/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicMenuBarUI
extends MenuBarUI {
    protected ChangeListener changeListener = this.createChangeListener();
    protected ContainerListener containerListener = this.createContainerListener();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    protected JMenuBar menuBar;
    private MouseInputListener mouseListener = new MouseInputHandler();

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicMenuBarUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
        this.menuBar.setOpaque(true);
    }

    protected void installKeyboardActions() {
        Object[] bindings = (Object[])SharedUIDefaults.get("MenuBar.windowBindings");
        ComponentInputMap inputMap = LookAndFeel.makeComponentInputMap(this.menuBar, bindings);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        SwingUtilities.replaceUIActionMap(this.menuBar, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("MenuBar.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        FocusAction action = new FocusAction();
        am.put(action.getValue("Name"), action);
        return am;
    }

    protected void installListeners() {
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
        this.menuBar.addMouseListener(this.mouseListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuBar = (JMenuBar)c;
        this.menuBar.setLayout(new BoxLayout(this.menuBar, 0));
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void uninstallDefaults() {
        this.menuBar.setBackground(null);
        this.menuBar.setBorder(null);
        this.menuBar.setFont(null);
        this.menuBar.setForeground(null);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        this.menuBar.removeMouseListener(this.mouseListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent event) {
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            BasicMenuBarUI.this.menuBar.revalidate();
            BasicMenuBarUI.this.menuBar.repaint();
        }

        public void componentRemoved(ContainerEvent e) {
            BasicMenuBarUI.this.menuBar.revalidate();
            BasicMenuBarUI.this.menuBar.repaint();
        }
    }

    private static class FocusAction
    extends AbstractAction {
        FocusAction() {
            super("takeFocus");
        }

        public void actionPerformed(ActionEvent event) {
            JMenuBar menuBar = (JMenuBar)event.getSource();
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            JMenu menu = menuBar.getMenu(0);
            if (menu != null) {
                MenuElement[] me = new MenuElement[]{menuBar, menu, menu.getPopupMenu()};
                defaultManager.setSelectedPath(me);
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            MenuElement[] me = BasicMenuBarUI.this.menuBar.getSubElements();
            int i = 0;
            while (i < me.length) {
                JMenu menu = BasicMenuBarUI.this.menuBar.getMenu(i);
                if (menu != null) {
                    menu.setSelected(false);
                }
                ++i;
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("borderPainted")) {
                BasicMenuBarUI.this.menuBar.repaint();
            }
            if (e.getPropertyName().equals("margin")) {
                BasicMenuBarUI.this.menuBar.repaint();
            }
        }
    }
}

