/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatePolicies
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.32");
    private final List<OID> policies;
    private final Map<OID, List<PolicyQualifierInfo>> policyQualifierInfos;

    public CertificatePolicies(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue pol = der.read();
        if (!pol.isConstructed()) {
            throw new IOException("malformed CertificatePolicies");
        }
        int len = 0;
        LinkedList<OID> policyList = new LinkedList<OID>();
        HashMap qualifierMap = new HashMap();
        while (len < pol.getLength()) {
            DERValue policyInfo = der.read();
            if (!policyInfo.isConstructed()) {
                throw new IOException("malformed PolicyInformation");
            }
            DERValue val = der.read();
            if (val.getTag() != 6) {
                throw new IOException("malformed CertPolicyId");
            }
            OID policyId = (OID)val.getValue();
            policyList.add(policyId);
            if (val.getEncodedLength() < policyInfo.getLength()) {
                DERValue qual = der.read();
                int len2 = 0;
                LinkedList<PolicyQualifierInfo> quals = new LinkedList<PolicyQualifierInfo>();
                while (len2 < qual.getLength()) {
                    val = der.read();
                    quals.add(new PolicyQualifierInfo(val.getEncoded()));
                    der.skip(val.getLength());
                    len2 += val.getEncodedLength();
                }
                qualifierMap.put(policyId, quals);
            }
            len += policyInfo.getEncodedLength();
        }
        this.policies = Collections.unmodifiableList(policyList);
        this.policyQualifierInfos = Collections.unmodifiableMap(qualifierMap);
    }

    public CertificatePolicies(List<OID> policies, Map<OID, List<PolicyQualifierInfo>> policyQualifierInfos) {
        Iterator<Object> it = policies.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof OID) continue;
            throw new IllegalArgumentException("policies must be OIDs");
        }
        it = policyQualifierInfos.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (!(e.getKey() instanceof OID) || !policies.contains(e.getKey())) {
                throw new IllegalArgumentException("policyQualifierInfos keys must be OIDs");
            }
            if (!(e.getValue() instanceof List)) {
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
            Iterator it2 = ((List)e.getValue()).iterator();
            while (it.hasNext()) {
                if (it2.next() instanceof PolicyQualifierInfo) continue;
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
        }
        this.policies = Collections.unmodifiableList(new ArrayList<OID>(policies));
        this.policyQualifierInfos = Collections.unmodifiableMap(new HashMap<OID, List<PolicyQualifierInfo>>(policyQualifierInfos));
    }

    public List<OID> getPolicies() {
        return this.policies;
    }

    public List<String> getPolicyStrings() {
        ArrayList<String> l = new ArrayList<String>(this.policies.size());
        for (OID oid : this.policies) {
            l.add(oid.toString());
        }
        return l;
    }

    public List<PolicyQualifierInfo> getPolicyQualifierInfos(OID oid) {
        return this.policyQualifierInfos.get(oid);
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList<DERValue> pol = new ArrayList<DERValue>(this.policies.size());
            Iterator<OID> it = this.policies.iterator();
            while (it.hasNext()) {
                OID policy = it.next();
                List<PolicyQualifierInfo> qualifiers = this.getPolicyQualifierInfos(policy);
                ArrayList<DERValue> l = new ArrayList<DERValue>(qualifiers == null ? 1 : 2);
                l.add(new DERValue(6, policy));
                if (qualifiers != null) {
                    ArrayList<DERValue> ll = new ArrayList<DERValue>(qualifiers.size());
                    Iterator<PolicyQualifierInfo> it2 = qualifiers.iterator();
                    while (it.hasNext()) {
                        PolicyQualifierInfo info = it2.next();
                        try {
                            ll.add(DERReader.read(info.getEncoded()));
                        }
                        catch (IOException iOException) {}
                    }
                    l.add(new DERValue(48, ll));
                }
                pol.add(new DERValue(48, l));
            }
            this.encoded = new DERValue(48, pol).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    @Override
    public String toString() {
        return String.valueOf(CertificatePolicies.class.getName()) + " [ policies=" + this.policies + " policyQualifierInfos=" + this.policyQualifierInfos + " ]";
    }
}

