/* UserListDialog.c generated by valac 0.30.0, the Vala compiler
 * generated from UserListDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <rest/rest-proxy-call.h>
#include <gio/gio.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <pango/pango.h>


#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_LIST_DIALOG (user_list_dialog_get_type ())
#define USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_DIALOG, UserListDialog))
#define USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_DIALOG, UserListDialogClass))
#define IS_USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_DIALOG))
#define IS_USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_DIALOG))
#define USER_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_DIALOG, UserListDialogClass))

typedef struct _UserListDialog UserListDialog;
typedef struct _UserListDialogClass UserListDialogClass;
typedef struct _UserListDialogPrivate UserListDialogPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LIST_USER_ENTRY (list_user_entry_get_type ())
#define LIST_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_USER_ENTRY, ListUserEntry))
#define LIST_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_USER_ENTRY, ListUserEntryClass))
#define IS_LIST_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_USER_ENTRY))
#define IS_LIST_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_USER_ENTRY))
#define LIST_USER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_USER_ENTRY, ListUserEntryClass))

typedef struct _ListUserEntry ListUserEntry;
typedef struct _ListUserEntryClass ListUserEntryClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;
typedef struct _Block79Data Block79Data;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _ListUserEntryPrivate ListUserEntryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block80Data Block80Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block81Data Block81Data;
typedef struct _Block82Data Block82Data;

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
	guint n_members;
};

struct _UserListDialog {
	GtkDialog parent_instance;
	UserListDialogPrivate * priv;
};

struct _UserListDialogClass {
	GtkDialogClass parent_class;
};

struct _UserListDialogPrivate {
	Account* account;
	MainWindow* main_window;
	GtkListBox* list_list_box;
	GtkLabel* placeholder_label;
	gint64 user_id;
};

struct _Block79Data {
	int _ref_count_;
	UserListDialog* self;
	ListsPage* lists_page;
	RestProxyCall* call;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ListUserEntry {
	GtkListBoxRow parent_instance;
	ListUserEntryPrivate * priv;
	gint64 id;
	gboolean changed;
};

struct _ListUserEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block80Data {
	int _ref_count_;
	UserListDialog* self;
	gint64 id;
};

struct _Block81Data {
	int _ref_count_;
	UserListDialog* self;
	RestProxyCall* call;
};

struct _Block82Data {
	int _ref_count_;
	UserListDialog* self;
	RestProxyCall* call;
};

struct _ListUserEntryPrivate {
	GtkCheckButton* added_checkbox;
};


static gpointer user_list_dialog_parent_class = NULL;
static gpointer list_user_entry_parent_class = NULL;

GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
GType user_list_dialog_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define USER_LIST_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LIST_DIALOG, UserListDialogPrivate))
enum  {
	USER_LIST_DIALOG_DUMMY_PROPERTY
};
UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id);
UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id);
static void __lambda175_ (UserListDialog* self, GtkListBoxRow* row);
GType list_user_entry_get_type (void) G_GNUC_CONST;
void list_user_entry_toggle (ListUserEntry* self);
static void ___lambda175__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void user_list_dialog_load_lists (UserListDialog* self);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType lists_page_get_type (void) G_GNUC_CONST;
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
GType bundle_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType page_get_type (void) G_GNUC_CONST;
void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1);
static void __lambda177_ (Block79Data* _data79_, GObject* obj, GAsyncResult* res);
ListUserEntry* list_user_entry_new (const gchar* list_name, const gchar* description);
ListUserEntry* list_user_entry_construct (GType object_type, const gchar* list_name, const gchar* description);
void list_user_entry_disable (ListUserEntry* self);
static void _vala_TwitterList_array_free (TwitterList* array, gint array_length);
static void ___lambda177__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
OAuthProxy* account_get_proxy (Account* self);
static void __lambda178_ (Block79Data* _data79_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void __lambda179_ (UserListDialog* self, JsonArray* arr, guint index, JsonNode* node);
static Block80Data* block80_data_ref (Block80Data* _data80_);
static void block80_data_unref (void * _userdata_);
static void __lambda180_ (Block80Data* _data80_, GtkWidget* w);
void list_user_entry_check (ListUserEntry* self);
void list_user_entry_enable (ListUserEntry* self);
static void ___lambda180__gtk_callback (GtkWidget* widget, gpointer self);
static void ___lambda179__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda178__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void user_list_dialog_real_response (GtkDialog* base, gint response_id);
gboolean list_user_entry_get_active (ListUserEntry* self);
static void user_list_dialog_add_user (UserListDialog* self, gint64 list_id);
static void user_list_dialog_remove_user (UserListDialog* self, gint64 list_id);
static Block81Data* block81_data_ref (Block81Data* _data81_);
static void block81_data_unref (void * _userdata_);
static void __lambda181_ (Block81Data* _data81_, GObject* o, GAsyncResult* res);
static void ___lambda181__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
static void __lambda182_ (Block82Data* _data82_, GObject* o, GAsyncResult* res);
static void ___lambda182__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void user_list_dialog_finalize (GObject* obj);
#define LIST_USER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_USER_ENTRY, ListUserEntryPrivate))
enum  {
	LIST_USER_ENTRY_DUMMY_PROPERTY,
	LIST_USER_ENTRY_ACTIVE
};
static void __lambda176_ (ListUserEntry* self);
static void ___lambda176__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void list_user_entry_finalize (GObject* obj);
static void _vala_list_user_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


void twitter_list_copy (const TwitterList* self, TwitterList* dest) {
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
	_tmp3_ = (*self).description;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp4_;
	_tmp5_ = (*self).mode;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).mode);
	(*dest).mode = _tmp6_;
	_tmp7_ = (*self).n_members;
	(*dest).n_members = _tmp7_;
}


void twitter_list_destroy (TwitterList* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mode);
}


TwitterList* twitter_list_dup (const TwitterList* self) {
	TwitterList* dup;
	dup = g_new0 (TwitterList, 1);
	twitter_list_copy (self, dup);
	return dup;
}


void twitter_list_free (TwitterList* self) {
	twitter_list_destroy (self);
	g_free (self);
}


GType twitter_list_get_type (void) {
	static volatile gsize twitter_list_type_id__volatile = 0;
	if (g_once_init_enter (&twitter_list_type_id__volatile)) {
		GType twitter_list_type_id;
		twitter_list_type_id = g_boxed_type_register_static ("TwitterList", (GBoxedCopyFunc) twitter_list_dup, (GBoxedFreeFunc) twitter_list_free);
		g_once_init_leave (&twitter_list_type_id__volatile, twitter_list_type_id);
	}
	return twitter_list_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda175_ (UserListDialog* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_USER_ENTRY)) {
		g_warning ("UserListDialog.vala:59: Row != ListUserEntry!");
		return;
	}
	_tmp1_ = row;
	list_user_entry_toggle (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_USER_ENTRY, ListUserEntry));
}


static void ___lambda175__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda175_ ((UserListDialog*) self, row);
}


UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id) {
	UserListDialog * self = NULL;
	gint _tmp0_ = 0;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	Account* _tmp7_ = NULL;
	MainWindow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkBox* content_box = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkListBox* _tmp14_ = NULL;
	GtkListBox* _tmp15_ = NULL;
	GtkListBox* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkStyleContext* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkListBox* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	g_return_val_if_fail (IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-dialogs-use-header", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	self = (UserListDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
	_tmp4_ = _ ("Add to or Remove User From List");
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp4_);
	_tmp5_ = parent;
	self->priv->main_window = _tmp5_;
	_tmp6_ = user_id;
	self->priv->user_id = _tmp6_;
	_tmp7_ = account;
	self->priv->account = _tmp7_;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp8_ = parent;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 250, 200);
	_tmp9_ = _ ("Cancel");
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), _tmp9_, (gint) GTK_RESPONSE_CANCEL);
	_tmp10_ = _ ("Save");
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), _tmp10_, (gint) GTK_RESPONSE_OK);
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
	_tmp11_ = (GtkBox*) gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp12_ = _g_object_ref0 (_tmp11_);
	content_box = _tmp12_;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (content_box, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp13_);
	scroller = _tmp13_;
	_tmp14_ = self->priv->list_list_box;
	gtk_list_box_set_selection_mode (_tmp14_, GTK_SELECTION_NONE);
	_tmp15_ = self->priv->list_list_box;
	g_signal_connect_object (_tmp15_, "row-activated", (GCallback) ___lambda175__gtk_list_box_row_activated, self, 0);
	_tmp16_ = self->priv->list_list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	gtk_box_pack_start (content_box, G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp17_ = self->priv->placeholder_label;
	_tmp18_ = _ ("You have no lists.");
	gtk_label_set_label (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->placeholder_label;
	_tmp20_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp20_, "dim-label");
	_tmp21_ = self->priv->placeholder_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
	_tmp22_ = self->priv->list_list_box;
	_tmp23_ = self->priv->placeholder_label;
	gtk_list_box_set_placeholder (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (scroller);
	_g_object_unref0 (content_box);
	return self;
}


UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id) {
	return user_list_dialog_construct (TYPE_USER_LIST_DIALOG, parent, account, user_id);
}


static Block79Data* block79_data_ref (Block79Data* _data79_) {
	g_atomic_int_inc (&_data79_->_ref_count_);
	return _data79_;
}


static void block79_data_unref (void * _userdata_) {
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
		UserListDialog* self;
		self = _data79_->self;
		_g_object_unref0 (_data79_->call);
		_g_object_unref0 (_data79_->lists_page);
		_g_object_unref0 (self);
		g_slice_free (Block79Data, _data79_);
	}
}


static void _vala_TwitterList_array_free (TwitterList* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda177_ (Block79Data* _data79_, GObject* obj, GAsyncResult* res) {
	UserListDialog* self;
	TwitterList* lists = NULL;
	GAsyncResult* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	TwitterList* _tmp2_ = NULL;
	gint lists_length1 = 0;
	gint _lists_size_ = 0;
	TwitterList* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	self = _data79_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp2_ = lists_page_get_user_lists_finish (_data79_->lists_page, _tmp0_, &_tmp1_);
	lists = _tmp2_;
	lists_length1 = _tmp1_;
	_lists_size_ = lists_length1;
	_tmp3_ = lists;
	_tmp3__length1 = lists_length1;
	{
		TwitterList* list_collection = NULL;
		gint list_collection_length1 = 0;
		gint _list_collection_size_ = 0;
		gint list_it = 0;
		list_collection = _tmp3_;
		list_collection_length1 = _tmp3__length1;
		for (list_it = 0; list_it < _tmp3__length1; list_it = list_it + 1) {
			TwitterList _tmp4_ = {0};
			TwitterList list = {0};
			twitter_list_copy (&list_collection[list_it], &_tmp4_);
			list = _tmp4_;
			{
				ListUserEntry* l = NULL;
				TwitterList _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				TwitterList _tmp7_ = {0};
				const gchar* _tmp8_ = NULL;
				ListUserEntry* _tmp9_ = NULL;
				ListUserEntry* _tmp10_ = NULL;
				TwitterList _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				TwitterList _tmp13_ = {0};
				guint _tmp14_ = 0U;
				GtkListBox* _tmp16_ = NULL;
				ListUserEntry* _tmp17_ = NULL;
				_tmp5_ = list;
				_tmp6_ = _tmp5_.name;
				_tmp7_ = list;
				_tmp8_ = _tmp7_.description;
				_tmp9_ = list_user_entry_new (_tmp6_, _tmp8_);
				g_object_ref_sink (_tmp9_);
				l = _tmp9_;
				_tmp10_ = l;
				_tmp11_ = list;
				_tmp12_ = _tmp11_.id;
				_tmp10_->id = _tmp12_;
				_tmp13_ = list;
				_tmp14_ = _tmp13_.n_members;
				if (_tmp14_ >= ((guint) 500)) {
					ListUserEntry* _tmp15_ = NULL;
					_tmp15_ = l;
					list_user_entry_disable (_tmp15_);
				}
				_tmp16_ = self->priv->list_list_box;
				_tmp17_ = l;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (l);
				twitter_list_destroy (&list);
			}
		}
	}
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	lists = (_vala_TwitterList_array_free (lists, lists_length1), NULL);
}


static void ___lambda177__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda177_ (self, source_object, res);
	block79_data_unref (self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static Block80Data* block80_data_ref (Block80Data* _data80_) {
	g_atomic_int_inc (&_data80_->_ref_count_);
	return _data80_;
}


static void block80_data_unref (void * _userdata_) {
	Block80Data* _data80_;
	_data80_ = (Block80Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data80_->_ref_count_)) {
		UserListDialog* self;
		self = _data80_->self;
		_g_object_unref0 (self);
		g_slice_free (Block80Data, _data80_);
	}
}


static void __lambda180_ (Block80Data* _data80_, GtkWidget* w) {
	UserListDialog* self;
	ListUserEntry* lue = NULL;
	GtkWidget* _tmp0_ = NULL;
	ListUserEntry* _tmp1_ = NULL;
	ListUserEntry* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	self = _data80_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIST_USER_ENTRY, ListUserEntry));
	lue = _tmp1_;
	_tmp2_ = lue;
	_tmp3_ = _tmp2_->id;
	if (_tmp3_ == _data80_->id) {
		ListUserEntry* _tmp4_ = NULL;
		ListUserEntry* _tmp5_ = NULL;
		_tmp4_ = lue;
		list_user_entry_check (_tmp4_);
		_tmp5_ = lue;
		list_user_entry_enable (_tmp5_);
	}
	_g_object_unref0 (lue);
}


static void ___lambda180__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda180_ (self, widget);
}


static void __lambda179_ (UserListDialog* self, JsonArray* arr, guint index, JsonNode* node) {
	Block80Data* _data80_;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	GtkListBox* _tmp3_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_data80_ = g_slice_new0 (Block80Data);
	_data80_->_ref_count_ = 1;
	_data80_->self = g_object_ref (self);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = json_object_get_int_member (_tmp1_, "id");
	_data80_->id = _tmp2_;
	_tmp3_ = self->priv->list_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), ___lambda180__gtk_callback, _data80_);
	block80_data_unref (_data80_);
	_data80_ = NULL;
}


static void ___lambda179__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda179_ ((UserListDialog*) self, array, index_, element_node);
}


static void __lambda178_ (Block79Data* _data79_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonObject* root = NULL;
	JsonParser* _tmp9_ = NULL;
	JsonNode* _tmp10_ = NULL;
	JsonObject* _tmp11_ = NULL;
	JsonObject* _tmp12_ = NULL;
	JsonArray* list_arr = NULL;
	JsonObject* _tmp13_ = NULL;
	JsonArray* _tmp14_ = NULL;
	JsonArray* _tmp15_ = NULL;
	JsonArray* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data79_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data79_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch103_g_error;
		}
	}
	goto __finally103;
	__catch103_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data79_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 98, "UserListDialog.vala");
		_g_error_free0 (e);
		return;
	}
	__finally103:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonParser* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = parser;
		_tmp6_ = rest_proxy_call_get_payload (_data79_->call);
		json_parser_load_from_data (_tmp5_, _tmp6_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch104_g_error;
		}
	}
	goto __finally104;
	__catch104_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("UserListDialog.vala:105: %s", _tmp8_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally104:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = parser;
	_tmp10_ = json_parser_get_root (_tmp9_);
	_tmp11_ = json_node_get_object (_tmp10_);
	_tmp12_ = _json_object_ref0 (_tmp11_);
	root = _tmp12_;
	_tmp13_ = root;
	_tmp14_ = json_object_get_array_member (_tmp13_, "lists");
	_tmp15_ = _json_array_ref0 (_tmp14_);
	list_arr = _tmp15_;
	_tmp16_ = list_arr;
	json_array_foreach_element (_tmp16_, ___lambda179__json_array_foreach, self);
	_json_array_unref0 (list_arr);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


static void ___lambda178__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda178_ (self, source_object, res);
	block79_data_unref (self);
}


void user_list_dialog_load_lists (UserListDialog* self) {
	Block79Data* _data79_;
	MainWindow* _tmp0_ = NULL;
	IPage* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data79_ = g_slice_new0 (Block79Data);
	_data79_->_ref_count_ = 1;
	_data79_->self = g_object_ref (self);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_page (_tmp0_, (gint) PAGE_LISTS);
	_data79_->lists_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LISTS_PAGE, ListsPage);
	lists_page_get_user_lists (_data79_->lists_page, ___lambda177__gasync_ready_callback, block79_data_ref (_data79_));
	_tmp2_ = self->priv->account;
	_tmp3_ = account_get_proxy (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	_data79_->call = _tmp5_;
	rest_proxy_call_set_function (_data79_->call, "1.1/lists/memberships.json");
	_tmp6_ = self->priv->user_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (_data79_->call, "user_id", _tmp8_);
	_g_free0 (_tmp8_);
	rest_proxy_call_add_param (_data79_->call, "filter_to_owned_lists", "true");
	rest_proxy_call_invoke_async (_data79_->call, NULL, ___lambda178__gasync_ready_callback, block79_data_ref (_data79_));
	block79_data_unref (_data79_);
	_data79_ = NULL;
}


static void user_list_dialog_real_response (GtkDialog* base, gint response_id) {
	UserListDialog * self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_LIST_DIALOG, UserListDialog);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CANCEL)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gint _tmp1_ = 0;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
			GList* list_entries = NULL;
			GtkListBox* _tmp2_ = NULL;
			GList* _tmp3_ = NULL;
			GList* _tmp4_ = NULL;
			_tmp2_ = self->priv->list_list_box;
			_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
			list_entries = _tmp3_;
			_tmp4_ = list_entries;
			{
				GList* w_collection = NULL;
				GList* w_it = NULL;
				w_collection = _tmp4_;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWidget* _tmp5_ = NULL;
					GtkWidget* w = NULL;
					_tmp5_ = _g_object_ref0 ((GtkWidget*) w_it->data);
					w = _tmp5_;
					{
						ListUserEntry* lue = NULL;
						GtkWidget* _tmp6_ = NULL;
						ListUserEntry* _tmp7_ = NULL;
						ListUserEntry* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						_tmp6_ = w;
						_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIST_USER_ENTRY, ListUserEntry));
						lue = _tmp7_;
						_tmp8_ = lue;
						_tmp9_ = _tmp8_->changed;
						if (_tmp9_) {
							ListUserEntry* _tmp10_ = NULL;
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							g_debug ("UserListDialog.vala:132: VALUE CHANGED");
							_tmp10_ = lue;
							_tmp11_ = list_user_entry_get_active (_tmp10_);
							_tmp12_ = _tmp11_;
							if (_tmp12_) {
								ListUserEntry* _tmp13_ = NULL;
								gint64 _tmp14_ = 0LL;
								_tmp13_ = lue;
								_tmp14_ = _tmp13_->id;
								user_list_dialog_add_user (self, _tmp14_);
							} else {
								ListUserEntry* _tmp15_ = NULL;
								gint64 _tmp16_ = 0LL;
								_tmp15_ = lue;
								_tmp16_ = _tmp15_->id;
								user_list_dialog_remove_user (self, _tmp16_);
							}
						}
						_g_object_unref0 (lue);
						_g_object_unref0 (w);
					}
				}
			}
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_g_list_free0 (list_entries);
		}
	}
}


static Block81Data* block81_data_ref (Block81Data* _data81_) {
	g_atomic_int_inc (&_data81_->_ref_count_);
	return _data81_;
}


static void block81_data_unref (void * _userdata_) {
	Block81Data* _data81_;
	_data81_ = (Block81Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data81_->_ref_count_)) {
		UserListDialog* self;
		self = _data81_->self;
		_g_object_unref0 (_data81_->call);
		_g_object_unref0 (self);
		g_slice_free (Block81Data, _data81_);
	}
}


static void __lambda181_ (Block81Data* _data81_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	GError * _inner_error_ = NULL;
	self = _data81_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data81_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch105_g_error;
		}
	}
	goto __finally105;
	__catch105_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data81_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 157, "UserListDialog.vala");
		_g_error_free0 (e);
	}
	__finally105:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda181__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda181_ (self, source_object, res);
	block81_data_unref (self);
}


static void user_list_dialog_add_user (UserListDialog* self, gint64 list_id) {
	Block81Data* _data81_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data81_ = g_slice_new0 (Block81Data);
	_data81_->_ref_count_ = 1;
	_data81_->self = g_object_ref (self);
	_tmp0_ = self->priv->account;
	_tmp1_ = account_get_proxy (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	_data81_->call = _tmp3_;
	rest_proxy_call_set_function (_data81_->call, "1.1/lists/members/create.json");
	rest_proxy_call_set_method (_data81_->call, "POST");
	_tmp4_ = list_id;
	_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
	_tmp6_ = _tmp5_;
	rest_proxy_call_add_param (_data81_->call, "list_id", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->user_id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	rest_proxy_call_add_param (_data81_->call, "user_id", _tmp9_);
	_g_free0 (_tmp9_);
	rest_proxy_call_invoke_async (_data81_->call, NULL, ___lambda181__gasync_ready_callback, block81_data_ref (_data81_));
	block81_data_unref (_data81_);
	_data81_ = NULL;
}


static Block82Data* block82_data_ref (Block82Data* _data82_) {
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}


static void block82_data_unref (void * _userdata_) {
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		UserListDialog* self;
		self = _data82_->self;
		_g_object_unref0 (_data82_->call);
		_g_object_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}


static void __lambda182_ (Block82Data* _data82_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	GError * _inner_error_ = NULL;
	self = _data82_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data82_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch106_g_error;
		}
	}
	goto __finally106;
	__catch106_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data82_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 173, "UserListDialog.vala");
		_g_error_free0 (e);
	}
	__finally106:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda182__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda182_ (self, source_object, res);
	block82_data_unref (self);
}


static void user_list_dialog_remove_user (UserListDialog* self, gint64 list_id) {
	Block82Data* _data82_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data82_ = g_slice_new0 (Block82Data);
	_data82_->_ref_count_ = 1;
	_data82_->self = g_object_ref (self);
	_tmp0_ = self->priv->account;
	_tmp1_ = account_get_proxy (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	_data82_->call = _tmp3_;
	rest_proxy_call_set_function (_data82_->call, "1.1/lists/members/destroy.json");
	rest_proxy_call_set_method (_data82_->call, "POST");
	_tmp4_ = list_id;
	_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
	_tmp6_ = _tmp5_;
	rest_proxy_call_add_param (_data82_->call, "list_id", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->user_id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	rest_proxy_call_add_param (_data82_->call, "user_id", _tmp9_);
	_g_free0 (_tmp9_);
	rest_proxy_call_invoke_async (_data82_->call, NULL, ___lambda182__gasync_ready_callback, block82_data_ref (_data82_));
	block82_data_unref (_data82_);
	_data82_ = NULL;
}


static void user_list_dialog_class_init (UserListDialogClass * klass) {
	user_list_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListDialogPrivate));
	((GtkDialogClass *) klass)->response = user_list_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = user_list_dialog_finalize;
}


static void user_list_dialog_instance_init (UserListDialog * self) {
	GtkListBox* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	self->priv = USER_LIST_DIALOG_GET_PRIVATE (self);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->list_list_box = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	self->priv->placeholder_label = _tmp1_;
}


static void user_list_dialog_finalize (GObject* obj) {
	UserListDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LIST_DIALOG, UserListDialog);
	_g_object_unref0 (self->priv->list_list_box);
	_g_object_unref0 (self->priv->placeholder_label);
	G_OBJECT_CLASS (user_list_dialog_parent_class)->finalize (obj);
}


GType user_list_dialog_get_type (void) {
	static volatile gsize user_list_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&user_list_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_list_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserListDialog), 0, (GInstanceInitFunc) user_list_dialog_instance_init, NULL };
		GType user_list_dialog_type_id;
		user_list_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "UserListDialog", &g_define_type_info, 0);
		g_once_init_leave (&user_list_dialog_type_id__volatile, user_list_dialog_type_id);
	}
	return user_list_dialog_type_id__volatile;
}


static void __lambda176_ (ListUserEntry* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->changed;
	self->changed = !_tmp0_;
}


static void ___lambda176__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda176_ ((ListUserEntry*) self);
}


ListUserEntry* list_user_entry_construct (GType object_type, const gchar* list_name, const gchar* description) {
	ListUserEntry * self = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	GtkCheckButton* _tmp2_ = NULL;
	GtkCheckButton* _tmp3_ = NULL;
	GtkBox* box2 = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* desc_label = NULL;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	g_return_val_if_fail (list_name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (ListUserEntry*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget), "margin", 6, NULL);
	_tmp1_ = self->priv->added_checkbox;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp2_ = self->priv->added_checkbox;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp3_ = self->priv->added_checkbox;
	gtk_box_pack_start (box, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp4_);
	box2 = _tmp4_;
	_tmp5_ = list_name;
	_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	label = _tmp11_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_box_pack_start (box2, G_TYPE_CHECK_INSTANCE_CAST (label, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp12_ = description;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	desc_label = _tmp13_;
	_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp14_, "dim-label");
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_label_set_ellipsize (desc_label, PANGO_ELLIPSIZE_END);
	gtk_box_pack_start (box2, G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	gtk_box_pack_start (box, G_TYPE_CHECK_INSTANCE_CAST (box2, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->added_checkbox;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda176__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (label);
	_g_object_unref0 (box2);
	_g_object_unref0 (box);
	return self;
}


ListUserEntry* list_user_entry_new (const gchar* list_name, const gchar* description) {
	return list_user_entry_construct (TYPE_LIST_USER_ENTRY, list_name, description);
}


void list_user_entry_check (ListUserEntry* self) {
	GtkCheckButton* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	self->changed = FALSE;
}


void list_user_entry_toggle (ListUserEntry* self) {
	GtkCheckButton* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	_tmp1_ = self->priv->added_checkbox;
	_tmp2_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), !_tmp3_);
}


void list_user_entry_disable (ListUserEntry* self) {
	GtkCheckButton* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
}


void list_user_entry_enable (ListUserEntry* self) {
	GtkCheckButton* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


gboolean list_user_entry_get_active (ListUserEntry* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_LIST_USER_ENTRY (self), FALSE);
	_tmp0_ = self->priv->added_checkbox;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void list_user_entry_class_init (ListUserEntryClass * klass) {
	list_user_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListUserEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_user_entry_get_property;
	G_OBJECT_CLASS (klass)->finalize = list_user_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_USER_ENTRY_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void list_user_entry_instance_init (ListUserEntry * self) {
	GtkCheckButton* _tmp0_ = NULL;
	self->priv = LIST_USER_ENTRY_GET_PRIVATE (self);
	self->changed = FALSE;
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->added_checkbox = _tmp0_;
}


static void list_user_entry_finalize (GObject* obj) {
	ListUserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_USER_ENTRY, ListUserEntry);
	_g_object_unref0 (self->priv->added_checkbox);
	G_OBJECT_CLASS (list_user_entry_parent_class)->finalize (obj);
}


GType list_user_entry_get_type (void) {
	static volatile gsize list_user_entry_type_id__volatile = 0;
	if (g_once_init_enter (&list_user_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListUserEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_user_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListUserEntry), 0, (GInstanceInitFunc) list_user_entry_instance_init, NULL };
		GType list_user_entry_type_id;
		list_user_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ListUserEntry", &g_define_type_info, 0);
		g_once_init_leave (&list_user_entry_type_id__volatile, list_user_entry_type_id);
	}
	return list_user_entry_type_id__volatile;
}


static void _vala_list_user_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListUserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_USER_ENTRY, ListUserEntry);
	switch (property_id) {
		case LIST_USER_ENTRY_ACTIVE:
		g_value_set_boolean (value, list_user_entry_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



