/* SettingsDialog.c generated by valac 0.30.0, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo.h>


#define TYPE_SETTINGS_DIALOG (settings_dialog_get_type ())
#define SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DIALOG, SettingsDialog))
#define SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DIALOG, SettingsDialogClass))
#define IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DIALOG))
#define IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DIALOG))
#define SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DIALOG, SettingsDialogClass))

typedef struct _SettingsDialog SettingsDialog;
typedef struct _SettingsDialogClass SettingsDialogClass;
typedef struct _SettingsDialogPrivate SettingsDialogPrivate;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _TweetPrivate TweetPrivate;
#define _mini_tweet_unref0(var) ((var == NULL) ? NULL : (var = (mini_tweet_unref (var), NULL)))
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;

#define TYPE_SNIPPET_LIST_ENTRY (snippet_list_entry_get_type ())
#define SNIPPET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry))
#define SNIPPET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntryClass))
#define IS_SNIPPET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_LIST_ENTRY))
#define IS_SNIPPET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_LIST_ENTRY))
#define SNIPPET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntryClass))

typedef struct _SnippetListEntry SnippetListEntry;
typedef struct _SnippetListEntryClass SnippetListEntryClass;

#define TYPE_MODIFY_SNIPPET_DIALOG (modify_snippet_dialog_get_type ())
#define MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialog))
#define MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))
#define IS_MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_SNIPPET_DIALOG))
#define IS_MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_SNIPPET_DIALOG))
#define MODIFY_SNIPPET_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))

typedef struct _ModifySnippetDialog ModifySnippetDialog;
typedef struct _ModifySnippetDialogClass ModifySnippetDialogClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SettingsDialog {
	GtkWindow parent_instance;
	SettingsDialogPrivate * priv;
};

struct _SettingsDialogClass {
	GtkWindowClass parent_class;
};

struct _SettingsDialogPrivate {
	GtkSwitch* on_new_mentions_switch;
	GtkSwitch* round_avatar_switch;
	GtkSwitch* on_new_dms_switch;
	GtkComboBoxText* on_new_tweets_combobox;
	GtkSwitch* auto_scroll_on_new_tweets_switch;
	GtkSpinButton* max_media_size_spin_button;
	GtkStack* main_stack;
	GtkSwitch* double_click_activation_switch;
	GtkListBox* sample_tweet_list;
	GtkSwitch* remove_trailing_hashtags_switch;
	GtkSwitch* remove_media_links_switch;
	GtkListBox* snippet_list_box;
	TweetListEntry* sample_tweet_entry;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;

typedef void (*SnippetManagerSnippetQueryFunc) (const gchar* key, const gchar* value, void* user_data);

static gpointer settings_dialog_parent_class = NULL;
extern SnippetManager* corebird_snippet_manager;

GType settings_dialog_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS_DIALOG, SettingsDialogPrivate))
enum  {
	SETTINGS_DIALOG_DUMMY_PROPERTY
};
GType corebird_get_type (void) G_GNUC_CONST;
SettingsDialog* settings_dialog_new (Corebird* application);
SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application);
GSettings* settings_get (void);
static void __lambda221_ (SettingsDialog* self);
static void ___lambda221__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType tweet_get_type (void) G_GNUC_CONST;
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
MiniTweet* mini_tweet_new (void);
MiniTweet* mini_tweet_construct (GType object_type);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
void tweet_set_avatar (Tweet* self, cairo_surface_t* value);
static void _vala_TextEntity_array_free (TextEntity* array, gint array_length);
void tweet_utils_sort_entities (TextEntity** entities, int* entities_length1);
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* main_window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* main_window, Account* account);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
GType transform_flags_get_type (void) G_GNUC_CONST;
TransformFlags settings_get_text_transform_flags (void);
GType snippet_manager_get_type (void) G_GNUC_CONST;
void snippet_manager_query_snippets (SnippetManager* self, SnippetManagerSnippetQueryFunc func, void* func_target);
static void __lambda222_ (SettingsDialog* self, const gchar* key, const gchar* value);
GType snippet_list_entry_get_type (void) G_GNUC_CONST;
SnippetListEntry* snippet_list_entry_new (const gchar* key, const gchar* value);
SnippetListEntry* snippet_list_entry_construct (GType object_type, const gchar* key, const gchar* value);
static void ___lambda222__snippet_manager_snippet_query_func (const gchar* key, const gchar* value, gpointer self);
static void settings_dialog_add_accels (SettingsDialog* self);
static void settings_dialog_load_geometry (SettingsDialog* self);
static gboolean settings_dialog_window_destroy_cb (SettingsDialog* self);
static void settings_dialog_save_geometry (SettingsDialog* self);
static gboolean _settings_dialog_window_destroy_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void settings_dialog_snippet_entry_activated_cb (SettingsDialog* self, GtkListBoxRow* row);
GType modify_snippet_dialog_get_type (void) G_GNUC_CONST;
const gchar* snippet_list_entry_get_key (SnippetListEntry* self);
const gchar* snippet_list_entry_get_value (SnippetListEntry* self);
ModifySnippetDialog* modify_snippet_dialog_new (const gchar* key, const gchar* value);
ModifySnippetDialog* modify_snippet_dialog_construct (GType object_type, const gchar* key, const gchar* value);
static void settings_dialog_snippet_updated_func (SettingsDialog* self, const gchar* old_key, const gchar* key, const gchar* value);
static void _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated (ModifySnippetDialog* _sender, const gchar* old_key, const gchar* key, const gchar* value, gpointer self);
static void _settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void settings_dialog_add_snippet_button_clicked_cb (SettingsDialog* self);
static void _settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void snippet_list_entry_reveal (SnippetListEntry* self);
void snippet_list_entry_set_key (SnippetListEntry* self, const gchar* value);
void snippet_list_entry_set_value (SnippetListEntry* self, const gchar* value);
static gboolean __lambda224_ (SettingsDialog* self);
static gboolean ___lambda224__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda225_ (SettingsDialog* self);
static gboolean ___lambda225__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda226_ (SettingsDialog* self);
static gboolean ___lambda226__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda227_ (SettingsDialog* self);
static gboolean ___lambda227__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda228_ (SettingsDialog* self);
static gboolean ___lambda228__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void settings_dialog_remove_trailing_hashtags_cb (SettingsDialog* self);
void settings_add_text_transform_flag (TransformFlags flag);
void settings_remove_text_transform_flag (TransformFlags flag);
static void _settings_dialog_remove_trailing_hashtags_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void settings_dialog_remove_media_links_cb (SettingsDialog* self);
static void _settings_dialog_remove_media_links_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void settings_dialog_finalize (GObject* obj);


static void __lambda221_ (SettingsDialog* self) {
	GtkComboBoxText* _tmp0_ = NULL;
	GtkSwitch* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->on_new_tweets_combobox;
	_tmp1_ = self->priv->auto_scroll_on_new_tweets_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !_tmp3_);
}


static void ___lambda221__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda221_ ((SettingsDialog*) self);
}


static void _vala_TextEntity_array_free (TextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			text_entity_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda222_ (SettingsDialog* self, const gchar* key, const gchar* value) {
	SnippetListEntry* e = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SnippetListEntry* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = key;
	_tmp1_ = value;
	_tmp2_ = snippet_list_entry_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	e = _tmp2_;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (e, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->snippet_list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (e, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (e);
}


static void ___lambda222__snippet_manager_snippet_query_func (const gchar* key, const gchar* value, gpointer self) {
	__lambda222_ ((SettingsDialog*) self, key, value);
}


SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application) {
	SettingsDialog * self = NULL;
	Corebird* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkSwitch* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GtkComboBoxText* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GtkSwitch* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	GtkSwitch* _tmp12_ = NULL;
	GtkSwitch* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	GtkSwitch* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	GtkSpinButton* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	GtkSwitch* _tmp22_ = NULL;
	Tweet* sample_tweet = NULL;
	Tweet* _tmp23_ = NULL;
	Tweet* _tmp24_ = NULL;
	MiniTweet* _tmp25_ = NULL;
	Tweet* _tmp26_ = NULL;
	MiniTweet* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	UserIdentity _tmp30_ = {0};
	UserIdentity _tmp31_ = {0};
	gchar* sample_text = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GdkPixbuf* a = NULL;
	Tweet* _tmp44_ = NULL;
	MiniTweet* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	Tweet* _tmp85_ = NULL;
	MiniTweet* _tmp86_ = NULL;
	Tweet* _tmp87_ = NULL;
	Tweet* _tmp88_ = NULL;
	Account* _tmp89_ = NULL;
	Account* _tmp90_ = NULL;
	TweetListEntry* _tmp91_ = NULL;
	TweetListEntry* _tmp92_ = NULL;
	TweetListEntry* _tmp93_ = NULL;
	TweetListEntry* _tmp94_ = NULL;
	GtkListBox* _tmp95_ = NULL;
	TweetListEntry* _tmp96_ = NULL;
	TransformFlags text_transform_flags = 0;
	TransformFlags _tmp97_ = 0;
	GtkSwitch* _tmp98_ = NULL;
	GtkSwitch* _tmp99_ = NULL;
	SnippetManager* _tmp100_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (application), NULL);
	self = (SettingsDialog*) g_object_new (object_type, NULL);
	_tmp0_ = application;
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->round_avatar_switch;
	g_settings_bind (_tmp2_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = settings_get ();
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->on_new_tweets_combobox;
	g_settings_bind (_tmp5_, "new-tweets-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp5_);
	_tmp7_ = settings_get ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->on_new_mentions_switch;
	g_settings_bind (_tmp8_, "new-mentions-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp8_);
	_tmp10_ = settings_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->on_new_dms_switch;
	g_settings_bind (_tmp11_, "new-dms-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->auto_scroll_on_new_tweets_switch;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G_TYPE_OBJECT, GObject), "notify::active", (GCallback) ___lambda221__g_object_notify, self, 0);
	_tmp14_ = settings_get ();
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->auto_scroll_on_new_tweets_switch;
	g_settings_bind (_tmp15_, "auto-scroll-on-new-tweets", G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp15_);
	_tmp17_ = settings_get ();
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->max_media_size_spin_button;
	g_settings_bind (_tmp18_, "max-media-size", G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, G_TYPE_OBJECT, GObject), "value", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp18_);
	_tmp20_ = settings_get ();
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->double_click_activation_switch;
	g_settings_bind (_tmp21_, "double-click-activation", G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp21_);
	_tmp23_ = tweet_new ();
	sample_tweet = _tmp23_;
	_tmp24_ = sample_tweet;
	_tmp25_ = mini_tweet_new ();
	_mini_tweet_unref0 (_tmp24_->source_tweet);
	_tmp24_->source_tweet = _tmp25_;
	_tmp26_ = sample_tweet;
	_tmp27_ = _tmp26_->source_tweet;
	_tmp28_ = g_strdup ("corebirdclient");
	_tmp29_ = g_strdup ("Corebird");
	memset (&_tmp30_, 0, sizeof (UserIdentity));
	_tmp30_.id = (gint64) 12;
	_g_free0 (_tmp30_.screen_name);
	_tmp30_.screen_name = _tmp28_;
	_g_free0 (_tmp30_.user_name);
	_tmp30_.user_name = _tmp29_;
	user_identity_destroy (&_tmp27_->author);
	_tmp27_->author = _tmp30_;
	_tmp31_ = _tmp27_->author;
	_tmp32_ = _ ("Hey, check out this new #Corebird version! \\ (•◡•) / #cool #newisalwa" \
"ysbetter");
	_tmp33_ = g_strdup (_tmp32_);
	sample_text = _tmp33_;
	a = NULL;
	{
		GdkPixbuf* _tmp34_ = NULL;
		GtkIconTheme* _tmp35_ = NULL;
		GdkPixbuf* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		Tweet* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
		cairo_surface_t* _tmp40_ = NULL;
		cairo_surface_t* _tmp41_ = NULL;
		_tmp35_ = gtk_icon_theme_get_default ();
		_tmp36_ = gtk_icon_theme_load_icon (_tmp35_, "corebird", 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
		_tmp34_ = _tmp36_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch101_g_error;
		}
		_tmp37_ = _tmp34_;
		_tmp34_ = NULL;
		_g_object_unref0 (a);
		a = _tmp37_;
		_tmp38_ = sample_tweet;
		_tmp39_ = a;
		_tmp40_ = gdk_cairo_surface_create_from_pixbuf (_tmp39_, 1, NULL);
		_tmp41_ = _tmp40_;
		tweet_set_avatar (_tmp38_, _tmp41_);
		_cairo_surface_destroy0 (_tmp41_);
		_g_object_unref0 (_tmp34_);
	}
	goto __finally101;
	__catch101_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("SettingsDialog.vala:88: %s", _tmp43_);
		_g_error_free0 (e);
	}
	__finally101:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (a);
		_g_free0 (sample_text);
		_g_object_unref0 (sample_tweet);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp44_ = sample_tweet;
	_tmp45_ = _tmp44_->source_tweet;
	_tmp46_ = sample_text;
	_tmp47_ = g_strdup (_tmp46_);
	_g_free0 (_tmp45_->text);
	_tmp45_->text = _tmp47_;
	{
		GRegex* regex = NULL;
		GRegex* _tmp48_ = NULL;
		GMatchInfo* match_info = NULL;
		gboolean matched = FALSE;
		GRegex* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		GMatchInfo* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		Tweet* _tmp54_ = NULL;
		MiniTweet* _tmp55_ = NULL;
		TextEntity* _tmp56_ = NULL;
		gint i = 0;
		_tmp48_ = g_regex_new ("#\\w+", 0, 0, &_inner_error_);
		regex = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch102_g_regex_error;
			}
			_g_object_unref0 (a);
			_g_free0 (sample_text);
			_g_object_unref0 (sample_tweet);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp49_ = regex;
		_tmp50_ = sample_text;
		_tmp52_ = g_regex_match (_tmp49_, _tmp50_, 0, &_tmp51_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp51_;
		matched = _tmp52_;
		_tmp53_ = matched;
		_vala_assert (_tmp53_, "matched");
		_tmp54_ = sample_tweet;
		_tmp55_ = _tmp54_->source_tweet;
		_tmp56_ = g_new0 (TextEntity, 3);
		_tmp55_->entities = (_vala_TextEntity_array_free (_tmp55_->entities, _tmp55_->entities_length1), NULL);
		_tmp55_->entities = _tmp56_;
		_tmp55_->entities_length1 = 3;
		i = 0;
		while (TRUE) {
			GMatchInfo* _tmp57_ = NULL;
			gboolean _tmp58_ = FALSE;
			GMatchInfo* _tmp59_ = NULL;
			gint _tmp60_ = 0;
			gint from = 0;
			gint to = 0;
			GMatchInfo* _tmp61_ = NULL;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			gchar* match = NULL;
			GMatchInfo* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			Tweet* _tmp66_ = NULL;
			MiniTweet* _tmp67_ = NULL;
			TextEntity* _tmp68_ = NULL;
			gint _tmp68__length1 = 0;
			gint _tmp69_ = 0;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			const gchar* _tmp73_ = NULL;
			gint _tmp74_ = 0;
			gint _tmp75_ = 0;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			TextEntity _tmp79_ = {0};
			TextEntity _tmp80_ = {0};
			GMatchInfo* _tmp81_ = NULL;
			gint _tmp82_ = 0;
			_tmp57_ = match_info;
			_tmp58_ = g_match_info_matches (_tmp57_);
			if (!_tmp58_) {
				break;
			}
			_tmp59_ = match_info;
			_tmp60_ = g_match_info_get_match_count (_tmp59_);
			_vala_assert (_tmp60_ == 1, "match_info.get_match_count () == 1");
			_tmp61_ = match_info;
			g_match_info_fetch_pos (_tmp61_, 0, &_tmp62_, &_tmp63_);
			from = _tmp62_;
			to = _tmp63_;
			_tmp64_ = match_info;
			_tmp65_ = g_match_info_fetch (_tmp64_, 0);
			match = _tmp65_;
			_tmp66_ = sample_tweet;
			_tmp67_ = _tmp66_->source_tweet;
			_tmp68_ = _tmp67_->entities;
			_tmp68__length1 = _tmp67_->entities_length1;
			_tmp69_ = i;
			_tmp70_ = sample_text;
			_tmp71_ = from;
			_tmp72_ = g_utf8_strlen (_tmp70_, (gssize) _tmp71_);
			_tmp73_ = sample_text;
			_tmp74_ = to;
			_tmp75_ = g_utf8_strlen (_tmp73_, (gssize) _tmp74_);
			_tmp76_ = match;
			_tmp77_ = g_strdup (_tmp76_);
			_tmp78_ = g_strdup ("foobar");
			memset (&_tmp79_, 0, sizeof (TextEntity));
			_tmp79_.from = (guint) _tmp72_;
			_tmp79_.to = (guint) _tmp75_;
			_g_free0 (_tmp79_.display_text);
			_tmp79_.display_text = _tmp77_;
			_g_free0 (_tmp79_.target);
			_tmp79_.target = _tmp78_;
			text_entity_destroy (&_tmp68_[_tmp69_]);
			_tmp68_[_tmp69_] = _tmp79_;
			_tmp80_ = _tmp68_[_tmp69_];
			_tmp81_ = match_info;
			g_match_info_next (_tmp81_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (match);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch102_g_regex_error;
				}
				_g_free0 (match);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				_g_object_unref0 (a);
				_g_free0 (sample_text);
				_g_object_unref0 (sample_tweet);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp82_ = i;
			i = _tmp82_ + 1;
			_g_free0 (match);
		}
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
	}
	goto __finally102;
	__catch102_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		g_critical ("SettingsDialog.vala:117: %s", _tmp84_);
		_g_error_free0 (e);
	}
	__finally102:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (a);
		_g_free0 (sample_text);
		_g_object_unref0 (sample_tweet);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp85_ = sample_tweet;
	_tmp86_ = _tmp85_->source_tweet;
	tweet_utils_sort_entities (&_tmp86_->entities, &_tmp86_->entities_length1);
	_tmp87_ = sample_tweet;
	_tmp88_ = _g_object_ref0 (_tmp87_);
	_tmp89_ = account_new ((gint64) 10, "", "");
	_tmp90_ = _tmp89_;
	_tmp91_ = tweet_list_entry_new (_tmp88_, NULL, _tmp90_);
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (self->priv->sample_tweet_entry);
	self->priv->sample_tweet_entry = _tmp91_;
	_g_object_unref0 (_tmp90_);
	_tmp92_ = self->priv->sample_tweet_entry;
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	_tmp93_ = self->priv->sample_tweet_entry;
	tweet_list_entry_set_read_only (_tmp93_, TRUE);
	_tmp94_ = self->priv->sample_tweet_entry;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_widget_get_type (), GtkWidget));
	_tmp95_ = self->priv->sample_tweet_list;
	_tmp96_ = self->priv->sample_tweet_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_widget_get_type (), GtkWidget));
	_tmp97_ = settings_get_text_transform_flags ();
	text_transform_flags = _tmp97_;
	_tmp98_ = self->priv->remove_trailing_hashtags_switch;
	gtk_switch_set_active (_tmp98_, (text_transform_flags & TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS) == TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS);
	_tmp99_ = self->priv->remove_media_links_switch;
	gtk_switch_set_active (_tmp99_, (text_transform_flags & TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS) == TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS);
	_tmp100_ = corebird_snippet_manager;
	snippet_manager_query_snippets (_tmp100_, ___lambda222__snippet_manager_snippet_query_func, self);
	settings_dialog_add_accels (self);
	settings_dialog_load_geometry (self);
	_g_object_unref0 (a);
	_g_free0 (sample_text);
	_g_object_unref0 (sample_tweet);
	return self;
}


SettingsDialog* settings_dialog_new (Corebird* application) {
	return settings_dialog_construct (TYPE_SETTINGS_DIALOG, application);
}


static gboolean settings_dialog_window_destroy_cb (SettingsDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_SETTINGS_DIALOG (self), FALSE);
	settings_dialog_save_geometry (self);
	result = FALSE;
	return result;
}


static gboolean _settings_dialog_window_destroy_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = settings_dialog_window_destroy_cb ((SettingsDialog*) self);
	return result;
}


static void _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated (ModifySnippetDialog* _sender, const gchar* old_key, const gchar* key, const gchar* value, gpointer self) {
	settings_dialog_snippet_updated_func ((SettingsDialog*) self, old_key, key, value);
}


static void settings_dialog_snippet_entry_activated_cb (SettingsDialog* self, GtkListBoxRow* row) {
	SnippetListEntry* snippet_row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	SnippetListEntry* _tmp1_ = NULL;
	ModifySnippetDialog* d = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ModifySnippetDialog* _tmp6_ = NULL;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
	snippet_row = _tmp1_;
	_tmp2_ = snippet_list_entry_get_key (snippet_row);
	_tmp3_ = _tmp2_;
	_tmp4_ = snippet_list_entry_get_value (snippet_row);
	_tmp5_ = _tmp4_;
	_tmp6_ = modify_snippet_dialog_new (_tmp3_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	d = _tmp6_;
	g_signal_connect_object (d, "snippet-updated", (GCallback) _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated, self, 0);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (d);
	_g_object_unref0 (snippet_row);
}


static void _settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	settings_dialog_snippet_entry_activated_cb ((SettingsDialog*) self, row);
}


static void settings_dialog_add_snippet_button_clicked_cb (SettingsDialog* self) {
	ModifySnippetDialog* d = NULL;
	ModifySnippetDialog* _tmp0_ = NULL;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = modify_snippet_dialog_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	d = _tmp0_;
	g_signal_connect_object (d, "snippet-updated", (GCallback) _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated, self, 0);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (d);
}


static void _settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	settings_dialog_add_snippet_button_clicked_cb ((SettingsDialog*) self);
}


static void settings_dialog_snippet_updated_func (SettingsDialog* self, const gchar* old_key, const gchar* key, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp2_ = old_key;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = key;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = value;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp5_ = NULL;
		GList* _tmp6_ = NULL;
		_tmp5_ = self->priv->snippet_list_box;
		_tmp6_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer));
		{
			GList* _row_collection = NULL;
			GList* _row_it = NULL;
			_row_collection = _tmp6_;
			for (_row_it = _row_collection; _row_it != NULL; _row_it = _row_it->next) {
				GtkWidget* _row = NULL;
				_row = (GtkWidget*) _row_it->data;
				{
					SnippetListEntry* srow = NULL;
					GtkWidget* _tmp7_ = NULL;
					SnippetListEntry* _tmp8_ = NULL;
					SnippetListEntry* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					_tmp7_ = _row;
					_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
					srow = _tmp8_;
					_tmp9_ = srow;
					_tmp10_ = snippet_list_entry_get_key (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = old_key;
					if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
						SnippetListEntry* _tmp13_ = NULL;
						_tmp13_ = srow;
						snippet_list_entry_reveal (_tmp13_);
						_g_object_unref0 (srow);
						break;
					}
					_g_object_unref0 (srow);
				}
			}
			_g_list_free0 (_row_collection);
		}
		return;
	}
	_tmp14_ = old_key;
	if (_tmp14_ == NULL) {
		SnippetListEntry* e = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		SnippetListEntry* _tmp17_ = NULL;
		SnippetListEntry* _tmp18_ = NULL;
		GtkListBox* _tmp19_ = NULL;
		SnippetListEntry* _tmp20_ = NULL;
		_tmp15_ = key;
		_tmp16_ = value;
		_tmp17_ = snippet_list_entry_new (_tmp15_, _tmp16_);
		g_object_ref_sink (_tmp17_);
		e = _tmp17_;
		_tmp18_ = e;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		_tmp19_ = self->priv->snippet_list_box;
		_tmp20_ = e;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (e);
	} else {
		GtkListBox* _tmp21_ = NULL;
		GList* _tmp22_ = NULL;
		_tmp21_ = self->priv->snippet_list_box;
		_tmp22_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer));
		{
			GList* _row_collection = NULL;
			GList* _row_it = NULL;
			_row_collection = _tmp22_;
			for (_row_it = _row_collection; _row_it != NULL; _row_it = _row_it->next) {
				GtkWidget* _row = NULL;
				_row = (GtkWidget*) _row_it->data;
				{
					SnippetListEntry* srow = NULL;
					GtkWidget* _tmp23_ = NULL;
					SnippetListEntry* _tmp24_ = NULL;
					SnippetListEntry* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					_tmp23_ = _row;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
					srow = _tmp24_;
					_tmp25_ = srow;
					_tmp26_ = snippet_list_entry_get_key (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = old_key;
					if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
						SnippetListEntry* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						SnippetListEntry* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						_tmp29_ = srow;
						_tmp30_ = key;
						snippet_list_entry_set_key (_tmp29_, _tmp30_);
						_tmp31_ = srow;
						_tmp32_ = value;
						snippet_list_entry_set_value (_tmp31_, _tmp32_);
						_g_object_unref0 (srow);
						break;
					}
					_g_object_unref0 (srow);
				}
			}
			_g_list_free0 (_row_collection);
		}
	}
}


static void settings_dialog_load_geometry (SettingsDialog* self) {
	GVariant* geom = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	gint32 _tmp7_ = 0;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	gint32 _tmp11_ = 0;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	gint32 _tmp15_ = 0;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gint32 _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_value (_tmp1_, "settings-geometry");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	geom = _tmp3_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp4_ = geom;
	_tmp5_ = g_variant_get_child_value (_tmp4_, (gsize) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_get_int32 (_tmp6_);
	x = (gint) _tmp7_;
	_g_variant_unref0 (_tmp6_);
	_tmp8_ = geom;
	_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) 1);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_int32 (_tmp10_);
	y = (gint) _tmp11_;
	_g_variant_unref0 (_tmp10_);
	_tmp12_ = geom;
	_tmp13_ = g_variant_get_child_value (_tmp12_, (gsize) 2);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_variant_get_int32 (_tmp14_);
	w = (gint) _tmp15_;
	_g_variant_unref0 (_tmp14_);
	_tmp16_ = geom;
	_tmp17_ = g_variant_get_child_value (_tmp16_, (gsize) 3);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_variant_get_int32 (_tmp18_);
	h = (gint) _tmp19_;
	_g_variant_unref0 (_tmp18_);
	_tmp21_ = w;
	if (_tmp21_ == 0) {
		_tmp20_ = TRUE;
	} else {
		gint _tmp22_ = 0;
		_tmp22_ = h;
		_tmp20_ = _tmp22_ == 0;
	}
	if (_tmp20_) {
		_g_variant_unref0 (geom);
		return;
	}
	_tmp23_ = x;
	_tmp24_ = y;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp23_, _tmp24_);
	_tmp25_ = w;
	_tmp26_ = h;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp25_, _tmp26_);
	_g_variant_unref0 (geom);
}


static void settings_dialog_save_geometry (SettingsDialog* self) {
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp0_ = NULL;
	GVariantBuilder* _tmp1_ = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = G_VARIANT_TYPE_TUPLE;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	builder = _tmp1_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	gtk_window_get_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	_tmp4_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	w = _tmp4_;
	_tmp5_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	h = _tmp5_;
	_tmp6_ = x;
	_tmp7_ = g_variant_new_int32 ((gint32) _tmp6_);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	g_variant_builder_add_value (builder, _tmp8_);
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = y;
	_tmp10_ = g_variant_new_int32 ((gint32) _tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_variant_builder_add_value (builder, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = w;
	_tmp13_ = g_variant_new_int32 ((gint32) _tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	g_variant_builder_add_value (builder, _tmp14_);
	_g_variant_unref0 (_tmp14_);
	_tmp15_ = h;
	_tmp16_ = g_variant_new_int32 ((gint32) _tmp15_);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	g_variant_builder_add_value (builder, _tmp17_);
	_g_variant_unref0 (_tmp17_);
	_tmp18_ = settings_get ();
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_builder_end (builder);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	g_settings_set_value (_tmp19_, "settings-geometry", _tmp21_);
	_g_variant_unref0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	_g_variant_builder_unref0 (builder);
}


static gboolean __lambda224_ (SettingsDialog* self) {
	gboolean result = FALSE;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	return result;
}


static gboolean ___lambda224__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda224_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda225_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "interface");
	result = TRUE;
	return result;
}


static gboolean ___lambda225__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda225_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda226_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "notifications");
	result = TRUE;
	return result;
}


static gboolean ___lambda226__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda226_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda227_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "tweet");
	result = TRUE;
	return result;
}


static gboolean ___lambda227__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda227_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda228_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "snippets");
	result = TRUE;
	return result;
}


static gboolean ___lambda228__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda228_ ((SettingsDialog*) self);
	return result;
}


static void settings_dialog_add_accels (SettingsDialog* self) {
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp0_ = NULL;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = gtk_accel_group_new ();
	ag = _tmp0_;
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda224__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda224__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_1, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda225__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda225__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_2, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda226__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda226__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_3, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda227__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda227__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_4, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda228__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda228__gtk_accel_group_activate, g_object_ref (self), g_object_unref)));
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ag);
	_g_object_unref0 (ag);
}


static void settings_dialog_remove_trailing_hashtags_cb (SettingsDialog* self) {
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = self->priv->remove_trailing_hashtags_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		settings_add_text_transform_flag (TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS);
	} else {
		settings_remove_text_transform_flag (TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS);
	}
}


static void _settings_dialog_remove_trailing_hashtags_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	settings_dialog_remove_trailing_hashtags_cb ((SettingsDialog*) self);
}


static void settings_dialog_remove_media_links_cb (SettingsDialog* self) {
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = self->priv->remove_media_links_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		settings_add_text_transform_flag (TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS);
	} else {
		settings_remove_text_transform_flag (TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS);
	}
}


static void _settings_dialog_remove_media_links_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	settings_dialog_remove_media_links_cb ((SettingsDialog*) self);
}


static void settings_dialog_class_init (SettingsDialogClass * klass) {
	gint SettingsDialog_private_offset;
	settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = settings_dialog_finalize;
	SettingsDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/settings-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_mentions_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_mentions_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "round_avatar_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, round_avatar_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_dms_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_dms_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_tweets_combobox", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_tweets_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "auto_scroll_on_new_tweets_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, auto_scroll_on_new_tweets_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_media_size_spin_button", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, max_media_size_spin_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "double_click_activation_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, double_click_activation_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sample_tweet_list", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, sample_tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_trailing_hashtags_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, remove_trailing_hashtags_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_media_links_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, remove_media_links_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "snippet_list_box", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, snippet_list_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_destroy_cb", G_CALLBACK(_settings_dialog_window_destroy_cb_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "snippet_entry_activated_cb", G_CALLBACK(_settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_snippet_button_clicked_cb", G_CALLBACK(_settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "remove_trailing_hashtags_cb", G_CALLBACK(_settings_dialog_remove_trailing_hashtags_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "remove_media_links_cb", G_CALLBACK(_settings_dialog_remove_media_links_cb_g_object_notify));
}


static void settings_dialog_instance_init (SettingsDialog * self) {
	self->priv = SETTINGS_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void settings_dialog_finalize (GObject* obj) {
	SettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS_DIALOG, SettingsDialog);
	_g_object_unref0 (self->priv->on_new_mentions_switch);
	_g_object_unref0 (self->priv->round_avatar_switch);
	_g_object_unref0 (self->priv->on_new_dms_switch);
	_g_object_unref0 (self->priv->on_new_tweets_combobox);
	_g_object_unref0 (self->priv->auto_scroll_on_new_tweets_switch);
	_g_object_unref0 (self->priv->max_media_size_spin_button);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->double_click_activation_switch);
	_g_object_unref0 (self->priv->sample_tweet_list);
	_g_object_unref0 (self->priv->remove_trailing_hashtags_switch);
	_g_object_unref0 (self->priv->remove_media_links_switch);
	_g_object_unref0 (self->priv->snippet_list_box);
	_g_object_unref0 (self->priv->sample_tweet_entry);
	G_OBJECT_CLASS (settings_dialog_parent_class)->finalize (obj);
}


GType settings_dialog_get_type (void) {
	static volatile gsize settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDialog), 0, (GInstanceInitFunc) settings_dialog_instance_init, NULL };
		GType settings_dialog_type_id;
		settings_dialog_type_id = g_type_register_static (gtk_window_get_type (), "SettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&settings_dialog_type_id__volatile, settings_dialog_type_id);
	}
	return settings_dialog_type_id__volatile;
}



