/* ScrollWidget.c generated by valac 0.30.0, the Vala compiler
 * generated from ScrollWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;
typedef struct _Block43Data Block43Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block44Data Block44Data;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _ScrollWidgetPrivate {
	gdouble upper_cache;
	gdouble value_cache;
	gint balance;
	gdouble _end_diff;
	gulong scroll_down_id;
	gulong scroll_up_id;
	gint64 start_time;
	gint64 end_time;
	gdouble transition_diff;
	gdouble transition_start_value;
};

struct _Block43Data {
	int _ref_count_;
	ScrollWidget* self;
	gboolean animate;
};

struct _Block44Data {
	int _ref_count_;
	ScrollWidget* self;
	gboolean animate;
};


static gpointer scroll_widget_parent_class = NULL;

#define TOP 1
#define BOTTOM 2
#define NONE 0
GType scroll_widget_get_type (void) G_GNUC_CONST;
#define SCROLL_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCROLL_WIDGET, ScrollWidgetPrivate))
enum  {
	SCROLL_WIDGET_DUMMY_PROPERTY,
	SCROLL_WIDGET_END_DIFF,
	SCROLL_WIDGET_SCROLLED_DOWN,
	SCROLL_WIDGET_SCROLLED_UP
};
#define SCROLL_WIDGET_TRANSITION_DURATION ((gint64) 300)
static void scroll_widget_keep_upper_func (ScrollWidget* self);
static void scroll_widget_keep_value_func (ScrollWidget* self);
gdouble scroll_widget_get_end_diff (ScrollWidget* self);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
void scroll_widget_scroll_up_next (ScrollWidget* self, gboolean animate, gboolean force_wait, gboolean force_start);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static gboolean scroll_widget_scroll_up_tick_cb (ScrollWidget* self, GtkWidget* widget, GdkFrameClock* frame_clock);
static gboolean _scroll_widget_scroll_up_tick_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void ___lambda44_ (Block43Data* _data43_);
static void ____lambda44__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void __lambda45_ (Block44Data* _data44_);
static void ___lambda45__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gdouble scroll_widget_ease_out_cubic (ScrollWidget* self, gdouble t);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void scroll_widget_set_end_diff (ScrollWidget* self, gdouble value);
gboolean scroll_widget_get_scrolled_down (ScrollWidget* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
static GObject * scroll_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _scroll_widget_keep_upper_func_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _scroll_widget_keep_value_func_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void scroll_widget_finalize (GObject* obj);
static void _vala_scroll_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_scroll_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void scroll_widget_keep_upper_func (ScrollWidget* self) {
	gdouble upper = 0.0;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	GtkAdjustment* _tmp16_ = NULL;
	GtkAdjustment* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	GtkAdjustment* _tmp20_ = NULL;
	GtkAdjustment* _tmp21_ = NULL;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	upper = _tmp3_;
	_tmp4_ = self->priv->balance;
	if (_tmp4_ == TOP) {
		gdouble inc = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		GtkAdjustment* _tmp7_ = NULL;
		GtkAdjustment* _tmp8_ = NULL;
		GtkAdjustment* _tmp9_ = NULL;
		GtkAdjustment* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		GtkAdjustment* _tmp14_ = NULL;
		GtkAdjustment* _tmp15_ = NULL;
		_tmp5_ = upper;
		_tmp6_ = self->priv->upper_cache;
		inc = _tmp5_ - _tmp6_;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp10_ = _tmp9_;
		_tmp11_ = gtk_adjustment_get_value (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = inc;
		gtk_adjustment_set_value (_tmp10_, _tmp12_ + _tmp13_);
		_tmp14_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp15_ = _tmp14_;
		gtk_adjustment_value_changed (_tmp15_);
		self->priv->balance = NONE;
	}
	_tmp16_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp17_ = _tmp16_;
	_tmp18_ = gtk_adjustment_get_upper (_tmp17_);
	_tmp19_ = _tmp18_;
	self->priv->upper_cache = _tmp19_;
	_tmp20_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp21_ = _tmp20_;
	_tmp22_ = gtk_adjustment_get_value (_tmp21_);
	_tmp23_ = _tmp22_;
	self->priv->value_cache = _tmp23_;
}


static void scroll_widget_keep_value_func (ScrollWidget* self) {
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble max = 0.0;
	GtkAdjustment* _tmp8_ = NULL;
	GtkAdjustment* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GtkAdjustment* _tmp12_ = NULL;
	GtkAdjustment* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	GtkAdjustment* _tmp16_ = NULL;
	GtkAdjustment* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp22_ = NULL;
	GtkAdjustment* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gint _tmp26_ = 0;
	GtkAdjustment* _tmp38_ = NULL;
	GtkAdjustment* _tmp39_ = NULL;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	GtkAdjustment* _tmp42_ = NULL;
	GtkAdjustment* _tmp43_ = NULL;
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 10.0) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		g_signal_emit_by_name (self, "scrolled-to-start", _tmp7_);
	}
	_tmp8_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_upper (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_adjustment_get_page_size (_tmp13_);
	_tmp15_ = _tmp14_;
	max = _tmp11_ - _tmp15_;
	_tmp16_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp17_ = _tmp16_;
	_tmp18_ = gtk_adjustment_get_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = max;
	_tmp21_ = self->priv->_end_diff;
	if (_tmp19_ >= (_tmp20_ - _tmp21_)) {
		g_signal_emit_by_name (self, "scrolled-to-end");
	}
	_tmp22_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp23_ = _tmp22_;
	_tmp24_ = gtk_adjustment_get_upper (_tmp23_);
	_tmp25_ = _tmp24_;
	upper = _tmp25_;
	_tmp26_ = self->priv->balance;
	if (_tmp26_ == BOTTOM) {
		gdouble inc = 0.0;
		gdouble _tmp27_ = 0.0;
		gdouble _tmp28_ = 0.0;
		GtkAdjustment* _tmp29_ = NULL;
		GtkAdjustment* _tmp30_ = NULL;
		GtkAdjustment* _tmp31_ = NULL;
		GtkAdjustment* _tmp32_ = NULL;
		gdouble _tmp33_ = 0.0;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		GtkAdjustment* _tmp36_ = NULL;
		GtkAdjustment* _tmp37_ = NULL;
		_tmp27_ = upper;
		_tmp28_ = self->priv->upper_cache;
		inc = _tmp27_ - _tmp28_;
		_tmp29_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp30_ = _tmp29_;
		_tmp31_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp32_ = _tmp31_;
		_tmp33_ = gtk_adjustment_get_value (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = inc;
		gtk_adjustment_set_value (_tmp32_, _tmp34_ - _tmp35_);
		_tmp36_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp37_ = _tmp36_;
		gtk_adjustment_value_changed (_tmp37_);
		self->priv->balance = NONE;
	}
	_tmp38_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp39_ = _tmp38_;
	_tmp40_ = gtk_adjustment_get_upper (_tmp39_);
	_tmp41_ = _tmp40_;
	self->priv->upper_cache = _tmp41_;
	_tmp42_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp43_ = _tmp42_;
	_tmp44_ = gtk_adjustment_get_value (_tmp43_);
	_tmp45_ = _tmp44_;
	self->priv->value_cache = _tmp45_;
}


void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_tmp0_ = mode;
	self->priv->balance = _tmp0_;
}


/**
   * TODO: Update scroll_down_next
   * Scroll to the very top of the scrolled window once the next
   * size_allocate occurs.
   * This will use a transition if the correct Gtk+ settings is set
   * to true.
   *
   * @param animate    Whether to animate/transition the change or not (default: true)
   * @param force_wait If this is set to true, we will wait for the next size_allocate
   *                   event, even if the widget is unmapped (default: false).
   */
static Block43Data* block43_data_ref (Block43Data* _data43_) {
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}


static void block43_data_unref (void * _userdata_) {
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		ScrollWidget* self;
		self = _data43_->self;
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}


static gboolean _scroll_widget_scroll_up_tick_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = scroll_widget_scroll_up_tick_cb ((ScrollWidget*) self, widget, frame_clock);
	return result;
}


static void ___lambda44_ (Block43Data* _data43_) {
	ScrollWidget* self;
	gboolean _tmp0_ = FALSE;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gulong _tmp20_ = 0UL;
	self = _data43_->self;
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-enable-animations", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = _data43_->animate;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkFrameClock* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		GtkAdjustment* _tmp8_ = NULL;
		GtkAdjustment* _tmp9_ = NULL;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		GtkAdjustment* _tmp12_ = NULL;
		GtkAdjustment* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		_tmp5_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = gdk_frame_clock_get_frame_time (_tmp5_);
		self->priv->start_time = _tmp6_;
		_tmp7_ = self->priv->start_time;
		self->priv->end_time = _tmp7_ + (SCROLL_WIDGET_TRANSITION_DURATION * 1000);
		_tmp8_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_adjustment_get_value (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->transition_diff = -_tmp11_;
		_tmp12_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_adjustment_get_value (_tmp13_);
		_tmp15_ = _tmp14_;
		self->priv->transition_start_value = _tmp15_;
		gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _scroll_widget_scroll_up_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
	} else {
		GtkAdjustment* _tmp16_ = NULL;
		GtkAdjustment* _tmp17_ = NULL;
		GtkAdjustment* _tmp18_ = NULL;
		GtkAdjustment* _tmp19_ = NULL;
		_tmp16_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp17_ = _tmp16_;
		gtk_adjustment_set_value (_tmp17_, (gdouble) 0);
		_tmp18_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp19_ = _tmp18_;
		gtk_adjustment_value_changed (_tmp19_);
	}
	_tmp20_ = self->priv->scroll_up_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp20_);
	self->priv->scroll_up_id = (gulong) 0;
}


static void ____lambda44__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	___lambda44_ (self);
}


void scroll_widget_scroll_up_next (ScrollWidget* self, gboolean animate, gboolean force_wait, gboolean force_start) {
	Block43Data* _data43_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_tmp0_ = animate;
	_data43_->animate = _tmp0_;
	_tmp2_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = force_wait;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		GtkAdjustment* _tmp6_ = NULL;
		GtkAdjustment* _tmp7_ = NULL;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		gtk_adjustment_set_value (_tmp5_, (gdouble) 0);
		_tmp6_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp7_ = _tmp6_;
		gtk_adjustment_value_changed (_tmp7_);
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return;
	}
	_tmp8_ = force_start;
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		GtkSettings* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = gtk_settings_get_default ();
		g_object_get (_tmp10_, "gtk-enable-animations", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			_tmp13_ = _data43_->animate;
			_tmp9_ = _tmp13_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GdkFrameClock* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
			gint64 _tmp16_ = 0LL;
			GtkAdjustment* _tmp17_ = NULL;
			GtkAdjustment* _tmp18_ = NULL;
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
			GtkAdjustment* _tmp21_ = NULL;
			GtkAdjustment* _tmp22_ = NULL;
			gdouble _tmp23_ = 0.0;
			gdouble _tmp24_ = 0.0;
			_tmp14_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_tmp15_ = gdk_frame_clock_get_frame_time (_tmp14_);
			self->priv->start_time = _tmp15_;
			_tmp16_ = self->priv->start_time;
			self->priv->end_time = _tmp16_ + (SCROLL_WIDGET_TRANSITION_DURATION * 1000);
			_tmp17_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp18_ = _tmp17_;
			_tmp19_ = gtk_adjustment_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			self->priv->transition_diff = -_tmp20_;
			_tmp21_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_adjustment_get_value (_tmp22_);
			_tmp24_ = _tmp23_;
			self->priv->transition_start_value = _tmp24_;
			gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _scroll_widget_scroll_up_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
		} else {
			GtkAdjustment* _tmp25_ = NULL;
			GtkAdjustment* _tmp26_ = NULL;
			GtkAdjustment* _tmp27_ = NULL;
			GtkAdjustment* _tmp28_ = NULL;
			_tmp25_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp26_ = _tmp25_;
			gtk_adjustment_set_value (_tmp26_, (gdouble) 0);
			_tmp27_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp28_ = _tmp27_;
			gtk_adjustment_value_changed (_tmp28_);
		}
	} else {
		gulong _tmp29_ = 0UL;
		gulong _tmp38_ = 0UL;
		_tmp29_ = self->priv->scroll_up_id;
		if (_tmp29_ != ((gulong) 0)) {
			GtkAdjustment* _tmp30_ = NULL;
			GtkAdjustment* _tmp31_ = NULL;
			gdouble _tmp32_ = 0.0;
			gdouble _tmp33_ = 0.0;
			GtkAdjustment* _tmp34_ = NULL;
			GtkAdjustment* _tmp35_ = NULL;
			gdouble _tmp36_ = 0.0;
			gdouble _tmp37_ = 0.0;
			_tmp30_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp31_ = _tmp30_;
			_tmp32_ = gtk_adjustment_get_value (_tmp31_);
			_tmp33_ = _tmp32_;
			self->priv->transition_diff = -_tmp33_;
			_tmp34_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp35_ = _tmp34_;
			_tmp36_ = gtk_adjustment_get_value (_tmp35_);
			_tmp37_ = _tmp36_;
			self->priv->transition_start_value = _tmp37_;
			block43_data_unref (_data43_);
			_data43_ = NULL;
			return;
		}
		_tmp38_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) ____lambda44__gtk_widget_size_allocate, block43_data_ref (_data43_), (GClosureNotify) block43_data_unref, 0);
		self->priv->scroll_up_id = _tmp38_;
	}
	block43_data_unref (_data43_);
	_data43_ = NULL;
}


/**
   * Scroll to the very end of the scrolled window once the next
   * size_alocate occurs.
   * This will use a transition if the correct Gtk+ settings is set
   * to true
   *
   * @param animate Whether to animate/transition the change or not (default: true)
   * @param force_wait If this is set to true, we will wait for the next size_allocate
   *                   event, even if the widget is unmapped (default: false).
   */
static Block44Data* block44_data_ref (Block44Data* _data44_) {
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}


static void block44_data_unref (void * _userdata_) {
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		ScrollWidget* self;
		self = _data44_->self;
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}


static void __lambda45_ (Block44Data* _data44_) {
	ScrollWidget* self;
	gboolean _tmp0_ = FALSE;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gulong _tmp36_ = 0UL;
	self = _data44_->self;
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-enable-animations", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = _data44_->animate;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkFrameClock* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		GtkAdjustment* _tmp8_ = NULL;
		GtkAdjustment* _tmp9_ = NULL;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		GtkAdjustment* _tmp12_ = NULL;
		GtkAdjustment* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		GtkAdjustment* _tmp16_ = NULL;
		GtkAdjustment* _tmp17_ = NULL;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		GtkAdjustment* _tmp20_ = NULL;
		GtkAdjustment* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		_tmp5_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = gdk_frame_clock_get_frame_time (_tmp5_);
		self->priv->start_time = _tmp6_;
		_tmp7_ = self->priv->start_time;
		self->priv->end_time = _tmp7_ + (SCROLL_WIDGET_TRANSITION_DURATION * 1000);
		_tmp8_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_adjustment_get_upper (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_adjustment_get_page_size (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp17_ = _tmp16_;
		_tmp18_ = gtk_adjustment_get_value (_tmp17_);
		_tmp19_ = _tmp18_;
		self->priv->transition_diff = (_tmp11_ - _tmp15_) - _tmp19_;
		_tmp20_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp21_ = _tmp20_;
		_tmp22_ = gtk_adjustment_get_value (_tmp21_);
		_tmp23_ = _tmp22_;
		self->priv->transition_start_value = _tmp23_;
		gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _scroll_widget_scroll_up_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
	} else {
		GtkAdjustment* _tmp24_ = NULL;
		GtkAdjustment* _tmp25_ = NULL;
		GtkAdjustment* _tmp26_ = NULL;
		GtkAdjustment* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		GtkAdjustment* _tmp30_ = NULL;
		GtkAdjustment* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		gdouble _tmp33_ = 0.0;
		GtkAdjustment* _tmp34_ = NULL;
		GtkAdjustment* _tmp35_ = NULL;
		_tmp24_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp25_ = _tmp24_;
		_tmp26_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp27_ = _tmp26_;
		_tmp28_ = gtk_adjustment_get_upper (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp31_ = _tmp30_;
		_tmp32_ = gtk_adjustment_get_page_size (_tmp31_);
		_tmp33_ = _tmp32_;
		gtk_adjustment_set_value (_tmp25_, _tmp29_ - _tmp33_);
		_tmp34_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp35_ = _tmp34_;
		gtk_adjustment_value_changed (_tmp35_);
	}
	_tmp36_ = self->priv->scroll_down_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp36_);
	self->priv->scroll_down_id = (gulong) 0;
}


static void ___lambda45__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda45_ (self);
}


void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait) {
	Block44Data* _data44_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gulong _tmp16_ = 0UL;
	gulong _tmp17_ = 0UL;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = animate;
	_data44_->animate = _tmp0_;
	_tmp2_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = force_wait;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		GtkAdjustment* _tmp6_ = NULL;
		GtkAdjustment* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		GtkAdjustment* _tmp10_ = NULL;
		GtkAdjustment* _tmp11_ = NULL;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		GtkAdjustment* _tmp14_ = NULL;
		GtkAdjustment* _tmp15_ = NULL;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_adjustment_get_upper (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_adjustment_get_page_size (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_adjustment_set_value (_tmp5_, _tmp9_ - _tmp13_);
		_tmp14_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp15_ = _tmp14_;
		gtk_adjustment_value_changed (_tmp15_);
		block44_data_unref (_data44_);
		_data44_ = NULL;
		return;
	}
	_tmp16_ = self->priv->scroll_down_id;
	if (_tmp16_ != ((gulong) 0)) {
		block44_data_unref (_data44_);
		_data44_ = NULL;
		return;
	}
	_tmp17_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) ___lambda45__gtk_widget_size_allocate, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
	self->priv->scroll_down_id = _tmp17_;
	block44_data_unref (_data44_);
	_data44_ = NULL;
}


static gboolean scroll_widget_scroll_up_tick_cb (ScrollWidget* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gdouble t = 0.0;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	GtkAdjustment* _tmp15_ = NULL;
	GtkAdjustment* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gboolean _tmp20_ = FALSE;
	GtkAdjustment* _tmp21_ = NULL;
	GtkAdjustment* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	g_return_val_if_fail (IS_SCROLL_WIDGET (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		GtkAdjustment* _tmp1_ = NULL;
		GtkAdjustment* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp1_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->transition_start_value;
		_tmp4_ = self->priv->transition_diff;
		gtk_adjustment_set_value (_tmp2_, _tmp3_ + _tmp4_);
		result = FALSE;
		return result;
	}
	_tmp5_ = frame_clock;
	_tmp6_ = gdk_frame_clock_get_frame_time (_tmp5_);
	now = _tmp6_;
	t = 1.0;
	_tmp7_ = now;
	_tmp8_ = self->priv->end_time;
	if (_tmp7_ < _tmp8_) {
		gint64 _tmp9_ = 0LL;
		gint64 _tmp10_ = 0LL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
		_tmp9_ = now;
		_tmp10_ = self->priv->start_time;
		_tmp11_ = self->priv->end_time;
		_tmp12_ = self->priv->start_time;
		t = (_tmp9_ - _tmp10_) / ((gdouble) (_tmp11_ - _tmp12_));
	}
	_tmp13_ = t;
	_tmp14_ = scroll_widget_ease_out_cubic (self, _tmp13_);
	t = _tmp14_;
	_tmp15_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->transition_start_value;
	_tmp18_ = t;
	_tmp19_ = self->priv->transition_diff;
	gtk_adjustment_set_value (_tmp16_, _tmp17_ + (_tmp18_ * _tmp19_));
	_tmp21_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_adjustment_get_value (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ <= ((gdouble) 0)) {
		_tmp20_ = TRUE;
	} else {
		gint64 _tmp25_ = 0LL;
		gint64 _tmp26_ = 0LL;
		_tmp25_ = now;
		_tmp26_ = self->priv->end_time;
		_tmp20_ = _tmp25_ >= _tmp26_;
	}
	if (_tmp20_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gdouble scroll_widget_ease_out_cubic (ScrollWidget* self, gdouble t) {
	gdouble result = 0.0;
	gdouble p = 0.0;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_SCROLL_WIDGET (self), 0.0);
	_tmp0_ = t;
	p = _tmp0_ - 1;
	result = ((p * p) * p) + 1;
	return result;
}


ScrollWidget* scroll_widget_construct (GType object_type) {
	ScrollWidget * self = NULL;
	self = (ScrollWidget*) g_object_new (object_type, NULL);
	return self;
}


ScrollWidget* scroll_widget_new (void) {
	return scroll_widget_construct (TYPE_SCROLL_WIDGET);
}


gdouble scroll_widget_get_end_diff (ScrollWidget* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_SCROLL_WIDGET (self), 0.0);
	_tmp0_ = self->priv->_end_diff;
	result = _tmp0_;
	return result;
}


void scroll_widget_set_end_diff (ScrollWidget* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (IS_SCROLL_WIDGET (self));
	_tmp0_ = value;
	self->priv->_end_diff = _tmp0_;
	g_object_notify ((GObject *) self, "end-diff");
}


gboolean scroll_widget_get_scrolled_down (ScrollWidget* self) {
	gboolean result;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GtkAdjustment* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	GtkAdjustment* _tmp8_ = NULL;
	GtkAdjustment* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	g_return_val_if_fail (IS_SCROLL_WIDGET (self), FALSE);
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_adjustment_get_upper (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_page_size (_tmp9_);
	_tmp11_ = _tmp10_;
	result = _tmp3_ >= ((_tmp7_ - _tmp11_) - 5);
	return result;
}


gboolean scroll_widget_get_scrolled_up (ScrollWidget* self) {
	gboolean result;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (IS_SCROLL_WIDGET (self), FALSE);
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ <= ((gdouble) 5);
	return result;
}


static void _scroll_widget_keep_upper_func_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	scroll_widget_keep_upper_func ((ScrollWidget*) self);
}


static void _scroll_widget_keep_value_func_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	scroll_widget_keep_value_func ((ScrollWidget*) self);
}


static GObject * scroll_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ScrollWidget * self;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (scroll_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCROLL_WIDGET, ScrollWidget);
	_tmp0_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp1_ = _tmp0_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "notify::upper", (GCallback) _scroll_widget_keep_upper_func_g_object_notify, self, 0);
	_tmp2_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp3_ = _tmp2_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "notify::value", (GCallback) _scroll_widget_keep_value_func_g_object_notify, self, 0);
	return obj;
}


static void scroll_widget_class_init (ScrollWidgetClass * klass) {
	scroll_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScrollWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_scroll_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scroll_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = scroll_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = scroll_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCROLL_WIDGET_END_DIFF, g_param_spec_double ("end-diff", "end-diff", "end-diff", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 200, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCROLL_WIDGET_SCROLLED_DOWN, g_param_spec_boolean ("scrolled-down", "scrolled-down", "scrolled-down", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCROLL_WIDGET_SCROLLED_UP, g_param_spec_boolean ("scrolled-up", "scrolled-up", "scrolled-up", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("scrolled_to_start", TYPE_SCROLL_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("scrolled_to_end", TYPE_SCROLL_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void scroll_widget_instance_init (ScrollWidget * self) {
	self->priv = SCROLL_WIDGET_GET_PRIVATE (self);
	self->priv->balance = NONE;
	self->priv->_end_diff = (gdouble) 200;
}


static void scroll_widget_finalize (GObject* obj) {
	ScrollWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCROLL_WIDGET, ScrollWidget);
	G_OBJECT_CLASS (scroll_widget_parent_class)->finalize (obj);
}


GType scroll_widget_get_type (void) {
	static volatile gsize scroll_widget_type_id__volatile = 0;
	if (g_once_init_enter (&scroll_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScrollWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scroll_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScrollWidget), 0, (GInstanceInitFunc) scroll_widget_instance_init, NULL };
		GType scroll_widget_type_id;
		scroll_widget_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "ScrollWidget", &g_define_type_info, 0);
		g_once_init_leave (&scroll_widget_type_id__volatile, scroll_widget_type_id);
	}
	return scroll_widget_type_id__volatile;
}


static void _vala_scroll_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ScrollWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCROLL_WIDGET, ScrollWidget);
	switch (property_id) {
		case SCROLL_WIDGET_END_DIFF:
		g_value_set_double (value, scroll_widget_get_end_diff (self));
		break;
		case SCROLL_WIDGET_SCROLLED_DOWN:
		g_value_set_boolean (value, scroll_widget_get_scrolled_down (self));
		break;
		case SCROLL_WIDGET_SCROLLED_UP:
		g_value_set_boolean (value, scroll_widget_get_scrolled_up (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_scroll_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ScrollWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCROLL_WIDGET, ScrollWidget);
	switch (property_id) {
		case SCROLL_WIDGET_END_DIFF:
		scroll_widget_set_end_diff (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



