/* MultiMediaWidget.c generated by valac 0.30.0, the Vala compiler
 * generated from MultiMediaWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */
/* TODO: Allow D'n'D out of the button*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_MEDIA_BUTTON (media_button_get_type ())
#define MEDIA_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_BUTTON, MediaButton))
#define MEDIA_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_BUTTON, MediaButtonClass))
#define IS_MEDIA_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_BUTTON))
#define IS_MEDIA_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_BUTTON))
#define MEDIA_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_BUTTON, MediaButtonClass))

typedef struct _MediaButton MediaButton;
typedef struct _MediaButtonClass MediaButtonClass;
typedef struct _MediaButtonPrivate MediaButtonPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MediaButton {
	GtkButton parent_instance;
	MediaButtonPrivate * priv;
	GtkWindow* window;
};

struct _MediaButtonClass {
	GtkButtonClass parent_class;
};

struct _MediaButtonPrivate {
	Media* _media;
	GMenu* menu_model;
	GtkMenu* menu;
	GSimpleActionGroup* actions;
	PangoLayout* layout;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	cairo_surface_t* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

struct _MultiMediaWidgetPrivate {
	gint _media_count;
	MediaButton** media_buttons;
	gint media_buttons_length1;
	gint _media_buttons_size_;
	gboolean media_invalid_fired;
};


static gpointer media_button_parent_class = NULL;
static cairo_surface_t** media_button_play_icons;
static gint media_button_play_icons_length1;
static cairo_surface_t** media_button_play_icons = NULL;
static gint media_button_play_icons_length1 = 0;
static gint _media_button_play_icons_size_ = 0;
static gpointer multi_media_widget_parent_class = NULL;

GType media_button_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
#define MEDIA_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_BUTTON, MediaButtonPrivate))
enum  {
	MEDIA_BUTTON_DUMMY_PROPERTY,
	MEDIA_BUTTON_MEDIA
};
#define MEDIA_BUTTON_PLAY_ICON_SIZE 32
static void media_button_copy_url_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_copy_url_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void media_button_save_original_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_save_original_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void media_button_open_in_browser_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_open_in_browser_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MediaButton* media_button_new (Media* media);
MediaButton* media_button_construct (GType object_type, Media* media);
void media_button_set_media (MediaButton* self, Media* value);
#define MULTI_MEDIA_WIDGET_HEIGHT 60
static gboolean media_button_button_clicked_cb (MediaButton* self, GdkEventButton* evt);
static gboolean _media_button_button_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean media_button_real_draw (GtkWidget* base, cairo_t* ct);
Media* media_button_get_media (MediaButton* self);
GType media_type_get_type (void) G_GNUC_CONST;
gdouble media_get_percent_loaded (Media* self);
const gchar* media_get_target_url (Media* self);
gchar* utils_get_file_name (const gchar* path);
static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void media_button_finalize (GObject* obj);
static void _vala_media_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_media_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType multi_media_widget_get_type (void) G_GNUC_CONST;
#define MULTI_MEDIA_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetPrivate))
enum  {
	MULTI_MEDIA_WIDGET_DUMMY_PROPERTY,
	MULTI_MEDIA_WIDGET_MEDIA_COUNT
};
MultiMediaWidget* multi_media_widget_new (gint media_count);
MultiMediaWidget* multi_media_widget_construct (GType object_type, gint media_count);
static void multi_media_widget_set_media_count (MultiMediaWidget* self, gint value);
void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1);
static void multi_media_widget_remove_all (MultiMediaWidget* self);
void multi_media_widget_set_media (MultiMediaWidget* self, gint index, Media* media);
static void __lambda11_ (MultiMediaWidget* self, GtkWidget* w);
static void ___lambda11__gfunc (gconstpointer data, gpointer self);
gint multi_media_widget_get_media_count (MultiMediaWidget* self);
static void multi_media_widget_media_loaded_cb (MultiMediaWidget* self, Media* source);
static void _multi_media_widget_media_loaded_cb_media_finished_loading (Media* _sender, gpointer self);
static void multi_media_widget_button_clicked_cb (MultiMediaWidget* self, GtkButton* source);
static void _multi_media_widget_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void multi_media_widget_finalize (GObject* obj);
static void _vala_multi_media_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_multi_media_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry MEDIA_BUTTON_action_entries[3] = {{"copy-url", _media_button_copy_url_activated_gsimple_action_activate_callback}, {"save-original", _media_button_save_original_activated_gsimple_action_activate_callback}, {"open-in-browser", _media_button_open_in_browser_activated_gsimple_action_activate_callback}};

static void _media_button_copy_url_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_copy_url_activated ((MediaButton*) self, action, parameter);
}


static void _media_button_save_original_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_save_original_activated ((MediaButton*) self, action, parameter);
}


static void _media_button_open_in_browser_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_open_in_browser_activated ((MediaButton*) self, action, parameter);
}


static gboolean _media_button_button_clicked_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = media_button_button_clicked_cb ((MediaButton*) self, event);
	return result;
}


MediaButton* media_button_construct (GType object_type, Media* media) {
	MediaButton * self = NULL;
	Media* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GSimpleActionGroup* _tmp3_ = NULL;
	GSimpleActionGroup* _tmp4_ = NULL;
	GSimpleActionGroup* _tmp5_ = NULL;
	GMenu* _tmp6_ = NULL;
	GMenu* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GMenu* _tmp9_ = NULL;
	GtkMenu* _tmp10_ = NULL;
	GtkMenu* _tmp11_ = NULL;
	PangoLayout* _tmp12_ = NULL;
	g_return_val_if_fail ((media == NULL) || IS_MEDIA (media), NULL);
	self = (MediaButton*) g_object_new (object_type, NULL);
	_tmp0_ = media;
	media_button_set_media (self, _tmp0_);
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), -1, MULTI_MEDIA_WIDGET_HEIGHT);
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp1_, "inline-media");
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "dim-label");
	_tmp3_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp3_;
	_tmp4_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_action_map_get_type (), GActionMap), MEDIA_BUTTON_action_entries, G_N_ELEMENTS (MEDIA_BUTTON_action_entries), self);
	_tmp5_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "media", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_action_group_get_type (), GActionGroup));
	_tmp6_ = g_menu_new ();
	_g_object_unref0 (self->priv->menu_model);
	self->priv->menu_model = _tmp6_;
	_tmp7_ = self->priv->menu_model;
	_tmp8_ = _ ("Open in Browser");
	g_menu_append (_tmp7_, _tmp8_, "media.open-in-browser");
	_tmp9_ = self->priv->menu_model;
	_tmp10_ = (GtkMenu*) gtk_menu_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_menu_model_get_type (), GMenuModel));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp10_;
	_tmp11_ = self->priv->menu;
	gtk_menu_attach_to_widget (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL);
	_tmp12_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "0%");
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp12_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _media_button_button_clicked_cb_gtk_widget_button_press_event, self, 0);
	return self;
}


MediaButton* media_button_new (Media* media) {
	return media_button_construct (TYPE_MEDIA_BUTTON, media);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean media_button_real_draw (GtkWidget* base, cairo_t* ct) {
	MediaButton * self;
	gboolean result = FALSE;
	gint widget_width = 0;
	gint _tmp0_ = 0;
	gint widget_height = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Media* _tmp4_ = NULL;
	Media* _tmp5_ = NULL;
	cairo_t* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp1_;
	_tmp4_ = media_button_get_media (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		Media* _tmp6_ = NULL;
		Media* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		_tmp6_ = media_button_get_media (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->thumbnail;
		_tmp3_ = _tmp8_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Media* _tmp9_ = NULL;
		Media* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = media_button_get_media (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->loaded;
		_tmp2_ = _tmp11_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		cairo_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gdouble scale = 0.0;
		gint _tmp16_ = 0;
		Media* _tmp17_ = NULL;
		Media* _tmp18_ = NULL;
		cairo_surface_t* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		cairo_t* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		cairo_t* _tmp23_ = NULL;
		Media* _tmp24_ = NULL;
		Media* _tmp25_ = NULL;
		cairo_surface_t* _tmp26_ = NULL;
		cairo_t* _tmp27_ = NULL;
		cairo_t* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		Media* _tmp32_ = NULL;
		Media* _tmp33_ = NULL;
		MediaType _tmp34_ = 0;
		_tmp12_ = ct;
		cairo_save (_tmp12_);
		_tmp13_ = ct;
		_tmp14_ = widget_width;
		_tmp15_ = widget_height;
		cairo_rectangle (_tmp13_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp14_, (gdouble) _tmp15_);
		_tmp16_ = widget_width;
		_tmp17_ = media_button_get_media (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->thumbnail;
		_tmp20_ = cairo_image_surface_get_width ((cairo_surface_t*) _tmp19_);
		scale = ((gdouble) _tmp16_) / _tmp20_;
		_tmp21_ = ct;
		_tmp22_ = scale;
		cairo_scale (_tmp21_, _tmp22_, (gdouble) 1);
		_tmp23_ = ct;
		_tmp24_ = media_button_get_media (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_->thumbnail;
		cairo_set_source_surface (_tmp23_, _tmp26_, (gdouble) 0, (gdouble) 0);
		_tmp27_ = ct;
		cairo_fill (_tmp27_);
		_tmp28_ = ct;
		cairo_restore (_tmp28_);
		_tmp32_ = media_button_get_media (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_->type;
		if (_tmp34_ == MEDIA_TYPE_VINE) {
			_tmp31_ = TRUE;
		} else {
			Media* _tmp35_ = NULL;
			Media* _tmp36_ = NULL;
			MediaType _tmp37_ = 0;
			_tmp35_ = media_button_get_media (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_->type;
			_tmp31_ = _tmp37_ == MEDIA_TYPE_ANIMATED_GIF;
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			Media* _tmp38_ = NULL;
			Media* _tmp39_ = NULL;
			MediaType _tmp40_ = 0;
			_tmp38_ = media_button_get_media (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_->type;
			_tmp30_ = _tmp40_ == MEDIA_TYPE_GIF;
		}
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			Media* _tmp41_ = NULL;
			Media* _tmp42_ = NULL;
			MediaType _tmp43_ = 0;
			_tmp41_ = media_button_get_media (self);
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_->type;
			_tmp29_ = _tmp43_ == MEDIA_TYPE_TWITTER_VIDEO;
		}
		if (_tmp29_) {
			gint x = 0;
			gint _tmp44_ = 0;
			gint y = 0;
			gint _tmp45_ = 0;
			cairo_t* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			cairo_t* _tmp49_ = NULL;
			cairo_surface_t** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp51_ = 0;
			cairo_surface_t* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gint _tmp54_ = 0;
			cairo_t* _tmp55_ = NULL;
			_tmp44_ = widget_width;
			x = (_tmp44_ / 2) - (MEDIA_BUTTON_PLAY_ICON_SIZE / 2);
			_tmp45_ = widget_height;
			y = (_tmp45_ / 2) - (MEDIA_BUTTON_PLAY_ICON_SIZE / 2);
			_tmp46_ = ct;
			_tmp47_ = x;
			_tmp48_ = y;
			cairo_rectangle (_tmp46_, (gdouble) _tmp47_, (gdouble) _tmp48_, (gdouble) MEDIA_BUTTON_PLAY_ICON_SIZE, (gdouble) MEDIA_BUTTON_PLAY_ICON_SIZE);
			_tmp49_ = ct;
			_tmp50_ = media_button_play_icons;
			_tmp50__length1 = media_button_play_icons_length1;
			_tmp51_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_tmp52_ = _tmp50_[_tmp51_ - 1];
			_tmp53_ = x;
			_tmp54_ = y;
			cairo_set_source_surface (_tmp49_, _tmp52_, (gdouble) _tmp53_, (gdouble) _tmp54_);
			_tmp55_ = ct;
			cairo_fill (_tmp55_);
		}
	} else {
		GtkStyleContext* sc = NULL;
		GtkStyleContext* _tmp56_ = NULL;
		GtkStyleContext* _tmp57_ = NULL;
		gdouble layout_x = 0.0;
		gdouble layout_y = 0.0;
		gint layout_w = 0;
		gint layout_h = 0;
		PangoLayout* _tmp58_ = NULL;
		Media* _tmp59_ = NULL;
		Media* _tmp60_ = NULL;
		gdouble _tmp61_ = 0.0;
		gdouble _tmp62_ = 0.0;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		PangoLayout* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		GtkStyleContext* _tmp72_ = NULL;
		cairo_t* _tmp73_ = NULL;
		gdouble _tmp74_ = 0.0;
		gdouble _tmp75_ = 0.0;
		PangoLayout* _tmp76_ = NULL;
		_tmp56_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp57_ = _g_object_ref0 (_tmp56_);
		sc = _tmp57_;
		_tmp58_ = self->priv->layout;
		_tmp59_ = media_button_get_media (self);
		_tmp60_ = _tmp59_;
		_tmp61_ = media_get_percent_loaded (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strdup_printf ("%d%%", (gint) (_tmp62_ * 100));
		_tmp64_ = _tmp63_;
		pango_layout_set_text (_tmp58_, _tmp64_, -1);
		_g_free0 (_tmp64_);
		_tmp65_ = self->priv->layout;
		pango_layout_get_size (_tmp65_, &_tmp66_, &_tmp67_);
		layout_w = _tmp66_;
		layout_h = _tmp67_;
		_tmp68_ = widget_width;
		_tmp69_ = layout_w;
		layout_x = (_tmp68_ / 2.0) - ((_tmp69_ / PANGO_SCALE) / 2.0);
		_tmp70_ = widget_height;
		_tmp71_ = layout_h;
		layout_y = (_tmp70_ / 2.0) - ((_tmp71_ / PANGO_SCALE) / 2.0);
		_tmp72_ = sc;
		_tmp73_ = ct;
		_tmp74_ = layout_x;
		_tmp75_ = layout_y;
		_tmp76_ = self->priv->layout;
		gtk_render_layout (_tmp72_, _tmp73_, _tmp74_, _tmp75_, _tmp76_);
		_g_object_unref0 (sc);
	}
	_tmp77_ = ct;
	_tmp78_ = GTK_WIDGET_CLASS (media_button_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), gtk_widget_get_type (), GtkWidget), _tmp77_);
	result = _tmp78_;
	return result;
}


static gboolean media_button_button_clicked_cb (MediaButton* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (IS_MEDIA_BUTTON (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ == ((guint) GDK_BUTTON_SECONDARY)) {
		Media* _tmp3_ = NULL;
		Media* _tmp4_ = NULL;
		_tmp3_ = media_button_get_media (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenu* _tmp5_ = NULL;
		GtkMenu* _tmp6_ = NULL;
		GdkEventButton* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		GdkEventButton* _tmp9_ = NULL;
		guint32 _tmp10_ = 0U;
		_tmp5_ = self->priv->menu;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = self->priv->menu;
		_tmp7_ = evt;
		_tmp8_ = _tmp7_->button;
		_tmp9_ = evt;
		_tmp10_ = _tmp9_->time;
		gtk_menu_popup (_tmp6_, NULL, NULL, NULL, NULL, _tmp8_, _tmp10_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void media_button_copy_url_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_ = NULL;
	GtkClipboard* _tmp1_ = NULL;
	GtkClipboard* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_clipboard_get_for_display (_tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = media_button_get_media (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->url;
	gtk_clipboard_set_text (clipboard, _tmp5_, -1);
	_g_object_unref0 (clipboard);
}


static void media_button_open_in_browser_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	{
		GdkScreen* _tmp0_ = NULL;
		Media* _tmp1_ = NULL;
		Media* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		guint32 _tmp5_ = 0U;
		_tmp0_ = gdk_screen_get_default ();
		_tmp1_ = media_button_get_media (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = media_get_target_url (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, _tmp4_, _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch61_g_error;
		}
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("MultiMediaWidget.vala:145: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void media_button_save_original_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	GtkFileChooserDialog* file_dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	gchar* filename = NULL;
	Media* _tmp5_ = NULL;
	Media* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkWindow* _tmp12_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = _ ("Save image");
	_tmp1_ = self->window;
	_tmp2_ = _ ("Cancel");
	_tmp3_ = _ ("Save");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, _tmp1_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp4_);
	file_dialog = _tmp4_;
	_tmp5_ = media_button_get_media (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->path;
	_tmp8_ = utils_get_file_name (_tmp7_);
	filename = _tmp8_;
	_tmp9_ = file_dialog;
	_tmp10_ = filename;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp10_);
	_tmp11_ = file_dialog;
	_tmp12_ = self->window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow), _tmp12_);
	_tmp13_ = file_dialog;
	_tmp14_ = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_dialog_get_type (), GtkDialog));
	response = _tmp14_;
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* dest = NULL;
		GtkFileChooserDialog* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* source = NULL;
		Media* _tmp21_ = NULL;
		Media* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GFile* _tmp24_ = NULL;
		GtkFileChooserDialog* _tmp29_ = NULL;
		_tmp16_ = file_dialog;
		_tmp17_ = gtk_file_chooser_get_uri (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_new_for_uri (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		dest = _tmp20_;
		_tmp21_ = media_button_get_media (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->path;
		_tmp24_ = g_file_new_for_path (_tmp23_);
		source = _tmp24_;
		{
			GFile* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			_tmp25_ = source;
			_tmp26_ = dest;
			g_file_copy (_tmp25_, _tmp26_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch62_g_error;
			}
		}
		goto __finally62;
		__catch62_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_critical ("MultiMediaWidget.vala:166: %s", _tmp28_);
			_g_error_free0 (e);
		}
		__finally62:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (source);
			_g_object_unref0 (dest);
			_g_free0 (filename);
			_g_object_unref0 (file_dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp29_ = file_dialog;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (source);
		_g_object_unref0 (dest);
	} else {
		gint _tmp30_ = 0;
		_tmp30_ = response;
		if (_tmp30_ == ((gint) GTK_RESPONSE_CANCEL)) {
			GtkFileChooserDialog* _tmp31_ = NULL;
			_tmp31_ = file_dialog;
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
		}
	}
	_g_free0 (filename);
	_g_object_unref0 (file_dialog);
}


Media* media_button_get_media (MediaButton* self) {
	Media* result;
	Media* _tmp0_ = NULL;
	g_return_val_if_fail (IS_MEDIA_BUTTON (self), NULL);
	_tmp0_ = self->priv->_media;
	result = _tmp0_;
	return result;
}


static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void media_button_set_media (MediaButton* self, Media* value) {
	Media* _tmp0_ = NULL;
	Media* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	Media* _tmp4_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp0_ = value;
	self->priv->_media = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		Media* _tmp2_ = NULL;
		_tmp2_ = self->priv->_media;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "notify::percent-loaded", (GCallback) _gtk_widget_queue_draw_g_object_notify, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0);
	}
	_tmp4_ = value;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		Media* _tmp6_ = NULL;
		MediaType _tmp7_ = 0;
		_tmp6_ = value;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ == MEDIA_TYPE_IMAGE) {
			_tmp5_ = TRUE;
		} else {
			Media* _tmp8_ = NULL;
			MediaType _tmp9_ = 0;
			_tmp8_ = value;
			_tmp9_ = _tmp8_->type;
			_tmp5_ = _tmp9_ == MEDIA_TYPE_GIF;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GMenu* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GMenu* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp10_ = self->priv->menu_model;
		_tmp11_ = _ ("Copy URL");
		g_menu_append (_tmp10_, _tmp11_, "media.copy-url");
		_tmp12_ = self->priv->menu_model;
		_tmp13_ = _ ("Save Original");
		g_menu_append (_tmp12_, _tmp13_, "media.save-original");
	}
	g_object_notify ((GObject *) self, "media");
}


static void media_button_class_init (MediaButtonClass * klass) {
	GError * _inner_error_ = NULL;
	media_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaButtonPrivate));
	((GtkWidgetClass *) klass)->draw = media_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_media_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_media_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = media_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_BUTTON_MEDIA, g_param_spec_object ("media", "media", "media", TYPE_MEDIA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		cairo_surface_t* _tmp4_ = NULL;
		cairo_surface_t* _tmp5_ = NULL;
		cairo_surface_t** _tmp6_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/play.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
		_tmp3_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/play@2.png", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch63_g_error;
		}
		_tmp4_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp2_, 2, NULL);
		_tmp6_ = g_new0 (cairo_surface_t*, 2 + 1);
		_tmp6_[0] = _tmp4_;
		_tmp6_[1] = _tmp5_;
		media_button_play_icons = (_vala_array_free (media_button_play_icons, media_button_play_icons_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		media_button_play_icons = _tmp6_;
		media_button_play_icons_length1 = 2;
		_media_button_play_icons_size_ = media_button_play_icons_length1;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MultiMediaWidget.vala:60: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally63:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void media_button_instance_init (MediaButton * self) {
	self->priv = MEDIA_BUTTON_GET_PRIVATE (self);
}


static void media_button_finalize (GObject* obj) {
	MediaButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_BUTTON, MediaButton);
	_g_object_unref0 (self->priv->menu_model);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->layout);
	G_OBJECT_CLASS (media_button_parent_class)->finalize (obj);
}


GType media_button_get_type (void) {
	static volatile gsize media_button_type_id__volatile = 0;
	if (g_once_init_enter (&media_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaButton), 0, (GInstanceInitFunc) media_button_instance_init, NULL };
		GType media_button_type_id;
		media_button_type_id = g_type_register_static (gtk_button_get_type (), "MediaButton", &g_define_type_info, 0);
		g_once_init_leave (&media_button_type_id__volatile, media_button_type_id);
	}
	return media_button_type_id__volatile;
}


static void _vala_media_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MediaButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_BUTTON, MediaButton);
	switch (property_id) {
		case MEDIA_BUTTON_MEDIA:
		g_value_set_object (value, media_button_get_media (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_media_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MediaButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_BUTTON, MediaButton);
	switch (property_id) {
		case MEDIA_BUTTON_MEDIA:
		media_button_set_media (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MultiMediaWidget* multi_media_widget_construct (GType object_type, gint media_count) {
	MultiMediaWidget * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	MediaButton** _tmp2_ = NULL;
	self = (MultiMediaWidget*) g_object_new (object_type, NULL);
	_tmp0_ = media_count;
	multi_media_widget_set_media_count (self, _tmp0_);
	_tmp1_ = media_count;
	_tmp2_ = g_new0 (MediaButton*, _tmp1_ + 1);
	self->priv->media_buttons = (_vala_array_free (self->priv->media_buttons, self->priv->media_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->media_buttons = _tmp2_;
	self->priv->media_buttons_length1 = _tmp1_;
	self->priv->_media_buttons_size_ = self->priv->media_buttons_length1;
	return self;
}


MultiMediaWidget* multi_media_widget_new (gint media_count) {
	return multi_media_widget_construct (TYPE_MULTI_MEDIA_WIDGET, media_count);
}


void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1) {
	Media** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MediaButton** _tmp1_ = NULL;
	Media** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	multi_media_widget_remove_all (self);
	_tmp0_ = medias;
	_tmp0__length1 = medias_length1;
	_tmp1_ = g_new0 (MediaButton*, _tmp0__length1 + 1);
	self->priv->media_buttons = (_vala_array_free (self->priv->media_buttons, self->priv->media_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->media_buttons = _tmp1_;
	self->priv->media_buttons_length1 = _tmp0__length1;
	self->priv->_media_buttons_size_ = self->priv->media_buttons_length1;
	_tmp2_ = medias;
	_tmp2__length1 = medias_length1;
	multi_media_widget_set_media_count (self, _tmp2__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				Media** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				Media** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				Media* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				Media** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				Media* _tmp13_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = medias;
				_tmp6__length1 = medias_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = medias;
				_tmp7__length1 = medias_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				_vala_assert (_tmp9_ != NULL, "medias[i] != null");
				_tmp10_ = i;
				_tmp11_ = medias;
				_tmp11__length1 = medias_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				multi_media_widget_set_media (self, _tmp10_, _tmp13_);
			}
		}
	}
}


static void __lambda11_ (MultiMediaWidget* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp0_);
}


static void ___lambda11__gfunc (gconstpointer data, gpointer self) {
	__lambda11_ ((MultiMediaWidget*) self, (GtkWidget*) data);
}


static void multi_media_widget_remove_all (MultiMediaWidget* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	_tmp0_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	_tmp1_ = _tmp0_;
	g_list_foreach (_tmp1_, ___lambda11__gfunc, self);
	_g_list_free0 (_tmp1_);
}


static void _multi_media_widget_media_loaded_cb_media_finished_loading (Media* _sender, gpointer self) {
	multi_media_widget_media_loaded_cb ((MultiMediaWidget*) self, _sender);
}


static void _multi_media_widget_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	multi_media_widget_button_clicked_cb ((MultiMediaWidget*) self, _sender);
}


void multi_media_widget_set_media (MultiMediaWidget* self, gint index, Media* media) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	Media* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	MediaButton* button = NULL;
	MediaButton* _tmp7_ = NULL;
	MediaButton* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	MediaButton* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	MediaButton** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
	MediaButton* _tmp14_ = NULL;
	MediaButton* _tmp15_ = NULL;
	MediaButton* _tmp16_ = NULL;
	Media* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	MediaButton* _tmp28_ = NULL;
	MediaButton* _tmp29_ = NULL;
	MediaButton* _tmp30_ = NULL;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	g_return_if_fail (IS_MEDIA (media));
	_tmp0_ = index;
	_tmp1_ = self->priv->_media_count;
	_vala_assert (_tmp0_ < _tmp1_, "index < media_count");
	_tmp3_ = media;
	_tmp4_ = _tmp3_->loaded;
	if (_tmp4_) {
		Media* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = media;
		_tmp6_ = _tmp5_->invalid;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	_tmp7_ = media_button_new (NULL);
	g_object_ref_sink (_tmp7_);
	button = _tmp7_;
	_tmp8_ = button;
	_tmp9_ = index;
	g_object_set_data_full (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G_TYPE_OBJECT, GObject), "pos", (gpointer) ((gintptr) _tmp9_), NULL);
	_tmp10_ = button;
	_tmp11_ = self->window;
	_tmp10_->window = _tmp11_;
	_tmp12_ = self->priv->media_buttons;
	_tmp12__length1 = self->priv->media_buttons_length1;
	_tmp13_ = index;
	_tmp14_ = button;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (_tmp12_[_tmp13_]);
	_tmp12_[_tmp13_] = _tmp15_;
	_tmp16_ = _tmp12_[_tmp13_];
	_tmp17_ = media;
	_tmp18_ = _tmp17_->loaded;
	if (_tmp18_) {
		MediaButton** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp20_ = 0;
		MediaButton* _tmp21_ = NULL;
		Media* _tmp22_ = NULL;
		_tmp19_ = self->priv->media_buttons;
		_tmp19__length1 = self->priv->media_buttons_length1;
		_tmp20_ = index;
		_tmp21_ = _tmp19_[_tmp20_];
		_tmp22_ = media;
		media_button_set_media (_tmp21_, _tmp22_);
	} else {
		MediaButton** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gint _tmp24_ = 0;
		MediaButton* _tmp25_ = NULL;
		Media* _tmp26_ = NULL;
		Media* _tmp27_ = NULL;
		_tmp23_ = self->priv->media_buttons;
		_tmp23__length1 = self->priv->media_buttons_length1;
		_tmp24_ = index;
		_tmp25_ = _tmp23_[_tmp24_];
		_tmp26_ = media;
		media_button_set_media (_tmp25_, _tmp26_);
		_tmp27_ = media;
		g_signal_connect_object (_tmp27_, "finished-loading", (GCallback) _multi_media_widget_media_loaded_cb_media_finished_loading, self, 0);
	}
	_tmp28_ = button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp29_ = button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _multi_media_widget_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp30_ = button;
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (button);
}


static void multi_media_widget_button_clicked_cb (MultiMediaWidget* self, GtkButton* source) {
	MediaButton* mb = NULL;
	GtkButton* _tmp0_ = NULL;
	MediaButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	MediaButton* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	Media* _tmp5_ = NULL;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	g_return_if_fail (GTK_IS_BUTTON (source));
	_tmp0_ = source;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_BUTTON, MediaButton));
	mb = _tmp1_;
	_tmp3_ = mb;
	_tmp4_ = media_button_get_media (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		MediaButton* _tmp6_ = NULL;
		Media* _tmp7_ = NULL;
		Media* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = mb;
		_tmp7_ = media_button_get_media (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->loaded;
		_tmp2_ = _tmp9_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint index = 0;
		MediaButton* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		MediaButton* _tmp12_ = NULL;
		Media* _tmp13_ = NULL;
		Media* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		_tmp10_ = mb;
		_tmp11_ = g_object_get_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), "pos");
		index = (gint) ((gintptr) _tmp11_);
		_tmp12_ = mb;
		_tmp13_ = media_button_get_media (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = index;
		g_signal_emit_by_name (self, "media-clicked", _tmp14_, _tmp15_);
	}
	_g_object_unref0 (mb);
}


static void multi_media_widget_media_loaded_cb (MultiMediaWidget* self, Media* source) {
	Media* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	g_return_if_fail (IS_MEDIA (source));
	_tmp0_ = source;
	_tmp1_ = _tmp0_->invalid;
	if (_tmp1_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					gboolean _tmp6_ = FALSE;
					MediaButton** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					gint _tmp8_ = 0;
					MediaButton* _tmp9_ = NULL;
					if (!_tmp2_) {
						gint _tmp3_ = 0;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = self->priv->_media_count;
					if (!(_tmp4_ < _tmp5_)) {
						break;
					}
					_tmp7_ = self->priv->media_buttons;
					_tmp7__length1 = self->priv->media_buttons_length1;
					_tmp8_ = i;
					_tmp9_ = _tmp7_[_tmp8_];
					if (_tmp9_ != NULL) {
						MediaButton** _tmp10_ = NULL;
						gint _tmp10__length1 = 0;
						gint _tmp11_ = 0;
						MediaButton* _tmp12_ = NULL;
						Media* _tmp13_ = NULL;
						Media* _tmp14_ = NULL;
						Media* _tmp15_ = NULL;
						_tmp10_ = self->priv->media_buttons;
						_tmp10__length1 = self->priv->media_buttons_length1;
						_tmp11_ = i;
						_tmp12_ = _tmp10_[_tmp11_];
						_tmp13_ = media_button_get_media (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = source;
						_tmp6_ = _tmp14_ == _tmp15_;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						MediaButton** _tmp16_ = NULL;
						gint _tmp16__length1 = 0;
						gint _tmp17_ = 0;
						MediaButton* _tmp18_ = NULL;
						MediaButton** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						gint _tmp20_ = 0;
						MediaButton* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						_tmp16_ = self->priv->media_buttons;
						_tmp16__length1 = self->priv->media_buttons_length1;
						_tmp17_ = i;
						_tmp18_ = _tmp16_[_tmp17_];
						gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
						_tmp19_ = self->priv->media_buttons;
						_tmp19__length1 = self->priv->media_buttons_length1;
						_tmp20_ = i;
						_g_object_unref0 (_tmp19_[_tmp20_]);
						_tmp19_[_tmp20_] = NULL;
						_tmp21_ = _tmp19_[_tmp20_];
						_tmp22_ = self->priv->media_invalid_fired;
						if (!_tmp22_) {
							g_signal_emit_by_name (self, "media-invalid");
							self->priv->media_invalid_fired = TRUE;
						}
						return;
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gboolean _tmp27_ = FALSE;
				MediaButton** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gint _tmp29_ = 0;
				MediaButton* _tmp30_ = NULL;
				if (!_tmp23_) {
					gint _tmp24_ = 0;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = self->priv->_media_count;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp28_ = self->priv->media_buttons;
				_tmp28__length1 = self->priv->media_buttons_length1;
				_tmp29_ = i;
				_tmp30_ = _tmp28_[_tmp29_];
				if (_tmp30_ != NULL) {
					MediaButton** _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					gint _tmp32_ = 0;
					MediaButton* _tmp33_ = NULL;
					Media* _tmp34_ = NULL;
					Media* _tmp35_ = NULL;
					Media* _tmp36_ = NULL;
					_tmp31_ = self->priv->media_buttons;
					_tmp31__length1 = self->priv->media_buttons_length1;
					_tmp32_ = i;
					_tmp33_ = _tmp31_[_tmp32_];
					_tmp34_ = media_button_get_media (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = source;
					_tmp27_ = _tmp35_ == _tmp36_;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					MediaButton** _tmp37_ = NULL;
					gint _tmp37__length1 = 0;
					gint _tmp38_ = 0;
					MediaButton* _tmp39_ = NULL;
					_tmp37_ = self->priv->media_buttons;
					_tmp37__length1 = self->priv->media_buttons_length1;
					_tmp38_ = i;
					_tmp39_ = _tmp37_[_tmp38_];
					gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
					break;
				}
			}
		}
	}
}


gint multi_media_widget_get_media_count (MultiMediaWidget* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_MULTI_MEDIA_WIDGET (self), 0);
	_tmp0_ = self->priv->_media_count;
	result = _tmp0_;
	return result;
}


static void multi_media_widget_set_media_count (MultiMediaWidget* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_MULTI_MEDIA_WIDGET (self));
	_tmp0_ = value;
	self->priv->_media_count = _tmp0_;
	g_object_notify ((GObject *) self, "media-count");
}


static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void multi_media_widget_class_init (MultiMediaWidgetClass * klass) {
	multi_media_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MultiMediaWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_multi_media_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_multi_media_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = multi_media_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULTI_MEDIA_WIDGET_MEDIA_COUNT, g_param_spec_int ("media-count", "media-count", "media-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("media_clicked", TYPE_MULTI_MEDIA_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, TYPE_MEDIA, G_TYPE_INT);
	g_signal_new ("media_invalid", TYPE_MULTI_MEDIA_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void multi_media_widget_instance_init (MultiMediaWidget * self) {
	self->priv = MULTI_MEDIA_WIDGET_GET_PRIVATE (self);
	self->priv->_media_count = 0;
	self->priv->media_invalid_fired = FALSE;
}


static void multi_media_widget_finalize (GObject* obj) {
	MultiMediaWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget);
	self->priv->media_buttons = (_vala_array_free (self->priv->media_buttons, self->priv->media_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (multi_media_widget_parent_class)->finalize (obj);
}


GType multi_media_widget_get_type (void) {
	static volatile gsize multi_media_widget_type_id__volatile = 0;
	if (g_once_init_enter (&multi_media_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiMediaWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multi_media_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiMediaWidget), 0, (GInstanceInitFunc) multi_media_widget_instance_init, NULL };
		GType multi_media_widget_type_id;
		multi_media_widget_type_id = g_type_register_static (gtk_box_get_type (), "MultiMediaWidget", &g_define_type_info, 0);
		g_once_init_leave (&multi_media_widget_type_id__volatile, multi_media_widget_type_id);
	}
	return multi_media_widget_type_id__volatile;
}


static void _vala_multi_media_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MultiMediaWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget);
	switch (property_id) {
		case MULTI_MEDIA_WIDGET_MEDIA_COUNT:
		g_value_set_int (value, multi_media_widget_get_media_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_multi_media_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MultiMediaWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget);
	switch (property_id) {
		case MULTI_MEDIA_WIDGET_MEDIA_COUNT:
		multi_media_widget_set_media_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



