/* TweetModel.c generated by valac 0.30.0, the Vala compiler
 * generated from TweetModel.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
typedef struct _TweetModelPrivate TweetModelPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TweetModel {
	GObject parent_instance;
	TweetModelPrivate * priv;
};

struct _TweetModelClass {
	GObjectClass parent_class;
};

struct _TweetModelPrivate {
	GeeArrayList* tweets;
	gint64 min_id;
	gint64 max_id;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};


static gpointer tweet_model_parent_class = NULL;
static GListModelInterface* tweet_model_g_list_model_parent_iface = NULL;

GType tweet_model_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
#define TWEET_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_MODEL, TweetModelPrivate))
enum  {
	TWEET_MODEL_DUMMY_PROPERTY,
	TWEET_MODEL_LOWEST_ID,
	TWEET_MODEL_GREATEST_ID
};
static GType tweet_model_real_get_item_type (GListModel* base);
static GObject* tweet_model_real_get_item (GListModel* base, guint index);
static guint tweet_model_real_get_n_items (GListModel* base);
static void tweet_model_insert_sorted (TweetModel* self, Tweet* tweet);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
void tweet_model_add (TweetModel* self, Tweet* tweet);
void tweet_model_remove_last_n_visible (TweetModel* self, guint amount);
gboolean tweet_get_is_hidden (Tweet* self);
void tweet_model_clear (TweetModel* self);
void tweet_model_remove (TweetModel* self, gint64 tweet_id);
void tweet_model_remove_tweet (TweetModel* self, Tweet* t);
void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, guint reason, gboolean active);
gint64 tweet_get_user_id (Tweet* self);
void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, guint reason, gboolean active);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id);
void tweet_model_remove_tweets_above (TweetModel* self, gint64 id);
Tweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff);
gboolean tweet_model_delete_id (TweetModel* self, gint64 id, gboolean* seen);
gboolean tweet_get_seen (Tweet* self);
void tweet_set_deleted (Tweet* self, gboolean value);
gboolean tweet_get_retweeted (Tweet* self);
void tweet_set_retweeted (Tweet* self, gboolean value);
TweetModel* tweet_model_new (void);
TweetModel* tweet_model_construct (GType object_type);
gint64 tweet_model_get_lowest_id (TweetModel* self);
gint64 tweet_model_get_greatest_id (TweetModel* self);
static void tweet_model_finalize (GObject* obj);
static void _vala_tweet_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static GType tweet_model_real_get_item_type (GListModel* base) {
	TweetModel * self;
	GType result = 0UL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	result = TYPE_TWEET;
	return result;
}


static GObject* tweet_model_real_get_item (GListModel* base, guint index) {
	TweetModel * self;
	GObject* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	GeeArrayList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeArrayList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gpointer _tmp7_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= ((guint) 0), "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->tweets;
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp1_ < ((guint) _tmp4_), "index <  tweets.size");
	_tmp5_ = self->priv->tweets;
	_tmp6_ = index;
	_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), (gint) _tmp6_);
	result = G_TYPE_CHECK_INSTANCE_CAST ((Tweet*) _tmp7_, G_TYPE_OBJECT, GObject);
	return result;
}


static guint tweet_model_real_get_n_items (GListModel* base) {
	TweetModel * self;
	guint result = 0U;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	_tmp0_ = self->priv->tweets;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}


static void tweet_model_insert_sorted (TweetModel* self, Tweet* tweet) {
	gint insert_pos = 0;
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint _tmp46_ = 0;
	GeeArrayList* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	Tweet* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (IS_TWEET (tweet));
	insert_pos = -1;
	_tmp0_ = tweet;
	_tmp1_ = _tmp0_->id;
	_tmp2_ = self->priv->max_id;
	if (_tmp1_ > _tmp2_) {
		insert_pos = 0;
	} else {
		Tweet* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gint64 _tmp5_ = 0LL;
		_tmp3_ = tweet;
		_tmp4_ = _tmp3_->id;
		_tmp5_ = self->priv->min_id;
		if (_tmp4_ < _tmp5_) {
			GeeArrayList* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp6_ = self->priv->tweets;
			_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp8_ = _tmp7_;
			insert_pos = _tmp8_;
		} else {
			gint64 half = 0LL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			Tweet* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			gint64 _tmp14_ = 0LL;
			_tmp9_ = self->priv->max_id;
			_tmp10_ = self->priv->min_id;
			half = (_tmp9_ - _tmp10_) / 2;
			_tmp11_ = tweet;
			_tmp12_ = _tmp11_->id;
			_tmp13_ = self->priv->min_id;
			_tmp14_ = half;
			if (_tmp12_ > (_tmp13_ + _tmp14_)) {
				{
					gint i = 0;
					gint p = 0;
					GeeArrayList* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					i = 0;
					_tmp15_ = self->priv->tweets;
					_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp17_ = _tmp16_;
					p = _tmp17_;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							GeeArrayList* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gpointer _tmp24_ = NULL;
							Tweet* _tmp25_ = NULL;
							gint64 _tmp26_ = 0LL;
							Tweet* _tmp27_ = NULL;
							gint64 _tmp28_ = 0LL;
							gboolean _tmp29_ = FALSE;
							if (!_tmp18_) {
								gint _tmp19_ = 0;
								_tmp19_ = i;
								i = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = i;
							_tmp21_ = p;
							if (!(_tmp20_ < _tmp21_)) {
								break;
							}
							_tmp22_ = self->priv->tweets;
							_tmp23_ = i;
							_tmp24_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp23_);
							_tmp25_ = (Tweet*) _tmp24_;
							_tmp26_ = _tmp25_->id;
							_tmp27_ = tweet;
							_tmp28_ = _tmp27_->id;
							_tmp29_ = _tmp26_ < _tmp28_;
							_g_object_unref0 (_tmp25_);
							if (_tmp29_) {
								gint _tmp30_ = 0;
								_tmp30_ = i;
								insert_pos = _tmp30_;
								break;
							}
						}
					}
				}
			} else {
				{
					gint i = 0;
					GeeArrayList* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					_tmp31_ = self->priv->tweets;
					_tmp32_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp33_ = _tmp32_;
					i = _tmp33_ - 1;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							gint _tmp36_ = 0;
							GeeArrayList* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gpointer _tmp39_ = NULL;
							Tweet* _tmp40_ = NULL;
							gint64 _tmp41_ = 0LL;
							Tweet* _tmp42_ = NULL;
							gint64 _tmp43_ = 0LL;
							gboolean _tmp44_ = FALSE;
							if (!_tmp34_) {
								gint _tmp35_ = 0;
								_tmp35_ = i;
								i = _tmp35_ - 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = i;
							if (!(_tmp36_ >= 0)) {
								break;
							}
							_tmp37_ = self->priv->tweets;
							_tmp38_ = i;
							_tmp39_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp38_);
							_tmp40_ = (Tweet*) _tmp39_;
							_tmp41_ = _tmp40_->id;
							_tmp42_ = tweet;
							_tmp43_ = _tmp42_->id;
							_tmp44_ = _tmp41_ <= _tmp43_;
							_g_object_unref0 (_tmp40_);
							if (_tmp44_) {
								gint _tmp45_ = 0;
								_tmp45_ = i;
								insert_pos = _tmp45_;
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp46_ = insert_pos;
	_vala_assert (_tmp46_ != -1, "insert_pos != -1");
	_tmp47_ = self->priv->tweets;
	_tmp48_ = insert_pos;
	_tmp49_ = tweet;
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp48_, _tmp49_);
	_tmp50_ = insert_pos;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp50_, (guint) 0, (guint) 1);
}


void tweet_model_add (TweetModel* self, Tweet* tweet) {
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	Tweet* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (IS_TWEET (tweet));
	_tmp0_ = tweet;
	tweet_model_insert_sorted (self, _tmp0_);
	_tmp1_ = tweet;
	_tmp2_ = _tmp1_->id;
	_tmp3_ = self->priv->max_id;
	if (_tmp2_ > _tmp3_) {
		Tweet* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		_tmp4_ = tweet;
		_tmp5_ = _tmp4_->id;
		self->priv->max_id = _tmp5_;
	}
	_tmp6_ = tweet;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = self->priv->min_id;
	if (_tmp7_ < _tmp8_) {
		Tweet* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp9_ = tweet;
		_tmp10_ = _tmp9_->id;
		self->priv->min_id = _tmp10_;
	}
}


void tweet_model_remove_last_n_visible (TweetModel* self, guint amount) {
	guint _tmp0_ = 0U;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	guint n_removed = 0U;
	gint index = 0;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	guint _tmp26_ = 0U;
	g_return_if_fail (IS_TWEET_MODEL (self));
	_tmp0_ = amount;
	_tmp1_ = self->priv->tweets;
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp0_ < ((guint) _tmp3_), "amount < tweets.size");
	n_removed = (guint) 0;
	_tmp4_ = self->priv->tweets;
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp6_ = _tmp5_;
	index = _tmp6_ - 1;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		Tweet* tweet = NULL;
		GeeArrayList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gpointer _tmp13_ = NULL;
		Tweet* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		GeeArrayList* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gpointer _tmp20_ = NULL;
		Tweet* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp8_ = index;
		if (_tmp8_ >= 0) {
			guint _tmp9_ = 0U;
			guint _tmp10_ = 0U;
			_tmp9_ = n_removed;
			_tmp10_ = amount;
			_tmp7_ = _tmp9_ < _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp11_ = self->priv->tweets;
		_tmp12_ = index;
		_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp12_);
		tweet = (Tweet*) _tmp13_;
		_tmp14_ = tweet;
		_tmp15_ = tweet_get_is_hidden (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			guint _tmp17_ = 0U;
			_tmp17_ = n_removed;
			n_removed = _tmp17_ + 1;
		}
		_tmp18_ = self->priv->tweets;
		_tmp19_ = index;
		_tmp20_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
		_tmp21_ = (Tweet*) _tmp20_;
		_g_object_unref0 (_tmp21_);
		_tmp22_ = index;
		index = _tmp22_ - 1;
		_g_object_unref0 (tweet);
	}
	_tmp23_ = self->priv->tweets;
	_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp25_ = _tmp24_;
	_tmp26_ = n_removed;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) (_tmp25_ - 1), _tmp26_, (guint) 0);
}


void tweet_model_clear (TweetModel* self) {
	gint s = 0;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeArrayList* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	_tmp0_ = self->priv->tweets;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	s = _tmp2_;
	_tmp3_ = self->priv->tweets;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	self->priv->min_id = G_MAXINT64;
	self->priv->max_id = G_MININT64;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) 0, (guint) s, (guint) 0);
}


void tweet_model_remove (TweetModel* self, gint64 tweet_id) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	{
		gint i = 0;
		gint p = 0;
		GeeArrayList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		i = 0;
		_tmp0_ = self->priv->tweets;
		_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp2_ = _tmp1_;
		p = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeArrayList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				Tweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gboolean _tmp13_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = p;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->tweets;
				_tmp8_ = i;
				_tmp9_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp8_);
				_tmp10_ = (Tweet*) _tmp9_;
				_tmp11_ = _tmp10_->id;
				_tmp12_ = tweet_id;
				_tmp13_ = _tmp11_ == _tmp12_;
				_g_object_unref0 (_tmp10_);
				if (_tmp13_) {
					GeeArrayList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gpointer _tmp16_ = NULL;
					Tweet* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					_tmp14_ = self->priv->tweets;
					_tmp15_ = i;
					_tmp16_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp15_);
					_tmp17_ = (Tweet*) _tmp16_;
					_g_object_unref0 (_tmp17_);
					_tmp18_ = i;
					g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp18_, (guint) 1, (guint) 0);
					break;
				}
			}
		}
	}
}


void tweet_model_remove_tweet (TweetModel* self, Tweet* t) {
	gint pos = 0;
	GeeArrayList* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeArrayList* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (IS_TWEET (t));
	_tmp0_ = self->priv->tweets;
	_tmp1_ = t;
	_tmp2_ = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
	pos = _tmp2_;
	_tmp3_ = self->priv->tweets;
	_tmp4_ = t;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) pos, (guint) 1, (guint) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, guint reason, gboolean active) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	{
		GeeArrayList* _tweet_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _tweet_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tweet_index = 0;
		_tmp0_ = self->priv->tweets;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_tweet_list = _tmp1_;
		_tmp2_ = _tweet_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tweet_size = _tmp4_;
		_tweet_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Tweet* tweet = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Tweet* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			gint64 _tmp14_ = 0LL;
			_tmp5_ = _tweet_index;
			_tweet_index = _tmp5_ + 1;
			_tmp6_ = _tweet_index;
			_tmp7_ = _tweet_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _tweet_list;
			_tmp9_ = _tweet_index;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
			tweet = (Tweet*) _tmp10_;
			_tmp11_ = tweet;
			_tmp12_ = tweet_get_user_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = user_id;
			if (_tmp13_ == _tmp14_) {
				gboolean _tmp15_ = FALSE;
				Tweet* _tmp24_ = NULL;
				_tmp15_ = active;
				if (_tmp15_) {
					Tweet* _tmp16_ = NULL;
					Tweet* _tmp17_ = NULL;
					guint _tmp18_ = 0U;
					guint _tmp19_ = 0U;
					_tmp16_ = tweet;
					_tmp17_ = tweet;
					_tmp18_ = _tmp17_->hidden_flags;
					_tmp19_ = reason;
					_tmp17_->hidden_flags = _tmp18_ | _tmp19_;
				} else {
					Tweet* _tmp20_ = NULL;
					Tweet* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
					guint _tmp23_ = 0U;
					_tmp20_ = tweet;
					_tmp21_ = tweet;
					_tmp22_ = _tmp21_->hidden_flags;
					_tmp23_ = reason;
					_tmp21_->hidden_flags = _tmp22_ & (~_tmp23_);
				}
				_tmp24_ = tweet;
				g_signal_emit_by_name (_tmp24_, "hidden-flags-changed");
			}
			_g_object_unref0 (tweet);
		}
		_g_object_unref0 (_tweet_list);
	}
}


void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, guint reason, gboolean active) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	{
		GeeArrayList* _tweet_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _tweet_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tweet_index = 0;
		_tmp0_ = self->priv->tweets;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_tweet_list = _tmp1_;
		_tmp2_ = _tweet_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tweet_size = _tmp4_;
		_tweet_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Tweet* tweet = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			Tweet* _tmp12_ = NULL;
			MiniTweet* _tmp13_ = NULL;
			_tmp5_ = _tweet_index;
			_tweet_index = _tmp5_ + 1;
			_tmp6_ = _tweet_index;
			_tmp7_ = _tweet_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _tweet_list;
			_tmp9_ = _tweet_index;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
			tweet = (Tweet*) _tmp10_;
			_tmp12_ = tweet;
			_tmp13_ = _tmp12_->retweeted_tweet;
			if (_tmp13_ != NULL) {
				Tweet* _tmp14_ = NULL;
				MiniTweet* _tmp15_ = NULL;
				UserIdentity _tmp16_ = {0};
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				_tmp14_ = tweet;
				_tmp15_ = _tmp14_->source_tweet;
				_tmp16_ = _tmp15_->author;
				_tmp17_ = _tmp16_.id;
				_tmp18_ = user_id;
				_tmp11_ = _tmp17_ == _tmp18_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gboolean _tmp19_ = FALSE;
				Tweet* _tmp28_ = NULL;
				_tmp19_ = active;
				if (_tmp19_) {
					Tweet* _tmp20_ = NULL;
					Tweet* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
					guint _tmp23_ = 0U;
					_tmp20_ = tweet;
					_tmp21_ = tweet;
					_tmp22_ = _tmp21_->hidden_flags;
					_tmp23_ = reason;
					_tmp21_->hidden_flags = _tmp22_ | _tmp23_;
				} else {
					Tweet* _tmp24_ = NULL;
					Tweet* _tmp25_ = NULL;
					guint _tmp26_ = 0U;
					guint _tmp27_ = 0U;
					_tmp24_ = tweet;
					_tmp25_ = tweet;
					_tmp26_ = _tmp25_->hidden_flags;
					_tmp27_ = reason;
					_tmp25_->hidden_flags = _tmp26_ & (~_tmp27_);
				}
				_tmp28_ = tweet;
				g_signal_emit_by_name (_tmp28_, "hidden-flags-changed");
			}
			_g_object_unref0 (tweet);
		}
		_g_object_unref0 (_tweet_list);
	}
}


gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _t_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _t_index = 0;
		_tmp0_ = self->priv->tweets;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_t_list = _tmp1_;
		_tmp2_ = _t_list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_t_size = _tmp4_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Tweet* t = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Tweet* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			_tmp5_ = _t_index;
			_t_index = _tmp5_ + 1;
			_tmp6_ = _t_index;
			_tmp7_ = _t_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _t_list;
			_tmp9_ = _t_index;
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
			t = (Tweet*) _tmp10_;
			_tmp11_ = t;
			_tmp12_ = _tmp11_->id;
			_tmp13_ = tweet_id;
			if (_tmp12_ == _tmp13_) {
				result = TRUE;
				_g_object_unref0 (t);
				_g_object_unref0 (_t_list);
				return result;
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	result = FALSE;
	return result;
}


void tweet_model_remove_tweets_above (TweetModel* self, gint64 id) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GeeArrayList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GeeArrayList* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		Tweet* _tmp11_ = NULL;
		_tmp1_ = self->priv->tweets;
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		if (_tmp3_ > 0) {
			GeeArrayList* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			Tweet* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp4_ = self->priv->tweets;
			_tmp5_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
			_tmp6_ = (Tweet*) _tmp5_;
			_tmp7_ = _tmp6_->id;
			_tmp8_ = id;
			_tmp0_ = _tmp7_ >= _tmp8_;
			_g_object_unref0 (_tmp6_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp9_ = self->priv->tweets;
		_tmp10_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_tmp11_ = (Tweet*) _tmp10_;
		_g_object_unref0 (_tmp11_);
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) 0, (guint) 1, (guint) 0);
	}
}


Tweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff) {
	Tweet* result = NULL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GeeArrayList* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GeeArrayList* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gpointer _tmp8_ = NULL;
				Tweet* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint64 _tmp11_ = 0LL;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp7_);
				_tmp9_ = (Tweet*) _tmp8_;
				_tmp10_ = _tmp9_->id;
				_tmp11_ = id;
				_tmp12_ = _tmp10_ == _tmp11_;
				_g_object_unref0 (_tmp9_);
				if (_tmp12_) {
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					GeeArrayList* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp14_ = i;
					_tmp15_ = diff;
					_tmp16_ = self->priv->tweets;
					_tmp17_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
					_tmp18_ = _tmp17_;
					if ((_tmp14_ + _tmp15_) < _tmp18_) {
						gint _tmp19_ = 0;
						gint _tmp20_ = 0;
						_tmp19_ = i;
						_tmp20_ = diff;
						_tmp13_ = (_tmp19_ + _tmp20_) >= 0;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						GeeArrayList* _tmp21_ = NULL;
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
						gpointer _tmp24_ = NULL;
						_tmp21_ = self->priv->tweets;
						_tmp22_ = i;
						_tmp23_ = diff;
						_tmp24_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_ + _tmp23_);
						result = (Tweet*) _tmp24_;
						return result;
					}
					result = NULL;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


gboolean tweet_model_delete_id (TweetModel* self, gint64 id, gboolean* seen) {
	gboolean _vala_seen = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GeeArrayList* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Tweet* t = NULL;
				GeeArrayList* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gpointer _tmp8_ = NULL;
				Tweet* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint64 _tmp11_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp7_);
				t = (Tweet*) _tmp8_;
				_tmp9_ = t;
				_tmp10_ = _tmp9_->id;
				_tmp11_ = id;
				if (_tmp10_ == _tmp11_) {
					Tweet* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					Tweet* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					_tmp12_ = t;
					_tmp13_ = tweet_get_seen (_tmp12_);
					_tmp14_ = _tmp13_;
					_vala_seen = _tmp14_;
					_tmp15_ = t;
					_tmp16_ = tweet_get_is_hidden (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						Tweet* _tmp18_ = NULL;
						_tmp18_ = t;
						tweet_model_remove_tweet (self, _tmp18_);
					} else {
						Tweet* _tmp19_ = NULL;
						_tmp19_ = t;
						tweet_set_deleted (_tmp19_, TRUE);
					}
					result = TRUE;
					_g_object_unref0 (t);
					if (seen) {
						*seen = _vala_seen;
					}
					return result;
				} else {
					gboolean _tmp20_ = FALSE;
					Tweet* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
					gboolean _tmp23_ = FALSE;
					_tmp21_ = t;
					_tmp22_ = tweet_get_retweeted (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_) {
						Tweet* _tmp24_ = NULL;
						gint64 _tmp25_ = 0LL;
						gint64 _tmp26_ = 0LL;
						_tmp24_ = t;
						_tmp25_ = _tmp24_->my_retweet;
						_tmp26_ = id;
						_tmp20_ = _tmp25_ == _tmp26_;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						Tweet* _tmp27_ = NULL;
						_tmp27_ = t;
						tweet_set_retweeted (_tmp27_, FALSE);
					}
				}
				_g_object_unref0 (t);
			}
		}
	}
	_vala_seen = FALSE;
	result = FALSE;
	if (seen) {
		*seen = _vala_seen;
	}
	return result;
}


TweetModel* tweet_model_construct (GType object_type) {
	TweetModel * self = NULL;
	self = (TweetModel*) g_object_new (object_type, NULL);
	return self;
}


TweetModel* tweet_model_new (void) {
	return tweet_model_construct (TYPE_TWEET_MODEL);
}


gint64 tweet_model_get_lowest_id (TweetModel* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), 0LL);
	_tmp0_ = self->priv->min_id;
	result = _tmp0_;
	return result;
}


gint64 tweet_model_get_greatest_id (TweetModel* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), 0LL);
	_tmp0_ = self->priv->max_id;
	result = _tmp0_;
	return result;
}


static void tweet_model_class_init (TweetModelClass * klass) {
	tweet_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_MODEL_LOWEST_ID, g_param_spec_int64 ("lowest-id", "lowest-id", "lowest-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_MODEL_GREATEST_ID, g_param_spec_int64 ("greatest-id", "greatest-id", "greatest-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tweet_model_g_list_model_interface_init (GListModelInterface * iface) {
	tweet_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*)(GListModel*)) tweet_model_real_get_item_type;
	iface->get_item = (GObject* (*)(GListModel*, guint)) tweet_model_real_get_item;
	iface->get_n_items = (guint (*)(GListModel*)) tweet_model_real_get_n_items;
}


static void tweet_model_instance_init (TweetModel * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = TWEET_MODEL_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (TYPE_TWEET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->tweets = _tmp0_;
	self->priv->min_id = G_MAXINT64;
	self->priv->max_id = G_MININT64;
}


static void tweet_model_finalize (GObject* obj) {
	TweetModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_MODEL, TweetModel);
	_g_object_unref0 (self->priv->tweets);
	G_OBJECT_CLASS (tweet_model_parent_class)->finalize (obj);
}


GType tweet_model_get_type (void) {
	static volatile gsize tweet_model_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetModel), 0, (GInstanceInitFunc) tweet_model_instance_init, NULL };
		static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) tweet_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_model_type_id;
		tweet_model_type_id = g_type_register_static (G_TYPE_OBJECT, "TweetModel", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_model_type_id, g_list_model_get_type (), &g_list_model_info);
		g_once_init_leave (&tweet_model_type_id__volatile, tweet_model_type_id);
	}
	return tweet_model_type_id__volatile;
}


static void _vala_tweet_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_MODEL, TweetModel);
	switch (property_id) {
		case TWEET_MODEL_LOWEST_ID:
		g_value_set_int64 (value, tweet_model_get_lowest_id (self));
		break;
		case TWEET_MODEL_GREATEST_ID:
		g_value_set_int64 (value, tweet_model_get_greatest_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



