/* UserListEntry.c generated by valac 0.30.0, the Vala compiler
 * generated from UserListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gio/gio.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
typedef struct _UserListEntryPrivate UserListEntryPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block67Data Block67Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _UserListEntry {
	GtkListBoxRow parent_instance;
	UserListEntryPrivate * priv;
};

struct _UserListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _UserListEntryPrivate {
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkButton* settings_button;
	GtkButton* new_window_button;
	gint64 _user_id;
	Account* account;
};

struct _Block67Data {
	int _ref_count_;
	UserListEntry* self;
	Account* acc;
};

typedef void (*TwitterAvatarDownloadedFunc) (cairo_surface_t* avatar, void* user_data);

static gpointer user_list_entry_parent_class = NULL;
static ITwitterItemIface* user_list_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType user_list_entry_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LIST_ENTRY, UserListEntryPrivate))
enum  {
	USER_LIST_ENTRY_DUMMY_PROPERTY,
	USER_LIST_ENTRY_NAME,
	USER_LIST_ENTRY_SCREEN_NAME,
	USER_LIST_ENTRY_AVATAR,
	USER_LIST_ENTRY_AVATAR_SURFACE,
	USER_LIST_ENTRY_SEEN,
	USER_LIST_ENTRY_SORT_FACTOR,
	USER_LIST_ENTRY_SHOW_SETTINGS,
	USER_LIST_ENTRY_USER_ID
};
UserListEntry* user_list_entry_new_from_account (Account* acc);
UserListEntry* user_list_entry_construct_from_account (GType object_type, Account* acc);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
const gchar* account_get_screen_name (Account* self);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* value);
const gchar* account_get_name (Account* self);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
cairo_surface_t* account_get_avatar (Account* self);
void user_list_entry_set_avatar_surface (UserListEntry* self, cairo_surface_t* value);
gint64 account_get_id (Account* self);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
static void __lambda148_ (UserListEntry* self, const gchar* screen_name, const gchar* name, cairo_surface_t* nop, cairo_surface_t* avatar);
static void ___lambda148__account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self);
static void __lambda149_ (Block67Data* _data67_);
static void ___lambda149__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType corebird_get_type (void) G_GNUC_CONST;
static void __lambda150_ (UserListEntry* self, GtkWindow* window);
GType main_window_get_type (void) G_GNUC_CONST;
static void user_list_entry_update_window_button_sensitivity (UserListEntry* self, GtkWindow* window, gboolean new_value);
static void ___lambda150__gtk_application_window_added (GtkApplication* _sender, GtkWindow* window, gpointer self);
static void __lambda151_ (UserListEntry* self, GtkWindow* window);
static void ___lambda151__gtk_application_window_removed (GtkApplication* _sender, GtkWindow* window, gpointer self);
static void __lambda152_ (UserListEntry* self, gint64* old_id, gint64 new_id);
gint64 user_list_entry_get_user_id (UserListEntry* self);
static gboolean _int64_equal (const gint64* s1, const gint64* s2);
static void ___lambda152__corebird_account_window_changed (Corebird* _sender, gint64* old_id, gint64 new_id, gpointer self);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
static void user_list_entry_real_set_avatar (UserListEntry* self, const gchar* avatar_url);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
cairo_surface_t* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, gint size);
static void __lambda153_ (UserListEntry* self, cairo_surface_t* a);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda153__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self);
static gint user_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
Account* main_window_get_account (MainWindow* self);
static void user_list_entry_settings_button_clicked_cb (UserListEntry* self);
GType account_dialog_get_type (void) G_GNUC_CONST;
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
static void _user_list_entry_settings_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_list_entry_new_window_button_clicked_cb (UserListEntry* self);
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
static void _user_list_entry_new_window_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
void user_list_entry_set_avatar (UserListEntry* self, const gchar* value);
gboolean user_list_entry_get_seen (UserListEntry* self);
void user_list_entry_set_seen (UserListEntry* self, gboolean value);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void user_list_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_user_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_user_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block67Data* block67_data_ref (Block67Data* _data67_) {
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}


static void block67_data_unref (void * _userdata_) {
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		UserListEntry* self;
		self = _data67_->self;
		_g_object_unref0 (_data67_->acc);
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}


static void __lambda148_ (UserListEntry* self, const gchar* screen_name, const gchar* name, cairo_surface_t* nop, cairo_surface_t* avatar) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (nop != NULL);
	g_return_if_fail (avatar != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = g_strconcat ("@", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	user_list_entry_set_screen_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = name;
	user_list_entry_set_name (self, _tmp3_);
	_tmp4_ = avatar;
	user_list_entry_set_avatar_surface (self, _tmp4_);
}


static void ___lambda148__account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self) {
	__lambda148_ ((UserListEntry*) self, screen_name, name, avatar_small, avatar);
}


static void __lambda149_ (Block67Data* _data67_) {
	UserListEntry* self;
	Account* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	self = _data67_->self;
	_tmp0_ = _data67_->acc;
	_tmp1_ = account_get_avatar (_tmp0_);
	_tmp2_ = _tmp1_;
	user_list_entry_set_avatar_surface (self, _tmp2_);
}


static void ___lambda149__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda149_ (self);
}


static void __lambda150_ (UserListEntry* self, GtkWindow* window) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WINDOW (window));
	_tmp0_ = window;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_MAIN_WINDOW)) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = window;
		user_list_entry_update_window_button_sensitivity (self, _tmp1_, FALSE);
	}
}


static void ___lambda150__gtk_application_window_added (GtkApplication* _sender, GtkWindow* window, gpointer self) {
	__lambda150_ ((UserListEntry*) self, window);
}


static void __lambda151_ (UserListEntry* self, GtkWindow* window) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WINDOW (window));
	_tmp0_ = window;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_MAIN_WINDOW)) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = window;
		user_list_entry_update_window_button_sensitivity (self, _tmp1_, TRUE);
	}
}


static void ___lambda151__gtk_application_window_removed (GtkApplication* _sender, GtkWindow* window, gpointer self) {
	__lambda151_ ((UserListEntry*) self, window);
}


static gboolean _int64_equal (const gint64* s1, const gint64* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void __lambda152_ (UserListEntry* self, gint64* old_id, gint64 new_id) {
	gint64* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	_tmp0_ = old_id;
	_tmp1_ = self->priv->_user_id;
	if (_int64_equal (_tmp0_, &_tmp1_) == TRUE) {
		GtkButton* _tmp2_ = NULL;
		_tmp2_ = self->priv->new_window_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	} else {
		gint64 _tmp3_ = 0LL;
		gint64 _tmp4_ = 0LL;
		_tmp3_ = new_id;
		_tmp4_ = self->priv->_user_id;
		if (_tmp3_ == _tmp4_) {
			GtkButton* _tmp5_ = NULL;
			_tmp5_ = self->priv->new_window_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
		}
	}
}


static void ___lambda152__corebird_account_window_changed (Corebird* _sender, gint64* old_id, gint64 new_id, gpointer self) {
	__lambda152_ ((UserListEntry*) self, old_id, new_id);
}


UserListEntry* user_list_entry_construct_from_account (GType object_type, Account* acc) {
	UserListEntry * self = NULL;
	Block67Data* _data67_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	cairo_surface_t* _tmp11_ = NULL;
	cairo_surface_t* _tmp12_ = NULL;
	Account* _tmp13_ = NULL;
	Account* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	gint64 _tmp16_ = 0LL;
	Account* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	Corebird* cb = NULL;
	GApplication* _tmp19_ = NULL;
	Corebird* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	Account* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp24_ = 0LL;
	gboolean _tmp25_ = FALSE;
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_tmp0_ = acc;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data67_->acc);
	_data67_->acc = _tmp1_;
	self = (UserListEntry*) g_object_new (object_type, NULL);
	_data67_->self = g_object_ref (self);
	_tmp2_ = _data67_->acc;
	_tmp3_ = account_get_screen_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("@", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	user_list_entry_set_screen_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = _data67_->acc;
	_tmp8_ = account_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	user_list_entry_set_name (self, _tmp9_);
	_tmp10_ = _data67_->acc;
	_tmp11_ = account_get_avatar (_tmp10_);
	_tmp12_ = _tmp11_;
	user_list_entry_set_avatar_surface (self, _tmp12_);
	_tmp13_ = _data67_->acc;
	self->priv->account = _tmp13_;
	_tmp14_ = _data67_->acc;
	_tmp15_ = account_get_id (_tmp14_);
	_tmp16_ = _tmp15_;
	user_list_entry_set_user_id (self, _tmp16_);
	_tmp17_ = _data67_->acc;
	g_signal_connect_object (_tmp17_, "info-changed", (GCallback) ___lambda148__account_info_changed, self, 0);
	_tmp18_ = _data67_->acc;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) ___lambda149__g_object_notify, block67_data_ref (_data67_), (GClosureNotify) block67_data_unref, 0);
	_tmp19_ = g_application_get_default ();
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_COREBIRD, Corebird));
	cb = _tmp20_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (cb, gtk_application_get_type (), GtkApplication), "window-added", (GCallback) ___lambda150__gtk_application_window_added, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (cb, gtk_application_get_type (), GtkApplication), "window-removed", (GCallback) ___lambda151__gtk_application_window_removed, self, 0);
	g_signal_connect_object (cb, "account-window-changed", (GCallback) ___lambda152__corebird_account_window_changed, self, 0);
	_tmp21_ = self->priv->new_window_button;
	_tmp22_ = _data67_->acc;
	_tmp23_ = account_get_id (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = corebird_is_window_open_for_user_id (cb, _tmp24_, NULL);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), !_tmp25_);
	_g_object_unref0 (cb);
	block67_data_unref (_data67_);
	_data67_ = NULL;
	return self;
}


UserListEntry* user_list_entry_new_from_account (Account* acc) {
	return user_list_entry_construct_from_account (TYPE_USER_LIST_ENTRY, acc);
}


static void __lambda153_ (UserListEntry* self, cairo_surface_t* a) {
	AvatarWidget* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = a;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
}


static void ___lambda153__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self) {
	__lambda153_ ((UserListEntry*) self, avatar);
}


static void user_list_entry_real_set_avatar (UserListEntry* self, const gchar* avatar_url) {
	AvatarWidget* _tmp0_ = NULL;
	Twitter* _tmp1_ = NULL;
	Twitter* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = twitter_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = avatar_url;
	_tmp4_ = twitter_get_avatar (_tmp2_, _tmp3_, ___lambda153__twitter_avatar_downloaded_func, g_object_ref (self), g_object_unref, 48);
	_tmp5_ = _tmp4_;
	avatar_widget_set_surface (_tmp0_, _tmp5_);
	_cairo_surface_destroy0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
}


static gint user_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	UserListEntry * self;
	gint result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_LIST_ENTRY, UserListEntry);
	result = 0;
	return result;
}


static void user_list_entry_update_window_button_sensitivity (UserListEntry* self, GtkWindow* window, gboolean new_value) {
	GtkWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	g_return_if_fail (GTK_IS_WINDOW (window));
	_tmp0_ = window;
	_tmp1_ = main_window_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MAIN_WINDOW, MainWindow));
	_tmp2_ = _tmp1_;
	_tmp3_ = account_get_screen_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->account;
	_tmp6_ = account_get_screen_name (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp4_, _tmp7_) == 0) {
		GtkButton* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->new_window_button;
		_tmp9_ = new_value;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), _tmp9_);
	}
}


static void user_list_entry_settings_button_clicked_cb (UserListEntry* self) {
	GtkWindow* active_window = NULL;
	GApplication* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	AccountDialog* dialog = NULL;
	Account* _tmp4_ = NULL;
	AccountDialog* _tmp5_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	g_signal_emit_by_name (self, "action-clicked");
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	active_window = _tmp3_;
	_tmp4_ = self->priv->account;
	_tmp5_ = account_dialog_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), active_window);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
	_g_object_unref0 (active_window);
}


static void _user_list_entry_settings_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_list_entry_settings_button_clicked_cb ((UserListEntry*) self);
}


static void user_list_entry_new_window_button_clicked_cb (UserListEntry* self) {
	Corebird* cb = NULL;
	GApplication* _tmp0_ = NULL;
	Corebird* _tmp1_ = NULL;
	MainWindow* window = NULL;
	Account* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_COREBIRD, Corebird));
	cb = _tmp1_;
	_tmp2_ = self->priv->account;
	_tmp3_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (cb, gtk_application_get_type (), GtkApplication), _tmp2_);
	g_object_ref_sink (_tmp3_);
	window = _tmp3_;
	gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (cb, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (window, gtk_window_get_type (), GtkWindow));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (window, gtk_widget_get_type (), GtkWidget));
	g_signal_emit_by_name (self, "action-clicked");
	_g_object_unref0 (window);
	_g_object_unref0 (cb);
}


static void _user_list_entry_new_window_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_list_entry_new_window_button_clicked_cb ((UserListEntry*) self);
}


UserListEntry* user_list_entry_construct (GType object_type) {
	UserListEntry * self = NULL;
	self = (UserListEntry*) g_object_new (object_type, NULL);
	return self;
}


UserListEntry* user_list_entry_new (void) {
	return user_list_entry_construct (TYPE_USER_LIST_ENTRY);
}


void user_list_entry_set_name (UserListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = self->priv->name_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "name");
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* user_list_entry_get_screen_name (UserListEntry* self) {
	gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (IS_USER_LIST_ENTRY (self), NULL);
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
	result = _tmp3_;
	return result;
}


void user_list_entry_set_screen_name (UserListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "screen-name");
}


void user_list_entry_set_avatar (UserListEntry* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = value;
	user_list_entry_real_set_avatar (self, _tmp0_);
	g_object_notify ((GObject *) self, "avatar");
}


void user_list_entry_set_avatar_surface (UserListEntry* self, cairo_surface_t* value) {
	AvatarWidget* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = value;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "avatar-surface");
}


gboolean user_list_entry_get_seen (UserListEntry* self) {
	gboolean result;
	g_return_val_if_fail (IS_USER_LIST_ENTRY (self), FALSE);
	result = TRUE;
	return result;
}


void user_list_entry_set_seen (UserListEntry* self, gboolean value) {
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	g_object_notify ((GObject *) self, "seen");
}


static gint64 user_list_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	UserListEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_LIST_ENTRY, UserListEntry);
	result = G_MAXINT64 - 1;
	return result;
}


void user_list_entry_set_show_settings (UserListEntry* self, gboolean value) {
	GtkButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = self->priv->settings_button;
	_tmp1_ = value;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp1_);
	_tmp2_ = self->priv->new_window_button;
	_tmp3_ = value;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), _tmp3_);
	g_object_notify ((GObject *) self, "show-settings");
}


gint64 user_list_entry_get_user_id (UserListEntry* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_USER_LIST_ENTRY (self), 0LL);
	_tmp0_ = self->priv->_user_id;
	result = _tmp0_;
	return result;
}


void user_list_entry_set_user_id (UserListEntry* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (IS_USER_LIST_ENTRY (self));
	_tmp0_ = value;
	self->priv->_user_id = _tmp0_;
	g_object_notify ((GObject *) self, "user-id");
}


static void user_list_entry_class_init (UserListEntryClass * klass) {
	gint UserListEntry_private_offset;
	user_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_user_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_SCREEN_NAME, g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_AVATAR, g_param_spec_string ("avatar", "avatar", "avatar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_AVATAR_SURFACE, g_param_spec_pointer ("avatar-surface", "avatar-surface", "avatar-surface", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_SHOW_SETTINGS, g_param_spec_boolean ("show-settings", "show-settings", "show-settings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_ENTRY_USER_ID, g_param_spec_int64 ("user-id", "user-id", "user-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	UserListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/user-list-entry.ui");
	g_signal_new ("action_clicked", TYPE_USER_LIST_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, UserListEntry_private_offset + G_STRUCT_OFFSET (UserListEntryPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, UserListEntry_private_offset + G_STRUCT_OFFSET (UserListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, UserListEntry_private_offset + G_STRUCT_OFFSET (UserListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "settings_button", FALSE, UserListEntry_private_offset + G_STRUCT_OFFSET (UserListEntryPrivate, settings_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_window_button", FALSE, UserListEntry_private_offset + G_STRUCT_OFFSET (UserListEntryPrivate, new_window_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "settings_button_clicked_cb", G_CALLBACK(_user_list_entry_settings_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_window_button_clicked_cb", G_CALLBACK(_user_list_entry_new_window_button_clicked_cb_gtk_button_clicked));
}


static void user_list_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	user_list_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) user_list_entry_real_update_time_delta;
	iface->get_sort_factor = user_list_entry_real_get_sort_factor;
}


static void user_list_entry_instance_init (UserListEntry * self) {
	self->priv = USER_LIST_ENTRY_GET_PRIVATE (self);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void user_list_entry_finalize (GObject* obj) {
	UserListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LIST_ENTRY, UserListEntry);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->settings_button);
	_g_object_unref0 (self->priv->new_window_button);
	G_OBJECT_CLASS (user_list_entry_parent_class)->finalize (obj);
}


GType user_list_entry_get_type (void) {
	static volatile gsize user_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&user_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserListEntry), 0, (GInstanceInitFunc) user_list_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) user_list_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType user_list_entry_type_id;
		user_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "UserListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (user_list_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&user_list_entry_type_id__volatile, user_list_entry_type_id);
	}
	return user_list_entry_type_id__volatile;
}


static void _vala_user_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LIST_ENTRY, UserListEntry);
	switch (property_id) {
		case USER_LIST_ENTRY_SCREEN_NAME:
		g_value_take_string (value, user_list_entry_get_screen_name (self));
		break;
		case USER_LIST_ENTRY_SEEN:
		g_value_set_boolean (value, user_list_entry_get_seen (self));
		break;
		case USER_LIST_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case USER_LIST_ENTRY_USER_ID:
		g_value_set_int64 (value, user_list_entry_get_user_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_user_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LIST_ENTRY, UserListEntry);
	switch (property_id) {
		case USER_LIST_ENTRY_NAME:
		user_list_entry_set_name (self, g_value_get_string (value));
		break;
		case USER_LIST_ENTRY_SCREEN_NAME:
		user_list_entry_set_screen_name (self, g_value_get_string (value));
		break;
		case USER_LIST_ENTRY_AVATAR:
		user_list_entry_set_avatar (self, g_value_get_string (value));
		break;
		case USER_LIST_ENTRY_AVATAR_SURFACE:
		user_list_entry_set_avatar_surface (self, g_value_get_pointer (value));
		break;
		case USER_LIST_ENTRY_SEEN:
		user_list_entry_set_seen (self, g_value_get_boolean (value));
		break;
		case USER_LIST_ENTRY_SHOW_SETTINGS:
		user_list_entry_set_show_settings (self, g_value_get_boolean (value));
		break;
		case USER_LIST_ENTRY_USER_ID:
		user_list_entry_set_user_id (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



