/* DMThreadsPage.c generated by valac 0.30.0, the Vala compiler
 * generated from DMThreadsPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <cairo.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;
typedef struct _DMThreadsPagePrivate DMThreadsPagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_DM_THREAD_ENTRY (dm_thread_entry_get_type ())
#define DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntry))
#define DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))
#define IS_DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD_ENTRY))
#define IS_DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD_ENTRY))
#define DM_THREAD_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))

typedef struct _DMThreadEntry DMThreadEntry;
typedef struct _DMThreadEntryClass DMThreadEntryClass;

#define TYPE_START_CONVERSATION_ENTRY (start_conversation_entry_get_type ())
#define START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntry))
#define START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))
#define IS_START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_START_CONVERSATION_ENTRY))
#define IS_START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_START_CONVERSATION_ENTRY))
#define START_CONVERSATION_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))

typedef struct _StartConversationEntry StartConversationEntry;
typedef struct _StartConversationEntryClass StartConversationEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DMThreadEntryPrivate DMThreadEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;
typedef struct _Block18Data Block18Data;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;
typedef struct _Block19Data Block19Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _DMThreadsPage {
	ScrollWidget parent_instance;
	DMThreadsPagePrivate * priv;
};

struct _DMThreadsPageClass {
	ScrollWidgetClass parent_class;
};

struct _DMThreadsPagePrivate {
	gboolean initialized;
	gint _unread_count;
	MainWindow* _main_window;
	Account* _account;
	DeltaUpdater* _delta_updater;
	gint _id;
	BadgeRadioToolButton* tool_button;
	GeeHashMap* thread_map;
	StartConversationEntry* start_conversation_entry;
	gint64 max_received_id;
	gint64 max_sent_id;
	GtkListBox* thread_list;
	GtkSpinner* progress_spinner;
	Collect* dm_download_collect;
};

struct _DMThreadEntry {
	GtkListBoxRow parent_instance;
	DMThreadEntryPrivate * priv;
	gchar* notification_id;
};

struct _DMThreadEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block17Data {
	int _ref_count_;
	DMThreadsPage* self;
	DMThreadEntry* entry;
};

typedef void (*TwitterAvatarDownloadedFunc) (cairo_surface_t* avatar, void* user_data);
struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _Block18Data {
	int _ref_count_;
	DMThreadsPage* self;
	TextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
	DMThreadEntry* thread_entry;
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;

struct _Block19Data {
	int _ref_count_;
	DMThreadsPage* self;
	TextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};


static gpointer dm_threads_page_parent_class = NULL;
static IPageIface* dm_threads_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* dm_threads_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType dm_threads_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType dm_thread_entry_get_type (void) G_GNUC_CONST;
GType start_conversation_entry_get_type (void) G_GNUC_CONST;
GType collect_get_type (void) G_GNUC_CONST;
#define DM_THREADS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_THREADS_PAGE, DMThreadsPagePrivate))
enum  {
	DM_THREADS_PAGE_DUMMY_PROPERTY,
	DM_THREADS_PAGE_UNREAD_COUNT,
	DM_THREADS_PAGE_MAIN_WINDOW,
	DM_THREADS_PAGE_ACCOUNT,
	DM_THREADS_PAGE_DELTA_UPDATER,
	DM_THREADS_PAGE_ID
};
guint utils_int64_hash_func (gint64* k);
static guint _utils_int64_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean utils_int64_equal_func (gint64* a, gint64* b);
static gboolean _utils_int64_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gboolean dm_thread_entry_equal_func (DMThreadEntry* a, DMThreadEntry* b);
static gboolean _dm_thread_entry_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint64* _int64_dup (gint64* self);
DMThreadsPage* dm_threads_page_new (gint id, Account* account);
DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void ipage_set_account (IPage* self, Account* value);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint dm_thread_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
static gint _dm_thread_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void __lambda105_ (DMThreadsPage* self, GtkListBoxRow* row);
void start_conversation_entry_reveal (StartConversationEntry* self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
gint64 dm_thread_entry_get_user_id (DMThreadEntry* self);
MainWindow* ipage_get_main_window (IPage* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda105__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
StartConversationEntry* start_conversation_entry_new (Account* account);
StartConversationEntry* start_conversation_entry_construct (GType object_type, Account* account);
static void __lambda106_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url);
gint dm_threads_page_get_unread_count (DMThreadsPage* self);
gint dm_thread_entry_get_unread_count (DMThreadEntry* self);
void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
static void ___lambda106__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self);
static void dm_threads_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void dm_threads_page_add_new_thread (DMThreadsPage* self, JsonObject* dm_obj);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id);
static void dm_threads_page_real_on_join (IPage* base, gint page_id, Bundle* args);
void dm_threads_page_load_cached (DMThreadsPage* self);
void dm_threads_page_load_newest (DMThreadsPage* self);
static void dm_threads_page_real_on_leave (IPage* base);
void start_conversation_entry_unreveal (StartConversationEntry* self);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
SqlDatabase* account_get_db (Account* self);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda121_ (DMThreadsPage* self, gchar** vals, int vals_length1);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
DMThreadEntry* dm_thread_entry_new (gint64 user_id);
DMThreadEntry* dm_thread_entry_construct (GType object_type, gint64 user_id);
void dm_thread_entry_set_screen_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_last_message (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_last_message_id (DMThreadEntry* self, gint64 value);
void dm_thread_entry_set_unread_count (DMThreadEntry* self, gint value);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
cairo_surface_t* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, gint size);
static void __lambda122_ (Block17Data* _data17_, cairo_surface_t* a);
void dm_thread_entry_set_avatar (DMThreadEntry* self, cairo_surface_t* value);
static void ___lambda122__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self);
static gboolean ___lambda121__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void __lambda123_ (DMThreadsPage* self);
static void dm_threads_page_remove_spinner (DMThreadsPage* self);
static void dm_threads_page_save_last_messages (DMThreadsPage* self);
static void ___lambda123__collect_finished (Collect* _sender, GError* _error_, gpointer self);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda124_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res);
static void dm_threads_page_on_dm_result (DMThreadsPage* self, JsonNode* root);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda124__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda126_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res);
static void ___lambda126__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void collect_emit (Collect* self, GError* _error_);
void sql_database_begin_transaction (SqlDatabase* self);
static void ___lambda125_ (DMThreadsPage* self, JsonArray* arr, guint pos, JsonNode* node);
static void dm_threads_page_save_message (DMThreadsPage* self, JsonObject* dm_obj);
static void ____lambda125__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void sql_database_end_transaction (SqlDatabase* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void _vala_TextEntity_array_free (TextEntity* array, gint array_length);
static void block18_data_unref (void * _userdata_);
gint64 dm_thread_entry_get_last_message_id (DMThreadEntry* self);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_vali64 (SqlUpdateStatement* self, const gchar* col_name, gint64 col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static gchar* dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThreadEntry* thread_entry, const gchar* msg_text);
gchar* utils_unescape_html (const gchar* input);
static void __lambda119_ (Block18Data* _data18_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda119__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType transform_flags_get_type (void) G_GNUC_CONST;
gchar* text_transform_transform (const gchar* text, TextEntity* entities, int entities_length1, TransformFlags flags, guint media_count, gint64 quote_id);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
const gchar* dm_thread_entry_get_last_message (DMThreadEntry* self);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
static void __lambda120_ (Block18Data* _data18_, cairo_surface_t* a);
static void ___lambda120__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void ___lambda107_ (Block19Data* _data19_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda107__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GDateTime* utils_parse_date (const gchar* input);
gboolean settings_notify_new_dms (void);
const gchar* dm_thread_entry_get_screen_name (DMThreadEntry* self);
const gchar* dm_thread_entry_get_name (DMThreadEntry* self);
static void dm_threads_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* dm_threads_page_real_get_tool_button (IPage* base);
gint main_window_get_cur_page_id (MainWindow* self);
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType dm_page_get_type (void) G_GNUC_CONST;
static gchar* dm_threads_page_real_get_title (IPage* base);
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
void badge_radio_tool_button_set_show_badge (BadgeRadioToolButton* self, gboolean value);
DeltaUpdater* dm_threads_page_get_delta_updater (DMThreadsPage* self);
void dm_threads_page_set_delta_updater (DMThreadsPage* self, DeltaUpdater* value);
static void dm_threads_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static guint _utils_int64_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = utils_int64_hash_func ((gint64*) v);
	return result;
}


static gboolean _utils_int64_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = utils_int64_equal_func ((gint64*) a, (gint64*) b);
	return result;
}


static gboolean _dm_thread_entry_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = dm_thread_entry_equal_func ((DMThreadEntry*) a, (DMThreadEntry*) b);
	return result;
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static gint _dm_thread_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = dm_thread_entry_sort_func (row1, row2);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda105_ (DMThreadsPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_START_CONVERSATION_ENTRY)) {
		GtkListBoxRow* _tmp1_ = NULL;
		_tmp1_ = row;
		start_conversation_entry_reveal (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_START_CONVERSATION_ENTRY, StartConversationEntry));
	} else {
		GtkListBoxRow* _tmp2_ = NULL;
		_tmp2_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DM_THREAD_ENTRY)) {
			DMThreadEntry* entry = NULL;
			GtkListBoxRow* _tmp3_ = NULL;
			DMThreadEntry* _tmp4_ = NULL;
			DMThreadEntry* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			Bundle* bundle = NULL;
			Bundle* _tmp11_ = NULL;
			Bundle* _tmp12_ = NULL;
			DMThreadEntry* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
			MainWindow* _tmp16_ = NULL;
			MainWindow* _tmp17_ = NULL;
			MainWidget* _tmp18_ = NULL;
			Bundle* _tmp19_ = NULL;
			_tmp3_ = row;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DM_THREAD_ENTRY, DMThreadEntry));
			entry = _tmp4_;
			_tmp5_ = entry;
			_tmp6_ = _tmp5_->notification_id;
			if (_tmp6_ != NULL) {
				GApplication* _tmp7_ = NULL;
				DMThreadEntry* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				DMThreadEntry* _tmp10_ = NULL;
				_tmp7_ = g_application_get_default ();
				_tmp8_ = entry;
				_tmp9_ = _tmp8_->notification_id;
				g_application_withdraw_notification (_tmp7_, _tmp9_);
				_tmp10_ = entry;
				_g_free0 (_tmp10_->notification_id);
				_tmp10_->notification_id = NULL;
			}
			_tmp11_ = bundle_new ();
			bundle = _tmp11_;
			_tmp12_ = bundle;
			_tmp13_ = entry;
			_tmp14_ = dm_thread_entry_get_user_id (_tmp13_);
			_tmp15_ = _tmp14_;
			bundle_put_int64 (_tmp12_, "sender_id", _tmp15_);
			_tmp16_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_->main_widget;
			_tmp19_ = bundle;
			main_widget_switch_page (_tmp18_, (gint) PAGE_DM, _tmp19_);
			_g_object_unref0 (bundle);
			_g_object_unref0 (entry);
		}
	}
}


static void ___lambda105__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda105_ ((DMThreadsPage*) self, row);
}


static void __lambda106_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url) {
	DMThreadEntry* thread_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	MainWindow* _tmp15_ = NULL;
	MainWindow* _tmp16_ = NULL;
	MainWidget* _tmp17_ = NULL;
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	thread_entry = _tmp3_;
	_tmp4_ = thread_entry;
	if (_tmp4_ != NULL) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		DMThreadEntry* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp5_ = dm_threads_page_get_unread_count (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = thread_entry;
		_tmp8_ = dm_thread_entry_get_unread_count (_tmp7_);
		_tmp9_ = _tmp8_;
		dm_threads_page_set_unread_count (self, _tmp6_ - _tmp9_);
	}
	_tmp10_ = bundle_new ();
	bundle = _tmp10_;
	_tmp11_ = user_id;
	bundle_put_int64 (bundle, "sender_id", _tmp11_);
	_tmp12_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp12_);
	_tmp13_ = name;
	bundle_put_string (bundle, "name", _tmp13_);
	_tmp14_ = avatar_url;
	bundle_put_string (bundle, "avatar_url", _tmp14_);
	_tmp15_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_->main_widget;
	main_widget_switch_page (_tmp17_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
	_g_object_unref0 (thread_entry);
}


static void ___lambda106__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self) {
	__lambda106_ ((DMThreadsPage*) self, user_id, screen_name, name, avatar_url);
}


DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account) {
	DMThreadsPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	Collect* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	StartConversationEntry* _tmp7_ = NULL;
	StartConversationEntry* _tmp8_ = NULL;
	GtkListBox* _tmp9_ = NULL;
	StartConversationEntry* _tmp10_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMThreadsPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp1_);
	_tmp2_ = collect_new (2);
	_g_object_unref0 (self->priv->dm_download_collect);
	self->priv->dm_download_collect = _tmp2_;
	_tmp3_ = self->priv->thread_list;
	gtk_list_box_set_header_func (_tmp3_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp4_ = self->priv->thread_list;
	gtk_list_box_set_sort_func (_tmp4_, _dm_thread_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp5_ = self->priv->thread_list;
	g_signal_connect_object (_tmp5_, "row-activated", (GCallback) ___lambda105__gtk_list_box_row_activated, self, 0);
	_tmp6_ = account;
	_tmp7_ = start_conversation_entry_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->start_conversation_entry);
	self->priv->start_conversation_entry = _tmp7_;
	_tmp8_ = self->priv->start_conversation_entry;
	g_signal_connect_object (_tmp8_, "start", (GCallback) ___lambda106__start_conversation_entry_start, self, 0);
	_tmp9_ = self->priv->thread_list;
	_tmp10_ = self->priv->start_conversation_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	return self;
}


DMThreadsPage* dm_threads_page_new (gint id, Account* account) {
	return dm_threads_page_construct (TYPE_DM_THREADS_PAGE, id, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void dm_threads_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	DMThreadsPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		gint64 sender_id = 0LL;
		JsonObject* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		Account* _tmp9_ = NULL;
		Account* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		dm_threads_page_add_new_thread (self, _tmp5_);
		_tmp6_ = obj;
		_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
		sender_id = _tmp7_;
		_tmp8_ = sender_id;
		_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp10_ = _tmp9_;
		_tmp11_ = account_get_id (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp8_ != _tmp12_) {
			gint64 _tmp13_ = 0LL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = sender_id;
			_tmp14_ = dm_threads_page_user_id_visible (self, _tmp13_);
			if (!_tmp14_) {
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				_tmp15_ = dm_threads_page_get_unread_count (self);
				_tmp16_ = _tmp15_;
				dm_threads_page_set_unread_count (self, _tmp16_ + 1);
				g_debug ("DMThreadsPage.vala:98: Increasing global unread count by 1");
			}
		}
		_json_object_unref0 (obj);
	}
}


static void dm_threads_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	DMThreadsPage * self;
	GNetworkMonitor* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_network_available (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->initialized;
	if (!_tmp2_) {
		dm_threads_page_load_cached (self);
		dm_threads_page_load_newest (self);
		self->priv->initialized = TRUE;
	}
}


static void dm_threads_page_real_on_leave (IPage* base) {
	DMThreadsPage * self;
	StartConversationEntry* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->start_conversation_entry;
	start_conversation_entry_unreveal (_tmp0_);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void __lambda122_ (Block17Data* _data17_, cairo_surface_t* a) {
	DMThreadsPage* self;
	cairo_surface_t* _tmp0_ = NULL;
	self = _data17_->self;
	g_return_if_fail (a != NULL);
	_tmp0_ = a;
	dm_thread_entry_set_avatar (_data17_->entry, _tmp0_);
}


static void ___lambda122__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self) {
	__lambda122_ (self, avatar);
}


static gboolean __lambda121_ (DMThreadsPage* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	Block17Data* _data17_;
	gint64 user_id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	DMThreadEntry* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	Twitter* _tmp13_ = NULL;
	Twitter* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	cairo_surface_t* _tmp18_ = NULL;
	GtkListBox* _tmp19_ = NULL;
	GeeHashMap* _tmp20_ = NULL;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	user_id = _tmp2_;
	_tmp3_ = dm_thread_entry_new (user_id);
	g_object_ref_sink (_tmp3_);
	_data17_->entry = _tmp3_;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	dm_thread_entry_set_screen_name (_data17_->entry, _tmp5_);
	_tmp6_ = vals;
	_tmp6__length1 = vals_length1;
	_tmp7_ = _tmp6_[5];
	dm_thread_entry_set_name (_data17_->entry, _tmp7_);
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[2];
	dm_thread_entry_set_last_message (_data17_->entry, _tmp9_);
	_tmp10_ = vals;
	_tmp10__length1 = vals_length1;
	_tmp11_ = _tmp10_[3];
	_tmp12_ = int64_parse (_tmp11_);
	dm_thread_entry_set_last_message_id (_data17_->entry, _tmp12_);
	dm_thread_entry_set_unread_count (_data17_->entry, 0);
	_tmp13_ = twitter_get ();
	_tmp14_ = _tmp13_;
	_tmp15_ = vals;
	_tmp15__length1 = vals_length1;
	_tmp16_ = _tmp15_[4];
	_tmp17_ = twitter_get_avatar (_tmp14_, _tmp16_, ___lambda122__twitter_avatar_downloaded_func, block17_data_ref (_data17_), block17_data_unref, 48);
	_tmp18_ = _tmp17_;
	dm_thread_entry_set_avatar (_data17_->entry, _tmp18_);
	_cairo_surface_destroy0 (_tmp18_);
	_g_object_unref0 (_tmp14_);
	_tmp19_ = self->priv->thread_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data17_->entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->thread_map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &user_id, _data17_->entry);
	result = TRUE;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


static gboolean ___lambda121__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda121_ ((DMThreadsPage*) self, vals, vals_length1);
	return result;
}


void dm_threads_page_load_cached (DMThreadsPage* self) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	SqlDatabase* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	SqlSelectStatement* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	SqlSelectStatement* _tmp12_ = NULL;
	SqlSelectStatement* _tmp13_ = NULL;
	SqlSelectStatement* _tmp14_ = NULL;
	SqlSelectStatement* _tmp15_ = NULL;
	SqlSelectStatement* _tmp16_ = NULL;
	SqlSelectStatement* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	Account* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	SqlDatabase* _tmp21_ = NULL;
	SqlDatabase* _tmp22_ = NULL;
	SqlSelectStatement* _tmp23_ = NULL;
	SqlSelectStatement* _tmp24_ = NULL;
	SqlSelectStatement* _tmp25_ = NULL;
	SqlSelectStatement* _tmp26_ = NULL;
	Account* _tmp27_ = NULL;
	Account* _tmp28_ = NULL;
	gint64 _tmp29_ = 0LL;
	gint64 _tmp30_ = 0LL;
	SqlSelectStatement* _tmp31_ = NULL;
	SqlSelectStatement* _tmp32_ = NULL;
	SqlSelectStatement* _tmp33_ = NULL;
	SqlSelectStatement* _tmp34_ = NULL;
	SqlSelectStatement* _tmp35_ = NULL;
	SqlSelectStatement* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	gint n_rows = 0;
	Account* _tmp38_ = NULL;
	Account* _tmp39_ = NULL;
	SqlDatabase* _tmp40_ = NULL;
	SqlDatabase* _tmp41_ = NULL;
	SqlSelectStatement* _tmp42_ = NULL;
	SqlSelectStatement* _tmp43_ = NULL;
	SqlSelectStatement* _tmp44_ = NULL;
	SqlSelectStatement* _tmp45_ = NULL;
	SqlSelectStatement* _tmp46_ = NULL;
	SqlSelectStatement* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_ = 0;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_db (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_database_select (_tmp3_, "dms");
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_cols (_tmp5_, "id", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp9_ = _tmp8_;
	_tmp10_ = account_get_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = sql_select_statement_where_eqi (_tmp7_, "to_id", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = sql_select_statement_order (_tmp13_, "id DESC");
	_tmp15_ = _tmp14_;
	_tmp16_ = sql_select_statement_limit (_tmp15_, 1);
	_tmp17_ = _tmp16_;
	_tmp18_ = sql_select_statement_once_i64 (_tmp17_);
	self->priv->max_received_id = _tmp18_;
	_sql_select_statement_unref0 (_tmp17_);
	_sql_select_statement_unref0 (_tmp15_);
	_sql_select_statement_unref0 (_tmp13_);
	_sql_select_statement_unref0 (_tmp7_);
	_sql_select_statement_unref0 (_tmp5_);
	_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp20_ = _tmp19_;
	_tmp21_ = account_get_db (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = sql_database_select (_tmp22_, "dms");
	_tmp24_ = _tmp23_;
	_tmp25_ = sql_select_statement_cols (_tmp24_, "id", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp28_ = _tmp27_;
	_tmp29_ = account_get_id (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = sql_select_statement_where_eqi (_tmp26_, "from_id", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = sql_select_statement_order (_tmp32_, "id DESC");
	_tmp34_ = _tmp33_;
	_tmp35_ = sql_select_statement_limit (_tmp34_, 1);
	_tmp36_ = _tmp35_;
	_tmp37_ = sql_select_statement_once_i64 (_tmp36_);
	self->priv->max_sent_id = _tmp37_;
	_sql_select_statement_unref0 (_tmp36_);
	_sql_select_statement_unref0 (_tmp34_);
	_sql_select_statement_unref0 (_tmp32_);
	_sql_select_statement_unref0 (_tmp26_);
	_sql_select_statement_unref0 (_tmp24_);
	_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp39_ = _tmp38_;
	_tmp40_ = account_get_db (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = sql_database_select (_tmp41_, "dm_threads");
	_tmp43_ = _tmp42_;
	_tmp44_ = sql_select_statement_cols (_tmp43_, "user_id", "screen_name", "last_message", "last_message_id", "avatar_url", "name", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = sql_select_statement_order (_tmp45_, "last_message_id");
	_tmp47_ = _tmp46_;
	_tmp48_ = sql_select_statement_run (_tmp47_, ___lambda121__sql_select_callback, self);
	_tmp49_ = _tmp48_;
	_sql_select_statement_unref0 (_tmp47_);
	_sql_select_statement_unref0 (_tmp45_);
	_sql_select_statement_unref0 (_tmp43_);
	n_rows = _tmp49_;
	_tmp51_ = n_rows;
	if (_tmp51_ == 0) {
		GNetworkMonitor* _tmp52_ = NULL;
		gboolean _tmp53_ = FALSE;
		_tmp52_ = g_network_monitor_get_default ();
		_tmp53_ = g_network_monitor_get_network_available (_tmp52_);
		_tmp50_ = _tmp53_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		GtkListBoxRow* row = NULL;
		GtkListBoxRow* _tmp54_ = NULL;
		GtkSpinner* _tmp55_ = NULL;
		GtkSpinner* _tmp56_ = NULL;
		GtkSpinner* _tmp57_ = NULL;
		GtkSpinner* _tmp58_ = NULL;
		GtkListBoxRow* _tmp59_ = NULL;
		GtkSpinner* _tmp60_ = NULL;
		GtkListBoxRow* _tmp61_ = NULL;
		GtkListBox* _tmp62_ = NULL;
		GtkListBoxRow* _tmp63_ = NULL;
		_tmp54_ = (GtkListBoxRow*) gtk_list_box_row_new ();
		g_object_ref_sink (_tmp54_);
		row = _tmp54_;
		_tmp55_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_ref_sink (_tmp55_);
		_g_object_unref0 (self->priv->progress_spinner);
		self->priv->progress_spinner = _tmp55_;
		_tmp56_ = self->priv->progress_spinner;
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_widget_get_type (), GtkWidget), 16, 16);
		_tmp57_ = self->priv->progress_spinner;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), "margin", 12, NULL);
		_tmp58_ = self->priv->progress_spinner;
		gtk_spinner_start (_tmp58_);
		_tmp59_ = row;
		_tmp60_ = self->priv->progress_spinner;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
		_tmp61_ = row;
		gtk_list_box_row_set_activatable (_tmp61_, FALSE);
		_tmp62_ = self->priv->thread_list;
		_tmp63_ = row;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (row);
	}
}


static void __lambda123_ (DMThreadsPage* self) {
	dm_threads_page_remove_spinner (self);
	dm_threads_page_save_last_messages (self);
}


static void ___lambda123__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda123_ ((DMThreadsPage*) self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda124_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_ = NULL;
		JsonNode* _tmp1_ = NULL;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch17_g_error;
		}
		dm_threads_page_on_dm_result (self, root);
		__vala_JsonNode_free0 (root);
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMThreadsPage.vala:178: %s", _tmp3_);
		dm_threads_page_on_dm_result (self, NULL);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda124__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda124_ ((DMThreadsPage*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda126_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_ = NULL;
		JsonNode* _tmp1_ = NULL;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
		dm_threads_page_on_dm_result (self, root);
		__vala_JsonNode_free0 (root);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMThreadsPage.vala:194: %s", _tmp3_);
		dm_threads_page_on_dm_result (self, NULL);
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda126__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda126_ ((DMThreadsPage*) self, source_object, res);
	g_object_unref (self);
}


void dm_threads_page_load_newest (DMThreadsPage* self) {
	Collect* _tmp0_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RestProxyCall* sent_call = NULL;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	OAuthProxy* _tmp11_ = NULL;
	OAuthProxy* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->dm_download_collect;
	g_signal_connect_object (_tmp0_, "finished", (GCallback) ___lambda123__collect_finished, self, 0);
	_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = account_get_proxy (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	call = _tmp5_;
	rest_proxy_call_set_function (call, "1.1/direct_messages.json");
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_add_param (call, "skip_status", "true");
	_tmp6_ = self->priv->max_received_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (call, "since_id", _tmp8_);
	_g_free0 (_tmp8_);
	rest_proxy_call_add_param (call, "count", "200");
	tweet_utils_load_threaded (call, ___lambda124__gasync_ready_callback, g_object_ref (self));
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = account_get_proxy (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, rest_proxy_get_type (), RestProxy));
	sent_call = _tmp13_;
	rest_proxy_call_set_function (sent_call, "1.1/direct_messages/sent.json");
	rest_proxy_call_add_param (sent_call, "skip_status", "true");
	_tmp14_ = self->priv->max_sent_id;
	_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
	_tmp16_ = _tmp15_;
	rest_proxy_call_add_param (sent_call, "since_id", _tmp16_);
	_g_free0 (_tmp16_);
	rest_proxy_call_add_param (sent_call, "count", "200");
	rest_proxy_call_set_method (sent_call, "GET");
	tweet_utils_load_threaded (sent_call, ___lambda126__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (sent_call);
	_g_object_unref0 (call);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda125_ (DMThreadsPage* self, JsonArray* arr, guint pos, JsonNode* node) {
	JsonObject* dm_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	Account* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	dm_obj = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_int_member (_tmp3_, "sender_id");
	_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = account_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp4_ == _tmp8_) {
		JsonObject* _tmp9_ = NULL;
		_tmp9_ = dm_obj;
		dm_threads_page_save_message (self, _tmp9_);
	} else {
		JsonObject* _tmp10_ = NULL;
		_tmp10_ = dm_obj;
		dm_threads_page_add_new_thread (self, _tmp10_);
	}
	_json_object_unref0 (dm_obj);
}


static void ____lambda125__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda125_ ((DMThreadsPage*) self, array, index_, element_node);
}


static void dm_threads_page_on_dm_result (DMThreadsPage* self, JsonNode* root) {
	Collect* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonArray* root_arr = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	JsonArray* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->dm_download_collect;
	collect_emit (_tmp0_, NULL);
	_tmp1_ = root;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = root;
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = _json_array_ref0 (_tmp3_);
	root_arr = _tmp4_;
	_tmp5_ = root_arr;
	_tmp6_ = json_array_get_length (_tmp5_);
	g_debug ("DMThreadsPage.vala:209: sent: %u", _tmp6_);
	_tmp7_ = root_arr;
	_tmp8_ = json_array_get_length (_tmp7_);
	if (_tmp8_ > ((guint) 0)) {
		Account* _tmp9_ = NULL;
		Account* _tmp10_ = NULL;
		SqlDatabase* _tmp11_ = NULL;
		SqlDatabase* _tmp12_ = NULL;
		JsonArray* _tmp13_ = NULL;
		Account* _tmp14_ = NULL;
		Account* _tmp15_ = NULL;
		SqlDatabase* _tmp16_ = NULL;
		SqlDatabase* _tmp17_ = NULL;
		_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp10_ = _tmp9_;
		_tmp11_ = account_get_db (_tmp10_);
		_tmp12_ = _tmp11_;
		sql_database_begin_transaction (_tmp12_);
		_tmp13_ = root_arr;
		json_array_foreach_element (_tmp13_, ____lambda125__json_array_foreach, self);
		_tmp14_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp15_ = _tmp14_;
		_tmp16_ = account_get_db (_tmp15_);
		_tmp17_ = _tmp16_;
		sql_database_end_transaction (_tmp17_);
	}
	_json_array_unref0 (root_arr);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void _vala_TextEntity_array_free (TextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			text_entity_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->thread_entry);
		_data18_->url_list = (_vala_TextEntity_array_free (_data18_->url_list, _data18_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda119_ (Block18Data* _data18_, JsonArray* arr, guint index, JsonNode* node) {
	DMThreadsPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	TextEntity* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	TextEntity _tmp15_ = {0};
	TextEntity _tmp16_ = {0};
	self = _data18_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = _data18_->url_list;
	_tmp9__length1 = _data18_->url_list_length1;
	_tmp10_ = index;
	_tmp11_ = json_array_get_int_element (indices, (guint) 0);
	_tmp12_ = json_array_get_int_element (indices, (guint) 1);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (TextEntity));
	_tmp15_.from = (guint) ((gint) _tmp11_);
	_tmp15_.to = (guint) ((gint) _tmp12_);
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp14_;
	text_entity_destroy (&_tmp9_[_tmp10_]);
	_tmp9_[_tmp10_] = _tmp15_;
	_tmp16_ = _tmp9_[_tmp10_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda119__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda119_ (self, array, index_, element_node);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda120_ (Block18Data* _data18_, cairo_surface_t* a) {
	DMThreadsPage* self;
	DMThreadEntry* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	self = _data18_->self;
	g_return_if_fail (a != NULL);
	_tmp0_ = _data18_->thread_entry;
	_tmp1_ = a;
	dm_thread_entry_set_avatar (_tmp0_, _tmp1_);
}


static void ___lambda120__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self) {
	__lambda120_ (self, avatar);
}


static void dm_threads_page_add_new_thread (DMThreadsPage* self, JsonObject* dm_obj) {
	Block18Data* _data18_;
	gint64 sender_id = 0LL;
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 message_id = 0LL;
	JsonObject* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	JsonObject* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	Account* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gchar* text = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gboolean _tmp15_ = FALSE;
	JsonArray* urls = NULL;
	JsonObject* _tmp57_ = NULL;
	JsonObject* _tmp58_ = NULL;
	JsonArray* _tmp59_ = NULL;
	JsonArray* _tmp60_ = NULL;
	JsonArray* _tmp61_ = NULL;
	guint _tmp62_ = 0U;
	TextEntity* _tmp63_ = NULL;
	JsonArray* _tmp64_ = NULL;
	gint64 _tmp65_ = 0LL;
	DMThreadEntry* _tmp66_ = NULL;
	gchar* author = NULL;
	JsonObject* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* sender_name = NULL;
	JsonObject* _tmp70_ = NULL;
	JsonObject* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	DMThreadEntry* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	DMThreadEntry* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	DMThreadEntry* _tmp78_ = NULL;
	const gchar* _tmp79_ = NULL;
	TextEntity* _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	gchar* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	DMThreadEntry* _tmp83_ = NULL;
	gint64 _tmp84_ = 0LL;
	GtkListBox* _tmp85_ = NULL;
	DMThreadEntry* _tmp86_ = NULL;
	GtkListBox* _tmp87_ = NULL;
	GeeHashMap* _tmp88_ = NULL;
	gint64 _tmp89_ = 0LL;
	DMThreadEntry* _tmp90_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp91_ = NULL;
	JsonObject* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	Account* _tmp95_ = NULL;
	Account* _tmp96_ = NULL;
	SqlDatabase* _tmp97_ = NULL;
	SqlDatabase* _tmp98_ = NULL;
	SqlInsertStatement* _tmp99_ = NULL;
	SqlInsertStatement* _tmp100_ = NULL;
	gint64 _tmp101_ = 0LL;
	SqlInsertStatement* _tmp102_ = NULL;
	SqlInsertStatement* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	SqlInsertStatement* _tmp105_ = NULL;
	SqlInsertStatement* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	SqlInsertStatement* _tmp108_ = NULL;
	SqlInsertStatement* _tmp109_ = NULL;
	DMThreadEntry* _tmp110_ = NULL;
	const gchar* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	SqlInsertStatement* _tmp113_ = NULL;
	SqlInsertStatement* _tmp114_ = NULL;
	gint64 _tmp115_ = 0LL;
	SqlInsertStatement* _tmp116_ = NULL;
	SqlInsertStatement* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	SqlInsertStatement* _tmp119_ = NULL;
	SqlInsertStatement* _tmp120_ = NULL;
	Account* _tmp121_ = NULL;
	Account* _tmp122_ = NULL;
	UserCounter* _tmp123_ = NULL;
	UserCounter* _tmp124_ = NULL;
	gint64 _tmp125_ = 0LL;
	const gchar* _tmp126_ = NULL;
	const gchar* _tmp127_ = NULL;
	DMThreadEntry* _tmp128_ = NULL;
	Twitter* _tmp129_ = NULL;
	Twitter* _tmp130_ = NULL;
	const gchar* _tmp131_ = NULL;
	cairo_surface_t* _tmp132_ = NULL;
	cairo_surface_t* _tmp133_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (dm_obj != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "sender_id");
	sender_id = _tmp1_;
	_tmp2_ = dm_obj;
	_tmp3_ = json_object_get_int_member (_tmp2_, "id");
	message_id = _tmp3_;
	_tmp4_ = dm_obj;
	dm_threads_page_save_message (self, _tmp4_);
	_tmp5_ = sender_id;
	_tmp6_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp7_ = _tmp6_;
	_tmp8_ = account_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp5_ == _tmp9_) {
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return;
	}
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = self->priv->thread_map;
	_tmp14_ = sender_id;
	_tmp15_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp14_);
	if (_tmp15_) {
		DMThreadEntry* t_e = NULL;
		GeeHashMap* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gpointer _tmp18_ = NULL;
		DMThreadEntry* _tmp19_ = NULL;
		DMThreadEntry* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		gint64 _tmp22_ = 0LL;
		gint64 _tmp23_ = 0LL;
		DMThreadEntry* _tmp24_ = NULL;
		gint64 _tmp25_ = 0LL;
		gint64 _tmp26_ = 0LL;
		gboolean _tmp27_ = FALSE;
		DMThreadEntry* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		DMThreadEntry* _tmp33_ = NULL;
		gint64 _tmp34_ = 0LL;
		Account* _tmp35_ = NULL;
		Account* _tmp36_ = NULL;
		SqlDatabase* _tmp37_ = NULL;
		SqlDatabase* _tmp38_ = NULL;
		SqlUpdateStatement* _tmp39_ = NULL;
		SqlUpdateStatement* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		SqlUpdateStatement* _tmp42_ = NULL;
		SqlUpdateStatement* _tmp43_ = NULL;
		gint64 _tmp44_ = 0LL;
		SqlUpdateStatement* _tmp45_ = NULL;
		SqlUpdateStatement* _tmp46_ = NULL;
		gint64 _tmp47_ = 0LL;
		SqlUpdateStatement* _tmp48_ = NULL;
		SqlUpdateStatement* _tmp49_ = NULL;
		DMThreadEntry* _tmp50_ = NULL;
		DMThreadEntry* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		GtkListBox* _tmp56_ = NULL;
		_tmp16_ = self->priv->thread_map;
		_tmp17_ = sender_id;
		_tmp18_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp17_);
		_tmp19_ = _g_object_ref0 ((DMThreadEntry*) _tmp18_);
		t_e = _tmp19_;
		_tmp20_ = t_e;
		_tmp21_ = dm_thread_entry_get_last_message_id (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = message_id;
		if (_tmp22_ > _tmp23_) {
			_g_object_unref0 (t_e);
			_g_free0 (text);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			return;
		}
		_tmp24_ = t_e;
		_tmp25_ = dm_thread_entry_get_user_id (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = dm_threads_page_user_id_visible (self, _tmp26_);
		if (!_tmp27_) {
			DMThreadEntry* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			_tmp28_ = t_e;
			_tmp29_ = dm_thread_entry_get_unread_count (_tmp28_);
			_tmp30_ = _tmp29_;
			dm_thread_entry_set_unread_count (_tmp28_, _tmp30_ + 1);
		}
		_tmp31_ = t_e;
		_tmp32_ = text;
		dm_thread_entry_set_last_message (_tmp31_, _tmp32_);
		_tmp33_ = t_e;
		_tmp34_ = message_id;
		dm_thread_entry_set_last_message_id (_tmp33_, _tmp34_);
		_tmp35_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp36_ = _tmp35_;
		_tmp37_ = account_get_db (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = sql_database_update (_tmp38_, "dm_threads");
		_tmp40_ = _tmp39_;
		_tmp41_ = text;
		_tmp42_ = sql_update_statement_val (_tmp40_, "last_message", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = message_id;
		_tmp45_ = sql_update_statement_vali64 (_tmp43_, "last_message_id", _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = sender_id;
		_tmp48_ = sql_update_statement_where_eqi (_tmp46_, "user_id", _tmp47_);
		_tmp49_ = _tmp48_;
		sql_update_statement_run (_tmp49_);
		_sql_update_statement_unref0 (_tmp49_);
		_sql_update_statement_unref0 (_tmp46_);
		_sql_update_statement_unref0 (_tmp43_);
		_sql_update_statement_unref0 (_tmp40_);
		_tmp50_ = t_e;
		_tmp51_ = t_e;
		_tmp52_ = text;
		_tmp53_ = utils_unescape_html (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = dm_threads_page_notify_new_dm (self, _tmp51_, _tmp54_);
		_g_free0 (_tmp50_->notification_id);
		_tmp50_->notification_id = _tmp55_;
		_g_free0 (_tmp54_);
		_tmp56_ = self->priv->thread_list;
		gtk_list_box_invalidate_sort (_tmp56_);
		_g_object_unref0 (t_e);
		_g_free0 (text);
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return;
	}
	_tmp57_ = dm_obj;
	_tmp58_ = json_object_get_object_member (_tmp57_, "entities");
	_tmp59_ = json_object_get_array_member (_tmp58_, "urls");
	_tmp60_ = _json_array_ref0 (_tmp59_);
	urls = _tmp60_;
	_tmp61_ = urls;
	_tmp62_ = json_array_get_length (_tmp61_);
	_tmp63_ = g_new0 (TextEntity, _tmp62_);
	_data18_->url_list = _tmp63_;
	_data18_->url_list_length1 = _tmp62_;
	_data18_->_url_list_size_ = _data18_->url_list_length1;
	_tmp64_ = urls;
	json_array_foreach_element (_tmp64_, ___lambda119__json_array_foreach, _data18_);
	_tmp65_ = sender_id;
	_tmp66_ = dm_thread_entry_new (_tmp65_);
	g_object_ref_sink (_tmp66_);
	_data18_->thread_entry = _tmp66_;
	_tmp67_ = dm_obj;
	_tmp68_ = json_object_get_string_member (_tmp67_, "sender_screen_name");
	_tmp69_ = g_strdup (_tmp68_);
	author = _tmp69_;
	_tmp70_ = dm_obj;
	_tmp71_ = json_object_get_object_member (_tmp70_, "sender");
	_tmp72_ = json_object_get_string_member (_tmp71_, "name");
	_tmp73_ = string_strip (_tmp72_);
	sender_name = _tmp73_;
	_tmp74_ = _data18_->thread_entry;
	_tmp75_ = sender_name;
	dm_thread_entry_set_name (_tmp74_, _tmp75_);
	_tmp76_ = _data18_->thread_entry;
	_tmp77_ = author;
	dm_thread_entry_set_screen_name (_tmp76_, _tmp77_);
	_tmp78_ = _data18_->thread_entry;
	_tmp79_ = text;
	_tmp80_ = _data18_->url_list;
	_tmp80__length1 = _data18_->url_list_length1;
	_tmp81_ = text_transform_transform (_tmp79_, _tmp80_, _tmp80__length1, TRANSFORM_FLAGS_EXPAND_LINKS, (guint) 0, (gint64) -1);
	_tmp82_ = _tmp81_;
	dm_thread_entry_set_last_message (_tmp78_, _tmp82_);
	_g_free0 (_tmp82_);
	_tmp83_ = _data18_->thread_entry;
	_tmp84_ = message_id;
	dm_thread_entry_set_last_message_id (_tmp83_, _tmp84_);
	_tmp85_ = self->priv->thread_list;
	_tmp86_ = _data18_->thread_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, gtk_widget_get_type (), GtkWidget));
	_tmp87_ = self->priv->thread_list;
	gtk_list_box_invalidate_sort (_tmp87_);
	_tmp88_ = self->priv->thread_map;
	_tmp89_ = sender_id;
	_tmp90_ = _data18_->thread_entry;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp89_, _tmp90_);
	_tmp91_ = dm_obj;
	_tmp92_ = json_object_get_object_member (_tmp91_, "sender");
	_tmp93_ = json_object_get_string_member (_tmp92_, "profile_image_url");
	_tmp94_ = g_strdup (_tmp93_);
	avatar_url = _tmp94_;
	_tmp95_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp96_ = _tmp95_;
	_tmp97_ = account_get_db (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = sql_database_insert (_tmp98_, "dm_threads");
	_tmp100_ = _tmp99_;
	_tmp101_ = sender_id;
	_tmp102_ = sql_insert_statement_vali64 (_tmp100_, "user_id", _tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = sender_name;
	_tmp105_ = sql_insert_statement_val (_tmp103_, "name", _tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = author;
	_tmp108_ = sql_insert_statement_val (_tmp106_, "screen_name", _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = _data18_->thread_entry;
	_tmp111_ = dm_thread_entry_get_last_message (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = sql_insert_statement_val (_tmp109_, "last_message", _tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = message_id;
	_tmp116_ = sql_insert_statement_vali64 (_tmp114_, "last_message_id", _tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = avatar_url;
	_tmp119_ = sql_insert_statement_val (_tmp117_, "avatar_url", _tmp118_);
	_tmp120_ = _tmp119_;
	sql_insert_statement_run (_tmp120_);
	_sql_insert_statement_unref0 (_tmp120_);
	_sql_insert_statement_unref0 (_tmp117_);
	_sql_insert_statement_unref0 (_tmp114_);
	_sql_insert_statement_unref0 (_tmp109_);
	_sql_insert_statement_unref0 (_tmp106_);
	_sql_insert_statement_unref0 (_tmp103_);
	_sql_insert_statement_unref0 (_tmp100_);
	_tmp121_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp122_ = _tmp121_;
	_tmp123_ = account_get_user_counter (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = sender_id;
	_tmp126_ = author;
	_tmp127_ = sender_name;
	user_counter_user_seen (_tmp124_, _tmp125_, _tmp126_, _tmp127_);
	_tmp128_ = _data18_->thread_entry;
	_tmp129_ = twitter_get ();
	_tmp130_ = _tmp129_;
	_tmp131_ = avatar_url;
	_tmp132_ = twitter_get_avatar (_tmp130_, _tmp131_, ___lambda120__twitter_avatar_downloaded_func, block18_data_ref (_data18_), block18_data_unref, 48);
	_tmp133_ = _tmp132_;
	dm_thread_entry_set_avatar (_tmp128_, _tmp133_);
	_cairo_surface_destroy0 (_tmp133_);
	_g_object_unref0 (_tmp130_);
	_g_free0 (avatar_url);
	_g_free0 (sender_name);
	_g_free0 (author);
	_json_array_unref0 (urls);
	_g_free0 (text);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data19_->self;
		_data19_->url_list = (_vala_TextEntity_array_free (_data19_->url_list, _data19_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}


static void ___lambda107_ (Block19Data* _data19_, JsonArray* arr, guint index, JsonNode* node) {
	DMThreadsPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	TextEntity* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	TextEntity _tmp17_ = {0};
	TextEntity _tmp18_ = {0};
	self = _data19_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = _data19_->url_list;
	_tmp9__length1 = _data19_->url_list_length1;
	_tmp10_ = index;
	_tmp11_ = json_array_get_int_element (indices, (guint) 0);
	_tmp12_ = json_array_get_int_element (indices, (guint) 1);
	_tmp13_ = expanded_url;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = json_object_get_string_member (url, "display_url");
	_tmp16_ = g_strdup (_tmp15_);
	memset (&_tmp17_, 0, sizeof (TextEntity));
	_tmp17_.from = (guint) ((gint) _tmp11_);
	_tmp17_.to = (guint) ((gint) _tmp12_);
	_g_free0 (_tmp17_.target);
	_tmp17_.target = _tmp14_;
	_g_free0 (_tmp17_.display_text);
	_tmp17_.display_text = _tmp16_;
	text_entity_destroy (&_tmp9_[_tmp10_]);
	_tmp9_[_tmp10_] = _tmp17_;
	_tmp18_ = _tmp9_[_tmp10_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda107__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda107_ (self, array, index_, element_node);
}


static void dm_threads_page_save_message (DMThreadsPage* self, JsonObject* dm_obj) {
	JsonObject* sender = NULL;
	JsonObject* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* recipient = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	gint64 sender_id = 0LL;
	JsonObject* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 dm_id = 0LL;
	JsonObject* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gchar* text = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	JsonObject* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Account* _tmp26_ = NULL;
	Account* _tmp27_ = NULL;
	SqlDatabase* _tmp28_ = NULL;
	SqlDatabase* _tmp29_ = NULL;
	SqlInsertStatement* _tmp30_ = NULL;
	SqlInsertStatement* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	SqlInsertStatement* _tmp33_ = NULL;
	SqlInsertStatement* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	SqlInsertStatement* _tmp36_ = NULL;
	SqlInsertStatement* _tmp37_ = NULL;
	JsonObject* _tmp38_ = NULL;
	gint64 _tmp39_ = 0LL;
	SqlInsertStatement* _tmp40_ = NULL;
	SqlInsertStatement* _tmp41_ = NULL;
	JsonObject* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	SqlInsertStatement* _tmp44_ = NULL;
	SqlInsertStatement* _tmp45_ = NULL;
	JsonObject* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	SqlInsertStatement* _tmp48_ = NULL;
	SqlInsertStatement* _tmp49_ = NULL;
	JsonObject* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	SqlInsertStatement* _tmp52_ = NULL;
	SqlInsertStatement* _tmp53_ = NULL;
	JsonObject* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	SqlInsertStatement* _tmp56_ = NULL;
	SqlInsertStatement* _tmp57_ = NULL;
	JsonObject* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	SqlInsertStatement* _tmp60_ = NULL;
	SqlInsertStatement* _tmp61_ = NULL;
	JsonObject* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	GDateTime* _tmp64_ = NULL;
	GDateTime* _tmp65_ = NULL;
	gint64 _tmp66_ = 0LL;
	SqlInsertStatement* _tmp67_ = NULL;
	SqlInsertStatement* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	SqlInsertStatement* _tmp70_ = NULL;
	SqlInsertStatement* _tmp71_ = NULL;
	gint64 _tmp72_ = 0LL;
	Account* _tmp73_ = NULL;
	Account* _tmp74_ = NULL;
	gint64 _tmp75_ = 0LL;
	gint64 _tmp76_ = 0LL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_object_member (_tmp0_, "sender");
	_tmp2_ = _json_object_ref0 (_tmp1_);
	sender = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_object_member (_tmp3_, "recipient");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	recipient = _tmp5_;
	_tmp6_ = dm_obj;
	_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
	sender_id = _tmp7_;
	_tmp8_ = dm_obj;
	_tmp9_ = json_object_get_int_member (_tmp8_, "id");
	dm_id = _tmp9_;
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = dm_obj;
	_tmp14_ = json_object_has_member (_tmp13_, "entities");
	if (_tmp14_) {
		Block19Data* _data19_;
		JsonArray* urls = NULL;
		JsonObject* _tmp15_ = NULL;
		JsonObject* _tmp16_ = NULL;
		JsonArray* _tmp17_ = NULL;
		JsonArray* _tmp18_ = NULL;
		JsonArray* _tmp19_ = NULL;
		guint _tmp20_ = 0U;
		TextEntity* _tmp21_ = NULL;
		JsonArray* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		TextEntity* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar* _tmp25_ = NULL;
		_data19_ = g_slice_new0 (Block19Data);
		_data19_->_ref_count_ = 1;
		_data19_->self = g_object_ref (self);
		_tmp15_ = dm_obj;
		_tmp16_ = json_object_get_object_member (_tmp15_, "entities");
		_tmp17_ = json_object_get_array_member (_tmp16_, "urls");
		_tmp18_ = _json_array_ref0 (_tmp17_);
		urls = _tmp18_;
		_tmp19_ = urls;
		_tmp20_ = json_array_get_length (_tmp19_);
		_tmp21_ = g_new0 (TextEntity, _tmp20_);
		_data19_->url_list = _tmp21_;
		_data19_->url_list_length1 = _tmp20_;
		_data19_->_url_list_size_ = _data19_->url_list_length1;
		_tmp22_ = urls;
		json_array_foreach_element (_tmp22_, ____lambda107__json_array_foreach, _data19_);
		_tmp23_ = text;
		_tmp24_ = _data19_->url_list;
		_tmp24__length1 = _data19_->url_list_length1;
		_tmp25_ = text_transform_transform (_tmp23_, _tmp24_, _tmp24__length1, 0, (guint) 0, (gint64) -1);
		_g_free0 (text);
		text = _tmp25_;
		_json_array_unref0 (urls);
		block19_data_unref (_data19_);
		_data19_ = NULL;
	}
	_tmp26_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp27_ = _tmp26_;
	_tmp28_ = account_get_db (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = sql_database_insert (_tmp29_, "dms");
	_tmp31_ = _tmp30_;
	_tmp32_ = dm_id;
	_tmp33_ = sql_insert_statement_vali64 (_tmp31_, "id", _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = sender_id;
	_tmp36_ = sql_insert_statement_vali64 (_tmp34_, "from_id", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = dm_obj;
	_tmp39_ = json_object_get_int_member (_tmp38_, "recipient_id");
	_tmp40_ = sql_insert_statement_vali64 (_tmp37_, "to_id", _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = dm_obj;
	_tmp43_ = json_object_get_string_member (_tmp42_, "sender_screen_name");
	_tmp44_ = sql_insert_statement_val (_tmp41_, "from_screen_name", _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = dm_obj;
	_tmp47_ = json_object_get_string_member (_tmp46_, "recipient_screen_name");
	_tmp48_ = sql_insert_statement_val (_tmp45_, "to_screen_name", _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = sender;
	_tmp51_ = json_object_get_string_member (_tmp50_, "name");
	_tmp52_ = sql_insert_statement_val (_tmp49_, "from_name", _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = recipient;
	_tmp55_ = json_object_get_string_member (_tmp54_, "name");
	_tmp56_ = sql_insert_statement_val (_tmp53_, "to_name", _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = sender;
	_tmp59_ = json_object_get_string_member (_tmp58_, "profile_image_url");
	_tmp60_ = sql_insert_statement_val (_tmp57_, "avatar_url", _tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = dm_obj;
	_tmp63_ = json_object_get_string_member (_tmp62_, "created_at");
	_tmp64_ = utils_parse_date (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_date_time_to_unix (_tmp65_);
	_tmp67_ = sql_insert_statement_vali64 (_tmp61_, "timestamp", _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = text;
	_tmp70_ = sql_insert_statement_val (_tmp68_, "text", _tmp69_);
	_tmp71_ = _tmp70_;
	sql_insert_statement_run (_tmp71_);
	_sql_insert_statement_unref0 (_tmp71_);
	_sql_insert_statement_unref0 (_tmp68_);
	_g_date_time_unref0 (_tmp65_);
	_sql_insert_statement_unref0 (_tmp61_);
	_sql_insert_statement_unref0 (_tmp57_);
	_sql_insert_statement_unref0 (_tmp53_);
	_sql_insert_statement_unref0 (_tmp49_);
	_sql_insert_statement_unref0 (_tmp45_);
	_sql_insert_statement_unref0 (_tmp41_);
	_sql_insert_statement_unref0 (_tmp37_);
	_sql_insert_statement_unref0 (_tmp34_);
	_sql_insert_statement_unref0 (_tmp31_);
	_tmp72_ = sender_id;
	_tmp73_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp74_ = _tmp73_;
	_tmp75_ = account_get_id (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp72_ != _tmp76_) {
		gint64 _tmp77_ = 0LL;
		_tmp77_ = dm_id;
		self->priv->max_received_id = _tmp77_;
	} else {
		gint64 _tmp78_ = 0LL;
		_tmp78_ = dm_id;
		self->priv->max_sent_id = _tmp78_;
	}
	_g_free0 (text);
	_json_object_unref0 (recipient);
	_json_object_unref0 (sender);
}


static void dm_threads_page_save_last_messages (DMThreadsPage* self) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	SqlDatabase* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	Account* _tmp30_ = NULL;
	Account* _tmp31_ = NULL;
	SqlDatabase* _tmp32_ = NULL;
	SqlDatabase* _tmp33_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_db (_tmp1_);
	_tmp3_ = _tmp2_;
	sql_database_begin_transaction (_tmp3_);
	{
		GeeIterator* _thread_entry_it = NULL;
		GeeHashMap* _tmp4_ = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeCollection* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		_tmp4_ = self->priv->thread_map;
		_tmp5_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MAP, GeeMap));
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_thread_entry_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			DMThreadEntry* thread_entry = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			Account* _tmp14_ = NULL;
			Account* _tmp15_ = NULL;
			SqlDatabase* _tmp16_ = NULL;
			SqlDatabase* _tmp17_ = NULL;
			SqlUpdateStatement* _tmp18_ = NULL;
			SqlUpdateStatement* _tmp19_ = NULL;
			DMThreadEntry* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			SqlUpdateStatement* _tmp23_ = NULL;
			SqlUpdateStatement* _tmp24_ = NULL;
			DMThreadEntry* _tmp25_ = NULL;
			gint64 _tmp26_ = 0LL;
			gint64 _tmp27_ = 0LL;
			SqlUpdateStatement* _tmp28_ = NULL;
			SqlUpdateStatement* _tmp29_ = NULL;
			_tmp10_ = _thread_entry_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _thread_entry_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			thread_entry = (DMThreadEntry*) _tmp13_;
			_tmp14_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp15_ = _tmp14_;
			_tmp16_ = account_get_db (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = sql_database_update (_tmp17_, "dm_threads");
			_tmp19_ = _tmp18_;
			_tmp20_ = thread_entry;
			_tmp21_ = dm_thread_entry_get_last_message (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = sql_update_statement_val (_tmp19_, "last_message", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = thread_entry;
			_tmp26_ = dm_thread_entry_get_user_id (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = sql_update_statement_where_eqi (_tmp24_, "user_id", _tmp27_);
			_tmp29_ = _tmp28_;
			sql_update_statement_run (_tmp29_);
			_sql_update_statement_unref0 (_tmp29_);
			_sql_update_statement_unref0 (_tmp24_);
			_sql_update_statement_unref0 (_tmp19_);
		}
		_g_object_unref0 (_thread_entry_it);
	}
	_tmp30_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp31_ = _tmp30_;
	_tmp32_ = account_get_db (_tmp31_);
	_tmp33_ = _tmp32_;
	sql_database_end_transaction (_tmp33_);
}


static void dm_threads_page_remove_spinner (DMThreadsPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkSpinner* _tmp1_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp1_ = self->priv->progress_spinner;
	if (_tmp1_ != NULL) {
		GtkSpinner* _tmp2_ = NULL;
		GtkContainer* _tmp3_ = NULL;
		GtkContainer* _tmp4_ = NULL;
		_tmp2_ = self->priv->progress_spinner;
		_tmp3_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp5_ = NULL;
		GtkListBox* _tmp6_ = NULL;
		GtkListBoxRow* _tmp7_ = NULL;
		_tmp5_ = self->priv->thread_list;
		_tmp6_ = self->priv->thread_list;
		_tmp7_ = gtk_list_box_get_row_at_index (_tmp6_, 1);
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (self->priv->progress_spinner);
		self->priv->progress_spinner = NULL;
	}
}


static gchar* dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThreadEntry* thread_entry, const gchar* msg_text) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* sender_screen_name = NULL;
	DMThreadEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint64 sender_id = 0LL;
	DMThreadEntry* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gchar* id = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* summary = NULL;
	gchar* text = NULL;
	DMThreadEntry* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GNotification* n = NULL;
	const gchar* _tmp34_ = NULL;
	GNotification* _tmp35_ = NULL;
	GNotification* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GVariant* value = NULL;
	Account* _tmp38_ = NULL;
	Account* _tmp39_ = NULL;
	gint64 _tmp40_ = 0LL;
	gint64 _tmp41_ = 0LL;
	GVariant* _tmp42_ = NULL;
	gint64 _tmp43_ = 0LL;
	GVariant* _tmp44_ = NULL;
	GVariant** _tmp45_ = NULL;
	GVariant** _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	GVariant* _tmp47_ = NULL;
	GVariant* _tmp48_ = NULL;
	GNotification* _tmp49_ = NULL;
	GVariant* _tmp50_ = NULL;
	GApplication* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	GNotification* _tmp53_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	g_return_val_if_fail (IS_DM_THREAD_ENTRY (thread_entry), NULL);
	g_return_val_if_fail (msg_text != NULL, NULL);
	_tmp0_ = settings_notify_new_dms ();
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = thread_entry;
	_tmp2_ = dm_thread_entry_get_screen_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	sender_screen_name = _tmp4_;
	_tmp5_ = thread_entry;
	_tmp6_ = dm_thread_entry_get_user_id (_tmp5_);
	_tmp7_ = _tmp6_;
	sender_id = _tmp7_;
	_tmp8_ = sender_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("new-dm-", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	id = _tmp12_;
	_tmp13_ = thread_entry;
	_tmp14_ = _tmp13_->notification_id;
	if (_tmp14_ != NULL) {
		GApplication* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		DMThreadEntry* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		const gchar* _tmp20_ = NULL;
		DMThreadEntry* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		DMThreadEntry* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp15_ = g_application_get_default ();
		_tmp16_ = id;
		g_application_withdraw_notification (_tmp15_, _tmp16_);
		_tmp17_ = thread_entry;
		_tmp18_ = dm_thread_entry_get_unread_count (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = ngettext ("%d new Message from %s", "%d new Messages from %s", (gulong) _tmp19_);
		_tmp21_ = thread_entry;
		_tmp22_ = dm_thread_entry_get_unread_count (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = thread_entry;
		_tmp25_ = dm_thread_entry_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf (_tmp20_, _tmp23_, _tmp26_);
		_g_free0 (summary);
		summary = _tmp27_;
		_tmp28_ = g_strdup ("");
		_g_free0 (text);
		text = _tmp28_;
	} else {
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp29_ = _ ("New direct message from %s");
		_tmp30_ = sender_screen_name;
		_tmp31_ = g_strdup_printf (_tmp29_, _tmp30_);
		_g_free0 (summary);
		summary = _tmp31_;
		_tmp32_ = msg_text;
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (text);
		text = _tmp33_;
	}
	_tmp34_ = summary;
	_tmp35_ = g_notification_new (_tmp34_);
	n = _tmp35_;
	_tmp36_ = n;
	_tmp37_ = text;
	g_notification_set_body (_tmp36_, _tmp37_);
	_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp39_ = _tmp38_;
	_tmp40_ = account_get_id (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_variant_new_int64 (_tmp41_);
	g_variant_ref_sink (_tmp42_);
	_tmp43_ = sender_id;
	_tmp44_ = g_variant_new_int64 (_tmp43_);
	g_variant_ref_sink (_tmp44_);
	_tmp45_ = g_new0 (GVariant*, 2 + 1);
	_tmp45_[0] = _tmp42_;
	_tmp45_[1] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 2;
	_tmp47_ = g_variant_new_tuple (_tmp46_, 2);
	g_variant_ref_sink (_tmp47_);
	_tmp48_ = _tmp47_;
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_variant_unref), NULL);
	value = _tmp48_;
	_tmp49_ = n;
	_tmp50_ = value;
	g_notification_set_default_action_and_target_value (_tmp49_, "app.show-dm-thread", _tmp50_);
	_tmp51_ = g_application_get_default ();
	_tmp52_ = id;
	_tmp53_ = n;
	g_application_send_notification (_tmp51_, _tmp52_, _tmp53_);
	result = id;
	_g_variant_unref0 (value);
	_g_object_unref0 (n);
	_g_free0 (text);
	_g_free0 (summary);
	_g_free0 (sender_screen_name);
	return result;
}


static void dm_threads_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	DMThreadsPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Direct Messages");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "corebird-dms-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tool_button);
	self->priv->tool_button = _tmp2_;
}


static GtkRadioButton* dm_threads_page_real_get_tool_button (IPage* base) {
	DMThreadsPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioToolButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), FALSE);
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = main_window_get_cur_page_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((gint) PAGE_DM)) {
		MainWindow* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		IPage* _tmp7_ = NULL;
		DMPage* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gint64 _tmp10_ = 0LL;
		_tmp5_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp6_ = _tmp5_;
		_tmp7_ = main_window_get_page (_tmp6_, (gint) PAGE_DM);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DM_PAGE, DMPage);
		_tmp9_ = _tmp8_->user_id;
		_tmp10_ = sender_id;
		_tmp0_ = _tmp9_ == _tmp10_;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* dm_threads_page_real_get_title (IPage* base) {
	DMThreadsPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = _ ("Direct Messages");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id) {
	DMThreadEntry* user_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	DMThreadEntry* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	DMThreadEntry* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	DMThreadEntry* _tmp16_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	user_entry = _tmp3_;
	_tmp4_ = user_entry;
	if (_tmp4_ == NULL) {
		gint64 _tmp5_ = 0LL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp5_ = user_id;
		_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
		_tmp7_ = _tmp6_;
		g_warning ("DMThreadsPage.vala:410: No DMThreadEntry instance for id %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (user_entry);
		return;
	}
	_tmp8_ = dm_threads_page_get_unread_count (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = user_entry;
	_tmp11_ = dm_thread_entry_get_unread_count (_tmp10_);
	_tmp12_ = _tmp11_;
	dm_threads_page_set_unread_count (self, _tmp9_ - _tmp12_);
	_tmp13_ = user_entry;
	_tmp14_ = dm_thread_entry_get_unread_count (_tmp13_);
	_tmp15_ = _tmp14_;
	g_debug ("DMThreadsPage.vala:415: unread_count -= %d", _tmp15_);
	_tmp16_ = user_entry;
	dm_thread_entry_set_unread_count (_tmp16_, 0);
	_g_object_unref0 (user_entry);
}


gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id) {
	gchar* result = NULL;
	DMThreadEntry* user_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	gchar* id = NULL;
	DMThreadEntry* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	DMThreadEntry* _tmp11_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	user_entry = _tmp3_;
	_tmp4_ = user_entry;
	if (_tmp4_ == NULL) {
		gint64 _tmp5_ = 0LL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp5_ = user_id;
		_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
		_tmp7_ = _tmp6_;
		g_warning ("DMThreadsPage.vala:422: No DMThreadEntry instance for id %s", _tmp7_);
		_g_free0 (_tmp7_);
		result = NULL;
		_g_object_unref0 (user_entry);
		return result;
	}
	_tmp8_ = user_entry;
	_tmp9_ = _tmp8_->notification_id;
	_tmp10_ = g_strdup (_tmp9_);
	id = _tmp10_;
	_tmp11_ = user_entry;
	_g_free0 (_tmp11_->notification_id);
	_tmp11_->notification_id = NULL;
	result = id;
	_g_object_unref0 (user_entry);
	return result;
}


gint dm_threads_page_get_unread_count (DMThreadsPage* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	BadgeRadioToolButton* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->_unread_count;
	_tmp1_ = value;
	g_debug ("DMThreadsPage.vala:28: Changing unread_count from %d to %d", _tmp0_, _tmp1_);
	_tmp2_ = value;
	self->priv->_unread_count = _tmp2_;
	_tmp3_ = self->priv->tool_button;
	_tmp4_ = self->priv->_unread_count;
	badge_radio_tool_button_set_show_badge (_tmp3_, _tmp4_ > 0);
	g_object_notify ((GObject *) self, "unread-count");
}


static MainWindow* dm_threads_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	DMThreadsPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_main_window (IPage* base, MainWindow* value) {
	DMThreadsPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* dm_threads_page_real_get_account (IPage* base) {
	Account* result;
	DMThreadsPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_account (IPage* base, Account* value) {
	DMThreadsPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


DeltaUpdater* dm_threads_page_get_delta_updater (DMThreadsPage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void dm_threads_page_set_delta_updater (DMThreadsPage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static gint dm_threads_page_real_get_id (IPage* base) {
	gint result;
	DMThreadsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_id (IPage* base, gint value) {
	DMThreadsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void dm_threads_page_class_init (DMThreadsPageClass * klass) {
	gint DMThreadsPage_private_offset;
	dm_threads_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMThreadsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_threads_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_threads_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_threads_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMThreadsPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-threads-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thread_list", FALSE, DMThreadsPage_private_offset + G_STRUCT_OFFSET (DMThreadsPagePrivate, thread_list));
}


static void dm_threads_page_ipage_interface_init (IPageIface * iface) {
	dm_threads_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) dm_threads_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) dm_threads_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) dm_threads_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) dm_threads_page_real_get_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) dm_threads_page_real_get_title;
	iface->get_main_window = dm_threads_page_real_get_main_window;
	iface->set_main_window = dm_threads_page_real_set_main_window;
	iface->get_account = dm_threads_page_real_get_account;
	iface->set_account = dm_threads_page_real_set_account;
	iface->get_id = dm_threads_page_real_get_id;
	iface->set_id = dm_threads_page_real_set_id;
}


static void dm_threads_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	dm_threads_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) dm_threads_page_real_stream_message_received;
}


static void dm_threads_page_instance_init (DMThreadsPage * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = DM_THREADS_PAGE_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
	self->priv->_unread_count = 0;
	_tmp0_ = gee_hash_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, g_free, TYPE_DM_THREAD_ENTRY, NULL, NULL, _utils_int64_hash_func_gee_hash_data_func, NULL, NULL, _utils_int64_equal_func_gee_equal_data_func, NULL, NULL, _dm_thread_entry_equal_func_gee_equal_data_func, NULL, NULL);
	self->priv->thread_map = _tmp0_;
	self->priv->max_received_id = (gint64) -1;
	self->priv->max_sent_id = (gint64) -1;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_threads_page_finalize (GObject* obj) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_g_object_unref0 (self->priv->tool_button);
	_g_object_unref0 (self->priv->thread_map);
	_g_object_unref0 (self->priv->start_conversation_entry);
	_g_object_unref0 (self->priv->thread_list);
	_g_object_unref0 (self->priv->progress_spinner);
	_g_object_unref0 (self->priv->dm_download_collect);
	G_OBJECT_CLASS (dm_threads_page_parent_class)->finalize (obj);
}


GType dm_threads_page_get_type (void) {
	static volatile gsize dm_threads_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_threads_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMThreadsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_threads_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMThreadsPage), 0, (GInstanceInitFunc) dm_threads_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_threads_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) dm_threads_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_threads_page_type_id;
		dm_threads_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "DMThreadsPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_threads_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_threads_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&dm_threads_page_type_id__volatile, dm_threads_page_type_id);
	}
	return dm_threads_page_type_id__volatile;
}


static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		g_value_set_int (value, dm_threads_page_get_unread_count (self));
		break;
		case DM_THREADS_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_THREADS_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_THREADS_PAGE_DELTA_UPDATER:
		g_value_set_object (value, dm_threads_page_get_delta_updater (self));
		break;
		case DM_THREADS_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		dm_threads_page_set_unread_count (self, g_value_get_int (value));
		break;
		case DM_THREADS_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_DELTA_UPDATER:
		dm_threads_page_set_delta_updater (self, g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



