#!/bin/sh
DESTDIR=$1
VERSION=$2
if [ -z "${DESTDIR}" -o -z "${VERSION}" ]
then
  echo "usage: $0 DESTDIR VERSION"
  exit 1
fi
mkdir -p -m 755 ${DESTDIR}/usr/bin
install -s -m 755 attr/.libs/attr.exe ${DESTDIR}/usr/bin
install -s -m 755 getfattr/.libs/getfattr.exe ${DESTDIR}/usr/bin
install -s -m 755 setfattr/.libs/setfattr.exe ${DESTDIR}/usr/bin
mkdir -p -m 755 ${DESTDIR}/usr/share/doc/attr
cp doc/[CP]* ${DESTDIR}/usr/share/doc/attr
chmod 644 ${DESTDIR}/usr/share/doc/attr/*
mkdir -p -m 755 ${DESTDIR}/usr/share/man/man1
mkdir -p -m 755 ${DESTDIR}/usr/share/man/man5
cp man/man1/*.1 ${DESTDIR}/usr/share/man/man1
cp man/man5/*.5 ${DESTDIR}/usr/share/man/man5
chmod 644 ${DESTDIR}/usr/share/man/man*/*
gzip ${DESTDIR}/usr/share/man/man*/*
mkdir -p -m 755 ${DESTDIR}/usr/share/locale
pushd po > /dev/null
for i in *.mo
do
  dir=`basename $i`
  mkdir -p -m 755 ${DESTDIR}/usr/share/locale/${dir}/LC_MESSAGES
  install -m 644 $i ${DESTDIR}/usr/share/locale/${dir}/LC_MESSAGES/attr.mo
done
popd > /dev/null
pushd ${DESTDIR} > /dev/null
tar cjf attr-${VERSION}.tar.bz2 usr
rm -rf usr
popd > /dev/null

mkdir -p -m 755 ${DESTDIR}/usr/lib
install -m 644 libattr/.libs/libattr.a ${DESTDIR}/usr/lib
install -m 644 libattr/.libs/libattr.dll.a ${DESTDIR}/usr/lib
mkdir -p -m 755 ${DESTDIR}/usr/include/attr
install -m 644 include/attributes.h ${DESTDIR}/usr/include/attr
install -m 644 include/error_context.h ${DESTDIR}/usr/include/attr
install -m 644 include/libattr.h ${DESTDIR}/usr/include/attr
mkdir -p -m 755 ${DESTDIR}/usr/share/man/man2
mkdir -p -m 755 ${DESTDIR}/usr/share/man/man3
cp man/man2/*.2 ${DESTDIR}/usr/share/man/man2
cp man/man3/*.3 ${DESTDIR}/usr/share/man/man3
chmod 644 ${DESTDIR}/usr/share/man/man*/*
gzip ${DESTDIR}/usr/share/man/man*/*
pushd ${DESTDIR} > /dev/null
tar cjf libattr-devel-${VERSION}.tar.bz2 usr
rm -rf usr
popd > /dev/null
mkdir -p -m 755 ${DESTDIR}/usr/bin
install -s -m 755 libattr/.libs/cygattr-1.dll ${DESTDIR}/usr/bin
pushd ${DESTDIR} > /dev/null
tar cjf libattr1-${VERSION}.tar.bz2 usr
rm -rf usr
mkdir -p attr/libattr1 attr/libattr-devel
mv libattr1*.tar.bz2 attr/libattr1
mv libattr-devel*.tar.bz2 attr/libattr-devel
mv attr*.tar.bz2 attr
cd attr
cat > setup.hint << EOF
sdesc: "Utilities for managing filesystem extended attributes"
ldesc: "A set of tools for manipulating extended attributes on filesystem
objects, in particular getfattr(1) and setfattr(1).
An attr(1) command is also provided which is largely compatible
with the SGI IRIX tool of the same name."
requires: libgcc1 libattr1
EOF
cd libattr1
cat > setup.hint << EOF
sdesc: "Shared lib for managing filesystem extended attributes"
ldesc: "Shared lib for managing filesystem extended attributes"
requires:
external-source: attr
EOF
cd ../libattr-devel
cat > setup.hint << EOF
sdesc: "Extended attribute static libraries and headers"
ldesc: "This package contains the libraries and header files needed to
develop programs which make use of extended attributes.
For Cygwin programs, the documented system call API is the
recommended interface.  This package provides the libs and headers
required to develop using the SGI IRIX compatibility interface."
requires: libattr1
external-source: attr
EOF
popd > /dev/null
