---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              inclusion de fichier, fichiers imbriqués, inclusion récursive,
              \include, \includeonly, \input
---

# Que signifie l'erreur : "`\include` cannot be nested" ?

- **Message** : `\include cannot be nested`

LaTeX a rencontré une commande `\include` à l'intérieur d'un fichier chargé
avec `\include`. En raison des contraintes d'implémentation, il est impossible
d'imbriquer ces commandes. Vous devez remplacer la commande `\include`
par une commande `\input` ou repenser la structure des fichiers 
afin que toutes les instructions `\include` soient regroupées 
dans le fichier principal du document.


:::{sources}
- [FAQ erreurs - Lettre I](https://latex.developpez.com/faq/erreurs?page=I), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::