/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformance.h"

#include "JSMemoryInfo.h"
#include "JSPerformanceNavigation.h"
#include "JSPerformanceTiming.h"
#include "MemoryInfo.h"
#include "Performance.h"
#include "PerformanceNavigation.h"
#include "PerformanceTiming.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPerformance);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPerformanceTableValues[4] =
{
    { "navigation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigation), (intptr_t)0 THUNK_GENERATOR(0) },
    { "timing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTiming), (intptr_t)0 THUNK_GENERATOR(0) },
    { "memory", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceMemory), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPerformanceTable = { 8, 7, JSPerformanceTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPerformancePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPerformancePrototypeTable = { 1, 0, JSPerformancePrototypeTableValues, 0 };
const ClassInfo JSPerformancePrototype::s_info = { "PerformancePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSPerformancePrototypeTable, 0 };

JSObject* JSPerformancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformance>(exec, globalObject);
}

const ClassInfo JSPerformance::s_info = { "Performance", &JSDOMWrapper::s_info, &JSPerformanceTable, 0 };

JSPerformance::JSPerformance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Performance> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPerformancePrototype(exec->globalData(), globalObject, JSPerformancePrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSPerformance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPerformance, Base>(exec, &JSPerformanceTable, this, propertyName, slot);
}

bool JSPerformance::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPerformance, Base>(exec, &JSPerformanceTable, this, propertyName, descriptor);
}

JSValue jsPerformanceNavigation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPerformance* castedThis = static_cast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* imp = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->navigation()));
    return result;
}


JSValue jsPerformanceTiming(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPerformance* castedThis = static_cast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* imp = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->timing()));
    return result;
}


JSValue jsPerformanceMemory(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPerformance* castedThis = static_cast<JSPerformance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Performance* imp = static_cast<Performance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->memory()));
    return result;
}


JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Performance* impl)
{
    return wrap<JSPerformance>(exec, globalObject, impl);
}

Performance* toPerformance(JSC::JSValue value)
{
    return value.inherits(&JSPerformance::s_info) ? static_cast<JSPerformance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
