--TEST--
bcadd() function
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$leftSummands = ["15", "-15", "1", "-9", "14.14", "-16.60", "0.15", "-0.01"];
$rightSummands = array_merge($leftSummands, [
    "0",
    "0.00",
    "-0",
    "-0.00",
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
]);

run_bcmath_tests($leftSummands, $rightSummands, "+", bcadd(...));

?>
--EXPECT--
Number "15" (scale 0)
15 + 15                             = 30
15 + -15                            = 0
15 + 1                              = 16
15 + -9                             = 6
15 + 14.14                          = 29
15 + -16.60                         = -1
15 + 0.15                           = 15
15 + -0.01                          = 14
15 + 0                              = 15
15 + 0.00                           = 15
15 + -0                             = 15
15 + -0.00                          = 15
15 + 15151324141414.412312232141241 = 15151324141429
15 + -132132245132134.1515123765412 = -132132245132119
15 + 141241241241241248267654747412 = 141241241241241248267654747427
15 + -149143276547656984948124912   = -149143276547656984948124897
15 + 0.1322135476547459213732911312 = 15
15 + -0.123912932193769965476541321 = 14

Number "-15" (scale 0)
-15 + 15                             = 0
-15 + -15                            = -30
-15 + 1                              = -14
-15 + -9                             = -24
-15 + 14.14                          = 0
-15 + -16.60                         = -31
-15 + 0.15                           = -14
-15 + -0.01                          = -15
-15 + 0                              = -15
-15 + 0.00                           = -15
-15 + -0                             = -15
-15 + -0.00                          = -15
-15 + 15151324141414.412312232141241 = 15151324141399
-15 + -132132245132134.1515123765412 = -132132245132149
-15 + 141241241241241248267654747412 = 141241241241241248267654747397
-15 + -149143276547656984948124912   = -149143276547656984948124927
-15 + 0.1322135476547459213732911312 = -14
-15 + -0.123912932193769965476541321 = -15

Number "1" (scale 0)
1 + 15                             = 16
1 + -15                            = -14
1 + 1                              = 2
1 + -9                             = -8
1 + 14.14                          = 15
1 + -16.60                         = -15
1 + 0.15                           = 1
1 + -0.01                          = 0
1 + 0                              = 1
1 + 0.00                           = 1
1 + -0                             = 1
1 + -0.00                          = 1
1 + 15151324141414.412312232141241 = 15151324141415
1 + -132132245132134.1515123765412 = -132132245132133
1 + 141241241241241248267654747412 = 141241241241241248267654747413
1 + -149143276547656984948124912   = -149143276547656984948124911
1 + 0.1322135476547459213732911312 = 1
1 + -0.123912932193769965476541321 = 0

Number "-9" (scale 0)
-9 + 15                             = 6
-9 + -15                            = -24
-9 + 1                              = -8
-9 + -9                             = -18
-9 + 14.14                          = 5
-9 + -16.60                         = -25
-9 + 0.15                           = -8
-9 + -0.01                          = -9
-9 + 0                              = -9
-9 + 0.00                           = -9
-9 + -0                             = -9
-9 + -0.00                          = -9
-9 + 15151324141414.412312232141241 = 15151324141405
-9 + -132132245132134.1515123765412 = -132132245132143
-9 + 141241241241241248267654747412 = 141241241241241248267654747403
-9 + -149143276547656984948124912   = -149143276547656984948124921
-9 + 0.1322135476547459213732911312 = -8
-9 + -0.123912932193769965476541321 = -9

Number "14.14" (scale 0)
14.14 + 15                             = 29
14.14 + -15                            = 0
14.14 + 1                              = 15
14.14 + -9                             = 5
14.14 + 14.14                          = 28
14.14 + -16.60                         = -2
14.14 + 0.15                           = 14
14.14 + -0.01                          = 14
14.14 + 0                              = 14
14.14 + 0.00                           = 14
14.14 + -0                             = 14
14.14 + -0.00                          = 14
14.14 + 15151324141414.412312232141241 = 15151324141428
14.14 + -132132245132134.1515123765412 = -132132245132120
14.14 + 141241241241241248267654747412 = 141241241241241248267654747426
14.14 + -149143276547656984948124912   = -149143276547656984948124897
14.14 + 0.1322135476547459213732911312 = 14
14.14 + -0.123912932193769965476541321 = 14

Number "-16.60" (scale 0)
-16.60 + 15                             = -1
-16.60 + -15                            = -31
-16.60 + 1                              = -15
-16.60 + -9                             = -25
-16.60 + 14.14                          = -2
-16.60 + -16.60                         = -33
-16.60 + 0.15                           = -16
-16.60 + -0.01                          = -16
-16.60 + 0                              = -16
-16.60 + 0.00                           = -16
-16.60 + -0                             = -16
-16.60 + -0.00                          = -16
-16.60 + 15151324141414.412312232141241 = 15151324141397
-16.60 + -132132245132134.1515123765412 = -132132245132150
-16.60 + 141241241241241248267654747412 = 141241241241241248267654747395
-16.60 + -149143276547656984948124912   = -149143276547656984948124928
-16.60 + 0.1322135476547459213732911312 = -16
-16.60 + -0.123912932193769965476541321 = -16

Number "0.15" (scale 0)
0.15 + 15                             = 15
0.15 + -15                            = -14
0.15 + 1                              = 1
0.15 + -9                             = -8
0.15 + 14.14                          = 14
0.15 + -16.60                         = -16
0.15 + 0.15                           = 0
0.15 + -0.01                          = 0
0.15 + 0                              = 0
0.15 + 0.00                           = 0
0.15 + -0                             = 0
0.15 + -0.00                          = 0
0.15 + 15151324141414.412312232141241 = 15151324141414
0.15 + -132132245132134.1515123765412 = -132132245132134
0.15 + 141241241241241248267654747412 = 141241241241241248267654747412
0.15 + -149143276547656984948124912   = -149143276547656984948124911
0.15 + 0.1322135476547459213732911312 = 0
0.15 + -0.123912932193769965476541321 = 0

Number "-0.01" (scale 0)
-0.01 + 15                             = 14
-0.01 + -15                            = -15
-0.01 + 1                              = 0
-0.01 + -9                             = -9
-0.01 + 14.14                          = 14
-0.01 + -16.60                         = -16
-0.01 + 0.15                           = 0
-0.01 + -0.01                          = 0
-0.01 + 0                              = 0
-0.01 + 0.00                           = 0
-0.01 + -0                             = 0
-0.01 + -0.00                          = 0
-0.01 + 15151324141414.412312232141241 = 15151324141414
-0.01 + -132132245132134.1515123765412 = -132132245132134
-0.01 + 141241241241241248267654747412 = 141241241241241248267654747411
-0.01 + -149143276547656984948124912   = -149143276547656984948124912
-0.01 + 0.1322135476547459213732911312 = 0
-0.01 + -0.123912932193769965476541321 = 0

Number "15" (scale 10)
15 + 15                             = 30.0000000000
15 + -15                            = 0.0000000000
15 + 1                              = 16.0000000000
15 + -9                             = 6.0000000000
15 + 14.14                          = 29.1400000000
15 + -16.60                         = -1.6000000000
15 + 0.15                           = 15.1500000000
15 + -0.01                          = 14.9900000000
15 + 0                              = 15.0000000000
15 + 0.00                           = 15.0000000000
15 + -0                             = 15.0000000000
15 + -0.00                          = 15.0000000000
15 + 15151324141414.412312232141241 = 15151324141429.4123122321
15 + -132132245132134.1515123765412 = -132132245132119.1515123765
15 + 141241241241241248267654747412 = 141241241241241248267654747427.0000000000
15 + -149143276547656984948124912   = -149143276547656984948124897.0000000000
15 + 0.1322135476547459213732911312 = 15.1322135476
15 + -0.123912932193769965476541321 = 14.8760870678

Number "-15" (scale 10)
-15 + 15                             = 0.0000000000
-15 + -15                            = -30.0000000000
-15 + 1                              = -14.0000000000
-15 + -9                             = -24.0000000000
-15 + 14.14                          = -0.8600000000
-15 + -16.60                         = -31.6000000000
-15 + 0.15                           = -14.8500000000
-15 + -0.01                          = -15.0100000000
-15 + 0                              = -15.0000000000
-15 + 0.00                           = -15.0000000000
-15 + -0                             = -15.0000000000
-15 + -0.00                          = -15.0000000000
-15 + 15151324141414.412312232141241 = 15151324141399.4123122321
-15 + -132132245132134.1515123765412 = -132132245132149.1515123765
-15 + 141241241241241248267654747412 = 141241241241241248267654747397.0000000000
-15 + -149143276547656984948124912   = -149143276547656984948124927.0000000000
-15 + 0.1322135476547459213732911312 = -14.8677864523
-15 + -0.123912932193769965476541321 = -15.1239129321

Number "1" (scale 10)
1 + 15                             = 16.0000000000
1 + -15                            = -14.0000000000
1 + 1                              = 2.0000000000
1 + -9                             = -8.0000000000
1 + 14.14                          = 15.1400000000
1 + -16.60                         = -15.6000000000
1 + 0.15                           = 1.1500000000
1 + -0.01                          = 0.9900000000
1 + 0                              = 1.0000000000
1 + 0.00                           = 1.0000000000
1 + -0                             = 1.0000000000
1 + -0.00                          = 1.0000000000
1 + 15151324141414.412312232141241 = 15151324141415.4123122321
1 + -132132245132134.1515123765412 = -132132245132133.1515123765
1 + 141241241241241248267654747412 = 141241241241241248267654747413.0000000000
1 + -149143276547656984948124912   = -149143276547656984948124911.0000000000
1 + 0.1322135476547459213732911312 = 1.1322135476
1 + -0.123912932193769965476541321 = 0.8760870678

Number "-9" (scale 10)
-9 + 15                             = 6.0000000000
-9 + -15                            = -24.0000000000
-9 + 1                              = -8.0000000000
-9 + -9                             = -18.0000000000
-9 + 14.14                          = 5.1400000000
-9 + -16.60                         = -25.6000000000
-9 + 0.15                           = -8.8500000000
-9 + -0.01                          = -9.0100000000
-9 + 0                              = -9.0000000000
-9 + 0.00                           = -9.0000000000
-9 + -0                             = -9.0000000000
-9 + -0.00                          = -9.0000000000
-9 + 15151324141414.412312232141241 = 15151324141405.4123122321
-9 + -132132245132134.1515123765412 = -132132245132143.1515123765
-9 + 141241241241241248267654747412 = 141241241241241248267654747403.0000000000
-9 + -149143276547656984948124912   = -149143276547656984948124921.0000000000
-9 + 0.1322135476547459213732911312 = -8.8677864523
-9 + -0.123912932193769965476541321 = -9.1239129321

Number "14.14" (scale 10)
14.14 + 15                             = 29.1400000000
14.14 + -15                            = -0.8600000000
14.14 + 1                              = 15.1400000000
14.14 + -9                             = 5.1400000000
14.14 + 14.14                          = 28.2800000000
14.14 + -16.60                         = -2.4600000000
14.14 + 0.15                           = 14.2900000000
14.14 + -0.01                          = 14.1300000000
14.14 + 0                              = 14.1400000000
14.14 + 0.00                           = 14.1400000000
14.14 + -0                             = 14.1400000000
14.14 + -0.00                          = 14.1400000000
14.14 + 15151324141414.412312232141241 = 15151324141428.5523122321
14.14 + -132132245132134.1515123765412 = -132132245132120.0115123765
14.14 + 141241241241241248267654747412 = 141241241241241248267654747426.1400000000
14.14 + -149143276547656984948124912   = -149143276547656984948124897.8600000000
14.14 + 0.1322135476547459213732911312 = 14.2722135476
14.14 + -0.123912932193769965476541321 = 14.0160870678

Number "-16.60" (scale 10)
-16.60 + 15                             = -1.6000000000
-16.60 + -15                            = -31.6000000000
-16.60 + 1                              = -15.6000000000
-16.60 + -9                             = -25.6000000000
-16.60 + 14.14                          = -2.4600000000
-16.60 + -16.60                         = -33.2000000000
-16.60 + 0.15                           = -16.4500000000
-16.60 + -0.01                          = -16.6100000000
-16.60 + 0                              = -16.6000000000
-16.60 + 0.00                           = -16.6000000000
-16.60 + -0                             = -16.6000000000
-16.60 + -0.00                          = -16.6000000000
-16.60 + 15151324141414.412312232141241 = 15151324141397.8123122321
-16.60 + -132132245132134.1515123765412 = -132132245132150.7515123765
-16.60 + 141241241241241248267654747412 = 141241241241241248267654747395.4000000000
-16.60 + -149143276547656984948124912   = -149143276547656984948124928.6000000000
-16.60 + 0.1322135476547459213732911312 = -16.4677864523
-16.60 + -0.123912932193769965476541321 = -16.7239129321

Number "0.15" (scale 10)
0.15 + 15                             = 15.1500000000
0.15 + -15                            = -14.8500000000
0.15 + 1                              = 1.1500000000
0.15 + -9                             = -8.8500000000
0.15 + 14.14                          = 14.2900000000
0.15 + -16.60                         = -16.4500000000
0.15 + 0.15                           = 0.3000000000
0.15 + -0.01                          = 0.1400000000
0.15 + 0                              = 0.1500000000
0.15 + 0.00                           = 0.1500000000
0.15 + -0                             = 0.1500000000
0.15 + -0.00                          = 0.1500000000
0.15 + 15151324141414.412312232141241 = 15151324141414.5623122321
0.15 + -132132245132134.1515123765412 = -132132245132134.0015123765
0.15 + 141241241241241248267654747412 = 141241241241241248267654747412.1500000000
0.15 + -149143276547656984948124912   = -149143276547656984948124911.8500000000
0.15 + 0.1322135476547459213732911312 = 0.2822135476
0.15 + -0.123912932193769965476541321 = 0.0260870678

Number "-0.01" (scale 10)
-0.01 + 15                             = 14.9900000000
-0.01 + -15                            = -15.0100000000
-0.01 + 1                              = 0.9900000000
-0.01 + -9                             = -9.0100000000
-0.01 + 14.14                          = 14.1300000000
-0.01 + -16.60                         = -16.6100000000
-0.01 + 0.15                           = 0.1400000000
-0.01 + -0.01                          = -0.0200000000
-0.01 + 0                              = -0.0100000000
-0.01 + 0.00                           = -0.0100000000
-0.01 + -0                             = -0.0100000000
-0.01 + -0.00                          = -0.0100000000
-0.01 + 15151324141414.412312232141241 = 15151324141414.4023122321
-0.01 + -132132245132134.1515123765412 = -132132245132134.1615123765
-0.01 + 141241241241241248267654747412 = 141241241241241248267654747411.9900000000
-0.01 + -149143276547656984948124912   = -149143276547656984948124912.0100000000
-0.01 + 0.1322135476547459213732911312 = 0.1222135476
-0.01 + -0.123912932193769965476541321 = -0.1339129321
