/* Generated by re2c 0.16 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) {
			goto yyc_NORMAL;
		} else {
			goto yyc_PRE_RAW;
		}
	} else {
		if (YYGETCONDITION() < 3) {
			goto yyc_RAW;
		} else {
			goto yyc_INITIAL;
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(4);
		yych = *YYCURSOR;
		if (yych <= 'E') {
			if (yych <= '\r') {
				if (yych == '\t') goto yy5;
				if (yych >= '\r') goto yy5;
			} else {
				if (yych == ' ') goto yy6;
				if (yych >= 'E') goto yy9;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'Q') goto yy3;
				if (yych <= 'R') goto yy10;
				if (yych <= 'S') goto yy11;
			} else {
				if (yych <= 'q') {
					if (yych <= 'e') goto yy9;
				} else {
					if (yych <= 'r') goto yy12;
					if (yych <= 's') goto yy11;
				}
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy6;
		}
		goto yy4;
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(7, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy6;
		}
		YYDEBUG(8, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'V') goto yy13;
		if (yych == 'v') goto yy13;
		goto yy4;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy15;
		if (yych == 'u') goto yy15;
		goto yy4;
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy16;
		if (yych == 'h') goto yy16;
		goto yy4;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy4;
				goto yy17;
			} else {
				if (yych == '\r') goto yy17;
				goto yy4;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= ' ') goto yy17;
				if (yych <= 'T') goto yy4;
				goto yy15;
			} else {
				if (yych == 'u') goto yy15;
				goto yy4;
			}
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy20;
		} else {
			if (yych <= '\r') goto yy20;
			if (yych == ' ') goto yy20;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy4;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy23;
		if (yych == 'n') goto yy23;
		goto yy14;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy24;
			goto yy14;
		} else {
			if (yych <= '\r') goto yy24;
			if (yych == ' ') goto yy24;
			goto yy14;
		}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy17;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych == ' ') goto yy17;
		}
		YYDEBUG(19, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(21, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy20;
		} else {
			if (yych <= '\r') goto yy20;
			if (yych == ' ') goto yy20;
		}
		YYDEBUG(22, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy17;
			goto yy14;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych == ' ') goto yy17;
			goto yy14;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy24;
		} else {
			if (yych <= '\r') goto yy24;
			if (yych == ' ') goto yy24;
		}
		YYDEBUG(26, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
	}
/* *********************************** */
yyc_NORMAL:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0,  62,  62,  62,  62,  62,  62,  62, 
			 62,  40,   0,  62,  62,  40,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 40,  62,  50,  40,  62,  62,  62,  14, 
			 62,  62,  62,  62,  62,  62,  63,  62, 
			127, 127, 127, 127, 127, 127, 127, 127, 
			127, 127,  40,  62,  62,  62,  62,  62, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,   2,  62,  62,  62, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			/* table 9 .. 10: 256 */
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64, 128,   0,  64,  64, 128,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			128,  64,   0,   0,  64,  64,  64,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(27, *YYCURSOR);
		YYFILL(11);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 128) {
			goto yy34;
		}
		switch (yych) {
		case 0x00:
		case '\t':
		case '\n':	goto yy29;
		case '"':	goto yy37;
		case '#':	goto yy39;
		case '\'':	goto yy41;
		case '-':	goto yy42;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy43;
		case '0':	goto yy46;
		case ':':	goto yy47;
		case 'D':
		case 'd':	goto yy48;
		case 'E':
		case 'e':	goto yy49;
		case 'F':
		case 'f':	goto yy50;
		case 'I':
		case 'i':	goto yy51;
		case 'N':
		case 'n':	goto yy52;
		case 'O':
		case 'o':	goto yy53;
		case 'T':
		case 't':	goto yy54;
		case 'Y':
		case 'y':	goto yy55;
		case 'Z':	goto yy56;
		case 'z':	goto yy57;
		default:	goto yy31;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy31;
		}
		if (yych <= ' ') goto yy33;
		if (yych == '#') goto yy33;
		if (yych <= '\'') goto yy58;
		goto yy60;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy34;
		}
		YYDEBUG(36, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy58;
		goto yy62;
yy38:
		YYDEBUG(38, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy33;
				} else {
					goto yy40;
				}
			} else {
				if (yyaccept == 2) {
					goto yy45;
				} else {
					goto yy109;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy112;
				} else {
					goto yy128;
				}
			} else {
				goto yy145;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '.') {
			if (yych <= ',') goto yy40;
			if (yych <= '-') goto yy67;
			goto yy68;
		} else {
			if (yych <= '/') goto yy40;
			if (yych <= '9') goto yy68;
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy58;
		goto yy72;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych == 'r') goto yy77;
		goto yy32;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy45;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy45;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych <= '/') goto yy31;
				if (yych <= ':') goto yy60;
				goto yy31;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy45;
				if (yych <= 0x08) goto yy32;
				goto yy45;
			} else {
				if (yych == '\r') goto yy45;
				goto yy32;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy45;
				if (yych <= '"') goto yy32;
				goto yy45;
			} else {
				if (yych == 'x') goto yy78;
				goto yy32;
			}
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		YYCTXMARKER = YYCURSOR;
		if (yych == ':') goto yy81;
		if (yych == '\\') goto yy83;
		goto yy79;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy85;
		if (yych == 'i') goto yy85;
		goto yy32;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy86;
		if (yych == 'n') goto yy86;
		goto yy32;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy87;
		if (yych == 'a') goto yy87;
		goto yy32;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy88;
		if (yych == 'f') goto yy88;
		goto yy32;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy89;
		if (yych == 'o') goto yy89;
		goto yy32;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych == 'F') goto yy90;
			if (yych <= 'M') goto yy32;
			goto yy91;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy32;
				goto yy90;
			} else {
				if (yych == 'n') goto yy91;
				goto yy32;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy92;
		if (yych == 'r') goto yy92;
		goto yy32;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy93;
		if (yych == 'e') goto yy93;
		goto yy32;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy94;
		goto yy32;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'e') goto yy95;
		goto yy32;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy58;
		}
		if (yych <= '#') goto yy38;
		goto yy96;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy97;
		if (yych == '\\') goto yy83;
		goto yy38;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy62:
		YYDEBUG(62, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy61;
		}
		if (yych <= ' ') {
			if (yych <= 0x00) goto yy38;
			if (yych == '\n') goto yy38;
		} else {
			if (yych <= '"') goto yy98;
			if (yych <= '#') goto yy63;
			if (yych <= ':') goto yy65;
			goto yy66;
		}
yy63:
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy64:
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy63;
		}
		if (yych <= '\n') goto yy38;
		if (yych <= '"') goto yy99;
		goto yy100;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy101;
		goto yy64;
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy38;
				if (yych <= 0x08) goto yy58;
				goto yy38;
			} else {
				if (yych == '\r') goto yy38;
				if (yych <= 0x1F) goto yy58;
				goto yy38;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '!') goto yy58;
				if (yych <= '"') goto yy61;
				if (yych <= '#') goto yy38;
				goto yy58;
			} else {
				if (yych <= ':') goto yy96;
				if (yych == '\\') goto yy61;
				goto yy58;
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy68;
		if (yych <= '/') goto yy38;
		if (yych >= ':') goto yy38;
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		if (yych == '.') goto yy68;
		if (yych <= '/') goto yy70;
		if (yych <= '9') goto yy68;
yy70:
		YYDEBUG(70, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_POUND;
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy72:
		YYDEBUG(72, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy71;
		}
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy38;
			if (yych >= '\n') goto yy38;
		} else {
			if (yych <= '#') goto yy73;
			if (yych <= '\'') goto yy98;
			if (yych <= ':') goto yy75;
			goto yy76;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy74:
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy73;
		}
		if (yych <= '\n') goto yy38;
		if (yych <= '\'') goto yy99;
		goto yy102;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy103;
		goto yy74;
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy38;
				if (yych <= 0x08) goto yy58;
				if (yych <= '\n') goto yy38;
				goto yy58;
			} else {
				if (yych <= '\r') goto yy38;
				if (yych == ' ') goto yy38;
				goto yy58;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '#') goto yy38;
				if (yych == '\'') goto yy71;
				goto yy58;
			} else {
				if (yych <= ':') goto yy96;
				if (yych == '\\') goto yy71;
				goto yy58;
			}
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy104;
				goto yy32;
			} else {
				if (yych <= '\r') goto yy104;
				if (yych <= 0x1F) goto yy32;
				goto yy104;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy32;
				if (yych <= '-') goto yy106;
				goto yy107;
			} else {
				if (yych <= '/') goto yy32;
				if (yych <= '9') goto yy107;
				goto yy32;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy110;
		}
		goto yy32;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_COLON;
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_DCOLON;
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy33;
				if (yych <= 0x08) goto yy83;
				goto yy33;
			} else {
				if (yych == '\r') goto yy33;
				if (yych <= 0x1F) goto yy83;
				goto yy33;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy83;
				if (yych <= '#') goto yy33;
				goto yy83;
			} else {
				if (yych <= '\'') goto yy33;
				if (yych == ':') goto yy113;
				goto yy83;
			}
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy114;
		if (yych == 's') goto yy114;
		goto yy32;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy115;
		if (yych == 'a') goto yy115;
		goto yy32;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy116;
		if (yych == 'l') goto yy116;
		goto yy32;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy117;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy117;
			if (yych == ' ') goto yy117;
			goto yy32;
		}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy120;
			if (yych <= 0x08) goto yy32;
			if (yych <= '\n') goto yy120;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy120;
			if (yych == ' ') goto yy120;
			goto yy32;
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy89;
		if (yych == 'f') goto yy89;
		goto yy32;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy122;
			if (yych <= 0x08) goto yy32;
			if (yych <= '\n') goto yy122;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy122;
			if (yych == ' ') goto yy122;
			goto yy32;
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy124;
		if (yych == 'u') goto yy124;
		goto yy32;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy91;
		if (yych == 's') goto yy91;
		goto yy32;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy125;
		goto yy32;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'n') goto yy126;
		goto yy32;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '/') goto yy38;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy127;
		goto yy38;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy33;
				goto yy59;
			} else {
				if (yych <= '\n') goto yy33;
				if (yych <= '\f') goto yy59;
				goto yy33;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy59;
				goto yy33;
			} else {
				if (yych == '#') goto yy33;
				goto yy59;
			}
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy33;
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '"') goto yy63;
		if (yych == '\\') goto yy63;
		goto yy38;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy129;
		goto yy64;
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\'') goto yy73;
		if (yych == '\\') goto yy73;
		goto yy38;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy130;
		goto yy74;
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy104;
				goto yy38;
			} else {
				if (yych <= '\r') goto yy104;
				if (yych <= 0x1F) goto yy38;
				goto yy104;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy38;
				if (yych <= '-') goto yy131;
				goto yy132;
			} else {
				if (yych <= '/') goto yy38;
				if (yych <= '9') goto yy132;
				goto yy38;
			}
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '.') goto yy107;
		if (yych <= '/') goto yy32;
		if (yych >= ':') goto yy32;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy109;
				if (yych <= 0x08) goto yy31;
				if (yych >= '\v') goto yy31;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy31;
				} else {
					if (yych <= ' ') goto yy109;
					if (yych <= '!') goto yy31;
					goto yy58;
				}
			}
		} else {
			if (yych <= '-') {
				if (yych <= '#') goto yy109;
				if (yych == '\'') goto yy58;
				goto yy31;
			} else {
				if (yych <= '/') {
					if (yych <= '.') goto yy107;
					goto yy31;
				} else {
					if (yych <= '9') goto yy107;
					if (yych <= ':') goto yy60;
					goto yy31;
				}
			}
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy110;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy112;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy112;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych <= '/') goto yy31;
				if (yych <= ':') goto yy60;
				goto yy31;
			}
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\\') goto yy83;
		goto yy38;
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy134;
		if (yych == 'a') goto yy134;
		goto yy32;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy135;
		if (yych == 'b') goto yy135;
		goto yy32;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy136;
		if (yych == 's') goto yy136;
		goto yy32;
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(118, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy117;
		} else {
			if (yych <= '\r') goto yy117;
			if (yych == ' ') goto yy117;
		}
		YYDEBUG(119, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy91;
		if (yych == 'e') goto yy91;
		goto yy32;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy137;
		goto yy32;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'd') goto yy137;
		goto yy32;
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy128;
		if (yych == '\n') goto yy128;
		goto yy64;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy128;
		if (yych == '\n') goto yy128;
		goto yy74;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy132;
		if (yych <= '/') goto yy38;
		if (yych >= ':') goto yy38;
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		if (yych == '.') goto yy132;
		if (yych <= '/') goto yy109;
		if (yych <= '9') goto yy132;
		goto yy109;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy138;
		if (yych == 'b') goto yy138;
		goto yy32;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy139;
		if (yych == 'l') goto yy139;
		goto yy32;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy89;
		if (yych == 'e') goto yy89;
		goto yy32;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy140;
		goto yy32;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy141;
		if (yych == 'l') goto yy141;
		goto yy32;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy142;
		if (yych == 'e') goto yy142;
		goto yy32;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy143;
		}
		goto yy32;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy146;
		if (yych == 'e') goto yy146;
		goto yy32;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy91;
		if (yych == 'd') goto yy91;
		goto yy32;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 6;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy143;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy145;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy145;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych == ':') goto yy60;
				goto yy31;
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy89;
		if (yych == 'd') goto yy89;
		goto yy32;
	}
/* *********************************** */
yyc_PRE_RAW:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,   0,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(147, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych == '\t') goto yy151;
			if (yych >= '\r') goto yy151;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy152;
			} else {
				if (yych == '-') goto yy155;
			}
		}
		YYDEBUG(149, *YYCURSOR);
		++YYCURSOR;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy152;
		}
		goto yy150;
yy152:
		YYDEBUG(152, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy152;
		}
		YYDEBUG(154, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'r') goto yy150;
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(157, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy160;
		}
		if (yych <= '\r') {
			if (yych == '\t') goto yy156;
			if (yych >= '\r') goto yy156;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy156;
			} else {
				if (yych == '-') goto yy159;
			}
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy150;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy160;
		}
		goto yy158;
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy160;
		}
		YYDEBUG(162, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
	}
/* *********************************** */
yyc_RAW:
	{
		static const unsigned char yybm[] = {
			  0, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,   0, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,  64, 224, 232, 232, 232,  32, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232,  16, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
		};
		YYDEBUG(163, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy167;
		}
		if (yych <= '\n') goto yy165;
		if (yych <= '"') goto yy170;
		if (yych <= '#') goto yy172;
		if (yych <= '\'') goto yy174;
		goto yy175;
yy165:
		YYDEBUG(165, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(166, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy167:
		YYDEBUG(167, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy167;
		}
		if (yych <= '\n') goto yy169;
		if (yych <= '"') goto yy170;
		if (yych <= '#') goto yy169;
		if (yych <= '\'') goto yy174;
		goto yy175;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy177;
		}
		if (yych >= '#') goto yy179;
yy171:
		YYDEBUG(171, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy169;
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy181;
		}
		if (yych <= '\'') goto yy171;
		goto yy183;
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(176, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy175;
		}
		if (yych <= '!') {
			if (yych <= 0x00) goto yy169;
			if (yych == '\n') goto yy169;
			goto yy167;
		} else {
			if (yych <= '"') goto yy185;
			if (yych == '\'') goto yy186;
			goto yy167;
		}
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(178, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy177;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '"') goto yy167;
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(180, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy177;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '"') goto yy187;
		goto yy179;
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy181;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '\'') goto yy167;
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy181;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '\'') goto yy189;
		goto yy183;
yy185:
		YYDEBUG(185, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy187;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy187;
				goto yy170;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy177;
				if (yych <= '&') goto yy187;
				goto yy191;
			} else {
				if (yych == '\\') goto yy192;
				goto yy187;
			}
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy189;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy189;
				goto yy194;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy181;
				if (yych <= '&') goto yy189;
				goto yy174;
			} else {
				if (yych == '\\') goto yy195;
				goto yy189;
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy187;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy187;
				goto yy185;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy177;
				if (yych <= '&') goto yy187;
				goto yy191;
			} else {
				if (yych == '\\') goto yy192;
				goto yy187;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy189;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy189;
				goto yy194;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy181;
				if (yych <= '&') goto yy189;
				goto yy186;
			} else {
				if (yych == '\\') goto yy195;
				goto yy189;
			}
		}
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy197;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '"') goto yy189;
		if (yych <= '\'') goto yy177;
		goto yy199;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x00) goto yy169;
			if (yych == '\n') goto yy169;
			goto yy187;
		} else {
			if (yych <= '\'') goto yy201;
			if (yych == '\\') goto yy192;
			goto yy187;
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy197;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '"') goto yy181;
		if (yych <= '\'') goto yy187;
		goto yy199;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= 0x00) goto yy169;
			if (yych == '\n') goto yy169;
			goto yy189;
		} else {
			if (yych <= '"') goto yy202;
			if (yych == '\\') goto yy195;
			goto yy189;
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(198, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy197;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '"') goto yy189;
		if (yych <= '\'') goto yy187;
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy197;
		}
		if (yych <= '\n') goto yy171;
		if (yych <= '\'') goto yy203;
		goto yy199;
yy201:
		YYDEBUG(201, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy203;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy203;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy197;
				if (yych <= '&') goto yy203;
				goto yy191;
			} else {
				if (yych == '\\') goto yy205;
				goto yy203;
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych >= '"') goto yy194;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy197;
				if (yych >= '\'') goto yy201;
			} else {
				if (yych == '\\') goto yy205;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy169;
				goto yy203;
			} else {
				if (yych <= '\n') goto yy169;
				if (yych <= '!') goto yy203;
				goto yy202;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy197;
				if (yych <= '&') goto yy203;
				goto yy201;
			} else {
				if (yych != '\\') goto yy203;
			}
		}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy169;
			if (yych <= '\t') goto yy203;
			goto yy169;
		} else {
			if (yych == '\\') goto yy205;
			goto yy203;
		}
	}
}

}
