/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */

//constants 
var NUMBER_OF_ALTERNATIVES = 4;
var NUMBER_OF_LIVES = 3;
var QUESTION_DISPLAY_TIME = 12;
var ANSWER_DISPLAY_TIME = 2;
var NUMBER_OF_PLAYERS = 5;

//global variables
var g_score = 0, g_livesLeft = NUMBER_OF_LIVES; 
var g_appearedCountries = [];

//helping function
function $( idName )
{
    return document.getElementById( idName );
}

window.languages = 
{
    'en' : 'lang/en.js'
};

//entry function
window.onload = function()
{
    //widget.setPreferenceForKey(' ','scoreBoard');
    window.setLanguage( 'en', function(){ document.toLocale(); } );
    $( 'startbutton' ).addEventListener( 'click', startQuiz, false );
}
 
// navigates to first question.
function startQuiz()
{
    $( 'startbutton' ).removeEventListener( 'click', startQuiz, false );
	$( 'welcomePage' ).style.display = "none";
    $( 'questionairePage' ).style.display = "block";
    $( 'life'+g_livesLeft ).className = "life_active";
    showQuestion();
}

//creates a new question and displays it.
function showQuestion()
{
    var question = new Question();
    question.displayCountry();
    question.displayAlternatives();
    question.showTimeLine();
}

function Question()
{
    var _countryIndex = getCountryIndex();
    this.alternatives = getAlternatives(_countryIndex);
    this.country = g_countries[_countryIndex].name;
    this.capital = g_countries[_countryIndex].capital;
    this.timeout = setTimeout(onTimeout, QUESTION_DISPLAY_TIME *1000);
    this.timeLine = null ;
    this.counter = QUESTION_DISPLAY_TIME ;
}

Question.prototype.displayCountry = function ()
{
    $( 'question' ).textContent =  'question'.toLocale()  + this.country  + '?';
}

Question.prototype.displayAlternatives = function()
{
    var self = this;
	var answerReference = null;
    removeOldAlternatives();
    for( var i=0; i<NUMBER_OF_ALTERNATIVES; i++ )
    {
        var li = document.createElement( 'li' );
		var altSpan = document.createElement( 'span' );
		var altIndex = document.createElement( 'p' );
		altIndex.setAttribute('id', 'altIndex' + parseInt(i+1));
        li.active = true;
        answerReference = (this.alternatives[i] == this.capital)?li:answerReference;
        altSpan.textContent = this.alternatives[i];
		li.appendChild(altSpan);
		li.appendChild(altIndex);
        $( 'alternatives' ).appendChild(li);
        li.addEventListener( 'click', function()
        {
            var liElements = $('alternatives').children;
            var selectedAlternative = this;
			selectedAlternative.setAttribute('selected', 'true');
            if(this.active == true)       // Removes the eventListeners once the user selects an alternative. 
            {
                for (var i in liElements)
                {
                    liElements[i].active = false;
                }
                var timeSpent = QUESTION_DISPLAY_TIME - self.counter;	
                $('timeLine').textContent = '';  //clears the timeLine
                clearTimeout(self.timeout);      //clears the timer for the display of each Question .
                clearTimeout(self.timeLine);     //clears the timer for timeline.
                setTimeout(function(){updateScore(selectedAlternative, answerReference, timeSpent);}, 1000);
            }
        },  false ); 
    }
	window.onkeypress = function(e)                       //To select the alternative using hardware keyboard
	{
		var code = e.keyCode;                                 //Get the ascii code for the key pressed     
		var keyChar = String.fromCharCode(event.keyCode);     //Get the character pressed i.e the selected alternative number/index     
		if ((parseInt(keyChar) >= 1) && (parseInt(keyChar) <= 4))
		{
			var liElements = $('alternatives').children;
            var selectedAlternative = liElements[code - 49];
            if(selectedAlternative.active == true)       // Removes the eventListeners once the user selects an alternative. 
            {
                for (var i in liElements)
                {
                    liElements[i].active = false;
                }
                var timeSpent = QUESTION_DISPLAY_TIME - self.counter;	
                $('timeLine').textContent = '';  //clears the timeLine
                clearTimeout(self.timeout);      //clears the timer for the display of each Question .
                clearTimeout(self.timeLine);     //clears the timer for timeline.
                setTimeout(function()
				{
					updateScore(selectedAlternative, answerReference, timeSpent);
				}, 500);
            }
		}
	}
}

/***
 * Shows the progression of the time for each Question that is displayed 
 */
Question.prototype.showTimeLine = function()
{
    var self = this;
    this.counter--; 
    if (this.counter <=0)
    {    
        this.counter = QUESTION_DISPLAY_TIME ; 
        $('timeLine').textContent = ''; 
        clearTimeout(this.timeLine); 
    } 
    else
    {
        this.timeLine = setTimeout(function(){self.showTimeLine();}, 1000); 
        var timeLineSpan  = document.createElement('span');
        $('timeLine').appendChild(timeLineSpan);
    }
}

/***
 * Generates random alternatives (false answers)
 * @param excludedCountryId (Number) A country capital that SHOULD NOT be included as an alternative. 
 * and also checks for the repetition in the alternatives.
 * Adds an alternative with right answer at random location and rearranges the alternatives 
 * @returns (array) An array of alternatives including the right answer and fake alternatives 
 */
function getAlternatives( excludedCountryId )
{
    var alternatives = [];
    for( var i=0; i < ( NUMBER_OF_ALTERNATIVES-1 ); i++ )
    {
        var isSelected = false;
        var indexOfAlternative = getRandomInt( g_countries.length );
		//check for the duplicate alternative in alternatives for present question
        isSelected = (indexOfAlternative == excludedCountryId);//Check for generated index equal the selected country index
        for(var j=0;j<alternatives.length;j++)    //Check for generated index in already selected Alternatives 
        {
            if (isSelected || (alternatives[j] == g_countries[indexOfAlternative].capital))
            {
                isSelected = true;
                break;
            }
        } 
        (isSelected)?(--i):alternatives.push(g_countries[indexOfAlternative].capital);   
    }
    var index = getRandomInt( NUMBER_OF_ALTERNATIVES ); // the position of the correct answer 
    if(index < 3)
    {
        alternatives.push(alternatives[index]);
        alternatives[index] = g_countries[excludedCountryId].capital;		
    }	
    else
    {
        alternatives.push(g_countries[excludedCountryId].capital);
    }	
    return alternatives;
} 

function removeOldAlternatives()
{
    removeChildren("alternatives");
}

function removeChildren(id) 
{
    var ele = $(id);
    while (ele.firstChild) 
    { 
        ele.removeChild(ele.firstChild)
    }
}

/***
 * Generates random number
 * @param max ( number ) 
 * @returns (number) A integer number between 0 to max-1.
 */
function getRandomInt( max ) 
{
    return Math.floor( Math.random()*( max ));
}

/***
 * Selects an Index for country-capital pair from the database randomly and check for repetition 
 * @returns The index for selected country-capital pair
 */
function getCountryIndex()
{
    countryIndex = getRandomInt( g_countries.length );
    return (hasAppeared(countryIndex))?getCountryIndex():countryIndex;
} 

/***
 * Checks the formerly used countries to see if the country with countryIndex has been used earlier
 * @param countryIndex (number) the selected index
 * @returns (boolean) True if index is already used 
 * otherwise pushes the index in appeared indices array and returns false
 */
function hasAppeared( countryIndex )
{
    for( var i=0; i<g_appearedCountries.length; i++ )
    {
        if(countryIndex == g_appearedCountries[i])
        {
            return true;
        }
    }
    // Reset if all countries are used
    if(g_appearedCountries.length == g_countries.length)
    {
        g_appearedCountries.length = 0;
    }
    g_appearedCountries.push(countryIndex);
    return false;
}

/***
 *if the timeout has occured and lives are still left then displays next Question else shows the score page
 */
function onTimeout()
{
    $( 'life'+ g_livesLeft-- ).className = 'life_grey';
    if(g_livesLeft)
    {
        $( 'life'+ g_livesLeft ).className = 'life_active';
        showQuestion();
    }
    else
    {
        showScorestats();
    }        
}

/***
 * Updates life,score.Highlights correct and wrong answers.
 * @param ( ObjectHTMLList, ObjectHTMLlist ) selected answer reeference, right answer reference
 */ 
function updateScore( selectedAlternative, answerReference, timeSpent )
{
    if( selectedAlternative == answerReference ) 
    {
        if (timeSpent<=2)
        {
            g_score = g_score + 3;
            $( 'scoreValue' ).textContent = g_score;
        }
        else 
        {
            if (timeSpent > 2 && timeSpent <= 6)
            {
                g_score = g_score + 2;
                $( 'scoreValue' ).textContent = g_score;
            }
            else
            {
                $( 'scoreValue' ).textContent = ++g_score;
            }
        }
        selectedAlternative.setAttribute('rightalternative', 'true'); 
        setTimeout(showQuestion, 1000 * ANSWER_DISPLAY_TIME);
    }
    else 
    {
        $( 'life'+ g_livesLeft ).className = 'life_grey';
        selectedAlternative.setAttribute('wrong', 'true'); 
        answerReference.setAttribute('rightalternative', 'true'); 
        if(--g_livesLeft)
        {
            $( 'life'+ g_livesLeft ).className = 'life_active';
            setTimeout(showQuestion,1000 * ANSWER_DISPLAY_TIME );
        }
        else
        {
            setTimeout(showScorestats,1000 * ANSWER_DISPLAY_TIME );
        }
    }
}

function showScorestats()
{
    $( 'questionairePage' ).style.display = "none";
    $( 'scorePage' ).style.display = "block";
    $('scoreBoard').textContent = '';
    parseScoreBoardData();
	$( 'tryagain' ).addEventListener ('click', reStartQuiz, false); 
}

function reStartQuiz()
{
    $( 'tryagain' ).removeEventListener ('click', reStartQuiz, false); 
	if($('playerName'))
    {
        var playerNamep = document.createElement('p');
        playerNamep.textContent = $('playerName').value;
        $('newPlayer').removeChild($('playerName'));
        $('newPlayer').appendChild(playerNamep);
        widget.setPreferenceForKey(
        (widget.preferenceForKey('scoreBoard')+g_score+'_'+playerNamep.textContent +','),'scoreBoard');
    }
    g_appearedCountries.length = 0;
    reSetScoreBar();
    showQuestion();
    $( 'questionairePage' ).style.display = "block";
    $( 'scorePage' ).style.display = "none";
}

function reSetScoreBar()
{
    g_score = 0;
    $( 'scoreValue' ).textContent = g_score;
    g_livesLeft = NUMBER_OF_LIVES;
    for( var i=1; i<=g_livesLeft; i++ )
    {
        $( 'life'+i ).className = ''; 
    }
    $( 'life'+g_livesLeft ).className = 'life_active'; 
}

/***
 * Gets data from preferenceKey ,
 * Sorts the data by score, checks if the score is one among the top 5
 * and then displays.
 */
function parseScoreBoardData()
{
    var players = [];
    var hasNewEntry = false;
    var highScore = 0, lowScore = 0;
    players = widget.preferenceForKey('scoreBoard').split(',').map(function(current)
    {
        var parts = current.split('_');
        return {'name':parts[1],'score':parts[0]};
    });
    players.sort(function(a, b)
                {
                   return b.score-a.score;
                });
    players.length = (players.length > NUMBER_OF_PLAYERS )?NUMBER_OF_PLAYERS:players.length-1;
    if(players.length)
    {
        highScore = players[0].score;
        lowScore = (players.length>1)?players[players.length - 1].score:0;
    }    
    ((g_score)&&((players.length < 5 ) || (g_score > players[4].score)) )?hasNewEntry = true:hasNewEntry = false;
    displayMessage( highScore, lowScore );
    displayScore(hasNewEntry, players);      
}
 
/*** To display the message to the user based on the score range
 * @param (number, number) Highest Score on the score board, Lowest score on the score board (Default 0)
 */
function displayMessage( highScore, lowScore )
{
    if(g_score == 0)   // User's score is zero
    {
        $('highScore').textContent = "Hard Luck!";
        $('scorePageMessage').textContent = 'zeroScore'.toLocale();    
    }     
    else
    {
        if ( g_score > highScore )      //User scored more then highest score
        {
            $('highScore').textContent = "High Score!";
            $('scorePageMessage').textContent = 'topScore'.toLocale();        
        } 
        else 
        {
            if((g_score > lowScore) && (g_score < highScore))   //User in Top 5
            {
                $('highScore').textContent = "Good Job!";
                $('scorePageMessage').textContent = 'inTop5'.toLocale(); 
            } 
            else     // User's score is in between zero and lowest score
            {
                $('highScore').textContent = "Hard Luck!";
                $('scorePageMessage').textContent = 'notinTop5'.toLocale(); 
            }
        }
    }
} 
   
/*** displays the top 5 high scores
 * @param ( boolean, array ) true if the player'score is one among the top 5 else false , 
 * array of old top 5 players' scores.
 */
function displayScore(hasNewEntry, players)
{
    var count =0;
    for(var i = 0; (i<NUMBER_OF_PLAYERS); i++)
    { 
        if(hasNewEntry && ((i==players.length) || (players[i].score<g_score))) //New entry
        {
            var li = document.createElement('li');
            li.setAttribute('id','newPlayer');
			var playerScore = document.createElement('p');
			playerScore.id = 'pscore';
            playerScore.textContent = g_score;
            li.appendChild(playerScore);
            var indexNum = document.createElement('span');
            indexNum.textContent = ++count + '.';
            li.appendChild(indexNum);
            $('scoreBoard').appendChild(li);
            showInputBox(players);
            i--;
            hasNewEntry = false;
        }
        else
        {
            if(i==players.length)    //Breaks the loop if the index exceeds current length of scores 
            {
                break;
            }
            else                     //Display the contents in the stored score board
            {
                var li = document.createElement('li');
                var playerName = document.createElement('p');
                var playerScore = document.createElement('p');
                var indexNum = document.createElement('span');
                playerName.textContent = players[i].name;
                playerScore.textContent = players[i].score;
                li.appendChild(playerScore);
                indexNum.textContent = ++count + '.';
                li.appendChild(indexNum);
                li.appendChild(playerName);
                $('scoreBoard').appendChild(li);
            }    
        }
    }
}  

//displays the input box and adds the player's details to the score board and to the preference key
function showInputBox(players)
{
    players.length = (players.length == NUMBER_OF_PLAYERS)?players.length-1:players.length;
    var input = document.createElement('input');
    input.setAttribute('type','text');
    input.setAttribute('id','playerName');
    $('newPlayer').appendChild(input);
	input.value = "Player Name";
    input.setAttribute('maxlength', '20');
    input.select();
    input.focus(); 
	input.onclick = function()
	{
	    if(input.value ==  "Player Name")
		  input.value = '';
		input.focus(); 
    }
    input.onkeypress = function(e)
    {
        var code = e.keyCode;
		var keyChar = String.fromCharCode(event.keyCode);
	    if(code == 13)
        {
            var playerNamep = document.createElement('p');
			playerNamep.textContent = this.value;
            $('newPlayer').removeChild(playerName);
            $('newPlayer').appendChild(playerNamep);
            widget.setPreferenceForKey(
            (widget.preferenceForKey('scoreBoard')+g_score+'_'+playerNamep.textContent +','),'scoreBoard'); 
        }
        return (((code > 64) && (code < 91)) || ((code > 96) && (code < 123)) 
		          || (code == 32) || (code == 8) || (code==127) || (code == 37 && keyChar!='%') || (code==39 && keyChar!='\''));
    }
}   