// cQ/Hm+Y38Wa5mXl/L8s09QSnO4V6LUnBqHbe+3iMcphzogbZIcuuriYuuLUqk7hIQGZqtBuXVFLOBGO2aNn0BiUf/Hs2BJhZWQndHpW/qrr3inMUrusbJQrk8HFjqweOz8wfe1862dmFxRuxJ2Vb5yzmh6UqkNlJj3V3ZHXHW6y/Q+K1ICTzVFhnq1qX4+Dm9hM9+Hq9c8Fns2Hgfr5fJO5oo4xcHYh3K8PmLMwr1yuYkgIJUO/qwNVvVF9mPcPTxIm1zECdeQcIGsEhNH8QdLhnLDS1TBw+vjGzXE9XDJnpGC7O6Dnq77NBixJrIQh9jhr8bq4y65mgQ18Zy6woSA==
/**
** Copyright (C) 2000-2012 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
**
** If you have comments on these patches (for example if you are the webmaster
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited.
**/
// Generic fixes (mostly)
(function(opera){
	if(!opera || opera._browserjsran)return;
	opera._browserjsran=true;
	var bjsversion=' Opera Desktop 12.01 core 2.10.289, October 15, 2012. Active patches: 273 ';
	// variables and utility functions
	var navRestore = {}; // keep original navigator.* values
	var shouldRestore = false;
	var hostname = {
		value:location.hostname, 
		toString:function(){return this.value;},
		valueOf:function(){return this.value;}, 
		indexOf:function(str){return this.value.indexOf(str);},
		match: function(rx){ return this.value.match(rx); },
		contains:function(str){ return this.value.indexOf(str)>-1; },
		endsWith:function(str){ var pos=this.value.indexOf(str);return pos>-1 && this.value.length===pos+str.length; }
	}
	var href = location.href;
	var pathname=location.pathname;
	var fixed = false; // magic fixes need only run once
	if(!opera.postError)opera.postError=function(){}; // handling versions w/o error console
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call,
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute,
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	replaceChild=Node.prototype.replaceChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createEvent=Document.prototype.createEvent,
	dispatchEvent=Document.prototype.dispatchEvent,
	initEvent=Event.prototype.initEvent,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	shift=Array.prototype.shift,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString,
	parseFloat=window.parseFloat,
	random=Math.random;
	var opera_version = parseFloat.call(window,opera.version());
	var tinyMCEVersionInfo={};
	function log(str){if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ('+str+'). See browser.js for details');}

	// Utility functions

	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}

	function addPreprocessHandler( search, replacement, onceonly, conditional ){
		// adding event handler for script pre-processing if required
		var handler=function(e){
			indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */
			if( conditional && ! conditional(e.element) ){return;}
			e.element.text=replace.call( e.element.text, search, replacement );
			if(onceonly){
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}
		opera.addEventListener('BeforeScript', handler , false);
		return handler;
	}

function avoidDocumentWriteAbuse(contentRegexp){
	var dw=document.write;
	contentRegexp = contentRegexp || /(^<img .*?width=("|)1("|)\s+height=("|)1("|)\s+border=("|)0("|)\s+alt="".*?>$|^\[object Object\]$)/i;
	document.write=function( s ){
		if( String(s).match( contentRegexp ) ){
			log('The s_code patch prevented document.write()');
		}else{
			dw.apply(document, arguments);
		}
	};
}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script
		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions
		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions
		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter
	}

	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=match.call=call;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);
		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);
		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);
		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload
		defineMagicVariable.call(opera, 'Trigger', function(obj){if(obj===document||obj===document.body) return window; return obj; }, null);
		// Tell the script that CSS filters are not supported.
		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7'; 
			shouldRestore = true;
		}
	}
	function fixHierMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });
		if(!document.all)defineMagicVariable.call(opera, 'HM_IE', function(){ return true}, function(){ return true });
		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;}); // PATCH-33
		defineMagicVariable.call(opera, 'HM_GL_Filter', function(){ return undefined;},null); // PATCH-327
		defineMagicVariable.call(opera, 'HM_Canvas', function(obj){obj.__defineGetter__('clientHeight', function(){return window.innerHeight});return obj;},null); // PATCH-785

	}

function fixIFrameSSIscriptII(funcName, iFrameId){
	if(typeof funcName==='string'&&!arguments.callee[funcName]){
		var overrideFn = function (a,b,frameid){
			frameid = frameid|| iFrameId;
			var currentfr=document.getElementById(frameid);
			if (currentfr){
				try{
					currentfr.height = currentfr.contentDocument.documentElement.scrollHeight;
				}catch(e){}
				currentfr.style.display='block';
				if(!arguments.callee._listenerAdded){
					currentfr.addEventListener("load", function(e){ overrideFn(0,0,e.target.id); }, false);
					arguments.callee._listenerAdded=true;
				}
			}
		}
		opera.defineMagicFunction(funcName, overrideFn);
		fixIFrameSSIscriptII[funcName]=1;//remember that we fixed this already
	}
}
function fixJQueryAutocomplete(){
  addPreprocessHandler(/\.opera\s*\?\s*["']keypress["']\s*:\s*["']keydown["']/g, '.opera && !(\'KeyboardEvent\' in window)?"keypress":"keydown"');
}

function fixLiknoAllWebMenus(ev){
	indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=appendChild.call=createElement.call=preventDefault.call=replace.call=call;
	if(fixed)return; fixed=true;
	if( indexOf.call(ev.element.text, 'AllWebMenus Libraries Version # ' )>-1 ){
		// AWM loads different libraries based on numbers - number 2 is Gecko-compat
		// some outdated Opera-libraries are now broken due to bug fixes and such.
		var awmVersion = parseInt(match.call(ev.element.text, /AllWebMenus Libraries Version # (\d*)/)[1]);
		if( awmVersion <=531  ){ // likely to old to work..
			defineMagicVariable.call(opera,   'scriptNo', function(){return 2}, null);
			defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );
			preventDefault.call(ev); // don't run this script
			var script = appendChild.call(document.body, createElement.call(document, 'script')); // create another one..
			script.src = replace.call(ev.element.src, /awmlib\d*\.js/, 'awmlib2.js'); // and load a more suitable version
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
		}
		removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );
	}
}
	function fixMilonicMenu(name){ 	// gotcha: must be called with script.src as argument
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=defineMagicFunction.call=addEventListener.call=call;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});
		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		defineMagicFunction.call(opera,  'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });
		// Fix units for standards mode, CORE-38601
		defineMagicVariable.call(opera,  '_px' , function(){return 'px';}, null);
		// bug 330958
		if(typeof window.scrollX=='undefined'){
			defineMagicVariable.call(opera, 'scrollY', function(){ return document.body.scrollTop;}, null);
			defineMagicVariable.call(opera, 'scrollX', function(){ return document.body.scrollLeft;}, null);
		}
	}

function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
	if(fixed)return;
	match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;
	// OpenCube menu
	window.vxml = window.vxml||{}; // to fix semi-opera-detection
	//Some versions try to call a function q99 which is only defined in the Opera library
	addEventListener.call(window, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
	// fake some support for the menu version that tries to use CSS filters in spite of magic var below
	fakeCSSFilters();
	// We'll overrule their sniffing and find the correct library for Opera
	if(indexOf.call(navigator.appVersion, 'Mac')!=-1){
		// They don't seem to like Macs.. see 356184
		navigator.appVersion = replace.call( navigator.appVersion, 'Mac', 'M A C' );
		addEventListener.call(opera, 'AfterExternalScript', function(){
			replace.call = removeEventListener.call = call;
			navigator.appVersion = replace.call( navigator.appVersion, 'M A C', 'Mac' );
			removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
		}, false);
		// some variables are uninitialized
		q20=q21=[];
	}
	if(match.call(name, /dqm_script\d*\.js$/)){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });
		defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622
			addEventListener.call(window, 'load', function(){
				var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;
				while( node=nodes.iterateNext()){
					node.parentElement.parentElement.replaceChild(node, node.parentElement );
				};
			}, false);
		}
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dqm_loader.js')>-1){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dnm_script.js')>-1){ // very old version.. 153257
		defineMagicVariable.call(opera, 'ie5', function(val){ return true }, function(val){ return true });
		defineMagicVariable.call(opera, 'ns5', function(val){ return true }, function(val){ return true });
	}
}

function fixTransitionEndCase(){
	opera.addEventListener('BeforeEventListener.otransitionend', function(e){
		e.event.__defineGetter__('type', function(){
			return 'oTransitionEnd';
		});
	}, false);
}
	function fixUDM(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);
		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);

		// certain versions break if insertRule throws exceptions. Also see bug 242411.
		// Better fake missing support for DOM2Style then..
		defineMagicVariable.call(opera, 'um', function(o){ o.ss=false; o.o7=false; return o; }, null);
    }

function ignoreCancellationOfCertainKeyEvents(type, list){
	opera.addEventListener( 'BeforeEventListener.'+type, function(e){
		preventDefault.call=call;
		if( e.event.keyCode in list ){
			preventDefault.call(e);
		}
	},false );
}
function makePropertyCacheable(obj, prop){ 
 (function() { 
	 var is_cached = false; 
	 var cached_value; 
	 obj.__defineGetter__(prop, function() 
	 { 
		 if (!is_cached) 
		 { 
			 cached_value = Object.getOwnPropertyDescriptor(this, prop).get.call(this); 
			 is_cached = true; 
		 } 

		 return cached_value; 
	 }); 
 })(); 
}
function prestoVersionBelow(ver){
	var parts=ver.split(/\./);
	var current=navigator.userAgent.match(/Presto\/(\d+)\.(\d+)\.(\d+)/);
	if(!current)return true;
	for( var i=1;i<current.length;i++ ){
		if( parts[i] != current[i] ){
			return parts[i]<current[i];
		}
	}
	return false; // identical
}
function sendOperaEvent(name, target){
	initEvent.call=createEvent.call=dispatchEvent.call=call;
	var evt=createEvent.call(document, 'Event');
	initEvent.call(evt, name, false, false);
	evt.element=target;
	dispatchEvent.call(opera, evt);
}
function setTinyMCEVersion(e){
	if(tinyMCEVersionInfo.majorVersion)return; // already found it
	indexOf.call=match.call=call;
	// look at source code
	if( e && indexOf.call(e.element.text, 'majorVersion' )>-1  ){
		if(match.call(e.element.text, /majorVersion\s*[:=]+\s*["']?(\d)/)){ tinyMCEVersionInfo.majorVersion=RegExp.$1; }
		if(match.call(e.element.text, /minorVersion\s*[:=]+\s*["']?(\d(\.\d|))/)){ tinyMCEVersionInfo.minorVersion=RegExp.$1; }
	}
	// if an instance has already been created, we can read version info from it...
	var tinyInstance='tinyMCE' in window?window.tinyMCE : 'tinymce' in window ? window.tinymce : 'tiny_mce' in window ?  window.tiny_mce : null;
	if(tinyInstance&&tinyInstance.majorVersion)tinyMCEVersionInfo={ majorVersion:tinyInstance.majorVersion, minorVersion:tinyInstance.minorVersion };
}






	// PATCH-621, Work around browser sniffing in old Macromedia menu script
// DSK-223254, lines reversed on enter by workaround against old Opera bug
// PATCH-204, TinyMCE 2.x uses document.selection in Opera
// DSK-199930, no code in TinyMCE 2.x HTML source editor because it expects a different order of load events
// PATCH-139, Generic JS library patches
// PATCH-452, Validate result from document.all.item
// PATCH-248, Jive forum software doesn't work in Opera
// PATCH-503, Working around Transmenu's browser sniffing
// PATCH-261, Hide broken implementation of showModalDialog to make object detection reliable
// PATCH-835, Generic fix for the .Net JS library that defines a broken PopOut_Position() function
// 246299, PDF security patch
// PATCH-554, Workaround for jquery.jsonp plugin's workaround against missing onerror support
// PATCH-298, Disable sniffing in old HTMLArea editors
// PATCH-138, Asia-region Generic Patches
// PATCH-581, Make getUserMedia() scripts written according to current spec work
// PATCH-604, Facebook: work around iframe load event issue
// PATCH-605, remove document.charset
// PATCH-373, TinyMCE double IFRAME init problem, some versions
// PATCH-622, Unblock iCongo Platform product image zoom

	opera.defineMagicFunction('mmLoadMenus', function(func, context){
	  window.__defineSetter__('mmIsOpera', function(){});
	  window.__defineGetter__('mmIsOpera', function(){return false});
	  return func.apply(context, Array.prototype.slice.call(arguments, 2));
	});
	

	opera.addEventListener('bjsOnTinyMCEScript', function(e){
		if(tinyMCEVersionInfo.majorVersion<3 || ( tinyMCEVersionInfo.majorVersion==3 && (parseInt(tinyMCEVersionInfo.minorVersion)==0 || tinyMCEVersionInfo.minorVersion=='X' /*X: see CORE-15898*/ ))){
			e.element.text = e.element.text.replace( /if\s*\((tinyMCE\.|)isOpera\)\s*\{(\s*(\w{1,}\.normalize\(\);|)\s*\w{1,}\.insertNode\(\s*\w{1,}\s*\);)/g , 'if(false){$2' );
			e.element.text = e.element.text.replace( /if\([\w\.]+\)\{(\w+)\.insertNode\((\w+)\);\1\.insertNode\((\w+)\)\}else\{\1\.insertNode\(\3\);\1.insertNode\(\2\)/g , function(str){ return str.replace( /if\([\w\.]\)/, 'if(false)' ) } ); // PATCH-248
		}
	}, false);
	

	opera.addEventListener('bjsOnTinyMCEInstance', function(e){
		if(!document.selection && tinyMCEVersionInfo&&tinyMCEVersionInfo.majorVersion<3){
			var doc=e.element.contentDocument;
			doc.selection={};
			doc.selection.__defineGetter__('type', function(){ if(doc.getSelection())return 'Text'; return 'None'; });
			doc.selection.createRange=function(){var rng=window.getSelection().getRangeAt(0);rng.__defineGetter__('text', function(){return doc.getSelection();});return rng;}
		}
	}, false);

	opera.addEventListener('bjsOnTinyMCEScript', function(e){
		if( e.element.src.indexOf('popup')>-1 && ( (tinyMCEVersionInfo&&tinyMCEVersionInfo.majorVersion<3&&tinyMCEVersionInfo.minorVersion<1.3)||!tinyMCEVersionInfo.majorVersion) ){
			var name=tinyMCEVersionInfo.minorVersion==0?'TinyMCEPopup':'TinyMCE_Popup';//sigh..
			opera.defineMagicVariable(name, function(o){
				o.prototype.resizeToInnerSize=function(){};
				o.prototype.executeOnLoad=function(str){eval(str);}
				return o;
			}, null);
		}
	}, false);
	

	// Use an event listener to detect specific scripts
	opera.addEventListener( 'BeforeExternalScript', function(ev){
		match.call=replace.call=indexOf.call=toLowerCase.call=addEventListener.call=removeEventListener.call=version.call=parseFloat.call=defineMagicVariable.call=preventDefault.call=call;
		
		var name=ev.element.src; 
		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
		name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se
		if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'dnm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){
			// OpenCube menu
			if(fixOpenCube(name)){
				log('OpenCube fix');
			}
			return;
		}else if(  indexOf.call(name, 'hm_loader')>-1  ){
			// HierMenus menu
			// If we apply this fix to version 6.x the menu breaks.
			// HM support recommends checking that HM_BrowserVersion is not defined
			addEventListener.call(opera, 'BeforeScript', function(ev){ 
				match.call=removeEventListener.call=call;
				if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){
					fixHierMenus(name);
					log('HierMenus fix');
				}
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}, false);
			return;
		}else if(  indexOf.call(name, 'mmenu')>-1 || indexOf.call(name, 'milonic')>-1  ){
			// Milonic menu
			fixMilonicMenu(name);
			log('Milonic fix');
			return;
		}else if(  match.call(name, /menu(\d*_(script|com|build|var|program|compact|animation)|e)\.js$/)  ){
			// HV menu
			fixHVMenu(name);
			log('HVMenu fix');
			return;
		}else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){
			if(hostname.indexOf('usatoday.com')>-1)return; // PATCH-465
			// UDM menu
			addEventListener.call(opera, 'BeforeScript', function(ev){
				match.call=call;
				if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){
					fixUDM(name);
					log('UDM fix');
				}
			}, false);
			return;
		}else if( parseFloat.call(window, version.call())<9.5 && indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA
			defineMagicFunction.call(opera, 'fixContentHeight',
				function(oF, oT){
					document.documentElement.clientHeight=window.innerHeight;
					oF.apply(oT, slice.call(arguments, 2));
			});
			log('Novell Height function fix');
		}else if( indexOf.call(name, 'awmlib')>-1 ){
				opera.addEventListener('BeforeScript', fixLiknoAllWebMenus, false);
				log('AllWebMenus fix');
		}else if( indexOf.call(name, 'io-upload-iframe')>-1 ){ // PATCH-697, Moodle / YUI upload
		  addEventListener.call(opera, 'BeforeEventListener.load', function(e){
		    if(e.event.target.id && indexOf.call(e.event.target.id, 'io_iframe')==0){
		      try{if( e.event.target.contentDocument.body.textContent=='' )preventDefault.call(e);}catch(e){}
		    }
		  }, false);
		  log('YUI upload fix');
		}else if( indexOf.call( name, 'tiny_mce' )>-1 && 'designMode' in document && !fixed){
				log('TinyMCE detected. Various fixes applied.');
				addEventListener.call(opera, 'BeforeScript', function(e){
					indexOf.call=removeEventListener.call=call;
					if( indexOf.call(e.element.src, 'tiny_mce'>-1) ){
						setTinyMCEVersion(e);
						sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					}
				}, false);
				addEventListener.call(opera, 'BeforeEvent.load', function(e){
					match.call=call;
					if( e.event.target.tagName==='IFRAME' && ( match.call(e.event.target.name, /^mce_editor_\d/ ) || match.call(e.event.target.id, /^mce_editor_\d/ ))){
						setTinyMCEVersion();
						sendOperaEvent('bjsOnTinyMCEInstance', e.event.target);
					}
				}, false);
				fixed=true;
		}else if(indexOf.call(name,'s_code')>-1||indexOf.call(name,'omniture')>-1){ //PATCH-59
			avoidDocumentWriteAbuse(); // calls log()
		}else if(indexOf.call(name,'setdomain.js')>-1 || indexOf.call(name,'browserversion.js')>-1){
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+=' Gecko';
			shouldRestore=true;
			log('PATCH-128, Sun Webmail set domain fix');
		}else if(indexOf.call(name, '.virtualearth.net/mapcontrol')>-1 && !fixed){
			if(prestoVersionBelow('2.12.356')){// required up to 2.12.356
				addCssToDocument('.MicrosoftMap button:first-child{display:none}');
				fixed=!0;
				log('PATCH-768, MS Virtual Earth workaround applied');
			}
		}else if(!fixed && (indexOf.call(name, 'jquery.autocomplete')>-1 || indexOf.call(name, 'highslide.js')>-1 )){
			fixJQueryAutocomplete();
		}
		if( typeof window._jive_plain_quote_text!='undefined' ){
			opera.addEventListener('BeforeScript', function(e){
				indexOf.call=removeEventListener=call;
				if(indexOf.call(e.element.text, 'tinymce=')>-1){
					setTinyMCEVersion(e);
					sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					removeEventListener.call(opera, 'BeforeScript',arguments.callee,false);
				}
			}, false);
			log('PATCH-248, Jive forum embeds TinyMCE, possibly outdated versions');
		}
		// Creating event handler to restore any changed navigator properties
		if( shouldRestore ){
			addEventListener.call(opera, 'AfterExternalScript', 
				function(ev){
					removeEventListener.call=call;
					var prop;
					for(prop in navRestore) navigator[prop]=navRestore[prop];
					removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
				}
			, false);
		}
	}, false);

	try{
	//Credits Makoto Mizukami
	if('all' in document){document.all.item = function(lIndex, iSubindex){
		var i = 0, j = 0,
		byId = document.getElementById(lIndex),
		byName = document.getElementsByName(lIndex),
		retLength = byId === null ? byName.length : byName.length + 1,
		ret = byName.length === 0 ? byId : (retLength === 1 ? byName[0] : new Array(retLength));
		if(byId)return byId;
		if(retLength < 2) return ret;
	
		if(byId !== null){
			ret[0] = byId;
			j = 1;
		}
		for(i = 0; i < byName.length; i += 1){
			if(byName[i].tagName.match(/^(applet|button|form|iframe|input|map|meta|object|param|select|textarea)$/i)){
				ret[j] = byName[i];
				j += 1;
			}
		}
		ret.splice(j);
	
		return iSubindex === undefined ? ret : ret[iSubindex];
	};
	}}catch(e){}

	opera.defineMagicVariable('jive', null, function(obj){
		navigator.userAgent='Mozilla/5.0 (Windows; U; Windows NT 5.1; rv:1.9.2) Gecko/20100115 Firefox/3.6';
		log('PATCH-248, Jive forums fix');
		return obj;
	});

	opera.defineMagicVariable('TransMenu', null, function(obj){ obj.__defineSetter__('isSupported', function(){});obj.__defineGetter__('isSupported', function(){return function(){return true;}}); return obj;});

	delete showModalDialog;

	opera.defineMagicFunction( 'PopOut_Position', function(func, that){
	    var _opera=window.opera;
	    if(func.toString().match(/if\s*\(\s*window\.opera\)\s*\{\s*panel\./))delete window.opera;
	    var value = func.apply( that, [].slice.call(arguments, 2) );
	    window.opera=_opera;
	    return value;
	} );

	opera.addEventListener('BeforeJavaScriptURL', function( e ){
		unescape.call=toLowerCase.call=indexOf.call=preventDefault.call=call;
		var hash=unescape.call(self, toLowerCase.call(self.location.hash));
		if( hash  &&  indexOf.call(hash, 'javascript:')>-1   ) preventDefault.call(e);
	}, false);

	(function(tmp){
		var g=tmp.__lookupGetter__('text');
		var s=tmp.__lookupSetter__('text');
		HTMLScriptElement.prototype.__defineGetter__( 'text', function(){ return g.call(this); } );
		HTMLScriptElement.prototype.__defineSetter__( 'text', function(str){ 
			if( str.match(/jQuery\('#\w*'\)\[0\]\.onerror\(\)/) ){ return ''; }
			return s.call(this, str); 
		} );
	})(document.createElement('script'));

	opera.defineMagicVariable('HTMLArea', null, function(obj){
		obj.__defineGetter__('is_gecko', function(){return true});
		obj.__defineSetter__('is_gecko', function(){});
		obj.__defineGetter__('checkSupportedBrowser', function(){return function(){return true;}});
		obj.__defineSetter__('checkSupportedBrowser', function(){});
		var onloadmethod;
		obj.__defineSetter__('onload', function(func){ onloadmethod=func;});
		obj.__defineGetter__('onload', function(){ return function(){ try{ onloadmethod.call(this);}catch(e){ var instance=this; setTimeout(function(){instance.onload();}, 150); }}});
		log('PATCH-298, HTMLArea fix');
		return obj;
	});
	

	opera.addEventListener('BeforeExternalScript',function(ev){
		var name=ev.element.src; 
		if(!name){return;}
		if(name.indexOf('api.e-map.ne.jp/jsapi.cgi?')!=-1){
			log('PATCH-115, Zenrin Datacom E-Map API fix applied');
			if (!Event.prototype.__lookupGetter__('layerX')&&!Event.prototype.__lookupGetter__('layerY')) {
				Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });
				Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });
			}
			ev.element.src += '&force=1';
		}else if((name.indexOf('expapi/authentication')!=-1)||(name.indexOf('expapi/expmapinclude')!=-1)||(name.indexOf('rosen/authentication')!=-1)){
			log('PATCH-122, Rosenzu ASP Map Service map fix applied');
			opera.defineMagicFunction('_ch',function(){return true;});
		}else if((name.indexOf('expapi/suggest')!=-1)||(name.indexOf('rosen/suggest')!=-1)){
			log('PATCH-122, Rosenzu ASP Map Service suggestions fix applied');
			opera.defineMagicFunction('checkBrowser',function(){return true;});
		}else if(name.indexOf('http://ebook.webcatalog.jp/engine/java/7net/common/sCommonLib.js')!=-1){ 
			log('PATCH-125, Netfly TrueEBook fix applied');
			opera.defineMagicFunction('funcGetBrowser',function(){return 2;}); 
		}else if(name.indexOf('_zap/')!=-1 && name.indexOf('source/js/script.js')!=-1){ 
			log('PATCH-471, ZAPPALLAS Fortune _zap fix applied');
			opera.defineMagicFunction('checkNavigator',function(){return true;}); 
		}
	},false);

	if( navigator.getUserMedia ){
		if( ! window.URL )window.URL={};
		if( ! window.URL.createObjectURL)window.URL.createObjectURL=function(obj){return obj;}
	}

	opera.addEventListener( 'BeforeExternalScript', function(ev){
		indexOf.call=addEventListener.call=removeEventListener.call=call;
		var name=ev.element.src;
		if(!name)return;
		if(indexOf.call(name,'connect.facebook.net')>-1 && indexOf.call(name,'all.js')>-1){
			var ifrScrollingSetter = (document.createElement('iframe')).__lookupSetter__('scrolling');
			var ifrScrollingGetter = (document.createElement('iframe')).__lookupGetter__('scrolling');
			HTMLIFrameElement.prototype.__defineSetter__('scrolling', function(){ if(this.src=='')this.src='javascript:void(0);'; return ifrScrollingSetter.apply(this,arguments); });
			HTMLIFrameElement.prototype.__defineGetter__('scrolling', function(){ return ifrScrollingGetter.apply(this,arguments); });
		}
	},false);

	document.charset=undefined;

	opera.addEventListener('bjsOnTinyMCEScript', function(e){
	  if( tinyMCEVersionInfo && tinyMCEVersionInfo.majorVersion==3 && tinyMCEVersionInfo.minorVersion>1.0 ){
	    Element.prototype.appendChild=function(el){ 
	      if(el.tagName=='IFRAME' && /^\s*javascript:/.test(el.src) && el.src.indexOf('document.domain')>-1){
	        el.src='about:blank'; 
	      }
	      return appendChild.call( this, el );
	    }
	  }
	}, false);
	

	defineMagicFunction.call(opera, 'toggleRemoteSwf', function(oF, oT){
		var ua=navigator.userAgent;
		navigator.userAgent='0pera';
		oF.apply(oT, slice.call(arguments, 2));
		navigator.userAgent=ua;
	        log('PATCH-622, Unblock iCongo Platform product image zoom');
	});


	if((hostname.indexOf('tokyo.jp')>-1)||(hostname.indexOf('lg.jp')>-1)){
		if (location.pathname.indexOf('citymap')>-1) {
			window.opera.defineMagicFunction('chkBrowser',function(){
				return true;
			},false);
		}
		log('PATCH-186, tokyo.jp, lg.jp enable maps');
	} else if(hostname.contains('curriculum.degois.pt')){
		addPreprocessHandler(/MouseEvent\._eventHandler = function\(\)\s*\{\s*var e = dynapi\.frame\.event;\s*if\(!e\)\s*return true;/g, 'MouseEvent._eventHandler = function(e) {\nif(!e) return true;');
		log('PATCH-851, Fix event object detection in old DynAPI code');
	} else if(hostname.contains('onlinetb.tejaratbank.net')){
		addPreprocessHandler(/frames\[this\.name\]\.bfo_object = this;/g, 'frames[this.name].bfo_object = this;var T=this;iframe.addEventListener("load", function(){ frames[T.name].bfo_object=T; }, false);');
		log('PATCH-776, Don\'t set properties on IFRAME window object until content is loaded');
	} else if(hostname.contains('sheet.zoho.com')){
		MouseEvent.prototype.axis=2;
		log('PATCH-766, Make mouse scrolling work in Zoho spreadsheets');
	} else if(hostname.endsWith('.apple.com')){
		if(hostname.indexOf('store.')>-1){
		 addCssToDocument('#apple-header.enhanced .links li{width: auto !important}');
		}
	
		if(pathname.indexOf('/support/')>-1 || hostname.indexOf('support.')>-1 || hostname.indexOf('discussions.')>-1){
		 addCssToDocument('#globalnav li { width: auto !important}');
		}
	
		if(hostname.indexOf('daw.')>-1){
		 addCssToDocument('#globalheader #globalnav li{width: auto !important}');
		}
	
		addPreprocessHandler(/window\.onunload\s*=\s*function\(\)\{\s*location\.reload\(true\);\};/g,'');
	
		if (hostname.endsWith('itunes.apple.com')) {
			navigator.userAgent = navigator.userAgent.replace(/OS X (\d+).(\d+).(\d+)+;/,'OS X $1_$2_$3;');
		}
		log('PATCH-387, Make Apple Store menu visible\nPATCH-387, Enable menu on Apple support pages\nPATCH-387, Enable menu on Apple community pages\nPATCH-846, apple.com: don\'t reload from within unload handler\nPATCH-924, apple.com - reformat OS X version string with underscores');
	} else if(hostname.endsWith('aldoshoes.com')){
		document.__defineSetter__('domain', function(){});
		log('PATCH-808, aldoshoes.com - fix broken document.domain settings');
	} else if(hostname.endsWith('allbankonline.in')){
		HTMLElement.prototype.onselectstart = true;
		log('PATCH-889, allbankonline.in: prevent mousedown prevention');
	} else if(hostname.endsWith('antikvar.hu')){
		addCssToDocument('#header a{font-size:11px}');
		log('PATCH-890, antikvar.hu: font fallback breaks layout');
	} else if(hostname.endsWith('caisse-epargne.fr')){
		addPreprocessHandler(/this\._changeHandler\);if\s*\(Sys\.Browser\.agent\s==\sSys\.Browser\.Opera\)/g, ' this._changeHandler);if(false)');
		log('PATCH-798, Avoid browser sniffing that breaks typing');
	} else if(hostname.endsWith('cfe.urssaf.fr')){
		opera.defineMagicFunction('navigateurAutorise',function(){return true});
		log('PATCH-807, urssaf.fr: block browser block');
	} else if(hostname.endsWith('clarkhoward.com')){
		addCssToDocument('blockquote{content: normal !important;}');
		log('PATCH-844, clarkhoward.com: abouse of CSS content property');
	} else if(hostname.endsWith('directbus.com.mx')){
		if(pathname=="/")location.href='/home.html';
		log('PATCH-895, directbus.com.mx: avoid freezing Flash frontpage');
	} else if(hostname.endsWith('ebayclassifieds.com') && pathname.match(/\/PostAd/)){
		navigator.userAgent = navigator.userAgent.replace(/Opera/g,'0pera');
		log('PATCH-784, eBay Classifieds - disable block on image uploader');
	} else if(hostname.endsWith('garmin.com')){
		opera.defineMagicFunction('eligible', function() { return true; });
		opera.defineMagicFunction('detectOSBrowser', function(realFunc, realThis, inOS, inBrowser) {
			inBrowser = "Firefox";
			return realFunc(inOS, inBrowser);
		});
		opera.addEventListener('AfterScript', function(e){
			if (e.element.src.indexOf('GarminDeviceControl.js')>-1) {
				BrowserSupport.isBrowserSupported = function() { return true; }
			}
		},false);
	
		if (document.location.pathname.indexOf('savePOI.htm')>-1) {
			document.addEventListener('DOMContentLoaded', function(e){
				var els = document.querySelectorAll("a[href='javascript:history.back()']");
				for (var i=0, len=els.length; i<len; i++) {
					els[i].href = 'javascript:window.history.go(-3)';
				}
			},false);
		}
		log('PATCH-855, garmin.com - allow Opera to install and use Garmin Communicator Plugin\nPATCH-856, garmin.com - go back multiple pages after saving POI');
	} else if(hostname.endsWith('gay.com')){
		opera.defineMagicFunction('isSupportedBrowser', function() { return true; });
		log('PATCH-879, gay.com - work around browser blocking');
	} else if(hostname.endsWith('github.com')){
		addCssToDocument('.social-count::before {margin-right:14px;margin-top:0;}.social-count::after {margin-right:13px;margin-top:0;}');
		log('PATCH-815, github: work around misplaced arrows (Opera bug)');
	} else if(hostname.endsWith('gsmtronix.com')){
		fixHVMenu('dummy.js');
		log('PATCH-842, gsmtronix.com: HVmenu');
	} else if(hostname.endsWith('help.sap.com')){
		navigator.appName = 'Netscape';
		navigator.appVersion = '5.0';
		log('PATCH-833, help.sap.com : fool sniffing to make frameset complete');
	} else if(hostname.endsWith('hipmunk.com')){
		if(pathname.indexOf('/flights')==0){
		 addCssToDocument('div#header table td + td{width: 60%;}');
		}
		log('PATCH-862, hipmunk.com: avoid header table cell collapse. Core bug.');
	} else if(hostname.endsWith('hotels.ctrip.com')){
		addPreprocessHandler(/win.addEventListener/g,'ifm.addEventListener',true,function(elm){ return elm.src&&elm.src.indexOf('c_result.map.js')>-1});
		log('PATCH-857, hotels.ctrip.com: word around iframe load event order issue with Opera');
	} else if(hostname.endsWith('ieee.org')){
		(function(ac){
			Element.prototype.insertBefore=function(newChild, refChild){
				if(newChild.src && newChild.src.indexOf('https://securesso.ieee.org/ieeevendorsso/ssocookievalidator')>-1){
					if( !document.getElementById('ballotlogin') ){
						var parent=this;
						setTimeout(function(){ ac.call(parent, newChild, refChild); }, 100);
						return;
					}
				}
				return ac.call(this,newChild, refChild);
			}
		})(Element.prototype.insertBefore);
		
		log('PATCH-850, Postphone insertion of JSONP data source until we\'ve parsed the element the data is meant to be inserted into');
	} else if(hostname.endsWith('imf-wb.2012tokyo.mof.go.jp')){
		addCssToDocument('#TopPage .category-section li{float:left;}#HeaderRight{float:right;}');
		log('PATCH-910, 2012tokyo: avoid inline-block wrapping');
	} else if(hostname.endsWith('ingdirect.com')){
		addCssToDocument('div.alert.caution{display:none}');
		log('PATCH-902, ingdirect.com: avoid browser blocking');
	} else if(hostname.endsWith('insubuy.com')){
		HTMLElement.prototype.onselectstart = true;
		log('PATCH-703, insubuy.com: don\'t prevent mouse click');
	} else if(hostname.endsWith('khanacademy.org')){
		fixTransitionEndCase();
		log('PATCH-892, Fix transition event case to un-confuse jQuery');
	} else if(hostname.endsWith('loyalbank.com')){
		HTMLElement.prototype.onselectstart = true;
		log('PATCH-707, loyalbank.com: prevent mousedown prevention');
	} else if(hostname.endsWith('maerskfleet.com')){
		navigator.userAgent = 'Firefox'+navigator.userAgent;
		window.opera = null;
		
		log('PATCH-733, maerskfleet.com - work around browser sniffing');
	} else if(hostname.endsWith('mail.live.com')){
		function fixButton(e) {
			if (e.button == 1) {
				e.__defineGetter__('button', function() { return 0 });
			}
		};
		window.addEventListener('mousedown', fixButton, true);
		window.addEventListener('mousemove', fixButton, true);
		window.addEventListener('mouseup', fixButton, true);
		window.addEventListener('click', fixButton, true);
	
		addCssToDocument('.c_is { display: inline-block }');
	
		opera.addEventListener('BeforeScript', function (e) {
			if (e.element.src.indexOf('fullex.js') > -1) {
				e.element.text = e.element.text.replace('for(i.isArray(t)||(t in e?t=[t]:(t=i.camelCase(t),t=t in e?[t]:t.split(" "))),', 'if (!i.isArray(t))(t in e?t=[t]:(t=i.camelCase(t),t=t in e?[t]:t.split(" ")));for(');
			}
		}, false);
		
	
		HTMLImageElement.prototype.__defineGetter__('complete', function(){ if(this.src.match(/\.js$/))return false; return true; });
	
		var styleSetterLookupMethod = document.createElement('span').style.__lookupSetter__;
		 CSSStyleDeclaration.prototype.__lookupSetter__ = function(prop){
			return styleSetterLookupMethod.call(document.createElement('span').style, prop);
		 };
		log('CORE-17444, Fix drag and drop in Hotmail\nCORE-17447, Mispositioned sprites due to missing CSS\nPATCH-770, Fix minified jQuery on Hotmail\nPATCH-823, img.complete must be false while loading a .js file\nDSK-235885, Hotmail uses lookupGetter on prototypes, not instances');
	} else if(hostname.endsWith('members.webs.com')){
		opera.addEventListener('BeforeScript', function (e) {
			if (e.element.src.indexOf('underscore-base.js') > -1) {
				e.element.text = e.element.text.replace(/this\.document\.styleSheets/gi, 'this.styleSheets');
			}
		}, false);
		
		log('PATCH-743, webs.com - fix reference to stylesheet variable');
	} else if(hostname.endsWith('mog.com')){
		opera.addEventListener('BeforeScript',function(ev){
			var name=ev.element.src; 
			if(!name){return;}
			if(name.indexOf('player.min.js')>-1){
				ev.element.text = ev.element.text.replace(/a.supported_browsers\s*=\s*\[/,'a.supported_browsers=["Opera",');
			}else if(name.indexOf('global.js')>-1){
				ev.element.text = ev.element.text.replace(/Mog.supported_browsers\s*=\s*\[/,'Mog.supported_browsers=["Opera",');
			}
		},false);
		
		log('PATCH-737, mog.com - report Opera as a supported browser');
	} else if(hostname.endsWith('mycoast.cccd.edu')){
		opera.defineMagicVariable('is_fox',function(){return true},null);
		log('PATCH-804, mycoast.cccd.edu: block browser block');
	} else if(hostname.endsWith('myfreecams.com')){
		addCssToDocument('div#player_main{width:auto !important;height:auto !important;}div#friends_container{height:auto !important}');
		log('PATCH-891, myfreecams.com: let height be auto to fill space');
	} else if(hostname.endsWith('myharmony.com')){
		opera.defineMagicFunction('IsSupportedPlatform',function(){return true;});
		log('PATCH-706, myharmony.com - work around browser blocking');
	} else if(hostname.endsWith('myportfolio.nbcn.ca')){
		opera.defineMagicFunction('checkBrowserVersion',function(){});
		log('PATCH-805, nbcn.ca - block browser block');
	} else if(hostname.endsWith('office.microsoft.com')){
		opera.defineMagicFunction('FIsFirefox',function(){return true});
		opera.defineMagicFunction('ResizeVideoControl',function(oF,oT){
			var value=oF.apply(oT, Array.prototype.slice.call(arguments, 2));
			document.getElementById('objMediaPlayer').outerHTML = document.getElementById('objMediaPlayer').outerHTML;
			return value;
		});
		log('PATCH-513, office.microsoft.com: re-initialize video player after applying page overflow');
	} else if(hostname.endsWith('oly-forum.com')){
		addCssToDocument('#navigation ul#menu li { margin-left: 0; }');
		log('PATCH-922, oly-forum.com: better placemnet of menu dropdown');
	} else if(hostname.endsWith('onlystudy.cn')){
		document.addEventListener('DOMContentLoaded',function(){
			var elm = document.getElementById('loginpw');
			if(elm)elm.setAttribute('onKeyDown',elm.getAttribute('onKeyDown').replace(/KsdOnKeyDown\(\)/,'KsdOnKeyDown(e)'))
		},false);
		log('PATCH-873, Make sure an event is passed in to the handler');
	} else if(hostname.endsWith('openphoto.me')){
		fixTransitionEndCase();
		log('PATCH-874, Fix transition event case to un-confuse jQuery');
	} else if(hostname.endsWith('pb.com')){
		navigator.userAgent=navigator.userAgent.replace( /Opera/g, '0pera not Mozilla' );
	
		document.addEventListener('DOMContentLoaded', function(){
			if( document.selectSingleNode('//img[contains(@src, "LabelCutLine.")]') ){
				for(var frame,i=0; frame=parent.frames[i];i++){
				 frame.print=makePrint(frame, frame.print);
				}
			}
			function makePrint(frame,realPrint){
				return function(){
					var docClone=frame.document.documentElement.cloneNode(true);
					docClone.appendChild(document.createElement('script')).appendChild(document.createTextNode("setTimeout(function(){var p,style; (p=document.body.appendChild(document.createElement('p'))).appendChild(document.createTextNode('Please close this tab when your label is finished printing'));p.className='noprint';p.setAttribute('style', 'text-align:center; font-weight:bold; font-size: 1.5em;color:red');(style=document.body.appendChild(document.createElement('style'))).appendChild(document.createTextNode('.noprint{display:none}'));style.media='print';}, 2000);"));
					var win=window.open( '', '_blank', 'width=750,height='+(frame.document.body.offsetHeight+150));
					try{
						win.document.replaceChild(docClone, win.document.documentElement);
					}catch(e){
						win.close();
						realPrint.call(frame);
						return;
					}
					setTimeout(function(){
						win.print();
					}, 100);
				}
			}
		}, false);
		
		log('PATCH-774, Fix postage label printing failure with eBay/PayPal: avoid browser sniffing\nPATCH-774, Fix postage label printing failure with eBay/PayPal: frame.print() bug workaround');
	} else if(hostname.endsWith('pinterest.com')){
		addCssToDocument('div.NoInput input[data-text-on="On"]{display: inherit !important;visibility: hidden;}');
		log('PATCH-811, pinterest.com: Opera fails to update status of display:none checkbox');
	} else if(hostname.endsWith('quora.com')){
		(function(sTo){
			var lastEvt=new Date();
			opera.addEventListener('BeforeEventListener.scroll', function(e){ 
				if( (new Date)-lastEvt < 2000 ){
					e.preventDefault();
				}else{
					lastEvt=new Date();
				}
			}, false);
			window.setTimeout = function(f,t){
				if(t==50){
					t=450;
				}
				return sTo.call(this, f, t);
			}
		})(setTimeout);
		
		log('PATCH-863, Throttle scroll events and certain timeouts to improve Quora performance');
	} else if(hostname.endsWith('razr.com')){
		addPreprocessHandler(/b=b\.substring\(c\+4,b\.length\);c=b\.indexOf\("\)"\);/,'b=b.substring(c+5,b.length);c = b.indexOf(\'")\');', true, function(elm){return elm.src&&elm.src.indexOf('main.js')>-1});
		log('PATCH-876, razr.com: CSS url() argument takes quotes');
	} else if(hostname.endsWith('reservations.disney.go.com')){
		opera.defineMagicVariable('Figment', null, function(obj){
			var str=Element.prototype.__defineSetter__;
			Element.prototype.__defineSetter__=function(name, func){
				if( name in document.createElement('div') )return;
				return str.call(this, name, func);
			}
			return obj;
		});
		
		log('PATCH-794, Prevent broken innerHTML setter on Disney booking site');
	} else if(hostname.endsWith('sears.com')){
		addCssToDocument('.scrollWidget .slider { top: 0; } .thumbWidget .slider2 { top: 0; }');
		log('PATCH-847, sears.com - fix moving product thumbnail images');
	} else if(hostname.endsWith('shopping.com')){
		navigator.appName = "Netscape";
		log('PATCH-836, shopping.com - work around browser sniff');
	} else if(hostname.endsWith('staples.com')){
		(function(){
			var xhrDocGetter=(new XMLHttpRequest).__lookupGetter__('responseXML');
			XMLHttpRequest.prototype.__defineGetter__('responseXML', function(){
				var doc=xhrDocGetter.call(this);
				if(!doc)return doc;
				for(var elms=doc.getElementsByTagName('*'),elm,i=0;elm=elms[i];i++){
					if(elm.hasAttribute('disable-output-escaping'))elm.removeAttribute('disable-output-escaping');
				}
				return doc;
			});
		})();
		
		log('PATCH-769, Opera throws when XSL variable has disable-output-escaping attribute, breaks sorting on staples.com');
	} else if(hostname.endsWith('tedxboulder.com')){
		fixTransitionEndCase();
		log('PATCH-874, Fix transition event case to un-confuse jQuery');
	} else if(hostname.endsWith('washingtonpost.com')){
		addPreprocessHandler(  /if\(\(b\.webkit\|\|b\.gecko\)&&y\.type==="css"\)/  ,'if((b.webkit||b.gecko||b.opera)&&y.type==="css")' , true, function(el){return el.src.indexOf('yui/yui-min.js')>-1;} );
	
		avoidDocumentWriteAbuse(/<div id="trc_related_container".*/);
		
	
		opera.defineMagicVariable('goodBrowser',function(){return true},null);
		
		log('PATCH-633, No load fires for LINK element if href returns an empty file with text/javascript type - breaks Washingtonpost.com slideshows\nPATCH-494, Washingtonpost: avoid articles being overwritten in race condition\nPATCH-832, Report that Opera is a good browser on The Washington Post');
	} else if(hostname.endsWith('westelm.com')){
		opera.addEventListener('BeforeExternalScript',function(ev){
			var name=ev.element.src; 
			if(!name){return;}
			if(name.indexOf('mqResultsControllerMini.js')>-1){
				window.navigator.appName = "Netscape";
				opera.defineMagicFunction('mqXmlToStr', function(oRealFunc, oThis, xmlDoc) {
					var serializer = new window.XMLSerializer();
					return serializer.serializeToString(xmlDoc).replace('<?xml version="1.0"?>','');;
				});
			}
		},false);
		log('PATCH-750, westelm.com - Fix compatibility with old version of MapQuest API');
	} else if(hostname.endsWith('www.auf.org')){
		opera.defineMagicFunction('OldBrowserDetect',function(){return false})
		log('PATCH-795, auf.org: work around broken sniffer');
	} else if(hostname.endsWith('www.bankofamerica.com')){
		if(pathname.indexOf('/activate')==0){
		opera.addEventListener('BeforeCSS', function(e) {
			if (e.element.href && e.element.href.indexOf('cardactivation-ie.css')>-1) {
				e.element.href = e.element.href.replace(/cardactivation-ie.css/, 'cardactivation-moz.css')
			}
		}, false);
		}
		log('PATCH-875, bankofamerica: don\'t use IE stylesheet');
	} else if(hostname.endsWith('www.finanzas.com')){
		addCssToDocument('body{content: normal !important}');
		log('PATCH-901, finanzas.com: work around generated content abuse');
	} else if(hostname.endsWith('www.lingvo.ru')){
		addPreprocessHandler(/a\.unselectable="on";if\(window\.opera\)\{a\.onmousedown=function\(\)\{return\s*false\}\}/,'a.unselectable="on";if(!window.opera){a.onmousedown=function(){return false}}');
		log('PATCH-925, lingvo.ru: prevent mousedown prevention');
	} else if(hostname.endsWith('www.shaw.ca')){
		opera.defineMagicFunction('detectBrowserVersion',function(){return true})
		log('PATCH-788, shaw.ca: work around browser sniff');
	} else if(hostname.endsWith('www.udemy.com')){
		window.addEventListener('load',
		function(){
			document.getElementById('login').style.visibility = 'hidden';
			document.querySelector('a.goto-login-btn').addEventListener('click',function(){
				document.getElementById('signup').style.visibility = 'hidden';
				document.getElementById('login').style.visibility = 'visible';
			},false);
			document.querySelector('a.goto-signup-btn').addEventListener('click',function(){
				document.getElementById('signup').style.visibility = 'visible';
				document.getElementById('login').style.visibility = 'hidden';
			},false);
		}
		,false);
		
	
		opera.addEventListener('BeforeEvent.click', function(e) { 
			if (e.event.target.className == 'placeholder') { 
				e.event.target.previousSibling.focus();
			}
		}, false); 
		log('PATCH-853, udemy.com: Opera doesn\'t support 3Dtransforms yet\nPATCH-871, udemy.com: work around lack of pointer-events in Opera');
	} else if(hostname.indexOf("cang.baidu.com") != -1 ){
		window.opera.defineMagicFunction(
			"top",
			function(originalFunction, oThis, oParam1, oParam2) {
				return originalFunction();
			}
		);
		
		log('OTW-4761, cang.baidu.com for Baidu SouCang can\'t display saved items, window.top');
	} else if(hostname.indexOf('.aaa.com')>-1){
		opera.defineMagicVariable('ttp_isFirefox', function(){return true;}, null);
		log('PATCH-646, Fix AAA TripTik sniffing');
	} else if(hostname.indexOf('.aol.') >-1){
		/* AOL */
	
	
		if(hostname.indexOf('.aol.fr')>-1){
			document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='SAF';}, false);
			log('PATCH-563, aol.fr: give Opera better styling');
		}
		if(hostname.indexOf('aol.com')>-1){
			avoidDocumentWriteAbuse();
		
			addPreprocessHandler(/\|\|adsUA\.indexOf\(\'opera\'\)>-1/,'');
			log('188197, Making sure AOL pages are not overwritten by ad script\nPATCH-608, Aol.com: Avoid ad overwrite');
		}
		log('0, AOL');
	} else if(hostname.indexOf('.bmo.com')>-1){
		addPreprocessHandler(/return "\(\?:"\+([^+]+)\+([^+]+)\+([^+]+)\+"\)\?";/, 'return ($1+$2+$3=="") ? "(?:)" : "(?:"+$1+$2+$3+")?";' );
		log('PATCH-676, RegExp parsing exception confuses Dojo, breaks BMO.com interface');
	} else if(hostname.indexOf('.delta.com')>-1){
		addCssToDocument('fieldset#content{clear: both;}');
		log('PATCH-627, Fixing misaligned fieldset on Delta itinerary page');
	} else if(hostname.indexOf('.ebay.')>-1 || hostname.indexOf('.ebaydesc.')>-1){
		/* eBay issues */
	
	
		// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions
	
		function resizeIframesAndPassSizeOn(e){
			if(e && e.type==='message' && e.origin.indexOf('ebaydesc')>-1){
				for(var iframes=document.getElementsByTagName('iframe'),iframe,i=0;iframe=iframes[i];i++){
					if(iframe.src.indexOf(e.origin)>-1){
						iframe.style.height=(20+parseInt(e.data))+'px';
					}
				}
			}
			if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
		}
		window.addEventListener('message', resizeIframesAndPassSizeOn, false);
		
	
	
		if(hostname.indexOf('.ebay.')>-1){
			opera.addEventListener('BeforeEvent.keydown', function(e) { 
				if (e.event.shiftKey && ( e.event.keyCode>36 && e.event.keyCode<41 ) ) 
					e.preventDefault(); 
			}, false); 
			
		
			 window.addEventListener('load',function(e){
				if( top==self && typeof top.opener ==='object' && window.ebay && ebay.oDocument && ebay.oDocument.oPage && typeof ebay.oDocument.oPage.onMSAResponse === 'function' ){
					var _originalFunc=ebay.oDocument.oPage.onMSAResponse;
					ebay.oDocument.oPage.onMSAResponse=function(){
						try{
							var retval=_originalFunc.apply(this, arguments);
						}catch(e){
							var json='["'+Array.prototype.join.call(arguments, '", "')+'"]';
							top.opener.postMessage('browser.js message: '+json, location.protocol+'//'+document.domain);
							window.close();
						}
						return retval;
					}
				}
			},false);
			
			window.addEventListener('message', function(e){
				var secTest=new RegExp( document.domain+'$', '' );
				if( e.origin.match(secTest) ){
					if(/^browser\.js message: /.test(e.data)){
						ebay.oDocument.oPage.updatePhoto.apply(ebay.oDocument.oPage, JSON.parse(e.data.substring(20)));
					}
				}
			}, false);
			
		
			if(hostname.indexOf('signin.ebay.')>-1){
			 addCssToDocument('#but_sgnBt, #but_register_signin{margin-left:0;padding-left: 8px;}');
			}
			log('PATCH-550, eBay: make spatnav in menu work\nPATCH-268, eBay mixes security origins, basic photo upload fails\nPATCH-565, ebay: make sign in buttons accessible with spatnav');
		}
		if(hostname.indexOf('.ebaydesc.')>-1){
			window.addEventListener('load', function(){ 
				setTimeout(function(){
					if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
				}, 100); 
			}, false);
			setTimeout(function(){
				if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
			}, 600);
			
			log('PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)');
		}
		log('0, eBay');
	} else if(hostname.indexOf('.evaair.com')>-1){
		navigator.appName='Netscape';
		log('PATCH-688, evaair.com: broken sniffing');
	} else if(hostname.indexOf('.geoaccess.com')>-1){
		navigator.appName='Netscape';
		opera.defineMagicVariable('is_nav6up', function(){return true},null);
		log('PATCH-314, PacifiCare doctor finder blocks Opera');
	} else if(hostname.indexOf('.google.')>-1){
		/* Google */
	
	
		if(hostname.indexOf('adwords.google.') > -1){
			window.navigator.product = 'Gecko';
			log(' PATCH-332, Fix disabled charts on Google AdWords');
		}
		if(hostname.indexOf('code.google.')>-1 && (pathname.indexOf('diff')>-1 || pathname.indexOf('detail')>-1 )){
			addCssToDocument('div.diff>pre>table{white-space: normal;}div.diff>pre>table th, div.diff>pre>table td{white-space: pre-wrap;}');
			log('PATCH-321, Work around pre inheritance into tables on Google Code');
		}
		if(hostname.indexOf('docs.google.')>-1){
			opera.addEventListener('BeforeScript', function (e) {
			 if (e.element.src.indexOf('trix_waffle') > -1 && e.element.src.indexOf('_core') > -1) {
			  e.element.text = e.element.text.replace(/indexOf\("Opera"\)/g, 'indexOf("Opra")').replace(/"Gecko"==/g, '"Gecko"!=').replace(/"DOMMouseScroll"/g, '"mousewheel"').replace(/\.charCode\:0\)\:[^\?]+\?/g,'.charCode:0):!0?');
			 }
			}, false);
		
			addCssToDocument('td.doclist-td-checkbox, td.doclist-td-name, td.doclist-td-star {width:auto !important}');
		
			document.addEventListener('load', function(e){
				if(e.target.tagName && e.target.contentWindow){
					e.target.contentWindow.addEventListener('keypress', function(e){
						if(e.which===0){
							e.__defineGetter__('keyCode', function(){return 0});
						}
					}, true);
				}
			}, true);
			
			log('PATCH-382, Google Spreadsheets cell size and column label size mismatch\nPATCH-517, docs.google: make document names visible\nPATCH-278, We should not send keypress events for navigation- and function keys');
		}
		if(hostname.indexOf('mail.google.')>-1){
			addCssToDocument('div.wl{overflow:inherit}body.aam{position:inherit}');
		
			addCssToDocument('body.editable.LW-avf{font-size: small !important}');
			log('PATCH-566, GMail: override overflow and fixed position styles to improve scrolling performance\nPATCH-582, GMail: override workaround for old font-size bug in Opera');
		}
		if(hostname.indexOf('maps.google.')>-1 || hostname.indexOf('mapy.google.')>-1){
			opera.addEventListener('BeforeEventListener.mousedown', function(e){if(e.event.target.tagName=='OPTION')e.preventDefault()}, false);
			log('PATCH-610, GMaps: avoid autoclose of problem reporting dialog');
		}
		if(hostname.indexOf('plus.google')>-1){
			addCssToDocument('div.B-u-nd-nb, div.s-r-Ge-ec {display:block}');
			log('PATCH-526, G+: avoid tall narrow posts due to word-wrap in table ');
		}
		log('0, Google');
	} else if(hostname.indexOf('.hbo.com')>-1){
		opera.defineMagicFunction('olderBrowserUnsupported', function(){return false;});
		opera.defineMagicFunction('browserVersionGood', function(){return true;});
		log('PATCH-399, Avoid browser detection on hbo.com');
	} else if(hostname.indexOf('.hotwire.com')>-1){
		addCssToDocument('div.OldBrowserPopupComp, div.mask{display:none !important}');
		log('PATCH-390, Hide browser warning on hotwire');
	} else if(hostname.indexOf('.in.gr')>-1){
		document.addEventListener('DOMContentLoaded', function(){
		 elm = document.getElementById('ticker-area');
		 if(elm){
		  elm.innerHTML=elm.innerHTML.replace(/&nbsp;/,'');
		 }
		},false);
		log('PATCH-367, Correct placement of marquee on in.gr');
	} else if(hostname.indexOf('.ing.nl')>-1){
		if(hostname.indexOf('ideal.')==0)(function(ib){
		  Element.prototype.insertBefore=function(newC, refC){
		    if(newC.tagName=='SCRIPT' && newC.src && newC.src.indexOf('lpt/start.js')>-1){
		      var context=this;
		      window.addEventListener('load', function(){ ib.call(context, newC, refC); }, false);
		      return newC;
		    }
		    return ib.apply(this, arguments);
		  }
		})(Element.prototype.insertBefore);
		
	
		opera.defineMagicFunction('$Es', function(){});
		window.controllers={}; // detecting some-whatever-Gecko-proprietary-object?
		navigator.productSub=20031002; // anything larger than 20031001
		
	
		Element.prototype.getAttribute =(function (getAttribute){
			return function(name){
				for(var attr,i=0;attr=this.attributes[i];i++){
					if(attr.name==name)return attr.value;
				}
				return null;
			}
		})(Element.prototype.getAttribute);
		log('PATCH-690, Postphone inserted script which confuses frame breaker if run immediately\nPATCH-76, Work around sniffing in old BackBase library on ing.nl\nPATCH-76, Make sure getAttribute() does not confuse an old BackBase lib\'s code where it uses namespace-like syntax');
	} else if(hostname.indexOf('.intel.com')>-1){
		addCssToDocument('div#browserdetectid{display:none !important}');
		log('PATCH-723, intel.com: hide "old_browser" message');
	} else if(hostname.indexOf('.nab.com.au')>-1){
		opera.defineMagicFunction('detectBrowser', function(){return 'correct';});
		log('PATCH-643, nab.com.au: avoid browser warning');
	} else if(hostname.indexOf('.sina.com.cn')>-1){
		navigator.userAgent += ' not Gecko';
		log('PATCH-614, sina.com: video doesn\'t play due to missing script readystate support');
	} else if(hostname.indexOf('.t-online.de')>-1){
		if(hostname.indexOf('unterhaltung')>-1){
					//Fix browser detection
					opera.defineMagicFunction( 'allResultsOK', function(){return true;} );
					// Fix plugin detection
					opera.defineMagicVariable( 'fHasWMP64', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'fHasWMP7', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'WMPVer', function(){ try{return fHasWMP64?'6.4':'unknown'}catch(e){return '6.4'} }, null )
			opera.addEventListener( 'BeforeScript',function(e){
				replace.call=call;
				e.element.text=replace.call(e.element.text,  'playerframe.Player.url=url;', 'playerframe.Player.url=url;nplayerframe.Player.Open(url);' );
			},false );
					// use TYPE as well as CLASSID on OBJECT tags in markup
					var objId='Player';
					var objref=null;
					document.addEventListener('DOMContentLoaded', function(e){ 
						if( ! (objref=document.getElementById(objId) ) ) return;
						if(objref.getAttribute('classid')=="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6")objref.type='application/x-mplayer2';
					}, false);
					// Remove UI that depends on ActiveX scripting. Built-in WMP UI will do..
					document.addEventListener('DOMContentLoaded', function(e){ 
						var pb=document.getElementById('playBtn');
						var wmp=document.getElementById('playerframe');
						if( pb&&wmp ){
							pb.parentNode.style.visibility='hidden';	wmp.style.visibility='visible';
							try{ document.images.tonaus.height=0;document.images.tonaus.width=0;}catch(e){}
						}
					}, false);
		}
	
		if(href.indexOf('__license=delivered')>-1){
			location.replace( location.href.replace( /__license=delivered/, '?license=delivered' ) );
		}
		
	
		if(hostname.indexOf('email.')>-1){
		HTMLFormElement.prototype.submit=(function(s){
			return function(){ 
				var doc = this.target=='' ? this.ownerDocument : this.ownerDocument.getElementsByName(this.target)[0];
				if( doc ){
					doc.__defineGetter__('readyState', function(){return 'loading'});
				}
				return s.apply(this,arguments);
			}
		})(HTMLFormElement.prototype.submit)
		}
	
		if(hostname.indexOf('email.')>-1){
		document.addEventListener('load', function(e){
			if( e.target instanceof HTMLIFrameElement ){
				e.target.contentDocument.body.__defineGetter__('scrollHeight', function(){
					return this.ownerDocument.documentElement.offsetHeight; });
			}
		}, true);	
		}
		log('225374,  video problems on T-online.de\n231082,  video problems on T-online.de, WMP license installation\nPATCH-458, Indicate loading state while a form submit is in progress, fixes attachment upload on T-Online\nPATCH-474, Avoid compose IFRAME resize (body.scrollHeight should be document\'s height)');
	} else if(hostname.indexOf('.terra.c')>-1){
		//terra.cl, terra.com.{ar,br,mx,co,pe}
		opera.defineMagicVariable('SonoraBrowserDetect', function(obj){ obj.browser='Firefox'; return obj; }, null)
		log('PATCH-623, Terra music: work around browser sniffing');
	} else if(hostname.indexOf('.traffic.com')>-1){
		addPreprocessHandler('(C.Opera)?document.body["client"+B]:document.documentElement["client"+B]', '(C.Opera)?document.documentElement["client"+B]:document.documentElement["client"+B]');
		
		log('PATCH-742, Work around browser sniffing that breaks traffic.com');
	} else if(hostname.indexOf('.tv.com')>-1){
		opera.addEventListener('BeforeCSS', function(e){
		  e.cssText = e.cssText.replace(/br{content:"&nbsp;";/g,'br{ ');
		}, false);
		log('PATCH-720, tv.com: workaround misuse of CSS generated content');
	} else if(hostname.indexOf('.ulead.') >-1){
		 fixMilonicMenu('mmenu.js');
		log('DSK-130832, Ulead.com old Milonic menu');
	} else if(hostname.indexOf('.usps.com')>-1){
		opera.defineMagicVariable('browserSupported',function(){return true},null);
		log('PATCH-718, USPS: work around old browser sniff');
	} else if(hostname.indexOf('.videoload.de')>-1){
				if( hostname.indexOf('vod')>-1 ){ // 231082
					navigator.userAgent+=' Firefox';
				}
		
	
		window.external=window.external||{};
		
		log('231082,  video problems on T-online.de, VOD section\n226414,  video problems on T-online.de, no window.external detection');
	} else if(hostname.indexOf('.yahoo.')>-1){
		/* Yahoo! */
	
	
		// PATCH-510, Yahoo!: Enable logging in with other auth services, work around cross-domain navigation block
	
		if( location.hostname.indexOf('open.login.yahoo')>-1 && window.opener ){
			opera.addEventListener('BeforeScript', function(e){
				e.element.text = e.element.text.replace( /(o\.top\.location\.href\s*=\s*"([^"]*)");/, 'try{$1}catch(e){o.top.postMessage("$2", location.protocol+"//"+ location.hostname.replace(/open\./, ""));}' );
			}, false);
		}else if(location.hostname.indexOf('login.yahoo')>-1){
			window.addEventListener('message', function(e){
				if(e.origin==location.protocol+'//'+'open.'+location.hostname && /https?:\/\//.test(e.data)){
					location.href=e.data;
				}
			}, false);
		}
		
	
	
		if(hostname.indexOf('.mail.yahoo.')>-1){
			if(self==top&&location.search.indexOf('reason=ignore')==-1){
				document.addEventListener('DOMContentLoaded',function(){
					if(el=document.querySelector('a[href*="reason=ignore"]')){
						el.click();
					}else if(document.evaluate('//a[contains(@href,"/firefox")]', document.body, null, 6, null).snapshotLength && document.evaluate('//a[contains(@href,"/internetexplorer/")]', document.body, null, 6, null).snapshotLength && document.evaluate('//a[contains(@href,"/safari/")]', document.body, null, 6, null).snapshotLength){
						location.search='?reason=ignore'+location.search.replace(/^\?/, '&');
					}
				},false);
			}
			log('PATCH-325, Y!Mail: click continue link in unsupported browser page');
		}
		if(hostname.indexOf('.mail.yahoo.')>-1&& ( href.indexOf( '/neo/launch' )>-1 || href.indexOf( '/dc/launch' )>-1 )){
			opera.addEventListener('BeforeEventListener.mousedown', function(e){
				if(e.event.target.tagName=='INPUT' && e.event.target.id=='subject-field'){
					e.preventDefault();
				}
			},false);
			
		
			document.addEventListener('load', function(e){
				if(e.target && e.target.tagName=='IFRAME'){
					var ifrWin, gCS;
					try{ifrWin=e.target.contentWindow.location&&e.target.contentWindow.document.URL&&e.target.contentWindow;}catch(e){}
					if(ifrWin){
						gCS=ifrWin.getComputedStyle;
						ifrWin.getComputedStyle=function(el, str){
							var cssobj=gCS.apply(this,arguments);
							if( el.tagName=='FONT' && el.getAttribute('face') )cssobj.__defineGetter__( 'fontFamily', function(){return el.getAttribute('face');} );
							return cssobj;
						}
					}
				}
			}, true);
			
		
			document.addEventListener('load', function(e){
				if(document.getElementById('rtetext') && document.getElementById('rtetext').getElementsByTagName('iframe').length)
					document.getElementById('rtetext').getElementsByTagName('iframe')[0].style.height = '97%';
			}, true);
			log('PATCH-417, Y!Mail Allow focusing subject field by mouse click in\nPATCH-418, Y!Mail Fix inserting links in mail compose screen\nPATCH-460, Y!Mail Prevent hidden text when composing long e-mails');
		}
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){
			location.href='/dc/launch?sysreq=ignore';
			
			log('194334, Y!Mail work around browser blocking');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){
			if( location.search.indexOf('sysreq=ignore')>-1 ){
				Node.prototype.selectSingleNode=undefined;
				Node.prototype.selectNodes=undefined;
			}
			log('194334, Y!Mail remove selectSingleNode and selectNodes ("old new mail" only)');
		}
		if(hostname.indexOf('finance.yahoo.')>-1){
			navigator.userAgent = 'Mozilla/5.0 (Windows NT 5.1; rv:6.0) Gecko/20100101 Firefox/6.0'; 
			log('PATCH-297, Fool browser sniffing that prevents stock ticker on Yahoo Finance');
		}
		if(hostname.indexOf('finance.yahoo.com')>-1){
			opera.addEventListener('BeforeEventListener.focusout', function(e){e.preventDefault();}, false);
		
			addPreprocessHandler(/Y\.later\(10,\s*this,\s*function\(\)\s*\{\s*Y\.namespace\("Media"\);/,'Y.later(1000, this, function() {Y.namespace("Media");');
			log('PATCH-406, Prevent currency menu from closing too fast on Y!Finance\nPATCH-911, Y!finance: delay script to load comments');
		}
		if(hostname.indexOf('mail.yahoo')>-1){
			opera.addEventListener('BeforeEvent.keypress', function(e){
				if( e.event.keyCode>36 && e.event.keyCode<41 ){
					e.event.charCode=0;
				}
			}, false);
			log('DSK-263826, Y!Mail Keyboard navigation of autocomplete menu fails');
		}
		if(hostname.indexOf('yahoo.co.jp')>-1){
			opera.defineMagicVariable('judgeMethod',function(curVal){if(curVal && curVal.indexOf('genOSError')<0 && curVal.indexOf('genBrowserError')<0){return(curVal)}return null},null);	// Player.js
			opera.defineMagicFunction('isCommonEnvCheck',function(){return true});	// JudgeCommonEnv.js
			opera.defineMagicFunction('isSilverLightEnvCheck',function(){return true});	// checkenv-min.js
			opera.defineMagicVariable('Silverlight',function(obj){	// Silverlight.supportedUserAgent.js
				try {
					obj.supportedUserAgent=function(){return true;}
					return obj;
				}catch(e){return undefined;}
			},
			null);
			log('PATCH-498, Yahoo! Japan services block Opera from using Silverlight plugin');
		}
		if(self==top&&hostname.indexOf('.mail.yahoo.co.jp')>-1&&(href.indexOf( '/neo/launch' )>-1&&location.search.indexOf('?reason=ignore')!=0)){
			location.href='/neo/launch?reason=ignore'+location.search.replace(/^\?/, '&');
			
			log('PATCH-325, Y!Mail work around browser blocking');
		}
		log('0, Yahoo!');
	} else if(hostname.indexOf('.yammer.com')>-1){
		window.addEventListener('message', function(e){
			if(e.data=='{"__opera_bjs_getURL":""}' && e.origin.match(/https:\/\/(www|ymodules)\.yammer\.com/)){
				e.source.postMessage('{"__opera_bjs_getURLResponse": "'+location.href+'"}', '*');
				window.removeEventListener(e.type,arguments.callee,false);
			}
		}, false);
		if(self!=top && document.referrer == ''){
			window.addEventListener('message', function(e){
				if(e.data.indexOf('{"__opera_bjs_getURLResponse"')==0 && e.origin.match(/https:\/\/(www|ymodules)\.yammer\.com/)){
					var url=e.data.substr(32);
					document.__defineGetter__('referrer', function(){return url;});
					window.removeEventListener(e.type,arguments.callee,false);
				}
			}, false);
			try{
				parent.postMessage('{"__opera_bjs_getURL":""}', '*');
			}catch(e){}
		}
		log('PATCH-512, Yammer: work around limitation on setting document.referrer inside https IFRAME');
	} else if(hostname.indexOf('265.com')>-1){
		addCssToDocument('#coolSites .body li, #coolSites .body li a{line-height:2em !important}')
		log('PATCH-475, Avoid overflowing text on 265.com');
	} else if(hostname.indexOf('aeonretail.jp')>-1){
		addPreprocessHandler(/var el = win \? \$\.browser\.opera \? document\.body : document\.documentElement : elem;/, 'var el = win ? document.documentElement : elem;', true, function(elm){ return elm.src&&elm.src.indexOf('scroll.js')>-1&&elm.text.indexOf('Opera 9.22')>-1; });
		log('PATCH-88, Make links work on Aeonretail (outdated jQuery plugin detects Opera and scrolls up)');
	} else if(hostname.indexOf('alfresco.com')>-1){
		if(hostname.indexOf('alfresco.com')>-1){
			if(pathname.indexOf('help/')>-1){
				navigator.appName = 'Netscape';
				window.opera = null;
			}
		}
		log('PATCH-467, Get rid of browser warning on Alfresco help pages');
	} else if(hostname.indexOf('allegro.pl')>-1){
		makePropertyCacheable(HTMLEmbedElement.prototype, 'type'); 
		makePropertyCacheable(HTMLEmbedElement.prototype, 'src');
		log('PATCH-653, allegro.pl: cache plugin properties to avoid performance impact from short interval');
	} else if(hostname.indexOf('amazon.')>-1){
		window.opera.addEventListener('BeforeScript', function (ev) {
			var name=ev.element.src; 
			if(!name){return;}
			if(name.indexOf('amazonShoveler')>-1){
				ev.element.text = ev.element.text.replace('if(li[0]!=cell){var self=this;','if(li[0]!=cell){li.append(cell);var self=this;');
			}
		}, false);
	
		if (navigator.appName!=='Opera'){
			document.documentElement.style.MozAppearance = 'Opera';
		}
		log('PATCH-652, Fix displaying recommended items in Amazon\nPATCH-527, Add more spoofing when masking as another browser on Amazon');
	} else if(hostname.indexOf('ameba.jp')!=-1){
		addPreprocessHandler(/editor\.insertNodeAtSelection\(link\);\s*editor\.insertNodeAtSelection\(document\.createElement\('br'\)\);/, 'editor.insertNodeAtSelection(link);');
		log('331093, Work around Opera bug where second BR tag overwrites newly inserted IMG');
	} else if(hostname.indexOf('archives.aisne.fr')>-1){
		defineMagicVariable.call(opera, 'isNS', function(){ return true }, null);
		log('PATCH-682, Fix document viewer on Archives départementales de l\'Aisne');
	} else if(hostname.indexOf('area-11.com')>-1){
		window.constructor={};
		window.constructor.prototype={};
		log('PATCH-695, area-11.com: prevent high CPU usage');
	} else if(hostname.indexOf('argos.co.uk')>-1){
		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;});
		log('PATCH-583, argos.co.uk: work around old jQuery/Opera clientHeight issue');
	} else if(hostname.indexOf('athome.co.jp') > -1){
		opera.defineMagicFunction('checkTargetBrowser',function(){});
		opera.defineMagicFunction('checkTargetCookie',function(){});
		log('PATCH-147, athome.co.jp Hide warning messages because of Browser UA');
	} else if(hostname.indexOf('b9dm.com')>-1){
		window.constructor={};
		window.constructor.prototype={};
		log('PATCH-694, b9dm.com: prevent high CPU usage');
	} else if(hostname.indexOf('balkanweb.com')>-1){
		opera.defineMagicFunction('ticker_start', function(oRealFunc, oThis){
			var ua=navigator.userAgent;
			navigator.userAgent+=' Firefox';
			oRealFunc.call(oThis);
			navigator.userAgent=ua;
		});
		log('PATCH-421, Enable news ticker on Balkanweb');
	} else if(hostname.indexOf('bankofamerica.com')>-1){
		opera.defineMagicFunction('getVersionString', function(){ return ''+parseFloat(opera.version()); });
		log('PATCH-668, Broken browser sniffing prevents SafePass login on Bank of America site');
	} else if(hostname.indexOf('bcbssc.com')>-1){
		(function(gEBI) { 
		  document.getElementById = function(idOrName) { 
		    return gEBI.call(document, arguments) || document.getElementsByName(idOrName)[0] || null; 
		  }; 
		})(document.getElementById);
		log('PATCH-93, Blue Cross SC looks up named elements with getElementById()');
	} else if(hostname.indexOf('bing.com')>-1 && pathname.indexOf('/images/')>-1){
		var locationReplace = Location.prototype.replace;
		Location.prototype.replace=function(uri){
			var href = document.location.href;
			var olduri = href.indexOf('#')>-1?href.substr(0,href.indexOf('#')):href;
			var newuri = uri.substr(0,uri.indexOf('#'));
			if (olduri == newuri) history.replaceState({}, document.title, uri);		
			else locationReplace.call( this, uri );
		}
		log('PATCH-545, Bing Image Search adds history entries when scrolling results');
	} else if(hostname.indexOf('bing.com')>-1 && pathname.indexOf('/maps')>-1){
		if(navigator.mimeTypes['application/x-silverlight-2'] &&
			navigator.mimeTypes['application/x-silverlight-2'].enabledPlugin)(function(){
			var actualSetter=document.__lookupSetter__('cookie');
			var actualGetter=document.__lookupGetter__('cookie');
			document.__defineGetter__('cookie', function(){ return actualGetter.call(this); });
			document.__defineSetter__('cookie', function(val){
				var _this=this;
				setTimeout(function(){actualSetter.call(_this, val)}, 0); 
				return val;
			});
		})();
		
		log('PATCH-534, Bing Maps deadlock on accessing document.cookie from Silverlight');
	} else if(hostname.indexOf('boards.4chan.org')>-1){
		addCssToDocument('td.reply blockquote, td.replyhl blockquote{margin-bottom: 1em}');
		log('PATCH-585, 4chan: add bottom margin to blockquote for better readability');
	} else if(hostname.indexOf('boortz.com')>-1){
		opera.addEventListener('BeforeCSS', function(e){
		  e.cssText = e.cssText.replace(/#cmArticleWell q:before,#cmArticleWell blockquote,.cmStaffBioContent q:before,.cmStaffBioContent blockquote{ content:open-quote}/g,'#cmArticleWell q:before,.cmStaffBioContent q:before{content:open-quote}')
		  .replace(/#cmArticleWell q:after,#cmArticleWell blockquote,.cmStaffBioContent q:after,.cmStaffBioContent blockquote{content:close-quote}/g,'#cmArticleWell q:after,.cmStaffBioContent q:after{content:close-quote}');
		}, false);
		log('PATCH-665, boortz.com: override abuse of CSS content on real elements');
	} else if(hostname.indexOf('britannica.com')>-1){
		avoidDocumentWriteAbuse();
		log('332948, Prevent overwriting document with stats graphic on britannica.com');
	} else if(hostname.indexOf('cajamadrid.es')!=-1){
		document.addEventListener( 'DOMContentLoaded', function(){
			for(var collection=document.getElementsByClassName('clearfix'), el; el=collection[0];){
				el.className = el.className.replace(/clearfix/, '');
			}
		}, false );
		
		log('PATCH-208, Caja Madrid hides login form by CSS mistake');
	} else if(hostname.indexOf('cambrian.mb.ca')>-1){
		HTMLTableElement.prototype.__defineGetter__('all', function(){});
		HTMLTableCellElement.prototype.__defineGetter__('all', function(){});
		HTMLDivElement.prototype.__defineGetter__('all', function(){});
		
		log('PATCH-285, Enable log-in button on Cambrian bank');
	} else if(hostname.indexOf('capitecbank.co.za')>-1){
		(function(){
		  var scriptQ=[];
		  opera.addEventListener('BeforeExternalScript', function(e){
		    if(e.element.hasAttribute('defer')){
		      scriptQ.push( e.element.parentNode.removeChild(e.element) );
		    }
		  }, false);
		  document.addEventListener('DOMContentLoaded', function(){
		    scriptQ.forEach(function(s){s.removeAttribute('defer');document.body.appendChild(s);});
		  }, false);
		})();
		
		log('PATCH-667, fake script @defer support on capitecbank.co.za');
	} else if(hostname.indexOf('cdec-sic.cl')!=-1){
		fixHierMenus();
		log('365516, Old HierMenus on cdec-sic.cl');
	} else if(hostname.indexOf('cnnturk.com')>-1){
		addCssToDocument('#fbtm div.dtc{bottom:-170px !important;}#fbtm div.dtc ul{position: static !important; display:inline !important}');
		log('PATCH-509, cnnturk: work around CSS bug that causes footer content to float upwards');
	} else if(hostname.indexOf('computerra.ru')>-1){
		document.addEventListener('DOMContentLoaded', function(){
			if(window.jsUtils&&window.jsUtils.bOpera)jsUtils.bOpera=false;
		}, false);
		log('PATCH-267, Make BBCode editor buttons work by disabling Opera sniffing');
	} else if(hostname.indexOf('credit-suisse.com')>-1 ){
		addPreprocessHandler(/GBrowserIsCompatible\(\)&&\!\$\.browser\.opera/, 'GBrowserIsCompatible()');
		log('PATCH-762, Credit Suisse second-guesses GMaps GBrowserIsCompatible, adds extra Opera blocking');
	} else if(hostname.indexOf('cs.kddi.com')>-1){
		HTMLInputElement.prototype.__defineSetter__('disabled', function(){});
		log('PATCH-656, Fix disabled buttons on KDDI Customer Support page');
	} else if(hostname.indexOf('danawa.com')!=-1 && href.indexOf('danawa.com/product/item.html')!=-1){
		HTMLBodyElement.prototype.__defineGetter__('offsetHeight', function(){
			return  (this.scrollHeight);
		});
		
		log('PATCH-14, Iframe content height is too small and not expanded on danawa.com');
	} else if(hostname.indexOf('dell.com')>-1){
		if(pathname.indexOf('/support/')==0){
		 opera.addEventListener('BeforeCSS', function(e){
		  e.cssText = e.cssText.replace(/white-space: -o-pre-wrap;/g,'');
		 }, false);
		}
		log('PATCH-710, dell.com: work around misguided use of prefixed white-space CSS property');
	} else if(hostname.indexOf('di.jal.co.jp')>-1){
		var dw=document.write;
		var MapViewer_dw;
		document.write=function( s ){
			if( String(s).indexOf('MapViewer') > -1 ){
				dw.apply(document, ["<div id='MapViewer_holder'></div>"]);
				MapViewer_dw = String(s);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Delay script execution). See browser.js for details');
			}else{
				dw.apply(document, arguments);
			}
		};
		
		window.addEventListener('load',function(e){
			document.getElementById('MapViewer_holder').outerHTML = MapViewer_dw;
		},false)
		log('PATCH-237, Delay script execution on JAL map');
	} else if(hostname.indexOf('directv.com')>-1){
		opera.defineMagicFunction('printContingencyWarningMessage',function(){});
		log('PATCH-721, directv.com: suppress old browser message');
	} else if(hostname.indexOf('e-pagofacil.com')>-1){
		opera.defineMagicFunction('PNG_loader', function(){return false});
		
		log('PATCH-734, Avoid IE PNG transparency bug workaround that hides submit button');
	} else if(hostname.indexOf('easycruit.com')>-1){
		fixIFrameSSIscriptII('resizeIframe');
		log('PATCH-219, Fujitsu recruitment page on EasyCruit hides content due to browser sniffing');
	} else if(hostname.indexOf('enter.nifmail.jp') > -1){
		opera.defineMagicFunction('checkBrowser',function(){
			return 1;
		},false);
		log('OTW-4878, Nifmail web mail bypass browser blocking');
	} else if(hostname.indexOf('espn.go.com')>-1){
		navigator.appName="netscape";
		log('PATCH-375, Make sure the ESPN polls work');
	} else if(hostname.indexOf('etour.co.jp') > -1){
		navigator.appName='Netscape';
		log('PATCH-152, etour.co.jp fix non-disappearing overlapping image');
	} else if(hostname.indexOf('facebook.com')>-1){
		if(hostname.endsWith('www.facebook.com')){
		 addCssToDocument('div.fbNubFlyoutBody.scrollable{position:inherit}');
		}
	
		if(hostname.endsWith('www.facebook.com')){
		opera.addEventListener('BeforeEventListener.keypress', function(e){
			if( e.event.ctrlKey && (e.event.keyCode==86 || e.event.keyCode==118 ) ){
				var trgt=e.event.target;
				setTimeout(
					function(){ 
						var evt=document.createEvent('Event');
						evt.initEvent('paste', true, true);
						trgt.dispatchEvent(evt);
					}, 10
				);
			}
		}, false);
		}
	
		if(hostname.endsWith('www.facebook.com')){
		 opera.addEventListener('BeforeCSS', function(e){
			e.cssText = e.cssText.replace(/border-(top|bottom)-(right|left)-radius:3px/g, '');
		 }, false);
		}
		
	
		if(hostname.endsWith('www.facebook.com')){
		 addCssToDocument('div.videoStage + div + div#fbPhotoPageTagBoxes{visibility:hidden;}');
		}
		log('PATCH-714, facebook: prevent chat window overflow - Presto bug\nPATCH-488, Facebook: fake paste event to make show preview immediately after pasting links in status\nPATCH-573, Facebook\'s border-radius triggers hyperactive reflow bug, performance suffers\nPATCH-923, facebook: work around lack of pointer-events blocking video playback');
	} else if(hostname.indexOf('fintyre.it')>-1){
		navigator.appName = "Netscape";
		log('PATCH-661, fintyre.it: work around sniffing');
	} else if(hostname.indexOf('forever21.co.jp') > -1){
		if (pathname.indexOf('QuickView.aspx')>-1) {
			addCssToDocument('html{background:#fff}');
		}
		log('PATCH-617, missing QuickView background color on Forever21.co.jp');
	} else if(hostname.indexOf('frys.com')>-1){
		addPreprocessHandler('self.parent.location=document.location;','if(self!=top)self.parent.location=document.location;');
		log('PATCH-638, frys.com: avoid racy framebuster due to lack of script async');
	} else if(hostname.indexOf('geforce.com')>-1&&pathname.toLowerCase().indexOf('/drivers')>-1){
		addCssToDocument('div.main,div.mainContent,div.rightNav,div.middle,div.contentMiddle,div.innerBox,div.innerMiddle{position:static !important;}');
		
		log('PATCH-521, geforce.com: fix unclickable options on custom select box');
	} else if(hostname.indexOf('geoaccess.com')!=-1){
		opera.defineMagicVariable('is_nav', function(){return true;}, null);
		
		log('318050,  BlueCross browser sniffing prevents insurance search');
	} else if(hostname.indexOf('goo.ne.jp')>-1){
		HTMLElement.prototype.__defineGetter__('currentStyle', function(){})
		document.addEventListener('DOMContentLoaded',function(e){
			if (gooSuggest && typeof sgtObj == "undefined") {
				createSuggest();
			}
		},false);
		log('PATCH-650, Fix search suggestions on Goo search engine');
	} else if(hostname.indexOf('googletv.blogspot.')>-1){
		addCssToDocument('div.post-body div{text-align:inherit !important}');
		log('PATCH-603, GoogleTV: fix broken word spacing - Opera bug');
	} else if(hostname.indexOf('groups.live.com')>-1){
		addCssToDocument('span.et_main{padding-left:0 !important}');
		log('PATCH-571, live.com: make file names visible');
	} else if(hostname.indexOf('help.adobe.com')!=-1){
		opera.defineMagicFunction('usingPushState', function(){return false});
		
		log('PATCH-741, Avoid an Opera pushState() and URL resolution bug that breaks navigation on help.adobe.com');
	} else if(hostname.indexOf('hk.centamap.com')>-1){
		document.addEventListener('DOMContentLoaded',function(evt){
			parent.document.body.__defineGetter__('offsetHeight',function(){ return parent.window.innerHeight; });
			parent.document.body.__defineGetter__('offsetWidth',function(){ return parent.window.innerWidth; });
		},false);
		
		
		log('PATCH-318, Fix missing menu and misplaced highlights on hk.centamap.com');
	} else if(hostname.indexOf('huffingtonpost.com')>-1){
		addPreprocessHandler(/\|\|adsUA\.indexOf\(\'opera\'\)>-1/,'');
		log('PATCH-601, Huffingtonpost: Avoid ad overwrite');
	} else if(hostname.indexOf('huntington.com')>-1){
		opera.defineMagicVariable('browserOkay',function(){return true},null);
		log('PATCH-712, huntington.com: work around browser sniff');
	} else if(hostname.indexOf('inetdec.nra.bg')>-1){
		addPreprocessHandler( /if\(newiframe&&!window.opera\)/g, 'if(newiframe)', true, function(el){return el.src.indexOf('scripts.js')>-1;} );
		log('PATCH-537, nra.bg: work around captcha load issue');
	} else if(hostname.indexOf('infinitiusa.com')>-1 || hostname.indexOf('nissanusa.com')>-1){
		opera.addEventListener('BeforeScript', function(e){
			if (e.element.src.indexOf('codepack.incGlobPaths.true.content.js')>-1){
				e.element.text = e.element.text.replace(/function\(un\){s\.un=un;/,"function(un){var s=this;s.un=un;");
			}
		}, false);
		log('PATCH-529, Fix SiteCatalyst H.9 code on Nissan/Infiniti USA');
	} else if(hostname.indexOf('internetbank.swedbank.se')>-1){
		Event.prototype.__defineGetter__('charCode', function(){if( this.keyCode>=48 && this.keyCode<=57  )return this.keyCode;});
		log('PATCH-611, SwedBank: temporary work around for mismatch between window.event support and charcode support');
	} else if(hostname.indexOf('investordaily.com.au')>-1){
		opera.defineMagicFunction('minmax_scan', function(){});
		log('PATCH-238, Override minmax IE helper script');
	} else if(hostname.indexOf('jabong.com')>-1){
		opera.addEventListener('BeforeCSS', function(e){
		  e.cssText = e.cssText.replace(/.clearfix:after,#content,#content:after,/g,'.clearfix:after,#content:after,');
		}, false);
		log('PATCH-658, jabong.com: override usage of CSS content property on element content');
	} else if(hostname.indexOf('journalism.org')>-1){
		fixIFrameSSIscriptII('resizeIframe');
		log('PATCH-523, journalism.org: fix old IFrame SSI script');
	} else if(hostname.indexOf('kort.arealinfo.dk')>-1){
		opera.defineMagicVariable('op', function(){return false}, null);
		log('PATCH-348, Disable Opera detection that causes hidden content');
	} else if(hostname.indexOf('latenightwithjimmyfallon.com')>-1){
		window.addEventListener('load', function(){
			if(window.DPSVPlayer && window.DPSVPlayer.onReady)DPSVPlayer.onReady.call(window);
		}, false);
		
		log('PATCH-615, Unexpected script loading order breaks video player ready check');
	} else if(hostname.indexOf('lottery.sina.2caipiao.com')>-1){
		fixIFrameSSIscriptII('dyniframesize');
		log('PATCH-556, 2caipiao.com: fix iframe resize');
	} else if(hostname.indexOf('mapion.co.jp')>-1){
		opera.addEventListener('BeforeScript',function(ev){
			var name=ev.element.src; 
			if(!name){return;}
			if(name.indexOf('merge_all_logic.js')!=-1){
				ev.element.text = ev.element.text.replace(/if\s*\(!MBrowser.opera\)\s*{/,'if(true){');
			}
		},false);
		document.addEventListener('DOMContentLoaded', function(e){
			var orig_onKeyDown = MKeyboardHandler.onKeyDown;
			MKeyboardHandler.onKeyDown = function(e) {
				orig_onKeyDown(e);
				e.preventDefault();
			}
		},false);
		log('PATCH-649, Enable keyboard controls on Mapion');
	} else if(hostname.indexOf('mb.softbank.jp')!=-1){
		window.opera.addEventListener('BeforeScript', function (e) {
			if (e.element.src.indexOf('history.js') > -1) {
				e.element.text = e.element.text.replace(/if \(!this.is_op && hash\)/gi, 'if (hash)');
			}
		}, false);
		log('PATCH-588, SoftBank Mobile History Plugin browser sniffing');
	} else if(hostname.indexOf('merriam-webster.com')>-1){
		addCssToDocument('embed[hidden=true]{display:inline;width:0;height:0;}');
		log('PATCH-540, Merriam-Webster: override embed with hidden attribute. Conflicts with HTML global hidden attribute.');
	} else if(hostname.indexOf('myspace.com')>-1){
		addCssToDocument('.punymce iframe{display:inline!important}');
		log('PATCH-487, MySpace: fix smiley insertion in mail and blog editor');
	} else if(hostname.indexOf('nbc.com')>-1){
		navigator.userAgent += " Chrome/5.0.375.9 Safari/533.4";
	
		window.addEventListener('load', function(){
			if(window.DPSVPlayer && window.DPSVPlayer.onReady)DPSVPlayer.onReady.call(window);
		}, false);
		
		log('PATCH-236, Make NBC videos work\nPATCH-577, Unexpected script loading order breaks video player ready check');
	} else if(hostname.indexOf('nbs.rs')>-1){
		fixIFrameSSIscriptII('dyniframesize', 'rir');
		log('PATCH-704, nbs.rs: fix iframe resize');
	} else if(hostname.indexOf('news.qq.com')>-1){
		var gEBI=document.getElementById;
		document.getElementById=function(){
			var result=gEBI.apply(this, arguments);
			if(!result)result=document.getElementsByName.apply(this,arguments)[0];
			return result;
		}
	
		fakeCSSFilters();
		log('PATCH-112, weather.news.qq.com expects getElementById() to find named elements\nOTW-4861, qq.com uses IE-style CSS filters');
	} else if(hostname.indexOf('oakley.com')>-1){
		opera.addEventListener('BeforeCSS', function(e){
		  e.cssText = e.cssText.replace(/#nav ul#nav_primary li.dd_link .dd ul li ul,\n#nav ul#nav_primary li.dd_link .dd a.category:after/g,'#nav ul#nav_primary li.dd_link .dd a.category:after');
		}, false);
		log('PATCH-664, oakley.com: abuse of CSS content on real elements');
	} else if(hostname.indexOf('officeapps.live.com')>-1){
		/* Microsoft Office Web Apps */
		log('0, Microsoft Office Web Apps');
	} else if(hostname.indexOf('opera.com')>-1&& pathname.indexOf('/docs/browserjs/')==0){
		document.addEventListener((parseFloat(opera.version())>9?'DOMContentLoaded':'load'),function(){
			if(document.getElementById('browserjs_active')){
				document.getElementById('browserjs_active').style.display='';
				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));
				document.getElementById('browserjs_status_message').style.display='none';
			}else if(document.getElementById('browserjs_status_message')){
				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;
			}
		}, false);
		log('0, Browser.js status and version reported on browser.js documentation page');
	} else if(hostname.indexOf('orbitdownloader.com')>-1){
		addCssToDocument('div.flag{height:1.1em;}');
		log('PATCH-322, Force height to avoid overlapping on orbitdownloader');
	} else if(hostname.indexOf('ordering.bellsouth.com')!=-1){
		opera.defineMagicVariable( 'isDHTML', function(){return true;}, null );
		opera.defineMagicFunction('checkBrowser', function(){});
		navigator.appName='Microsoft Internet Explorer';
		navigator.appVersion='MSIE'+navigator.appVersion;
		log('PATCH-36, ATT / Bellsouth browser sniffing');
	} else if(hostname.indexOf('orkut.com')>-1){
		(function(sTo){
			window.setTimeout=function(f,t){
				if( t==0 && !document.body )t=100;
				sTo.call( window, f, t );
			}
		})(window.setTimeout);
		log('CORE-19206, orkut avatar image crop does not happen because of timing issue');
	} else if(hostname.indexOf('passport2.hp.com')>-1){
		navigator.appName='Netscape';
		log('PATCH-738, Work around sniffing hiding submit buttons on passport2.hp.com');
	} else if(hostname.indexOf('pb.yamada-denki.jp')>-1){
		Element.prototype.attachEvent = null;
		window.opera = null;
		document.addEventListener('DOMContentLoaded',function(e){
			document.addEventListener('mousewheel',onMouseWheel,true);
		},false);
		
		log('PATCH-202, Show digital pamphlet from Yamada Denki');
	} else if(hostname.indexOf('pluginfree.com') > -1){
		opera.defineMagicFunction('sort',function(rf,rt){
			var res;
			return (res=rf.apply(rt,slice.call(arguments, 2)))?res:"nn";
		},false);
		
		log('PATCH-105, DNP Pluginfree Viewer fallback to Netscape version for Opera');
	} else if(hostname.indexOf('rabobank.nl')!=-1){
		ignoreCancellationOfCertainKeyEvents('keypress', {116:''});
		
		log('OTW-3405,  Rabobank cancels t keypress');
	} else if(hostname.indexOf('rede-expressos.pt')>-1 ){
		addCssToDocument('#fraHorarioIN, #fraBil1IN{min-height: 250px !important}');
		
			
		log('PATCH-422, Miscalculated IFRAME height prevents booking on rede-expressos');
	} else if(hostname.indexOf('salesforce.com')>-1){
		HTMLIFrameElement.prototype.__defineSetter__('onreadystatechange', function(){});
		
		opera.addEventListener('BeforeEventListener.load', 
			function(e){
				preventDefault.call=call;
				try{
					if(e.event.target.contentDocument && e.event.target.contentDocument.body.innerHTML == ""){
						preventDefault.call(e);
					}
				}catch(e){}
			},
			false
		);
		log('PATCH-176, Allow upload of workspace resources in Salesforce');
	} else if(hostname.indexOf('sbrf.ru')>-1){
		addEventListener('DOMContentLoaded', function(){s
			var nodes=document.evaluate('//*[@onmouseover | @onmouseout]', document.body, null, 4, null), node;
			while(node=nodes.iterateNext()){
				node.onmouseenter = node.onmouseover;
				node.onmouseover=null;
				node.onmouseleave = node.onmouseout;
				node.onmouseout=null; 
			}
		}, false);
		
		log('PATCH-644, Resolving sbrf.ru\'s menus mouseout confusion by helping them use mouseleave instead');
	} else if(hostname.indexOf('sharklink.nova.edu')>-1){
		opera.defineMagicVariable('is_opera',function(){return false},null);
		opera.defineMagicVariable('is_fox',function(){return true},null);
		opera.addEventListener('BeforeCSS',function(e){
			if (String(e.element.href).indexOf("sharklink_home.css")!=-1){
				e.cssText = e.cssText.replace(/\/\*text-indent:-9999px;\*\//g,'text-indent:-9999px;');
			}
		},false);
		log('PATCH-574, nova.edu: browser sniffing');
	} else if(hostname.indexOf('siren24.com')!=-1){
		navigator.appName = 'Netscape';
		log('SEOUL-609, ActiveX installation page redirect on siren24.com due to sniffing limitation on redirect script');
	} else if(hostname.indexOf('skydrive.live.com')>-1){
		MouseEvent.prototype.__defineGetter__('button',function(){return this.which == 2 ? 1 : this.which == 3 ? 2 : 0;;})
	
		opera.addEventListener('BeforeEventListener.load', 
			function(e){
				preventDefault.call=call;
				if(e.event.target.contentDocument && e.event.target.contentDocument.body.innerHTML == ""){
					preventDefault.call(e);
				}
			},
			false
		);
	
		addCssToDocument('span.et_main{padding-left:0 !important}');
		log('PATCH-679, skydrive: correct MouseEvent which\nPATCH-782, skydrive.live.com - Allow upload of files\nPATCH-571, live.com: make file names visible');
	} else if(hostname.indexOf('smithbarney.com')>-1){
		HTMLInputElement.prototype.__defineSetter__('type',function(){
			if (this.getAttribute('type')!=arguments[0]) {
				var doFocus=false, result;
				if (this == document.activeElement) doFocus = true;
				result = this.setAttribute('type',arguments[0]);
				if (doFocus) this.focus();
				return result;
			}
		});
		
		log('PATCH-360, Enable the password box on smithbarney.com');
	} else if(hostname.indexOf('smn.gov.ar')>-1){
		addCssToDocument('input#busqueda{max-width:108px}');
		log('PATCH-572, smn.gov.ar: reduce search input width to avoid wrapping');
	} else if(hostname.indexOf('social.')>-1&&hostname.indexOf('.microsoft.')>-1){
		document.getSelection=function(){return window.getSelection();}
		log('PATCH-619, Emulating IE breaks Microsoft fora');
	} else if(hostname.indexOf('sslsecure.maybank.com')>-1){
		opera.defineMagicFunction('MM_checkBrowser', function(){});
		log('PATCH-415, Browser sniffing causes 404 page on login to Maybank');
	} else if(hostname.indexOf('support.asus.com.tw')>-1){
		navigator.appName='Netscape';
		log('PATCH-459, Prevent Asus browser sniffing from breaking support site software download');
	} else if(hostname.indexOf('suzuki.co.jp')>-1){
		opera.defineMagicFunction('browserCheck',function(){return true});
		log('PATCH-716, Suzuki Japan - fix 3D car browser functionality');
	} else if(hostname.indexOf('sytadin.fr')!=-1){
		fixIFrameSSIscriptII('resizeIframeOnContent');
		log('OTW-5415, Sytadin.fr IFRAME resize script detects Opera');
	} else if(hostname.indexOf('t.qq.com')>-1){
		opera.addEventListener('BeforeScript', function(e){
			if(e.element.src && e.element.src.indexOf('mi.Tmpl')>-1 && typeof _ === 'function'){
				e.element.text = e.element.text.replace(/'\+_\("([^"]*)"\)\+'/g, function(){return _(arguments[1]) });
			}
		}, false);
		log('PATCH-538, Pre-process script to avoid "too deeply nested input" error, internal limits in Opera\'s ES engine too low');
	} else if(hostname.indexOf('talenthouse.com')>-1){
		opera.defineMagicVariable('th', function(obj){if(obj.ui)obj.ui.browserOk=function(){return true};return obj;}, null);
		
		log('PATCH-689, talenthouse.com: work around browser sniff');
	} else if(hostname.indexOf('tdwaterhouse.ca')>-1&&location.protocol=='https:'){
		document.domain='tdwaterhouse.ca';
		log('147840, tdwaterhouse.ca login fails - cross-domain access on https disallows setting location');
	} else if(hostname.indexOf('teledeporte.es')>-1){
		fixIFrameSSIscriptII('resizeIframe');
		log('PATCH-544, teledeporte.es: fix iframe resize');
	} else if(hostname.indexOf('tistory.com')!=-1){
		addCssToDocument('#memberbox .btn-login {text-indent:-100px;}');
		log('347990, two login buttons on tistory.com');
	} else if(hostname.indexOf('tradera.com')>-1){
		document.addEventListener('DOMContentLoaded',function(e){
			var els = document.getElementsByClassName('headerWrapperThin');
			for (var i=0,len=els.length;i<len;i++) {
				var pnstyle = els[i].parentNode.getAttribute('style');
				els[i].parentNode.setAttribute('style',(pnstyle?pnstyle+' ':'')+els[i].getAttribute('style'));
			}
		},false);
		log('PATCH-427, layout issue on Tradera.com\'s header');
	} else if(hostname.indexOf('tuenti.com')!=-1){
		navigator.userAgent += ' [NOT firefox/3]';
		log('PATCH-134, Videos not shown');
	} else if(hostname.indexOf('tvguide.co.uk')>-1){
		opera.addEventListener('AfterScript', function(e) {
			if (e.element.src.indexOf('boxover.js')>-1) {
				document.addEventListener('mouseover',moveMouse,false);
			}
		}, false);
		log('PATCH-596, tvguide.co.uk - Fix double descriptions appearing in TV listing');
	} else if(hostname.indexOf('tvguide.com')>-1){
		opera.defineMagicVariable('isSafari', function(){return true;}, null);
		log('PATCH-274, TVGuide doesn\'t show program descriptions, due to browser sniffing');
	} else if(hostname.indexOf('twitter.com')>-1){
		addCssToDocument('strong.fullname + span:not([class]){content:""}');
		log('PATCH-671, Twitter: avoid ghost @ before username');
	} else if(hostname.indexOf('uol.com.br')>-1){
		addCssToDocument('#moduloTopoRotativo ul li div.texto{top:225px}');
		log('PATCH-636, uol.com.br: work around abs.pos.bottom.align core bug');
	} else if(hostname.indexOf('virginamerica.com')>-1){
		navigator.appName='Netscape';
		opera.defineMagicVariable('browserType',function(){return 'gecko'},null);
		log('PATCH-492, virginamerica.com - Fix browser sniffing');
	} else if(hostname.indexOf('walmart.com')>-1){
		Element.prototype.__defineGetter__('className', function(){return this.getAttribute('class');});
		Element.prototype.__defineSetter__('className', function(value){
			if(value=='' && this.className.indexOf('topNavMenuItem')>-1)return value;
			return this.setAttribute('class', value);
		});
		
		log('PATCH-631, Walmart menus messed up by hasOwnProperty() regression');
	} else if(hostname.indexOf('wangpiao.com')>-1){
		window.constructor={};
		window.constructor.prototype={};
		log('PATCH-522, wangpiao.com: allow seat selection');
	} else if(hostname.indexOf('webprint.post.japanpost.jp')>-1){
		opera.defineMagicFunction('_supportsDOM',function (oReal,oThis) { return true; });
		log('PATCH-449, japanpost.jp: Fix broken _supportsDOM function');
	} else if(hostname.indexOf('weibo.com')>-1){
		if(!('KeyboardEvent' in window))window.KeyboardEvent = Event;
		log('PATCH-590, weibo.com: work around missing KeyboardEvent interface');
	} else if(hostname.indexOf('westjet.com')>-1 ){
		opera.defineMagicVariable('browser', function(o){ o.isSupported=true; return o; }, null);
		log('PATCH-260,  Westjet browser sniffing warns against Opera');
	} else if(hostname.indexOf('wikisky.org')>-1){
		Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });
		Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });
		
		log('PATCH-756, wikisky.org - Fix mouse controls');
	} else if(hostname.indexOf('www.yoka.com')>-1){
		opera.defineMagicFunction('minmax_scan', function(){});
		log('PATCH-238, Override minmax IE helper script');
	} else if(hostname.indexOf('www.yr.no')==0){
		(function (){
			var realGetter=(new XMLHttpRequest).__lookupGetter__('responseXML');
			XMLHttpRequest.prototype.__defineGetter__('responseXML', function(){
				if(this.getResponseHeader('content-type') && this.getResponseHeader('content-type').indexOf('text/plain')>-1)return;
				return realGetter.call(this);
			});
		})();
		log('PATCH-629, yr.no: don\'t define responseXML for text/plain responses, even if it looks like valid markup');
	} else if(hostname.indexOf('xcweather.co.uk')>-1){
		opera.defineMagicFunction('populateForm',
			function(real,oThis,oForm){
				var args=arguments;
				if(!oForm){
					setTimeout(function(){real.apply(oThis, Array.prototype.slice.call(args, 2));},100);
				}else{
					return real.apply(oThis, Array.prototype.slice.call(arguments, 2));
				}
			}
		);
		log('PATCH-519, xcweather: make sure the preference form is available when running script');
	} else if(hostname=='62.61.69.224'&&pathname.indexOf('/facebook')==0){
		(function(){
			var definedTop=window.top;
			opera.defineMagicVariable('top', function(){return definedTop;}, function(obj){definedTop=obj;} );
		})();
		log('PATCH-473, Nokia Ovi maps on Facebook wants to rewrite window.top');
	} else if(href.indexOf('/sample_lr.html')>-1){
		navigator.userAgent+=' Gecko';
		log('PATCH-128, Sun Webmail fails to set document.domain due to browser sniffing');
	} else if(href==='https://bugs.opera.com/wizarddesktop/'){
		document.addEventListener('DOMContentLoaded', function(){
			var frm;
			if(document.getElementById('bug') instanceof HTMLFormElement){
				frm=document.getElementById('bug');
				if(frm.auto)frm.auto.value+='\n\nBrowser JavaScript: \n'+bjsversion;
			}
		}, false);
		log('PATCH-221, Include browser.js timestamp in bug reports');
	} else if(pathname.indexOf("Maconomy/MaconomyPortal") > -1){
		opera.defineMagicFunction('handleKeyPresses', function (oReal, oThis, evt){
			if(evt.ctrlKey && evt.keyCode == 71 && typeof handleOnClickSearch == 'function'){evt.preventDefault();handleOnClickSearch('');return true}
			else{return oReal.apply(oThis, Array.prototype.slice.call(arguments, 2));}
		});
	
		opera.addEventListener("BeforeEvent.click", function(e){
			/*
			Opera doesn't send unload events in all cases. Check if
			a mouse click is about to replace a named frame (target). 
			If it will, iterate over the subframes and send an unload event.
			*/
			if(e.event.target.nodeName=="A" && e.event.target.getAttribute('target')!=null){
				trgt = e.event.target.getAttribute('target');
				if(trgt.indexOf('_rightside')){
					f = parent.frames[trgt];
					for(i=0;i<f.frames.length;i++){
						var evt=document.createEvent('Event');
						evt.initEvent('unload', true, true);
						f.frames[i].dispatchEvent(evt);
					}
				}
			}
		}
		,false);
	
		opera.addEventListener("BeforeEvent.unload", function(e){
				if(!(typeof doSubmitEmptyData==='function'))return;
				var original_function = doSubmitEmptyData;
				doSubmitEmptyData = function( command, parameter_1, parameter_2, parameter_3, formSetup ){
					var form = viewDocument.forms["emptyForm"], node;
					setupForm(form, formSetup);
					form.windowSerialId.value = windowSerialId;
					form.command.value        = command;
					form.parameter_1.value    = parameter_1;
					form.parameter_2.value    = parameter_2;
					form.parameter_3.value    = parameter_3;
					form.dataChanged.value    = (formSetup.dataChanged == null ? 0 : (formSetup.dataChanged ? 1 : 0));
					form.componentName.value  = "";
		
					var getstr = "";
					for (i=0; node = form.elements[i]; i++) {
						switch(node.type){
							case "hidden":
							case "text":
							case "select-one":
								getstr += escape(node.name) + "=" + escape(node.value) + "&";
								break;
							case "checkbox":
								if (node.checked) {
									getstr += escape(node.name) + "=" + escape(node.value) + "&";
								} else {
									getstr += escape(node.name) + "=&";
								}
								break;
							case "radio":
								if (node.checked) {
									getstr += escape(node.name) + "=" + escape(node.value) + "&";
								}
								break;
						}
		
					}
					getstr = getstr.replace(/&$/,""); //remove trailing &
					var xhr = new XMLHttpRequest();
		                        var url = form.action;
		                        if(form.target!="")url += "#"+form.target;
					xhr.open("POST",url,true);
					xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
					xhr.send(getstr);
					resetForm(form);
					doSubmitEmptyData = original_function;
			}
		},false);
		log('PATCH-445, Fix Ctrl-G shortcut in Maconomy\nPATCH-838, Maconomy: nested frameset unload\nPATCH-6, Fix unload form submit behavior on Maconomy portals');
	} else if(pathname.indexOf('/AnalyticalReporting/')==0){
		if(pathname.indexOf('AnalyticalReporting/WebiModify.do')>-1 || pathname.indexOf('AnalyticalReporting/WebiCreate.do')>-1){
		opera.defineMagicVariable('embed_size_attr',
			function(v){
				if(v=='style="width: 100%; height: 100%;'){
					return 'style="width: 100%; height: 100%;"';
				}
				return v;
			}
		,null);
		}
		log('PATCH-555, Analytix: add missing end quote');
	} else if(pathname.indexOf('/zimbra/')>-1){
		opera.defineMagicVariable('AjxEnv', null, function(obj){
			obj.__defineGetter__('isGeckoBased', function(){return true;});
			obj.__defineSetter__('isGeckoBased', function(){});
			return obj;
		});
		
		log('PATCH-255, Work around browser sniffing that prevents Zimbra\'s rich text editor from loading');
	}

})(opera);
