# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Default name for new events
new-event =
    .placeholder = Nuevo evento
# Titles for the event/task dialog
new-event-dialog = Nuevo evento
edit-event-dialog = Editar evento
new-task-dialog = Nueva tarea
edit-task-dialog = Editar tarea
# Do you want to save changes?
ask-save-title-event = Guardar evento
ask-save-title-task = Guardar tarea
ask-save-message-event = El evento no ha sido guardado. ¿Desea guardar el evento?
ask-save-message-task = La tarea no ha sido guardada. ¿Desea guardar la tarea?
# Event Dialog Warnings
warning-end-before-start = El día final que marcó es anterior al día inicial
warning-until-date-before-start = El día de cierre es anterior al día inicial
# The name of the calendar provided with the application by default
home-calendar-name = Inicio
# The name given to a calendar if an opened calendar has an empty filename
untitled-calendar-name = Calendario sin título
# Event status: Tentative, Confirmed, Cancelled
# ToDo task status: NeedsAction, InProcess, Completed, Cancelled
status-tentative = Tentativo
status-confirmed = Confirmado
event-status-cancelled = Cancelado
todo-status-cancelled = Cancelado
status-needs-action = Se necesita acción
status-in-process = En proceso
status-completed = Finalizada
# Task priority, these should match the priority.level.* labels in calendar.dtd
high-priority = Alta
normal-priority = Normal
low-priority = Baja
import-prompt = ¿En qué calendario quiere importar estos items?
export-prompt = ¿Cuál es el calendario desde el que quiere exportar?
paste-prompt = ¿En cual de los calendarios que actualmente se pueden escribir desea pegar información?
publish-prompt = ¿Cuál calendario quiere publicar?
# LOCALIZATION NOTE (paste-event-also): The users pasting operation includes among
# others also a meeting invitation - this is used as a affix in
# paste-notify-about
paste-event-also = Su pegado incluye una reunión
# LOCALIZATION NOTE (paste-events-also): The users pasting operation includes among
# others also several meeting invitations  - this is used as a affix in
# paste-notify-about
paste-events-also = Su pegado incluye reuniones
# LOCALIZATION NOTE (paste-task-also): The users pasting operation includes among
# others also an assigned task - this is used as a affix in paste-notify-about
paste-task-also = Su pegado incluye una tarea asignada
# LOCALIZATION NOTE (paste-tasks-also): The users pasting operation include among
# others also several assigned tasks - this is used as a affix in
# paste-notify-about
paste-tasks-also = Su pegado incluye tareas asignadas
# LOCALIZATION NOTE (paste-items-also): The users pasting operation includes among
# others also assigned task(s) and meeting invitation(s) - this is used as a affix
# in paste-notify-about
paste-items-also = Su pegado incluye reuniones y tareas asignadas
# LOCALIZATION NOTE (paste-event-only): The users is pasting a meeting -
# this is used as a affix in paste-notify-about
paste-event-only = Está pegando una reunión
# LOCALIZATION NOTE (paste-events-only): The users is pasting several meetings -
# this is used as a affix in paste-notify-about
paste-events-only = Está pegando reuniones
# LOCALIZATION NOTE (paste-event-only): The users is pasting an assigned task -
# this is used as a affix in paste-notify-about
paste-task-only = Está pegando una tarea asignada
# LOCALIZATION NOTE (paste-events-only): The users is pasting several assigned
# tasks - this is used as a affix in paste-notify-about
paste-tasks-only = Está pegando tareas asignadas
# LOCALIZATION NOTE (paste-events-only): The users is pasting assigned task(s) and
# meeting(s) - this is used as a affix in paste-notify-about
paste-items-only = Está pegando reuniones y tareas asignadas
# LOCALIZATION NOTE (paste-notify-about): Text displayed if pasting an invitation
# or assigned task
# $pasteItem - pasteEvent* or pasteTask*
paste-notify-about = { $pasteItem } - ¿Desea enviar una actualización a todos los involucrados?
# LOCALIZATION NOTE (paste-and-notify-label): button label used in calendar prompt
# of the pasted item has attendees
paste-and-notify-label = Pegar y enviar ahora
# LOCALIZATION NOTE (paste-dont-notify-label): button label used in calendar prompt
# of the pasted item has attendees
paste-dont-notify-label = Pegar sin enviar
# LOCALIZATION NOTE (import-items-failed):
#    $count will be replaced with number of failed items
#    $error will be replaced with last error code / error string
import-items-failed = Falló la importación de { $count } items. El último error fue: { $error }
# LOCALIZATION NOTE (no-items-in-calendar-file2):
#    $filePath will be replaced with file path
no-items-in-calendar-file2 = No se pudo importar de { $filePath }. No hay ítems importables en este archivo.
# spaces needed at the end of the following lines
event-description = Descripción:
unable-to-read = No se puede leer el archivo:
# $filePath
unable-to-write = No se puede escribir en el archivo: { $filePath }
default-file-name = CalEventosMozilla
html-title = Calendario Mozilla
# LOCALIZATION NOTE (timezone-error):
# used for an error message like 'An unknown and undefined timezone was found while reading c:\Mycalendarfile.ics'
#    $filePath will be replaced with the path to a file
timezone-error = Se encontró una zona de tiempo desconocida e indefinida mientras se leía { $filePath }.
# LOCALIZATION NOTE (duplicate-error):
#    $count will be replaced with number of duplicate items
#    $filePath will be replaced with a file path pointing to a calendar
duplicate-error =
    { $count ->
        [one] { $count } item(s) fueron ignorado/s porque existían tanto en el calendario de destino como en { $filePath }.
       *[other] { $count } item(s) fueron ignorado/s porque existían tanto en el calendario de destino como en { $filePath }.
    }
# $location unknown calendar location
unable-to-create-provider = Un error fue encontrado preparando el calendario ubicado en { $location } para su uso. No estará disponible.
# Sample: Unknown timezone "USPacific" in "Dentist Appt".  Using the 'floating' local timezone instead: 2008/02/28 14:00:00
# $timezone timezone name, $title item title, $datetime date-time
unknown-timezone-in-item = Huso horario desconocido "{ $timezone }" en "{ $title }".  Tratada como huso horario local 'flotante' en su lugar: { $datetime }
timezone-errors-alert-title = Errores de huso horario
timezone-errors-see-console = Vea la consola de errores: Husos horarios desconocidos con tratados como huso horario local 'flotante'.
# The following strings are for the prompt to delete/unsubscribe from the calendar
remove-calendar-title = Eliminar calendario
remove-calendar-button-delete = Borrar calendario
remove-calendar-button-unsubscribe = Desuscribir
# LOCALIZATION NOTE (remove-calendar-message-delete-or-unsubscribe): Shown for
# calendar where both deleting and unsubscribing is possible.
# $name:  The name of a calendar
remove-calendar-message-delete-or-unsubscribe = ¿Desea eliminar el calendario "{ $name }"? Desuscribirse eliminará el calendario de la lista, borrarlo también purgará permanentemente sus datos.
# LOCALIZATION NOTE (remove-calendar-message-delete): Shown for calendar where
# deleting is the only option.
# $name:  The name of a calendar
remove-calendar-message-delete = ¿Desea borrar de forma permanente el calendario "{ $name }"?
# LOCALIZATION NOTE (remove-calendar-message-unsubscribe): Shown for calendar
# where unsubscribing is the only option.
# $name:  The name of a calendar
remove-calendar-message-unsubscribe = ¿Desea desuscribirse del calendario "{ $name }"?
# $title title
week-title = Semana { $title }
# $title title
week-title-label =
    .aria-label = Semana { $title }
calendar-none =
    .label = Nada
# Error strings
# @name UID_NOT_FOUND
# @loc none
# LOCALIZATION NOTE (too-new-schema-error-text):
#    $hostApplication will be replaced with the name of the host application, e.g. 'Thunderbird'
#    $fileName will be replaced with the name of the new copy of the file, e.g. 'local-2020-05-11T21-30-17.sqlite'
too-new-schema-error-text = Sus datos del calendario no son compatibles con esta versión de { $hostApplication }. Los datos del calendario en su perfil fueron actualizados por una versión más nueva de { $hostApplication }. Se creó una copia de seguridad del archivo de datos, denominada "{ $fileName }". Continuando con un archivo de datos recién creado.
# List of events or todos (unifinder)
event-untitled = Sin título
# Tooltips of events or todos
tooltip-title = Título:
tooltip-location = Lugar:
# event date, usually an interval, such as
#  Date: 7:00--8:00 Thu 9 Oct 2011
#  Date: Thu 9 Oct 2000 -- Fri 10 Oct 2000
tooltip-date = Fecha:
# event calendar name
tooltip-cal-name = Nombre de calendario:
# event status: tentative, confirmed, cancelled
tooltip-status = Estado:
# event organizer
tooltip-organizer = Organizador:
# task/todo fields
# start date time, due date time, task priority number, completed date time
tooltip-start = Inicio:
tooltip-due = Vencimiento:
tooltip-priority = Prioridad:
tooltip-percent = % Completo:
tooltip-completed = Finalizado:
# File commands and dialogs
calendar-new = Nuevo
calendar-open = Abrir
filepicker-title-import = Importar
filepicker-title-export = Exportar
# Filters for export/import/open file picker.  $wildmat will be replaced with
# wildmat used to filter files by extension, such as (*.html; *.htm).
filter-ics = iCalendar ({ $wildmat })
# Filters for export/import/open file picker.  $wildmat will be replaced with
# wildmat used to filter files by extension, such as (*.html; *.htm).
filter-html = Página web ({ $wildmat })
# Remote calendar errors
generic-error-title = Ha ocurrido un error
# $statusCode $statusCodeInfo status code info
http-put-error =
    Falló la publicación del archivo de calendario.
    Código de estado: { $statusCode }: { $statusCodeInfo }
# $statusCode status code
other-put-error =
    Falló la publicación del archivo de calendario.
    Código de estado: 0x{ $statusCode }
# LOCALIZATION NOTE (read-only-mode):
# used for an message like 'There has been an error reading data for calendar: Home. It has been...'
#    $name will be replaced with the name of a calendar
read-only-mode = Hubo un error leyendo la información para el calendario: { $name }. Será dejado en modo de sólo lectura, ya que los cambios en este calendario pueden resultar en pérdida de datos. Puede cambiar esta opción eligiendo 'Editar calendario'.
# LOCALIZATION NOTE (disabled-mode):
# used for an message like 'There has been an error reading data for calendar: Home. It has been...'
#    $name will be replaced with the name of a calendar
disabled-mode = Hubo un error leyendo la información para el calendario: { $name }. Será deshabilitado hasta que sea seguro usarlo.
# LOCALIZATION NOTE (minor-error):
# used for an message like 'There has been an error reading data for calendar: Home. However this...'
#    $name will be replaced with the name of a calendar
minor-error = Hubo un error leyendo la información para el calendario: { $name }.  Sin embargo, el error parece menor, así que el programa continuará.
# LOCALIZATION NOTE (still-read-only-error):
# used for an message like 'There has been an error reading data for calendar: Home.'
#    $name will be replaced with the name of a calendar
still-read-only-error = Hubo un error leyendo la información para el calendario: { $name }.
utf8-decode-error = Hubo un error cuando se decodificaba un archivo iCalendar (ics) como UTF-8. Verifique que el archivo, incluyendo símbolos y letras con tildes, está codificado usando UTF-8.
ics-malformed-error = Falló el parseo de un archivo iCalendar (ics). Verifique que el archivo tenga una sintaxis válida como iCalendar (ics).
item-modified-on-server-title = El elemento cambió en el servidor
item-modified-on-server = Este elemento cambió recientemente en el servidor.
modify-will-lose-data = Enviar sus cambios sobreescribirá los cambios realizados en el servidor.
delete-will-lose-data = Borrar este elemento causará la pérdida de los cambios realizados en el servidor.
calendar-conflicts-dialog =
    .buttonlabelcancel = Descartar mis cambios y recargar
proceed-modify =
    .label = Enviar mis cambios igualmente
proceed-delete =
    .label = Borrar de todas formas
# $name calendar name
dav-not-dav = El servicio en { $name } no es una colección DAV o no está disponible
# $name calendar name
dav-dav-not-cal-dav = El servicio en { $name } es una colección DAV pero no un calendario CalDAV
item-put-error = Hubo un error guardando el elemento en el servidor.
item-delete-error = Hubo un error cuando se guardaba el elemento en el servidor.
cal-dav-request-error = Hubo un error al enviar la invitación.
cal-dav-response-error = Hubo un error al enviar la respuesta.
# $statusCode status code
cal-dav-request-status-code = Código de estado: { $statusCode }
cal-dav-request-status-code-string-generic = La solicitud no pudo ser procesada.
cal-dav-request-status-code-string-400 = La solicitud contiene errores de sintaxis y no puede ser procesada.
cal-dav-request-status-code-string-403 = El usuario no tiene los permisos necesarios para ejecutar la solicitud.
cal-dav-request-status-code-string-404 = Recurso no encontrado.
cal-dav-request-status-code-string-409 = Conflicto de recursos.
cal-dav-request-status-code-string-412 = Error de condición previa.
cal-dav-request-status-code-string-500 = Error interno de servidor.
cal-dav-request-status-code-string-502 = Bad gateway (¿Configuración del proxy?).
cal-dav-request-status-code-string-503 = Error interno de servidor (¿Caída temporal del servidor?).
# $name name of calendar
cal-dav-redirect-title = ¿Actualizar ubicación para el calendario { $name }?
# $name name of calendar
cal-dav-redirect-text = Los pedidos para { $name } están siendo redireccionados a una nueva ubicación. ¿Desea cambiar la ubicación al nuevo valor?
cal-dav-redirect-disable-calendar = Deshabilitar calendario
# LOCALIZATION NOTE (likely-timezone):
#   Translators, please put the most likely timezone(s) where the people using
#   your locale will be.  Use the Olson ZoneInfo timezone name *in English*,
#   ie "Europe/Paris", (continent or ocean)/(largest city in timezone).
#   Order does not matter, except if two historically different zones now match,
#   such as America/New_York and America/Toronto, will only find first listed.
#   (Particularly needed to guess the most relevant timezones if there are
#    similar timezones at the same June/December GMT offsets with alphabetically
#    earlier ZoneInfo timezone names.  Sample explanations for English below.)
# for english-US:
#   America/Los_Angeles likelier than America/Dawson
#   America/New_York    likelier than America/Detroit (NY for US-EasternTime)
# for english:
#   Europe/London   likelier than Atlantic/Canary
#   Europe/Paris    likelier than Africa/Ceuta (for WestEuropeanTime)
#   America/Halifax likelier than America/Glace_Bay (Canada-AtlanticTime)
#   America/Mexico_City likelier than America/Cancun
#   America/Argentina/Buenos_Aires likelier than America/Araguaina
#   America/Sao_Paolo (may not recognize: summer-time dates change every year)
#   Asia/Singapore  likelier than Antarctica/Casey
#   Asia/Tokyo      likelier than Asia/Dili
#   Africa/Lagos likelier than Africa/Algiers (for WestAfricanTime)
#   Africa/Johannesburg likelier than Africa/Blantyre (for SouthAfricanStdTime)
#   Africa/Nairobi likelier than Africa/Addis_Ababa (for EastAfricanTime)
#   Australia/Brisbane likelier than Antarctica/DumontDUrville
#   Australia/Sydney likelier than Australia/Currie or Australia/Hobart
#   Pacific/Auckland likelier than Antarctica/McMurdo
likely-timezone = America/Argentina/Buenos_Aires, America/New_York, America/Chicago, America/Denver, America/Phoenix, America/Los_Angeles, America/Anchorage, America/Adak, Pacific/Honolulu, America/Puerto_Rico, America/Halifax, America/Mexico_City, America/Sao_Paulo, Europe/London, Europe/Paris, Asia/Singapore, Asia/Tokyo, Africa/Lagos, Africa/Johannesburg, Africa/Nairobi, Australia/Brisbane, Australia/Sydney, Pacific/Auckland
# Guessed Timezone errors and warnings.
# Testing note:
# * remove preference for calendar.timezone.default in userprofile/prefs.js
# * repeat
#   - set OS timezone to a city (windows: click right on clock in taskbar)
#   - restart
#   - observe guess in error console and verify whether guessed timezone city
#     makes sense for OS city.
# 'Warning: Operating system timezone "E. South America Standard Time"
#  no longer matches ZoneInfo timezone "America/Sao_Paulo".'
# Testing notes:
# - Brasil DST change dates are set every year by decree, so likely out of sync.
# - Only appears on OSes from which timezone can be obtained
#   (windows; or TZ env var, /etc/localtime target path, or line in
#    /etc/timezone or /etc/sysconfig/clock contains ZoneInfo timezone id).
# - Windows: turning off "Automatically adjust clock for daylight saving time"
#   can also trigger this warning.
# $timezone OS timezone id
# $zoneInfoTimezoneId ZoneInfo timezone id
warning-os-tz-no-match =
    Advertencia: El huso horario del sistema operativo "{ $timezone }"
    no coincide con el huso horario interno ZoneInfo "{ $zoneInfoTimezoneId }".
# "Skipping Operating System timezone 'Pacific/New_Country'."
# Testing note: not easily testable.  May occur someday if (non-windows)
# OS uses different version of ZoneInfo database which has a timezone name
# that is not included in our current ZoneInfo database (or if the mapping
# mapping from windows to ZoneInfo timezone ids does).
# $timezone OS timezone id
skipping-os-timezone = Evitando huso horario del sistema operativo '{ $timezone }'.
# "Skipping locale timezone 'America/New_Yawk'."
# Testing note: Skipping occurs if a likely-timezone id is unknown or misspelled.
# $timezone likely timezone id
skipping-locale-timezone = Evitando huso horario local '{ $timezone }'.
# Testing note: "No match" timezones include Bucharest on W2k.
# Brazil timezones may be "No match" (change every year, so often out of date,
# and changes are often more than a week different).
warning-using-floating-tz-no-match =
    Advertencia: Usando huso horario "flotante".
    Ningún huso horario ZoneInfo coincide con los datos de huso horario del sistema operativo.
# "Warning:  Using guessed timezone
#    America/New York (UTC-0500/-0400).
#    [rfc2445 summer daylight saving shift rules for timezone]
#  This ZoneInfo timezone almost matches/seems to match..."
#  This ZoneInfo timezone was chosen based on ... "
# $timezone $offset $detail1 $detail2
warning-using-guessedtz =
    Advertencia:  Usando huso horario supuesto
    { $timezone } (UTC{ $offset }).
    { $detail1 }
    { $detail2 }
# Testing note: "Almost match" timezones include Cairo on W2k.
tz-almost-matches-os-differ-at-mostaweek =
    Este huso horario ZoneInfo casi coincide con el huso horario del sistema operativo.
    Para esta regla, las próximas transiciones entre horario de verano y horario estándar
    difieren a lo sumo una semana de las transiciones del sistema operativo.
    Puede haber discrepancias en los datos, como un día de inicio diferente,
    una regla diferente o aproximación para una regla de calendario no gregoriano.
tz-seems-to-matchos = Este huso horario ZoneInfo parece coincidir con el huso horario del sistema operativo este año.
# LOCALIZATION NOTE (tz-fromos):
# used for a display of a chosen timezone
#    $timezone will be replaced with the name of a timezone
tz-fromos =
    Este huso horario ZoneInfo fue elegido basándose en el identificador de huso horario de su
    sistema operativo "{ $timezone }".
# Localization note (tz-from-locale): Substitute name of your locale language.
tz-from-locale =
    Este huso horario ZoneInfo fue elegido basándose en la coincidencia del huso horario de su
    sistema operativo con husos horarios para usuarios de internet usando Español de Argentina.
tz-from-known-timezones =
    Este huso horario ZoneInfo fue elegido basándose en el huso horario de su
    sistema operativo con husos horarios conocidos en orden alfabético de id.
# Print Layout
tasks-with-no-due-date = Tareas sin fecha de vencimiento
# Providers
cal-dav-name = CalDAV
composite-name = Redactar
ics-name-key = iCalendar (ICS)
memory-name = Temporario (memoria)
storage-name = Local (SQLite)
# Used in created html code for export
html-prefix-title = Título
html-prefix-when = Cuando
html-prefix-location = Lugar
html-prefix-description = Descripción
# $task task
html-task-completed = { $task } (completa)
# Categories
add-category = Agregar Categoría
multiple-categories = Categorías múltiples
no-categories = Ninguna
calendar-today = Hoy
calendar-tomorrow = Mañana
yesterday = Ayer
# Today pane
events-only = Eventos
events-and-tasks = Eventos y tareas
tasks-only = Tareas
short-calendar-week = CS
calendar-go = Ir
# Some languages have different conjugations of 'next' and 'last'.  If yours
# does not, simply repeat the value.  This will be used with day names, as in
# 'next Sunday'.
calendar-next1 = próximo
calendar-next2 = próximo
calendar-last1 = último
calendar-last2 = último
# Alarm Dialog
# $count reminder count
alarm-window-title-label =
    { $count ->
        [one] { $count } recordatorio
       *[other] { $count } recordatorios
    }
# LOCALIZATION NOTE (alarm-starts):
# used for a display the start of an alarm like 'Starts:  Thu 2 Oct 2008 13:21'
#    $datetime will be replaced with a date-time
alarm-starts =
    .value = Inicio: { $datetime }
# LOCALIZATION NOTE (alarm-today-at):
# used for a display the date-time of an alarm like 'Today at Thu 2 Oct 2008 13:21'
#    $datetime will be replaced with a date-time
alarm-today-at = Hoy a las { $datetime }
# LOCALIZATION NOTE (alarm-tomorrow-at):
# used for a display the date-time of an alarm like 'Tomorrow at Thu 2 Oct 2008 13:21'
#    $datetime will be replaced with a date-time
alarm-tomorrow-at = Mañana a las { $datetime }
# LOCALIZATION NOTE (alarm-yesterday-at):
# used for a display the date-time of an alarm like 'Yesterday at Thu 2 Oct 2008 13:21'
#    $datetime will be replaced with a date-time
alarm-yesterday-at = Ayer a las { $datetime }
# Alarm interface strings
# LOCALIZATION NOTE: These strings do not get displayed. They are only visible
# when exporting an item with i.e a DISPLAY alarm, that doesn't have a
# description set, or an EMAIL alarm that doesn't have a summary set.
alarm-default-description = Descripción de Mozilla predeterminada
alarm-default-summary = Sumario de Mozilla predeterminado
# $count number of months
alarm-snooze-limit-exceeded =
    { $count ->
        [one] No se puede posponer una alarma por más de { $count } mes.
       *[other] No se puede posponer una alarma por más de { $count } meses.
    }
task-details-status-needs-action = Necesita acción
# LOCALIZATION NOTE (task-details-status-in-progress):
# used for a display of how much of a task is completed ' Complete'
#    $percent will be replaced with the number of percentage completed
task-details-status-in-progress = { $percent }% Finalizado
task-details-status-completed = Finalizado
# LOCALIZATION NOTE (task-details-status-completed-on):
# used for a display of completion date like 'Completed on Thu 2 Oct 2008 13:21'
#    $datetime will be replaced with the completion date-time of the task
task-details-status-completed-on = Finalizado el { $datetime }
task-details-status-cancelled = Cancelado
getting-calendar-info-common =
    .label = Verificando los calendarios…
# LOCALIZATION NOTE (getting-calendar-info-detail):
# used for a progress-display of processed like 'Checking Calendar 5 of 10'
#    $index will be replaced with the index of the currently processed calendar
#    $total will be replaced with the total numbers of calendars
getting-calendar-info-detail =
    .label = Verificando el calendario { $index } de { $total }
# LOCALIZATION NOTE (error-code):
#    $errorCode will be replaced with the number of an error code
error-code = Código de error: { $errorCode }
# LOCALIZATION NOTE (error-description):
#    $errorDescription will be replaced with the description of an error
error-description = Descripción: { $errorDescription }
# LOCALIZATION NOTE (error-writing):
# used for an message like 'An error occurred when writing to the calendar Home!'
#    $name will be replaced with the name of a calendar
error-writing2 = ¡Ocurrió un error al escribir en el calendario { $name }! Vea lo siguiente para más información.
# LOCALIZATION NOTE (error-writing-details):
# This will be displayed in the detail section of the error dialog
error-writing-details = Si ve este mensaje después de dormitar o descartar un recordatorio y se trata de un calendario al que no quiere agregar ni editar eventos, puede marcarlo como de solo lectura para evitar tal experiencia en el futuro. Para hacerlo, vaya a las propiedades del calendario haciendo clic derecho en este calendario en la lista en el calendario o en la vista de tareas.
# LOCALIZATION NOTE (tooltip-calendar-disabled):
# used for an alert-message like 'The calendar Home is momentarily not available'
#    $name will be replaced with the name of a calendar
tooltip-calendar-disabled =
    .title = El calendario { $name } no está disponible momentariamente
# LOCALIZATION NOTE (tooltip-calendar-read-only):
# used for an message like 'The calendar Home is readonly'
#    $name will be replaced with the name of a calendar
tooltip-calendar-read-only =
    .title = El calendario { $name } es de sólo lectura
task-edit-instructions = Haga clic aquí para agregar una nueva tarea
task-edit-instructions-readonly = Seleccione un calendario que pueda modificarse
task-edit-instructions-capability = Seleccione un calendario que permita tareas
event-details-start-date = Inicio:
event-details-end-date = Fin:
# LOCALIZATION NOTE (datetime-with-timezone):
# used for a display of a date-time with timezone 'Thu 2 Oct 2008 13:21', Europe/Paris
#    $datetime will be replaced with the completion date-time
#    $timezone will be replaced with the name of the timezone
datetime-with-timezone = { $datetime }, { $timezone }
# LOCALIZATION NOTE (single-long-calendar-week):
# used for display of calendar weeks in long form like 'Calendar Week 43'
#    $index will be replaced with the index of the week
single-long-calendar-week = Semana calendario: { $index }
# LOCALIZATION NOTE (single-calendar-week):
# used for display of calendar weeks in short form like 'CW 43'
#    $index will be replaced with the index of the week
single-calendar-week = SC: { $index }
    .title = Semana calendario: { $index }
# LOCALIZATION NOTE (several-long-calendar-weeks):
# used for display of calendar weeks in long form like 'Calendar Weeks 43 - 45'
#    $startIndex will be replaced with the index of the start-week
#    $endIndex will be replaced with the index of the end-week
several-long-calendar-weeks = Semanas del calendario { $startIndex }- { $endIndex }
# LOCALIZATION NOTE (several-calendar-weeks):
# used for display of calendar weeks in short form like 'CWs 43 - 45'
#    $startIndex will be replaced with the index of the start-week
#    $endIndex will be replaced with the index of the end-week
several-calendar-weeks = SsC: { $startIndex }-{ $endIndex }
    .title = Semanas calendario { $startIndex }-{ $endIndex }
# LOCALIZATION NOTE (multiweek-view-week):
# Used for displaying the week number in the first day box of every week
# in multiweek and month views.
# It allows to localize the label with the week number in case your locale
# requires it.
# Take into account that this label is placed in the same room of the day label
# inside the day boxes, exactly on left side, hence a possible string shouldn't
# be too long otherwise it will create confusion between the week number and
# the day number other than a possible crop when the window is resized.
#    $number is a number from 1 to 53 that represents the week number.
multiweek-view-week = S { $number }
# Task tree, "Due In" column.
# LOCALIZATION NOTE (due-in-days, due-in-hours): Semi-colon list of plural
# forms. See: http://developer.mozilla.org/en/Localization_and_Plurals
# $count count
due-in-days =
    { $count ->
        [one] { $count } día
       *[other] { $count } días
    }
# $count count
due-in-hours =
    { $count ->
        [one] { $count } hora
       *[other] { $count } horas
    }
due-in-less-than-one-hour = < 1 hora
# LOCALIZATION NOTE (format-date-long):
# used for display dates in long format like 'Mon 15 Oct 2008' when it's
# impossible to retrieve the formatatted date from the OS.
#    $dayName will be replaced with name of the day in short format;
#    $dayIndex will be replaced with the day-index of the month, possibly followed by an ordinal symbol
#         (depending on the string dayOrdinalSymbol in dateFormat.properties);
#    $monthName will be replaced with the name of the month in short format;
#    $year will be replaced with the year.
format-date-long = { $dayName } { $dayIndex } de { $monthName } de { $year }
# LOCALIZATION NOTE (day-header):
# used for display the labels in the header of the days in day/week views in short
# or long format. For example: 'Monday 6 Oct.' or 'Mon. 6 Oct.'
#    $dayName will be replaced with name of the day in short or long format
#    $dayIndex will be replaced with the day-index of the month, possibly followed by an ordinal symbol
#         (depending on the string dayOrdinalSymbol in dateFormat.properties), plus the name
#         of the month in short format (the day/month order depends on the OS settings).
day-header = { $dayName } { $dayIndex }
day-header-elem =
    .label = { day-header }
# LOCALIZATION NOTE (datetime-interval-task-without-date):
# used for task without start and due date
# (showed only in exported calendar in Html format)
datetime-interval-task-without-date = sin fecha de inicio o vencimiento
# LOCALIZATION NOTE (datetime-interval-task-without-due-date):
# used for intervals in task with only start date
# displayed form is 'start date 5 Jan 2006 13:00'
# (showed only in exported calendar in Html format)
#    $date will be replaced with the date of the start date
#    $time will be replaced with the time of the start date
datetime-interval-task-without-due-date = fecha de inicio { $date } { $time }
# LOCALIZATION NOTE (datetime-interval-task-without-start-date):
# used for intervals in task with only due date
# displayed form is 'due date 5 Jan 2006 13:00'
# (showed only in exported calendar in Html format)
#    $date will be replaced with the date of the due date
#    $time will be replaced with the time of the due date
datetime-interval-task-without-start-date = fecha de vencimiento { $date } { $time }
# LOCALIZATION NOTE (drag-label-tasks-with-only-entry-date
#                    drag-label-tasks-with-only-due-date)
# Labels that appear while dragging a task with only
# entry date OR due date
drag-label-tasks-with-only-entry-date = Fecha de inicio
drag-label-tasks-with-only-due-date = Vecimiento el
delete-task =
    .label = Borrar tarea
    .accesskey = B
delete-item =
    .label = Borrar
    .accesskey = B
delete-event =
    .label = Borrar evento
    .accesskey = B
# $count count
calendar-properties-every-minute =
    .label =
        { $count ->
            [one] Cada minuto
           *[other] Cada { $count } minutos
        }
# LOCALIZATION NOTE (extract-using)
# Used in message header
#    $languageName will be replaced with language name from languageNames.properties
extract-using = Usando { $languageName }
# LOCALIZATION NOTE (extract-using-region)
# Used in message header
#    $languageName will be replaced with language name from languageNames.properties
#    $region will be replaced with region like US in en-US
extract-using-region = Usando { $languageName } ({ $region })
# Variables:
# $count (Number) - Number of minutes, also used to determine the correct plural form.
unit-minutes =
    { $count ->
        [one] { $count } minuto
       *[other] { $count } minutos
    }
event-duration-menuitem-count-minutes =
    .label = { unit-minutes }
# Variables:
# $count (Number) - Number of hours, also used to determine the correct plural form.
unit-hours =
    { $count ->
        [one] { $count } hora
       *[other] { $count } horas
    }
event-duration-menuitem-count-hours =
    .label = { unit-hours }
# Variables:
# $count (Number) - Number of days, also used to determine the correct plural form.
unit-days =
    { $count ->
        [one] { $count } día
       *[other] { $count } días
    }
event-duration-menuitem-count-days =
    .label = { unit-days }
# Variables:
# $count (Number) - Number of weeks, also used to determine the correct plural form.
unit-weeks =
    { $count ->
        [one] { $count } semana
       *[other] { $count } semanas
    }
event-duration-menuitem-count-weeks =
    .label = { unit-weeks }
# Variables:
# $count (Number) - Number of minutes used to determine the correct plural form.
event-duration-menuitem-minutes =
    .label =
        { $count ->
            [one] minuto
           *[other] minutos
        }
event-duration-label-minutes =
    .value = { event-duration-menuitem-minutes.label }
# Variables:
# $count (Number) - Number of hours used to determine the correct plural form.
event-duration-menuitem-hours =
    .label =
        { $count ->
            [one] hora
           *[other] horas
        }
event-duration-label-hours =
    .value = { event-duration-menuitem-hours.label }
# Variables:
# $count (Number) - Number of days used to determine the correct plural form.
event-duration-menuitem-days =
    .label =
        { $count ->
            [one] día
           *[other] días
        }
event-duration-label-days =
    .value = { event-duration-menuitem-days.label }
# Variables:
# $count (Number) - Number of weeks used to determine the correct plural form.
event-duration-menuitem-weeks =
    .label =
        { $count ->
            [one] semana
           *[other] semanas
        }
event-duration-label-weeks =
    .value = { event-duration-menuitem-weeks.label }
# LOCALIZATION NOTE (show-calendar)
# Used in calendar list context menu
#    $name will be replaced with the calendar name
# uses the access key calendar.context.togglevisible.accesskey
# $name calendar name
show-calendar = Mostrar { $name }
# $name calendar name
hide-calendar = Ocultar { $name }
# $name calendar name
hide-calendar-title =
    .title = Mostrar { $name }
# $name calendar name
show-calendar-title =
    .title = Ocultar { $name }
# Variables:
# $name (String) - The calendar name
show-calendar-name =
    .label = Mostrar { $name }
    .accesskey = O
# Variables:
# $name (String) - The calendar name
hide-calendar-name =
    .label = Ocultar { $name }
    .accesskey = o
# Variables:
# $name (String) - The calendar name
show-only-calendar-name =
    .label = Mostrar solo { $name }
    .accesskey = s
# $name calendar name
show-calendar-label =
    .label = Mostrar { $name }
# $name calendar name
hide-calendar-label =
    .label = Ocultar { $name }
# uses the access key calendar.context.showonly.accesskey
# $name calendar name
show-only-calendar =
    .label = Mostrar solo { $name }
# LOCALIZATION NOTE (modify-conflict-*)
# Used by the event dialog to resolve item modification conflicts.
modify-conflict-prompt-title = Conflicto de modificación de ítem
modify-conflict-prompt-message = El ítem que está siendo editado en el díalogo fue modificado desde que fue abierto.
modify-conflict-prompt-button1 = Sobreescribir los otros cambios
modify-conflict-prompt-button2 = Descargar estos cambios
# Accessible description of a grid calendar with no selected date
minimonth-no-selected-date =
    .aria-label = Ninguna fecha seleccionada
# Used in the main menu and contextual menus.
calendar-context-today-pane =
    .label = Vista de hoy
    .accesskey = V
calendar-context-open-event =
    .label = Abrir
    .accesskey = A
calendar-context-open-task =
    .label = Abrir tarea…
    .accesskey = A
calendar-context-new-event =
    .label = Nuevo evento…
    .accesskey = N
calendar-context-new-task =
    .label = Nueva tarea…
    .accesskey = v
calendar-context-delete-task =
    .label = Borrar tarea
    .accesskey = B
calendar-context-delete-event =
    .label = Borrar evento
    .accesskey = B
calendar-context-cut =
    .label = Cortar
    .accesskey = t
calendar-context-copy =
    .label = Copiar
    .accesskey = C
calendar-context-paste =
    .label = Pegar
    .accesskey = P
calendar-taskview-delete =
    .label = Borrar
    .tooltiptext = Borrar tarea
calendar-context-attendance-menu =
    .label = Asistencia
    .accesskey = s
calendar-context-attendance-occurrence =
    .label = Esta vez
calendar-context-attendance-all-series =
    .label = Completar serie
calendar-context-attendance-send =
    .label = Enviar una notificación ahora
    .accesskey = E
calendar-context-attendance-dontsend =
    .label = No enviar una notificación
    .accesskey = N
calendar-context-attendance-occ-accepted =
    .label = Aceptada
    .accesskey = A
calendar-context-attendance-occ-tentative =
    .label = Aceptada tentativamente
    .accesskey = v
calendar-context-attendance-occ-declined =
    .label = Declinada
    .accesskey = c
calendar-context-attendance-occ-delegated =
    .label = Delegada
    .accesskey = g
calendar-context-attendance-occ-needs-action =
    .label = Aún necesita acción
    .accesskey = S
calendar-context-attendance-occ-in-progress =
    .label = En proceso
    .accesskey = p
calendar-context-attendance-occ-completed =
    .label = Completa
    .accesskey = C
calendar-context-attendance-all-accepted =
    .label = Aceptada
    .accesskey = e
calendar-context-attendance-all-tentative =
    .label = Aceptada tentativamente
    .accesskey = v
calendar-context-attendance-all-declined =
    .label = Declinada
    .accesskey = d
calendar-context-attendance-all-delegated =
    .label = Delegado
    .accesskey = l
calendar-context-attendance-all-needs-action =
    .label = Aún necesita acción
    .accesskey = i
calendar-context-attendance-all-in-progress =
    .label = En proceso
    .accesskey = p
calendar-context-attendance-all-completed =
    .label = Completo
    .accesskey = m
calendar-context-progress =
    .label = Progreso
    .accesskey = P
calendar-context-postpone =
    .label = Posponer tarea
    .accesskey = s
calendar-context-postpone-1hour =
    .label = 1 hora
    .accesskey = h
calendar-context-postpone-1day =
    .label = 1 día
    .accesskey = d
calendar-context-postpone-1week =
    .label = 1 semana
    .accesskey = s
calendar-context-new-server =
    .label = Nuevo calendario…
    .accesskey = N
calendar-context-delete-server =
    .label = Borrar calendario…
    .accesskey = d
calendar-context-remove-server =
    .label = Eliminar calendario…
    .accesskey = r
calendar-context-unsubscribe-server =
    .label = Desuscribir calendario…
    .accesskey = u
calendar-context-publish =
    .label = Publicar calendario…
    .accesskey = u
calendar-context-export =
    .label = Exportar calendario…
    .accesskey = E
calendar-context-properties =
    .label = Propiedades
    .accesskey = P
calendar-context-showall =
    .label = Mostrar todos los calendarios
    .accesskey = a
calendar-context-convert-menu =
    .label = Convertir a
    .accesskey = v
calendar-context-convert-to-event =
    .label = Evento…
    .accesskey = E
calendar-context-convert-to-message =
    .label = Mensaje…
    .accesskey = M
calendar-context-convert-to-task =
    .label = Tarea…
    .accesskey = T
calendar-task-filter-title = Mostrar
calendar-task-filter-all =
    .label = Todo
    .accesskey = T
calendar-task-filter-today =
    .label = Hoy
    .accesskey = H
calendar-task-filter-next7days =
    .label = Próximos siete días
    .accesskey = P
calendar-task-filter-notstarted =
    .label = Tareas no iniciadas
    .accesskey = i
calendar-task-filter-overdue =
    .label = Tareas vencidas
    .accesskey = v
calendar-task-filter-completed =
    .label = Tareas completas
    .accesskey = C
calendar-task-filter-open =
    .label = Tareas incompletas
    .accesskey = m
# LOCALIZATION NOTE (calendar-task-filter-current):
# "Current Tasks" shows all tasks except those starting in the future.
calendar-task-filter-current =
    .label = Tareas actuales
    .accesskey = u
calendar-task-details-title = título
calendar-task-details-organizer = de
calendar-task-details-priority = prioridad
calendar-task-details-priority-low = Baja
calendar-task-details-priority-normal = Normal
calendar-task-details-priority-high = Alta
calendar-task-details-status = estado
calendar-task-details-category = categoría
calendar-task-details-repeat = repetir
calendar-task-details-attachments = adjuntos
calendar-task-details-start = fecha de inicio
calendar-task-details-due = fecha de fin
calendar-task-mark-completed =
    .label = Marcar completadas
    .accesskey = o
    .tooltiptext = Marcar tareas seleccionadas como completas
calendar-task-change-priority =
    .label = Prioridad
    .accesskey = r
    .tooltiptext = Cambiar la prioridad
calendar-task-text-filter-field =
    .emptytextbase = Filtrar tareas #1
    .keylabelnonmac = <Ctrl+May+K>
    .keylabelmac = <⇧⌘K>
calendar-copylink =
    .label = Copiar dirección del enlace
    .accesskey = C
calendar-progress-level-0 =
    .label = 0% Completada
    .accesskey = 0
calendar-progress-level-25 =
    .label = 25% Completada
    .accesskey = 2
calendar-progress-level-50 =
    .label = 50% Completada
    .accesskey = 5
calendar-progress-level-75 =
    .label = 75% Completada
    .accesskey = 7
calendar-progress-level-100 =
    .label = 100% Completada
    .accesskey = 1
calendar-priority-none =
    .label = No especificado
    .accesskey = s
calendar-priority-low =
    .label = Baja
    .accesskey = B
calendar-priority-normal =
    .label = Normal
    .accesskey = N
calendar-priority-high =
    .label = Alta
    .accesskey = A
calendar-tasks-view-minimonth =
    .label = Mini mes
    .accesskey = M
calendar-tasks-view-calendarlist =
    .label = Lista de calendario
    .accesskey = L
calendar-tasks-view-filtertasks =
    .label = Filtrar Tareas
    .accesskey = F
calendar-properties-color =
    .value = Color:
calendar-properties-location =
    .value = Dirección:
calendar-properties-refresh =
    .value = Refrescar calendario:
calendar-properties-refresh-manual =
    .label = Manualmente
calendar-properties-read-only =
    .label = Sólo lectura
calendar-properties-show-reminders =
    .label = Mostrar alarmas
calendar-properties-offline-support =
    .label = Soporte sin conexión
calendar-properties-enable-calendar =
    .label = Habilitar este calendario
calendar-properties-provider-missing = No pudo encontrase el proveedor de este calendario. Ésto pasa a menudo si ha deshabilitado o desinstalado ciertos complementos.
calendar-properties-unsubscribe =
    .label = Desuscribir
    .accesskey = U
    .buttonlabelextra1 = Desuscribir
    .buttonaccesskeyextra1 = U
calendar-alarm-dialog-title = Alarma del calendario
calendar-alarm-details =
    .value = Detalles…
calendar-alarm-dismiss =
    .label = Descartar
calendar-alarm-dismiss-all =
    .label = Descartar todo
calendar-alarm-snooze-for =
    .label = Silenciar por
calendar-alarm-snooze-all-for =
    .label = Silenciar todo por
# Variables:
# $count (Number) - The number of minutes to snooze.
calendar-alarm-snooze-preset-minutes =
    .label =
        { $count ->
            [one] { $count } minuto
           *[other] { $count } minutos
        }
# Variables:
# $count (Number) - The number of hours to snooze.
calendar-alarm-snooze-preset-hours =
    .label =
        { $count ->
            [one] { $count } hora
           *[other] { $count } horas
        }
# Variables:
# $count (Number) - The number of days to snooze.
calendar-alarm-snooze-preset-days =
    .label =
        { $count ->
            [one] { $count } día
           *[other] { $count } días
        }
# LOCALIZATION NOTE (calendar-alarm-snooze-cancel):
# This string is not visible in the UI. It is read by screen readers when the
# user focuses the "Cancel" button in the "Snooze for..." popup of the alarm dialog.
calendar-alarm-snooze-cancel =
    .aria-label = Cancelar silenciar
calendar-calendar =
    .label = Calendario
    .accesskey = C
calendar-newevent-button =
    .label = Nuevo evento
    .tooltiptext = Crear un nuevo evento
calendar-newtask-button =
    .label = Nueva tarea
    .tooltiptext = Crear una nueva tarea
calendar-unifinder-show-completed-todos =
    .label = Mostrar tareas completas
calendar-display-todos-checkbox =
    .label = Tareas en vista
    .accesskey = v
calendar-completed-tasks-checkbox =
    .label = Mostrar tareas completas
    .accesskey = c
calendar-only-workday-checkbox =
    .label = Solamente días laborales
    .accesskey = r
calendar-orientation =
    .label = Rotar vista
    .accesskey = o
calendar-todaypane-button =
    .label = Vista de hoy
    .tooltiptext = Mostrar vista de hoy
calendar-search-options-searchfor =
    .value = contiene
calendar-server-dialog-title-edit =
    .title = Editar calendario
calendar-server-dialog-name-label =
    .value = Nombre de calendario:
calendar-publish-dialog-title =
    .title = Publicar Calendario
calendar-publish-url-label = URL de publicación
calendar-publish-publish-button = Publicar
calendar-publish-close-button = Cerrar
calendar-select-dialog-title = Elegir Calendario
calendar-error-detail =
    .label = Detalles…
calendar-error-code =
    .value = Código de error:
calendar-error-description =
    .value = Descripción:
calendar-error-title =
    .title = Ha ocurrido un error
calendar-extract-event-button =
    .label = Agregar como evento
    .tooltiptext = Extraer información de calendario desde el mensaje y agregarlo como un evento
calendar-extract-task-button =
    .label = Agregar como tarea
    .tooltiptext = Extraer información de calendario desde el mensaje y agregarlo como una tarea
