/* 
   Unix SMB/CIFS implementation.
   NT error code constants
   Copyright (C) Andrew Tridgell              1992-2000
   Copyright (C) John H Terpstra              1996-2000
   Copyright (C) Luke Kenneth Casson Leighton 1996-2000
   Copyright (C) Paul Ashton                  1998-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _NTSTATUS_H
#define _NTSTATUS_H

/* the following rather strange looking definitions of NTSTATUS 
   are there in order to catch common coding errors where different error types
   are mixed up. This is especially important as we slowly convert Samba
   from using bool for internal functions 
*/

#if defined(HAVE_IMMEDIATE_STRUCTURES)
typedef struct {uint32_t v;} NTSTATUS;
#define NT_STATUS(x) ((NTSTATUS) { x })
#define NT_STATUS_V(x) ((x).v)
#else
typedef uint32_t NTSTATUS;
#define NT_STATUS(x) (x)
#define NT_STATUS_V(x) (x)
#endif

/* Win32 Status codes. */

#define STATUS_BUFFER_OVERFLOW            NT_STATUS(0x80000005)
#define STATUS_NO_MORE_FILES              NT_STATUS(0x80000006)
#define STATUS_NO_MORE_EAS                NT_STATUS(0x80000012)	
#define STATUS_INVALID_EA_NAME            NT_STATUS(0x80000013)
#define STATUS_EA_LIST_INCONSISTENT       NT_STATUS(0x80000014)
#define STATUS_INVALID_EA_FLAG            NT_STATUS(0x80000015)
#define NT_STATUS_NO_MORE_ENTRIES         NT_STATUS(0x8000001a)
#define STATUS_STOPPED_ON_SYMLINK	  NT_STATUS(0x8000002d)

#define STATUS_PENDING                    NT_STATUS(0x0103)
/* Vista Status codes. */
#define NT_STATUS_INACCESSIBLE_SYSTEM_SHORTCUT         NT_STATUS(0x8000002d)
#define STATUS_MORE_ENTRIES               NT_STATUS(0x0105)
#define STATUS_SOME_UNMAPPED              NT_STATUS(0x0107)
#define STATUS_NOTIFY_CLEANUP             NT_STATUS(0x010b)
#define STATUS_NOTIFY_ENUM_DIR            NT_STATUS(0x010c)
#define ERROR_INVALID_PARAMETER		  NT_STATUS(0x0057)
#define ERROR_INSUFFICIENT_BUFFER	  NT_STATUS(0x007a)
#define ERROR_INVALID_DATATYPE		  NT_STATUS(0x070c)

/* Win7 status codes. */
#define NT_STATUS_INVALID_LOCK_RANGE      NT_STATUS(0xC0000000 | 0x01a1)

/* Win32 Error codes extracted using a loop in smbclient then printing a
   netmon sniff to a file. */

/*
                       --------------
                      /              \
                     /      REST      \
                    /        IN        \
                   /       PEACE        \
                  /                      \
                  | NT_STATUS_NOPROBLEMO |
                  |                      |
                  |                      |
                  |      4 September     |
                  |                      |
                  |         2001         |
                 *|     *  *  *          | *
        _________)/\\_//(\/(/\)/\//\/\///|_)_______
*/

#define NT_STATUS_OK NT_STATUS(0x0000)
#define NT_STATUS_UNSUCCESSFUL NT_STATUS(0xC0000000 | 0x0001)
#define NT_STATUS_NOT_IMPLEMENTED NT_STATUS(0xC0000000 | 0x0002)
#define NT_STATUS_INVALID_INFO_CLASS NT_STATUS(0xC0000000 | 0x0003)
#define NT_STATUS_INFO_LENGTH_MISMATCH NT_STATUS(0xC0000000 | 0x0004)
#define NT_STATUS_ACCESS_VIOLATION NT_STATUS(0xC0000000 | 0x0005)
#define NT_STATUS_IN_PAGE_ERROR NT_STATUS(0xC0000000 | 0x0006)
#define NT_STATUS_PAGEFILE_QUOTA NT_STATUS(0xC0000000 | 0x0007)
#define NT_STATUS_INVALID_HANDLE NT_STATUS(0xC0000000 | 0x0008)
#define NT_STATUS_BAD_INITIAL_STACK NT_STATUS(0xC0000000 | 0x0009)
#define NT_STATUS_BAD_INITIAL_PC NT_STATUS(0xC0000000 | 0x000a)
#define NT_STATUS_INVALID_CID NT_STATUS(0xC0000000 | 0x000b)
#define NT_STATUS_TIMER_NOT_CANCELED NT_STATUS(0xC0000000 | 0x000c)
#define NT_STATUS_INVALID_PARAMETER NT_STATUS(0xC0000000 | 0x000d)
#define NT_STATUS_NO_SUCH_DEVICE NT_STATUS(0xC0000000 | 0x000e)
#define NT_STATUS_NO_SUCH_FILE NT_STATUS(0xC0000000 | 0x000f)
#define NT_STATUS_INVALID_DEVICE_REQUEST NT_STATUS(0xC0000000 | 0x0010)
#define NT_STATUS_END_OF_FILE NT_STATUS(0xC0000000 | 0x0011)
#define NT_STATUS_WRONG_VOLUME NT_STATUS(0xC0000000 | 0x0012)
#define NT_STATUS_NO_MEDIA_IN_DEVICE NT_STATUS(0xC0000000 | 0x0013)
#define NT_STATUS_UNRECOGNIZED_MEDIA NT_STATUS(0xC0000000 | 0x0014)
#define NT_STATUS_NONEXISTENT_SECTOR NT_STATUS(0xC0000000 | 0x0015)
#define NT_STATUS_MORE_PROCESSING_REQUIRED NT_STATUS(0xC0000000 | 0x0016)
#if 0
/* this demonstrates a little trick when tracking down error codes */
#define NT_STATUS_NO_MEMORY (printf("no memory at %s\n", __location__), NT_STATUS(0xC0000000 | 0x0017))
#else
#define NT_STATUS_NO_MEMORY NT_STATUS(0xC0000000 | 0x0017)
#endif
#define NT_STATUS_CONFLICTING_ADDRESSES NT_STATUS(0xC0000000 | 0x0018)
#define NT_STATUS_NOT_MAPPED_VIEW NT_STATUS(0xC0000000 | 0x0019)
#define NT_STATUS_UNABLE_TO_FREE_VM NT_STATUS(0xC0000000 | 0x001a)
#define NT_STATUS_UNABLE_TO_DELETE_SECTION NT_STATUS(0xC0000000 | 0x001b)
#define NT_STATUS_INVALID_SYSTEM_SERVICE NT_STATUS(0xC0000000 | 0x001c)
#define NT_STATUS_ILLEGAL_INSTRUCTION NT_STATUS(0xC0000000 | 0x001d)
#define NT_STATUS_INVALID_LOCK_SEQUENCE NT_STATUS(0xC0000000 | 0x001e)
#define NT_STATUS_INVALID_VIEW_SIZE NT_STATUS(0xC0000000 | 0x001f)
#define NT_STATUS_INVALID_FILE_FOR_SECTION NT_STATUS(0xC0000000 | 0x0020)
#define NT_STATUS_ALREADY_COMMITTED NT_STATUS(0xC0000000 | 0x0021)
#if 0
/* this demonstrates a little trick when tracking down error codes */
#define NT_STATUS_ACCESS_DENIED (printf("access denied at %s\n", __location__), NT_STATUS(0xC0000000 | 0x0022))
#else
#define NT_STATUS_ACCESS_DENIED NT_STATUS(0xC0000000 | 0x0022)
#endif
#define NT_STATUS_BUFFER_TOO_SMALL NT_STATUS(0xC0000000 | 0x0023)
#define NT_STATUS_OBJECT_TYPE_MISMATCH NT_STATUS(0xC0000000 | 0x0024)
#define NT_STATUS_NONCONTINUABLE_EXCEPTION NT_STATUS(0xC0000000 | 0x0025)
#define NT_STATUS_INVALID_DISPOSITION NT_STATUS(0xC0000000 | 0x0026)
#define NT_STATUS_UNWIND NT_STATUS(0xC0000000 | 0x0027)
#define NT_STATUS_BAD_STACK NT_STATUS(0xC0000000 | 0x0028)
#define NT_STATUS_INVALID_UNWIND_TARGET NT_STATUS(0xC0000000 | 0x0029)
#define NT_STATUS_NOT_LOCKED NT_STATUS(0xC0000000 | 0x002a)
#define NT_STATUS_PARITY_ERROR NT_STATUS(0xC0000000 | 0x002b)
#define NT_STATUS_UNABLE_TO_DECOMMIT_VM NT_STATUS(0xC0000000 | 0x002c)
#define NT_STATUS_NOT_COMMITTED NT_STATUS(0xC0000000 | 0x002d)
#define NT_STATUS_INVALID_PORT_ATTRIBUTES NT_STATUS(0xC0000000 | 0x002e)
#define NT_STATUS_PORT_MESSAGE_TOO_LONG NT_STATUS(0xC0000000 | 0x002f)
#define NT_STATUS_INVALID_PARAMETER_MIX NT_STATUS(0xC0000000 | 0x0030)
#define NT_STATUS_INVALID_QUOTA_LOWER NT_STATUS(0xC0000000 | 0x0031)
#define NT_STATUS_DISK_CORRUPT_ERROR NT_STATUS(0xC0000000 | 0x0032)
#define NT_STATUS_OBJECT_NAME_INVALID NT_STATUS(0xC0000000 | 0x0033)
#define NT_STATUS_OBJECT_NAME_NOT_FOUND NT_STATUS(0xC0000000 | 0x0034)
#define NT_STATUS_OBJECT_NAME_COLLISION NT_STATUS(0xC0000000 | 0x0035)
#define NT_STATUS_HANDLE_NOT_WAITABLE NT_STATUS(0xC0000000 | 0x0036)
#define NT_STATUS_PORT_DISCONNECTED NT_STATUS(0xC0000000 | 0x0037)
#define NT_STATUS_DEVICE_ALREADY_ATTACHED NT_STATUS(0xC0000000 | 0x0038)
#define NT_STATUS_OBJECT_PATH_INVALID NT_STATUS(0xC0000000 | 0x0039)
#define NT_STATUS_OBJECT_PATH_NOT_FOUND NT_STATUS(0xC0000000 | 0x003a)
#define NT_STATUS_OBJECT_PATH_SYNTAX_BAD NT_STATUS(0xC0000000 | 0x003b)
#define NT_STATUS_DATA_OVERRUN NT_STATUS(0xC0000000 | 0x003c)
#define NT_STATUS_DATA_LATE_ERROR NT_STATUS(0xC0000000 | 0x003d)
#define NT_STATUS_DATA_ERROR NT_STATUS(0xC0000000 | 0x003e)
#define NT_STATUS_CRC_ERROR NT_STATUS(0xC0000000 | 0x003f)
#define NT_STATUS_SECTION_TOO_BIG NT_STATUS(0xC0000000 | 0x0040)
#define NT_STATUS_PORT_CONNECTION_REFUSED NT_STATUS(0xC0000000 | 0x0041)
#define NT_STATUS_INVALID_PORT_HANDLE NT_STATUS(0xC0000000 | 0x0042)
#define NT_STATUS_SHARING_VIOLATION NT_STATUS(0xC0000000 | 0x0043)
#define NT_STATUS_QUOTA_EXCEEDED NT_STATUS(0xC0000000 | 0x0044)
#define NT_STATUS_INVALID_PAGE_PROTECTION NT_STATUS(0xC0000000 | 0x0045)
#define NT_STATUS_MUTANT_NOT_OWNED NT_STATUS(0xC0000000 | 0x0046)
#define NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED NT_STATUS(0xC0000000 | 0x0047)
#define NT_STATUS_PORT_ALREADY_SET NT_STATUS(0xC0000000 | 0x0048)
#define NT_STATUS_SECTION_NOT_IMAGE NT_STATUS(0xC0000000 | 0x0049)
#define NT_STATUS_SUSPEND_COUNT_EXCEEDED NT_STATUS(0xC0000000 | 0x004a)
#define NT_STATUS_THREAD_IS_TERMINATING NT_STATUS(0xC0000000 | 0x004b)
#define NT_STATUS_BAD_WORKING_SET_LIMIT NT_STATUS(0xC0000000 | 0x004c)
#define NT_STATUS_INCOMPATIBLE_FILE_MAP NT_STATUS(0xC0000000 | 0x004d)
#define NT_STATUS_SECTION_PROTECTION NT_STATUS(0xC0000000 | 0x004e)
#define NT_STATUS_EAS_NOT_SUPPORTED NT_STATUS(0xC0000000 | 0x004f)
#define NT_STATUS_EA_TOO_LARGE NT_STATUS(0xC0000000 | 0x0050)
#define NT_STATUS_NONEXISTENT_EA_ENTRY NT_STATUS(0xC0000000 | 0x0051)
#define NT_STATUS_NO_EAS_ON_FILE NT_STATUS(0xC0000000 | 0x0052)
#define NT_STATUS_EA_CORRUPT_ERROR NT_STATUS(0xC0000000 | 0x0053)
#define NT_STATUS_FILE_LOCK_CONFLICT NT_STATUS(0xC0000000 | 0x0054)
#define NT_STATUS_LOCK_NOT_GRANTED NT_STATUS(0xC0000000 | 0x0055)
#define NT_STATUS_DELETE_PENDING NT_STATUS(0xC0000000 | 0x0056)
#define NT_STATUS_CTL_FILE_NOT_SUPPORTED NT_STATUS(0xC0000000 | 0x0057)
#define NT_STATUS_UNKNOWN_REVISION NT_STATUS(0xC0000000 | 0x0058)
#define NT_STATUS_REVISION_MISMATCH NT_STATUS(0xC0000000 | 0x0059)
#define NT_STATUS_INVALID_OWNER NT_STATUS(0xC0000000 | 0x005a)
#define NT_STATUS_INVALID_PRIMARY_GROUP NT_STATUS(0xC0000000 | 0x005b)
#define NT_STATUS_NO_IMPERSONATION_TOKEN NT_STATUS(0xC0000000 | 0x005c)
#define NT_STATUS_CANT_DISABLE_MANDATORY NT_STATUS(0xC0000000 | 0x005d)
#define NT_STATUS_NO_LOGON_SERVERS NT_STATUS(0xC0000000 | 0x005e)
#define NT_STATUS_NO_SUCH_LOGON_SESSION NT_STATUS(0xC0000000 | 0x005f)
#define NT_STATUS_NO_SUCH_PRIVILEGE NT_STATUS(0xC0000000 | 0x0060)
#define NT_STATUS_PRIVILEGE_NOT_HELD NT_STATUS(0xC0000000 | 0x0061)
#define NT_STATUS_INVALID_ACCOUNT_NAME NT_STATUS(0xC0000000 | 0x0062)
#define NT_STATUS_USER_EXISTS NT_STATUS(0xC0000000 | 0x0063)
#define NT_STATUS_NO_SUCH_USER NT_STATUS(0xC0000000 | 0x0064)
#define NT_STATUS_GROUP_EXISTS NT_STATUS(0xC0000000 | 0x0065)
#define NT_STATUS_NO_SUCH_GROUP NT_STATUS(0xC0000000 | 0x0066)
#define NT_STATUS_MEMBER_IN_GROUP NT_STATUS(0xC0000000 | 0x0067)
#define NT_STATUS_MEMBER_NOT_IN_GROUP NT_STATUS(0xC0000000 | 0x0068)
#define NT_STATUS_LAST_ADMIN NT_STATUS(0xC0000000 | 0x0069)
#define NT_STATUS_WRONG_PASSWORD NT_STATUS(0xC0000000 | 0x006a)
#define NT_STATUS_ILL_FORMED_PASSWORD NT_STATUS(0xC0000000 | 0x006b)
#define NT_STATUS_PASSWORD_RESTRICTION NT_STATUS(0xC0000000 | 0x006c)
#define NT_STATUS_LOGON_FAILURE NT_STATUS(0xC0000000 | 0x006d)
#define NT_STATUS_ACCOUNT_RESTRICTION NT_STATUS(0xC0000000 | 0x006e)
#define NT_STATUS_INVALID_LOGON_HOURS NT_STATUS(0xC0000000 | 0x006f)
#define NT_STATUS_INVALID_WORKSTATION NT_STATUS(0xC0000000 | 0x0070)
#define NT_STATUS_PASSWORD_EXPIRED NT_STATUS(0xC0000000 | 0x0071)
#define NT_STATUS_ACCOUNT_DISABLED NT_STATUS(0xC0000000 | 0x0072)
#define NT_STATUS_NONE_MAPPED NT_STATUS(0xC0000000 | 0x0073)
#define NT_STATUS_TOO_MANY_LUIDS_REQUESTED NT_STATUS(0xC0000000 | 0x0074)
#define NT_STATUS_LUIDS_EXHAUSTED NT_STATUS(0xC0000000 | 0x0075)
#define NT_STATUS_INVALID_SUB_AUTHORITY NT_STATUS(0xC0000000 | 0x0076)
#define NT_STATUS_INVALID_ACL NT_STATUS(0xC0000000 | 0x0077)
#define NT_STATUS_INVALID_SID NT_STATUS(0xC0000000 | 0x0078)
#define NT_STATUS_INVALID_SECURITY_DESCR NT_STATUS(0xC0000000 | 0x0079)
#define NT_STATUS_PROCEDURE_NOT_FOUND NT_STATUS(0xC0000000 | 0x007a)
#define NT_STATUS_INVALID_IMAGE_FORMAT NT_STATUS(0xC0000000 | 0x007b)
#define NT_STATUS_NO_TOKEN NT_STATUS(0xC0000000 | 0x007c)
#define NT_STATUS_BAD_INHERITANCE_ACL NT_STATUS(0xC0000000 | 0x007d)
#define NT_STATUS_RANGE_NOT_LOCKED NT_STATUS(0xC0000000 | 0x007e)
#define NT_STATUS_DISK_FULL NT_STATUS(0xC0000000 | 0x007f)
#define NT_STATUS_SERVER_DISABLED NT_STATUS(0xC0000000 | 0x0080)
#define NT_STATUS_SERVER_NOT_DISABLED NT_STATUS(0xC0000000 | 0x0081)
#define NT_STATUS_TOO_MANY_GUIDS_REQUESTED NT_STATUS(0xC0000000 | 0x0082)
#define NT_STATUS_GUIDS_EXHAUSTED NT_STATUS(0xC0000000 | 0x0083)
#define NT_STATUS_INVALID_ID_AUTHORITY NT_STATUS(0xC0000000 | 0x0084)
#define NT_STATUS_AGENTS_EXHAUSTED NT_STATUS(0xC0000000 | 0x0085)
#define NT_STATUS_INVALID_VOLUME_LABEL NT_STATUS(0xC0000000 | 0x0086)
#define NT_STATUS_SECTION_NOT_EXTENDED NT_STATUS(0xC0000000 | 0x0087)
#define NT_STATUS_NOT_MAPPED_DATA NT_STATUS(0xC0000000 | 0x0088)
#define NT_STATUS_RESOURCE_DATA_NOT_FOUND NT_STATUS(0xC0000000 | 0x0089)
#define NT_STATUS_RESOURCE_TYPE_NOT_FOUND NT_STATUS(0xC0000000 | 0x008a)
#define NT_STATUS_RESOURCE_NAME_NOT_FOUND NT_STATUS(0xC0000000 | 0x008b)
#define NT_STATUS_ARRAY_BOUNDS_EXCEEDED NT_STATUS(0xC0000000 | 0x008c)
#define NT_STATUS_FLOAT_DENORMAL_OPERAND NT_STATUS(0xC0000000 | 0x008d)
#define NT_STATUS_FLOAT_DIVIDE_BY_ZERO NT_STATUS(0xC0000000 | 0x008e)
#define NT_STATUS_FLOAT_INEXACT_RESULT NT_STATUS(0xC0000000 | 0x008f)
#define NT_STATUS_FLOAT_INVALID_OPERATION NT_STATUS(0xC0000000 | 0x0090)
#define NT_STATUS_FLOAT_OVERFLOW NT_STATUS(0xC0000000 | 0x0091)
#define NT_STATUS_FLOAT_STACK_CHECK NT_STATUS(0xC0000000 | 0x0092)
#define NT_STATUS_FLOAT_UNDERFLOW NT_STATUS(0xC0000000 | 0x0093)
#define NT_STATUS_INTEGER_DIVIDE_BY_ZERO NT_STATUS(0xC0000000 | 0x0094)
#define NT_STATUS_INTEGER_OVERFLOW NT_STATUS(0xC0000000 | 0x0095)
#define NT_STATUS_PRIVILEGED_INSTRUCTION NT_STATUS(0xC0000000 | 0x0096)
#define NT_STATUS_TOO_MANY_PAGING_FILES NT_STATUS(0xC0000000 | 0x0097)
#define NT_STATUS_FILE_INVALID NT_STATUS(0xC0000000 | 0x0098)
#define NT_STATUS_ALLOTTED_SPACE_EXCEEDED NT_STATUS(0xC0000000 | 0x0099)
#define NT_STATUS_INSUFFICIENT_RESOURCES NT_STATUS(0xC0000000 | 0x009a)
#define NT_STATUS_DFS_EXIT_PATH_FOUND NT_STATUS(0xC0000000 | 0x009b)
#define NT_STATUS_DEVICE_DATA_ERROR NT_STATUS(0xC0000000 | 0x009c)
#define NT_STATUS_DEVICE_NOT_CONNECTED NT_STATUS(0xC0000000 | 0x009d)
#define NT_STATUS_DEVICE_POWER_FAILURE NT_STATUS(0xC0000000 | 0x009e)
#define NT_STATUS_FREE_VM_NOT_AT_BASE NT_STATUS(0xC0000000 | 0x009f)
#define NT_STATUS_MEMORY_NOT_ALLOCATED NT_STATUS(0xC0000000 | 0x00a0)
#define NT_STATUS_WORKING_SET_QUOTA NT_STATUS(0xC0000000 | 0x00a1)
#define NT_STATUS_MEDIA_WRITE_PROTECTED NT_STATUS(0xC0000000 | 0x00a2)
#define NT_STATUS_DEVICE_NOT_READY NT_STATUS(0xC0000000 | 0x00a3)
#define NT_STATUS_INVALID_GROUP_ATTRIBUTES NT_STATUS(0xC0000000 | 0x00a4)
#define NT_STATUS_BAD_IMPERSONATION_LEVEL NT_STATUS(0xC0000000 | 0x00a5)
#define NT_STATUS_CANT_OPEN_ANONYMOUS NT_STATUS(0xC0000000 | 0x00a6)
#define NT_STATUS_BAD_VALIDATION_CLASS NT_STATUS(0xC0000000 | 0x00a7)
#define NT_STATUS_BAD_TOKEN_TYPE NT_STATUS(0xC0000000 | 0x00a8)
#define NT_STATUS_BAD_MASTER_BOOT_RECORD NT_STATUS(0xC0000000 | 0x00a9)
#define NT_STATUS_INSTRUCTION_MISALIGNMENT NT_STATUS(0xC0000000 | 0x00aa)
#define NT_STATUS_INSTANCE_NOT_AVAILABLE NT_STATUS(0xC0000000 | 0x00ab)
#define NT_STATUS_PIPE_NOT_AVAILABLE NT_STATUS(0xC0000000 | 0x00ac)
#define NT_STATUS_INVALID_PIPE_STATE NT_STATUS(0xC0000000 | 0x00ad)
#define NT_STATUS_PIPE_BUSY NT_STATUS(0xC0000000 | 0x00ae)
#define NT_STATUS_ILLEGAL_FUNCTION NT_STATUS(0xC0000000 | 0x00af)
#define NT_STATUS_PIPE_DISCONNECTED NT_STATUS(0xC0000000 | 0x00b0)
#define NT_STATUS_PIPE_CLOSING NT_STATUS(0xC0000000 | 0x00b1)
#define NT_STATUS_PIPE_CONNECTED NT_STATUS(0xC0000000 | 0x00b2)
#define NT_STATUS_PIPE_LISTENING NT_STATUS(0xC0000000 | 0x00b3)
#define NT_STATUS_INVALID_READ_MODE NT_STATUS(0xC0000000 | 0x00b4)
#define NT_STATUS_IO_TIMEOUT NT_STATUS(0xC0000000 | 0x00b5)
#define NT_STATUS_FILE_FORCED_CLOSED NT_STATUS(0xC0000000 | 0x00b6)
#define NT_STATUS_PROFILING_NOT_STARTED NT_STATUS(0xC0000000 | 0x00b7)
#define NT_STATUS_PROFILING_NOT_STOPPED NT_STATUS(0xC0000000 | 0x00b8)
#define NT_STATUS_COULD_NOT_INTERPRET NT_STATUS(0xC0000000 | 0x00b9)
#define NT_STATUS_FILE_IS_A_DIRECTORY NT_STATUS(0xC0000000 | 0x00ba)
#define NT_STATUS_NOT_SUPPORTED NT_STATUS(0xC0000000 | 0x00bb)
#define NT_STATUS_REMOTE_NOT_LISTENING NT_STATUS(0xC0000000 | 0x00bc)
#define NT_STATUS_DUPLICATE_NAME NT_STATUS(0xC0000000 | 0x00bd)
#define NT_STATUS_BAD_NETWORK_PATH NT_STATUS(0xC0000000 | 0x00be)
#define NT_STATUS_NETWORK_BUSY NT_STATUS(0xC0000000 | 0x00bf)
#define NT_STATUS_DEVICE_DOES_NOT_EXIST NT_STATUS(0xC0000000 | 0x00c0)
#define NT_STATUS_TOO_MANY_COMMANDS NT_STATUS(0xC0000000 | 0x00c1)
#define NT_STATUS_ADAPTER_HARDWARE_ERROR NT_STATUS(0xC0000000 | 0x00c2)
#define NT_STATUS_INVALID_NETWORK_RESPONSE NT_STATUS(0xC0000000 | 0x00c3)
#define NT_STATUS_UNEXPECTED_NETWORK_ERROR NT_STATUS(0xC0000000 | 0x00c4)
#define NT_STATUS_BAD_REMOTE_ADAPTER NT_STATUS(0xC0000000 | 0x00c5)
#define NT_STATUS_PRINT_QUEUE_FULL NT_STATUS(0xC0000000 | 0x00c6)
#define NT_STATUS_NO_SPOOL_SPACE NT_STATUS(0xC0000000 | 0x00c7)
#define NT_STATUS_PRINT_CANCELLED NT_STATUS(0xC0000000 | 0x00c8)
#define NT_STATUS_NETWORK_NAME_DELETED NT_STATUS(0xC0000000 | 0x00c9)
#define NT_STATUS_NETWORK_ACCESS_DENIED NT_STATUS(0xC0000000 | 0x00ca)
#define NT_STATUS_BAD_DEVICE_TYPE NT_STATUS(0xC0000000 | 0x00cb)
#define NT_STATUS_BAD_NETWORK_NAME NT_STATUS(0xC0000000 | 0x00cc)
#define NT_STATUS_TOO_MANY_NAMES NT_STATUS(0xC0000000 | 0x00cd)
#define NT_STATUS_TOO_MANY_SESSIONS NT_STATUS(0xC0000000 | 0x00ce)
#define NT_STATUS_SHARING_PAUSED NT_STATUS(0xC0000000 | 0x00cf)
#define NT_STATUS_REQUEST_NOT_ACCEPTED NT_STATUS(0xC0000000 | 0x00d0)
#define NT_STATUS_REDIRECTOR_PAUSED NT_STATUS(0xC0000000 | 0x00d1)
#define NT_STATUS_NET_WRITE_FAULT NT_STATUS(0xC0000000 | 0x00d2)
#define NT_STATUS_PROFILING_AT_LIMIT NT_STATUS(0xC0000000 | 0x00d3)
#define NT_STATUS_NOT_SAME_DEVICE NT_STATUS(0xC0000000 | 0x00d4)
#define NT_STATUS_FILE_RENAMED NT_STATUS(0xC0000000 | 0x00d5)
#define NT_STATUS_VIRTUAL_CIRCUIT_CLOSED NT_STATUS(0xC0000000 | 0x00d6)
#define NT_STATUS_NO_SECURITY_ON_OBJECT NT_STATUS(0xC0000000 | 0x00d7)
#define NT_STATUS_CANT_WAIT NT_STATUS(0xC0000000 | 0x00d8)
#define NT_STATUS_PIPE_EMPTY NT_STATUS(0xC0000000 | 0x00d9)
#define NT_STATUS_CANT_ACCESS_DOMAIN_INFO NT_STATUS(0xC0000000 | 0x00da)
#define NT_STATUS_CANT_TERMINATE_SELF NT_STATUS(0xC0000000 | 0x00db)
#define NT_STATUS_INVALID_SERVER_STATE NT_STATUS(0xC0000000 | 0x00dc)
#define NT_STATUS_INVALID_DOMAIN_STATE NT_STATUS(0xC0000000 | 0x00dd)
#define NT_STATUS_INVALID_DOMAIN_ROLE NT_STATUS(0xC0000000 | 0x00de)
#define NT_STATUS_NO_SUCH_DOMAIN NT_STATUS(0xC0000000 | 0x00df)
#define NT_STATUS_DOMAIN_EXISTS NT_STATUS(0xC0000000 | 0x00e0)
#define NT_STATUS_DOMAIN_LIMIT_EXCEEDED NT_STATUS(0xC0000000 | 0x00e1)
#define NT_STATUS_OPLOCK_NOT_GRANTED NT_STATUS(0xC0000000 | 0x00e2)
#define NT_STATUS_INVALID_OPLOCK_PROTOCOL NT_STATUS(0xC0000000 | 0x00e3)
#define NT_STATUS_INTERNAL_DB_CORRUPTION NT_STATUS(0xC0000000 | 0x00e4)
#define NT_STATUS_INTERNAL_ERROR NT_STATUS(0xC0000000 | 0x00e5)
#define NT_STATUS_GENERIC_NOT_MAPPED NT_STATUS(0xC0000000 | 0x00e6)
#define NT_STATUS_BAD_DESCRIPTOR_FORMAT NT_STATUS(0xC0000000 | 0x00e7)
#define NT_STATUS_INVALID_USER_BUFFER NT_STATUS(0xC0000000 | 0x00e8)
#define NT_STATUS_UNEXPECTED_IO_ERROR NT_STATUS(0xC0000000 | 0x00e9)
#define NT_STATUS_UNEXPECTED_MM_CREATE_ERR NT_STATUS(0xC0000000 | 0x00ea)
#define NT_STATUS_UNEXPECTED_MM_MAP_ERROR NT_STATUS(0xC0000000 | 0x00eb)
#define NT_STATUS_UNEXPECTED_MM_EXTEND_ERR NT_STATUS(0xC0000000 | 0x00ec)
#define NT_STATUS_NOT_LOGON_PROCESS NT_STATUS(0xC0000000 | 0x00ed)
#define NT_STATUS_LOGON_SESSION_EXISTS NT_STATUS(0xC0000000 | 0x00ee)
#define NT_STATUS_INVALID_PARAMETER_1 NT_STATUS(0xC0000000 | 0x00ef)
#define NT_STATUS_INVALID_PARAMETER_2 NT_STATUS(0xC0000000 | 0x00f0)
#define NT_STATUS_INVALID_PARAMETER_3 NT_STATUS(0xC0000000 | 0x00f1)
#define NT_STATUS_INVALID_PARAMETER_4 NT_STATUS(0xC0000000 | 0x00f2)
#define NT_STATUS_INVALID_PARAMETER_5 NT_STATUS(0xC0000000 | 0x00f3)
#define NT_STATUS_INVALID_PARAMETER_6 NT_STATUS(0xC0000000 | 0x00f4)
#define NT_STATUS_INVALID_PARAMETER_7 NT_STATUS(0xC0000000 | 0x00f5)
#define NT_STATUS_INVALID_PARAMETER_8 NT_STATUS(0xC0000000 | 0x00f6)
#define NT_STATUS_INVALID_PARAMETER_9 NT_STATUS(0xC0000000 | 0x00f7)
#define NT_STATUS_INVALID_PARAMETER_10 NT_STATUS(0xC0000000 | 0x00f8)
#define NT_STATUS_INVALID_PARAMETER_11 NT_STATUS(0xC0000000 | 0x00f9)
#define NT_STATUS_INVALID_PARAMETER_12 NT_STATUS(0xC0000000 | 0x00fa)
#define NT_STATUS_REDIRECTOR_NOT_STARTED NT_STATUS(0xC0000000 | 0x00fb)
#define NT_STATUS_REDIRECTOR_STARTED NT_STATUS(0xC0000000 | 0x00fc)
#define NT_STATUS_STACK_OVERFLOW NT_STATUS(0xC0000000 | 0x00fd)
#define NT_STATUS_NO_SUCH_PACKAGE NT_STATUS(0xC0000000 | 0x00fe)
#define NT_STATUS_BAD_FUNCTION_TABLE NT_STATUS(0xC0000000 | 0x00ff)
#define NT_STATUS_DIRECTORY_NOT_EMPTY NT_STATUS(0xC0000000 | 0x0101)
#define NT_STATUS_FILE_CORRUPT_ERROR NT_STATUS(0xC0000000 | 0x0102)
#define NT_STATUS_NOT_A_DIRECTORY NT_STATUS(0xC0000000 | 0x0103)
#define NT_STATUS_BAD_LOGON_SESSION_STATE NT_STATUS(0xC0000000 | 0x0104)
#define NT_STATUS_LOGON_SESSION_COLLISION NT_STATUS(0xC0000000 | 0x0105)
#define NT_STATUS_NAME_TOO_LONG NT_STATUS(0xC0000000 | 0x0106)
#define NT_STATUS_FILES_OPEN NT_STATUS(0xC0000000 | 0x0107)
#define NT_STATUS_CONNECTION_IN_USE NT_STATUS(0xC0000000 | 0x0108)
#define NT_STATUS_MESSAGE_NOT_FOUND NT_STATUS(0xC0000000 | 0x0109)
#define NT_STATUS_PROCESS_IS_TERMINATING NT_STATUS(0xC0000000 | 0x010a)
#define NT_STATUS_INVALID_LOGON_TYPE NT_STATUS(0xC0000000 | 0x010b)
#define NT_STATUS_NO_GUID_TRANSLATION NT_STATUS(0xC0000000 | 0x010c)
#define NT_STATUS_CANNOT_IMPERSONATE NT_STATUS(0xC0000000 | 0x010d)
#define NT_STATUS_IMAGE_ALREADY_LOADED NT_STATUS(0xC0000000 | 0x010e)
#define NT_STATUS_ABIOS_NOT_PRESENT NT_STATUS(0xC0000000 | 0x010f)
#define NT_STATUS_ABIOS_LID_NOT_EXIST NT_STATUS(0xC0000000 | 0x0110)
#define NT_STATUS_ABIOS_LID_ALREADY_OWNED NT_STATUS(0xC0000000 | 0x0111)
#define NT_STATUS_ABIOS_NOT_LID_OWNER NT_STATUS(0xC0000000 | 0x0112)
#define NT_STATUS_ABIOS_INVALID_COMMAND NT_STATUS(0xC0000000 | 0x0113)
#define NT_STATUS_ABIOS_INVALID_LID NT_STATUS(0xC0000000 | 0x0114)
#define NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE NT_STATUS(0xC0000000 | 0x0115)
#define NT_STATUS_ABIOS_INVALID_SELECTOR NT_STATUS(0xC0000000 | 0x0116)
#define NT_STATUS_NO_LDT NT_STATUS(0xC0000000 | 0x0117)
#define NT_STATUS_INVALID_LDT_SIZE NT_STATUS(0xC0000000 | 0x0118)
#define NT_STATUS_INVALID_LDT_OFFSET NT_STATUS(0xC0000000 | 0x0119)
#define NT_STATUS_INVALID_LDT_DESCRIPTOR NT_STATUS(0xC0000000 | 0x011a)
#define NT_STATUS_INVALID_IMAGE_NE_FORMAT NT_STATUS(0xC0000000 | 0x011b)
#define NT_STATUS_RXACT_INVALID_STATE NT_STATUS(0xC0000000 | 0x011c)
#define NT_STATUS_RXACT_COMMIT_FAILURE NT_STATUS(0xC0000000 | 0x011d)
#define NT_STATUS_MAPPED_FILE_SIZE_ZERO NT_STATUS(0xC0000000 | 0x011e)
#define NT_STATUS_TOO_MANY_OPENED_FILES NT_STATUS(0xC0000000 | 0x011f)
#define NT_STATUS_CANCELLED NT_STATUS(0xC0000000 | 0x0120)
#define NT_STATUS_CANNOT_DELETE NT_STATUS(0xC0000000 | 0x0121)
#define NT_STATUS_INVALID_COMPUTER_NAME NT_STATUS(0xC0000000 | 0x0122)
#define NT_STATUS_FILE_DELETED NT_STATUS(0xC0000000 | 0x0123)
#define NT_STATUS_SPECIAL_ACCOUNT NT_STATUS(0xC0000000 | 0x0124)
#define NT_STATUS_SPECIAL_GROUP NT_STATUS(0xC0000000 | 0x0125)
#define NT_STATUS_SPECIAL_USER NT_STATUS(0xC0000000 | 0x0126)
#define NT_STATUS_MEMBERS_PRIMARY_GROUP NT_STATUS(0xC0000000 | 0x0127)
#define NT_STATUS_FILE_CLOSED NT_STATUS(0xC0000000 | 0x0128)
#define NT_STATUS_TOO_MANY_THREADS NT_STATUS(0xC0000000 | 0x0129)
#define NT_STATUS_THREAD_NOT_IN_PROCESS NT_STATUS(0xC0000000 | 0x012a)
#define NT_STATUS_TOKEN_ALREADY_IN_USE NT_STATUS(0xC0000000 | 0x012b)
#define NT_STATUS_PAGEFILE_QUOTA_EXCEEDED NT_STATUS(0xC0000000 | 0x012c)
#define NT_STATUS_COMMITMENT_LIMIT NT_STATUS(0xC0000000 | 0x012d)
#define NT_STATUS_INVALID_IMAGE_LE_FORMAT NT_STATUS(0xC0000000 | 0x012e)
#define NT_STATUS_INVALID_IMAGE_NOT_MZ NT_STATUS(0xC0000000 | 0x012f)
#define NT_STATUS_INVALID_IMAGE_PROTECT NT_STATUS(0xC0000000 | 0x0130)
#define NT_STATUS_INVALID_IMAGE_WIN_16 NT_STATUS(0xC0000000 | 0x0131)
#define NT_STATUS_LOGON_SERVER_CONFLICT NT_STATUS(0xC0000000 | 0x0132)
#define NT_STATUS_TIME_DIFFERENCE_AT_DC NT_STATUS(0xC0000000 | 0x0133)
#define NT_STATUS_SYNCHRONIZATION_REQUIRED NT_STATUS(0xC0000000 | 0x0134)
#define NT_STATUS_DLL_NOT_FOUND NT_STATUS(0xC0000000 | 0x0135)
#define NT_STATUS_OPEN_FAILED NT_STATUS(0xC0000000 | 0x0136)
#define NT_STATUS_IO_PRIVILEGE_FAILED NT_STATUS(0xC0000000 | 0x0137)
#define NT_STATUS_ORDINAL_NOT_FOUND NT_STATUS(0xC0000000 | 0x0138)
#define NT_STATUS_ENTRYPOINT_NOT_FOUND NT_STATUS(0xC0000000 | 0x0139)
#define NT_STATUS_CONTROL_C_EXIT NT_STATUS(0xC0000000 | 0x013a)
#define NT_STATUS_LOCAL_DISCONNECT NT_STATUS(0xC0000000 | 0x013b)
#define NT_STATUS_REMOTE_DISCONNECT NT_STATUS(0xC0000000 | 0x013c)
#define NT_STATUS_REMOTE_RESOURCES NT_STATUS(0xC0000000 | 0x013d)
#define NT_STATUS_LINK_FAILED NT_STATUS(0xC0000000 | 0x013e)
#define NT_STATUS_LINK_TIMEOUT NT_STATUS(0xC0000000 | 0x013f)
#define NT_STATUS_INVALID_CONNECTION NT_STATUS(0xC0000000 | 0x0140)
#define NT_STATUS_INVALID_ADDRESS NT_STATUS(0xC0000000 | 0x0141)
#define NT_STATUS_DLL_INIT_FAILED NT_STATUS(0xC0000000 | 0x0142)
#define NT_STATUS_MISSING_SYSTEMFILE NT_STATUS(0xC0000000 | 0x0143)
#define NT_STATUS_UNHANDLED_EXCEPTION NT_STATUS(0xC0000000 | 0x0144)
#define NT_STATUS_APP_INIT_FAILURE NT_STATUS(0xC0000000 | 0x0145)
#define NT_STATUS_PAGEFILE_CREATE_FAILED NT_STATUS(0xC0000000 | 0x0146)
#define NT_STATUS_NO_PAGEFILE NT_STATUS(0xC0000000 | 0x0147)
#define NT_STATUS_INVALID_LEVEL NT_STATUS(0xC0000000 | 0x0148)
#define NT_STATUS_WRONG_PASSWORD_CORE NT_STATUS(0xC0000000 | 0x0149)
#define NT_STATUS_ILLEGAL_FLOAT_CONTEXT NT_STATUS(0xC0000000 | 0x014a)
#define NT_STATUS_PIPE_BROKEN NT_STATUS(0xC0000000 | 0x014b)
#define NT_STATUS_REGISTRY_CORRUPT NT_STATUS(0xC0000000 | 0x014c)
#define NT_STATUS_REGISTRY_IO_FAILED NT_STATUS(0xC0000000 | 0x014d)
#define NT_STATUS_NO_EVENT_PAIR NT_STATUS(0xC0000000 | 0x014e)
#define NT_STATUS_UNRECOGNIZED_VOLUME NT_STATUS(0xC0000000 | 0x014f)
#define NT_STATUS_SERIAL_NO_DEVICE_INITED NT_STATUS(0xC0000000 | 0x0150)
#define NT_STATUS_NO_SUCH_ALIAS NT_STATUS(0xC0000000 | 0x0151)
#define NT_STATUS_MEMBER_NOT_IN_ALIAS NT_STATUS(0xC0000000 | 0x0152)
#define NT_STATUS_MEMBER_IN_ALIAS NT_STATUS(0xC0000000 | 0x0153)
#define NT_STATUS_ALIAS_EXISTS NT_STATUS(0xC0000000 | 0x0154)
#define NT_STATUS_LOGON_NOT_GRANTED NT_STATUS(0xC0000000 | 0x0155)
#define NT_STATUS_TOO_MANY_SECRETS NT_STATUS(0xC0000000 | 0x0156)
#define NT_STATUS_SECRET_TOO_LONG NT_STATUS(0xC0000000 | 0x0157)
#define NT_STATUS_INTERNAL_DB_ERROR NT_STATUS(0xC0000000 | 0x0158)
#define NT_STATUS_FULLSCREEN_MODE NT_STATUS(0xC0000000 | 0x0159)
#define NT_STATUS_TOO_MANY_CONTEXT_IDS NT_STATUS(0xC0000000 | 0x015a)
#define NT_STATUS_LOGON_TYPE_NOT_GRANTED NT_STATUS(0xC0000000 | 0x015b)
#define NT_STATUS_NOT_REGISTRY_FILE NT_STATUS(0xC0000000 | 0x015c)
#define NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED NT_STATUS(0xC0000000 | 0x015d)
#define NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR NT_STATUS(0xC0000000 | 0x015e)
#define NT_STATUS_FT_MISSING_MEMBER NT_STATUS(0xC0000000 | 0x015f)
#define NT_STATUS_ILL_FORMED_SERVICE_ENTRY NT_STATUS(0xC0000000 | 0x0160)
#define NT_STATUS_ILLEGAL_CHARACTER NT_STATUS(0xC0000000 | 0x0161)
#define NT_STATUS_UNMAPPABLE_CHARACTER NT_STATUS(0xC0000000 | 0x0162)
#define NT_STATUS_UNDEFINED_CHARACTER NT_STATUS(0xC0000000 | 0x0163)
#define NT_STATUS_FLOPPY_VOLUME NT_STATUS(0xC0000000 | 0x0164)
#define NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND NT_STATUS(0xC0000000 | 0x0165)
#define NT_STATUS_FLOPPY_WRONG_CYLINDER NT_STATUS(0xC0000000 | 0x0166)
#define NT_STATUS_FLOPPY_UNKNOWN_ERROR NT_STATUS(0xC0000000 | 0x0167)
#define NT_STATUS_FLOPPY_BAD_REGISTERS NT_STATUS(0xC0000000 | 0x0168)
#define NT_STATUS_DISK_RECALIBRATE_FAILED NT_STATUS(0xC0000000 | 0x0169)
#define NT_STATUS_DISK_OPERATION_FAILED NT_STATUS(0xC0000000 | 0x016a)
#define NT_STATUS_DISK_RESET_FAILED NT_STATUS(0xC0000000 | 0x016b)
#define NT_STATUS_SHARED_IRQ_BUSY NT_STATUS(0xC0000000 | 0x016c)
#define NT_STATUS_FT_ORPHANING NT_STATUS(0xC0000000 | 0x016d)
#define NT_STATUS_PARTITION_FAILURE NT_STATUS(0xC0000000 | 0x0172)
#define NT_STATUS_INVALID_BLOCK_LENGTH NT_STATUS(0xC0000000 | 0x0173)
#define NT_STATUS_DEVICE_NOT_PARTITIONED NT_STATUS(0xC0000000 | 0x0174)
#define NT_STATUS_UNABLE_TO_LOCK_MEDIA NT_STATUS(0xC0000000 | 0x0175)
#define NT_STATUS_UNABLE_TO_UNLOAD_MEDIA NT_STATUS(0xC0000000 | 0x0176)
#define NT_STATUS_EOM_OVERFLOW NT_STATUS(0xC0000000 | 0x0177)
#define NT_STATUS_NO_MEDIA NT_STATUS(0xC0000000 | 0x0178)
#define NT_STATUS_NO_SUCH_MEMBER NT_STATUS(0xC0000000 | 0x017a)
#define NT_STATUS_INVALID_MEMBER NT_STATUS(0xC0000000 | 0x017b)
#define NT_STATUS_KEY_DELETED NT_STATUS(0xC0000000 | 0x017c)
#define NT_STATUS_NO_LOG_SPACE NT_STATUS(0xC0000000 | 0x017d)
#define NT_STATUS_TOO_MANY_SIDS NT_STATUS(0xC0000000 | 0x017e)
#define NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED NT_STATUS(0xC0000000 | 0x017f)
#define NT_STATUS_KEY_HAS_CHILDREN NT_STATUS(0xC0000000 | 0x0180)
#define NT_STATUS_CHILD_MUST_BE_VOLATILE NT_STATUS(0xC0000000 | 0x0181)
#define NT_STATUS_DEVICE_CONFIGURATION_ERROR NT_STATUS(0xC0000000 | 0x0182)
#define NT_STATUS_DRIVER_INTERNAL_ERROR NT_STATUS(0xC0000000 | 0x0183)
#define NT_STATUS_INVALID_DEVICE_STATE NT_STATUS(0xC0000000 | 0x0184)
#define NT_STATUS_IO_DEVICE_ERROR NT_STATUS(0xC0000000 | 0x0185)
#define NT_STATUS_DEVICE_PROTOCOL_ERROR NT_STATUS(0xC0000000 | 0x0186)
#define NT_STATUS_BACKUP_CONTROLLER NT_STATUS(0xC0000000 | 0x0187)
#define NT_STATUS_LOG_FILE_FULL NT_STATUS(0xC0000000 | 0x0188)
#define NT_STATUS_TOO_LATE NT_STATUS(0xC0000000 | 0x0189)
#define NT_STATUS_NO_TRUST_LSA_SECRET NT_STATUS(0xC0000000 | 0x018a)
#define NT_STATUS_NO_TRUST_SAM_ACCOUNT NT_STATUS(0xC0000000 | 0x018b)
#define NT_STATUS_TRUSTED_DOMAIN_FAILURE NT_STATUS(0xC0000000 | 0x018c)
#define NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE NT_STATUS(0xC0000000 | 0x018d)
#define NT_STATUS_EVENTLOG_FILE_CORRUPT NT_STATUS(0xC0000000 | 0x018e)
#define NT_STATUS_EVENTLOG_CANT_START NT_STATUS(0xC0000000 | 0x018f)
#define NT_STATUS_TRUST_FAILURE NT_STATUS(0xC0000000 | 0x0190)
#define NT_STATUS_MUTANT_LIMIT_EXCEEDED NT_STATUS(0xC0000000 | 0x0191)
#define NT_STATUS_NETLOGON_NOT_STARTED NT_STATUS(0xC0000000 | 0x0192)
#define NT_STATUS_ACCOUNT_EXPIRED NT_STATUS(0xC0000000 | 0x0193)
#define NT_STATUS_POSSIBLE_DEADLOCK NT_STATUS(0xC0000000 | 0x0194)
#define NT_STATUS_NETWORK_CREDENTIAL_CONFLICT NT_STATUS(0xC0000000 | 0x0195)
#define NT_STATUS_REMOTE_SESSION_LIMIT NT_STATUS(0xC0000000 | 0x0196)
#define NT_STATUS_EVENTLOG_FILE_CHANGED NT_STATUS(0xC0000000 | 0x0197)
#define NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT NT_STATUS(0xC0000000 | 0x0198)
#define NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT NT_STATUS(0xC0000000 | 0x0199)
#define NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT NT_STATUS(0xC0000000 | 0x019a)
#define NT_STATUS_DOMAIN_TRUST_INCONSISTENT NT_STATUS(0xC0000000 | 0x019b)
#define NT_STATUS_FS_DRIVER_REQUIRED NT_STATUS(0xC0000000 | 0x019c)
#define NT_STATUS_NO_USER_SESSION_KEY NT_STATUS(0xC0000000 | 0x0202)
#define NT_STATUS_USER_SESSION_DELETED NT_STATUS(0xC0000000 | 0x0203)
#define NT_STATUS_RESOURCE_LANG_NOT_FOUND NT_STATUS(0xC0000000 | 0x0204)
#define NT_STATUS_INSUFF_SERVER_RESOURCES NT_STATUS(0xC0000000 | 0x0205)
#define NT_STATUS_INVALID_BUFFER_SIZE NT_STATUS(0xC0000000 | 0x0206)
#define NT_STATUS_INVALID_ADDRESS_COMPONENT NT_STATUS(0xC0000000 | 0x0207)
#define NT_STATUS_INVALID_ADDRESS_WILDCARD NT_STATUS(0xC0000000 | 0x0208)
#define NT_STATUS_TOO_MANY_ADDRESSES NT_STATUS(0xC0000000 | 0x0209)
#define NT_STATUS_ADDRESS_ALREADY_EXISTS NT_STATUS(0xC0000000 | 0x020a)
#define NT_STATUS_ADDRESS_CLOSED NT_STATUS(0xC0000000 | 0x020b)
#define NT_STATUS_CONNECTION_DISCONNECTED NT_STATUS(0xC0000000 | 0x020c)
#define NT_STATUS_CONNECTION_RESET NT_STATUS(0xC0000000 | 0x020d)
#define NT_STATUS_TOO_MANY_NODES NT_STATUS(0xC0000000 | 0x020e)
#define NT_STATUS_TRANSACTION_ABORTED NT_STATUS(0xC0000000 | 0x020f)
#define NT_STATUS_TRANSACTION_TIMED_OUT NT_STATUS(0xC0000000 | 0x0210)
#define NT_STATUS_TRANSACTION_NO_RELEASE NT_STATUS(0xC0000000 | 0x0211)
#define NT_STATUS_TRANSACTION_NO_MATCH NT_STATUS(0xC0000000 | 0x0212)
#define NT_STATUS_TRANSACTION_RESPONDED NT_STATUS(0xC0000000 | 0x0213)
#define NT_STATUS_TRANSACTION_INVALID_ID NT_STATUS(0xC0000000 | 0x0214)
#define NT_STATUS_TRANSACTION_INVALID_TYPE NT_STATUS(0xC0000000 | 0x0215)
#define NT_STATUS_NOT_SERVER_SESSION NT_STATUS(0xC0000000 | 0x0216)
#define NT_STATUS_NOT_CLIENT_SESSION NT_STATUS(0xC0000000 | 0x0217)
#define NT_STATUS_CANNOT_LOAD_REGISTRY_FILE NT_STATUS(0xC0000000 | 0x0218)
#define NT_STATUS_DEBUG_ATTACH_FAILED NT_STATUS(0xC0000000 | 0x0219)
#define NT_STATUS_SYSTEM_PROCESS_TERMINATED NT_STATUS(0xC0000000 | 0x021a)
#define NT_STATUS_DATA_NOT_ACCEPTED NT_STATUS(0xC0000000 | 0x021b)
#define NT_STATUS_NO_BROWSER_SERVERS_FOUND NT_STATUS(0xC0000000 | 0x021c)
#define NT_STATUS_VDM_HARD_ERROR NT_STATUS(0xC0000000 | 0x021d)
#define NT_STATUS_DRIVER_CANCEL_TIMEOUT NT_STATUS(0xC0000000 | 0x021e)
#define NT_STATUS_REPLY_MESSAGE_MISMATCH NT_STATUS(0xC0000000 | 0x021f)
#define NT_STATUS_MAPPED_ALIGNMENT NT_STATUS(0xC0000000 | 0x0220)
#define NT_STATUS_IMAGE_CHECKSUM_MISMATCH NT_STATUS(0xC0000000 | 0x0221)
#define NT_STATUS_LOST_WRITEBEHIND_DATA NT_STATUS(0xC0000000 | 0x0222)
#define NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID NT_STATUS(0xC0000000 | 0x0223)
#define NT_STATUS_PASSWORD_MUST_CHANGE NT_STATUS(0xC0000000 | 0x0224)
#define NT_STATUS_NOT_FOUND NT_STATUS(0xC0000000 | 0x0225)
#define NT_STATUS_NOT_TINY_STREAM NT_STATUS(0xC0000000 | 0x0226)
#define NT_STATUS_RECOVERY_FAILURE NT_STATUS(0xC0000000 | 0x0227)
#define NT_STATUS_STACK_OVERFLOW_READ NT_STATUS(0xC0000000 | 0x0228)
#define NT_STATUS_FAIL_CHECK NT_STATUS(0xC0000000 | 0x0229)
#define NT_STATUS_DUPLICATE_OBJECTID NT_STATUS(0xC0000000 | 0x022a)
#define NT_STATUS_OBJECTID_EXISTS NT_STATUS(0xC0000000 | 0x022b)
#define NT_STATUS_CONVERT_TO_LARGE NT_STATUS(0xC0000000 | 0x022c)
#define NT_STATUS_RETRY NT_STATUS(0xC0000000 | 0x022d)
#define NT_STATUS_FOUND_OUT_OF_SCOPE NT_STATUS(0xC0000000 | 0x022e)
#define NT_STATUS_ALLOCATE_BUCKET NT_STATUS(0xC0000000 | 0x022f)
#define NT_STATUS_PROPSET_NOT_FOUND NT_STATUS(0xC0000000 | 0x0230)
#define NT_STATUS_MARSHALL_OVERFLOW NT_STATUS(0xC0000000 | 0x0231)
#define NT_STATUS_INVALID_VARIANT NT_STATUS(0xC0000000 | 0x0232)
#define NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND NT_STATUS(0xC0000000 | 0x0233)
#define NT_STATUS_ACCOUNT_LOCKED_OUT NT_STATUS(0xC0000000 | 0x0234)
#define NT_STATUS_HANDLE_NOT_CLOSABLE NT_STATUS(0xC0000000 | 0x0235)
#define NT_STATUS_CONNECTION_REFUSED NT_STATUS(0xC0000000 | 0x0236)
#define NT_STATUS_GRACEFUL_DISCONNECT NT_STATUS(0xC0000000 | 0x0237)
#define NT_STATUS_ADDRESS_ALREADY_ASSOCIATED NT_STATUS(0xC0000000 | 0x0238)
#define NT_STATUS_ADDRESS_NOT_ASSOCIATED NT_STATUS(0xC0000000 | 0x0239)
#define NT_STATUS_CONNECTION_INVALID NT_STATUS(0xC0000000 | 0x023a)
#define NT_STATUS_CONNECTION_ACTIVE NT_STATUS(0xC0000000 | 0x023b)
#define NT_STATUS_NETWORK_UNREACHABLE NT_STATUS(0xC0000000 | 0x023c)
#define NT_STATUS_HOST_UNREACHABLE NT_STATUS(0xC0000000 | 0x023d)
#define NT_STATUS_PROTOCOL_UNREACHABLE NT_STATUS(0xC0000000 | 0x023e)
#define NT_STATUS_PORT_UNREACHABLE NT_STATUS(0xC0000000 | 0x023f)
#define NT_STATUS_REQUEST_ABORTED NT_STATUS(0xC0000000 | 0x0240)
#define NT_STATUS_CONNECTION_ABORTED NT_STATUS(0xC0000000 | 0x0241)
#define NT_STATUS_BAD_COMPRESSION_BUFFER NT_STATUS(0xC0000000 | 0x0242)
#define NT_STATUS_USER_MAPPED_FILE NT_STATUS(0xC0000000 | 0x0243)
#define NT_STATUS_AUDIT_FAILED NT_STATUS(0xC0000000 | 0x0244)
#define NT_STATUS_TIMER_RESOLUTION_NOT_SET NT_STATUS(0xC0000000 | 0x0245)
#define NT_STATUS_CONNECTION_COUNT_LIMIT NT_STATUS(0xC0000000 | 0x0246)
#define NT_STATUS_LOGIN_TIME_RESTRICTION NT_STATUS(0xC0000000 | 0x0247)
#define NT_STATUS_LOGIN_WKSTA_RESTRICTION NT_STATUS(0xC0000000 | 0x0248)
#define NT_STATUS_IMAGE_MP_UP_MISMATCH NT_STATUS(0xC0000000 | 0x0249)
#define NT_STATUS_INSUFFICIENT_LOGON_INFO NT_STATUS(0xC0000000 | 0x0250)
#define NT_STATUS_BAD_DLL_ENTRYPOINT NT_STATUS(0xC0000000 | 0x0251)
#define NT_STATUS_BAD_SERVICE_ENTRYPOINT NT_STATUS(0xC0000000 | 0x0252)
#define NT_STATUS_LPC_REPLY_LOST NT_STATUS(0xC0000000 | 0x0253)
#define NT_STATUS_IP_ADDRESS_CONFLICT1 NT_STATUS(0xC0000000 | 0x0254)
#define NT_STATUS_IP_ADDRESS_CONFLICT2 NT_STATUS(0xC0000000 | 0x0255)
#define NT_STATUS_REGISTRY_QUOTA_LIMIT NT_STATUS(0xC0000000 | 0x0256)
#define NT_STATUS_PATH_NOT_COVERED NT_STATUS(0xC0000000 | 0x0257)
#define NT_STATUS_NO_CALLBACK_ACTIVE NT_STATUS(0xC0000000 | 0x0258)
#define NT_STATUS_LICENSE_QUOTA_EXCEEDED NT_STATUS(0xC0000000 | 0x0259)
#define NT_STATUS_PWD_TOO_SHORT NT_STATUS(0xC0000000 | 0x025a)
#define NT_STATUS_PWD_TOO_RECENT NT_STATUS(0xC0000000 | 0x025b)
#define NT_STATUS_PWD_HISTORY_CONFLICT NT_STATUS(0xC0000000 | 0x025c)
#define NT_STATUS_PLUGPLAY_NO_DEVICE NT_STATUS(0xC0000000 | 0x025e)
#define NT_STATUS_UNSUPPORTED_COMPRESSION NT_STATUS(0xC0000000 | 0x025f)
#define NT_STATUS_INVALID_HW_PROFILE NT_STATUS(0xC0000000 | 0x0260)
#define NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH NT_STATUS(0xC0000000 | 0x0261)
#define NT_STATUS_DRIVER_ORDINAL_NOT_FOUND NT_STATUS(0xC0000000 | 0x0262)
#define NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND NT_STATUS(0xC0000000 | 0x0263)
#define NT_STATUS_RESOURCE_NOT_OWNED NT_STATUS(0xC0000000 | 0x0264)
#define NT_STATUS_TOO_MANY_LINKS NT_STATUS(0xC0000000 | 0x0265)
#define NT_STATUS_QUOTA_LIST_INCONSISTENT NT_STATUS(0xC0000000 | 0x0266)
#define NT_STATUS_FILE_IS_OFFLINE NT_STATUS(0xC0000000 | 0x0267)
#define NT_STATUS_DS_NO_MORE_RIDS NT_STATUS(0xC0000000 | 0x02A8)
#define NT_STATUS_NOT_A_REPARSE_POINT NT_STATUS(0xC0000000 | 0x0275)
#define NT_STATUS_IO_REPARSE_DATA_INVALID NT_STATUS(0xC0000000 | 0x0278)
#define NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED NT_STATUS(0xC0000000 | 0x0279)
#define NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED NT_STATUS(0xC0000000 | 0x02E9)
#define NT_STATUS_OBJECTID_NOT_FOUND NT_STATUS(0xC0000000 | 0x02F0)
#define NT_STATUS_NO_SUCH_JOB NT_STATUS(0xC0000000 | 0xEDE) /* scheduler */
#define NT_STATUS_NETWORK_SESSION_EXPIRED NT_STATUS(0xC0000000 | 0x035C)
#define NT_STATUS_ALL_SIDS_FILTERED NT_STATUS(0xC0000000 | 0x035E)
#define NT_STATUS_DOWNGRADE_DETECTED NT_STATUS(0xC0000000 | 0x0388)
#define NT_STATUS_NO_S4U_PROT_SUPPORT NT_STATUS(0xC0000000 | 0x040A)
#define NT_STATUS_CROSSREALM_DELEGATION_FAILURE NT_STATUS(0xC0000000 | 0x040B)
#define NT_STATUS_FILE_NOT_AVAILABLE NT_STATUS(0xC0000000 | 0x0467)
#define NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED NT_STATUS(0xC0000000 | 0x20004)
#define NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX NT_STATUS(0xC0000000 | 0x20026)
#define NT_STATUS_RPC_UNKNOWN_IF NT_STATUS(0xC0000000 | 0x20012)
#define NT_STATUS_RPC_CALL_FAILED NT_STATUS(0xC0000000 | 0x2001B)
#define NT_STATUS_RPC_PROTOCOL_ERROR NT_STATUS(0xC0000000 | 0x2001D)
#define NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE NT_STATUS(0xC0000000 | 0x2002E)
#define NT_STATUS_RPC_CANNOT_SUPPORT NT_STATUS(0xC0000000 | 0x20041)
#define NT_STATUS_RPC_SEC_PKG_ERROR NT_STATUS(0xC0000000 | 0x20057)
#define NT_STATUS_RPC_SS_CONTEXT_MISMATCH NT_STATUS(0xC0000000 | 0x30005)
#define NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE NT_STATUS(0xC0000000 | 0x3000A)
#define NT_STATUS_RPC_BAD_STUB_DATA NT_STATUS(0xC0000000 | 0x3000C)
#define NT_STATUS_RPC_INVALID_PIPE_OBJECT NT_STATUS(0xC0000000 | 0x3005C)
#define NT_STATUS_RPC_INVALID_PIPE_OPERATION NT_STATUS(0xC0000000 | 0x3005D)
#define NT_STATUS_RPC_WRONG_PIPE_VERSION NT_STATUS(0xC0000000 | 0x3005E)
#define NT_STATUS_RPC_PIPE_CLOSED NT_STATUS(0xC0000000 | 0x3005F)
#define NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR NT_STATUS(0xC0000000 | 0x30060)
#define NT_STATUS_RPC_PIPE_EMPTY NT_STATUS(0xC0000000 | 0x30061)
#define NT_STATUS_ERROR_DS_OBJ_STRING_NAME_EXISTS NT_STATUS(0xC0000000 | 0x2071)
#define NT_STATUS_ERROR_DS_INCOMPATIBLE_VERSION NT_STATUS(0xC0000000 | 0x00002177)

/*
 * New descriptions for new errors generated from
 * [MS-ERREF] http://msdn.microsoft.com/en-us/library/cc704588.aspx
 */

#define NT_STATUS_WAIT_1				  NT_STATUS(0x00000001)
#define NT_STATUS_WAIT_2				  NT_STATUS(0x00000002)
#define NT_STATUS_WAIT_3				  NT_STATUS(0x00000003)
#define NT_STATUS_WAIT_63				  NT_STATUS(0x0000003F)
#define NT_STATUS_ABANDONED				  NT_STATUS(0x00000080)
#define NT_STATUS_ABANDONED_WAIT_0			  NT_STATUS(0x00000080)
#define NT_STATUS_ABANDONED_WAIT_63			  NT_STATUS(0x000000BF)
#define NT_STATUS_USER_APC				  NT_STATUS(0x000000C0)
#define NT_STATUS_ALERTED				  NT_STATUS(0x00000101)
#define NT_STATUS_TIMEOUT				  NT_STATUS(0x00000102)
#define NT_STATUS_REPARSE				  NT_STATUS(0x00000104)
#define NT_STATUS_NOT_ALL_ASSIGNED			  NT_STATUS(0x00000106)
#define NT_STATUS_OPLOCK_BREAK_IN_PROGRESS		  NT_STATUS(0x00000108)
#define NT_STATUS_VOLUME_MOUNTED			  NT_STATUS(0x00000109)
#define NT_STATUS_RXACT_COMMITTED			  NT_STATUS(0x0000010A)
#define NT_STATUS_NO_QUOTAS_FOR_ACCOUNT			  NT_STATUS(0x0000010D)
#define NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED	  NT_STATUS(0x0000010E)
#define NT_STATUS_PAGE_FAULT_TRANSITION			  NT_STATUS(0x00000110)
#define NT_STATUS_PAGE_FAULT_DEMAND_ZERO		  NT_STATUS(0x00000111)
#define NT_STATUS_PAGE_FAULT_COPY_ON_WRITE		  NT_STATUS(0x00000112)
#define NT_STATUS_PAGE_FAULT_GUARD_PAGE			  NT_STATUS(0x00000113)
#define NT_STATUS_PAGE_FAULT_PAGING_FILE		  NT_STATUS(0x00000114)
#define NT_STATUS_CACHE_PAGE_LOCKED			  NT_STATUS(0x00000115)
#define NT_STATUS_CRASH_DUMP				  NT_STATUS(0x00000116)
#define NT_STATUS_BUFFER_ALL_ZEROS			  NT_STATUS(0x00000117)
#define NT_STATUS_REPARSE_OBJECT			  NT_STATUS(0x00000118)
#define NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED		  NT_STATUS(0x00000119)
#define NT_STATUS_TRANSLATION_COMPLETE			  NT_STATUS(0x00000120)
#define NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY	  NT_STATUS(0x00000121)
#define NT_STATUS_NOTHING_TO_TERMINATE			  NT_STATUS(0x00000122)
#define NT_STATUS_PROCESS_NOT_IN_JOB			  NT_STATUS(0x00000123)
#define NT_STATUS_PROCESS_IN_JOB			  NT_STATUS(0x00000124)
#define NT_STATUS_VOLSNAP_HIBERNATE_READY		  NT_STATUS(0x00000125)
#define NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY	  NT_STATUS(0x00000126)
#define NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED	  NT_STATUS(0x00000127)
#define NT_STATUS_INTERRUPT_STILL_CONNECTED		  NT_STATUS(0x00000128)
#define NT_STATUS_PROCESS_CLONED			  NT_STATUS(0x00000129)
#define NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS		  NT_STATUS(0x0000012A)
#define NT_STATUS_FILE_LOCKED_WITH_WRITERS		  NT_STATUS(0x0000012B)
#define NT_STATUS_RESOURCEMANAGER_READ_ONLY		  NT_STATUS(0x00000202)
#define NT_STATUS_WAIT_FOR_OPLOCK			  NT_STATUS(0x00000367)
#define NT_STATUS_DBG_EXCEPTION_HANDLED			  NT_STATUS(0x00010001)
#define NT_STATUS_DBG_CONTINUE				  NT_STATUS(0x00010002)
#define NT_STATUS_FLT_IO_COMPLETE			  NT_STATUS(0x001C0001)
#define NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY	  NT_STATUS(0xC0000721)
#define NT_STATUS_OBJECT_NAME_EXISTS			  NT_STATUS(0x40000000)
#define NT_STATUS_THREAD_WAS_SUSPENDED			  NT_STATUS(0x40000001)
#define NT_STATUS_WORKING_SET_LIMIT_RANGE		  NT_STATUS(0x40000002)
#define NT_STATUS_IMAGE_NOT_AT_BASE			  NT_STATUS(0x40000003)
#define NT_STATUS_RXACT_STATE_CREATED			  NT_STATUS(0x40000004)
#define NT_STATUS_SEGMENT_NOTIFICATION			  NT_STATUS(0x40000005)
#define NT_STATUS_LOCAL_USER_SESSION_KEY		  NT_STATUS(0x40000006)
#define NT_STATUS_BAD_CURRENT_DIRECTORY			  NT_STATUS(0x40000007)
#define NT_STATUS_SERIAL_MORE_WRITES			  NT_STATUS(0x40000008)
#define NT_STATUS_REGISTRY_RECOVERED			  NT_STATUS(0x40000009)
#define NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP		  NT_STATUS(0x4000000A)
#define NT_STATUS_FT_WRITE_RECOVERY			  NT_STATUS(0x4000000B)
#define NT_STATUS_SERIAL_COUNTER_TIMEOUT		  NT_STATUS(0x4000000C)
#define NT_STATUS_NULL_LM_PASSWORD			  NT_STATUS(0x4000000D)
#define NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH		  NT_STATUS(0x4000000E)
#define NT_STATUS_RECEIVE_PARTIAL			  NT_STATUS(0x4000000F)
#define NT_STATUS_RECEIVE_EXPEDITED			  NT_STATUS(0x40000010)
#define NT_STATUS_RECEIVE_PARTIAL_EXPEDITED		  NT_STATUS(0x40000011)
#define NT_STATUS_EVENT_DONE				  NT_STATUS(0x40000012)
#define NT_STATUS_EVENT_PENDING				  NT_STATUS(0x40000013)
#define NT_STATUS_CHECKING_FILE_SYSTEM			  NT_STATUS(0x40000014)
#define NT_STATUS_FATAL_APP_EXIT			  NT_STATUS(0x40000015)
#define NT_STATUS_PREDEFINED_HANDLE			  NT_STATUS(0x40000016)
#define NT_STATUS_WAS_UNLOCKED				  NT_STATUS(0x40000017)
#define NT_STATUS_SERVICE_NOTIFICATION			  NT_STATUS(0x40000018)
#define NT_STATUS_WAS_LOCKED				  NT_STATUS(0x40000019)
#define NT_STATUS_LOG_HARD_ERROR			  NT_STATUS(0x4000001A)
#define NT_STATUS_ALREADY_WIN32				  NT_STATUS(0x4000001B)
#define NT_STATUS_WX86_UNSIMULATE			  NT_STATUS(0x4000001C)
#define NT_STATUS_WX86_CONTINUE				  NT_STATUS(0x4000001D)
#define NT_STATUS_WX86_SINGLE_STEP			  NT_STATUS(0x4000001E)
#define NT_STATUS_WX86_BREAKPOINT			  NT_STATUS(0x4000001F)
#define NT_STATUS_WX86_EXCEPTION_CONTINUE		  NT_STATUS(0x40000020)
#define NT_STATUS_WX86_EXCEPTION_LASTCHANCE		  NT_STATUS(0x40000021)
#define NT_STATUS_WX86_EXCEPTION_CHAIN			  NT_STATUS(0x40000022)
#define NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE	  NT_STATUS(0x40000023)
#define NT_STATUS_NO_YIELD_PERFORMED			  NT_STATUS(0x40000024)
#define NT_STATUS_TIMER_RESUME_IGNORED			  NT_STATUS(0x40000025)
#define NT_STATUS_ARBITRATION_UNHANDLED			  NT_STATUS(0x40000026)
#define NT_STATUS_CARDBUS_NOT_SUPPORTED			  NT_STATUS(0x40000027)
#define NT_STATUS_WX86_CREATEWX86TIB			  NT_STATUS(0x40000028)
#define NT_STATUS_MP_PROCESSOR_MISMATCH			  NT_STATUS(0x40000029)
#define NT_STATUS_HIBERNATED				  NT_STATUS(0x4000002A)
#define NT_STATUS_RESUME_HIBERNATION			  NT_STATUS(0x4000002B)
#define NT_STATUS_FIRMWARE_UPDATED			  NT_STATUS(0x4000002C)
#define NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES		  NT_STATUS(0x4000002D)
#define NT_STATUS_MESSAGE_RETRIEVED			  NT_STATUS(0x4000002E)
#define NT_STATUS_SYSTEM_POWERSTATE_TRANSITION		  NT_STATUS(0x4000002F)
#define NT_STATUS_ALPC_CHECK_COMPLETION_LIST		  NT_STATUS(0x40000030)
#define NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION	  NT_STATUS(0x40000031)
#define NT_STATUS_ACCESS_AUDIT_BY_POLICY		  NT_STATUS(0x40000032)
#define NT_STATUS_ABANDON_HIBERFILE			  NT_STATUS(0x40000033)
#define NT_STATUS_BIZRULES_NOT_ENABLED			  NT_STATUS(0x40000034)
#define NT_STATUS_WAKE_SYSTEM				  NT_STATUS(0x40000294)
#define NT_STATUS_DS_SHUTTING_DOWN			  NT_STATUS(0x40000370)
#define NT_STATUS_DBG_REPLY_LATER			  NT_STATUS(0x40010001)
#define NT_STATUS_DBG_UNABLE_TO_PROVIDE_HANDLE		  NT_STATUS(0x40010002)
#define NT_STATUS_DBG_TERMINATE_THREAD			  NT_STATUS(0x40010003)
#define NT_STATUS_DBG_TERMINATE_PROCESS			  NT_STATUS(0x40010004)
#define NT_STATUS_DBG_CONTROL_C				  NT_STATUS(0x40010005)
#define NT_STATUS_DBG_PRINTEXCEPTION_C			  NT_STATUS(0x40010006)
#define NT_STATUS_DBG_RIPEXCEPTION			  NT_STATUS(0x40010007)
#define NT_STATUS_DBG_CONTROL_BREAK			  NT_STATUS(0x40010008)
#define NT_STATUS_DBG_COMMAND_EXCEPTION			  NT_STATUS(0x40010009)
#define NT_STATUS_RPC_UUID_LOCAL_ONLY			  NT_STATUS(0x40020056)
#define NT_STATUS_RPC_SEND_INCOMPLETE			  NT_STATUS(0x400200AF)
#define NT_STATUS_CTX_CDM_CONNECT			  NT_STATUS(0x400A0004)
#define NT_STATUS_CTX_CDM_DISCONNECT			  NT_STATUS(0x400A0005)
#define NT_STATUS_SXS_RELEASE_ACTIVATION_CONTEXT	  NT_STATUS(0x4015000D)
#define NT_STATUS_RECOVERY_NOT_NEEDED			  NT_STATUS(0x40190034)
#define NT_STATUS_RM_ALREADY_STARTED			  NT_STATUS(0x40190035)
#define NT_STATUS_LOG_NO_RESTART			  NT_STATUS(0x401A000C)
#define NT_STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST	  NT_STATUS(0x401B00EC)
#define NT_STATUS_GRAPHICS_PARTIAL_DATA_POPULATED	  NT_STATUS(0x401E000A)
#define NT_STATUS_GRAPHICS_DRIVER_MISMATCH		  NT_STATUS(0x401E0117)
#define NT_STATUS_GRAPHICS_MODE_NOT_PINNED		  NT_STATUS(0x401E0307)
#define NT_STATUS_GRAPHICS_NO_PREFERRED_MODE		  NT_STATUS(0x401E031E)
#define NT_STATUS_GRAPHICS_DATASET_IS_EMPTY		  NT_STATUS(0x401E034B)
#define NT_STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET	  NT_STATUS(0x401E034C)
#define NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED NT_STATUS(0x401E0351)
#define NT_STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS		  NT_STATUS(0x401E042F)
#define NT_STATUS_GRAPHICS_LEADLINK_START_DEFERRED	  NT_STATUS(0x401E0437)
#define NT_STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY	  NT_STATUS(0x401E0439)
#define NT_STATUS_GRAPHICS_START_DEFERRED		  NT_STATUS(0x401E043A)
#define NT_STATUS_NDIS_INDICATION_REQUIRED		  NT_STATUS(0x40230001)
#define NT_STATUS_GUARD_PAGE_VIOLATION			  NT_STATUS(0x80000001)
#define NT_STATUS_DATATYPE_MISALIGNMENT			  NT_STATUS(0x80000002)
#define NT_STATUS_BREAKPOINT				  NT_STATUS(0x80000003)
#define NT_STATUS_SINGLE_STEP				  NT_STATUS(0x80000004)
#define NT_STATUS_WAKE_SYSTEM_DEBUGGER			  NT_STATUS(0x80000007)
#define NT_STATUS_HANDLES_CLOSED			  NT_STATUS(0x8000000A)
#define NT_STATUS_NO_INHERITANCE			  NT_STATUS(0x8000000B)
#define NT_STATUS_GUID_SUBSTITUTION_MADE		  NT_STATUS(0x8000000C)
#define NT_STATUS_PARTIAL_COPY				  NT_STATUS(0x8000000D)
#define NT_STATUS_DEVICE_PAPER_EMPTY			  NT_STATUS(0x8000000E)
#define NT_STATUS_DEVICE_POWERED_OFF			  NT_STATUS(0x8000000F)
#define NT_STATUS_DEVICE_OFF_LINE			  NT_STATUS(0x80000010)
#define NT_STATUS_DEVICE_BUSY				  NT_STATUS(0x80000011)
#define NT_STATUS_VERIFY_REQUIRED			  NT_STATUS(0x80000016)
#define NT_STATUS_EXTRANEOUS_INFORMATION		  NT_STATUS(0x80000017)
#define NT_STATUS_RXACT_COMMIT_NECESSARY		  NT_STATUS(0x80000018)
#define NT_STATUS_FILEMARK_DETECTED			  NT_STATUS(0x8000001B)
#define NT_STATUS_MEDIA_CHANGED				  NT_STATUS(0x8000001C)
#define NT_STATUS_BUS_RESET				  NT_STATUS(0x8000001D)
#define NT_STATUS_END_OF_MEDIA				  NT_STATUS(0x8000001E)
#define NT_STATUS_BEGINNING_OF_MEDIA			  NT_STATUS(0x8000001F)
#define NT_STATUS_MEDIA_CHECK				  NT_STATUS(0x80000020)
#define NT_STATUS_SETMARK_DETECTED			  NT_STATUS(0x80000021)
#define NT_STATUS_NO_DATA_DETECTED			  NT_STATUS(0x80000022)
#define NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES		  NT_STATUS(0x80000023)
#define NT_STATUS_SERVER_HAS_OPEN_HANDLES		  NT_STATUS(0x80000024)
#define NT_STATUS_ALREADY_DISCONNECTED			  NT_STATUS(0x80000025)
#define NT_STATUS_LONGJUMP				  NT_STATUS(0x80000026)
#define NT_STATUS_CLEANER_CARTRIDGE_INSTALLED		  NT_STATUS(0x80000027)
#define NT_STATUS_PLUGPLAY_QUERY_VETOED			  NT_STATUS(0x80000028)
#define NT_STATUS_UNWIND_CONSOLIDATE			  NT_STATUS(0x80000029)
#define NT_STATUS_REGISTRY_HIVE_RECOVERED		  NT_STATUS(0x8000002A)
#define NT_STATUS_DLL_MIGHT_BE_INSECURE			  NT_STATUS(0x8000002B)
#define NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE		  NT_STATUS(0x8000002C)
#define NT_STATUS_DEVICE_REQUIRES_CLEANING		  NT_STATUS(0x80000288)
#define NT_STATUS_DEVICE_DOOR_OPEN			  NT_STATUS(0x80000289)
#define NT_STATUS_DATA_LOST_REPAIR			  NT_STATUS(0x80000803)
#define NT_STATUS_DBG_EXCEPTION_NOT_HANDLED		  NT_STATUS(0x80010001)
#define NT_STATUS_CLUSTER_NODE_ALREADY_UP		  NT_STATUS(0x80130001)
#define NT_STATUS_CLUSTER_NODE_ALREADY_DOWN		  NT_STATUS(0x80130002)
#define NT_STATUS_CLUSTER_NETWORK_ALREADY_ONLINE	  NT_STATUS(0x80130003)
#define NT_STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE	  NT_STATUS(0x80130004)
#define NT_STATUS_CLUSTER_NODE_ALREADY_MEMBER		  NT_STATUS(0x80130005)
#define NT_STATUS_COULD_NOT_RESIZE_LOG			  NT_STATUS(0x80190009)
#define NT_STATUS_NO_TXF_METADATA			  NT_STATUS(0x80190029)
#define NT_STATUS_CANT_RECOVER_WITH_HANDLE_OPEN		  NT_STATUS(0x80190031)
#define NT_STATUS_TXF_METADATA_ALREADY_PRESENT		  NT_STATUS(0x80190041)
#define NT_STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET	  NT_STATUS(0x80190042)
#define NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED NT_STATUS(0x801B00EB)
#define NT_STATUS_FLT_BUFFER_TOO_SMALL			  NT_STATUS(0x801C0001)
#define NT_STATUS_FVE_PARTIAL_METADATA			  NT_STATUS(0x80210001)
#define NT_STATUS_FVE_TRANSIENT_STATE			  NT_STATUS(0x80210002)
#define NT_STATUS_VARIABLE_NOT_FOUND			  NT_STATUS(0xC0000100)
#define NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT	  NT_STATUS(0xC000016E)
#define NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL		  NT_STATUS(0xC000019D)
#define NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING NT_STATUS(0xC000019E)
#define NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME	  NT_STATUS(0xC000019F)
#define NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT	  NT_STATUS(0xC00001A0)
#define NT_STATUS_INVALID_ACE_CONDITION			  NT_STATUS(0xC00001A2)
#define NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT		  NT_STATUS(0xC00001A3)
#define NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED	  NT_STATUS(0xC00001A4)
#define NT_STATUS_NETWORK_OPEN_RESTRICTION		  NT_STATUS(0xC0000201)
#define NT_STATUS_EVALUATION_EXPIRATION			  NT_STATUS(0xC0000268)
#define NT_STATUS_ILLEGAL_DLL_RELOCATION		  NT_STATUS(0xC0000269)
#define NT_STATUS_LICENSE_VIOLATION			  NT_STATUS(0xC000026A)
#define NT_STATUS_DLL_INIT_FAILED_LOGOFF		  NT_STATUS(0xC000026B)
#define NT_STATUS_DRIVER_UNABLE_TO_LOAD			  NT_STATUS(0xC000026C)
#define NT_STATUS_DFS_UNAVAILABLE			  NT_STATUS(0xC000026D)
#define NT_STATUS_VOLUME_DISMOUNTED			  NT_STATUS(0xC000026E)
#define NT_STATUS_WX86_INTERNAL_ERROR			  NT_STATUS(0xC000026F)
#define NT_STATUS_WX86_FLOAT_STACK_CHECK		  NT_STATUS(0xC0000270)
#define NT_STATUS_VALIDATE_CONTINUE			  NT_STATUS(0xC0000271)
#define NT_STATUS_NO_MATCH				  NT_STATUS(0xC0000272)
#define NT_STATUS_NO_MORE_MATCHES			  NT_STATUS(0xC0000273)
#define NT_STATUS_IO_REPARSE_TAG_INVALID		  NT_STATUS(0xC0000276)
#define NT_STATUS_IO_REPARSE_TAG_MISMATCH		  NT_STATUS(0xC0000277)
#define NT_STATUS_REPARSE_POINT_NOT_RESOLVED		  NT_STATUS(0xC0000280)
#define NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT		  NT_STATUS(0xC0000281)
#define NT_STATUS_RANGE_LIST_CONFLICT			  NT_STATUS(0xC0000282)
#define NT_STATUS_SOURCE_ELEMENT_EMPTY			  NT_STATUS(0xC0000283)
#define NT_STATUS_DESTINATION_ELEMENT_FULL		  NT_STATUS(0xC0000284)
#define NT_STATUS_ILLEGAL_ELEMENT_ADDRESS		  NT_STATUS(0xC0000285)
#define NT_STATUS_MAGAZINE_NOT_PRESENT			  NT_STATUS(0xC0000286)
#define NT_STATUS_REINITIALIZATION_NEEDED		  NT_STATUS(0xC0000287)
#define NT_STATUS_ENCRYPTION_FAILED			  NT_STATUS(0xC000028A)
#define NT_STATUS_DECRYPTION_FAILED			  NT_STATUS(0xC000028B)
#define NT_STATUS_RANGE_NOT_FOUND			  NT_STATUS(0xC000028C)
#define NT_STATUS_NO_RECOVERY_POLICY			  NT_STATUS(0xC000028D)
#define NT_STATUS_NO_EFS				  NT_STATUS(0xC000028E)
#define NT_STATUS_WRONG_EFS				  NT_STATUS(0xC000028F)
#define NT_STATUS_NO_USER_KEYS				  NT_STATUS(0xC0000290)
#define NT_STATUS_FILE_NOT_ENCRYPTED			  NT_STATUS(0xC0000291)
#define NT_STATUS_NOT_EXPORT_FORMAT			  NT_STATUS(0xC0000292)
#define NT_STATUS_FILE_ENCRYPTED			  NT_STATUS(0xC0000293)
#define NT_STATUS_WMI_GUID_NOT_FOUND			  NT_STATUS(0xC0000295)
#define NT_STATUS_WMI_INSTANCE_NOT_FOUND		  NT_STATUS(0xC0000296)
#define NT_STATUS_WMI_ITEMID_NOT_FOUND			  NT_STATUS(0xC0000297)
#define NT_STATUS_WMI_TRY_AGAIN				  NT_STATUS(0xC0000298)
#define NT_STATUS_SHARED_POLICY				  NT_STATUS(0xC0000299)
#define NT_STATUS_POLICY_OBJECT_NOT_FOUND		  NT_STATUS(0xC000029A)
#define NT_STATUS_POLICY_ONLY_IN_DS			  NT_STATUS(0xC000029B)
#define NT_STATUS_VOLUME_NOT_UPGRADED			  NT_STATUS(0xC000029C)
#define NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE		  NT_STATUS(0xC000029D)
#define NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR		  NT_STATUS(0xC000029E)
#define NT_STATUS_NO_TRACKING_SERVICE			  NT_STATUS(0xC000029F)
#define NT_STATUS_SERVER_SID_MISMATCH			  NT_STATUS(0xC00002A0)
#define NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE		  NT_STATUS(0xC00002A1)
#define NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX		  NT_STATUS(0xC00002A2)
#define NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED		  NT_STATUS(0xC00002A3)
#define NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS		  NT_STATUS(0xC00002A4)
#define NT_STATUS_DS_BUSY				  NT_STATUS(0xC00002A5)
#define NT_STATUS_DS_UNAVAILABLE			  NT_STATUS(0xC00002A6)
#define NT_STATUS_DS_NO_RIDS_ALLOCATED			  NT_STATUS(0xC00002A7)
#define NT_STATUS_DS_INCORRECT_ROLE_OWNER		  NT_STATUS(0xC00002A9)
#define NT_STATUS_DS_RIDMGR_INIT_ERROR			  NT_STATUS(0xC00002AA)
#define NT_STATUS_DS_OBJ_CLASS_VIOLATION		  NT_STATUS(0xC00002AB)
#define NT_STATUS_DS_CANT_ON_NON_LEAF			  NT_STATUS(0xC00002AC)
#define NT_STATUS_DS_CANT_ON_RDN			  NT_STATUS(0xC00002AD)
#define NT_STATUS_DS_CANT_MOD_OBJ_CLASS			  NT_STATUS(0xC00002AE)
#define NT_STATUS_DS_CROSS_DOM_MOVE_FAILED		  NT_STATUS(0xC00002AF)
#define NT_STATUS_DS_GC_NOT_AVAILABLE			  NT_STATUS(0xC00002B0)
#define NT_STATUS_DIRECTORY_SERVICE_REQUIRED		  NT_STATUS(0xC00002B1)
#define NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT		  NT_STATUS(0xC00002B2)
#define NT_STATUS_CANT_ENABLE_DENY_ONLY			  NT_STATUS(0xC00002B3)
#define NT_STATUS_FLOAT_MULTIPLE_FAULTS			  NT_STATUS(0xC00002B4)
#define NT_STATUS_FLOAT_MULTIPLE_TRAPS			  NT_STATUS(0xC00002B5)
#define NT_STATUS_DEVICE_REMOVED			  NT_STATUS(0xC00002B6)
#define NT_STATUS_JOURNAL_DELETE_IN_PROGRESS		  NT_STATUS(0xC00002B7)
#define NT_STATUS_JOURNAL_NOT_ACTIVE			  NT_STATUS(0xC00002B8)
#define NT_STATUS_NOINTERFACE				  NT_STATUS(0xC00002B9)
#define NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED		  NT_STATUS(0xC00002C1)
#define NT_STATUS_DRIVER_FAILED_SLEEP			  NT_STATUS(0xC00002C2)
#define NT_STATUS_MUTUAL_AUTHENTICATION_FAILED		  NT_STATUS(0xC00002C3)
#define NT_STATUS_CORRUPT_SYSTEM_FILE			  NT_STATUS(0xC00002C4)
#define NT_STATUS_DATATYPE_MISALIGNMENT_ERROR		  NT_STATUS(0xC00002C5)
#define NT_STATUS_WMI_READ_ONLY				  NT_STATUS(0xC00002C6)
#define NT_STATUS_WMI_SET_FAILURE			  NT_STATUS(0xC00002C7)
#define NT_STATUS_COMMITMENT_MINIMUM			  NT_STATUS(0xC00002C8)
#define NT_STATUS_REG_NAT_CONSUMPTION			  NT_STATUS(0xC00002C9)
#define NT_STATUS_TRANSPORT_FULL			  NT_STATUS(0xC00002CA)
#define NT_STATUS_DS_SAM_INIT_FAILURE			  NT_STATUS(0xC00002CB)
#define NT_STATUS_ONLY_IF_CONNECTED			  NT_STATUS(0xC00002CC)
#define NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION		  NT_STATUS(0xC00002CD)
#define NT_STATUS_PNP_RESTART_ENUMERATION		  NT_STATUS(0xC00002CE)
#define NT_STATUS_JOURNAL_ENTRY_DELETED			  NT_STATUS(0xC00002CF)
#define NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID		  NT_STATUS(0xC00002D0)
#define NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE		  NT_STATUS(0xC00002D1)
#define NT_STATUS_PNP_REBOOT_REQUIRED			  NT_STATUS(0xC00002D2)
#define NT_STATUS_POWER_STATE_INVALID			  NT_STATUS(0xC00002D3)
#define NT_STATUS_DS_INVALID_GROUP_TYPE			  NT_STATUS(0xC00002D4)
#define NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN   NT_STATUS(0xC00002D5)
#define NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN	  NT_STATUS(0xC00002D6)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER	  NT_STATUS(0xC00002D7)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER	  NT_STATUS(0xC00002D8)
#define NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER	  NT_STATUS(0xC00002D9)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER  NT_STATUS(0xC00002DA)
#define NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER NT_STATUS(0xC00002DB)
#define NT_STATUS_DS_HAVE_PRIMARY_MEMBERS		  NT_STATUS(0xC00002DC)
#define NT_STATUS_WMI_NOT_SUPPORTED			  NT_STATUS(0xC00002DD)
#define NT_STATUS_INSUFFICIENT_POWER			  NT_STATUS(0xC00002DE)
#define NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD		  NT_STATUS(0xC00002DF)
#define NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY		  NT_STATUS(0xC00002E0)
#define NT_STATUS_DS_CANT_START				  NT_STATUS(0xC00002E1)
#define NT_STATUS_DS_INIT_FAILURE			  NT_STATUS(0xC00002E2)
#define NT_STATUS_SAM_INIT_FAILURE			  NT_STATUS(0xC00002E3)
#define NT_STATUS_DS_GC_REQUIRED			  NT_STATUS(0xC00002E4)
#define NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY		  NT_STATUS(0xC00002E5)
#define NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS		  NT_STATUS(0xC00002E6)
#define NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED	  NT_STATUS(0xC00002E7)
#define NT_STATUS_CANNOT_MAKE				  NT_STATUS(0xC00002EA)
#define NT_STATUS_SYSTEM_SHUTDOWN			  NT_STATUS(0xC00002EB)
#define NT_STATUS_DS_INIT_FAILURE_CONSOLE		  NT_STATUS(0xC00002EC)
#define NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE		  NT_STATUS(0xC00002ED)
#define NT_STATUS_UNFINISHED_CONTEXT_DELETED		  NT_STATUS(0xC00002EE)
#define NT_STATUS_NO_TGT_REPLY				  NT_STATUS(0xC00002EF)
#define NT_STATUS_NO_IP_ADDRESSES			  NT_STATUS(0xC00002F1)
#define NT_STATUS_WRONG_CREDENTIAL_HANDLE		  NT_STATUS(0xC00002F2)
#define NT_STATUS_CRYPTO_SYSTEM_INVALID			  NT_STATUS(0xC00002F3)
#define NT_STATUS_MAX_REFERRALS_EXCEEDED		  NT_STATUS(0xC00002F4)
#define NT_STATUS_MUST_BE_KDC				  NT_STATUS(0xC00002F5)
#define NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED		  NT_STATUS(0xC00002F6)
#define NT_STATUS_TOO_MANY_PRINCIPALS			  NT_STATUS(0xC00002F7)
#define NT_STATUS_NO_PA_DATA				  NT_STATUS(0xC00002F8)
#define NT_STATUS_PKINIT_NAME_MISMATCH			  NT_STATUS(0xC00002F9)
#define NT_STATUS_SMARTCARD_LOGON_REQUIRED		  NT_STATUS(0xC00002FA)
#define NT_STATUS_KDC_INVALID_REQUEST			  NT_STATUS(0xC00002FB)
#define NT_STATUS_KDC_UNABLE_TO_REFER			  NT_STATUS(0xC00002FC)
#define NT_STATUS_KDC_UNKNOWN_ETYPE			  NT_STATUS(0xC00002FD)
#define NT_STATUS_SHUTDOWN_IN_PROGRESS			  NT_STATUS(0xC00002FE)
#define NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS		  NT_STATUS(0xC00002FF)
#define NT_STATUS_NOT_SUPPORTED_ON_SBS			  NT_STATUS(0xC0000300)
#define NT_STATUS_WMI_GUID_DISCONNECTED			  NT_STATUS(0xC0000301)
#define NT_STATUS_WMI_ALREADY_DISABLED			  NT_STATUS(0xC0000302)
#define NT_STATUS_WMI_ALREADY_ENABLED			  NT_STATUS(0xC0000303)
#define NT_STATUS_MFT_TOO_FRAGMENTED			  NT_STATUS(0xC0000304)
#define NT_STATUS_COPY_PROTECTION_FAILURE		  NT_STATUS(0xC0000305)
#define NT_STATUS_CSS_AUTHENTICATION_FAILURE		  NT_STATUS(0xC0000306)
#define NT_STATUS_CSS_KEY_NOT_PRESENT			  NT_STATUS(0xC0000307)
#define NT_STATUS_CSS_KEY_NOT_ESTABLISHED		  NT_STATUS(0xC0000308)
#define NT_STATUS_CSS_SCRAMBLED_SECTOR			  NT_STATUS(0xC0000309)
#define NT_STATUS_CSS_REGION_MISMATCH			  NT_STATUS(0xC000030A)
#define NT_STATUS_CSS_RESETS_EXHAUSTED			  NT_STATUS(0xC000030B)
#define NT_STATUS_PKINIT_FAILURE			  NT_STATUS(0xC0000320)
#define NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE		  NT_STATUS(0xC0000321)
#define NT_STATUS_NO_KERB_KEY				  NT_STATUS(0xC0000322)
#define NT_STATUS_HOST_DOWN				  NT_STATUS(0xC0000350)
#define NT_STATUS_UNSUPPORTED_PREAUTH			  NT_STATUS(0xC0000351)
#define NT_STATUS_EFS_ALG_BLOB_TOO_BIG			  NT_STATUS(0xC0000352)
#define NT_STATUS_PORT_NOT_SET				  NT_STATUS(0xC0000353)
#define NT_STATUS_DEBUGGER_INACTIVE			  NT_STATUS(0xC0000354)
#define NT_STATUS_DS_VERSION_CHECK_FAILURE		  NT_STATUS(0xC0000355)
#define NT_STATUS_AUDITING_DISABLED			  NT_STATUS(0xC0000356)
#define NT_STATUS_PRENT4_MACHINE_ACCOUNT		  NT_STATUS(0xC0000357)
#define NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER	  NT_STATUS(0xC0000358)
#define NT_STATUS_INVALID_IMAGE_WIN_32			  NT_STATUS(0xC0000359)
#define NT_STATUS_INVALID_IMAGE_WIN_64			  NT_STATUS(0xC000035A)
#define NT_STATUS_BAD_BINDINGS				  NT_STATUS(0xC000035B)
#define NT_STATUS_APPHELP_BLOCK				  NT_STATUS(0xC000035D)
#define NT_STATUS_NOT_SAFE_MODE_DRIVER			  NT_STATUS(0xC000035F)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT	  NT_STATUS(0xC0000361)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH	  NT_STATUS(0xC0000362)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER	  NT_STATUS(0xC0000363)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER	  NT_STATUS(0xC0000364)
#define NT_STATUS_FAILED_DRIVER_ENTRY			  NT_STATUS(0xC0000365)
#define NT_STATUS_DEVICE_ENUMERATION_ERROR		  NT_STATUS(0xC0000366)
#define NT_STATUS_MOUNT_POINT_NOT_RESOLVED		  NT_STATUS(0xC0000368)
#define NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER	  NT_STATUS(0xC0000369)
#define NT_STATUS_MCA_OCCURED				  NT_STATUS(0xC000036A)
#define NT_STATUS_DRIVER_BLOCKED_CRITICAL		  NT_STATUS(0xC000036B)
#define NT_STATUS_DRIVER_BLOCKED			  NT_STATUS(0xC000036C)
#define NT_STATUS_DRIVER_DATABASE_ERROR			  NT_STATUS(0xC000036D)
#define NT_STATUS_SYSTEM_HIVE_TOO_LARGE			  NT_STATUS(0xC000036E)
#define NT_STATUS_INVALID_IMPORT_OF_NON_DLL		  NT_STATUS(0xC000036F)
#define NT_STATUS_NO_SECRETS				  NT_STATUS(0xC0000371)
#define NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY   NT_STATUS(0xC0000372)
#define NT_STATUS_FAILED_STACK_SWITCH			  NT_STATUS(0xC0000373)
#define NT_STATUS_HEAP_CORRUPTION			  NT_STATUS(0xC0000374)
#define NT_STATUS_SMARTCARD_WRONG_PIN			  NT_STATUS(0xC0000380)
#define NT_STATUS_SMARTCARD_CARD_BLOCKED		  NT_STATUS(0xC0000381)
#define NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED	  NT_STATUS(0xC0000382)
#define NT_STATUS_SMARTCARD_NO_CARD			  NT_STATUS(0xC0000383)
#define NT_STATUS_SMARTCARD_NO_KEY_CONTAINER		  NT_STATUS(0xC0000384)
#define NT_STATUS_SMARTCARD_NO_CERTIFICATE		  NT_STATUS(0xC0000385)
#define NT_STATUS_SMARTCARD_NO_KEYSET			  NT_STATUS(0xC0000386)
#define NT_STATUS_SMARTCARD_IO_ERROR			  NT_STATUS(0xC0000387)
#define NT_STATUS_SMARTCARD_CERT_REVOKED		  NT_STATUS(0xC0000389)
#define NT_STATUS_ISSUING_CA_UNTRUSTED			  NT_STATUS(0xC000038A)
#define NT_STATUS_REVOCATION_OFFLINE_C			  NT_STATUS(0xC000038B)
#define NT_STATUS_PKINIT_CLIENT_FAILURE			  NT_STATUS(0xC000038C)
#define NT_STATUS_SMARTCARD_CERT_EXPIRED		  NT_STATUS(0xC000038D)
#define NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD		  NT_STATUS(0xC000038E)
#define NT_STATUS_SMARTCARD_SILENT_CONTEXT		  NT_STATUS(0xC000038F)
#define NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED		  NT_STATUS(0xC0000401)
#define NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED		  NT_STATUS(0xC0000402)
#define NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED	  NT_STATUS(0xC0000403)
#define NT_STATUS_DS_NAME_NOT_UNIQUE			  NT_STATUS(0xC0000404)
#define NT_STATUS_DS_DUPLICATE_ID_FOUND			  NT_STATUS(0xC0000405)
#define NT_STATUS_DS_GROUP_CONVERSION_ERROR		  NT_STATUS(0xC0000406)
#define NT_STATUS_VOLSNAP_PREPARE_HIBERNATE		  NT_STATUS(0xC0000407)
#define NT_STATUS_USER2USER_REQUIRED			  NT_STATUS(0xC0000408)
#define NT_STATUS_STACK_BUFFER_OVERRUN			  NT_STATUS(0xC0000409)
#define NT_STATUS_REVOCATION_OFFLINE_KDC		  NT_STATUS(0xC000040C)
#define NT_STATUS_ISSUING_CA_UNTRUSTED_KDC		  NT_STATUS(0xC000040D)
#define NT_STATUS_KDC_CERT_EXPIRED			  NT_STATUS(0xC000040E)
#define NT_STATUS_KDC_CERT_REVOKED			  NT_STATUS(0xC000040F)
#define NT_STATUS_PARAMETER_QUOTA_EXCEEDED		  NT_STATUS(0xC0000410)
#define NT_STATUS_HIBERNATION_FAILURE			  NT_STATUS(0xC0000411)
#define NT_STATUS_DELAY_LOAD_FAILED			  NT_STATUS(0xC0000412)
#define NT_STATUS_AUTHENTICATION_FIREWALL_FAILED	  NT_STATUS(0xC0000413)
#define NT_STATUS_VDM_DISALLOWED			  NT_STATUS(0xC0000414)
#define NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD		  NT_STATUS(0xC0000415)
#define NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE NT_STATUS(0xC0000416)
#define NT_STATUS_INVALID_CRUNTIME_PARAMETER		  NT_STATUS(0xC0000417)
#define NT_STATUS_NTLM_BLOCKED				  NT_STATUS(0xC0000418)
#define NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST		  NT_STATUS(0xC0000419)
#define NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST	  NT_STATUS(0xC000041A)
#define NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST		  NT_STATUS(0xC000041B)
#define NT_STATUS_INVALID_USER_PRINCIPAL_NAME		  NT_STATUS(0xC000041C)
#define NT_STATUS_ASSERTION_FAILURE			  NT_STATUS(0xC0000420)
#define NT_STATUS_VERIFIER_STOP				  NT_STATUS(0xC0000421)
#define NT_STATUS_CALLBACK_POP_STACK			  NT_STATUS(0xC0000423)
#define NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED		  NT_STATUS(0xC0000424)
#define NT_STATUS_HIVE_UNLOADED				  NT_STATUS(0xC0000425)
#define NT_STATUS_COMPRESSION_DISABLED			  NT_STATUS(0xC0000426)
#define NT_STATUS_FILE_SYSTEM_LIMITATION		  NT_STATUS(0xC0000427)
#define NT_STATUS_INVALID_IMAGE_HASH			  NT_STATUS(0xC0000428)
#define NT_STATUS_NOT_CAPABLE				  NT_STATUS(0xC0000429)
#define NT_STATUS_REQUEST_OUT_OF_SEQUENCE		  NT_STATUS(0xC000042A)
#define NT_STATUS_IMPLEMENTATION_LIMIT			  NT_STATUS(0xC000042B)
#define NT_STATUS_ELEVATION_REQUIRED			  NT_STATUS(0xC000042C)
#define NT_STATUS_NO_SECURITY_CONTEXT			  NT_STATUS(0xC000042D)
#define NT_STATUS_PKU2U_CERT_FAILURE			  NT_STATUS(0xC000042E)
#define NT_STATUS_BEYOND_VDL				  NT_STATUS(0xC0000432)
#define NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS		  NT_STATUS(0xC0000433)
#define NT_STATUS_PTE_CHANGED				  NT_STATUS(0xC0000434)
#define NT_STATUS_PURGE_FAILED				  NT_STATUS(0xC0000435)
#define NT_STATUS_CRED_REQUIRES_CONFIRMATION		  NT_STATUS(0xC0000440)
#define NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE   NT_STATUS(0xC0000441)
#define NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER	  NT_STATUS(0xC0000442)
#define NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE   NT_STATUS(0xC0000443)
#define NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE	  NT_STATUS(0xC0000444)
#define NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE		  NT_STATUS(0xC0000445)
#define NT_STATUS_INVALID_LABEL				  NT_STATUS(0xC0000446)
#define NT_STATUS_DRIVER_PROCESS_TERMINATED		  NT_STATUS(0xC0000450)
#define NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE		  NT_STATUS(0xC0000451)
#define NT_STATUS_SYSTEM_DEVICE_NOT_FOUND		  NT_STATUS(0xC0000452)
#define NT_STATUS_RESTART_BOOT_APPLICATION		  NT_STATUS(0xC0000453)
#define NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES		  NT_STATUS(0xC0000454)
#define NT_STATUS_NO_RANGES_PROCESSED			  NT_STATUS(0xC0000460)
#define NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED		  NT_STATUS(0xC0000463)
#define NT_STATUS_DEVICE_UNREACHABLE			  NT_STATUS(0xC0000464)
#define NT_STATUS_INVALID_TOKEN				  NT_STATUS(0xC0000465)
#define NT_STATUS_INVALID_TASK_NAME			  NT_STATUS(0xC0000500)
#define NT_STATUS_INVALID_TASK_INDEX			  NT_STATUS(0xC0000501)
#define NT_STATUS_THREAD_ALREADY_IN_TASK		  NT_STATUS(0xC0000502)
#define NT_STATUS_CALLBACK_BYPASS			  NT_STATUS(0xC0000503)
#define NT_STATUS_FAIL_FAST_EXCEPTION			  NT_STATUS(0xC0000602)
#define NT_STATUS_IMAGE_CERT_REVOKED			  NT_STATUS(0xC0000603)
#define NT_STATUS_PORT_CLOSED				  NT_STATUS(0xC0000700)
#define NT_STATUS_MESSAGE_LOST				  NT_STATUS(0xC0000701)
#define NT_STATUS_INVALID_MESSAGE			  NT_STATUS(0xC0000702)
#define NT_STATUS_REQUEST_CANCELED			  NT_STATUS(0xC0000703)
#define NT_STATUS_RECURSIVE_DISPATCH			  NT_STATUS(0xC0000704)
#define NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED		  NT_STATUS(0xC0000705)
#define NT_STATUS_LPC_INVALID_CONNECTION_USAGE		  NT_STATUS(0xC0000706)
#define NT_STATUS_LPC_REQUESTS_NOT_ALLOWED		  NT_STATUS(0xC0000707)
#define NT_STATUS_RESOURCE_IN_USE			  NT_STATUS(0xC0000708)
#define NT_STATUS_HARDWARE_MEMORY_ERROR			  NT_STATUS(0xC0000709)
#define NT_STATUS_THREADPOOL_HANDLE_EXCEPTION		  NT_STATUS(0xC000070A)
#define NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED NT_STATUS(0xC000070B)
#define NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED NT_STATUS(0xC000070C)
#define NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED NT_STATUS(0xC000070D)
#define NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED NT_STATUS(0xC000070E)
#define NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION	  NT_STATUS(0xC000070F)
#define NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING   NT_STATUS(0xC0000710)
#define NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING	  NT_STATUS(0xC0000711)
#define NT_STATUS_PROCESS_IS_PROTECTED			  NT_STATUS(0xC0000712)
#define NT_STATUS_MCA_EXCEPTION				  NT_STATUS(0xC0000713)
#define NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE	  NT_STATUS(0xC0000714)
#define NT_STATUS_SYMLINK_CLASS_DISABLED		  NT_STATUS(0xC0000715)
#define NT_STATUS_INVALID_IDN_NORMALIZATION		  NT_STATUS(0xC0000716)
#define NT_STATUS_NO_UNICODE_TRANSLATION		  NT_STATUS(0xC0000717)
#define NT_STATUS_ALREADY_REGISTERED			  NT_STATUS(0xC0000718)
#define NT_STATUS_CONTEXT_MISMATCH			  NT_STATUS(0xC0000719)
#define NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST	  NT_STATUS(0xC000071A)
#define NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY	  NT_STATUS(0xC000071B)
#define NT_STATUS_INVALID_THREAD			  NT_STATUS(0xC000071C)
#define NT_STATUS_CALLBACK_RETURNED_TRANSACTION		  NT_STATUS(0xC000071D)
#define NT_STATUS_CALLBACK_RETURNED_LDR_LOCK		  NT_STATUS(0xC000071E)
#define NT_STATUS_CALLBACK_RETURNED_LANG		  NT_STATUS(0xC000071F)
#define NT_STATUS_CALLBACK_RETURNED_PRI_BACK		  NT_STATUS(0xC0000720)
#define NT_STATUS_DISK_REPAIR_DISABLED			  NT_STATUS(0xC0000800)
#define NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS		  NT_STATUS(0xC0000801)
#define NT_STATUS_DISK_QUOTA_EXCEEDED			  NT_STATUS(0xC0000802)
#define NT_STATUS_CONTENT_BLOCKED			  NT_STATUS(0xC0000804)
#define NT_STATUS_BAD_CLUSTERS				  NT_STATUS(0xC0000805)
#define NT_STATUS_VOLUME_DIRTY				  NT_STATUS(0xC0000806)
#define NT_STATUS_FILE_CHECKED_OUT			  NT_STATUS(0xC0000901)
#define NT_STATUS_CHECKOUT_REQUIRED			  NT_STATUS(0xC0000902)
#define NT_STATUS_BAD_FILE_TYPE				  NT_STATUS(0xC0000903)
#define NT_STATUS_FILE_TOO_LARGE			  NT_STATUS(0xC0000904)
#define NT_STATUS_FORMS_AUTH_REQUIRED			  NT_STATUS(0xC0000905)
#define NT_STATUS_VIRUS_INFECTED			  NT_STATUS(0xC0000906)
#define NT_STATUS_VIRUS_DELETED				  NT_STATUS(0xC0000907)
#define NT_STATUS_BAD_MCFG_TABLE			  NT_STATUS(0xC0000908)
#define NT_STATUS_CANNOT_BREAK_OPLOCK			  NT_STATUS(0xC0000909)
#define NT_STATUS_WOW_ASSERTION				  NT_STATUS(0xC0009898)
#define NT_STATUS_INVALID_SIGNATURE			  NT_STATUS(0xC000A000)
#define NT_STATUS_HMAC_NOT_SUPPORTED			  NT_STATUS(0xC000A001)
#define NT_STATUS_IPSEC_QUEUE_OVERFLOW			  NT_STATUS(0xC000A010)
#define NT_STATUS_ND_QUEUE_OVERFLOW			  NT_STATUS(0xC000A011)
#define NT_STATUS_HOPLIMIT_EXCEEDED			  NT_STATUS(0xC000A012)
#define NT_STATUS_PROTOCOL_NOT_SUPPORTED		  NT_STATUS(0xC000A013)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED NT_STATUS(0xC000A080)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR NT_STATUS(0xC000A081)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR  NT_STATUS(0xC000A082)
#define NT_STATUS_XML_PARSE_ERROR			  NT_STATUS(0xC000A083)
#define NT_STATUS_XMLDSIG_ERROR				  NT_STATUS(0xC000A084)
#define NT_STATUS_WRONG_COMPARTMENT			  NT_STATUS(0xC000A085)
#define NT_STATUS_AUTHIP_FAILURE			  NT_STATUS(0xC000A086)
#define NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS   NT_STATUS(0xC000A087)
#define NT_STATUS_DS_OID_NOT_FOUND			  NT_STATUS(0xC000A088)
#define NT_STATUS_HASH_NOT_SUPPORTED			  NT_STATUS(0xC000A100)
#define NT_STATUS_HASH_NOT_PRESENT			  NT_STATUS(0xC000A101)
#define NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED	  NT_STATUS(0xC000A2A1)
#define NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED	  NT_STATUS(0xC000A2A2)
#define NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED	  NT_STATUS(0xC000A2A3)
#define NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED	  NT_STATUS(0xC000A2A4)
#define NT_STATUS_DBG_NO_STATE_CHANGE			  NT_STATUS(0xC0010001)
#define NT_STATUS_DBG_APP_NOT_IDLE			  NT_STATUS(0xC0010002)
#define NT_STATUS_RPC_INVALID_STRING_BINDING		  NT_STATUS(0xC0020001)
#define NT_STATUS_RPC_WRONG_KIND_OF_BINDING		  NT_STATUS(0xC0020002)
#define NT_STATUS_RPC_INVALID_BINDING			  NT_STATUS(0xC0020003)
#define NT_STATUS_RPC_INVALID_RPC_PROTSEQ		  NT_STATUS(0xC0020005)
#define NT_STATUS_RPC_INVALID_STRING_UUID		  NT_STATUS(0xC0020006)
#define NT_STATUS_RPC_INVALID_ENDPOINT_FORMAT		  NT_STATUS(0xC0020007)
#define NT_STATUS_RPC_INVALID_NET_ADDR			  NT_STATUS(0xC0020008)
#define NT_STATUS_RPC_NO_ENDPOINT_FOUND			  NT_STATUS(0xC0020009)
#define NT_STATUS_RPC_INVALID_TIMEOUT			  NT_STATUS(0xC002000A)
#define NT_STATUS_RPC_OBJECT_NOT_FOUND			  NT_STATUS(0xC002000B)
#define NT_STATUS_RPC_ALREADY_REGISTERED		  NT_STATUS(0xC002000C)
#define NT_STATUS_RPC_TYPE_ALREADY_REGISTERED		  NT_STATUS(0xC002000D)
#define NT_STATUS_RPC_ALREADY_LISTENING			  NT_STATUS(0xC002000E)
#define NT_STATUS_RPC_NO_PROTSEQS_REGISTERED		  NT_STATUS(0xC002000F)
#define NT_STATUS_RPC_NOT_LISTENING			  NT_STATUS(0xC0020010)
#define NT_STATUS_RPC_UNKNOWN_MGR_TYPE			  NT_STATUS(0xC0020011)
#define NT_STATUS_RPC_NO_BINDINGS			  NT_STATUS(0xC0020013)
#define NT_STATUS_RPC_NO_PROTSEQS			  NT_STATUS(0xC0020014)
#define NT_STATUS_RPC_CANT_CREATE_ENDPOINT		  NT_STATUS(0xC0020015)
#define NT_STATUS_RPC_OUT_OF_RESOURCES			  NT_STATUS(0xC0020016)
#define NT_STATUS_RPC_SERVER_UNAVAILABLE		  NT_STATUS(0xC0020017)
#define NT_STATUS_RPC_SERVER_TOO_BUSY			  NT_STATUS(0xC0020018)
#define NT_STATUS_RPC_INVALID_NETWORK_OPTIONS		  NT_STATUS(0xC0020019)
#define NT_STATUS_RPC_NO_CALL_ACTIVE			  NT_STATUS(0xC002001A)
#define NT_STATUS_RPC_CALL_FAILED_DNE			  NT_STATUS(0xC002001C)
#define NT_STATUS_RPC_UNSUPPORTED_TRANS_SYN		  NT_STATUS(0xC002001F)
#define NT_STATUS_RPC_UNSUPPORTED_TYPE			  NT_STATUS(0xC0020021)
#define NT_STATUS_RPC_INVALID_TAG			  NT_STATUS(0xC0020022)
#define NT_STATUS_RPC_INVALID_BOUND			  NT_STATUS(0xC0020023)
#define NT_STATUS_RPC_NO_ENTRY_NAME			  NT_STATUS(0xC0020024)
#define NT_STATUS_RPC_INVALID_NAME_SYNTAX		  NT_STATUS(0xC0020025)
#define NT_STATUS_RPC_UUID_NO_ADDRESS			  NT_STATUS(0xC0020028)
#define NT_STATUS_RPC_DUPLICATE_ENDPOINT		  NT_STATUS(0xC0020029)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_TYPE		  NT_STATUS(0xC002002A)
#define NT_STATUS_RPC_MAX_CALLS_TOO_SMALL		  NT_STATUS(0xC002002B)
#define NT_STATUS_RPC_STRING_TOO_LONG			  NT_STATUS(0xC002002C)
#define NT_STATUS_RPC_PROTSEQ_NOT_FOUND			  NT_STATUS(0xC002002D)
#define NT_STATUS_RPC_BINDING_HAS_NO_AUTH		  NT_STATUS(0xC002002F)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_SERVICE		  NT_STATUS(0xC0020030)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_LEVEL		  NT_STATUS(0xC0020031)
#define NT_STATUS_RPC_INVALID_AUTH_IDENTITY		  NT_STATUS(0xC0020032)
#define NT_STATUS_RPC_UNKNOWN_AUTHZ_SERVICE		  NT_STATUS(0xC0020033)
#define NT_STATUS_EPT_INVALID_ENTRY			  NT_STATUS(0xC0020034)
#define NT_STATUS_EPT_CANT_PERFORM_OP			  NT_STATUS(0xC0020035)
#define NT_STATUS_EPT_NOT_REGISTERED			  NT_STATUS(0xC0020036)
#define NT_STATUS_RPC_NOTHING_TO_EXPORT			  NT_STATUS(0xC0020037)
#define NT_STATUS_RPC_INCOMPLETE_NAME			  NT_STATUS(0xC0020038)
#define NT_STATUS_RPC_INVALID_VERS_OPTION		  NT_STATUS(0xC0020039)
#define NT_STATUS_RPC_NO_MORE_MEMBERS			  NT_STATUS(0xC002003A)
#define NT_STATUS_RPC_NOT_ALL_OBJS_UNEXPORTED		  NT_STATUS(0xC002003B)
#define NT_STATUS_RPC_INTERFACE_NOT_FOUND		  NT_STATUS(0xC002003C)
#define NT_STATUS_RPC_ENTRY_ALREADY_EXISTS		  NT_STATUS(0xC002003D)
#define NT_STATUS_RPC_ENTRY_NOT_FOUND			  NT_STATUS(0xC002003E)
#define NT_STATUS_RPC_NAME_SERVICE_UNAVAILABLE		  NT_STATUS(0xC002003F)
#define NT_STATUS_RPC_INVALID_NAF_ID			  NT_STATUS(0xC0020040)
#define NT_STATUS_RPC_NO_CONTEXT_AVAILABLE		  NT_STATUS(0xC0020042)
#define NT_STATUS_RPC_INTERNAL_ERROR			  NT_STATUS(0xC0020043)
#define NT_STATUS_RPC_ZERO_DIVIDE			  NT_STATUS(0xC0020044)
#define NT_STATUS_RPC_ADDRESS_ERROR			  NT_STATUS(0xC0020045)
#define NT_STATUS_RPC_FP_DIV_ZERO			  NT_STATUS(0xC0020046)
#define NT_STATUS_RPC_FP_UNDERFLOW			  NT_STATUS(0xC0020047)
#define NT_STATUS_RPC_FP_OVERFLOW			  NT_STATUS(0xC0020048)
#define NT_STATUS_RPC_CALL_IN_PROGRESS			  NT_STATUS(0xC0020049)
#define NT_STATUS_RPC_NO_MORE_BINDINGS			  NT_STATUS(0xC002004A)
#define NT_STATUS_RPC_GROUP_MEMBER_NOT_FOUND		  NT_STATUS(0xC002004B)
#define NT_STATUS_EPT_CANT_CREATE			  NT_STATUS(0xC002004C)
#define NT_STATUS_RPC_INVALID_OBJECT			  NT_STATUS(0xC002004D)
#define NT_STATUS_RPC_NO_INTERFACES			  NT_STATUS(0xC002004F)
#define NT_STATUS_RPC_CALL_CANCELLED			  NT_STATUS(0xC0020050)
#define NT_STATUS_RPC_BINDING_INCOMPLETE		  NT_STATUS(0xC0020051)
#define NT_STATUS_RPC_COMM_FAILURE			  NT_STATUS(0xC0020052)
#define NT_STATUS_RPC_UNSUPPORTED_AUTHN_LEVEL		  NT_STATUS(0xC0020053)
#define NT_STATUS_RPC_NO_PRINC_NAME			  NT_STATUS(0xC0020054)
#define NT_STATUS_RPC_NOT_RPC_ERROR			  NT_STATUS(0xC0020055)
#define NT_STATUS_RPC_NOT_CANCELLED			  NT_STATUS(0xC0020058)
#define NT_STATUS_RPC_INVALID_ASYNC_HANDLE		  NT_STATUS(0xC0020062)
#define NT_STATUS_RPC_INVALID_ASYNC_CALL		  NT_STATUS(0xC0020063)
#define NT_STATUS_RPC_PROXY_ACCESS_DENIED		  NT_STATUS(0xC0020064)
#define NT_STATUS_RPC_NO_MORE_ENTRIES			  NT_STATUS(0xC0030001)
#define NT_STATUS_RPC_SS_CHAR_TRANS_OPEN_FAIL		  NT_STATUS(0xC0030002)
#define NT_STATUS_RPC_SS_CHAR_TRANS_SHORT_FILE		  NT_STATUS(0xC0030003)
#define NT_STATUS_RPC_SS_IN_NULL_CONTEXT		  NT_STATUS(0xC0030004)
#define NT_STATUS_RPC_SS_CONTEXT_DAMAGED		  NT_STATUS(0xC0030006)
#define NT_STATUS_RPC_SS_HANDLES_MISMATCH		  NT_STATUS(0xC0030007)
#define NT_STATUS_RPC_SS_CANNOT_GET_CALL_HANDLE		  NT_STATUS(0xC0030008)
#define NT_STATUS_RPC_NULL_REF_POINTER			  NT_STATUS(0xC0030009)
#define NT_STATUS_RPC_BYTE_COUNT_TOO_SMALL		  NT_STATUS(0xC003000B)
#define NT_STATUS_RPC_INVALID_ES_ACTION			  NT_STATUS(0xC0030059)
#define NT_STATUS_RPC_WRONG_ES_VERSION			  NT_STATUS(0xC003005A)
#define NT_STATUS_RPC_WRONG_STUB_VERSION		  NT_STATUS(0xC003005B)
#define NT_STATUS_PNP_BAD_MPS_TABLE			  NT_STATUS(0xC0040035)
#define NT_STATUS_PNP_TRANSLATION_FAILED		  NT_STATUS(0xC0040036)
#define NT_STATUS_PNP_IRQ_TRANSLATION_FAILED		  NT_STATUS(0xC0040037)
#define NT_STATUS_PNP_INVALID_ID			  NT_STATUS(0xC0040038)
#define NT_STATUS_IO_REISSUE_AS_CACHED			  NT_STATUS(0xC0040039)
#define NT_STATUS_CTX_WINSTATION_NAME_INVALID		  NT_STATUS(0xC00A0001)
#define NT_STATUS_CTX_INVALID_PD			  NT_STATUS(0xC00A0002)
#define NT_STATUS_CTX_PD_NOT_FOUND			  NT_STATUS(0xC00A0003)
#define NT_STATUS_CTX_CLOSE_PENDING			  NT_STATUS(0xC00A0006)
#define NT_STATUS_CTX_NO_OUTBUF				  NT_STATUS(0xC00A0007)
#define NT_STATUS_CTX_MODEM_INF_NOT_FOUND		  NT_STATUS(0xC00A0008)
#define NT_STATUS_CTX_INVALID_MODEMNAME			  NT_STATUS(0xC00A0009)
#define NT_STATUS_CTX_RESPONSE_ERROR			  NT_STATUS(0xC00A000A)
#define NT_STATUS_CTX_MODEM_RESPONSE_TIMEOUT		  NT_STATUS(0xC00A000B)
#define NT_STATUS_CTX_MODEM_RESPONSE_NO_CARRIER		  NT_STATUS(0xC00A000C)
#define NT_STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE	  NT_STATUS(0xC00A000D)
#define NT_STATUS_CTX_MODEM_RESPONSE_BUSY		  NT_STATUS(0xC00A000E)
#define NT_STATUS_CTX_MODEM_RESPONSE_VOICE		  NT_STATUS(0xC00A000F)
#define NT_STATUS_CTX_TD_ERROR				  NT_STATUS(0xC00A0010)
#define NT_STATUS_CTX_LICENSE_CLIENT_INVALID		  NT_STATUS(0xC00A0012)
#define NT_STATUS_CTX_LICENSE_NOT_AVAILABLE		  NT_STATUS(0xC00A0013)
#define NT_STATUS_CTX_LICENSE_EXPIRED			  NT_STATUS(0xC00A0014)
#define NT_STATUS_CTX_WINSTATION_NOT_FOUND		  NT_STATUS(0xC00A0015)
#define NT_STATUS_CTX_WINSTATION_NAME_COLLISION		  NT_STATUS(0xC00A0016)
#define NT_STATUS_CTX_WINSTATION_BUSY			  NT_STATUS(0xC00A0017)
#define NT_STATUS_CTX_BAD_VIDEO_MODE			  NT_STATUS(0xC00A0018)
#define NT_STATUS_CTX_GRAPHICS_INVALID			  NT_STATUS(0xC00A0022)
#define NT_STATUS_CTX_NOT_CONSOLE			  NT_STATUS(0xC00A0024)
#define NT_STATUS_CTX_CLIENT_QUERY_TIMEOUT		  NT_STATUS(0xC00A0026)
#define NT_STATUS_CTX_CONSOLE_DISCONNECT		  NT_STATUS(0xC00A0027)
#define NT_STATUS_CTX_CONSOLE_CONNECT			  NT_STATUS(0xC00A0028)
#define NT_STATUS_CTX_SHADOW_DENIED			  NT_STATUS(0xC00A002A)
#define NT_STATUS_CTX_WINSTATION_ACCESS_DENIED		  NT_STATUS(0xC00A002B)
#define NT_STATUS_CTX_INVALID_WD			  NT_STATUS(0xC00A002E)
#define NT_STATUS_CTX_WD_NOT_FOUND			  NT_STATUS(0xC00A002F)
#define NT_STATUS_CTX_SHADOW_INVALID			  NT_STATUS(0xC00A0030)
#define NT_STATUS_CTX_SHADOW_DISABLED			  NT_STATUS(0xC00A0031)
#define NT_STATUS_RDP_PROTOCOL_ERROR			  NT_STATUS(0xC00A0032)
#define NT_STATUS_CTX_CLIENT_LICENSE_NOT_SET		  NT_STATUS(0xC00A0033)
#define NT_STATUS_CTX_CLIENT_LICENSE_IN_USE		  NT_STATUS(0xC00A0034)
#define NT_STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE	  NT_STATUS(0xC00A0035)
#define NT_STATUS_CTX_SHADOW_NOT_RUNNING		  NT_STATUS(0xC00A0036)
#define NT_STATUS_CTX_LOGON_DISABLED			  NT_STATUS(0xC00A0037)
#define NT_STATUS_CTX_SECURITY_LAYER_ERROR		  NT_STATUS(0xC00A0038)
#define NT_STATUS_TS_INCOMPATIBLE_SESSIONS		  NT_STATUS(0xC00A0039)
#define NT_STATUS_MUI_FILE_NOT_FOUND			  NT_STATUS(0xC00B0001)
#define NT_STATUS_MUI_INVALID_FILE			  NT_STATUS(0xC00B0002)
#define NT_STATUS_MUI_INVALID_RC_CONFIG			  NT_STATUS(0xC00B0003)
#define NT_STATUS_MUI_INVALID_LOCALE_NAME		  NT_STATUS(0xC00B0004)
#define NT_STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME	  NT_STATUS(0xC00B0005)
#define NT_STATUS_MUI_FILE_NOT_LOADED			  NT_STATUS(0xC00B0006)
#define NT_STATUS_RESOURCE_ENUM_USER_STOP		  NT_STATUS(0xC00B0007)
#define NT_STATUS_CLUSTER_INVALID_NODE			  NT_STATUS(0xC0130001)
#define NT_STATUS_CLUSTER_NODE_EXISTS			  NT_STATUS(0xC0130002)
#define NT_STATUS_CLUSTER_JOIN_IN_PROGRESS		  NT_STATUS(0xC0130003)
#define NT_STATUS_CLUSTER_NODE_NOT_FOUND		  NT_STATUS(0xC0130004)
#define NT_STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND		  NT_STATUS(0xC0130005)
#define NT_STATUS_CLUSTER_NETWORK_EXISTS		  NT_STATUS(0xC0130006)
#define NT_STATUS_CLUSTER_NETWORK_NOT_FOUND		  NT_STATUS(0xC0130007)
#define NT_STATUS_CLUSTER_NETINTERFACE_EXISTS		  NT_STATUS(0xC0130008)
#define NT_STATUS_CLUSTER_NETINTERFACE_NOT_FOUND	  NT_STATUS(0xC0130009)
#define NT_STATUS_CLUSTER_INVALID_REQUEST		  NT_STATUS(0xC013000A)
#define NT_STATUS_CLUSTER_INVALID_NETWORK_PROVIDER	  NT_STATUS(0xC013000B)
#define NT_STATUS_CLUSTER_NODE_DOWN			  NT_STATUS(0xC013000C)
#define NT_STATUS_CLUSTER_NODE_UNREACHABLE		  NT_STATUS(0xC013000D)
#define NT_STATUS_CLUSTER_NODE_NOT_MEMBER		  NT_STATUS(0xC013000E)
#define NT_STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS		  NT_STATUS(0xC013000F)
#define NT_STATUS_CLUSTER_INVALID_NETWORK		  NT_STATUS(0xC0130010)
#define NT_STATUS_CLUSTER_NO_NET_ADAPTERS		  NT_STATUS(0xC0130011)
#define NT_STATUS_CLUSTER_NODE_UP			  NT_STATUS(0xC0130012)
#define NT_STATUS_CLUSTER_NODE_PAUSED			  NT_STATUS(0xC0130013)
#define NT_STATUS_CLUSTER_NODE_NOT_PAUSED		  NT_STATUS(0xC0130014)
#define NT_STATUS_CLUSTER_NO_SECURITY_CONTEXT		  NT_STATUS(0xC0130015)
#define NT_STATUS_CLUSTER_NETWORK_NOT_INTERNAL		  NT_STATUS(0xC0130016)
#define NT_STATUS_CLUSTER_POISONED			  NT_STATUS(0xC0130017)
#define NT_STATUS_ACPI_INVALID_OPCODE			  NT_STATUS(0xC0140001)
#define NT_STATUS_ACPI_STACK_OVERFLOW			  NT_STATUS(0xC0140002)
#define NT_STATUS_ACPI_ASSERT_FAILED			  NT_STATUS(0xC0140003)
#define NT_STATUS_ACPI_INVALID_INDEX			  NT_STATUS(0xC0140004)
#define NT_STATUS_ACPI_INVALID_ARGUMENT			  NT_STATUS(0xC0140005)
#define NT_STATUS_ACPI_FATAL				  NT_STATUS(0xC0140006)
#define NT_STATUS_ACPI_INVALID_SUPERNAME		  NT_STATUS(0xC0140007)
#define NT_STATUS_ACPI_INVALID_ARGTYPE			  NT_STATUS(0xC0140008)
#define NT_STATUS_ACPI_INVALID_OBJTYPE			  NT_STATUS(0xC0140009)
#define NT_STATUS_ACPI_INVALID_TARGETTYPE		  NT_STATUS(0xC014000A)
#define NT_STATUS_ACPI_INCORRECT_ARGUMENT_COUNT		  NT_STATUS(0xC014000B)
#define NT_STATUS_ACPI_ADDRESS_NOT_MAPPED		  NT_STATUS(0xC014000C)
#define NT_STATUS_ACPI_INVALID_EVENTTYPE		  NT_STATUS(0xC014000D)
#define NT_STATUS_ACPI_HANDLER_COLLISION		  NT_STATUS(0xC014000E)
#define NT_STATUS_ACPI_INVALID_DATA			  NT_STATUS(0xC014000F)
#define NT_STATUS_ACPI_INVALID_REGION			  NT_STATUS(0xC0140010)
#define NT_STATUS_ACPI_INVALID_ACCESS_SIZE		  NT_STATUS(0xC0140011)
#define NT_STATUS_ACPI_ACQUIRE_GLOBAL_LOCK		  NT_STATUS(0xC0140012)
#define NT_STATUS_ACPI_ALREADY_INITIALIZED		  NT_STATUS(0xC0140013)
#define NT_STATUS_ACPI_NOT_INITIALIZED			  NT_STATUS(0xC0140014)
#define NT_STATUS_ACPI_INVALID_MUTEX_LEVEL		  NT_STATUS(0xC0140015)
#define NT_STATUS_ACPI_MUTEX_NOT_OWNED			  NT_STATUS(0xC0140016)
#define NT_STATUS_ACPI_MUTEX_NOT_OWNER			  NT_STATUS(0xC0140017)
#define NT_STATUS_ACPI_RS_ACCESS			  NT_STATUS(0xC0140018)
#define NT_STATUS_ACPI_INVALID_TABLE			  NT_STATUS(0xC0140019)
#define NT_STATUS_ACPI_REG_HANDLER_FAILED		  NT_STATUS(0xC0140020)
#define NT_STATUS_ACPI_POWER_REQUEST_FAILED		  NT_STATUS(0xC0140021)
#define NT_STATUS_SXS_SECTION_NOT_FOUND			  NT_STATUS(0xC0150001)
#define NT_STATUS_SXS_CANT_GEN_ACTCTX			  NT_STATUS(0xC0150002)
#define NT_STATUS_SXS_INVALID_ACTCTXDATA_FORMAT		  NT_STATUS(0xC0150003)
#define NT_STATUS_SXS_ASSEMBLY_NOT_FOUND		  NT_STATUS(0xC0150004)
#define NT_STATUS_SXS_MANIFEST_FORMAT_ERROR		  NT_STATUS(0xC0150005)
#define NT_STATUS_SXS_MANIFEST_PARSE_ERROR		  NT_STATUS(0xC0150006)
#define NT_STATUS_SXS_ACTIVATION_CONTEXT_DISABLED	  NT_STATUS(0xC0150007)
#define NT_STATUS_SXS_KEY_NOT_FOUND			  NT_STATUS(0xC0150008)
#define NT_STATUS_SXS_VERSION_CONFLICT			  NT_STATUS(0xC0150009)
#define NT_STATUS_SXS_WRONG_SECTION_TYPE		  NT_STATUS(0xC015000A)
#define NT_STATUS_SXS_THREAD_QUERIES_DISABLED		  NT_STATUS(0xC015000B)
#define NT_STATUS_SXS_ASSEMBLY_MISSING			  NT_STATUS(0xC015000C)
#define NT_STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET	  NT_STATUS(0xC015000E)
#define NT_STATUS_SXS_EARLY_DEACTIVATION		  NT_STATUS(0xC015000F)
#define NT_STATUS_SXS_INVALID_DEACTIVATION		  NT_STATUS(0xC0150010)
#define NT_STATUS_SXS_MULTIPLE_DEACTIVATION		  NT_STATUS(0xC0150011)
#define NT_STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY NT_STATUS(0xC0150012)
#define NT_STATUS_SXS_PROCESS_TERMINATION_REQUESTED	  NT_STATUS(0xC0150013)
#define NT_STATUS_SXS_CORRUPT_ACTIVATION_STACK		  NT_STATUS(0xC0150014)
#define NT_STATUS_SXS_CORRUPTION			  NT_STATUS(0xC0150015)
#define NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE	  NT_STATUS(0xC0150016)
#define NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME	  NT_STATUS(0xC0150017)
#define NT_STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE	  NT_STATUS(0xC0150018)
#define NT_STATUS_SXS_IDENTITY_PARSE_ERROR		  NT_STATUS(0xC0150019)
#define NT_STATUS_SXS_COMPONENT_STORE_CORRUPT		  NT_STATUS(0xC015001A)
#define NT_STATUS_SXS_FILE_HASH_MISMATCH		  NT_STATUS(0xC015001B)
#define NT_STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT NT_STATUS(0xC015001C)
#define NT_STATUS_SXS_IDENTITIES_DIFFERENT		  NT_STATUS(0xC015001D)
#define NT_STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT	  NT_STATUS(0xC015001E)
#define NT_STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY		  NT_STATUS(0xC015001F)
#define NT_STATUS_ADVANCED_INSTALLER_FAILED		  NT_STATUS(0xC0150020)
#define NT_STATUS_XML_ENCODING_MISMATCH			  NT_STATUS(0xC0150021)
#define NT_STATUS_SXS_MANIFEST_TOO_BIG			  NT_STATUS(0xC0150022)
#define NT_STATUS_SXS_SETTING_NOT_REGISTERED		  NT_STATUS(0xC0150023)
#define NT_STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE	  NT_STATUS(0xC0150024)
#define NT_STATUS_SMI_PRIMITIVE_INSTALLER_FAILED	  NT_STATUS(0xC0150025)
#define NT_STATUS_GENERIC_COMMAND_FAILED		  NT_STATUS(0xC0150026)
#define NT_STATUS_SXS_FILE_HASH_MISSING			  NT_STATUS(0xC0150027)
#define NT_STATUS_TRANSACTIONAL_CONFLICT		  NT_STATUS(0xC0190001)
#define NT_STATUS_INVALID_TRANSACTION			  NT_STATUS(0xC0190002)
#define NT_STATUS_TRANSACTION_NOT_ACTIVE		  NT_STATUS(0xC0190003)
#define NT_STATUS_TM_INITIALIZATION_FAILED		  NT_STATUS(0xC0190004)
#define NT_STATUS_RM_NOT_ACTIVE				  NT_STATUS(0xC0190005)
#define NT_STATUS_RM_METADATA_CORRUPT			  NT_STATUS(0xC0190006)
#define NT_STATUS_TRANSACTION_NOT_JOINED		  NT_STATUS(0xC0190007)
#define NT_STATUS_DIRECTORY_NOT_RM			  NT_STATUS(0xC0190008)
#define NT_STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE	  NT_STATUS(0xC019000A)
#define NT_STATUS_LOG_RESIZE_INVALID_SIZE		  NT_STATUS(0xC019000B)
#define NT_STATUS_REMOTE_FILE_VERSION_MISMATCH		  NT_STATUS(0xC019000C)
#define NT_STATUS_CRM_PROTOCOL_ALREADY_EXISTS		  NT_STATUS(0xC019000F)
#define NT_STATUS_TRANSACTION_PROPAGATION_FAILED	  NT_STATUS(0xC0190010)
#define NT_STATUS_CRM_PROTOCOL_NOT_FOUND		  NT_STATUS(0xC0190011)
#define NT_STATUS_TRANSACTION_SUPERIOR_EXISTS		  NT_STATUS(0xC0190012)
#define NT_STATUS_TRANSACTION_REQUEST_NOT_VALID		  NT_STATUS(0xC0190013)
#define NT_STATUS_TRANSACTION_NOT_REQUESTED		  NT_STATUS(0xC0190014)
#define NT_STATUS_TRANSACTION_ALREADY_ABORTED		  NT_STATUS(0xC0190015)
#define NT_STATUS_TRANSACTION_ALREADY_COMMITTED		  NT_STATUS(0xC0190016)
#define NT_STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER	  NT_STATUS(0xC0190017)
#define NT_STATUS_CURRENT_TRANSACTION_NOT_VALID		  NT_STATUS(0xC0190018)
#define NT_STATUS_LOG_GROWTH_FAILED			  NT_STATUS(0xC0190019)
#define NT_STATUS_OBJECT_NO_LONGER_EXISTS		  NT_STATUS(0xC0190021)
#define NT_STATUS_STREAM_MINIVERSION_NOT_FOUND		  NT_STATUS(0xC0190022)
#define NT_STATUS_STREAM_MINIVERSION_NOT_VALID		  NT_STATUS(0xC0190023)
#define NT_STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION NT_STATUS(0xC0190024)
#define NT_STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT NT_STATUS(0xC0190025)
#define NT_STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS	  NT_STATUS(0xC0190026)
#define NT_STATUS_HANDLE_NO_LONGER_VALID		  NT_STATUS(0xC0190028)
#define NT_STATUS_LOG_CORRUPTION_DETECTED		  NT_STATUS(0xC0190030)
#define NT_STATUS_RM_DISCONNECTED			  NT_STATUS(0xC0190032)
#define NT_STATUS_ENLISTMENT_NOT_SUPERIOR		  NT_STATUS(0xC0190033)
#define NT_STATUS_FILE_IDENTITY_NOT_PERSISTENT		  NT_STATUS(0xC0190036)
#define NT_STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY	  NT_STATUS(0xC0190037)
#define NT_STATUS_CANT_CROSS_RM_BOUNDARY		  NT_STATUS(0xC0190038)
#define NT_STATUS_TXF_DIR_NOT_EMPTY			  NT_STATUS(0xC0190039)
#define NT_STATUS_INDOUBT_TRANSACTIONS_EXIST		  NT_STATUS(0xC019003A)
#define NT_STATUS_TM_VOLATILE				  NT_STATUS(0xC019003B)
#define NT_STATUS_ROLLBACK_TIMER_EXPIRED		  NT_STATUS(0xC019003C)
#define NT_STATUS_TXF_ATTRIBUTE_CORRUPT			  NT_STATUS(0xC019003D)
#define NT_STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION	  NT_STATUS(0xC019003E)
#define NT_STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED	  NT_STATUS(0xC019003F)
#define NT_STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE   NT_STATUS(0xC0190040)
#define NT_STATUS_TRANSACTION_REQUIRED_PROMOTION	  NT_STATUS(0xC0190043)
#define NT_STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION	  NT_STATUS(0xC0190044)
#define NT_STATUS_TRANSACTIONS_NOT_FROZEN		  NT_STATUS(0xC0190045)
#define NT_STATUS_TRANSACTION_FREEZE_IN_PROGRESS	  NT_STATUS(0xC0190046)
#define NT_STATUS_NOT_SNAPSHOT_VOLUME			  NT_STATUS(0xC0190047)
#define NT_STATUS_NO_SAVEPOINT_WITH_OPEN_FILES		  NT_STATUS(0xC0190048)
#define NT_STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION	  NT_STATUS(0xC0190049)
#define NT_STATUS_TM_IDENTITY_MISMATCH			  NT_STATUS(0xC019004A)
#define NT_STATUS_FLOATED_SECTION			  NT_STATUS(0xC019004B)
#define NT_STATUS_CANNOT_ACCEPT_TRANSACTED_WORK		  NT_STATUS(0xC019004C)
#define NT_STATUS_CANNOT_ABORT_TRANSACTIONS		  NT_STATUS(0xC019004D)
#define NT_STATUS_TRANSACTION_NOT_FOUND			  NT_STATUS(0xC019004E)
#define NT_STATUS_RESOURCEMANAGER_NOT_FOUND		  NT_STATUS(0xC019004F)
#define NT_STATUS_ENLISTMENT_NOT_FOUND			  NT_STATUS(0xC0190050)
#define NT_STATUS_TRANSACTIONMANAGER_NOT_FOUND		  NT_STATUS(0xC0190051)
#define NT_STATUS_TRANSACTIONMANAGER_NOT_ONLINE		  NT_STATUS(0xC0190052)
#define NT_STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION NT_STATUS(0xC0190053)
#define NT_STATUS_TRANSACTION_NOT_ROOT			  NT_STATUS(0xC0190054)
#define NT_STATUS_TRANSACTION_OBJECT_EXPIRED		  NT_STATUS(0xC0190055)
#define NT_STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION  NT_STATUS(0xC0190056)
#define NT_STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED	  NT_STATUS(0xC0190057)
#define NT_STATUS_TRANSACTION_RECORD_TOO_LONG		  NT_STATUS(0xC0190058)
#define NT_STATUS_NO_LINK_TRACKING_IN_TRANSACTION	  NT_STATUS(0xC0190059)
#define NT_STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION  NT_STATUS(0xC019005A)
#define NT_STATUS_TRANSACTION_INTEGRITY_VIOLATED	  NT_STATUS(0xC019005B)
#define NT_STATUS_EXPIRED_HANDLE			  NT_STATUS(0xC0190060)
#define NT_STATUS_TRANSACTION_NOT_ENLISTED		  NT_STATUS(0xC0190061)
#define NT_STATUS_LOG_SECTOR_INVALID			  NT_STATUS(0xC01A0001)
#define NT_STATUS_LOG_SECTOR_PARITY_INVALID		  NT_STATUS(0xC01A0002)
#define NT_STATUS_LOG_SECTOR_REMAPPED			  NT_STATUS(0xC01A0003)
#define NT_STATUS_LOG_BLOCK_INCOMPLETE			  NT_STATUS(0xC01A0004)
#define NT_STATUS_LOG_INVALID_RANGE			  NT_STATUS(0xC01A0005)
#define NT_STATUS_LOG_BLOCKS_EXHAUSTED			  NT_STATUS(0xC01A0006)
#define NT_STATUS_LOG_READ_CONTEXT_INVALID		  NT_STATUS(0xC01A0007)
#define NT_STATUS_LOG_RESTART_INVALID			  NT_STATUS(0xC01A0008)
#define NT_STATUS_LOG_BLOCK_VERSION			  NT_STATUS(0xC01A0009)
#define NT_STATUS_LOG_BLOCK_INVALID			  NT_STATUS(0xC01A000A)
#define NT_STATUS_LOG_READ_MODE_INVALID			  NT_STATUS(0xC01A000B)
#define NT_STATUS_LOG_METADATA_CORRUPT			  NT_STATUS(0xC01A000D)
#define NT_STATUS_LOG_METADATA_INVALID			  NT_STATUS(0xC01A000E)
#define NT_STATUS_LOG_METADATA_INCONSISTENT		  NT_STATUS(0xC01A000F)
#define NT_STATUS_LOG_RESERVATION_INVALID		  NT_STATUS(0xC01A0010)
#define NT_STATUS_LOG_CANT_DELETE			  NT_STATUS(0xC01A0011)
#define NT_STATUS_LOG_CONTAINER_LIMIT_EXCEEDED		  NT_STATUS(0xC01A0012)
#define NT_STATUS_LOG_START_OF_LOG			  NT_STATUS(0xC01A0013)
#define NT_STATUS_LOG_POLICY_ALREADY_INSTALLED		  NT_STATUS(0xC01A0014)
#define NT_STATUS_LOG_POLICY_NOT_INSTALLED		  NT_STATUS(0xC01A0015)
#define NT_STATUS_LOG_POLICY_INVALID			  NT_STATUS(0xC01A0016)
#define NT_STATUS_LOG_POLICY_CONFLICT			  NT_STATUS(0xC01A0017)
#define NT_STATUS_LOG_PINNED_ARCHIVE_TAIL		  NT_STATUS(0xC01A0018)
#define NT_STATUS_LOG_RECORD_NONEXISTENT		  NT_STATUS(0xC01A0019)
#define NT_STATUS_LOG_RECORDS_RESERVED_INVALID		  NT_STATUS(0xC01A001A)
#define NT_STATUS_LOG_SPACE_RESERVED_INVALID		  NT_STATUS(0xC01A001B)
#define NT_STATUS_LOG_TAIL_INVALID			  NT_STATUS(0xC01A001C)
#define NT_STATUS_LOG_FULL				  NT_STATUS(0xC01A001D)
#define NT_STATUS_LOG_MULTIPLEXED			  NT_STATUS(0xC01A001E)
#define NT_STATUS_LOG_DEDICATED				  NT_STATUS(0xC01A001F)
#define NT_STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS		  NT_STATUS(0xC01A0020)
#define NT_STATUS_LOG_ARCHIVE_IN_PROGRESS		  NT_STATUS(0xC01A0021)
#define NT_STATUS_LOG_EPHEMERAL				  NT_STATUS(0xC01A0022)
#define NT_STATUS_LOG_NOT_ENOUGH_CONTAINERS		  NT_STATUS(0xC01A0023)
#define NT_STATUS_LOG_CLIENT_ALREADY_REGISTERED		  NT_STATUS(0xC01A0024)
#define NT_STATUS_LOG_CLIENT_NOT_REGISTERED		  NT_STATUS(0xC01A0025)
#define NT_STATUS_LOG_FULL_HANDLER_IN_PROGRESS		  NT_STATUS(0xC01A0026)
#define NT_STATUS_LOG_CONTAINER_READ_FAILED		  NT_STATUS(0xC01A0027)
#define NT_STATUS_LOG_CONTAINER_WRITE_FAILED		  NT_STATUS(0xC01A0028)
#define NT_STATUS_LOG_CONTAINER_OPEN_FAILED		  NT_STATUS(0xC01A0029)
#define NT_STATUS_LOG_CONTAINER_STATE_INVALID		  NT_STATUS(0xC01A002A)
#define NT_STATUS_LOG_STATE_INVALID			  NT_STATUS(0xC01A002B)
#define NT_STATUS_LOG_PINNED				  NT_STATUS(0xC01A002C)
#define NT_STATUS_LOG_METADATA_FLUSH_FAILED		  NT_STATUS(0xC01A002D)
#define NT_STATUS_LOG_INCONSISTENT_SECURITY		  NT_STATUS(0xC01A002E)
#define NT_STATUS_LOG_APPENDED_FLUSH_FAILED		  NT_STATUS(0xC01A002F)
#define NT_STATUS_LOG_PINNED_RESERVATION		  NT_STATUS(0xC01A0030)
#define NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD	  NT_STATUS(0xC01B00EA)
#define NT_STATUS_FLT_NO_HANDLER_DEFINED		  NT_STATUS(0xC01C0001)
#define NT_STATUS_FLT_CONTEXT_ALREADY_DEFINED		  NT_STATUS(0xC01C0002)
#define NT_STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST	  NT_STATUS(0xC01C0003)
#define NT_STATUS_FLT_DISALLOW_FAST_IO			  NT_STATUS(0xC01C0004)
#define NT_STATUS_FLT_INVALID_NAME_REQUEST		  NT_STATUS(0xC01C0005)
#define NT_STATUS_FLT_NOT_SAFE_TO_POST_OPERATION	  NT_STATUS(0xC01C0006)
#define NT_STATUS_FLT_NOT_INITIALIZED			  NT_STATUS(0xC01C0007)
#define NT_STATUS_FLT_FILTER_NOT_READY			  NT_STATUS(0xC01C0008)
#define NT_STATUS_FLT_POST_OPERATION_CLEANUP		  NT_STATUS(0xC01C0009)
#define NT_STATUS_FLT_INTERNAL_ERROR			  NT_STATUS(0xC01C000A)
#define NT_STATUS_FLT_DELETING_OBJECT			  NT_STATUS(0xC01C000B)
#define NT_STATUS_FLT_MUST_BE_NONPAGED_POOL		  NT_STATUS(0xC01C000C)
#define NT_STATUS_FLT_DUPLICATE_ENTRY			  NT_STATUS(0xC01C000D)
#define NT_STATUS_FLT_CBDQ_DISABLED			  NT_STATUS(0xC01C000E)
#define NT_STATUS_FLT_DO_NOT_ATTACH			  NT_STATUS(0xC01C000F)
#define NT_STATUS_FLT_DO_NOT_DETACH			  NT_STATUS(0xC01C0010)
#define NT_STATUS_FLT_INSTANCE_ALTITUDE_COLLISION	  NT_STATUS(0xC01C0011)
#define NT_STATUS_FLT_INSTANCE_NAME_COLLISION		  NT_STATUS(0xC01C0012)
#define NT_STATUS_FLT_FILTER_NOT_FOUND			  NT_STATUS(0xC01C0013)
#define NT_STATUS_FLT_VOLUME_NOT_FOUND			  NT_STATUS(0xC01C0014)
#define NT_STATUS_FLT_INSTANCE_NOT_FOUND		  NT_STATUS(0xC01C0015)
#define NT_STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND	  NT_STATUS(0xC01C0016)
#define NT_STATUS_FLT_INVALID_CONTEXT_REGISTRATION	  NT_STATUS(0xC01C0017)
#define NT_STATUS_FLT_NAME_CACHE_MISS			  NT_STATUS(0xC01C0018)
#define NT_STATUS_FLT_NO_DEVICE_OBJECT			  NT_STATUS(0xC01C0019)
#define NT_STATUS_FLT_VOLUME_ALREADY_MOUNTED		  NT_STATUS(0xC01C001A)
#define NT_STATUS_FLT_ALREADY_ENLISTED			  NT_STATUS(0xC01C001B)
#define NT_STATUS_FLT_CONTEXT_ALREADY_LINKED		  NT_STATUS(0xC01C001C)
#define NT_STATUS_FLT_NO_WAITER_FOR_REPLY		  NT_STATUS(0xC01C0020)
#define NT_STATUS_MONITOR_NO_DESCRIPTOR			  NT_STATUS(0xC01D0001)
#define NT_STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT	  NT_STATUS(0xC01D0002)
#define NT_STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM	  NT_STATUS(0xC01D0003)
#define NT_STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK   NT_STATUS(0xC01D0004)
#define NT_STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED NT_STATUS(0xC01D0005)
#define NT_STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK NT_STATUS(0xC01D0006)
#define NT_STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK NT_STATUS(0xC01D0007)
#define NT_STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA	  NT_STATUS(0xC01D0008)
#define NT_STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK   NT_STATUS(0xC01D0009)
#define NT_STATUS_MONITOR_INVALID_MANUFACTURE_DATE	  NT_STATUS(0xC01D000A)
#define NT_STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER	  NT_STATUS(0xC01E0000)
#define NT_STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER	  NT_STATUS(0xC01E0001)
#define NT_STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER	  NT_STATUS(0xC01E0002)
#define NT_STATUS_GRAPHICS_ADAPTER_WAS_RESET		  NT_STATUS(0xC01E0003)
#define NT_STATUS_GRAPHICS_INVALID_DRIVER_MODEL		  NT_STATUS(0xC01E0004)
#define NT_STATUS_GRAPHICS_PRESENT_MODE_CHANGED		  NT_STATUS(0xC01E0005)
#define NT_STATUS_GRAPHICS_PRESENT_OCCLUDED		  NT_STATUS(0xC01E0006)
#define NT_STATUS_GRAPHICS_PRESENT_DENIED		  NT_STATUS(0xC01E0007)
#define NT_STATUS_GRAPHICS_CANNOTCOLORCONVERT		  NT_STATUS(0xC01E0008)
#define NT_STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED   NT_STATUS(0xC01E000B)
#define NT_STATUS_GRAPHICS_PRESENT_UNOCCLUDED		  NT_STATUS(0xC01E000C)
#define NT_STATUS_GRAPHICS_NO_VIDEO_MEMORY		  NT_STATUS(0xC01E0100)
#define NT_STATUS_GRAPHICS_CANT_LOCK_MEMORY		  NT_STATUS(0xC01E0101)
#define NT_STATUS_GRAPHICS_ALLOCATION_BUSY		  NT_STATUS(0xC01E0102)
#define NT_STATUS_GRAPHICS_TOO_MANY_REFERENCES		  NT_STATUS(0xC01E0103)
#define NT_STATUS_GRAPHICS_TRY_AGAIN_LATER		  NT_STATUS(0xC01E0104)
#define NT_STATUS_GRAPHICS_TRY_AGAIN_NOW		  NT_STATUS(0xC01E0105)
#define NT_STATUS_GRAPHICS_ALLOCATION_INVALID		  NT_STATUS(0xC01E0106)
#define NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE NT_STATUS(0xC01E0107)
#define NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED NT_STATUS(0xC01E0108)
#define NT_STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION   NT_STATUS(0xC01E0109)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE	  NT_STATUS(0xC01E0110)
#define NT_STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION  NT_STATUS(0xC01E0111)
#define NT_STATUS_GRAPHICS_ALLOCATION_CLOSED		  NT_STATUS(0xC01E0112)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE	  NT_STATUS(0xC01E0113)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE	  NT_STATUS(0xC01E0114)
#define NT_STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE	  NT_STATUS(0xC01E0115)
#define NT_STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST	  NT_STATUS(0xC01E0116)
#define NT_STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE	  NT_STATUS(0xC01E0200)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY	  NT_STATUS(0xC01E0300)
#define NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED   NT_STATUS(0xC01E0301)
#define NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED NT_STATUS(0xC01E0302)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN		  NT_STATUS(0xC01E0303)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE   NT_STATUS(0xC01E0304)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET   NT_STATUS(0xC01E0305)
#define NT_STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED   NT_STATUS(0xC01E0306)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET	  NT_STATUS(0xC01E0308)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET	  NT_STATUS(0xC01E0309)
#define NT_STATUS_GRAPHICS_INVALID_FREQUENCY		  NT_STATUS(0xC01E030A)
#define NT_STATUS_GRAPHICS_INVALID_ACTIVE_REGION	  NT_STATUS(0xC01E030B)
#define NT_STATUS_GRAPHICS_INVALID_TOTAL_REGION		  NT_STATUS(0xC01E030C)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE NT_STATUS(0xC01E0310)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE NT_STATUS(0xC01E0311)
#define NT_STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET NT_STATUS(0xC01E0312)
#define NT_STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY	  NT_STATUS(0xC01E0313)
#define NT_STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET	  NT_STATUS(0xC01E0314)
#define NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET  NT_STATUS(0xC01E0315)
#define NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET  NT_STATUS(0xC01E0316)
#define NT_STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET	  NT_STATUS(0xC01E0317)
#define NT_STATUS_GRAPHICS_TARGET_ALREADY_IN_SET	  NT_STATUS(0xC01E0318)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH	  NT_STATUS(0xC01E0319)
#define NT_STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY  NT_STATUS(0xC01E031A)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET NT_STATUS(0xC01E031B)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE NT_STATUS(0xC01E031C)
#define NT_STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET	  NT_STATUS(0xC01E031D)
#define NT_STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET  NT_STATUS(0xC01E031F)
#define NT_STATUS_GRAPHICS_STALE_MODESET		  NT_STATUS(0xC01E0320)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET  NT_STATUS(0xC01E0321)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE	  NT_STATUS(0xC01E0322)
#define NT_STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN NT_STATUS(0xC01E0323)
#define NT_STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE	  NT_STATUS(0xC01E0324)
#define NT_STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION NT_STATUS(0xC01E0325)
#define NT_STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES NT_STATUS(0xC01E0326)
#define NT_STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY		  NT_STATUS(0xC01E0327)
#define NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE NT_STATUS(0xC01E0328)
#define NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET NT_STATUS(0xC01E0329)
#define NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET   NT_STATUS(0xC01E032A)
#define NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR	  NT_STATUS(0xC01E032B)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET   NT_STATUS(0xC01E032C)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET NT_STATUS(0xC01E032D)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE NT_STATUS(0xC01E032E)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE NT_STATUS(0xC01E032F)
#define NT_STATUS_GRAPHICS_RESOURCES_NOT_RELATED	  NT_STATUS(0xC01E0330)
#define NT_STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE	  NT_STATUS(0xC01E0331)
#define NT_STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE	  NT_STATUS(0xC01E0332)
#define NT_STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET	  NT_STATUS(0xC01E0333)
#define NT_STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER NT_STATUS(0xC01E0334)
#define NT_STATUS_GRAPHICS_NO_VIDPNMGR			  NT_STATUS(0xC01E0335)
#define NT_STATUS_GRAPHICS_NO_ACTIVE_VIDPN		  NT_STATUS(0xC01E0336)
#define NT_STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY		  NT_STATUS(0xC01E0337)
#define NT_STATUS_GRAPHICS_MONITOR_NOT_CONNECTED	  NT_STATUS(0xC01E0338)
#define NT_STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY	  NT_STATUS(0xC01E0339)
#define NT_STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE	  NT_STATUS(0xC01E033A)
#define NT_STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE	  NT_STATUS(0xC01E033B)
#define NT_STATUS_GRAPHICS_INVALID_STRIDE		  NT_STATUS(0xC01E033C)
#define NT_STATUS_GRAPHICS_INVALID_PIXELFORMAT		  NT_STATUS(0xC01E033D)
#define NT_STATUS_GRAPHICS_INVALID_COLORBASIS		  NT_STATUS(0xC01E033E)
#define NT_STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE   NT_STATUS(0xC01E033F)
#define NT_STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY	  NT_STATUS(0xC01E0340)
#define NT_STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT NT_STATUS(0xC01E0341)
#define NT_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE		  NT_STATUS(0xC01E0342)
#define NT_STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN	  NT_STATUS(0xC01E0343)
#define NT_STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL NT_STATUS(0xC01E0344)
#define NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION NT_STATUS(0xC01E0345)
#define NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED NT_STATUS(0xC01E0346)
#define NT_STATUS_GRAPHICS_INVALID_GAMMA_RAMP		  NT_STATUS(0xC01E0347)
#define NT_STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED	  NT_STATUS(0xC01E0348)
#define NT_STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED	  NT_STATUS(0xC01E0349)
#define NT_STATUS_GRAPHICS_MODE_NOT_IN_MODESET		  NT_STATUS(0xC01E034A)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON NT_STATUS(0xC01E034D)
#define NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE	  NT_STATUS(0xC01E034E)
#define NT_STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE	  NT_STATUS(0xC01E034F)
#define NT_STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS NT_STATUS(0xC01E0350)
#define NT_STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING	  NT_STATUS(0xC01E0352)
#define NT_STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED   NT_STATUS(0xC01E0353)
#define NT_STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS NT_STATUS(0xC01E0354)
#define NT_STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT	  NT_STATUS(0xC01E0355)
#define NT_STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM NT_STATUS(0xC01E0356)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN NT_STATUS(0xC01E0357)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT NT_STATUS(0xC01E0358)
#define NT_STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED	  NT_STATUS(0xC01E0359)
#define NT_STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION NT_STATUS(0xC01E035A)
#define NT_STATUS_GRAPHICS_INVALID_CLIENT_TYPE		  NT_STATUS(0xC01E035B)
#define NT_STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET		  NT_STATUS(0xC01E035C)
#define NT_STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED NT_STATUS(0xC01E0400)
#define NT_STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED NT_STATUS(0xC01E0401)
#define NT_STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER		  NT_STATUS(0xC01E0430)
#define NT_STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED	  NT_STATUS(0xC01E0431)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED	  NT_STATUS(0xC01E0432)
#define NT_STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY	  NT_STATUS(0xC01E0433)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED	  NT_STATUS(0xC01E0434)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON	  NT_STATUS(0xC01E0435)
#define NT_STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE NT_STATUS(0xC01E0436)
#define NT_STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER	  NT_STATUS(0xC01E0438)
#define NT_STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED	  NT_STATUS(0xC01E043B)
#define NT_STATUS_GRAPHICS_OPM_NOT_SUPPORTED		  NT_STATUS(0xC01E0500)
#define NT_STATUS_GRAPHICS_COPP_NOT_SUPPORTED		  NT_STATUS(0xC01E0501)
#define NT_STATUS_GRAPHICS_UAB_NOT_SUPPORTED		  NT_STATUS(0xC01E0502)
#define NT_STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS NT_STATUS(0xC01E0503)
#define NT_STATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL  NT_STATUS(0xC01E0504)
#define NT_STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST NT_STATUS(0xC01E0505)
#define NT_STATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME NT_STATUS(0xC01E0506)
#define NT_STATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP NT_STATUS(0xC01E0507)
#define NT_STATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED NT_STATUS(0xC01E0508)
#define NT_STATUS_GRAPHICS_OPM_INVALID_POINTER		  NT_STATUS(0xC01E050A)
#define NT_STATUS_GRAPHICS_OPM_INTERNAL_ERROR		  NT_STATUS(0xC01E050B)
#define NT_STATUS_GRAPHICS_OPM_INVALID_HANDLE		  NT_STATUS(0xC01E050C)
#define NT_STATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE NT_STATUS(0xC01E050D)
#define NT_STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH NT_STATUS(0xC01E050E)
#define NT_STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED	  NT_STATUS(0xC01E050F)
#define NT_STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED	  NT_STATUS(0xC01E0510)
#define NT_STATUS_GRAPHICS_PVP_HFS_FAILED		  NT_STATUS(0xC01E0511)
#define NT_STATUS_GRAPHICS_OPM_INVALID_SRM		  NT_STATUS(0xC01E0512)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP NT_STATUS(0xC01E0513)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP NT_STATUS(0xC01E0514)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA NT_STATUS(0xC01E0515)
#define NT_STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET	  NT_STATUS(0xC01E0516)
#define NT_STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH	  NT_STATUS(0xC01E0517)
#define NT_STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE NT_STATUS(0xC01E0518)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS NT_STATUS(0xC01E051A)
#define NT_STATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS NT_STATUS(0xC01E051B)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS NT_STATUS(0xC01E051C)
#define NT_STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST NT_STATUS(0xC01E051D)
#define NT_STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR	  NT_STATUS(0xC01E051E)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS NT_STATUS(0xC01E051F)
#define NT_STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED	  NT_STATUS(0xC01E0520)
#define NT_STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST NT_STATUS(0xC01E0521)
#define NT_STATUS_GRAPHICS_I2C_NOT_SUPPORTED		  NT_STATUS(0xC01E0580)
#define NT_STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST	  NT_STATUS(0xC01E0581)
#define NT_STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA	  NT_STATUS(0xC01E0582)
#define NT_STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA	  NT_STATUS(0xC01E0583)
#define NT_STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED	  NT_STATUS(0xC01E0584)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_DATA		  NT_STATUS(0xC01E0585)
#define NT_STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE NT_STATUS(0xC01E0586)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING NT_STATUS(0xC01E0587)
#define NT_STATUS_GRAPHICS_MCA_INTERNAL_ERROR		  NT_STATUS(0xC01E0588)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND  NT_STATUS(0xC01E0589)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH   NT_STATUS(0xC01E058A)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM NT_STATUS(0xC01E058B)
#define NT_STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE NT_STATUS(0xC01E058C)
#define NT_STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS	  NT_STATUS(0xC01E058D)
#define NT_STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED NT_STATUS(0xC01E05E0)
#define NT_STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME NT_STATUS(0xC01E05E1)
#define NT_STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP NT_STATUS(0xC01E05E2)
#define NT_STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED NT_STATUS(0xC01E05E3)
#define NT_STATUS_GRAPHICS_INVALID_POINTER		  NT_STATUS(0xC01E05E4)
#define NT_STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE NT_STATUS(0xC01E05E5)
#define NT_STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL	  NT_STATUS(0xC01E05E6)
#define NT_STATUS_GRAPHICS_INTERNAL_ERROR		  NT_STATUS(0xC01E05E7)
#define NT_STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS NT_STATUS(0xC01E05E8)
#define NT_STATUS_FVE_LOCKED_VOLUME			  NT_STATUS(0xC0210000)
#define NT_STATUS_FVE_NOT_ENCRYPTED			  NT_STATUS(0xC0210001)
#define NT_STATUS_FVE_BAD_INFORMATION			  NT_STATUS(0xC0210002)
#define NT_STATUS_FVE_TOO_SMALL				  NT_STATUS(0xC0210003)
#define NT_STATUS_FVE_FAILED_WRONG_FS			  NT_STATUS(0xC0210004)
#define NT_STATUS_FVE_FAILED_BAD_FS			  NT_STATUS(0xC0210005)
#define NT_STATUS_FVE_FS_NOT_EXTENDED			  NT_STATUS(0xC0210006)
#define NT_STATUS_FVE_FS_MOUNTED			  NT_STATUS(0xC0210007)
#define NT_STATUS_FVE_NO_LICENSE			  NT_STATUS(0xC0210008)
#define NT_STATUS_FVE_ACTION_NOT_ALLOWED		  NT_STATUS(0xC0210009)
#define NT_STATUS_FVE_BAD_DATA				  NT_STATUS(0xC021000A)
#define NT_STATUS_FVE_VOLUME_NOT_BOUND			  NT_STATUS(0xC021000B)
#define NT_STATUS_FVE_NOT_DATA_VOLUME			  NT_STATUS(0xC021000C)
#define NT_STATUS_FVE_CONV_READ_ERROR			  NT_STATUS(0xC021000D)
#define NT_STATUS_FVE_CONV_WRITE_ERROR			  NT_STATUS(0xC021000E)
#define NT_STATUS_FVE_OVERLAPPED_UPDATE			  NT_STATUS(0xC021000F)
#define NT_STATUS_FVE_FAILED_SECTOR_SIZE		  NT_STATUS(0xC0210010)
#define NT_STATUS_FVE_FAILED_AUTHENTICATION		  NT_STATUS(0xC0210011)
#define NT_STATUS_FVE_NOT_OS_VOLUME			  NT_STATUS(0xC0210012)
#define NT_STATUS_FVE_KEYFILE_NOT_FOUND			  NT_STATUS(0xC0210013)
#define NT_STATUS_FVE_KEYFILE_INVALID			  NT_STATUS(0xC0210014)
#define NT_STATUS_FVE_KEYFILE_NO_VMK			  NT_STATUS(0xC0210015)
#define NT_STATUS_FVE_TPM_DISABLED			  NT_STATUS(0xC0210016)
#define NT_STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO		  NT_STATUS(0xC0210017)
#define NT_STATUS_FVE_TPM_INVALID_PCR			  NT_STATUS(0xC0210018)
#define NT_STATUS_FVE_TPM_NO_VMK			  NT_STATUS(0xC0210019)
#define NT_STATUS_FVE_PIN_INVALID			  NT_STATUS(0xC021001A)
#define NT_STATUS_FVE_AUTH_INVALID_APPLICATION		  NT_STATUS(0xC021001B)
#define NT_STATUS_FVE_AUTH_INVALID_CONFIG		  NT_STATUS(0xC021001C)
#define NT_STATUS_FVE_DEBUGGER_ENABLED			  NT_STATUS(0xC021001D)
#define NT_STATUS_FVE_DRY_RUN_FAILED			  NT_STATUS(0xC021001E)
#define NT_STATUS_FVE_BAD_METADATA_POINTER		  NT_STATUS(0xC021001F)
#define NT_STATUS_FVE_OLD_METADATA_COPY			  NT_STATUS(0xC0210020)
#define NT_STATUS_FVE_REBOOT_REQUIRED			  NT_STATUS(0xC0210021)
#define NT_STATUS_FVE_RAW_ACCESS			  NT_STATUS(0xC0210022)
#define NT_STATUS_FVE_RAW_BLOCKED			  NT_STATUS(0xC0210023)
#define NT_STATUS_FVE_NO_FEATURE_LICENSE		  NT_STATUS(0xC0210026)
#define NT_STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED NT_STATUS(0xC0210027)
#define NT_STATUS_FVE_CONV_RECOVERY_FAILED		  NT_STATUS(0xC0210028)
#define NT_STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG		  NT_STATUS(0xC0210029)
#define NT_STATUS_FVE_VOLUME_TOO_SMALL			  NT_STATUS(0xC0210030)
#define NT_STATUS_FWP_CALLOUT_NOT_FOUND			  NT_STATUS(0xC0220001)
#define NT_STATUS_FWP_CONDITION_NOT_FOUND		  NT_STATUS(0xC0220002)
#define NT_STATUS_FWP_FILTER_NOT_FOUND			  NT_STATUS(0xC0220003)
#define NT_STATUS_FWP_LAYER_NOT_FOUND			  NT_STATUS(0xC0220004)
#define NT_STATUS_FWP_PROVIDER_NOT_FOUND		  NT_STATUS(0xC0220005)
#define NT_STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND	  NT_STATUS(0xC0220006)
#define NT_STATUS_FWP_SUBLAYER_NOT_FOUND		  NT_STATUS(0xC0220007)
#define NT_STATUS_FWP_NOT_FOUND				  NT_STATUS(0xC0220008)
#define NT_STATUS_FWP_ALREADY_EXISTS			  NT_STATUS(0xC0220009)
#define NT_STATUS_FWP_IN_USE				  NT_STATUS(0xC022000A)
#define NT_STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS	  NT_STATUS(0xC022000B)
#define NT_STATUS_FWP_WRONG_SESSION			  NT_STATUS(0xC022000C)
#define NT_STATUS_FWP_NO_TXN_IN_PROGRESS		  NT_STATUS(0xC022000D)
#define NT_STATUS_FWP_TXN_IN_PROGRESS			  NT_STATUS(0xC022000E)
#define NT_STATUS_FWP_TXN_ABORTED			  NT_STATUS(0xC022000F)
#define NT_STATUS_FWP_SESSION_ABORTED			  NT_STATUS(0xC0220010)
#define NT_STATUS_FWP_INCOMPATIBLE_TXN			  NT_STATUS(0xC0220011)
#define NT_STATUS_FWP_TIMEOUT				  NT_STATUS(0xC0220012)
#define NT_STATUS_FWP_NET_EVENTS_DISABLED		  NT_STATUS(0xC0220013)
#define NT_STATUS_FWP_INCOMPATIBLE_LAYER		  NT_STATUS(0xC0220014)
#define NT_STATUS_FWP_KM_CLIENTS_ONLY			  NT_STATUS(0xC0220015)
#define NT_STATUS_FWP_LIFETIME_MISMATCH			  NT_STATUS(0xC0220016)
#define NT_STATUS_FWP_BUILTIN_OBJECT			  NT_STATUS(0xC0220017)
#define NT_STATUS_FWP_TOO_MANY_BOOTTIME_FILTERS		  NT_STATUS(0xC0220018)
#define NT_STATUS_FWP_TOO_MANY_CALLOUTS			  NT_STATUS(0xC0220018)
#define NT_STATUS_FWP_NOTIFICATION_DROPPED		  NT_STATUS(0xC0220019)
#define NT_STATUS_FWP_TRAFFIC_MISMATCH			  NT_STATUS(0xC022001A)
#define NT_STATUS_FWP_INCOMPATIBLE_SA_STATE		  NT_STATUS(0xC022001B)
#define NT_STATUS_FWP_NULL_POINTER			  NT_STATUS(0xC022001C)
#define NT_STATUS_FWP_INVALID_ENUMERATOR		  NT_STATUS(0xC022001D)
#define NT_STATUS_FWP_INVALID_FLAGS			  NT_STATUS(0xC022001E)
#define NT_STATUS_FWP_INVALID_NET_MASK			  NT_STATUS(0xC022001F)
#define NT_STATUS_FWP_INVALID_RANGE			  NT_STATUS(0xC0220020)
#define NT_STATUS_FWP_INVALID_INTERVAL			  NT_STATUS(0xC0220021)
#define NT_STATUS_FWP_ZERO_LENGTH_ARRAY			  NT_STATUS(0xC0220022)
#define NT_STATUS_FWP_NULL_DISPLAY_NAME			  NT_STATUS(0xC0220023)
#define NT_STATUS_FWP_INVALID_ACTION_TYPE		  NT_STATUS(0xC0220024)
#define NT_STATUS_FWP_INVALID_WEIGHT			  NT_STATUS(0xC0220025)
#define NT_STATUS_FWP_MATCH_TYPE_MISMATCH		  NT_STATUS(0xC0220026)
#define NT_STATUS_FWP_TYPE_MISMATCH			  NT_STATUS(0xC0220027)
#define NT_STATUS_FWP_OUT_OF_BOUNDS			  NT_STATUS(0xC0220028)
#define NT_STATUS_FWP_RESERVED				  NT_STATUS(0xC0220029)
#define NT_STATUS_FWP_DUPLICATE_CONDITION		  NT_STATUS(0xC022002A)
#define NT_STATUS_FWP_DUPLICATE_KEYMOD			  NT_STATUS(0xC022002B)
#define NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER	  NT_STATUS(0xC022002C)
#define NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER   NT_STATUS(0xC022002D)
#define NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER	  NT_STATUS(0xC022002E)
#define NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT   NT_STATUS(0xC022002F)
#define NT_STATUS_FWP_INCOMPATIBLE_AUTH_METHOD		  NT_STATUS(0xC0220030)
#define NT_STATUS_FWP_INCOMPATIBLE_DH_GROUP		  NT_STATUS(0xC0220031)
#define NT_STATUS_FWP_EM_NOT_SUPPORTED			  NT_STATUS(0xC0220032)
#define NT_STATUS_FWP_NEVER_MATCH			  NT_STATUS(0xC0220033)
#define NT_STATUS_FWP_PROVIDER_CONTEXT_MISMATCH		  NT_STATUS(0xC0220034)
#define NT_STATUS_FWP_INVALID_PARAMETER			  NT_STATUS(0xC0220035)
#define NT_STATUS_FWP_TOO_MANY_SUBLAYERS		  NT_STATUS(0xC0220036)
#define NT_STATUS_FWP_CALLOUT_NOTIFICATION_FAILED	  NT_STATUS(0xC0220037)
#define NT_STATUS_FWP_INCOMPATIBLE_AUTH_CONFIG		  NT_STATUS(0xC0220038)
#define NT_STATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG	  NT_STATUS(0xC0220039)
#define NT_STATUS_FWP_DUPLICATE_AUTH_METHOD		  NT_STATUS(0xC022003C)
#define NT_STATUS_FWP_TCPIP_NOT_READY			  NT_STATUS(0xC0220100)
#define NT_STATUS_FWP_INJECT_HANDLE_CLOSING		  NT_STATUS(0xC0220101)
#define NT_STATUS_FWP_INJECT_HANDLE_STALE		  NT_STATUS(0xC0220102)
#define NT_STATUS_FWP_CANNOT_PEND			  NT_STATUS(0xC0220103)
#define NT_STATUS_NDIS_CLOSING				  NT_STATUS(0xC0230002)
#define NT_STATUS_NDIS_BAD_VERSION			  NT_STATUS(0xC0230004)
#define NT_STATUS_NDIS_BAD_CHARACTERISTICS		  NT_STATUS(0xC0230005)
#define NT_STATUS_NDIS_ADAPTER_NOT_FOUND		  NT_STATUS(0xC0230006)
#define NT_STATUS_NDIS_OPEN_FAILED			  NT_STATUS(0xC0230007)
#define NT_STATUS_NDIS_DEVICE_FAILED			  NT_STATUS(0xC0230008)
#define NT_STATUS_NDIS_MULTICAST_FULL			  NT_STATUS(0xC0230009)
#define NT_STATUS_NDIS_MULTICAST_EXISTS			  NT_STATUS(0xC023000A)
#define NT_STATUS_NDIS_MULTICAST_NOT_FOUND		  NT_STATUS(0xC023000B)
#define NT_STATUS_NDIS_REQUEST_ABORTED			  NT_STATUS(0xC023000C)
#define NT_STATUS_NDIS_RESET_IN_PROGRESS		  NT_STATUS(0xC023000D)
#define NT_STATUS_NDIS_INVALID_PACKET			  NT_STATUS(0xC023000F)
#define NT_STATUS_NDIS_INVALID_DEVICE_REQUEST		  NT_STATUS(0xC0230010)
#define NT_STATUS_NDIS_ADAPTER_NOT_READY		  NT_STATUS(0xC0230011)
#define NT_STATUS_NDIS_INVALID_LENGTH			  NT_STATUS(0xC0230014)
#define NT_STATUS_NDIS_INVALID_DATA			  NT_STATUS(0xC0230015)
#define NT_STATUS_NDIS_BUFFER_TOO_SHORT			  NT_STATUS(0xC0230016)
#define NT_STATUS_NDIS_INVALID_OID			  NT_STATUS(0xC0230017)
#define NT_STATUS_NDIS_ADAPTER_REMOVED			  NT_STATUS(0xC0230018)
#define NT_STATUS_NDIS_UNSUPPORTED_MEDIA		  NT_STATUS(0xC0230019)
#define NT_STATUS_NDIS_GROUP_ADDRESS_IN_USE		  NT_STATUS(0xC023001A)
#define NT_STATUS_NDIS_FILE_NOT_FOUND			  NT_STATUS(0xC023001B)
#define NT_STATUS_NDIS_ERROR_READING_FILE		  NT_STATUS(0xC023001C)
#define NT_STATUS_NDIS_ALREADY_MAPPED			  NT_STATUS(0xC023001D)
#define NT_STATUS_NDIS_RESOURCE_CONFLICT		  NT_STATUS(0xC023001E)
#define NT_STATUS_NDIS_MEDIA_DISCONNECTED		  NT_STATUS(0xC023001F)
#define NT_STATUS_NDIS_INVALID_ADDRESS			  NT_STATUS(0xC0230022)
#define NT_STATUS_NDIS_PAUSED				  NT_STATUS(0xC023002A)
#define NT_STATUS_NDIS_INTERFACE_NOT_FOUND		  NT_STATUS(0xC023002B)
#define NT_STATUS_NDIS_UNSUPPORTED_REVISION		  NT_STATUS(0xC023002C)
#define NT_STATUS_NDIS_INVALID_PORT			  NT_STATUS(0xC023002D)
#define NT_STATUS_NDIS_INVALID_PORT_STATE		  NT_STATUS(0xC023002E)
#define NT_STATUS_NDIS_LOW_POWER_STATE			  NT_STATUS(0xC023002F)
#define NT_STATUS_NDIS_NOT_SUPPORTED			  NT_STATUS(0xC02300BB)
#define NT_STATUS_NDIS_OFFLOAD_POLICY			  NT_STATUS(0xC023100F)
#define NT_STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED	  NT_STATUS(0xC0231012)
#define NT_STATUS_NDIS_OFFLOAD_PATH_REJECTED		  NT_STATUS(0xC0231013)
#define NT_STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED	  NT_STATUS(0xC0232000)
#define NT_STATUS_NDIS_DOT11_MEDIA_IN_USE		  NT_STATUS(0xC0232001)
#define NT_STATUS_NDIS_DOT11_POWER_STATE_INVALID	  NT_STATUS(0xC0232002)
#define NT_STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL		  NT_STATUS(0xC0232003)
#define NT_STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL	  NT_STATUS(0xC0232004)
#define NT_STATUS_IPSEC_BAD_SPI				  NT_STATUS(0xC0360001)
#define NT_STATUS_IPSEC_SA_LIFETIME_EXPIRED		  NT_STATUS(0xC0360002)
#define NT_STATUS_IPSEC_WRONG_SA			  NT_STATUS(0xC0360003)
#define NT_STATUS_IPSEC_REPLAY_CHECK_FAILED		  NT_STATUS(0xC0360004)
#define NT_STATUS_IPSEC_INVALID_PACKET			  NT_STATUS(0xC0360005)
#define NT_STATUS_IPSEC_INTEGRITY_CHECK_FAILED		  NT_STATUS(0xC0360006)
#define NT_STATUS_IPSEC_CLEAR_TEXT_DROP			  NT_STATUS(0xC0360007)
#define NT_STATUS_IPSEC_AUTH_FIREWALL_DROP		  NT_STATUS(0xC0360008)
#define NT_STATUS_IPSEC_THROTTLE_DROP			  NT_STATUS(0xC0360009)
#define NT_STATUS_IPSEC_DOSP_BLOCK			  NT_STATUS(0xC0368000)
#define NT_STATUS_IPSEC_DOSP_RECEIVED_MULTICAST		  NT_STATUS(0xC0368001)
#define NT_STATUS_IPSEC_DOSP_INVALID_PACKET		  NT_STATUS(0xC0368002)
#define NT_STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED	  NT_STATUS(0xC0368003)
#define NT_STATUS_IPSEC_DOSP_MAX_ENTRIES		  NT_STATUS(0xC0368004)
#define NT_STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED		  NT_STATUS(0xC0368005)
#define NT_STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES  NT_STATUS(0xC0368006)
#define NT_STATUS_VOLMGR_MIRROR_NOT_SUPPORTED		  NT_STATUS(0xC038005B)
#define NT_STATUS_VOLMGR_RAID5_NOT_SUPPORTED		  NT_STATUS(0xC038005C)
#define NT_STATUS_VIRTDISK_PROVIDER_NOT_FOUND		  NT_STATUS(0xC03A0014)
#define NT_STATUS_VIRTDISK_NOT_VIRTUAL_DISK		  NT_STATUS(0xC03A0015)
#define NT_STATUS_VHD_PARENT_VHD_ACCESS_DENIED		  NT_STATUS(0xC03A0016)
#define NT_STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH	  NT_STATUS(0xC03A0017)
#define NT_STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED   NT_STATUS(0xC03A0018)
#define NT_STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT  NT_STATUS(0xC03A0019)

/* I use NT_STATUS_FOOBAR when I have no idea what error code to use -
 * this means we need a torture test */
#define NT_STATUS_FOOBAR NT_STATUS_UNSUCCESSFUL

/*****************************************************************************
 Returns an NT error message.  not amazingly helpful, but better than a number.

 This version is const, and so neither allocates memory nor uses a
 static variable for unknown errors.
 *****************************************************************************/

const char *nt_errstr_const(NTSTATUS nt_code);

/*****************************************************************************
 returns an NT error message.  not amazingly helpful, but better than a number.
 *****************************************************************************/
const char *nt_errstr(NTSTATUS nt_code);

/************************************************************************
 Print friendler version fo NT error code
 ***********************************************************************/
const char *get_friendly_nt_error_msg(NTSTATUS nt_code);

/*****************************************************************************
 returns an NT_STATUS constant as a string for inclusion in autogen C code
 *****************************************************************************/
const char *get_nt_error_c_code(void *mem_ctx, NTSTATUS nt_code);

/*****************************************************************************
 returns the NT_STATUS constant matching the string supplied (as an NTSTATUS)
 *****************************************************************************/
NTSTATUS nt_status_string_to_code(const char *nt_status_str);

/* we need these here for openchange */
#ifndef likely
#define likely(x) (x)
#endif
#ifndef unlikely
#define unlikely(x) (x)
#endif

#define NT_STATUS_IS_OK(x) (likely(NT_STATUS_V(x) == 0))
#define NT_STATUS_IS_ERR(x) (unlikely((NT_STATUS_V(x) & 0xc0000000) == 0xc0000000))
#define NT_STATUS_EQUAL(x,y) (NT_STATUS_V(x) == NT_STATUS_V(y))

/*
 * These macros (with the embedded return) are considered poor coding
 * style per README.Coding
 *
 * Please do not use them in new code, and do not rely on them in
 * projects external to Samba as they will go away at some point.
 */

#define NT_STATUS_HAVE_NO_MEMORY(x) do { \
	if (unlikely(!(x))) {		\
		return NT_STATUS_NO_MEMORY;\
	}\
} while (0)

/* This varient is for when you want to free a local
   temporary memory context in the error path */
#define NT_STATUS_HAVE_NO_MEMORY_AND_FREE(x, ctx) do {	\
	if (!(x)) {\
		talloc_free(ctx); \
		return NT_STATUS_NO_MEMORY;\
	}\
} while (0)

#define NT_STATUS_IS_OK_RETURN(x) do { \
	if (NT_STATUS_IS_OK(x)) {\
		return x;\
	}\
} while (0)

#define NT_STATUS_NOT_OK_RETURN(x) do { \
	if (!NT_STATUS_IS_OK(x)) {\
		return x;\
	}\
} while (0)

#define NT_STATUS_NOT_OK_RETURN_AND_FREE(x, ctx) do {	\
	if (!NT_STATUS_IS_OK(x)) {\
		talloc_free(ctx); \
		return x;\
	}\
} while (0)

#define NT_STATUS_IS_ERR_RETURN(x) do { \
	if (NT_STATUS_IS_ERR(x)) {\
		return x;\
	}\
} while (0)

#define NT_STATUS_NOT_ERR_RETURN(x) do { \
	if (!NT_STATUS_IS_ERR(x)) {\
		return x;\
	}\
} while (0)

/* this defines special NTSTATUS codes to represent DOS errors.  I
   have chosen this macro to produce status codes in the invalid
   NTSTATUS range */
#define NT_STATUS_DOS(class, code) NT_STATUS(0xF1000000 | ((class)<<16) | code)
#define NT_STATUS_IS_DOS(status) ((NT_STATUS_V(status) & 0xFF000000) == 0xF1000000)
#define NT_STATUS_DOS_CLASS(status) ((NT_STATUS_V(status) >> 16) & 0xFF)
#define NT_STATUS_DOS_CODE(status) (NT_STATUS_V(status) & 0xFFFF)

/* define ldap error codes as NTSTATUS codes */
#define NT_STATUS_LDAP(code) NT_STATUS(0xF2000000 | code)
#define NT_STATUS_IS_LDAP(status) ((NT_STATUS_V(status) & 0xFF000000) == 0xF2000000)
#define NT_STATUS_LDAP_CODE(status) (NT_STATUS_V(status) & ~0xFF000000)

#define NT_STATUS_IS_RPC(status) \
	(((NT_STATUS_V(status) & 0xFFFF) == 0xC0020000) || \
	 ((NT_STATUS_V(status) & 0xFFFF) == 0xC0030000))

#endif /* _NTSTATUS_H */
