/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_fsrvp.h"
#include "autoconf/librpc/gen_ndr/ndr_fsrvp_c.h"

/* FileServerVssAgent - client functions generated by pidl */

struct dcerpc_fss_GetSupportedVersion_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_GetSupportedVersion_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_GetSupportedVersion_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_GetSupportedVersion *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_GetSupportedVersion_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_GetSupportedVersion_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_GETSUPPORTEDVERSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_GetSupportedVersion_r_done, req);

	return req;
}

static void dcerpc_fss_GetSupportedVersion_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_GetSupportedVersion_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_GetSupportedVersion_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_GetSupportedVersion_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_GetSupportedVersion_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_GetSupportedVersion *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_GETSUPPORTEDVERSION, mem_ctx, r);

	return status;
}

struct dcerpc_fss_GetSupportedVersion_state {
	struct fss_GetSupportedVersion orig;
	struct fss_GetSupportedVersion tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_GetSupportedVersion_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_GetSupportedVersion_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       uint8_t _magic[52] /* [in]  */,
						       uint32_t *_MinVersion /* [out] [ref] */,
						       uint32_t *_MaxVersion /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_GetSupportedVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_GetSupportedVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	memcpy(state->orig.in.magic, _magic, sizeof(state->orig.in.magic));

	/* Out parameters */
	state->orig.out.MinVersion = _MinVersion;
	state->orig.out.MaxVersion = _MaxVersion;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_GetSupportedVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_GetSupportedVersion_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_GetSupportedVersion_done, req);
	return req;
}

static void dcerpc_fss_GetSupportedVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_GetSupportedVersion_state *state = tevent_req_data(
		req, struct dcerpc_fss_GetSupportedVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_GetSupportedVersion_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.MinVersion = *state->tmp.out.MinVersion;
	*state->orig.out.MaxVersion = *state->tmp.out.MaxVersion;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_GetSupportedVersion_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *result)
{
	struct dcerpc_fss_GetSupportedVersion_state *state = tevent_req_data(
		req, struct dcerpc_fss_GetSupportedVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_GetSupportedVersion(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					uint8_t _magic[52] /* [in]  */,
					uint32_t *_MinVersion /* [out] [ref] */,
					uint32_t *_MaxVersion /* [out] [ref] */,
					uint32_t *result)
{
	struct fss_GetSupportedVersion r;
	NTSTATUS status;

	/* In parameters */
	memcpy(r.in.magic, _magic, sizeof(r.in.magic));

	/* Out parameters */
	r.out.MinVersion = _MinVersion;
	r.out.MaxVersion = _MaxVersion;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_GetSupportedVersion_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_MinVersion = *r.out.MinVersion;
	*_MaxVersion = *r.out.MaxVersion;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_SetContext_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_SetContext_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_SetContext_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_SetContext *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_SetContext_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_SetContext_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_SETCONTEXT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_SetContext_r_done, req);

	return req;
}

static void dcerpc_fss_SetContext_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_SetContext_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_SetContext_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_SetContext_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_SetContext_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_SetContext *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_SETCONTEXT, mem_ctx, r);

	return status;
}

struct dcerpc_fss_SetContext_state {
	struct fss_SetContext orig;
	struct fss_SetContext tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_SetContext_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_SetContext_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint32_t _Context /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_SetContext_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_SetContext_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Context = _Context;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_SetContext_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_SetContext_done, req);
	return req;
}

static void dcerpc_fss_SetContext_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_SetContext_state *state = tevent_req_data(
		req, struct dcerpc_fss_SetContext_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_SetContext_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_SetContext_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    uint32_t *result)
{
	struct dcerpc_fss_SetContext_state *state = tevent_req_data(
		req, struct dcerpc_fss_SetContext_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_SetContext(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint32_t _Context /* [in]  */,
			       uint32_t *result)
{
	struct fss_SetContext r;
	NTSTATUS status;

	/* In parameters */
	r.in.Context = _Context;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_SetContext_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_StartShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_StartShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_StartShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_StartShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_StartShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_StartShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_STARTSHADOWCOPYSET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_StartShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_StartShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_StartShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_StartShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_StartShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_StartShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_StartShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_STARTSHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_StartShadowCopySet_state {
	struct fss_StartShadowCopySet orig;
	struct fss_StartShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_StartShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_StartShadowCopySet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct GUID _ClientShadowCopySetId /* [in]  */,
						      struct GUID *_pShadowCopySetId /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_StartShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_StartShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ClientShadowCopySetId = _ClientShadowCopySetId;

	/* Out parameters */
	state->orig.out.pShadowCopySetId = _pShadowCopySetId;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_StartShadowCopySet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_StartShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_StartShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_StartShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_StartShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_StartShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_StartShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pShadowCopySetId = *state->tmp.out.pShadowCopySetId;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_StartShadowCopySet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint32_t *result)
{
	struct dcerpc_fss_StartShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_StartShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_StartShadowCopySet(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct GUID _ClientShadowCopySetId /* [in]  */,
				       struct GUID *_pShadowCopySetId /* [out] [ref] */,
				       uint32_t *result)
{
	struct fss_StartShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ClientShadowCopySetId = _ClientShadowCopySetId;

	/* Out parameters */
	r.out.pShadowCopySetId = _pShadowCopySetId;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_StartShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pShadowCopySetId = *r.out.pShadowCopySetId;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_AddToShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_AddToShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_AddToShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_AddToShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_AddToShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_AddToShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ADDTOSHADOWCOPYSET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_AddToShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_AddToShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_AddToShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_AddToShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_AddToShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_AddToShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_AddToShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ADDTOSHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_AddToShadowCopySet_state {
	struct fss_AddToShadowCopySet orig;
	struct fss_AddToShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_AddToShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_AddToShadowCopySet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct GUID _ClientShadowCopyId /* [in]  */,
						      struct GUID _ShadowCopySetId /* [in]  */,
						      const char *_ShareName /* [in] [charset(UTF16),ref] */,
						      struct GUID *_pShadowCopyId /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_AddToShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_AddToShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ClientShadowCopyId = _ClientShadowCopyId;
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.ShareName = _ShareName;

	/* Out parameters */
	state->orig.out.pShadowCopyId = _pShadowCopyId;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_AddToShadowCopySet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_AddToShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_AddToShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_AddToShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_AddToShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_AddToShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_AddToShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pShadowCopyId = *state->tmp.out.pShadowCopyId;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_AddToShadowCopySet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint32_t *result)
{
	struct dcerpc_fss_AddToShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_AddToShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_AddToShadowCopySet(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct GUID _ClientShadowCopyId /* [in]  */,
				       struct GUID _ShadowCopySetId /* [in]  */,
				       const char *_ShareName /* [in] [charset(UTF16),ref] */,
				       struct GUID *_pShadowCopyId /* [out] [ref] */,
				       uint32_t *result)
{
	struct fss_AddToShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ClientShadowCopyId = _ClientShadowCopyId;
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.ShareName = _ShareName;

	/* Out parameters */
	r.out.pShadowCopyId = _pShadowCopyId;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_AddToShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pShadowCopyId = *r.out.pShadowCopyId;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_CommitShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_CommitShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_CommitShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_CommitShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_CommitShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_CommitShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_COMMITSHADOWCOPYSET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_CommitShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_CommitShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_CommitShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_CommitShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_CommitShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_CommitShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_CommitShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_COMMITSHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_CommitShadowCopySet_state {
	struct fss_CommitShadowCopySet orig;
	struct fss_CommitShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_CommitShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_CommitShadowCopySet_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct GUID _ShadowCopySetId /* [in]  */,
						       uint32_t _TimeOutInMilliseconds /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_CommitShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_CommitShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_CommitShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_CommitShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_CommitShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_CommitShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_CommitShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_CommitShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_CommitShadowCopySet_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *result)
{
	struct dcerpc_fss_CommitShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_CommitShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_CommitShadowCopySet(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct GUID _ShadowCopySetId /* [in]  */,
					uint32_t _TimeOutInMilliseconds /* [in]  */,
					uint32_t *result)
{
	struct fss_CommitShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_CommitShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_ExposeShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_ExposeShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_ExposeShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_ExposeShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_ExposeShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_ExposeShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_EXPOSESHADOWCOPYSET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_ExposeShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_ExposeShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_ExposeShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_ExposeShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_ExposeShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_ExposeShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_ExposeShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_EXPOSESHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_ExposeShadowCopySet_state {
	struct fss_ExposeShadowCopySet orig;
	struct fss_ExposeShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_ExposeShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_ExposeShadowCopySet_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct GUID _ShadowCopySetId /* [in]  */,
						       uint32_t _TimeOutInMilliseconds /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_ExposeShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_ExposeShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_ExposeShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_ExposeShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_ExposeShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_ExposeShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_ExposeShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_ExposeShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_ExposeShadowCopySet_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *result)
{
	struct dcerpc_fss_ExposeShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_ExposeShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_ExposeShadowCopySet(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct GUID _ShadowCopySetId /* [in]  */,
					uint32_t _TimeOutInMilliseconds /* [in]  */,
					uint32_t *result)
{
	struct fss_ExposeShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_ExposeShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_RecoveryCompleteShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_RecoveryCompleteShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_RecoveryCompleteShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_RecoveryCompleteShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_RecoveryCompleteShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_RecoveryCompleteShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_RECOVERYCOMPLETESHADOWCOPYSET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_RecoveryCompleteShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_RecoveryCompleteShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_RecoveryCompleteShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_RecoveryCompleteShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_RecoveryCompleteShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_RecoveryCompleteShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_RecoveryCompleteShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_RECOVERYCOMPLETESHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_RecoveryCompleteShadowCopySet_state {
	struct fss_RecoveryCompleteShadowCopySet orig;
	struct fss_RecoveryCompleteShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_RecoveryCompleteShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_RecoveryCompleteShadowCopySet_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct GUID _ShadowCopySetId /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_RecoveryCompleteShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_RecoveryCompleteShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_RecoveryCompleteShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_RecoveryCompleteShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_RecoveryCompleteShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_RecoveryCompleteShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_RecoveryCompleteShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_RecoveryCompleteShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_RecoveryCompleteShadowCopySet_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       uint32_t *result)
{
	struct dcerpc_fss_RecoveryCompleteShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_RecoveryCompleteShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_RecoveryCompleteShadowCopySet(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct GUID _ShadowCopySetId /* [in]  */,
						  uint32_t *result)
{
	struct fss_RecoveryCompleteShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_RecoveryCompleteShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_AbortShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_AbortShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_AbortShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_AbortShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_AbortShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_AbortShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ABORTSHADOWCOPYSET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_AbortShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_AbortShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_AbortShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_AbortShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_AbortShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_AbortShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_AbortShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ABORTSHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_AbortShadowCopySet_state {
	struct fss_AbortShadowCopySet orig;
	struct fss_AbortShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_AbortShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_AbortShadowCopySet_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct GUID _ShadowCopySetId /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_AbortShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_AbortShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_AbortShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_AbortShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_AbortShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_AbortShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_AbortShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_AbortShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_AbortShadowCopySet_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint32_t *result)
{
	struct dcerpc_fss_AbortShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_AbortShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_AbortShadowCopySet(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct GUID _ShadowCopySetId /* [in]  */,
				       uint32_t *result)
{
	struct fss_AbortShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_AbortShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_IsPathSupported_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_IsPathSupported_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_IsPathSupported_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_IsPathSupported *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_IsPathSupported_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_IsPathSupported_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ISPATHSUPPORTED, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_IsPathSupported_r_done, req);

	return req;
}

static void dcerpc_fss_IsPathSupported_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_IsPathSupported_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_IsPathSupported_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_IsPathSupported_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_IsPathSupported_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_IsPathSupported *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ISPATHSUPPORTED, mem_ctx, r);

	return status;
}

struct dcerpc_fss_IsPathSupported_state {
	struct fss_IsPathSupported orig;
	struct fss_IsPathSupported tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_IsPathSupported_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_IsPathSupported_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_ShareName /* [in] [ref,charset(UTF16)] */,
						   uint8_t _magic[52] /* [in]  */,
						   uint32_t *_SupportedByThisProvider /* [out] [ref] */,
						   const char **_OwnerMachineName /* [out] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_IsPathSupported_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_IsPathSupported_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShareName = _ShareName;
	memcpy(state->orig.in.magic, _magic, sizeof(state->orig.in.magic));

	/* Out parameters */
	state->orig.out.SupportedByThisProvider = _SupportedByThisProvider;
	state->orig.out.OwnerMachineName = _OwnerMachineName;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_IsPathSupported_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_IsPathSupported_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_IsPathSupported_done, req);
	return req;
}

static void dcerpc_fss_IsPathSupported_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_IsPathSupported_state *state = tevent_req_data(
		req, struct dcerpc_fss_IsPathSupported_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_IsPathSupported_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.SupportedByThisProvider = *state->tmp.out.SupportedByThisProvider;
	*state->orig.out.OwnerMachineName = *state->tmp.out.OwnerMachineName;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_IsPathSupported_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 uint32_t *result)
{
	struct dcerpc_fss_IsPathSupported_state *state = tevent_req_data(
		req, struct dcerpc_fss_IsPathSupported_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_IsPathSupported(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_ShareName /* [in] [ref,charset(UTF16)] */,
				    uint8_t _magic[52] /* [in]  */,
				    uint32_t *_SupportedByThisProvider /* [out] [ref] */,
				    const char **_OwnerMachineName /* [out] [ref,charset(UTF16)] */,
				    uint32_t *result)
{
	struct fss_IsPathSupported r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShareName = _ShareName;
	memcpy(r.in.magic, _magic, sizeof(r.in.magic));

	/* Out parameters */
	r.out.SupportedByThisProvider = _SupportedByThisProvider;
	r.out.OwnerMachineName = _OwnerMachineName;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_IsPathSupported_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_SupportedByThisProvider = *r.out.SupportedByThisProvider;
	*_OwnerMachineName = *r.out.OwnerMachineName;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_IsPathShadowCopied_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_IsPathShadowCopied_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_IsPathShadowCopied_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_IsPathShadowCopied *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_IsPathShadowCopied_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_IsPathShadowCopied_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ISPATHSHADOWCOPIED, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_IsPathShadowCopied_r_done, req);

	return req;
}

static void dcerpc_fss_IsPathShadowCopied_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_IsPathShadowCopied_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_IsPathShadowCopied_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_IsPathShadowCopied_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_IsPathShadowCopied_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_IsPathShadowCopied *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_ISPATHSHADOWCOPIED, mem_ctx, r);

	return status;
}

struct dcerpc_fss_IsPathShadowCopied_state {
	struct fss_IsPathShadowCopied orig;
	struct fss_IsPathShadowCopied tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_IsPathShadowCopied_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_IsPathShadowCopied_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_ShareName /* [in] [charset(UTF16),ref] */,
						      uint32_t *_ShadowCopyPresent /* [out] [ref] */,
						      int32_t *_ShadowCopyCompatibility /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_IsPathShadowCopied_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_IsPathShadowCopied_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShareName = _ShareName;

	/* Out parameters */
	state->orig.out.ShadowCopyPresent = _ShadowCopyPresent;
	state->orig.out.ShadowCopyCompatibility = _ShadowCopyCompatibility;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_IsPathShadowCopied_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_IsPathShadowCopied_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_IsPathShadowCopied_done, req);
	return req;
}

static void dcerpc_fss_IsPathShadowCopied_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_IsPathShadowCopied_state *state = tevent_req_data(
		req, struct dcerpc_fss_IsPathShadowCopied_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_IsPathShadowCopied_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ShadowCopyPresent = *state->tmp.out.ShadowCopyPresent;
	*state->orig.out.ShadowCopyCompatibility = *state->tmp.out.ShadowCopyCompatibility;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_IsPathShadowCopied_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint32_t *result)
{
	struct dcerpc_fss_IsPathShadowCopied_state *state = tevent_req_data(
		req, struct dcerpc_fss_IsPathShadowCopied_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_IsPathShadowCopied(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_ShareName /* [in] [charset(UTF16),ref] */,
				       uint32_t *_ShadowCopyPresent /* [out] [ref] */,
				       int32_t *_ShadowCopyCompatibility /* [out] [ref] */,
				       uint32_t *result)
{
	struct fss_IsPathShadowCopied r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShareName = _ShareName;

	/* Out parameters */
	r.out.ShadowCopyPresent = _ShadowCopyPresent;
	r.out.ShadowCopyCompatibility = _ShadowCopyCompatibility;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_IsPathShadowCopied_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ShadowCopyPresent = *r.out.ShadowCopyPresent;
	*_ShadowCopyCompatibility = *r.out.ShadowCopyCompatibility;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_GetShareMapping_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_GetShareMapping_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_GetShareMapping_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_GetShareMapping *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_GetShareMapping_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_GetShareMapping_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_GETSHAREMAPPING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_GetShareMapping_r_done, req);

	return req;
}

static void dcerpc_fss_GetShareMapping_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_GetShareMapping_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_GetShareMapping_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_GetShareMapping_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_GetShareMapping_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_GetShareMapping *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_GETSHAREMAPPING, mem_ctx, r);

	return status;
}

struct dcerpc_fss_GetShareMapping_state {
	struct fss_GetShareMapping orig;
	struct fss_GetShareMapping tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_GetShareMapping_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_GetShareMapping_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct GUID _ShadowCopyId /* [in]  */,
						   struct GUID _ShadowCopySetId /* [in]  */,
						   const char *_ShareName /* [in] [charset(UTF16),ref] */,
						   uint32_t _Level /* [in]  */,
						   union fssagent_share_mapping *_ShareMapping /* [out] [switch_is(Level),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_GetShareMapping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_GetShareMapping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopyId = _ShadowCopyId;
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.ShareName = _ShareName;
	state->orig.in.Level = _Level;

	/* Out parameters */
	state->orig.out.ShareMapping = _ShareMapping;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_fss_GetShareMapping_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_GetShareMapping_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_GetShareMapping_done, req);
	return req;
}

static void dcerpc_fss_GetShareMapping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_GetShareMapping_state *state = tevent_req_data(
		req, struct dcerpc_fss_GetShareMapping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_GetShareMapping_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ShareMapping = *state->tmp.out.ShareMapping;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_GetShareMapping_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 uint32_t *result)
{
	struct dcerpc_fss_GetShareMapping_state *state = tevent_req_data(
		req, struct dcerpc_fss_GetShareMapping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_GetShareMapping(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct GUID _ShadowCopyId /* [in]  */,
				    struct GUID _ShadowCopySetId /* [in]  */,
				    const char *_ShareName /* [in] [charset(UTF16),ref] */,
				    uint32_t _Level /* [in]  */,
				    union fssagent_share_mapping *_ShareMapping /* [out] [switch_is(Level),ref] */,
				    uint32_t *result)
{
	struct fss_GetShareMapping r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopyId = _ShadowCopyId;
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.ShareName = _ShareName;
	r.in.Level = _Level;

	/* Out parameters */
	r.out.ShareMapping = _ShareMapping;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_GetShareMapping_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ShareMapping = *r.out.ShareMapping;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_DeleteShareMapping_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_DeleteShareMapping_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_DeleteShareMapping_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_DeleteShareMapping *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_DeleteShareMapping_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_DeleteShareMapping_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_DELETESHAREMAPPING, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_DeleteShareMapping_r_done, req);

	return req;
}

static void dcerpc_fss_DeleteShareMapping_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_DeleteShareMapping_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_DeleteShareMapping_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_DeleteShareMapping_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_DeleteShareMapping_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_DeleteShareMapping *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_DELETESHAREMAPPING, mem_ctx, r);

	return status;
}

struct dcerpc_fss_DeleteShareMapping_state {
	struct fss_DeleteShareMapping orig;
	struct fss_DeleteShareMapping tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_DeleteShareMapping_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_DeleteShareMapping_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct GUID _ShadowCopySetId /* [in]  */,
						      struct GUID _ShadowCopyId /* [in]  */,
						      const char *_ShareName /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_fss_DeleteShareMapping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_DeleteShareMapping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.ShadowCopyId = _ShadowCopyId;
	state->orig.in.ShareName = _ShareName;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_DeleteShareMapping_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_DeleteShareMapping_done, req);
	return req;
}

static void dcerpc_fss_DeleteShareMapping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_DeleteShareMapping_state *state = tevent_req_data(
		req, struct dcerpc_fss_DeleteShareMapping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_DeleteShareMapping_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_DeleteShareMapping_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    uint32_t *result)
{
	struct dcerpc_fss_DeleteShareMapping_state *state = tevent_req_data(
		req, struct dcerpc_fss_DeleteShareMapping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_DeleteShareMapping(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct GUID _ShadowCopySetId /* [in]  */,
				       struct GUID _ShadowCopyId /* [in]  */,
				       const char *_ShareName /* [in] [charset(UTF16),ref] */,
				       uint32_t *result)
{
	struct fss_DeleteShareMapping r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.ShadowCopyId = _ShadowCopyId;
	r.in.ShareName = _ShareName;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_DeleteShareMapping_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_fss_PrepareShadowCopySet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_PrepareShadowCopySet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_PrepareShadowCopySet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct fss_PrepareShadowCopySet *r)
{
	struct tevent_req *req;
	struct dcerpc_fss_PrepareShadowCopySet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_PrepareShadowCopySet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_PREPARESHADOWCOPYSET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_PrepareShadowCopySet_r_done, req);

	return req;
}

static void dcerpc_fss_PrepareShadowCopySet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_PrepareShadowCopySet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_fss_PrepareShadowCopySet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_fss_PrepareShadowCopySet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_PrepareShadowCopySet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct fss_PrepareShadowCopySet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_FileServerVssAgent,
			NDR_FSS_PREPARESHADOWCOPYSET, mem_ctx, r);

	return status;
}

struct dcerpc_fss_PrepareShadowCopySet_state {
	struct fss_PrepareShadowCopySet orig;
	struct fss_PrepareShadowCopySet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_fss_PrepareShadowCopySet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_fss_PrepareShadowCopySet_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct GUID _ShadowCopySetId /* [in]  */,
							uint32_t _TimeOutInMilliseconds /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_fss_PrepareShadowCopySet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_fss_PrepareShadowCopySet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ShadowCopySetId = _ShadowCopySetId;
	state->orig.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_fss_PrepareShadowCopySet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_fss_PrepareShadowCopySet_done, req);
	return req;
}

static void dcerpc_fss_PrepareShadowCopySet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_fss_PrepareShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_PrepareShadowCopySet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_fss_PrepareShadowCopySet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_fss_PrepareShadowCopySet_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      uint32_t *result)
{
	struct dcerpc_fss_PrepareShadowCopySet_state *state = tevent_req_data(
		req, struct dcerpc_fss_PrepareShadowCopySet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_fss_PrepareShadowCopySet(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct GUID _ShadowCopySetId /* [in]  */,
					 uint32_t _TimeOutInMilliseconds /* [in]  */,
					 uint32_t *result)
{
	struct fss_PrepareShadowCopySet r;
	NTSTATUS status;

	/* In parameters */
	r.in.ShadowCopySetId = _ShadowCopySetId;
	r.in.TimeOutInMilliseconds = _TimeOutInMilliseconds;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_fss_PrepareShadowCopySet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

