/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_rot.h"
#include "autoconf/librpc/gen_ndr/ndr_rot_c.h"

/* rot - client functions generated by pidl */

struct dcerpc_rot_add_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_add_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_add_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_add *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_add_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_add_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_ADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_add_r_done, req);

	return req;
}

static void dcerpc_rot_add_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_add_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_add_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_add_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_add_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_add *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_ADD, mem_ctx, r);

	return status;
}

struct dcerpc_rot_add_state {
	struct rot_add orig;
	struct rot_add tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_add_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_add_send(TALLOC_CTX *mem_ctx,
				       struct tevent_context *ev,
				       struct dcerpc_binding_handle *h,
				       uint32_t _flags /* [in]  */,
				       struct MInterfacePointer *_unk /* [in] [ref] */,
				       struct MInterfacePointer *_moniker /* [in] [ref] */,
				       uint32_t *_rotid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_add_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_add_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.flags = _flags;
	state->orig.in.unk = _unk;
	state->orig.in.moniker = _moniker;

	/* Out parameters */
	state->orig.out.rotid = _rotid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_rot_add_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_add_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_add_done, req);
	return req;
}

static void dcerpc_rot_add_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_add_state *state = tevent_req_data(
		req, struct dcerpc_rot_add_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_add_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rotid = *state->tmp.out.rotid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_add_recv(struct tevent_req *req,
			     TALLOC_CTX *mem_ctx,
			     WERROR *result)
{
	struct dcerpc_rot_add_state *state = tevent_req_data(
		req, struct dcerpc_rot_add_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_add(struct dcerpc_binding_handle *h,
			TALLOC_CTX *mem_ctx,
			uint32_t _flags /* [in]  */,
			struct MInterfacePointer *_unk /* [in] [ref] */,
			struct MInterfacePointer *_moniker /* [in] [ref] */,
			uint32_t *_rotid /* [out] [ref] */,
			WERROR *result)
{
	struct rot_add r;
	NTSTATUS status;

	/* In parameters */
	r.in.flags = _flags;
	r.in.unk = _unk;
	r.in.moniker = _moniker;

	/* Out parameters */
	r.out.rotid = _rotid;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_add_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rotid = *r.out.rotid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_remove_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_remove_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_remove_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_remove *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_remove_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_remove_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_REMOVE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_remove_r_done, req);

	return req;
}

static void dcerpc_rot_remove_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_remove_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_remove_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_remove_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_remove_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_remove *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_REMOVE, mem_ctx, r);

	return status;
}

struct dcerpc_rot_remove_state {
	struct rot_remove orig;
	struct rot_remove tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_remove_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_remove_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  uint32_t _rotid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_rot_remove_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_remove_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.rotid = _rotid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_remove_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_remove_done, req);
	return req;
}

static void dcerpc_rot_remove_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_remove_state *state = tevent_req_data(
		req, struct dcerpc_rot_remove_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_remove_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_remove_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct dcerpc_rot_remove_state *state = tevent_req_data(
		req, struct dcerpc_rot_remove_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_remove(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   uint32_t _rotid /* [in]  */,
			   WERROR *result)
{
	struct rot_remove r;
	NTSTATUS status;

	/* In parameters */
	r.in.rotid = _rotid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_remove_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_is_listed_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_is_listed_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_is_listed_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_is_listed *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_is_listed_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_is_listed_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_IS_LISTED, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_is_listed_r_done, req);

	return req;
}

static void dcerpc_rot_is_listed_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_is_listed_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_is_listed_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_is_listed_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_is_listed_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_is_listed *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_IS_LISTED, mem_ctx, r);

	return status;
}

struct dcerpc_rot_is_listed_state {
	struct rot_is_listed orig;
	struct rot_is_listed tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_is_listed_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_is_listed_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct MInterfacePointer *_moniker /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_is_listed_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_is_listed_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.moniker = _moniker;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_is_listed_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_is_listed_done, req);
	return req;
}

static void dcerpc_rot_is_listed_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_is_listed_state *state = tevent_req_data(
		req, struct dcerpc_rot_is_listed_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_is_listed_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_is_listed_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct dcerpc_rot_is_listed_state *state = tevent_req_data(
		req, struct dcerpc_rot_is_listed_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_is_listed(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct MInterfacePointer *_moniker /* [in] [ref] */,
			      WERROR *result)
{
	struct rot_is_listed r;
	NTSTATUS status;

	/* In parameters */
	r.in.moniker = _moniker;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_is_listed_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_get_interface_pointer_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_get_interface_pointer_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_get_interface_pointer_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_get_interface_pointer *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_get_interface_pointer_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_get_interface_pointer_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_GET_INTERFACE_POINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_get_interface_pointer_r_done, req);

	return req;
}

static void dcerpc_rot_get_interface_pointer_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_get_interface_pointer_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_get_interface_pointer_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_get_interface_pointer_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_get_interface_pointer_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_get_interface_pointer *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_GET_INTERFACE_POINTER, mem_ctx, r);

	return status;
}

struct dcerpc_rot_get_interface_pointer_state {
	struct rot_get_interface_pointer orig;
	struct rot_get_interface_pointer tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_get_interface_pointer_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_get_interface_pointer_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct MInterfacePointer *_moniker /* [in] [ref] */,
							 struct MInterfacePointer *_ip /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_get_interface_pointer_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_get_interface_pointer_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.moniker = _moniker;

	/* Out parameters */
	state->orig.out.ip = _ip;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_rot_get_interface_pointer_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_get_interface_pointer_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_get_interface_pointer_done, req);
	return req;
}

static void dcerpc_rot_get_interface_pointer_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_get_interface_pointer_state *state = tevent_req_data(
		req, struct dcerpc_rot_get_interface_pointer_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_get_interface_pointer_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ip = *state->tmp.out.ip;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_get_interface_pointer_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_rot_get_interface_pointer_state *state = tevent_req_data(
		req, struct dcerpc_rot_get_interface_pointer_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_get_interface_pointer(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct MInterfacePointer *_moniker /* [in] [ref] */,
					  struct MInterfacePointer *_ip /* [out] [ref] */,
					  WERROR *result)
{
	struct rot_get_interface_pointer r;
	NTSTATUS status;

	/* In parameters */
	r.in.moniker = _moniker;

	/* Out parameters */
	r.out.ip = _ip;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_get_interface_pointer_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ip = *r.out.ip;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_set_modification_time_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_set_modification_time_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_set_modification_time_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_set_modification_time *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_set_modification_time_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_set_modification_time_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_SET_MODIFICATION_TIME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_set_modification_time_r_done, req);

	return req;
}

static void dcerpc_rot_set_modification_time_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_set_modification_time_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_set_modification_time_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_set_modification_time_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_set_modification_time_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_set_modification_time *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_SET_MODIFICATION_TIME, mem_ctx, r);

	return status;
}

struct dcerpc_rot_set_modification_time_state {
	struct rot_set_modification_time orig;
	struct rot_set_modification_time tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_set_modification_time_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_set_modification_time_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 uint32_t _rotid /* [in]  */,
							 NTTIME *_t /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_set_modification_time_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_set_modification_time_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.rotid = _rotid;
	state->orig.in.t = _t;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_set_modification_time_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_set_modification_time_done, req);
	return req;
}

static void dcerpc_rot_set_modification_time_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_set_modification_time_state *state = tevent_req_data(
		req, struct dcerpc_rot_set_modification_time_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_set_modification_time_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_set_modification_time_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_rot_set_modification_time_state *state = tevent_req_data(
		req, struct dcerpc_rot_set_modification_time_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_set_modification_time(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  uint32_t _rotid /* [in]  */,
					  NTTIME *_t /* [in] [ref] */,
					  WERROR *result)
{
	struct rot_set_modification_time r;
	NTSTATUS status;

	/* In parameters */
	r.in.rotid = _rotid;
	r.in.t = _t;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_set_modification_time_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_get_modification_time_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_get_modification_time_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_get_modification_time_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_get_modification_time *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_get_modification_time_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_get_modification_time_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_GET_MODIFICATION_TIME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_get_modification_time_r_done, req);

	return req;
}

static void dcerpc_rot_get_modification_time_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_get_modification_time_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_get_modification_time_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_get_modification_time_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_get_modification_time_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_get_modification_time *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_GET_MODIFICATION_TIME, mem_ctx, r);

	return status;
}

struct dcerpc_rot_get_modification_time_state {
	struct rot_get_modification_time orig;
	struct rot_get_modification_time tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_get_modification_time_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_get_modification_time_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct MInterfacePointer *_moniker /* [in] [ref] */,
							 NTTIME *_t /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_get_modification_time_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_get_modification_time_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.moniker = _moniker;

	/* Out parameters */
	state->orig.out.t = _t;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_rot_get_modification_time_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_get_modification_time_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_get_modification_time_done, req);
	return req;
}

static void dcerpc_rot_get_modification_time_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_get_modification_time_state *state = tevent_req_data(
		req, struct dcerpc_rot_get_modification_time_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_get_modification_time_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.t = *state->tmp.out.t;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_get_modification_time_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_rot_get_modification_time_state *state = tevent_req_data(
		req, struct dcerpc_rot_get_modification_time_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_get_modification_time(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct MInterfacePointer *_moniker /* [in] [ref] */,
					  NTTIME *_t /* [out] [ref] */,
					  WERROR *result)
{
	struct rot_get_modification_time r;
	NTSTATUS status;

	/* In parameters */
	r.in.moniker = _moniker;

	/* Out parameters */
	r.out.t = _t;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_get_modification_time_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_t = *r.out.t;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_rot_enum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_enum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_enum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct rot_enum *r)
{
	struct tevent_req *req;
	struct dcerpc_rot_enum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_enum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_rot,
			NDR_ROT_ENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_enum_r_done, req);

	return req;
}

static void dcerpc_rot_enum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_enum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_rot_enum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_rot_enum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_enum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct rot_enum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_rot,
			NDR_ROT_ENUM, mem_ctx, r);

	return status;
}

struct dcerpc_rot_enum_state {
	struct rot_enum orig;
	struct rot_enum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_rot_enum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_rot_enum_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct MInterfacePointer *_EnumMoniker /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_rot_enum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_rot_enum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.EnumMoniker = _EnumMoniker;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_rot_enum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_rot_enum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_rot_enum_done, req);
	return req;
}

static void dcerpc_rot_enum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_rot_enum_state *state = tevent_req_data(
		req, struct dcerpc_rot_enum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_rot_enum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.EnumMoniker = *state->tmp.out.EnumMoniker;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_rot_enum_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_rot_enum_state *state = tevent_req_data(
		req, struct dcerpc_rot_enum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_rot_enum(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct MInterfacePointer *_EnumMoniker /* [out] [ref] */,
			 WERROR *result)
{
	struct rot_enum r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.EnumMoniker = _EnumMoniker;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_rot_enum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_EnumMoniker = *r.out.EnumMoniker;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

