/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_libnetapi.h"
#include "autoconf/librpc/gen_ndr/ndr_libnetapi_c.h"

/* libnetapi - client functions generated by pidl */

struct dcerpc_NetJoinDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetJoinDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetJoinDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetJoinDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_NetJoinDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetJoinDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETJOINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetJoinDomain_r_done, req);

	return req;
}

static void dcerpc_NetJoinDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetJoinDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetJoinDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetJoinDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetJoinDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetJoinDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETJOINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_NetJoinDomain_state {
	struct NetJoinDomain orig;
	struct NetJoinDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetJoinDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetJoinDomain_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char * _server /* [in] [unique] */,
					     const char * _domain /* [in] [ref] */,
					     const char * _account_ou /* [in] [unique] */,
					     const char * _account /* [in] [unique] */,
					     const char * _password /* [in] [unique] */,
					     uint32_t _join_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetJoinDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetJoinDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.domain = _domain;
	state->orig.in.account_ou = _account_ou;
	state->orig.in.account = _account;
	state->orig.in.password = _password;
	state->orig.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetJoinDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetJoinDomain_done, req);
	return req;
}

static void dcerpc_NetJoinDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetJoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetJoinDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetJoinDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetJoinDomain_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   enum NET_API_STATUS *result)
{
	struct dcerpc_NetJoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetJoinDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetJoinDomain(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char * _server /* [in] [unique] */,
			      const char * _domain /* [in] [ref] */,
			      const char * _account_ou /* [in] [unique] */,
			      const char * _account /* [in] [unique] */,
			      const char * _password /* [in] [unique] */,
			      uint32_t _join_flags /* [in]  */,
			      enum NET_API_STATUS *result)
{
	struct NetJoinDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.domain = _domain;
	r.in.account_ou = _account_ou;
	r.in.account = _account;
	r.in.password = _password;
	r.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetJoinDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUnjoinDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUnjoinDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUnjoinDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUnjoinDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUnjoinDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUnjoinDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUNJOINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUnjoinDomain_r_done, req);

	return req;
}

static void dcerpc_NetUnjoinDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUnjoinDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUnjoinDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUnjoinDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUnjoinDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUnjoinDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUNJOINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_NetUnjoinDomain_state {
	struct NetUnjoinDomain orig;
	struct NetUnjoinDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUnjoinDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUnjoinDomain_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in] [unique] */,
					       const char * _account /* [in] [unique] */,
					       const char * _password /* [in] [unique] */,
					       uint32_t _unjoin_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetUnjoinDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUnjoinDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account = _account;
	state->orig.in.password = _password;
	state->orig.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUnjoinDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUnjoinDomain_done, req);
	return req;
}

static void dcerpc_NetUnjoinDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUnjoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetUnjoinDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUnjoinDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUnjoinDomain_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetUnjoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetUnjoinDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUnjoinDomain(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in] [unique] */,
				const char * _account /* [in] [unique] */,
				const char * _password /* [in] [unique] */,
				uint32_t _unjoin_flags /* [in]  */,
				enum NET_API_STATUS *result)
{
	struct NetUnjoinDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account = _account;
	r.in.password = _password;
	r.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUnjoinDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGetJoinInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetJoinInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetJoinInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGetJoinInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGetJoinInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetJoinInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETJOININFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetJoinInformation_r_done, req);

	return req;
}

static void dcerpc_NetGetJoinInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetJoinInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGetJoinInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGetJoinInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetJoinInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGetJoinInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETJOININFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_NetGetJoinInformation_state {
	struct NetGetJoinInformation orig;
	struct NetGetJoinInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetJoinInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetJoinInformation_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char * _server_name /* [in] [unique] */,
						     const char * *_name_buffer /* [out] [ref] */,
						     uint16_t *_name_type /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGetJoinInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetJoinInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.name_buffer = _name_buffer;
	state->orig.out.name_type = _name_type;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGetJoinInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGetJoinInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetJoinInformation_done, req);
	return req;
}

static void dcerpc_NetGetJoinInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGetJoinInformation_state *state = tevent_req_data(
		req, struct dcerpc_NetGetJoinInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGetJoinInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name_buffer = *state->tmp.out.name_buffer;
	*state->orig.out.name_type = *state->tmp.out.name_type;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetJoinInformation_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   enum NET_API_STATUS *result)
{
	struct dcerpc_NetGetJoinInformation_state *state = tevent_req_data(
		req, struct dcerpc_NetGetJoinInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetJoinInformation(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char * _server_name /* [in] [unique] */,
				      const char * *_name_buffer /* [out] [ref] */,
				      uint16_t *_name_type /* [out] [ref] */,
				      enum NET_API_STATUS *result)
{
	struct NetGetJoinInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */
	r.out.name_buffer = _name_buffer;
	r.out.name_type = _name_type;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGetJoinInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name_buffer = *r.out.name_buffer;
	*_name_type = *r.out.name_type;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGetJoinableOUs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetJoinableOUs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetJoinableOUs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGetJoinableOUs *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGetJoinableOUs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetJoinableOUs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETJOINABLEOUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetJoinableOUs_r_done, req);

	return req;
}

static void dcerpc_NetGetJoinableOUs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetJoinableOUs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGetJoinableOUs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGetJoinableOUs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetJoinableOUs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGetJoinableOUs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETJOINABLEOUS, mem_ctx, r);

	return status;
}

struct dcerpc_NetGetJoinableOUs_state {
	struct NetGetJoinableOUs orig;
	struct NetGetJoinableOUs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetJoinableOUs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetJoinableOUs_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char * _server_name /* [in] [unique] */,
						 const char * _domain /* [in] [ref] */,
						 const char * _account /* [in] [unique] */,
						 const char * _password /* [in] [unique] */,
						 uint32_t *_ou_count /* [out] [ref] */,
						 const char * **_ous /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGetJoinableOUs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetJoinableOUs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain = _domain;
	state->orig.in.account = _account;
	state->orig.in.password = _password;

	/* Out parameters */
	state->orig.out.ou_count = _ou_count;
	state->orig.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGetJoinableOUs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGetJoinableOUs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetJoinableOUs_done, req);
	return req;
}

static void dcerpc_NetGetJoinableOUs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGetJoinableOUs_state *state = tevent_req_data(
		req, struct dcerpc_NetGetJoinableOUs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGetJoinableOUs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ou_count = *state->tmp.out.ou_count;
	*state->orig.out.ous = *state->tmp.out.ous;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetJoinableOUs_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       enum NET_API_STATUS *result)
{
	struct dcerpc_NetGetJoinableOUs_state *state = tevent_req_data(
		req, struct dcerpc_NetGetJoinableOUs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetJoinableOUs(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char * _server_name /* [in] [unique] */,
				  const char * _domain /* [in] [ref] */,
				  const char * _account /* [in] [unique] */,
				  const char * _password /* [in] [unique] */,
				  uint32_t *_ou_count /* [out] [ref] */,
				  const char * **_ous /* [out] [ref] */,
				  enum NET_API_STATUS *result)
{
	struct NetGetJoinableOUs r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain = _domain;
	r.in.account = _account;
	r.in.password = _password;

	/* Out parameters */
	r.out.ou_count = _ou_count;
	r.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGetJoinableOUs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ou_count = *r.out.ou_count;
	*_ous = *r.out.ous;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetRenameMachineInDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetRenameMachineInDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetRenameMachineInDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetRenameMachineInDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_NetRenameMachineInDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetRenameMachineInDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETRENAMEMACHINEINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetRenameMachineInDomain_r_done, req);

	return req;
}

static void dcerpc_NetRenameMachineInDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetRenameMachineInDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetRenameMachineInDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetRenameMachineInDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetRenameMachineInDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetRenameMachineInDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETRENAMEMACHINEINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_NetRenameMachineInDomain_state {
	struct NetRenameMachineInDomain orig;
	struct NetRenameMachineInDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetRenameMachineInDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetRenameMachineInDomain_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char * _server_name /* [in]  */,
							const char * _new_machine_name /* [in]  */,
							const char * _account /* [in]  */,
							const char * _password /* [in]  */,
							uint32_t _rename_options /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetRenameMachineInDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetRenameMachineInDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.new_machine_name = _new_machine_name;
	state->orig.in.account = _account;
	state->orig.in.password = _password;
	state->orig.in.rename_options = _rename_options;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetRenameMachineInDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetRenameMachineInDomain_done, req);
	return req;
}

static void dcerpc_NetRenameMachineInDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetRenameMachineInDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetRenameMachineInDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetRenameMachineInDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetRenameMachineInDomain_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      enum NET_API_STATUS *result)
{
	struct dcerpc_NetRenameMachineInDomain_state *state = tevent_req_data(
		req, struct dcerpc_NetRenameMachineInDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetRenameMachineInDomain(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char * _server_name /* [in]  */,
					 const char * _new_machine_name /* [in]  */,
					 const char * _account /* [in]  */,
					 const char * _password /* [in]  */,
					 uint32_t _rename_options /* [in]  */,
					 enum NET_API_STATUS *result)
{
	struct NetRenameMachineInDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.new_machine_name = _new_machine_name;
	r.in.account = _account;
	r.in.password = _password;
	r.in.rename_options = _rename_options;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetRenameMachineInDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetServerGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetServerGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetServerGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetServerGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetServerGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetServerGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSERVERGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetServerGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetServerGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetServerGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetServerGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetServerGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetServerGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetServerGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSERVERGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetServerGetInfo_state {
	struct NetServerGetInfo orig;
	struct NetServerGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetServerGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetServerGetInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in] [unique] */,
						uint32_t _level /* [in]  */,
						uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetServerGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetServerGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetServerGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetServerGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetServerGetInfo_done, req);
	return req;
}

static void dcerpc_NetServerGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetServerGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetServerGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetServerGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetServerGetInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetServerGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetServerGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetServerGetInfo(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in] [unique] */,
				 uint32_t _level /* [in]  */,
				 uint8_t **_buffer /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetServerGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetServerGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetServerSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetServerSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetServerSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetServerSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetServerSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetServerSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSERVERSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetServerSetInfo_r_done, req);

	return req;
}

static void dcerpc_NetServerSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetServerSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetServerSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetServerSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetServerSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetServerSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSERVERSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetServerSetInfo_state {
	struct NetServerSetInfo orig;
	struct NetServerSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetServerSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetServerSetInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in] [unique] */,
						uint32_t _level /* [in]  */,
						uint8_t *_buffer /* [in] [ref] */,
						uint32_t *_parm_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetServerSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetServerSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetServerSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetServerSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetServerSetInfo_done, req);
	return req;
}

static void dcerpc_NetServerSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetServerSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetServerSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetServerSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_error = *state->tmp.out.parm_error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetServerSetInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetServerSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetServerSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetServerSetInfo(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in] [unique] */,
				 uint32_t _level /* [in]  */,
				 uint8_t *_buffer /* [in] [ref] */,
				 uint32_t *_parm_error /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetServerSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetServerSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_error = *r.out.parm_error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGetDCName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetDCName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetDCName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGetDCName *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGetDCName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetDCName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetDCName_r_done, req);

	return req;
}

static void dcerpc_NetGetDCName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetDCName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGetDCName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGetDCName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetDCName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGetDCName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_NetGetDCName_state {
	struct NetGetDCName orig;
	struct NetGetDCName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetDCName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetDCName_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char * _server_name /* [in] [unique] */,
					    const char * _domain_name /* [in] [unique] */,
					    uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGetDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGetDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGetDCName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetDCName_done, req);
	return req;
}

static void dcerpc_NetGetDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGetDCName_state *state = tevent_req_data(
		req, struct dcerpc_NetGetDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGetDCName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetDCName_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  enum NET_API_STATUS *result)
{
	struct dcerpc_NetGetDCName_state *state = tevent_req_data(
		req, struct dcerpc_NetGetDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetDCName(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char * _server_name /* [in] [unique] */,
			     const char * _domain_name /* [in] [unique] */,
			     uint8_t **_buffer /* [out] [ref] */,
			     enum NET_API_STATUS *result)
{
	struct NetGetDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGetDCName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGetAnyDCName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetAnyDCName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetAnyDCName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGetAnyDCName *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGetAnyDCName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetAnyDCName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETANYDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetAnyDCName_r_done, req);

	return req;
}

static void dcerpc_NetGetAnyDCName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetAnyDCName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGetAnyDCName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGetAnyDCName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetAnyDCName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGetAnyDCName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGETANYDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_NetGetAnyDCName_state {
	struct NetGetAnyDCName orig;
	struct NetGetAnyDCName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGetAnyDCName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGetAnyDCName_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in] [unique] */,
					       const char * _domain_name /* [in] [unique] */,
					       uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGetAnyDCName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGetAnyDCName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGetAnyDCName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGetAnyDCName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGetAnyDCName_done, req);
	return req;
}

static void dcerpc_NetGetAnyDCName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGetAnyDCName_state *state = tevent_req_data(
		req, struct dcerpc_NetGetAnyDCName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGetAnyDCName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGetAnyDCName_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetGetAnyDCName_state *state = tevent_req_data(
		req, struct dcerpc_NetGetAnyDCName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGetAnyDCName(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in] [unique] */,
				const char * _domain_name /* [in] [unique] */,
				uint8_t **_buffer /* [out] [ref] */,
				enum NET_API_STATUS *result)
{
	struct NetGetAnyDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGetAnyDCName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DsGetDcName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DsGetDcName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DsGetDcName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DsGetDcName *r)
{
	struct tevent_req *req;
	struct dcerpc_DsGetDcName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DsGetDcName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_DSGETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DsGetDcName_r_done, req);

	return req;
}

static void dcerpc_DsGetDcName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DsGetDcName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DsGetDcName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DsGetDcName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DsGetDcName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DsGetDcName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_DSGETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_DsGetDcName_state {
	struct DsGetDcName orig;
	struct DsGetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DsGetDcName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DsGetDcName_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in] [unique] */,
					   const char * _domain_name /* [in] [ref] */,
					   struct GUID *_domain_guid /* [in] [unique] */,
					   const char * _site_name /* [in] [unique] */,
					   uint32_t _flags /* [in]  */,
					   struct DOMAIN_CONTROLLER_INFO **_dc_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DsGetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DsGetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.dc_info = _dc_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DsGetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DsGetDcName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DsGetDcName_done, req);
	return req;
}

static void dcerpc_DsGetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_DsGetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DsGetDcName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dc_info = *state->tmp.out.dc_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DsGetDcName_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_DsGetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DsGetDcName(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in] [unique] */,
			    const char * _domain_name /* [in] [ref] */,
			    struct GUID *_domain_guid /* [in] [unique] */,
			    const char * _site_name /* [in] [unique] */,
			    uint32_t _flags /* [in]  */,
			    struct DOMAIN_CONTROLLER_INFO **_dc_info /* [out] [ref] */,
			    enum NET_API_STATUS *result)
{
	struct DsGetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_name = _site_name;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.dc_info = _dc_info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DsGetDcName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dc_info = *r.out.dc_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserAdd_r_done, req);

	return req;
}

static void dcerpc_NetUserAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERADD, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserAdd_state {
	struct NetUserAdd orig;
	struct NetUserAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserAdd_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  const char * _server_name /* [in] [unique] */,
					  uint32_t _level /* [in]  */,
					  uint8_t *_buffer /* [in] [ref] */,
					  uint32_t *_parm_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserAdd_done, req);
	return req;
}

static void dcerpc_NetUserAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetUserAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_error = *state->tmp.out.parm_error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserAdd_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetUserAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserAdd(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   const char * _server_name /* [in] [unique] */,
			   uint32_t _level /* [in]  */,
			   uint8_t *_buffer /* [in] [ref] */,
			   uint32_t *_parm_error /* [out] [ref] */,
			   enum NET_API_STATUS *result)
{
	struct NetUserAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_error = *r.out.parm_error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserDel *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserDel_r_done, req);

	return req;
}

static void dcerpc_NetUserDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERDEL, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserDel_state {
	struct NetUserDel orig;
	struct NetUserDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserDel_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  const char * _server_name /* [in] [unique] */,
					  const char * _user_name /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserDel_done, req);
	return req;
}

static void dcerpc_NetUserDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserDel_state *state = tevent_req_data(
		req, struct dcerpc_NetUserDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserDel_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserDel_state *state = tevent_req_data(
		req, struct dcerpc_NetUserDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserDel(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   const char * _server_name /* [in] [unique] */,
			   const char * _user_name /* [in] [ref] */,
			   enum NET_API_STATUS *result)
{
	struct NetUserDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserEnum_r_done, req);

	return req;
}

static void dcerpc_NetUserEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERENUM, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserEnum_state {
	struct NetUserEnum orig;
	struct NetUserEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserEnum_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in] [unique] */,
					   uint32_t _level /* [in]  */,
					   uint32_t _filter /* [in]  */,
					   uint8_t **_buffer /* [out] [ref] */,
					   uint32_t _prefmaxlen /* [in]  */,
					   uint32_t *_entries_read /* [out] [ref] */,
					   uint32_t *_total_entries /* [out] [ref] */,
					   uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.filter = _filter;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserEnum_done, req);
	return req;
}

static void dcerpc_NetUserEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetUserEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserEnum_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetUserEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserEnum(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in] [unique] */,
			    uint32_t _level /* [in]  */,
			    uint32_t _filter /* [in]  */,
			    uint8_t **_buffer /* [out] [ref] */,
			    uint32_t _prefmaxlen /* [in]  */,
			    uint32_t *_entries_read /* [out] [ref] */,
			    uint32_t *_total_entries /* [out] [ref] */,
			    uint32_t *_resume_handle /* [in,out] [ref] */,
			    enum NET_API_STATUS *result)
{
	struct NetUserEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.filter = _filter;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserChangePassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserChangePassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserChangePassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserChangePassword *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserChangePassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserChangePassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERCHANGEPASSWORD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserChangePassword_r_done, req);

	return req;
}

static void dcerpc_NetUserChangePassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserChangePassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserChangePassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserChangePassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserChangePassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserChangePassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERCHANGEPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserChangePassword_state {
	struct NetUserChangePassword orig;
	struct NetUserChangePassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserChangePassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserChangePassword_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char * _domain_name /* [in]  */,
						     const char * _user_name /* [in]  */,
						     const char * _old_password /* [in]  */,
						     const char * _new_password /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserChangePassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserChangePassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.old_password = _old_password;
	state->orig.in.new_password = _new_password;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserChangePassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserChangePassword_done, req);
	return req;
}

static void dcerpc_NetUserChangePassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_NetUserChangePassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserChangePassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserChangePassword_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserChangePassword_state *state = tevent_req_data(
		req, struct dcerpc_NetUserChangePassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserChangePassword(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char * _domain_name /* [in]  */,
				      const char * _user_name /* [in]  */,
				      const char * _old_password /* [in]  */,
				      const char * _new_password /* [in]  */,
				      enum NET_API_STATUS *result)
{
	struct NetUserChangePassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;
	r.in.user_name = _user_name;
	r.in.old_password = _old_password;
	r.in.new_password = _new_password;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserChangePassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetUserGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserGetInfo_state {
	struct NetUserGetInfo orig;
	struct NetUserGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetInfo_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      const char * _server_name /* [in]  */,
					      const char * _user_name /* [in]  */,
					      uint32_t _level /* [in]  */,
					      uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetInfo_done, req);
	return req;
}

static void dcerpc_NetUserGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetInfo_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetInfo(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       const char * _server_name /* [in]  */,
			       const char * _user_name /* [in]  */,
			       uint32_t _level /* [in]  */,
			       uint8_t **_buffer /* [out] [ref] */,
			       enum NET_API_STATUS *result)
{
	struct NetUserGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserSetInfo_r_done, req);

	return req;
}

static void dcerpc_NetUserSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserSetInfo_state {
	struct NetUserSetInfo orig;
	struct NetUserSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserSetInfo_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      const char * _server_name /* [in]  */,
					      const char * _user_name /* [in]  */,
					      uint32_t _level /* [in]  */,
					      uint8_t *_buffer /* [in] [ref] */,
					      uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserSetInfo_done, req);
	return req;
}

static void dcerpc_NetUserSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetUserSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserSetInfo_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetUserSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserSetInfo(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       const char * _server_name /* [in]  */,
			       const char * _user_name /* [in]  */,
			       uint32_t _level /* [in]  */,
			       uint8_t *_buffer /* [in] [ref] */,
			       uint32_t *_parm_err /* [out] [ref] */,
			       enum NET_API_STATUS *result)
{
	struct NetUserSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserGetGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserGetGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETGROUPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetGroups_r_done, req);

	return req;
}

static void dcerpc_NetUserGetGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserGetGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserGetGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserGetGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserGetGroups_state {
	struct NetUserGetGroups orig;
	struct NetUserGetGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetGroups_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						const char * _user_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t **_buffer /* [out] [ref] */,
						uint32_t _prefmaxlen /* [in]  */,
						uint32_t *_entries_read /* [out] [ref] */,
						uint32_t *_total_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserGetGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserGetGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetGroups_done, req);
	return req;
}

static void dcerpc_NetUserGetGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserGetGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserGetGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetGroups_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserGetGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetGroups(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 const char * _user_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t **_buffer /* [out] [ref] */,
				 uint32_t _prefmaxlen /* [in]  */,
				 uint32_t *_entries_read /* [out] [ref] */,
				 uint32_t *_total_entries /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetUserGetGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserGetGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserSetGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserSetGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserSetGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserSetGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserSetGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserSetGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERSETGROUPS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserSetGroups_r_done, req);

	return req;
}

static void dcerpc_NetUserSetGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserSetGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserSetGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserSetGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserSetGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserSetGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERSETGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserSetGroups_state {
	struct NetUserSetGroups orig;
	struct NetUserSetGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserSetGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserSetGroups_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						const char * _user_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t *_buffer /* [in] [ref] */,
						uint32_t _num_entries /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserSetGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserSetGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.num_entries = _num_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserSetGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserSetGroups_done, req);
	return req;
}

static void dcerpc_NetUserSetGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserSetGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserSetGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserSetGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserSetGroups_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserSetGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserSetGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserSetGroups(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 const char * _user_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t *_buffer /* [in] [ref] */,
				 uint32_t _num_entries /* [in]  */,
				 enum NET_API_STATUS *result)
{
	struct NetUserSetGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.num_entries = _num_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserSetGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserGetLocalGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetLocalGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetLocalGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserGetLocalGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetLocalGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetLocalGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETLOCALGROUPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetLocalGroups_r_done, req);

	return req;
}

static void dcerpc_NetUserGetLocalGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetLocalGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserGetLocalGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserGetLocalGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetLocalGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserGetLocalGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERGETLOCALGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserGetLocalGroups_state {
	struct NetUserGetLocalGroups orig;
	struct NetUserGetLocalGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserGetLocalGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserGetLocalGroups_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char * _server_name /* [in]  */,
						     const char * _user_name /* [in]  */,
						     uint32_t _level /* [in]  */,
						     uint32_t _flags /* [in]  */,
						     uint8_t **_buffer /* [out] [ref] */,
						     uint32_t _prefmaxlen /* [in]  */,
						     uint32_t *_entries_read /* [out] [ref] */,
						     uint32_t *_total_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserGetLocalGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserGetLocalGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;
	state->orig.in.flags = _flags;
	state->orig.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserGetLocalGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserGetLocalGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserGetLocalGroups_done, req);
	return req;
}

static void dcerpc_NetUserGetLocalGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserGetLocalGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetLocalGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserGetLocalGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserGetLocalGroups_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserGetLocalGroups_state *state = tevent_req_data(
		req, struct dcerpc_NetUserGetLocalGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserGetLocalGroups(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char * _server_name /* [in]  */,
				      const char * _user_name /* [in]  */,
				      uint32_t _level /* [in]  */,
				      uint32_t _flags /* [in]  */,
				      uint8_t **_buffer /* [out] [ref] */,
				      uint32_t _prefmaxlen /* [in]  */,
				      uint32_t *_entries_read /* [out] [ref] */,
				      uint32_t *_total_entries /* [out] [ref] */,
				      enum NET_API_STATUS *result)
{
	struct NetUserGetLocalGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.user_name = _user_name;
	r.in.level = _level;
	r.in.flags = _flags;
	r.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserGetLocalGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserModalsGet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserModalsGet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserModalsGet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserModalsGet *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserModalsGet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserModalsGet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERMODALSGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserModalsGet_r_done, req);

	return req;
}

static void dcerpc_NetUserModalsGet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserModalsGet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserModalsGet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserModalsGet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserModalsGet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserModalsGet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERMODALSGET, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserModalsGet_state {
	struct NetUserModalsGet orig;
	struct NetUserModalsGet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserModalsGet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserModalsGet_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserModalsGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserModalsGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserModalsGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserModalsGet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserModalsGet_done, req);
	return req;
}

static void dcerpc_NetUserModalsGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserModalsGet_state *state = tevent_req_data(
		req, struct dcerpc_NetUserModalsGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserModalsGet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserModalsGet_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserModalsGet_state *state = tevent_req_data(
		req, struct dcerpc_NetUserModalsGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserModalsGet(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t **_buffer /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetUserModalsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserModalsGet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetUserModalsSet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserModalsSet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserModalsSet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetUserModalsSet *r)
{
	struct tevent_req *req;
	struct dcerpc_NetUserModalsSet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserModalsSet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERMODALSSET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserModalsSet_r_done, req);

	return req;
}

static void dcerpc_NetUserModalsSet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserModalsSet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetUserModalsSet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetUserModalsSet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserModalsSet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetUserModalsSet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETUSERMODALSSET, mem_ctx, r);

	return status;
}

struct dcerpc_NetUserModalsSet_state {
	struct NetUserModalsSet orig;
	struct NetUserModalsSet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetUserModalsSet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetUserModalsSet_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t *_buffer /* [in] [ref] */,
						uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetUserModalsSet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetUserModalsSet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetUserModalsSet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetUserModalsSet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetUserModalsSet_done, req);
	return req;
}

static void dcerpc_NetUserModalsSet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetUserModalsSet_state *state = tevent_req_data(
		req, struct dcerpc_NetUserModalsSet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetUserModalsSet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetUserModalsSet_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetUserModalsSet_state *state = tevent_req_data(
		req, struct dcerpc_NetUserModalsSet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetUserModalsSet(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t *_buffer /* [in] [ref] */,
				 uint32_t *_parm_err /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetUserModalsSet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetUserModalsSet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetQueryDisplayInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetQueryDisplayInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetQueryDisplayInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetQueryDisplayInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_NetQueryDisplayInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetQueryDisplayInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETQUERYDISPLAYINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetQueryDisplayInformation_r_done, req);

	return req;
}

static void dcerpc_NetQueryDisplayInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetQueryDisplayInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetQueryDisplayInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetQueryDisplayInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetQueryDisplayInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetQueryDisplayInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETQUERYDISPLAYINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_NetQueryDisplayInformation_state {
	struct NetQueryDisplayInformation orig;
	struct NetQueryDisplayInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetQueryDisplayInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetQueryDisplayInformation_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char * _server_name /* [in] [unique] */,
							  uint32_t _level /* [in]  */,
							  uint32_t _idx /* [in]  */,
							  uint32_t _entries_requested /* [in]  */,
							  uint32_t _prefmaxlen /* [in]  */,
							  uint32_t *_entries_read /* [out] [ref] */,
							  void **_buffer /* [out] [noprint,ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetQueryDisplayInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetQueryDisplayInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.idx = _idx;
	state->orig.in.entries_requested = _entries_requested;
	state->orig.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	state->orig.out.entries_read = _entries_read;
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetQueryDisplayInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetQueryDisplayInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetQueryDisplayInformation_done, req);
	return req;
}

static void dcerpc_NetQueryDisplayInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetQueryDisplayInformation_state *state = tevent_req_data(
		req, struct dcerpc_NetQueryDisplayInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetQueryDisplayInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetQueryDisplayInformation_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						enum NET_API_STATUS *result)
{
	struct dcerpc_NetQueryDisplayInformation_state *state = tevent_req_data(
		req, struct dcerpc_NetQueryDisplayInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetQueryDisplayInformation(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char * _server_name /* [in] [unique] */,
					   uint32_t _level /* [in]  */,
					   uint32_t _idx /* [in]  */,
					   uint32_t _entries_requested /* [in]  */,
					   uint32_t _prefmaxlen /* [in]  */,
					   uint32_t *_entries_read /* [out] [ref] */,
					   void **_buffer /* [out] [noprint,ref] */,
					   enum NET_API_STATUS *result)
{
	struct NetQueryDisplayInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.idx = _idx;
	r.in.entries_requested = _entries_requested;
	r.in.prefmaxlen = _prefmaxlen;

	/* Out parameters */
	r.out.entries_read = _entries_read;
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetQueryDisplayInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_entries_read = *r.out.entries_read;
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupAdd_r_done, req);

	return req;
}

static void dcerpc_NetGroupAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPADD, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupAdd_state {
	struct NetGroupAdd orig;
	struct NetGroupAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupAdd_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in]  */,
					   uint32_t _level /* [in]  */,
					   uint8_t *_buffer /* [in] [ref] */,
					   uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGroupAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupAdd_done, req);
	return req;
}

static void dcerpc_NetGroupAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupAdd_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupAdd(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in]  */,
			    uint32_t _level /* [in]  */,
			    uint8_t *_buffer /* [in] [ref] */,
			    uint32_t *_parm_err /* [out] [ref] */,
			    enum NET_API_STATUS *result)
{
	struct NetGroupAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupDel *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupDel_r_done, req);

	return req;
}

static void dcerpc_NetGroupDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPDEL, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupDel_state {
	struct NetGroupDel orig;
	struct NetGroupDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupDel_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in]  */,
					   const char * _group_name /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupDel_done, req);
	return req;
}

static void dcerpc_NetGroupDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupDel_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupDel_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupDel_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupDel(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in]  */,
			    const char * _group_name /* [in]  */,
			    enum NET_API_STATUS *result)
{
	struct NetGroupDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupEnum_r_done, req);

	return req;
}

static void dcerpc_NetGroupEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPENUM, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupEnum_state {
	struct NetGroupEnum orig;
	struct NetGroupEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupEnum_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char * _server_name /* [in]  */,
					    uint32_t _level /* [in]  */,
					    uint8_t **_buffer /* [out] [ref] */,
					    uint32_t _prefmaxlen /* [in]  */,
					    uint32_t *_entries_read /* [out] [ref] */,
					    uint32_t *_total_entries /* [out] [ref] */,
					    uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGroupEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupEnum_done, req);
	return req;
}

static void dcerpc_NetGroupEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupEnum_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupEnum(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char * _server_name /* [in]  */,
			     uint32_t _level /* [in]  */,
			     uint8_t **_buffer /* [out] [ref] */,
			     uint32_t _prefmaxlen /* [in]  */,
			     uint32_t *_entries_read /* [out] [ref] */,
			     uint32_t *_total_entries /* [out] [ref] */,
			     uint32_t *_resume_handle /* [in,out] [ref] */,
			     enum NET_API_STATUS *result)
{
	struct NetGroupEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupSetInfo_r_done, req);

	return req;
}

static void dcerpc_NetGroupSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupSetInfo_state {
	struct NetGroupSetInfo orig;
	struct NetGroupSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupSetInfo_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _group_name /* [in]  */,
					       uint32_t _level /* [in]  */,
					       uint8_t *_buffer /* [in] [ref] */,
					       uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGroupSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupSetInfo_done, req);
	return req;
}

static void dcerpc_NetGroupSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupSetInfo_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupSetInfo(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _group_name /* [in]  */,
				uint32_t _level /* [in]  */,
				uint8_t *_buffer /* [in] [ref] */,
				uint32_t *_parm_err /* [out] [ref] */,
				enum NET_API_STATUS *result)
{
	struct NetGroupSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetGroupGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupGetInfo_state {
	struct NetGroupGetInfo orig;
	struct NetGroupGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupGetInfo_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _group_name /* [in]  */,
					       uint32_t _level /* [in]  */,
					       uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGroupGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupGetInfo_done, req);
	return req;
}

static void dcerpc_NetGroupGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupGetInfo_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupGetInfo(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _group_name /* [in]  */,
				uint32_t _level /* [in]  */,
				uint8_t **_buffer /* [out] [ref] */,
				enum NET_API_STATUS *result)
{
	struct NetGroupGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupAddUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupAddUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupAddUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupAddUser *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupAddUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupAddUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPADDUSER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupAddUser_r_done, req);

	return req;
}

static void dcerpc_NetGroupAddUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupAddUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupAddUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupAddUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupAddUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupAddUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPADDUSER, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupAddUser_state {
	struct NetGroupAddUser orig;
	struct NetGroupAddUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupAddUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupAddUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _group_name /* [in]  */,
					       const char * _user_name /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupAddUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupAddUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupAddUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupAddUser_done, req);
	return req;
}

static void dcerpc_NetGroupAddUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupAddUser_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupAddUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupAddUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupAddUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupAddUser_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupAddUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupAddUser(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _group_name /* [in]  */,
				const char * _user_name /* [in]  */,
				enum NET_API_STATUS *result)
{
	struct NetGroupAddUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupAddUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupDelUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupDelUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupDelUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupDelUser *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupDelUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupDelUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPDELUSER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupDelUser_r_done, req);

	return req;
}

static void dcerpc_NetGroupDelUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupDelUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupDelUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupDelUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupDelUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupDelUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPDELUSER, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupDelUser_state {
	struct NetGroupDelUser orig;
	struct NetGroupDelUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupDelUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupDelUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _group_name /* [in]  */,
					       const char * _user_name /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupDelUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupDelUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupDelUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupDelUser_done, req);
	return req;
}

static void dcerpc_NetGroupDelUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupDelUser_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupDelUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupDelUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupDelUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupDelUser_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupDelUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupDelUser(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _group_name /* [in]  */,
				const char * _user_name /* [in]  */,
				enum NET_API_STATUS *result)
{
	struct NetGroupDelUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.user_name = _user_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupDelUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupGetUsers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupGetUsers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupGetUsers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupGetUsers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupGetUsers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupGetUsers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPGETUSERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupGetUsers_r_done, req);

	return req;
}

static void dcerpc_NetGroupGetUsers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupGetUsers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupGetUsers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupGetUsers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupGetUsers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupGetUsers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPGETUSERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupGetUsers_state {
	struct NetGroupGetUsers orig;
	struct NetGroupGetUsers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupGetUsers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupGetUsers_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						const char * _group_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t **_buffer /* [out] [ref] */,
						uint32_t _prefmaxlen /* [in]  */,
						uint32_t *_entries_read /* [out] [ref] */,
						uint32_t *_total_entries /* [out] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupGetUsers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupGetUsers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetGroupGetUsers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupGetUsers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupGetUsers_done, req);
	return req;
}

static void dcerpc_NetGroupGetUsers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupGetUsers_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupGetUsers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupGetUsers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupGetUsers_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupGetUsers_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupGetUsers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupGetUsers(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 const char * _group_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t **_buffer /* [out] [ref] */,
				 uint32_t _prefmaxlen /* [in]  */,
				 uint32_t *_entries_read /* [out] [ref] */,
				 uint32_t *_total_entries /* [out] [ref] */,
				 uint32_t *_resume_handle /* [in,out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetGroupGetUsers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupGetUsers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetGroupSetUsers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupSetUsers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupSetUsers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetGroupSetUsers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupSetUsers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupSetUsers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPSETUSERS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupSetUsers_r_done, req);

	return req;
}

static void dcerpc_NetGroupSetUsers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupSetUsers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetGroupSetUsers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetGroupSetUsers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupSetUsers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetGroupSetUsers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETGROUPSETUSERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetGroupSetUsers_state {
	struct NetGroupSetUsers orig;
	struct NetGroupSetUsers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetGroupSetUsers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetGroupSetUsers_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						const char * _group_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t *_buffer /* [in] [ref] */,
						uint32_t _num_entries /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetGroupSetUsers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetGroupSetUsers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.num_entries = _num_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetGroupSetUsers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetGroupSetUsers_done, req);
	return req;
}

static void dcerpc_NetGroupSetUsers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetGroupSetUsers_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupSetUsers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetGroupSetUsers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetGroupSetUsers_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetGroupSetUsers_state *state = tevent_req_data(
		req, struct dcerpc_NetGroupSetUsers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetGroupSetUsers(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 const char * _group_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t *_buffer /* [in] [ref] */,
				 uint32_t _num_entries /* [in]  */,
				 enum NET_API_STATUS *result)
{
	struct NetGroupSetUsers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.num_entries = _num_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetGroupSetUsers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupAdd_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPADD, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupAdd_state {
	struct NetLocalGroupAdd orig;
	struct NetLocalGroupAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupAdd_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						uint32_t _level /* [in]  */,
						uint8_t *_buffer /* [in] [ref] */,
						uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetLocalGroupAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupAdd_done, req);
	return req;
}

static void dcerpc_NetLocalGroupAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupAdd_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupAdd(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 uint32_t _level /* [in]  */,
				 uint8_t *_buffer /* [in] [ref] */,
				 uint32_t *_parm_err /* [out] [ref] */,
				 enum NET_API_STATUS *result)
{
	struct NetLocalGroupAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupDel *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupDel_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPDEL, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupDel_state {
	struct NetLocalGroupDel orig;
	struct NetLocalGroupDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupDel_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */,
						const char * _group_name /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupDel_done, req);
	return req;
}

static void dcerpc_NetLocalGroupDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupDel_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupDel_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupDel_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupDel(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 const char * _group_name /* [in]  */,
				 enum NET_API_STATUS *result)
{
	struct NetLocalGroupDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupGetInfo_state {
	struct NetLocalGroupGetInfo orig;
	struct NetLocalGroupGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupGetInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char * _server_name /* [in]  */,
						    const char * _group_name /* [in]  */,
						    uint32_t _level /* [in]  */,
						    uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetLocalGroupGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupGetInfo_done, req);
	return req;
}

static void dcerpc_NetLocalGroupGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupGetInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupGetInfo(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char * _server_name /* [in]  */,
				     const char * _group_name /* [in]  */,
				     uint32_t _level /* [in]  */,
				     uint8_t **_buffer /* [out] [ref] */,
				     enum NET_API_STATUS *result)
{
	struct NetLocalGroupGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupSetInfo_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupSetInfo_state {
	struct NetLocalGroupSetInfo orig;
	struct NetLocalGroupSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupSetInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char * _server_name /* [in]  */,
						    const char * _group_name /* [in]  */,
						    uint32_t _level /* [in]  */,
						    uint8_t *_buffer /* [in] [ref] */,
						    uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetLocalGroupSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupSetInfo_done, req);
	return req;
}

static void dcerpc_NetLocalGroupSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupSetInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupSetInfo(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char * _server_name /* [in]  */,
				     const char * _group_name /* [in]  */,
				     uint32_t _level /* [in]  */,
				     uint8_t *_buffer /* [in] [ref] */,
				     uint32_t *_parm_err /* [out] [ref] */,
				     enum NET_API_STATUS *result)
{
	struct NetLocalGroupSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupEnum_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPENUM, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupEnum_state {
	struct NetLocalGroupEnum orig;
	struct NetLocalGroupEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupEnum_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char * _server_name /* [in]  */,
						 uint32_t _level /* [in]  */,
						 uint8_t **_buffer /* [out] [ref] */,
						 uint32_t _prefmaxlen /* [in]  */,
						 uint32_t *_entries_read /* [out] [ref] */,
						 uint32_t *_total_entries /* [out] [ref] */,
						 uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetLocalGroupEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupEnum_done, req);
	return req;
}

static void dcerpc_NetLocalGroupEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupEnum_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupEnum(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char * _server_name /* [in]  */,
				  uint32_t _level /* [in]  */,
				  uint8_t **_buffer /* [out] [ref] */,
				  uint32_t _prefmaxlen /* [in]  */,
				  uint32_t *_entries_read /* [out] [ref] */,
				  uint32_t *_total_entries /* [out] [ref] */,
				  uint32_t *_resume_handle /* [in,out] [ref] */,
				  enum NET_API_STATUS *result)
{
	struct NetLocalGroupEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupAddMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupAddMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupAddMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupAddMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupAddMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupAddMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPADDMEMBERS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupAddMembers_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupAddMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupAddMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupAddMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupAddMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupAddMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupAddMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPADDMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupAddMembers_state {
	struct NetLocalGroupAddMembers orig;
	struct NetLocalGroupAddMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupAddMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupAddMembers_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char * _server_name /* [in]  */,
						       const char * _group_name /* [in]  */,
						       uint32_t _level /* [in]  */,
						       uint8_t *_buffer /* [in] [ref] */,
						       uint32_t _total_entries /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupAddMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupAddMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupAddMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupAddMembers_done, req);
	return req;
}

static void dcerpc_NetLocalGroupAddMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupAddMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupAddMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupAddMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupAddMembers_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupAddMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupAddMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupAddMembers(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char * _server_name /* [in]  */,
					const char * _group_name /* [in]  */,
					uint32_t _level /* [in]  */,
					uint8_t *_buffer /* [in] [ref] */,
					uint32_t _total_entries /* [in]  */,
					enum NET_API_STATUS *result)
{
	struct NetLocalGroupAddMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupAddMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupDelMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupDelMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupDelMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupDelMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupDelMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupDelMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPDELMEMBERS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupDelMembers_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupDelMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupDelMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupDelMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupDelMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupDelMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupDelMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPDELMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupDelMembers_state {
	struct NetLocalGroupDelMembers orig;
	struct NetLocalGroupDelMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupDelMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupDelMembers_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char * _server_name /* [in]  */,
						       const char * _group_name /* [in]  */,
						       uint32_t _level /* [in]  */,
						       uint8_t *_buffer /* [in] [ref] */,
						       uint32_t _total_entries /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupDelMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupDelMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupDelMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupDelMembers_done, req);
	return req;
}

static void dcerpc_NetLocalGroupDelMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupDelMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupDelMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupDelMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupDelMembers_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupDelMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupDelMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupDelMembers(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char * _server_name /* [in]  */,
					const char * _group_name /* [in]  */,
					uint32_t _level /* [in]  */,
					uint8_t *_buffer /* [in] [ref] */,
					uint32_t _total_entries /* [in]  */,
					enum NET_API_STATUS *result)
{
	struct NetLocalGroupDelMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupDelMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupGetMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupGetMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupGetMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupGetMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupGetMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupGetMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPGETMEMBERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupGetMembers_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupGetMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupGetMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupGetMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupGetMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupGetMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupGetMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPGETMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupGetMembers_state {
	struct NetLocalGroupGetMembers orig;
	struct NetLocalGroupGetMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupGetMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupGetMembers_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char * _server_name /* [in]  */,
						       const char * _local_group_name /* [in]  */,
						       uint32_t _level /* [in]  */,
						       uint8_t **_buffer /* [out] [ref] */,
						       uint32_t _prefmaxlen /* [in]  */,
						       uint32_t *_entries_read /* [out] [ref] */,
						       uint32_t *_total_entries /* [out] [ref] */,
						       uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupGetMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupGetMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.local_group_name = _local_group_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetLocalGroupGetMembers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupGetMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupGetMembers_done, req);
	return req;
}

static void dcerpc_NetLocalGroupGetMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupGetMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupGetMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupGetMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupGetMembers_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupGetMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupGetMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupGetMembers(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char * _server_name /* [in]  */,
					const char * _local_group_name /* [in]  */,
					uint32_t _level /* [in]  */,
					uint8_t **_buffer /* [out] [ref] */,
					uint32_t _prefmaxlen /* [in]  */,
					uint32_t *_entries_read /* [out] [ref] */,
					uint32_t *_total_entries /* [out] [ref] */,
					uint32_t *_resume_handle /* [in,out] [ref] */,
					enum NET_API_STATUS *result)
{
	struct NetLocalGroupGetMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.local_group_name = _local_group_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupGetMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetLocalGroupSetMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupSetMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupSetMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetLocalGroupSetMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupSetMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupSetMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPSETMEMBERS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupSetMembers_r_done, req);

	return req;
}

static void dcerpc_NetLocalGroupSetMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupSetMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetLocalGroupSetMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetLocalGroupSetMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupSetMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetLocalGroupSetMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETLOCALGROUPSETMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_NetLocalGroupSetMembers_state {
	struct NetLocalGroupSetMembers orig;
	struct NetLocalGroupSetMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetLocalGroupSetMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetLocalGroupSetMembers_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char * _server_name /* [in]  */,
						       const char * _group_name /* [in]  */,
						       uint32_t _level /* [in]  */,
						       uint8_t *_buffer /* [in] [ref] */,
						       uint32_t _total_entries /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetLocalGroupSetMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetLocalGroupSetMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.group_name = _group_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetLocalGroupSetMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetLocalGroupSetMembers_done, req);
	return req;
}

static void dcerpc_NetLocalGroupSetMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetLocalGroupSetMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupSetMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetLocalGroupSetMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetLocalGroupSetMembers_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     enum NET_API_STATUS *result)
{
	struct dcerpc_NetLocalGroupSetMembers_state *state = tevent_req_data(
		req, struct dcerpc_NetLocalGroupSetMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetLocalGroupSetMembers(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char * _server_name /* [in]  */,
					const char * _group_name /* [in]  */,
					uint32_t _level /* [in]  */,
					uint8_t *_buffer /* [in] [ref] */,
					uint32_t _total_entries /* [in]  */,
					enum NET_API_STATUS *result)
{
	struct NetLocalGroupSetMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.group_name = _group_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.total_entries = _total_entries;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetLocalGroupSetMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetRemoteTOD_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetRemoteTOD_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetRemoteTOD_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetRemoteTOD *r)
{
	struct tevent_req *req;
	struct dcerpc_NetRemoteTOD_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetRemoteTOD_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETREMOTETOD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetRemoteTOD_r_done, req);

	return req;
}

static void dcerpc_NetRemoteTOD_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetRemoteTOD_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetRemoteTOD_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetRemoteTOD_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetRemoteTOD_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetRemoteTOD *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETREMOTETOD, mem_ctx, r);

	return status;
}

struct dcerpc_NetRemoteTOD_state {
	struct NetRemoteTOD orig;
	struct NetRemoteTOD tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetRemoteTOD_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetRemoteTOD_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char * _server_name /* [in]  */,
					    uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetRemoteTOD_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetRemoteTOD_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetRemoteTOD_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetRemoteTOD_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetRemoteTOD_done, req);
	return req;
}

static void dcerpc_NetRemoteTOD_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetRemoteTOD_state *state = tevent_req_data(
		req, struct dcerpc_NetRemoteTOD_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetRemoteTOD_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetRemoteTOD_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  enum NET_API_STATUS *result)
{
	struct dcerpc_NetRemoteTOD_state *state = tevent_req_data(
		req, struct dcerpc_NetRemoteTOD_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetRemoteTOD(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char * _server_name /* [in]  */,
			     uint8_t **_buffer /* [out] [ref] */,
			     enum NET_API_STATUS *result)
{
	struct NetRemoteTOD r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetRemoteTOD_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShareAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShareAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShareAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareAdd_r_done, req);

	return req;
}

static void dcerpc_NetShareAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShareAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShareAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShareAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREADD, mem_ctx, r);

	return status;
}

struct dcerpc_NetShareAdd_state {
	struct NetShareAdd orig;
	struct NetShareAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareAdd_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in]  */,
					   uint32_t _level /* [in]  */,
					   uint8_t *_buffer /* [in] [ref] */,
					   uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetShareAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetShareAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShareAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareAdd_done, req);
	return req;
}

static void dcerpc_NetShareAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShareAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetShareAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShareAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareAdd_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetShareAdd_state *state = tevent_req_data(
		req, struct dcerpc_NetShareAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareAdd(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in]  */,
			    uint32_t _level /* [in]  */,
			    uint8_t *_buffer /* [in] [ref] */,
			    uint32_t *_parm_err /* [out] [ref] */,
			    enum NET_API_STATUS *result)
{
	struct NetShareAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShareAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShareDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShareDel *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShareDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareDel_r_done, req);

	return req;
}

static void dcerpc_NetShareDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShareDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShareDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShareDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREDEL, mem_ctx, r);

	return status;
}

struct dcerpc_NetShareDel_state {
	struct NetShareDel orig;
	struct NetShareDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareDel_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in]  */,
					   const char * _net_name /* [in]  */,
					   uint32_t _reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetShareDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.net_name = _net_name;
	state->orig.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShareDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareDel_done, req);
	return req;
}

static void dcerpc_NetShareDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShareDel_state *state = tevent_req_data(
		req, struct dcerpc_NetShareDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShareDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareDel_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetShareDel_state *state = tevent_req_data(
		req, struct dcerpc_NetShareDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareDel(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in]  */,
			    const char * _net_name /* [in]  */,
			    uint32_t _reserved /* [in]  */,
			    enum NET_API_STATUS *result)
{
	struct NetShareDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.net_name = _net_name;
	r.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShareDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShareEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShareEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShareEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareEnum_r_done, req);

	return req;
}

static void dcerpc_NetShareEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShareEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShareEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShareEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREENUM, mem_ctx, r);

	return status;
}

struct dcerpc_NetShareEnum_state {
	struct NetShareEnum orig;
	struct NetShareEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareEnum_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char * _server_name /* [in]  */,
					    uint32_t _level /* [in]  */,
					    uint8_t **_buffer /* [out] [ref] */,
					    uint32_t _prefmaxlen /* [in]  */,
					    uint32_t *_entries_read /* [out] [ref] */,
					    uint32_t *_total_entries /* [out] [ref] */,
					    uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetShareEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetShareEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShareEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareEnum_done, req);
	return req;
}

static void dcerpc_NetShareEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShareEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetShareEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShareEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareEnum_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  enum NET_API_STATUS *result)
{
	struct dcerpc_NetShareEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetShareEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareEnum(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char * _server_name /* [in]  */,
			     uint32_t _level /* [in]  */,
			     uint8_t **_buffer /* [out] [ref] */,
			     uint32_t _prefmaxlen /* [in]  */,
			     uint32_t *_entries_read /* [out] [ref] */,
			     uint32_t *_total_entries /* [out] [ref] */,
			     uint32_t *_resume_handle /* [in,out] [ref] */,
			     enum NET_API_STATUS *result)
{
	struct NetShareEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShareEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShareGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShareGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShareGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetShareGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShareGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShareGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShareGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHAREGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetShareGetInfo_state {
	struct NetShareGetInfo orig;
	struct NetShareGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareGetInfo_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _net_name /* [in]  */,
					       uint32_t _level /* [in]  */,
					       uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetShareGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.net_name = _net_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetShareGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShareGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareGetInfo_done, req);
	return req;
}

static void dcerpc_NetShareGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShareGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetShareGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShareGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareGetInfo_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetShareGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetShareGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareGetInfo(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _net_name /* [in]  */,
				uint32_t _level /* [in]  */,
				uint8_t **_buffer /* [out] [ref] */,
				enum NET_API_STATUS *result)
{
	struct NetShareGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.net_name = _net_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShareGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShareSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShareSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShareSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHARESETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareSetInfo_r_done, req);

	return req;
}

static void dcerpc_NetShareSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShareSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShareSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShareSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHARESETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetShareSetInfo_state {
	struct NetShareSetInfo orig;
	struct NetShareSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShareSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShareSetInfo_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _net_name /* [in]  */,
					       uint32_t _level /* [in]  */,
					       uint8_t *_buffer /* [in] [ref] */,
					       uint32_t *_parm_err /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetShareSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShareSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.net_name = _net_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetShareSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShareSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShareSetInfo_done, req);
	return req;
}

static void dcerpc_NetShareSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShareSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetShareSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShareSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_err = *state->tmp.out.parm_err;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShareSetInfo_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetShareSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetShareSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShareSetInfo(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _net_name /* [in]  */,
				uint32_t _level /* [in]  */,
				uint8_t *_buffer /* [in] [ref] */,
				uint32_t *_parm_err /* [out] [ref] */,
				enum NET_API_STATUS *result)
{
	struct NetShareSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.net_name = _net_name;
	r.in.level = _level;
	r.in.buffer = _buffer;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShareSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_err = *r.out.parm_err;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetFileClose_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileClose_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileClose_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetFileClose *r)
{
	struct tevent_req *req;
	struct dcerpc_NetFileClose_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileClose_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILECLOSE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileClose_r_done, req);

	return req;
}

static void dcerpc_NetFileClose_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileClose_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetFileClose_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetFileClose_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileClose_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetFileClose *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILECLOSE, mem_ctx, r);

	return status;
}

struct dcerpc_NetFileClose_state {
	struct NetFileClose orig;
	struct NetFileClose tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileClose_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileClose_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    const char * _server_name /* [in]  */,
					    uint32_t _fileid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetFileClose_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileClose_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.fileid = _fileid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetFileClose_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileClose_done, req);
	return req;
}

static void dcerpc_NetFileClose_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetFileClose_state *state = tevent_req_data(
		req, struct dcerpc_NetFileClose_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetFileClose_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileClose_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  enum NET_API_STATUS *result)
{
	struct dcerpc_NetFileClose_state *state = tevent_req_data(
		req, struct dcerpc_NetFileClose_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileClose(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     const char * _server_name /* [in]  */,
			     uint32_t _fileid /* [in]  */,
			     enum NET_API_STATUS *result)
{
	struct NetFileClose r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.fileid = _fileid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetFileClose_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetFileGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetFileGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_NetFileGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILEGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileGetInfo_r_done, req);

	return req;
}

static void dcerpc_NetFileGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetFileGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetFileGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetFileGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILEGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_NetFileGetInfo_state {
	struct NetFileGetInfo orig;
	struct NetFileGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileGetInfo_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      const char * _server_name /* [in]  */,
					      uint32_t _fileid /* [in]  */,
					      uint32_t _level /* [in]  */,
					      uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetFileGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.fileid = _fileid;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetFileGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetFileGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileGetInfo_done, req);
	return req;
}

static void dcerpc_NetFileGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetFileGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetFileGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetFileGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileGetInfo_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    enum NET_API_STATUS *result)
{
	struct dcerpc_NetFileGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_NetFileGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileGetInfo(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       const char * _server_name /* [in]  */,
			       uint32_t _fileid /* [in]  */,
			       uint32_t _level /* [in]  */,
			       uint8_t **_buffer /* [out] [ref] */,
			       enum NET_API_STATUS *result)
{
	struct NetFileGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.fileid = _fileid;
	r.in.level = _level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetFileGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetFileEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetFileEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_NetFileEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileEnum_r_done, req);

	return req;
}

static void dcerpc_NetFileEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetFileEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetFileEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetFileEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETFILEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_NetFileEnum_state {
	struct NetFileEnum orig;
	struct NetFileEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetFileEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetFileEnum_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char * _server_name /* [in]  */,
					   const char * _base_path /* [in]  */,
					   const char * _user_name /* [in]  */,
					   uint32_t _level /* [in]  */,
					   uint8_t **_buffer /* [out] [ref] */,
					   uint32_t _prefmaxlen /* [in]  */,
					   uint32_t *_entries_read /* [out] [ref] */,
					   uint32_t *_total_entries /* [out] [ref] */,
					   uint32_t *_resume_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NetFileEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetFileEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.base_path = _base_path;
	state->orig.in.user_name = _user_name;
	state->orig.in.level = _level;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NetFileEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetFileEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetFileEnum_done, req);
	return req;
}

static void dcerpc_NetFileEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetFileEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetFileEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetFileEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetFileEnum_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 enum NET_API_STATUS *result)
{
	struct dcerpc_NetFileEnum_state *state = tevent_req_data(
		req, struct dcerpc_NetFileEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetFileEnum(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char * _server_name /* [in]  */,
			    const char * _base_path /* [in]  */,
			    const char * _user_name /* [in]  */,
			    uint32_t _level /* [in]  */,
			    uint8_t **_buffer /* [out] [ref] */,
			    uint32_t _prefmaxlen /* [in]  */,
			    uint32_t *_entries_read /* [out] [ref] */,
			    uint32_t *_total_entries /* [out] [ref] */,
			    uint32_t *_resume_handle /* [in,out] [ref] */,
			    enum NET_API_STATUS *result)
{
	struct NetFileEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.base_path = _base_path;
	r.in.user_name = _user_name;
	r.in.level = _level;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.entries_read = _entries_read;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetFileEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;
	*_entries_read = *r.out.entries_read;
	*_total_entries = *r.out.total_entries;
	*_resume_handle = *r.out.resume_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShutdownInit_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShutdownInit_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShutdownInit_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShutdownInit *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShutdownInit_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShutdownInit_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHUTDOWNINIT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShutdownInit_r_done, req);

	return req;
}

static void dcerpc_NetShutdownInit_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShutdownInit_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShutdownInit_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShutdownInit_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShutdownInit_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShutdownInit *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHUTDOWNINIT, mem_ctx, r);

	return status;
}

struct dcerpc_NetShutdownInit_state {
	struct NetShutdownInit orig;
	struct NetShutdownInit tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShutdownInit_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShutdownInit_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _server_name /* [in]  */,
					       const char * _message /* [in]  */,
					       uint32_t _timeout /* [in]  */,
					       uint8_t _force_apps /* [in]  */,
					       uint8_t _do_reboot /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetShutdownInit_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShutdownInit_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.message = _message;
	state->orig.in.timeout = _timeout;
	state->orig.in.force_apps = _force_apps;
	state->orig.in.do_reboot = _do_reboot;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShutdownInit_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShutdownInit_done, req);
	return req;
}

static void dcerpc_NetShutdownInit_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShutdownInit_state *state = tevent_req_data(
		req, struct dcerpc_NetShutdownInit_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShutdownInit_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShutdownInit_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     enum NET_API_STATUS *result)
{
	struct dcerpc_NetShutdownInit_state *state = tevent_req_data(
		req, struct dcerpc_NetShutdownInit_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShutdownInit(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _server_name /* [in]  */,
				const char * _message /* [in]  */,
				uint32_t _timeout /* [in]  */,
				uint8_t _force_apps /* [in]  */,
				uint8_t _do_reboot /* [in]  */,
				enum NET_API_STATUS *result)
{
	struct NetShutdownInit r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.message = _message;
	r.in.timeout = _timeout;
	r.in.force_apps = _force_apps;
	r.in.do_reboot = _do_reboot;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShutdownInit_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NetShutdownAbort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShutdownAbort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShutdownAbort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NetShutdownAbort *r)
{
	struct tevent_req *req;
	struct dcerpc_NetShutdownAbort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShutdownAbort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHUTDOWNABORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShutdownAbort_r_done, req);

	return req;
}

static void dcerpc_NetShutdownAbort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShutdownAbort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NetShutdownAbort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NetShutdownAbort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShutdownAbort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NetShutdownAbort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_NETSHUTDOWNABORT, mem_ctx, r);

	return status;
}

struct dcerpc_NetShutdownAbort_state {
	struct NetShutdownAbort orig;
	struct NetShutdownAbort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NetShutdownAbort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NetShutdownAbort_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char * _server_name /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_NetShutdownAbort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NetShutdownAbort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NetShutdownAbort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NetShutdownAbort_done, req);
	return req;
}

static void dcerpc_NetShutdownAbort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NetShutdownAbort_state *state = tevent_req_data(
		req, struct dcerpc_NetShutdownAbort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NetShutdownAbort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NetShutdownAbort_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      enum NET_API_STATUS *result)
{
	struct dcerpc_NetShutdownAbort_state *state = tevent_req_data(
		req, struct dcerpc_NetShutdownAbort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NetShutdownAbort(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char * _server_name /* [in]  */,
				 enum NET_API_STATUS *result)
{
	struct NetShutdownAbort r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_NetShutdownAbort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_I_NetLogonControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_I_NetLogonControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_I_NetLogonControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct I_NetLogonControl *r)
{
	struct tevent_req *req;
	struct dcerpc_I_NetLogonControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_I_NetLogonControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_I_NETLOGONCONTROL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_I_NetLogonControl_r_done, req);

	return req;
}

static void dcerpc_I_NetLogonControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_I_NetLogonControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_I_NetLogonControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_I_NetLogonControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_I_NetLogonControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct I_NetLogonControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_I_NETLOGONCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_I_NetLogonControl_state {
	struct I_NetLogonControl orig;
	struct I_NetLogonControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_I_NetLogonControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_I_NetLogonControl_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char * _server_name /* [in]  */,
						 uint32_t _function_code /* [in]  */,
						 uint32_t _query_level /* [in]  */,
						 uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_I_NetLogonControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_I_NetLogonControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.function_code = _function_code;
	state->orig.in.query_level = _query_level;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_I_NetLogonControl_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_I_NetLogonControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_I_NetLogonControl_done, req);
	return req;
}

static void dcerpc_I_NetLogonControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_I_NetLogonControl_state *state = tevent_req_data(
		req, struct dcerpc_I_NetLogonControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_I_NetLogonControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_I_NetLogonControl_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       enum NET_API_STATUS *result)
{
	struct dcerpc_I_NetLogonControl_state *state = tevent_req_data(
		req, struct dcerpc_I_NetLogonControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_I_NetLogonControl(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char * _server_name /* [in]  */,
				  uint32_t _function_code /* [in]  */,
				  uint32_t _query_level /* [in]  */,
				  uint8_t **_buffer /* [out] [ref] */,
				  enum NET_API_STATUS *result)
{
	struct I_NetLogonControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.function_code = _function_code;
	r.in.query_level = _query_level;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_I_NetLogonControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_I_NetLogonControl2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_I_NetLogonControl2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_I_NetLogonControl2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct I_NetLogonControl2 *r)
{
	struct tevent_req *req;
	struct dcerpc_I_NetLogonControl2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_I_NetLogonControl2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_libnetapi,
			NDR_I_NETLOGONCONTROL2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_I_NetLogonControl2_r_done, req);

	return req;
}

static void dcerpc_I_NetLogonControl2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_I_NetLogonControl2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_I_NetLogonControl2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_I_NetLogonControl2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_I_NetLogonControl2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct I_NetLogonControl2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_libnetapi,
			NDR_I_NETLOGONCONTROL2, mem_ctx, r);

	return status;
}

struct dcerpc_I_NetLogonControl2_state {
	struct I_NetLogonControl2 orig;
	struct I_NetLogonControl2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_I_NetLogonControl2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_I_NetLogonControl2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char * _server_name /* [in]  */,
						  uint32_t _function_code /* [in]  */,
						  uint32_t _query_level /* [in]  */,
						  uint8_t *_data /* [in] [unique] */,
						  uint8_t **_buffer /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_I_NetLogonControl2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_I_NetLogonControl2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.function_code = _function_code;
	state->orig.in.query_level = _query_level;
	state->orig.in.data = _data;

	/* Out parameters */
	state->orig.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_I_NetLogonControl2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_I_NetLogonControl2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_I_NetLogonControl2_done, req);
	return req;
}

static void dcerpc_I_NetLogonControl2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_I_NetLogonControl2_state *state = tevent_req_data(
		req, struct dcerpc_I_NetLogonControl2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_I_NetLogonControl2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.buffer = *state->tmp.out.buffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_I_NetLogonControl2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					enum NET_API_STATUS *result)
{
	struct dcerpc_I_NetLogonControl2_state *state = tevent_req_data(
		req, struct dcerpc_I_NetLogonControl2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_I_NetLogonControl2(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char * _server_name /* [in]  */,
				   uint32_t _function_code /* [in]  */,
				   uint32_t _query_level /* [in]  */,
				   uint8_t *_data /* [in] [unique] */,
				   uint8_t **_buffer /* [out] [ref] */,
				   enum NET_API_STATUS *result)
{
	struct I_NetLogonControl2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.function_code = _function_code;
	r.in.query_level = _query_level;
	r.in.data = _data;

	/* Out parameters */
	r.out.buffer = _buffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_I_NetLogonControl2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_buffer = *r.out.buffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

