
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_auth.h"
#include "autoconf/librpc/gen_ndr/ndr_auth_c.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/krb5pac.h"
staticforward PyTypeObject auth_user_info_Type;
staticforward PyTypeObject auth_user_info_torture_Type;
staticforward PyTypeObject auth_user_info_unix_Type;
staticforward PyTypeObject auth_user_info_dc_Type;
staticforward PyTypeObject auth_session_info_Type;
staticforward PyTypeObject auth_session_info_transport_Type;

void initauth(void);static PyTypeObject *security_token_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *security_unix_token_Type;
#include "librpc/ndr/py_auth.c"


static PyObject *py_auth_user_info_get_account_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_auth_user_info_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		if (PyUnicode_Check(value)) {
			object->account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->account_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_domain_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_auth_user_info_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		if (PyUnicode_Check(value)) {
			object->domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->domain_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_full_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	if (object->full_name == NULL) {
		py_full_name = Py_None;
		Py_INCREF(py_full_name);
	} else {
		if (object->full_name == NULL) {
			py_full_name = Py_None;
			Py_INCREF(py_full_name);
		} else {
			py_full_name = PyUnicode_Decode(object->full_name, strlen(object->full_name), "utf-8", "ignore");
		}
	}
	return py_full_name;
}

static int py_auth_user_info_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->full_name = NULL;
	} else {
		object->full_name = NULL;
		if (PyUnicode_Check(value)) {
			object->full_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->full_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_script(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	if (object->logon_script == NULL) {
		py_logon_script = Py_None;
		Py_INCREF(py_logon_script);
	} else {
		if (object->logon_script == NULL) {
			py_logon_script = Py_None;
			Py_INCREF(py_logon_script);
		} else {
			py_logon_script = PyUnicode_Decode(object->logon_script, strlen(object->logon_script), "utf-8", "ignore");
		}
	}
	return py_logon_script;
}

static int py_auth_user_info_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->logon_script = NULL;
	} else {
		object->logon_script = NULL;
		if (PyUnicode_Check(value)) {
			object->logon_script = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->logon_script = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_profile_path(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	if (object->profile_path == NULL) {
		py_profile_path = Py_None;
		Py_INCREF(py_profile_path);
	} else {
		if (object->profile_path == NULL) {
			py_profile_path = Py_None;
			Py_INCREF(py_profile_path);
		} else {
			py_profile_path = PyUnicode_Decode(object->profile_path, strlen(object->profile_path), "utf-8", "ignore");
		}
	}
	return py_profile_path;
}

static int py_auth_user_info_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->profile_path = NULL;
	} else {
		object->profile_path = NULL;
		if (PyUnicode_Check(value)) {
			object->profile_path = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->profile_path = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_home_directory(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	if (object->home_directory == NULL) {
		py_home_directory = Py_None;
		Py_INCREF(py_home_directory);
	} else {
		if (object->home_directory == NULL) {
			py_home_directory = Py_None;
			Py_INCREF(py_home_directory);
		} else {
			py_home_directory = PyUnicode_Decode(object->home_directory, strlen(object->home_directory), "utf-8", "ignore");
		}
	}
	return py_home_directory;
}

static int py_auth_user_info_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->home_directory = NULL;
	} else {
		object->home_directory = NULL;
		if (PyUnicode_Check(value)) {
			object->home_directory = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->home_directory = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_home_drive(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	if (object->home_drive == NULL) {
		py_home_drive = Py_None;
		Py_INCREF(py_home_drive);
	} else {
		if (object->home_drive == NULL) {
			py_home_drive = Py_None;
			Py_INCREF(py_home_drive);
		} else {
			py_home_drive = PyUnicode_Decode(object->home_drive, strlen(object->home_drive), "utf-8", "ignore");
		}
	}
	return py_home_drive;
}

static int py_auth_user_info_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->home_drive = NULL;
	} else {
		object->home_drive = NULL;
		if (PyUnicode_Check(value)) {
			object->home_drive = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->home_drive = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_server(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	if (object->logon_server == NULL) {
		py_logon_server = Py_None;
		Py_INCREF(py_logon_server);
	} else {
		if (object->logon_server == NULL) {
			py_logon_server = Py_None;
			Py_INCREF(py_logon_server);
		} else {
			py_logon_server = PyUnicode_Decode(object->logon_server, strlen(object->logon_server), "utf-8", "ignore");
		}
	}
	return py_logon_server;
}

static int py_auth_user_info_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->logon_server = NULL;
	} else {
		object->logon_server = NULL;
		if (PyUnicode_Check(value)) {
			object->logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->logon_server = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_logon(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromLongLong(object->last_logon);
	return py_last_logon;
}

static int py_auth_user_info_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_logon = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_logon = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_logoff(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_auth_user_info_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_logoff = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_logoff = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_acct_expiry(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_auth_user_info_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->acct_expiry = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->acct_expiry = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_auth_user_info_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_allow_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_auth_user_info_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->allow_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->allow_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_force_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_auth_user_info_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->force_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->force_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_count(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_auth_user_info_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_auth_user_info_get_bad_password_count(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyInt_FromLong(object->bad_password_count);
	return py_bad_password_count;
}

static int py_auth_user_info_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_password_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_auth_user_info_get_acct_flags(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyInt_FromLong(object->acct_flags);
	return py_acct_flags;
}

static int py_auth_user_info_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_auth_user_info_get_authenticated(PyObject *obj, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(obj);
	PyObject *py_authenticated;
	py_authenticated = PyInt_FromLong(object->authenticated);
	return py_authenticated;
}

static int py_auth_user_info_set_authenticated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->authenticated = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_auth_user_info_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_auth_user_info_get_account_name, py_auth_user_info_set_account_name },
	{ discard_const_p(char, "domain_name"), py_auth_user_info_get_domain_name, py_auth_user_info_set_domain_name },
	{ discard_const_p(char, "full_name"), py_auth_user_info_get_full_name, py_auth_user_info_set_full_name },
	{ discard_const_p(char, "logon_script"), py_auth_user_info_get_logon_script, py_auth_user_info_set_logon_script },
	{ discard_const_p(char, "profile_path"), py_auth_user_info_get_profile_path, py_auth_user_info_set_profile_path },
	{ discard_const_p(char, "home_directory"), py_auth_user_info_get_home_directory, py_auth_user_info_set_home_directory },
	{ discard_const_p(char, "home_drive"), py_auth_user_info_get_home_drive, py_auth_user_info_set_home_drive },
	{ discard_const_p(char, "logon_server"), py_auth_user_info_get_logon_server, py_auth_user_info_set_logon_server },
	{ discard_const_p(char, "last_logon"), py_auth_user_info_get_last_logon, py_auth_user_info_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_auth_user_info_get_last_logoff, py_auth_user_info_set_last_logoff },
	{ discard_const_p(char, "acct_expiry"), py_auth_user_info_get_acct_expiry, py_auth_user_info_set_acct_expiry },
	{ discard_const_p(char, "last_password_change"), py_auth_user_info_get_last_password_change, py_auth_user_info_set_last_password_change },
	{ discard_const_p(char, "allow_password_change"), py_auth_user_info_get_allow_password_change, py_auth_user_info_set_allow_password_change },
	{ discard_const_p(char, "force_password_change"), py_auth_user_info_get_force_password_change, py_auth_user_info_set_force_password_change },
	{ discard_const_p(char, "logon_count"), py_auth_user_info_get_logon_count, py_auth_user_info_set_logon_count },
	{ discard_const_p(char, "bad_password_count"), py_auth_user_info_get_bad_password_count, py_auth_user_info_set_bad_password_count },
	{ discard_const_p(char, "acct_flags"), py_auth_user_info_get_acct_flags, py_auth_user_info_set_acct_flags },
	{ discard_const_p(char, "authenticated"), py_auth_user_info_get_authenticated, py_auth_user_info_set_authenticated },
	{ NULL }
};

static PyObject *py_auth_user_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info, type);
}

static PyObject *py_auth_user_info_ndr_pack(PyObject *py_obj)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_user_info);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_user_info_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_ndr_print(PyObject *py_obj)
{
	struct auth_user_info *object = (struct auth_user_info *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info, "auth_user_info", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_user_info_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_user_info_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.user_info",
	.tp_getset = py_auth_user_info_getsetters,
	.tp_methods = py_auth_user_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_user_info_new,
};


static PyObject *py_auth_user_info_torture_get_num_dc_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(obj);
	PyObject *py_num_dc_sids;
	py_num_dc_sids = PyInt_FromLong(object->num_dc_sids);
	return py_num_dc_sids;
}

static int py_auth_user_info_torture_set_num_dc_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_dc_sids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_auth_user_info_torture_get_dc_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(obj);
	PyObject *py_dc_sids;
	py_dc_sids = PyList_New(object->num_dc_sids);
	if (py_dc_sids == NULL) {
		return NULL;
	}
	{
		int dc_sids_cntr_0;
		for (dc_sids_cntr_0 = 0; dc_sids_cntr_0 < object->num_dc_sids; dc_sids_cntr_0++) {
			PyObject *py_dc_sids_0;
			py_dc_sids_0 = pytalloc_reference_ex(dom_sid_Type, object->dc_sids, &object->dc_sids[dc_sids_cntr_0]);
			PyList_SetItem(py_dc_sids, dc_sids_cntr_0, py_dc_sids_0);
		}
	}
	return py_dc_sids;
}

static int py_auth_user_info_torture_set_dc_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dc_sids_cntr_0;
		object->dc_sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dc_sids, PyList_GET_SIZE(value));
		if (!object->dc_sids) { return -1;; }
		talloc_set_name_const(object->dc_sids, "ARRAY: object->dc_sids");
		for (dc_sids_cntr_0 = 0; dc_sids_cntr_0 < PyList_GET_SIZE(value); dc_sids_cntr_0++) {
			PY_CHECK_TYPE(dom_sid_Type, PyList_GET_ITEM(value, dc_sids_cntr_0), return -1;);
			if (talloc_reference(object->dc_sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, dc_sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dc_sids[dc_sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, dc_sids_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_torture_getsetters[] = {
	{ discard_const_p(char, "num_dc_sids"), py_auth_user_info_torture_get_num_dc_sids, py_auth_user_info_torture_set_num_dc_sids },
	{ discard_const_p(char, "dc_sids"), py_auth_user_info_torture_get_dc_sids, py_auth_user_info_torture_set_dc_sids },
	{ NULL }
};

static PyObject *py_auth_user_info_torture_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_torture, type);
}

static PyObject *py_auth_user_info_torture_ndr_pack(PyObject *py_obj)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_torture);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_user_info_torture_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_torture);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_torture);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_torture_ndr_print(PyObject *py_obj)
{
	struct auth_user_info_torture *object = (struct auth_user_info_torture *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_torture, "auth_user_info_torture", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_torture_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_torture_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_user_info_torture_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_user_info_torture_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_torture_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.user_info_torture",
	.tp_getset = py_auth_user_info_torture_getsetters,
	.tp_methods = py_auth_user_info_torture_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_user_info_torture_new,
};


static PyObject *py_auth_user_info_unix_get_unix_name(PyObject *obj, void *closure)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(obj);
	PyObject *py_unix_name;
	if (object->unix_name == NULL) {
		py_unix_name = Py_None;
		Py_INCREF(py_unix_name);
	} else {
		if (object->unix_name == NULL) {
			py_unix_name = Py_None;
			Py_INCREF(py_unix_name);
		} else {
			py_unix_name = PyUnicode_Decode(object->unix_name, strlen(object->unix_name), "utf-8", "ignore");
		}
	}
	return py_unix_name;
}

static int py_auth_user_info_unix_set_unix_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->unix_name = NULL;
	} else {
		object->unix_name = NULL;
		if (PyUnicode_Check(value)) {
			object->unix_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->unix_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_unix_get_sanitized_username(PyObject *obj, void *closure)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(obj);
	PyObject *py_sanitized_username;
	if (object->sanitized_username == NULL) {
		py_sanitized_username = Py_None;
		Py_INCREF(py_sanitized_username);
	} else {
		if (object->sanitized_username == NULL) {
			py_sanitized_username = Py_None;
			Py_INCREF(py_sanitized_username);
		} else {
			py_sanitized_username = PyUnicode_Decode(object->sanitized_username, strlen(object->sanitized_username), "utf-8", "ignore");
		}
	}
	return py_sanitized_username;
}

static int py_auth_user_info_unix_set_sanitized_username(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->sanitized_username = NULL;
	} else {
		object->sanitized_username = NULL;
		if (PyUnicode_Check(value)) {
			object->sanitized_username = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->sanitized_username = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_unix_getsetters[] = {
	{ discard_const_p(char, "unix_name"), py_auth_user_info_unix_get_unix_name, py_auth_user_info_unix_set_unix_name },
	{ discard_const_p(char, "sanitized_username"), py_auth_user_info_unix_get_sanitized_username, py_auth_user_info_unix_set_sanitized_username },
	{ NULL }
};

static PyObject *py_auth_user_info_unix_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_unix, type);
}

static PyObject *py_auth_user_info_unix_ndr_pack(PyObject *py_obj)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_unix);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_user_info_unix_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_unix);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_unix);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_unix_ndr_print(PyObject *py_obj)
{
	struct auth_user_info_unix *object = (struct auth_user_info_unix *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_unix, "auth_user_info_unix", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_unix_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_unix_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_user_info_unix_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_user_info_unix_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_unix_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.user_info_unix",
	.tp_getset = py_auth_user_info_unix_getsetters,
	.tp_methods = py_auth_user_info_unix_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_user_info_unix_new,
};


static PyObject *py_auth_user_info_dc_get_num_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyInt_FromLong(object->num_sids);
	return py_num_sids;
}

static int py_auth_user_info_dc_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_sids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_auth_user_info_dc_get_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->num_sids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < object->num_sids; sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(dom_sid_Type, object->sids, &object->sids[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_auth_user_info_dc_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
		if (!object->sids) { return -1;; }
		talloc_set_name_const(object->sids, "ARRAY: object->sids");
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_GET_SIZE(value); sids_cntr_0++) {
			PY_CHECK_TYPE(dom_sid_Type, PyList_GET_ITEM(value, sids_cntr_0), return -1;);
			if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->sids[sids_cntr_0] = *(struct dom_sid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_dc_get_info(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&auth_user_info_Type, object->info, object->info);
	}
	return py_info;
}

static int py_auth_user_info_dc_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&auth_user_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct auth_user_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_user_info_dc_get_user_session_key(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(obj);
	PyObject *py_user_session_key;
	py_user_session_key = PyString_FromStringAndSize((char *)(object->user_session_key).data, (object->user_session_key).length);
	return py_user_session_key;
}

static int py_auth_user_info_dc_set_user_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	object->user_session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_auth_user_info_dc_get_lm_session_key(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(obj);
	PyObject *py_lm_session_key;
	py_lm_session_key = PyString_FromStringAndSize((char *)(object->lm_session_key).data, (object->lm_session_key).length);
	return py_lm_session_key;
}

static int py_auth_user_info_dc_set_lm_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	object->lm_session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_auth_user_info_dc_getsetters[] = {
	{ discard_const_p(char, "num_sids"), py_auth_user_info_dc_get_num_sids, py_auth_user_info_dc_set_num_sids },
	{ discard_const_p(char, "sids"), py_auth_user_info_dc_get_sids, py_auth_user_info_dc_set_sids },
	{ discard_const_p(char, "info"), py_auth_user_info_dc_get_info, py_auth_user_info_dc_set_info },
	{ discard_const_p(char, "user_session_key"), py_auth_user_info_dc_get_user_session_key, py_auth_user_info_dc_set_user_session_key },
	{ discard_const_p(char, "lm_session_key"), py_auth_user_info_dc_get_lm_session_key, py_auth_user_info_dc_set_lm_session_key },
	{ NULL }
};

static PyObject *py_auth_user_info_dc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_dc, type);
}

static PyObject *py_auth_user_info_dc_ndr_pack(PyObject *py_obj)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_dc);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_user_info_dc_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_dc);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_dc);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_dc_ndr_print(PyObject *py_obj)
{
	struct auth_user_info_dc *object = (struct auth_user_info_dc *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_dc, "auth_user_info_dc", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_dc_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_dc_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_user_info_dc_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_user_info_dc_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_dc_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.user_info_dc",
	.tp_getset = py_auth_user_info_dc_getsetters,
	.tp_methods = py_auth_user_info_dc_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_user_info_dc_new,
};


static PyObject *py_auth_session_info_get_security_token(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_security_token;
	if (object->security_token == NULL) {
		py_security_token = Py_None;
		Py_INCREF(py_security_token);
	} else {
		py_security_token = pytalloc_reference_ex(security_token_Type, object->security_token, object->security_token);
	}
	return py_security_token;
}

static int py_auth_session_info_set_security_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->security_token);
	if (value == Py_None) {
		object->security_token = NULL;
	} else {
		object->security_token = NULL;
		PY_CHECK_TYPE(security_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->security_token = (struct security_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_unix_token(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_unix_token;
	if (object->unix_token == NULL) {
		py_unix_token = Py_None;
		Py_INCREF(py_unix_token);
	} else {
		py_unix_token = pytalloc_reference_ex(security_unix_token_Type, object->unix_token, object->unix_token);
	}
	return py_unix_token;
}

static int py_auth_session_info_set_unix_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->unix_token);
	if (value == Py_None) {
		object->unix_token = NULL;
	} else {
		object->unix_token = NULL;
		PY_CHECK_TYPE(security_unix_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unix_token = (struct security_unix_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_info(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&auth_user_info_Type, object->info, object->info);
	}
	return py_info;
}

static int py_auth_session_info_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&auth_user_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct auth_user_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_unix_info(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_unix_info;
	if (object->unix_info == NULL) {
		py_unix_info = Py_None;
		Py_INCREF(py_unix_info);
	} else {
		py_unix_info = pytalloc_reference_ex(&auth_user_info_unix_Type, object->unix_info, object->unix_info);
	}
	return py_unix_info;
}

static int py_auth_session_info_set_unix_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->unix_info);
	if (value == Py_None) {
		object->unix_info = NULL;
	} else {
		object->unix_info = NULL;
		PY_CHECK_TYPE(&auth_user_info_unix_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unix_info = (struct auth_user_info_unix *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_torture(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_torture;
	if (object->torture == NULL) {
		py_torture = Py_None;
		Py_INCREF(py_torture);
	} else {
		py_torture = pytalloc_reference_ex(&auth_user_info_torture_Type, object->torture, object->torture);
	}
	return py_torture;
}

static int py_auth_session_info_set_torture(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->torture);
	if (value == Py_None) {
		object->torture = NULL;
	} else {
		object->torture = NULL;
		PY_CHECK_TYPE(&auth_user_info_torture_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->torture = (struct auth_user_info_torture *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_session_key(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_session_key;
	py_session_key = PyString_FromStringAndSize((char *)(object->session_key).data, (object->session_key).length);
	return py_session_key;
}

static int py_auth_session_info_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	object->session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_auth_session_info_get_credentials(PyObject *obj, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(obj);
	PyObject *py_credentials;
	if (object->credentials == NULL) {
		py_credentials = Py_None;
		Py_INCREF(py_credentials);
	} else {
		py_credentials = NULL;
	}
	return py_credentials;
}

static int py_auth_session_info_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->credentials);
	if (value == Py_None) {
		object->credentials = NULL;
	} else {
		object->credentials = NULL;
		PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct cli_credentials from Python");
	}
	return 0;
}

static PyGetSetDef py_auth_session_info_getsetters[] = {
	{ discard_const_p(char, "security_token"), py_auth_session_info_get_security_token, py_auth_session_info_set_security_token },
	{ discard_const_p(char, "unix_token"), py_auth_session_info_get_unix_token, py_auth_session_info_set_unix_token },
	{ discard_const_p(char, "info"), py_auth_session_info_get_info, py_auth_session_info_set_info },
	{ discard_const_p(char, "unix_info"), py_auth_session_info_get_unix_info, py_auth_session_info_set_unix_info },
	{ discard_const_p(char, "torture"), py_auth_session_info_get_torture, py_auth_session_info_set_torture },
	{ discard_const_p(char, "session_key"), py_auth_session_info_get_session_key, py_auth_session_info_set_session_key },
	{ discard_const_p(char, "credentials"), py_auth_session_info_get_credentials, py_auth_session_info_set_credentials },
	{ NULL }
};

static PyObject *py_auth_session_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_session_info, type);
}

static PyObject *py_auth_session_info_ndr_pack(PyObject *py_obj)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_session_info);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_session_info_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_session_info_ndr_print(PyObject *py_obj)
{
	struct auth_session_info *object = (struct auth_session_info *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info, "auth_session_info", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_session_info_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_session_info_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_session_info_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_session_info_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_session_info_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.session_info",
	.tp_getset = py_auth_session_info_getsetters,
	.tp_methods = py_auth_session_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_session_info_new,
};


static PyObject *py_auth_session_info_transport_get_session_info(PyObject *obj, void *closure)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(obj);
	PyObject *py_session_info;
	if (object->session_info == NULL) {
		py_session_info = Py_None;
		Py_INCREF(py_session_info);
	} else {
		py_session_info = pytalloc_reference_ex(&auth_session_info_Type, object->session_info, object->session_info);
	}
	return py_session_info;
}

static int py_auth_session_info_transport_set_session_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->session_info);
	if (value == Py_None) {
		object->session_info = NULL;
	} else {
		object->session_info = NULL;
		PY_CHECK_TYPE(&auth_session_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->session_info = (struct auth_session_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_transport_get_exported_gssapi_credentials(PyObject *obj, void *closure)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(obj);
	PyObject *py_exported_gssapi_credentials;
	py_exported_gssapi_credentials = PyString_FromStringAndSize((char *)(object->exported_gssapi_credentials).data, (object->exported_gssapi_credentials).length);
	return py_exported_gssapi_credentials;
}

static int py_auth_session_info_transport_set_exported_gssapi_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(py_obj);
	object->exported_gssapi_credentials = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_auth_session_info_transport_getsetters[] = {
	{ discard_const_p(char, "session_info"), py_auth_session_info_transport_get_session_info, py_auth_session_info_transport_set_session_info },
	{ discard_const_p(char, "exported_gssapi_credentials"), py_auth_session_info_transport_get_exported_gssapi_credentials, py_auth_session_info_transport_set_exported_gssapi_credentials },
	{ NULL }
};

static PyObject *py_auth_session_info_transport_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_session_info_transport, type);
}

static PyObject *py_auth_session_info_transport_ndr_pack(PyObject *py_obj)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_auth_session_info_transport);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_auth_session_info_transport_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info_transport);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info_transport);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_session_info_transport_ndr_print(PyObject *py_obj)
{
	struct auth_session_info_transport *object = (struct auth_session_info_transport *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info_transport, "auth_session_info_transport", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_session_info_transport_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_session_info_transport_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_auth_session_info_transport_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_auth_session_info_transport_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_session_info_transport_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "auth.session_info_transport",
	.tp_getset = py_auth_session_info_transport_getsetters,
	.tp_methods = py_auth_session_info_transport_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_auth_session_info_transport_new,
};

static PyMethodDef auth_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initauth(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_samba_dcerpc_lsa;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_krb5pac;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_krb5pac = PyImport_ImportModule("samba.dcerpc.krb5pac");
	if (dep_samba_dcerpc_krb5pac == NULL)
		return;

	security_token_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "token");
	if (security_token_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	security_unix_token_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "unix_token");
	if (security_unix_token_Type == NULL)
		return;

	auth_user_info_Type.tp_base = Object_Type;

	auth_user_info_torture_Type.tp_base = Object_Type;

	auth_user_info_unix_Type.tp_base = Object_Type;

	auth_user_info_dc_Type.tp_base = Object_Type;

	auth_session_info_Type.tp_base = Object_Type;

	auth_session_info_transport_Type.tp_base = Object_Type;

	if (PyType_Ready(&auth_user_info_Type) < 0)
		return;
	if (PyType_Ready(&auth_user_info_torture_Type) < 0)
		return;
	if (PyType_Ready(&auth_user_info_unix_Type) < 0)
		return;
	if (PyType_Ready(&auth_user_info_dc_Type) < 0)
		return;
	if (PyType_Ready(&auth_session_info_Type) < 0)
		return;
	if (PyType_Ready(&auth_session_info_transport_Type) < 0)
		return;
#ifdef PY_USER_INFO_PATCH
	PY_USER_INFO_PATCH(&auth_user_info_Type);
#endif
#ifdef PY_USER_INFO_TORTURE_PATCH
	PY_USER_INFO_TORTURE_PATCH(&auth_user_info_torture_Type);
#endif
#ifdef PY_USER_INFO_UNIX_PATCH
	PY_USER_INFO_UNIX_PATCH(&auth_user_info_unix_Type);
#endif
#ifdef PY_USER_INFO_DC_PATCH
	PY_USER_INFO_DC_PATCH(&auth_user_info_dc_Type);
#endif
#ifdef PY_SESSION_INFO_PATCH
	PY_SESSION_INFO_PATCH(&auth_session_info_Type);
#endif
#ifdef PY_SESSION_INFO_TRANSPORT_PATCH
	PY_SESSION_INFO_TRANSPORT_PATCH(&auth_session_info_transport_Type);
#endif

	m = Py_InitModule3("auth", auth_methods, "auth DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "SEC_AUTH_METHOD_KERBEROS", PyInt_FromLong(SEC_AUTH_METHOD_KERBEROS));
	PyModule_AddObject(m, "SEC_AUTH_METHOD_UNAUTHENTICATED", PyInt_FromLong(SEC_AUTH_METHOD_UNAUTHENTICATED));
	PyModule_AddObject(m, "SEC_AUTH_METHOD_NTLM", PyInt_FromLong(SEC_AUTH_METHOD_NTLM));
	Py_INCREF((PyObject *)(void *)&auth_user_info_Type);
	PyModule_AddObject(m, "user_info", (PyObject *)(void *)&auth_user_info_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_torture_Type);
	PyModule_AddObject(m, "user_info_torture", (PyObject *)(void *)&auth_user_info_torture_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_unix_Type);
	PyModule_AddObject(m, "user_info_unix", (PyObject *)(void *)&auth_user_info_unix_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_dc_Type);
	PyModule_AddObject(m, "user_info_dc", (PyObject *)(void *)&auth_user_info_dc_Type);
	Py_INCREF((PyObject *)(void *)&auth_session_info_Type);
	PyModule_AddObject(m, "session_info", (PyObject *)(void *)&auth_session_info_Type);
	Py_INCREF((PyObject *)(void *)&auth_session_info_transport_Type);
	PyModule_AddObject(m, "session_info_transport", (PyObject *)(void *)&auth_session_info_transport_Type);
#ifdef PY_MOD_AUTH_PATCH
	PY_MOD_AUTH_PATCH(m);
#endif

}
