
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_schannel.h"
#include "autoconf/librpc/gen_ndr/ndr_schannel_c.h"

#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/nbt.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject netlogon_creds_CredentialState_Type;
staticforward PyTypeObject NL_AUTH_MESSAGE_Type;
staticforward PyTypeObject NL_AUTH_SIGNATURE_Type;
staticforward PyTypeObject NL_AUTH_SHA2_SIGNATURE_Type;

void initschannel(void);static PyTypeObject *netr_Credential_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *Object_Type;

static PyObject *py_netlogon_creds_CredentialState_get_negotiate_flags(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_negotiate_flags;
	py_negotiate_flags = PyInt_FromLong(object->negotiate_flags);
	return py_negotiate_flags;
}

static int py_netlogon_creds_CredentialState_set_negotiate_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->negotiate_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->negotiate_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_session_key(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_session_key;
	py_session_key = PyList_New(16);
	if (py_session_key == NULL) {
		return NULL;
	}
	{
		int session_key_cntr_0;
		for (session_key_cntr_0 = 0; session_key_cntr_0 < 16; session_key_cntr_0++) {
			PyObject *py_session_key_0;
			py_session_key_0 = PyInt_FromLong(object->session_key[session_key_cntr_0]);
			PyList_SetItem(py_session_key, session_key_cntr_0, py_session_key_0);
		}
	}
	return py_session_key;
}

static int py_netlogon_creds_CredentialState_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int session_key_cntr_0;
		for (session_key_cntr_0 = 0; session_key_cntr_0 < PyList_GET_SIZE(value); session_key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, session_key_cntr_0), return -1;);
			object->session_key[session_key_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, session_key_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_sequence(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_sequence;
	py_sequence = PyInt_FromLong(object->sequence);
	return py_sequence;
}

static int py_netlogon_creds_CredentialState_set_sequence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sequence = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_seed(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_seed;
	py_seed = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->seed);
	return py_seed;
}

static int py_netlogon_creds_CredentialState_set_seed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->seed = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_client(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_client;
	py_client = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->client);
	return py_client;
}

static int py_netlogon_creds_CredentialState_set_client(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->client = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_server(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_server;
	py_server = pytalloc_reference_ex(netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->server);
	return py_server;
}

static int py_netlogon_creds_CredentialState_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_secure_channel_type(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_secure_channel_type;
	py_secure_channel_type = PyInt_FromLong(object->secure_channel_type);
	return py_secure_channel_type;
}

static int py_netlogon_creds_CredentialState_set_secure_channel_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->secure_channel_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->secure_channel_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_computer_name(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	if (object->computer_name == NULL) {
		py_computer_name = Py_None;
		Py_INCREF(py_computer_name);
	} else {
		py_computer_name = PyUnicode_Decode(object->computer_name, strlen(object->computer_name), "utf-8", "ignore");
	}
	return py_computer_name;
}

static int py_netlogon_creds_CredentialState_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->computer_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_account_name(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netlogon_creds_CredentialState_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->account_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netlogon_creds_CredentialState_get_sid(PyObject *obj, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netlogon_creds_CredentialState_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netlogon_creds_CredentialState_getsetters[] = {
	{ discard_const_p(char, "negotiate_flags"), py_netlogon_creds_CredentialState_get_negotiate_flags, py_netlogon_creds_CredentialState_set_negotiate_flags },
	{ discard_const_p(char, "session_key"), py_netlogon_creds_CredentialState_get_session_key, py_netlogon_creds_CredentialState_set_session_key },
	{ discard_const_p(char, "sequence"), py_netlogon_creds_CredentialState_get_sequence, py_netlogon_creds_CredentialState_set_sequence },
	{ discard_const_p(char, "seed"), py_netlogon_creds_CredentialState_get_seed, py_netlogon_creds_CredentialState_set_seed },
	{ discard_const_p(char, "client"), py_netlogon_creds_CredentialState_get_client, py_netlogon_creds_CredentialState_set_client },
	{ discard_const_p(char, "server"), py_netlogon_creds_CredentialState_get_server, py_netlogon_creds_CredentialState_set_server },
	{ discard_const_p(char, "secure_channel_type"), py_netlogon_creds_CredentialState_get_secure_channel_type, py_netlogon_creds_CredentialState_set_secure_channel_type },
	{ discard_const_p(char, "computer_name"), py_netlogon_creds_CredentialState_get_computer_name, py_netlogon_creds_CredentialState_set_computer_name },
	{ discard_const_p(char, "account_name"), py_netlogon_creds_CredentialState_get_account_name, py_netlogon_creds_CredentialState_set_account_name },
	{ discard_const_p(char, "sid"), py_netlogon_creds_CredentialState_get_sid, py_netlogon_creds_CredentialState_set_sid },
	{ NULL }
};

static PyObject *py_netlogon_creds_CredentialState_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_creds_CredentialState, type);
}

static PyObject *py_netlogon_creds_CredentialState_ndr_pack(PyObject *py_obj)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netlogon_creds_CredentialState);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netlogon_creds_CredentialState_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_creds_CredentialState);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_creds_CredentialState);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netlogon_creds_CredentialState_ndr_print(PyObject *py_obj)
{
	struct netlogon_creds_CredentialState *object = (struct netlogon_creds_CredentialState *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_creds_CredentialState, "netlogon_creds_CredentialState", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netlogon_creds_CredentialState_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netlogon_creds_CredentialState_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netlogon_creds_CredentialState_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netlogon_creds_CredentialState_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netlogon_creds_CredentialState_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "schannel.netlogon_creds_CredentialState",
	.tp_getset = py_netlogon_creds_CredentialState_getsetters,
	.tp_methods = py_netlogon_creds_CredentialState_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netlogon_creds_CredentialState_new,
};

PyObject *py_import_NL_AUTH_MESSAGE_BUFFER(TALLOC_CTX *mem_ctx, int level, union NL_AUTH_MESSAGE_BUFFER *in)
{
	PyObject *ret;

	switch (level) {
		case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME:
			ret = PyString_FromStringOrNULL(in->a);
			return ret;

		case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME:
			ret = PyString_FromStringOrNULL(in->a);
			return ret;

		case NL_FLAG_UTF8_DNS_DOMAIN_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		case NL_FLAG_UTF8_DNS_HOST_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME:
			ret = PyString_FromStringOrNULL(in->u);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union NL_AUTH_MESSAGE_BUFFER *py_export_NL_AUTH_MESSAGE_BUFFER(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union NL_AUTH_MESSAGE_BUFFER *ret = talloc_zero(mem_ctx, union NL_AUTH_MESSAGE_BUFFER);
	switch (level) {
		case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME:
			ret->a = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME:
			ret->a = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case NL_FLAG_UTF8_DNS_DOMAIN_NAME:
			ret->u = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case NL_FLAG_UTF8_DNS_HOST_NAME:
			ret->u = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME:
			ret->u = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		default:
			break;

	}

	return ret;
}

PyObject *py_import_NL_AUTH_MESSAGE_BUFFER_REPLY(TALLOC_CTX *mem_ctx, int level, union NL_AUTH_MESSAGE_BUFFER_REPLY *in)
{
	PyObject *ret;

	switch (level) {
		case NL_NEGOTIATE_RESPONSE:
			ret = PyInt_FromLong(in->dummy);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union NL_AUTH_MESSAGE_BUFFER_REPLY *py_export_NL_AUTH_MESSAGE_BUFFER_REPLY(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union NL_AUTH_MESSAGE_BUFFER_REPLY *ret = talloc_zero(mem_ctx, union NL_AUTH_MESSAGE_BUFFER_REPLY);
	switch (level) {
		case NL_NEGOTIATE_RESPONSE:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->dummy = PyInt_AsLong(in);
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_NL_AUTH_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyInt_FromLong(object->MessageType);
	return py_MessageType;
}

static int py_NL_AUTH_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->MessageType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->MessageType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_NL_AUTH_MESSAGE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_oem_netbios_domain(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_oem_netbios_domain;
	py_oem_netbios_domain = py_import_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME, &object->oem_netbios_domain);
	if (py_oem_netbios_domain == NULL) {
		return NULL;
	}
	return py_oem_netbios_domain;
}

static int py_NL_AUTH_MESSAGE_set_oem_netbios_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER *oem_netbios_domain_switch_0;
		oem_netbios_domain_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME, value);
		if (oem_netbios_domain_switch_0 == NULL) {
			return -1;
		}
		object->oem_netbios_domain = *oem_netbios_domain_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_oem_netbios_computer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_oem_netbios_computer;
	py_oem_netbios_computer = py_import_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME, &object->oem_netbios_computer);
	if (py_oem_netbios_computer == NULL) {
		return NULL;
	}
	return py_oem_netbios_computer;
}

static int py_NL_AUTH_MESSAGE_set_oem_netbios_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER *oem_netbios_computer_switch_0;
		oem_netbios_computer_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME, value);
		if (oem_netbios_computer_switch_0 == NULL) {
			return -1;
		}
		object->oem_netbios_computer = *oem_netbios_computer_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_dns_domain(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_utf8_dns_domain;
	py_utf8_dns_domain = py_import_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME, &object->utf8_dns_domain);
	if (py_utf8_dns_domain == NULL) {
		return NULL;
	}
	return py_utf8_dns_domain;
}

static int py_NL_AUTH_MESSAGE_set_utf8_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_dns_domain_switch_0;
		utf8_dns_domain_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME, value);
		if (utf8_dns_domain_switch_0 == NULL) {
			return -1;
		}
		object->utf8_dns_domain = *utf8_dns_domain_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_dns_host(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_utf8_dns_host;
	py_utf8_dns_host = py_import_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_DNS_HOST_NAME, &object->utf8_dns_host);
	if (py_utf8_dns_host == NULL) {
		return NULL;
	}
	return py_utf8_dns_host;
}

static int py_NL_AUTH_MESSAGE_set_utf8_dns_host(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_dns_host_switch_0;
		utf8_dns_host_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_DNS_HOST_NAME, value);
		if (utf8_dns_host_switch_0 == NULL) {
			return -1;
		}
		object->utf8_dns_host = *utf8_dns_host_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_utf8_netbios_computer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_utf8_netbios_computer;
	py_utf8_netbios_computer = py_import_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(obj), object->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME, &object->utf8_netbios_computer);
	if (py_utf8_netbios_computer == NULL) {
		return NULL;
	}
	return py_utf8_netbios_computer;
}

static int py_NL_AUTH_MESSAGE_set_utf8_netbios_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER *utf8_netbios_computer_switch_0;
		utf8_netbios_computer_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER(pytalloc_get_mem_ctx(py_obj), object->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME, value);
		if (utf8_netbios_computer_switch_0 == NULL) {
			return -1;
		}
		object->utf8_netbios_computer = *utf8_netbios_computer_switch_0;
	}
	return 0;
}

static PyObject *py_NL_AUTH_MESSAGE_get_Buffer(PyObject *obj, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = py_import_NL_AUTH_MESSAGE_BUFFER_REPLY(pytalloc_get_mem_ctx(obj), object->MessageType & NL_NEGOTIATE_RESPONSE, &object->Buffer);
	if (py_Buffer == NULL) {
		return NULL;
	}
	return py_Buffer;
}

static int py_NL_AUTH_MESSAGE_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	{
		union NL_AUTH_MESSAGE_BUFFER_REPLY *Buffer_switch_0;
		Buffer_switch_0 = py_export_NL_AUTH_MESSAGE_BUFFER_REPLY(pytalloc_get_mem_ctx(py_obj), object->MessageType & NL_NEGOTIATE_RESPONSE, value);
		if (Buffer_switch_0 == NULL) {
			return -1;
		}
		object->Buffer = *Buffer_switch_0;
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_MESSAGE_getsetters[] = {
	{ discard_const_p(char, "MessageType"), py_NL_AUTH_MESSAGE_get_MessageType, py_NL_AUTH_MESSAGE_set_MessageType },
	{ discard_const_p(char, "Flags"), py_NL_AUTH_MESSAGE_get_Flags, py_NL_AUTH_MESSAGE_set_Flags },
	{ discard_const_p(char, "oem_netbios_domain"), py_NL_AUTH_MESSAGE_get_oem_netbios_domain, py_NL_AUTH_MESSAGE_set_oem_netbios_domain },
	{ discard_const_p(char, "oem_netbios_computer"), py_NL_AUTH_MESSAGE_get_oem_netbios_computer, py_NL_AUTH_MESSAGE_set_oem_netbios_computer },
	{ discard_const_p(char, "utf8_dns_domain"), py_NL_AUTH_MESSAGE_get_utf8_dns_domain, py_NL_AUTH_MESSAGE_set_utf8_dns_domain },
	{ discard_const_p(char, "utf8_dns_host"), py_NL_AUTH_MESSAGE_get_utf8_dns_host, py_NL_AUTH_MESSAGE_set_utf8_dns_host },
	{ discard_const_p(char, "utf8_netbios_computer"), py_NL_AUTH_MESSAGE_get_utf8_netbios_computer, py_NL_AUTH_MESSAGE_set_utf8_netbios_computer },
	{ discard_const_p(char, "Buffer"), py_NL_AUTH_MESSAGE_get_Buffer, py_NL_AUTH_MESSAGE_set_Buffer },
	{ NULL }
};

static PyObject *py_NL_AUTH_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_MESSAGE, type);
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_pack(PyObject *py_obj)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_MESSAGE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_MESSAGE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_MESSAGE_ndr_print(PyObject *py_obj)
{
	struct NL_AUTH_MESSAGE *object = (struct NL_AUTH_MESSAGE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_MESSAGE, "NL_AUTH_MESSAGE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_MESSAGE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NL_AUTH_MESSAGE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NL_AUTH_MESSAGE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_MESSAGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "schannel.NL_AUTH_MESSAGE",
	.tp_getset = py_NL_AUTH_MESSAGE_getsetters,
	.tp_methods = py_NL_AUTH_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_AUTH_MESSAGE_new,
};


static PyObject *py_NL_AUTH_SIGNATURE_get_SignatureAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SignatureAlgorithm;
	py_SignatureAlgorithm = PyInt_FromLong(object->SignatureAlgorithm);
	return py_SignatureAlgorithm;
}

static int py_NL_AUTH_SIGNATURE_set_SignatureAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->SignatureAlgorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->SignatureAlgorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_SealAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SealAlgorithm;
	py_SealAlgorithm = PyInt_FromLong(object->SealAlgorithm);
	return py_SealAlgorithm;
}

static int py_NL_AUTH_SIGNATURE_set_SealAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->SealAlgorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->SealAlgorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Pad(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Pad;
	py_Pad = PyInt_FromLong(object->Pad);
	return py_Pad;
}

static int py_NL_AUTH_SIGNATURE_set_Pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_NL_AUTH_SIGNATURE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_SequenceNumber(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SequenceNumber;
	py_SequenceNumber = PyList_New(8);
	if (py_SequenceNumber == NULL) {
		return NULL;
	}
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < 8; SequenceNumber_cntr_0++) {
			PyObject *py_SequenceNumber_0;
			py_SequenceNumber_0 = PyInt_FromLong(object->SequenceNumber[SequenceNumber_cntr_0]);
			PyList_SetItem(py_SequenceNumber, SequenceNumber_cntr_0, py_SequenceNumber_0);
		}
	}
	return py_SequenceNumber;
}

static int py_NL_AUTH_SIGNATURE_set_SequenceNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < PyList_GET_SIZE(value); SequenceNumber_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, SequenceNumber_cntr_0), return -1;);
			object->SequenceNumber[SequenceNumber_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, SequenceNumber_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(8);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < 8; Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyInt_FromLong(object->Checksum[Checksum_cntr_0]);
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NL_AUTH_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_GET_SIZE(value); Checksum_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Checksum_cntr_0), return -1;);
			object->Checksum[Checksum_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Checksum_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SIGNATURE_get_Confounder(PyObject *obj, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Confounder;
	py_Confounder = PyList_New(8);
	if (py_Confounder == NULL) {
		return NULL;
	}
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < 8; Confounder_cntr_0++) {
			PyObject *py_Confounder_0;
			py_Confounder_0 = PyInt_FromLong(object->Confounder[Confounder_cntr_0]);
			PyList_SetItem(py_Confounder, Confounder_cntr_0, py_Confounder_0);
		}
	}
	return py_Confounder;
}

static int py_NL_AUTH_SIGNATURE_set_Confounder(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < PyList_GET_SIZE(value); Confounder_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Confounder_cntr_0), return -1;);
			object->Confounder[Confounder_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Confounder_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_SIGNATURE_getsetters[] = {
	{ discard_const_p(char, "SignatureAlgorithm"), py_NL_AUTH_SIGNATURE_get_SignatureAlgorithm, py_NL_AUTH_SIGNATURE_set_SignatureAlgorithm },
	{ discard_const_p(char, "SealAlgorithm"), py_NL_AUTH_SIGNATURE_get_SealAlgorithm, py_NL_AUTH_SIGNATURE_set_SealAlgorithm },
	{ discard_const_p(char, "Pad"), py_NL_AUTH_SIGNATURE_get_Pad, py_NL_AUTH_SIGNATURE_set_Pad },
	{ discard_const_p(char, "Flags"), py_NL_AUTH_SIGNATURE_get_Flags, py_NL_AUTH_SIGNATURE_set_Flags },
	{ discard_const_p(char, "SequenceNumber"), py_NL_AUTH_SIGNATURE_get_SequenceNumber, py_NL_AUTH_SIGNATURE_set_SequenceNumber },
	{ discard_const_p(char, "Checksum"), py_NL_AUTH_SIGNATURE_get_Checksum, py_NL_AUTH_SIGNATURE_set_Checksum },
	{ discard_const_p(char, "Confounder"), py_NL_AUTH_SIGNATURE_get_Confounder, py_NL_AUTH_SIGNATURE_set_Confounder },
	{ NULL }
};

static PyObject *py_NL_AUTH_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_SIGNATURE, type);
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_pack(PyObject *py_obj)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_SIGNATURE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SIGNATURE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SIGNATURE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_SIGNATURE_ndr_print(PyObject *py_obj)
{
	struct NL_AUTH_SIGNATURE *object = (struct NL_AUTH_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SIGNATURE, "NL_AUTH_SIGNATURE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_SIGNATURE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NL_AUTH_SIGNATURE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NL_AUTH_SIGNATURE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_SIGNATURE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "schannel.NL_AUTH_SIGNATURE",
	.tp_getset = py_NL_AUTH_SIGNATURE_getsetters,
	.tp_methods = py_NL_AUTH_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_AUTH_SIGNATURE_new,
};


static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SignatureAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SignatureAlgorithm;
	py_SignatureAlgorithm = PyInt_FromLong(object->SignatureAlgorithm);
	return py_SignatureAlgorithm;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SignatureAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->SignatureAlgorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->SignatureAlgorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SealAlgorithm(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SealAlgorithm;
	py_SealAlgorithm = PyInt_FromLong(object->SealAlgorithm);
	return py_SealAlgorithm;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SealAlgorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->SealAlgorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->SealAlgorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Pad(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Pad;
	py_Pad = PyInt_FromLong(object->Pad);
	return py_Pad;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Flags(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_SequenceNumber(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_SequenceNumber;
	py_SequenceNumber = PyList_New(8);
	if (py_SequenceNumber == NULL) {
		return NULL;
	}
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < 8; SequenceNumber_cntr_0++) {
			PyObject *py_SequenceNumber_0;
			py_SequenceNumber_0 = PyInt_FromLong(object->SequenceNumber[SequenceNumber_cntr_0]);
			PyList_SetItem(py_SequenceNumber, SequenceNumber_cntr_0, py_SequenceNumber_0);
		}
	}
	return py_SequenceNumber;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_SequenceNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int SequenceNumber_cntr_0;
		for (SequenceNumber_cntr_0 = 0; SequenceNumber_cntr_0 < PyList_GET_SIZE(value); SequenceNumber_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, SequenceNumber_cntr_0), return -1;);
			object->SequenceNumber[SequenceNumber_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, SequenceNumber_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(32);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < 32; Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyInt_FromLong(object->Checksum[Checksum_cntr_0]);
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_GET_SIZE(value); Checksum_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Checksum_cntr_0), return -1;);
			object->Checksum[Checksum_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Checksum_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_get_Confounder(PyObject *obj, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(obj);
	PyObject *py_Confounder;
	py_Confounder = PyList_New(8);
	if (py_Confounder == NULL) {
		return NULL;
	}
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < 8; Confounder_cntr_0++) {
			PyObject *py_Confounder_0;
			py_Confounder_0 = PyInt_FromLong(object->Confounder[Confounder_cntr_0]);
			PyList_SetItem(py_Confounder, Confounder_cntr_0, py_Confounder_0);
		}
	}
	return py_Confounder;
}

static int py_NL_AUTH_SHA2_SIGNATURE_set_Confounder(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Confounder_cntr_0;
		for (Confounder_cntr_0 = 0; Confounder_cntr_0 < PyList_GET_SIZE(value); Confounder_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Confounder_cntr_0), return -1;);
			object->Confounder[Confounder_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Confounder_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_NL_AUTH_SHA2_SIGNATURE_getsetters[] = {
	{ discard_const_p(char, "SignatureAlgorithm"), py_NL_AUTH_SHA2_SIGNATURE_get_SignatureAlgorithm, py_NL_AUTH_SHA2_SIGNATURE_set_SignatureAlgorithm },
	{ discard_const_p(char, "SealAlgorithm"), py_NL_AUTH_SHA2_SIGNATURE_get_SealAlgorithm, py_NL_AUTH_SHA2_SIGNATURE_set_SealAlgorithm },
	{ discard_const_p(char, "Pad"), py_NL_AUTH_SHA2_SIGNATURE_get_Pad, py_NL_AUTH_SHA2_SIGNATURE_set_Pad },
	{ discard_const_p(char, "Flags"), py_NL_AUTH_SHA2_SIGNATURE_get_Flags, py_NL_AUTH_SHA2_SIGNATURE_set_Flags },
	{ discard_const_p(char, "SequenceNumber"), py_NL_AUTH_SHA2_SIGNATURE_get_SequenceNumber, py_NL_AUTH_SHA2_SIGNATURE_set_SequenceNumber },
	{ discard_const_p(char, "Checksum"), py_NL_AUTH_SHA2_SIGNATURE_get_Checksum, py_NL_AUTH_SHA2_SIGNATURE_set_Checksum },
	{ discard_const_p(char, "Confounder"), py_NL_AUTH_SHA2_SIGNATURE_get_Confounder, py_NL_AUTH_SHA2_SIGNATURE_set_Confounder },
	{ NULL }
};

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_AUTH_SHA2_SIGNATURE, type);
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_pack(PyObject *py_obj)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NL_AUTH_SHA2_SIGNATURE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SHA2_SIGNATURE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_AUTH_SHA2_SIGNATURE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_AUTH_SHA2_SIGNATURE_ndr_print(PyObject *py_obj)
{
	struct NL_AUTH_SHA2_SIGNATURE *object = (struct NL_AUTH_SHA2_SIGNATURE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_AUTH_SHA2_SIGNATURE, "NL_AUTH_SHA2_SIGNATURE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_AUTH_SHA2_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_AUTH_SHA2_SIGNATURE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NL_AUTH_SHA2_SIGNATURE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NL_AUTH_SHA2_SIGNATURE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_AUTH_SHA2_SIGNATURE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "schannel.NL_AUTH_SHA2_SIGNATURE",
	.tp_getset = py_NL_AUTH_SHA2_SIGNATURE_getsetters,
	.tp_methods = py_NL_AUTH_SHA2_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_AUTH_SHA2_SIGNATURE_new,
};

static PyMethodDef schannel_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initschannel(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_nbt;
	PyObject *dep_samba_dcerpc_netlogon;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_security;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_nbt = PyImport_ImportModule("samba.dcerpc.nbt");
	if (dep_samba_dcerpc_nbt == NULL)
		return;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	netr_Credential_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_Credential");
	if (netr_Credential_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	netlogon_creds_CredentialState_Type.tp_base = Object_Type;

	NL_AUTH_MESSAGE_Type.tp_base = Object_Type;

	NL_AUTH_SIGNATURE_Type.tp_base = Object_Type;

	NL_AUTH_SHA2_SIGNATURE_Type.tp_base = Object_Type;

	if (PyType_Ready(&netlogon_creds_CredentialState_Type) < 0)
		return;
	if (PyType_Ready(&NL_AUTH_MESSAGE_Type) < 0)
		return;
	if (PyType_Ready(&NL_AUTH_SIGNATURE_Type) < 0)
		return;
	if (PyType_Ready(&NL_AUTH_SHA2_SIGNATURE_Type) < 0)
		return;
#ifdef PY_NETLOGON_CREDS_CREDENTIALSTATE_PATCH
	PY_NETLOGON_CREDS_CREDENTIALSTATE_PATCH(&netlogon_creds_CredentialState_Type);
#endif
#ifdef PY_NL_AUTH_MESSAGE_PATCH
	PY_NL_AUTH_MESSAGE_PATCH(&NL_AUTH_MESSAGE_Type);
#endif
#ifdef PY_NL_AUTH_SIGNATURE_PATCH
	PY_NL_AUTH_SIGNATURE_PATCH(&NL_AUTH_SIGNATURE_Type);
#endif
#ifdef PY_NL_AUTH_SHA2_SIGNATURE_PATCH
	PY_NL_AUTH_SHA2_SIGNATURE_PATCH(&NL_AUTH_SHA2_SIGNATURE_Type);
#endif

	m = Py_InitModule3("schannel", schannel_methods, "schannel DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NL_AUTH_SIGNATURE_SIZE", PyInt_FromLong(0x20));
	PyModule_AddObject(m, "NL_FLAG_UTF8_DNS_HOST_NAME", PyInt_FromLong(NL_FLAG_UTF8_DNS_HOST_NAME));
	PyModule_AddObject(m, "NL_NEGOTIATE_REQUEST", PyInt_FromLong(NL_NEGOTIATE_REQUEST));
	PyModule_AddObject(m, "NL_SIGN_HMAC_MD5", PyInt_FromLong(NL_SIGN_HMAC_MD5));
	PyModule_AddObject(m, "NL_FLAG_OEM_NETBIOS_COMPUTER_NAME", PyInt_FromLong(NL_FLAG_OEM_NETBIOS_COMPUTER_NAME));
	PyModule_AddObject(m, "NL_SEAL_RC4", PyInt_FromLong(NL_SEAL_RC4));
	PyModule_AddObject(m, "NL_SEAL_NONE", PyInt_FromLong(NL_SEAL_NONE));
	PyModule_AddObject(m, "NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME", PyInt_FromLong(NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME));
	PyModule_AddObject(m, "NL_SIGN_HMAC_SHA256", PyInt_FromLong(NL_SIGN_HMAC_SHA256));
	PyModule_AddObject(m, "NL_FLAG_OEM_NETBIOS_DOMAIN_NAME", PyInt_FromLong(NL_FLAG_OEM_NETBIOS_DOMAIN_NAME));
	PyModule_AddObject(m, "NL_FLAG_UTF8_DNS_DOMAIN_NAME", PyInt_FromLong(NL_FLAG_UTF8_DNS_DOMAIN_NAME));
	PyModule_AddObject(m, "NL_NEGOTIATE_RESPONSE", PyInt_FromLong(NL_NEGOTIATE_RESPONSE));
	PyModule_AddObject(m, "NL_SEAL_AES128", PyInt_FromLong(NL_SEAL_AES128));
	Py_INCREF((PyObject *)(void *)&netlogon_creds_CredentialState_Type);
	PyModule_AddObject(m, "netlogon_creds_CredentialState", (PyObject *)(void *)&netlogon_creds_CredentialState_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_MESSAGE_Type);
	PyModule_AddObject(m, "NL_AUTH_MESSAGE", (PyObject *)(void *)&NL_AUTH_MESSAGE_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_SIGNATURE_Type);
	PyModule_AddObject(m, "NL_AUTH_SIGNATURE", (PyObject *)(void *)&NL_AUTH_SIGNATURE_Type);
	Py_INCREF((PyObject *)(void *)&NL_AUTH_SHA2_SIGNATURE_Type);
	PyModule_AddObject(m, "NL_AUTH_SHA2_SIGNATURE", (PyObject *)(void *)&NL_AUTH_SHA2_SIGNATURE_Type);
#ifdef PY_MOD_SCHANNEL_PATCH
	PY_MOD_SCHANNEL_PATCH(m);
#endif

}
