
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_orpc.h"
#include "autoconf/librpc/gen_ndr/ndr_orpc_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject COMVERSION_Type;
staticforward PyTypeObject ORPC_EXTENT_Type;
staticforward PyTypeObject ORPC_EXTENT_ARRAY_Type;
staticforward PyTypeObject ORPCTHIS_Type;
staticforward PyTypeObject ORPCTHAT_Type;
staticforward PyTypeObject STRINGBINDING_Type;
staticforward PyTypeObject STRINGARRAY_Type;
staticforward PyTypeObject DUALSTRINGARRAY_Type;
staticforward PyTypeObject SECURITYBINDING_Type;
staticforward PyTypeObject STDOBJREF_Type;
staticforward PyTypeObject u_standard_Type;
staticforward PyTypeObject u_handler_Type;
staticforward PyTypeObject u_custom_Type;
staticforward PyTypeObject u_null_Type;
staticforward PyTypeObject OBJREF_Type;
staticforward PyTypeObject MInterfacePointer_Type;

void initorpc(void);static PyTypeObject *Object_Type;
static PyTypeObject *GUID_Type;

static PyObject *py_COMVERSION_get_MajorVersion(PyObject *obj, void *closure)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(obj);
	PyObject *py_MajorVersion;
	py_MajorVersion = PyInt_FromLong(object->MajorVersion);
	return py_MajorVersion;
}

static int py_COMVERSION_set_MajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MajorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_COMVERSION_get_MinorVersion(PyObject *obj, void *closure)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(obj);
	PyObject *py_MinorVersion;
	py_MinorVersion = PyInt_FromLong(object->MinorVersion);
	return py_MinorVersion;
}

static int py_COMVERSION_set_MinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MinorVersion = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_COMVERSION_getsetters[] = {
	{ discard_const_p(char, "MajorVersion"), py_COMVERSION_get_MajorVersion, py_COMVERSION_set_MajorVersion },
	{ discard_const_p(char, "MinorVersion"), py_COMVERSION_get_MinorVersion, py_COMVERSION_set_MinorVersion },
	{ NULL }
};

static PyObject *py_COMVERSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct COMVERSION, type);
}

static PyObject *py_COMVERSION_ndr_pack(PyObject *py_obj)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_COMVERSION);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_COMVERSION_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_COMVERSION);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_COMVERSION);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_COMVERSION_ndr_print(PyObject *py_obj)
{
	struct COMVERSION *object = (struct COMVERSION *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_COMVERSION, "COMVERSION", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_COMVERSION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_COMVERSION_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_COMVERSION_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_COMVERSION_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject COMVERSION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.COMVERSION",
	.tp_getset = py_COMVERSION_getsetters,
	.tp_methods = py_COMVERSION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_COMVERSION_new,
};


static PyObject *py_ORPC_EXTENT_get_id(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->id);
	return py_id;
}

static int py_ORPC_EXTENT_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->id = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ORPC_EXTENT_get_size(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_ORPC_EXTENT_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPC_EXTENT_get_data(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(((object->size + 7) & ~7));
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < ((object->size + 7) & ~7); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_ORPC_EXTENT_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1;; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_ORPC_EXTENT_getsetters[] = {
	{ discard_const_p(char, "id"), py_ORPC_EXTENT_get_id, py_ORPC_EXTENT_set_id },
	{ discard_const_p(char, "size"), py_ORPC_EXTENT_get_size, py_ORPC_EXTENT_set_size },
	{ discard_const_p(char, "data"), py_ORPC_EXTENT_get_data, py_ORPC_EXTENT_set_data },
	{ NULL }
};

static PyObject *py_ORPC_EXTENT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ORPC_EXTENT, type);
}

static PyObject *py_ORPC_EXTENT_ndr_pack(PyObject *py_obj)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ORPC_EXTENT);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ORPC_EXTENT_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPC_EXTENT);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPC_EXTENT);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ORPC_EXTENT_ndr_print(PyObject *py_obj)
{
	struct ORPC_EXTENT *object = (struct ORPC_EXTENT *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ORPC_EXTENT, "ORPC_EXTENT", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ORPC_EXTENT_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ORPC_EXTENT_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ORPC_EXTENT_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ORPC_EXTENT_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ORPC_EXTENT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.ORPC_EXTENT",
	.tp_getset = py_ORPC_EXTENT_getsetters,
	.tp_methods = py_ORPC_EXTENT_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ORPC_EXTENT_new,
};


static PyObject *py_ORPC_EXTENT_ARRAY_get_size(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_ORPC_EXTENT_ARRAY_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPC_EXTENT_ARRAY_get_reserved(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_ORPC_EXTENT_ARRAY_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPC_EXTENT_ARRAY_get_extent(PyObject *obj, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_extent;
	if (object->extent == NULL) {
		py_extent = Py_None;
		Py_INCREF(py_extent);
	} else {
		py_extent = PyList_New(((object->size + 1) & ~1));
		if (py_extent == NULL) {
			return NULL;
		}
		{
			int extent_cntr_1;
			for (extent_cntr_1 = 0; extent_cntr_1 < ((object->size + 1) & ~1); extent_cntr_1++) {
				PyObject *py_extent_1;
				if (object->extent[extent_cntr_1] == NULL) {
					py_extent_1 = Py_None;
					Py_INCREF(py_extent_1);
				} else {
					py_extent_1 = pytalloc_reference_ex(&ORPC_EXTENT_Type, object->extent[extent_cntr_1], object->extent[extent_cntr_1]);
				}
				PyList_SetItem(py_extent, extent_cntr_1, py_extent_1);
			}
		}
	}
	return py_extent;
}

static int py_ORPC_EXTENT_ARRAY_set_extent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPC_EXTENT_ARRAY *object = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->extent);
	if (value == Py_None) {
		object->extent = NULL;
	} else {
		object->extent = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int extent_cntr_1;
			object->extent = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->extent, PyList_GET_SIZE(value));
			if (!object->extent) { return -1;; }
			talloc_set_name_const(object->extent, "ARRAY: object->extent");
			for (extent_cntr_1 = 0; extent_cntr_1 < PyList_GET_SIZE(value); extent_cntr_1++) {
				if (PyList_GET_ITEM(value, extent_cntr_1) == Py_None) {
					object->extent[extent_cntr_1] = NULL;
				} else {
					object->extent[extent_cntr_1] = NULL;
					PY_CHECK_TYPE(&ORPC_EXTENT_Type, PyList_GET_ITEM(value, extent_cntr_1), return -1;);
					if (talloc_reference(object->extent, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, extent_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					object->extent[extent_cntr_1] = (struct ORPC_EXTENT *)pytalloc_get_ptr(PyList_GET_ITEM(value, extent_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_ORPC_EXTENT_ARRAY_getsetters[] = {
	{ discard_const_p(char, "size"), py_ORPC_EXTENT_ARRAY_get_size, py_ORPC_EXTENT_ARRAY_set_size },
	{ discard_const_p(char, "reserved"), py_ORPC_EXTENT_ARRAY_get_reserved, py_ORPC_EXTENT_ARRAY_set_reserved },
	{ discard_const_p(char, "extent"), py_ORPC_EXTENT_ARRAY_get_extent, py_ORPC_EXTENT_ARRAY_set_extent },
	{ NULL }
};

static PyObject *py_ORPC_EXTENT_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ORPC_EXTENT_ARRAY, type);
}


static PyTypeObject ORPC_EXTENT_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.ORPC_EXTENT_ARRAY",
	.tp_getset = py_ORPC_EXTENT_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ORPC_EXTENT_ARRAY_new,
};


static PyObject *py_ORPCTHIS_get_version(PyObject *obj, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = pytalloc_reference_ex(&COMVERSION_Type, pytalloc_get_mem_ctx(obj), &object->version);
	return py_version;
}

static int py_ORPCTHIS_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&COMVERSION_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->version = *(struct COMVERSION *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ORPCTHIS_get_flags(PyObject *obj, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_ORPCTHIS_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPCTHIS_get_reserved1(PyObject *obj, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyInt_FromLong(object->reserved1);
	return py_reserved1;
}

static int py_ORPCTHIS_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPCTHIS_get_cid(PyObject *obj, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(obj);
	PyObject *py_cid;
	py_cid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->cid);
	return py_cid;
}

static int py_ORPCTHIS_set_cid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ORPCTHIS_get_extensions(PyObject *obj, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(obj);
	PyObject *py_extensions;
	if (object->extensions == NULL) {
		py_extensions = Py_None;
		Py_INCREF(py_extensions);
	} else {
		py_extensions = pytalloc_reference_ex(&ORPC_EXTENT_ARRAY_Type, object->extensions, object->extensions);
	}
	return py_extensions;
}

static int py_ORPCTHIS_set_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->extensions);
	if (value == Py_None) {
		object->extensions = NULL;
	} else {
		object->extensions = NULL;
		PY_CHECK_TYPE(&ORPC_EXTENT_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->extensions = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_ORPCTHIS_getsetters[] = {
	{ discard_const_p(char, "version"), py_ORPCTHIS_get_version, py_ORPCTHIS_set_version },
	{ discard_const_p(char, "flags"), py_ORPCTHIS_get_flags, py_ORPCTHIS_set_flags },
	{ discard_const_p(char, "reserved1"), py_ORPCTHIS_get_reserved1, py_ORPCTHIS_set_reserved1 },
	{ discard_const_p(char, "cid"), py_ORPCTHIS_get_cid, py_ORPCTHIS_set_cid },
	{ discard_const_p(char, "extensions"), py_ORPCTHIS_get_extensions, py_ORPCTHIS_set_extensions },
	{ NULL }
};

static PyObject *py_ORPCTHIS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ORPCTHIS, type);
}

static PyObject *py_ORPCTHIS_ndr_pack(PyObject *py_obj)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ORPCTHIS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ORPCTHIS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPCTHIS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPCTHIS);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ORPCTHIS_ndr_print(PyObject *py_obj)
{
	struct ORPCTHIS *object = (struct ORPCTHIS *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ORPCTHIS, "ORPCTHIS", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ORPCTHIS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ORPCTHIS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ORPCTHIS_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ORPCTHIS_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ORPCTHIS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.ORPCTHIS",
	.tp_getset = py_ORPCTHIS_getsetters,
	.tp_methods = py_ORPCTHIS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ORPCTHIS_new,
};


static PyObject *py_ORPCTHAT_get_flags(PyObject *obj, void *closure)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_ORPCTHAT_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ORPCTHAT_get_extensions(PyObject *obj, void *closure)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(obj);
	PyObject *py_extensions;
	if (object->extensions == NULL) {
		py_extensions = Py_None;
		Py_INCREF(py_extensions);
	} else {
		py_extensions = pytalloc_reference_ex(&ORPC_EXTENT_ARRAY_Type, object->extensions, object->extensions);
	}
	return py_extensions;
}

static int py_ORPCTHAT_set_extensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->extensions);
	if (value == Py_None) {
		object->extensions = NULL;
	} else {
		object->extensions = NULL;
		PY_CHECK_TYPE(&ORPC_EXTENT_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->extensions = (struct ORPC_EXTENT_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_ORPCTHAT_getsetters[] = {
	{ discard_const_p(char, "flags"), py_ORPCTHAT_get_flags, py_ORPCTHAT_set_flags },
	{ discard_const_p(char, "extensions"), py_ORPCTHAT_get_extensions, py_ORPCTHAT_set_extensions },
	{ NULL }
};

static PyObject *py_ORPCTHAT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ORPCTHAT, type);
}

static PyObject *py_ORPCTHAT_ndr_pack(PyObject *py_obj)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ORPCTHAT);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ORPCTHAT_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPCTHAT);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ORPCTHAT);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ORPCTHAT_ndr_print(PyObject *py_obj)
{
	struct ORPCTHAT *object = (struct ORPCTHAT *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ORPCTHAT, "ORPCTHAT", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ORPCTHAT_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ORPCTHAT_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ORPCTHAT_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ORPCTHAT_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ORPCTHAT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.ORPCTHAT",
	.tp_getset = py_ORPCTHAT_getsetters,
	.tp_methods = py_ORPCTHAT_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ORPCTHAT_new,
};


static PyObject *py_STRINGBINDING_get_wTowerId(PyObject *obj, void *closure)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(obj);
	PyObject *py_wTowerId;
	py_wTowerId = PyInt_FromLong(object->wTowerId);
	return py_wTowerId;
}

static int py_STRINGBINDING_set_wTowerId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wTowerId = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_STRINGBINDING_get_NetworkAddr(PyObject *obj, void *closure)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(obj);
	PyObject *py_NetworkAddr;
	py_NetworkAddr = PyString_FromStringOrNULL(object->NetworkAddr);
	return py_NetworkAddr;
}

static int py_STRINGBINDING_set_NetworkAddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(py_obj);
	object->NetworkAddr = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_STRINGBINDING_getsetters[] = {
	{ discard_const_p(char, "wTowerId"), py_STRINGBINDING_get_wTowerId, py_STRINGBINDING_set_wTowerId },
	{ discard_const_p(char, "NetworkAddr"), py_STRINGBINDING_get_NetworkAddr, py_STRINGBINDING_set_NetworkAddr },
	{ NULL }
};

static PyObject *py_STRINGBINDING_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct STRINGBINDING, type);
}

static PyObject *py_STRINGBINDING_ndr_pack(PyObject *py_obj)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_STRINGBINDING);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_STRINGBINDING_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STRINGBINDING);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STRINGBINDING);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_STRINGBINDING_ndr_print(PyObject *py_obj)
{
	struct STRINGBINDING *object = (struct STRINGBINDING *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_STRINGBINDING, "STRINGBINDING", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_STRINGBINDING_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_STRINGBINDING_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_STRINGBINDING_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_STRINGBINDING_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject STRINGBINDING_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.STRINGBINDING",
	.tp_getset = py_STRINGBINDING_getsetters,
	.tp_methods = py_STRINGBINDING_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_STRINGBINDING_new,
};


static PyObject *py_STRINGARRAY_get_stringbindings(PyObject *obj, void *closure)
{
	struct STRINGARRAY *object = (struct STRINGARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_stringbindings;
	if (object->stringbindings == NULL) {
		py_stringbindings = Py_None;
		Py_INCREF(py_stringbindings);
	} else {
		if (*object->stringbindings == NULL) {
			py_stringbindings = Py_None;
			Py_INCREF(py_stringbindings);
		} else {
			py_stringbindings = pytalloc_reference_ex(&STRINGBINDING_Type, *object->stringbindings, *object->stringbindings);
		}
	}
	return py_stringbindings;
}

static int py_STRINGARRAY_set_stringbindings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STRINGARRAY *object = (struct STRINGARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->stringbindings);
	if (value == Py_None) {
		object->stringbindings = NULL;
	} else {
		object->stringbindings = NULL;
		if (value == Py_None) {
			*object->stringbindings = NULL;
		} else {
			*object->stringbindings = NULL;
			PY_CHECK_TYPE(&STRINGBINDING_Type, value, return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->stringbindings = (struct STRINGBINDING *)pytalloc_get_ptr(value);
		}
	}
	return 0;
}

static PyGetSetDef py_STRINGARRAY_getsetters[] = {
	{ discard_const_p(char, "stringbindings"), py_STRINGARRAY_get_stringbindings, py_STRINGARRAY_set_stringbindings },
	{ NULL }
};

static PyObject *py_STRINGARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct STRINGARRAY, type);
}

static PyObject *py_STRINGARRAY_ndr_pack(PyObject *py_obj)
{
	struct STRINGARRAY *object = (struct STRINGARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_STRINGARRAY);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_STRINGARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct STRINGARRAY *object = (struct STRINGARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STRINGARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STRINGARRAY);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_STRINGARRAY_ndr_print(PyObject *py_obj)
{
	struct STRINGARRAY *object = (struct STRINGARRAY *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_STRINGARRAY, "STRINGARRAY", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_STRINGARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_STRINGARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_STRINGARRAY_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_STRINGARRAY_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject STRINGARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.STRINGARRAY",
	.tp_getset = py_STRINGARRAY_getsetters,
	.tp_methods = py_STRINGARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_STRINGARRAY_new,
};


static PyObject *py_DUALSTRINGARRAY_get_stringbindings(PyObject *obj, void *closure)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_stringbindings;
	if (object->stringbindings == NULL) {
		py_stringbindings = Py_None;
		Py_INCREF(py_stringbindings);
	} else {
		if (*object->stringbindings == NULL) {
			py_stringbindings = Py_None;
			Py_INCREF(py_stringbindings);
		} else {
			py_stringbindings = pytalloc_reference_ex(&STRINGBINDING_Type, *object->stringbindings, *object->stringbindings);
		}
	}
	return py_stringbindings;
}

static int py_DUALSTRINGARRAY_set_stringbindings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->stringbindings);
	if (value == Py_None) {
		object->stringbindings = NULL;
	} else {
		object->stringbindings = NULL;
		if (value == Py_None) {
			*object->stringbindings = NULL;
		} else {
			*object->stringbindings = NULL;
			PY_CHECK_TYPE(&STRINGBINDING_Type, value, return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->stringbindings = (struct STRINGBINDING *)pytalloc_get_ptr(value);
		}
	}
	return 0;
}

static PyObject *py_DUALSTRINGARRAY_get_securitybindings(PyObject *obj, void *closure)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_securitybindings;
	if (object->securitybindings == NULL) {
		py_securitybindings = Py_None;
		Py_INCREF(py_securitybindings);
	} else {
		if (*object->securitybindings == NULL) {
			py_securitybindings = Py_None;
			Py_INCREF(py_securitybindings);
		} else {
			py_securitybindings = pytalloc_reference_ex(&SECURITYBINDING_Type, *object->securitybindings, *object->securitybindings);
		}
	}
	return py_securitybindings;
}

static int py_DUALSTRINGARRAY_set_securitybindings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->securitybindings);
	if (value == Py_None) {
		object->securitybindings = NULL;
	} else {
		object->securitybindings = NULL;
		if (value == Py_None) {
			*object->securitybindings = NULL;
		} else {
			*object->securitybindings = NULL;
			PY_CHECK_TYPE(&SECURITYBINDING_Type, value, return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			*object->securitybindings = (struct SECURITYBINDING *)pytalloc_get_ptr(value);
		}
	}
	return 0;
}

static PyGetSetDef py_DUALSTRINGARRAY_getsetters[] = {
	{ discard_const_p(char, "stringbindings"), py_DUALSTRINGARRAY_get_stringbindings, py_DUALSTRINGARRAY_set_stringbindings },
	{ discard_const_p(char, "securitybindings"), py_DUALSTRINGARRAY_get_securitybindings, py_DUALSTRINGARRAY_set_securitybindings },
	{ NULL }
};

static PyObject *py_DUALSTRINGARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DUALSTRINGARRAY, type);
}

static PyObject *py_DUALSTRINGARRAY_ndr_pack(PyObject *py_obj)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DUALSTRINGARRAY);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DUALSTRINGARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DUALSTRINGARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DUALSTRINGARRAY);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DUALSTRINGARRAY_ndr_print(PyObject *py_obj)
{
	struct DUALSTRINGARRAY *object = (struct DUALSTRINGARRAY *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DUALSTRINGARRAY, "DUALSTRINGARRAY", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DUALSTRINGARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DUALSTRINGARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DUALSTRINGARRAY_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DUALSTRINGARRAY_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DUALSTRINGARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.DUALSTRINGARRAY",
	.tp_getset = py_DUALSTRINGARRAY_getsetters,
	.tp_methods = py_DUALSTRINGARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DUALSTRINGARRAY_new,
};


static PyObject *py_SECURITYBINDING_get_wAuthnSvc(PyObject *obj, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(obj);
	PyObject *py_wAuthnSvc;
	py_wAuthnSvc = PyInt_FromLong(object->wAuthnSvc);
	return py_wAuthnSvc;
}

static int py_SECURITYBINDING_set_wAuthnSvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wAuthnSvc = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SECURITYBINDING_get_wAuthzSvc(PyObject *obj, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(obj);
	PyObject *py_wAuthzSvc;
	py_wAuthzSvc = PyInt_FromLong(object->wAuthzSvc);
	return py_wAuthzSvc;
}

static int py_SECURITYBINDING_set_wAuthzSvc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wAuthzSvc = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SECURITYBINDING_get_PrincName(PyObject *obj, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(obj);
	PyObject *py_PrincName;
	py_PrincName = PyString_FromStringOrNULL(object->PrincName);
	return py_PrincName;
}

static int py_SECURITYBINDING_set_PrincName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	object->PrincName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_SECURITYBINDING_getsetters[] = {
	{ discard_const_p(char, "wAuthnSvc"), py_SECURITYBINDING_get_wAuthnSvc, py_SECURITYBINDING_set_wAuthnSvc },
	{ discard_const_p(char, "wAuthzSvc"), py_SECURITYBINDING_get_wAuthzSvc, py_SECURITYBINDING_set_wAuthzSvc },
	{ discard_const_p(char, "PrincName"), py_SECURITYBINDING_get_PrincName, py_SECURITYBINDING_set_PrincName },
	{ NULL }
};

static PyObject *py_SECURITYBINDING_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct SECURITYBINDING, type);
}

static PyObject *py_SECURITYBINDING_ndr_pack(PyObject *py_obj)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_SECURITYBINDING);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_SECURITYBINDING_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SECURITYBINDING);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_SECURITYBINDING);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_SECURITYBINDING_ndr_print(PyObject *py_obj)
{
	struct SECURITYBINDING *object = (struct SECURITYBINDING *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_SECURITYBINDING, "SECURITYBINDING", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_SECURITYBINDING_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SECURITYBINDING_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_SECURITYBINDING_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_SECURITYBINDING_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SECURITYBINDING_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.SECURITYBINDING",
	.tp_getset = py_SECURITYBINDING_getsetters,
	.tp_methods = py_SECURITYBINDING_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_SECURITYBINDING_new,
};


static PyObject *py_STDOBJREF_get_flags(PyObject *obj, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_STDOBJREF_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_STDOBJREF_get_cPublicRefs(PyObject *obj, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_cPublicRefs;
	py_cPublicRefs = PyInt_FromLong(object->cPublicRefs);
	return py_cPublicRefs;
}

static int py_STDOBJREF_set_cPublicRefs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cPublicRefs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_STDOBJREF_get_oxid(PyObject *obj, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_oxid;
	py_oxid = PyLong_FromLongLong(object->oxid);
	return py_oxid;
}

static int py_STDOBJREF_set_oxid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->oxid = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->oxid = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_STDOBJREF_get_oid(PyObject *obj, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_oid;
	py_oid = PyLong_FromLongLong(object->oid);
	return py_oid;
}

static int py_STDOBJREF_set_oid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->oid = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->oid = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_STDOBJREF_get_ipid(PyObject *obj, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_ipid;
	py_ipid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ipid);
	return py_ipid;
}

static int py_STDOBJREF_set_ipid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ipid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_STDOBJREF_getsetters[] = {
	{ discard_const_p(char, "flags"), py_STDOBJREF_get_flags, py_STDOBJREF_set_flags },
	{ discard_const_p(char, "cPublicRefs"), py_STDOBJREF_get_cPublicRefs, py_STDOBJREF_set_cPublicRefs },
	{ discard_const_p(char, "oxid"), py_STDOBJREF_get_oxid, py_STDOBJREF_set_oxid },
	{ discard_const_p(char, "oid"), py_STDOBJREF_get_oid, py_STDOBJREF_set_oid },
	{ discard_const_p(char, "ipid"), py_STDOBJREF_get_ipid, py_STDOBJREF_set_ipid },
	{ NULL }
};

static PyObject *py_STDOBJREF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct STDOBJREF, type);
}

static PyObject *py_STDOBJREF_ndr_pack(PyObject *py_obj)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_STDOBJREF);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_STDOBJREF_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STDOBJREF);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_STDOBJREF);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_STDOBJREF_ndr_print(PyObject *py_obj)
{
	struct STDOBJREF *object = (struct STDOBJREF *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_STDOBJREF, "STDOBJREF", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_STDOBJREF_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_STDOBJREF_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_STDOBJREF_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_STDOBJREF_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject STDOBJREF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.STDOBJREF",
	.tp_getset = py_STDOBJREF_getsetters,
	.tp_methods = py_STDOBJREF_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_STDOBJREF_new,
};


static PyObject *py_u_standard_get_std(PyObject *obj, void *closure)
{
	struct u_standard *object = (struct u_standard *)pytalloc_get_ptr(obj);
	PyObject *py_std;
	py_std = pytalloc_reference_ex(&STDOBJREF_Type, pytalloc_get_mem_ctx(obj), &object->std);
	return py_std;
}

static int py_u_standard_set_std(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_standard *object = (struct u_standard *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&STDOBJREF_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->std = *(struct STDOBJREF *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_u_standard_get_saResAddr(PyObject *obj, void *closure)
{
	struct u_standard *object = (struct u_standard *)pytalloc_get_ptr(obj);
	PyObject *py_saResAddr;
	py_saResAddr = pytalloc_reference_ex(&STRINGARRAY_Type, pytalloc_get_mem_ctx(obj), &object->saResAddr);
	return py_saResAddr;
}

static int py_u_standard_set_saResAddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_standard *object = (struct u_standard *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&STRINGARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->saResAddr = *(struct STRINGARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_u_standard_getsetters[] = {
	{ discard_const_p(char, "std"), py_u_standard_get_std, py_u_standard_set_std },
	{ discard_const_p(char, "saResAddr"), py_u_standard_get_saResAddr, py_u_standard_set_saResAddr },
	{ NULL }
};

static PyObject *py_u_standard_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct u_standard, type);
}


static PyTypeObject u_standard_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.u_standard",
	.tp_getset = py_u_standard_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_u_standard_new,
};


static PyObject *py_u_handler_get_std(PyObject *obj, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(obj);
	PyObject *py_std;
	py_std = pytalloc_reference_ex(&STDOBJREF_Type, pytalloc_get_mem_ctx(obj), &object->std);
	return py_std;
}

static int py_u_handler_set_std(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&STDOBJREF_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->std = *(struct STDOBJREF *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_u_handler_get_clsid(PyObject *obj, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(obj);
	PyObject *py_clsid;
	py_clsid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->clsid);
	return py_clsid;
}

static int py_u_handler_set_clsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->clsid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_u_handler_get_saResAddr(PyObject *obj, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(obj);
	PyObject *py_saResAddr;
	py_saResAddr = pytalloc_reference_ex(&STRINGARRAY_Type, pytalloc_get_mem_ctx(obj), &object->saResAddr);
	return py_saResAddr;
}

static int py_u_handler_set_saResAddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_handler *object = (struct u_handler *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&STRINGARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->saResAddr = *(struct STRINGARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_u_handler_getsetters[] = {
	{ discard_const_p(char, "std"), py_u_handler_get_std, py_u_handler_set_std },
	{ discard_const_p(char, "clsid"), py_u_handler_get_clsid, py_u_handler_set_clsid },
	{ discard_const_p(char, "saResAddr"), py_u_handler_get_saResAddr, py_u_handler_set_saResAddr },
	{ NULL }
};

static PyObject *py_u_handler_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct u_handler, type);
}


static PyTypeObject u_handler_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.u_handler",
	.tp_getset = py_u_handler_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_u_handler_new,
};


static PyObject *py_u_custom_get_clsid(PyObject *obj, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(obj);
	PyObject *py_clsid;
	py_clsid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->clsid);
	return py_clsid;
}

static int py_u_custom_set_clsid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->clsid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_u_custom_get_cbExtension(PyObject *obj, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(obj);
	PyObject *py_cbExtension;
	py_cbExtension = PyInt_FromLong(object->cbExtension);
	return py_cbExtension;
}

static int py_u_custom_set_cbExtension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cbExtension = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_u_custom_get_size(PyObject *obj, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_u_custom_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_u_custom_get_pData(PyObject *obj, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(obj);
	PyObject *py_pData;
	py_pData = PyList_New(object->size);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_0;
		for (pData_cntr_0 = 0; pData_cntr_0 < object->size; pData_cntr_0++) {
			PyObject *py_pData_0;
			py_pData_0 = PyInt_FromLong(object->pData[pData_cntr_0]);
			PyList_SetItem(py_pData, pData_cntr_0, py_pData_0);
		}
	}
	return py_pData;
}

static int py_u_custom_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct u_custom *object = (struct u_custom *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_0;
		object->pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pData, PyList_GET_SIZE(value));
		if (!object->pData) { return -1;; }
		talloc_set_name_const(object->pData, "ARRAY: object->pData");
		for (pData_cntr_0 = 0; pData_cntr_0 < PyList_GET_SIZE(value); pData_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, pData_cntr_0), return -1;);
			object->pData[pData_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, pData_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_u_custom_getsetters[] = {
	{ discard_const_p(char, "clsid"), py_u_custom_get_clsid, py_u_custom_set_clsid },
	{ discard_const_p(char, "cbExtension"), py_u_custom_get_cbExtension, py_u_custom_set_cbExtension },
	{ discard_const_p(char, "size"), py_u_custom_get_size, py_u_custom_set_size },
	{ discard_const_p(char, "pData"), py_u_custom_get_pData, py_u_custom_set_pData },
	{ NULL }
};

static PyObject *py_u_custom_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct u_custom, type);
}


static PyTypeObject u_custom_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.u_custom",
	.tp_getset = py_u_custom_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_u_custom_new,
};


static PyObject *py_u_null_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct u_null, type);
}


static PyTypeObject u_null_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.u_null",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_u_null_new,
};

PyObject *py_import_OBJREF_Types(TALLOC_CTX *mem_ctx, int level, union OBJREF_Types *in)
{
	PyObject *ret;

	switch (level) {
		case OBJREF_NULL:
			ret = pytalloc_reference_ex(&u_null_Type, mem_ctx, &in->u_null);
			return ret;

		case OBJREF_STANDARD:
			ret = pytalloc_reference_ex(&u_standard_Type, mem_ctx, &in->u_standard);
			return ret;

		case OBJREF_HANDLER:
			ret = pytalloc_reference_ex(&u_handler_Type, mem_ctx, &in->u_handler);
			return ret;

		case OBJREF_CUSTOM:
			ret = pytalloc_reference_ex(&u_custom_Type, mem_ctx, &in->u_custom);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union OBJREF_Types *py_export_OBJREF_Types(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union OBJREF_Types *ret = talloc_zero(mem_ctx, union OBJREF_Types);
	switch (level) {
		case OBJREF_NULL:
			PY_CHECK_TYPE(&u_null_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->u_null = *(struct u_null *)pytalloc_get_ptr(in);
			break;

		case OBJREF_STANDARD:
			PY_CHECK_TYPE(&u_standard_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->u_standard = *(struct u_standard *)pytalloc_get_ptr(in);
			break;

		case OBJREF_HANDLER:
			PY_CHECK_TYPE(&u_handler_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->u_handler = *(struct u_handler *)pytalloc_get_ptr(in);
			break;

		case OBJREF_CUSTOM:
			PY_CHECK_TYPE(&u_custom_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->u_custom = *(struct u_custom *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_OBJREF_get_signature(PyObject *obj, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyInt_FromLong(object->signature);
	return py_signature;
}

static int py_OBJREF_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->signature = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_OBJREF_get_flags(PyObject *obj, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_OBJREF_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_OBJREF_get_iid(PyObject *obj, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_iid;
	py_iid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->iid);
	return py_iid;
}

static int py_OBJREF_set_iid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->iid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_OBJREF_get_u_objref(PyObject *obj, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(obj);
	PyObject *py_u_objref;
	py_u_objref = py_import_OBJREF_Types(pytalloc_get_mem_ctx(obj), object->flags, &object->u_objref);
	if (py_u_objref == NULL) {
		return NULL;
	}
	return py_u_objref;
}

static int py_OBJREF_set_u_objref(PyObject *py_obj, PyObject *value, void *closure)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	{
		union OBJREF_Types *u_objref_switch_0;
		u_objref_switch_0 = py_export_OBJREF_Types(pytalloc_get_mem_ctx(py_obj), object->flags, value);
		if (u_objref_switch_0 == NULL) {
			return -1;
		}
		object->u_objref = *u_objref_switch_0;
	}
	return 0;
}

static PyGetSetDef py_OBJREF_getsetters[] = {
	{ discard_const_p(char, "signature"), py_OBJREF_get_signature, py_OBJREF_set_signature },
	{ discard_const_p(char, "flags"), py_OBJREF_get_flags, py_OBJREF_set_flags },
	{ discard_const_p(char, "iid"), py_OBJREF_get_iid, py_OBJREF_set_iid },
	{ discard_const_p(char, "u_objref"), py_OBJREF_get_u_objref, py_OBJREF_set_u_objref },
	{ NULL }
};

static PyObject *py_OBJREF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct OBJREF, type);
}

static PyObject *py_OBJREF_ndr_pack(PyObject *py_obj)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_OBJREF);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_OBJREF_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_OBJREF);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_OBJREF);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_OBJREF_ndr_print(PyObject *py_obj)
{
	struct OBJREF *object = (struct OBJREF *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_OBJREF, "OBJREF", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_OBJREF_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_OBJREF_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_OBJREF_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_OBJREF_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject OBJREF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.OBJREF",
	.tp_getset = py_OBJREF_getsetters,
	.tp_methods = py_OBJREF_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_OBJREF_new,
};


static PyObject *py_MInterfacePointer_get_size(PyObject *obj, void *closure)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_MInterfacePointer_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_MInterfacePointer_get_obj(PyObject *obj, void *closure)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(obj);
	PyObject *py_obj;
	py_obj = pytalloc_reference_ex(&OBJREF_Type, pytalloc_get_mem_ctx(obj), &object->obj);
	return py_obj;
}

static int py_MInterfacePointer_set_obj(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&OBJREF_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->obj = *(struct OBJREF *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_MInterfacePointer_getsetters[] = {
	{ discard_const_p(char, "size"), py_MInterfacePointer_get_size, py_MInterfacePointer_set_size },
	{ discard_const_p(char, "obj"), py_MInterfacePointer_get_obj, py_MInterfacePointer_set_obj },
	{ NULL }
};

static PyObject *py_MInterfacePointer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct MInterfacePointer, type);
}

static PyObject *py_MInterfacePointer_ndr_pack(PyObject *py_obj)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_MInterfacePointer);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_MInterfacePointer_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MInterfacePointer);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_MInterfacePointer);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_MInterfacePointer_ndr_print(PyObject *py_obj)
{
	struct MInterfacePointer *object = (struct MInterfacePointer *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_MInterfacePointer, "MInterfacePointer", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_MInterfacePointer_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_MInterfacePointer_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_MInterfacePointer_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_MInterfacePointer_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject MInterfacePointer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "orpc.MInterfacePointer",
	.tp_getset = py_MInterfacePointer_getsetters,
	.tp_methods = py_MInterfacePointer_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_MInterfacePointer_new,
};

static PyMethodDef orpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initorpc(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_talloc;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	COMVERSION_Type.tp_base = Object_Type;

	ORPC_EXTENT_Type.tp_base = Object_Type;

	ORPC_EXTENT_ARRAY_Type.tp_base = Object_Type;

	ORPCTHIS_Type.tp_base = Object_Type;

	ORPCTHAT_Type.tp_base = Object_Type;

	STRINGBINDING_Type.tp_base = Object_Type;

	STRINGARRAY_Type.tp_base = Object_Type;

	DUALSTRINGARRAY_Type.tp_base = Object_Type;

	SECURITYBINDING_Type.tp_base = Object_Type;

	STDOBJREF_Type.tp_base = Object_Type;

	u_standard_Type.tp_base = Object_Type;

	u_handler_Type.tp_base = Object_Type;

	u_custom_Type.tp_base = Object_Type;

	u_null_Type.tp_base = Object_Type;

	OBJREF_Type.tp_base = Object_Type;

	MInterfacePointer_Type.tp_base = Object_Type;

	if (PyType_Ready(&COMVERSION_Type) < 0)
		return;
	if (PyType_Ready(&ORPC_EXTENT_Type) < 0)
		return;
	if (PyType_Ready(&ORPC_EXTENT_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&ORPCTHIS_Type) < 0)
		return;
	if (PyType_Ready(&ORPCTHAT_Type) < 0)
		return;
	if (PyType_Ready(&STRINGBINDING_Type) < 0)
		return;
	if (PyType_Ready(&STRINGARRAY_Type) < 0)
		return;
	if (PyType_Ready(&DUALSTRINGARRAY_Type) < 0)
		return;
	if (PyType_Ready(&SECURITYBINDING_Type) < 0)
		return;
	if (PyType_Ready(&STDOBJREF_Type) < 0)
		return;
	if (PyType_Ready(&u_standard_Type) < 0)
		return;
	if (PyType_Ready(&u_handler_Type) < 0)
		return;
	if (PyType_Ready(&u_custom_Type) < 0)
		return;
	if (PyType_Ready(&u_null_Type) < 0)
		return;
	if (PyType_Ready(&OBJREF_Type) < 0)
		return;
	if (PyType_Ready(&MInterfacePointer_Type) < 0)
		return;
#ifdef PY_COMVERSION_PATCH
	PY_COMVERSION_PATCH(&COMVERSION_Type);
#endif
#ifdef PY_ORPC_EXTENT_PATCH
	PY_ORPC_EXTENT_PATCH(&ORPC_EXTENT_Type);
#endif
#ifdef PY_ORPC_EXTENT_ARRAY_PATCH
	PY_ORPC_EXTENT_ARRAY_PATCH(&ORPC_EXTENT_ARRAY_Type);
#endif
#ifdef PY_ORPCTHIS_PATCH
	PY_ORPCTHIS_PATCH(&ORPCTHIS_Type);
#endif
#ifdef PY_ORPCTHAT_PATCH
	PY_ORPCTHAT_PATCH(&ORPCTHAT_Type);
#endif
#ifdef PY_STRINGBINDING_PATCH
	PY_STRINGBINDING_PATCH(&STRINGBINDING_Type);
#endif
#ifdef PY_STRINGARRAY_PATCH
	PY_STRINGARRAY_PATCH(&STRINGARRAY_Type);
#endif
#ifdef PY_DUALSTRINGARRAY_PATCH
	PY_DUALSTRINGARRAY_PATCH(&DUALSTRINGARRAY_Type);
#endif
#ifdef PY_SECURITYBINDING_PATCH
	PY_SECURITYBINDING_PATCH(&SECURITYBINDING_Type);
#endif
#ifdef PY_STDOBJREF_PATCH
	PY_STDOBJREF_PATCH(&STDOBJREF_Type);
#endif
#ifdef PY_U_STANDARD_PATCH
	PY_U_STANDARD_PATCH(&u_standard_Type);
#endif
#ifdef PY_U_HANDLER_PATCH
	PY_U_HANDLER_PATCH(&u_handler_Type);
#endif
#ifdef PY_U_CUSTOM_PATCH
	PY_U_CUSTOM_PATCH(&u_custom_Type);
#endif
#ifdef PY_U_NULL_PATCH
	PY_U_NULL_PATCH(&u_null_Type);
#endif
#ifdef PY_OBJREF_PATCH
	PY_OBJREF_PATCH(&OBJREF_Type);
#endif
#ifdef PY_MINTERFACEPOINTER_PATCH
	PY_MINTERFACEPOINTER_PATCH(&MInterfacePointer_Type);
#endif

	m = Py_InitModule3("orpc", orpc_methods, "orpc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "SORF_NULL", PyInt_FromLong(SORF_NULL));
	PyModule_AddObject(m, "dcom_ext_debugging", PyString_FromString("f1f19680-4d2a-11ce-a66a-0020af6e72f4"));
	PyModule_AddObject(m, "COM_INVALIDARG", PyInt_FromLong(COM_INVALIDARG));
	PyModule_AddObject(m, "COM_INVALID_SET", PyInt_FromLong(COM_INVALID_SET));
	PyModule_AddObject(m, "COM_MINOR_VERSION", PyInt_FromLong(1));
	PyModule_AddObject(m, "COM_UNEXPECTED", PyInt_FromLong(COM_UNEXPECTED));
	PyModule_AddObject(m, "COM_INVALID_OID", PyInt_FromLong(COM_INVALID_OID));
	PyModule_AddObject(m, "SORF_OXRES5", PyInt_FromLong(SORF_OXRES5));
	PyModule_AddObject(m, "ORPCF_RESERVED1", PyInt_FromLong(ORPCF_RESERVED1));
	PyModule_AddObject(m, "OBJREF_NULL", PyInt_FromLong(OBJREF_NULL));
	PyModule_AddObject(m, "SORF_OXRES3", PyInt_FromLong(SORF_OXRES3));
	PyModule_AddObject(m, "SORF_OXRES2", PyInt_FromLong(SORF_OXRES2));
	PyModule_AddObject(m, "ORPCF_RESERVED2", PyInt_FromLong(ORPCF_RESERVED2));
	PyModule_AddObject(m, "ORPCF_NULL", PyInt_FromLong(ORPCF_NULL));
	PyModule_AddObject(m, "SORF_OXRES1", PyInt_FromLong(SORF_OXRES1));
	PyModule_AddObject(m, "ORPCF_LOCAL", PyInt_FromLong(ORPCF_LOCAL));
	PyModule_AddObject(m, "ORPCF_RESERVED4", PyInt_FromLong(ORPCF_RESERVED4));
	PyModule_AddObject(m, "SORF_OXRES8", PyInt_FromLong(SORF_OXRES8));
	PyModule_AddObject(m, "COM_MAJOR_VERSION", PyInt_FromLong(5));
	PyModule_AddObject(m, "dcom_ext_extended_error", PyString_FromString("f1f19681-4d2a-11ce-a66a-0020af6e72f4"));
	PyModule_AddObject(m, "COM_C_AUTHZ_NONE", PyInt_FromLong(0xffff));
	PyModule_AddObject(m, "COM_NOINTERFACE", PyInt_FromLong(COM_NOINTERFACE));
	PyModule_AddObject(m, "SORF_NOPING", PyInt_FromLong(SORF_NOPING));
	PyModule_AddObject(m, "COM_INVALID_OXID", PyInt_FromLong(COM_INVALID_OXID));
	PyModule_AddObject(m, "ORPCF_RESERVED3", PyInt_FromLong(ORPCF_RESERVED3));
	PyModule_AddObject(m, "COM_OUTOFMEMORY", PyInt_FromLong(COM_OUTOFMEMORY));
	PyModule_AddObject(m, "OBJREF_CUSTOM", PyInt_FromLong(OBJREF_CUSTOM));
	PyModule_AddObject(m, "SORF_OXRES6", PyInt_FromLong(SORF_OXRES6));
	PyModule_AddObject(m, "OBJREF_SIGNATURE", PyInt_FromLong(0x574f454d));
	PyModule_AddObject(m, "COM_OK", PyInt_FromLong(COM_OK));
	PyModule_AddObject(m, "OBJREF_HANDLER", PyInt_FromLong(OBJREF_HANDLER));
	PyModule_AddObject(m, "OBJREF_STANDARD", PyInt_FromLong(OBJREF_STANDARD));
	PyModule_AddObject(m, "SORF_OXRES4", PyInt_FromLong(SORF_OXRES4));
	PyModule_AddObject(m, "COM_ACCESSDENIED", PyInt_FromLong(COM_ACCESSDENIED));
	PyModule_AddObject(m, "COM_CLSNOTFOUND", PyInt_FromLong(COM_CLSNOTFOUND));
	PyModule_AddObject(m, "SORF_OXRES7", PyInt_FromLong(SORF_OXRES7));
	Py_INCREF((PyObject *)(void *)&COMVERSION_Type);
	PyModule_AddObject(m, "COMVERSION", (PyObject *)(void *)&COMVERSION_Type);
	Py_INCREF((PyObject *)(void *)&ORPC_EXTENT_Type);
	PyModule_AddObject(m, "ORPC_EXTENT", (PyObject *)(void *)&ORPC_EXTENT_Type);
	Py_INCREF((PyObject *)(void *)&ORPC_EXTENT_ARRAY_Type);
	PyModule_AddObject(m, "ORPC_EXTENT_ARRAY", (PyObject *)(void *)&ORPC_EXTENT_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&ORPCTHIS_Type);
	PyModule_AddObject(m, "ORPCTHIS", (PyObject *)(void *)&ORPCTHIS_Type);
	Py_INCREF((PyObject *)(void *)&ORPCTHAT_Type);
	PyModule_AddObject(m, "ORPCTHAT", (PyObject *)(void *)&ORPCTHAT_Type);
	Py_INCREF((PyObject *)(void *)&STRINGBINDING_Type);
	PyModule_AddObject(m, "STRINGBINDING", (PyObject *)(void *)&STRINGBINDING_Type);
	Py_INCREF((PyObject *)(void *)&STRINGARRAY_Type);
	PyModule_AddObject(m, "STRINGARRAY", (PyObject *)(void *)&STRINGARRAY_Type);
	Py_INCREF((PyObject *)(void *)&DUALSTRINGARRAY_Type);
	PyModule_AddObject(m, "DUALSTRINGARRAY", (PyObject *)(void *)&DUALSTRINGARRAY_Type);
	Py_INCREF((PyObject *)(void *)&SECURITYBINDING_Type);
	PyModule_AddObject(m, "SECURITYBINDING", (PyObject *)(void *)&SECURITYBINDING_Type);
	Py_INCREF((PyObject *)(void *)&STDOBJREF_Type);
	PyModule_AddObject(m, "STDOBJREF", (PyObject *)(void *)&STDOBJREF_Type);
	Py_INCREF((PyObject *)(void *)&u_standard_Type);
	PyModule_AddObject(m, "u_standard", (PyObject *)(void *)&u_standard_Type);
	Py_INCREF((PyObject *)(void *)&u_handler_Type);
	PyModule_AddObject(m, "u_handler", (PyObject *)(void *)&u_handler_Type);
	Py_INCREF((PyObject *)(void *)&u_custom_Type);
	PyModule_AddObject(m, "u_custom", (PyObject *)(void *)&u_custom_Type);
	Py_INCREF((PyObject *)(void *)&u_null_Type);
	PyModule_AddObject(m, "u_null", (PyObject *)(void *)&u_null_Type);
	Py_INCREF((PyObject *)(void *)&OBJREF_Type);
	PyModule_AddObject(m, "OBJREF", (PyObject *)(void *)&OBJREF_Type);
	Py_INCREF((PyObject *)(void *)&MInterfacePointer_Type);
	PyModule_AddObject(m, "MInterfacePointer", (PyObject *)(void *)&MInterfacePointer_Type);
#ifdef PY_MOD_ORPC_PATCH
	PY_MOD_ORPC_PATCH(m);
#endif

}
