
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_lsa.h"
#include "autoconf/librpc/gen_ndr/ndr_lsa_c.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject lsa_String_Type;
staticforward PyTypeObject lsa_StringLarge_Type;
staticforward PyTypeObject lsa_Strings_Type;
staticforward PyTypeObject lsa_AsciiString_Type;
staticforward PyTypeObject lsa_AsciiStringLarge_Type;
staticforward PyTypeObject lsa_BinaryString_Type;
staticforward PyTypeObject lsa_LUID_Type;
staticforward PyTypeObject lsa_PrivEntry_Type;
staticforward PyTypeObject lsa_PrivArray_Type;
staticforward PyTypeObject lsa_QosInfo_Type;
staticforward PyTypeObject lsa_ObjectAttribute_Type;
staticforward PyTypeObject lsa_AuditLogInfo_Type;
staticforward PyTypeObject lsa_AuditEventsInfo_Type;
staticforward PyTypeObject lsa_DomainInfo_Type;
staticforward PyTypeObject lsa_PDAccountInfo_Type;
staticforward PyTypeObject lsa_ServerRole_Type;
staticforward PyTypeObject lsa_ReplicaSourceInfo_Type;
staticforward PyTypeObject lsa_DefaultQuotaInfo_Type;
staticforward PyTypeObject lsa_ModificationInfo_Type;
staticforward PyTypeObject lsa_AuditFullSetInfo_Type;
staticforward PyTypeObject lsa_AuditFullQueryInfo_Type;
staticforward PyTypeObject lsa_DnsDomainInfo_Type;
staticforward PyTypeObject lsa_SidPtr_Type;
staticforward PyTypeObject lsa_SidArray_Type;
staticforward PyTypeObject lsa_DomainList_Type;
staticforward PyTypeObject lsa_TranslatedSid_Type;
staticforward PyTypeObject lsa_TransSidArray_Type;
staticforward PyTypeObject lsa_RefDomainList_Type;
staticforward PyTypeObject lsa_TranslatedName_Type;
staticforward PyTypeObject lsa_TransNameArray_Type;
staticforward PyTypeObject lsa_LUIDAttribute_Type;
staticforward PyTypeObject lsa_PrivilegeSet_Type;
staticforward PyTypeObject lsa_DATA_BUF_Type;
staticforward PyTypeObject lsa_DATA_BUF2_Type;
staticforward PyTypeObject lsa_TrustDomainInfoName_Type;
staticforward PyTypeObject lsa_TrustDomainInfoControllers_Type;
staticforward PyTypeObject lsa_TrustDomainInfoPosixOffset_Type;
staticforward PyTypeObject lsa_TrustDomainInfoPassword_Type;
staticforward PyTypeObject lsa_TrustDomainInfoBasic_Type;
staticforward PyTypeObject lsa_TrustDomainInfoInfoEx_Type;
staticforward PyTypeObject lsa_TrustDomainInfoBuffer_Type;
staticforward PyTypeObject lsa_TrustDomainInfoAuthInfo_Type;
staticforward PyTypeObject lsa_TrustDomainInfoFullInfo_Type;
staticforward PyTypeObject lsa_TrustDomainInfoAuthInfoInternal_Type;
staticforward PyTypeObject lsa_TrustDomainInfoFullInfoInternal_Type;
staticforward PyTypeObject lsa_TrustDomainInfoInfoEx2Internal_Type;
staticforward PyTypeObject lsa_TrustDomainInfoFullInfo2Internal_Type;
staticforward PyTypeObject lsa_TrustDomainInfoSupportedEncTypes_Type;
staticforward PyTypeObject lsa_DATA_BUF_PTR_Type;
staticforward PyTypeObject lsa_RightAttribute_Type;
staticforward PyTypeObject lsa_RightSet_Type;
staticforward PyTypeObject lsa_DomainListEx_Type;
staticforward PyTypeObject lsa_DomainInfoKerberos_Type;
staticforward PyTypeObject lsa_DomainInfoEfs_Type;
staticforward PyTypeObject lsa_TranslatedName2_Type;
staticforward PyTypeObject lsa_TransNameArray2_Type;
staticforward PyTypeObject lsa_TranslatedSid2_Type;
staticforward PyTypeObject lsa_TransSidArray2_Type;
staticforward PyTypeObject lsa_TranslatedSid3_Type;
staticforward PyTypeObject lsa_TransSidArray3_Type;
staticforward PyTypeObject lsa_ForestTrustBinaryData_Type;
staticforward PyTypeObject lsa_ForestTrustDomainInfo_Type;
staticforward PyTypeObject lsa_ForestTrustRecord_Type;
staticforward PyTypeObject lsa_ForestTrustInformation_Type;
staticforward PyTypeObject lsa_ForestTrustCollisionRecord_Type;
staticforward PyTypeObject lsa_ForestTrustCollisionInfo_Type;
staticforward PyTypeObject lsarpc_InterfaceType;

void initlsa(void);static PyTypeObject *GUID_Type;
static PyTypeObject *security_descriptor_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *policy_handle_Type;

static PyObject *py_lsa_String_get_length(PyObject *obj, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_String_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_String_get_size(PyObject *obj, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_String_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_String_get_string(PyObject *obj, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_String_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		if (PyUnicode_Check(value)) {
			object->string = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->string = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_String_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_String_get_length, py_lsa_String_set_length },
	{ discard_const_p(char, "size"), py_lsa_String_get_size, py_lsa_String_set_size },
	{ discard_const_p(char, "string"), py_lsa_String_get_string, py_lsa_String_set_string },
	{ NULL }
};

static PyObject *py_lsa_String_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_String, type);
}

static PyObject *py_lsa_String_ndr_pack(PyObject *py_obj)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_String);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_String_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_String);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_String);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_String_ndr_print(PyObject *py_obj)
{
	struct lsa_String *object = (struct lsa_String *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_String, "lsa_String", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_String_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_String_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_String_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_String_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_String_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.String",
	.tp_getset = py_lsa_String_getsetters,
	.tp_methods = py_lsa_String_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_String_new,
};


static PyObject *py_lsa_StringLarge_get_length(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_StringLarge_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_StringLarge_get_size(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_StringLarge_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_StringLarge_get_string(PyObject *obj, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_StringLarge_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		if (PyUnicode_Check(value)) {
			object->string = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->string = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_StringLarge_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_StringLarge_get_length, py_lsa_StringLarge_set_length },
	{ discard_const_p(char, "size"), py_lsa_StringLarge_get_size, py_lsa_StringLarge_set_size },
	{ discard_const_p(char, "string"), py_lsa_StringLarge_get_string, py_lsa_StringLarge_set_string },
	{ NULL }
};

static PyObject *py_lsa_StringLarge_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_StringLarge, type);
}

static PyObject *py_lsa_StringLarge_ndr_pack(PyObject *py_obj)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_StringLarge);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_StringLarge_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_StringLarge);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_StringLarge);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_StringLarge_ndr_print(PyObject *py_obj)
{
	struct lsa_StringLarge *object = (struct lsa_StringLarge *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_StringLarge, "lsa_StringLarge", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_StringLarge_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_StringLarge_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_StringLarge_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_StringLarge_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_StringLarge_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.StringLarge",
	.tp_getset = py_lsa_StringLarge_getsetters,
	.tp_methods = py_lsa_StringLarge_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_StringLarge_new,
};


static PyObject *py_lsa_Strings_get_count(PyObject *obj, void *closure)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_Strings_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_Strings_get_names(PyObject *obj, void *closure)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < object->count; names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_String_Type, object->names, &object->names[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_Strings_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->names);
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1;; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->names[names_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_Strings_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_Strings_get_count, py_lsa_Strings_set_count },
	{ discard_const_p(char, "names"), py_lsa_Strings_get_names, py_lsa_Strings_set_names },
	{ NULL }
};

static PyObject *py_lsa_Strings_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_Strings, type);
}

static PyObject *py_lsa_Strings_ndr_pack(PyObject *py_obj)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_Strings);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_Strings_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_Strings);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_Strings);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_Strings_ndr_print(PyObject *py_obj)
{
	struct lsa_Strings *object = (struct lsa_Strings *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_Strings, "lsa_Strings", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_Strings_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_Strings_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_Strings_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_Strings_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_Strings_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.Strings",
	.tp_getset = py_lsa_Strings_getsetters,
	.tp_methods = py_lsa_Strings_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_Strings_new,
};


static PyObject *py_lsa_AsciiString_get_length(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_AsciiString_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AsciiString_get_size(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_AsciiString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AsciiString_get_string(PyObject *obj, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_AsciiString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		if (PyUnicode_Check(value)) {
			object->string = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->string = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AsciiString_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_AsciiString_get_length, py_lsa_AsciiString_set_length },
	{ discard_const_p(char, "size"), py_lsa_AsciiString_get_size, py_lsa_AsciiString_set_size },
	{ discard_const_p(char, "string"), py_lsa_AsciiString_get_string, py_lsa_AsciiString_set_string },
	{ NULL }
};

static PyObject *py_lsa_AsciiString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AsciiString, type);
}

static PyObject *py_lsa_AsciiString_ndr_pack(PyObject *py_obj)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_AsciiString);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_AsciiString_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiString);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiString);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_AsciiString_ndr_print(PyObject *py_obj)
{
	struct lsa_AsciiString *object = (struct lsa_AsciiString *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_AsciiString, "lsa_AsciiString", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_AsciiString_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_AsciiString_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_AsciiString_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_AsciiString_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_AsciiString_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AsciiString",
	.tp_getset = py_lsa_AsciiString_getsetters,
	.tp_methods = py_lsa_AsciiString_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AsciiString_new,
};


static PyObject *py_lsa_AsciiStringLarge_get_length(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_AsciiStringLarge_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AsciiStringLarge_get_size(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_AsciiStringLarge_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AsciiStringLarge_get_string(PyObject *obj, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_lsa_AsciiStringLarge_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		if (PyUnicode_Check(value)) {
			object->string = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->string = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_AsciiStringLarge_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_AsciiStringLarge_get_length, py_lsa_AsciiStringLarge_set_length },
	{ discard_const_p(char, "size"), py_lsa_AsciiStringLarge_get_size, py_lsa_AsciiStringLarge_set_size },
	{ discard_const_p(char, "string"), py_lsa_AsciiStringLarge_get_string, py_lsa_AsciiStringLarge_set_string },
	{ NULL }
};

static PyObject *py_lsa_AsciiStringLarge_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AsciiStringLarge, type);
}

static PyObject *py_lsa_AsciiStringLarge_ndr_pack(PyObject *py_obj)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_AsciiStringLarge);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_AsciiStringLarge_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiStringLarge);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_AsciiStringLarge);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_AsciiStringLarge_ndr_print(PyObject *py_obj)
{
	struct lsa_AsciiStringLarge *object = (struct lsa_AsciiStringLarge *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_AsciiStringLarge, "lsa_AsciiStringLarge", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_AsciiStringLarge_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_AsciiStringLarge_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_AsciiStringLarge_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_AsciiStringLarge_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_AsciiStringLarge_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AsciiStringLarge",
	.tp_getset = py_lsa_AsciiStringLarge_getsetters,
	.tp_methods = py_lsa_AsciiStringLarge_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AsciiStringLarge_new,
};


static PyObject *py_lsa_BinaryString_get_length(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_BinaryString_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_BinaryString_get_size(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_BinaryString_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_BinaryString_get_array(PyObject *obj, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->length / 2);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < object->length / 2; array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = PyInt_FromLong(object->array[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_lsa_BinaryString_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->array);
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1;; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				object->array[array_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_BinaryString_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_BinaryString_get_length, py_lsa_BinaryString_set_length },
	{ discard_const_p(char, "size"), py_lsa_BinaryString_get_size, py_lsa_BinaryString_set_size },
	{ discard_const_p(char, "array"), py_lsa_BinaryString_get_array, py_lsa_BinaryString_set_array },
	{ NULL }
};

static PyObject *py_lsa_BinaryString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_BinaryString, type);
}

static PyObject *py_lsa_BinaryString_ndr_pack(PyObject *py_obj)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_BinaryString);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_BinaryString_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_BinaryString);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_BinaryString);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_BinaryString_ndr_print(PyObject *py_obj)
{
	struct lsa_BinaryString *object = (struct lsa_BinaryString *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_BinaryString, "lsa_BinaryString", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_BinaryString_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_BinaryString_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_BinaryString_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_BinaryString_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_BinaryString_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.BinaryString",
	.tp_getset = py_lsa_BinaryString_getsetters,
	.tp_methods = py_lsa_BinaryString_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_BinaryString_new,
};


static PyObject *py_lsa_LUID_get_low(PyObject *obj, void *closure)
{
	struct lsa_LUID *object = (struct lsa_LUID *)pytalloc_get_ptr(obj);
	PyObject *py_low;
	py_low = PyInt_FromLong(object->low);
	return py_low;
}

static int py_lsa_LUID_set_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUID *object = (struct lsa_LUID *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_LUID_get_high(PyObject *obj, void *closure)
{
	struct lsa_LUID *object = (struct lsa_LUID *)pytalloc_get_ptr(obj);
	PyObject *py_high;
	py_high = PyInt_FromLong(object->high);
	return py_high;
}

static int py_lsa_LUID_set_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUID *object = (struct lsa_LUID *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->high = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_LUID_getsetters[] = {
	{ discard_const_p(char, "low"), py_lsa_LUID_get_low, py_lsa_LUID_set_low },
	{ discard_const_p(char, "high"), py_lsa_LUID_get_high, py_lsa_LUID_set_high },
	{ NULL }
};

static PyObject *py_lsa_LUID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_LUID, type);
}


static PyTypeObject lsa_LUID_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.LUID",
	.tp_getset = py_lsa_LUID_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_LUID_new,
};


static PyObject *py_lsa_PrivEntry_get_name(PyObject *obj, void *closure)
{
	struct lsa_PrivEntry *object = (struct lsa_PrivEntry *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_PrivEntry_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivEntry *object = (struct lsa_PrivEntry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_PrivEntry_get_luid(PyObject *obj, void *closure)
{
	struct lsa_PrivEntry *object = (struct lsa_PrivEntry *)pytalloc_get_ptr(obj);
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, pytalloc_get_mem_ctx(obj), &object->luid);
	return py_luid;
}

static int py_lsa_PrivEntry_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivEntry *object = (struct lsa_PrivEntry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->luid = *(struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_PrivEntry_getsetters[] = {
	{ discard_const_p(char, "name"), py_lsa_PrivEntry_get_name, py_lsa_PrivEntry_set_name },
	{ discard_const_p(char, "luid"), py_lsa_PrivEntry_get_luid, py_lsa_PrivEntry_set_luid },
	{ NULL }
};

static PyObject *py_lsa_PrivEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivEntry, type);
}


static PyTypeObject lsa_PrivEntry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.PrivEntry",
	.tp_getset = py_lsa_PrivEntry_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_PrivEntry_new,
};


static PyObject *py_lsa_PrivArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_PrivArray *object = (struct lsa_PrivArray *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_PrivArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivArray *object = (struct lsa_PrivArray *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_PrivArray_get_privs(PyObject *obj, void *closure)
{
	struct lsa_PrivArray *object = (struct lsa_PrivArray *)pytalloc_get_ptr(obj);
	PyObject *py_privs;
	if (object->privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = PyList_New(object->count);
		if (py_privs == NULL) {
			return NULL;
		}
		{
			int privs_cntr_1;
			for (privs_cntr_1 = 0; privs_cntr_1 < object->count; privs_cntr_1++) {
				PyObject *py_privs_1;
				py_privs_1 = pytalloc_reference_ex(&lsa_PrivEntry_Type, object->privs, &object->privs[privs_cntr_1]);
				PyList_SetItem(py_privs, privs_cntr_1, py_privs_1);
			}
		}
	}
	return py_privs;
}

static int py_lsa_PrivArray_set_privs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivArray *object = (struct lsa_PrivArray *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->privs);
	if (value == Py_None) {
		object->privs = NULL;
	} else {
		object->privs = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privs_cntr_1;
			object->privs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privs, PyList_GET_SIZE(value));
			if (!object->privs) { return -1;; }
			talloc_set_name_const(object->privs, "ARRAY: object->privs");
			for (privs_cntr_1 = 0; privs_cntr_1 < PyList_GET_SIZE(value); privs_cntr_1++) {
				PY_CHECK_TYPE(&lsa_PrivEntry_Type, PyList_GET_ITEM(value, privs_cntr_1), return -1;);
				if (talloc_reference(object->privs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, privs_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->privs[privs_cntr_1] = *(struct lsa_PrivEntry *)pytalloc_get_ptr(PyList_GET_ITEM(value, privs_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_PrivArray_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_PrivArray_get_count, py_lsa_PrivArray_set_count },
	{ discard_const_p(char, "privs"), py_lsa_PrivArray_get_privs, py_lsa_PrivArray_set_privs },
	{ NULL }
};

static PyObject *py_lsa_PrivArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivArray, type);
}


static PyTypeObject lsa_PrivArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.PrivArray",
	.tp_getset = py_lsa_PrivArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_PrivArray_new,
};


static PyObject *py_lsa_QosInfo_get_len(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_lsa_QosInfo_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_QosInfo_get_impersonation_level(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(obj);
	PyObject *py_impersonation_level;
	py_impersonation_level = PyInt_FromLong(object->impersonation_level);
	return py_impersonation_level;
}

static int py_lsa_QosInfo_set_impersonation_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->impersonation_level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_QosInfo_get_context_mode(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(obj);
	PyObject *py_context_mode;
	py_context_mode = PyInt_FromLong(object->context_mode);
	return py_context_mode;
}

static int py_lsa_QosInfo_set_context_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_mode = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_QosInfo_get_effective_only(PyObject *obj, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(obj);
	PyObject *py_effective_only;
	py_effective_only = PyInt_FromLong(object->effective_only);
	return py_effective_only;
}

static int py_lsa_QosInfo_set_effective_only(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_QosInfo *object = (struct lsa_QosInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->effective_only = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_QosInfo_getsetters[] = {
	{ discard_const_p(char, "len"), py_lsa_QosInfo_get_len, py_lsa_QosInfo_set_len },
	{ discard_const_p(char, "impersonation_level"), py_lsa_QosInfo_get_impersonation_level, py_lsa_QosInfo_set_impersonation_level },
	{ discard_const_p(char, "context_mode"), py_lsa_QosInfo_get_context_mode, py_lsa_QosInfo_set_context_mode },
	{ discard_const_p(char, "effective_only"), py_lsa_QosInfo_get_effective_only, py_lsa_QosInfo_set_effective_only },
	{ NULL }
};

static PyObject *py_lsa_QosInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_QosInfo, type);
}


static PyTypeObject lsa_QosInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.QosInfo",
	.tp_getset = py_lsa_QosInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_QosInfo_new,
};


static PyObject *py_lsa_ObjectAttribute_get_len(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_lsa_ObjectAttribute_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_root_dir(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_root_dir;
	if (object->root_dir == NULL) {
		py_root_dir = Py_None;
		Py_INCREF(py_root_dir);
	} else {
		py_root_dir = PyInt_FromLong(*object->root_dir);
	}
	return py_root_dir;
}

static int py_lsa_ObjectAttribute_set_root_dir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->root_dir);
	if (value == Py_None) {
		object->root_dir = NULL;
	} else {
		object->root_dir = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->root_dir);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->root_dir = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_object_name(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_object_name;
	if (object->object_name == NULL) {
		py_object_name = Py_None;
		Py_INCREF(py_object_name);
	} else {
		if (object->object_name == NULL) {
			py_object_name = Py_None;
			Py_INCREF(py_object_name);
		} else {
			py_object_name = PyUnicode_Decode(object->object_name, strlen(object->object_name), "utf-8", "ignore");
		}
	}
	return py_object_name;
}

static int py_lsa_ObjectAttribute_set_object_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->object_name = NULL;
	} else {
		object->object_name = NULL;
		if (PyUnicode_Check(value)) {
			object->object_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->object_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_attributes(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_lsa_ObjectAttribute_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_sec_desc(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_sec_desc;
	if (object->sec_desc == NULL) {
		py_sec_desc = Py_None;
		Py_INCREF(py_sec_desc);
	} else {
		py_sec_desc = pytalloc_reference_ex(security_descriptor_Type, object->sec_desc, object->sec_desc);
	}
	return py_sec_desc;
}

static int py_lsa_ObjectAttribute_set_sec_desc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sec_desc);
	if (value == Py_None) {
		object->sec_desc = NULL;
	} else {
		object->sec_desc = NULL;
		PY_CHECK_TYPE(security_descriptor_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sec_desc = (struct security_descriptor *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_ObjectAttribute_get_sec_qos(PyObject *obj, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_sec_qos;
	if (object->sec_qos == NULL) {
		py_sec_qos = Py_None;
		Py_INCREF(py_sec_qos);
	} else {
		py_sec_qos = pytalloc_reference_ex(&lsa_QosInfo_Type, object->sec_qos, object->sec_qos);
	}
	return py_sec_qos;
}

static int py_lsa_ObjectAttribute_set_sec_qos(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ObjectAttribute *object = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sec_qos);
	if (value == Py_None) {
		object->sec_qos = NULL;
	} else {
		object->sec_qos = NULL;
		PY_CHECK_TYPE(&lsa_QosInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sec_qos = (struct lsa_QosInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_ObjectAttribute_getsetters[] = {
	{ discard_const_p(char, "len"), py_lsa_ObjectAttribute_get_len, py_lsa_ObjectAttribute_set_len },
	{ discard_const_p(char, "root_dir"), py_lsa_ObjectAttribute_get_root_dir, py_lsa_ObjectAttribute_set_root_dir },
	{ discard_const_p(char, "object_name"), py_lsa_ObjectAttribute_get_object_name, py_lsa_ObjectAttribute_set_object_name },
	{ discard_const_p(char, "attributes"), py_lsa_ObjectAttribute_get_attributes, py_lsa_ObjectAttribute_set_attributes },
	{ discard_const_p(char, "sec_desc"), py_lsa_ObjectAttribute_get_sec_desc, py_lsa_ObjectAttribute_set_sec_desc },
	{ discard_const_p(char, "sec_qos"), py_lsa_ObjectAttribute_get_sec_qos, py_lsa_ObjectAttribute_set_sec_qos },
	{ NULL }
};

static PyObject *py_lsa_ObjectAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ObjectAttribute, type);
}


static PyTypeObject lsa_ObjectAttribute_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ObjectAttribute",
	.tp_getset = py_lsa_ObjectAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ObjectAttribute_new,
};


static PyObject *py_lsa_AuditLogInfo_get_percent_full(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_percent_full;
	py_percent_full = PyInt_FromLong(object->percent_full);
	return py_percent_full;
}

static int py_lsa_AuditLogInfo_set_percent_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->percent_full = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_maximum_log_size(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_maximum_log_size;
	py_maximum_log_size = PyInt_FromLong(object->maximum_log_size);
	return py_maximum_log_size;
}

static int py_lsa_AuditLogInfo_set_maximum_log_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximum_log_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_retention_time(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_retention_time;
	py_retention_time = PyLong_FromLongLong(object->retention_time);
	return py_retention_time;
}

static int py_lsa_AuditLogInfo_set_retention_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->retention_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->retention_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_shutdown_in_progress(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_shutdown_in_progress;
	py_shutdown_in_progress = PyInt_FromLong(object->shutdown_in_progress);
	return py_shutdown_in_progress;
}

static int py_lsa_AuditLogInfo_set_shutdown_in_progress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->shutdown_in_progress = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_time_to_shutdown(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_time_to_shutdown;
	py_time_to_shutdown = PyLong_FromLongLong(object->time_to_shutdown);
	return py_time_to_shutdown;
}

static int py_lsa_AuditLogInfo_set_time_to_shutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->time_to_shutdown = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->time_to_shutdown = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_AuditLogInfo_get_next_audit_record(PyObject *obj, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(obj);
	PyObject *py_next_audit_record;
	py_next_audit_record = PyInt_FromLong(object->next_audit_record);
	return py_next_audit_record;
}

static int py_lsa_AuditLogInfo_set_next_audit_record(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditLogInfo *object = (struct lsa_AuditLogInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->next_audit_record = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_AuditLogInfo_getsetters[] = {
	{ discard_const_p(char, "percent_full"), py_lsa_AuditLogInfo_get_percent_full, py_lsa_AuditLogInfo_set_percent_full },
	{ discard_const_p(char, "maximum_log_size"), py_lsa_AuditLogInfo_get_maximum_log_size, py_lsa_AuditLogInfo_set_maximum_log_size },
	{ discard_const_p(char, "retention_time"), py_lsa_AuditLogInfo_get_retention_time, py_lsa_AuditLogInfo_set_retention_time },
	{ discard_const_p(char, "shutdown_in_progress"), py_lsa_AuditLogInfo_get_shutdown_in_progress, py_lsa_AuditLogInfo_set_shutdown_in_progress },
	{ discard_const_p(char, "time_to_shutdown"), py_lsa_AuditLogInfo_get_time_to_shutdown, py_lsa_AuditLogInfo_set_time_to_shutdown },
	{ discard_const_p(char, "next_audit_record"), py_lsa_AuditLogInfo_get_next_audit_record, py_lsa_AuditLogInfo_set_next_audit_record },
	{ NULL }
};

static PyObject *py_lsa_AuditLogInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditLogInfo, type);
}


static PyTypeObject lsa_AuditLogInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AuditLogInfo",
	.tp_getset = py_lsa_AuditLogInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AuditLogInfo_new,
};


static PyObject *py_lsa_AuditEventsInfo_get_auditing_mode(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(obj);
	PyObject *py_auditing_mode;
	py_auditing_mode = PyInt_FromLong(object->auditing_mode);
	return py_auditing_mode;
}

static int py_lsa_AuditEventsInfo_set_auditing_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auditing_mode = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AuditEventsInfo_get_settings(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(obj);
	PyObject *py_settings;
	if (object->settings == NULL) {
		py_settings = Py_None;
		Py_INCREF(py_settings);
	} else {
		py_settings = PyList_New(object->count);
		if (py_settings == NULL) {
			return NULL;
		}
		{
			int settings_cntr_1;
			for (settings_cntr_1 = 0; settings_cntr_1 < object->count; settings_cntr_1++) {
				PyObject *py_settings_1;
				py_settings_1 = PyInt_FromLong(object->settings[settings_cntr_1]);
				PyList_SetItem(py_settings, settings_cntr_1, py_settings_1);
			}
		}
	}
	return py_settings;
}

static int py_lsa_AuditEventsInfo_set_settings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->settings);
	if (value == Py_None) {
		object->settings = NULL;
	} else {
		object->settings = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int settings_cntr_1;
			object->settings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->settings, PyList_GET_SIZE(value));
			if (!object->settings) { return -1;; }
			talloc_set_name_const(object->settings, "ARRAY: object->settings");
			for (settings_cntr_1 = 0; settings_cntr_1 < PyList_GET_SIZE(value); settings_cntr_1++) {
				if (PyLong_Check(PyList_GET_ITEM(value, settings_cntr_1))) {
					object->settings[settings_cntr_1] = PyLong_AsLongLong(PyList_GET_ITEM(value, settings_cntr_1));
				} else if (PyInt_Check(PyList_GET_ITEM(value, settings_cntr_1))) {
					object->settings[settings_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, settings_cntr_1));
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
					  PyInt_Type.tp_name, PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_AuditEventsInfo_get_count(PyObject *obj, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_AuditEventsInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditEventsInfo *object = (struct lsa_AuditEventsInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_AuditEventsInfo_getsetters[] = {
	{ discard_const_p(char, "auditing_mode"), py_lsa_AuditEventsInfo_get_auditing_mode, py_lsa_AuditEventsInfo_set_auditing_mode },
	{ discard_const_p(char, "settings"), py_lsa_AuditEventsInfo_get_settings, py_lsa_AuditEventsInfo_set_settings },
	{ discard_const_p(char, "count"), py_lsa_AuditEventsInfo_get_count, py_lsa_AuditEventsInfo_set_count },
	{ NULL }
};

static PyObject *py_lsa_AuditEventsInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditEventsInfo, type);
}


static PyTypeObject lsa_AuditEventsInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AuditEventsInfo",
	.tp_getset = py_lsa_AuditEventsInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AuditEventsInfo_new,
};


static PyObject *py_lsa_DomainInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_DomainInfo *object = (struct lsa_DomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_DomainInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfo *object = (struct lsa_DomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DomainInfo_get_sid(PyObject *obj, void *closure)
{
	struct lsa_DomainInfo *object = (struct lsa_DomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_DomainInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfo *object = (struct lsa_DomainInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfo_getsetters[] = {
	{ discard_const_p(char, "name"), py_lsa_DomainInfo_get_name, py_lsa_DomainInfo_set_name },
	{ discard_const_p(char, "sid"), py_lsa_DomainInfo_get_sid, py_lsa_DomainInfo_set_sid },
	{ NULL }
};

static PyObject *py_lsa_DomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfo, type);
}


static PyTypeObject lsa_DomainInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DomainInfo",
	.tp_getset = py_lsa_DomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DomainInfo_new,
};


static PyObject *py_lsa_PDAccountInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_PDAccountInfo *object = (struct lsa_PDAccountInfo *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_PDAccountInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PDAccountInfo *object = (struct lsa_PDAccountInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_PDAccountInfo_getsetters[] = {
	{ discard_const_p(char, "name"), py_lsa_PDAccountInfo_get_name, py_lsa_PDAccountInfo_set_name },
	{ NULL }
};

static PyObject *py_lsa_PDAccountInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PDAccountInfo, type);
}


static PyTypeObject lsa_PDAccountInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.PDAccountInfo",
	.tp_getset = py_lsa_PDAccountInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_PDAccountInfo_new,
};


static PyObject *py_lsa_ServerRole_get_role(PyObject *obj, void *closure)
{
	struct lsa_ServerRole *object = (struct lsa_ServerRole *)pytalloc_get_ptr(obj);
	PyObject *py_role;
	py_role = PyInt_FromLong(object->role);
	return py_role;
}

static int py_lsa_ServerRole_set_role(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ServerRole *object = (struct lsa_ServerRole *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->role = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->role = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_ServerRole_getsetters[] = {
	{ discard_const_p(char, "role"), py_lsa_ServerRole_get_role, py_lsa_ServerRole_set_role },
	{ NULL }
};

static PyObject *py_lsa_ServerRole_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ServerRole, type);
}


static PyTypeObject lsa_ServerRole_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ServerRole",
	.tp_getset = py_lsa_ServerRole_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ServerRole_new,
};


static PyObject *py_lsa_ReplicaSourceInfo_get_source(PyObject *obj, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = (struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(obj);
	PyObject *py_source;
	py_source = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->source);
	return py_source;
}

static int py_lsa_ReplicaSourceInfo_set_source(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = (struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_ReplicaSourceInfo_get_account(PyObject *obj, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = (struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(obj);
	PyObject *py_account;
	py_account = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account);
	return py_account;
}

static int py_lsa_ReplicaSourceInfo_set_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ReplicaSourceInfo *object = (struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ReplicaSourceInfo_getsetters[] = {
	{ discard_const_p(char, "source"), py_lsa_ReplicaSourceInfo_get_source, py_lsa_ReplicaSourceInfo_set_source },
	{ discard_const_p(char, "account"), py_lsa_ReplicaSourceInfo_get_account, py_lsa_ReplicaSourceInfo_set_account },
	{ NULL }
};

static PyObject *py_lsa_ReplicaSourceInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ReplicaSourceInfo, type);
}


static PyTypeObject lsa_ReplicaSourceInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ReplicaSourceInfo",
	.tp_getset = py_lsa_ReplicaSourceInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ReplicaSourceInfo_new,
};


static PyObject *py_lsa_DefaultQuotaInfo_get_paged_pool(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_paged_pool;
	py_paged_pool = PyInt_FromLong(object->paged_pool);
	return py_paged_pool;
}

static int py_lsa_DefaultQuotaInfo_set_paged_pool(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->paged_pool = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_non_paged_pool(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_non_paged_pool;
	py_non_paged_pool = PyInt_FromLong(object->non_paged_pool);
	return py_non_paged_pool;
}

static int py_lsa_DefaultQuotaInfo_set_non_paged_pool(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->non_paged_pool = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_min_wss(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_min_wss;
	py_min_wss = PyInt_FromLong(object->min_wss);
	return py_min_wss;
}

static int py_lsa_DefaultQuotaInfo_set_min_wss(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_wss = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_max_wss(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_max_wss;
	py_max_wss = PyInt_FromLong(object->max_wss);
	return py_max_wss;
}

static int py_lsa_DefaultQuotaInfo_set_max_wss(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_wss = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_pagefile(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_pagefile;
	py_pagefile = PyInt_FromLong(object->pagefile);
	return py_pagefile;
}

static int py_lsa_DefaultQuotaInfo_set_pagefile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pagefile = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DefaultQuotaInfo_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromLongLong(object->unknown);
	return py_unknown;
}

static int py_lsa_DefaultQuotaInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DefaultQuotaInfo *object = (struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->unknown = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->unknown = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_DefaultQuotaInfo_getsetters[] = {
	{ discard_const_p(char, "paged_pool"), py_lsa_DefaultQuotaInfo_get_paged_pool, py_lsa_DefaultQuotaInfo_set_paged_pool },
	{ discard_const_p(char, "non_paged_pool"), py_lsa_DefaultQuotaInfo_get_non_paged_pool, py_lsa_DefaultQuotaInfo_set_non_paged_pool },
	{ discard_const_p(char, "min_wss"), py_lsa_DefaultQuotaInfo_get_min_wss, py_lsa_DefaultQuotaInfo_set_min_wss },
	{ discard_const_p(char, "max_wss"), py_lsa_DefaultQuotaInfo_get_max_wss, py_lsa_DefaultQuotaInfo_set_max_wss },
	{ discard_const_p(char, "pagefile"), py_lsa_DefaultQuotaInfo_get_pagefile, py_lsa_DefaultQuotaInfo_set_pagefile },
	{ discard_const_p(char, "unknown"), py_lsa_DefaultQuotaInfo_get_unknown, py_lsa_DefaultQuotaInfo_set_unknown },
	{ NULL }
};

static PyObject *py_lsa_DefaultQuotaInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DefaultQuotaInfo, type);
}


static PyTypeObject lsa_DefaultQuotaInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DefaultQuotaInfo",
	.tp_getset = py_lsa_DefaultQuotaInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DefaultQuotaInfo_new,
};


static PyObject *py_lsa_ModificationInfo_get_modified_id(PyObject *obj, void *closure)
{
	struct lsa_ModificationInfo *object = (struct lsa_ModificationInfo *)pytalloc_get_ptr(obj);
	PyObject *py_modified_id;
	py_modified_id = PyLong_FromLongLong(object->modified_id);
	return py_modified_id;
}

static int py_lsa_ModificationInfo_set_modified_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ModificationInfo *object = (struct lsa_ModificationInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->modified_id = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->modified_id = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_ModificationInfo_get_db_create_time(PyObject *obj, void *closure)
{
	struct lsa_ModificationInfo *object = (struct lsa_ModificationInfo *)pytalloc_get_ptr(obj);
	PyObject *py_db_create_time;
	py_db_create_time = PyLong_FromLongLong(object->db_create_time);
	return py_db_create_time;
}

static int py_lsa_ModificationInfo_set_db_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ModificationInfo *object = (struct lsa_ModificationInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->db_create_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->db_create_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_ModificationInfo_getsetters[] = {
	{ discard_const_p(char, "modified_id"), py_lsa_ModificationInfo_get_modified_id, py_lsa_ModificationInfo_set_modified_id },
	{ discard_const_p(char, "db_create_time"), py_lsa_ModificationInfo_get_db_create_time, py_lsa_ModificationInfo_set_db_create_time },
	{ NULL }
};

static PyObject *py_lsa_ModificationInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ModificationInfo, type);
}


static PyTypeObject lsa_ModificationInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ModificationInfo",
	.tp_getset = py_lsa_ModificationInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ModificationInfo_new,
};


static PyObject *py_lsa_AuditFullSetInfo_get_shutdown_on_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullSetInfo *object = (struct lsa_AuditFullSetInfo *)pytalloc_get_ptr(obj);
	PyObject *py_shutdown_on_full;
	py_shutdown_on_full = PyInt_FromLong(object->shutdown_on_full);
	return py_shutdown_on_full;
}

static int py_lsa_AuditFullSetInfo_set_shutdown_on_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullSetInfo *object = (struct lsa_AuditFullSetInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->shutdown_on_full = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_AuditFullSetInfo_getsetters[] = {
	{ discard_const_p(char, "shutdown_on_full"), py_lsa_AuditFullSetInfo_get_shutdown_on_full, py_lsa_AuditFullSetInfo_set_shutdown_on_full },
	{ NULL }
};

static PyObject *py_lsa_AuditFullSetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditFullSetInfo, type);
}


static PyTypeObject lsa_AuditFullSetInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AuditFullSetInfo",
	.tp_getset = py_lsa_AuditFullSetInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AuditFullSetInfo_new,
};


static PyObject *py_lsa_AuditFullQueryInfo_get_shutdown_on_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = (struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(obj);
	PyObject *py_shutdown_on_full;
	py_shutdown_on_full = PyInt_FromLong(object->shutdown_on_full);
	return py_shutdown_on_full;
}

static int py_lsa_AuditFullQueryInfo_set_shutdown_on_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = (struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->shutdown_on_full = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_AuditFullQueryInfo_get_log_is_full(PyObject *obj, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = (struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(obj);
	PyObject *py_log_is_full;
	py_log_is_full = PyInt_FromLong(object->log_is_full);
	return py_log_is_full;
}

static int py_lsa_AuditFullQueryInfo_set_log_is_full(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_AuditFullQueryInfo *object = (struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->log_is_full = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_AuditFullQueryInfo_getsetters[] = {
	{ discard_const_p(char, "shutdown_on_full"), py_lsa_AuditFullQueryInfo_get_shutdown_on_full, py_lsa_AuditFullQueryInfo_set_shutdown_on_full },
	{ discard_const_p(char, "log_is_full"), py_lsa_AuditFullQueryInfo_get_log_is_full, py_lsa_AuditFullQueryInfo_set_log_is_full },
	{ NULL }
};

static PyObject *py_lsa_AuditFullQueryInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_AuditFullQueryInfo, type);
}


static PyTypeObject lsa_AuditFullQueryInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.AuditFullQueryInfo",
	.tp_getset = py_lsa_AuditFullQueryInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_AuditFullQueryInfo_new,
};


static PyObject *py_lsa_DnsDomainInfo_get_name(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_DnsDomainInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_dns_domain(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domain);
	return py_dns_domain;
}

static int py_lsa_DnsDomainInfo_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domain = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_dns_forest(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dns_forest;
	py_dns_forest = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_forest);
	return py_dns_forest;
}

static int py_lsa_DnsDomainInfo_set_dns_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_forest = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_lsa_DnsDomainInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_DnsDomainInfo_get_sid(PyObject *obj, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_DnsDomainInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DnsDomainInfo *object = (struct lsa_DnsDomainInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DnsDomainInfo_getsetters[] = {
	{ discard_const_p(char, "name"), py_lsa_DnsDomainInfo_get_name, py_lsa_DnsDomainInfo_set_name },
	{ discard_const_p(char, "dns_domain"), py_lsa_DnsDomainInfo_get_dns_domain, py_lsa_DnsDomainInfo_set_dns_domain },
	{ discard_const_p(char, "dns_forest"), py_lsa_DnsDomainInfo_get_dns_forest, py_lsa_DnsDomainInfo_set_dns_forest },
	{ discard_const_p(char, "domain_guid"), py_lsa_DnsDomainInfo_get_domain_guid, py_lsa_DnsDomainInfo_set_domain_guid },
	{ discard_const_p(char, "sid"), py_lsa_DnsDomainInfo_get_sid, py_lsa_DnsDomainInfo_set_sid },
	{ NULL }
};

static PyObject *py_lsa_DnsDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DnsDomainInfo, type);
}


static PyTypeObject lsa_DnsDomainInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DnsDomainInfo",
	.tp_getset = py_lsa_DnsDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DnsDomainInfo_new,
};

PyObject *py_import_lsa_PolicyInformation(TALLOC_CTX *mem_ctx, int level, union lsa_PolicyInformation *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			ret = pytalloc_reference_ex(&lsa_AuditLogInfo_Type, mem_ctx, &in->audit_log);
			return ret;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			ret = pytalloc_reference_ex(&lsa_AuditEventsInfo_Type, mem_ctx, &in->audit_events);
			return ret;

		case LSA_POLICY_INFO_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->domain);
			return ret;

		case LSA_POLICY_INFO_PD:
			ret = pytalloc_reference_ex(&lsa_PDAccountInfo_Type, mem_ctx, &in->pd);
			return ret;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->account_domain);
			return ret;

		case LSA_POLICY_INFO_ROLE:
			ret = pytalloc_reference_ex(&lsa_ServerRole_Type, mem_ctx, &in->role);
			return ret;

		case LSA_POLICY_INFO_REPLICA:
			ret = pytalloc_reference_ex(&lsa_ReplicaSourceInfo_Type, mem_ctx, &in->replica);
			return ret;

		case LSA_POLICY_INFO_QUOTA:
			ret = pytalloc_reference_ex(&lsa_DefaultQuotaInfo_Type, mem_ctx, &in->quota);
			return ret;

		case LSA_POLICY_INFO_MOD:
			ret = pytalloc_reference_ex(&lsa_ModificationInfo_Type, mem_ctx, &in->mod);
			return ret;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			ret = pytalloc_reference_ex(&lsa_AuditFullSetInfo_Type, mem_ctx, &in->auditfullset);
			return ret;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			ret = pytalloc_reference_ex(&lsa_AuditFullQueryInfo_Type, mem_ctx, &in->auditfullquery);
			return ret;

		case LSA_POLICY_INFO_DNS:
			ret = pytalloc_reference_ex(&lsa_DnsDomainInfo_Type, mem_ctx, &in->dns);
			return ret;

		case LSA_POLICY_INFO_DNS_INT:
			ret = pytalloc_reference_ex(&lsa_DnsDomainInfo_Type, mem_ctx, &in->dns);
			return ret;

		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
			ret = pytalloc_reference_ex(&lsa_DomainInfo_Type, mem_ctx, &in->l_account_domain);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union lsa_PolicyInformation *py_export_lsa_PolicyInformation(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_PolicyInformation *ret = talloc_zero(mem_ctx, union lsa_PolicyInformation);
	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			PY_CHECK_TYPE(&lsa_AuditLogInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->audit_log = *(struct lsa_AuditLogInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			PY_CHECK_TYPE(&lsa_AuditEventsInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->audit_events = *(struct lsa_AuditEventsInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DOMAIN:
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_PD:
			PY_CHECK_TYPE(&lsa_PDAccountInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->pd = *(struct lsa_PDAccountInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->account_domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_ROLE:
			PY_CHECK_TYPE(&lsa_ServerRole_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->role = *(struct lsa_ServerRole *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_REPLICA:
			PY_CHECK_TYPE(&lsa_ReplicaSourceInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->replica = *(struct lsa_ReplicaSourceInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_QUOTA:
			PY_CHECK_TYPE(&lsa_DefaultQuotaInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->quota = *(struct lsa_DefaultQuotaInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_MOD:
			PY_CHECK_TYPE(&lsa_ModificationInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mod = *(struct lsa_ModificationInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			PY_CHECK_TYPE(&lsa_AuditFullSetInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auditfullset = *(struct lsa_AuditFullSetInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			PY_CHECK_TYPE(&lsa_AuditFullQueryInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auditfullquery = *(struct lsa_AuditFullQueryInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DNS:
			PY_CHECK_TYPE(&lsa_DnsDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dns = *(struct lsa_DnsDomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_DNS_INT:
			PY_CHECK_TYPE(&lsa_DnsDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dns = *(struct lsa_DnsDomainInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_POLICY_INFO_L_ACCOUNT_DOMAIN:
			PY_CHECK_TYPE(&lsa_DomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->l_account_domain = *(struct lsa_DomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_lsa_SidPtr_get_sid(PyObject *obj, void *closure)
{
	struct lsa_SidPtr *object = (struct lsa_SidPtr *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_SidPtr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidPtr *object = (struct lsa_SidPtr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_SidPtr_getsetters[] = {
	{ discard_const_p(char, "sid"), py_lsa_SidPtr_get_sid, py_lsa_SidPtr_set_sid },
	{ NULL }
};

static PyObject *py_lsa_SidPtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_SidPtr, type);
}


static PyTypeObject lsa_SidPtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.SidPtr",
	.tp_getset = py_lsa_SidPtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_SidPtr_new,
};


static PyObject *py_lsa_SidArray_get_num_sids(PyObject *obj, void *closure)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyInt_FromLong(object->num_sids);
	return py_num_sids;
}

static int py_lsa_SidArray_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_sids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_SidArray_get_sids(PyObject *obj, void *closure)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->num_sids);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->num_sids; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_SidPtr_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_SidArray_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&lsa_SidPtr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct lsa_SidPtr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_SidArray_getsetters[] = {
	{ discard_const_p(char, "num_sids"), py_lsa_SidArray_get_num_sids, py_lsa_SidArray_set_num_sids },
	{ discard_const_p(char, "sids"), py_lsa_SidArray_get_sids, py_lsa_SidArray_set_sids },
	{ NULL }
};

static PyObject *py_lsa_SidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_SidArray, type);
}

static PyObject *py_lsa_SidArray_ndr_pack(PyObject *py_obj)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_SidArray);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_SidArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_SidArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_SidArray);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_SidArray_ndr_print(PyObject *py_obj)
{
	struct lsa_SidArray *object = (struct lsa_SidArray *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_SidArray, "lsa_SidArray", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_SidArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_SidArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_SidArray_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_SidArray_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_SidArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.SidArray",
	.tp_getset = py_lsa_SidArray_getsetters,
	.tp_methods = py_lsa_SidArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_SidArray_new,
};


static PyObject *py_lsa_DomainList_get_count(PyObject *obj, void *closure)
{
	struct lsa_DomainList *object = (struct lsa_DomainList *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_DomainList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainList *object = (struct lsa_DomainList *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DomainList_get_domains(PyObject *obj, void *closure)
{
	struct lsa_DomainList *object = (struct lsa_DomainList *)pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < object->count; domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_DomainInfo_Type, object->domains, &object->domains[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_DomainList_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainList *object = (struct lsa_DomainList *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domains);
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1;; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				PY_CHECK_TYPE(&lsa_DomainInfo_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->domains[domains_cntr_1] = *(struct lsa_DomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainList_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_DomainList_get_count, py_lsa_DomainList_set_count },
	{ discard_const_p(char, "domains"), py_lsa_DomainList_get_domains, py_lsa_DomainList_set_domains },
	{ NULL }
};

static PyObject *py_lsa_DomainList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainList, type);
}


static PyTypeObject lsa_DomainList_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DomainList",
	.tp_getset = py_lsa_DomainList_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DomainList_new,
};


static PyObject *py_lsa_TranslatedSid_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyInt_FromLong(object->sid_type);
	return py_sid_type;
}

static int py_lsa_TranslatedSid_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sid_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sid_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid_get_rid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_lsa_TranslatedSid_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TranslatedSid_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyInt_FromLong(object->sid_index);
	return py_sid_index;
}

static int py_lsa_TranslatedSid_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid *object = (struct lsa_TranslatedSid *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_index = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid_getsetters[] = {
	{ discard_const_p(char, "sid_type"), py_lsa_TranslatedSid_get_sid_type, py_lsa_TranslatedSid_set_sid_type },
	{ discard_const_p(char, "rid"), py_lsa_TranslatedSid_get_rid, py_lsa_TranslatedSid_set_rid },
	{ discard_const_p(char, "sid_index"), py_lsa_TranslatedSid_get_sid_index, py_lsa_TranslatedSid_set_sid_index },
	{ NULL }
};

static PyObject *py_lsa_TranslatedSid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid, type);
}


static PyTypeObject lsa_TranslatedSid_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TranslatedSid",
	.tp_getset = py_lsa_TranslatedSid_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TranslatedSid_new,
};


static PyObject *py_lsa_TransSidArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray *object = (struct lsa_TransSidArray *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_TransSidArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray *object = (struct lsa_TransSidArray *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TransSidArray_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray *object = (struct lsa_TransSidArray *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->count; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray *object = (struct lsa_TransSidArray *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TranslatedSid_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct lsa_TranslatedSid *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_TransSidArray_get_count, py_lsa_TransSidArray_set_count },
	{ discard_const_p(char, "sids"), py_lsa_TransSidArray_get_sids, py_lsa_TransSidArray_set_sids },
	{ NULL }
};

static PyObject *py_lsa_TransSidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray, type);
}


static PyTypeObject lsa_TransSidArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TransSidArray",
	.tp_getset = py_lsa_TransSidArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TransSidArray_new,
};


static PyObject *py_lsa_RefDomainList_get_count(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_RefDomainList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_RefDomainList_get_domains(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < object->count; domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_DomainInfo_Type, object->domains, &object->domains[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_RefDomainList_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domains);
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1;; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				PY_CHECK_TYPE(&lsa_DomainInfo_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->domains[domains_cntr_1] = *(struct lsa_DomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_lsa_RefDomainList_get_max_size(PyObject *obj, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyInt_FromLong(object->max_size);
	return py_max_size;
}

static int py_lsa_RefDomainList_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_RefDomainList_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_RefDomainList_get_count, py_lsa_RefDomainList_set_count },
	{ discard_const_p(char, "domains"), py_lsa_RefDomainList_get_domains, py_lsa_RefDomainList_set_domains },
	{ discard_const_p(char, "max_size"), py_lsa_RefDomainList_get_max_size, py_lsa_RefDomainList_set_max_size },
	{ NULL }
};

static PyObject *py_lsa_RefDomainList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RefDomainList, type);
}

static PyObject *py_lsa_RefDomainList_ndr_pack(PyObject *py_obj)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_RefDomainList);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_RefDomainList_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_RefDomainList);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_RefDomainList);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_RefDomainList_ndr_print(PyObject *py_obj)
{
	struct lsa_RefDomainList *object = (struct lsa_RefDomainList *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_RefDomainList, "lsa_RefDomainList", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_RefDomainList_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_RefDomainList_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_RefDomainList_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_RefDomainList_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_RefDomainList_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.RefDomainList",
	.tp_getset = py_lsa_RefDomainList_getsetters,
	.tp_methods = py_lsa_RefDomainList_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_RefDomainList_new,
};


static PyObject *py_lsa_TranslatedName_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyInt_FromLong(object->sid_type);
	return py_sid_type;
}

static int py_lsa_TranslatedName_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sid_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sid_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TranslatedName_get_name(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_TranslatedName_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TranslatedName_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyInt_FromLong(object->sid_index);
	return py_sid_index;
}

static int py_lsa_TranslatedName_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName *object = (struct lsa_TranslatedName *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_index = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TranslatedName_getsetters[] = {
	{ discard_const_p(char, "sid_type"), py_lsa_TranslatedName_get_sid_type, py_lsa_TranslatedName_set_sid_type },
	{ discard_const_p(char, "name"), py_lsa_TranslatedName_get_name, py_lsa_TranslatedName_set_name },
	{ discard_const_p(char, "sid_index"), py_lsa_TranslatedName_get_sid_index, py_lsa_TranslatedName_set_sid_index },
	{ NULL }
};

static PyObject *py_lsa_TranslatedName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedName, type);
}


static PyTypeObject lsa_TranslatedName_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TranslatedName",
	.tp_getset = py_lsa_TranslatedName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TranslatedName_new,
};


static PyObject *py_lsa_TransNameArray_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_TransNameArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TransNameArray_get_names(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < object->count; names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_TranslatedName_Type, object->names, &object->names[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_TransNameArray_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->names);
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1;; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TranslatedName_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->names[names_cntr_1] = *(struct lsa_TranslatedName *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransNameArray_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_TransNameArray_get_count, py_lsa_TransNameArray_set_count },
	{ discard_const_p(char, "names"), py_lsa_TransNameArray_get_names, py_lsa_TransNameArray_set_names },
	{ NULL }
};

static PyObject *py_lsa_TransNameArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransNameArray, type);
}

static PyObject *py_lsa_TransNameArray_ndr_pack(PyObject *py_obj)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_TransNameArray);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_TransNameArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TransNameArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TransNameArray);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_TransNameArray_ndr_print(PyObject *py_obj)
{
	struct lsa_TransNameArray *object = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_TransNameArray, "lsa_TransNameArray", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_TransNameArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_TransNameArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_TransNameArray_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_TransNameArray_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_TransNameArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TransNameArray",
	.tp_getset = py_lsa_TransNameArray_getsetters,
	.tp_methods = py_lsa_TransNameArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TransNameArray_new,
};


static PyObject *py_lsa_LUIDAttribute_get_luid(PyObject *obj, void *closure)
{
	struct lsa_LUIDAttribute *object = (struct lsa_LUIDAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, pytalloc_get_mem_ctx(obj), &object->luid);
	return py_luid;
}

static int py_lsa_LUIDAttribute_set_luid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUIDAttribute *object = (struct lsa_LUIDAttribute *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_LUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->luid = *(struct lsa_LUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_LUIDAttribute_get_attribute(PyObject *obj, void *closure)
{
	struct lsa_LUIDAttribute *object = (struct lsa_LUIDAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_attribute;
	py_attribute = PyInt_FromLong(object->attribute);
	return py_attribute;
}

static int py_lsa_LUIDAttribute_set_attribute(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_LUIDAttribute *object = (struct lsa_LUIDAttribute *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attribute = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_LUIDAttribute_getsetters[] = {
	{ discard_const_p(char, "luid"), py_lsa_LUIDAttribute_get_luid, py_lsa_LUIDAttribute_set_luid },
	{ discard_const_p(char, "attribute"), py_lsa_LUIDAttribute_get_attribute, py_lsa_LUIDAttribute_set_attribute },
	{ NULL }
};

static PyObject *py_lsa_LUIDAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_LUIDAttribute, type);
}


static PyTypeObject lsa_LUIDAttribute_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.LUIDAttribute",
	.tp_getset = py_lsa_LUIDAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_LUIDAttribute_new,
};


static PyObject *py_lsa_PrivilegeSet_get_count(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_PrivilegeSet_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_PrivilegeSet_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_lsa_PrivilegeSet_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_PrivilegeSet_get_set(PyObject *obj, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(obj);
	PyObject *py_set;
	py_set = PyList_New(object->count);
	if (py_set == NULL) {
		return NULL;
	}
	{
		int set_cntr_0;
		for (set_cntr_0 = 0; set_cntr_0 < object->count; set_cntr_0++) {
			PyObject *py_set_0;
			py_set_0 = pytalloc_reference_ex(&lsa_LUIDAttribute_Type, object->set, &object->set[set_cntr_0]);
			PyList_SetItem(py_set, set_cntr_0, py_set_0);
		}
	}
	return py_set;
}

static int py_lsa_PrivilegeSet_set_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_PrivilegeSet *object = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int set_cntr_0;
		object->set = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->set, PyList_GET_SIZE(value));
		if (!object->set) { return -1;; }
		talloc_set_name_const(object->set, "ARRAY: object->set");
		for (set_cntr_0 = 0; set_cntr_0 < PyList_GET_SIZE(value); set_cntr_0++) {
			PY_CHECK_TYPE(&lsa_LUIDAttribute_Type, PyList_GET_ITEM(value, set_cntr_0), return -1;);
			if (talloc_reference(object->set, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, set_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->set[set_cntr_0] = *(struct lsa_LUIDAttribute *)pytalloc_get_ptr(PyList_GET_ITEM(value, set_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_PrivilegeSet_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_PrivilegeSet_get_count, py_lsa_PrivilegeSet_set_count },
	{ discard_const_p(char, "unknown"), py_lsa_PrivilegeSet_get_unknown, py_lsa_PrivilegeSet_set_unknown },
	{ discard_const_p(char, "set"), py_lsa_PrivilegeSet_get_set, py_lsa_PrivilegeSet_set_set },
	{ NULL }
};

static PyObject *py_lsa_PrivilegeSet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_PrivilegeSet, type);
}


static PyTypeObject lsa_PrivilegeSet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.PrivilegeSet",
	.tp_getset = py_lsa_PrivilegeSet_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_PrivilegeSet_new,
};


static PyObject *py_lsa_DATA_BUF_get_length(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_DATA_BUF_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DATA_BUF_get_size(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_DATA_BUF_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DATA_BUF_get_data(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_DATA_BUF_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF *object = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_DATA_BUF_get_length, py_lsa_DATA_BUF_set_length },
	{ discard_const_p(char, "size"), py_lsa_DATA_BUF_get_size, py_lsa_DATA_BUF_set_size },
	{ discard_const_p(char, "data"), py_lsa_DATA_BUF_get_data, py_lsa_DATA_BUF_set_data },
	{ NULL }
};

static PyObject *py_lsa_DATA_BUF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF, type);
}


static PyTypeObject lsa_DATA_BUF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DATA_BUF",
	.tp_getset = py_lsa_DATA_BUF_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DATA_BUF_new,
};


static PyObject *py_lsa_DATA_BUF2_get_size(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF2 *object = (struct lsa_DATA_BUF2 *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_lsa_DATA_BUF2_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF2 *object = (struct lsa_DATA_BUF2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DATA_BUF2_get_data(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF2 *object = (struct lsa_DATA_BUF2 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->size);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->size; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_DATA_BUF2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF2 *object = (struct lsa_DATA_BUF2 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF2_getsetters[] = {
	{ discard_const_p(char, "size"), py_lsa_DATA_BUF2_get_size, py_lsa_DATA_BUF2_set_size },
	{ discard_const_p(char, "data"), py_lsa_DATA_BUF2_get_data, py_lsa_DATA_BUF2_set_data },
	{ NULL }
};

static PyObject *py_lsa_DATA_BUF2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF2, type);
}


static PyTypeObject lsa_DATA_BUF2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DATA_BUF2",
	.tp_getset = py_lsa_DATA_BUF2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DATA_BUF2_new,
};


static PyObject *py_lsa_TrustDomainInfoName_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoName *object = (struct lsa_TrustDomainInfoName *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoName_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoName *object = (struct lsa_TrustDomainInfoName *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoName_getsetters[] = {
	{ discard_const_p(char, "netbios_name"), py_lsa_TrustDomainInfoName_get_netbios_name, py_lsa_TrustDomainInfoName_set_netbios_name },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoName, type);
}


static PyTypeObject lsa_TrustDomainInfoName_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoName",
	.tp_getset = py_lsa_TrustDomainInfoName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoName_new,
};


static PyObject *py_lsa_TrustDomainInfoControllers_get_entries(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = (struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyInt_FromLong(object->entries);
	return py_entries;
}

static int py_lsa_TrustDomainInfoControllers_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = (struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoControllers_get_netbios_names(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = (struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_names;
	if (object->netbios_names == NULL) {
		py_netbios_names = Py_None;
		Py_INCREF(py_netbios_names);
	} else {
		py_netbios_names = PyList_New(object->entries);
		if (py_netbios_names == NULL) {
			return NULL;
		}
		{
			int netbios_names_cntr_1;
			for (netbios_names_cntr_1 = 0; netbios_names_cntr_1 < object->entries; netbios_names_cntr_1++) {
				PyObject *py_netbios_names_1;
				py_netbios_names_1 = pytalloc_reference_ex(&lsa_StringLarge_Type, object->netbios_names, &object->netbios_names[netbios_names_cntr_1]);
				PyList_SetItem(py_netbios_names, netbios_names_cntr_1, py_netbios_names_1);
			}
		}
	}
	return py_netbios_names;
}

static int py_lsa_TrustDomainInfoControllers_set_netbios_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoControllers *object = (struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->netbios_names);
	if (value == Py_None) {
		object->netbios_names = NULL;
	} else {
		object->netbios_names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int netbios_names_cntr_1;
			object->netbios_names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->netbios_names, PyList_GET_SIZE(value));
			if (!object->netbios_names) { return -1;; }
			talloc_set_name_const(object->netbios_names, "ARRAY: object->netbios_names");
			for (netbios_names_cntr_1 = 0; netbios_names_cntr_1 < PyList_GET_SIZE(value); netbios_names_cntr_1++) {
				PY_CHECK_TYPE(&lsa_StringLarge_Type, PyList_GET_ITEM(value, netbios_names_cntr_1), return -1;);
				if (talloc_reference(object->netbios_names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, netbios_names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->netbios_names[netbios_names_cntr_1] = *(struct lsa_StringLarge *)pytalloc_get_ptr(PyList_GET_ITEM(value, netbios_names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoControllers_getsetters[] = {
	{ discard_const_p(char, "entries"), py_lsa_TrustDomainInfoControllers_get_entries, py_lsa_TrustDomainInfoControllers_set_entries },
	{ discard_const_p(char, "netbios_names"), py_lsa_TrustDomainInfoControllers_get_netbios_names, py_lsa_TrustDomainInfoControllers_set_netbios_names },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoControllers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoControllers, type);
}


static PyTypeObject lsa_TrustDomainInfoControllers_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoControllers",
	.tp_getset = py_lsa_TrustDomainInfoControllers_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoControllers_new,
};


static PyObject *py_lsa_TrustDomainInfoPosixOffset_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPosixOffset *object = (struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = PyInt_FromLong(object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoPosixOffset_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPosixOffset *object = (struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->posix_offset = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoPosixOffset_getsetters[] = {
	{ discard_const_p(char, "posix_offset"), py_lsa_TrustDomainInfoPosixOffset_get_posix_offset, py_lsa_TrustDomainInfoPosixOffset_set_posix_offset },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoPosixOffset_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoPosixOffset, type);
}


static PyTypeObject lsa_TrustDomainInfoPosixOffset_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoPosixOffset",
	.tp_getset = py_lsa_TrustDomainInfoPosixOffset_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoPosixOffset_new,
};


static PyObject *py_lsa_TrustDomainInfoPassword_get_password(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = (struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(obj);
	PyObject *py_password;
	if (object->password == NULL) {
		py_password = Py_None;
		Py_INCREF(py_password);
	} else {
		py_password = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->password, object->password);
	}
	return py_password;
}

static int py_lsa_TrustDomainInfoPassword_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = (struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->password);
	if (value == Py_None) {
		object->password = NULL;
	} else {
		object->password = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->password = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoPassword_get_old_password(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = (struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(obj);
	PyObject *py_old_password;
	if (object->old_password == NULL) {
		py_old_password = Py_None;
		Py_INCREF(py_old_password);
	} else {
		py_old_password = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->old_password, object->old_password);
	}
	return py_old_password;
}

static int py_lsa_TrustDomainInfoPassword_set_old_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoPassword *object = (struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->old_password);
	if (value == Py_None) {
		object->old_password = NULL;
	} else {
		object->old_password = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->old_password = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoPassword_getsetters[] = {
	{ discard_const_p(char, "password"), py_lsa_TrustDomainInfoPassword_get_password, py_lsa_TrustDomainInfoPassword_set_password },
	{ discard_const_p(char, "old_password"), py_lsa_TrustDomainInfoPassword_get_old_password, py_lsa_TrustDomainInfoPassword_set_old_password },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoPassword, type);
}


static PyTypeObject lsa_TrustDomainInfoPassword_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoPassword",
	.tp_getset = py_lsa_TrustDomainInfoPassword_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoPassword_new,
};


static PyObject *py_lsa_TrustDomainInfoBasic_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = (struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoBasic_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = (struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBasic_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = (struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TrustDomainInfoBasic_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBasic *object = (struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoBasic_getsetters[] = {
	{ discard_const_p(char, "netbios_name"), py_lsa_TrustDomainInfoBasic_get_netbios_name, py_lsa_TrustDomainInfoBasic_set_netbios_name },
	{ discard_const_p(char, "sid"), py_lsa_TrustDomainInfoBasic_get_sid, py_lsa_TrustDomainInfoBasic_set_sid },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoBasic_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoBasic, type);
}


static PyTypeObject lsa_TrustDomainInfoBasic_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoBasic",
	.tp_getset = py_lsa_TrustDomainInfoBasic_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoBasic_new,
};


static PyObject *py_lsa_TrustDomainInfoInfoEx_get_domain_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_lsa_TrustDomainInfoInfoEx_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_netbios_name(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	py_netbios_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_name);
	return py_netbios_name;
}

static int py_lsa_TrustDomainInfoInfoEx_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TrustDomainInfoInfoEx_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_direction(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_trust_direction;
	py_trust_direction = PyInt_FromLong(object->trust_direction);
	return py_trust_direction;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_direction(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_direction = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_direction = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_type(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyInt_FromLong(object->trust_type);
	return py_trust_type;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx_get_trust_attributes(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyInt_FromLong(object->trust_attributes);
	return py_trust_attributes;
}

static int py_lsa_TrustDomainInfoInfoEx_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx *object = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_attributes = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_attributes = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoInfoEx_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_lsa_TrustDomainInfoInfoEx_get_domain_name, py_lsa_TrustDomainInfoInfoEx_set_domain_name },
	{ discard_const_p(char, "netbios_name"), py_lsa_TrustDomainInfoInfoEx_get_netbios_name, py_lsa_TrustDomainInfoInfoEx_set_netbios_name },
	{ discard_const_p(char, "sid"), py_lsa_TrustDomainInfoInfoEx_get_sid, py_lsa_TrustDomainInfoInfoEx_set_sid },
	{ discard_const_p(char, "trust_direction"), py_lsa_TrustDomainInfoInfoEx_get_trust_direction, py_lsa_TrustDomainInfoInfoEx_set_trust_direction },
	{ discard_const_p(char, "trust_type"), py_lsa_TrustDomainInfoInfoEx_get_trust_type, py_lsa_TrustDomainInfoInfoEx_set_trust_type },
	{ discard_const_p(char, "trust_attributes"), py_lsa_TrustDomainInfoInfoEx_get_trust_attributes, py_lsa_TrustDomainInfoInfoEx_set_trust_attributes },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoInfoEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoInfoEx, type);
}


static PyTypeObject lsa_TrustDomainInfoInfoEx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoInfoEx",
	.tp_getset = py_lsa_TrustDomainInfoInfoEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoInfoEx_new,
};


static PyObject *py_lsa_TrustDomainInfoBuffer_get_last_update_time(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(obj);
	PyObject *py_last_update_time;
	py_last_update_time = PyLong_FromLongLong(object->last_update_time);
	return py_last_update_time;
}

static int py_lsa_TrustDomainInfoBuffer_set_last_update_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_update_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_update_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBuffer_get_AuthType(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(obj);
	PyObject *py_AuthType;
	py_AuthType = PyInt_FromLong(object->AuthType);
	return py_AuthType;
}

static int py_lsa_TrustDomainInfoBuffer_set_AuthType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->AuthType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->AuthType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoBuffer_get_data(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pytalloc_reference_ex(&lsa_DATA_BUF2_Type, pytalloc_get_mem_ctx(obj), &object->data);
	return py_data;
}

static int py_lsa_TrustDomainInfoBuffer_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoBuffer *object = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_DATA_BUF2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->data = *(struct lsa_DATA_BUF2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoBuffer_getsetters[] = {
	{ discard_const_p(char, "last_update_time"), py_lsa_TrustDomainInfoBuffer_get_last_update_time, py_lsa_TrustDomainInfoBuffer_set_last_update_time },
	{ discard_const_p(char, "AuthType"), py_lsa_TrustDomainInfoBuffer_get_AuthType, py_lsa_TrustDomainInfoBuffer_set_AuthType },
	{ discard_const_p(char, "data"), py_lsa_TrustDomainInfoBuffer_get_data, py_lsa_TrustDomainInfoBuffer_set_data },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoBuffer, type);
}


static PyTypeObject lsa_TrustDomainInfoBuffer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoBuffer",
	.tp_getset = py_lsa_TrustDomainInfoBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoBuffer_new,
};


static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_count(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_incoming_count;
	py_incoming_count = PyInt_FromLong(object->incoming_count);
	return py_incoming_count;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->incoming_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_current_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_incoming_current_auth_info;
	if (object->incoming_current_auth_info == NULL) {
		py_incoming_current_auth_info = Py_None;
		Py_INCREF(py_incoming_current_auth_info);
	} else {
		py_incoming_current_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->incoming_current_auth_info, object->incoming_current_auth_info);
	}
	return py_incoming_current_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_current_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->incoming_current_auth_info);
	if (value == Py_None) {
		object->incoming_current_auth_info = NULL;
	} else {
		object->incoming_current_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->incoming_current_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_incoming_previous_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_incoming_previous_auth_info;
	if (object->incoming_previous_auth_info == NULL) {
		py_incoming_previous_auth_info = Py_None;
		Py_INCREF(py_incoming_previous_auth_info);
	} else {
		py_incoming_previous_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->incoming_previous_auth_info, object->incoming_previous_auth_info);
	}
	return py_incoming_previous_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_incoming_previous_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->incoming_previous_auth_info);
	if (value == Py_None) {
		object->incoming_previous_auth_info = NULL;
	} else {
		object->incoming_previous_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->incoming_previous_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_count(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_outgoing_count;
	py_outgoing_count = PyInt_FromLong(object->outgoing_count);
	return py_outgoing_count;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->outgoing_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_current_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_outgoing_current_auth_info;
	if (object->outgoing_current_auth_info == NULL) {
		py_outgoing_current_auth_info = Py_None;
		Py_INCREF(py_outgoing_current_auth_info);
	} else {
		py_outgoing_current_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->outgoing_current_auth_info, object->outgoing_current_auth_info);
	}
	return py_outgoing_current_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_current_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->outgoing_current_auth_info);
	if (value == Py_None) {
		object->outgoing_current_auth_info = NULL;
	} else {
		object->outgoing_current_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->outgoing_current_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_get_outgoing_previous_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(obj);
	PyObject *py_outgoing_previous_auth_info;
	if (object->outgoing_previous_auth_info == NULL) {
		py_outgoing_previous_auth_info = Py_None;
		Py_INCREF(py_outgoing_previous_auth_info);
	} else {
		py_outgoing_previous_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoBuffer_Type, object->outgoing_previous_auth_info, object->outgoing_previous_auth_info);
	}
	return py_outgoing_previous_auth_info;
}

static int py_lsa_TrustDomainInfoAuthInfo_set_outgoing_previous_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->outgoing_previous_auth_info);
	if (value == Py_None) {
		object->outgoing_previous_auth_info = NULL;
	} else {
		object->outgoing_previous_auth_info = NULL;
		PY_CHECK_TYPE(&lsa_TrustDomainInfoBuffer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->outgoing_previous_auth_info = (struct lsa_TrustDomainInfoBuffer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoAuthInfo_getsetters[] = {
	{ discard_const_p(char, "incoming_count"), py_lsa_TrustDomainInfoAuthInfo_get_incoming_count, py_lsa_TrustDomainInfoAuthInfo_set_incoming_count },
	{ discard_const_p(char, "incoming_current_auth_info"), py_lsa_TrustDomainInfoAuthInfo_get_incoming_current_auth_info, py_lsa_TrustDomainInfoAuthInfo_set_incoming_current_auth_info },
	{ discard_const_p(char, "incoming_previous_auth_info"), py_lsa_TrustDomainInfoAuthInfo_get_incoming_previous_auth_info, py_lsa_TrustDomainInfoAuthInfo_set_incoming_previous_auth_info },
	{ discard_const_p(char, "outgoing_count"), py_lsa_TrustDomainInfoAuthInfo_get_outgoing_count, py_lsa_TrustDomainInfoAuthInfo_set_outgoing_count },
	{ discard_const_p(char, "outgoing_current_auth_info"), py_lsa_TrustDomainInfoAuthInfo_get_outgoing_current_auth_info, py_lsa_TrustDomainInfoAuthInfo_set_outgoing_current_auth_info },
	{ discard_const_p(char, "outgoing_previous_auth_info"), py_lsa_TrustDomainInfoAuthInfo_get_outgoing_previous_auth_info, py_lsa_TrustDomainInfoAuthInfo_set_outgoing_previous_auth_info },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoAuthInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoAuthInfo, type);
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_pack(PyObject *py_obj)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_TrustDomainInfoAuthInfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoAuthInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_TrustDomainInfoAuthInfo);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_TrustDomainInfoAuthInfo_ndr_print(PyObject *py_obj)
{
	struct lsa_TrustDomainInfoAuthInfo *object = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_TrustDomainInfoAuthInfo, "lsa_TrustDomainInfoAuthInfo", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_TrustDomainInfoAuthInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_TrustDomainInfoAuthInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_TrustDomainInfoAuthInfo_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_TrustDomainInfoAuthInfo_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_TrustDomainInfoAuthInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoAuthInfo",
	.tp_getset = py_lsa_TrustDomainInfoAuthInfo_getsetters,
	.tp_methods = py_lsa_TrustDomainInfoAuthInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoAuthInfo_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfo_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoFullInfo_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfo_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfo_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo *object = (struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfo_getsetters[] = {
	{ discard_const_p(char, "info_ex"), py_lsa_TrustDomainInfoFullInfo_get_info_ex, py_lsa_TrustDomainInfoFullInfo_set_info_ex },
	{ discard_const_p(char, "posix_offset"), py_lsa_TrustDomainInfoFullInfo_get_posix_offset, py_lsa_TrustDomainInfoFullInfo_set_posix_offset },
	{ discard_const_p(char, "auth_info"), py_lsa_TrustDomainInfoFullInfo_get_auth_info, py_lsa_TrustDomainInfoFullInfo_set_auth_info },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfo, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoFullInfo",
	.tp_getset = py_lsa_TrustDomainInfoFullInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoFullInfo_new,
};


static PyObject *py_lsa_TrustDomainInfoAuthInfoInternal_get_auth_blob(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternal *object = (struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(obj);
	PyObject *py_auth_blob;
	py_auth_blob = pytalloc_reference_ex(&lsa_DATA_BUF2_Type, pytalloc_get_mem_ctx(obj), &object->auth_blob);
	return py_auth_blob;
}

static int py_lsa_TrustDomainInfoAuthInfoInternal_set_auth_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoAuthInfoInternal *object = (struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_DATA_BUF2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_blob = *(struct lsa_DATA_BUF2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoAuthInfoInternal_getsetters[] = {
	{ discard_const_p(char, "auth_blob"), py_lsa_TrustDomainInfoAuthInfoInternal_get_auth_blob, py_lsa_TrustDomainInfoAuthInfoInternal_set_auth_blob },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoAuthInfoInternal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoAuthInfoInternal, type);
}


static PyTypeObject lsa_TrustDomainInfoAuthInfoInternal_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoAuthInfoInternal",
	.tp_getset = py_lsa_TrustDomainInfoAuthInfoInternal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoAuthInfoInternal_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternal_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfoInternal_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfoInternal *object = (struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternal_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfoInternal_getsetters[] = {
	{ discard_const_p(char, "info_ex"), py_lsa_TrustDomainInfoFullInfoInternal_get_info_ex, py_lsa_TrustDomainInfoFullInfoInternal_set_info_ex },
	{ discard_const_p(char, "posix_offset"), py_lsa_TrustDomainInfoFullInfoInternal_get_posix_offset, py_lsa_TrustDomainInfoFullInfoInternal_set_posix_offset },
	{ discard_const_p(char, "auth_info"), py_lsa_TrustDomainInfoFullInfoInternal_get_auth_info, py_lsa_TrustDomainInfoFullInfoInternal_set_auth_info },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfoInternal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfoInternal, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfoInternal_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoFullInfoInternal",
	.tp_getset = py_lsa_TrustDomainInfoFullInfoInternal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoFullInfoInternal_new,
};


static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_info_ex(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_info_ex;
	py_info_ex = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->info_ex);
	return py_info_ex;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_info_ex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_length(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_length;
	py_forest_trust_length = PyInt_FromLong(object->forest_trust_length);
	return py_forest_trust_length;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->forest_trust_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_data(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_data;
	if (object->forest_trust_data == NULL) {
		py_forest_trust_data = Py_None;
		Py_INCREF(py_forest_trust_data);
	} else {
		py_forest_trust_data = PyList_New(object->forest_trust_length);
		if (py_forest_trust_data == NULL) {
			return NULL;
		}
		{
			int forest_trust_data_cntr_1;
			for (forest_trust_data_cntr_1 = 0; forest_trust_data_cntr_1 < object->forest_trust_length; forest_trust_data_cntr_1++) {
				PyObject *py_forest_trust_data_1;
				py_forest_trust_data_1 = PyInt_FromLong(object->forest_trust_data[forest_trust_data_cntr_1]);
				PyList_SetItem(py_forest_trust_data, forest_trust_data_cntr_1, py_forest_trust_data_1);
			}
		}
	}
	return py_forest_trust_data;
}

static int py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoInfoEx2Internal *object = (struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->forest_trust_data);
	if (value == Py_None) {
		object->forest_trust_data = NULL;
	} else {
		object->forest_trust_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int forest_trust_data_cntr_1;
			object->forest_trust_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->forest_trust_data, PyList_GET_SIZE(value));
			if (!object->forest_trust_data) { return -1;; }
			talloc_set_name_const(object->forest_trust_data, "ARRAY: object->forest_trust_data");
			for (forest_trust_data_cntr_1 = 0; forest_trust_data_cntr_1 < PyList_GET_SIZE(value); forest_trust_data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, forest_trust_data_cntr_1), return -1;);
				object->forest_trust_data[forest_trust_data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, forest_trust_data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoInfoEx2Internal_getsetters[] = {
	{ discard_const_p(char, "info_ex"), py_lsa_TrustDomainInfoInfoEx2Internal_get_info_ex, py_lsa_TrustDomainInfoInfoEx2Internal_set_info_ex },
	{ discard_const_p(char, "forest_trust_length"), py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_length, py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_length },
	{ discard_const_p(char, "forest_trust_data"), py_lsa_TrustDomainInfoInfoEx2Internal_get_forest_trust_data, py_lsa_TrustDomainInfoInfoEx2Internal_set_forest_trust_data },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoInfoEx2Internal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoInfoEx2Internal, type);
}


static PyTypeObject lsa_TrustDomainInfoInfoEx2Internal_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoInfoEx2Internal",
	.tp_getset = py_lsa_TrustDomainInfoInfoEx2Internal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoInfoEx2Internal_new,
};


static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx2Internal_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx2Internal_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_posix_offset(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, pytalloc_get_mem_ctx(obj), &object->posix_offset);
	return py_posix_offset;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_get_auth_info(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, pytalloc_get_mem_ctx(obj), &object->auth_info);
	return py_auth_info;
}

static int py_lsa_TrustDomainInfoFullInfo2Internal_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoFullInfo2Internal *object = (struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoFullInfo2Internal_getsetters[] = {
	{ discard_const_p(char, "info"), py_lsa_TrustDomainInfoFullInfo2Internal_get_info, py_lsa_TrustDomainInfoFullInfo2Internal_set_info },
	{ discard_const_p(char, "posix_offset"), py_lsa_TrustDomainInfoFullInfo2Internal_get_posix_offset, py_lsa_TrustDomainInfoFullInfo2Internal_set_posix_offset },
	{ discard_const_p(char, "auth_info"), py_lsa_TrustDomainInfoFullInfo2Internal_get_auth_info, py_lsa_TrustDomainInfoFullInfo2Internal_set_auth_info },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoFullInfo2Internal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoFullInfo2Internal, type);
}


static PyTypeObject lsa_TrustDomainInfoFullInfo2Internal_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoFullInfo2Internal",
	.tp_getset = py_lsa_TrustDomainInfoFullInfo2Internal_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoFullInfo2Internal_new,
};


static PyObject *py_lsa_TrustDomainInfoSupportedEncTypes_get_enc_types(PyObject *obj, void *closure)
{
	struct lsa_TrustDomainInfoSupportedEncTypes *object = (struct lsa_TrustDomainInfoSupportedEncTypes *)pytalloc_get_ptr(obj);
	PyObject *py_enc_types;
	py_enc_types = PyInt_FromLong(object->enc_types);
	return py_enc_types;
}

static int py_lsa_TrustDomainInfoSupportedEncTypes_set_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TrustDomainInfoSupportedEncTypes *object = (struct lsa_TrustDomainInfoSupportedEncTypes *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->enc_types = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->enc_types = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_TrustDomainInfoSupportedEncTypes_getsetters[] = {
	{ discard_const_p(char, "enc_types"), py_lsa_TrustDomainInfoSupportedEncTypes_get_enc_types, py_lsa_TrustDomainInfoSupportedEncTypes_set_enc_types },
	{ NULL }
};

static PyObject *py_lsa_TrustDomainInfoSupportedEncTypes_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TrustDomainInfoSupportedEncTypes, type);
}


static PyTypeObject lsa_TrustDomainInfoSupportedEncTypes_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TrustDomainInfoSupportedEncTypes",
	.tp_getset = py_lsa_TrustDomainInfoSupportedEncTypes_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TrustDomainInfoSupportedEncTypes_new,
};

PyObject *py_import_lsa_TrustedDomainInfo(TALLOC_CTX *mem_ctx, int level, union lsa_TrustedDomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoName_Type, mem_ctx, &in->name);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoControllers_Type, mem_ctx, &in->controllers);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoPosixOffset_Type, mem_ctx, &in->posix_offset);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoPassword_Type, mem_ctx, &in->password);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoBasic_Type, mem_ctx, &in->info_basic);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, mem_ctx, &in->info_ex);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfo_Type, mem_ctx, &in->auth_info);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfo_Type, mem_ctx, &in->full_info);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoAuthInfoInternal_Type, mem_ctx, &in->auth_info_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfoInternal_Type, mem_ctx, &in->full_info_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx2Internal_Type, mem_ctx, &in->info_ex2_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoFullInfo2Internal_Type, mem_ctx, &in->full_info2_internal);
			return ret;

		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			ret = pytalloc_reference_ex(&lsa_TrustDomainInfoSupportedEncTypes_Type, mem_ctx, &in->enc_types);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union lsa_TrustedDomainInfo *py_export_lsa_TrustedDomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_TrustedDomainInfo *ret = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo);
	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct lsa_TrustDomainInfoName *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoControllers_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->controllers = *(struct lsa_TrustDomainInfoControllers *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoPosixOffset_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->posix_offset = *(struct lsa_TrustDomainInfoPosixOffset *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoPassword_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->password = *(struct lsa_TrustDomainInfoPassword *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoBasic_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_basic = *(struct lsa_TrustDomainInfoBasic *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_ex = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth_info = *(struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info = *(struct lsa_TrustDomainInfoFullInfo *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth_info_internal = *(struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfoInternal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info_internal = *(struct lsa_TrustDomainInfoFullInfoInternal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx2Internal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info_ex2_internal = *(struct lsa_TrustDomainInfoInfoEx2Internal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoFullInfo2Internal_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->full_info2_internal = *(struct lsa_TrustDomainInfoFullInfo2Internal *)pytalloc_get_ptr(in);
			break;

		case LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES:
			PY_CHECK_TYPE(&lsa_TrustDomainInfoSupportedEncTypes_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->enc_types = *(struct lsa_TrustDomainInfoSupportedEncTypes *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_lsa_DATA_BUF_PTR_get_buf(PyObject *obj, void *closure)
{
	struct lsa_DATA_BUF_PTR *object = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(obj);
	PyObject *py_buf;
	if (object->buf == NULL) {
		py_buf = Py_None;
		Py_INCREF(py_buf);
	} else {
		py_buf = pytalloc_reference_ex(&lsa_DATA_BUF_Type, object->buf, object->buf);
	}
	return py_buf;
}

static int py_lsa_DATA_BUF_PTR_set_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DATA_BUF_PTR *object = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->buf);
	if (value == Py_None) {
		object->buf = NULL;
	} else {
		object->buf = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->buf = (struct lsa_DATA_BUF *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_lsa_DATA_BUF_PTR_getsetters[] = {
	{ discard_const_p(char, "buf"), py_lsa_DATA_BUF_PTR_get_buf, py_lsa_DATA_BUF_PTR_set_buf },
	{ NULL }
};

static PyObject *py_lsa_DATA_BUF_PTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DATA_BUF_PTR, type);
}


static PyTypeObject lsa_DATA_BUF_PTR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DATA_BUF_PTR",
	.tp_getset = py_lsa_DATA_BUF_PTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DATA_BUF_PTR_new,
};


static PyObject *py_lsa_RightAttribute_get_name(PyObject *obj, void *closure)
{
	struct lsa_RightAttribute *object = (struct lsa_RightAttribute *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_lsa_RightAttribute_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightAttribute *object = (struct lsa_RightAttribute *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_RightAttribute_getsetters[] = {
	{ discard_const_p(char, "name"), py_lsa_RightAttribute_get_name, py_lsa_RightAttribute_set_name },
	{ NULL }
};

static PyObject *py_lsa_RightAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RightAttribute, type);
}


static PyTypeObject lsa_RightAttribute_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.RightAttribute",
	.tp_getset = py_lsa_RightAttribute_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_RightAttribute_new,
};


static PyObject *py_lsa_RightSet_get_count(PyObject *obj, void *closure)
{
	struct lsa_RightSet *object = (struct lsa_RightSet *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_RightSet_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightSet *object = (struct lsa_RightSet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_RightSet_get_names(PyObject *obj, void *closure)
{
	struct lsa_RightSet *object = (struct lsa_RightSet *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < object->count; names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_StringLarge_Type, object->names, &object->names[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_RightSet_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_RightSet *object = (struct lsa_RightSet *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->names);
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1;; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				PY_CHECK_TYPE(&lsa_StringLarge_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->names[names_cntr_1] = *(struct lsa_StringLarge *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_RightSet_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_RightSet_get_count, py_lsa_RightSet_set_count },
	{ discard_const_p(char, "names"), py_lsa_RightSet_get_names, py_lsa_RightSet_set_names },
	{ NULL }
};

static PyObject *py_lsa_RightSet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_RightSet, type);
}


static PyTypeObject lsa_RightSet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.RightSet",
	.tp_getset = py_lsa_RightSet_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_RightSet_new,
};


static PyObject *py_lsa_DomainListEx_get_count(PyObject *obj, void *closure)
{
	struct lsa_DomainListEx *object = (struct lsa_DomainListEx *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_DomainListEx_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainListEx *object = (struct lsa_DomainListEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DomainListEx_get_domains(PyObject *obj, void *closure)
{
	struct lsa_DomainListEx *object = (struct lsa_DomainListEx *)pytalloc_get_ptr(obj);
	PyObject *py_domains;
	if (object->domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = PyList_New(object->count);
		if (py_domains == NULL) {
			return NULL;
		}
		{
			int domains_cntr_1;
			for (domains_cntr_1 = 0; domains_cntr_1 < object->count; domains_cntr_1++) {
				PyObject *py_domains_1;
				py_domains_1 = pytalloc_reference_ex(&lsa_TrustDomainInfoInfoEx_Type, object->domains, &object->domains[domains_cntr_1]);
				PyList_SetItem(py_domains, domains_cntr_1, py_domains_1);
			}
		}
	}
	return py_domains;
}

static int py_lsa_DomainListEx_set_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainListEx *object = (struct lsa_DomainListEx *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domains);
	if (value == Py_None) {
		object->domains = NULL;
	} else {
		object->domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int domains_cntr_1;
			object->domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->domains, PyList_GET_SIZE(value));
			if (!object->domains) { return -1;; }
			talloc_set_name_const(object->domains, "ARRAY: object->domains");
			for (domains_cntr_1 = 0; domains_cntr_1 < PyList_GET_SIZE(value); domains_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, PyList_GET_ITEM(value, domains_cntr_1), return -1;);
				if (talloc_reference(object->domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->domains[domains_cntr_1] = *(struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(PyList_GET_ITEM(value, domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainListEx_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_DomainListEx_get_count, py_lsa_DomainListEx_set_count },
	{ discard_const_p(char, "domains"), py_lsa_DomainListEx_get_domains, py_lsa_DomainListEx_set_domains },
	{ NULL }
};

static PyObject *py_lsa_DomainListEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainListEx, type);
}


static PyTypeObject lsa_DomainListEx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DomainListEx",
	.tp_getset = py_lsa_DomainListEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DomainListEx_new,
};


static PyObject *py_lsa_DomainInfoKerberos_get_authentication_options(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_authentication_options;
	py_authentication_options = PyInt_FromLong(object->authentication_options);
	return py_authentication_options;
}

static int py_lsa_DomainInfoKerberos_set_authentication_options(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->authentication_options = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->authentication_options = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_service_tkt_lifetime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_service_tkt_lifetime;
	py_service_tkt_lifetime = PyLong_FromLongLong(object->service_tkt_lifetime);
	return py_service_tkt_lifetime;
}

static int py_lsa_DomainInfoKerberos_set_service_tkt_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->service_tkt_lifetime = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->service_tkt_lifetime = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_user_tkt_lifetime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_user_tkt_lifetime;
	py_user_tkt_lifetime = PyLong_FromLongLong(object->user_tkt_lifetime);
	return py_user_tkt_lifetime;
}

static int py_lsa_DomainInfoKerberos_set_user_tkt_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->user_tkt_lifetime = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->user_tkt_lifetime = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_user_tkt_renewaltime(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_user_tkt_renewaltime;
	py_user_tkt_renewaltime = PyLong_FromLongLong(object->user_tkt_renewaltime);
	return py_user_tkt_renewaltime;
}

static int py_lsa_DomainInfoKerberos_set_user_tkt_renewaltime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->user_tkt_renewaltime = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->user_tkt_renewaltime = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_clock_skew(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_clock_skew;
	py_clock_skew = PyLong_FromLongLong(object->clock_skew);
	return py_clock_skew;
}

static int py_lsa_DomainInfoKerberos_set_clock_skew(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->clock_skew = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->clock_skew = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_DomainInfoKerberos_get_reserved(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLongLong(object->reserved);
	return py_reserved;
}

static int py_lsa_DomainInfoKerberos_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoKerberos *object = (struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->reserved = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->reserved = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfoKerberos_getsetters[] = {
	{ discard_const_p(char, "authentication_options"), py_lsa_DomainInfoKerberos_get_authentication_options, py_lsa_DomainInfoKerberos_set_authentication_options },
	{ discard_const_p(char, "service_tkt_lifetime"), py_lsa_DomainInfoKerberos_get_service_tkt_lifetime, py_lsa_DomainInfoKerberos_set_service_tkt_lifetime },
	{ discard_const_p(char, "user_tkt_lifetime"), py_lsa_DomainInfoKerberos_get_user_tkt_lifetime, py_lsa_DomainInfoKerberos_set_user_tkt_lifetime },
	{ discard_const_p(char, "user_tkt_renewaltime"), py_lsa_DomainInfoKerberos_get_user_tkt_renewaltime, py_lsa_DomainInfoKerberos_set_user_tkt_renewaltime },
	{ discard_const_p(char, "clock_skew"), py_lsa_DomainInfoKerberos_get_clock_skew, py_lsa_DomainInfoKerberos_set_clock_skew },
	{ discard_const_p(char, "reserved"), py_lsa_DomainInfoKerberos_get_reserved, py_lsa_DomainInfoKerberos_set_reserved },
	{ NULL }
};

static PyObject *py_lsa_DomainInfoKerberos_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfoKerberos, type);
}


static PyTypeObject lsa_DomainInfoKerberos_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DomainInfoKerberos",
	.tp_getset = py_lsa_DomainInfoKerberos_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DomainInfoKerberos_new,
};


static PyObject *py_lsa_DomainInfoEfs_get_blob_size(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoEfs *object = (struct lsa_DomainInfoEfs *)pytalloc_get_ptr(obj);
	PyObject *py_blob_size;
	py_blob_size = PyInt_FromLong(object->blob_size);
	return py_blob_size;
}

static int py_lsa_DomainInfoEfs_set_blob_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoEfs *object = (struct lsa_DomainInfoEfs *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->blob_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_DomainInfoEfs_get_efs_blob(PyObject *obj, void *closure)
{
	struct lsa_DomainInfoEfs *object = (struct lsa_DomainInfoEfs *)pytalloc_get_ptr(obj);
	PyObject *py_efs_blob;
	if (object->efs_blob == NULL) {
		py_efs_blob = Py_None;
		Py_INCREF(py_efs_blob);
	} else {
		py_efs_blob = PyList_New(object->blob_size);
		if (py_efs_blob == NULL) {
			return NULL;
		}
		{
			int efs_blob_cntr_1;
			for (efs_blob_cntr_1 = 0; efs_blob_cntr_1 < object->blob_size; efs_blob_cntr_1++) {
				PyObject *py_efs_blob_1;
				py_efs_blob_1 = PyInt_FromLong(object->efs_blob[efs_blob_cntr_1]);
				PyList_SetItem(py_efs_blob, efs_blob_cntr_1, py_efs_blob_1);
			}
		}
	}
	return py_efs_blob;
}

static int py_lsa_DomainInfoEfs_set_efs_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_DomainInfoEfs *object = (struct lsa_DomainInfoEfs *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->efs_blob);
	if (value == Py_None) {
		object->efs_blob = NULL;
	} else {
		object->efs_blob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int efs_blob_cntr_1;
			object->efs_blob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->efs_blob, PyList_GET_SIZE(value));
			if (!object->efs_blob) { return -1;; }
			talloc_set_name_const(object->efs_blob, "ARRAY: object->efs_blob");
			for (efs_blob_cntr_1 = 0; efs_blob_cntr_1 < PyList_GET_SIZE(value); efs_blob_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, efs_blob_cntr_1), return -1;);
				object->efs_blob[efs_blob_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, efs_blob_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_DomainInfoEfs_getsetters[] = {
	{ discard_const_p(char, "blob_size"), py_lsa_DomainInfoEfs_get_blob_size, py_lsa_DomainInfoEfs_set_blob_size },
	{ discard_const_p(char, "efs_blob"), py_lsa_DomainInfoEfs_get_efs_blob, py_lsa_DomainInfoEfs_set_efs_blob },
	{ NULL }
};

static PyObject *py_lsa_DomainInfoEfs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_DomainInfoEfs, type);
}


static PyTypeObject lsa_DomainInfoEfs_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.DomainInfoEfs",
	.tp_getset = py_lsa_DomainInfoEfs_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_DomainInfoEfs_new,
};

PyObject *py_import_lsa_DomainInformationPolicy(TALLOC_CTX *mem_ctx, int level, union lsa_DomainInformationPolicy *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_EFS:
			ret = pytalloc_reference_ex(&lsa_DomainInfoEfs_Type, mem_ctx, &in->efs_info);
			return ret;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			ret = pytalloc_reference_ex(&lsa_DomainInfoKerberos_Type, mem_ctx, &in->kerberos_info);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union lsa_DomainInformationPolicy *py_export_lsa_DomainInformationPolicy(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_DomainInformationPolicy *ret = talloc_zero(mem_ctx, union lsa_DomainInformationPolicy);
	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_EFS:
			PY_CHECK_TYPE(&lsa_DomainInfoEfs_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->efs_info = *(struct lsa_DomainInfoEfs *)pytalloc_get_ptr(in);
			break;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			PY_CHECK_TYPE(&lsa_DomainInfoKerberos_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->kerberos_info = *(struct lsa_DomainInfoKerberos *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_lsa_TranslatedName2_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyInt_FromLong(object->sid_type);
	return py_sid_type;
}

static int py_lsa_TranslatedName2_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sid_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sid_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_name(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_TranslatedName2_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyInt_FromLong(object->sid_index);
	return py_sid_index;
}

static int py_lsa_TranslatedName2_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TranslatedName2_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_lsa_TranslatedName2_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedName2 *object = (struct lsa_TranslatedName2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TranslatedName2_getsetters[] = {
	{ discard_const_p(char, "sid_type"), py_lsa_TranslatedName2_get_sid_type, py_lsa_TranslatedName2_set_sid_type },
	{ discard_const_p(char, "name"), py_lsa_TranslatedName2_get_name, py_lsa_TranslatedName2_set_name },
	{ discard_const_p(char, "sid_index"), py_lsa_TranslatedName2_get_sid_index, py_lsa_TranslatedName2_set_sid_index },
	{ discard_const_p(char, "unknown"), py_lsa_TranslatedName2_get_unknown, py_lsa_TranslatedName2_set_unknown },
	{ NULL }
};

static PyObject *py_lsa_TranslatedName2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedName2, type);
}


static PyTypeObject lsa_TranslatedName2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TranslatedName2",
	.tp_getset = py_lsa_TranslatedName2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TranslatedName2_new,
};


static PyObject *py_lsa_TransNameArray2_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray2 *object = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_TransNameArray2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray2 *object = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TransNameArray2_get_names(PyObject *obj, void *closure)
{
	struct lsa_TransNameArray2 *object = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < object->count; names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&lsa_TranslatedName2_Type, object->names, &object->names[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_lsa_TransNameArray2_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransNameArray2 *object = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->names);
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1;; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TranslatedName2_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->names[names_cntr_1] = *(struct lsa_TranslatedName2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransNameArray2_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_TransNameArray2_get_count, py_lsa_TransNameArray2_set_count },
	{ discard_const_p(char, "names"), py_lsa_TransNameArray2_get_names, py_lsa_TransNameArray2_set_names },
	{ NULL }
};

static PyObject *py_lsa_TransNameArray2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransNameArray2, type);
}


static PyTypeObject lsa_TransNameArray2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TransNameArray2",
	.tp_getset = py_lsa_TransNameArray2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TransNameArray2_new,
};


static PyObject *py_lsa_TranslatedSid2_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyInt_FromLong(object->sid_type);
	return py_sid_type;
}

static int py_lsa_TranslatedSid2_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sid_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sid_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_rid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_lsa_TranslatedSid2_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyInt_FromLong(object->sid_index);
	return py_sid_index;
}

static int py_lsa_TranslatedSid2_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TranslatedSid2_get_unknown(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_lsa_TranslatedSid2_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid2 *object = (struct lsa_TranslatedSid2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid2_getsetters[] = {
	{ discard_const_p(char, "sid_type"), py_lsa_TranslatedSid2_get_sid_type, py_lsa_TranslatedSid2_set_sid_type },
	{ discard_const_p(char, "rid"), py_lsa_TranslatedSid2_get_rid, py_lsa_TranslatedSid2_set_rid },
	{ discard_const_p(char, "sid_index"), py_lsa_TranslatedSid2_get_sid_index, py_lsa_TranslatedSid2_set_sid_index },
	{ discard_const_p(char, "unknown"), py_lsa_TranslatedSid2_get_unknown, py_lsa_TranslatedSid2_set_unknown },
	{ NULL }
};

static PyObject *py_lsa_TranslatedSid2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid2, type);
}


static PyTypeObject lsa_TranslatedSid2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TranslatedSid2",
	.tp_getset = py_lsa_TranslatedSid2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TranslatedSid2_new,
};


static PyObject *py_lsa_TransSidArray2_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray2 *object = (struct lsa_TransSidArray2 *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_TransSidArray2_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray2 *object = (struct lsa_TransSidArray2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TransSidArray2_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray2 *object = (struct lsa_TransSidArray2 *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->count; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid2_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray2_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray2 *object = (struct lsa_TransSidArray2 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TranslatedSid2_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct lsa_TranslatedSid2 *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray2_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_TransSidArray2_get_count, py_lsa_TransSidArray2_set_count },
	{ discard_const_p(char, "sids"), py_lsa_TransSidArray2_get_sids, py_lsa_TransSidArray2_set_sids },
	{ NULL }
};

static PyObject *py_lsa_TransSidArray2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray2, type);
}


static PyTypeObject lsa_TransSidArray2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TransSidArray2",
	.tp_getset = py_lsa_TransSidArray2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TransSidArray2_new,
};


static PyObject *py_lsa_TranslatedSid3_get_sid_type(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_type;
	py_sid_type = PyInt_FromLong(object->sid_type);
	return py_sid_type;
}

static int py_lsa_TranslatedSid3_set_sid_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sid_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sid_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_sid(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_lsa_TranslatedSid3_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_sid_index(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(obj);
	PyObject *py_sid_index;
	py_sid_index = PyInt_FromLong(object->sid_index);
	return py_sid_index;
}

static int py_lsa_TranslatedSid3_set_sid_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TranslatedSid3_get_flags(PyObject *obj, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_lsa_TranslatedSid3_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TranslatedSid3 *object = (struct lsa_TranslatedSid3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_lsa_TranslatedSid3_getsetters[] = {
	{ discard_const_p(char, "sid_type"), py_lsa_TranslatedSid3_get_sid_type, py_lsa_TranslatedSid3_set_sid_type },
	{ discard_const_p(char, "sid"), py_lsa_TranslatedSid3_get_sid, py_lsa_TranslatedSid3_set_sid },
	{ discard_const_p(char, "sid_index"), py_lsa_TranslatedSid3_get_sid_index, py_lsa_TranslatedSid3_set_sid_index },
	{ discard_const_p(char, "flags"), py_lsa_TranslatedSid3_get_flags, py_lsa_TranslatedSid3_set_flags },
	{ NULL }
};

static PyObject *py_lsa_TranslatedSid3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TranslatedSid3, type);
}


static PyTypeObject lsa_TranslatedSid3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TranslatedSid3",
	.tp_getset = py_lsa_TranslatedSid3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TranslatedSid3_new,
};


static PyObject *py_lsa_TransSidArray3_get_count(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray3 *object = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_TransSidArray3_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray3 *object = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_TransSidArray3_get_sids(PyObject *obj, void *closure)
{
	struct lsa_TransSidArray3 *object = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->count);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->count; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&lsa_TranslatedSid3_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_lsa_TransSidArray3_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_TransSidArray3 *object = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&lsa_TranslatedSid3_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct lsa_TranslatedSid3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_TransSidArray3_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_TransSidArray3_get_count, py_lsa_TransSidArray3_set_count },
	{ discard_const_p(char, "sids"), py_lsa_TransSidArray3_get_sids, py_lsa_TransSidArray3_set_sids },
	{ NULL }
};

static PyObject *py_lsa_TransSidArray3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_TransSidArray3, type);
}


static PyTypeObject lsa_TransSidArray3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.TransSidArray3",
	.tp_getset = py_lsa_TransSidArray3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_TransSidArray3_new,
};


static PyObject *py_lsa_ForestTrustBinaryData_get_length(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = (struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_lsa_ForestTrustBinaryData_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = (struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustBinaryData_get_data(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = (struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_lsa_ForestTrustBinaryData_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustBinaryData *object = (struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustBinaryData_getsetters[] = {
	{ discard_const_p(char, "length"), py_lsa_ForestTrustBinaryData_get_length, py_lsa_ForestTrustBinaryData_set_length },
	{ discard_const_p(char, "data"), py_lsa_ForestTrustBinaryData_get_data, py_lsa_ForestTrustBinaryData_set_data },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustBinaryData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustBinaryData, type);
}


static PyTypeObject lsa_ForestTrustBinaryData_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustBinaryData",
	.tp_getset = py_lsa_ForestTrustBinaryData_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustBinaryData_new,
};


static PyObject *py_lsa_ForestTrustDomainInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_lsa_ForestTrustDomainInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domain_sid);
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustDomainInfo_get_dns_domain_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name;
	py_dns_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domain_name);
	return py_dns_domain_name;
}

static int py_lsa_ForestTrustDomainInfo_set_dns_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustDomainInfo_get_netbios_domain_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_domain_name;
	py_netbios_domain_name = pytalloc_reference_ex(&lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->netbios_domain_name);
	return py_netbios_domain_name;
}

static int py_lsa_ForestTrustDomainInfo_set_netbios_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustDomainInfo *object = (struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->netbios_domain_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustDomainInfo_getsetters[] = {
	{ discard_const_p(char, "domain_sid"), py_lsa_ForestTrustDomainInfo_get_domain_sid, py_lsa_ForestTrustDomainInfo_set_domain_sid },
	{ discard_const_p(char, "dns_domain_name"), py_lsa_ForestTrustDomainInfo_get_dns_domain_name, py_lsa_ForestTrustDomainInfo_set_dns_domain_name },
	{ discard_const_p(char, "netbios_domain_name"), py_lsa_ForestTrustDomainInfo_get_netbios_domain_name, py_lsa_ForestTrustDomainInfo_set_netbios_domain_name },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustDomainInfo, type);
}


static PyTypeObject lsa_ForestTrustDomainInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustDomainInfo",
	.tp_getset = py_lsa_ForestTrustDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustDomainInfo_new,
};

PyObject *py_import_lsa_ForestTrustData(TALLOC_CTX *mem_ctx, int level, union lsa_ForestTrustData *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name);
			return ret;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			ret = pytalloc_reference_ex(&lsa_StringLarge_Type, mem_ctx, &in->top_level_name_ex);
			return ret;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			ret = pytalloc_reference_ex(&lsa_ForestTrustDomainInfo_Type, mem_ctx, &in->domain_info);
			return ret;

		default:
			ret = pytalloc_reference_ex(&lsa_ForestTrustBinaryData_Type, mem_ctx, &in->data);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union lsa_ForestTrustData *py_export_lsa_ForestTrustData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_ForestTrustData *ret = talloc_zero(mem_ctx, union lsa_ForestTrustData);
	switch (level) {
		case LSA_FOREST_TRUST_TOP_LEVEL_NAME:
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX:
			PY_CHECK_TYPE(&lsa_StringLarge_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->top_level_name_ex = *(struct lsa_StringLarge *)pytalloc_get_ptr(in);
			break;

		case LSA_FOREST_TRUST_DOMAIN_INFO:
			PY_CHECK_TYPE(&lsa_ForestTrustDomainInfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain_info = *(struct lsa_ForestTrustDomainInfo *)pytalloc_get_ptr(in);
			break;

		default:
			PY_CHECK_TYPE(&lsa_ForestTrustBinaryData_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct lsa_ForestTrustBinaryData *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}


static PyObject *py_lsa_ForestTrustRecord_get_flags(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_lsa_ForestTrustRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_type(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_lsa_ForestTrustRecord_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_time(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromLongLong(object->time);
	return py_time;
}

static int py_lsa_ForestTrustRecord_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustRecord_get_forest_trust_data(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(obj);
	PyObject *py_forest_trust_data;
	py_forest_trust_data = py_import_lsa_ForestTrustData(pytalloc_get_mem_ctx(obj), object->type, &object->forest_trust_data);
	if (py_forest_trust_data == NULL) {
		return NULL;
	}
	return py_forest_trust_data;
}

static int py_lsa_ForestTrustRecord_set_forest_trust_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustRecord *object = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(py_obj);
	{
		union lsa_ForestTrustData *forest_trust_data_switch_0;
		forest_trust_data_switch_0 = py_export_lsa_ForestTrustData(pytalloc_get_mem_ctx(py_obj), object->type, value);
		if (forest_trust_data_switch_0 == NULL) {
			return -1;
		}
		object->forest_trust_data = *forest_trust_data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustRecord_getsetters[] = {
	{ discard_const_p(char, "flags"), py_lsa_ForestTrustRecord_get_flags, py_lsa_ForestTrustRecord_set_flags },
	{ discard_const_p(char, "type"), py_lsa_ForestTrustRecord_get_type, py_lsa_ForestTrustRecord_set_type },
	{ discard_const_p(char, "time"), py_lsa_ForestTrustRecord_get_time, py_lsa_ForestTrustRecord_set_time },
	{ discard_const_p(char, "forest_trust_data"), py_lsa_ForestTrustRecord_get_forest_trust_data, py_lsa_ForestTrustRecord_set_forest_trust_data },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustRecord, type);
}


static PyTypeObject lsa_ForestTrustRecord_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustRecord",
	.tp_getset = py_lsa_ForestTrustRecord_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustRecord_new,
};


static PyObject *py_lsa_ForestTrustInformation_get_count(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_ForestTrustInformation_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustInformation_get_entries(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < object->count; entries_cntr_1++) {
				PyObject *py_entries_1;
				if (object->entries[entries_cntr_1] == NULL) {
					py_entries_1 = Py_None;
					Py_INCREF(py_entries_1);
				} else {
					py_entries_1 = pytalloc_reference_ex(&lsa_ForestTrustRecord_Type, object->entries[entries_cntr_1], object->entries[entries_cntr_1]);
				}
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_lsa_ForestTrustInformation_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->entries);
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1;; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == Py_None) {
					object->entries[entries_cntr_1] = NULL;
				} else {
					object->entries[entries_cntr_1] = NULL;
					PY_CHECK_TYPE(&lsa_ForestTrustRecord_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
					if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					object->entries[entries_cntr_1] = (struct lsa_ForestTrustRecord *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustInformation_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_ForestTrustInformation_get_count, py_lsa_ForestTrustInformation_set_count },
	{ discard_const_p(char, "entries"), py_lsa_ForestTrustInformation_get_entries, py_lsa_ForestTrustInformation_set_entries },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustInformation, type);
}

static PyObject *py_lsa_ForestTrustInformation_ndr_pack(PyObject *py_obj)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustInformation);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_ForestTrustInformation_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustInformation);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustInformation_ndr_print(PyObject *py_obj)
{
	struct lsa_ForestTrustInformation *object = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustInformation, "lsa_ForestTrustInformation", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustInformation_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustInformation_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_ForestTrustInformation_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustInformation_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustInformation_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustInformation",
	.tp_getset = py_lsa_ForestTrustInformation_getsetters,
	.tp_methods = py_lsa_ForestTrustInformation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustInformation_new,
};

PyObject *py_import_lsa_ForestTrustCollisionFlags(TALLOC_CTX *mem_ctx, int level, union lsa_ForestTrustCollisionFlags *in)
{
	PyObject *ret;

	switch (level) {
		case LSA_FOREST_TRUST_COLLISION_TDO:
			ret = PyInt_FromLong(in->flags);
			return ret;

		case LSA_FOREST_TRUST_COLLISION_XREF:
			ret = PyInt_FromLong(in->flags);
			return ret;

		default:
			ret = PyInt_FromLong(in->flags);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union lsa_ForestTrustCollisionFlags *py_export_lsa_ForestTrustCollisionFlags(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union lsa_ForestTrustCollisionFlags *ret = talloc_zero(mem_ctx, union lsa_ForestTrustCollisionFlags);
	switch (level) {
		case LSA_FOREST_TRUST_COLLISION_TDO:
			if (PyLong_Check(in)) {
				ret->flags = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->flags = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case LSA_FOREST_TRUST_COLLISION_XREF:
			if (PyLong_Check(in)) {
				ret->flags = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->flags = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		default:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->flags = PyInt_AsLong(in);
			break;

	}

	return ret;
}


static PyObject *py_lsa_ForestTrustCollisionRecord_get_index(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(obj);
	PyObject *py_index;
	py_index = PyInt_FromLong(object->index);
	return py_index;
}

static int py_lsa_ForestTrustCollisionRecord_set_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_type(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_lsa_ForestTrustCollisionRecord_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_flags(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = py_import_lsa_ForestTrustCollisionFlags(pytalloc_get_mem_ctx(obj), object->type, &object->flags);
	if (py_flags == NULL) {
		return NULL;
	}
	return py_flags;
}

static int py_lsa_ForestTrustCollisionRecord_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	{
		union lsa_ForestTrustCollisionFlags *flags_switch_0;
		flags_switch_0 = py_export_lsa_ForestTrustCollisionFlags(pytalloc_get_mem_ctx(py_obj), object->type, value);
		if (flags_switch_0 == NULL) {
			return -1;
		}
		object->flags = *flags_switch_0;
	}
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_get_name(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_lsa_ForestTrustCollisionRecord_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustCollisionRecord_getsetters[] = {
	{ discard_const_p(char, "index"), py_lsa_ForestTrustCollisionRecord_get_index, py_lsa_ForestTrustCollisionRecord_set_index },
	{ discard_const_p(char, "type"), py_lsa_ForestTrustCollisionRecord_get_type, py_lsa_ForestTrustCollisionRecord_set_type },
	{ discard_const_p(char, "flags"), py_lsa_ForestTrustCollisionRecord_get_flags, py_lsa_ForestTrustCollisionRecord_set_flags },
	{ discard_const_p(char, "name"), py_lsa_ForestTrustCollisionRecord_get_name, py_lsa_ForestTrustCollisionRecord_set_name },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustCollisionRecord_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustCollisionRecord, type);
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_pack(PyObject *py_obj)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustCollisionRecord);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionRecord);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionRecord);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustCollisionRecord_ndr_print(PyObject *py_obj)
{
	struct lsa_ForestTrustCollisionRecord *object = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustCollisionRecord, "lsa_ForestTrustCollisionRecord", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustCollisionRecord_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustCollisionRecord_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_ForestTrustCollisionRecord_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustCollisionRecord_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustCollisionRecord_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustCollisionRecord",
	.tp_getset = py_lsa_ForestTrustCollisionRecord_getsetters,
	.tp_methods = py_lsa_ForestTrustCollisionRecord_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustCollisionRecord_new,
};


static PyObject *py_lsa_ForestTrustCollisionInfo_get_count(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_lsa_ForestTrustCollisionInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_lsa_ForestTrustCollisionInfo_get_entries(PyObject *obj, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < object->count; entries_cntr_1++) {
				PyObject *py_entries_1;
				if (object->entries[entries_cntr_1] == NULL) {
					py_entries_1 = Py_None;
					Py_INCREF(py_entries_1);
				} else {
					py_entries_1 = pytalloc_reference_ex(&lsa_ForestTrustCollisionRecord_Type, object->entries[entries_cntr_1], object->entries[entries_cntr_1]);
				}
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_lsa_ForestTrustCollisionInfo_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->entries);
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1;; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == Py_None) {
					object->entries[entries_cntr_1] = NULL;
				} else {
					object->entries[entries_cntr_1] = NULL;
					PY_CHECK_TYPE(&lsa_ForestTrustCollisionRecord_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
					if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					object->entries[entries_cntr_1] = (struct lsa_ForestTrustCollisionRecord *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_lsa_ForestTrustCollisionInfo_getsetters[] = {
	{ discard_const_p(char, "count"), py_lsa_ForestTrustCollisionInfo_get_count, py_lsa_ForestTrustCollisionInfo_set_count },
	{ discard_const_p(char, "entries"), py_lsa_ForestTrustCollisionInfo_get_entries, py_lsa_ForestTrustCollisionInfo_set_entries },
	{ NULL }
};

static PyObject *py_lsa_ForestTrustCollisionInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct lsa_ForestTrustCollisionInfo, type);
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_pack(PyObject *py_obj)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_lsa_ForestTrustCollisionInfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_lsa_ForestTrustCollisionInfo);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_lsa_ForestTrustCollisionInfo_ndr_print(PyObject *py_obj)
{
	struct lsa_ForestTrustCollisionInfo *object = (struct lsa_ForestTrustCollisionInfo *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_lsa_ForestTrustCollisionInfo, "lsa_ForestTrustCollisionInfo", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_lsa_ForestTrustCollisionInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_lsa_ForestTrustCollisionInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_lsa_ForestTrustCollisionInfo_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_lsa_ForestTrustCollisionInfo_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject lsa_ForestTrustCollisionInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.ForestTrustCollisionInfo",
	.tp_getset = py_lsa_ForestTrustCollisionInfo_getsetters,
	.tp_methods = py_lsa_ForestTrustCollisionInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_lsa_ForestTrustCollisionInfo_new,
};


static bool pack_py_lsa_Close_args_in(PyObject *args, PyObject *kwargs, struct lsa_Close *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_Close", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_Close_args_out(struct lsa_Close *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_Delete_args_in(PyObject *args, PyObject *kwargs, struct lsa_Delete *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_Delete", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_Delete_args_out(struct lsa_Delete *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumPrivs_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumPrivs *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_count;
	const char *kwnames[] = {
		"handle", "resume_handle", "max_count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumPrivs", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_max_count)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
	*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_max_count, return false;);
	r->in.max_count = PyInt_AsLong(py_max_count);
	return true;
}

static PyObject *unpack_py_lsa_EnumPrivs_args_out(struct lsa_EnumPrivs *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_privs;
	result = PyTuple_New(2);
	py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_privs = pytalloc_reference_ex(&lsa_PrivArray_Type, r->out.privs, r->out.privs);
	PyTuple_SetItem(result, 1, py_privs);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QuerySecurity_args_in(PyObject *args, PyObject *kwargs, struct lsa_QuerySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	const char *kwnames[] = {
		"handle", "sec_info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QuerySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_sec_info)) {
		r->in.sec_info = PyLong_AsLongLong(py_sec_info);
	} else if (PyInt_Check(py_sec_info)) {
		r->in.sec_info = PyInt_AsLong(py_sec_info);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QuerySecurity_args_out(struct lsa_QuerySecurity *r)
{
	PyObject *result;
	PyObject *py_sdbuf;
	if (*r->out.sdbuf == NULL) {
		py_sdbuf = Py_None;
		Py_INCREF(py_sdbuf);
	} else {
		py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, *r->out.sdbuf, *r->out.sdbuf);
	}
	result = py_sdbuf;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetSecObj_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSecObj *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sdbuf;
	const char *kwnames[] = {
		"handle", "sec_info", "sdbuf", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetSecObj", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sdbuf)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_sec_info)) {
		r->in.sec_info = PyLong_AsLongLong(py_sec_info);
	} else if (PyInt_Check(py_sec_info)) {
		r->in.sec_info = PyInt_AsLong(py_sec_info);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sdbuf = talloc_ptrtype(r, r->in.sdbuf);
	PY_CHECK_TYPE(sec_desc_buf_Type, py_sdbuf, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sdbuf)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(py_sdbuf);
	return true;
}

static PyObject *unpack_py_lsa_SetSecObj_args_out(struct lsa_SetSecObj *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenPolicy *r)
{
	PyObject *py_system_name;
	PyObject *py_attr;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "attr", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenPolicy", discard_const_p(char *, kwnames), &py_system_name, &py_attr, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		PY_CHECK_TYPE(&PyInt_Type, py_system_name, return false;);
		*r->in.system_name = PyInt_AsLong(py_system_name);
	}
	r->in.attr = talloc_ptrtype(r, r->in.attr);
	PY_CHECK_TYPE(&lsa_ObjectAttribute_Type, py_attr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_attr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.attr = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_attr);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenPolicy_args_out(struct lsa_OpenPolicy *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryInfoPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryInfoPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryInfoPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryInfoPolicy_args_out(struct lsa_QueryInfoPolicy *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_PolicyInformation(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetInfoPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetInfoPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetInfoPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	{
		union lsa_PolicyInformation *info_switch_1;
		info_switch_1 = py_export_lsa_PolicyInformation(r, r->in.level, py_info);
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetInfoPolicy_args_out(struct lsa_SetInfoPolicy *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CreateAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateAccount *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateAccount", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateAccount_args_out(struct lsa_CreateAccount *r)
{
	PyObject *result;
	PyObject *py_acct_handle;
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, r->out.acct_handle, r->out.acct_handle);
	result = py_acct_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumAccounts_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumAccounts *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_num_entries;
	const char *kwnames[] = {
		"handle", "resume_handle", "num_entries", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumAccounts", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_num_entries)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
	*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_num_entries, return false;);
	r->in.num_entries = PyInt_AsLong(py_num_entries);
	return true;
}

static PyObject *unpack_py_lsa_EnumAccounts_args_out(struct lsa_EnumAccounts *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_sids;
	result = PyTuple_New(2);
	py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CreateTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateTrustedDomain *r)
{
	PyObject *py_policy_handle;
	PyObject *py_info;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"policy_handle", "info", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateTrustedDomain", discard_const_p(char *, kwnames), &py_policy_handle, &py_info, &py_access_mask)) {
		return false;
	}

	r->in.policy_handle = talloc_ptrtype(r, r->in.policy_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_policy_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_policy_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.policy_handle = (struct policy_handle *)pytalloc_get_ptr(py_policy_handle);
	r->in.info = talloc_ptrtype(r, r->in.info);
	PY_CHECK_TYPE(&lsa_DomainInfo_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct lsa_DomainInfo *)pytalloc_get_ptr(py_info);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateTrustedDomain_args_out(struct lsa_CreateTrustedDomain *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumTrustDom_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumTrustDom *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"handle", "resume_handle", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumTrustDom", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_max_size)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
	*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_max_size, return false;);
	r->in.max_size = PyInt_AsLong(py_max_size);
	return true;
}

static PyObject *unpack_py_lsa_EnumTrustDom_args_out(struct lsa_EnumTrustDom *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_domains;
	result = PyTuple_New(2);
	py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_domains = pytalloc_reference_ex(&lsa_DomainList_Type, r->out.domains, r->out.domains);
	PyTuple_SetItem(result, 1, py_domains);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupNames_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupNames *r)
{
	PyObject *py_handle;
	PyObject *py_names;
	PyObject *py_sids;
	PyObject *py_level;
	PyObject *py_count;
	const char *kwnames[] = {
		"handle", "names", "sids", "level", "count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_LookupNames", discard_const_p(char *, kwnames), &py_handle, &py_names, &py_sids, &py_level, &py_count)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false;; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.names[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_TransSidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_TransSidArray *)pytalloc_get_ptr(py_sids);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	return true;
}

static PyObject *unpack_py_lsa_LookupNames_args_out(struct lsa_LookupNames *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_sids;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupSids_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupSids *r)
{
	PyObject *py_handle;
	PyObject *py_sids;
	PyObject *py_names;
	PyObject *py_level;
	PyObject *py_count;
	const char *kwnames[] = {
		"handle", "sids", "names", "level", "count", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_LookupSids", discard_const_p(char *, kwnames), &py_handle, &py_sids, &py_names, &py_level, &py_count)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	r->in.names = talloc_ptrtype(r, r->in.names);
	PY_CHECK_TYPE(&lsa_TransNameArray_Type, py_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.names = (struct lsa_TransNameArray *)pytalloc_get_ptr(py_names);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	return true;
}

static PyObject *unpack_py_lsa_LookupSids_args_out(struct lsa_LookupSids *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_names;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_names = pytalloc_reference_ex(&lsa_TransNameArray_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CreateSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateSecret *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_CreateSecret", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct lsa_String *)pytalloc_get_ptr(py_name);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateSecret_args_out(struct lsa_CreateSecret *r)
{
	PyObject *result;
	PyObject *py_sec_handle;
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, r->out.sec_handle, r->out.sec_handle);
	result = py_sec_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenAccount *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenAccount", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenAccount_args_out(struct lsa_OpenAccount *r)
{
	PyObject *result;
	PyObject *py_acct_handle;
	py_acct_handle = pytalloc_reference_ex(policy_handle_Type, r->out.acct_handle, r->out.acct_handle);
	result = py_acct_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumPrivsAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumPrivsAccount *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_EnumPrivsAccount", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_EnumPrivsAccount_args_out(struct lsa_EnumPrivsAccount *r)
{
	PyObject *result;
	PyObject *py_privs;
	if (*r->out.privs == NULL) {
		py_privs = Py_None;
		Py_INCREF(py_privs);
	} else {
		py_privs = pytalloc_reference_ex(&lsa_PrivilegeSet_Type, *r->out.privs, *r->out.privs);
	}
	result = py_privs;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_AddPrivilegesToAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_AddPrivilegesToAccount *r)
{
	PyObject *py_handle;
	PyObject *py_privs;
	const char *kwnames[] = {
		"handle", "privs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_AddPrivilegesToAccount", discard_const_p(char *, kwnames), &py_handle, &py_privs)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.privs = talloc_ptrtype(r, r->in.privs);
	PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, py_privs, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_privs)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_privs);
	return true;
}

static PyObject *unpack_py_lsa_AddPrivilegesToAccount_args_out(struct lsa_AddPrivilegesToAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_RemovePrivilegesFromAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_RemovePrivilegesFromAccount *r)
{
	PyObject *py_handle;
	PyObject *py_remove_all;
	PyObject *py_privs;
	const char *kwnames[] = {
		"handle", "remove_all", "privs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_RemovePrivilegesFromAccount", discard_const_p(char *, kwnames), &py_handle, &py_remove_all, &py_privs)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_remove_all, return false;);
	r->in.remove_all = PyInt_AsLong(py_remove_all);
	if (py_privs == Py_None) {
		r->in.privs = NULL;
	} else {
		r->in.privs = NULL;
		PY_CHECK_TYPE(&lsa_PrivilegeSet_Type, py_privs, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_privs)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.privs = (struct lsa_PrivilegeSet *)pytalloc_get_ptr(py_privs);
	}
	return true;
}

static PyObject *unpack_py_lsa_RemovePrivilegesFromAccount_args_out(struct lsa_RemovePrivilegesFromAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_GetSystemAccessAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_GetSystemAccessAccount *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_GetSystemAccessAccount", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_GetSystemAccessAccount_args_out(struct lsa_GetSystemAccessAccount *r)
{
	PyObject *result;
	PyObject *py_access_mask;
	py_access_mask = PyInt_FromLong(*r->out.access_mask);
	result = py_access_mask;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetSystemAccessAccount_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSystemAccessAccount *r)
{
	PyObject *py_handle;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_SetSystemAccessAccount", discard_const_p(char *, kwnames), &py_handle, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetSystemAccessAccount_args_out(struct lsa_SetSystemAccessAccount *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenTrustedDomain *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "sid", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenTrustedDomain", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenTrustedDomain_args_out(struct lsa_OpenTrustedDomain *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryTrustedDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryTrustedDomainInfo *r)
{
	PyObject *py_trustdom_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"trustdom_handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryTrustedDomainInfo", discard_const_p(char *, kwnames), &py_trustdom_handle, &py_level)) {
		return false;
	}

	r->in.trustdom_handle = talloc_ptrtype(r, r->in.trustdom_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_trustdom_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trustdom_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(py_trustdom_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryTrustedDomainInfo_args_out(struct lsa_QueryTrustedDomainInfo *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_TrustedDomainInfo(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetInformationTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetInformationTrustedDomain *r)
{
	PyObject *py_trustdom_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"trustdom_handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetInformationTrustedDomain", discard_const_p(char *, kwnames), &py_trustdom_handle, &py_level, &py_info)) {
		return false;
	}

	r->in.trustdom_handle = talloc_ptrtype(r, r->in.trustdom_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_trustdom_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trustdom_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trustdom_handle = (struct policy_handle *)pytalloc_get_ptr(py_trustdom_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	{
		union lsa_TrustedDomainInfo *info_switch_1;
		info_switch_1 = py_export_lsa_TrustedDomainInfo(r, r->in.level, py_info);
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetInformationTrustedDomain_args_out(struct lsa_SetInformationTrustedDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenSecret *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenSecret", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct lsa_String *)pytalloc_get_ptr(py_name);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenSecret_args_out(struct lsa_OpenSecret *r)
{
	PyObject *result;
	PyObject *py_sec_handle;
	py_sec_handle = pytalloc_reference_ex(policy_handle_Type, r->out.sec_handle, r->out.sec_handle);
	result = py_sec_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetSecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetSecret *r)
{
	PyObject *py_sec_handle;
	PyObject *py_new_val;
	PyObject *py_old_val;
	const char *kwnames[] = {
		"sec_handle", "new_val", "old_val", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetSecret", discard_const_p(char *, kwnames), &py_sec_handle, &py_new_val, &py_old_val)) {
		return false;
	}

	r->in.sec_handle = talloc_ptrtype(r, r->in.sec_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_sec_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(py_sec_handle);
	if (py_new_val == Py_None) {
		r->in.new_val = NULL;
	} else {
		r->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_new_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.new_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_new_val);
	}
	if (py_old_val == Py_None) {
		r->in.old_val = NULL;
	} else {
		r->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_old_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_old_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.old_val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_old_val);
	}
	return true;
}

static PyObject *unpack_py_lsa_SetSecret_args_out(struct lsa_SetSecret *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QuerySecret_args_in(PyObject *args, PyObject *kwargs, struct lsa_QuerySecret *r)
{
	PyObject *py_sec_handle;
	PyObject *py_new_val;
	PyObject *py_new_mtime;
	PyObject *py_old_val;
	PyObject *py_old_mtime;
	const char *kwnames[] = {
		"sec_handle", "new_val", "new_mtime", "old_val", "old_mtime", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_QuerySecret", discard_const_p(char *, kwnames), &py_sec_handle, &py_new_val, &py_new_mtime, &py_old_val, &py_old_mtime)) {
		return false;
	}

	r->in.sec_handle = talloc_ptrtype(r, r->in.sec_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_sec_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sec_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sec_handle = (struct policy_handle *)pytalloc_get_ptr(py_sec_handle);
	if (py_new_val == Py_None) {
		r->in.new_val = NULL;
	} else {
		r->in.new_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, py_new_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.new_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(py_new_val);
	}
	if (py_new_mtime == Py_None) {
		r->in.new_mtime = NULL;
	} else {
		r->in.new_mtime = talloc_ptrtype(r, r->in.new_mtime);
		if (PyLong_Check(py_new_mtime)) {
			*r->in.new_mtime = PyLong_AsLongLong(py_new_mtime);
		} else if (PyInt_Check(py_new_mtime)) {
			*r->in.new_mtime = PyInt_AsLong(py_new_mtime);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_old_val == Py_None) {
		r->in.old_val = NULL;
	} else {
		r->in.old_val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_PTR_Type, py_old_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_old_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.old_val = (struct lsa_DATA_BUF_PTR *)pytalloc_get_ptr(py_old_val);
	}
	if (py_old_mtime == Py_None) {
		r->in.old_mtime = NULL;
	} else {
		r->in.old_mtime = talloc_ptrtype(r, r->in.old_mtime);
		if (PyLong_Check(py_old_mtime)) {
			*r->in.old_mtime = PyLong_AsLongLong(py_old_mtime);
		} else if (PyInt_Check(py_old_mtime)) {
			*r->in.old_mtime = PyInt_AsLong(py_old_mtime);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
			  PyInt_Type.tp_name, PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_QuerySecret_args_out(struct lsa_QuerySecret *r)
{
	PyObject *result;
	PyObject *py_new_val;
	PyObject *py_new_mtime;
	PyObject *py_old_val;
	PyObject *py_old_mtime;
	result = PyTuple_New(4);
	if (r->out.new_val == NULL) {
		py_new_val = Py_None;
		Py_INCREF(py_new_val);
	} else {
		py_new_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, r->out.new_val, r->out.new_val);
	}
	PyTuple_SetItem(result, 0, py_new_val);
	if (r->out.new_mtime == NULL) {
		py_new_mtime = Py_None;
		Py_INCREF(py_new_mtime);
	} else {
		py_new_mtime = PyLong_FromLongLong(*r->out.new_mtime);
	}
	PyTuple_SetItem(result, 1, py_new_mtime);
	if (r->out.old_val == NULL) {
		py_old_val = Py_None;
		Py_INCREF(py_old_val);
	} else {
		py_old_val = pytalloc_reference_ex(&lsa_DATA_BUF_PTR_Type, r->out.old_val, r->out.old_val);
	}
	PyTuple_SetItem(result, 2, py_old_val);
	if (r->out.old_mtime == NULL) {
		py_old_mtime = Py_None;
		Py_INCREF(py_old_mtime);
	} else {
		py_old_mtime = PyLong_FromLongLong(*r->out.old_mtime);
	}
	PyTuple_SetItem(result, 3, py_old_mtime);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupPrivValue_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivValue *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	const char *kwnames[] = {
		"handle", "name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_LookupPrivValue", discard_const_p(char *, kwnames), &py_handle, &py_name)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivValue_args_out(struct lsa_LookupPrivValue *r)
{
	PyObject *result;
	PyObject *py_luid;
	py_luid = pytalloc_reference_ex(&lsa_LUID_Type, r->out.luid, r->out.luid);
	result = py_luid;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupPrivName_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivName *r)
{
	PyObject *py_handle;
	PyObject *py_luid;
	const char *kwnames[] = {
		"handle", "luid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_LookupPrivName", discard_const_p(char *, kwnames), &py_handle, &py_luid)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.luid = talloc_ptrtype(r, r->in.luid);
	PY_CHECK_TYPE(&lsa_LUID_Type, py_luid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_luid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.luid = (struct lsa_LUID *)pytalloc_get_ptr(py_luid);
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivName_args_out(struct lsa_LookupPrivName *r)
{
	PyObject *result;
	PyObject *py_name;
	if (*r->out.name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *r->out.name, *r->out.name);
	}
	result = py_name;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupPrivDisplayName_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupPrivDisplayName *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_language_id;
	PyObject *py_language_id_sys;
	const char *kwnames[] = {
		"handle", "name", "language_id", "language_id_sys", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_LookupPrivDisplayName", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_language_id, &py_language_id_sys)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	PY_CHECK_TYPE(&PyInt_Type, py_language_id, return false;);
	r->in.language_id = PyInt_AsLong(py_language_id);
	PY_CHECK_TYPE(&PyInt_Type, py_language_id_sys, return false;);
	r->in.language_id_sys = PyInt_AsLong(py_language_id_sys);
	return true;
}

static PyObject *unpack_py_lsa_LookupPrivDisplayName_args_out(struct lsa_LookupPrivDisplayName *r)
{
	PyObject *result;
	PyObject *py_disp_name;
	PyObject *py_returned_language_id;
	result = PyTuple_New(2);
	if (*r->out.disp_name == NULL) {
		py_disp_name = Py_None;
		Py_INCREF(py_disp_name);
	} else {
		py_disp_name = pytalloc_reference_ex(&lsa_StringLarge_Type, *r->out.disp_name, *r->out.disp_name);
	}
	PyTuple_SetItem(result, 0, py_disp_name);
	py_returned_language_id = PyInt_FromLong(*r->out.returned_language_id);
	PyTuple_SetItem(result, 1, py_returned_language_id);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_DeleteObject_args_in(PyObject *args, PyObject *kwargs, struct lsa_DeleteObject *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_DeleteObject", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_DeleteObject_args_out(struct lsa_DeleteObject *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumAccountsWithUserRight_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumAccountsWithUserRight *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	const char *kwnames[] = {
		"handle", "name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_EnumAccountsWithUserRight", discard_const_p(char *, kwnames), &py_handle, &py_name)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_name == Py_None) {
		r->in.name = NULL;
	} else {
		r->in.name = NULL;
		PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	}
	return true;
}

static PyObject *unpack_py_lsa_EnumAccountsWithUserRight_args_out(struct lsa_EnumAccountsWithUserRight *r)
{
	PyObject *result;
	PyObject *py_sids;
	py_sids = pytalloc_reference_ex(&lsa_SidArray_Type, r->out.sids, r->out.sids);
	result = py_sids;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumAccountRights_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumAccountRights *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	const char *kwnames[] = {
		"handle", "sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_EnumAccountRights", discard_const_p(char *, kwnames), &py_handle, &py_sid)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_lsa_EnumAccountRights_args_out(struct lsa_EnumAccountRights *r)
{
	PyObject *result;
	PyObject *py_rights;
	py_rights = pytalloc_reference_ex(&lsa_RightSet_Type, r->out.rights, r->out.rights);
	result = py_rights;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_AddAccountRights_args_in(PyObject *args, PyObject *kwargs, struct lsa_AddAccountRights *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_rights;
	const char *kwnames[] = {
		"handle", "sid", "rights", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_AddAccountRights", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_rights)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	r->in.rights = talloc_ptrtype(r, r->in.rights);
	PY_CHECK_TYPE(&lsa_RightSet_Type, py_rights, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_rights)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.rights = (struct lsa_RightSet *)pytalloc_get_ptr(py_rights);
	return true;
}

static PyObject *unpack_py_lsa_AddAccountRights_args_out(struct lsa_AddAccountRights *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_RemoveAccountRights_args_in(PyObject *args, PyObject *kwargs, struct lsa_RemoveAccountRights *r)
{
	PyObject *py_handle;
	PyObject *py_sid;
	PyObject *py_remove_all;
	PyObject *py_rights;
	const char *kwnames[] = {
		"handle", "sid", "remove_all", "rights", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_RemoveAccountRights", discard_const_p(char *, kwnames), &py_handle, &py_sid, &py_remove_all, &py_rights)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	PY_CHECK_TYPE(&PyInt_Type, py_remove_all, return false;);
	r->in.remove_all = PyInt_AsLong(py_remove_all);
	r->in.rights = talloc_ptrtype(r, r->in.rights);
	PY_CHECK_TYPE(&lsa_RightSet_Type, py_rights, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_rights)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.rights = (struct lsa_RightSet *)pytalloc_get_ptr(py_rights);
	return true;
}

static PyObject *unpack_py_lsa_RemoveAccountRights_args_out(struct lsa_RemoveAccountRights *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryTrustedDomainInfoBySid_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryTrustedDomainInfoBySid *r)
{
	PyObject *py_handle;
	PyObject *py_dom_sid;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "dom_sid", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_QueryTrustedDomainInfoBySid", discard_const_p(char *, kwnames), &py_handle, &py_dom_sid, &py_level)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.dom_sid = talloc_ptrtype(r, r->in.dom_sid);
	PY_CHECK_TYPE(dom_sid_Type, py_dom_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dom_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dom_sid = (struct dom_sid *)pytalloc_get_ptr(py_dom_sid);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryTrustedDomainInfoBySid_args_out(struct lsa_QueryTrustedDomainInfoBySid *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_TrustedDomainInfo(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetTrustedDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetTrustedDomainInfo *r)
{
	PyObject *py_handle;
	PyObject *py_dom_sid;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "dom_sid", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_SetTrustedDomainInfo", discard_const_p(char *, kwnames), &py_handle, &py_dom_sid, &py_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.dom_sid = talloc_ptrtype(r, r->in.dom_sid);
	PY_CHECK_TYPE(dom_sid_Type, py_dom_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dom_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dom_sid = (struct dom_sid *)pytalloc_get_ptr(py_dom_sid);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	{
		union lsa_TrustedDomainInfo *info_switch_1;
		info_switch_1 = py_export_lsa_TrustedDomainInfo(r, r->in.level, py_info);
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetTrustedDomainInfo_args_out(struct lsa_SetTrustedDomainInfo *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_DeleteTrustedDomain_args_in(PyObject *args, PyObject *kwargs, struct lsa_DeleteTrustedDomain *r)
{
	PyObject *py_handle;
	PyObject *py_dom_sid;
	const char *kwnames[] = {
		"handle", "dom_sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_DeleteTrustedDomain", discard_const_p(char *, kwnames), &py_handle, &py_dom_sid)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.dom_sid = talloc_ptrtype(r, r->in.dom_sid);
	PY_CHECK_TYPE(dom_sid_Type, py_dom_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dom_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dom_sid = (struct dom_sid *)pytalloc_get_ptr(py_dom_sid);
	return true;
}

static PyObject *unpack_py_lsa_DeleteTrustedDomain_args_out(struct lsa_DeleteTrustedDomain *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_StorePrivateData_args_in(PyObject *args, PyObject *kwargs, struct lsa_StorePrivateData *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_val;
	const char *kwnames[] = {
		"handle", "name", "val", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_StorePrivateData", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_val)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	if (py_val == Py_None) {
		r->in.val = NULL;
	} else {
		r->in.val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_val);
	}
	return true;
}

static PyObject *unpack_py_lsa_StorePrivateData_args_out(struct lsa_StorePrivateData *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_RetrievePrivateData_args_in(PyObject *args, PyObject *kwargs, struct lsa_RetrievePrivateData *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_val;
	const char *kwnames[] = {
		"handle", "name", "val", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_RetrievePrivateData", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_val)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.name = talloc_ptrtype(r, r->in.name);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	r->in.val = talloc_ptrtype(r, r->in.val);
	if (py_val == Py_None) {
		*r->in.val = NULL;
	} else {
		*r->in.val = NULL;
		PY_CHECK_TYPE(&lsa_DATA_BUF_Type, py_val, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_val)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		*r->in.val = (struct lsa_DATA_BUF *)pytalloc_get_ptr(py_val);
	}
	return true;
}

static PyObject *unpack_py_lsa_RetrievePrivateData_args_out(struct lsa_RetrievePrivateData *r)
{
	PyObject *result;
	PyObject *py_val;
	if (*r->out.val == NULL) {
		py_val = Py_None;
		Py_INCREF(py_val);
	} else {
		py_val = pytalloc_reference_ex(&lsa_DATA_BUF_Type, *r->out.val, *r->out.val);
	}
	result = py_val;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenPolicy2_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenPolicy2 *r)
{
	PyObject *py_system_name;
	PyObject *py_attr;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "attr", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenPolicy2", discard_const_p(char *, kwnames), &py_system_name, &py_attr, &py_access_mask)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = NULL;
		if (PyUnicode_Check(py_system_name)) {
			r->in.system_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_system_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_system_name)) {
			r->in.system_name = PyString_AS_STRING(py_system_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_system_name)->tp_name);
			return false;
		}
	}
	r->in.attr = talloc_ptrtype(r, r->in.attr);
	PY_CHECK_TYPE(&lsa_ObjectAttribute_Type, py_attr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_attr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.attr = (struct lsa_ObjectAttribute *)pytalloc_get_ptr(py_attr);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenPolicy2_args_out(struct lsa_OpenPolicy2 *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_GetUserName_args_in(PyObject *args, PyObject *kwargs, struct lsa_GetUserName *r)
{
	PyObject *py_system_name;
	PyObject *py_account_name;
	PyObject *py_authority_name;
	const char *kwnames[] = {
		"system_name", "account_name", "authority_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_GetUserName", discard_const_p(char *, kwnames), &py_system_name, &py_account_name, &py_authority_name)) {
		return false;
	}

	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = NULL;
		if (PyUnicode_Check(py_system_name)) {
			r->in.system_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_system_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_system_name)) {
			r->in.system_name = PyString_AS_STRING(py_system_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_system_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (py_account_name == Py_None) {
		*r->in.account_name = NULL;
	} else {
		*r->in.account_name = NULL;
		PY_CHECK_TYPE(&lsa_String_Type, py_account_name, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_account_name)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		*r->in.account_name = (struct lsa_String *)pytalloc_get_ptr(py_account_name);
	}
	if (py_authority_name == Py_None) {
		r->in.authority_name = NULL;
	} else {
		r->in.authority_name = NULL;
		if (py_authority_name == Py_None) {
			*r->in.authority_name = NULL;
		} else {
			*r->in.authority_name = NULL;
			PY_CHECK_TYPE(&lsa_String_Type, py_authority_name, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_authority_name)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.authority_name = (struct lsa_String *)pytalloc_get_ptr(py_authority_name);
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_GetUserName_args_out(struct lsa_GetUserName *r)
{
	PyObject *result;
	PyObject *py_account_name;
	PyObject *py_authority_name;
	result = PyTuple_New(2);
	if (*r->out.account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = pytalloc_reference_ex(&lsa_String_Type, *r->out.account_name, *r->out.account_name);
	}
	PyTuple_SetItem(result, 0, py_account_name);
	if (r->out.authority_name == NULL) {
		py_authority_name = Py_None;
		Py_INCREF(py_authority_name);
	} else {
		if (*r->out.authority_name == NULL) {
			py_authority_name = Py_None;
			Py_INCREF(py_authority_name);
		} else {
			py_authority_name = pytalloc_reference_ex(&lsa_String_Type, *r->out.authority_name, *r->out.authority_name);
		}
	}
	PyTuple_SetItem(result, 1, py_authority_name);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryInfoPolicy2_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryInfoPolicy2 *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryInfoPolicy2", discard_const_p(char *, kwnames), &py_handle, &py_level)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryInfoPolicy2_args_out(struct lsa_QueryInfoPolicy2 *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_PolicyInformation(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetInfoPolicy2_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetInfoPolicy2 *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetInfoPolicy2", discard_const_p(char *, kwnames), &py_handle, &py_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	{
		union lsa_PolicyInformation *info_switch_1;
		info_switch_1 = py_export_lsa_PolicyInformation(r, r->in.level, py_info);
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetInfoPolicy2_args_out(struct lsa_SetInfoPolicy2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryTrustedDomainInfoByName_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryTrustedDomainInfoByName *r)
{
	PyObject *py_handle;
	PyObject *py_trusted_domain;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "trusted_domain", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_QueryTrustedDomainInfoByName", discard_const_p(char *, kwnames), &py_handle, &py_trusted_domain, &py_level)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.trusted_domain = talloc_ptrtype(r, r->in.trusted_domain);
	PY_CHECK_TYPE(&lsa_String_Type, py_trusted_domain, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trusted_domain)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trusted_domain = (struct lsa_String *)pytalloc_get_ptr(py_trusted_domain);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_QueryTrustedDomainInfoByName_args_out(struct lsa_QueryTrustedDomainInfoByName *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_TrustedDomainInfo(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetTrustedDomainInfoByName_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetTrustedDomainInfoByName *r)
{
	PyObject *py_handle;
	PyObject *py_trusted_domain;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "trusted_domain", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_SetTrustedDomainInfoByName", discard_const_p(char *, kwnames), &py_handle, &py_trusted_domain, &py_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.trusted_domain = talloc_ptrtype(r, r->in.trusted_domain);
	PY_CHECK_TYPE(&lsa_String_Type, py_trusted_domain, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trusted_domain)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trusted_domain = (struct lsa_String *)pytalloc_get_ptr(py_trusted_domain);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	{
		union lsa_TrustedDomainInfo *info_switch_1;
		info_switch_1 = py_export_lsa_TrustedDomainInfo(r, r->in.level, py_info);
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_lsa_SetTrustedDomainInfoByName_args_out(struct lsa_SetTrustedDomainInfoByName *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_EnumTrustedDomainsEx_args_in(PyObject *args, PyObject *kwargs, struct lsa_EnumTrustedDomainsEx *r)
{
	PyObject *py_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"handle", "resume_handle", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_EnumTrustedDomainsEx", discard_const_p(char *, kwnames), &py_handle, &py_resume_handle, &py_max_size)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
	*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_max_size, return false;);
	r->in.max_size = PyInt_AsLong(py_max_size);
	return true;
}

static PyObject *unpack_py_lsa_EnumTrustedDomainsEx_args_out(struct lsa_EnumTrustedDomainsEx *r)
{
	PyObject *result;
	PyObject *py_resume_handle;
	PyObject *py_domains;
	result = PyTuple_New(2);
	py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	PyTuple_SetItem(result, 0, py_resume_handle);
	py_domains = pytalloc_reference_ex(&lsa_DomainListEx_Type, r->out.domains, r->out.domains);
	PyTuple_SetItem(result, 1, py_domains);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CreateTrustedDomainEx_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateTrustedDomainEx *r)
{
	PyObject *py_policy_handle;
	PyObject *py_info;
	PyObject *py_auth_info;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"policy_handle", "info", "auth_info", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_CreateTrustedDomainEx", discard_const_p(char *, kwnames), &py_policy_handle, &py_info, &py_auth_info, &py_access_mask)) {
		return false;
	}

	r->in.policy_handle = talloc_ptrtype(r, r->in.policy_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_policy_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_policy_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.policy_handle = (struct policy_handle *)pytalloc_get_ptr(py_policy_handle);
	r->in.info = talloc_ptrtype(r, r->in.info);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_info);
	r->in.auth_info = talloc_ptrtype(r, r->in.auth_info);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfo_Type, py_auth_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_auth_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.auth_info = (struct lsa_TrustDomainInfoAuthInfo *)pytalloc_get_ptr(py_auth_info);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateTrustedDomainEx_args_out(struct lsa_CreateTrustedDomainEx *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CloseTrustedDomainEx_args_in(PyObject *args, PyObject *kwargs, struct lsa_CloseTrustedDomainEx *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:lsa_CloseTrustedDomainEx", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_lsa_CloseTrustedDomainEx_args_out(struct lsa_CloseTrustedDomainEx *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_QueryDomainInformationPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_QueryDomainInformationPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:lsa_QueryDomainInformationPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	return true;
}

static PyObject *unpack_py_lsa_QueryDomainInformationPolicy_args_out(struct lsa_QueryDomainInformationPolicy *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_lsa_DomainInformationPolicy(*r->out.info, r->in.level, *r->out.info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	result = py_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_SetDomainInformationPolicy_args_in(PyObject *args, PyObject *kwargs, struct lsa_SetDomainInformationPolicy *r)
{
	PyObject *py_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_SetDomainInformationPolicy", discard_const_p(char *, kwnames), &py_handle, &py_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	if (py_info == Py_None) {
		r->in.info = NULL;
	} else {
		r->in.info = NULL;
		{
			union lsa_DomainInformationPolicy *info_switch_1;
			info_switch_1 = py_export_lsa_DomainInformationPolicy(r, r->in.level, py_info);
			if (info_switch_1 == NULL) {
				return false;
			}
			r->in.info = info_switch_1;
		}
	}
	return true;
}

static PyObject *unpack_py_lsa_SetDomainInformationPolicy_args_out(struct lsa_SetDomainInformationPolicy *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_OpenTrustedDomainByName_args_in(PyObject *args, PyObject *kwargs, struct lsa_OpenTrustedDomainByName *r)
{
	PyObject *py_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_OpenTrustedDomainByName", discard_const_p(char *, kwnames), &py_handle, &py_name, &py_access_mask)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct lsa_String *)pytalloc_get_ptr(py_name);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_OpenTrustedDomainByName_args_out(struct lsa_OpenTrustedDomainByName *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupSids2_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupSids2 *r)
{
	PyObject *py_handle;
	PyObject *py_sids;
	PyObject *py_names;
	PyObject *py_level;
	PyObject *py_count;
	PyObject *py_lookup_options;
	PyObject *py_client_revision;
	const char *kwnames[] = {
		"handle", "sids", "names", "level", "count", "lookup_options", "client_revision", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:lsa_LookupSids2", discard_const_p(char *, kwnames), &py_handle, &py_sids, &py_names, &py_level, &py_count, &py_lookup_options, &py_client_revision)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	r->in.names = talloc_ptrtype(r, r->in.names);
	PY_CHECK_TYPE(&lsa_TransNameArray2_Type, py_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.names = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(py_names);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	if (PyLong_Check(py_lookup_options)) {
		r->in.lookup_options = PyLong_AsLongLong(py_lookup_options);
	} else if (PyInt_Check(py_lookup_options)) {
		r->in.lookup_options = PyInt_AsLong(py_lookup_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_client_revision)) {
		r->in.client_revision = PyLong_AsLongLong(py_client_revision);
	} else if (PyInt_Check(py_client_revision)) {
		r->in.client_revision = PyInt_AsLong(py_client_revision);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupSids2_args_out(struct lsa_LookupSids2 *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_names;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_names = pytalloc_reference_ex(&lsa_TransNameArray2_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupNames2_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupNames2 *r)
{
	PyObject *py_handle;
	PyObject *py_names;
	PyObject *py_sids;
	PyObject *py_level;
	PyObject *py_count;
	PyObject *py_lookup_options;
	PyObject *py_client_revision;
	const char *kwnames[] = {
		"handle", "names", "sids", "level", "count", "lookup_options", "client_revision", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:lsa_LookupNames2", discard_const_p(char *, kwnames), &py_handle, &py_names, &py_sids, &py_level, &py_count, &py_lookup_options, &py_client_revision)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false;; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.names[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_TransSidArray2_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_TransSidArray2 *)pytalloc_get_ptr(py_sids);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	if (PyLong_Check(py_lookup_options)) {
		r->in.lookup_options = PyLong_AsLongLong(py_lookup_options);
	} else if (PyInt_Check(py_lookup_options)) {
		r->in.lookup_options = PyInt_AsLong(py_lookup_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_client_revision)) {
		r->in.client_revision = PyLong_AsLongLong(py_client_revision);
	} else if (PyInt_Check(py_client_revision)) {
		r->in.client_revision = PyInt_AsLong(py_client_revision);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupNames2_args_out(struct lsa_LookupNames2 *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_sids;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray2_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_CreateTrustedDomainEx2_args_in(PyObject *args, PyObject *kwargs, struct lsa_CreateTrustedDomainEx2 *r)
{
	PyObject *py_policy_handle;
	PyObject *py_info;
	PyObject *py_auth_info_internal;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"policy_handle", "info", "auth_info_internal", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:lsa_CreateTrustedDomainEx2", discard_const_p(char *, kwnames), &py_policy_handle, &py_info, &py_auth_info_internal, &py_access_mask)) {
		return false;
	}

	r->in.policy_handle = talloc_ptrtype(r, r->in.policy_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_policy_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_policy_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.policy_handle = (struct policy_handle *)pytalloc_get_ptr(py_policy_handle);
	r->in.info = talloc_ptrtype(r, r->in.info);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoInfoEx_Type, py_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.info = (struct lsa_TrustDomainInfoInfoEx *)pytalloc_get_ptr(py_info);
	r->in.auth_info_internal = talloc_ptrtype(r, r->in.auth_info_internal);
	PY_CHECK_TYPE(&lsa_TrustDomainInfoAuthInfoInternal_Type, py_auth_info_internal, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_auth_info_internal)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.auth_info_internal = (struct lsa_TrustDomainInfoAuthInfoInternal *)pytalloc_get_ptr(py_auth_info_internal);
	if (PyLong_Check(py_access_mask)) {
		r->in.access_mask = PyLong_AsLongLong(py_access_mask);
	} else if (PyInt_Check(py_access_mask)) {
		r->in.access_mask = PyInt_AsLong(py_access_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_CreateTrustedDomainEx2_args_out(struct lsa_CreateTrustedDomainEx2 *r)
{
	PyObject *result;
	PyObject *py_trustdom_handle;
	py_trustdom_handle = pytalloc_reference_ex(policy_handle_Type, r->out.trustdom_handle, r->out.trustdom_handle);
	result = py_trustdom_handle;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupNames3_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupNames3 *r)
{
	PyObject *py_handle;
	PyObject *py_names;
	PyObject *py_sids;
	PyObject *py_level;
	PyObject *py_count;
	PyObject *py_lookup_options;
	PyObject *py_client_revision;
	const char *kwnames[] = {
		"handle", "names", "sids", "level", "count", "lookup_options", "client_revision", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:lsa_LookupNames3", discard_const_p(char *, kwnames), &py_handle, &py_names, &py_sids, &py_level, &py_count, &py_lookup_options, &py_client_revision)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false;; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.names[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_TransSidArray3_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(py_sids);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	if (PyLong_Check(py_lookup_options)) {
		r->in.lookup_options = PyLong_AsLongLong(py_lookup_options);
	} else if (PyInt_Check(py_lookup_options)) {
		r->in.lookup_options = PyInt_AsLong(py_lookup_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_client_revision)) {
		r->in.client_revision = PyLong_AsLongLong(py_client_revision);
	} else if (PyInt_Check(py_client_revision)) {
		r->in.client_revision = PyInt_AsLong(py_client_revision);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupNames3_args_out(struct lsa_LookupNames3 *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_sids;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray3_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_lsaRQueryForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct lsa_lsaRQueryForestTrustInformation *r)
{
	PyObject *py_handle;
	PyObject *py_trusted_domain_name;
	PyObject *py_unknown;
	const char *kwnames[] = {
		"handle", "trusted_domain_name", "unknown", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:lsa_lsaRQueryForestTrustInformation", discard_const_p(char *, kwnames), &py_handle, &py_trusted_domain_name, &py_unknown)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.trusted_domain_name = talloc_ptrtype(r, r->in.trusted_domain_name);
	PY_CHECK_TYPE(&lsa_String_Type, py_trusted_domain_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trusted_domain_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trusted_domain_name = (struct lsa_String *)pytalloc_get_ptr(py_trusted_domain_name);
	PY_CHECK_TYPE(&PyInt_Type, py_unknown, return false;);
	r->in.unknown = PyInt_AsLong(py_unknown);
	return true;
}

static PyObject *unpack_py_lsa_lsaRQueryForestTrustInformation_args_out(struct lsa_lsaRQueryForestTrustInformation *r)
{
	PyObject *result;
	PyObject *py_forest_trust_info;
	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
		Py_INCREF(py_forest_trust_info);
	} else {
		py_forest_trust_info = pytalloc_reference_ex(&lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	result = py_forest_trust_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_lsaRSetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct lsa_lsaRSetForestTrustInformation *r)
{
	PyObject *py_handle;
	PyObject *py_trusted_domain_name;
	PyObject *py_highest_record_type;
	PyObject *py_forest_trust_info;
	PyObject *py_check_only;
	const char *kwnames[] = {
		"handle", "trusted_domain_name", "highest_record_type", "forest_trust_info", "check_only", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:lsa_lsaRSetForestTrustInformation", discard_const_p(char *, kwnames), &py_handle, &py_trusted_domain_name, &py_highest_record_type, &py_forest_trust_info, &py_check_only)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	r->in.trusted_domain_name = talloc_ptrtype(r, r->in.trusted_domain_name);
	PY_CHECK_TYPE(&lsa_StringLarge_Type, py_trusted_domain_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_trusted_domain_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.trusted_domain_name = (struct lsa_StringLarge *)pytalloc_get_ptr(py_trusted_domain_name);
	PY_CHECK_TYPE(&PyInt_Type, py_highest_record_type, return false;);
	r->in.highest_record_type = PyInt_AsLong(py_highest_record_type);
	r->in.forest_trust_info = talloc_ptrtype(r, r->in.forest_trust_info);
	PY_CHECK_TYPE(&lsa_ForestTrustInformation_Type, py_forest_trust_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_forest_trust_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.forest_trust_info = (struct lsa_ForestTrustInformation *)pytalloc_get_ptr(py_forest_trust_info);
	PY_CHECK_TYPE(&PyInt_Type, py_check_only, return false;);
	r->in.check_only = PyInt_AsLong(py_check_only);
	return true;
}

static PyObject *unpack_py_lsa_lsaRSetForestTrustInformation_args_out(struct lsa_lsaRSetForestTrustInformation *r)
{
	PyObject *result;
	PyObject *py_collision_info;
	if (*r->out.collision_info == NULL) {
		py_collision_info = Py_None;
		Py_INCREF(py_collision_info);
	} else {
		py_collision_info = pytalloc_reference_ex(&lsa_ForestTrustCollisionInfo_Type, *r->out.collision_info, *r->out.collision_info);
	}
	result = py_collision_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupSids3_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupSids3 *r)
{
	PyObject *py_sids;
	PyObject *py_names;
	PyObject *py_level;
	PyObject *py_count;
	PyObject *py_lookup_options;
	PyObject *py_client_revision;
	const char *kwnames[] = {
		"sids", "names", "level", "count", "lookup_options", "client_revision", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:lsa_LookupSids3", discard_const_p(char *, kwnames), &py_sids, &py_names, &py_level, &py_count, &py_lookup_options, &py_client_revision)) {
		return false;
	}

	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	r->in.names = talloc_ptrtype(r, r->in.names);
	PY_CHECK_TYPE(&lsa_TransNameArray2_Type, py_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.names = (struct lsa_TransNameArray2 *)pytalloc_get_ptr(py_names);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	if (PyLong_Check(py_lookup_options)) {
		r->in.lookup_options = PyLong_AsLongLong(py_lookup_options);
	} else if (PyInt_Check(py_lookup_options)) {
		r->in.lookup_options = PyInt_AsLong(py_lookup_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_client_revision)) {
		r->in.client_revision = PyLong_AsLongLong(py_client_revision);
	} else if (PyInt_Check(py_client_revision)) {
		r->in.client_revision = PyInt_AsLong(py_client_revision);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupSids3_args_out(struct lsa_LookupSids3 *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_names;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_names = pytalloc_reference_ex(&lsa_TransNameArray2_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 1, py_names);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_lsa_LookupNames4_args_in(PyObject *args, PyObject *kwargs, struct lsa_LookupNames4 *r)
{
	PyObject *py_names;
	PyObject *py_sids;
	PyObject *py_level;
	PyObject *py_count;
	PyObject *py_lookup_options;
	PyObject *py_client_revision;
	const char *kwnames[] = {
		"names", "sids", "level", "count", "lookup_options", "client_revision", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:lsa_LookupNames4", discard_const_p(char *, kwnames), &py_names, &py_sids, &py_level, &py_count, &py_lookup_options, &py_client_revision)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false;; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			PY_CHECK_TYPE(&lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.names[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	PY_CHECK_TYPE(&lsa_TransSidArray3_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_TransSidArray3 *)pytalloc_get_ptr(py_sids);
	if (PyLong_Check(py_level)) {
		r->in.level = PyLong_AsLongLong(py_level);
	} else if (PyInt_Check(py_level)) {
		r->in.level = PyInt_AsLong(py_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.count = talloc_ptrtype(r, r->in.count);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	*r->in.count = PyInt_AsLong(py_count);
	if (PyLong_Check(py_lookup_options)) {
		r->in.lookup_options = PyLong_AsLongLong(py_lookup_options);
	} else if (PyInt_Check(py_lookup_options)) {
		r->in.lookup_options = PyInt_AsLong(py_lookup_options);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_client_revision)) {
		r->in.client_revision = PyLong_AsLongLong(py_client_revision);
	} else if (PyInt_Check(py_client_revision)) {
		r->in.client_revision = PyInt_AsLong(py_client_revision);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_lsa_LookupNames4_args_out(struct lsa_LookupNames4 *r)
{
	PyObject *result;
	PyObject *py_domains;
	PyObject *py_sids;
	PyObject *py_count;
	result = PyTuple_New(3);
	if (*r->out.domains == NULL) {
		py_domains = Py_None;
		Py_INCREF(py_domains);
	} else {
		py_domains = pytalloc_reference_ex(&lsa_RefDomainList_Type, *r->out.domains, *r->out.domains);
	}
	PyTuple_SetItem(result, 0, py_domains);
	py_sids = pytalloc_reference_ex(&lsa_TransSidArray3_Type, r->out.sids, r->out.sids);
	PyTuple_SetItem(result, 1, py_sids);
	py_count = PyInt_FromLong(*r->out.count);
	PyTuple_SetItem(result, 2, py_count);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_lsarpc_methods[] = {
	{ "Close", "S.Close(handle) -> handle", (py_dcerpc_call_fn)dcerpc_lsa_Close_r, (py_data_pack_fn)pack_py_lsa_Close_args_in, (py_data_unpack_fn)unpack_py_lsa_Close_args_out, 0, &ndr_table_lsarpc },
	{ "Delete", "S.Delete(handle) -> None", (py_dcerpc_call_fn)dcerpc_lsa_Delete_r, (py_data_pack_fn)pack_py_lsa_Delete_args_in, (py_data_unpack_fn)unpack_py_lsa_Delete_args_out, 1, &ndr_table_lsarpc },
	{ "EnumPrivs", "S.EnumPrivs(handle, resume_handle, max_count) -> (resume_handle, privs)", (py_dcerpc_call_fn)dcerpc_lsa_EnumPrivs_r, (py_data_pack_fn)pack_py_lsa_EnumPrivs_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumPrivs_args_out, 2, &ndr_table_lsarpc },
	{ "QuerySecurity", "S.QuerySecurity(handle, sec_info) -> sdbuf", (py_dcerpc_call_fn)dcerpc_lsa_QuerySecurity_r, (py_data_pack_fn)pack_py_lsa_QuerySecurity_args_in, (py_data_unpack_fn)unpack_py_lsa_QuerySecurity_args_out, 3, &ndr_table_lsarpc },
	{ "SetSecObj", "S.SetSecObj(handle, sec_info, sdbuf) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetSecObj_r, (py_data_pack_fn)pack_py_lsa_SetSecObj_args_in, (py_data_unpack_fn)unpack_py_lsa_SetSecObj_args_out, 4, &ndr_table_lsarpc },
	{ "OpenPolicy", "S.OpenPolicy(system_name, attr, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenPolicy_r, (py_data_pack_fn)pack_py_lsa_OpenPolicy_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenPolicy_args_out, 6, &ndr_table_lsarpc },
	{ "QueryInfoPolicy", "S.QueryInfoPolicy(handle, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryInfoPolicy_r, (py_data_pack_fn)pack_py_lsa_QueryInfoPolicy_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryInfoPolicy_args_out, 7, &ndr_table_lsarpc },
	{ "SetInfoPolicy", "S.SetInfoPolicy(handle, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetInfoPolicy_r, (py_data_pack_fn)pack_py_lsa_SetInfoPolicy_args_in, (py_data_unpack_fn)unpack_py_lsa_SetInfoPolicy_args_out, 8, &ndr_table_lsarpc },
	{ "CreateAccount", "S.CreateAccount(handle, sid, access_mask) -> acct_handle", (py_dcerpc_call_fn)dcerpc_lsa_CreateAccount_r, (py_data_pack_fn)pack_py_lsa_CreateAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_CreateAccount_args_out, 10, &ndr_table_lsarpc },
	{ "EnumAccounts", "S.EnumAccounts(handle, resume_handle, num_entries) -> (resume_handle, sids)", (py_dcerpc_call_fn)dcerpc_lsa_EnumAccounts_r, (py_data_pack_fn)pack_py_lsa_EnumAccounts_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumAccounts_args_out, 11, &ndr_table_lsarpc },
	{ "CreateTrustedDomain", "S.CreateTrustedDomain(policy_handle, info, access_mask) -> trustdom_handle", (py_dcerpc_call_fn)dcerpc_lsa_CreateTrustedDomain_r, (py_data_pack_fn)pack_py_lsa_CreateTrustedDomain_args_in, (py_data_unpack_fn)unpack_py_lsa_CreateTrustedDomain_args_out, 12, &ndr_table_lsarpc },
	{ "EnumTrustDom", "S.EnumTrustDom(handle, resume_handle, max_size) -> (resume_handle, domains)", (py_dcerpc_call_fn)dcerpc_lsa_EnumTrustDom_r, (py_data_pack_fn)pack_py_lsa_EnumTrustDom_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumTrustDom_args_out, 13, &ndr_table_lsarpc },
	{ "LookupNames", "S.LookupNames(handle, names, sids, level, count) -> (domains, sids, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupNames_r, (py_data_pack_fn)pack_py_lsa_LookupNames_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupNames_args_out, 14, &ndr_table_lsarpc },
	{ "LookupSids", "S.LookupSids(handle, sids, names, level, count) -> (domains, names, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupSids_r, (py_data_pack_fn)pack_py_lsa_LookupSids_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupSids_args_out, 15, &ndr_table_lsarpc },
	{ "CreateSecret", "S.CreateSecret(handle, name, access_mask) -> sec_handle", (py_dcerpc_call_fn)dcerpc_lsa_CreateSecret_r, (py_data_pack_fn)pack_py_lsa_CreateSecret_args_in, (py_data_unpack_fn)unpack_py_lsa_CreateSecret_args_out, 16, &ndr_table_lsarpc },
	{ "OpenAccount", "S.OpenAccount(handle, sid, access_mask) -> acct_handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenAccount_r, (py_data_pack_fn)pack_py_lsa_OpenAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenAccount_args_out, 17, &ndr_table_lsarpc },
	{ "EnumPrivsAccount", "S.EnumPrivsAccount(handle) -> privs", (py_dcerpc_call_fn)dcerpc_lsa_EnumPrivsAccount_r, (py_data_pack_fn)pack_py_lsa_EnumPrivsAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumPrivsAccount_args_out, 18, &ndr_table_lsarpc },
	{ "AddPrivilegesToAccount", "S.AddPrivilegesToAccount(handle, privs) -> None", (py_dcerpc_call_fn)dcerpc_lsa_AddPrivilegesToAccount_r, (py_data_pack_fn)pack_py_lsa_AddPrivilegesToAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_AddPrivilegesToAccount_args_out, 19, &ndr_table_lsarpc },
	{ "RemovePrivilegesFromAccount", "S.RemovePrivilegesFromAccount(handle, remove_all, privs) -> None", (py_dcerpc_call_fn)dcerpc_lsa_RemovePrivilegesFromAccount_r, (py_data_pack_fn)pack_py_lsa_RemovePrivilegesFromAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_RemovePrivilegesFromAccount_args_out, 20, &ndr_table_lsarpc },
	{ "GetSystemAccessAccount", "S.GetSystemAccessAccount(handle) -> access_mask", (py_dcerpc_call_fn)dcerpc_lsa_GetSystemAccessAccount_r, (py_data_pack_fn)pack_py_lsa_GetSystemAccessAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_GetSystemAccessAccount_args_out, 23, &ndr_table_lsarpc },
	{ "SetSystemAccessAccount", "S.SetSystemAccessAccount(handle, access_mask) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetSystemAccessAccount_r, (py_data_pack_fn)pack_py_lsa_SetSystemAccessAccount_args_in, (py_data_unpack_fn)unpack_py_lsa_SetSystemAccessAccount_args_out, 24, &ndr_table_lsarpc },
	{ "OpenTrustedDomain", "S.OpenTrustedDomain(handle, sid, access_mask) -> trustdom_handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenTrustedDomain_r, (py_data_pack_fn)pack_py_lsa_OpenTrustedDomain_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenTrustedDomain_args_out, 25, &ndr_table_lsarpc },
	{ "QueryTrustedDomainInfo", "S.QueryTrustedDomainInfo(trustdom_handle, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryTrustedDomainInfo_r, (py_data_pack_fn)pack_py_lsa_QueryTrustedDomainInfo_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryTrustedDomainInfo_args_out, 26, &ndr_table_lsarpc },
	{ "SetInformationTrustedDomain", "S.SetInformationTrustedDomain(trustdom_handle, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetInformationTrustedDomain_r, (py_data_pack_fn)pack_py_lsa_SetInformationTrustedDomain_args_in, (py_data_unpack_fn)unpack_py_lsa_SetInformationTrustedDomain_args_out, 27, &ndr_table_lsarpc },
	{ "OpenSecret", "S.OpenSecret(handle, name, access_mask) -> sec_handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenSecret_r, (py_data_pack_fn)pack_py_lsa_OpenSecret_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenSecret_args_out, 28, &ndr_table_lsarpc },
	{ "SetSecret", "S.SetSecret(sec_handle, new_val, old_val) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetSecret_r, (py_data_pack_fn)pack_py_lsa_SetSecret_args_in, (py_data_unpack_fn)unpack_py_lsa_SetSecret_args_out, 29, &ndr_table_lsarpc },
	{ "QuerySecret", "S.QuerySecret(sec_handle, new_val, new_mtime, old_val, old_mtime) -> (new_val, new_mtime, old_val, old_mtime)", (py_dcerpc_call_fn)dcerpc_lsa_QuerySecret_r, (py_data_pack_fn)pack_py_lsa_QuerySecret_args_in, (py_data_unpack_fn)unpack_py_lsa_QuerySecret_args_out, 30, &ndr_table_lsarpc },
	{ "LookupPrivValue", "S.LookupPrivValue(handle, name) -> luid", (py_dcerpc_call_fn)dcerpc_lsa_LookupPrivValue_r, (py_data_pack_fn)pack_py_lsa_LookupPrivValue_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupPrivValue_args_out, 31, &ndr_table_lsarpc },
	{ "LookupPrivName", "S.LookupPrivName(handle, luid) -> name", (py_dcerpc_call_fn)dcerpc_lsa_LookupPrivName_r, (py_data_pack_fn)pack_py_lsa_LookupPrivName_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupPrivName_args_out, 32, &ndr_table_lsarpc },
	{ "LookupPrivDisplayName", "S.LookupPrivDisplayName(handle, name, language_id, language_id_sys) -> (disp_name, returned_language_id)", (py_dcerpc_call_fn)dcerpc_lsa_LookupPrivDisplayName_r, (py_data_pack_fn)pack_py_lsa_LookupPrivDisplayName_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupPrivDisplayName_args_out, 33, &ndr_table_lsarpc },
	{ "DeleteObject", "S.DeleteObject(handle) -> handle", (py_dcerpc_call_fn)dcerpc_lsa_DeleteObject_r, (py_data_pack_fn)pack_py_lsa_DeleteObject_args_in, (py_data_unpack_fn)unpack_py_lsa_DeleteObject_args_out, 34, &ndr_table_lsarpc },
	{ "EnumAccountsWithUserRight", "S.EnumAccountsWithUserRight(handle, name) -> sids", (py_dcerpc_call_fn)dcerpc_lsa_EnumAccountsWithUserRight_r, (py_data_pack_fn)pack_py_lsa_EnumAccountsWithUserRight_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumAccountsWithUserRight_args_out, 35, &ndr_table_lsarpc },
	{ "EnumAccountRights", "S.EnumAccountRights(handle, sid) -> rights", (py_dcerpc_call_fn)dcerpc_lsa_EnumAccountRights_r, (py_data_pack_fn)pack_py_lsa_EnumAccountRights_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumAccountRights_args_out, 36, &ndr_table_lsarpc },
	{ "AddAccountRights", "S.AddAccountRights(handle, sid, rights) -> None", (py_dcerpc_call_fn)dcerpc_lsa_AddAccountRights_r, (py_data_pack_fn)pack_py_lsa_AddAccountRights_args_in, (py_data_unpack_fn)unpack_py_lsa_AddAccountRights_args_out, 37, &ndr_table_lsarpc },
	{ "RemoveAccountRights", "S.RemoveAccountRights(handle, sid, remove_all, rights) -> None", (py_dcerpc_call_fn)dcerpc_lsa_RemoveAccountRights_r, (py_data_pack_fn)pack_py_lsa_RemoveAccountRights_args_in, (py_data_unpack_fn)unpack_py_lsa_RemoveAccountRights_args_out, 38, &ndr_table_lsarpc },
	{ "QueryTrustedDomainInfoBySid", "S.QueryTrustedDomainInfoBySid(handle, dom_sid, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryTrustedDomainInfoBySid_r, (py_data_pack_fn)pack_py_lsa_QueryTrustedDomainInfoBySid_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryTrustedDomainInfoBySid_args_out, 39, &ndr_table_lsarpc },
	{ "SetTrustedDomainInfo", "S.SetTrustedDomainInfo(handle, dom_sid, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetTrustedDomainInfo_r, (py_data_pack_fn)pack_py_lsa_SetTrustedDomainInfo_args_in, (py_data_unpack_fn)unpack_py_lsa_SetTrustedDomainInfo_args_out, 40, &ndr_table_lsarpc },
	{ "DeleteTrustedDomain", "S.DeleteTrustedDomain(handle, dom_sid) -> None", (py_dcerpc_call_fn)dcerpc_lsa_DeleteTrustedDomain_r, (py_data_pack_fn)pack_py_lsa_DeleteTrustedDomain_args_in, (py_data_unpack_fn)unpack_py_lsa_DeleteTrustedDomain_args_out, 41, &ndr_table_lsarpc },
	{ "StorePrivateData", "S.StorePrivateData(handle, name, val) -> None", (py_dcerpc_call_fn)dcerpc_lsa_StorePrivateData_r, (py_data_pack_fn)pack_py_lsa_StorePrivateData_args_in, (py_data_unpack_fn)unpack_py_lsa_StorePrivateData_args_out, 42, &ndr_table_lsarpc },
	{ "RetrievePrivateData", "S.RetrievePrivateData(handle, name, val) -> val", (py_dcerpc_call_fn)dcerpc_lsa_RetrievePrivateData_r, (py_data_pack_fn)pack_py_lsa_RetrievePrivateData_args_in, (py_data_unpack_fn)unpack_py_lsa_RetrievePrivateData_args_out, 43, &ndr_table_lsarpc },
	{ "OpenPolicy2", "S.OpenPolicy2(system_name, attr, access_mask) -> handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenPolicy2_r, (py_data_pack_fn)pack_py_lsa_OpenPolicy2_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenPolicy2_args_out, 44, &ndr_table_lsarpc },
	{ "GetUserName", "S.GetUserName(system_name, account_name, authority_name) -> (account_name, authority_name)", (py_dcerpc_call_fn)dcerpc_lsa_GetUserName_r, (py_data_pack_fn)pack_py_lsa_GetUserName_args_in, (py_data_unpack_fn)unpack_py_lsa_GetUserName_args_out, 45, &ndr_table_lsarpc },
	{ "QueryInfoPolicy2", "S.QueryInfoPolicy2(handle, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryInfoPolicy2_r, (py_data_pack_fn)pack_py_lsa_QueryInfoPolicy2_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryInfoPolicy2_args_out, 46, &ndr_table_lsarpc },
	{ "SetInfoPolicy2", "S.SetInfoPolicy2(handle, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetInfoPolicy2_r, (py_data_pack_fn)pack_py_lsa_SetInfoPolicy2_args_in, (py_data_unpack_fn)unpack_py_lsa_SetInfoPolicy2_args_out, 47, &ndr_table_lsarpc },
	{ "QueryTrustedDomainInfoByName", "S.QueryTrustedDomainInfoByName(handle, trusted_domain, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryTrustedDomainInfoByName_r, (py_data_pack_fn)pack_py_lsa_QueryTrustedDomainInfoByName_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryTrustedDomainInfoByName_args_out, 48, &ndr_table_lsarpc },
	{ "SetTrustedDomainInfoByName", "S.SetTrustedDomainInfoByName(handle, trusted_domain, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetTrustedDomainInfoByName_r, (py_data_pack_fn)pack_py_lsa_SetTrustedDomainInfoByName_args_in, (py_data_unpack_fn)unpack_py_lsa_SetTrustedDomainInfoByName_args_out, 49, &ndr_table_lsarpc },
	{ "EnumTrustedDomainsEx", "S.EnumTrustedDomainsEx(handle, resume_handle, max_size) -> (resume_handle, domains)", (py_dcerpc_call_fn)dcerpc_lsa_EnumTrustedDomainsEx_r, (py_data_pack_fn)pack_py_lsa_EnumTrustedDomainsEx_args_in, (py_data_unpack_fn)unpack_py_lsa_EnumTrustedDomainsEx_args_out, 50, &ndr_table_lsarpc },
	{ "CreateTrustedDomainEx", "S.CreateTrustedDomainEx(policy_handle, info, auth_info, access_mask) -> trustdom_handle", (py_dcerpc_call_fn)dcerpc_lsa_CreateTrustedDomainEx_r, (py_data_pack_fn)pack_py_lsa_CreateTrustedDomainEx_args_in, (py_data_unpack_fn)unpack_py_lsa_CreateTrustedDomainEx_args_out, 51, &ndr_table_lsarpc },
	{ "CloseTrustedDomainEx", "S.CloseTrustedDomainEx(handle) -> handle", (py_dcerpc_call_fn)dcerpc_lsa_CloseTrustedDomainEx_r, (py_data_pack_fn)pack_py_lsa_CloseTrustedDomainEx_args_in, (py_data_unpack_fn)unpack_py_lsa_CloseTrustedDomainEx_args_out, 52, &ndr_table_lsarpc },
	{ "QueryDomainInformationPolicy", "S.QueryDomainInformationPolicy(handle, level) -> info", (py_dcerpc_call_fn)dcerpc_lsa_QueryDomainInformationPolicy_r, (py_data_pack_fn)pack_py_lsa_QueryDomainInformationPolicy_args_in, (py_data_unpack_fn)unpack_py_lsa_QueryDomainInformationPolicy_args_out, 53, &ndr_table_lsarpc },
	{ "SetDomainInformationPolicy", "S.SetDomainInformationPolicy(handle, level, info) -> None", (py_dcerpc_call_fn)dcerpc_lsa_SetDomainInformationPolicy_r, (py_data_pack_fn)pack_py_lsa_SetDomainInformationPolicy_args_in, (py_data_unpack_fn)unpack_py_lsa_SetDomainInformationPolicy_args_out, 54, &ndr_table_lsarpc },
	{ "OpenTrustedDomainByName", "S.OpenTrustedDomainByName(handle, name, access_mask) -> trustdom_handle", (py_dcerpc_call_fn)dcerpc_lsa_OpenTrustedDomainByName_r, (py_data_pack_fn)pack_py_lsa_OpenTrustedDomainByName_args_in, (py_data_unpack_fn)unpack_py_lsa_OpenTrustedDomainByName_args_out, 55, &ndr_table_lsarpc },
	{ "LookupSids2", "S.LookupSids2(handle, sids, names, level, count, lookup_options, client_revision) -> (domains, names, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupSids2_r, (py_data_pack_fn)pack_py_lsa_LookupSids2_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupSids2_args_out, 57, &ndr_table_lsarpc },
	{ "LookupNames2", "S.LookupNames2(handle, names, sids, level, count, lookup_options, client_revision) -> (domains, sids, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupNames2_r, (py_data_pack_fn)pack_py_lsa_LookupNames2_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupNames2_args_out, 58, &ndr_table_lsarpc },
	{ "CreateTrustedDomainEx2", "S.CreateTrustedDomainEx2(policy_handle, info, auth_info_internal, access_mask) -> trustdom_handle", (py_dcerpc_call_fn)dcerpc_lsa_CreateTrustedDomainEx2_r, (py_data_pack_fn)pack_py_lsa_CreateTrustedDomainEx2_args_in, (py_data_unpack_fn)unpack_py_lsa_CreateTrustedDomainEx2_args_out, 59, &ndr_table_lsarpc },
	{ "LookupNames3", "S.LookupNames3(handle, names, sids, level, count, lookup_options, client_revision) -> (domains, sids, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupNames3_r, (py_data_pack_fn)pack_py_lsa_LookupNames3_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupNames3_args_out, 68, &ndr_table_lsarpc },
	{ "lsaRQueryForestTrustInformation", "S.lsaRQueryForestTrustInformation(handle, trusted_domain_name, unknown) -> forest_trust_info", (py_dcerpc_call_fn)dcerpc_lsa_lsaRQueryForestTrustInformation_r, (py_data_pack_fn)pack_py_lsa_lsaRQueryForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_lsa_lsaRQueryForestTrustInformation_args_out, 73, &ndr_table_lsarpc },
	{ "lsaRSetForestTrustInformation", "S.lsaRSetForestTrustInformation(handle, trusted_domain_name, highest_record_type, forest_trust_info, check_only) -> collision_info", (py_dcerpc_call_fn)dcerpc_lsa_lsaRSetForestTrustInformation_r, (py_data_pack_fn)pack_py_lsa_lsaRSetForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_lsa_lsaRSetForestTrustInformation_args_out, 74, &ndr_table_lsarpc },
	{ "LookupSids3", "S.LookupSids3(sids, names, level, count, lookup_options, client_revision) -> (domains, names, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupSids3_r, (py_data_pack_fn)pack_py_lsa_LookupSids3_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupSids3_args_out, 76, &ndr_table_lsarpc },
	{ "LookupNames4", "S.LookupNames4(names, sids, level, count, lookup_options, client_revision) -> (domains, sids, count)", (py_dcerpc_call_fn)dcerpc_lsa_LookupNames4_r, (py_data_pack_fn)pack_py_lsa_LookupNames4_args_in, (py_data_unpack_fn)unpack_py_lsa_LookupNames4_args_out, 77, &ndr_table_lsarpc },
	{ NULL }
};

static PyObject *interface_lsarpc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_lsarpc);
}

#define PY_DOC_LSARPC "Local Security Authority"
static PyTypeObject lsarpc_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "lsa.lsarpc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "lsarpc(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_LSARPC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_lsarpc_new,
};

static PyMethodDef lsa_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initlsa(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	security_descriptor_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "descriptor");
	if (security_descriptor_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	sec_desc_buf_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "sec_desc_buf");
	if (sec_desc_buf_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	lsa_String_Type.tp_base = Object_Type;

	lsa_StringLarge_Type.tp_base = Object_Type;

	lsa_Strings_Type.tp_base = Object_Type;

	lsa_AsciiString_Type.tp_base = Object_Type;

	lsa_AsciiStringLarge_Type.tp_base = Object_Type;

	lsa_BinaryString_Type.tp_base = Object_Type;

	lsa_LUID_Type.tp_base = Object_Type;

	lsa_PrivEntry_Type.tp_base = Object_Type;

	lsa_PrivArray_Type.tp_base = Object_Type;

	lsa_QosInfo_Type.tp_base = Object_Type;

	lsa_ObjectAttribute_Type.tp_base = Object_Type;

	lsa_AuditLogInfo_Type.tp_base = Object_Type;

	lsa_AuditEventsInfo_Type.tp_base = Object_Type;

	lsa_DomainInfo_Type.tp_base = Object_Type;

	lsa_PDAccountInfo_Type.tp_base = Object_Type;

	lsa_ServerRole_Type.tp_base = Object_Type;

	lsa_ReplicaSourceInfo_Type.tp_base = Object_Type;

	lsa_DefaultQuotaInfo_Type.tp_base = Object_Type;

	lsa_ModificationInfo_Type.tp_base = Object_Type;

	lsa_AuditFullSetInfo_Type.tp_base = Object_Type;

	lsa_AuditFullQueryInfo_Type.tp_base = Object_Type;

	lsa_DnsDomainInfo_Type.tp_base = Object_Type;

	lsa_SidPtr_Type.tp_base = Object_Type;

	lsa_SidArray_Type.tp_base = Object_Type;

	lsa_DomainList_Type.tp_base = Object_Type;

	lsa_TranslatedSid_Type.tp_base = Object_Type;

	lsa_TransSidArray_Type.tp_base = Object_Type;

	lsa_RefDomainList_Type.tp_base = Object_Type;

	lsa_TranslatedName_Type.tp_base = Object_Type;

	lsa_TransNameArray_Type.tp_base = Object_Type;

	lsa_LUIDAttribute_Type.tp_base = Object_Type;

	lsa_PrivilegeSet_Type.tp_base = Object_Type;

	lsa_DATA_BUF_Type.tp_base = Object_Type;

	lsa_DATA_BUF2_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoName_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoControllers_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoPosixOffset_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoPassword_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoBasic_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoInfoEx_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoBuffer_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoAuthInfo_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoFullInfo_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoAuthInfoInternal_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoFullInfoInternal_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoInfoEx2Internal_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoFullInfo2Internal_Type.tp_base = Object_Type;

	lsa_TrustDomainInfoSupportedEncTypes_Type.tp_base = Object_Type;

	lsa_DATA_BUF_PTR_Type.tp_base = Object_Type;

	lsa_RightAttribute_Type.tp_base = Object_Type;

	lsa_RightSet_Type.tp_base = Object_Type;

	lsa_DomainListEx_Type.tp_base = Object_Type;

	lsa_DomainInfoKerberos_Type.tp_base = Object_Type;

	lsa_DomainInfoEfs_Type.tp_base = Object_Type;

	lsa_TranslatedName2_Type.tp_base = Object_Type;

	lsa_TransNameArray2_Type.tp_base = Object_Type;

	lsa_TranslatedSid2_Type.tp_base = Object_Type;

	lsa_TransSidArray2_Type.tp_base = Object_Type;

	lsa_TranslatedSid3_Type.tp_base = Object_Type;

	lsa_TransSidArray3_Type.tp_base = Object_Type;

	lsa_ForestTrustBinaryData_Type.tp_base = Object_Type;

	lsa_ForestTrustDomainInfo_Type.tp_base = Object_Type;

	lsa_ForestTrustRecord_Type.tp_base = Object_Type;

	lsa_ForestTrustInformation_Type.tp_base = Object_Type;

	lsa_ForestTrustCollisionRecord_Type.tp_base = Object_Type;

	lsa_ForestTrustCollisionInfo_Type.tp_base = Object_Type;

	lsarpc_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&lsa_String_Type) < 0)
		return;
	if (PyType_Ready(&lsa_StringLarge_Type) < 0)
		return;
	if (PyType_Ready(&lsa_Strings_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AsciiString_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AsciiStringLarge_Type) < 0)
		return;
	if (PyType_Ready(&lsa_BinaryString_Type) < 0)
		return;
	if (PyType_Ready(&lsa_LUID_Type) < 0)
		return;
	if (PyType_Ready(&lsa_PrivEntry_Type) < 0)
		return;
	if (PyType_Ready(&lsa_PrivArray_Type) < 0)
		return;
	if (PyType_Ready(&lsa_QosInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ObjectAttribute_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AuditLogInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AuditEventsInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DomainInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_PDAccountInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ServerRole_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ReplicaSourceInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DefaultQuotaInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ModificationInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AuditFullSetInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_AuditFullQueryInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DnsDomainInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_SidPtr_Type) < 0)
		return;
	if (PyType_Ready(&lsa_SidArray_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DomainList_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TranslatedSid_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TransSidArray_Type) < 0)
		return;
	if (PyType_Ready(&lsa_RefDomainList_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TranslatedName_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TransNameArray_Type) < 0)
		return;
	if (PyType_Ready(&lsa_LUIDAttribute_Type) < 0)
		return;
	if (PyType_Ready(&lsa_PrivilegeSet_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DATA_BUF_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DATA_BUF2_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoName_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoControllers_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoPosixOffset_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoPassword_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoBasic_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoInfoEx_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoBuffer_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoAuthInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoFullInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoAuthInfoInternal_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoFullInfoInternal_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoInfoEx2Internal_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoFullInfo2Internal_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TrustDomainInfoSupportedEncTypes_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DATA_BUF_PTR_Type) < 0)
		return;
	if (PyType_Ready(&lsa_RightAttribute_Type) < 0)
		return;
	if (PyType_Ready(&lsa_RightSet_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DomainListEx_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DomainInfoKerberos_Type) < 0)
		return;
	if (PyType_Ready(&lsa_DomainInfoEfs_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TranslatedName2_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TransNameArray2_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TranslatedSid2_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TransSidArray2_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TranslatedSid3_Type) < 0)
		return;
	if (PyType_Ready(&lsa_TransSidArray3_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustBinaryData_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustDomainInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustRecord_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustInformation_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustCollisionRecord_Type) < 0)
		return;
	if (PyType_Ready(&lsa_ForestTrustCollisionInfo_Type) < 0)
		return;
	if (PyType_Ready(&lsarpc_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&lsarpc_InterfaceType, py_ndr_lsarpc_methods))
		return;

#ifdef PY_STRING_PATCH
	PY_STRING_PATCH(&lsa_String_Type);
#endif
#ifdef PY_STRINGLARGE_PATCH
	PY_STRINGLARGE_PATCH(&lsa_StringLarge_Type);
#endif
#ifdef PY_STRINGS_PATCH
	PY_STRINGS_PATCH(&lsa_Strings_Type);
#endif
#ifdef PY_ASCIISTRING_PATCH
	PY_ASCIISTRING_PATCH(&lsa_AsciiString_Type);
#endif
#ifdef PY_ASCIISTRINGLARGE_PATCH
	PY_ASCIISTRINGLARGE_PATCH(&lsa_AsciiStringLarge_Type);
#endif
#ifdef PY_BINARYSTRING_PATCH
	PY_BINARYSTRING_PATCH(&lsa_BinaryString_Type);
#endif
#ifdef PY_LUID_PATCH
	PY_LUID_PATCH(&lsa_LUID_Type);
#endif
#ifdef PY_PRIVENTRY_PATCH
	PY_PRIVENTRY_PATCH(&lsa_PrivEntry_Type);
#endif
#ifdef PY_PRIVARRAY_PATCH
	PY_PRIVARRAY_PATCH(&lsa_PrivArray_Type);
#endif
#ifdef PY_QOSINFO_PATCH
	PY_QOSINFO_PATCH(&lsa_QosInfo_Type);
#endif
#ifdef PY_OBJECTATTRIBUTE_PATCH
	PY_OBJECTATTRIBUTE_PATCH(&lsa_ObjectAttribute_Type);
#endif
#ifdef PY_AUDITLOGINFO_PATCH
	PY_AUDITLOGINFO_PATCH(&lsa_AuditLogInfo_Type);
#endif
#ifdef PY_AUDITEVENTSINFO_PATCH
	PY_AUDITEVENTSINFO_PATCH(&lsa_AuditEventsInfo_Type);
#endif
#ifdef PY_DOMAININFO_PATCH
	PY_DOMAININFO_PATCH(&lsa_DomainInfo_Type);
#endif
#ifdef PY_PDACCOUNTINFO_PATCH
	PY_PDACCOUNTINFO_PATCH(&lsa_PDAccountInfo_Type);
#endif
#ifdef PY_SERVERROLE_PATCH
	PY_SERVERROLE_PATCH(&lsa_ServerRole_Type);
#endif
#ifdef PY_REPLICASOURCEINFO_PATCH
	PY_REPLICASOURCEINFO_PATCH(&lsa_ReplicaSourceInfo_Type);
#endif
#ifdef PY_DEFAULTQUOTAINFO_PATCH
	PY_DEFAULTQUOTAINFO_PATCH(&lsa_DefaultQuotaInfo_Type);
#endif
#ifdef PY_MODIFICATIONINFO_PATCH
	PY_MODIFICATIONINFO_PATCH(&lsa_ModificationInfo_Type);
#endif
#ifdef PY_AUDITFULLSETINFO_PATCH
	PY_AUDITFULLSETINFO_PATCH(&lsa_AuditFullSetInfo_Type);
#endif
#ifdef PY_AUDITFULLQUERYINFO_PATCH
	PY_AUDITFULLQUERYINFO_PATCH(&lsa_AuditFullQueryInfo_Type);
#endif
#ifdef PY_DNSDOMAININFO_PATCH
	PY_DNSDOMAININFO_PATCH(&lsa_DnsDomainInfo_Type);
#endif
#ifdef PY_SIDPTR_PATCH
	PY_SIDPTR_PATCH(&lsa_SidPtr_Type);
#endif
#ifdef PY_SIDARRAY_PATCH
	PY_SIDARRAY_PATCH(&lsa_SidArray_Type);
#endif
#ifdef PY_DOMAINLIST_PATCH
	PY_DOMAINLIST_PATCH(&lsa_DomainList_Type);
#endif
#ifdef PY_TRANSLATEDSID_PATCH
	PY_TRANSLATEDSID_PATCH(&lsa_TranslatedSid_Type);
#endif
#ifdef PY_TRANSSIDARRAY_PATCH
	PY_TRANSSIDARRAY_PATCH(&lsa_TransSidArray_Type);
#endif
#ifdef PY_REFDOMAINLIST_PATCH
	PY_REFDOMAINLIST_PATCH(&lsa_RefDomainList_Type);
#endif
#ifdef PY_TRANSLATEDNAME_PATCH
	PY_TRANSLATEDNAME_PATCH(&lsa_TranslatedName_Type);
#endif
#ifdef PY_TRANSNAMEARRAY_PATCH
	PY_TRANSNAMEARRAY_PATCH(&lsa_TransNameArray_Type);
#endif
#ifdef PY_LUIDATTRIBUTE_PATCH
	PY_LUIDATTRIBUTE_PATCH(&lsa_LUIDAttribute_Type);
#endif
#ifdef PY_PRIVILEGESET_PATCH
	PY_PRIVILEGESET_PATCH(&lsa_PrivilegeSet_Type);
#endif
#ifdef PY_DATA_BUF_PATCH
	PY_DATA_BUF_PATCH(&lsa_DATA_BUF_Type);
#endif
#ifdef PY_DATA_BUF2_PATCH
	PY_DATA_BUF2_PATCH(&lsa_DATA_BUF2_Type);
#endif
#ifdef PY_TRUSTDOMAININFONAME_PATCH
	PY_TRUSTDOMAININFONAME_PATCH(&lsa_TrustDomainInfoName_Type);
#endif
#ifdef PY_TRUSTDOMAININFOCONTROLLERS_PATCH
	PY_TRUSTDOMAININFOCONTROLLERS_PATCH(&lsa_TrustDomainInfoControllers_Type);
#endif
#ifdef PY_TRUSTDOMAININFOPOSIXOFFSET_PATCH
	PY_TRUSTDOMAININFOPOSIXOFFSET_PATCH(&lsa_TrustDomainInfoPosixOffset_Type);
#endif
#ifdef PY_TRUSTDOMAININFOPASSWORD_PATCH
	PY_TRUSTDOMAININFOPASSWORD_PATCH(&lsa_TrustDomainInfoPassword_Type);
#endif
#ifdef PY_TRUSTDOMAININFOBASIC_PATCH
	PY_TRUSTDOMAININFOBASIC_PATCH(&lsa_TrustDomainInfoBasic_Type);
#endif
#ifdef PY_TRUSTDOMAININFOINFOEX_PATCH
	PY_TRUSTDOMAININFOINFOEX_PATCH(&lsa_TrustDomainInfoInfoEx_Type);
#endif
#ifdef PY_TRUSTDOMAININFOBUFFER_PATCH
	PY_TRUSTDOMAININFOBUFFER_PATCH(&lsa_TrustDomainInfoBuffer_Type);
#endif
#ifdef PY_TRUSTDOMAININFOAUTHINFO_PATCH
	PY_TRUSTDOMAININFOAUTHINFO_PATCH(&lsa_TrustDomainInfoAuthInfo_Type);
#endif
#ifdef PY_TRUSTDOMAININFOFULLINFO_PATCH
	PY_TRUSTDOMAININFOFULLINFO_PATCH(&lsa_TrustDomainInfoFullInfo_Type);
#endif
#ifdef PY_TRUSTDOMAININFOAUTHINFOINTERNAL_PATCH
	PY_TRUSTDOMAININFOAUTHINFOINTERNAL_PATCH(&lsa_TrustDomainInfoAuthInfoInternal_Type);
#endif
#ifdef PY_TRUSTDOMAININFOFULLINFOINTERNAL_PATCH
	PY_TRUSTDOMAININFOFULLINFOINTERNAL_PATCH(&lsa_TrustDomainInfoFullInfoInternal_Type);
#endif
#ifdef PY_TRUSTDOMAININFOINFOEX2INTERNAL_PATCH
	PY_TRUSTDOMAININFOINFOEX2INTERNAL_PATCH(&lsa_TrustDomainInfoInfoEx2Internal_Type);
#endif
#ifdef PY_TRUSTDOMAININFOFULLINFO2INTERNAL_PATCH
	PY_TRUSTDOMAININFOFULLINFO2INTERNAL_PATCH(&lsa_TrustDomainInfoFullInfo2Internal_Type);
#endif
#ifdef PY_TRUSTDOMAININFOSUPPORTEDENCTYPES_PATCH
	PY_TRUSTDOMAININFOSUPPORTEDENCTYPES_PATCH(&lsa_TrustDomainInfoSupportedEncTypes_Type);
#endif
#ifdef PY_DATA_BUF_PTR_PATCH
	PY_DATA_BUF_PTR_PATCH(&lsa_DATA_BUF_PTR_Type);
#endif
#ifdef PY_RIGHTATTRIBUTE_PATCH
	PY_RIGHTATTRIBUTE_PATCH(&lsa_RightAttribute_Type);
#endif
#ifdef PY_RIGHTSET_PATCH
	PY_RIGHTSET_PATCH(&lsa_RightSet_Type);
#endif
#ifdef PY_DOMAINLISTEX_PATCH
	PY_DOMAINLISTEX_PATCH(&lsa_DomainListEx_Type);
#endif
#ifdef PY_DOMAININFOKERBEROS_PATCH
	PY_DOMAININFOKERBEROS_PATCH(&lsa_DomainInfoKerberos_Type);
#endif
#ifdef PY_DOMAININFOEFS_PATCH
	PY_DOMAININFOEFS_PATCH(&lsa_DomainInfoEfs_Type);
#endif
#ifdef PY_TRANSLATEDNAME2_PATCH
	PY_TRANSLATEDNAME2_PATCH(&lsa_TranslatedName2_Type);
#endif
#ifdef PY_TRANSNAMEARRAY2_PATCH
	PY_TRANSNAMEARRAY2_PATCH(&lsa_TransNameArray2_Type);
#endif
#ifdef PY_TRANSLATEDSID2_PATCH
	PY_TRANSLATEDSID2_PATCH(&lsa_TranslatedSid2_Type);
#endif
#ifdef PY_TRANSSIDARRAY2_PATCH
	PY_TRANSSIDARRAY2_PATCH(&lsa_TransSidArray2_Type);
#endif
#ifdef PY_TRANSLATEDSID3_PATCH
	PY_TRANSLATEDSID3_PATCH(&lsa_TranslatedSid3_Type);
#endif
#ifdef PY_TRANSSIDARRAY3_PATCH
	PY_TRANSSIDARRAY3_PATCH(&lsa_TransSidArray3_Type);
#endif
#ifdef PY_FORESTTRUSTBINARYDATA_PATCH
	PY_FORESTTRUSTBINARYDATA_PATCH(&lsa_ForestTrustBinaryData_Type);
#endif
#ifdef PY_FORESTTRUSTDOMAININFO_PATCH
	PY_FORESTTRUSTDOMAININFO_PATCH(&lsa_ForestTrustDomainInfo_Type);
#endif
#ifdef PY_FORESTTRUSTRECORD_PATCH
	PY_FORESTTRUSTRECORD_PATCH(&lsa_ForestTrustRecord_Type);
#endif
#ifdef PY_FORESTTRUSTINFORMATION_PATCH
	PY_FORESTTRUSTINFORMATION_PATCH(&lsa_ForestTrustInformation_Type);
#endif
#ifdef PY_FORESTTRUSTCOLLISIONRECORD_PATCH
	PY_FORESTTRUSTCOLLISIONRECORD_PATCH(&lsa_ForestTrustCollisionRecord_Type);
#endif
#ifdef PY_FORESTTRUSTCOLLISIONINFO_PATCH
	PY_FORESTTRUSTCOLLISIONINFO_PATCH(&lsa_ForestTrustCollisionInfo_Type);
#endif
#ifdef PY_LSARPC_PATCH
	PY_LSARPC_PATCH(&lsarpc_InterfaceType);
#endif

	m = Py_InitModule3("lsa", lsa_methods, "lsa DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_COLLISION_XREF", PyInt_FromLong(LSA_FOREST_TRUST_COLLISION_XREF));
	PyModule_AddObject(m, "LSA_POLICY_INFO_ACCOUNT_DOMAIN", PyInt_FromLong(LSA_POLICY_INFO_ACCOUNT_DOMAIN));
	PyModule_AddObject(m, "LSA_DOMAIN_INFO_POLICY_KERBEROS", PyInt_FromLong(LSA_DOMAIN_INFO_POLICY_KERBEROS));
	PyModule_AddObject(m, "LSA_CLIENT_REVISION_DNS", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "LSA_CLIENT_REVISION_2", PyInt_FromLong(LSA_CLIENT_REVISION_2));
	PyModule_AddObject(m, "TRUST_AUTH_TYPE_NONE", PyInt_FromLong(TRUST_AUTH_TYPE_NONE));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_COLLISION_TDO", PyInt_FromLong(LSA_FOREST_TRUST_COLLISION_TDO));
	PyModule_AddObject(m, "LSA_SECRET_QUERY_VALUE", PyInt_FromLong(LSA_SECRET_QUERY_VALUE));
	PyModule_AddObject(m, "LSA_POLICY_CREATE_PRIVILEGE", PyInt_FromLong(LSA_POLICY_CREATE_PRIVILEGE));
	PyModule_AddObject(m, "LSA_LOOKUP_OPTIONS_NO_ISOLATED", PyInt_FromLong(0x80000000));
	PyModule_AddObject(m, "LSA_POLICY_INFO_DNS_INT", PyInt_FromLong(LSA_POLICY_INFO_DNS_INT));
	PyModule_AddObject(m, "LSA_POLICY_NOTIFICATION", PyInt_FromLong(LSA_POLICY_NOTIFICATION));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_UPLEVEL_ONLY", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_UPLEVEL_ONLY));
	PyModule_AddObject(m, "LSA_DOMAIN_INFO_POLICY_EFS", PyInt_FromLong(LSA_DOMAIN_INFO_POLICY_EFS));
	PyModule_AddObject(m, "LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES", PyInt_FromLong(LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES));
	PyModule_AddObject(m, "LSA_TRUST_TYPE_UPLEVEL", PyInt_FromLong(LSA_TRUST_TYPE_UPLEVEL));
	PyModule_AddObject(m, "SID_NAME_USER", PyInt_FromLong(SID_NAME_USER));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_USES_RC4_ENCRYPTION", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_USES_RC4_ENCRYPTION));
	PyModule_AddObject(m, "LSA_POLICY_READ", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_VIEW_AUDIT_INFORMATION|LSA_POLICY_GET_PRIVATE_INFORMATION)));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_RECORD_TYPE_LAST", PyInt_FromLong(LSA_FOREST_TRUST_RECORD_TYPE_LAST));
	PyModule_AddObject(m, "LSA_TLN_DISABLED_NEW", PyInt_FromLong(LSA_TLN_DISABLED_NEW));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_SYSTEM", PyInt_FromLong(LSA_AUDIT_CATEGORY_SYSTEM));
	PyModule_AddObject(m, "LSA_AUDIT_POLICY_FAILURE", PyInt_FromLong(LSA_AUDIT_POLICY_FAILURE));
	PyModule_AddObject(m, "LSA_POLICY_INFO_QUOTA", PyInt_FromLong(LSA_POLICY_INFO_QUOTA));
	PyModule_AddObject(m, "LSA_ACCOUNT_ADJUST_PRIVILEGES", PyInt_FromLong(LSA_ACCOUNT_ADJUST_PRIVILEGES));
	PyModule_AddObject(m, "LSA_ROLE_PRIMARY", PyInt_FromLong(LSA_ROLE_PRIMARY));
	PyModule_AddObject(m, "LSA_CLIENT_REVISION_NO_DNS", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "LSA_POLICY_EXECUTE", PyInt_FromLong((STANDARD_RIGHTS_EXECUTE_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_LOOKUP_NAMES)));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_ALL", PyInt_FromLong(LSA_LOOKUP_NAMES_ALL));
	PyModule_AddObject(m, "LSA_POLICY_INFO_DOMAIN", PyInt_FromLong(LSA_POLICY_INFO_DOMAIN));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_DOMAIN_INFO", PyInt_FromLong(LSA_FOREST_TRUST_DOMAIN_INFO));
	PyModule_AddObject(m, "LSA_AUDIT_POLICY_ALL", PyInt_FromLong(LSA_AUDIT_POLICY_ALL));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_WRITE", PyInt_FromLong((LSA_TRUSTED_SET_CONTROLLERS|LSA_TRUSTED_SET_POSIX|LSA_TRUSTED_SET_AUTH|STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL));
	PyModule_AddObject(m, "LSA_POLICY_WRITE", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS|LSA_POLICY_TRUST_ADMIN|LSA_POLICY_CREATE_ACCOUNT|LSA_POLICY_CREATE_SECRET|LSA_POLICY_CREATE_PRIVILEGE|LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS|LSA_POLICY_SET_AUDIT_REQUIREMENTS|LSA_POLICY_AUDIT_LOG_ADMIN|LSA_POLICY_SERVER_ADMIN)));
	PyModule_AddObject(m, "LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL", PyInt_FromLong(LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL));
	PyModule_AddObject(m, "LSA_SECRET_WRITE", PyInt_FromLong((LSA_SECRET_SET_VALUE|STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS", PyInt_FromLong(LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS));
	PyModule_AddObject(m, "LSA_SECRET_ALL_ACCESS", PyInt_FromLong((LSA_SECRET_QUERY_VALUE|LSA_SECRET_SET_VALUE|SEC_STD_DELETE|STANDARD_RIGHTS_READ_ACCESS|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER)));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_PASSWORD", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_PASSWORD));
	PyModule_AddObject(m, "LSA_POLICY_VIEW_LOCAL_INFORMATION", PyInt_FromLong(LSA_POLICY_VIEW_LOCAL_INFORMATION));
	PyModule_AddObject(m, "LSA_ROLE_BACKUP", PyInt_FromLong(LSA_ROLE_BACKUP));
	PyModule_AddObject(m, "LSA_TRUSTED_SET_CONTROLLERS", PyInt_FromLong(LSA_TRUSTED_SET_CONTROLLERS));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_PROCCESS_TRACKING", PyInt_FromLong(LSA_AUDIT_CATEGORY_PROCCESS_TRACKING));
	PyModule_AddObject(m, "LSA_TRUST_DIRECTION_OUTBOUND", PyInt_FromLong(LSA_TRUST_DIRECTION_OUTBOUND));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES", PyInt_FromLong(LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES));
	PyModule_AddObject(m, "LSA_POLICY_INFO_MOD", PyInt_FromLong(LSA_POLICY_INFO_MOD));
	PyModule_AddObject(m, "LSA_POLICY_INFO_L_ACCOUNT_DOMAIN", PyInt_FromLong(LSA_POLICY_INFO_L_ACCOUNT_DOMAIN));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY", PyInt_FromLong(LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES", PyInt_FromLong(LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_FOREST_TRANSITIVE));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS", PyInt_FromLong(LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT", PyInt_FromLong(LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC", PyInt_FromLong(LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC));
	PyModule_AddObject(m, "LSA_TRUSTED_QUERY_CONTROLLERS", PyInt_FromLong(LSA_TRUSTED_QUERY_CONTROLLERS));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_WITHIN_FOREST", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_WITHIN_FOREST));
	PyModule_AddObject(m, "LSA_POLICY_SERVER_ADMIN", PyInt_FromLong(LSA_POLICY_SERVER_ADMIN));
	PyModule_AddObject(m, "SID_NAME_DOMAIN", PyInt_FromLong(SID_NAME_DOMAIN));
	PyModule_AddObject(m, "LSA_NB_DISABLED_CONFLICT", PyInt_FromLong(LSA_NB_DISABLED_CONFLICT));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS", PyInt_FromLong(LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX", PyInt_FromLong(LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_COLLISION_OTHER", PyInt_FromLong(LSA_FOREST_TRUST_COLLISION_OTHER));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2", PyInt_FromLong(LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2));
	PyModule_AddObject(m, "SID_NAME_DOM_GRP", PyInt_FromLong(SID_NAME_DOM_GRP));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_EXECUTE", PyInt_FromLong((LSA_TRUSTED_QUERY_DOMAIN_NAME|LSA_TRUSTED_QUERY_POSIX|STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO));
	PyModule_AddObject(m, "LSA_POLICY_INFO_ROLE", PyInt_FromLong(LSA_POLICY_INFO_ROLE));
	PyModule_AddObject(m, "LSA_POLICY_INFO_AUDIT_LOG", PyInt_FromLong(LSA_POLICY_INFO_AUDIT_LOG));
	PyModule_AddObject(m, "TRUST_AUTH_TYPE_VERSION", PyInt_FromLong(TRUST_AUTH_TYPE_VERSION));
	PyModule_AddObject(m, "LSA_POLICY_SET_AUDIT_REQUIREMENTS", PyInt_FromLong(LSA_POLICY_SET_AUDIT_REQUIREMENTS));
	PyModule_AddObject(m, "SID_NAME_DELETED", PyInt_FromLong(SID_NAME_DELETED));
	PyModule_AddObject(m, "LSA_AUDIT_POLICY_NONE", PyInt_FromLong(LSA_AUDIT_POLICY_NONE));
	PyModule_AddObject(m, "LSA_TRUST_DIRECTION_INBOUND", PyInt_FromLong(LSA_TRUST_DIRECTION_INBOUND));
	PyModule_AddObject(m, "LSA_ENUM_TRUST_DOMAIN_EX_MULTIPLIER", PyInt_FromLong(82));
	PyModule_AddObject(m, "LSA_POLICY_KERBEROS_VALIDATE_CLIENT", PyInt_FromLong(LSA_POLICY_KERBEROS_VALIDATE_CLIENT));
	PyModule_AddObject(m, "LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS", PyInt_FromLong(LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_LOGON", PyInt_FromLong(LSA_AUDIT_CATEGORY_LOGON));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_DOMAINS_ONLY", PyInt_FromLong(LSA_LOOKUP_NAMES_DOMAINS_ONLY));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO));
	PyModule_AddObject(m, "LSA_TRUST_TYPE_MIT", PyInt_FromLong(LSA_TRUST_TYPE_MIT));
	PyModule_AddObject(m, "LSA_AUDIT_POLICY_CLEAR", PyInt_FromLong(LSA_AUDIT_POLICY_CLEAR));
	PyModule_AddObject(m, "LSA_TRUSTED_QUERY_DOMAIN_NAME", PyInt_FromLong(LSA_TRUSTED_QUERY_DOMAIN_NAME));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL));
	PyModule_AddObject(m, "LSA_SECRET_SET_VALUE", PyInt_FromLong(LSA_SECRET_SET_VALUE));
	PyModule_AddObject(m, "LSA_POLICY_AUDIT_LOG_ADMIN", PyInt_FromLong(LSA_POLICY_AUDIT_LOG_ADMIN));
	PyModule_AddObject(m, "TRUST_AUTH_TYPE_NT4OWF", PyInt_FromLong(TRUST_AUTH_TYPE_NT4OWF));
	PyModule_AddObject(m, "LSA_POLICY_CREATE_ACCOUNT", PyInt_FromLong(LSA_POLICY_CREATE_ACCOUNT));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL));
	PyModule_AddObject(m, "SID_NAME_WKN_GRP", PyInt_FromLong(SID_NAME_WKN_GRP));
	PyModule_AddObject(m, "LSA_TRUSTED_SET_AUTH", PyInt_FromLong(LSA_TRUSTED_SET_AUTH));
	PyModule_AddObject(m, "SID_NAME_INVALID", PyInt_FromLong(SID_NAME_INVALID));
	PyModule_AddObject(m, "LSA_POLICY_ALL_ACCESS", PyInt_FromLong((STANDARD_RIGHTS_REQUIRED_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_VIEW_AUDIT_INFORMATION|LSA_POLICY_GET_PRIVATE_INFORMATION|LSA_POLICY_TRUST_ADMIN|LSA_POLICY_CREATE_ACCOUNT|LSA_POLICY_CREATE_SECRET|LSA_POLICY_CREATE_PRIVILEGE|LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS|LSA_POLICY_SET_AUDIT_REQUIREMENTS|LSA_POLICY_AUDIT_LOG_ADMIN|LSA_POLICY_SERVER_ADMIN|LSA_POLICY_LOOKUP_NAMES)));
	PyModule_AddObject(m, "LSA_ACCOUNT_ADJUST_QUOTAS", PyInt_FromLong(LSA_ACCOUNT_ADJUST_QUOTAS));
	PyModule_AddObject(m, "LSA_TRUSTED_QUERY_POSIX", PyInt_FromLong(LSA_TRUSTED_QUERY_POSIX));
	PyModule_AddObject(m, "LSA_ACCOUNT_EXECUTE", PyInt_FromLong((STANDARD_RIGHTS_EXECUTE_ACCESS)));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY", PyInt_FromLong(LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY));
	PyModule_AddObject(m, "SID_NAME_COMPUTER", PyInt_FromLong(SID_NAME_COMPUTER));
	PyModule_AddObject(m, "LSA_FOREST_TRUST_TOP_LEVEL_NAME", PyInt_FromLong(LSA_FOREST_TRUST_TOP_LEVEL_NAME));
	PyModule_AddObject(m, "LSA_REF_DOMAIN_LIST_MULTIPLIER", PyInt_FromLong(32));
	PyModule_AddObject(m, "LSA_POLICY_INFO_DNS", PyInt_FromLong(LSA_POLICY_INFO_DNS));
	PyModule_AddObject(m, "LSA_POLICY_INFO_PD", PyInt_FromLong(LSA_POLICY_INFO_PD));
	PyModule_AddObject(m, "LSA_POLICY_LOOKUP_NAMES", PyInt_FromLong(LSA_POLICY_LOOKUP_NAMES));
	PyModule_AddObject(m, "LSA_AUDIT_CATEGORY_ACCOUNT_LOGON", PyInt_FromLong(LSA_AUDIT_CATEGORY_ACCOUNT_LOGON));
	PyModule_AddObject(m, "LSA_SECRET_EXECUTE", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_NB_DISABLED_ADMIN", PyInt_FromLong(LSA_NB_DISABLED_ADMIN));
	PyModule_AddObject(m, "LSA_POLICY_GET_PRIVATE_INFORMATION", PyInt_FromLong(LSA_POLICY_GET_PRIVATE_INFORMATION));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_BASIC", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_BASIC));
	PyModule_AddObject(m, "LSA_ACCOUNT_VIEW", PyInt_FromLong(LSA_ACCOUNT_VIEW));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_READ", PyInt_FromLong((LSA_TRUSTED_QUERY_DOMAIN_NAME|STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_SID_DISABLED_CONFLICT", PyInt_FromLong(LSA_SID_DISABLED_CONFLICT));
	PyModule_AddObject(m, "LSA_ACCOUNT_ALL_ACCESS", PyInt_FromLong((STANDARD_RIGHTS_REQUIRED_ACCESS|LSA_ACCOUNT_VIEW|LSA_ACCOUNT_ADJUST_PRIVILEGES|LSA_ACCOUNT_ADJUST_QUOTAS|LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS)));
	PyModule_AddObject(m, "SID_NAME_USE_NONE", PyInt_FromLong(SID_NAME_USE_NONE));
	PyModule_AddObject(m, "LSA_POLICY_INFO_AUDIT_FULL_SET", PyInt_FromLong(LSA_POLICY_INFO_AUDIT_FULL_SET));
	PyModule_AddObject(m, "LSA_ACCOUNT_WRITE", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS|LSA_ACCOUNT_ADJUST_PRIVILEGES|LSA_ACCOUNT_ADJUST_QUOTAS|LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS)));
	PyModule_AddObject(m, "LSA_TLN_DISABLED_CONFLICT", PyInt_FromLong(LSA_TLN_DISABLED_CONFLICT));
	PyModule_AddObject(m, "LSA_POLICY_TRUST_ADMIN", PyInt_FromLong(LSA_POLICY_TRUST_ADMIN));
	PyModule_AddObject(m, "LSA_POLICY_CREATE_SECRET", PyInt_FromLong(LSA_POLICY_CREATE_SECRET));
	PyModule_AddObject(m, "LSA_TRUST_TYPE_DOWNLEVEL", PyInt_FromLong(LSA_TRUST_TYPE_DOWNLEVEL));
	PyModule_AddObject(m, "SID_NAME_ALIAS", PyInt_FromLong(SID_NAME_ALIAS));
	PyModule_AddObject(m, "LSA_POLICY_INFO_AUDIT_EVENTS", PyInt_FromLong(LSA_POLICY_INFO_AUDIT_EVENTS));
	PyModule_AddObject(m, "LSA_POLICY_INFO_AUDIT_FULL_QUERY", PyInt_FromLong(LSA_POLICY_INFO_AUDIT_FULL_QUERY));
	PyModule_AddObject(m, "LSA_CLIENT_REVISION_1", PyInt_FromLong(LSA_CLIENT_REVISION_1));
	PyModule_AddObject(m, "LSA_POLICY_INFO_REPLICA", PyInt_FromLong(LSA_POLICY_INFO_REPLICA));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS));
	PyModule_AddObject(m, "LSA_TLN_DISABLED_ADMIN", PyInt_FromLong(LSA_TLN_DISABLED_ADMIN));
	PyModule_AddObject(m, "LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY", PyInt_FromLong(LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY));
	PyModule_AddObject(m, "LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS", PyInt_FromLong(LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS));
	PyModule_AddObject(m, "LSA_TRUSTED_QUERY_AUTH", PyInt_FromLong(LSA_TRUSTED_QUERY_AUTH));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_NAME", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_NAME));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_ALL_ACCESS", PyInt_FromLong((LSA_TRUSTED_QUERY_DOMAIN_NAME|LSA_TRUSTED_QUERY_CONTROLLERS|LSA_TRUSTED_SET_CONTROLLERS|LSA_TRUSTED_QUERY_POSIX|LSA_TRUSTED_SET_POSIX|LSA_TRUSTED_SET_AUTH|LSA_TRUSTED_QUERY_AUTH|SEC_STD_DELETE|STANDARD_RIGHTS_READ_ACCESS|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER)));
	PyModule_AddObject(m, "LSA_SID_DISABLED_ADMIN", PyInt_FromLong(LSA_SID_DISABLED_ADMIN));
	PyModule_AddObject(m, "LSA_SECRET_READ", PyInt_FromLong((LSA_SECRET_QUERY_VALUE|STANDARD_RIGHTS_READ_ACCESS)));
	PyModule_AddObject(m, "LSA_TRUSTED_SET_POSIX", PyInt_FromLong(LSA_TRUSTED_SET_POSIX));
	PyModule_AddObject(m, "LSA_POLICY_VIEW_AUDIT_INFORMATION", PyInt_FromLong(LSA_POLICY_VIEW_AUDIT_INFORMATION));
	PyModule_AddObject(m, "TRUST_AUTH_TYPE_CLEAR", PyInt_FromLong(TRUST_AUTH_TYPE_CLEAR));
	PyModule_AddObject(m, "LSA_ENUM_TRUST_DOMAIN_MULTIPLIER", PyInt_FromLong(60));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION));
	PyModule_AddObject(m, "LSA_AUDIT_POLICY_SUCCESS", PyInt_FromLong(LSA_AUDIT_POLICY_SUCCESS));
	PyModule_AddObject(m, "SID_NAME_UNKNOWN", PyInt_FromLong(SID_NAME_UNKNOWN));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_NON_TRANSITIVE", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_NON_TRANSITIVE));
	PyModule_AddObject(m, "LSA_ACCOUNT_READ", PyInt_FromLong((STANDARD_RIGHTS_READ_ACCESS|LSA_ACCOUNT_VIEW)));
	PyModule_AddObject(m, "LSA_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", PyInt_FromLong(LSA_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL));
	PyModule_AddObject(m, "LSA_TRUSTED_DOMAIN_INFO_INFO_EX", PyInt_FromLong(LSA_TRUSTED_DOMAIN_INFO_INFO_EX));
	Py_INCREF((PyObject *)(void *)&lsa_String_Type);
	PyModule_AddObject(m, "String", (PyObject *)(void *)&lsa_String_Type);
	Py_INCREF((PyObject *)(void *)&lsa_StringLarge_Type);
	PyModule_AddObject(m, "StringLarge", (PyObject *)(void *)&lsa_StringLarge_Type);
	Py_INCREF((PyObject *)(void *)&lsa_Strings_Type);
	PyModule_AddObject(m, "Strings", (PyObject *)(void *)&lsa_Strings_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AsciiString_Type);
	PyModule_AddObject(m, "AsciiString", (PyObject *)(void *)&lsa_AsciiString_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AsciiStringLarge_Type);
	PyModule_AddObject(m, "AsciiStringLarge", (PyObject *)(void *)&lsa_AsciiStringLarge_Type);
	Py_INCREF((PyObject *)(void *)&lsa_BinaryString_Type);
	PyModule_AddObject(m, "BinaryString", (PyObject *)(void *)&lsa_BinaryString_Type);
	Py_INCREF((PyObject *)(void *)&lsa_LUID_Type);
	PyModule_AddObject(m, "LUID", (PyObject *)(void *)&lsa_LUID_Type);
	Py_INCREF((PyObject *)(void *)&lsa_PrivEntry_Type);
	PyModule_AddObject(m, "PrivEntry", (PyObject *)(void *)&lsa_PrivEntry_Type);
	Py_INCREF((PyObject *)(void *)&lsa_PrivArray_Type);
	PyModule_AddObject(m, "PrivArray", (PyObject *)(void *)&lsa_PrivArray_Type);
	Py_INCREF((PyObject *)(void *)&lsa_QosInfo_Type);
	PyModule_AddObject(m, "QosInfo", (PyObject *)(void *)&lsa_QosInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ObjectAttribute_Type);
	PyModule_AddObject(m, "ObjectAttribute", (PyObject *)(void *)&lsa_ObjectAttribute_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AuditLogInfo_Type);
	PyModule_AddObject(m, "AuditLogInfo", (PyObject *)(void *)&lsa_AuditLogInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AuditEventsInfo_Type);
	PyModule_AddObject(m, "AuditEventsInfo", (PyObject *)(void *)&lsa_AuditEventsInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DomainInfo_Type);
	PyModule_AddObject(m, "DomainInfo", (PyObject *)(void *)&lsa_DomainInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_PDAccountInfo_Type);
	PyModule_AddObject(m, "PDAccountInfo", (PyObject *)(void *)&lsa_PDAccountInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ServerRole_Type);
	PyModule_AddObject(m, "ServerRole", (PyObject *)(void *)&lsa_ServerRole_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ReplicaSourceInfo_Type);
	PyModule_AddObject(m, "ReplicaSourceInfo", (PyObject *)(void *)&lsa_ReplicaSourceInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DefaultQuotaInfo_Type);
	PyModule_AddObject(m, "DefaultQuotaInfo", (PyObject *)(void *)&lsa_DefaultQuotaInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ModificationInfo_Type);
	PyModule_AddObject(m, "ModificationInfo", (PyObject *)(void *)&lsa_ModificationInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AuditFullSetInfo_Type);
	PyModule_AddObject(m, "AuditFullSetInfo", (PyObject *)(void *)&lsa_AuditFullSetInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_AuditFullQueryInfo_Type);
	PyModule_AddObject(m, "AuditFullQueryInfo", (PyObject *)(void *)&lsa_AuditFullQueryInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DnsDomainInfo_Type);
	PyModule_AddObject(m, "DnsDomainInfo", (PyObject *)(void *)&lsa_DnsDomainInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_SidPtr_Type);
	PyModule_AddObject(m, "SidPtr", (PyObject *)(void *)&lsa_SidPtr_Type);
	Py_INCREF((PyObject *)(void *)&lsa_SidArray_Type);
	PyModule_AddObject(m, "SidArray", (PyObject *)(void *)&lsa_SidArray_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DomainList_Type);
	PyModule_AddObject(m, "DomainList", (PyObject *)(void *)&lsa_DomainList_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TranslatedSid_Type);
	PyModule_AddObject(m, "TranslatedSid", (PyObject *)(void *)&lsa_TranslatedSid_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TransSidArray_Type);
	PyModule_AddObject(m, "TransSidArray", (PyObject *)(void *)&lsa_TransSidArray_Type);
	Py_INCREF((PyObject *)(void *)&lsa_RefDomainList_Type);
	PyModule_AddObject(m, "RefDomainList", (PyObject *)(void *)&lsa_RefDomainList_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TranslatedName_Type);
	PyModule_AddObject(m, "TranslatedName", (PyObject *)(void *)&lsa_TranslatedName_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TransNameArray_Type);
	PyModule_AddObject(m, "TransNameArray", (PyObject *)(void *)&lsa_TransNameArray_Type);
	Py_INCREF((PyObject *)(void *)&lsa_LUIDAttribute_Type);
	PyModule_AddObject(m, "LUIDAttribute", (PyObject *)(void *)&lsa_LUIDAttribute_Type);
	Py_INCREF((PyObject *)(void *)&lsa_PrivilegeSet_Type);
	PyModule_AddObject(m, "PrivilegeSet", (PyObject *)(void *)&lsa_PrivilegeSet_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DATA_BUF_Type);
	PyModule_AddObject(m, "DATA_BUF", (PyObject *)(void *)&lsa_DATA_BUF_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DATA_BUF2_Type);
	PyModule_AddObject(m, "DATA_BUF2", (PyObject *)(void *)&lsa_DATA_BUF2_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoName_Type);
	PyModule_AddObject(m, "TrustDomainInfoName", (PyObject *)(void *)&lsa_TrustDomainInfoName_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoControllers_Type);
	PyModule_AddObject(m, "TrustDomainInfoControllers", (PyObject *)(void *)&lsa_TrustDomainInfoControllers_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoPosixOffset_Type);
	PyModule_AddObject(m, "TrustDomainInfoPosixOffset", (PyObject *)(void *)&lsa_TrustDomainInfoPosixOffset_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoPassword_Type);
	PyModule_AddObject(m, "TrustDomainInfoPassword", (PyObject *)(void *)&lsa_TrustDomainInfoPassword_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoBasic_Type);
	PyModule_AddObject(m, "TrustDomainInfoBasic", (PyObject *)(void *)&lsa_TrustDomainInfoBasic_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoInfoEx_Type);
	PyModule_AddObject(m, "TrustDomainInfoInfoEx", (PyObject *)(void *)&lsa_TrustDomainInfoInfoEx_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoBuffer_Type);
	PyModule_AddObject(m, "TrustDomainInfoBuffer", (PyObject *)(void *)&lsa_TrustDomainInfoBuffer_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoAuthInfo_Type);
	PyModule_AddObject(m, "TrustDomainInfoAuthInfo", (PyObject *)(void *)&lsa_TrustDomainInfoAuthInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoFullInfo_Type);
	PyModule_AddObject(m, "TrustDomainInfoFullInfo", (PyObject *)(void *)&lsa_TrustDomainInfoFullInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoAuthInfoInternal_Type);
	PyModule_AddObject(m, "TrustDomainInfoAuthInfoInternal", (PyObject *)(void *)&lsa_TrustDomainInfoAuthInfoInternal_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoFullInfoInternal_Type);
	PyModule_AddObject(m, "TrustDomainInfoFullInfoInternal", (PyObject *)(void *)&lsa_TrustDomainInfoFullInfoInternal_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoInfoEx2Internal_Type);
	PyModule_AddObject(m, "TrustDomainInfoInfoEx2Internal", (PyObject *)(void *)&lsa_TrustDomainInfoInfoEx2Internal_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoFullInfo2Internal_Type);
	PyModule_AddObject(m, "TrustDomainInfoFullInfo2Internal", (PyObject *)(void *)&lsa_TrustDomainInfoFullInfo2Internal_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TrustDomainInfoSupportedEncTypes_Type);
	PyModule_AddObject(m, "TrustDomainInfoSupportedEncTypes", (PyObject *)(void *)&lsa_TrustDomainInfoSupportedEncTypes_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DATA_BUF_PTR_Type);
	PyModule_AddObject(m, "DATA_BUF_PTR", (PyObject *)(void *)&lsa_DATA_BUF_PTR_Type);
	Py_INCREF((PyObject *)(void *)&lsa_RightAttribute_Type);
	PyModule_AddObject(m, "RightAttribute", (PyObject *)(void *)&lsa_RightAttribute_Type);
	Py_INCREF((PyObject *)(void *)&lsa_RightSet_Type);
	PyModule_AddObject(m, "RightSet", (PyObject *)(void *)&lsa_RightSet_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DomainListEx_Type);
	PyModule_AddObject(m, "DomainListEx", (PyObject *)(void *)&lsa_DomainListEx_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DomainInfoKerberos_Type);
	PyModule_AddObject(m, "DomainInfoKerberos", (PyObject *)(void *)&lsa_DomainInfoKerberos_Type);
	Py_INCREF((PyObject *)(void *)&lsa_DomainInfoEfs_Type);
	PyModule_AddObject(m, "DomainInfoEfs", (PyObject *)(void *)&lsa_DomainInfoEfs_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TranslatedName2_Type);
	PyModule_AddObject(m, "TranslatedName2", (PyObject *)(void *)&lsa_TranslatedName2_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TransNameArray2_Type);
	PyModule_AddObject(m, "TransNameArray2", (PyObject *)(void *)&lsa_TransNameArray2_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TranslatedSid2_Type);
	PyModule_AddObject(m, "TranslatedSid2", (PyObject *)(void *)&lsa_TranslatedSid2_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TransSidArray2_Type);
	PyModule_AddObject(m, "TransSidArray2", (PyObject *)(void *)&lsa_TransSidArray2_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TranslatedSid3_Type);
	PyModule_AddObject(m, "TranslatedSid3", (PyObject *)(void *)&lsa_TranslatedSid3_Type);
	Py_INCREF((PyObject *)(void *)&lsa_TransSidArray3_Type);
	PyModule_AddObject(m, "TransSidArray3", (PyObject *)(void *)&lsa_TransSidArray3_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustBinaryData_Type);
	PyModule_AddObject(m, "ForestTrustBinaryData", (PyObject *)(void *)&lsa_ForestTrustBinaryData_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustDomainInfo_Type);
	PyModule_AddObject(m, "ForestTrustDomainInfo", (PyObject *)(void *)&lsa_ForestTrustDomainInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustRecord_Type);
	PyModule_AddObject(m, "ForestTrustRecord", (PyObject *)(void *)&lsa_ForestTrustRecord_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustInformation_Type);
	PyModule_AddObject(m, "ForestTrustInformation", (PyObject *)(void *)&lsa_ForestTrustInformation_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustCollisionRecord_Type);
	PyModule_AddObject(m, "ForestTrustCollisionRecord", (PyObject *)(void *)&lsa_ForestTrustCollisionRecord_Type);
	Py_INCREF((PyObject *)(void *)&lsa_ForestTrustCollisionInfo_Type);
	PyModule_AddObject(m, "ForestTrustCollisionInfo", (PyObject *)(void *)&lsa_ForestTrustCollisionInfo_Type);
	Py_INCREF((PyObject *)(void *)&lsarpc_InterfaceType);
	PyModule_AddObject(m, "lsarpc", (PyObject *)(void *)&lsarpc_InterfaceType);
#ifdef PY_MOD_LSA_PATCH
	PY_MOD_LSA_PATCH(m);
#endif

}
