/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_dnsserver
#define _PIDL_HEADER_dnsserver

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/dnsp.h"
#ifndef _HEADER_dnsserver
#define _HEADER_dnsserver

enum DNS_RPC_PROTOCOLS
#ifndef USE_UINT_ENUMS
 {
	DNS_RPC_USE_TCPIP=(int)(0x00000001),
	DNS_RPC_USE_NAMED_PIPE=(int)(0x00000002),
	DNS_RPC_USE_LPC=(int)(0x00000004),
	DNS_RPC_USE_ALL_PROTOCOLS=(int)(0xFFFFFFFF)
}
#else
 { __donnot_use_enum_DNS_RPC_PROTOCOLS=0x7FFFFFFF}
#define DNS_RPC_USE_TCPIP ( 0x00000001 )
#define DNS_RPC_USE_NAMED_PIPE ( 0x00000002 )
#define DNS_RPC_USE_LPC ( 0x00000004 )
#define DNS_RPC_USE_ALL_PROTOCOLS ( 0xFFFFFFFF )
#endif
;

enum DNS_RPC_CLIENT_VERSION
#ifndef USE_UINT_ENUMS
 {
	DNS_CLIENT_VERSION_W2K=(int)(0x00000000),
	DNS_CLIENT_VERSION_DOTNET=(int)(0x00060000),
	DNS_CLIENT_VERSION_LONGHORN=(int)(0x00070000)
}
#else
 { __donnot_use_enum_DNS_RPC_CLIENT_VERSION=0x7FFFFFFF}
#define DNS_CLIENT_VERSION_W2K ( 0x00000000 )
#define DNS_CLIENT_VERSION_DOTNET ( 0x00060000 )
#define DNS_CLIENT_VERSION_LONGHORN ( 0x00070000 )
#endif
;

struct DNS_RPC_BUFFER {
	uint32_t dwLength;
	uint8_t *Buffer;/* [size_is(dwLength)] */
};

struct DNS_RPC_UTF8_STRING_LIST {
	uint32_t dwCount;/* [range(0,10000)] */
	const char **pszStrings;/* [unique,size_is(dwCount),charset(UTF8)] */
};

struct DNS_RPC_NAME_AND_PARAM {
	uint32_t dwParam;
	const char *pszNodeName;/* [unique,charset(UTF8)] */
};

struct DNS_RPC_NAME {
	uint8_t len;/* [value(strlen(str))] */
	const char *str;/* [charset(UTF8)] */
}/* [gensize,public] */;

struct DNS_RPC_NODE {
	uint16_t wLength;
	uint16_t wRecordCount;
	uint32_t dwFlags;
	uint32_t dwChildCount;
	struct DNS_RPC_NAME dnsNodeName;
};

struct DNS_RPC_RECORD_SOA {
	uint32_t dwSerialNo;
	uint32_t dwRefresh;
	uint32_t dwRetry;
	uint32_t dwExpire;
	uint32_t dwMinimumTtl;
	struct DNS_RPC_NAME NamePrimaryServer;
	struct DNS_RPC_NAME ZoneAdministratorEmail;
};

struct DNS_RPC_RECORD_NAME_PREFERENCE {
	uint16_t wPreference;
	struct DNS_RPC_NAME nameExchange;
};

struct DNS_RPC_RECORD_STRING {
	uint8_t count;
	struct DNS_RPC_NAME *str;
}/* [gensize,nopush,nopull] */;

struct DNS_RPC_RECORD_SRV {
	uint16_t wPriority;
	uint16_t wWeight;
	uint16_t wPort;
	struct DNS_RPC_NAME nameTarget;
};

union DNS_RPC_DATA {
	NTTIME timestamp;/* [case(DNS_TYPE_TOMBSTONE)] */
	const char * ipv4;/* [case(DNS_TYPE_A),flag(LIBNDR_FLAG_BIGENDIAN)] */
	struct DNS_RPC_NAME name;/* [case(DNS_TYPE_NS)] */
	struct DNS_RPC_RECORD_SOA soa;/* [case(DNS_TYPE_SOA)] */
	struct DNS_RPC_NAME ptr;/* [case(DNS_TYPE_PTR)] */
	struct DNS_RPC_NAME hinfo;/* [case(DNS_TYPE_HINFO)] */
	struct DNS_RPC_RECORD_NAME_PREFERENCE mx;/* [case(DNS_TYPE_MX)] */
	struct DNS_RPC_RECORD_STRING txt;/* [case(DNS_TYPE_TXT)] */
	const char * ipv6;/* [case(DNS_TYPE_AAAA)] */
	struct DNS_RPC_RECORD_SRV srv;/* [case(DNS_TYPE_SRV)] */
}/* [gensize,flag(LIBNDR_FLAG_NOALIGN),nodiscriminant] */;

struct DNS_RPC_RECORD {
	uint16_t wDataLength;/* [value(ndr_size_DNS_RPC_DATA(&data,wType,0))] */
	enum dns_record_type wType;
	uint32_t dwFlags;
	uint32_t dwSerial;
	uint32_t dwTtlSeconds;
	uint32_t dwTimeStamp;
	uint32_t dwReserved;
	union DNS_RPC_DATA data;/* [subcontext(0),switch_is(wType),subcontext_size(wDataLength)] */
}/* [public] */;

struct DNS_RPC_RECORD_BUF {
	uint32_t wContextLength;/* [value(ndr_size_DNS_RPC_DATA(&rec.data,rec.wType,0))] */
	struct DNS_RPC_RECORD rec;
};

enum DNS_IPVAL_CONTEXT
#ifndef USE_UINT_ENUMS
 {
	DNS_IPVAL_DNS_SERVERS=(int)(0x00),
	DNS_IPVAL_DNS_ROOTHINTS=(int)(0x01),
	DNS_IPVAL_DNS_FORWARDERS=(int)(0x02),
	DNS_IPVAL_DNS_ZONE_MASTERS=(int)(0x03),
	DNS_IPVAL_DNS_DELEGATIONS=(int)(0x04)
}
#else
 { __donnot_use_enum_DNS_IPVAL_CONTEXT=0x7FFFFFFF}
#define DNS_IPVAL_DNS_SERVERS ( 0x00 )
#define DNS_IPVAL_DNS_ROOTHINTS ( 0x01 )
#define DNS_IPVAL_DNS_FORWARDERS ( 0x02 )
#define DNS_IPVAL_DNS_ZONE_MASTERS ( 0x03 )
#define DNS_IPVAL_DNS_DELEGATIONS ( 0x04 )
#endif
;

enum DNS_IP_VALIDATE_RETURN_FLAGS
#ifndef USE_UINT_ENUMS
 {
	ERROR_SUCCESS=(int)(0x00),
	DNS_IPVAL_INVALID_ADDR=(int)(0x01),
	DNS_IPVAL_UNREACHABLE=(int)(0x02),
	DNS_IPVAL_NO_RESPONSE=(int)(0x03),
	DNS_IPVAL_NOT_AUTH_FOR_ZONE=(int)(0x04),
	DNS_IPVAL_UNKNOWN_ERROR=(int)(0xFF),
	DNS_IPVAL_NO_TCP=(int)(0x80000000)
}
#else
 { __donnot_use_enum_DNS_IP_VALIDATE_RETURN_FLAGS=0x7FFFFFFF}
#define ERROR_SUCCESS ( 0x00 )
#define DNS_IPVAL_INVALID_ADDR ( 0x01 )
#define DNS_IPVAL_UNREACHABLE ( 0x02 )
#define DNS_IPVAL_NO_RESPONSE ( 0x03 )
#define DNS_IPVAL_NOT_AUTH_FOR_ZONE ( 0x04 )
#define DNS_IPVAL_UNKNOWN_ERROR ( 0xFF )
#define DNS_IPVAL_NO_TCP ( 0x80000000 )
#endif
;

struct IP4_ARRAY {
	uint32_t AddrCount;
	uint32_t *AddrArray;/* [size_is(AddrCount)] */
};

struct DNS_ADDR {
	uint8_t MaxSa[32];
	uint32_t DnsAddrUserDword[8];
};

struct DNS_ADDR_ARRAY {
	uint32_t MaxCount;
	uint32_t AddrCount;
	uint32_t Tag;
	uint16_t Family;
	uint16_t WordReserved;
	uint32_t Flags;
	uint32_t MatchFlag;
	uint32_t Reserved1;
	uint32_t Reserved2;
	struct DNS_ADDR *AddrArray;/* [size_is(AddrCount)] */
};

struct DNS_RPC_IP_VALIDATE {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwContext;
	uint32_t dwReserved1;
	const char *pszContextName;/* [unique,charset(UTF8)] */
	struct DNS_ADDR_ARRAY *aipValidateAddrs;/* [unique] */
};

enum DNS_BOOT_METHOD
#ifndef USE_UINT_ENUMS
 {
	DNS_BOOT_METHOD_UNINITIALIZED=(int)(0x00),
	DNS_BOOT_METHOD_FILE=(int)(0x01),
	DNS_BOOT_METHOD_REGISTRY=(int)(0x02),
	DNS_BOOT_METHOD_DIRECTORY=(int)(0x03)
}
#else
 { __donnot_use_enum_DNS_BOOT_METHOD=0x7FFFFFFF}
#define DNS_BOOT_METHOD_UNINITIALIZED ( 0x00 )
#define DNS_BOOT_METHOD_FILE ( 0x01 )
#define DNS_BOOT_METHOD_REGISTRY ( 0x02 )
#define DNS_BOOT_METHOD_DIRECTORY ( 0x03 )
#endif
;

enum DNS_NAME_CHECK_FLAG
#ifndef USE_UINT_ENUMS
 {
	DNS_ALLOW_RFC_NAMES_ONLY=(int)(0x00),
	DNS_ALLOW_NONRFC_NAMES=(int)(0x01),
	DNS_ALLOW_MULTIBYTE_NAMES=(int)(0x02),
	DNS_ALLOW_ALL_NAMES=(int)(0x03)
}
#else
 { __donnot_use_enum_DNS_NAME_CHECK_FLAG=0x7FFFFFFF}
#define DNS_ALLOW_RFC_NAMES_ONLY ( 0x00 )
#define DNS_ALLOW_NONRFC_NAMES ( 0x01 )
#define DNS_ALLOW_MULTIBYTE_NAMES ( 0x02 )
#define DNS_ALLOW_ALL_NAMES ( 0x03 )
#endif
;

struct DNS_RPC_SERVER_INFO_W2K {
	uint32_t dwVersion;
	enum DNS_BOOT_METHOD fBootMethod;
	uint8_t fAdminConfigured;
	uint8_t fAllowUpdate;
	uint8_t fDsAvailable;
	const char *pszServerName;/* [charset(UTF8),unique] */
	const char *pszDsContainer;/* [unique,charset(UTF16)] */
	struct IP4_ARRAY *aipServerAddrs;/* [unique] */
	struct IP4_ARRAY *aipListenAddrs;/* [unique] */
	struct IP4_ARRAY *aipForwarders;/* [unique] */
	uint32_t *pExtension1;/* [unique] */
	uint32_t *pExtension2;/* [unique] */
	uint32_t *pExtension3;/* [unique] */
	uint32_t *pExtension4;/* [unique] */
	uint32_t *pExtension5;/* [unique] */
	uint32_t dwLogLevel;
	uint32_t dwDebugLevel;
	uint32_t dwForwardTimeout;
	uint32_t dwRpcProtocol;
	enum DNS_NAME_CHECK_FLAG dwNameCheckFlag;
	uint32_t cAddressAnswerLimit;
	uint32_t dwRecursionRetry;
	uint32_t dwRecursionTimeout;
	uint32_t dwMaxCacheTtl;
	uint32_t dwDsPollingInterval;
	uint32_t dwScavengingInterval;
	uint32_t dwDefaultRefreshInterval;
	uint32_t dwDefaultNoRefreshInterval;
	uint32_t dwReserveArray[10];
	uint8_t fAutoReverseZones;
	uint8_t fAutoCacheUpdate;
	uint8_t fRecurseAfterForwarding;
	uint8_t fForwardDelegations;
	uint8_t fNoRecursion;
	uint8_t fSecureResponses;
	uint8_t fRoundRobin;
	uint8_t fLocalNetPriority;
	uint8_t fBindSecondaries;
	uint8_t fWriteAuthorityNs;
	uint8_t fStrictFileParsing;
	uint8_t fLooseWildcarding;
	uint8_t fDefaultAgingState;
	uint8_t fReserveArray[15];
};

struct DNS_EXTENSION {
	const char *extension;/* [charset(UTF8),unique] */
};

struct DNS_RPC_SERVER_INFO_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwVersion;
	enum DNS_BOOT_METHOD fBootMethod;
	uint8_t fAdminConfigured;
	uint8_t fAllowUpdate;
	uint8_t fDsAvailable;
	const char *pszServerName;/* [charset(UTF8),unique] */
	const char *pszDsContainer;/* [unique,charset(UTF16)] */
	struct IP4_ARRAY *aipServerAddrs;/* [unique] */
	struct IP4_ARRAY *aipListenAddrs;/* [unique] */
	struct IP4_ARRAY *aipForwarders;/* [unique] */
	struct IP4_ARRAY *aipLogFilter;/* [unique] */
	const char *pwszLogFilePath;/* [unique,charset(UTF16)] */
	const char *pszDomainName;/* [charset(UTF8),unique] */
	const char *pszForestName;/* [charset(UTF8),unique] */
	const char *pszDomainDirectoryPartition;/* [unique,charset(UTF8)] */
	const char *pszForestDirectoryPartition;/* [charset(UTF8),unique] */
	struct DNS_EXTENSION pExtensions[6];
	uint32_t dwLogLevel;
	uint32_t dwDebugLevel;
	uint32_t dwForwardTimeout;
	uint32_t dwRpcProtocol;
	enum DNS_NAME_CHECK_FLAG dwNameCheckFlag;
	uint32_t cAddressAnswerLimit;
	uint32_t dwRecursionRetry;
	uint32_t dwRecursionTimeout;
	uint32_t dwMaxCacheTtl;
	uint32_t dwDsPollingInterval;
	uint32_t dwLocalNetPriorityNetMask;
	uint32_t dwScavengingInterval;
	uint32_t dwDefaultRefreshInterval;
	uint32_t dwDefaultNoRefreshInterval;
	uint32_t dwLastScavengeTime;
	uint32_t dwEventLogLevel;
	uint32_t dwLogFileMaxSize;
	uint32_t dwDsForestVersion;
	uint32_t dwDsDomainVersion;
	uint32_t dwDsDsaVersion;
	uint32_t dwReserveArray[4];
	uint8_t fAutoReverseZones;
	uint8_t fAutoCacheUpdate;
	uint8_t fRecurseAfterForwarding;
	uint8_t fForwardDelegations;
	uint8_t fNoRecursion;
	uint8_t fSecureResponses;
	uint8_t fRoundRobin;
	uint8_t fLocalNetPriority;
	uint8_t fBindSecondaries;
	uint8_t fWriteAuthorityNs;
	uint8_t fStrictFileParsing;
	uint8_t fLooseWildcarding;
	uint8_t fDefaultAgingState;
	uint8_t fReserveArray[15];
}/* [public] */;

struct DNS_RPC_SERVER_INFO_LONGHORN {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwVersion;
	enum DNS_BOOT_METHOD fBootMethod;
	uint8_t fAdminConfigured;
	uint8_t fAllowUpdate;
	uint8_t fDsAvailable;
	const char *pszServerName;/* [charset(UTF8),unique] */
	const char *pszDsContainer;/* [charset(UTF16),unique] */
	struct DNS_ADDR_ARRAY *aipServerAddrs;/* [unique] */
	struct DNS_ADDR_ARRAY *aipListenAddrs;/* [unique] */
	struct DNS_ADDR_ARRAY *aipForwarders;/* [unique] */
	struct DNS_ADDR_ARRAY *aipLogFilter;/* [unique] */
	const char *pwszLogFilePath;/* [unique,charset(UTF16)] */
	const char *pszDomainName;/* [unique,charset(UTF8)] */
	const char *pszForestName;/* [unique,charset(UTF8)] */
	const char *pszDomainDirectoryPartition;/* [unique,charset(UTF8)] */
	const char *pszForestDirectoryPartition;/* [unique,charset(UTF8)] */
	struct DNS_EXTENSION pExtensions[6];
	uint32_t dwLogLevel;
	uint32_t dwDebugLevel;
	uint32_t dwForwardTimeout;
	uint32_t dwRpcProtocol;
	enum DNS_NAME_CHECK_FLAG dwNameCheckFlag;
	uint32_t cAddressAnswerLimit;
	uint32_t dwRecursionRetry;
	uint32_t dwRecursionTimeout;
	uint32_t dwMaxCacheTtl;
	uint32_t dwDsPollingInterval;
	uint32_t dwLocalNetPriorityNetMask;
	uint32_t dwScavengingInterval;
	uint32_t dwDefaultRefreshInterval;
	uint32_t dwDefaultNoRefreshInterval;
	uint32_t dwLastScavengeTime;
	uint32_t dwEventLogLevel;
	uint32_t dwLogFileMaxSize;
	uint32_t dwDsForestVersion;
	uint32_t dwDsDomainVersion;
	uint32_t dwDsDsaVersion;
	uint8_t fReadOnlyDC;
	uint32_t dwReserveArray[3];
	uint8_t fAutoReverseZones;
	uint8_t fAutoCacheUpdate;
	uint8_t fRecurseAfterForwarding;
	uint8_t fForwardDelegations;
	uint8_t fNoRecursion;
	uint8_t fSecureResponses;
	uint8_t fRoundRobin;
	uint8_t fLocalNetPriority;
	uint8_t fBindSecondaries;
	uint8_t fWriteAuthorityNs;
	uint8_t fStrictFileParsing;
	uint8_t fLooseWildcarding;
	uint8_t fDefaultAgingState;
	uint8_t fReserveArray[15];
}/* [public] */;

/* bitmap DNS_RPC_DP_FLAGS */
#define DNS_DP_AUTOCREATED ( 0x00000001 )
#define DNS_DP_LEGACY ( 0x00000002 )
#define DNS_DP_DOMAIN_DEFAULT ( 0x00000004 )
#define DNS_DP_FOREST_DEFAULT ( 0x00000008 )
#define DNS_DP_ENLISTED ( 0x00000010 )
#define DNS_DP_DELETED ( 0x00000020 )

struct DNS_RPC_DP_REPLICA {
	const char *pszReplicaDn;/* [unique,charset(UTF16)] */
};

enum DNS_DP_STATE
#ifndef USE_UINT_ENUMS
 {
	DNS_DP_OKAY=(int)(0x00),
	DNS_DP_STATE_REPL_INCOMING=(int)(0x01),
	DNS_DP_STATE_REPL_OUTGOING=(int)(0x02),
	DNS_DP_STATE_UNKNOWN=(int)(0x03)
}
#else
 { __donnot_use_enum_DNS_DP_STATE=0x7FFFFFFF}
#define DNS_DP_OKAY ( 0x00 )
#define DNS_DP_STATE_REPL_INCOMING ( 0x01 )
#define DNS_DP_STATE_REPL_OUTGOING ( 0x02 )
#define DNS_DP_STATE_UNKNOWN ( 0x03 )
#endif
;

struct DNS_RPC_DP_INFO {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	const char *pszDpDn;/* [unique,charset(UTF16)] */
	const char *pszCrDn;/* [unique,charset(UTF16)] */
	uint32_t dwFlags;
	uint32_t dwZoneCount;
	enum DNS_DP_STATE dwState;
	uint32_t dwReserved[3];
	struct DNS_EXTENSION pwszReserved[3];
	uint32_t dwReplicaCount;/* [range(0,10000)] */
	struct DNS_RPC_DP_REPLICA **ReplicaArray;/* [size_is(dwReplicaCount),unique] */
};

struct DNS_RPC_DP_ENUM {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	uint32_t dwFlags;
	uint32_t dwZoneCount;
};

struct DNS_RPC_DP_LIST {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwDpCount;/* [range(0,5000)] */
	struct DNS_RPC_DP_ENUM **DpArray;/* [size_is(dwDpCount),unique] */
};

struct DNS_RPC_ENLIST_DP {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	uint32_t dwOperation;
};

struct DNS_RPC_ZONE_CHANGE_DP {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszDestPartition;/* [unique,charset(UTF8)] */
};

enum DNS_ZONE_SECONDARY_SECURITY
#ifndef USE_UINT_ENUMS
 {
	DNS_ZONE_SECSECURE_NO_SECURITY=(int)(0x00),
	DNS_ZONE_SECSECURE_NS_ONLY=(int)(0x01),
	DNS_ZONE_SECSECURE_LIST_ONLY=(int)(0x02),
	DNS_ZONE_SECSECURE_NO_XFER=(int)(0x03)
}
#else
 { __donnot_use_enum_DNS_ZONE_SECONDARY_SECURITY=0x7FFFFFFF}
#define DNS_ZONE_SECSECURE_NO_SECURITY ( 0x00 )
#define DNS_ZONE_SECSECURE_NS_ONLY ( 0x01 )
#define DNS_ZONE_SECSECURE_LIST_ONLY ( 0x02 )
#define DNS_ZONE_SECSECURE_NO_XFER ( 0x03 )
#endif
;

enum DNS_ZONE_NOTIFY_LEVEL
#ifndef USE_UINT_ENUMS
 {
	DNS_ZONE_NOTIFY_OFF=(int)(0x00),
	DNS_ZONE_NOTIFY_ALL_SECONDARIES=(int)(0x01),
	DNS_ZONE_NOTIFY_LIST_ONLY=(int)(0x02)
}
#else
 { __donnot_use_enum_DNS_ZONE_NOTIFY_LEVEL=0x7FFFFFFF}
#define DNS_ZONE_NOTIFY_OFF ( 0x00 )
#define DNS_ZONE_NOTIFY_ALL_SECONDARIES ( 0x01 )
#define DNS_ZONE_NOTIFY_LIST_ONLY ( 0x02 )
#endif
;

enum DNS_ZONE_REQUEST_FILTERS
#ifndef USE_UINT_ENUMS
 {
	DNS_ZONE_REQUEST_PRIMARY=(int)(0x00000001),
	DNS_ZONE_REQUEST_SECONDARY=(int)(0x00000002),
	DNS_ZONE_REQUEST_CACHE=(int)(0x00000004),
	DNS_ZONE_REQUEST_AUTO=(int)(0x00000008),
	DNS_ZONE_REQUEST_FORWARD=(int)(0x00000010),
	DNS_ZONE_REQUEST_REVERSE=(int)(0x00000020),
	DNS_ZONE_REQUEST_FORWARDER=(int)(0x00000040),
	DNS_ZONE_REQUEST_STUB=(int)(0x00000080),
	DNS_ZONE_REQUEST_DS=(int)(0x00000100),
	DNS_ZONE_REQUEST_NON_DS=(int)(0x00000200),
	DNS_ZONE_REQUEST_DOMAIN_DP=(int)(0x00000400),
	DNS_ZONE_REQUEST_FOREST_DP=(int)(0x00000800),
	DNS_ZONE_REQUEST_CUSTOM_DP=(int)(0x00001000),
	DNS_ZONE_REQUEST_LEGACY_DP=(int)(0x00002000)
}
#else
 { __donnot_use_enum_DNS_ZONE_REQUEST_FILTERS=0x7FFFFFFF}
#define DNS_ZONE_REQUEST_PRIMARY ( 0x00000001 )
#define DNS_ZONE_REQUEST_SECONDARY ( 0x00000002 )
#define DNS_ZONE_REQUEST_CACHE ( 0x00000004 )
#define DNS_ZONE_REQUEST_AUTO ( 0x00000008 )
#define DNS_ZONE_REQUEST_FORWARD ( 0x00000010 )
#define DNS_ZONE_REQUEST_REVERSE ( 0x00000020 )
#define DNS_ZONE_REQUEST_FORWARDER ( 0x00000040 )
#define DNS_ZONE_REQUEST_STUB ( 0x00000080 )
#define DNS_ZONE_REQUEST_DS ( 0x00000100 )
#define DNS_ZONE_REQUEST_NON_DS ( 0x00000200 )
#define DNS_ZONE_REQUEST_DOMAIN_DP ( 0x00000400 )
#define DNS_ZONE_REQUEST_FOREST_DP ( 0x00000800 )
#define DNS_ZONE_REQUEST_CUSTOM_DP ( 0x00001000 )
#define DNS_ZONE_REQUEST_LEGACY_DP ( 0x00002000 )
#endif
;

/* bitmap DNS_RPC_ZONE_FLAGS */
#define DNS_RPC_ZONE_PAUSED ( 0x0001 )
#define DNS_RPC_ZONE_SHUTDOWN ( 0x0002 )
#define DNS_RPC_ZONE_REVERSE ( 0x0004 )
#define DNS_RPC_ZONE_AUTOCREATED ( 0x0008 )
#define DNS_RPC_ZONE_DSINTEGRATED ( 0x0010 )
#define DNS_RPC_ZONE_AGING ( 0x0020 )
#define DNS_RPC_ZONE_UPDATE_UNSECURE ( 0x0040 )
#define DNS_RPC_ZONE_UPDATE_SECURE ( 0x0080 )
#define DNS_RPC_ZONE_READONLY ( 0x0100 )

struct DNS_RPC_ZONE_W2K {
	const char *pszZoneName;/* [charset(UTF16),unique] */
	uint32_t Flags;
	uint8_t ZoneType;
	uint8_t Version;
};

struct DNS_RPC_ZONE_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneName;/* [unique,charset(UTF16)] */
	uint32_t Flags;
	uint8_t ZoneType;
	uint8_t Version;
	uint32_t dwDpFlags;
	const char *pszDpFqdn;/* [charset(UTF8),unique] */
};

struct DNS_RPC_ZONE_LIST_W2K {
	uint32_t dwZoneCount;/* [range(0,500000)] */
	struct DNS_RPC_ZONE_W2K **ZoneArray;/* [unique,size_is(dwZoneCount)] */
};

struct DNS_RPC_ZONE_LIST_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwZoneCount;/* [range(0,500000)] */
	struct DNS_RPC_ZONE_DOTNET **ZoneArray;/* [unique,size_is(dwZoneCount)] */
};

struct DNS_RPC_ZONE_INFO_W2K {
	const char *pszZoneName;/* [unique,charset(UTF8)] */
	uint32_t dwZoneType;
	uint32_t fReverse;
	enum dns_zone_update fAllowUpdate;
	uint32_t fPaused;
	uint32_t fShutdown;
	uint32_t fAutoCreated;
	uint32_t fUseDatabase;
	const char *pszDataFile;/* [unique,charset(UTF8)] */
	struct IP4_ARRAY *aipMasters;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	struct IP4_ARRAY *aipNotify;/* [unique] */
	uint32_t fUseWins;
	uint32_t fUseNbstat;
	uint32_t fAging;
	uint32_t dwNoRefreshInterval;
	uint32_t dwRefreshInterval;
	uint32_t dwAvailForScavengeTime;
	struct IP4_ARRAY *aipScavengeServers;/* [unique] */
	uint32_t pvReserved1;
	uint32_t pvReserved2;
	uint32_t pvReserved3;
	uint32_t pvReserved4;
};

struct DNS_RPC_ZONE_INFO_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneName;/* [unique,charset(UTF8)] */
	uint32_t dwZoneType;
	uint32_t fReverse;
	enum dns_zone_update fAllowUpdate;
	uint32_t fPaused;
	uint32_t fShutdown;
	uint32_t fAutoCreated;
	uint32_t fUseDatabase;
	const char *pszDataFile;/* [unique,charset(UTF8)] */
	struct IP4_ARRAY *aipMasters;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	struct IP4_ARRAY *aipNotify;/* [unique] */
	uint32_t fUseWins;
	uint32_t fUseNbstat;
	uint32_t fAging;
	uint32_t dwNoRefreshInterval;
	uint32_t dwRefreshInterval;
	uint32_t dwAvailForScavengeTime;
	struct IP4_ARRAY *aipScavengeServers;/* [unique] */
	uint32_t dwForwarderTimeout;
	uint32_t fForwarderSlave;
	struct IP4_ARRAY *aipLocalMasters;/* [unique] */
	uint32_t dwDpFlags;
	const char *pszDpFqdn;/* [charset(UTF8),unique] */
	const char *pwszZoneDn;/* [unique,charset(UTF16)] */
	uint32_t dwLastSuccessfulSoaCheck;
	uint32_t dwLastSuccessfulXfr;
	uint32_t dwReserved1;
	uint32_t dwReserved2;
	uint32_t dwReserved3;
	uint32_t dwReserved4;
	uint32_t dwReserved5;
	const char *pReserved1;/* [unique,charset(UTF8)] */
	const char *pReserved2;/* [charset(UTF8),unique] */
	const char *pReserved3;/* [charset(UTF8),unique] */
	const char *pReserved4;/* [unique,charset(UTF8)] */
};

struct DNS_RPC_ZONE_INFO_LONGHORN {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneName;/* [charset(UTF8),unique] */
	uint32_t dwZoneType;
	uint32_t fReverse;
	enum dns_zone_update fAllowUpdate;
	uint32_t fPaused;
	uint32_t fShutdown;
	uint32_t fAutoCreated;
	uint32_t fUseDatabase;
	const char *pszDataFile;/* [unique,charset(UTF8)] */
	struct DNS_ADDR_ARRAY *aipMasters;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct DNS_ADDR_ARRAY *aipSecondaries;/* [unique] */
	struct DNS_ADDR_ARRAY *aipNotify;/* [unique] */
	uint32_t fUseWins;
	uint32_t fUseNbstat;
	uint32_t fAging;
	uint32_t dwNoRefreshInterval;
	uint32_t dwRefreshInterval;
	uint32_t dwAvailForScavengeTime;
	struct DNS_ADDR_ARRAY *aipScavengeServers;/* [unique] */
	uint32_t dwForwarderTimeout;
	uint32_t fForwarderSlave;
	struct DNS_ADDR_ARRAY *aipLocalMasters;/* [unique] */
	uint32_t dwDpFlags;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	const char *pwszZoneDn;/* [unique,charset(UTF16)] */
	uint32_t dwLastSuccessfulSoaCheck;
	uint32_t dwLastSuccessfulXfr;
	uint32_t fQueuedForBackgroundLoad;
	uint32_t fBackgroundLoadInProgress;
	uint32_t fReadOnlyZone;
	uint32_t dwLastXfrAttempt;
	uint32_t dwLastXfrResult;
};

struct DNS_RPC_ZONE_SECONDARIES_W2K {
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	struct IP4_ARRAY *aipNotify;/* [unique] */
};

struct DNS_RPC_ZONE_SECONDARIES_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	struct IP4_ARRAY *aipNotify;/* [unique] */
};

struct DNS_RPC_ZONE_SECONDARIES_LONGHORN {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	struct DNS_ADDR_ARRAY *aipSecondaries;/* [unique] */
	struct DNS_ADDR_ARRAY *aipNotify;/* [unique] */
};

struct DNS_RPC_ZONE_DATABASE_W2K {
	uint32_t fDsIntegrated;
	const char *pszFileName;/* [charset(UTF8),unique] */
};

struct DNS_RPC_ZONE_DATABASE_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t fDsIntegrated;
	const char *pszFileName;/* [unique,charset(UTF8)] */
};

struct DNS_RPC_ZONE_CREATE_INFO_W2K {
	const char *pszZoneName;/* [charset(UTF8),unique] */
	uint32_t dwZoneType;
	enum dns_zone_update fAllowUpdate;
	uint32_t fAging;
	uint32_t dwFlags;
	const char *pszDataFile;/* [charset(UTF8),unique] */
	uint32_t fDsIntegrated;
	uint32_t fLoadExisting;
	const char *pszAdmin;/* [charset(UTF8),unique] */
	struct IP4_ARRAY *aipMasters;/* [unique] */
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	const char *pvReserved1;/* [unique,charset(UTF8)] */
	const char *pvReserved2;/* [unique,charset(UTF8)] */
	const char *pvReserved3;/* [unique,charset(UTF8)] */
	const char *pvReserved4;/* [charset(UTF8),unique] */
	const char *pvReserved5;/* [charset(UTF8),unique] */
	const char *pvReserved6;/* [unique,charset(UTF8)] */
	const char *pvReserved7;/* [unique,charset(UTF8)] */
	const char *pvReserved8;/* [charset(UTF8),unique] */
	uint32_t dwReserved1;
	uint32_t dwReserved2;
	uint32_t dwReserved3;
	uint32_t dwReserved4;
	uint32_t dwReserved5;
	uint32_t dwReserved6;
	uint32_t dwReserved7;
	uint32_t dwReserved8;
};

struct DNS_RPC_ZONE_CREATE_INFO_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneName;/* [charset(UTF8),unique] */
	uint32_t dwZoneType;
	enum dns_zone_update fAllowUpdate;
	uint32_t fAging;
	uint32_t dwFlags;
	const char *pszDataFile;/* [unique,charset(UTF8)] */
	uint32_t fDsIntegrated;
	uint32_t fLoadExisting;
	const char *pszAdmin;/* [charset(UTF8),unique] */
	struct IP4_ARRAY *aipMasters;/* [unique] */
	struct IP4_ARRAY *aipSecondaries;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	uint32_t dwTimeout;
	uint32_t fRecurseAfterForwarding;
	uint32_t dwDpFlags;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	uint32_t dwReserved[32];
};

struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneName;/* [unique,charset(UTF8)] */
	uint32_t dwZoneType;
	enum dns_zone_update fAllowUpdate;
	uint32_t fAging;
	uint32_t dwFlags;
	const char *pszDataFile;/* [unique,charset(UTF8)] */
	uint32_t fDsIntegrated;
	uint32_t fLoadExisting;
	const char *pszAdmin;/* [charset(UTF8),unique] */
	struct DNS_ADDR_ARRAY *aipMasters;/* [unique] */
	struct DNS_ADDR_ARRAY *aipSecondaries;/* [unique] */
	enum DNS_ZONE_SECONDARY_SECURITY fSecureSecondaries;
	enum DNS_ZONE_NOTIFY_LEVEL fNotifyLevel;
	uint32_t dwTimeout;
	uint32_t fRecurseAfterForwarding;
	uint32_t dwDpFlags;
	const char *pszDpFqdn;/* [unique,charset(UTF8)] */
	uint32_t dwReserved[32];
};

struct DNS_RPC_ZONE_EXPORT_INFO {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	const char *pszZoneExportFile;/* [unique,charset(UTF8)] */
};

struct DNS_RPC_ENUM_ZONES_FILTER {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t dwFilter;
	const char *pszPartitionFqdn;/* [charset(UTF8),unique] */
	const char *pszQueryString;/* [unique,charset(UTF8)] */
	struct DNS_EXTENSION pszReserved[6];
};

struct DNS_RPC_FORWARDERS_W2K {
	uint32_t fRecurseAfterForwarding;
	uint32_t dwForwardTimeout;
	struct IP4_ARRAY *aipForwarders;/* [unique] */
};

struct DNS_RPC_FORWARDERS_DOTNET {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t fRecurseAfterForwarding;
	uint32_t dwForwardTimeout;
	struct IP4_ARRAY *aipForwarders;/* [unique] */
};

struct DNS_RPC_FORWARDERS_LONGHORN {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	uint32_t fRecurseAfterForwarding;
	uint32_t dwForwardTimeout;
	struct DNS_ADDR_ARRAY *aipForwarders;/* [unique] */
};

enum DNS_RPC_AUTOCONFIG
#ifndef USE_UINT_ENUMS
 {
	DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS=(int)(0x00000001),
	DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS=(int)(0x00000002),
	DNS_RPC_AUTOCONFIG_INTERNAL_ZONES=(int)(0x00000004),
	DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT=(int)(0x00000010),
	DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND=(int)(0x00000020),
	DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND=(int)(0x00000040),
	DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR=(int)(0x00008000),
	DNS_RPC_AUTOCONFIG_ALL=(int)(0xFFFFFFFF)
}
#else
 { __donnot_use_enum_DNS_RPC_AUTOCONFIG=0x7FFFFFFF}
#define DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS ( 0x00000001 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS ( 0x00000002 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_ZONES ( 0x00000004 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT ( 0x00000010 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND ( 0x00000020 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND ( 0x00000040 )
#define DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR ( 0x00008000 )
#define DNS_RPC_AUTOCONFIG_ALL ( 0xFFFFFFFF )
#endif
;

struct DNS_RPC_AUTOCONFIGURE {
	uint32_t dwRpcStructureVersion;
	uint32_t dwReserved0;
	enum DNS_RPC_AUTOCONFIG dwAutoConfigFlags;
	uint32_t dwReserved1;
	const char *pszNewDomainName;/* [charset(UTF8),unique] */
};

/* bitmap DNS_EVENT_LOG_TYPES */
#define DNS_EVENT_LOG_SUCCESS ( 0x00000000 )
#define DNS_EVENT_LOG_ERROR_TYPE ( 0x00000001 )
#define DNS_EVENT_LOG_WARNING_TYPE ( 0x00000002 )
#define DNS_EVENT_LOG_INFORMATION_TYPE ( 0x00000004 )

/* bitmap DNS_SELECT_FLAGS */
#define DNS_RPC_VIEW_AUTHORITY_DATA ( 0x00000001 )
#define DNS_RPC_VIEW_CACHE_DATA ( 0x00000002 )
#define DNS_RPC_VIEW_GLUE_DATA ( 0x00000004 )
#define DNS_RPC_VIEW_ROOT_HINT_DATA ( 0x00000008 )
#define DNS_RPC_VIEW_ADDITIONAL_DATA ( 0x00000010 )
#define DNS_RPC_VIEW_NO_CHILDREN ( 0x00010000 )
#define DNS_RPC_VIEW_ONLY_CHILDREN ( 0x00020000 )

struct DNSSRV_STAT_HEADER {
	uint32_t StatId;
	uint16_t wLength;
	uint8_t fClear;
	uint8_t fReserved;
};

struct DNSSRV_STAT {
	struct DNSSRV_STAT_HEADER Header;
	uint8_t Buffer[1];
};

enum DNS_RPC_TYPEID
#ifndef USE_UINT_ENUMS
 {
	DNSSRV_TYPEID_NULL=(int)(0),
	DNSSRV_TYPEID_DWORD=(int)(1),
	DNSSRV_TYPEID_LPSTR=(int)(2),
	DNSSRV_TYPEID_LPWSTR=(int)(3),
	DNSSRV_TYPEID_IPARRAY=(int)(4),
	DNSSRV_TYPEID_BUFFER=(int)(5),
	DNSSRV_TYPEID_SERVER_INFO_W2K=(int)(6),
	DNSSRV_TYPEID_STATS=(int)(7),
	DNSSRV_TYPEID_FORWARDERS_W2K=(int)(8),
	DNSSRV_TYPEID_ZONE_W2K=(int)(9),
	DNSSRV_TYPEID_ZONE_INFO_W2K=(int)(10),
	DNSSRV_TYPEID_ZONE_SECONDARIES_W2K=(int)(11),
	DNSSRV_TYPEID_ZONE_DATABASE_W2K=(int)(12),
	DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K=(int)(13),
	DNSSRV_TYPEID_ZONE_CREATE_W2K=(int)(14),
	DNSSRV_TYPEID_NAME_AND_PARAM=(int)(15),
	DNSSRV_TYPEID_ZONE_LIST_W2K=(int)(16),
	DNSSRV_TYPEID_ZONE_RENAME=(int)(17),
	DNSSRV_TYPEID_ZONE_EXPORT=(int)(18),
	DNSSRV_TYPEID_SERVER_INFO_DOTNET=(int)(19),
	DNSSRV_TYPEID_FORWARDERS_DOTNET=(int)(20),
	DNSSRV_TYPEID_ZONE=(int)(21),
	DNSSRV_TYPEID_ZONE_INFO_DOTNET=(int)(22),
	DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET=(int)(23),
	DNSSRV_TYPEID_ZONE_DATABASE=(int)(24),
	DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET=(int)(25),
	DNSSRV_TYPEID_ZONE_CREATE_DOTNET=(int)(26),
	DNSSRV_TYPEID_ZONE_LIST=(int)(27),
	DNSSRV_TYPEID_DP_ENUM=(int)(28),
	DNSSRV_TYPEID_DP_INFO=(int)(29),
	DNSSRV_TYPEID_DP_LIST=(int)(30),
	DNSSRV_TYPEID_ENLIST_DP=(int)(31),
	DNSSRV_TYPEID_ZONE_CHANGE_DP=(int)(32),
	DNSSRV_TYPEID_ENUM_ZONES_FILTER=(int)(33),
	DNSSRV_TYPEID_ADDRARRAY=(int)(34),
	DNSSRV_TYPEID_SERVER_INFO=(int)(35),
	DNSSRV_TYPEID_ZONE_INFO=(int)(36),
	DNSSRV_TYPEID_FORWARDERS=(int)(37),
	DNSSRV_TYPEID_ZONE_SECONDARIES=(int)(38),
	DNSSRV_TYPEID_ZONE_TYPE_RESET=(int)(39),
	DNSSRV_TYPEID_ZONE_CREATE=(int)(40),
	DNSSRV_TYPEID_IP_VALIDATE=(int)(41),
	DNSSRV_TYPEID_AUTOCONFIGURE=(int)(42),
	DNSSRV_TYPEID_UTF8_STRING_LIST=(int)(43),
	DNSSRV_TYPEID_UNICODE_STRING_LIST=(int)(44)
}
#else
 { __donnot_use_enum_DNS_RPC_TYPEID=0x7FFFFFFF}
#define DNSSRV_TYPEID_NULL ( 0 )
#define DNSSRV_TYPEID_DWORD ( 1 )
#define DNSSRV_TYPEID_LPSTR ( 2 )
#define DNSSRV_TYPEID_LPWSTR ( 3 )
#define DNSSRV_TYPEID_IPARRAY ( 4 )
#define DNSSRV_TYPEID_BUFFER ( 5 )
#define DNSSRV_TYPEID_SERVER_INFO_W2K ( 6 )
#define DNSSRV_TYPEID_STATS ( 7 )
#define DNSSRV_TYPEID_FORWARDERS_W2K ( 8 )
#define DNSSRV_TYPEID_ZONE_W2K ( 9 )
#define DNSSRV_TYPEID_ZONE_INFO_W2K ( 10 )
#define DNSSRV_TYPEID_ZONE_SECONDARIES_W2K ( 11 )
#define DNSSRV_TYPEID_ZONE_DATABASE_W2K ( 12 )
#define DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K ( 13 )
#define DNSSRV_TYPEID_ZONE_CREATE_W2K ( 14 )
#define DNSSRV_TYPEID_NAME_AND_PARAM ( 15 )
#define DNSSRV_TYPEID_ZONE_LIST_W2K ( 16 )
#define DNSSRV_TYPEID_ZONE_RENAME ( 17 )
#define DNSSRV_TYPEID_ZONE_EXPORT ( 18 )
#define DNSSRV_TYPEID_SERVER_INFO_DOTNET ( 19 )
#define DNSSRV_TYPEID_FORWARDERS_DOTNET ( 20 )
#define DNSSRV_TYPEID_ZONE ( 21 )
#define DNSSRV_TYPEID_ZONE_INFO_DOTNET ( 22 )
#define DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET ( 23 )
#define DNSSRV_TYPEID_ZONE_DATABASE ( 24 )
#define DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET ( 25 )
#define DNSSRV_TYPEID_ZONE_CREATE_DOTNET ( 26 )
#define DNSSRV_TYPEID_ZONE_LIST ( 27 )
#define DNSSRV_TYPEID_DP_ENUM ( 28 )
#define DNSSRV_TYPEID_DP_INFO ( 29 )
#define DNSSRV_TYPEID_DP_LIST ( 30 )
#define DNSSRV_TYPEID_ENLIST_DP ( 31 )
#define DNSSRV_TYPEID_ZONE_CHANGE_DP ( 32 )
#define DNSSRV_TYPEID_ENUM_ZONES_FILTER ( 33 )
#define DNSSRV_TYPEID_ADDRARRAY ( 34 )
#define DNSSRV_TYPEID_SERVER_INFO ( 35 )
#define DNSSRV_TYPEID_ZONE_INFO ( 36 )
#define DNSSRV_TYPEID_FORWARDERS ( 37 )
#define DNSSRV_TYPEID_ZONE_SECONDARIES ( 38 )
#define DNSSRV_TYPEID_ZONE_TYPE_RESET ( 39 )
#define DNSSRV_TYPEID_ZONE_CREATE ( 40 )
#define DNSSRV_TYPEID_IP_VALIDATE ( 41 )
#define DNSSRV_TYPEID_AUTOCONFIGURE ( 42 )
#define DNSSRV_TYPEID_UTF8_STRING_LIST ( 43 )
#define DNSSRV_TYPEID_UNICODE_STRING_LIST ( 44 )
#endif
;

union DNSSRV_RPC_UNION {
	uint8_t *Null;/* [case(DNSSRV_TYPEID_NULL),unique] */
	uint32_t Dword;/* [case(DNSSRV_TYPEID_DWORD)] */
	const char *String;/* [case(DNSSRV_TYPEID_LPSTR),unique,charset(UTF8)] */
	const char *WideString;/* [charset(UTF16),unique,case(DNSSRV_TYPEID_LPWSTR)] */
	struct IP4_ARRAY *IpArray;/* [case(DNSSRV_TYPEID_IPARRAY),unique] */
	struct DNS_RPC_BUFFER *Buffer;/* [unique,case(DNSSRV_TYPEID_BUFFER)] */
	struct DNS_RPC_SERVER_INFO_W2K *ServerInfoW2K;/* [unique,case(DNSSRV_TYPEID_SERVER_INFO_W2K)] */
	struct DNSSRV_STAT *Stats;/* [case(DNSSRV_TYPEID_STATS),unique] */
	struct DNS_RPC_FORWARDERS_W2K *ForwardersW2K;/* [unique,case(DNSSRV_TYPEID_FORWARDERS_W2K)] */
	struct DNS_RPC_ZONE_W2K *ZoneW2K;/* [case(DNSSRV_TYPEID_ZONE_W2K),unique] */
	struct DNS_RPC_ZONE_INFO_W2K *ZoneInfoW2K;/* [case(DNSSRV_TYPEID_ZONE_INFO_W2K),unique] */
	struct DNS_RPC_ZONE_SECONDARIES_W2K *SecondariesW2K;/* [unique,case(DNSSRV_TYPEID_ZONE_SECONDARIES_W2K)] */
	struct DNS_RPC_ZONE_DATABASE_W2K *DatabaseW2K;/* [case(DNSSRV_TYPEID_ZONE_DATABASE_W2K),unique] */
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *ZoneCreateW2K;/* [unique,case(DNSSRV_TYPEID_ZONE_CREATE_W2K)] */
	struct DNS_RPC_NAME_AND_PARAM *NameAndParam;/* [case(DNSSRV_TYPEID_NAME_AND_PARAM),unique] */
	struct DNS_RPC_ZONE_LIST_W2K *ZoneListW2K;/* [unique,case(DNSSRV_TYPEID_ZONE_LIST_W2K)] */
	struct DNS_RPC_SERVER_INFO_DOTNET *ServerInfoDotNet;/* [case(DNSSRV_TYPEID_SERVER_INFO_DOTNET),unique] */
	struct DNS_RPC_FORWARDERS_DOTNET *ForwardersDotNet;/* [case(DNSSRV_TYPEID_FORWARDERS_DOTNET),unique] */
	struct DNS_RPC_ZONE_DOTNET *Zone;/* [unique,case(DNSSRV_TYPEID_ZONE)] */
	struct DNS_RPC_ZONE_INFO_DOTNET *ZoneInfoDotNet;/* [case(DNSSRV_TYPEID_ZONE_INFO_DOTNET),unique] */
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *SecondariesDotNet;/* [case(DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET),unique] */
	struct DNS_RPC_ZONE_DATABASE_DOTNET *Database;/* [case(DNSSRV_TYPEID_ZONE_DATABASE),unique] */
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *ZoneCreateDotNet;/* [unique,case(DNSSRV_TYPEID_ZONE_CREATE_DOTNET)] */
	struct DNS_RPC_ZONE_LIST_DOTNET *ZoneList;/* [case(DNSSRV_TYPEID_ZONE_LIST),unique] */
	struct DNS_RPC_ZONE_EXPORT_INFO *ZoneExport;/* [unique,case(DNSSRV_TYPEID_ZONE_EXPORT)] */
	struct DNS_RPC_DP_INFO *DirectoryPartition;/* [case(DNSSRV_TYPEID_DP_INFO),unique] */
	struct DNS_RPC_DP_ENUM *DirectoryPartitionEnum;/* [case(DNSSRV_TYPEID_DP_ENUM),unique] */
	struct DNS_RPC_DP_LIST *DirectoryPartitionList;/* [unique,case(DNSSRV_TYPEID_DP_LIST)] */
	struct DNS_RPC_ENLIST_DP *EnlistDirectoryPartition;/* [case(DNSSRV_TYPEID_ENLIST_DP),unique] */
	struct DNS_RPC_ZONE_CHANGE_DP *ZoneChangeDirectoryPartition;/* [case(DNSSRV_TYPEID_ZONE_CHANGE_DP),unique] */
	struct DNS_RPC_ENUM_ZONES_FILTER *EnumZonesFilter;/* [unique,case(DNSSRV_TYPEID_ENUM_ZONES_FILTER)] */
	struct DNS_ADDR_ARRAY *AddrArray;/* [case(DNSSRV_TYPEID_ADDRARRAY),unique] */
	struct DNS_RPC_SERVER_INFO_LONGHORN *ServerInfo;/* [case(DNSSRV_TYPEID_SERVER_INFO),unique] */
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *ZoneCreate;/* [case(DNSSRV_TYPEID_ZONE_CREATE),unique] */
	struct DNS_RPC_FORWARDERS_LONGHORN *Forwarders;/* [case(DNSSRV_TYPEID_FORWARDERS),unique] */
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *Secondaries;/* [unique,case(DNSSRV_TYPEID_ZONE_SECONDARIES)] */
	struct DNS_RPC_IP_VALIDATE *IpValidate;/* [case(DNSSRV_TYPEID_IP_VALIDATE),unique] */
	struct DNS_RPC_ZONE_INFO_LONGHORN *ZoneInfo;/* [unique,case(DNSSRV_TYPEID_ZONE_INFO)] */
	struct DNS_RPC_AUTOCONFIGURE *AutoConfigure;/* [case(DNSSRV_TYPEID_AUTOCONFIGURE),unique] */
	struct DNS_RPC_UTF8_STRING_LIST *Utf8StringList;/* [case(DNSSRV_TYPEID_UTF8_STRING_LIST),unique] */
}/* [switch_type(uint3264)] */;

struct DNS_RPC_RECORDS {
	uint16_t wLength;/* [value((12+ndr_size_DNS_RPC_NAME(&dnsNodeName,0)+3)&~3)] */
	uint16_t wRecordCount;
	uint32_t dwFlags;
	uint32_t dwChildCount;
	struct DNS_RPC_NAME dnsNodeName;
	struct DNS_RPC_RECORD *records;
}/* [gensize,public] */;

struct DNS_RPC_RECORDS_ARRAY {
	uint32_t count;
	struct DNS_RPC_RECORDS *rec;
}/* [nopush,public,nopull,gensize] */;


struct DnssrvOperation {
	struct {
		const char *pwszServerName;/* [charset(UTF16),unique] */
		const char *pszZone;/* [unique,charset(UTF8)] */
		uint32_t dwContext;
		const char *pszOperation;/* [charset(UTF8),unique] */
		enum DNS_RPC_TYPEID dwTypeId;
		union DNSSRV_RPC_UNION pData;/* [switch_is(dwTypeId)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct DnssrvQuery {
	struct {
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [charset(UTF8),unique] */
		const char *pszOperation;/* [charset(UTF8),unique] */
	} in;

	struct {
		enum DNS_RPC_TYPEID *pdwTypeId;/* [ref] */
		union DNSSRV_RPC_UNION *ppData;/* [switch_is(*pdwTypeId),ref] */
		WERROR result;
	} out;

};


struct DnssrvComplexOperation {
	struct {
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [unique,charset(UTF8)] */
		const char *pszOperation;/* [unique,charset(UTF8)] */
		enum DNS_RPC_TYPEID dwTypeIn;
		union DNSSRV_RPC_UNION pDataIn;/* [switch_is(dwTypeIn)] */
	} in;

	struct {
		enum DNS_RPC_TYPEID *pdwTypeOut;/* [ref] */
		union DNSSRV_RPC_UNION *ppDataOut;/* [switch_is(*pdwTypeOut),ref] */
		WERROR result;
	} out;

};


struct DnssrvEnumRecords {
	struct {
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [charset(UTF8),unique] */
		const char *pszNodeName;/* [unique,charset(UTF8)] */
		const char *pszStartChild;/* [unique,charset(UTF8)] */
		enum dns_record_type wRecordType;
		uint32_t fSelectFlag;
		const char *pszFilterStart;/* [unique,charset(UTF8)] */
		const char *pszFilterStop;/* [unique,charset(UTF8)] */
	} in;

	struct {
		uint32_t *pdwBufferLength;/* [ref] */
		struct DNS_RPC_RECORDS_ARRAY **pBuffer;/* [subcontext_size(*pdwBufferLength),ref,subcontext(4)] */
		WERROR result;
	} out;

};


struct DnssrvUpdateRecord {
	struct {
		const char *pwszServerName;/* [charset(UTF16),unique] */
		const char *pszZone;/* [unique,charset(UTF8)] */
		const char *pszNodeName;/* [unique,charset(UTF8)] */
		struct DNS_RPC_RECORD_BUF *pAddRecord;/* [unique] */
		struct DNS_RPC_RECORD_BUF *pDeleteRecord;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct DnssrvOperation2 {
	struct {
		enum DNS_RPC_CLIENT_VERSION dwClientVersion;
		uint32_t dwSettingFlags;
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [charset(UTF8),unique] */
		uint32_t dwContext;
		const char *pszOperation;/* [charset(UTF8),unique] */
		enum DNS_RPC_TYPEID dwTypeId;
		union DNSSRV_RPC_UNION pData;/* [switch_is(dwTypeId)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct DnssrvQuery2 {
	struct {
		enum DNS_RPC_CLIENT_VERSION dwClientVersion;
		uint32_t dwSettingFlags;
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [charset(UTF8),unique] */
		const char *pszOperation;/* [unique,charset(UTF8)] */
	} in;

	struct {
		enum DNS_RPC_TYPEID *pdwTypeId;/* [ref] */
		union DNSSRV_RPC_UNION *ppData;/* [switch_is(*pdwTypeId),ref] */
		WERROR result;
	} out;

};


struct DnssrvComplexOperation2 {
	struct {
		enum DNS_RPC_CLIENT_VERSION dwClientVersion;
		uint32_t dwSettingFlags;
		const char *pwszServerName;/* [charset(UTF16),unique] */
		const char *pszZone;/* [charset(UTF8),unique] */
		const char *pszOperation;/* [charset(UTF8),unique] */
		enum DNS_RPC_TYPEID dwTypeIn;
		union DNSSRV_RPC_UNION pDataIn;/* [switch_is(dwTypeIn)] */
	} in;

	struct {
		enum DNS_RPC_TYPEID *pdwTypeOut;/* [ref] */
		union DNSSRV_RPC_UNION *ppDataOut;/* [ref,switch_is(*pdwTypeOut)] */
		WERROR result;
	} out;

};


struct DnssrvEnumRecords2 {
	struct {
		enum DNS_RPC_CLIENT_VERSION dwClientVersion;
		uint32_t dwSettingFlags;
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [unique,charset(UTF8)] */
		const char *pszNodeName;/* [charset(UTF8),unique] */
		const char *pszStartChild;/* [unique,charset(UTF8)] */
		enum dns_record_type wRecordType;
		uint32_t fSelectFlag;
		const char *pszFilterStart;/* [unique,charset(UTF8)] */
		const char *pszFilterStop;/* [charset(UTF8),unique] */
	} in;

	struct {
		uint32_t *pdwBufferLength;/* [ref] */
		struct DNS_RPC_RECORDS_ARRAY **pBuffer;/* [subcontext(4),ref,subcontext_size(*pdwBufferLength)] */
		WERROR result;
	} out;

};


struct DnssrvUpdateRecord2 {
	struct {
		enum DNS_RPC_CLIENT_VERSION dwClientVersion;
		uint32_t dwSettingFlags;
		const char *pwszServerName;/* [unique,charset(UTF16)] */
		const char *pszZone;/* [unique,charset(UTF8)] */
		const char *pszNodeName;/* [charset(UTF8),ref] */
		struct DNS_RPC_RECORD_BUF *pAddRecord;/* [unique] */
		struct DNS_RPC_RECORD_BUF *pDeleteRecord;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_dnsserver */
#endif /* _PIDL_HEADER_dnsserver */
