/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_winreg.h"
#include "autoconf/librpc/gen_ndr/ndr_winreg_c.h"

/* winreg - client functions generated by pidl */

struct dcerpc_winreg_OpenHKCR_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCR_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCR_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKCR *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCR_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCR_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCR, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCR_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKCR_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCR_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKCR_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKCR_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCR_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKCR *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCR, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKCR_state {
	struct winreg_OpenHKCR orig;
	struct winreg_OpenHKCR tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCR_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCR_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCR_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCR_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKCR_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKCR_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCR_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKCR_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKCR_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCR_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKCR_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCR_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKCR_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCR_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCR(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKCR r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKCR_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKCU_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCU_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCU_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKCU *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCU_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCU_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCU, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCU_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKCU_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCU_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKCU_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKCU_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCU_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKCU *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCU, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKCU_state {
	struct winreg_OpenHKCU orig;
	struct winreg_OpenHKCU tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCU_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCU_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCU_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCU_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKCU_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKCU_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCU_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKCU_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKCU_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCU_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKCU_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCU_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKCU_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCU_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCU(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKCU r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKCU_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKLM_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKLM_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKLM_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKLM *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKLM_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKLM_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKLM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKLM_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKLM_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKLM_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKLM_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKLM_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKLM_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKLM *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKLM, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKLM_state {
	struct winreg_OpenHKLM orig;
	struct winreg_OpenHKLM tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKLM_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKLM_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKLM_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKLM_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKLM_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKLM_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKLM_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKLM_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKLM_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKLM_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKLM_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKLM_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKLM_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKLM_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKLM(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKLM r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKLM_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKPD_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPD_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPD_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKPD *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPD_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPD_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPD_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKPD_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPD_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKPD_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKPD_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPD_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKPD *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPD, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKPD_state {
	struct winreg_OpenHKPD orig;
	struct winreg_OpenHKPD tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPD_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPD_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPD_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPD_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKPD_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKPD_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPD_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKPD_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKPD_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPD_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKPD_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPD_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKPD_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPD_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPD(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKPD r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKPD_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKU_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKU_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKU_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKU *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKU_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKU_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKU, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKU_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKU_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKU_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKU_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKU_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKU_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKU *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKU, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKU_state {
	struct winreg_OpenHKU orig;
	struct winreg_OpenHKU tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKU_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKU_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint16_t *_system_name /* [in] [unique] */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKU_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKU_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKU_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKU_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKU_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKU_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKU_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKU_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKU_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKU_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_winreg_OpenHKU_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKU_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKU(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *_system_name /* [in] [unique] */,
			       uint32_t _access_mask /* [in]  */,
			       struct policy_handle *_handle /* [out] [ref] */,
			       WERROR *result)
{
	struct winreg_OpenHKU r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKU_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_CloseKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_CloseKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_CloseKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_CloseKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_CloseKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_CloseKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_CLOSEKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_CloseKey_r_done, req);

	return req;
}

static void dcerpc_winreg_CloseKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_CloseKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_CloseKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_CloseKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_CloseKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_CloseKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_CLOSEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_CloseKey_state {
	struct winreg_CloseKey orig;
	struct winreg_CloseKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_CloseKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_CloseKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_CloseKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_CloseKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_CloseKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_CloseKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_CloseKey_done, req);
	return req;
}

static void dcerpc_winreg_CloseKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_CloseKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_CloseKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_CloseKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_CloseKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_CloseKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_CloseKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_CloseKey(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in,out] [ref] */,
				WERROR *result)
{
	struct winreg_CloseKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_CloseKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_CreateKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_CreateKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_CreateKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_CreateKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_CreateKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_CreateKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_CREATEKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_CreateKey_r_done, req);

	return req;
}

static void dcerpc_winreg_CreateKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_CreateKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_CreateKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_CreateKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_CreateKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_CreateKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_CREATEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_CreateKey_state {
	struct winreg_CreateKey orig;
	struct winreg_CreateKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_CreateKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_CreateKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String _name /* [in]  */,
						struct winreg_String _keyclass /* [in]  */,
						uint32_t _options /* [in]  */,
						uint32_t _access_mask /* [in]  */,
						struct winreg_SecBuf *_secdesc /* [in] [unique] */,
						struct policy_handle *_new_handle /* [out] [ref] */,
						enum winreg_CreateAction *_action_taken /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_CreateKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_CreateKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.keyclass = _keyclass;
	state->orig.in.options = _options;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.secdesc = _secdesc;
	state->orig.in.action_taken = _action_taken;

	/* Out parameters */
	state->orig.out.new_handle = _new_handle;
	state->orig.out.action_taken = _action_taken;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_CreateKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_CreateKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_CreateKey_done, req);
	return req;
}

static void dcerpc_winreg_CreateKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_CreateKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_CreateKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_CreateKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.new_handle = *state->tmp.out.new_handle;
	if (state->orig.out.action_taken && state->tmp.out.action_taken) {
		*state->orig.out.action_taken = *state->tmp.out.action_taken;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_CreateKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_winreg_CreateKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_CreateKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_CreateKey(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 struct winreg_String _name /* [in]  */,
				 struct winreg_String _keyclass /* [in]  */,
				 uint32_t _options /* [in]  */,
				 uint32_t _access_mask /* [in]  */,
				 struct winreg_SecBuf *_secdesc /* [in] [unique] */,
				 struct policy_handle *_new_handle /* [out] [ref] */,
				 enum winreg_CreateAction *_action_taken /* [in,out] [unique] */,
				 WERROR *result)
{
	struct winreg_CreateKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.keyclass = _keyclass;
	r.in.options = _options;
	r.in.access_mask = _access_mask;
	r.in.secdesc = _secdesc;
	r.in.action_taken = _action_taken;

	/* Out parameters */
	r.out.new_handle = _new_handle;
	r.out.action_taken = _action_taken;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_CreateKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_new_handle = *r.out.new_handle;
	if (_action_taken && r.out.action_taken) {
		*_action_taken = *r.out.action_taken;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_DeleteKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_DeleteKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteKey_r_done, req);

	return req;
}

static void dcerpc_winreg_DeleteKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_DeleteKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_DeleteKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_DeleteKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_DeleteKey_state {
	struct winreg_DeleteKey orig;
	struct winreg_DeleteKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String _key /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key = _key;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_DeleteKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteKey_done, req);
	return req;
}

static void dcerpc_winreg_DeleteKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_DeleteKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_DeleteKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_winreg_DeleteKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteKey(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 struct winreg_String _key /* [in]  */,
				 WERROR *result)
{
	struct winreg_DeleteKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key = _key;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_DeleteKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_DeleteValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_DeleteValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEVALUE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteValue_r_done, req);

	return req;
}

static void dcerpc_winreg_DeleteValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_DeleteValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_DeleteValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_DeleteValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_DeleteValue_state {
	struct winreg_DeleteValue orig;
	struct winreg_DeleteValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteValue_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct winreg_String _value /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.value = _value;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_DeleteValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteValue_done, req);
	return req;
}

static void dcerpc_winreg_DeleteValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_DeleteValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteValue_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_winreg_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteValue(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   struct winreg_String _value /* [in]  */,
				   WERROR *result)
{
	struct winreg_DeleteValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.value = _value;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_DeleteValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_EnumKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_EnumKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_EnumKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_EnumKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_EnumKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_EnumKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ENUMKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_EnumKey_r_done, req);

	return req;
}

static void dcerpc_winreg_EnumKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_EnumKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_EnumKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_EnumKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_EnumKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_EnumKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ENUMKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_EnumKey_state {
	struct winreg_EnumKey orig;
	struct winreg_EnumKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_EnumKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_EnumKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      uint32_t _enum_index /* [in]  */,
					      struct winreg_StringBuf *_name /* [in,out] [ref] */,
					      struct winreg_StringBuf *_keyclass /* [in,out] [unique] */,
					      NTTIME *_last_changed_time /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_EnumKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_EnumKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.enum_index = _enum_index;
	state->orig.in.name = _name;
	state->orig.in.keyclass = _keyclass;
	state->orig.in.last_changed_time = _last_changed_time;

	/* Out parameters */
	state->orig.out.name = _name;
	state->orig.out.keyclass = _keyclass;
	state->orig.out.last_changed_time = _last_changed_time;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_EnumKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_EnumKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_EnumKey_done, req);
	return req;
}

static void dcerpc_winreg_EnumKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_EnumKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_EnumKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_EnumKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name = *state->tmp.out.name;
	if (state->orig.out.keyclass && state->tmp.out.keyclass) {
		*state->orig.out.keyclass = *state->tmp.out.keyclass;
	}
	if (state->orig.out.last_changed_time && state->tmp.out.last_changed_time) {
		*state->orig.out.last_changed_time = *state->tmp.out.last_changed_time;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_EnumKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_winreg_EnumKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_EnumKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_EnumKey(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       uint32_t _enum_index /* [in]  */,
			       struct winreg_StringBuf *_name /* [in,out] [ref] */,
			       struct winreg_StringBuf *_keyclass /* [in,out] [unique] */,
			       NTTIME *_last_changed_time /* [in,out] [unique] */,
			       WERROR *result)
{
	struct winreg_EnumKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.enum_index = _enum_index;
	r.in.name = _name;
	r.in.keyclass = _keyclass;
	r.in.last_changed_time = _last_changed_time;

	/* Out parameters */
	r.out.name = _name;
	r.out.keyclass = _keyclass;
	r.out.last_changed_time = _last_changed_time;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_EnumKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name = *r.out.name;
	if (_keyclass && r.out.keyclass) {
		*_keyclass = *r.out.keyclass;
	}
	if (_last_changed_time && r.out.last_changed_time) {
		*_last_changed_time = *r.out.last_changed_time;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_EnumValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_EnumValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_EnumValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_EnumValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_EnumValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_EnumValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ENUMVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_EnumValue_r_done, req);

	return req;
}

static void dcerpc_winreg_EnumValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_EnumValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_EnumValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_EnumValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_EnumValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_EnumValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ENUMVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_EnumValue_state {
	struct winreg_EnumValue orig;
	struct winreg_EnumValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_EnumValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_EnumValue_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _enum_index /* [in]  */,
						struct winreg_ValNameBuf *_name /* [in,out] [ref] */,
						enum winreg_Type *_type /* [in,out] [unique] */,
						uint8_t *_value /* [in,out] [unique,range(0,0x4000000),length_is(length?*length:0),size_is(size?*size:0)] */,
						uint32_t *_size /* [in,out] [unique] */,
						uint32_t *_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_EnumValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_EnumValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.enum_index = _enum_index;
	state->orig.in.name = _name;
	state->orig.in.type = _type;
	state->orig.in.value = _value;
	state->orig.in.size = _size;
	state->orig.in.length = _length;

	/* Out parameters */
	state->orig.out.name = _name;
	state->orig.out.type = _type;
	state->orig.out.value = _value;
	state->orig.out.size = _size;
	state->orig.out.length = _length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_EnumValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_EnumValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_EnumValue_done, req);
	return req;
}

static void dcerpc_winreg_EnumValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_EnumValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_EnumValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_EnumValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name = *state->tmp.out.name;
	if (state->orig.out.type && state->tmp.out.type) {
		*state->orig.out.type = *state->tmp.out.type;
	}
	if (state->orig.out.value && state->tmp.out.value) {
		{
			size_t _copy_len_value;
			if ((state->tmp.out.size?*state->tmp.out.size:0) > (state->tmp.in.size?*state->tmp.in.size:0)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			if ((state->tmp.out.length?*state->tmp.out.length:0) > (state->tmp.out.size?*state->tmp.out.size:0)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			_copy_len_value = state->tmp.out.length?*state->tmp.out.length:0;
			memcpy(state->orig.out.value, state->tmp.out.value, _copy_len_value * sizeof(*state->orig.out.value));
		}
	}
	if (state->orig.out.size && state->tmp.out.size) {
		*state->orig.out.size = *state->tmp.out.size;
	}
	if (state->orig.out.length && state->tmp.out.length) {
		*state->orig.out.length = *state->tmp.out.length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_EnumValue_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_winreg_EnumValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_EnumValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_EnumValue(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t _enum_index /* [in]  */,
				 struct winreg_ValNameBuf *_name /* [in,out] [ref] */,
				 enum winreg_Type *_type /* [in,out] [unique] */,
				 uint8_t *_value /* [in,out] [unique,range(0,0x4000000),length_is(length?*length:0),size_is(size?*size:0)] */,
				 uint32_t *_size /* [in,out] [unique] */,
				 uint32_t *_length /* [in,out] [unique] */,
				 WERROR *result)
{
	struct winreg_EnumValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.enum_index = _enum_index;
	r.in.name = _name;
	r.in.type = _type;
	r.in.value = _value;
	r.in.size = _size;
	r.in.length = _length;

	/* Out parameters */
	r.out.name = _name;
	r.out.type = _type;
	r.out.value = _value;
	r.out.size = _size;
	r.out.length = _length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_EnumValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name = *r.out.name;
	if (_type && r.out.type) {
		*_type = *r.out.type;
	}
	if (_value && r.out.value) {
		{
			size_t _copy_len_value;
			if ((r.out.size?*r.out.size:0) > (r.in.size?*r.in.size:0)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			if ((r.out.length?*r.out.length:0) > (r.out.size?*r.out.size:0)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			_copy_len_value = r.out.length?*r.out.length:0;
			memcpy(_value, r.out.value, _copy_len_value * sizeof(*_value));
		}
	}
	if (_size && r.out.size) {
		*_size = *r.out.size;
	}
	if (_length && r.out.length) {
		*_length = *r.out.length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_FlushKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_FlushKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_FlushKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_FlushKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_FlushKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_FlushKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_FLUSHKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_FlushKey_r_done, req);

	return req;
}

static void dcerpc_winreg_FlushKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_FlushKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_FlushKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_FlushKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_FlushKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_FlushKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_FLUSHKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_FlushKey_state {
	struct winreg_FlushKey orig;
	struct winreg_FlushKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_FlushKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_FlushKey_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_FlushKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_FlushKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_FlushKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_FlushKey_done, req);
	return req;
}

static void dcerpc_winreg_FlushKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_FlushKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_FlushKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_FlushKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_FlushKey_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_FlushKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_FlushKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_FlushKey(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				WERROR *result)
{
	struct winreg_FlushKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_FlushKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_GetKeySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_GetKeySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_GetKeySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_GetKeySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_GetKeySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_GetKeySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_GETKEYSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_GetKeySecurity_r_done, req);

	return req;
}

static void dcerpc_winreg_GetKeySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_GetKeySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_GetKeySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_GetKeySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_GetKeySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_GetKeySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_GETKEYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_GetKeySecurity_state {
	struct winreg_GetKeySecurity orig;
	struct winreg_GetKeySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_GetKeySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_GetKeySecurity_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     uint32_t _sec_info /* [in]  */,
						     struct KeySecurityData *_sd /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_GetKeySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_GetKeySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;
	state->orig.in.sd = _sd;

	/* Out parameters */
	state->orig.out.sd = _sd;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_GetKeySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_GetKeySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_GetKeySecurity_done, req);
	return req;
}

static void dcerpc_winreg_GetKeySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_GetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_winreg_GetKeySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_GetKeySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sd = *state->tmp.out.sd;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_GetKeySecurity_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winreg_GetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_winreg_GetKeySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_GetKeySecurity(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      uint32_t _sec_info /* [in]  */,
				      struct KeySecurityData *_sd /* [in,out] [ref] */,
				      WERROR *result)
{
	struct winreg_GetKeySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;
	r.in.sd = _sd;

	/* Out parameters */
	r.out.sd = _sd;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_GetKeySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sd = *r.out.sd;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_LoadKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_LoadKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_LoadKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_LoadKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_LoadKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_LoadKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_LOADKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_LoadKey_r_done, req);

	return req;
}

static void dcerpc_winreg_LoadKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_LoadKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_LoadKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_LoadKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_LoadKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_LoadKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_LOADKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_LoadKey_state {
	struct winreg_LoadKey orig;
	struct winreg_LoadKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_LoadKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_LoadKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct winreg_String *_keyname /* [in] [unique] */,
					      struct winreg_String *_filename /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_LoadKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_LoadKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.keyname = _keyname;
	state->orig.in.filename = _filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_LoadKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_LoadKey_done, req);
	return req;
}

static void dcerpc_winreg_LoadKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_LoadKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_LoadKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_LoadKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_LoadKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_winreg_LoadKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_LoadKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_LoadKey(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       struct winreg_String *_keyname /* [in] [unique] */,
			       struct winreg_String *_filename /* [in] [unique] */,
			       WERROR *result)
{
	struct winreg_LoadKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.keyname = _keyname;
	r.in.filename = _filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_LoadKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_NotifyChangeKeyValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_NotifyChangeKeyValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_NotifyChangeKeyValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_NotifyChangeKeyValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_NotifyChangeKeyValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_NotifyChangeKeyValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_NOTIFYCHANGEKEYVALUE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_NotifyChangeKeyValue_r_done, req);

	return req;
}

static void dcerpc_winreg_NotifyChangeKeyValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_NotifyChangeKeyValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_NotifyChangeKeyValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_NotifyChangeKeyValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_NotifyChangeKeyValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_NotifyChangeKeyValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_NOTIFYCHANGEKEYVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_NotifyChangeKeyValue_state {
	struct winreg_NotifyChangeKeyValue orig;
	struct winreg_NotifyChangeKeyValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_NotifyChangeKeyValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_NotifyChangeKeyValue_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint8_t _watch_subtree /* [in]  */,
							   uint32_t _notify_filter /* [in]  */,
							   uint32_t _unknown /* [in]  */,
							   struct winreg_String _string1 /* [in]  */,
							   struct winreg_String _string2 /* [in]  */,
							   uint32_t _unknown2 /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_NotifyChangeKeyValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_NotifyChangeKeyValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.watch_subtree = _watch_subtree;
	state->orig.in.notify_filter = _notify_filter;
	state->orig.in.unknown = _unknown;
	state->orig.in.string1 = _string1;
	state->orig.in.string2 = _string2;
	state->orig.in.unknown2 = _unknown2;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_NotifyChangeKeyValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_NotifyChangeKeyValue_done, req);
	return req;
}

static void dcerpc_winreg_NotifyChangeKeyValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_NotifyChangeKeyValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_NotifyChangeKeyValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_NotifyChangeKeyValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_NotifyChangeKeyValue_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_winreg_NotifyChangeKeyValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_NotifyChangeKeyValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_NotifyChangeKeyValue(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    uint8_t _watch_subtree /* [in]  */,
					    uint32_t _notify_filter /* [in]  */,
					    uint32_t _unknown /* [in]  */,
					    struct winreg_String _string1 /* [in]  */,
					    struct winreg_String _string2 /* [in]  */,
					    uint32_t _unknown2 /* [in]  */,
					    WERROR *result)
{
	struct winreg_NotifyChangeKeyValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.watch_subtree = _watch_subtree;
	r.in.notify_filter = _notify_filter;
	r.in.unknown = _unknown;
	r.in.string1 = _string1;
	r.in.string2 = _string2;
	r.in.unknown2 = _unknown2;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_NotifyChangeKeyValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenKey_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenKey_state {
	struct winreg_OpenKey orig;
	struct winreg_OpenKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_parent_handle /* [in] [ref] */,
					      struct winreg_String _keyname /* [in]  */,
					      uint32_t _options /* [in]  */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.parent_handle = _parent_handle;
	state->orig.in.keyname = _keyname;
	state->orig.in.options = _options;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenKey_done, req);
	return req;
}

static void dcerpc_winreg_OpenKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_winreg_OpenKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenKey(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_parent_handle /* [in] [ref] */,
			       struct winreg_String _keyname /* [in]  */,
			       uint32_t _options /* [in]  */,
			       uint32_t _access_mask /* [in]  */,
			       struct policy_handle *_handle /* [out] [ref] */,
			       WERROR *result)
{
	struct winreg_OpenKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.parent_handle = _parent_handle;
	r.in.keyname = _keyname;
	r.in.options = _options;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_QueryInfoKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryInfoKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryInfoKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_QueryInfoKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryInfoKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryInfoKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYINFOKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryInfoKey_r_done, req);

	return req;
}

static void dcerpc_winreg_QueryInfoKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryInfoKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_QueryInfoKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_QueryInfoKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryInfoKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_QueryInfoKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYINFOKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_QueryInfoKey_state {
	struct winreg_QueryInfoKey orig;
	struct winreg_QueryInfoKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryInfoKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryInfoKey_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_handle /* [in] [ref] */,
						   struct winreg_String *_classname /* [in,out] [ref] */,
						   uint32_t *_num_subkeys /* [out] [ref] */,
						   uint32_t *_max_subkeylen /* [out] [ref] */,
						   uint32_t *_max_classlen /* [out] [ref] */,
						   uint32_t *_num_values /* [out] [ref] */,
						   uint32_t *_max_valnamelen /* [out] [ref] */,
						   uint32_t *_max_valbufsize /* [out] [ref] */,
						   uint32_t *_secdescsize /* [out] [ref] */,
						   NTTIME *_last_changed_time /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryInfoKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryInfoKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.classname = _classname;

	/* Out parameters */
	state->orig.out.classname = _classname;
	state->orig.out.num_subkeys = _num_subkeys;
	state->orig.out.max_subkeylen = _max_subkeylen;
	state->orig.out.max_classlen = _max_classlen;
	state->orig.out.num_values = _num_values;
	state->orig.out.max_valnamelen = _max_valnamelen;
	state->orig.out.max_valbufsize = _max_valbufsize;
	state->orig.out.secdescsize = _secdescsize;
	state->orig.out.last_changed_time = _last_changed_time;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_QueryInfoKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_QueryInfoKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryInfoKey_done, req);
	return req;
}

static void dcerpc_winreg_QueryInfoKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_QueryInfoKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryInfoKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_QueryInfoKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.classname = *state->tmp.out.classname;
	*state->orig.out.num_subkeys = *state->tmp.out.num_subkeys;
	*state->orig.out.max_subkeylen = *state->tmp.out.max_subkeylen;
	*state->orig.out.max_classlen = *state->tmp.out.max_classlen;
	*state->orig.out.num_values = *state->tmp.out.num_values;
	*state->orig.out.max_valnamelen = *state->tmp.out.max_valnamelen;
	*state->orig.out.max_valbufsize = *state->tmp.out.max_valbufsize;
	*state->orig.out.secdescsize = *state->tmp.out.secdescsize;
	*state->orig.out.last_changed_time = *state->tmp.out.last_changed_time;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryInfoKey_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_winreg_QueryInfoKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryInfoKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryInfoKey(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_handle /* [in] [ref] */,
				    struct winreg_String *_classname /* [in,out] [ref] */,
				    uint32_t *_num_subkeys /* [out] [ref] */,
				    uint32_t *_max_subkeylen /* [out] [ref] */,
				    uint32_t *_max_classlen /* [out] [ref] */,
				    uint32_t *_num_values /* [out] [ref] */,
				    uint32_t *_max_valnamelen /* [out] [ref] */,
				    uint32_t *_max_valbufsize /* [out] [ref] */,
				    uint32_t *_secdescsize /* [out] [ref] */,
				    NTTIME *_last_changed_time /* [out] [ref] */,
				    WERROR *result)
{
	struct winreg_QueryInfoKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.classname = _classname;

	/* Out parameters */
	r.out.classname = _classname;
	r.out.num_subkeys = _num_subkeys;
	r.out.max_subkeylen = _max_subkeylen;
	r.out.max_classlen = _max_classlen;
	r.out.num_values = _num_values;
	r.out.max_valnamelen = _max_valnamelen;
	r.out.max_valbufsize = _max_valbufsize;
	r.out.secdescsize = _secdescsize;
	r.out.last_changed_time = _last_changed_time;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_QueryInfoKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_classname = *r.out.classname;
	*_num_subkeys = *r.out.num_subkeys;
	*_max_subkeylen = *r.out.max_subkeylen;
	*_max_classlen = *r.out.max_classlen;
	*_num_values = *r.out.num_values;
	*_max_valnamelen = *r.out.max_valnamelen;
	*_max_valbufsize = *r.out.max_valbufsize;
	*_secdescsize = *r.out.secdescsize;
	*_last_changed_time = *r.out.last_changed_time;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_QueryValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_QueryValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryValue_r_done, req);

	return req;
}

static void dcerpc_winreg_QueryValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_QueryValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_QueryValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_QueryValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_QueryValue_state {
	struct winreg_QueryValue orig;
	struct winreg_QueryValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryValue_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct winreg_String *_value_name /* [in] [ref] */,
						 enum winreg_Type *_type /* [in,out] [unique] */,
						 uint8_t *_data /* [in,out] [unique,range(0,0x4000000),length_is(data_length?*data_length:0),size_is(data_size?*data_size:0)] */,
						 uint32_t *_data_size /* [in,out] [unique] */,
						 uint32_t *_data_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.value_name = _value_name;
	state->orig.in.type = _type;
	state->orig.in.data = _data;
	state->orig.in.data_size = _data_size;
	state->orig.in.data_length = _data_length;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.data = _data;
	state->orig.out.data_size = _data_size;
	state->orig.out.data_length = _data_length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_QueryValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_QueryValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryValue_done, req);
	return req;
}

static void dcerpc_winreg_QueryValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_QueryValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_QueryValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.type && state->tmp.out.type) {
		*state->orig.out.type = *state->tmp.out.type;
	}
	if (state->orig.out.data && state->tmp.out.data) {
		{
			size_t _copy_len_data;
			if ((state->tmp.out.data_size?*state->tmp.out.data_size:0) > (state->tmp.in.data_size?*state->tmp.in.data_size:0)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			if ((state->tmp.out.data_length?*state->tmp.out.data_length:0) > (state->tmp.out.data_size?*state->tmp.out.data_size:0)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			_copy_len_data = state->tmp.out.data_length?*state->tmp.out.data_length:0;
			memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
		}
	}
	if (state->orig.out.data_size && state->tmp.out.data_size) {
		*state->orig.out.data_size = *state->tmp.out.data_size;
	}
	if (state->orig.out.data_length && state->tmp.out.data_length) {
		*state->orig.out.data_length = *state->tmp.out.data_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryValue_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_winreg_QueryValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryValue(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  struct winreg_String *_value_name /* [in] [ref] */,
				  enum winreg_Type *_type /* [in,out] [unique] */,
				  uint8_t *_data /* [in,out] [unique,range(0,0x4000000),length_is(data_length?*data_length:0),size_is(data_size?*data_size:0)] */,
				  uint32_t *_data_size /* [in,out] [unique] */,
				  uint32_t *_data_length /* [in,out] [unique] */,
				  WERROR *result)
{
	struct winreg_QueryValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.value_name = _value_name;
	r.in.type = _type;
	r.in.data = _data;
	r.in.data_size = _data_size;
	r.in.data_length = _data_length;

	/* Out parameters */
	r.out.type = _type;
	r.out.data = _data;
	r.out.data_size = _data_size;
	r.out.data_length = _data_length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_QueryValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_type && r.out.type) {
		*_type = *r.out.type;
	}
	if (_data && r.out.data) {
		{
			size_t _copy_len_data;
			if ((r.out.data_size?*r.out.data_size:0) > (r.in.data_size?*r.in.data_size:0)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			if ((r.out.data_length?*r.out.data_length:0) > (r.out.data_size?*r.out.data_size:0)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			_copy_len_data = r.out.data_length?*r.out.data_length:0;
			memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
		}
	}
	if (_data_size && r.out.data_size) {
		*_data_size = *r.out.data_size;
	}
	if (_data_length && r.out.data_length) {
		*_data_length = *r.out.data_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_ReplaceKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_ReplaceKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_ReplaceKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_ReplaceKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_ReplaceKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_ReplaceKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_REPLACEKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_ReplaceKey_r_done, req);

	return req;
}

static void dcerpc_winreg_ReplaceKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_ReplaceKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_ReplaceKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_ReplaceKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_ReplaceKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_ReplaceKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_REPLACEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_ReplaceKey_state {
	struct winreg_ReplaceKey orig;
	struct winreg_ReplaceKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_ReplaceKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_ReplaceKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct winreg_String *_subkey /* [in] [ref] */,
						 struct winreg_String *_new_file /* [in] [ref] */,
						 struct winreg_String *_old_file /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_ReplaceKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_ReplaceKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.subkey = _subkey;
	state->orig.in.new_file = _new_file;
	state->orig.in.old_file = _old_file;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_ReplaceKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_ReplaceKey_done, req);
	return req;
}

static void dcerpc_winreg_ReplaceKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_ReplaceKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_ReplaceKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_ReplaceKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_ReplaceKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_winreg_ReplaceKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_ReplaceKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_ReplaceKey(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  struct winreg_String *_subkey /* [in] [ref] */,
				  struct winreg_String *_new_file /* [in] [ref] */,
				  struct winreg_String *_old_file /* [in] [ref] */,
				  WERROR *result)
{
	struct winreg_ReplaceKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.subkey = _subkey;
	r.in.new_file = _new_file;
	r.in.old_file = _old_file;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_ReplaceKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_RestoreKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_RestoreKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_RestoreKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_RestoreKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_RestoreKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_RestoreKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_RESTOREKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_RestoreKey_r_done, req);

	return req;
}

static void dcerpc_winreg_RestoreKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_RestoreKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_RestoreKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_RestoreKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_RestoreKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_RestoreKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_RESTOREKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_RestoreKey_state {
	struct winreg_RestoreKey orig;
	struct winreg_RestoreKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_RestoreKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_RestoreKey_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct winreg_String *_filename /* [in] [ref] */,
						 uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_RestoreKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_RestoreKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.filename = _filename;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_RestoreKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_RestoreKey_done, req);
	return req;
}

static void dcerpc_winreg_RestoreKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_RestoreKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_RestoreKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_RestoreKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_RestoreKey_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_winreg_RestoreKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_RestoreKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_RestoreKey(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  struct winreg_String *_filename /* [in] [ref] */,
				  uint32_t _flags /* [in]  */,
				  WERROR *result)
{
	struct winreg_RestoreKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.filename = _filename;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_RestoreKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_SaveKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SaveKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SaveKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_SaveKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SaveKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SaveKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SAVEKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SaveKey_r_done, req);

	return req;
}

static void dcerpc_winreg_SaveKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SaveKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_SaveKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_SaveKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SaveKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_SaveKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SAVEKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_SaveKey_state {
	struct winreg_SaveKey orig;
	struct winreg_SaveKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SaveKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SaveKey_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct winreg_String *_filename /* [in] [ref] */,
					      struct KeySecurityAttribute *_sec_attrib /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SaveKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SaveKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.filename = _filename;
	state->orig.in.sec_attrib = _sec_attrib;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_SaveKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SaveKey_done, req);
	return req;
}

static void dcerpc_winreg_SaveKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_SaveKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SaveKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_SaveKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SaveKey_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_winreg_SaveKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SaveKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SaveKey(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       struct winreg_String *_filename /* [in] [ref] */,
			       struct KeySecurityAttribute *_sec_attrib /* [in] [unique] */,
			       WERROR *result)
{
	struct winreg_SaveKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.filename = _filename;
	r.in.sec_attrib = _sec_attrib;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_SaveKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_SetKeySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SetKeySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SetKeySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_SetKeySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SetKeySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SetKeySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SETKEYSECURITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SetKeySecurity_r_done, req);

	return req;
}

static void dcerpc_winreg_SetKeySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SetKeySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_SetKeySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_SetKeySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SetKeySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_SetKeySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SETKEYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_SetKeySecurity_state {
	struct winreg_SetKeySecurity orig;
	struct winreg_SetKeySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SetKeySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SetKeySecurity_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     uint32_t _sec_info /* [in]  */,
						     struct KeySecurityData *_sd /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SetKeySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SetKeySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;
	state->orig.in.sd = _sd;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_SetKeySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SetKeySecurity_done, req);
	return req;
}

static void dcerpc_winreg_SetKeySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_SetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SetKeySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_SetKeySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SetKeySecurity_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_winreg_SetKeySecurity_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SetKeySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SetKeySecurity(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      uint32_t _sec_info /* [in]  */,
				      struct KeySecurityData *_sd /* [in] [ref] */,
				      WERROR *result)
{
	struct winreg_SetKeySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;
	r.in.sd = _sd;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_SetKeySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_SetValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SetValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SetValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_SetValue *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SetValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SetValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SETVALUE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SetValue_r_done, req);

	return req;
}

static void dcerpc_winreg_SetValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SetValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_SetValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_SetValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SetValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_SetValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SETVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_SetValue_state {
	struct winreg_SetValue orig;
	struct winreg_SetValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SetValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SetValue_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct winreg_String _name /* [in]  */,
					       enum winreg_Type _type /* [in]  */,
					       uint8_t *_data /* [in] [ref,size_is(size)] */,
					       uint32_t _size /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.type = _type;
	state->orig.in.data = _data;
	state->orig.in.size = _size;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_SetValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SetValue_done, req);
	return req;
}

static void dcerpc_winreg_SetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_SetValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SetValue_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SetValue(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				struct winreg_String _name /* [in]  */,
				enum winreg_Type _type /* [in]  */,
				uint8_t *_data /* [in] [ref,size_is(size)] */,
				uint32_t _size /* [in]  */,
				WERROR *result)
{
	struct winreg_SetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.name = _name;
	r.in.type = _type;
	r.in.data = _data;
	r.in.size = _size;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_SetValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_UnLoadKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_UnLoadKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_UnLoadKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_UnLoadKey *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_UnLoadKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_UnLoadKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_UNLOADKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_UnLoadKey_r_done, req);

	return req;
}

static void dcerpc_winreg_UnLoadKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_UnLoadKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_UnLoadKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_UnLoadKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_UnLoadKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_UnLoadKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_UNLOADKEY, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_UnLoadKey_state {
	struct winreg_UnLoadKey orig;
	struct winreg_UnLoadKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_UnLoadKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_UnLoadKey_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String *_subkey /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_UnLoadKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_UnLoadKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.subkey = _subkey;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_UnLoadKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_UnLoadKey_done, req);
	return req;
}

static void dcerpc_winreg_UnLoadKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_UnLoadKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_UnLoadKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_UnLoadKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_UnLoadKey_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_winreg_UnLoadKey_state *state = tevent_req_data(
		req, struct dcerpc_winreg_UnLoadKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_UnLoadKey(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 struct winreg_String *_subkey /* [in] [ref] */,
				 WERROR *result)
{
	struct winreg_UnLoadKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.subkey = _subkey;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_UnLoadKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_InitiateSystemShutdown_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_InitiateSystemShutdown_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_InitiateSystemShutdown_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_InitiateSystemShutdown *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_InitiateSystemShutdown_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_InitiateSystemShutdown_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_INITIATESYSTEMSHUTDOWN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_InitiateSystemShutdown_r_done, req);

	return req;
}

static void dcerpc_winreg_InitiateSystemShutdown_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdown_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_InitiateSystemShutdown_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_InitiateSystemShutdown_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdown_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_InitiateSystemShutdown *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_INITIATESYSTEMSHUTDOWN, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_InitiateSystemShutdown_state {
	struct winreg_InitiateSystemShutdown orig;
	struct winreg_InitiateSystemShutdown tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_InitiateSystemShutdown_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_InitiateSystemShutdown_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     uint16_t *_hostname /* [in] [unique] */,
							     struct lsa_StringLarge *_message /* [in] [unique] */,
							     uint32_t _timeout /* [in]  */,
							     uint8_t _force_apps /* [in]  */,
							     uint8_t _do_reboot /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_InitiateSystemShutdown_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_InitiateSystemShutdown_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hostname = _hostname;
	state->orig.in.message = _message;
	state->orig.in.timeout = _timeout;
	state->orig.in.force_apps = _force_apps;
	state->orig.in.do_reboot = _do_reboot;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_InitiateSystemShutdown_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_InitiateSystemShutdown_done, req);
	return req;
}

static void dcerpc_winreg_InitiateSystemShutdown_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_InitiateSystemShutdown_state *state = tevent_req_data(
		req, struct dcerpc_winreg_InitiateSystemShutdown_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_InitiateSystemShutdown_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdown_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_winreg_InitiateSystemShutdown_state *state = tevent_req_data(
		req, struct dcerpc_winreg_InitiateSystemShutdown_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdown(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      uint16_t *_hostname /* [in] [unique] */,
					      struct lsa_StringLarge *_message /* [in] [unique] */,
					      uint32_t _timeout /* [in]  */,
					      uint8_t _force_apps /* [in]  */,
					      uint8_t _do_reboot /* [in]  */,
					      WERROR *result)
{
	struct winreg_InitiateSystemShutdown r;
	NTSTATUS status;

	/* In parameters */
	r.in.hostname = _hostname;
	r.in.message = _message;
	r.in.timeout = _timeout;
	r.in.force_apps = _force_apps;
	r.in.do_reboot = _do_reboot;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_InitiateSystemShutdown_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_AbortSystemShutdown_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_AbortSystemShutdown_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_AbortSystemShutdown_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_AbortSystemShutdown *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_AbortSystemShutdown_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_AbortSystemShutdown_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ABORTSYSTEMSHUTDOWN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_AbortSystemShutdown_r_done, req);

	return req;
}

static void dcerpc_winreg_AbortSystemShutdown_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_AbortSystemShutdown_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_AbortSystemShutdown_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_AbortSystemShutdown_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_AbortSystemShutdown_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_AbortSystemShutdown *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_ABORTSYSTEMSHUTDOWN, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_AbortSystemShutdown_state {
	struct winreg_AbortSystemShutdown orig;
	struct winreg_AbortSystemShutdown tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_AbortSystemShutdown_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_AbortSystemShutdown_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  uint16_t *_server /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_AbortSystemShutdown_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_AbortSystemShutdown_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_AbortSystemShutdown_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_AbortSystemShutdown_done, req);
	return req;
}

static void dcerpc_winreg_AbortSystemShutdown_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_AbortSystemShutdown_state *state = tevent_req_data(
		req, struct dcerpc_winreg_AbortSystemShutdown_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_AbortSystemShutdown_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_AbortSystemShutdown_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winreg_AbortSystemShutdown_state *state = tevent_req_data(
		req, struct dcerpc_winreg_AbortSystemShutdown_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_AbortSystemShutdown(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   uint16_t *_server /* [in] [unique] */,
					   WERROR *result)
{
	struct winreg_AbortSystemShutdown r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_AbortSystemShutdown_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_GetVersion_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_GetVersion_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_GetVersion_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_GetVersion *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_GetVersion_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_GetVersion_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_GETVERSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_GetVersion_r_done, req);

	return req;
}

static void dcerpc_winreg_GetVersion_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_GetVersion_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_GetVersion_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_GetVersion_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_GetVersion_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_GetVersion *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_GETVERSION, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_GetVersion_state {
	struct winreg_GetVersion orig;
	struct winreg_GetVersion tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_GetVersion_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_GetVersion_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 uint32_t *_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_GetVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_GetVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.version = _version;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_GetVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_GetVersion_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_GetVersion_done, req);
	return req;
}

static void dcerpc_winreg_GetVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_GetVersion_state *state = tevent_req_data(
		req, struct dcerpc_winreg_GetVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_GetVersion_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.version = *state->tmp.out.version;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_GetVersion_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_winreg_GetVersion_state *state = tevent_req_data(
		req, struct dcerpc_winreg_GetVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_GetVersion(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  uint32_t *_version /* [out] [ref] */,
				  WERROR *result)
{
	struct winreg_GetVersion r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.version = _version;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_GetVersion_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_version = *r.out.version;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKCC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKCC *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCC_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKCC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKCC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKCC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKCC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKCC, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKCC_state {
	struct winreg_OpenHKCC orig;
	struct winreg_OpenHKCC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKCC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKCC_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKCC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKCC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKCC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKCC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKCC_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKCC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKCC_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKCC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKCC_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKCC_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKCC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKCC(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKCC r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKCC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKDD_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKDD_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKDD_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKDD *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKDD_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKDD_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKDD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKDD_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKDD_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKDD_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKDD_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKDD_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKDD_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKDD *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKDD, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKDD_state {
	struct winreg_OpenHKDD orig;
	struct winreg_OpenHKDD tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKDD_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKDD_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKDD_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKDD_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKDD_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKDD_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKDD_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKDD_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKDD_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKDD_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKDD_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKDD_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKDD_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKDD_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKDD(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKDD r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKDD_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_QueryMultipleValues_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryMultipleValues_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryMultipleValues_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_QueryMultipleValues *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryMultipleValues_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryMultipleValues_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYMULTIPLEVALUES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryMultipleValues_r_done, req);

	return req;
}

static void dcerpc_winreg_QueryMultipleValues_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryMultipleValues_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_QueryMultipleValues_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_QueryMultipleValues_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryMultipleValues_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_QueryMultipleValues *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYMULTIPLEVALUES, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_QueryMultipleValues_state {
	struct winreg_QueryMultipleValues orig;
	struct winreg_QueryMultipleValues tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryMultipleValues_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryMultipleValues_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_key_handle /* [in] [ref] */,
							  struct QueryMultipleValue *_values_in /* [in] [ref,length_is(num_values),size_is(num_values)] */,
							  struct QueryMultipleValue *_values_out /* [out] [ref,length_is(num_values),size_is(num_values)] */,
							  uint32_t _num_values /* [in]  */,
							  uint8_t *_buffer /* [in,out] [unique,length_is(*buffer_size),size_is(*buffer_size)] */,
							  uint32_t *_buffer_size /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryMultipleValues_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryMultipleValues_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.key_handle = _key_handle;
	state->orig.in.values_in = _values_in;
	state->orig.in.num_values = _num_values;
	state->orig.in.buffer = _buffer;
	state->orig.in.buffer_size = _buffer_size;

	/* Out parameters */
	state->orig.out.values_out = _values_out;
	state->orig.out.buffer = _buffer;
	state->orig.out.buffer_size = _buffer_size;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_QueryMultipleValues_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_QueryMultipleValues_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryMultipleValues_done, req);
	return req;
}

static void dcerpc_winreg_QueryMultipleValues_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_QueryMultipleValues_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryMultipleValues_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_QueryMultipleValues_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_values_out;
		_copy_len_values_out = state->tmp.in.num_values;
		memcpy(state->orig.out.values_out, state->tmp.out.values_out, _copy_len_values_out * sizeof(*state->orig.out.values_out));
	}
	if (state->orig.out.buffer && state->tmp.out.buffer) {
		{
			size_t _copy_len_buffer;
			if ((*state->tmp.out.buffer_size) > (*state->tmp.in.buffer_size)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			_copy_len_buffer = *state->tmp.out.buffer_size;
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.buffer_size = *state->tmp.out.buffer_size;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryMultipleValues_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_winreg_QueryMultipleValues_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryMultipleValues_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryMultipleValues(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_key_handle /* [in] [ref] */,
					   struct QueryMultipleValue *_values_in /* [in] [ref,length_is(num_values),size_is(num_values)] */,
					   struct QueryMultipleValue *_values_out /* [out] [ref,length_is(num_values),size_is(num_values)] */,
					   uint32_t _num_values /* [in]  */,
					   uint8_t *_buffer /* [in,out] [unique,length_is(*buffer_size),size_is(*buffer_size)] */,
					   uint32_t *_buffer_size /* [in,out] [ref] */,
					   WERROR *result)
{
	struct winreg_QueryMultipleValues r;
	NTSTATUS status;

	/* In parameters */
	r.in.key_handle = _key_handle;
	r.in.values_in = _values_in;
	r.in.num_values = _num_values;
	r.in.buffer = _buffer;
	r.in.buffer_size = _buffer_size;

	/* Out parameters */
	r.out.values_out = _values_out;
	r.out.buffer = _buffer;
	r.out.buffer_size = _buffer_size;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_QueryMultipleValues_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_values_out;
		_copy_len_values_out = r.in.num_values;
		memcpy(_values_out, r.out.values_out, _copy_len_values_out * sizeof(*_values_out));
	}
	if (_buffer && r.out.buffer) {
		{
			size_t _copy_len_buffer;
			if ((*r.out.buffer_size) > (*r.in.buffer_size)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			_copy_len_buffer = *r.out.buffer_size;
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_buffer_size = *r.out.buffer_size;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_InitiateSystemShutdownEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_InitiateSystemShutdownEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_InitiateSystemShutdownEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_InitiateSystemShutdownEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_InitiateSystemShutdownEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_InitiateSystemShutdownEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_INITIATESYSTEMSHUTDOWNEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_InitiateSystemShutdownEx_r_done, req);

	return req;
}

static void dcerpc_winreg_InitiateSystemShutdownEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdownEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_InitiateSystemShutdownEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_InitiateSystemShutdownEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdownEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_InitiateSystemShutdownEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_INITIATESYSTEMSHUTDOWNEX, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_InitiateSystemShutdownEx_state {
	struct winreg_InitiateSystemShutdownEx orig;
	struct winreg_InitiateSystemShutdownEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_InitiateSystemShutdownEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_InitiateSystemShutdownEx_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       uint16_t *_hostname /* [in] [unique] */,
							       struct lsa_StringLarge *_message /* [in] [unique] */,
							       uint32_t _timeout /* [in]  */,
							       uint8_t _force_apps /* [in]  */,
							       uint8_t _do_reboot /* [in]  */,
							       uint32_t _reason /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_InitiateSystemShutdownEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_InitiateSystemShutdownEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hostname = _hostname;
	state->orig.in.message = _message;
	state->orig.in.timeout = _timeout;
	state->orig.in.force_apps = _force_apps;
	state->orig.in.do_reboot = _do_reboot;
	state->orig.in.reason = _reason;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_InitiateSystemShutdownEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_InitiateSystemShutdownEx_done, req);
	return req;
}

static void dcerpc_winreg_InitiateSystemShutdownEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_InitiateSystemShutdownEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_InitiateSystemShutdownEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_InitiateSystemShutdownEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdownEx_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_winreg_InitiateSystemShutdownEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_InitiateSystemShutdownEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_InitiateSystemShutdownEx(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						uint16_t *_hostname /* [in] [unique] */,
						struct lsa_StringLarge *_message /* [in] [unique] */,
						uint32_t _timeout /* [in]  */,
						uint8_t _force_apps /* [in]  */,
						uint8_t _do_reboot /* [in]  */,
						uint32_t _reason /* [in]  */,
						WERROR *result)
{
	struct winreg_InitiateSystemShutdownEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hostname = _hostname;
	r.in.message = _message;
	r.in.timeout = _timeout;
	r.in.force_apps = _force_apps;
	r.in.do_reboot = _do_reboot;
	r.in.reason = _reason;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_InitiateSystemShutdownEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_SaveKeyEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SaveKeyEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SaveKeyEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_SaveKeyEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SaveKeyEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SaveKeyEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SAVEKEYEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SaveKeyEx_r_done, req);

	return req;
}

static void dcerpc_winreg_SaveKeyEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SaveKeyEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_SaveKeyEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_SaveKeyEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SaveKeyEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_SaveKeyEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_SAVEKEYEX, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_SaveKeyEx_state {
	struct winreg_SaveKeyEx orig;
	struct winreg_SaveKeyEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_SaveKeyEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_SaveKeyEx_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						struct winreg_String *_filename /* [in] [ref] */,
						struct KeySecurityAttribute *_sec_attrib /* [in] [unique] */,
						uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_SaveKeyEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_SaveKeyEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.filename = _filename;
	state->orig.in.sec_attrib = _sec_attrib;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_SaveKeyEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_SaveKeyEx_done, req);
	return req;
}

static void dcerpc_winreg_SaveKeyEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_SaveKeyEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SaveKeyEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_SaveKeyEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_SaveKeyEx_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_winreg_SaveKeyEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_SaveKeyEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_SaveKeyEx(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 struct winreg_String *_filename /* [in] [ref] */,
				 struct KeySecurityAttribute *_sec_attrib /* [in] [unique] */,
				 uint32_t _flags /* [in]  */,
				 WERROR *result)
{
	struct winreg_SaveKeyEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.filename = _filename;
	r.in.sec_attrib = _sec_attrib;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_SaveKeyEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKPT_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPT_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPT_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKPT *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPT_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPT_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPT_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKPT_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPT_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKPT_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKPT_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPT_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKPT *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPT, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKPT_state {
	struct winreg_OpenHKPT orig;
	struct winreg_OpenHKPT tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPT_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPT_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPT_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPT_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKPT_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKPT_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPT_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKPT_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKPT_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPT_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKPT_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPT_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKPT_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPT_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPT(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKPT r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKPT_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_OpenHKPN_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPN_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPN_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_OpenHKPN *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPN_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPN_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPN_r_done, req);

	return req;
}

static void dcerpc_winreg_OpenHKPN_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPN_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_OpenHKPN_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_OpenHKPN_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPN_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_OpenHKPN *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_OPENHKPN, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_OpenHKPN_state {
	struct winreg_OpenHKPN orig;
	struct winreg_OpenHKPN tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_OpenHKPN_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_OpenHKPN_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint16_t *_system_name /* [in] [unique] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_OpenHKPN_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_OpenHKPN_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_OpenHKPN_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_OpenHKPN_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_OpenHKPN_done, req);
	return req;
}

static void dcerpc_winreg_OpenHKPN_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_OpenHKPN_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPN_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_OpenHKPN_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_OpenHKPN_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_winreg_OpenHKPN_state *state = tevent_req_data(
		req, struct dcerpc_winreg_OpenHKPN_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_OpenHKPN(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint16_t *_system_name /* [in] [unique] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_handle /* [out] [ref] */,
				WERROR *result)
{
	struct winreg_OpenHKPN r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_OpenHKPN_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_QueryMultipleValues2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryMultipleValues2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryMultipleValues2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_QueryMultipleValues2 *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryMultipleValues2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryMultipleValues2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYMULTIPLEVALUES2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryMultipleValues2_r_done, req);

	return req;
}

static void dcerpc_winreg_QueryMultipleValues2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryMultipleValues2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_QueryMultipleValues2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_QueryMultipleValues2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryMultipleValues2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_QueryMultipleValues2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_QUERYMULTIPLEVALUES2, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_QueryMultipleValues2_state {
	struct winreg_QueryMultipleValues2 orig;
	struct winreg_QueryMultipleValues2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_QueryMultipleValues2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_QueryMultipleValues2_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_key_handle /* [in] [ref] */,
							   struct QueryMultipleValue *_values_in /* [in] [ref,length_is(num_values),size_is(num_values)] */,
							   struct QueryMultipleValue *_values_out /* [out] [ref,length_is(num_values),size_is(num_values)] */,
							   uint32_t _num_values /* [in]  */,
							   uint8_t *_buffer /* [in,out] [unique,length_is(*offered),size_is(*offered)] */,
							   uint32_t *_offered /* [in] [ref] */,
							   uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_QueryMultipleValues2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_QueryMultipleValues2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.key_handle = _key_handle;
	state->orig.in.values_in = _values_in;
	state->orig.in.num_values = _num_values;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.values_out = _values_out;
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_winreg_QueryMultipleValues2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_QueryMultipleValues2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_QueryMultipleValues2_done, req);
	return req;
}

static void dcerpc_winreg_QueryMultipleValues2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_QueryMultipleValues2_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryMultipleValues2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_QueryMultipleValues2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_values_out;
		_copy_len_values_out = state->tmp.in.num_values;
		memcpy(state->orig.out.values_out, state->tmp.out.values_out, _copy_len_values_out * sizeof(*state->orig.out.values_out));
	}
	if (state->orig.out.buffer && state->tmp.out.buffer) {
		{
			size_t _copy_len_buffer;
			_copy_len_buffer = *state->tmp.in.offered;
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_QueryMultipleValues2_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_winreg_QueryMultipleValues2_state *state = tevent_req_data(
		req, struct dcerpc_winreg_QueryMultipleValues2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_QueryMultipleValues2(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_key_handle /* [in] [ref] */,
					    struct QueryMultipleValue *_values_in /* [in] [ref,length_is(num_values),size_is(num_values)] */,
					    struct QueryMultipleValue *_values_out /* [out] [ref,length_is(num_values),size_is(num_values)] */,
					    uint32_t _num_values /* [in]  */,
					    uint8_t *_buffer /* [in,out] [unique,length_is(*offered),size_is(*offered)] */,
					    uint32_t *_offered /* [in] [ref] */,
					    uint32_t *_needed /* [out] [ref] */,
					    WERROR *result)
{
	struct winreg_QueryMultipleValues2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.key_handle = _key_handle;
	r.in.values_in = _values_in;
	r.in.num_values = _num_values;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.values_out = _values_out;
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_QueryMultipleValues2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_values_out;
		_copy_len_values_out = r.in.num_values;
		memcpy(_values_out, r.out.values_out, _copy_len_values_out * sizeof(*_values_out));
	}
	if (_buffer && r.out.buffer) {
		{
			size_t _copy_len_buffer;
			_copy_len_buffer = *r.in.offered;
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_winreg_DeleteKeyEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteKeyEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteKeyEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct winreg_DeleteKeyEx *r)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteKeyEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteKeyEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEKEYEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteKeyEx_r_done, req);

	return req;
}

static void dcerpc_winreg_DeleteKeyEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteKeyEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_winreg_DeleteKeyEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_winreg_DeleteKeyEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteKeyEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct winreg_DeleteKeyEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_winreg,
			NDR_WINREG_DELETEKEYEX, mem_ctx, r);

	return status;
}

struct dcerpc_winreg_DeleteKeyEx_state {
	struct winreg_DeleteKeyEx orig;
	struct winreg_DeleteKeyEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_winreg_DeleteKeyEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_winreg_DeleteKeyEx_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct winreg_String *_key /* [in] [ref] */,
						  uint32_t _access_mask /* [in]  */,
						  uint32_t _reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_winreg_DeleteKeyEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_winreg_DeleteKeyEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key = _key;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_winreg_DeleteKeyEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_winreg_DeleteKeyEx_done, req);
	return req;
}

static void dcerpc_winreg_DeleteKeyEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_winreg_DeleteKeyEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteKeyEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_winreg_DeleteKeyEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_winreg_DeleteKeyEx_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_winreg_DeleteKeyEx_state *state = tevent_req_data(
		req, struct dcerpc_winreg_DeleteKeyEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_winreg_DeleteKeyEx(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   struct winreg_String *_key /* [in] [ref] */,
				   uint32_t _access_mask /* [in]  */,
				   uint32_t _reserved /* [in]  */,
				   WERROR *result)
{
	struct winreg_DeleteKeyEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key = _key;
	r.in.access_mask = _access_mask;
	r.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_winreg_DeleteKeyEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

