/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_eventlog6.h"
#include "autoconf/librpc/gen_ndr/ndr_eventlog6_c.h"

/* eventlog6 - client functions generated by pidl */

struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERREMOTESUBSCRIPTION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERREMOTESUBSCRIPTION, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state {
	struct eventlog6_EvtRpcRegisterRemoteSubscription orig;
	struct eventlog6_EvtRpcRegisterRemoteSubscription tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_send(TALLOC_CTX *mem_ctx,
									  struct tevent_context *ev,
									  struct dcerpc_binding_handle *h,
									  const char *_channelPath /* [in] [unique,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
									  const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
									  const char *_bookmarkXml /* [in] [unique,range(0,MAX_RPC_BOOKMARK_LENGTH),charset(UTF16)] */,
									  uint32_t _flags /* [in]  */,
									  struct policy_handle *_handle /* [out] [ref] */,
									  struct policy_handle *_control /* [out] [ref] */,
									  uint32_t *_queryChannelInfoSize /* [out] [ref] */,
									  struct eventlog6_EvtRpcQueryChannelInfo **_queryChannelInfo /* [out] [ref,range(0,MAX_RPC_QUERY_CHANNEL_SIZE),size_is(,*queryChannelInfoSize)] */,
									  struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.channelPath = _channelPath;
	state->orig.in.query = _query;
	state->orig.in.bookmarkXml = _bookmarkXml;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.handle = _handle;
	state->orig.out.control = _control;
	state->orig.out.queryChannelInfoSize = _queryChannelInfoSize;
	state->orig.out.queryChannelInfo = _queryChannelInfo;
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;
	*state->orig.out.control = *state->tmp.out.control;
	*state->orig.out.queryChannelInfoSize = *state->tmp.out.queryChannelInfoSize;
	*state->orig.out.queryChannelInfo = *state->tmp.out.queryChannelInfo;
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_recv(struct tevent_req *req,
								TALLOC_CTX *mem_ctx,
								WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription(struct dcerpc_binding_handle *h,
							   TALLOC_CTX *mem_ctx,
							   const char *_channelPath /* [in] [unique,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							   const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
							   const char *_bookmarkXml /* [in] [unique,range(0,MAX_RPC_BOOKMARK_LENGTH),charset(UTF16)] */,
							   uint32_t _flags /* [in]  */,
							   struct policy_handle *_handle /* [out] [ref] */,
							   struct policy_handle *_control /* [out] [ref] */,
							   uint32_t *_queryChannelInfoSize /* [out] [ref] */,
							   struct eventlog6_EvtRpcQueryChannelInfo **_queryChannelInfo /* [out] [ref,range(0,MAX_RPC_QUERY_CHANNEL_SIZE),size_is(,*queryChannelInfoSize)] */,
							   struct eventlog6_RpcInfo *_error /* [out] [ref] */,
							   WERROR *result)
{
	struct eventlog6_EvtRpcRegisterRemoteSubscription r;
	NTSTATUS status;

	/* In parameters */
	r.in.channelPath = _channelPath;
	r.in.query = _query;
	r.in.bookmarkXml = _bookmarkXml;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;
	*_control = *r.out.control;
	*_queryChannelInfoSize = *r.out.queryChannelInfoSize;
	*_queryChannelInfo = *r.out.queryChannelInfo;
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONNEXTASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONNEXTASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state {
	struct eventlog6_EvtRpcRemoteSubscriptionNextAsync orig;
	struct eventlog6_EvtRpcRemoteSubscriptionNextAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_send(TALLOC_CTX *mem_ctx,
									   struct tevent_context *ev,
									   struct dcerpc_binding_handle *h,
									   struct policy_handle *_handle /* [in] [ref] */,
									   uint32_t _numRequestedRecords /* [in]  */,
									   uint32_t _flags /* [in]  */,
									   uint32_t *_numActualRecords /* [out] [ref] */,
									   uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
									   uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
									   uint32_t *_resultBufferSize /* [out] [ref] */,
									   uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.numRequestedRecords = _numRequestedRecords;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numActualRecords = _numActualRecords;
	state->orig.out.eventDataIndices = _eventDataIndices;
	state->orig.out.eventDataSizes = _eventDataSizes;
	state->orig.out.resultBufferSize = _resultBufferSize;
	state->orig.out.resultBuffer = _resultBuffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numActualRecords = *state->tmp.out.numActualRecords;
	*state->orig.out.eventDataIndices = *state->tmp.out.eventDataIndices;
	*state->orig.out.eventDataSizes = *state->tmp.out.eventDataSizes;
	*state->orig.out.resultBufferSize = *state->tmp.out.resultBufferSize;
	*state->orig.out.resultBuffer = *state->tmp.out.resultBuffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_recv(struct tevent_req *req,
								 TALLOC_CTX *mem_ctx,
								 WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync(struct dcerpc_binding_handle *h,
							    TALLOC_CTX *mem_ctx,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _numRequestedRecords /* [in]  */,
							    uint32_t _flags /* [in]  */,
							    uint32_t *_numActualRecords /* [out] [ref] */,
							    uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
							    uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
							    uint32_t *_resultBufferSize /* [out] [ref] */,
							    uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */,
							    WERROR *result)
{
	struct eventlog6_EvtRpcRemoteSubscriptionNextAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.numRequestedRecords = _numRequestedRecords;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numActualRecords = *r.out.numActualRecords;
	*_eventDataIndices = *r.out.eventDataIndices;
	*_eventDataSizes = *r.out.eventDataSizes;
	*_resultBufferSize = *r.out.resultBufferSize;
	*_resultBuffer = *r.out.resultBuffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONNEXT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONNEXT, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state {
	struct eventlog6_EvtRpcRemoteSubscriptionNext orig;
	struct eventlog6_EvtRpcRemoteSubscriptionNext tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct dcerpc_binding_handle *h,
								      struct policy_handle *_handle /* [in] [ref] */,
								      uint32_t _numRequestedRecords /* [in]  */,
								      uint32_t _timeOut /* [in]  */,
								      uint32_t _flags /* [in]  */,
								      uint32_t *_numActualRecords /* [out] [ref] */,
								      uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
								      uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
								      uint32_t *_resultBufferSize /* [out] [ref] */,
								      uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.numRequestedRecords = _numRequestedRecords;
	state->orig.in.timeOut = _timeOut;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numActualRecords = _numActualRecords;
	state->orig.out.eventDataIndices = _eventDataIndices;
	state->orig.out.eventDataSizes = _eventDataSizes;
	state->orig.out.resultBufferSize = _resultBufferSize;
	state->orig.out.resultBuffer = _resultBuffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numActualRecords = *state->tmp.out.numActualRecords;
	*state->orig.out.eventDataIndices = *state->tmp.out.eventDataIndices;
	*state->orig.out.eventDataSizes = *state->tmp.out.eventDataSizes;
	*state->orig.out.resultBufferSize = *state->tmp.out.resultBufferSize;
	*state->orig.out.resultBuffer = *state->tmp.out.resultBuffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext(struct dcerpc_binding_handle *h,
						       TALLOC_CTX *mem_ctx,
						       struct policy_handle *_handle /* [in] [ref] */,
						       uint32_t _numRequestedRecords /* [in]  */,
						       uint32_t _timeOut /* [in]  */,
						       uint32_t _flags /* [in]  */,
						       uint32_t *_numActualRecords /* [out] [ref] */,
						       uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
						       uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
						       uint32_t *_resultBufferSize /* [out] [ref] */,
						       uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */,
						       WERROR *result)
{
	struct eventlog6_EvtRpcRemoteSubscriptionNext r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.numRequestedRecords = _numRequestedRecords;
	r.in.timeOut = _timeOut;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numActualRecords = *r.out.numActualRecords;
	*_eventDataIndices = *r.out.eventDataIndices;
	*_eventDataSizes = *r.out.eventDataSizes;
	*_resultBufferSize = *r.out.resultBufferSize;
	*_resultBuffer = *r.out.resultBuffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONWAITASYNC, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREMOTESUBSCRIPTIONWAITASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state {
	struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync orig;
	struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_send(TALLOC_CTX *mem_ctx,
									   struct tevent_context *ev,
									   struct dcerpc_binding_handle *h,
									   struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_recv(struct tevent_req *req,
								 TALLOC_CTX *mem_ctx,
								 WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync(struct dcerpc_binding_handle *h,
							    TALLOC_CTX *mem_ctx,
							    struct policy_handle *_handle /* [in] [ref] */,
							    WERROR *result)
{
	struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERCONTROLLABLEOPERATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERCONTROLLABLEOPERATION, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state {
	struct eventlog6_EvtRpcRegisterControllableOperation orig;
	struct eventlog6_EvtRpcRegisterControllableOperation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterControllableOperation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterControllableOperation_send(TALLOC_CTX *mem_ctx,
									     struct tevent_context *ev,
									     struct dcerpc_binding_handle *h,
									     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcRegisterControllableOperation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterControllableOperation_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterControllableOperation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterControllableOperation_recv(struct tevent_req *req,
								   TALLOC_CTX *mem_ctx,
								   WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterControllableOperation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterControllableOperation(struct dcerpc_binding_handle *h,
							      TALLOC_CTX *mem_ctx,
							      struct policy_handle *_handle /* [out] [ref] */,
							      WERROR *result)
{
	struct eventlog6_EvtRpcRegisterControllableOperation r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERLOGQUERY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterLogQuery_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCREGISTERLOGQUERY, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state {
	struct eventlog6_EvtRpcRegisterLogQuery orig;
	struct eventlog6_EvtRpcRegisterLogQuery tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRegisterLogQuery_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRegisterLogQuery_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_path /* [in] [unique,range(0,MAX_RPC_CHANNEL_PATH_LENGTH),charset(UTF16)] */,
								const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
								uint32_t _flags /* [in]  */,
								struct policy_handle *_handle /* [out] [ref] */,
								struct policy_handle *_opControl /* [out] [ref] */,
								uint32_t *_queryChannelInfoSize /* [out] [ref] */,
								struct eventlog6_EvtRpcQueryChannelInfo **_queryChannelInfo /* [out] [ref,range(0,MAX_RPC_QUERY_CHANNEL_SIZE),size_is(,*queryChannelInfoSize)] */,
								struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.query = _query;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.handle = _handle;
	state->orig.out.opControl = _opControl;
	state->orig.out.queryChannelInfoSize = _queryChannelInfoSize;
	state->orig.out.queryChannelInfo = _queryChannelInfo;
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcRegisterLogQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRegisterLogQuery_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRegisterLogQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRegisterLogQuery_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;
	*state->orig.out.opControl = *state->tmp.out.opControl;
	*state->orig.out.queryChannelInfoSize = *state->tmp.out.queryChannelInfoSize;
	*state->orig.out.queryChannelInfo = *state->tmp.out.queryChannelInfo;
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterLogQuery_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRegisterLogQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRegisterLogQuery(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_path /* [in] [unique,range(0,MAX_RPC_CHANNEL_PATH_LENGTH),charset(UTF16)] */,
						 const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
						 uint32_t _flags /* [in]  */,
						 struct policy_handle *_handle /* [out] [ref] */,
						 struct policy_handle *_opControl /* [out] [ref] */,
						 uint32_t *_queryChannelInfoSize /* [out] [ref] */,
						 struct eventlog6_EvtRpcQueryChannelInfo **_queryChannelInfo /* [out] [ref,range(0,MAX_RPC_QUERY_CHANNEL_SIZE),size_is(,*queryChannelInfoSize)] */,
						 struct eventlog6_RpcInfo *_error /* [out] [ref] */,
						 WERROR *result)
{
	struct eventlog6_EvtRpcRegisterLogQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = _path;
	r.in.query = _query;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcRegisterLogQuery_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;
	*_opControl = *r.out.opControl;
	*_queryChannelInfoSize = *r.out.queryChannelInfoSize;
	*_queryChannelInfo = *r.out.queryChannelInfo;
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcClearLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcClearLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcClearLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcClearLog *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcClearLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcClearLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCLEARLOG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcClearLog_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcClearLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcClearLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcClearLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcClearLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcClearLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcClearLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCLEARLOG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcClearLog_state {
	struct eventlog6_EvtRpcClearLog orig;
	struct eventlog6_EvtRpcClearLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcClearLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcClearLog_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_control /* [in] [ref] */,
							const char *_channelPath /* [in] [ref,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							const char *_backupPath /* [in] [unique,range(0,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
							uint32_t _flags /* [in]  */,
							struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcClearLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcClearLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.control = _control;
	state->orig.in.channelPath = _channelPath;
	state->orig.in.backupPath = _backupPath;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcClearLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcClearLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcClearLog_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcClearLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcClearLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcClearLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcClearLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcClearLog_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcClearLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcClearLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcClearLog(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_control /* [in] [ref] */,
					 const char *_channelPath /* [in] [ref,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
					 const char *_backupPath /* [in] [unique,range(0,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
					 uint32_t _flags /* [in]  */,
					 struct eventlog6_RpcInfo *_error /* [out] [ref] */,
					 WERROR *result)
{
	struct eventlog6_EvtRpcClearLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.control = _control;
	r.in.channelPath = _channelPath;
	r.in.backupPath = _backupPath;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcClearLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcExportLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcExportLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcExportLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcExportLog *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcExportLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcExportLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCEXPORTLOG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcExportLog_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcExportLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcExportLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcExportLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcExportLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcExportLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcExportLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCEXPORTLOG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcExportLog_state {
	struct eventlog6_EvtRpcExportLog orig;
	struct eventlog6_EvtRpcExportLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcExportLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcExportLog_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_control /* [in] [ref] */,
							 const char *_channelPath /* [in] [unique,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							 const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
							 const char *_backupPath /* [in] [ref,range(1,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
							 uint32_t _flags /* [in]  */,
							 struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcExportLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcExportLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.control = _control;
	state->orig.in.channelPath = _channelPath;
	state->orig.in.query = _query;
	state->orig.in.backupPath = _backupPath;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcExportLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcExportLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcExportLog_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcExportLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcExportLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcExportLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcExportLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcExportLog_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcExportLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcExportLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcExportLog(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_control /* [in] [ref] */,
					  const char *_channelPath /* [in] [unique,range(0,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
					  const char *_query /* [in] [ref,range(1,MAX_RPC_QUERY_LENGTH),charset(UTF16)] */,
					  const char *_backupPath /* [in] [ref,range(1,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
					  uint32_t _flags /* [in]  */,
					  struct eventlog6_RpcInfo *_error /* [out] [ref] */,
					  WERROR *result)
{
	struct eventlog6_EvtRpcExportLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.control = _control;
	r.in.channelPath = _channelPath;
	r.in.query = _query;
	r.in.backupPath = _backupPath;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcExportLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCLOCALIZEEXPORTLOG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcLocalizeExportLog_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCLOCALIZEEXPORTLOG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state {
	struct eventlog6_EvtRpcLocalizeExportLog orig;
	struct eventlog6_EvtRpcLocalizeExportLog tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcLocalizeExportLog_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcLocalizeExportLog_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle *_control /* [in] [ref] */,
								 const char *_logFilePath /* [in] [ref,range(1,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
								 uint32_t _locale /* [in]  */,
								 uint32_t _flags /* [in]  */,
								 struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.control = _control;
	state->orig.in.logFilePath = _logFilePath;
	state->orig.in.locale = _locale;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcLocalizeExportLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcLocalizeExportLog_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcLocalizeExportLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcLocalizeExportLog_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcLocalizeExportLog_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcLocalizeExportLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcLocalizeExportLog(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *_control /* [in] [ref] */,
						  const char *_logFilePath /* [in] [ref,range(1,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
						  uint32_t _locale /* [in]  */,
						  uint32_t _flags /* [in]  */,
						  struct eventlog6_RpcInfo *_error /* [out] [ref] */,
						  WERROR *result)
{
	struct eventlog6_EvtRpcLocalizeExportLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.control = _control;
	r.in.logFilePath = _logFilePath;
	r.in.locale = _locale;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcLocalizeExportLog_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcMessageRender_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcMessageRender_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcMessageRender_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcMessageRender *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcMessageRender_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcMessageRender_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCMESSAGERENDER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcMessageRender_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcMessageRender_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRender_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcMessageRender_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcMessageRender_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRender_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcMessageRender *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCMESSAGERENDER, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcMessageRender_state {
	struct eventlog6_EvtRpcMessageRender orig;
	struct eventlog6_EvtRpcMessageRender tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcMessageRender_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcMessageRender_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_pubCfgObj /* [in] [ref] */,
							     uint32_t _sizeEventId /* [in] [range(1,MAX_RPC_EVENT_ID_SIZE)] */,
							     uint8_t *_eventId /* [in] [ref,size_is(sizeEventId)] */,
							     uint32_t _messageId /* [in]  */,
							     struct eventlog6_EvtRpcVariantList *_values /* [in] [ref] */,
							     uint32_t _flags /* [in]  */,
							     uint32_t _maxSizeString /* [in]  */,
							     uint32_t *_actualSizeString /* [out] [ref] */,
							     uint32_t *_neededSizeString /* [out] [ref] */,
							     uint8_t **_string /* [out] [ref,range(0,MAX_RPC_RENDERED_STRING_SIZE),size_is(,*actualSizeString)] */,
							     struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcMessageRender_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcMessageRender_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pubCfgObj = _pubCfgObj;
	state->orig.in.sizeEventId = _sizeEventId;
	state->orig.in.eventId = _eventId;
	state->orig.in.messageId = _messageId;
	state->orig.in.values = _values;
	state->orig.in.flags = _flags;
	state->orig.in.maxSizeString = _maxSizeString;

	/* Out parameters */
	state->orig.out.actualSizeString = _actualSizeString;
	state->orig.out.neededSizeString = _neededSizeString;
	state->orig.out.string = _string;
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcMessageRender_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcMessageRender_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcMessageRender_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcMessageRender_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcMessageRender_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcMessageRender_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcMessageRender_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.actualSizeString = *state->tmp.out.actualSizeString;
	*state->orig.out.neededSizeString = *state->tmp.out.neededSizeString;
	*state->orig.out.string = *state->tmp.out.string;
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRender_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcMessageRender_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcMessageRender_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRender(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_pubCfgObj /* [in] [ref] */,
					      uint32_t _sizeEventId /* [in] [range(1,MAX_RPC_EVENT_ID_SIZE)] */,
					      uint8_t *_eventId /* [in] [ref,size_is(sizeEventId)] */,
					      uint32_t _messageId /* [in]  */,
					      struct eventlog6_EvtRpcVariantList *_values /* [in] [ref] */,
					      uint32_t _flags /* [in]  */,
					      uint32_t _maxSizeString /* [in]  */,
					      uint32_t *_actualSizeString /* [out] [ref] */,
					      uint32_t *_neededSizeString /* [out] [ref] */,
					      uint8_t **_string /* [out] [ref,range(0,MAX_RPC_RENDERED_STRING_SIZE),size_is(,*actualSizeString)] */,
					      struct eventlog6_RpcInfo *_error /* [out] [ref] */,
					      WERROR *result)
{
	struct eventlog6_EvtRpcMessageRender r;
	NTSTATUS status;

	/* In parameters */
	r.in.pubCfgObj = _pubCfgObj;
	r.in.sizeEventId = _sizeEventId;
	r.in.eventId = _eventId;
	r.in.messageId = _messageId;
	r.in.values = _values;
	r.in.flags = _flags;
	r.in.maxSizeString = _maxSizeString;

	status = dcerpc_eventlog6_EvtRpcMessageRender_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_actualSizeString = *r.out.actualSizeString;
	*_neededSizeString = *r.out.neededSizeString;
	*_string = *r.out.string;
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCMESSAGERENDERDEFAULT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRenderDefault_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCMESSAGERENDERDEFAULT, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state {
	struct eventlog6_EvtRpcMessageRenderDefault orig;
	struct eventlog6_EvtRpcMessageRenderDefault tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcMessageRenderDefault_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcMessageRenderDefault_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    uint32_t _sizeEventId /* [in] [range(1,MAX_RPC_EVENT_ID_SIZE)] */,
								    uint8_t *_eventId /* [in] [ref,size_is(sizeEventId)] */,
								    uint32_t _messageId /* [in]  */,
								    struct eventlog6_EvtRpcVariantList *_values /* [in] [ref] */,
								    uint32_t _flags /* [in]  */,
								    uint32_t _maxSizeString /* [in]  */,
								    uint32_t *_actualSizeString /* [out] [ref] */,
								    uint32_t *_neededSizeString /* [out] [ref] */,
								    uint8_t **_string /* [out] [ref,range(0,MAX_RPC_RENDERED_STRING_SIZE),size_is(,*actualSizeString)] */,
								    struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sizeEventId = _sizeEventId;
	state->orig.in.eventId = _eventId;
	state->orig.in.messageId = _messageId;
	state->orig.in.values = _values;
	state->orig.in.flags = _flags;
	state->orig.in.maxSizeString = _maxSizeString;

	/* Out parameters */
	state->orig.out.actualSizeString = _actualSizeString;
	state->orig.out.neededSizeString = _neededSizeString;
	state->orig.out.string = _string;
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcMessageRenderDefault_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcMessageRenderDefault_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcMessageRenderDefault_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcMessageRenderDefault_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.actualSizeString = *state->tmp.out.actualSizeString;
	*state->orig.out.neededSizeString = *state->tmp.out.neededSizeString;
	*state->orig.out.string = *state->tmp.out.string;
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRenderDefault_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcMessageRenderDefault_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcMessageRenderDefault(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     uint32_t _sizeEventId /* [in] [range(1,MAX_RPC_EVENT_ID_SIZE)] */,
						     uint8_t *_eventId /* [in] [ref,size_is(sizeEventId)] */,
						     uint32_t _messageId /* [in]  */,
						     struct eventlog6_EvtRpcVariantList *_values /* [in] [ref] */,
						     uint32_t _flags /* [in]  */,
						     uint32_t _maxSizeString /* [in]  */,
						     uint32_t *_actualSizeString /* [out] [ref] */,
						     uint32_t *_neededSizeString /* [out] [ref] */,
						     uint8_t **_string /* [out] [ref,range(0,MAX_RPC_RENDERED_STRING_SIZE),size_is(,*actualSizeString)] */,
						     struct eventlog6_RpcInfo *_error /* [out] [ref] */,
						     WERROR *result)
{
	struct eventlog6_EvtRpcMessageRenderDefault r;
	NTSTATUS status;

	/* In parameters */
	r.in.sizeEventId = _sizeEventId;
	r.in.eventId = _eventId;
	r.in.messageId = _messageId;
	r.in.values = _values;
	r.in.flags = _flags;
	r.in.maxSizeString = _maxSizeString;

	status = dcerpc_eventlog6_EvtRpcMessageRenderDefault_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_actualSizeString = *r.out.actualSizeString;
	*_neededSizeString = *r.out.neededSizeString;
	*_string = *r.out.string;
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcQueryNext_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcQueryNext_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcQueryNext_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcQueryNext *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcQueryNext_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcQueryNext_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCQUERYNEXT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcQueryNext_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcQueryNext_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcQueryNext_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcQueryNext_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcQueryNext_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcQueryNext_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcQueryNext *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCQUERYNEXT, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcQueryNext_state {
	struct eventlog6_EvtRpcQueryNext orig;
	struct eventlog6_EvtRpcQueryNext tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcQueryNext_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcQueryNext_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_logQuery /* [in] [ref] */,
							 uint32_t _numRequestedRecords /* [in]  */,
							 uint32_t _timeOutEnd /* [in]  */,
							 uint32_t _flags /* [in]  */,
							 uint32_t *_numActualRecords /* [out] [ref] */,
							 uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
							 uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
							 uint32_t *_resultBufferSize /* [out] [ref] */,
							 uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcQueryNext_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcQueryNext_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logQuery = _logQuery;
	state->orig.in.numRequestedRecords = _numRequestedRecords;
	state->orig.in.timeOutEnd = _timeOutEnd;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numActualRecords = _numActualRecords;
	state->orig.out.eventDataIndices = _eventDataIndices;
	state->orig.out.eventDataSizes = _eventDataSizes;
	state->orig.out.resultBufferSize = _resultBufferSize;
	state->orig.out.resultBuffer = _resultBuffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcQueryNext_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcQueryNext_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcQueryNext_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcQueryNext_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcQueryNext_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcQueryNext_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcQueryNext_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numActualRecords = *state->tmp.out.numActualRecords;
	*state->orig.out.eventDataIndices = *state->tmp.out.eventDataIndices;
	*state->orig.out.eventDataSizes = *state->tmp.out.eventDataSizes;
	*state->orig.out.resultBufferSize = *state->tmp.out.resultBufferSize;
	*state->orig.out.resultBuffer = *state->tmp.out.resultBuffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcQueryNext_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcQueryNext_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcQueryNext_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcQueryNext(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_logQuery /* [in] [ref] */,
					  uint32_t _numRequestedRecords /* [in]  */,
					  uint32_t _timeOutEnd /* [in]  */,
					  uint32_t _flags /* [in]  */,
					  uint32_t *_numActualRecords /* [out] [ref] */,
					  uint32_t **_eventDataIndices /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
					  uint32_t **_eventDataSizes /* [out] [ref,range(0,MAX_RPC_RECORD_COUNT),size_is(,*numActualRecords)] */,
					  uint32_t *_resultBufferSize /* [out] [ref] */,
					  uint8_t **_resultBuffer /* [out] [ref,range(0,MAX_RPC_BATCH_SIZE),size_is(,*resultBufferSize)] */,
					  WERROR *result)
{
	struct eventlog6_EvtRpcQueryNext r;
	NTSTATUS status;

	/* In parameters */
	r.in.logQuery = _logQuery;
	r.in.numRequestedRecords = _numRequestedRecords;
	r.in.timeOutEnd = _timeOutEnd;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcQueryNext_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numActualRecords = *r.out.numActualRecords;
	*_eventDataIndices = *r.out.eventDataIndices;
	*_eventDataSizes = *r.out.eventDataSizes;
	*_resultBufferSize = *r.out.resultBufferSize;
	*_resultBuffer = *r.out.resultBuffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcQuerySeek_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcQuerySeek_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcQuerySeek_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcQuerySeek *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcQuerySeek_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcQuerySeek_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCQUERYSEEK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcQuerySeek_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcQuerySeek_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcQuerySeek_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcQuerySeek_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcQuerySeek_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcQuerySeek_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcQuerySeek *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCQUERYSEEK, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcQuerySeek_state {
	struct eventlog6_EvtRpcQuerySeek orig;
	struct eventlog6_EvtRpcQuerySeek tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcQuerySeek_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcQuerySeek_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_logQuery /* [in] [ref] */,
							 uint64_t _pos /* [in]  */,
							 const char *_bookmarkXml /* [in] [unique,range(0,MAX_RPC_BOOKMARK_LENGTH),charset(UTF16)] */,
							 uint32_t _timeOut /* [in]  */,
							 uint32_t _flags /* [in]  */,
							 struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcQuerySeek_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcQuerySeek_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logQuery = _logQuery;
	state->orig.in.pos = _pos;
	state->orig.in.bookmarkXml = _bookmarkXml;
	state->orig.in.timeOut = _timeOut;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcQuerySeek_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcQuerySeek_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcQuerySeek_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcQuerySeek_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcQuerySeek_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcQuerySeek_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcQuerySeek_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcQuerySeek_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcQuerySeek_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcQuerySeek_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcQuerySeek(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_logQuery /* [in] [ref] */,
					  uint64_t _pos /* [in]  */,
					  const char *_bookmarkXml /* [in] [unique,range(0,MAX_RPC_BOOKMARK_LENGTH),charset(UTF16)] */,
					  uint32_t _timeOut /* [in]  */,
					  uint32_t _flags /* [in]  */,
					  struct eventlog6_RpcInfo *_error /* [out] [ref] */,
					  WERROR *result)
{
	struct eventlog6_EvtRpcQuerySeek r;
	NTSTATUS status;

	/* In parameters */
	r.in.logQuery = _logQuery;
	r.in.pos = _pos;
	r.in.bookmarkXml = _bookmarkXml;
	r.in.timeOut = _timeOut;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcQuerySeek_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcClose_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcClose_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcClose_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcClose *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcClose_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcClose_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCLOSE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcClose_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcClose_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcClose_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcClose_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcClose_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcClose_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcClose *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCLOSE, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcClose_state {
	struct eventlog6_EvtRpcClose orig;
	struct eventlog6_EvtRpcClose tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcClose_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcClose_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle **_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcClose_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcClose_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcClose_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcClose_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcClose_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcClose_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcClose_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcClose_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcClose_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcClose_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcClose_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcClose_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcClose(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle **_handle /* [in,out] [ref] */,
				      WERROR *result)
{
	struct eventlog6_EvtRpcClose r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog6_EvtRpcClose_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcCancel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcCancel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcCancel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcCancel *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcCancel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcCancel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCANCEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcCancel_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcCancel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcCancel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcCancel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcCancel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcCancel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcCancel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCCANCEL, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcCancel_state {
	struct eventlog6_EvtRpcCancel orig;
	struct eventlog6_EvtRpcCancel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcCancel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcCancel_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcCancel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcCancel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcCancel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcCancel_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcCancel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcCancel_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcCancel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcCancel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcCancel_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcCancel_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcCancel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcCancel(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       WERROR *result)
{
	struct eventlog6_EvtRpcCancel r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_eventlog6_EvtRpcCancel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcAssertConfig_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcAssertConfig_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcAssertConfig_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcAssertConfig *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcAssertConfig_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcAssertConfig_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCASSERTCONFIG, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcAssertConfig_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcAssertConfig_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcAssertConfig_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcAssertConfig_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcAssertConfig_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcAssertConfig_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcAssertConfig *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCASSERTCONFIG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcAssertConfig_state {
	struct eventlog6_EvtRpcAssertConfig orig;
	struct eventlog6_EvtRpcAssertConfig tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcAssertConfig_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcAssertConfig_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_path /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							    uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcAssertConfig_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcAssertConfig_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcAssertConfig_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcAssertConfig_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcAssertConfig_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcAssertConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcAssertConfig_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcAssertConfig_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcAssertConfig_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcAssertConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcAssertConfig_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcAssertConfig(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_path /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
					     uint32_t _flags /* [in]  */,
					     WERROR *result)
{
	struct eventlog6_EvtRpcAssertConfig r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = _path;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcAssertConfig_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcRetractConfig_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRetractConfig_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRetractConfig_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcRetractConfig *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRetractConfig_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRetractConfig_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCRETRACTCONFIG, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRetractConfig_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcRetractConfig_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRetractConfig_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcRetractConfig_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcRetractConfig_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRetractConfig_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcRetractConfig *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCRETRACTCONFIG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcRetractConfig_state {
	struct eventlog6_EvtRpcRetractConfig orig;
	struct eventlog6_EvtRpcRetractConfig tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcRetractConfig_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcRetractConfig_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_path /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							     uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcRetractConfig_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcRetractConfig_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcRetractConfig_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcRetractConfig_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcRetractConfig_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcRetractConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRetractConfig_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcRetractConfig_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcRetractConfig_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcRetractConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcRetractConfig_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcRetractConfig(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_path /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
					      uint32_t _flags /* [in]  */,
					      WERROR *result)
{
	struct eventlog6_EvtRpcRetractConfig r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = _path;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcRetractConfig_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcOpenLogHandle_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcOpenLogHandle_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcOpenLogHandle_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcOpenLogHandle *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcOpenLogHandle_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcOpenLogHandle_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCOPENLOGHANDLE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcOpenLogHandle_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcOpenLogHandle_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcOpenLogHandle_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcOpenLogHandle_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcOpenLogHandle_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcOpenLogHandle_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcOpenLogHandle *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCOPENLOGHANDLE, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state {
	struct eventlog6_EvtRpcOpenLogHandle orig;
	struct eventlog6_EvtRpcOpenLogHandle tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcOpenLogHandle_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcOpenLogHandle_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_channel /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							     uint32_t _flags /* [in]  */,
							     struct policy_handle *_handle /* [out] [ref] */,
							     struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.channel = _channel;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.handle = _handle;
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcOpenLogHandle_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcOpenLogHandle_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcOpenLogHandle_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcOpenLogHandle_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcOpenLogHandle_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcOpenLogHandle_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcOpenLogHandle_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcOpenLogHandle(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_channel /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
					      uint32_t _flags /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */,
					      struct eventlog6_RpcInfo *_error /* [out] [ref] */,
					      WERROR *result)
{
	struct eventlog6_EvtRpcOpenLogHandle r;
	NTSTATUS status;

	/* In parameters */
	r.in.channel = _channel;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcOpenLogHandle_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETLOGFILEINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetLogFileInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETLOGFILEINFO, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state {
	struct eventlog6_EvtRpcGetLogFileInfo orig;
	struct eventlog6_EvtRpcGetLogFileInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetLogFileInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetLogFileInfo_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_logHandle /* [in] [ref] */,
							      uint32_t _propertyId /* [in]  */,
							      uint32_t _propertyValueBufferSize /* [in] [range(0,MAX_RPC_PROPERTY_BUFFER_SIZE)] */,
							      uint8_t *_propertyValueBuffer /* [out] [ref,size_is(propertyValueBufferSize)] */,
							      uint32_t *_propertyValueBufferLength /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logHandle = _logHandle;
	state->orig.in.propertyId = _propertyId;
	state->orig.in.propertyValueBufferSize = _propertyValueBufferSize;

	/* Out parameters */
	state->orig.out.propertyValueBuffer = _propertyValueBuffer;
	state->orig.out.propertyValueBufferLength = _propertyValueBufferLength;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetLogFileInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetLogFileInfo_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetLogFileInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetLogFileInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_propertyValueBuffer;
		_copy_len_propertyValueBuffer = state->tmp.in.propertyValueBufferSize;
		memcpy(state->orig.out.propertyValueBuffer, state->tmp.out.propertyValueBuffer, _copy_len_propertyValueBuffer * sizeof(*state->orig.out.propertyValueBuffer));
	}
	*state->orig.out.propertyValueBufferLength = *state->tmp.out.propertyValueBufferLength;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetLogFileInfo_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetLogFileInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetLogFileInfo(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_logHandle /* [in] [ref] */,
					       uint32_t _propertyId /* [in]  */,
					       uint32_t _propertyValueBufferSize /* [in] [range(0,MAX_RPC_PROPERTY_BUFFER_SIZE)] */,
					       uint8_t *_propertyValueBuffer /* [out] [ref,size_is(propertyValueBufferSize)] */,
					       uint32_t *_propertyValueBufferLength /* [out] [ref] */,
					       WERROR *result)
{
	struct eventlog6_EvtRpcGetLogFileInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.logHandle = _logHandle;
	r.in.propertyId = _propertyId;
	r.in.propertyValueBufferSize = _propertyValueBufferSize;

	status = dcerpc_eventlog6_EvtRpcGetLogFileInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_propertyValueBuffer;
		_copy_len_propertyValueBuffer = r.in.propertyValueBufferSize;
		memcpy(_propertyValueBuffer, r.out.propertyValueBuffer, _copy_len_propertyValueBuffer * sizeof(*_propertyValueBuffer));
	}
	*_propertyValueBufferLength = *r.out.propertyValueBufferLength;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetChannelList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetChannelList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetChannelList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetChannelList *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetChannelList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetChannelList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCHANNELLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetChannelList_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetChannelList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetChannelList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetChannelList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetChannelList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCHANNELLIST, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetChannelList_state {
	struct eventlog6_EvtRpcGetChannelList orig;
	struct eventlog6_EvtRpcGetChannelList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetChannelList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetChannelList_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      uint32_t _flags /* [in]  */,
							      uint32_t *_numChannelPaths /* [out] [ref] */,
							      const char ***_channelPaths /* [out] [ref,range(0,MAX_RPC_CHANNEL_COUNT),charset(UTF16),size_is(,*numChannelPaths)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetChannelList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetChannelList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numChannelPaths = _numChannelPaths;
	state->orig.out.channelPaths = _channelPaths;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetChannelList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetChannelList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetChannelList_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetChannelList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetChannelList_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetChannelList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetChannelList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numChannelPaths = *state->tmp.out.numChannelPaths;
	*state->orig.out.channelPaths = *state->tmp.out.channelPaths;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelList_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetChannelList_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetChannelList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelList(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       uint32_t _flags /* [in]  */,
					       uint32_t *_numChannelPaths /* [out] [ref] */,
					       const char ***_channelPaths /* [out] [ref,range(0,MAX_RPC_CHANNEL_COUNT),charset(UTF16),size_is(,*numChannelPaths)] */,
					       WERROR *result)
{
	struct eventlog6_EvtRpcGetChannelList r;
	NTSTATUS status;

	/* In parameters */
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetChannelList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numChannelPaths = *r.out.numChannelPaths;
	*_channelPaths = *r.out.channelPaths;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetChannelConfig_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetChannelConfig_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetChannelConfig_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetChannelConfig *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetChannelConfig_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetChannelConfig_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCHANNELCONFIG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetChannelConfig_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetChannelConfig_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelConfig_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetChannelConfig_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetChannelConfig_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelConfig_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetChannelConfig *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCHANNELCONFIG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state {
	struct eventlog6_EvtRpcGetChannelConfig orig;
	struct eventlog6_EvtRpcGetChannelConfig tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetChannelConfig_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetChannelConfig_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_channelPath /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
								uint32_t _flags /* [in]  */,
								struct eventlog6_EvtRpcVariantList *_props /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.channelPath = _channelPath;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.props = _props;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetChannelConfig_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetChannelConfig_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetChannelConfig_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetChannelConfig_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetChannelConfig_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.props = *state->tmp.out.props;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelConfig_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetChannelConfig_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetChannelConfig(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_channelPath /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
						 uint32_t _flags /* [in]  */,
						 struct eventlog6_EvtRpcVariantList *_props /* [out] [ref] */,
						 WERROR *result)
{
	struct eventlog6_EvtRpcGetChannelConfig r;
	NTSTATUS status;

	/* In parameters */
	r.in.channelPath = _channelPath;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetChannelConfig_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_props = *r.out.props;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcPutChannelConfig_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcPutChannelConfig_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcPutChannelConfig_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcPutChannelConfig *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcPutChannelConfig_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcPutChannelConfig_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCPUTCHANNELCONFIG, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcPutChannelConfig_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcPutChannelConfig_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcPutChannelConfig_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcPutChannelConfig_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcPutChannelConfig_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcPutChannelConfig_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcPutChannelConfig *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCPUTCHANNELCONFIG, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state {
	struct eventlog6_EvtRpcPutChannelConfig orig;
	struct eventlog6_EvtRpcPutChannelConfig tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcPutChannelConfig_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcPutChannelConfig_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_channelPath /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
								uint32_t _flags /* [in]  */,
								struct eventlog6_EvtRpcVariantList *_props /* [in] [ref] */,
								struct eventlog6_RpcInfo *_error /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.channelPath = _channelPath;
	state->orig.in.flags = _flags;
	state->orig.in.props = _props;

	/* Out parameters */
	state->orig.out.error = _error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcPutChannelConfig_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcPutChannelConfig_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcPutChannelConfig_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcPutChannelConfig_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcPutChannelConfig_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.error = *state->tmp.out.error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcPutChannelConfig_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcPutChannelConfig_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcPutChannelConfig(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_channelPath /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
						 uint32_t _flags /* [in]  */,
						 struct eventlog6_EvtRpcVariantList *_props /* [in] [ref] */,
						 struct eventlog6_RpcInfo *_error /* [out] [ref] */,
						 WERROR *result)
{
	struct eventlog6_EvtRpcPutChannelConfig r;
	NTSTATUS status;

	/* In parameters */
	r.in.channelPath = _channelPath;
	r.in.flags = _flags;
	r.in.props = _props;

	status = dcerpc_eventlog6_EvtRpcPutChannelConfig_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_error = *r.out.error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetPublisherList *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherList_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetPublisherList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetPublisherList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERLIST, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherList_state {
	struct eventlog6_EvtRpcGetPublisherList orig;
	struct eventlog6_EvtRpcGetPublisherList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherList_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								uint32_t _flags /* [in]  */,
								uint32_t *_numPublisherIds /* [out] [ref] */,
								const char ***_publisherIds /* [out] [ref,range(0,MAX_RPC_PUBLISHER_COUNT),charset(UTF16),size_is(,*numPublisherIds)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numPublisherIds = _numPublisherIds;
	state->orig.out.publisherIds = _publisherIds;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetPublisherList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetPublisherList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherList_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetPublisherList_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetPublisherList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numPublisherIds = *state->tmp.out.numPublisherIds;
	*state->orig.out.publisherIds = *state->tmp.out.publisherIds;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherList_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherList_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherList(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 uint32_t _flags /* [in]  */,
						 uint32_t *_numPublisherIds /* [out] [ref] */,
						 const char ***_publisherIds /* [out] [ref,range(0,MAX_RPC_PUBLISHER_COUNT),charset(UTF16),size_is(,*numPublisherIds)] */,
						 WERROR *result)
{
	struct eventlog6_EvtRpcGetPublisherList r;
	NTSTATUS status;

	/* In parameters */
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetPublisherList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numPublisherIds = *r.out.numPublisherIds;
	*_publisherIds = *r.out.publisherIds;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERLISTFORCHANNEL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERLISTFORCHANNEL, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state {
	struct eventlog6_EvtRpcGetPublisherListForChannel orig;
	struct eventlog6_EvtRpcGetPublisherListForChannel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_send(TALLOC_CTX *mem_ctx,
									  struct tevent_context *ev,
									  struct dcerpc_binding_handle *h,
									  uint16_t *_channelName /* [in] [ref] */,
									  uint32_t _flags /* [in]  */,
									  uint32_t *_numPublisherIds /* [out] [ref] */,
									  const char ***_publisherIds /* [out] [ref,range(0,MAX_RPC_PUBLISHER_COUNT),charset(UTF16),size_is(,*numPublisherIds)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.channelName = _channelName;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.numPublisherIds = _numPublisherIds;
	state->orig.out.publisherIds = _publisherIds;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numPublisherIds = *state->tmp.out.numPublisherIds;
	*state->orig.out.publisherIds = *state->tmp.out.publisherIds;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_recv(struct tevent_req *req,
								TALLOC_CTX *mem_ctx,
								WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherListForChannel(struct dcerpc_binding_handle *h,
							   TALLOC_CTX *mem_ctx,
							   uint16_t *_channelName /* [in] [ref] */,
							   uint32_t _flags /* [in]  */,
							   uint32_t *_numPublisherIds /* [out] [ref] */,
							   const char ***_publisherIds /* [out] [ref,range(0,MAX_RPC_PUBLISHER_COUNT),charset(UTF16),size_is(,*numPublisherIds)] */,
							   WERROR *result)
{
	struct eventlog6_EvtRpcGetPublisherListForChannel r;
	NTSTATUS status;

	/* In parameters */
	r.in.channelName = _channelName;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numPublisherIds = *r.out.numPublisherIds;
	*_publisherIds = *r.out.publisherIds;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERMETADATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERMETADATA, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state {
	struct eventlog6_EvtRpcGetPublisherMetadata orig;
	struct eventlog6_EvtRpcGetPublisherMetadata tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherMetadata_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherMetadata_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    const char *_publisherId /* [in] [unique,range(0,MAX_RPC_PUBLISHER_ID_LENGTH),charset(UTF16)] */,
								    const char *_logFilePath /* [in] [unique,range(0,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
								    uint32_t _locale /* [in]  */,
								    uint32_t _flags /* [in]  */,
								    struct eventlog6_EvtRpcVariantList *_pubMetadataProps /* [out] [ref] */,
								    struct policy_handle *_pubMetadata /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.publisherId = _publisherId;
	state->orig.in.logFilePath = _logFilePath;
	state->orig.in.locale = _locale;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.pubMetadataProps = _pubMetadataProps;
	state->orig.out.pubMetadata = _pubMetadata;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetPublisherMetadata_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherMetadata_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherMetadata_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pubMetadataProps = *state->tmp.out.pubMetadataProps;
	*state->orig.out.pubMetadata = *state->tmp.out.pubMetadata;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherMetadata_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherMetadata_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherMetadata(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     const char *_publisherId /* [in] [unique,range(0,MAX_RPC_PUBLISHER_ID_LENGTH),charset(UTF16)] */,
						     const char *_logFilePath /* [in] [unique,range(0,MAX_RPC_FILE_PATH_LENGTH),charset(UTF16)] */,
						     uint32_t _locale /* [in]  */,
						     uint32_t _flags /* [in]  */,
						     struct eventlog6_EvtRpcVariantList *_pubMetadataProps /* [out] [ref] */,
						     struct policy_handle *_pubMetadata /* [out] [ref] */,
						     WERROR *result)
{
	struct eventlog6_EvtRpcGetPublisherMetadata r;
	NTSTATUS status;

	/* In parameters */
	r.in.publisherId = _publisherId;
	r.in.logFilePath = _logFilePath;
	r.in.locale = _locale;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pubMetadataProps = *r.out.pubMetadataProps;
	*_pubMetadata = *r.out.pubMetadata;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERRESOURCEMETADATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETPUBLISHERRESOURCEMETADATA, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state {
	struct eventlog6_EvtRpcGetPublisherResourceMetadata orig;
	struct eventlog6_EvtRpcGetPublisherResourceMetadata tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_send(TALLOC_CTX *mem_ctx,
									    struct tevent_context *ev,
									    struct dcerpc_binding_handle *h,
									    struct policy_handle *_handle /* [in] [ref] */,
									    uint32_t _propertyId /* [in]  */,
									    uint32_t _flags /* [in]  */,
									    struct eventlog6_EvtRpcVariantList *_pubMetadataProps /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.propertyId = _propertyId;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.pubMetadataProps = _pubMetadataProps;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pubMetadataProps = *state->tmp.out.pubMetadataProps;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_recv(struct tevent_req *req,
								  TALLOC_CTX *mem_ctx,
								  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata(struct dcerpc_binding_handle *h,
							     TALLOC_CTX *mem_ctx,
							     struct policy_handle *_handle /* [in] [ref] */,
							     uint32_t _propertyId /* [in]  */,
							     uint32_t _flags /* [in]  */,
							     struct eventlog6_EvtRpcVariantList *_pubMetadataProps /* [out] [ref] */,
							     WERROR *result)
{
	struct eventlog6_EvtRpcGetPublisherResourceMetadata r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.propertyId = _propertyId;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pubMetadataProps = *r.out.pubMetadataProps;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETEVENTMETADATAENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETEVENTMETADATAENUM, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state {
	struct eventlog6_EvtRpcGetEventMetadataEnum orig;
	struct eventlog6_EvtRpcGetEventMetadataEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle *_pubMetadata /* [in] [ref] */,
								    uint32_t _flags /* [in]  */,
								    const char *_reservedForFilter /* [in] [unique,range(0,MAX_RPC_FILTER_LENGTH),charset(UTF16)] */,
								    struct policy_handle *_eventMetaDataEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pubMetadata = _pubMetadata;
	state->orig.in.flags = _flags;
	state->orig.in.reservedForFilter = _reservedForFilter;

	/* Out parameters */
	state->orig.out.eventMetaDataEnum = _eventMetaDataEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.eventMetaDataEnum = *state->tmp.out.eventMetaDataEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetEventMetadataEnum(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle *_pubMetadata /* [in] [ref] */,
						     uint32_t _flags /* [in]  */,
						     const char *_reservedForFilter /* [in] [unique,range(0,MAX_RPC_FILTER_LENGTH),charset(UTF16)] */,
						     struct policy_handle *_eventMetaDataEnum /* [out] [ref] */,
						     WERROR *result)
{
	struct eventlog6_EvtRpcGetEventMetadataEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.pubMetadata = _pubMetadata;
	r.in.flags = _flags;
	r.in.reservedForFilter = _reservedForFilter;

	status = dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_eventMetaDataEnum = *r.out.eventMetaDataEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETNEXTEVENTMETADATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETNEXTEVENTMETADATA, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state {
	struct eventlog6_EvtRpcGetNextEventMetadata orig;
	struct eventlog6_EvtRpcGetNextEventMetadata tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetNextEventMetadata_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetNextEventMetadata_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct policy_handle *_eventMetaDataEnum /* [in] [ref] */,
								    uint32_t _flags /* [in]  */,
								    uint32_t _numRequested /* [in]  */,
								    uint32_t *_numReturned /* [out] [ref] */,
								    struct eventlog6_EvtRpcVariantList **_eventMetadataInstances /* [out] [ref,range(0,MAX_RPC_EVENT_METADATA_COUNT),size_is(,*numReturned)] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.eventMetaDataEnum = _eventMetaDataEnum;
	state->orig.in.flags = _flags;
	state->orig.in.numRequested = _numRequested;

	/* Out parameters */
	state->orig.out.numReturned = _numReturned;
	state->orig.out.eventMetadataInstances = _eventMetadataInstances;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetNextEventMetadata_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetNextEventMetadata_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetNextEventMetadata_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.numReturned = *state->tmp.out.numReturned;
	*state->orig.out.eventMetadataInstances = *state->tmp.out.eventMetadataInstances;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetNextEventMetadata_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetNextEventMetadata_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetNextEventMetadata(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct policy_handle *_eventMetaDataEnum /* [in] [ref] */,
						     uint32_t _flags /* [in]  */,
						     uint32_t _numRequested /* [in]  */,
						     uint32_t *_numReturned /* [out] [ref] */,
						     struct eventlog6_EvtRpcVariantList **_eventMetadataInstances /* [out] [ref,range(0,MAX_RPC_EVENT_METADATA_COUNT),size_is(,*numReturned)] */,
						     WERROR *result)
{
	struct eventlog6_EvtRpcGetNextEventMetadata r;
	NTSTATUS status;

	/* In parameters */
	r.in.eventMetaDataEnum = _eventMetaDataEnum;
	r.in.flags = _flags;
	r.in.numRequested = _numRequested;

	status = dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_numReturned = *r.out.numReturned;
	*_eventMetadataInstances = *r.out.eventMetadataInstances;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCLASSICLOGDISPLAYNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_done, req);

	return req;
}

static void dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_eventlog6,
			NDR_EVENTLOG6_EVTRPCGETCLASSICLOGDISPLAYNAME, mem_ctx, r);

	return status;
}

struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state {
	struct eventlog6_EvtRpcGetClassicLogDisplayName orig;
	struct eventlog6_EvtRpcGetClassicLogDisplayName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									const char *_logName /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
									uint32_t _locale /* [in]  */,
									uint32_t _flags /* [in]  */,
									uint16_t **_displayName /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.logName = _logName;
	state->orig.in.locale = _locale;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.displayName = _displayName;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_done, req);
	return req;
}

static void dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.displayName = *state->tmp.out.displayName;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result)
{
	struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state *state = tevent_req_data(
		req, struct dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 const char *_logName /* [in] [ref,range(1,MAX_RPC_CHANNEL_NAME_LENGTH),charset(UTF16)] */,
							 uint32_t _locale /* [in]  */,
							 uint32_t _flags /* [in]  */,
							 uint16_t **_displayName /* [out] [ref] */,
							 WERROR *result)
{
	struct eventlog6_EvtRpcGetClassicLogDisplayName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logName = _logName;
	r.in.locale = _locale;
	r.in.flags = _flags;

	status = dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_displayName = *r.out.displayName;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

