
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "librpc/gen_ndr/ndr_dns.h"
#include "librpc/gen_ndr/ndr_dns_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dns_name_question_Type;
staticforward PyTypeObject dns_rdata_data_Type;
staticforward PyTypeObject dns_soa_record_Type;
staticforward PyTypeObject dns_srv_record_Type;
staticforward PyTypeObject dns_mx_record_Type;
staticforward PyTypeObject dns_res_rec_Type;
staticforward PyTypeObject dns_name_packet_Type;
staticforward PyTypeObject dns_InterfaceType;

void initdns(void);static PyTypeObject *ClientConnection_Type;
static PyTypeObject *Object_Type;

static PyObject *py_dns_name_question_get_name(PyObject *obj, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_dns_name_question_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	object->name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_dns_name_question_get_question_type(PyObject *obj, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(obj);
	PyObject *py_question_type;
	py_question_type = PyInt_FromLong(object->question_type);
	return py_question_type;
}

static int py_dns_name_question_set_question_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->question_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->question_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dns_name_question_get_question_class(PyObject *obj, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(obj);
	PyObject *py_question_class;
	py_question_class = PyInt_FromLong(object->question_class);
	return py_question_class;
}

static int py_dns_name_question_set_question_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->question_class = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->question_class = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_dns_name_question_getsetters[] = {
	{ discard_const_p(char, "name"), py_dns_name_question_get_name, py_dns_name_question_set_name },
	{ discard_const_p(char, "question_type"), py_dns_name_question_get_question_type, py_dns_name_question_set_question_type },
	{ discard_const_p(char, "question_class"), py_dns_name_question_get_question_class, py_dns_name_question_set_question_class },
	{ NULL }
};

static PyObject *py_dns_name_question_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_name_question, type);
}

static PyObject *py_dns_name_question_ndr_pack(PyObject *py_obj)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dns_name_question);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dns_name_question_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_question);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_name_question_ndr_print(PyObject *py_obj)
{
	struct dns_name_question *object = (struct dns_name_question *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_name_question, "dns_name_question", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_name_question_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_name_question_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dns_name_question_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_name_question_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_name_question_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.name_question",
	.tp_getset = py_dns_name_question_getsetters,
	.tp_methods = py_dns_name_question_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_name_question_new,
};


static PyObject *py_dns_rdata_data_get_length(PyObject *obj, void *closure)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_dns_rdata_data_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_rdata_data_get_data(PyObject *obj, void *closure)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->length);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < object->length; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_dns_rdata_data_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1;; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dns_rdata_data_getsetters[] = {
	{ discard_const_p(char, "length"), py_dns_rdata_data_get_length, py_dns_rdata_data_set_length },
	{ discard_const_p(char, "data"), py_dns_rdata_data_get_data, py_dns_rdata_data_set_data },
	{ NULL }
};

static PyObject *py_dns_rdata_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_rdata_data, type);
}

static PyObject *py_dns_rdata_data_ndr_pack(PyObject *py_obj)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dns_rdata_data);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dns_rdata_data_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_rdata_data);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_rdata_data_ndr_print(PyObject *py_obj)
{
	struct dns_rdata_data *object = (struct dns_rdata_data *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_rdata_data, "dns_rdata_data", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_rdata_data_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_rdata_data_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dns_rdata_data_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_rdata_data_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_rdata_data_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.rdata_data",
	.tp_getset = py_dns_rdata_data_getsetters,
	.tp_methods = py_dns_rdata_data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_rdata_data_new,
};


static PyObject *py_dns_soa_record_get_mname(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_mname;
	py_mname = PyString_FromStringOrNULL(object->mname);
	return py_mname;
}

static int py_dns_soa_record_set_mname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	object->mname = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_dns_soa_record_get_rname(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_rname;
	py_rname = PyString_FromStringOrNULL(object->rname);
	return py_rname;
}

static int py_dns_soa_record_set_rname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	object->rname = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_dns_soa_record_get_serial(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyInt_FromLong(object->serial);
	return py_serial;
}

static int py_dns_soa_record_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_soa_record_get_refresh(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_refresh;
	py_refresh = PyInt_FromLong(object->refresh);
	return py_refresh;
}

static int py_dns_soa_record_set_refresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->refresh = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_soa_record_get_retry(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_retry;
	py_retry = PyInt_FromLong(object->retry);
	return py_retry;
}

static int py_dns_soa_record_set_retry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->retry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_soa_record_get_expire(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_expire;
	py_expire = PyInt_FromLong(object->expire);
	return py_expire;
}

static int py_dns_soa_record_set_expire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->expire = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_soa_record_get_minimum(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(obj);
	PyObject *py_minimum;
	py_minimum = PyInt_FromLong(object->minimum);
	return py_minimum;
}

static int py_dns_soa_record_set_minimum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = (struct dns_soa_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->minimum = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dns_soa_record_getsetters[] = {
	{ discard_const_p(char, "mname"), py_dns_soa_record_get_mname, py_dns_soa_record_set_mname },
	{ discard_const_p(char, "rname"), py_dns_soa_record_get_rname, py_dns_soa_record_set_rname },
	{ discard_const_p(char, "serial"), py_dns_soa_record_get_serial, py_dns_soa_record_set_serial },
	{ discard_const_p(char, "refresh"), py_dns_soa_record_get_refresh, py_dns_soa_record_set_refresh },
	{ discard_const_p(char, "retry"), py_dns_soa_record_get_retry, py_dns_soa_record_set_retry },
	{ discard_const_p(char, "expire"), py_dns_soa_record_get_expire, py_dns_soa_record_set_expire },
	{ discard_const_p(char, "minimum"), py_dns_soa_record_get_minimum, py_dns_soa_record_set_minimum },
	{ NULL }
};

static PyObject *py_dns_soa_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_soa_record, type);
}


static PyTypeObject dns_soa_record_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.soa_record",
	.tp_getset = py_dns_soa_record_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_soa_record_new,
};


static PyObject *py_dns_srv_record_get_priority(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyInt_FromLong(object->priority);
	return py_priority;
}

static int py_dns_srv_record_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->priority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_srv_record_get_weight(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(obj);
	PyObject *py_weight;
	py_weight = PyInt_FromLong(object->weight);
	return py_weight;
}

static int py_dns_srv_record_set_weight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->weight = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_srv_record_get_port(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyInt_FromLong(object->port);
	return py_port;
}

static int py_dns_srv_record_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_srv_record_get_target(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(obj);
	PyObject *py_target;
	py_target = PyString_FromStringOrNULL(object->target);
	return py_target;
}

static int py_dns_srv_record_set_target(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	object->target = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_dns_srv_record_getsetters[] = {
	{ discard_const_p(char, "priority"), py_dns_srv_record_get_priority, py_dns_srv_record_set_priority },
	{ discard_const_p(char, "weight"), py_dns_srv_record_get_weight, py_dns_srv_record_set_weight },
	{ discard_const_p(char, "port"), py_dns_srv_record_get_port, py_dns_srv_record_set_port },
	{ discard_const_p(char, "target"), py_dns_srv_record_get_target, py_dns_srv_record_set_target },
	{ NULL }
};

static PyObject *py_dns_srv_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_srv_record, type);
}

static PyObject *py_dns_srv_record_ndr_pack(PyObject *py_obj)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dns_srv_record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dns_srv_record_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_srv_record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_srv_record_ndr_print(PyObject *py_obj)
{
	struct dns_srv_record *object = (struct dns_srv_record *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_srv_record, "dns_srv_record", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_srv_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_srv_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dns_srv_record_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_srv_record_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_srv_record_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.srv_record",
	.tp_getset = py_dns_srv_record_getsetters,
	.tp_methods = py_dns_srv_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_srv_record_new,
};


static PyObject *py_dns_mx_record_get_preference(PyObject *obj, void *closure)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(obj);
	PyObject *py_preference;
	py_preference = PyInt_FromLong(object->preference);
	return py_preference;
}

static int py_dns_mx_record_set_preference(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->preference = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_mx_record_get_exchange(PyObject *obj, void *closure)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(obj);
	PyObject *py_exchange;
	py_exchange = PyString_FromStringOrNULL(object->exchange);
	return py_exchange;
}

static int py_dns_mx_record_set_exchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(py_obj);
	object->exchange = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_dns_mx_record_getsetters[] = {
	{ discard_const_p(char, "preference"), py_dns_mx_record_get_preference, py_dns_mx_record_set_preference },
	{ discard_const_p(char, "exchange"), py_dns_mx_record_get_exchange, py_dns_mx_record_set_exchange },
	{ NULL }
};

static PyObject *py_dns_mx_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_mx_record, type);
}

static PyObject *py_dns_mx_record_ndr_pack(PyObject *py_obj)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dns_mx_record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dns_mx_record_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_mx_record);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_mx_record_ndr_print(PyObject *py_obj)
{
	struct dns_mx_record *object = (struct dns_mx_record *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_mx_record, "dns_mx_record", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_mx_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_mx_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dns_mx_record_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_mx_record_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_mx_record_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.mx_record",
	.tp_getset = py_dns_mx_record_getsetters,
	.tp_methods = py_dns_mx_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_mx_record_new,
};

PyObject *py_import_dns_rdata(TALLOC_CTX *mem_ctx, int level, union dns_rdata *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_QTYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4_record);
			return ret;

		case DNS_QTYPE_NS:
			ret = PyString_FromStringOrNULL(in->ns_record);
			return ret;

		case DNS_QTYPE_CNAME:
			ret = PyString_FromStringOrNULL(in->cname_record);
			return ret;

		case DNS_QTYPE_SOA:
			ret = py_talloc_reference_ex(&dns_soa_record_Type, mem_ctx, &in->soa_record);
			return ret;

		case DNS_QTYPE_PTR:
			ret = PyString_FromStringOrNULL(in->ptr_record);
			return ret;

		case DNS_QTYPE_MX:
			ret = py_talloc_reference_ex(&dns_mx_record_Type, mem_ctx, &in->mx_record);
			return ret;

		case DNS_QTYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6_record);
			return ret;

		case DNS_QTYPE_SRV:
			ret = py_talloc_reference_ex(&dns_srv_record_Type, mem_ctx, &in->srv_record);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dns_rdata *py_export_dns_rdata(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dns_rdata *ret = talloc_zero(mem_ctx, union dns_rdata);
	switch (level) {
		case DNS_QTYPE_A:
			ret->ipv4_record = PyString_AS_STRING(in);
			break;

		case DNS_QTYPE_NS:
			ret->ns_record = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case DNS_QTYPE_CNAME:
			ret->cname_record = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case DNS_QTYPE_SOA:
			PY_CHECK_TYPE(&dns_soa_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa_record = *(struct dns_soa_record *)py_talloc_get_ptr(in);
			break;

		case DNS_QTYPE_PTR:
			ret->ptr_record = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		case DNS_QTYPE_MX:
			PY_CHECK_TYPE(&dns_mx_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx_record = *(struct dns_mx_record *)py_talloc_get_ptr(in);
			break;

		case DNS_QTYPE_AAAA:
			ret->ipv6_record = PyString_AsString(in);
			break;

		case DNS_QTYPE_SRV:
			PY_CHECK_TYPE(&dns_srv_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv_record = *(struct dns_srv_record *)py_talloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_dns_res_rec_get_name(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_dns_res_rec_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	object->name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_dns_res_rec_get_rr_type(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_rr_type;
	py_rr_type = PyInt_FromLong(object->rr_type);
	return py_rr_type;
}

static int py_dns_res_rec_set_rr_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rr_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rr_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_rr_class(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_rr_class;
	py_rr_class = PyInt_FromLong(object->rr_class);
	return py_rr_class;
}

static int py_dns_res_rec_set_rr_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rr_class = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rr_class = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_ttl(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyInt_FromLong(object->ttl);
	return py_ttl;
}

static int py_dns_res_rec_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ttl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_res_rec_get_length(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_dns_res_rec_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_res_rec_get_rdata(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_rdata;
	py_rdata = py_import_dns_rdata(py_talloc_get_mem_ctx(obj), object->rr_type, &object->rdata);
	if (py_rdata == NULL) {
		return NULL;
	}
	return py_rdata;
}

static int py_dns_res_rec_set_rdata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	{
		union dns_rdata *rdata_switch_0;
		rdata_switch_0 = py_export_dns_rdata(py_talloc_get_mem_ctx(py_obj), object->rr_type, value);
		if (rdata_switch_0 == NULL) {
			return -1;
		}
		object->rdata = *rdata_switch_0;
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_unexpected(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(obj);
	PyObject *py_unexpected;
	py_unexpected = PyString_FromStringAndSize((char *)(object->unexpected).data, (object->unexpected).length);
	return py_unexpected;
}

static int py_dns_res_rec_set_unexpected(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = (struct dns_res_rec *)py_talloc_get_ptr(py_obj);
	object->unexpected = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dns_res_rec_getsetters[] = {
	{ discard_const_p(char, "name"), py_dns_res_rec_get_name, py_dns_res_rec_set_name },
	{ discard_const_p(char, "rr_type"), py_dns_res_rec_get_rr_type, py_dns_res_rec_set_rr_type },
	{ discard_const_p(char, "rr_class"), py_dns_res_rec_get_rr_class, py_dns_res_rec_set_rr_class },
	{ discard_const_p(char, "ttl"), py_dns_res_rec_get_ttl, py_dns_res_rec_set_ttl },
	{ discard_const_p(char, "length"), py_dns_res_rec_get_length, py_dns_res_rec_set_length },
	{ discard_const_p(char, "rdata"), py_dns_res_rec_get_rdata, py_dns_res_rec_set_rdata },
	{ discard_const_p(char, "unexpected"), py_dns_res_rec_get_unexpected, py_dns_res_rec_set_unexpected },
	{ NULL }
};

static PyObject *py_dns_res_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_res_rec, type);
}


static PyTypeObject dns_res_rec_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.res_rec",
	.tp_getset = py_dns_res_rec_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_res_rec_new,
};


static PyObject *py_dns_name_packet_get_id(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyInt_FromLong(object->id);
	return py_id;
}

static int py_dns_name_packet_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_name_packet_get_operation(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_operation;
	py_operation = PyInt_FromLong(object->operation);
	return py_operation;
}

static int py_dns_name_packet_set_operation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->operation = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->operation = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_qdcount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_qdcount;
	py_qdcount = PyInt_FromLong(object->qdcount);
	return py_qdcount;
}

static int py_dns_name_packet_set_qdcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->qdcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_name_packet_get_ancount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ancount;
	py_ancount = PyInt_FromLong(object->ancount);
	return py_ancount;
}

static int py_dns_name_packet_set_ancount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ancount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_name_packet_get_nscount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_nscount;
	py_nscount = PyInt_FromLong(object->nscount);
	return py_nscount;
}

static int py_dns_name_packet_set_nscount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nscount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_name_packet_get_arcount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_arcount;
	py_arcount = PyInt_FromLong(object->arcount);
	return py_arcount;
}

static int py_dns_name_packet_set_arcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->arcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dns_name_packet_get_questions(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_questions;
	py_questions = PyList_New(object->qdcount);
	if (py_questions == NULL) {
		return NULL;
	}
	{
		int questions_cntr_0;
		for (questions_cntr_0 = 0; questions_cntr_0 < object->qdcount; questions_cntr_0++) {
			PyObject *py_questions_0;
			py_questions_0 = py_talloc_reference_ex(&dns_name_question_Type, object->questions, &object->questions[questions_cntr_0]);
			PyList_SetItem(py_questions, questions_cntr_0, py_questions_0);
		}
	}
	return py_questions;
}

static int py_dns_name_packet_set_questions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int questions_cntr_0;
		object->questions = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->questions, PyList_GET_SIZE(value));
		if (!object->questions) { return -1;; }
		talloc_set_name_const(object->questions, "ARRAY: object->questions");
		for (questions_cntr_0 = 0; questions_cntr_0 < PyList_GET_SIZE(value); questions_cntr_0++) {
			PY_CHECK_TYPE(&dns_name_question_Type, PyList_GET_ITEM(value, questions_cntr_0), return -1;);
			if (talloc_reference(object->questions, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, questions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->questions[questions_cntr_0] = *(struct dns_name_question *)py_talloc_get_ptr(PyList_GET_ITEM(value, questions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_answers(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_answers;
	py_answers = PyList_New(object->ancount);
	if (py_answers == NULL) {
		return NULL;
	}
	{
		int answers_cntr_0;
		for (answers_cntr_0 = 0; answers_cntr_0 < object->ancount; answers_cntr_0++) {
			PyObject *py_answers_0;
			py_answers_0 = py_talloc_reference_ex(&dns_res_rec_Type, object->answers, &object->answers[answers_cntr_0]);
			PyList_SetItem(py_answers, answers_cntr_0, py_answers_0);
		}
	}
	return py_answers;
}

static int py_dns_name_packet_set_answers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int answers_cntr_0;
		object->answers = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->answers, PyList_GET_SIZE(value));
		if (!object->answers) { return -1;; }
		talloc_set_name_const(object->answers, "ARRAY: object->answers");
		for (answers_cntr_0 = 0; answers_cntr_0 < PyList_GET_SIZE(value); answers_cntr_0++) {
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, answers_cntr_0), return -1;);
			if (talloc_reference(object->answers, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, answers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->answers[answers_cntr_0] = *(struct dns_res_rec *)py_talloc_get_ptr(PyList_GET_ITEM(value, answers_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_nsrecs(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_nsrecs;
	py_nsrecs = PyList_New(object->nscount);
	if (py_nsrecs == NULL) {
		return NULL;
	}
	{
		int nsrecs_cntr_0;
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < object->nscount; nsrecs_cntr_0++) {
			PyObject *py_nsrecs_0;
			py_nsrecs_0 = py_talloc_reference_ex(&dns_res_rec_Type, object->nsrecs, &object->nsrecs[nsrecs_cntr_0]);
			PyList_SetItem(py_nsrecs, nsrecs_cntr_0, py_nsrecs_0);
		}
	}
	return py_nsrecs;
}

static int py_dns_name_packet_set_nsrecs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nsrecs_cntr_0;
		object->nsrecs = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->nsrecs, PyList_GET_SIZE(value));
		if (!object->nsrecs) { return -1;; }
		talloc_set_name_const(object->nsrecs, "ARRAY: object->nsrecs");
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < PyList_GET_SIZE(value); nsrecs_cntr_0++) {
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, nsrecs_cntr_0), return -1;);
			if (talloc_reference(object->nsrecs, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, nsrecs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->nsrecs[nsrecs_cntr_0] = *(struct dns_res_rec *)py_talloc_get_ptr(PyList_GET_ITEM(value, nsrecs_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_additional(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(obj);
	PyObject *py_additional;
	py_additional = PyList_New(object->arcount);
	if (py_additional == NULL) {
		return NULL;
	}
	{
		int additional_cntr_0;
		for (additional_cntr_0 = 0; additional_cntr_0 < object->arcount; additional_cntr_0++) {
			PyObject *py_additional_0;
			py_additional_0 = py_talloc_reference_ex(&dns_res_rec_Type, object->additional, &object->additional[additional_cntr_0]);
			PyList_SetItem(py_additional, additional_cntr_0, py_additional_0);
		}
	}
	return py_additional;
}

static int py_dns_name_packet_set_additional(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int additional_cntr_0;
		object->additional = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->additional, PyList_GET_SIZE(value));
		if (!object->additional) { return -1;; }
		talloc_set_name_const(object->additional, "ARRAY: object->additional");
		for (additional_cntr_0 = 0; additional_cntr_0 < PyList_GET_SIZE(value); additional_cntr_0++) {
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, additional_cntr_0), return -1;);
			if (talloc_reference(object->additional, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, additional_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->additional[additional_cntr_0] = *(struct dns_res_rec *)py_talloc_get_ptr(PyList_GET_ITEM(value, additional_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dns_name_packet_getsetters[] = {
	{ discard_const_p(char, "id"), py_dns_name_packet_get_id, py_dns_name_packet_set_id },
	{ discard_const_p(char, "operation"), py_dns_name_packet_get_operation, py_dns_name_packet_set_operation },
	{ discard_const_p(char, "qdcount"), py_dns_name_packet_get_qdcount, py_dns_name_packet_set_qdcount },
	{ discard_const_p(char, "ancount"), py_dns_name_packet_get_ancount, py_dns_name_packet_set_ancount },
	{ discard_const_p(char, "nscount"), py_dns_name_packet_get_nscount, py_dns_name_packet_set_nscount },
	{ discard_const_p(char, "arcount"), py_dns_name_packet_get_arcount, py_dns_name_packet_set_arcount },
	{ discard_const_p(char, "questions"), py_dns_name_packet_get_questions, py_dns_name_packet_set_questions },
	{ discard_const_p(char, "answers"), py_dns_name_packet_get_answers, py_dns_name_packet_set_answers },
	{ discard_const_p(char, "nsrecs"), py_dns_name_packet_get_nsrecs, py_dns_name_packet_set_nsrecs },
	{ discard_const_p(char, "additional"), py_dns_name_packet_get_additional, py_dns_name_packet_set_additional },
	{ NULL }
};

static PyObject *py_dns_name_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dns_name_packet, type);
}

static PyObject *py_dns_name_packet_ndr_pack(PyObject *py_obj)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dns_name_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dns_name_packet_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_name_packet_ndr_print(PyObject *py_obj)
{
	struct dns_name_packet *object = (struct dns_name_packet *)py_talloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(py_talloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_name_packet, "dns_name_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_name_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_name_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dns_name_packet_ndr_unpack, METH_VARARGS, "S.ndr_unpack(class, blob) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_name_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_name_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.name_packet",
	.tp_getset = py_dns_name_packet_getsetters,
	.tp_methods = py_dns_name_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_dns_name_packet_new,
};


static bool pack_py_decode_dns_name_packet_args_in(PyObject *args, PyObject *kwargs, struct decode_dns_name_packet *r)
{
	PyObject *py_packet;
	const char *kwnames[] = {
		"packet", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_dns_name_packet", discard_const_p(char *, kwnames), &py_packet)) {
		return false;
	}

	PY_CHECK_TYPE(&dns_name_packet_Type, py_packet, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_packet)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.packet = *(struct dns_name_packet *)py_talloc_get_ptr(py_packet);
	return true;
}

static PyObject *unpack_py_decode_dns_name_packet_args_out(struct decode_dns_name_packet *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_dns_methods[] = {
	{ "decode_dns_name_packet", "S.decode_dns_name_packet(packet) -> None", (py_dcerpc_call_fn)dcerpc_decode_dns_name_packet_r, (py_data_pack_fn)pack_py_decode_dns_name_packet_args_in, (py_data_unpack_fn)unpack_py_decode_dns_name_packet_args_out, 0, &ndr_table_dns },
	{ NULL }
};

static PyObject *interface_dns_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dns);
}

#define PY_DOC_DNS "DNS records"
static PyTypeObject dns_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dns.dns",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dns(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DNS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dns_new,
};

static PyMethodDef dns_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdns(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_base;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	dns_name_question_Type.tp_base = Object_Type;

	dns_rdata_data_Type.tp_base = Object_Type;

	dns_soa_record_Type.tp_base = Object_Type;

	dns_srv_record_Type.tp_base = Object_Type;

	dns_mx_record_Type.tp_base = Object_Type;

	dns_res_rec_Type.tp_base = Object_Type;

	dns_name_packet_Type.tp_base = Object_Type;

	dns_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&dns_name_question_Type) < 0)
		return;
	if (PyType_Ready(&dns_rdata_data_Type) < 0)
		return;
	if (PyType_Ready(&dns_soa_record_Type) < 0)
		return;
	if (PyType_Ready(&dns_srv_record_Type) < 0)
		return;
	if (PyType_Ready(&dns_mx_record_Type) < 0)
		return;
	if (PyType_Ready(&dns_res_rec_Type) < 0)
		return;
	if (PyType_Ready(&dns_name_packet_Type) < 0)
		return;
	if (PyType_Ready(&dns_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&dns_InterfaceType, py_ndr_dns_methods))
		return;

#ifdef PY_NAME_QUESTION_PATCH
	PY_NAME_QUESTION_PATCH(&dns_name_question_Type);
#endif
#ifdef PY_RDATA_DATA_PATCH
	PY_RDATA_DATA_PATCH(&dns_rdata_data_Type);
#endif
#ifdef PY_SOA_RECORD_PATCH
	PY_SOA_RECORD_PATCH(&dns_soa_record_Type);
#endif
#ifdef PY_SRV_RECORD_PATCH
	PY_SRV_RECORD_PATCH(&dns_srv_record_Type);
#endif
#ifdef PY_MX_RECORD_PATCH
	PY_MX_RECORD_PATCH(&dns_mx_record_Type);
#endif
#ifdef PY_RES_REC_PATCH
	PY_RES_REC_PATCH(&dns_res_rec_Type);
#endif
#ifdef PY_NAME_PACKET_PATCH
	PY_NAME_PACKET_PATCH(&dns_name_packet_Type);
#endif
#ifdef PY_DNS_PATCH
	PY_DNS_PATCH(&dns_InterfaceType);
#endif

	m = Py_InitModule3("dns", dns_methods, "dns DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DNS_QTYPE_X25", PyInt_FromLong(DNS_QTYPE_X25));
	PyModule_AddObject(m, "DNS_QTYPE_MF", PyInt_FromLong(DNS_QTYPE_MF));
	PyModule_AddObject(m, "DNS_QTYPE_ISDN", PyInt_FromLong(DNS_QTYPE_ISDN));
	PyModule_AddObject(m, "DNS_QTYPE_ALL", PyInt_FromLong(DNS_QTYPE_ALL));
	PyModule_AddObject(m, "DNS_QTYPE_DNAME", PyInt_FromLong(DNS_QTYPE_DNAME));
	PyModule_AddObject(m, "DNS_OPCODE_RELEASE", PyInt_FromLong(DNS_OPCODE_RELEASE));
	PyModule_AddObject(m, "DNS_OPCODE_WACK", PyInt_FromLong(DNS_OPCODE_WACK));
	PyModule_AddObject(m, "DNS_OPCODE_QUERY", PyInt_FromLong(DNS_OPCODE_QUERY));
	PyModule_AddObject(m, "DNS_QTYPE_CNAME", PyInt_FromLong(DNS_QTYPE_CNAME));
	PyModule_AddObject(m, "DNS_FLAG_TRUNCATION", PyInt_FromLong(DNS_FLAG_TRUNCATION));
	PyModule_AddObject(m, "DNS_QTYPE_SIG", PyInt_FromLong(DNS_QTYPE_SIG));
	PyModule_AddObject(m, "DNS_QTYPE_DS", PyInt_FromLong(DNS_QTYPE_DS));
	PyModule_AddObject(m, "DNS_QTYPE_HINFO", PyInt_FromLong(DNS_QTYPE_HINFO));
	PyModule_AddObject(m, "DNS_RCODE", PyInt_FromLong(DNS_RCODE));
	PyModule_AddObject(m, "DNS_QTYPE_RP", PyInt_FromLong(DNS_QTYPE_RP));
	PyModule_AddObject(m, "DNS_RCODE_SERVFAIL", PyInt_FromLong(DNS_RCODE_SERVFAIL));
	PyModule_AddObject(m, "DNS_RCODE_OK", PyInt_FromLong(DNS_RCODE_OK));
	PyModule_AddObject(m, "DNS_QTYPE_NAPTR", PyInt_FromLong(DNS_QTYPE_NAPTR));
	PyModule_AddObject(m, "DNS_RCODE_NXDOMAIN", PyInt_FromLong(DNS_RCODE_NXDOMAIN));
	PyModule_AddObject(m, "DNS_QTYPE_TXT", PyInt_FromLong(DNS_QTYPE_TXT));
	PyModule_AddObject(m, "DNS_QTYPE_ATMA", PyInt_FromLong(DNS_QTYPE_ATMA));
	PyModule_AddObject(m, "DNS_QTYPE_A", PyInt_FromLong(DNS_QTYPE_A));
	PyModule_AddObject(m, "DNS_QCLASS_IP", PyInt_FromLong(DNS_QCLASS_IP));
	PyModule_AddObject(m, "DNS_RCODE_REFUSED", PyInt_FromLong(DNS_RCODE_REFUSED));
	PyModule_AddObject(m, "DNS_QTYPE_MB", PyInt_FromLong(DNS_QTYPE_MB));
	PyModule_AddObject(m, "DNS_QTYPE_NULL", PyInt_FromLong(DNS_QTYPE_NULL));
	PyModule_AddObject(m, "DNS_QTYPE_ZERO", PyInt_FromLong(DNS_QTYPE_ZERO));
	PyModule_AddObject(m, "DNS_QTYPE_PTR", PyInt_FromLong(DNS_QTYPE_PTR));
	PyModule_AddObject(m, "DNS_RCODE_NOTZONE", PyInt_FromLong(DNS_RCODE_NOTZONE));
	PyModule_AddObject(m, "DNS_QTYPE_MINFO", PyInt_FromLong(DNS_QTYPE_MINFO));
	PyModule_AddObject(m, "DNS_RCODE_NXRRSET", PyInt_FromLong(DNS_RCODE_NXRRSET));
	PyModule_AddObject(m, "DNS_SERVICE_PORT", PyInt_FromLong(53));
	PyModule_AddObject(m, "DNS_QTYPE_NXT", PyInt_FromLong(DNS_QTYPE_NXT));
	PyModule_AddObject(m, "DNS_QTYPE_KEY", PyInt_FromLong(DNS_QTYPE_KEY));
	PyModule_AddObject(m, "DNS_QTYPE_AFSDB", PyInt_FromLong(DNS_QTYPE_AFSDB));
	PyModule_AddObject(m, "DNS_QTYPE_WKS", PyInt_FromLong(DNS_QTYPE_WKS));
	PyModule_AddObject(m, "DNS_FLAG_RECURSION_DESIRED", PyInt_FromLong(DNS_FLAG_RECURSION_DESIRED));
	PyModule_AddObject(m, "DNS_OPCODE_REGISTER", PyInt_FromLong(DNS_OPCODE_REGISTER));
	PyModule_AddObject(m, "DNS_QTYPE_NS", PyInt_FromLong(DNS_QTYPE_NS));
	PyModule_AddObject(m, "DNS_OPCODE", PyInt_FromLong(DNS_OPCODE));
	PyModule_AddObject(m, "DNS_QTYPE_MR", PyInt_FromLong(DNS_QTYPE_MR));
	PyModule_AddObject(m, "DNS_RCODE_YXRRSET", PyInt_FromLong(DNS_RCODE_YXRRSET));
	PyModule_AddObject(m, "DNS_QCLASS_ANY", PyInt_FromLong(DNS_QCLASS_ANY));
	PyModule_AddObject(m, "DNS_OPCODE_MULTI_HOME_REG", PyInt_FromLong(DNS_OPCODE_MULTI_HOME_REG));
	PyModule_AddObject(m, "DNS_QTYPE_RT", PyInt_FromLong(DNS_QTYPE_RT));
	PyModule_AddObject(m, "DNS_QTYPE_MD", PyInt_FromLong(DNS_QTYPE_MD));
	PyModule_AddObject(m, "DNS_RCODE_FORMERR", PyInt_FromLong(DNS_RCODE_FORMERR));
	PyModule_AddObject(m, "DNS_OPCODE_REFRESH2", PyInt_FromLong(DNS_OPCODE_REFRESH2));
	PyModule_AddObject(m, "DNS_QTYPE_SRV", PyInt_FromLong(DNS_QTYPE_SRV));
	PyModule_AddObject(m, "DNS_OPCODE_STATUS", PyInt_FromLong(DNS_OPCODE_STATUS));
	PyModule_AddObject(m, "DNS_QTYPE_NSEC", PyInt_FromLong(DNS_QTYPE_NSEC));
	PyModule_AddObject(m, "DNS_QTYPE_MG", PyInt_FromLong(DNS_QTYPE_MG));
	PyModule_AddObject(m, "DNS_QTYPE_AAAA", PyInt_FromLong(DNS_QTYPE_AAAA));
	PyModule_AddObject(m, "DNS_FLAG_AUTHORITATIVE", PyInt_FromLong(DNS_FLAG_AUTHORITATIVE));
	PyModule_AddObject(m, "DNS_QTYPE_WINS", PyInt_FromLong(DNS_QTYPE_WINS));
	PyModule_AddObject(m, "DNS_FLAG_RECURSION_AVAIL", PyInt_FromLong(DNS_FLAG_RECURSION_AVAIL));
	PyModule_AddObject(m, "DNS_QTYPE_MX", PyInt_FromLong(DNS_QTYPE_MX));
	PyModule_AddObject(m, "DNS_QTYPE_LOC", PyInt_FromLong(DNS_QTYPE_LOC));
	PyModule_AddObject(m, "DNS_RCODE_NOTAUTH", PyInt_FromLong(DNS_RCODE_NOTAUTH));
	PyModule_AddObject(m, "DNS_RCODE_YXDOMAIN", PyInt_FromLong(DNS_RCODE_YXDOMAIN));
	PyModule_AddObject(m, "DNS_FLAG_BROADCAST", PyInt_FromLong(DNS_FLAG_BROADCAST));
	PyModule_AddObject(m, "DNS_QTYPE_NETBIOS", PyInt_FromLong(DNS_QTYPE_NETBIOS));
	PyModule_AddObject(m, "DNS_QTYPE_DNSKEY", PyInt_FromLong(DNS_QTYPE_DNSKEY));
	PyModule_AddObject(m, "DNS_QTYPE_WINSR", PyInt_FromLong(DNS_QTYPE_WINSR));
	PyModule_AddObject(m, "DNS_QCLASS_NONE", PyInt_FromLong(DNS_QCLASS_NONE));
	PyModule_AddObject(m, "DNS_QTYPE_SOA", PyInt_FromLong(DNS_QTYPE_SOA));
	PyModule_AddObject(m, "DNS_RCODE_NOTIMP", PyInt_FromLong(DNS_RCODE_NOTIMP));
	PyModule_AddObject(m, "DNS_QTYPE_RRSIG", PyInt_FromLong(DNS_QTYPE_RRSIG));
	PyModule_AddObject(m, "DNS_OPCODE_REFRESH", PyInt_FromLong(DNS_OPCODE_REFRESH));
	PyModule_AddObject(m, "DNS_QTYPE_DHCID", PyInt_FromLong(DNS_QTYPE_DHCID));
	PyModule_AddObject(m, "DNS_OPCODE_IQUERY", PyInt_FromLong(DNS_OPCODE_IQUERY));
	PyModule_AddObject(m, "DNS_FLAG_REPLY", PyInt_FromLong(DNS_FLAG_REPLY));
	Py_INCREF((PyObject *)(void *)&dns_name_question_Type);
	PyModule_AddObject(m, "name_question", (PyObject *)(void *)&dns_name_question_Type);
	Py_INCREF((PyObject *)(void *)&dns_rdata_data_Type);
	PyModule_AddObject(m, "rdata_data", (PyObject *)(void *)&dns_rdata_data_Type);
	Py_INCREF((PyObject *)(void *)&dns_soa_record_Type);
	PyModule_AddObject(m, "soa_record", (PyObject *)(void *)&dns_soa_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_srv_record_Type);
	PyModule_AddObject(m, "srv_record", (PyObject *)(void *)&dns_srv_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_mx_record_Type);
	PyModule_AddObject(m, "mx_record", (PyObject *)(void *)&dns_mx_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_res_rec_Type);
	PyModule_AddObject(m, "res_rec", (PyObject *)(void *)&dns_res_rec_Type);
	Py_INCREF((PyObject *)(void *)&dns_name_packet_Type);
	PyModule_AddObject(m, "name_packet", (PyObject *)(void *)&dns_name_packet_Type);
	Py_INCREF((PyObject *)(void *)&dns_InterfaceType);
	PyModule_AddObject(m, "dns", (PyObject *)(void *)&dns_InterfaceType);
#ifdef PY_MOD_DNS_PATCH
	PY_MOD_DNS_PATCH(m);
#endif

}
