/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_dnsp
#define _PIDL_HEADER_dnsp

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#ifndef _HEADER_dnsp
#define _HEADER_dnsp

enum dns_record_type
#ifndef USE_UINT_ENUMS
 {
	DNS_TYPE_TOMBSTONE=(int)(0x0),
	DNS_TYPE_A=(int)(0x1),
	DNS_TYPE_NS=(int)(0x2),
	DNS_TYPE_MD=(int)(0x3),
	DNS_TYPE_MF=(int)(0x4),
	DNS_TYPE_CNAME=(int)(0x5),
	DNS_TYPE_SOA=(int)(0x6),
	DNS_TYPE_MB=(int)(0x7),
	DNS_TYPE_MG=(int)(0x8),
	DNS_TYPE_MR=(int)(0x9),
	DNS_TYPE_NULL=(int)(0xA),
	DNS_TYPE_WKS=(int)(0xB),
	DNS_TYPE_PTR=(int)(0xC),
	DNS_TYPE_HINFO=(int)(0xD),
	DNS_TYPE_MINFO=(int)(0xE),
	DNS_TYPE_MX=(int)(0xF),
	DNS_TYPE_TXT=(int)(0x10),
	DNS_TYPE_RP=(int)(0x11),
	DNS_TYPE_AFSDB=(int)(0x12),
	DNS_TYPE_X25=(int)(0x13),
	DNS_TYPE_ISDN=(int)(0x14),
	DNS_TYPE_RT=(int)(0x15),
	DNS_TYPE_SIG=(int)(0x18),
	DNS_TYPE_KEY=(int)(0x19),
	DNS_TYPE_AAAA=(int)(0x1C),
	DNS_TYPE_LOC=(int)(0x1D),
	DNS_TYPE_NXT=(int)(0x1E),
	DNS_TYPE_SRV=(int)(0x21),
	DNS_TYPE_ATMA=(int)(0x22),
	DNS_TYPE_NAPTR=(int)(0x23),
	DNS_TYPE_DNAME=(int)(0x27),
	DNS_TYPE_DS=(int)(0x2B),
	DNS_TYPE_RRSIG=(int)(0x2E),
	DNS_TYPE_NSEC=(int)(0x2F),
	DNS_TYPE_DNSKEY=(int)(0x30),
	DNS_TYPE_DHCID=(int)(0x31),
	DNS_TYPE_ALL=(int)(0xFF),
	DNS_TYPE_WINS=(int)(0xFF01),
	DNS_TYPE_WINSR=(int)(0xFF02)
}
#else
 { __donnot_use_enum_dns_record_type=0x7FFFFFFF}
#define DNS_TYPE_TOMBSTONE ( 0x0 )
#define DNS_TYPE_A ( 0x1 )
#define DNS_TYPE_NS ( 0x2 )
#define DNS_TYPE_MD ( 0x3 )
#define DNS_TYPE_MF ( 0x4 )
#define DNS_TYPE_CNAME ( 0x5 )
#define DNS_TYPE_SOA ( 0x6 )
#define DNS_TYPE_MB ( 0x7 )
#define DNS_TYPE_MG ( 0x8 )
#define DNS_TYPE_MR ( 0x9 )
#define DNS_TYPE_NULL ( 0xA )
#define DNS_TYPE_WKS ( 0xB )
#define DNS_TYPE_PTR ( 0xC )
#define DNS_TYPE_HINFO ( 0xD )
#define DNS_TYPE_MINFO ( 0xE )
#define DNS_TYPE_MX ( 0xF )
#define DNS_TYPE_TXT ( 0x10 )
#define DNS_TYPE_RP ( 0x11 )
#define DNS_TYPE_AFSDB ( 0x12 )
#define DNS_TYPE_X25 ( 0x13 )
#define DNS_TYPE_ISDN ( 0x14 )
#define DNS_TYPE_RT ( 0x15 )
#define DNS_TYPE_SIG ( 0x18 )
#define DNS_TYPE_KEY ( 0x19 )
#define DNS_TYPE_AAAA ( 0x1C )
#define DNS_TYPE_LOC ( 0x1D )
#define DNS_TYPE_NXT ( 0x1E )
#define DNS_TYPE_SRV ( 0x21 )
#define DNS_TYPE_ATMA ( 0x22 )
#define DNS_TYPE_NAPTR ( 0x23 )
#define DNS_TYPE_DNAME ( 0x27 )
#define DNS_TYPE_DS ( 0x2B )
#define DNS_TYPE_RRSIG ( 0x2E )
#define DNS_TYPE_NSEC ( 0x2F )
#define DNS_TYPE_DNSKEY ( 0x30 )
#define DNS_TYPE_DHCID ( 0x31 )
#define DNS_TYPE_ALL ( 0xFF )
#define DNS_TYPE_WINS ( 0xFF01 )
#define DNS_TYPE_WINSR ( 0xFF02 )
#endif
;

enum dns_record_rank
#ifndef USE_UINT_ENUMS
 {
	DNS_RANK_NONE=(int)(0x00),
	DNS_RANK_CACHE_BIT=(int)(0x01),
	DNS_RANK_ROOT_HINT=(int)(0x08),
	DNS_RANK_OUTSIDE_GLUE=(int)(0x20),
	DNS_RANK_CACHE_NA_ADDITIONAL=(int)(0x31),
	DNS_RANK_CACHE_NA_AUTHORITY=(int)(0x41),
	DNS_RANK_CACHE_A_ADDITIONAL=(int)(0x51),
	DNS_RANK_CACHE_NA_ANSWER=(int)(0x61),
	DNS_RANK_CACHE_A_AUTHORITY=(int)(0x71),
	DNS_RANK_GLUE=(int)(0x80),
	DNS_RANK_NS_GLUE=(int)(0x82),
	DNS_RANK_CACHE_A_ANSWER=(int)(0xc1),
	DNS_RANK_ZONE=(int)(0xf0)
}
#else
 { __donnot_use_enum_dns_record_rank=0x7FFFFFFF}
#define DNS_RANK_NONE ( 0x00 )
#define DNS_RANK_CACHE_BIT ( 0x01 )
#define DNS_RANK_ROOT_HINT ( 0x08 )
#define DNS_RANK_OUTSIDE_GLUE ( 0x20 )
#define DNS_RANK_CACHE_NA_ADDITIONAL ( 0x31 )
#define DNS_RANK_CACHE_NA_AUTHORITY ( 0x41 )
#define DNS_RANK_CACHE_A_ADDITIONAL ( 0x51 )
#define DNS_RANK_CACHE_NA_ANSWER ( 0x61 )
#define DNS_RANK_CACHE_A_AUTHORITY ( 0x71 )
#define DNS_RANK_GLUE ( 0x80 )
#define DNS_RANK_NS_GLUE ( 0x82 )
#define DNS_RANK_CACHE_A_ANSWER ( 0xc1 )
#define DNS_RANK_ZONE ( 0xf0 )
#endif
;

struct dnsp_soa {
	uint32_t serial;
	uint32_t refresh;
	uint32_t retry;
	uint32_t expire;
	uint32_t minimum;
	const char * mname;
	const char * rname;
}/* [public] */;

struct dnsp_mx {
	uint16_t wPriority;
	const char * nameTarget;
}/* [public] */;

struct dnsp_hinfo {
	const char * cpu;
	const char * os;
}/* [public] */;

struct dnsp_srv {
	uint16_t wPriority;
	uint16_t wWeight;
	uint16_t wPort;
	const char * nameTarget;
}/* [public] */;

union dnsRecordData {
	NTTIME timestamp;/* [case(DNS_TYPE_TOMBSTONE)] */
	const char * ipv4;/* [flag(LIBNDR_FLAG_BIGENDIAN),case(DNS_TYPE_A)] */
	const char * ns;/* [case(DNS_TYPE_NS)] */
	const char * cname;/* [case(DNS_TYPE_CNAME)] */
	struct dnsp_soa soa;/* [flag(LIBNDR_FLAG_BIGENDIAN),case(DNS_TYPE_SOA)] */
	struct dnsp_mx mx;/* [flag(LIBNDR_FLAG_BIGENDIAN),case(DNS_TYPE_MX)] */
	const char * txt;/* [case(DNS_TYPE_TXT)] */
	const char * ptr;/* [case(DNS_TYPE_PTR)] */
	struct dnsp_hinfo hinfo;/* [case(DNS_TYPE_HINFO)] */
	const char * ipv6;/* [case(DNS_TYPE_AAAA)] */
	struct dnsp_srv srv;/* [case(DNS_TYPE_SRV),flag(LIBNDR_FLAG_BIGENDIAN)] */
	DATA_BLOB data;/* [default,flag(LIBNDR_FLAG_REMAINING)] */
}/* [nodiscriminant,gensize] */;

struct dnsp_DnssrvRpcRecord {
	uint16_t wDataLength;/* [value(ndr_size_dnsRecordData(&data,wType,ndr->flags))] */
	enum dns_record_type wType;
	uint8_t version;/* [value(5)] */
	enum dns_record_rank rank;
	uint16_t flags;
	uint32_t dwSerial;
	uint32_t dwTtlSeconds;/* [flag(LIBNDR_FLAG_BIGENDIAN)] */
	uint32_t dwReserved;
	uint32_t dwTimeStamp;
	union dnsRecordData data;/* [switch_is(wType)] */
}/* [public] */;


struct decode_DnssrvRpcRecord {
	struct {
		struct dnsp_DnssrvRpcRecord blob;
	} in;

};

#endif /* _HEADER_dnsp */
#endif /* _PIDL_HEADER_dnsp */
