/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "librpc/gen_ndr/srv_drsuapi.h"

static bool api_drsuapi_DsBind(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsBind *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSBIND];

	r = talloc(talloc_tos(), struct drsuapi_DsBind);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsBind, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.bind_info = r->in.bind_info;
	r->out.bind_handle = talloc_zero(r, struct policy_handle);
	if (r->out.bind_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsBind(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsBind, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsUnbind(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsUnbind *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSUNBIND];

	r = talloc(talloc_tos(), struct drsuapi_DsUnbind);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsUnbind, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.bind_handle = r->in.bind_handle;
	r->out.result = _drsuapi_DsUnbind(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsUnbind, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaSync(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaSync *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICASYNC];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaSync);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaSync, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsReplicaSync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaSync, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsGetNCChanges(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsGetNCChanges *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSGETNCCHANGES];

	r = talloc(talloc_tos(), struct drsuapi_DsGetNCChanges);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNCChanges, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsGetNCChangesCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsGetNCChanges(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNCChanges, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaUpdateRefs(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaUpdateRefs *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICAUPDATEREFS];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaUpdateRefs);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaUpdateRefs, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsReplicaUpdateRefs(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaUpdateRefs, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaAdd(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaAdd *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICAADD];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaAdd);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaAdd, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsReplicaAdd(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaAdd, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaDel(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaDel *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICADEL];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaDel);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaDel, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsReplicaDel(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaDel, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaMod(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaMod *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICAMOD];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaMod);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaMod, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsReplicaMod(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaMod, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_VERIFY_NAMES(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_VERIFY_NAMES *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_VERIFY_NAMES];

	r = talloc(talloc_tos(), struct DRSUAPI_VERIFY_NAMES);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_VERIFY_NAMES, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_VERIFY_NAMES(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_VERIFY_NAMES, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsGetMemberships(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsGetMemberships *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSGETMEMBERSHIPS];

	r = talloc(talloc_tos(), struct drsuapi_DsGetMemberships);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsGetMembershipsCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsGetMemberships(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_INTER_DOMAIN_MOVE(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_INTER_DOMAIN_MOVE *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_INTER_DOMAIN_MOVE];

	r = talloc(talloc_tos(), struct DRSUAPI_INTER_DOMAIN_MOVE);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_INTER_DOMAIN_MOVE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsGetNT4ChangeLog(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsGetNT4ChangeLog *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSGETNT4CHANGELOG];

	r = talloc(talloc_tos(), struct drsuapi_DsGetNT4ChangeLog);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNT4ChangeLog, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info = talloc_zero(r, union drsuapi_DsGetNT4ChangeLogInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsGetNT4ChangeLog(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNT4ChangeLog, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsCrackNames(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsCrackNames *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSCRACKNAMES];

	r = talloc(talloc_tos(), struct drsuapi_DsCrackNames);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsCrackNames, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsNameCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsCrackNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsCrackNames, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsWriteAccountSpn(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsWriteAccountSpn *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSWRITEACCOUNTSPN];

	r = talloc(talloc_tos(), struct drsuapi_DsWriteAccountSpn);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsWriteAccountSpn, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.res = talloc_zero(r, union drsuapi_DsWriteAccountSpnResult);
	if (r->out.res == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsWriteAccountSpn(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsWriteAccountSpn, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsRemoveDSServer(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsRemoveDSServer *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREMOVEDSSERVER];

	r = talloc(talloc_tos(), struct drsuapi_DsRemoveDSServer);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsRemoveDSServer, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.res = talloc_zero(r, union drsuapi_DsRemoveDSServerResult);
	if (r->out.res == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsRemoveDSServer(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsRemoveDSServer, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_REMOVE_DS_DOMAIN(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_REMOVE_DS_DOMAIN *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_REMOVE_DS_DOMAIN];

	r = talloc(talloc_tos(), struct DRSUAPI_REMOVE_DS_DOMAIN);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_REMOVE_DS_DOMAIN(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsGetDomainControllerInfo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsGetDomainControllerInfo *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSGETDOMAINCONTROLLERINFO];

	r = talloc(talloc_tos(), struct drsuapi_DsGetDomainControllerInfo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetDomainControllerInfo, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, int32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsGetDCInfoCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsGetDomainControllerInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetDomainControllerInfo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsAddEntry(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsAddEntry *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSADDENTRY];

	r = talloc(talloc_tos(), struct drsuapi_DsAddEntry);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsAddEntry, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsAddEntryCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsAddEntry(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsAddEntry, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsExecuteKCC(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsExecuteKCC *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSEXECUTEKCC];

	r = talloc(talloc_tos(), struct drsuapi_DsExecuteKCC);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsExecuteKCC, NDR_IN, r);
	}

	r->out.result = _drsuapi_DsExecuteKCC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsExecuteKCC, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsReplicaGetInfo(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsReplicaGetInfo *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSREPLICAGETINFO];

	r = talloc(talloc_tos(), struct drsuapi_DsReplicaGetInfo);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaGetInfo, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info_type = talloc_zero(r, enum drsuapi_DsReplicaInfoType);
	if (r->out.info_type == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.info = talloc_zero(r, union drsuapi_DsReplicaInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsReplicaGetInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaGetInfo, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_ADD_SID_HISTORY(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_ADD_SID_HISTORY *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_ADD_SID_HISTORY];

	r = talloc(talloc_tos(), struct DRSUAPI_ADD_SID_HISTORY);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_ADD_SID_HISTORY, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_ADD_SID_HISTORY(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_ADD_SID_HISTORY, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_DsGetMemberships2(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_DsGetMemberships2 *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_DSGETMEMBERSHIPS2];

	r = talloc(talloc_tos(), struct drsuapi_DsGetMemberships2);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships2, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_DsGetMemberships2Ctr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_DsGetMemberships2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships2, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_REPLICA_VERIFY_OBJECTS];

	r = talloc(talloc_tos(), struct DRSUAPI_REPLICA_VERIFY_OBJECTS);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_REPLICA_VERIFY_OBJECTS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_DRSUAPI_GET_OBJECT_EXISTENCE(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct DRSUAPI_GET_OBJECT_EXISTENCE *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_GET_OBJECT_EXISTENCE];

	r = talloc(talloc_tos(), struct DRSUAPI_GET_OBJECT_EXISTENCE);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, NDR_IN, r);
	}

	r->out.result = _DRSUAPI_GET_OBJECT_EXISTENCE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_drsuapi_QuerySitesByCost(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct drsuapi_QuerySitesByCost *r;

	call = &ndr_table_drsuapi.calls[NDR_DRSUAPI_QUERYSITESBYCOST];

	r = talloc(talloc_tos(), struct drsuapi_QuerySitesByCost);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_QuerySitesByCost, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.level_out = talloc_zero(r, uint32_t);
	if (r->out.level_out == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ctr = talloc_zero(r, union drsuapi_QuerySitesByCostCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _drsuapi_QuerySitesByCost(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(drsuapi_QuerySitesByCost, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_drsuapi_cmds[] = 
{
	{"DRSUAPI_DSBIND", NDR_DRSUAPI_DSBIND, api_drsuapi_DsBind},
	{"DRSUAPI_DSUNBIND", NDR_DRSUAPI_DSUNBIND, api_drsuapi_DsUnbind},
	{"DRSUAPI_DSREPLICASYNC", NDR_DRSUAPI_DSREPLICASYNC, api_drsuapi_DsReplicaSync},
	{"DRSUAPI_DSGETNCCHANGES", NDR_DRSUAPI_DSGETNCCHANGES, api_drsuapi_DsGetNCChanges},
	{"DRSUAPI_DSREPLICAUPDATEREFS", NDR_DRSUAPI_DSREPLICAUPDATEREFS, api_drsuapi_DsReplicaUpdateRefs},
	{"DRSUAPI_DSREPLICAADD", NDR_DRSUAPI_DSREPLICAADD, api_drsuapi_DsReplicaAdd},
	{"DRSUAPI_DSREPLICADEL", NDR_DRSUAPI_DSREPLICADEL, api_drsuapi_DsReplicaDel},
	{"DRSUAPI_DSREPLICAMOD", NDR_DRSUAPI_DSREPLICAMOD, api_drsuapi_DsReplicaMod},
	{"DRSUAPI_VERIFY_NAMES", NDR_DRSUAPI_VERIFY_NAMES, api_DRSUAPI_VERIFY_NAMES},
	{"DRSUAPI_DSGETMEMBERSHIPS", NDR_DRSUAPI_DSGETMEMBERSHIPS, api_drsuapi_DsGetMemberships},
	{"DRSUAPI_INTER_DOMAIN_MOVE", NDR_DRSUAPI_INTER_DOMAIN_MOVE, api_DRSUAPI_INTER_DOMAIN_MOVE},
	{"DRSUAPI_DSGETNT4CHANGELOG", NDR_DRSUAPI_DSGETNT4CHANGELOG, api_drsuapi_DsGetNT4ChangeLog},
	{"DRSUAPI_DSCRACKNAMES", NDR_DRSUAPI_DSCRACKNAMES, api_drsuapi_DsCrackNames},
	{"DRSUAPI_DSWRITEACCOUNTSPN", NDR_DRSUAPI_DSWRITEACCOUNTSPN, api_drsuapi_DsWriteAccountSpn},
	{"DRSUAPI_DSREMOVEDSSERVER", NDR_DRSUAPI_DSREMOVEDSSERVER, api_drsuapi_DsRemoveDSServer},
	{"DRSUAPI_REMOVE_DS_DOMAIN", NDR_DRSUAPI_REMOVE_DS_DOMAIN, api_DRSUAPI_REMOVE_DS_DOMAIN},
	{"DRSUAPI_DSGETDOMAINCONTROLLERINFO", NDR_DRSUAPI_DSGETDOMAINCONTROLLERINFO, api_drsuapi_DsGetDomainControllerInfo},
	{"DRSUAPI_DSADDENTRY", NDR_DRSUAPI_DSADDENTRY, api_drsuapi_DsAddEntry},
	{"DRSUAPI_DSEXECUTEKCC", NDR_DRSUAPI_DSEXECUTEKCC, api_drsuapi_DsExecuteKCC},
	{"DRSUAPI_DSREPLICAGETINFO", NDR_DRSUAPI_DSREPLICAGETINFO, api_drsuapi_DsReplicaGetInfo},
	{"DRSUAPI_ADD_SID_HISTORY", NDR_DRSUAPI_ADD_SID_HISTORY, api_DRSUAPI_ADD_SID_HISTORY},
	{"DRSUAPI_DSGETMEMBERSHIPS2", NDR_DRSUAPI_DSGETMEMBERSHIPS2, api_drsuapi_DsGetMemberships2},
	{"DRSUAPI_REPLICA_VERIFY_OBJECTS", NDR_DRSUAPI_REPLICA_VERIFY_OBJECTS, api_DRSUAPI_REPLICA_VERIFY_OBJECTS},
	{"DRSUAPI_GET_OBJECT_EXISTENCE", NDR_DRSUAPI_GET_OBJECT_EXISTENCE, api_DRSUAPI_GET_OBJECT_EXISTENCE},
	{"DRSUAPI_QUERYSITESBYCOST", NDR_DRSUAPI_QUERYSITESBYCOST, api_drsuapi_QuerySitesByCost},
};

void drsuapi_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_drsuapi_cmds;
	*n_fns = sizeof(api_drsuapi_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_drsuapi_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "drsuapi", "drsuapi", &ndr_table_drsuapi, api_drsuapi_cmds, sizeof(api_drsuapi_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_drsuapi_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_drsuapi);
}
