%define initdir %{_sysconfdir}/rc.d/init.d
%define auth %(test -f /etc/pam.d/system-auth && echo /etc/pam.d/system-auth || echo)

Summary: Samba SMB client and server
Vendor: Samba Team
Packager: Samba Team <samba@samba.org>
Name:         samba
Version:      3.0.21b
Release:      1
License: GNU GPL version 2
Group: System Environment/Daemons
URL: http://www.samba.org/

Source: samba-%{version}.tar.bz2

# Don't depend on Net::LDAP
Source998: filter-requires-samba.sh
Source999: setup.tar.bz2

Requires: pam >= 0.64 %{auth} samba-common = %{version}
Requires: logrotate >= 3.4 initscripts >= 5.54-1
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: /sbin/chkconfig /bin/mktemp /usr/bin/killall
Prereq: fileutils sed /etc/init.d
BuildRequires: pam-devel, readline-devel, fileutils, libacl-devel, openldap-devel, krb5-devel, cups-devel
Provides: samba = %{version}
Obsoletes: samba-common, samba-client, samba-swat

BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prefix: /usr

# Working around perl dependency problem from docs
%define __perl_requires %{SOURCE998}


%description
Samba is the protocol by which a lot of PC-related machines share
files, printers, and other information (such as lists of available
files and printers). The Windows NT, OS/2, and Linux operating systems
support this natively, and add-on packages can enable the same thing
for DOS, Windows, VMS, UNIX of all kinds, MVS, and more. This package
provides an SMB server that can be used to provide network services to
SMB (sometimes called "Lan Manager") clients. Samba uses NetBIOS over
TCP/IP (NetBT) protocols and does NOT need the NetBEUI (Microsoft Raw
NetBIOS frame) protocol.


%package client
Summary: Samba (SMB) client programs.
Group: Applications/System
Requires: samba-common = %{version}
Obsoletes: smbfs

%description client
The samba-client package provides some SMB clients to compliment the
built-in SMB filesystem in Linux. These clients allow access of SMB
shares and printing to SMB printers.


%package common
Summary: Files used by both Samba servers and clients.
Group: Applications/System

%description common
Samba-common provides files necessary for both the server and client
packages of Samba.


%package swat
Summary: The Samba SMB server configuration program.
Group: Applications/System
Requires: samba = %{version} xinetd

%description swat
The samba-swat package includes the new SWAT (Samba Web Administration
Tool), for remotely managing Samba's smb.conf file using your favorite
Web browser.


%prep
%setup -q

# setup the vendor files (init scripts, etc...)
%setup -T -D -a 999 -n samba-%{version} -q

%build

/bin/cp setup/filter-requires-samba.sh %{SOURCE998}

cd source
%ifarch i386 sparc
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64"
%endif
%ifarch ia64
libtoolize --copy --force     # get it to recognize IA-64
autoheader
autoconf
EXTRA="-D_LARGEFILE64_SOURCE"
%endif

## run autogen if missing the configure script
if [ ! -f "configure" ]; then
	./autogen.sh
fi

CFLAGS="$RPM_OPT_FLAGS $EXTRA -D_GNU_SOURCE" ./configure \
	--prefix=%{_prefix} \
	--localstatedir=/var \
        --with-configdir=%{_sysconfdir}/samba \
        --with-libdir=%{_libdir}/samba \
        --with-lockdir=/var/cache/samba \
        --with-logfilebase=/var/log/samba \
        --with-mandir=%{_mandir} \
        --with-piddir=/var/run \
	--with-privatedir=%{_sysconfdir}/samba \
        --with-sambabook=%{_datadir}/swat/using_samba \
        --with-swatdir=%{_datadir}/swat \
	--enable-cups \
        --with-acl-support \
        --with-automount \
        --with-fhs \
	--with-pam_smbpass \
	--with-libsmbclient \
	--with-libsmbsharemodes \
	--with-pam \
	--with-quotas \
	--with-shared-modules=idmap_rid,idmap_ad \
	--with-smbmount \
	--with-syslog \
	--with-utmp 

make showlayout

make CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE"  proto pch

make CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE" %{?_smp_mflags} \
	all modules pam_smbpass

## build the cifs fs mount helper
cd client
gcc  -o mount.cifs $RPM_OPT_FLAGS  -D_GNU_SOURCE -Wall -D_GNU_SOURCE -D_LARGEFILE64_SOURCE mount.cifs.c
gcc  -o umount.cifs $RPM_OPT_FLAGS  -D_GNU_SOURCE -Wall -D_GNU_SOURCE -D_LARGEFILE64_SOURCE umount.cifs.c
cd ..

# Remove some permission bits to avoid to many dependencies
cd ..
find examples docs -type f | xargs -r chmod -x

%install
# Clean up in case there is trash left from a previous build
rm -rf $RPM_BUILD_ROOT

# Create the target build directory hierarchy
mkdir -p $RPM_BUILD_ROOT%{_datadir}/swat/{help,include,using_samba/{figs,gifsa}}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/swat/using_samba
mkdir -p $RPM_BUILD_ROOT%{_includedir}
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
mkdir -p $RPM_BUILD_ROOT{%{_libdir},%{_includedir}}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/samba/{auth,charset,idmap,vfs,pdb}
mkdir -p $RPM_BUILD_ROOT/%{_lib}/security
mkdir -p $RPM_BUILD_ROOT%{_mandir}
mkdir -p $RPM_BUILD_ROOT%{_prefix}/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT%{_prefix}/lib
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/{logrotate.d,pam.d,samba}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/{pam.d,logrotate.d}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/{samba,sysconfig}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/xinetd.d
mkdir -p $RPM_BUILD_ROOT/var/cache/samba/winbindd_privileged
mkdir -p $RPM_BUILD_ROOT/var/{log,run/winbindd,spool}/samba

cd source
make DESTDIR=$RPM_BUILD_ROOT \
        install
cd ..

# pam_smbpass
cp source/bin/pam_smbpass.so $RPM_BUILD_ROOT/%{_lib}/security/pam_smbpass.so

# NSS & PAM winbind support
install -m 755 source/nsswitch/pam_winbind.so $RPM_BUILD_ROOT/%{_lib}/security/pam_winbind.so
install -m 755 source/nsswitch/libnss_winbind.so $RPM_BUILD_ROOT/%{_lib}/libnss_winbind.so
install -m 755 source/nsswitch/libnss_wins.so $RPM_BUILD_ROOT/%{_lib}/libnss_wins.so
( cd $RPM_BUILD_ROOT/%{_lib};
  ln -sf libnss_winbind.so  libnss_winbind.so.2;
  ln -sf libnss_wins.so  libnss_wins.so.2 )

# make install puts libsmbclient.so in the wrong place on x86_64
rm -f $RPM_BUILD_ROOT/usr/lib*/samba/libsmbclient.so $RPM_BUILD_ROOT/usr/lib*/samba/libsmbclient.a || true
install -m 755 source/bin/libsmbclient.so $RPM_BUILD_ROOT%{_libdir}/libsmbclient.so
install -m 755 source/bin/libsmbclient.a $RPM_BUILD_ROOT%{_libdir}/libsmbclient.a
install -m 644 source/include/libsmbclient.h $RPM_BUILD_ROOT%{_includedir}
ln -s %{_libdir}/libsmbclient.so $RPM_BUILD_ROOT%{_libdir}/libsmbclient.so.0
#if [ %{_libdir} == /usr/lib64 ];then
#	ln -s %{_libdir}/libsmbclient.so $RPM_BUILD_ROOT/usr/lib/libsmbclient.so.0
#	ln -s %{_libdir}/libsmbclient.so $RPM_BUILD_ROOT/usr/lib/libsmbclient.so
#fi

# make install puts libmsrpc.so in the wrong place on x86_64
rm -f $RPM_BUILD_ROOT/usr/lib*/samba/libmsrpc.so $RPM_BUILD_ROOT/usr/lib*/samba/libmsrpc.a || true
install -m 755 source/bin/libmsrpc.so $RPM_BUILD_ROOT%{_libdir}/libmsrpc.so
install -m 755 source/bin/libmsrpc.a $RPM_BUILD_ROOT%{_libdir}/libmsrpc.a
install -m 644 source/include/libmsrpc.h $RPM_BUILD_ROOT%{_includedir}
rm -f $RPM_BUILD_ROOT%{_libdir}/samba/libmsrpc.*
ln -s /%{_libdir}/libmsrpc.so $RPM_BUILD_ROOT%{_libdir}/libmsrpc.so.0
#if [ %{_libdir} == /usr/lib64 ];then
#	ln -s %{_libdir}/libmsrpc.so $RPM_BUILD_ROOT/usr/lib/libmsrpc.so.0
#	ln -s %{_libdir}/libmsrpc.so $RPM_BUILD_ROOT/usr/lib/libmsrpc.so
#fi

# Install pam_smbpass.so
install -m755 source/bin/pam_smbpass.so $RPM_BUILD_ROOT/%{_lib}/security/pam_smbpass.so

# we need a symlink for mount to recognise the smb and smbfs filesystem types
ln -sf %{_prefix}/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs
ln -sf %{_prefix}/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smb

# Install the miscellany
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT%{_sysconfdir}/samba/lmhosts

install -m644 setup/samba.log $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/samba
install -m644 setup/swat $RPM_BUILD_ROOT%{_sysconfdir}/xinetd.d/swat
install -m644 setup/samba.sysconfig $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/samba
install -m755 setup/smb.init $RPM_BUILD_ROOT%{initdir}/smb
install -m755 setup/winbind.init $RPM_BUILD_ROOT%{initdir}/winbind
install -m644 setup/samba.pamd $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/samba
install -m755 setup/smbprint $RPM_BUILD_ROOT%{_bindir}
install -m644 setup/smbusers $RPM_BUILD_ROOT%{_sysconfdir}/samba/smbusers
install -m644 setup/smb.conf $RPM_BUILD_ROOT%{_sysconfdir}/samba/smb.conf
install -m755 source/client/mount.cifs $RPM_BUILD_ROOT/sbin/mount.cifs
install -m755 source/client/umount.cifs $RPM_BUILD_ROOT/sbin/umount.cifs
install -m755 source/script/mksmbpasswd.sh $RPM_BUILD_ROOT%{_bindir}

ln -s ../..%{initdir}/smb  $RPM_BUILD_ROOT%{_sbindir}/samba
ln -s ../..%{initdir}/winbind  $RPM_BUILD_ROOT%{_sbindir}/winbind

# Remove "*.old" files
find $RPM_BUILD_ROOT -name "*.old" -exec rm -f {} \;

## don't duplicate the docs.  These are installed by/with SWAT
rm -rf docs/htmldocs
rm -rf docs/manpages
( cd docs; ln -s %{_prefix}/share/swat/help htmldocs )

##
## Clean out man pages for tools not installed here
##
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/log2pcap.1*
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/smbsh.1*
rm -f $RPM_BUILD_ROOT%{_mandir}/man5/vfstest.1*


%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add smb

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb
    rm -rf /var/log/samba/* /var/cache/samba/*
    /sbin/service smb stop >/dev/null 2>&1
fi
exit 0

%postun
if [ "$1" -ge "1" ]; then
	%{initdir}/smb condrestart >/dev/null 2>&1
fi	


%post swat
# Add swat entry to /etc/services if not already there.
if [ ! "`grep ^\s**swat /etc/services`" ]; then
        echo 'swat        901/tcp     # Add swat service used via inetd' >> /etc/services
fi

%post common
/sbin/chkconfig --add winbind
/sbin/ldconfig

%preun common
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del winbind
    /sbin/service winbind stop >/dev/null 2>&1
fi
exit 0

%postun common -p /sbin/ldconfig

%triggerpostun -- samba < 1.9.18p7
if [ $1 != 0 ]; then
    /sbin/chkconfig --add smb
fi

%triggerpostun -- samba < 2.0.5a-3
if [ $1 != 0 ]; then
    [ ! -d /var/lock/samba ] && mkdir -m 0755 /var/lock/samba
    [ ! -d /var/spool/samba ] && mkdir -m 1777 /var/spool/samba
    chmod 644 /etc/services
    [ -f /etc/inetd.conf ] && chmod 644 /etc/inetd.conf
fi

%files
%defattr(-,root,root)
%doc README COPYING Manifest 
%doc WHATSNEW.txt Roadmap
%doc docs
%doc examples/autofs examples/LDAP examples/libsmbclient examples/misc examples/printer-accounting
%doc examples/printing

%attr(755,root,root) /%{_lib}/security/pam_smbpass.so
%{_sbindir}/samba
%{_sbindir}/winbind
%{_sbindir}/smbd
%{_sbindir}/nmbd
%{_bindir}/mksmbpasswd.sh
%{_bindir}/smbcontrol
%{_bindir}/smbstatus
%{_bindir}/tdbbackup
%{_bindir}/tdbtool
%config(noreplace) %{_sysconfdir}/sysconfig/samba
%config(noreplace) %{_sysconfdir}/samba/smbusers
%attr(755,root,root) %config %{initdir}/smb
%config(noreplace) %{_sysconfdir}/logrotate.d/samba
%config(noreplace) %{_sysconfdir}/pam.d/samba
%{_mandir}/man1/smbcontrol.1*
%{_mandir}/man1/smbstatus.1*
%{_mandir}/man1/vfstest.1*
%{_mandir}/man5/smbpasswd.5*
%{_mandir}/man7/samba.7*
%{_mandir}/man8/nmbd.8*
%{_mandir}/man8/pdbedit.8*
%{_mandir}/man8/smbd.8*
%{_mandir}/man7/pam_winbind.7*
%{_mandir}/man8/tdbbackup.8*
%{_mandir}/man7/libsmbclient.7*

%{_libdir}/samba/vfs

%attr(0700,root,root) %dir /var/log/samba
%attr(1777,root,root) %dir /var/spool/samba

%files swat
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/xinetd.d/swat
%{_datadir}/swat
%{_sbindir}/swat
%{_mandir}/man8/swat.8*
%attr(755,root,root) %{_libdir}/samba/*.msg

%files client
%defattr(-,root,root)
/sbin/mount.smb
/sbin/mount.smbfs
/sbin/mount.cifs
/sbin/umount.cifs
%{_libdir}/samba/lowcase.dat
%{_libdir}/samba/upcase.dat
%{_libdir}/samba/valid.dat
%{_bindir}/rpcclient
%{_bindir}/smbcacls
%{_bindir}/smbmount
%{_bindir}/smbmnt
%{_bindir}/smbumount
%{_bindir}/findsmb
%{_bindir}/tdbdump
%{_mandir}/man8/tdbdump.8*
%{_mandir}/man8/smbmnt.8*
%{_mandir}/man8/smbmount.8*
%{_mandir}/man8/smbumount.8*
%{_mandir}/man8/mount.cifs.8.*
%{_mandir}/man8/umount.cifs.8.*
%{_mandir}/man8/smbspool.8*
%{_bindir}/nmblookup
%{_bindir}/smbget
%{_bindir}/smbclient
%{_bindir}/smbprint
%{_bindir}/smbspool
%{_bindir}/smbtar
%{_bindir}/net
%{_bindir}/smbtree
%{_mandir}/man1/smbget.1*
%{_mandir}/man5/smbgetrc.5*
%{_mandir}/man1/findsmb.1*
%{_mandir}/man1/nmblookup.1*
%{_mandir}/man1/rpcclient.1*
%{_mandir}/man1/smbcacls.1*
%{_mandir}/man1/smbclient.1*
%{_mandir}/man1/smbtar.1*
%{_mandir}/man1/smbtree.1*
%{_mandir}/man8/net.8*

%files common
%defattr(-,root,root)
/%{_lib}/libnss_wins.so*
/%{_lib}/libnss_winbind.so*
/%{_lib}/security/pam_winbind.so
%{_includedir}/libsmbclient.h
%{_libdir}/libsmbclient.a
%{_libdir}/libsmbclient.so
%{_libdir}/libsmbclient.so.0
%{_includedir}/libmsrpc.h
%{_libdir}/libmsrpc.a
%{_libdir}/libmsrpc.so
%{_libdir}/libmsrpc.so.0
%{_libdir}/samba/charset/CP*.so
%{_libdir}/samba/idmap/*.so
%{_libdir}/samba/auth/script.so
%{_bindir}/testparm
%{_bindir}/smbpasswd
%{_bindir}/wbinfo
%{_bindir}/ntlm_auth
%{_bindir}/pdbedit
%{_bindir}/eventlogadm
%{_bindir}/profiles
%{_bindir}/smbcquotas
%{_sbindir}/winbindd
%config(noreplace) %{_sysconfdir}/samba/smb.conf
%config(noreplace) %{_sysconfdir}/samba/lmhosts
%dir %{_sysconfdir}/samba
%{initdir}/winbind
%{_mandir}/man1/ntlm_auth.1*
%{_mandir}/man1/profiles.1*
%{_mandir}/man1/smbcquotas.1*
%{_mandir}/man1/testparm.1*
%{_mandir}/man5/smb.conf.5*
%{_mandir}/man5/lmhosts.5*
%{_mandir}/man8/smbpasswd.8*
%{_mandir}/man1/wbinfo.1*
%{_mandir}/man8/winbindd.8*

%changelog
* Fri Jan 16 2004 Gerald (Jerry) Carter <jerry@samba,org>
- Removed ChangeLog entries since they are kept in CVS



