/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   NT Domain Authentication SMB / MSRPC client
   Copyright (C) Andrew Tridgell 1994-1997
   Copyright (C) Luke Kenneth Casson Leighton 1996-1997
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifdef SYSLOG
#undef SYSLOG
#endif

#include "../includes.h"
#include "../nterr.h"

extern int DEBUGLEVEL;



/****************************************************************************
 determine the status of the target machine.

 see stuff on well-known SIDS: level 3 is for server (S-1-3)
 see stuff on well-known SIDS: level 5 is for client (S-1-5)

 ****************************************************************************/
BOOL do_nt_status_check(struct in_addr dest_ip, char *dest_host, char *myhostname)
{
	POLICY_HND pol;
	RPC_IFACE abstract;
	RPC_IFACE transfer;

	/* received from LSA Query Info Policy, level 5 */
	fstring level5_domain_name;
	pstring level5_domain_sid;

	/* received from LSA Query Info Policy, level 3 */
	fstring level3_domain_name;
	pstring level3_domain_sid;

	fstring server_name;

	/* connection to the lsarpc pipe */
	struct cli_state cli;
	int fnum = -1;

	/******************** initialise ********************************/

	bzero(&cli, sizeof(cli));
	if (!cli_initialise(&cli))
	{
		DEBUG(1,("do_nt_status_check: cli_initialise failed\n"));
		return False;
	}

	DEBUG(1,("do_nt_status_check: server connect initialisation\n"));

	if (!server_connect_init(&cli, myhostname, dest_ip, dest_host))
	{
		uint8 err_cls;
		uint32 err_num;
		cli_error(&cli, &err_cls, &err_num);
		DEBUG(1,("server_connect_init failed (%s)\n", cli_errstr(&cli)));

		cli_shutdown(&cli);
		return False;
	}

	DEBUG(1,("do_nt_status_check: server connect initialisation succeeded\n"));
	
	if (!server_validate2(&cli, "", "", "", 1, NULL, 0))
	{
		uint8 err_cls;
		uint32 err_num;
		cli_error(&cli, &err_cls, &err_num);
		DEBUG(1,("server_validate2 failed (%s)\n", cli_errstr(&cli)));

		return False;
	}
	
	DEBUG(1,("do_nt_session_open: server IPC$ connection succeeded\n"));

	/******************** Open the \PIPE\lsarpc *******************/

	if ((fnum = cli_open(&cli, PIPE_LSARPC, O_CREAT, DENY_NONE,
	                     NULL, NULL, NULL)) == 0xffff)
	{
		cli_shutdown(&cli);
		return False;
	}

	/**************** Set Named Pipe State ***************/

	if (!rpc_pipe_set_hnd_state(&cli, PIPE_LSARPC, (uint16)fnum, 0x4300))
	{
		cli_shutdown(&cli);
		return False;
	}

	/******************* bind request on \PIPE\lsarpc *****************/

	/* create and send a MSRPC command with api LSA_OPENPOLICY */

	DEBUG(4,("LSA RPC Bind[%x]\n", (uint16)fnum));

	if (!rpc_pipe_bind(&cli, PIPE_LSARPC, (uint16)fnum, &abstract, &transfer))
	{
		cli_shutdown(&cli);
		return False;
	}

	/******************* Open Policy ********************/

	fstrcpy(server_name, ("\\\\"));
	fstrcpy(&server_name[2], myhostname);

	/* send an open policy request; receive a policy handle */
	if (!do_lsa_open_policy(&cli, (uint16)fnum, server_name, &pol))
	{
		cli_close(&cli, fnum, 0);
		cli_shutdown(&cli);
		return False;
	}

	/**************** Query Info Policy, level 3 ********************/

	/* send a query info policy at level 3; receive an info policy */
	if (!do_lsa_query_info_pol(&cli, (uint16)fnum, &pol, 0x3,
	                           level3_domain_name, level3_domain_sid))
	{
		cli_close(&cli, (uint16)fnum, 0);
		cli_shutdown(&cli);
		return False;
	}

	/**************** Query Info Policy, level 5 ********************/

	/* send a query info policy at level 5; receive an info policy */
	if (!do_lsa_query_info_pol(&cli, (uint16)fnum, &pol, 0x5,
	                           level5_domain_name, level5_domain_sid))
	{
		cli_close(&cli, (uint16)fnum, 0);
		cli_shutdown(&cli);
		return False;
	}

	/******************* Open Policy ********************/

	/* send a close policy request; receive a close pol response */
	if (!do_lsa_close(&cli, (uint16)fnum, &pol))
	{
		cli_close(&cli, (uint16)fnum, 0);
		cli_shutdown(&cli);
		return False;
	}

	/******************* close the \PIPE\lsarpc file *******************/

	cli_close(&cli, (uint16)fnum, 0);
	cli_shutdown(&cli);

	return True;
}


