
/* 
 *  Unix SMB/Netbios implementation.
 *  Version 1.9.
 *  RPC Pipe client / server routines
 *  Copyright (C) Andrew Tridgell              1992-1997,
 *  Copyright (C) Luke Kenneth Casson Leighton 1996-1997,
 *  Copyright (C) Paul Ashton                       1997.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef SYSLOG
#undef SYSLOG
#endif

#include "../includes.h"

extern int DEBUGLEVEL;

/****************************************************************************
experimental srv tests
****************************************************************************/
BOOL do_srv_session_open(struct cli_state *cli, int t_idx, struct client_info *info)
{
	RPC_IFACE abstract;
	RPC_IFACE transfer;

	/******************** initialise ********************************/

	DEBUG(1,("do_srv_session_open: %d\n", __LINE__));

	/******************* open the \PIPE\srvsvc file *****************/

	if ((info->dom.srvsvc_fnum = cli_open(cli, t_idx, PIPE_SRVSVC, O_CREAT, DENY_NONE,
	                         NULL, NULL, NULL)) == 0xffff)
	{
		DEBUG(1,("do_srv_session_open: cli_open failed\n"));
		return False;
	}

	/**************** Set Named Pipe State ***************/
	if (!rpc_pipe_set_hnd_state(cli, t_idx, PIPE_SRVSVC, info->dom.srvsvc_fnum, 0x4300))
	{
		DEBUG(1,("do_srv_session_open: pipe hnd state failed\n"));
		return False;
	}

	/******************* bind request on \PIPE\srvsvc *****************/

	if (!rpc_pipe_bind(cli, t_idx, PIPE_SRVSVC, info->dom.srvsvc_fnum, &abstract, &transfer))
	{
		DEBUG(1,("do_srv_session_open: rpc bind failed\n"));
		return False;
	}

	return True;
}


/****************************************************************************
close the \PIPE\srv session
****************************************************************************/
void do_srv_session_close(struct cli_state *cli, int t_idx, struct client_info *info)
{
	if (info->dom.srvsvc_fnum != 0xffff)
	{
		cli_close(cli, t_idx, info->dom.srvsvc_fnum, 0);
	}
}


/****************************************************************************
do a server net conn enum
****************************************************************************/
BOOL do_srv_net_srv_conn_enum(struct cli_state *cli, int t_idx, uint16 fnum,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_CONN_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd)
{
	struct mem_buffer data; 
	struct mem_buffer rdata;
	struct mem_buffer rparams;
	int p = 0, r = 0;
	SRV_Q_NET_CONN_ENUM q_o;
    BOOL valid_enum = False;

	if (server_name == NULL || ctr == NULL || preferred_len == 0) return False;

	buf_init(&data   , 4, SAFETY_MARGIN);
	buf_init(&rdata  , 4, SAFETY_MARGIN);
	buf_init(&rparams, 4, SAFETY_MARGIN);

	buf_alloc(&data , 1024);

	/* create and send a MSRPC command with api SRV_NETCONNENUM */

	DEBUG(4,("SRV Net Server Connection Enum(%s, %s), level %d, enum:%8x\n",
				server_name, qual_name, switch_value, get_enum_hnd(hnd)));
				
	ctr->switch_value = switch_value;
	ctr->ptr_conn_ctr = 1;
	ctr->conn.info0.num_entries_read = 0;
	ctr->conn.info0.ptr_conn_info    = 1;

	/* store the parameters */
	make_srv_q_net_conn_enum(&q_o, server_name, qual_name,
	                         switch_value, ctr,
	                         preferred_len,
	                         hnd);

	/* turn parameters into data stream */
	p = 0x18;
	srv_io_q_net_conn_enum("", False, &q_o, &data, &p, 0);

	data.data_used = p;

	/* create the request RPC_HDR_RR with no data */
	create_rpc_request(&data, &r, get_rpc_call_id(), SRV_NETCONNENUM, p);

	/* send the data on \PIPE\ */
	if (rpc_api_pipe(cli, t_idx, 0x0026, fnum, NULL, &data, &rparams, &rdata))
	{
		SRV_R_NET_CONN_ENUM r_o;
		RPC_HDR_RR hdr;
		int hdr_len;
		int pkt_len;

		r_o.ctr = ctr;

		DEBUG(5, ("cli_api_pipe: return OK\n"));

		p = 0;

		smb_io_rpc_hdr_rr   ("", True, &hdr, &rdata, &p, 0);
		if (p) buf_align(&rdata, &p); /* oh, what a surprise */

		hdr_len = p;

		if (p && hdr_len != hdr.hdr.frag_len - hdr.alloc_hint)
		{
			/* header length not same as calculated header length */
			DEBUG(2,("do_srv_open_policy: hdr_len %x != frag_len-alloc_hint %x\n",
			          hdr_len, hdr.hdr.frag_len - hdr.alloc_hint));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p) srv_io_r_net_conn_enum("", True, &r_o, &rdata, &p, 0);
		
		pkt_len = p;

		if (p && pkt_len != hdr.hdr.frag_len)
		{
			/* packet data size not same as reported fragment length */
			DEBUG(2,("do_srv_open_policy: pkt_len %x != frag_len \n",
			                           pkt_len, hdr.hdr.frag_len));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p && r_o.status != 0)
		{
			/* report error code */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: %s\n", get_nt_error_msg(r_o.status)));
			p = 0;
		}

		if (p && r_o.ctr->switch_value != switch_value)
		{
			/* different switch levels.  oops. */
			DEBUG(0,("SRV_R_NET_SRV_CONN_ENUM: info class %d does not match request %d\n",
				r_o.ctr->switch_value, switch_value));
			p = 0;
		}

		if (p)
		{
			/* ok, at last: we're happy. */
			valid_enum = True;
		}
	}

	buf_free(&data   );
	buf_free(&rdata  );
	buf_free(&rparams);
	
	return valid_enum;
}

/****************************************************************************
do a server net sess enum
****************************************************************************/
BOOL do_srv_net_srv_sess_enum(struct cli_state *cli, int t_idx, uint16 fnum,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_SESS_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd)
{
	struct mem_buffer data; 
	struct mem_buffer rdata;
	struct mem_buffer rparams;
	int p = 0, r = 0;
	SRV_Q_NET_SESS_ENUM q_o;
    BOOL valid_enum = False;

	if (server_name == NULL || ctr == NULL || preferred_len == 0) return False;

	buf_init(&data   , 4, SAFETY_MARGIN);
	buf_init(&rdata  , 4, SAFETY_MARGIN);
	buf_init(&rparams, 4, SAFETY_MARGIN);

	buf_alloc(&data , 1024);

	/* create and send a MSRPC command with api SRV_NETSESSENUM */

	DEBUG(4,("SRV Net Session Enum (%s), level %d, enum:%8x\n",
				server_name, switch_value, get_enum_hnd(hnd)));
				
	ctr->switch_value = switch_value;
	ctr->ptr_sess_ctr = 1;
	ctr->sess.info0.num_entries_read = 0;
	ctr->sess.info0.ptr_sess_info    = 1;

	/* store the parameters */
	make_srv_q_net_sess_enum(&q_o, server_name, qual_name,
	                         switch_value, ctr,
	                         preferred_len,
	                         hnd);

	/* turn parameters into data stream */
	p = 0x18;
	srv_io_q_net_sess_enum("", False, &q_o, &data, &p, 0);

	data.data_used = p;

	/* create the request RPC_HDR_RR with no data */
	create_rpc_request(&data, &r, get_rpc_call_id(), SRV_NETSESSENUM, p);

	/* send the data on \PIPE\ */
	if (rpc_api_pipe(cli, t_idx, 0x0026, fnum, NULL, &data, &rparams, &rdata))
	{
		SRV_R_NET_SESS_ENUM r_o;
		RPC_HDR_RR hdr;
		int hdr_len;
		int pkt_len;

		r_o.ctr = ctr;

		DEBUG(5, ("cli_api_pipe: return OK\n"));

		p = 0;

		smb_io_rpc_hdr_rr   ("", True, &hdr, &rdata, &p, 0);
		if (p) buf_align(&rdata, &p); /* oh, what a surprise */

		hdr_len = p;

		if (p && hdr_len != hdr.hdr.frag_len - hdr.alloc_hint)
		{
			/* header length not same as calculated header length */
			DEBUG(2,("do_srv_open_policy: hdr_len %x != frag_len-alloc_hint %x\n",
			          hdr_len, hdr.hdr.frag_len - hdr.alloc_hint));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p) srv_io_r_net_sess_enum("", True, &r_o, &rdata, &p, 0);
		
		pkt_len = p;

		if (p && pkt_len != hdr.hdr.frag_len)
		{
			/* packet data size not same as reported fragment length */
			DEBUG(2,("do_srv_open_policy: pkt_len %x != frag_len \n",
			                           pkt_len, hdr.hdr.frag_len));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p && r_o.status != 0)
		{
			/* report error code */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: %s\n", get_nt_error_msg(r_o.status)));
			p = 0;
		}

		if (p && r_o.ctr->switch_value != switch_value)
		{
			/* different switch levels.  oops. */
			DEBUG(0,("SRV_R_NET_SRV_SESS_ENUM: info class %d does not match request %d\n",
				r_o.ctr->switch_value, switch_value));
			p = 0;
		}

		if (p)
		{
			/* ok, at last: we're happy. */
			valid_enum = True;
		}
	}

	buf_free(&data   );
	buf_free(&rdata  );
	buf_free(&rparams);
	
	return valid_enum;
}

/****************************************************************************
do a server net share enum
****************************************************************************/
BOOL do_srv_net_srv_share_enum(struct cli_state *cli, int t_idx, uint16 fnum,
			char *server_name, 
			uint32 switch_value, SRV_SHARE_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd)
{
	struct mem_buffer data; 
	struct mem_buffer rdata;
	struct mem_buffer rparams;
	int p = 0, r = 0;
	SRV_Q_NET_SHARE_ENUM q_o;
    BOOL valid_enum = False;

	if (server_name == NULL || ctr == NULL || preferred_len == 0) return False;

	buf_init(&data   , 4, SAFETY_MARGIN);
	buf_init(&rdata  , 4, SAFETY_MARGIN);
	buf_init(&rparams, 4, SAFETY_MARGIN);

	buf_alloc(&data , 1024);

	/* create and send a MSRPC command with api SRV_NETSHAREENUM */

	DEBUG(4,("SRV Get Share Info (%s), level %d, enum:%8x\n",
				server_name, switch_value, get_enum_hnd(hnd)));
				
	q_o.share_level = switch_value;

	ctr->switch_value = switch_value;
	ctr->ptr_share_ctr = 1;
	ctr->share.info1.num_entries_read = 0;
	ctr->share.info1.ptr_share_info    = 1;

	/* store the parameters */
	make_srv_q_net_share_enum(&q_o, server_name, 
	                         switch_value, ctr,
	                         preferred_len,
	                         hnd);

	/* turn parameters into data stream */
	p = 0x18;
	srv_io_q_net_share_enum("", False, &q_o, &data, &p, 0);

	data.data_used = p;

	/* create the request RPC_HDR_RR with no data */
	create_rpc_request(&data, &r, get_rpc_call_id(), SRV_NETSHAREENUM, p);

	/* send the data on \PIPE\ */
	if (rpc_api_pipe(cli, t_idx, 0x0026, fnum, NULL, &data, &rparams, &rdata))
	{
		SRV_R_NET_SHARE_ENUM r_o;
		RPC_HDR_RR hdr;
		int hdr_len;
		int pkt_len;

		r_o.ctr = ctr;

		DEBUG(5, ("cli_api_pipe: return OK\n"));

		p = 0;

		smb_io_rpc_hdr_rr   ("", True, &hdr, &rdata, &p, 0);
		if (p) buf_align(&rdata, &p); /* oh, what a surprise */

		hdr_len = p;

		if (p && hdr_len != hdr.hdr.frag_len - hdr.alloc_hint)
		{
			/* header length not same as calculated header length */
			DEBUG(2,("do_srv_open_policy: hdr_len %x != frag_len-alloc_hint %x\n",
			          hdr_len, hdr.hdr.frag_len - hdr.alloc_hint));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p) srv_io_r_net_share_enum("", True, &r_o, &rdata, &p, 0);
		
		pkt_len = p;

		if (p && pkt_len != hdr.hdr.frag_len)
		{
			/* packet data size not same as reported fragment length */
			DEBUG(2,("do_srv_open_policy: pkt_len %x != frag_len \n",
			                           pkt_len, hdr.hdr.frag_len));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p && r_o.status != 0)
		{
			/* report error code */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: %s\n", get_nt_error_msg(r_o.status)));
			p = 0;
		}

		if (p && r_o.ctr->switch_value != switch_value)
		{
			/* different switch levels.  oops. */
			DEBUG(0,("SRV_R_NET_SRV_SHARE_ENUM: info class %d does not match request %d\n",
				r_o.ctr->switch_value, switch_value));
			p = 0;
		}

		if (p)
		{
			/* ok, at last: we're happy. */
			valid_enum = True;
		}
	}

	buf_free(&data   );
	buf_free(&rdata  );
	buf_free(&rparams);
	
	return valid_enum;
}

/****************************************************************************
do a server net file enum
****************************************************************************/
BOOL do_srv_net_srv_file_enum(struct cli_state *cli, int t_idx, uint16 fnum,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_FILE_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd)
{
	struct mem_buffer data; 
	struct mem_buffer rdata;
	struct mem_buffer rparams;
	int p = 0, r = 0;
	SRV_Q_NET_FILE_ENUM q_o;
    BOOL valid_enum = False;

	if (server_name == NULL || ctr == NULL || preferred_len == 0) return False;

	buf_init(&data   , 4, SAFETY_MARGIN);
	buf_init(&rdata  , 4, SAFETY_MARGIN);
	buf_init(&rparams, 4, SAFETY_MARGIN);

	buf_alloc(&data , 1024);

	/* create and send a MSRPC command with api SRV_NETFILEENUM */

	DEBUG(4,("SRV Get File Info (%s), level %d, enum:%8x\n",
				server_name, switch_value, get_enum_hnd(hnd)));
				
	q_o.file_level = switch_value;

	ctr->switch_value = switch_value;
	ctr->ptr_file_ctr = 1;
	ctr->file.info3.num_entries_read = 0;
	ctr->file.info3.ptr_file_info    = 1;

	/* store the parameters */
	make_srv_q_net_file_enum(&q_o, server_name, qual_name,
	                         switch_value, ctr,
	                         preferred_len,
	                         hnd);

	/* turn parameters into data stream */
	p = 0x18;
	srv_io_q_net_file_enum("", False, &q_o, &data, &p, 0);

	data.data_used = p;

	/* create the request RPC_HDR_RR with no data */
	create_rpc_request(&data, &r, get_rpc_call_id(), SRV_NETFILEENUM, p);

	/* send the data on \PIPE\ */
	if (rpc_api_pipe(cli, t_idx, 0x0026, fnum, NULL, &data, &rparams, &rdata))
	{
		SRV_R_NET_FILE_ENUM r_o;
		RPC_HDR_RR hdr;
		int hdr_len;
		int pkt_len;

		r_o.ctr = ctr;

		DEBUG(5, ("cli_api_pipe: return OK\n"));

		p = 0;

		smb_io_rpc_hdr_rr   ("", True, &hdr, &rdata, &p, 0);
		if (p) buf_align(&rdata, &p); /* oh, what a surprise */

		hdr_len = p;

		if (p && hdr_len != hdr.hdr.frag_len - hdr.alloc_hint)
		{
			/* header length not same as calculated header length */
			DEBUG(2,("do_srv_open_policy: hdr_len %x != frag_len-alloc_hint %x\n",
			          hdr_len, hdr.hdr.frag_len - hdr.alloc_hint));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p) srv_io_r_net_file_enum("", True, &r_o, &rdata, &p, 0);
		
		pkt_len = p;

		if (p && pkt_len != hdr.hdr.frag_len)
		{
			/* packet data size not same as reported fragment length */
			DEBUG(2,("do_srv_open_policy: pkt_len %x != frag_len \n",
			                           pkt_len, hdr.hdr.frag_len));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p && r_o.status != 0)
		{
			/* report error code */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: %s\n", get_nt_error_msg(r_o.status)));
			p = 0;
		}

		if (p && r_o.ctr->switch_value != switch_value)
		{
			/* different switch levels.  oops. */
			DEBUG(0,("SRV_R_NET_SRV_FILE_ENUM: info class %d does not match request %d\n",
				r_o.ctr->switch_value, switch_value));
			p = 0;
		}

		if (p)
		{
			/* ok, at last: we're happy. */
			valid_enum = True;
		}
	}

	buf_free(&data   );
	buf_free(&rdata  );
	buf_free(&rparams);
	
	return valid_enum;
}

/****************************************************************************
do a server get info 
****************************************************************************/
BOOL do_srv_net_srv_get_info(struct cli_state *cli, int t_idx, uint16 fnum,
			char *server_name, uint32 switch_value, SRV_INFO_CTR *ctr)
{
	struct mem_buffer data; 
	struct mem_buffer rdata;
	struct mem_buffer rparams;
	int p = 0, r = 0;
	SRV_Q_NET_SRV_GET_INFO q_o;
    BOOL valid_info = False;

	if (server_name == NULL || switch_value == 0 || ctr == NULL) return False;

	buf_init(&data   , 4, SAFETY_MARGIN);
	buf_init(&rdata  , 4, SAFETY_MARGIN);
	buf_init(&rparams, 4, SAFETY_MARGIN);

	buf_alloc(&data , 1024);

	/* create and send a MSRPC command with api SRV_NET_SRV_GET_INFO */

	DEBUG(4,("SRV Get Server Info (%s), level %d\n", server_name, switch_value));

	/* store the parameters */
	make_srv_q_net_srv_get_info(&q_o, server_name, switch_value);

	/* turn parameters into data stream */
	p = 0x18;
	srv_io_q_net_srv_get_info("", False, &q_o, &data, &p, 0);

	data.data_used = p;

	/* create the request RPC_HDR_RR with no data */
	create_rpc_request(&data, &r, get_rpc_call_id(), SRV_NET_SRV_GET_INFO, p);

	/* send the data on \PIPE\ */
	if (rpc_api_pipe(cli, t_idx, 0x0026, fnum, NULL, &data, &rparams, &rdata))
	{
		SRV_R_NET_SRV_GET_INFO r_o;
		RPC_HDR_RR hdr;
		int hdr_len;
		int pkt_len;

		r_o.ctr = ctr;

		DEBUG(5, ("cli_api_pipe: return OK\n"));

		p = 0;

		smb_io_rpc_hdr_rr   ("", True, &hdr, &rdata, &p, 0);
		if (p) buf_align(&rdata, &p); /* oh, what a surprise */

		hdr_len = p;

		if (p && hdr_len != hdr.hdr.frag_len - hdr.alloc_hint)
		{
			/* header length not same as calculated header length */
			DEBUG(2,("do_srv_open_policy: hdr_len %x != frag_len-alloc_hint %x\n",
			          hdr_len, hdr.hdr.frag_len - hdr.alloc_hint));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p) srv_io_r_net_srv_get_info("", True, &r_o, &rdata, &p, 0);
		
		pkt_len = p;

		if (p && pkt_len != hdr.hdr.frag_len)
		{
			/* packet data size not same as reported fragment length */
			DEBUG(2,("do_srv_open_policy: pkt_len %x != frag_len \n",
			                           pkt_len, hdr.hdr.frag_len));
#ifdef CATCH_RPC_FRAG_LEN_ERRORS
			p = 0;
#endif
		}

		if (p && r_o.status != 0)
		{
			/* report error code */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: %s\n", get_nt_error_msg(r_o.status)));
			p = 0;
		}

		if (p && r_o.ctr->switch_value != q_o.switch_value)
		{
			/* different switch levels.  oops. */
			DEBUG(0,("SRV_R_NET_SRV_GET_INFO: info class %d does not match request %d\n",
				r_o.ctr->switch_value, q_o.switch_value));
			p = 0;
		}

		if (p)
		{
			/* ok, at last: we're happy. */
			valid_info = True;
		}
	}

	buf_free(&data   );
	buf_free(&rdata  );
	buf_free(&rparams);
	
	return valid_info;
}

