/* test_smb.c                                                               */
/* Copyright (C) Richard Sharpe, 1996                                       */
/*                                                                          */
/* We test some things out in SMB servers ...                               */

/* A test for smblib that does nasty things ...... */

#include <sys/types.h>
#include <unistd.h>

#include "smblib.h"

#define DEFAULT "msfax"

char err_string[1024];

char data[65536] = "Now is the time for all birds to roost.";
char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "LANMAN1.0",
			    "LM1.2X002",
			    "Samba",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
			    NULL};


void *connect_server(char *server, char *user, char *password)

{ void *con;
  int prot, SMB_Error;

  fprintf(stderr, "Connecting to server \\\\%s ...\n", server);

  con = SMB_Connect_Server(NULL, server);

  if (con == NULL) { /* Error ... */

    fprintf(stderr, "Unable to connect to server \"%s\" ... \n", server);

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("Error in calling: %s ...\n", err_string);
    exit(1);

  }

  /* Now do a negotiate ... */

  fprintf(stderr, "Now we negotiate a protocol ... \n");

  if (SMB_Negotiate(con, SMB_Prots) < 0) { /* An error */

    fprintf(stderr, "Unable to negotiate a protocol ...\n");

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s ...\n", err_string);
    exit(1);

  }

  prot = SMB_Get_Protocol_IDX(con);

  fprintf(stderr, "  The protocol accepted was %i, %s\n", prot, 
	  SMB_Prots[prot]);

  /* Now we do a logon ... */

  fprintf(stderr, "Now try to logon as %s ...\n", user);

  if (SMB_Logon_Server(con, user, password) < 0) {

    fprintf(stderr, "Unable to logon to server ...\n");
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  %s ...\n", err_string);
    fprintf(stderr, "This error ignored. We will keep going and hope ...\n");

  }

  return(con);

}


/* Do various tests on tree connects ... Assumes that we have logged in
   or in some way will be able to                                       */

void test_tree_connect(void *con, char *service, char *server, char *user,
		       char *password)

{ char service_type[80];
  int i, SMB_Error, error;
  void *tree;

  /* Try to connect to the service name first with A: as a service type */

  fprintf(stderr, "Connecting to service %s as service type A:\n", service);

  strcpy(service_type, "A:");

  if ((tree = SMB_TreeConnect(con, NULL, 
			      service, password, service_type)) == NULL) {

    fprintf(stderr, "Unable to connect to the tree ... See if others work\n");
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  Error trying to connect: %s \n", err_string);

    error = abs(SMB_Get_Last_Error());

    if (error == SMBlibE_SendFailed || error == SMBlibE_RecvFailed) {

      /* Some sort of problem at the protocol layer, drop the connection */
      /* and reconnect                                                   */

      SMB_Discon(con, FALSE);

      con = connect_server(server, user, password);

    }
  }
  else {

    fprintf(stderr, "Connected successfully to %s as service type %s\n", 
	    service, service_type);
    fprintf(stderr, "  The TID was: %i\n", SMB_Get_Tree_TID(tree));

    fprintf(stderr, "  Max Buf Size = %i\n", SMB_Get_Tree_MBS(tree));

    if (SMB_TreeDisconnect(tree, FALSE) < 0) {

      fprintf(stderr, "Unable to disconnect from the tree ...\n");
      RFCNB_Get_Error(err_string, sizeof(err_string));
      printf("Error in calling: %s ...\n", err_string);
      exit(1);

    }

  }

  /* Now try to connect using other service types ... */

  for (i = 2; i <= 26; i++) {     /* Skip A */

    service_type[0] = ('A' + (i - 1));

    fprintf(stderr, "Now trying to connect to %s as service type %s\n",
	    service, service_type);

    if ((tree = SMB_TreeConnect(con, NULL, 
				service, password, service_type)) == NULL) {

      fprintf(stderr, "Unable to connect to the tree ... See if others work\n");
      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, 
			  sizeof(err_string) - 1);
      }
    
      fprintf(stderr, "  Error trying to connect: %s \n", err_string);

      error = abs(SMB_Get_Last_Error());

      if (error == SMBlibE_SendFailed || error == SMBlibE_RecvFailed) {

	/* Some sort of problem at the protocol layer, drop the connection */
	/* and reconnect                                                   */

	SMB_Discon(con, FALSE);

	con = connect_server(server, user, password);
      }
    }
    else {
      
      fprintf(stderr, "Connected OK to the tree %s as device type %s, now we disconnect.\n",
	      service, service_type);
      fprintf(stderr, "  The TID was: %i\n", SMB_Get_Tree_TID(tree));
      fprintf(stderr, "  Max Buf Size = %i\n", SMB_Get_Tree_MBS(tree));
      
      if (SMB_TreeDisconnect(tree, TRUE) < 0) {

	fprintf(stderr, "Unable to disconnect from the tree ...\n");
	RFCNB_Get_Error(err_string, sizeof(err_string));
	printf("Error in calling: %s ...\n", err_string);
	exit(1);
	
      }

    }
  }
}

main(int argc, char *argv[])

{ void *con, *file;

  int written, actual_size, i, prot, mbs;

  char server[80], service[80], called[80];
  char service_unc[80], password[80], user[80];
  actual_size = 8192;

  if (argc >= 2) { 
    strncpy(server, argv[1], sizeof(server) - 1);
  }

  if (argc >= 3)  /* Copy service */
    strncpy(service, argv[2], sizeof(service) - 1);
  else
    strncpy(service, DEFAULT, sizeof(service) - 1);

  if (argc >= 4) /* Copy username */
    strncpy(user, argv[3], sizeof(user) - 1);
  else
    strcpy(user, "fred");

  if (argc >= 5) /* Copy password */
    strncpy(password, argv[4], sizeof(password) -1);
  else
    strcpy(password, "nurk");

  SMB_Init();

  con = connect_server(server, user, password);

  sprintf(service_unc, "\\\\%s\\%s", server, service);

  test_tree_connect(con, service, server, user, password);

  SMB_Discon(con, FALSE);

}



