/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib Utility routines for changing parts of structures so I can test
   SMB servers. These routines can do nasty things and should not be 
   available.

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "smblib-priv.h"

#include "../rfcnb/rfcnb.h"

/* Set the tid to what we want ... we trunc to 0xFFFF                     */

int SMB_Set_Tree_TID(SMB_Tree_Handle Tree_Handle, int new_tid)

{

  if (new_tid < 0 || new_tid > 0x0000FFFF)
    Tree_Handle -> tid = 0x0000FFFF;
  else
    Tree_Handle -> tid = new_tid;

}

int SMB_Get_Tree_TID(SMB_Tree_Handle Tree_Handle)

{

  if (Tree_Handle != NULL)
    return(Tree_Handle -> tid);
  else
    return(0xFFFF);

}

/* Set the con to a new one in the tree handle */

int SMB_Set_Tree_Con(SMB_Tree_Handle tree, SMB_Handle_Type con)

{

  tree -> con = con;

}

/* Create a tree handle */

void *SMB_Create_Tree_Handle(SMB_Handle_Type con)

{ SMB_Tree_Handle tree;

  tree = (SMB_Tree_Handle)malloc(sizeof(struct SMB_Tree_Structure));

  if (tree == NULL) {

    return(NULL);

  }
  else {

    tree -> con = con;

  }

  return(tree);
}
