/* Test password changing ... */

#include <sys/types.h>
#include <unistd.h>

#include "smblib.h"

char data[65536] = "Now is the time for all birds to roost.";
char slosh[2] = "\\";

int verbose = FALSE;
int lotc = FALSE;

char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "LANMAN1.0",
			    "LM1.2X002",
		            "LANMAN2.1",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
			    NULL};

void usage()

{
  fprintf(stderr,"Usage: test_password -u <user> -p <password> -o <oldpass> server\n");
}

main(int argc, char *argv[])

{ void *con, *tree;
  extern char *optarg;
  extern int optind;
  int opt, error, SMB_Error, err_class, err_code, apiStatus;
  char server[80], service[80], service_name[160], password[80], username[80];
  char old_password[80], err_string[1024];

  server[0] = 0;
  strncpy(service, "IPC$", sizeof(service) - 1);
  service_name[0] = 0;
  username[0] = 0;
  password[0] = 0;
  old_password[0] = 0;

  while ((opt = getopt(argc, argv, "s:u:o:p:v")) != EOF) {

    switch (opt) {
    case 's':

      strcpy(service, optarg);
      break;

    case 'u':     /* Pick up the user name */

      strncpy(username, optarg, sizeof(username) - 1);
      break;

    case 'l':     /* do a logon and tree connect ... */
      lotc = TRUE;
      break;

    case 'v':     /* Verbose? */
      verbose = TRUE;
      break;

    case 'p':     /* Pick up the password */
      strncpy(password, optarg, sizeof(password) - 1);
      break;

    case 'o':     /* Pick up old password */
      strncpy(old_password, optarg, sizeof(old_password) - 1);
      break;

    default:

      usage();
      exit(1);
      break;
    }

  }

  if (optind < argc) { /* Some more parameters, assume is the server */
    strncpy(server, argv[optind], sizeof(server) - 1);
    optind++;
  }
  else {
    strcpy(server, "nemesis");
  }

  if (verbose == TRUE) {  /* Print out all we know */

    fprintf(stderr, "Changing password for User: %s, on server: %s\n",
	    username, server);
    fprintf(stderr, "         from: %s, to: %s\n", old_password, password);

  }

  SMB_Init();          /* Initialize things ... */

  /* We connect to the server and negotiate */

  con = SMB_Connect_Server(NULL, server);

  if (con == NULL) {  /* Error processing */

    fprintf(stderr, "Unable to connect to server %s ...\n", server);

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s\n", err_string);
    exit(1);

  }

  /* We need to negotiate a protocol better than PC NetWork Program */

  if (SMB_Negotiate(con, SMB_Prots) < 0) {

    fprintf(stderr, "Unable to negotiate a protocol with server %s ...\n",
	    server);

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s\n", err_string);
    exit(1);

  }

  sprintf(service_name, "\\\\%s\\%s", server, service); /* Could blow up */

  if ((tree = SMB_Logon_And_TCon(con, 
				 NULL, 
				 username, 
				 old_password, 
				 service_name, "?????")) == NULL) {

    fprintf(stderr, "Unable to logon and tree connect to server %s ...\n",
	    server);

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }
    
    printf("  %s\n", err_string);

    exit(1);       /* Too bad ... */
  }

  /* OK, now we have a tree ... Issue the api call ... */

  if (SMBapi_NetUserPasswordSet(tree, username, 
				old_password, password, &apiStatus) < 0) {

    fprintf(stderr, "Unable to change password on server %s ...\n",
	    server);

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s\n", err_string);

    exit(1);       /* Too bad ... */

  }

  if (apiStatus != 0) {

    fprintf(stderr, "Password change failed. Status is: %i\n", apiStatus);

  }
  else {

    fprintf(stderr, "Password change succeeded.\n");

  }
}
