/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib Defines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "std-defines.h"

/* Just define all the entry points */

/* Create a handle to allow us to set/override some parameters ...       */

void *SMB_Create_Handle();

/* Connect to a server and give us back a handle. If Con == NULL, create */
/* The handle and populate it with defaults                              */

void *SMB_Connect(void *Con, char *name, char *User, char *Password);

/* Connect to a tree ...                                                 */

int SMB_TCon();

/* Open a file                                                           */

int SMB_Open(); 

/* Close a file                                                          */

int SMB_Close();

/* Disconnect from server. Has flag to specify whether or not we keep the */
/* handle.                                                                */

int SMB_Discon(void *Con, BOOL KeepHandle);
