
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_wmi.h"
#include "autoconf/librpc/gen_ndr/ndr_wmi_c.h"

#include "librpc/gen_ndr/orpc.h"
#include "librpc/gen_ndr/dcom.h"
#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject BSTR_Type;
staticforward PyTypeObject IWbemClassObject_InterfaceType;

staticforward PyTypeObject CIMSTRINGS_Type;
staticforward PyTypeObject IWbemServices_InterfaceType;

staticforward PyTypeObject IEnumWbemClassObject_InterfaceType;

staticforward PyTypeObject IWbemContext_InterfaceType;

staticforward PyTypeObject IWbemLevel1Login_InterfaceType;

staticforward PyTypeObject WBEMDATA_Type;
staticforward PyTypeObject WBEMDATA4_Type;
staticforward PyTypeObject WBEMDATA3_Type;
staticforward PyTypeObject WBEMDATA2_Type;
staticforward PyTypeObject WBEMDATA1_Type;
staticforward PyTypeObject WBEMDATA0_Type;
staticforward PyTypeObject IWbemWCOSmartEnum_InterfaceType;

staticforward PyTypeObject IWbemFetchSmartEnum_InterfaceType;

staticforward PyTypeObject IWbemCallResult_InterfaceType;

staticforward PyTypeObject IWbemObjectSink_InterfaceType;

void initwmi(void);static PyTypeObject *ORPCTHIS_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *MInterfacePointer_Type;
static PyTypeObject *ORPCTHAT_Type;

static PyObject *py_BSTR_get_flags(PyObject *obj, void *closure)
{
	struct BSTR *object = (struct BSTR *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_BSTR_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BSTR *object = (struct BSTR *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_BSTR_get_data(PyObject *obj, void *closure)
{
	struct BSTR *object = (struct BSTR *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyUnicode_Decode(object->data, strlen(object->data), "utf-8", "ignore");
	}
	return py_data;
}

static int py_BSTR_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BSTR *object = (struct BSTR *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->data = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->data = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_BSTR_getsetters[] = {
	{ discard_const_p(char, "flags"), py_BSTR_get_flags, py_BSTR_set_flags },
	{ discard_const_p(char, "data"), py_BSTR_get_data, py_BSTR_set_data },
	{ NULL }
};

static PyObject *py_BSTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct BSTR, type);
}


static PyTypeObject BSTR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.BSTR",
	.tp_getset = py_BSTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_BSTR_new,
};


static bool pack_py_Delete_args_in(PyObject *args, PyObject *kwargs, struct Delete *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_wszName;
	const char *kwnames[] = {
		"ORPCthis", "wszName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:Delete", discard_const_p(char *, kwnames), &py_ORPCthis, &py_wszName)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.wszName = talloc_ptrtype(r, r->in.wszName);
	if (PyUnicode_Check(py_wszName)) {
		r->in.wszName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszName, "utf-8", "ignore"));
	} else if (PyString_Check(py_wszName)) {
		r->in.wszName = PyString_AS_STRING(py_wszName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszName)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_Delete_args_out(struct Delete *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemClassObject_methods[] = {
	{ "Delete", "S.Delete(ORPCthis, wszName) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_Delete_r, (py_data_pack_fn)pack_py_Delete_args_in, (py_data_unpack_fn)unpack_py_Delete_args_out, 0, &ndr_table_IWbemClassObject },
	{ NULL }
};

static PyObject *interface_IWbemClassObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemClassObject);
}

static PyTypeObject IWbemClassObject_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemClassObject",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemClassObject(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemClassObject_new,
};


static PyObject *py_CIMSTRINGS_get_count(PyObject *obj, void *closure)
{
	struct CIMSTRINGS *object = (struct CIMSTRINGS *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_CIMSTRINGS_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CIMSTRINGS *object = (struct CIMSTRINGS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CIMSTRINGS_get_item(PyObject *obj, void *closure)
{
	struct CIMSTRINGS *object = (struct CIMSTRINGS *)pytalloc_get_ptr(obj);
	PyObject *py_item;
	py_item = PyList_New(object->count);
	if (py_item == NULL) {
		return NULL;
	}
	{
		int item_cntr_0;
		for (item_cntr_0 = 0; item_cntr_0 < object->count; item_cntr_0++) {
			PyObject *py_item_0;
			py_item_0 = PyInt_FromLong(*object->item[item_cntr_0]);
			PyList_SetItem(py_item, item_cntr_0, py_item_0);
		}
	}
	return py_item;
}

static int py_CIMSTRINGS_set_item(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CIMSTRINGS *object = (struct CIMSTRINGS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int item_cntr_0;
		object->item = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->item, PyList_GET_SIZE(value));
		if (!object->item) { return -1;; }
		talloc_set_name_const(object->item, "ARRAY: object->item");
		for (item_cntr_0 = 0; item_cntr_0 < PyList_GET_SIZE(value); item_cntr_0++) {
			object->item[item_cntr_0] = talloc_ptrtype(object->item, object->item[item_cntr_0]);
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, item_cntr_0), return -1;);
			*object->item[item_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, item_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_CIMSTRINGS_getsetters[] = {
	{ discard_const_p(char, "count"), py_CIMSTRINGS_get_count, py_CIMSTRINGS_set_count },
	{ discard_const_p(char, "item"), py_CIMSTRINGS_get_item, py_CIMSTRINGS_set_item },
	{ NULL }
};

static PyObject *py_CIMSTRINGS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CIMSTRINGS, type);
}


static PyTypeObject CIMSTRINGS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.CIMSTRINGS",
	.tp_getset = py_CIMSTRINGS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_CIMSTRINGS_new,
};


static bool pack_py_OpenNamespace_args_in(PyObject *args, PyObject *kwargs, struct OpenNamespace *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strNamespace;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppWorkingNamespace;
	PyObject *py_ppResult;
	const char *kwnames[] = {
		"ORPCthis", "strNamespace", "lFlags", "pCtx", "ppWorkingNamespace", "ppResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:OpenNamespace", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strNamespace, &py_lFlags, &py_pCtx, &py_ppWorkingNamespace, &py_ppResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strNamespace, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strNamespace)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strNamespace = *(struct BSTR *)pytalloc_get_ptr(py_strNamespace);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppWorkingNamespace == Py_None) {
		r->in.ppWorkingNamespace = NULL;
	} else {
		r->in.ppWorkingNamespace = NULL;
		if (py_ppWorkingNamespace == Py_None) {
			*r->in.ppWorkingNamespace = NULL;
		} else {
			*r->in.ppWorkingNamespace = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppWorkingNamespace, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppWorkingNamespace)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppWorkingNamespace = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppWorkingNamespace);
		}
	}
	if (py_ppResult == Py_None) {
		r->in.ppResult = NULL;
	} else {
		r->in.ppResult = NULL;
		if (py_ppResult == Py_None) {
			*r->in.ppResult = NULL;
		} else {
			*r->in.ppResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppResult);
		}
	}
	return true;
}

static PyObject *unpack_py_OpenNamespace_args_out(struct OpenNamespace *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppWorkingNamespace;
	PyObject *py_ppResult;
	result = PyTuple_New(3);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppWorkingNamespace == NULL) {
		py_ppWorkingNamespace = Py_None;
		Py_INCREF(py_ppWorkingNamespace);
	} else {
		if (*r->out.ppWorkingNamespace == NULL) {
			py_ppWorkingNamespace = Py_None;
			Py_INCREF(py_ppWorkingNamespace);
		} else {
			py_ppWorkingNamespace = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppWorkingNamespace, *r->out.ppWorkingNamespace);
		}
	}
	PyTuple_SetItem(result, 1, py_ppWorkingNamespace);
	if (r->out.ppResult == NULL) {
		py_ppResult = Py_None;
		Py_INCREF(py_ppResult);
	} else {
		if (*r->out.ppResult == NULL) {
			py_ppResult = Py_None;
			Py_INCREF(py_ppResult);
		} else {
			py_ppResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppResult, *r->out.ppResult);
		}
	}
	PyTuple_SetItem(result, 2, py_ppResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_CancelAsyncCall_args_in(PyObject *args, PyObject *kwargs, struct CancelAsyncCall *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pSink;
	const char *kwnames[] = {
		"ORPCthis", "pSink", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:CancelAsyncCall", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pSink)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.pSink = talloc_ptrtype(r, r->in.pSink);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pSink, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pSink)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pSink = (struct MInterfacePointer *)pytalloc_get_ptr(py_pSink);
	return true;
}

static PyObject *unpack_py_CancelAsyncCall_args_out(struct CancelAsyncCall *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_QueryObjectSink_args_in(PyObject *args, PyObject *kwargs, struct QueryObjectSink *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lFlags;
	const char *kwnames[] = {
		"ORPCthis", "lFlags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:QueryObjectSink", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lFlags)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	return true;
}

static PyObject *unpack_py_QueryObjectSink_args_out(struct QueryObjectSink *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppResponseHandler;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppResponseHandler == NULL) {
		py_ppResponseHandler = Py_None;
		Py_INCREF(py_ppResponseHandler);
	} else {
		py_ppResponseHandler = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppResponseHandler, *r->out.ppResponseHandler);
	}
	PyTuple_SetItem(result, 1, py_ppResponseHandler);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetObject_args_in(PyObject *args, PyObject *kwargs, struct GetObject *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppObject;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "lFlags", "pCtx", "ppObject", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:GetObject", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_lFlags, &py_pCtx, &py_ppObject, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppObject == Py_None) {
		r->in.ppObject = NULL;
	} else {
		r->in.ppObject = NULL;
		if (py_ppObject == Py_None) {
			*r->in.ppObject = NULL;
		} else {
			*r->in.ppObject = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppObject, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppObject)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppObject = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppObject);
		}
	}
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_GetObject_args_out(struct GetObject *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppObject;
	PyObject *py_ppCallResult;
	result = PyTuple_New(3);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppObject == NULL) {
		py_ppObject = Py_None;
		Py_INCREF(py_ppObject);
	} else {
		if (*r->out.ppObject == NULL) {
			py_ppObject = Py_None;
			Py_INCREF(py_ppObject);
		} else {
			py_ppObject = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppObject, *r->out.ppObject);
		}
	}
	PyTuple_SetItem(result, 1, py_ppObject);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 2, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetObjectAsync_args_in(PyObject *args, PyObject *kwargs, struct GetObjectAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:GetObjectAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_GetObjectAsync_args_out(struct GetObjectAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PutClass_args_in(PyObject *args, PyObject *kwargs, struct PutClass *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pObject;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "pObject", "lFlags", "pCtx", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:PutClass", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pObject, &py_lFlags, &py_pCtx, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.pObject = talloc_ptrtype(r, r->in.pObject);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pObject, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pObject)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pObject = (struct MInterfacePointer *)pytalloc_get_ptr(py_pObject);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_PutClass_args_out(struct PutClass *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppCallResult;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 1, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PutClassAsync_args_in(PyObject *args, PyObject *kwargs, struct PutClassAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pObject;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "pObject", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:PutClassAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pObject, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.pObject = talloc_ptrtype(r, r->in.pObject);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pObject, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pObject)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pObject = (struct MInterfacePointer *)pytalloc_get_ptr(py_pObject);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_PutClassAsync_args_out(struct PutClassAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteClass_args_in(PyObject *args, PyObject *kwargs, struct DeleteClass *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strClass;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "strClass", "lFlags", "pCtx", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DeleteClass", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strClass, &py_lFlags, &py_pCtx, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strClass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strClass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strClass = *(struct BSTR *)pytalloc_get_ptr(py_strClass);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_DeleteClass_args_out(struct DeleteClass *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppCallResult;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 1, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteClassAsync_args_in(PyObject *args, PyObject *kwargs, struct DeleteClassAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strClass;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strClass", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DeleteClassAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strClass, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strClass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strClass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strClass = *(struct BSTR *)pytalloc_get_ptr(py_strClass);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_DeleteClassAsync_args_out(struct DeleteClassAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_CreateClassEnum_args_in(PyObject *args, PyObject *kwargs, struct CreateClassEnum *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strSuperclass;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "strSuperclass", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:CreateClassEnum", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strSuperclass, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strSuperclass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strSuperclass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strSuperclass = *(struct BSTR *)pytalloc_get_ptr(py_strSuperclass);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	return true;
}

static PyObject *unpack_py_CreateClassEnum_args_out(struct CreateClassEnum *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_CreateClassEnumAsync_args_in(PyObject *args, PyObject *kwargs, struct CreateClassEnumAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strSuperclass;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strSuperclass", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:CreateClassEnumAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strSuperclass, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strSuperclass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strSuperclass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strSuperclass = *(struct BSTR *)pytalloc_get_ptr(py_strSuperclass);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_CreateClassEnumAsync_args_out(struct CreateClassEnumAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PutInstance_args_in(PyObject *args, PyObject *kwargs, struct PutInstance *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pInst;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "pInst", "lFlags", "pCtx", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:PutInstance", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pInst, &py_lFlags, &py_pCtx, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.pInst = talloc_ptrtype(r, r->in.pInst);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pInst, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pInst)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pInst = (struct MInterfacePointer *)pytalloc_get_ptr(py_pInst);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_PutInstance_args_out(struct PutInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppCallResult;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 1, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_PutInstanceAsync_args_in(PyObject *args, PyObject *kwargs, struct PutInstanceAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pInst;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "pInst", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:PutInstanceAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pInst, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.pInst = talloc_ptrtype(r, r->in.pInst);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pInst, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pInst)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pInst = (struct MInterfacePointer *)pytalloc_get_ptr(py_pInst);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_PutInstanceAsync_args_out(struct PutInstanceAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteInstance_args_in(PyObject *args, PyObject *kwargs, struct DeleteInstance *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "lFlags", "pCtx", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DeleteInstance", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_lFlags, &py_pCtx, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_DeleteInstance_args_out(struct DeleteInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppCallResult;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 1, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteInstanceAsync_args_in(PyObject *args, PyObject *kwargs, struct DeleteInstanceAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DeleteInstanceAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_DeleteInstanceAsync_args_out(struct DeleteInstanceAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_CreateInstanceEnum_args_in(PyObject *args, PyObject *kwargs, struct CreateInstanceEnum *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strFilter;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "strFilter", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:CreateInstanceEnum", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strFilter, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strFilter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strFilter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strFilter = *(struct BSTR *)pytalloc_get_ptr(py_strFilter);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	if (py_pCtx == Py_None) {
		r->in.pCtx = NULL;
	} else {
		r->in.pCtx = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	}
	return true;
}

static PyObject *unpack_py_CreateInstanceEnum_args_out(struct CreateInstanceEnum *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_CreateInstanceEnumAsync_args_in(PyObject *args, PyObject *kwargs, struct CreateInstanceEnumAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strSuperClass;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strSuperClass", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:CreateInstanceEnumAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strSuperClass, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strSuperClass, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strSuperClass)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strSuperClass = *(struct BSTR *)pytalloc_get_ptr(py_strSuperClass);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_CreateInstanceEnumAsync_args_out(struct CreateInstanceEnumAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecQuery_args_in(PyObject *args, PyObject *kwargs, struct ExecQuery *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strQueryLanguage;
	PyObject *py_strQuery;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "strQueryLanguage", "strQuery", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:ExecQuery", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strQueryLanguage, &py_strQuery, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strQueryLanguage, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQueryLanguage)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQueryLanguage = *(struct BSTR *)pytalloc_get_ptr(py_strQueryLanguage);
	PY_CHECK_TYPE(&BSTR_Type, py_strQuery, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQuery = *(struct BSTR *)pytalloc_get_ptr(py_strQuery);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	if (py_pCtx == Py_None) {
		r->in.pCtx = NULL;
	} else {
		r->in.pCtx = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	}
	return true;
}

static PyObject *unpack_py_ExecQuery_args_out(struct ExecQuery *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecQueryAsync_args_in(PyObject *args, PyObject *kwargs, struct ExecQueryAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strQueryLanguage;
	PyObject *py_strQuery;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strQueryLanguage", "strQuery", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:ExecQueryAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strQueryLanguage, &py_strQuery, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strQueryLanguage, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQueryLanguage)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQueryLanguage = *(struct BSTR *)pytalloc_get_ptr(py_strQueryLanguage);
	PY_CHECK_TYPE(&BSTR_Type, py_strQuery, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQuery = *(struct BSTR *)pytalloc_get_ptr(py_strQuery);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_ExecQueryAsync_args_out(struct ExecQueryAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecNotificationQuery_args_in(PyObject *args, PyObject *kwargs, struct ExecNotificationQuery *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strQueryLanguage;
	PyObject *py_strQuery;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "strQueryLanguage", "strQuery", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:ExecNotificationQuery", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strQueryLanguage, &py_strQuery, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strQueryLanguage, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQueryLanguage)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQueryLanguage = *(struct BSTR *)pytalloc_get_ptr(py_strQueryLanguage);
	PY_CHECK_TYPE(&BSTR_Type, py_strQuery, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQuery = *(struct BSTR *)pytalloc_get_ptr(py_strQuery);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	if (py_pCtx == Py_None) {
		r->in.pCtx = NULL;
	} else {
		r->in.pCtx = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	}
	return true;
}

static PyObject *unpack_py_ExecNotificationQuery_args_out(struct ExecNotificationQuery *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecNotificationQueryAsync_args_in(PyObject *args, PyObject *kwargs, struct ExecNotificationQueryAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strQueryLanguage;
	PyObject *py_strQuery;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strQueryLanguage", "strQuery", "lFlags", "pCtx", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:ExecNotificationQueryAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strQueryLanguage, &py_strQuery, &py_lFlags, &py_pCtx, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strQueryLanguage, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQueryLanguage)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQueryLanguage = *(struct BSTR *)pytalloc_get_ptr(py_strQueryLanguage);
	PY_CHECK_TYPE(&BSTR_Type, py_strQuery, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strQuery = *(struct BSTR *)pytalloc_get_ptr(py_strQuery);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_ExecNotificationQueryAsync_args_out(struct ExecNotificationQueryAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecMethod_args_in(PyObject *args, PyObject *kwargs, struct ExecMethod *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_strMethodName;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pInParams;
	PyObject *py_ppOutParams;
	PyObject *py_ppCallResult;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "strMethodName", "lFlags", "pCtx", "pInParams", "ppOutParams", "ppCallResult", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:ExecMethod", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_strMethodName, &py_lFlags, &py_pCtx, &py_pInParams, &py_ppOutParams, &py_ppCallResult)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&BSTR_Type, py_strMethodName, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strMethodName)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strMethodName = *(struct BSTR *)pytalloc_get_ptr(py_strMethodName);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	if (py_pCtx == Py_None) {
		r->in.pCtx = NULL;
	} else {
		r->in.pCtx = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	}
	if (py_pInParams == Py_None) {
		r->in.pInParams = NULL;
	} else {
		r->in.pInParams = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pInParams, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pInParams)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pInParams = (struct MInterfacePointer *)pytalloc_get_ptr(py_pInParams);
	}
	if (py_ppOutParams == Py_None) {
		r->in.ppOutParams = NULL;
	} else {
		r->in.ppOutParams = NULL;
		if (py_ppOutParams == Py_None) {
			*r->in.ppOutParams = NULL;
		} else {
			*r->in.ppOutParams = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppOutParams, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppOutParams)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppOutParams = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppOutParams);
		}
	}
	if (py_ppCallResult == Py_None) {
		r->in.ppCallResult = NULL;
	} else {
		r->in.ppCallResult = NULL;
		if (py_ppCallResult == Py_None) {
			*r->in.ppCallResult = NULL;
		} else {
			*r->in.ppCallResult = NULL;
			PY_CHECK_TYPE(MInterfacePointer_Type, py_ppCallResult, return false;);
			if (talloc_reference(r, pytalloc_get_mem_ctx(py_ppCallResult)) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			*r->in.ppCallResult = (struct MInterfacePointer *)pytalloc_get_ptr(py_ppCallResult);
		}
	}
	return true;
}

static PyObject *unpack_py_ExecMethod_args_out(struct ExecMethod *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppOutParams;
	PyObject *py_ppCallResult;
	result = PyTuple_New(3);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppOutParams == NULL) {
		py_ppOutParams = Py_None;
		Py_INCREF(py_ppOutParams);
	} else {
		if (*r->out.ppOutParams == NULL) {
			py_ppOutParams = Py_None;
			Py_INCREF(py_ppOutParams);
		} else {
			py_ppOutParams = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppOutParams, *r->out.ppOutParams);
		}
	}
	PyTuple_SetItem(result, 1, py_ppOutParams);
	if (r->out.ppCallResult == NULL) {
		py_ppCallResult = Py_None;
		Py_INCREF(py_ppCallResult);
	} else {
		if (*r->out.ppCallResult == NULL) {
			py_ppCallResult = Py_None;
			Py_INCREF(py_ppCallResult);
		} else {
			py_ppCallResult = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppCallResult, *r->out.ppCallResult);
		}
	}
	PyTuple_SetItem(result, 2, py_ppCallResult);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_ExecMethodAsync_args_in(PyObject *args, PyObject *kwargs, struct ExecMethodAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_strObjectPath;
	PyObject *py_strMethodName;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	PyObject *py_pInParams;
	PyObject *py_pResponseHandler;
	const char *kwnames[] = {
		"ORPCthis", "strObjectPath", "strMethodName", "lFlags", "pCtx", "pInParams", "pResponseHandler", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:ExecMethodAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_strObjectPath, &py_strMethodName, &py_lFlags, &py_pCtx, &py_pInParams, &py_pResponseHandler)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&BSTR_Type, py_strObjectPath, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strObjectPath)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strObjectPath = *(struct BSTR *)pytalloc_get_ptr(py_strObjectPath);
	PY_CHECK_TYPE(&BSTR_Type, py_strMethodName, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strMethodName)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strMethodName = *(struct BSTR *)pytalloc_get_ptr(py_strMethodName);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	r->in.pInParams = talloc_ptrtype(r, r->in.pInParams);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pInParams, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pInParams)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pInParams = (struct MInterfacePointer *)pytalloc_get_ptr(py_pInParams);
	r->in.pResponseHandler = talloc_ptrtype(r, r->in.pResponseHandler);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pResponseHandler, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pResponseHandler)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pResponseHandler = (struct MInterfacePointer *)pytalloc_get_ptr(py_pResponseHandler);
	return true;
}

static PyObject *unpack_py_ExecMethodAsync_args_out(struct ExecMethodAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemServices_methods[] = {
	{ "OpenNamespace", "S.OpenNamespace(ORPCthis, strNamespace, lFlags, pCtx, ppWorkingNamespace, ppResult) -> (ORPCthat, ppWorkingNamespace, ppResult)", (py_dcerpc_call_fn)dcerpc_OpenNamespace_r, (py_data_pack_fn)pack_py_OpenNamespace_args_in, (py_data_unpack_fn)unpack_py_OpenNamespace_args_out, 0, &ndr_table_IWbemServices },
	{ "CancelAsyncCall", "S.CancelAsyncCall(ORPCthis, pSink) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_CancelAsyncCall_r, (py_data_pack_fn)pack_py_CancelAsyncCall_args_in, (py_data_unpack_fn)unpack_py_CancelAsyncCall_args_out, 1, &ndr_table_IWbemServices },
	{ "QueryObjectSink", "S.QueryObjectSink(ORPCthis, lFlags) -> (ORPCthat, ppResponseHandler)", (py_dcerpc_call_fn)dcerpc_QueryObjectSink_r, (py_data_pack_fn)pack_py_QueryObjectSink_args_in, (py_data_unpack_fn)unpack_py_QueryObjectSink_args_out, 2, &ndr_table_IWbemServices },
	{ "GetObject", "S.GetObject(ORPCthis, strObjectPath, lFlags, pCtx, ppObject, ppCallResult) -> (ORPCthat, ppObject, ppCallResult)", (py_dcerpc_call_fn)dcerpc_GetObject_r, (py_data_pack_fn)pack_py_GetObject_args_in, (py_data_unpack_fn)unpack_py_GetObject_args_out, 3, &ndr_table_IWbemServices },
	{ "GetObjectAsync", "S.GetObjectAsync(ORPCthis, strObjectPath, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_GetObjectAsync_r, (py_data_pack_fn)pack_py_GetObjectAsync_args_in, (py_data_unpack_fn)unpack_py_GetObjectAsync_args_out, 4, &ndr_table_IWbemServices },
	{ "PutClass", "S.PutClass(ORPCthis, pObject, lFlags, pCtx, ppCallResult) -> (ORPCthat, ppCallResult)", (py_dcerpc_call_fn)dcerpc_PutClass_r, (py_data_pack_fn)pack_py_PutClass_args_in, (py_data_unpack_fn)unpack_py_PutClass_args_out, 5, &ndr_table_IWbemServices },
	{ "PutClassAsync", "S.PutClassAsync(ORPCthis, pObject, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_PutClassAsync_r, (py_data_pack_fn)pack_py_PutClassAsync_args_in, (py_data_unpack_fn)unpack_py_PutClassAsync_args_out, 6, &ndr_table_IWbemServices },
	{ "DeleteClass", "S.DeleteClass(ORPCthis, strClass, lFlags, pCtx, ppCallResult) -> (ORPCthat, ppCallResult)", (py_dcerpc_call_fn)dcerpc_DeleteClass_r, (py_data_pack_fn)pack_py_DeleteClass_args_in, (py_data_unpack_fn)unpack_py_DeleteClass_args_out, 7, &ndr_table_IWbemServices },
	{ "DeleteClassAsync", "S.DeleteClassAsync(ORPCthis, strClass, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_DeleteClassAsync_r, (py_data_pack_fn)pack_py_DeleteClassAsync_args_in, (py_data_unpack_fn)unpack_py_DeleteClassAsync_args_out, 8, &ndr_table_IWbemServices },
	{ "CreateClassEnum", "S.CreateClassEnum(ORPCthis, strSuperclass, lFlags, pCtx) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_CreateClassEnum_r, (py_data_pack_fn)pack_py_CreateClassEnum_args_in, (py_data_unpack_fn)unpack_py_CreateClassEnum_args_out, 9, &ndr_table_IWbemServices },
	{ "CreateClassEnumAsync", "S.CreateClassEnumAsync(ORPCthis, strSuperclass, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_CreateClassEnumAsync_r, (py_data_pack_fn)pack_py_CreateClassEnumAsync_args_in, (py_data_unpack_fn)unpack_py_CreateClassEnumAsync_args_out, 10, &ndr_table_IWbemServices },
	{ "PutInstance", "S.PutInstance(ORPCthis, pInst, lFlags, pCtx, ppCallResult) -> (ORPCthat, ppCallResult)", (py_dcerpc_call_fn)dcerpc_PutInstance_r, (py_data_pack_fn)pack_py_PutInstance_args_in, (py_data_unpack_fn)unpack_py_PutInstance_args_out, 11, &ndr_table_IWbemServices },
	{ "PutInstanceAsync", "S.PutInstanceAsync(ORPCthis, pInst, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_PutInstanceAsync_r, (py_data_pack_fn)pack_py_PutInstanceAsync_args_in, (py_data_unpack_fn)unpack_py_PutInstanceAsync_args_out, 12, &ndr_table_IWbemServices },
	{ "DeleteInstance", "S.DeleteInstance(ORPCthis, strObjectPath, lFlags, pCtx, ppCallResult) -> (ORPCthat, ppCallResult)", (py_dcerpc_call_fn)dcerpc_DeleteInstance_r, (py_data_pack_fn)pack_py_DeleteInstance_args_in, (py_data_unpack_fn)unpack_py_DeleteInstance_args_out, 13, &ndr_table_IWbemServices },
	{ "DeleteInstanceAsync", "S.DeleteInstanceAsync(ORPCthis, strObjectPath, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_DeleteInstanceAsync_r, (py_data_pack_fn)pack_py_DeleteInstanceAsync_args_in, (py_data_unpack_fn)unpack_py_DeleteInstanceAsync_args_out, 14, &ndr_table_IWbemServices },
	{ "CreateInstanceEnum", "S.CreateInstanceEnum(ORPCthis, strFilter, lFlags, pCtx) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_CreateInstanceEnum_r, (py_data_pack_fn)pack_py_CreateInstanceEnum_args_in, (py_data_unpack_fn)unpack_py_CreateInstanceEnum_args_out, 15, &ndr_table_IWbemServices },
	{ "CreateInstanceEnumAsync", "S.CreateInstanceEnumAsync(ORPCthis, strSuperClass, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_CreateInstanceEnumAsync_r, (py_data_pack_fn)pack_py_CreateInstanceEnumAsync_args_in, (py_data_unpack_fn)unpack_py_CreateInstanceEnumAsync_args_out, 16, &ndr_table_IWbemServices },
	{ "ExecQuery", "S.ExecQuery(ORPCthis, strQueryLanguage, strQuery, lFlags, pCtx) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_ExecQuery_r, (py_data_pack_fn)pack_py_ExecQuery_args_in, (py_data_unpack_fn)unpack_py_ExecQuery_args_out, 17, &ndr_table_IWbemServices },
	{ "ExecQueryAsync", "S.ExecQueryAsync(ORPCthis, strQueryLanguage, strQuery, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_ExecQueryAsync_r, (py_data_pack_fn)pack_py_ExecQueryAsync_args_in, (py_data_unpack_fn)unpack_py_ExecQueryAsync_args_out, 18, &ndr_table_IWbemServices },
	{ "ExecNotificationQuery", "S.ExecNotificationQuery(ORPCthis, strQueryLanguage, strQuery, lFlags, pCtx) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_ExecNotificationQuery_r, (py_data_pack_fn)pack_py_ExecNotificationQuery_args_in, (py_data_unpack_fn)unpack_py_ExecNotificationQuery_args_out, 19, &ndr_table_IWbemServices },
	{ "ExecNotificationQueryAsync", "S.ExecNotificationQueryAsync(ORPCthis, strQueryLanguage, strQuery, lFlags, pCtx, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_ExecNotificationQueryAsync_r, (py_data_pack_fn)pack_py_ExecNotificationQueryAsync_args_in, (py_data_unpack_fn)unpack_py_ExecNotificationQueryAsync_args_out, 20, &ndr_table_IWbemServices },
	{ "ExecMethod", "S.ExecMethod(ORPCthis, strObjectPath, strMethodName, lFlags, pCtx, pInParams, ppOutParams, ppCallResult) -> (ORPCthat, ppOutParams, ppCallResult)", (py_dcerpc_call_fn)dcerpc_ExecMethod_r, (py_data_pack_fn)pack_py_ExecMethod_args_in, (py_data_unpack_fn)unpack_py_ExecMethod_args_out, 21, &ndr_table_IWbemServices },
	{ "ExecMethodAsync", "S.ExecMethodAsync(ORPCthis, strObjectPath, strMethodName, lFlags, pCtx, pInParams, pResponseHandler) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_ExecMethodAsync_r, (py_data_pack_fn)pack_py_ExecMethodAsync_args_in, (py_data_unpack_fn)unpack_py_ExecMethodAsync_args_out, 22, &ndr_table_IWbemServices },
	{ NULL }
};

static PyObject *interface_IWbemServices_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemServices);
}

static PyTypeObject IWbemServices_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemServices",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemServices(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemServices_new,
};


static bool pack_py_Reset_args_in(PyObject *args, PyObject *kwargs, struct Reset *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Reset", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_Reset_args_out(struct Reset *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_IEnumWbemClassObject_Next_args_in(PyObject *args, PyObject *kwargs, struct IEnumWbemClassObject_Next *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	PyObject *py_uCount;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", "uCount", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:IEnumWbemClassObject_Next", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout, &py_uCount)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	PY_CHECK_TYPE(&PyInt_Type, py_uCount, return false;);
	r->in.uCount = PyInt_AsLong(py_uCount);
	return true;
}

static PyObject *unpack_py_IEnumWbemClassObject_Next_args_out(struct IEnumWbemClassObject_Next *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_apObjects;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_apObjects = PyList_New(*r->out.puReturned);
	if (py_apObjects == NULL) {
		return NULL;
	}
	{
		int apObjects_cntr_1;
		for (apObjects_cntr_1 = 0; apObjects_cntr_1 < *r->out.puReturned; apObjects_cntr_1++) {
			PyObject *py_apObjects_1;
			if (r->out.apObjects[apObjects_cntr_1] == NULL) {
				py_apObjects_1 = Py_None;
				Py_INCREF(py_apObjects_1);
			} else {
				py_apObjects_1 = pytalloc_reference_ex(MInterfacePointer_Type, r->out.apObjects[apObjects_cntr_1], r->out.apObjects[apObjects_cntr_1]);
			}
			PyList_SetItem(py_apObjects, apObjects_cntr_1, py_apObjects_1);
		}
	}
	PyTuple_SetItem(result, 1, py_apObjects);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_NextAsync_args_in(PyObject *args, PyObject *kwargs, struct NextAsync *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_uCount;
	PyObject *py_pSink;
	const char *kwnames[] = {
		"ORPCthis", "uCount", "pSink", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:NextAsync", discard_const_p(char *, kwnames), &py_ORPCthis, &py_uCount, &py_pSink)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_uCount, return false;);
	r->in.uCount = PyInt_AsLong(py_uCount);
	r->in.pSink = talloc_ptrtype(r, r->in.pSink);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pSink, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pSink)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pSink = (struct MInterfacePointer *)pytalloc_get_ptr(py_pSink);
	return true;
}

static PyObject *unpack_py_NextAsync_args_out(struct NextAsync *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_IEnumWbemClassObject_Clone_args_in(PyObject *args, PyObject *kwargs, struct IEnumWbemClassObject_Clone *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:IEnumWbemClassObject_Clone", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_IEnumWbemClassObject_Clone_args_out(struct IEnumWbemClassObject_Clone *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Skip_args_in(PyObject *args, PyObject *kwargs, struct Skip *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	PyObject *py_nCount;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", "nCount", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:Skip", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout, &py_nCount)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	PY_CHECK_TYPE(&PyInt_Type, py_nCount, return false;);
	r->in.nCount = PyInt_AsLong(py_nCount);
	return true;
}

static PyObject *unpack_py_Skip_args_out(struct Skip *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IEnumWbemClassObject_methods[] = {
	{ "Reset", "S.Reset(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_Reset_r, (py_data_pack_fn)pack_py_Reset_args_in, (py_data_unpack_fn)unpack_py_Reset_args_out, 0, &ndr_table_IEnumWbemClassObject },
	{ "Next", "S.Next(ORPCthis, lTimeout, uCount) -> (ORPCthat, apObjects)", (py_dcerpc_call_fn)dcerpc_IEnumWbemClassObject_Next_r, (py_data_pack_fn)pack_py_IEnumWbemClassObject_Next_args_in, (py_data_unpack_fn)unpack_py_IEnumWbemClassObject_Next_args_out, 1, &ndr_table_IEnumWbemClassObject },
	{ "NextAsync", "S.NextAsync(ORPCthis, uCount, pSink) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_NextAsync_r, (py_data_pack_fn)pack_py_NextAsync_args_in, (py_data_unpack_fn)unpack_py_NextAsync_args_out, 2, &ndr_table_IEnumWbemClassObject },
	{ "Clone", "S.Clone(ORPCthis) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_IEnumWbemClassObject_Clone_r, (py_data_pack_fn)pack_py_IEnumWbemClassObject_Clone_args_in, (py_data_unpack_fn)unpack_py_IEnumWbemClassObject_Clone_args_out, 3, &ndr_table_IEnumWbemClassObject },
	{ "Skip", "S.Skip(ORPCthis, lTimeout, nCount) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_Skip_r, (py_data_pack_fn)pack_py_Skip_args_in, (py_data_unpack_fn)unpack_py_Skip_args_out, 4, &ndr_table_IEnumWbemClassObject },
	{ NULL }
};

static PyObject *interface_IEnumWbemClassObject_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IEnumWbemClassObject);
}

static PyTypeObject IEnumWbemClassObject_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IEnumWbemClassObject",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IEnumWbemClassObject(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IEnumWbemClassObject_new,
};


static bool pack_py_Clone_args_in(PyObject *args, PyObject *kwargs, struct Clone *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Clone", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_Clone_args_out(struct Clone *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppNewCopy;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppNewCopy == NULL) {
		py_ppNewCopy = Py_None;
		Py_INCREF(py_ppNewCopy);
	} else {
		py_ppNewCopy = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppNewCopy, *r->out.ppNewCopy);
	}
	PyTuple_SetItem(result, 1, py_ppNewCopy);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetNames_args_in(PyObject *args, PyObject *kwargs, struct GetNames *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GetNames", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_GetNames_args_out(struct GetNames *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_BeginEnumeration_args_in(PyObject *args, PyObject *kwargs, struct BeginEnumeration *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lFlags;
	const char *kwnames[] = {
		"ORPCthis", "lFlags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:BeginEnumeration", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lFlags)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	return true;
}

static PyObject *unpack_py_BeginEnumeration_args_out(struct BeginEnumeration *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Next_args_in(PyObject *args, PyObject *kwargs, struct Next *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Next", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_Next_args_out(struct Next *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_EndEnumeration_args_in(PyObject *args, PyObject *kwargs, struct EndEnumeration *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:EndEnumeration", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_EndEnumeration_args_out(struct EndEnumeration *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_SetValue_args_in(PyObject *args, PyObject *kwargs, struct SetValue *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:SetValue", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_SetValue_args_out(struct SetValue *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetValue_args_in(PyObject *args, PyObject *kwargs, struct GetValue *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GetValue", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_GetValue_args_out(struct GetValue *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteValue_args_in(PyObject *args, PyObject *kwargs, struct DeleteValue *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:DeleteValue", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_DeleteValue_args_out(struct DeleteValue *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DeleteAll_args_in(PyObject *args, PyObject *kwargs, struct DeleteAll *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:DeleteAll", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_DeleteAll_args_out(struct DeleteAll *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemContext_methods[] = {
	{ "Clone", "S.Clone(ORPCthis) -> (ORPCthat, ppNewCopy)", (py_dcerpc_call_fn)dcerpc_Clone_r, (py_data_pack_fn)pack_py_Clone_args_in, (py_data_unpack_fn)unpack_py_Clone_args_out, 0, &ndr_table_IWbemContext },
	{ "GetNames", "S.GetNames(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_GetNames_r, (py_data_pack_fn)pack_py_GetNames_args_in, (py_data_unpack_fn)unpack_py_GetNames_args_out, 1, &ndr_table_IWbemContext },
	{ "BeginEnumeration", "S.BeginEnumeration(ORPCthis, lFlags) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_BeginEnumeration_r, (py_data_pack_fn)pack_py_BeginEnumeration_args_in, (py_data_unpack_fn)unpack_py_BeginEnumeration_args_out, 2, &ndr_table_IWbemContext },
	{ "Next", "S.Next(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_Next_r, (py_data_pack_fn)pack_py_Next_args_in, (py_data_unpack_fn)unpack_py_Next_args_out, 3, &ndr_table_IWbemContext },
	{ "EndEnumeration", "S.EndEnumeration(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_EndEnumeration_r, (py_data_pack_fn)pack_py_EndEnumeration_args_in, (py_data_unpack_fn)unpack_py_EndEnumeration_args_out, 4, &ndr_table_IWbemContext },
	{ "SetValue", "S.SetValue(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_SetValue_r, (py_data_pack_fn)pack_py_SetValue_args_in, (py_data_unpack_fn)unpack_py_SetValue_args_out, 5, &ndr_table_IWbemContext },
	{ "GetValue", "S.GetValue(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_GetValue_r, (py_data_pack_fn)pack_py_GetValue_args_in, (py_data_unpack_fn)unpack_py_GetValue_args_out, 6, &ndr_table_IWbemContext },
	{ "DeleteValue", "S.DeleteValue(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_DeleteValue_r, (py_data_pack_fn)pack_py_DeleteValue_args_in, (py_data_unpack_fn)unpack_py_DeleteValue_args_out, 7, &ndr_table_IWbemContext },
	{ "DeleteAll", "S.DeleteAll(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_DeleteAll_r, (py_data_pack_fn)pack_py_DeleteAll_args_in, (py_data_unpack_fn)unpack_py_DeleteAll_args_out, 8, &ndr_table_IWbemContext },
	{ NULL }
};

static PyObject *interface_IWbemContext_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemContext);
}

static PyTypeObject IWbemContext_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemContext",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemContext(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemContext_new,
};


static bool pack_py_EstablishPosition_args_in(PyObject *args, PyObject *kwargs, struct EstablishPosition *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_wszLocaleList;
	PyObject *py_dwNumLocales;
	const char *kwnames[] = {
		"ORPCthis", "wszLocaleList", "dwNumLocales", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:EstablishPosition", discard_const_p(char *, kwnames), &py_ORPCthis, &py_wszLocaleList, &py_dwNumLocales)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	if (py_wszLocaleList == Py_None) {
		r->in.wszLocaleList = NULL;
	} else {
		r->in.wszLocaleList = NULL;
		if (PyUnicode_Check(py_wszLocaleList)) {
			r->in.wszLocaleList = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszLocaleList, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszLocaleList)) {
			r->in.wszLocaleList = PyString_AS_STRING(py_wszLocaleList);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszLocaleList)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwNumLocales, return false;);
	r->in.dwNumLocales = PyInt_AsLong(py_dwNumLocales);
	return true;
}

static PyObject *unpack_py_EstablishPosition_args_out(struct EstablishPosition *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_reserved;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_reserved = PyInt_FromLong(*r->out.reserved);
	PyTuple_SetItem(result, 1, py_reserved);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_RequestChallenge_args_in(PyObject *args, PyObject *kwargs, struct RequestChallenge *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_wszNetworkResource;
	PyObject *py_wszUser;
	const char *kwnames[] = {
		"ORPCthis", "wszNetworkResource", "wszUser", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:RequestChallenge", discard_const_p(char *, kwnames), &py_ORPCthis, &py_wszNetworkResource, &py_wszUser)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	if (py_wszNetworkResource == Py_None) {
		r->in.wszNetworkResource = NULL;
	} else {
		r->in.wszNetworkResource = NULL;
		if (PyUnicode_Check(py_wszNetworkResource)) {
			r->in.wszNetworkResource = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszNetworkResource, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszNetworkResource)) {
			r->in.wszNetworkResource = PyString_AS_STRING(py_wszNetworkResource);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszNetworkResource)->tp_name);
			return false;
		}
	}
	if (py_wszUser == Py_None) {
		r->in.wszUser = NULL;
	} else {
		r->in.wszUser = NULL;
		if (PyUnicode_Check(py_wszUser)) {
			r->in.wszUser = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszUser, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszUser)) {
			r->in.wszUser = PyString_AS_STRING(py_wszUser);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszUser)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_RequestChallenge_args_out(struct RequestChallenge *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_Nonce;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_Nonce = PyList_New(16);
	if (py_Nonce == NULL) {
		return NULL;
	}
	{
		int Nonce_cntr_1;
		for (Nonce_cntr_1 = 0; Nonce_cntr_1 < 16; Nonce_cntr_1++) {
			PyObject *py_Nonce_1;
			py_Nonce_1 = PyInt_FromLong(r->out.Nonce[Nonce_cntr_1]);
			PyList_SetItem(py_Nonce, Nonce_cntr_1, py_Nonce_1);
		}
	}
	PyTuple_SetItem(result, 1, py_Nonce);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_WBEMLogin_args_in(PyObject *args, PyObject *kwargs, struct WBEMLogin *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_wszPreferredLocale;
	PyObject *py_AccessToken;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "wszPreferredLocale", "AccessToken", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:WBEMLogin", discard_const_p(char *, kwnames), &py_ORPCthis, &py_wszPreferredLocale, &py_AccessToken, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	if (py_wszPreferredLocale == Py_None) {
		r->in.wszPreferredLocale = NULL;
	} else {
		r->in.wszPreferredLocale = NULL;
		if (PyUnicode_Check(py_wszPreferredLocale)) {
			r->in.wszPreferredLocale = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszPreferredLocale, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszPreferredLocale)) {
			r->in.wszPreferredLocale = PyString_AS_STRING(py_wszPreferredLocale);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszPreferredLocale)->tp_name);
			return false;
		}
	}
	if (py_AccessToken == Py_None) {
		r->in.AccessToken = NULL;
	} else {
		r->in.AccessToken = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_AccessToken, return false;);
		{
			int AccessToken_cntr_1;
			r->in.AccessToken = talloc_array_ptrtype(r, r->in.AccessToken, PyList_GET_SIZE(py_AccessToken));
			if (!r->in.AccessToken) { return false;; }
			talloc_set_name_const(r->in.AccessToken, "ARRAY: r->in.AccessToken");
			for (AccessToken_cntr_1 = 0; AccessToken_cntr_1 < PyList_GET_SIZE(py_AccessToken); AccessToken_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_AccessToken, AccessToken_cntr_1), return false;);
				r->in.AccessToken[AccessToken_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_AccessToken, AccessToken_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.pCtx = talloc_ptrtype(r, r->in.pCtx);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	return true;
}

static PyObject *unpack_py_WBEMLogin_args_out(struct WBEMLogin *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppNamespace;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppNamespace == NULL) {
		py_ppNamespace = Py_None;
		Py_INCREF(py_ppNamespace);
	} else {
		py_ppNamespace = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppNamespace, *r->out.ppNamespace);
	}
	PyTuple_SetItem(result, 1, py_ppNamespace);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_NTLMLogin_args_in(PyObject *args, PyObject *kwargs, struct NTLMLogin *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_wszNetworkResource;
	PyObject *py_wszPreferredLocale;
	PyObject *py_lFlags;
	PyObject *py_pCtx;
	const char *kwnames[] = {
		"ORPCthis", "wszNetworkResource", "wszPreferredLocale", "lFlags", "pCtx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:NTLMLogin", discard_const_p(char *, kwnames), &py_ORPCthis, &py_wszNetworkResource, &py_wszPreferredLocale, &py_lFlags, &py_pCtx)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	if (py_wszNetworkResource == Py_None) {
		r->in.wszNetworkResource = NULL;
	} else {
		r->in.wszNetworkResource = NULL;
		if (PyUnicode_Check(py_wszNetworkResource)) {
			r->in.wszNetworkResource = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszNetworkResource, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszNetworkResource)) {
			r->in.wszNetworkResource = PyString_AS_STRING(py_wszNetworkResource);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszNetworkResource)->tp_name);
			return false;
		}
	}
	if (py_wszPreferredLocale == Py_None) {
		r->in.wszPreferredLocale = NULL;
	} else {
		r->in.wszPreferredLocale = NULL;
		if (PyUnicode_Check(py_wszPreferredLocale)) {
			r->in.wszPreferredLocale = PyString_AS_STRING(PyUnicode_AsEncodedString(py_wszPreferredLocale, "utf-8", "ignore"));
		} else if (PyString_Check(py_wszPreferredLocale)) {
			r->in.wszPreferredLocale = PyString_AS_STRING(py_wszPreferredLocale);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_wszPreferredLocale)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	if (py_pCtx == Py_None) {
		r->in.pCtx = NULL;
	} else {
		r->in.pCtx = NULL;
		PY_CHECK_TYPE(MInterfacePointer_Type, py_pCtx, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pCtx)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pCtx = (struct MInterfacePointer *)pytalloc_get_ptr(py_pCtx);
	}
	return true;
}

static PyObject *unpack_py_NTLMLogin_args_out(struct NTLMLogin *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppNamespace;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppNamespace == NULL) {
		py_ppNamespace = Py_None;
		Py_INCREF(py_ppNamespace);
	} else {
		py_ppNamespace = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppNamespace, *r->out.ppNamespace);
	}
	PyTuple_SetItem(result, 1, py_ppNamespace);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemLevel1Login_methods[] = {
	{ "EstablishPosition", "S.EstablishPosition(ORPCthis, wszLocaleList, dwNumLocales) -> (ORPCthat, reserved)", (py_dcerpc_call_fn)dcerpc_EstablishPosition_r, (py_data_pack_fn)pack_py_EstablishPosition_args_in, (py_data_unpack_fn)unpack_py_EstablishPosition_args_out, 0, &ndr_table_IWbemLevel1Login },
	{ "RequestChallenge", "S.RequestChallenge(ORPCthis, wszNetworkResource, wszUser) -> (ORPCthat, Nonce)", (py_dcerpc_call_fn)dcerpc_RequestChallenge_r, (py_data_pack_fn)pack_py_RequestChallenge_args_in, (py_data_unpack_fn)unpack_py_RequestChallenge_args_out, 1, &ndr_table_IWbemLevel1Login },
	{ "WBEMLogin", "S.WBEMLogin(ORPCthis, wszPreferredLocale, AccessToken, lFlags, pCtx) -> (ORPCthat, ppNamespace)", (py_dcerpc_call_fn)dcerpc_WBEMLogin_r, (py_data_pack_fn)pack_py_WBEMLogin_args_in, (py_data_unpack_fn)unpack_py_WBEMLogin_args_out, 2, &ndr_table_IWbemLevel1Login },
	{ "NTLMLogin", "S.NTLMLogin(ORPCthis, wszNetworkResource, wszPreferredLocale, lFlags, pCtx) -> (ORPCthat, ppNamespace)", (py_dcerpc_call_fn)dcerpc_NTLMLogin_r, (py_data_pack_fn)pack_py_NTLMLogin_args_in, (py_data_unpack_fn)unpack_py_NTLMLogin_args_out, 3, &ndr_table_IWbemLevel1Login },
	{ NULL }
};

static PyObject *interface_IWbemLevel1Login_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemLevel1Login);
}

static PyTypeObject IWbemLevel1Login_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemLevel1Login",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemLevel1Login(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemLevel1Login_new,
};


static PyObject *py_WBEMDATA_get_size(PyObject *obj, void *closure)
{
	struct WBEMDATA *object = (struct WBEMDATA *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_WBEMDATA_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA *object = (struct WBEMDATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA_get_data(PyObject *obj, void *closure)
{
	struct WBEMDATA *object = (struct WBEMDATA *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->size);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < object->size; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_WBEMDATA_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA *object = (struct WBEMDATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1;; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_WBEMDATA_getsetters[] = {
	{ discard_const_p(char, "size"), py_WBEMDATA_get_size, py_WBEMDATA_set_size },
	{ discard_const_p(char, "data"), py_WBEMDATA_get_data, py_WBEMDATA_set_data },
	{ NULL }
};

static PyObject *py_WBEMDATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA, type);
}


static PyTypeObject WBEMDATA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA",
	.tp_getset = py_WBEMDATA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA_new,
};


static PyObject *py_WBEMDATA4_get_data_size(PyObject *obj, void *closure)
{
	struct WBEMDATA4 *object = (struct WBEMDATA4 *)pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_WBEMDATA4_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA4 *object = (struct WBEMDATA4 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA4_get_wtype(PyObject *obj, void *closure)
{
	struct WBEMDATA4 *object = (struct WBEMDATA4 *)pytalloc_get_ptr(obj);
	PyObject *py_wtype;
	py_wtype = PyInt_FromLong(object->wtype);
	return py_wtype;
}

static int py_WBEMDATA4_set_wtype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA4 *object = (struct WBEMDATA4 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wtype = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_WBEMDATA4_getsetters[] = {
	{ discard_const_p(char, "data_size"), py_WBEMDATA4_get_data_size, py_WBEMDATA4_set_data_size },
	{ discard_const_p(char, "wtype"), py_WBEMDATA4_get_wtype, py_WBEMDATA4_set_wtype },
	{ NULL }
};

static PyObject *py_WBEMDATA4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA4, type);
}


static PyTypeObject WBEMDATA4_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA4",
	.tp_getset = py_WBEMDATA4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA4_new,
};


static PyObject *py_WBEMDATA3_get_data(PyObject *obj, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = pytalloc_reference_ex(&WBEMDATA4_Type, object->data, object->data);
	}
	return py_data;
}

static int py_WBEMDATA3_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&WBEMDATA4_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->data = (struct WBEMDATA4 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_WBEMDATA3_get_data_size(PyObject *obj, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_WBEMDATA3_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA3_get_wtype(PyObject *obj, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(obj);
	PyObject *py_wtype;
	py_wtype = PyInt_FromLong(object->wtype);
	return py_wtype;
}

static int py_WBEMDATA3_set_wtype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA3 *object = (struct WBEMDATA3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wtype = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_WBEMDATA3_getsetters[] = {
	{ discard_const_p(char, "data"), py_WBEMDATA3_get_data, py_WBEMDATA3_set_data },
	{ discard_const_p(char, "data_size"), py_WBEMDATA3_get_data_size, py_WBEMDATA3_set_data_size },
	{ discard_const_p(char, "wtype"), py_WBEMDATA3_get_wtype, py_WBEMDATA3_set_wtype },
	{ NULL }
};

static PyObject *py_WBEMDATA3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA3, type);
}


static PyTypeObject WBEMDATA3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA3",
	.tp_getset = py_WBEMDATA3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA3_new,
};


static PyObject *py_WBEMDATA2_get_data(PyObject *obj, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->obj_num);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->obj_num; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = pytalloc_reference_ex(&WBEMDATA3_Type, object->data, &object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_WBEMDATA2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&WBEMDATA3_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				if (talloc_reference(object->data, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, data_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->data[data_cntr_1] = *(struct WBEMDATA3 *)pytalloc_get_ptr(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_WBEMDATA2_get_data_size(PyObject *obj, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_WBEMDATA2_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA2_get_obj_num(PyObject *obj, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(obj);
	PyObject *py_obj_num;
	py_obj_num = PyInt_FromLong(object->obj_num);
	return py_obj_num;
}

static int py_WBEMDATA2_set_obj_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA2 *object = (struct WBEMDATA2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->obj_num = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_WBEMDATA2_getsetters[] = {
	{ discard_const_p(char, "data"), py_WBEMDATA2_get_data, py_WBEMDATA2_set_data },
	{ discard_const_p(char, "data_size"), py_WBEMDATA2_get_data_size, py_WBEMDATA2_set_data_size },
	{ discard_const_p(char, "obj_num"), py_WBEMDATA2_get_obj_num, py_WBEMDATA2_set_obj_num },
	{ NULL }
};

static PyObject *py_WBEMDATA2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA2, type);
}


static PyTypeObject WBEMDATA2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA2",
	.tp_getset = py_WBEMDATA2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA2_new,
};


static PyObject *py_WBEMDATA1_get_data(PyObject *obj, void *closure)
{
	struct WBEMDATA1 *object = (struct WBEMDATA1 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = pytalloc_reference_ex(&WBEMDATA2_Type, object->data, object->data);
	}
	return py_data;
}

static int py_WBEMDATA1_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA1 *object = (struct WBEMDATA1 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&WBEMDATA2_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->data = (struct WBEMDATA2 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_WBEMDATA1_get_data_size(PyObject *obj, void *closure)
{
	struct WBEMDATA1 *object = (struct WBEMDATA1 *)pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_WBEMDATA1_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA1 *object = (struct WBEMDATA1 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_WBEMDATA1_getsetters[] = {
	{ discard_const_p(char, "data"), py_WBEMDATA1_get_data, py_WBEMDATA1_set_data },
	{ discard_const_p(char, "data_size"), py_WBEMDATA1_get_data_size, py_WBEMDATA1_set_data_size },
	{ NULL }
};

static PyObject *py_WBEMDATA1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA1, type);
}


static PyTypeObject WBEMDATA1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA1",
	.tp_getset = py_WBEMDATA1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA1_new,
};


static PyObject *py_WBEMDATA0_get_u1_0(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_u1_0;
	py_u1_0 = PyInt_FromLong(object->u1_0);
	return py_u1_0;
}

static int py_WBEMDATA0_set_u1_0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->u1_0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA0_get_signature(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyLong_FromLongLong(object->signature);
	return py_signature;
}

static int py_WBEMDATA0_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->signature = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->signature = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_WBEMDATA0_get_data(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = pytalloc_reference_ex(&WBEMDATA1_Type, object->data, object->data);
	}
	return py_data;
}

static int py_WBEMDATA0_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&WBEMDATA1_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->data = (struct WBEMDATA1 *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_WBEMDATA0_get_data_size(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_data_size;
	py_data_size = PyInt_FromLong(object->data_size);
	return py_data_size;
}

static int py_WBEMDATA0_set_data_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA0_get_u2_0(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_u2_0;
	py_u2_0 = PyInt_FromLong(object->u2_0);
	return py_u2_0;
}

static int py_WBEMDATA0_set_u2_0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->u2_0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA0_get_ver_major(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_ver_major;
	py_ver_major = PyInt_FromLong(object->ver_major);
	return py_ver_major;
}

static int py_WBEMDATA0_set_ver_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ver_major = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_WBEMDATA0_get_ver_minor(PyObject *obj, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(obj);
	PyObject *py_ver_minor;
	py_ver_minor = PyInt_FromLong(object->ver_minor);
	return py_ver_minor;
}

static int py_WBEMDATA0_set_ver_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct WBEMDATA0 *object = (struct WBEMDATA0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ver_minor = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_WBEMDATA0_getsetters[] = {
	{ discard_const_p(char, "u1_0"), py_WBEMDATA0_get_u1_0, py_WBEMDATA0_set_u1_0 },
	{ discard_const_p(char, "signature"), py_WBEMDATA0_get_signature, py_WBEMDATA0_set_signature },
	{ discard_const_p(char, "data"), py_WBEMDATA0_get_data, py_WBEMDATA0_set_data },
	{ discard_const_p(char, "data_size"), py_WBEMDATA0_get_data_size, py_WBEMDATA0_set_data_size },
	{ discard_const_p(char, "u2_0"), py_WBEMDATA0_get_u2_0, py_WBEMDATA0_set_u2_0 },
	{ discard_const_p(char, "ver_major"), py_WBEMDATA0_get_ver_major, py_WBEMDATA0_set_ver_major },
	{ discard_const_p(char, "ver_minor"), py_WBEMDATA0_get_ver_minor, py_WBEMDATA0_set_ver_minor },
	{ NULL }
};

static PyObject *py_WBEMDATA0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct WBEMDATA0, type);
}


static PyTypeObject WBEMDATA0_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.WBEMDATA0",
	.tp_getset = py_WBEMDATA0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_WBEMDATA0_new,
};


static bool pack_py_IWbemWCOSmartEnum_Next_args_in(PyObject *args, PyObject *kwargs, struct IWbemWCOSmartEnum_Next *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_gEWCO;
	PyObject *py_lTimeOut;
	PyObject *py_uCount;
	PyObject *py_unknown;
	PyObject *py_gWCO;
	const char *kwnames[] = {
		"ORPCthis", "gEWCO", "lTimeOut", "uCount", "unknown", "gWCO", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:IWbemWCOSmartEnum_Next", discard_const_p(char *, kwnames), &py_ORPCthis, &py_gEWCO, &py_lTimeOut, &py_uCount, &py_unknown, &py_gWCO)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	r->in.gEWCO = talloc_ptrtype(r, r->in.gEWCO);
	PY_CHECK_TYPE(GUID_Type, py_gEWCO, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_gEWCO)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.gEWCO = (struct GUID *)pytalloc_get_ptr(py_gEWCO);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeOut, return false;);
	r->in.lTimeOut = PyInt_AsLong(py_lTimeOut);
	PY_CHECK_TYPE(&PyInt_Type, py_uCount, return false;);
	r->in.uCount = PyInt_AsLong(py_uCount);
	PY_CHECK_TYPE(&PyInt_Type, py_unknown, return false;);
	r->in.unknown = PyInt_AsLong(py_unknown);
	r->in.gWCO = talloc_ptrtype(r, r->in.gWCO);
	PY_CHECK_TYPE(GUID_Type, py_gWCO, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_gWCO)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.gWCO = (struct GUID *)pytalloc_get_ptr(py_gWCO);
	return true;
}

static PyObject *unpack_py_IWbemWCOSmartEnum_Next_args_out(struct IWbemWCOSmartEnum_Next *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_puReturned;
	PyObject *py_pSize;
	PyObject *py_pData;
	result = PyTuple_New(4);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_puReturned = PyInt_FromLong(*r->out.puReturned);
	PyTuple_SetItem(result, 1, py_puReturned);
	py_pSize = PyInt_FromLong(*r->out.pSize);
	PyTuple_SetItem(result, 2, py_pSize);
	if (*r->out.pData == NULL) {
		py_pData = Py_None;
		Py_INCREF(py_pData);
	} else {
		py_pData = PyList_New(*r->out.pSize);
		if (py_pData == NULL) {
			return NULL;
		}
		{
			int pData_cntr_2;
			for (pData_cntr_2 = 0; pData_cntr_2 < *r->out.pSize; pData_cntr_2++) {
				PyObject *py_pData_2;
				py_pData_2 = PyInt_FromLong(*r->out.pData[pData_cntr_2]);
				PyList_SetItem(py_pData, pData_cntr_2, py_pData_2);
			}
		}
	}
	PyTuple_SetItem(result, 3, py_pData);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemWCOSmartEnum_methods[] = {
	{ "Next", "S.Next(ORPCthis, gEWCO, lTimeOut, uCount, unknown, gWCO) -> (ORPCthat, puReturned, pSize, pData)", (py_dcerpc_call_fn)dcerpc_IWbemWCOSmartEnum_Next_r, (py_data_pack_fn)pack_py_IWbemWCOSmartEnum_Next_args_in, (py_data_unpack_fn)unpack_py_IWbemWCOSmartEnum_Next_args_out, 0, &ndr_table_IWbemWCOSmartEnum },
	{ NULL }
};

static PyObject *interface_IWbemWCOSmartEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemWCOSmartEnum);
}

static PyTypeObject IWbemWCOSmartEnum_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemWCOSmartEnum",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemWCOSmartEnum(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemWCOSmartEnum_new,
};


static bool pack_py_Fetch_args_in(PyObject *args, PyObject *kwargs, struct Fetch *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Fetch", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_Fetch_args_out(struct Fetch *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Test_args_in(PyObject *args, PyObject *kwargs, struct Test *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Test", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	return true;
}

static PyObject *unpack_py_Test_args_out(struct Test *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppEnum;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppEnum == NULL) {
		py_ppEnum = Py_None;
		Py_INCREF(py_ppEnum);
	} else {
		py_ppEnum = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppEnum, *r->out.ppEnum);
	}
	PyTuple_SetItem(result, 1, py_ppEnum);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemFetchSmartEnum_methods[] = {
	{ "Fetch", "S.Fetch(ORPCthis) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_Fetch_r, (py_data_pack_fn)pack_py_Fetch_args_in, (py_data_unpack_fn)unpack_py_Fetch_args_out, 0, &ndr_table_IWbemFetchSmartEnum },
	{ "Test", "S.Test(ORPCthis) -> (ORPCthat, ppEnum)", (py_dcerpc_call_fn)dcerpc_Test_r, (py_data_pack_fn)pack_py_Test_args_in, (py_data_unpack_fn)unpack_py_Test_args_out, 1, &ndr_table_IWbemFetchSmartEnum },
	{ NULL }
};

static PyObject *interface_IWbemFetchSmartEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemFetchSmartEnum);
}

static PyTypeObject IWbemFetchSmartEnum_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemFetchSmartEnum",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemFetchSmartEnum(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemFetchSmartEnum_new,
};


static bool pack_py_GetResultObject_args_in(PyObject *args, PyObject *kwargs, struct GetResultObject *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:GetResultObject", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	return true;
}

static PyObject *unpack_py_GetResultObject_args_out(struct GetResultObject *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppResultObject;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppResultObject == NULL) {
		py_ppResultObject = Py_None;
		Py_INCREF(py_ppResultObject);
	} else {
		py_ppResultObject = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppResultObject, *r->out.ppResultObject);
	}
	PyTuple_SetItem(result, 1, py_ppResultObject);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetResultString_args_in(PyObject *args, PyObject *kwargs, struct GetResultString *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:GetResultString", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	return true;
}

static PyObject *unpack_py_GetResultString_args_out(struct GetResultString *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_pstrResultString;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_pstrResultString = pytalloc_reference_ex(&BSTR_Type, r->out.pstrResultString, r->out.pstrResultString);
	PyTuple_SetItem(result, 1, py_pstrResultString);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetResultServices_args_in(PyObject *args, PyObject *kwargs, struct GetResultServices *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:GetResultServices", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	return true;
}

static PyObject *unpack_py_GetResultServices_args_out(struct GetResultServices *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppServices;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.ppServices == NULL) {
		py_ppServices = Py_None;
		Py_INCREF(py_ppServices);
	} else {
		py_ppServices = pytalloc_reference_ex(MInterfacePointer_Type, *r->out.ppServices, *r->out.ppServices);
	}
	PyTuple_SetItem(result, 1, py_ppServices);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetCallStatus_args_in(PyObject *args, PyObject *kwargs, struct GetCallStatus *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lTimeout;
	const char *kwnames[] = {
		"ORPCthis", "lTimeout", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:GetCallStatus", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lTimeout)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lTimeout, return false;);
	r->in.lTimeout = PyInt_AsLong(py_lTimeout);
	return true;
}

static PyObject *unpack_py_GetCallStatus_args_out(struct GetCallStatus *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_plStatus;
	result = PyTuple_New(2);
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_plStatus = PyInt_FromLong(*r->out.plStatus);
	PyTuple_SetItem(result, 1, py_plStatus);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemCallResult_methods[] = {
	{ "GetResultObject", "S.GetResultObject(ORPCthis, lTimeout) -> (ORPCthat, ppResultObject)", (py_dcerpc_call_fn)dcerpc_GetResultObject_r, (py_data_pack_fn)pack_py_GetResultObject_args_in, (py_data_unpack_fn)unpack_py_GetResultObject_args_out, 0, &ndr_table_IWbemCallResult },
	{ "GetResultString", "S.GetResultString(ORPCthis, lTimeout) -> (ORPCthat, pstrResultString)", (py_dcerpc_call_fn)dcerpc_GetResultString_r, (py_data_pack_fn)pack_py_GetResultString_args_in, (py_data_unpack_fn)unpack_py_GetResultString_args_out, 1, &ndr_table_IWbemCallResult },
	{ "GetResultServices", "S.GetResultServices(ORPCthis, lTimeout) -> (ORPCthat, ppServices)", (py_dcerpc_call_fn)dcerpc_GetResultServices_r, (py_data_pack_fn)pack_py_GetResultServices_args_in, (py_data_unpack_fn)unpack_py_GetResultServices_args_out, 2, &ndr_table_IWbemCallResult },
	{ "GetCallStatus", "S.GetCallStatus(ORPCthis, lTimeout) -> (ORPCthat, plStatus)", (py_dcerpc_call_fn)dcerpc_GetCallStatus_r, (py_data_pack_fn)pack_py_GetCallStatus_args_in, (py_data_unpack_fn)unpack_py_GetCallStatus_args_out, 3, &ndr_table_IWbemCallResult },
	{ NULL }
};

static PyObject *interface_IWbemCallResult_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemCallResult);
}

static PyTypeObject IWbemCallResult_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemCallResult",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemCallResult(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemCallResult_new,
};


static bool pack_py_SetStatus_args_in(PyObject *args, PyObject *kwargs, struct SetStatus *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lFlags;
	PyObject *py_hResult;
	PyObject *py_strParam;
	PyObject *py_pObjParam;
	const char *kwnames[] = {
		"ORPCthis", "lFlags", "hResult", "strParam", "pObjParam", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:SetStatus", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lFlags, &py_hResult, &py_strParam, &py_pObjParam)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyInt_Type, py_lFlags, return false;);
	r->in.lFlags = PyInt_AsLong(py_lFlags);
	r->in.hResult = W_ERROR(PyInt_AsLong(py_hResult));
	PY_CHECK_TYPE(&BSTR_Type, py_strParam, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_strParam)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.strParam = *(struct BSTR *)pytalloc_get_ptr(py_strParam);
	r->in.pObjParam = talloc_ptrtype(r, r->in.pObjParam);
	PY_CHECK_TYPE(MInterfacePointer_Type, py_pObjParam, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pObjParam)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pObjParam = (struct MInterfacePointer *)pytalloc_get_ptr(py_pObjParam);
	return true;
}

static PyObject *unpack_py_SetStatus_args_out(struct SetStatus *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Indicate_args_in(PyObject *args, PyObject *kwargs, struct Indicate *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_apObjArray;
	const char *kwnames[] = {
		"ORPCthis", "apObjArray", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:Indicate", discard_const_p(char *, kwnames), &py_ORPCthis, &py_apObjArray)) {
		return false;
	}

	PY_CHECK_TYPE(ORPCTHIS_Type, py_ORPCthis, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ORPCthis)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ORPCthis = *(struct ORPCTHIS *)pytalloc_get_ptr(py_ORPCthis);
	PY_CHECK_TYPE(&PyList_Type, py_apObjArray, return false;);
	r->in.lObjectCount = PyList_GET_SIZE(py_apObjArray);
	r->in.apObjArray = talloc_ptrtype(r, r->in.apObjArray);
	PY_CHECK_TYPE(&PyList_Type, py_apObjArray, return false;);
	{
		int apObjArray_cntr_1;
		r->in.apObjArray = talloc_array_ptrtype(r, r->in.apObjArray, PyList_GET_SIZE(py_apObjArray));
		if (!r->in.apObjArray) { return false;; }
		talloc_set_name_const(r->in.apObjArray, "ARRAY: r->in.apObjArray");
		for (apObjArray_cntr_1 = 0; apObjArray_cntr_1 < PyList_GET_SIZE(py_apObjArray); apObjArray_cntr_1++) {
			if (PyList_GET_ITEM(py_apObjArray, apObjArray_cntr_1) == Py_None) {
				r->in.apObjArray[apObjArray_cntr_1] = NULL;
			} else {
				r->in.apObjArray[apObjArray_cntr_1] = NULL;
				PY_CHECK_TYPE(MInterfacePointer_Type, PyList_GET_ITEM(py_apObjArray, apObjArray_cntr_1), return false;);
				if (talloc_reference(r->in.apObjArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_apObjArray, apObjArray_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return false;
				}
				r->in.apObjArray[apObjArray_cntr_1] = (struct MInterfacePointer *)pytalloc_get_ptr(PyList_GET_ITEM(py_apObjArray, apObjArray_cntr_1));
			}
		}
	}
	return true;
}

static PyObject *unpack_py_Indicate_args_out(struct Indicate *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = pytalloc_reference_ex(ORPCTHAT_Type, r->out.ORPCthat, r->out.ORPCthat);
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IWbemObjectSink_methods[] = {
	{ "SetStatus", "S.SetStatus(ORPCthis, lFlags, hResult, strParam, pObjParam) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_SetStatus_r, (py_data_pack_fn)pack_py_SetStatus_args_in, (py_data_unpack_fn)unpack_py_SetStatus_args_out, 0, &ndr_table_IWbemObjectSink },
	{ "Indicate", "S.Indicate(ORPCthis, apObjArray) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_Indicate_r, (py_data_pack_fn)pack_py_Indicate_args_in, (py_data_unpack_fn)unpack_py_Indicate_args_out, 1, &ndr_table_IWbemObjectSink },
	{ NULL }
};

static PyObject *interface_IWbemObjectSink_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IWbemObjectSink);
}

static PyTypeObject IWbemObjectSink_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "wmi.IWbemObjectSink",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IWbemObjectSink(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IWbemObjectSink_new,
};

static PyMethodDef wmi_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initwmi(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_dcom;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_orpc;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_dcom = PyImport_ImportModule("samba.dcerpc.dcom");
	if (dep_samba_dcerpc_dcom == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_orpc = PyImport_ImportModule("samba.dcerpc.orpc");
	if (dep_samba_dcerpc_orpc == NULL)
		return;

	ORPCTHIS_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_orpc, "ORPCTHIS");
	if (ORPCTHIS_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	MInterfacePointer_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_orpc, "MInterfacePointer");
	if (MInterfacePointer_Type == NULL)
		return;

	ORPCTHAT_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_orpc, "ORPCTHAT");
	if (ORPCTHAT_Type == NULL)
		return;

	BSTR_Type.tp_base = Object_Type;

	IWbemClassObject_InterfaceType.tp_base = ClientConnection_Type;

	CIMSTRINGS_Type.tp_base = Object_Type;

	IWbemServices_InterfaceType.tp_base = ClientConnection_Type;

	IEnumWbemClassObject_InterfaceType.tp_base = ClientConnection_Type;

	IWbemContext_InterfaceType.tp_base = ClientConnection_Type;

	IWbemLevel1Login_InterfaceType.tp_base = ClientConnection_Type;

	WBEMDATA_Type.tp_base = Object_Type;

	WBEMDATA4_Type.tp_base = Object_Type;

	WBEMDATA3_Type.tp_base = Object_Type;

	WBEMDATA2_Type.tp_base = Object_Type;

	WBEMDATA1_Type.tp_base = Object_Type;

	WBEMDATA0_Type.tp_base = Object_Type;

	IWbemWCOSmartEnum_InterfaceType.tp_base = ClientConnection_Type;

	IWbemFetchSmartEnum_InterfaceType.tp_base = ClientConnection_Type;

	IWbemCallResult_InterfaceType.tp_base = ClientConnection_Type;

	IWbemObjectSink_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&BSTR_Type) < 0)
		return;
	if (PyType_Ready(&IWbemClassObject_InterfaceType) < 0)
		return;
	if (PyType_Ready(&CIMSTRINGS_Type) < 0)
		return;
	if (PyType_Ready(&IWbemServices_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IEnumWbemClassObject_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IWbemContext_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IWbemLevel1Login_InterfaceType) < 0)
		return;
	if (PyType_Ready(&WBEMDATA_Type) < 0)
		return;
	if (PyType_Ready(&WBEMDATA4_Type) < 0)
		return;
	if (PyType_Ready(&WBEMDATA3_Type) < 0)
		return;
	if (PyType_Ready(&WBEMDATA2_Type) < 0)
		return;
	if (PyType_Ready(&WBEMDATA1_Type) < 0)
		return;
	if (PyType_Ready(&WBEMDATA0_Type) < 0)
		return;
	if (PyType_Ready(&IWbemWCOSmartEnum_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IWbemFetchSmartEnum_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IWbemCallResult_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IWbemObjectSink_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&IWbemClassObject_InterfaceType, py_ndr_IWbemClassObject_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemServices_InterfaceType, py_ndr_IWbemServices_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IEnumWbemClassObject_InterfaceType, py_ndr_IEnumWbemClassObject_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemContext_InterfaceType, py_ndr_IWbemContext_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemLevel1Login_InterfaceType, py_ndr_IWbemLevel1Login_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemWCOSmartEnum_InterfaceType, py_ndr_IWbemWCOSmartEnum_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemFetchSmartEnum_InterfaceType, py_ndr_IWbemFetchSmartEnum_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemCallResult_InterfaceType, py_ndr_IWbemCallResult_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IWbemObjectSink_InterfaceType, py_ndr_IWbemObjectSink_methods))
		return;

#ifdef PY_BSTR_PATCH
	PY_BSTR_PATCH(&BSTR_Type);
#endif
#ifdef PY_IWBEMCLASSOBJECT_PATCH
	PY_IWBEMCLASSOBJECT_PATCH(&IWbemClassObject_InterfaceType);
#endif
#ifdef PY_CIMSTRINGS_PATCH
	PY_CIMSTRINGS_PATCH(&CIMSTRINGS_Type);
#endif
#ifdef PY_IWBEMSERVICES_PATCH
	PY_IWBEMSERVICES_PATCH(&IWbemServices_InterfaceType);
#endif
#ifdef PY_IENUMWBEMCLASSOBJECT_PATCH
	PY_IENUMWBEMCLASSOBJECT_PATCH(&IEnumWbemClassObject_InterfaceType);
#endif
#ifdef PY_IWBEMCONTEXT_PATCH
	PY_IWBEMCONTEXT_PATCH(&IWbemContext_InterfaceType);
#endif
#ifdef PY_IWBEMLEVEL1LOGIN_PATCH
	PY_IWBEMLEVEL1LOGIN_PATCH(&IWbemLevel1Login_InterfaceType);
#endif
#ifdef PY_WBEMDATA_PATCH
	PY_WBEMDATA_PATCH(&WBEMDATA_Type);
#endif
#ifdef PY_WBEMDATA4_PATCH
	PY_WBEMDATA4_PATCH(&WBEMDATA4_Type);
#endif
#ifdef PY_WBEMDATA3_PATCH
	PY_WBEMDATA3_PATCH(&WBEMDATA3_Type);
#endif
#ifdef PY_WBEMDATA2_PATCH
	PY_WBEMDATA2_PATCH(&WBEMDATA2_Type);
#endif
#ifdef PY_WBEMDATA1_PATCH
	PY_WBEMDATA1_PATCH(&WBEMDATA1_Type);
#endif
#ifdef PY_WBEMDATA0_PATCH
	PY_WBEMDATA0_PATCH(&WBEMDATA0_Type);
#endif
#ifdef PY_IWBEMWCOSMARTENUM_PATCH
	PY_IWBEMWCOSMARTENUM_PATCH(&IWbemWCOSmartEnum_InterfaceType);
#endif
#ifdef PY_IWBEMFETCHSMARTENUM_PATCH
	PY_IWBEMFETCHSMARTENUM_PATCH(&IWbemFetchSmartEnum_InterfaceType);
#endif
#ifdef PY_IWBEMCALLRESULT_PATCH
	PY_IWBEMCALLRESULT_PATCH(&IWbemCallResult_InterfaceType);
#endif
#ifdef PY_IWBEMOBJECTSINK_PATCH
	PY_IWBEMOBJECTSINK_PATCH(&IWbemObjectSink_InterfaceType);
#endif

	m = Py_InitModule3("wmi", wmi_methods, "wmi DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "WBEM_E_NOT_SUPPORTED", PyInt_FromLong(WBEM_E_NOT_SUPPORTED));
	PyModule_AddObject(m, "WBEM_E_PROPERTY_NAME_TOO_WIDE", PyInt_FromLong(WBEM_E_PROPERTY_NAME_TOO_WIDE));
	PyModule_AddObject(m, "WBEM_E_INVALID_CONTEXT", PyInt_FromLong(WBEM_E_INVALID_CONTEXT));
	PyModule_AddObject(m, "CIM_ARR_BOOLEAN", PyInt_FromLong(CIM_ARR_BOOLEAN));
	PyModule_AddObject(m, "RPC_S_CALL_FAILED", PyInt_FromLong(RPC_S_CALL_FAILED));
	PyModule_AddObject(m, "WBEM_E_CIRCULAR_REFERENCE", PyInt_FromLong(WBEM_E_CIRCULAR_REFERENCE));
	PyModule_AddObject(m, "WBEM_FLAG_DIRECT_READ", PyInt_FromLong(WBEM_FLAG_DIRECT_READ));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_NOT_CAPABLE", PyInt_FromLong(WBEM_E_PROVIDER_NOT_CAPABLE));
	PyModule_AddObject(m, "WBEM_S_RESET_TO_DEFAULT", PyInt_FromLong(WBEM_S_RESET_TO_DEFAULT));
	PyModule_AddObject(m, "WBEM_FLAVOR_FLAG_PROPAGATE_TO_INSTANCE", PyInt_FromLong(WBEM_FLAVOR_FLAG_PROPAGATE_TO_INSTANCE));
	PyModule_AddObject(m, "WBEM_E_METHOD_NOT_IMPLEMENTED", PyInt_FromLong(WBEM_E_METHOD_NOT_IMPLEMENTED));
	PyModule_AddObject(m, "WBEM_E_METHOD_NAME_TOO_WIDE", PyInt_FromLong(WBEM_E_METHOD_NAME_TOO_WIDE));
	PyModule_AddObject(m, "WBEM_S_PARTIAL_RESULTS", PyInt_FromLong(WBEM_S_PARTIAL_RESULTS));
	PyModule_AddObject(m, "CIM_DATETIME", PyInt_FromLong(CIM_DATETIME));
	PyModule_AddObject(m, "WBEM_E_RERUN_COMMAND", PyInt_FromLong(WBEM_E_RERUN_COMMAND));
	PyModule_AddObject(m, "WBEM_MASK_RESERVED_FLAGS", PyInt_FromLong(WBEM_MASK_RESERVED_FLAGS));
	PyModule_AddObject(m, "WBEM_E_PARAMETER_ID_ON_RETVAL", PyInt_FromLong(WBEM_E_PARAMETER_ID_ON_RETVAL));
	PyModule_AddObject(m, "WBEM_E_PROPAGATED_PROPERTY", PyInt_FromLong(WBEM_E_PROPAGATED_PROPERTY));
	PyModule_AddObject(m, "WBEM_E_INVALID_PARAMETER_ID", PyInt_FromLong(WBEM_E_INVALID_PARAMETER_ID));
	PyModule_AddObject(m, "WBEM_S_NO_MORE_DATA", PyInt_FromLong(WBEM_S_NO_MORE_DATA));
	PyModule_AddObject(m, "WBEM_S_SOURCE_NOT_AVAILABLE", PyInt_FromLong(WBEM_S_SOURCE_NOT_AVAILABLE));
	PyModule_AddObject(m, "WBEM_S_POSTHOOK_WITH_OLD", PyInt_FromLong(WBEM_S_POSTHOOK_WITH_OLD));
	PyModule_AddObject(m, "WBEM_E_NO_KEY", PyInt_FromLong(WBEM_E_NO_KEY));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_SUSPENDED", PyInt_FromLong(WBEM_E_PROVIDER_SUSPENDED));
	PyModule_AddObject(m, "WBEM_S_ACCESS_DENIED", PyInt_FromLong(WBEM_S_ACCESS_DENIED));
	PyModule_AddObject(m, "CIM_ARR_SINT32", PyInt_FromLong(CIM_ARR_SINT32));
	PyModule_AddObject(m, "CIM_ARR_UINT64", PyInt_FromLong(CIM_ARR_UINT64));
	PyModule_AddObject(m, "WBEM_E_INVALID_OBJECT", PyInt_FromLong(WBEM_E_INVALID_OBJECT));
	PyModule_AddObject(m, "WBEM_E_VETO_PUT", PyInt_FromLong(WBEM_E_VETO_PUT));
	PyModule_AddObject(m, "WBEM_E_INVALID_METHOD_PARAMETERS", PyInt_FromLong(WBEM_E_INVALID_METHOD_PARAMETERS));
	PyModule_AddObject(m, "WBEM_S_POSTHOOK_WITH_BOTH", PyInt_FromLong(WBEM_S_POSTHOOK_WITH_BOTH));
	PyModule_AddObject(m, "WBEM_E_CANNOT_CHANGE_KEY_INHERITANCE", PyInt_FromLong(WBEM_E_CANNOT_CHANGE_KEY_INHERITANCE));
	PyModule_AddObject(m, "WBEM_E_PROPERTY_NOT_AN_OBJECT", PyInt_FromLong(WBEM_E_PROPERTY_NOT_AN_OBJECT));
	PyModule_AddObject(m, "WBEM_FLAG_BIDIRECTIONAL", PyInt_FromLong(WBEM_FLAG_BIDIRECTIONAL));
	PyModule_AddObject(m, "WBEM_E_CANNOT_CHANGE_INDEX_INHERITANCE", PyInt_FromLong(WBEM_E_CANNOT_CHANGE_INDEX_INHERITANCE));
	PyModule_AddObject(m, "WBEM_E_AMENDED_OBJECT", PyInt_FromLong(WBEM_E_AMENDED_OBJECT));
	PyModule_AddObject(m, "WBEM_E_INVALID_DUPLICATE_PARAMETER", PyInt_FromLong(WBEM_E_INVALID_DUPLICATE_PARAMETER));
	PyModule_AddObject(m, "WBEM_E_UPDATE_TYPE_MISMATCH", PyInt_FromLong(WBEM_E_UPDATE_TYPE_MISMATCH));
	PyModule_AddObject(m, "WBEM_E_INVALID_QUALIFIER", PyInt_FromLong(WBEM_E_INVALID_QUALIFIER));
	PyModule_AddObject(m, "WBEM_E_TYPE_MISMATCH", PyInt_FromLong(WBEM_E_TYPE_MISMATCH));
	PyModule_AddObject(m, "WBEM_E_CONNECTION_FAILED", PyInt_FromLong(WBEM_E_CONNECTION_FAILED));
	PyModule_AddObject(m, "WBEM_E_SHUTTING_DOWN", PyInt_FromLong(WBEM_E_SHUTTING_DOWN));
	PyModule_AddObject(m, "WBEM_FLAG_STRONG_VALIDATION", PyInt_FromLong(WBEM_FLAG_STRONG_VALIDATION));
	PyModule_AddObject(m, "CIM_OBJECT", PyInt_FromLong(CIM_OBJECT));
	PyModule_AddObject(m, "WBEM_E_READ_ONLY", PyInt_FromLong(WBEM_E_READ_ONLY));
	PyModule_AddObject(m, "WBEM_E_INVALID_CLASS", PyInt_FromLong(WBEM_E_INVALID_CLASS));
	PyModule_AddObject(m, "WBEM_E_OVERRIDE_NOT_ALLOWED", PyInt_FromLong(WBEM_E_OVERRIDE_NOT_ALLOWED));
	PyModule_AddObject(m, "WBEM_E_INVALID_LOCALE", PyInt_FromLong(WBEM_E_INVALID_LOCALE));
	PyModule_AddObject(m, "WBEM_E_ILLEGAL_NULL", PyInt_FromLong(WBEM_E_ILLEGAL_NULL));
	PyModule_AddObject(m, "WBEM_E_INVALID_SYNTAX", PyInt_FromLong(WBEM_E_INVALID_SYNTAX));
	PyModule_AddObject(m, "CIM_ARR_DATETIME", PyInt_FromLong(CIM_ARR_DATETIME));
	PyModule_AddObject(m, "WBEM_FLAG_RETURN_IMMEDIATELY", PyInt_FromLong(WBEM_FLAG_RETURN_IMMEDIATELY));
	PyModule_AddObject(m, "WBEM_E_OUT_OF_MEMORY", PyInt_FromLong(WBEM_E_OUT_OF_MEMORY));
	PyModule_AddObject(m, "WBEM_S_PENDING", PyInt_FromLong(WBEM_S_PENDING));
	PyModule_AddObject(m, "WBEM_E_CANNOT_BE_KEY", PyInt_FromLong(WBEM_E_CANNOT_BE_KEY));
	PyModule_AddObject(m, "WBEM_E_HANDLE_OUT_OF_DATE", PyInt_FromLong(WBEM_E_HANDLE_OUT_OF_DATE));
	PyModule_AddObject(m, "WBEM_E_UNEXPECTED", PyInt_FromLong(WBEM_E_UNEXPECTED));
	PyModule_AddObject(m, "WBEM_E_MARSHAL_VERSION_MISMATCH", PyInt_FromLong(WBEM_E_MARSHAL_VERSION_MISMATCH));
	PyModule_AddObject(m, "WBEM_FLAG_SEND_STATUS", PyInt_FromLong(WBEM_FLAG_SEND_STATUS));
	PyModule_AddObject(m, "CIM_ARR_SINT8", PyInt_FromLong(CIM_ARR_SINT8));
	PyModule_AddObject(m, "WBEM_S_DUPLICATE_OBJECTS", PyInt_FromLong(WBEM_S_DUPLICATE_OBJECTS));
	PyModule_AddObject(m, "WBEM_E_PROPAGATED_QUALIFIER", PyInt_FromLong(WBEM_E_PROPAGATED_QUALIFIER));
	PyModule_AddObject(m, "WBEM_E_VALUE_OUT_OF_RANGE", PyInt_FromLong(WBEM_E_VALUE_OUT_OF_RANGE));
	PyModule_AddObject(m, "WBEM_E_NOT_EVENT_CLASS", PyInt_FromLong(WBEM_E_NOT_EVENT_CLASS));
	PyModule_AddObject(m, "WBEM_FLAVOR_ORIGIN_SYSTEM", PyInt_FromLong(WBEM_FLAVOR_ORIGIN_SYSTEM));
	PyModule_AddObject(m, "WBEM_E_MISSING_GROUP_WITHIN", PyInt_FromLong(WBEM_E_MISSING_GROUP_WITHIN));
	PyModule_AddObject(m, "WBEM_E_MARSHAL_INVALID_SIGNATURE", PyInt_FromLong(WBEM_E_MARSHAL_INVALID_SIGNATURE));
	PyModule_AddObject(m, "WBEM_E_PROPAGATED_METHOD", PyInt_FromLong(WBEM_E_PROPAGATED_METHOD));
	PyModule_AddObject(m, "WBEM_E_CLASS_NAME_TOO_WIDE", PyInt_FromLong(WBEM_E_CLASS_NAME_TOO_WIDE));
	PyModule_AddObject(m, "WBEM_NO_WAIT", NULL);
	PyModule_AddObject(m, "WBEM_E_ILLEGAL_OPERATION", PyInt_FromLong(WBEM_E_ILLEGAL_OPERATION));
	PyModule_AddObject(m, "WBEM_E_CLASS_HAS_CHILDREN", PyInt_FromLong(WBEM_E_CLASS_HAS_CHILDREN));
	PyModule_AddObject(m, "WBEM_E_NO_SCHEMA", PyInt_FromLong(WBEM_E_NO_SCHEMA));
	PyModule_AddObject(m, "DEFAULT_FLAG_EMPTY", PyInt_FromLong(DEFAULT_FLAG_EMPTY));
	PyModule_AddObject(m, "CIM_ARR_REFERENCE", PyInt_FromLong(CIM_ARR_REFERENCE));
	PyModule_AddObject(m, "CIM_ARR_UINT16", PyInt_FromLong(CIM_ARR_UINT16));
	PyModule_AddObject(m, "WBEM_E_QUEUE_OVERFLOW", PyInt_FromLong(WBEM_E_QUEUE_OVERFLOW));
	PyModule_AddObject(m, "CIM_CHAR16", PyInt_FromLong(CIM_CHAR16));
	PyModule_AddObject(m, "WBEM_S_REDO_PREHOOK_WITH_ORIGINAL_OBJECT", PyInt_FromLong(WBEM_S_REDO_PREHOOK_WITH_ORIGINAL_OBJECT));
	PyModule_AddObject(m, "CIM_STRING", PyInt_FromLong(CIM_STRING));
	PyModule_AddObject(m, "CIM_UINT16", PyInt_FromLong(CIM_UINT16));
	PyModule_AddObject(m, "WBEM_S_TIMEDOUT", PyInt_FromLong(WBEM_S_TIMEDOUT));
	PyModule_AddObject(m, "WBEM_E_RESERVED_001", PyInt_FromLong(WBEM_E_RESERVED_001));
	PyModule_AddObject(m, "WCF_CLASS", PyInt_FromLong(WCF_CLASS));
	PyModule_AddObject(m, "WBEM_E_NONCONSECUTIVE_PARAMETER_IDS", PyInt_FromLong(WBEM_E_NONCONSECUTIVE_PARAMETER_IDS));
	PyModule_AddObject(m, "WBEM_E_UNKNOWN_PACKET_TYPE", PyInt_FromLong(WBEM_E_UNKNOWN_PACKET_TYPE));
	PyModule_AddObject(m, "CIM_SINT8", PyInt_FromLong(CIM_SINT8));
	PyModule_AddObject(m, "WBEM_E_AGGREGATING_BY_OBJECT", PyInt_FromLong(WBEM_E_AGGREGATING_BY_OBJECT));
	PyModule_AddObject(m, "WBEM_E_LOCAL_CREDENTIALS", PyInt_FromLong(WBEM_E_LOCAL_CREDENTIALS));
	PyModule_AddObject(m, "WBEM_E_CRITICAL_ERROR", PyInt_FromLong(WBEM_E_CRITICAL_ERROR));
	PyModule_AddObject(m, "CIM_ARR_REAL32", PyInt_FromLong(CIM_ARR_REAL32));
	PyModule_AddObject(m, "WBEM_E_INVALID_NAMESPACE", PyInt_FromLong(WBEM_E_INVALID_NAMESPACE));
	PyModule_AddObject(m, "WBEM_E_ACCESS_DENIED", PyInt_FromLong(WBEM_E_ACCESS_DENIED));
	PyModule_AddObject(m, "WBEM_FLAG_DONT_SEND_STATUS", PyInt_FromLong(WBEM_FLAG_DONT_SEND_STATUS));
	PyModule_AddObject(m, "WTYPE_OBJECT", PyInt_FromLong(WTYPE_OBJECT));
	PyModule_AddObject(m, "WBEM_E_AMBIGUOUS_OPERATION", PyInt_FromLong(WBEM_E_AMBIGUOUS_OPERATION));
	PyModule_AddObject(m, "WBEM_E_INCOMPLETE_CLASS", PyInt_FromLong(WBEM_E_INCOMPLETE_CLASS));
	PyModule_AddObject(m, "WBEM_FLAG_NO_ERROR_OBJECT", PyInt_FromLong(WBEM_FLAG_NO_ERROR_OBJECT));
	PyModule_AddObject(m, "WBEM_E_NOT_FOUND", PyInt_FromLong(WBEM_E_NOT_FOUND));
	PyModule_AddObject(m, "WBEM_E_INVALID_QUERY", PyInt_FromLong(WBEM_E_INVALID_QUERY));
	PyModule_AddObject(m, "WBEM_E_BUFFER_TOO_SMALL", PyInt_FromLong(WBEM_E_BUFFER_TOO_SMALL));
	PyModule_AddObject(m, "WBEM_E_UNINTERPRETABLE_PROVIDER_QUERY", PyInt_FromLong(WBEM_E_UNINTERPRETABLE_PROVIDER_QUERY));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_TIMED_OUT", PyInt_FromLong(WBEM_E_PROVIDER_TIMED_OUT));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_LOAD_FAILURE", PyInt_FromLong(WBEM_E_PROVIDER_LOAD_FAILURE));
	PyModule_AddObject(m, "WBEM_FLAG_RETURN_ERROR_OBJECT", PyInt_FromLong(WBEM_FLAG_RETURN_ERROR_OBJECT));
	PyModule_AddObject(m, "CIM_ARR_CHAR16", PyInt_FromLong(CIM_ARR_CHAR16));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_ALREADY_REGISTERED", PyInt_FromLong(WBEM_E_PROVIDER_ALREADY_REGISTERED));
	PyModule_AddObject(m, "WBEM_RETURN_WHEN_COMPLETE", PyInt_FromLong(WBEM_RETURN_WHEN_COMPLETE));
	PyModule_AddObject(m, "WBEM_FLAG_USE_AMENDED_QUALIFIERS", PyInt_FromLong(WBEM_FLAG_USE_AMENDED_QUALIFIERS));
	PyModule_AddObject(m, "WBEM_E_ENCRYPTED_CONNECTION_REQUIRED", PyInt_FromLong(WBEM_E_ENCRYPTED_CONNECTION_REQUIRED));
	PyModule_AddObject(m, "WCF_CLASS_PART_INTERNAL", PyInt_FromLong(WCF_CLASS_PART_INTERNAL));
	PyModule_AddObject(m, "WBEM_E_INVALID_PROPERTY", PyInt_FromLong(WBEM_E_INVALID_PROPERTY));
	PyModule_AddObject(m, "WBEM_E_TRANSPORT_FAILURE", PyInt_FromLong(WBEM_E_TRANSPORT_FAILURE));
	PyModule_AddObject(m, "CIM_TYPEMASK", PyInt_FromLong(CIM_TYPEMASK));
	PyModule_AddObject(m, "CIM_ILLEGAL", PyInt_FromLong(CIM_ILLEGAL));
	PyModule_AddObject(m, "WBEM_E_UNSUPPORTED_PARAMETER", PyInt_FromLong(WBEM_E_UNSUPPORTED_PARAMETER));
	PyModule_AddObject(m, "CIM_SINT32", PyInt_FromLong(CIM_SINT32));
	PyModule_AddObject(m, "WBEM_E_INVALID_ASSOCIATION", PyInt_FromLong(WBEM_E_INVALID_ASSOCIATION));
	PyModule_AddObject(m, "WCF_INSTANCE", PyInt_FromLong(WCF_INSTANCE));
	PyModule_AddObject(m, "WBEM_E_PRIVILEGE_NOT_HELD", PyInt_FromLong(WBEM_E_PRIVILEGE_NOT_HELD));
	PyModule_AddObject(m, "WBEM_E_QUOTA_VIOLATION", PyInt_FromLong(WBEM_E_QUOTA_VIOLATION));
	PyModule_AddObject(m, "WBEM_FLAVOR_AMENDED", PyInt_FromLong(WBEM_FLAVOR_AMENDED));
	PyModule_AddObject(m, "WBEM_E_MISSING_PARAMETER_ID", PyInt_FromLong(WBEM_E_MISSING_PARAMETER_ID));
	PyModule_AddObject(m, "WBEM_E_VETO_DELETE", PyInt_FromLong(WBEM_E_VETO_DELETE));
	PyModule_AddObject(m, "WBEM_RETURN_IMMEDIATELY", PyInt_FromLong(WBEM_RETURN_IMMEDIATELY));
	PyModule_AddObject(m, "CIM_ARR_SINT64", PyInt_FromLong(CIM_ARR_SINT64));
	PyModule_AddObject(m, "WBEM_E_UNSUPPORTED_PUT_EXTENSION", PyInt_FromLong(WBEM_E_UNSUPPORTED_PUT_EXTENSION));
	PyModule_AddObject(m, "WBEM_S_POSTHOOK_WITH_NEW", PyInt_FromLong(WBEM_S_POSTHOOK_WITH_NEW));
	PyModule_AddObject(m, "WBEM_E_FAILED", PyInt_FromLong(WBEM_E_FAILED));
	PyModule_AddObject(m, "CIM_ARR_STRING", PyInt_FromLong(CIM_ARR_STRING));
	PyModule_AddObject(m, "WBEM_E_CLIENT_TOO_SLOW", PyInt_FromLong(WBEM_E_CLIENT_TOO_SLOW));
	PyModule_AddObject(m, "CIM_ARR_UINT8", PyInt_FromLong(CIM_ARR_UINT8));
	PyModule_AddObject(m, "WBEM_S_OPERATION_CANCELLED", PyInt_FromLong(WBEM_S_OPERATION_CANCELLED));
	PyModule_AddObject(m, "WBEM_FLAVOR_NOT_OVERRIDABLE", PyInt_FromLong(WBEM_FLAVOR_NOT_OVERRIDABLE));
	PyModule_AddObject(m, "WBEM_E_DATABASE_VER_MISMATCH", PyInt_FromLong(WBEM_E_DATABASE_VER_MISMATCH));
	PyModule_AddObject(m, "WBEM_E_TOO_MUCH_DATA", PyInt_FromLong(WBEM_E_TOO_MUCH_DATA));
	PyModule_AddObject(m, "WBEM_FLAVOR_FLAG_PROPAGATE_TO_DERIVED_CLASS", PyInt_FromLong(WBEM_FLAVOR_FLAG_PROPAGATE_TO_DERIVED_CLASS));
	PyModule_AddObject(m, "WBEM_E_INVALID_QUALIFIER_TYPE", PyInt_FromLong(WBEM_E_INVALID_QUALIFIER_TYPE));
	PyModule_AddObject(m, "WBEM_E_INVALID_SUPERCLASS", PyInt_FromLong(WBEM_E_INVALID_SUPERCLASS));
	PyModule_AddObject(m, "WBEM_E_UNSUPPORTED_LOCALE", PyInt_FromLong(WBEM_E_UNSUPPORTED_LOCALE));
	PyModule_AddObject(m, "CIM_REAL32", PyInt_FromLong(CIM_REAL32));
	PyModule_AddObject(m, "WBEM_E_INVALID_PARAMETER", PyInt_FromLong(WBEM_E_INVALID_PARAMETER));
	PyModule_AddObject(m, "CIM_UINT64", PyInt_FromLong(CIM_UINT64));
	PyModule_AddObject(m, "WBEM_E_INVALID_METHOD", PyInt_FromLong(WBEM_E_INVALID_METHOD));
	PyModule_AddObject(m, "WBEM_E_ALREADY_EXISTS", PyInt_FromLong(WBEM_E_ALREADY_EXISTS));
	PyModule_AddObject(m, "CIM_FLAG_ARRAY", PyInt_FromLong(CIM_FLAG_ARRAY));
	PyModule_AddObject(m, "WCF_DECORATIONS", PyInt_FromLong(WCF_DECORATIONS));
	PyModule_AddObject(m, "WBEM_E_NOT_AVAILABLE", PyInt_FromLong(WBEM_E_NOT_AVAILABLE));
	PyModule_AddObject(m, "WBEM_E_INVALID_PROVIDER_REGISTRATION", PyInt_FromLong(WBEM_E_INVALID_PROVIDER_REGISTRATION));
	PyModule_AddObject(m, "DEFAULT_FLAG_INHERITED", PyInt_FromLong(DEFAULT_FLAG_INHERITED));
	PyModule_AddObject(m, "WBEM_E_NONDECORATED_OBJECT", PyInt_FromLong(WBEM_E_NONDECORATED_OBJECT));
	PyModule_AddObject(m, "CIM_REAL64", PyInt_FromLong(CIM_REAL64));
	PyModule_AddObject(m, "WBEM_S_POSTHOOK_WITH_STATUS", PyInt_FromLong(WBEM_S_POSTHOOK_WITH_STATUS));
	PyModule_AddObject(m, "WBEM_S_SAME", PyInt_FromLong(WBEM_S_SAME));
	PyModule_AddObject(m, "WBEM_E_BACKUP_RESTORE_WINMGMT_RUNNING", PyInt_FromLong(WBEM_E_BACKUP_RESTORE_WINMGMT_RUNNING));
	PyModule_AddObject(m, "WBEM_E_INVALID_OPERATOR", PyInt_FromLong(WBEM_E_INVALID_OPERATOR));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_DISABLED", PyInt_FromLong(WBEM_E_PROVIDER_DISABLED));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_NOT_FOUND", PyInt_FromLong(WBEM_E_PROVIDER_NOT_FOUND));
	PyModule_AddObject(m, "CIM_ARR_SINT16", PyInt_FromLong(CIM_ARR_SINT16));
	PyModule_AddObject(m, "CIM_ARR_UINT32", PyInt_FromLong(CIM_ARR_UINT32));
	PyModule_AddObject(m, "CIM_UINT32", PyInt_FromLong(CIM_UINT32));
	PyModule_AddObject(m, "WBEM_INFINITE", NULL);
	PyModule_AddObject(m, "WBEM_E_MISSING_AGGREGATION_LIST", PyInt_FromLong(WBEM_E_MISSING_AGGREGATION_LIST));
	PyModule_AddObject(m, "WBEM_E_INVALID_QUERY_TYPE", PyInt_FromLong(WBEM_E_INVALID_QUERY_TYPE));
	PyModule_AddObject(m, "WBEM_FLAG_RETURN_WBEM_COMPLETE", PyInt_FromLong(WBEM_FLAG_RETURN_WBEM_COMPLETE));
	PyModule_AddObject(m, "WBEM_E_CALL_CANCELLED", PyInt_FromLong(WBEM_E_CALL_CANCELLED));
	PyModule_AddObject(m, "CIM_ARR_OBJECT", PyInt_FromLong(CIM_ARR_OBJECT));
	PyModule_AddObject(m, "CIM_SINT16", PyInt_FromLong(CIM_SINT16));
	PyModule_AddObject(m, "WBEM_E_UNSUPPORTED_CLASS_UPDATE", PyInt_FromLong(WBEM_E_UNSUPPORTED_CLASS_UPDATE));
	PyModule_AddObject(m, "WTYPE_CLASS", PyInt_FromLong(WTYPE_CLASS));
	PyModule_AddObject(m, "WBEM_E_INVALID_FLAVOR", PyInt_FromLong(WBEM_E_INVALID_FLAVOR));
	PyModule_AddObject(m, "WTYPE_SCHEMA", PyInt_FromLong(WTYPE_SCHEMA));
	PyModule_AddObject(m, "WBEM_NO_ERROR", PyInt_FromLong(WBEM_NO_ERROR));
	PyModule_AddObject(m, "CIM_ARR_REAL64", PyInt_FromLong(CIM_ARR_REAL64));
	PyModule_AddObject(m, "WBEM_E_SYSTEM_PROPERTY", PyInt_FromLong(WBEM_E_SYSTEM_PROPERTY));
	PyModule_AddObject(m, "WBEM_E_NULL_SECURITY_DESCRIPTOR", PyInt_FromLong(WBEM_E_NULL_SECURITY_DESCRIPTOR));
	PyModule_AddObject(m, "WBEM_FLAG_FORWARD_ONLY", PyInt_FromLong(WBEM_FLAG_FORWARD_ONLY));
	PyModule_AddObject(m, "CIM_BOOLEAN", PyInt_FromLong(CIM_BOOLEAN));
	PyModule_AddObject(m, "WBEM_E_INVALID_OPERATION", PyInt_FromLong(WBEM_E_INVALID_OPERATION));
	PyModule_AddObject(m, "CIM_UINT8", PyInt_FromLong(CIM_UINT8));
	PyModule_AddObject(m, "CIM_SINT64", PyInt_FromLong(CIM_SINT64));
	PyModule_AddObject(m, "WBEM_E_INVALID_STREAM", PyInt_FromLong(WBEM_E_INVALID_STREAM));
	PyModule_AddObject(m, "WBEM_S_NO_POSTHOOK", PyInt_FromLong(WBEM_S_NO_POSTHOOK));
	PyModule_AddObject(m, "WBEM_FLAVOR_ORIGIN_PROPAGATED", PyInt_FromLong(WBEM_FLAVOR_ORIGIN_PROPAGATED));
	PyModule_AddObject(m, "WBEM_E_CANNOT_BE_SINGLETON", PyInt_FromLong(WBEM_E_CANNOT_BE_SINGLETON));
	PyModule_AddObject(m, "WBEM_E_UNKNOWN_OBJECT_TYPE", PyInt_FromLong(WBEM_E_UNKNOWN_OBJECT_TYPE));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_NOT_REGISTERED", PyInt_FromLong(WBEM_E_PROVIDER_NOT_REGISTERED));
	PyModule_AddObject(m, "WBEM_E_UPDATE_OVERRIDE_NOT_ALLOWED", PyInt_FromLong(WBEM_E_UPDATE_OVERRIDE_NOT_ALLOWED));
	PyModule_AddObject(m, "WBEM_E_TOO_MANY_PROPERTIES", PyInt_FromLong(WBEM_E_TOO_MANY_PROPERTIES));
	PyModule_AddObject(m, "WBEM_E_REFRESHER_BUSY", PyInt_FromLong(WBEM_E_REFRESHER_BUSY));
	PyModule_AddObject(m, "WBEM_S_ALREADY_EXISTS", PyInt_FromLong(WBEM_S_ALREADY_EXISTS));
	PyModule_AddObject(m, "WBEM_FLAG_SEND_ONLY_SELECTED", PyInt_FromLong(WBEM_FLAG_SEND_ONLY_SELECTED));
	PyModule_AddObject(m, "WBEM_E_OUT_OF_DISK_SPACE", PyInt_FromLong(WBEM_E_OUT_OF_DISK_SPACE));
	PyModule_AddObject(m, "WBEM_E_INITIALIZATION_FAILURE", PyInt_FromLong(WBEM_E_INITIALIZATION_FAILURE));
	PyModule_AddObject(m, "CIM_EMPTY", PyInt_FromLong(CIM_EMPTY));
	PyModule_AddObject(m, "WBEM_E_INVALID_HANDLE_REQUEST", PyInt_FromLong(WBEM_E_INVALID_HANDLE_REQUEST));
	PyModule_AddObject(m, "WBEM_E_SERVER_TOO_BUSY", PyInt_FromLong(WBEM_E_SERVER_TOO_BUSY));
	PyModule_AddObject(m, "WBEM_E_FATAL_TRANSPORT_ERROR", PyInt_FromLong(WBEM_E_FATAL_TRANSPORT_ERROR));
	PyModule_AddObject(m, "WBEM_E_TIMED_OUT", PyInt_FromLong(WBEM_E_TIMED_OUT));
	PyModule_AddObject(m, "WBEM_E_INVALID_PROPERTY_TYPE", PyInt_FromLong(WBEM_E_INVALID_PROPERTY_TYPE));
	PyModule_AddObject(m, "WBEM_E_QUERY_NOT_IMPLEMENTED", PyInt_FromLong(WBEM_E_QUERY_NOT_IMPLEMENTED));
	PyModule_AddObject(m, "WBEM_E_QUALIFIER_NAME_TOO_WIDE", PyInt_FromLong(WBEM_E_QUALIFIER_NAME_TOO_WIDE));
	PyModule_AddObject(m, "WBEM_E_RESERVED_002", PyInt_FromLong(WBEM_E_RESERVED_002));
	PyModule_AddObject(m, "WBEM_S_FALSE", PyInt_FromLong(WBEM_S_FALSE));
	PyModule_AddObject(m, "WBEM_E_INVALID_OBJECT_PATH", PyInt_FromLong(WBEM_E_INVALID_OBJECT_PATH));
	PyModule_AddObject(m, "CIM_REFERENCE", PyInt_FromLong(CIM_REFERENCE));
	PyModule_AddObject(m, "WBEM_E_SYNCHRONIZATION_REQUIRED", PyInt_FromLong(WBEM_E_SYNCHRONIZATION_REQUIRED));
	PyModule_AddObject(m, "WBEM_E_UPDATE_PROPAGATED_METHOD", PyInt_FromLong(WBEM_E_UPDATE_PROPAGATED_METHOD));
	PyModule_AddObject(m, "WBEM_FLAG_ENSURE_LOCATABLE", PyInt_FromLong(WBEM_FLAG_ENSURE_LOCATABLE));
	PyModule_AddObject(m, "WBEM_E_METHOD_DISABLED", PyInt_FromLong(WBEM_E_METHOD_DISABLED));
	PyModule_AddObject(m, "WBEM_E_PROVIDER_FAILURE", PyInt_FromLong(WBEM_E_PROVIDER_FAILURE));
	PyModule_AddObject(m, "WBEM_E_INVALID_CIM_TYPE", PyInt_FromLong(WBEM_E_INVALID_CIM_TYPE));
	PyModule_AddObject(m, "WBEM_S_NO_ERROR", PyInt_FromLong(WBEM_S_NO_ERROR));
	PyModule_AddObject(m, "WBEM_E_CANNOT_BE_ABSTRACT", PyInt_FromLong(WBEM_E_CANNOT_BE_ABSTRACT));
	PyModule_AddObject(m, "WBEM_E_CLASS_HAS_INSTANCES", PyInt_FromLong(WBEM_E_CLASS_HAS_INSTANCES));
	PyModule_AddObject(m, "WBEM_E_UNPARSABLE_QUERY", PyInt_FromLong(WBEM_E_UNPARSABLE_QUERY));
	PyModule_AddObject(m, "WBEM_S_DIFFERENT", PyInt_FromLong(WBEM_S_DIFFERENT));
	Py_INCREF((PyObject *)(void *)&BSTR_Type);
	PyModule_AddObject(m, "BSTR", (PyObject *)(void *)&BSTR_Type);
	Py_INCREF((PyObject *)(void *)&IWbemClassObject_InterfaceType);
	PyModule_AddObject(m, "IWbemClassObject", (PyObject *)(void *)&IWbemClassObject_InterfaceType);
	Py_INCREF((PyObject *)(void *)&CIMSTRINGS_Type);
	PyModule_AddObject(m, "CIMSTRINGS", (PyObject *)(void *)&CIMSTRINGS_Type);
	Py_INCREF((PyObject *)(void *)&IWbemServices_InterfaceType);
	PyModule_AddObject(m, "IWbemServices", (PyObject *)(void *)&IWbemServices_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IEnumWbemClassObject_InterfaceType);
	PyModule_AddObject(m, "IEnumWbemClassObject", (PyObject *)(void *)&IEnumWbemClassObject_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IWbemContext_InterfaceType);
	PyModule_AddObject(m, "IWbemContext", (PyObject *)(void *)&IWbemContext_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IWbemLevel1Login_InterfaceType);
	PyModule_AddObject(m, "IWbemLevel1Login", (PyObject *)(void *)&IWbemLevel1Login_InterfaceType);
	Py_INCREF((PyObject *)(void *)&WBEMDATA_Type);
	PyModule_AddObject(m, "WBEMDATA", (PyObject *)(void *)&WBEMDATA_Type);
	Py_INCREF((PyObject *)(void *)&WBEMDATA4_Type);
	PyModule_AddObject(m, "WBEMDATA4", (PyObject *)(void *)&WBEMDATA4_Type);
	Py_INCREF((PyObject *)(void *)&WBEMDATA3_Type);
	PyModule_AddObject(m, "WBEMDATA3", (PyObject *)(void *)&WBEMDATA3_Type);
	Py_INCREF((PyObject *)(void *)&WBEMDATA2_Type);
	PyModule_AddObject(m, "WBEMDATA2", (PyObject *)(void *)&WBEMDATA2_Type);
	Py_INCREF((PyObject *)(void *)&WBEMDATA1_Type);
	PyModule_AddObject(m, "WBEMDATA1", (PyObject *)(void *)&WBEMDATA1_Type);
	Py_INCREF((PyObject *)(void *)&WBEMDATA0_Type);
	PyModule_AddObject(m, "WBEMDATA0", (PyObject *)(void *)&WBEMDATA0_Type);
	Py_INCREF((PyObject *)(void *)&IWbemWCOSmartEnum_InterfaceType);
	PyModule_AddObject(m, "IWbemWCOSmartEnum", (PyObject *)(void *)&IWbemWCOSmartEnum_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IWbemFetchSmartEnum_InterfaceType);
	PyModule_AddObject(m, "IWbemFetchSmartEnum", (PyObject *)(void *)&IWbemFetchSmartEnum_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IWbemCallResult_InterfaceType);
	PyModule_AddObject(m, "IWbemCallResult", (PyObject *)(void *)&IWbemCallResult_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IWbemObjectSink_InterfaceType);
	PyModule_AddObject(m, "IWbemObjectSink", (PyObject *)(void *)&IWbemObjectSink_InterfaceType);
#ifdef PY_MOD_WMI_PATCH
	PY_MOD_WMI_PATCH(m);
#endif

}
