/* 
   Unix SMB/CIFS implementation.
   test suite for drsuapi ndr operations

   Copyright (C) Jelmer Vernooij 2007
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_drsuapi.h"

static const uint8_t DsAddEntry_req1_dat[] = {
  0x00, 0x00, 0x00, 0x00, 0x52, 0xd7, 0x26, 0x47, 0x58, 0xd3, 0xd4, 0x45,
  0xaf, 0xa3, 0x85, 0x49, 0x9d, 0x26, 0xb6, 0x11, 0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x87, 0x00, 0x00, 0x00, 0x46, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x00, 0x00, 0x00,
  0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x4e, 0x00, 0x54, 0x00, 0x44, 0x00,
  0x53, 0x00, 0x20, 0x00, 0x53, 0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x69, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x73, 0x00, 0x2c, 0x00, 0x43, 0x00,
  0x4e, 0x00, 0x3d, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x33, 0x00,
  0x2d, 0x00, 0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x2c, 0x00, 0x43, 0x00,
  0x4e, 0x00, 0x3d, 0x00, 0x53, 0x00, 0x65, 0x00, 0x72, 0x00, 0x76, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x53, 0x00, 0x74, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x64, 0x00,
  0x61, 0x00, 0x72, 0x00, 0x64, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00,
  0x65, 0x00, 0x2d, 0x00, 0x64, 0x00, 0x65, 0x00, 0x73, 0x00, 0x2d, 0x00,
  0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6e, 0x00,
  0x2d, 0x00, 0x53, 0x00, 0x74, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x64, 0x00,
  0x6f, 0x00, 0x72, 0x00, 0x74, 0x00, 0x73, 0x00, 0x2c, 0x00, 0x43, 0x00,
  0x4e, 0x00, 0x3d, 0x00, 0x53, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00,
  0x73, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00,
  0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x19, 0x01, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00,
  0x0e, 0x03, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00,
  0x73, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x02, 0x00,
  0x0e, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00,
  0x2c, 0x07, 0x09, 0x00, 0x03, 0x00, 0x00, 0x00, 0x38, 0x00, 0x02, 0x00,
  0x24, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x48, 0x00, 0x02, 0x00,
  0x1c, 0x07, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x00, 0x02, 0x00,
  0xb3, 0x05, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x58, 0x00, 0x02, 0x00,
  0x77, 0x01, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 0x02, 0x00,
  0x03, 0x02, 0x09, 0x00, 0x01, 0x00, 0x00, 0x00, 0x68, 0x00, 0x02, 0x00,
  0x01, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00,
  0xa0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x80, 0x68, 0x00, 0x00, 0x00,
  0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x54, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
  0x94, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0xfd, 0x01, 0x0f, 0x00,
  0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
  0x16, 0xd8, 0xd8, 0x2d, 0x03, 0xe4, 0xc3, 0x74, 0x65, 0x8b, 0xdd, 0x61,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0xff, 0x01, 0x0f, 0x00,
  0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00,
  0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
  0x16, 0xd8, 0xd8, 0x2d, 0x03, 0xe4, 0xc3, 0x74, 0x65, 0x8b, 0xdd, 0x61,
  0x00, 0x02, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
  0x15, 0x00, 0x00, 0x00, 0x16, 0xd8, 0xd8, 0x2d, 0x03, 0xe4, 0xc3, 0x74,
  0x65, 0x8b, 0xdd, 0x61, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x14, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x2f, 0x00, 0x17, 0x00, 0x01, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x02, 0x00, 0xc8, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x46, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x4e, 0x00,
  0x54, 0x00, 0x44, 0x00, 0x53, 0x00, 0x2d, 0x00, 0x44, 0x00, 0x53, 0x00,
  0x41, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x53, 0x00,
  0x63, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x2c, 0x00,
  0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00, 0x72, 0x00, 0x61, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x24, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00, 0xae, 0xa5, 0x70, 0xc5,
  0x6d, 0x2a, 0x27, 0x4e, 0xa1, 0xcc, 0xde, 0x11, 0xcb, 0x76, 0x56, 0x22,
  0x03, 0x00, 0x00, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00,
  0x7a, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x02, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x9a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00,
  0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00,
  0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00,
  0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00,
  0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0xae, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3a, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x53, 0x00,
  0x63, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x2c, 0x00,
  0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00, 0x72, 0x00, 0x61, 0x00,
  0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x9c, 0x00, 0x00, 0x00,
  0x3c, 0x00, 0x02, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x40, 0x00, 0x02, 0x00,
  0xb0, 0x00, 0x00, 0x00, 0x44, 0x00, 0x02, 0x00, 0x9c, 0x00, 0x00, 0x00,
  0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x69, 0x00,
  0x67, 0x00, 0x75, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00,
  0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7a, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
  0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00,
  0x33, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00,
  0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00,
  0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00,
  0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00,
  0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00,
  0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x53, 0x00, 0x63, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6d, 0x00,
  0x61, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00,
  0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0xb0, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x00,
  0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x53, 0x00, 0x63, 0x00, 0x68, 0x00, 0x65, 0x00, 0x6d, 0x00,
  0x61, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00, 0x3d, 0x00, 0x43, 0x00,
  0x6f, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x69, 0x00, 0x67, 0x00, 0x75, 0x00,
  0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00,
  0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00,
  0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x7a, 0x00, 0x00, 0x00, 0x54, 0x00, 0x02, 0x00, 0x7a, 0x00, 0x00, 0x00,
  0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00, 0x2c, 0x00,
  0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x6e, 0x00,
  0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00, 0x43, 0x00,
  0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x5c, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x64, 0x00, 0x02, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
  0xac, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x02, 0x00, 0xac, 0x00, 0x00, 0x00,
  0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x33, 0x00, 0x2d, 0x00,
  0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x2c, 0x00, 0x43, 0x00, 0x4e, 0x00,
  0x3d, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x70, 0x00, 0x75, 0x00,
  0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00,
  0x2c, 0x00, 0x44, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00,
  0x6e, 0x00, 0x65, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x76, 0x00, 0x6d, 0x00, 0x2c, 0x00, 0x44, 0x00,
  0x43, 0x00, 0x3d, 0x00, 0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t DsAddEntry_resp1_dat[] = {
  0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x88, 0xf1, 0x0d, 0x4a, 0xb8, 0xa0, 0xea, 0x47, 0xbb, 0xe5, 0xe6, 0x14,
  0x72, 0x3f, 0x16, 0xdd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t DsBind_req1_dat[] = {
  0x00, 0x00, 0x02, 0x00, 0x9c, 0xb9, 0xfa, 0x6a, 0x26, 0x6e, 0x4a, 0x46,
  0x97, 0x5f, 0xf5, 0x8f, 0x10, 0x52, 0x18, 0xbc, 0x04, 0x00, 0x02, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x7f, 0xfb, 0xff, 0x1f,
  0xda, 0x95, 0x70, 0x26, 0xc1, 0x67, 0xae, 0x4e, 0xb6, 0xfe, 0xf2, 0x83,
  0x15, 0xe3, 0x87, 0xe8, 0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8a, 0xe3, 0x13, 0x71, 0x02, 0xf4, 0x36, 0x71, 0x02, 0x40, 0x28, 0x00,
  0x35, 0x42, 0x51, 0xe3, 0x06, 0x4b, 0xd1, 0x11, 0xab, 0x04, 0x00, 0xc0,
  0x4f, 0xc2, 0xdc, 0xd2, 0x04, 0x00, 0x00, 0x00, 0x04, 0x5d, 0x88, 0x8a,
  0xeb, 0x1c, 0xc9, 0x11, 0x9f, 0xe8, 0x08, 0x00, 0x2b, 0x10, 0x48, 0x60,
  0x02, 0x00, 0x00, 0x00
};

static const uint8_t DsBind_resp1_dat[] = {
  0x00, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x7f, 0xfb, 0xff, 0x1f, 0x81, 0xa6, 0xff, 0x5d, 0x80, 0x13, 0x94, 0x41,
  0xa3, 0x72, 0xe9, 0xb7, 0x79, 0xd7, 0x02, 0x68, 0xf8, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xc6, 0x55, 0x68,
  0xcf, 0x05, 0x42, 0x4a, 0xbb, 0xd3, 0x74, 0xcc, 0x6c, 0xaa, 0xdc, 0x73,
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t DsBind_req2_dat[] = {
  0x00, 0x00, 0x02, 0x00, 0x9c, 0xb9, 0xfa, 0x6a, 0x26, 0x6e, 0x4a, 0x46,
  0x97, 0x5f, 0xf5, 0x8f, 0x10, 0x52, 0x18, 0xbc, 0x04, 0x00, 0x02, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x7f, 0xfb, 0xff, 0x1f,
  0xda, 0x95, 0x70, 0x26, 0xc1, 0x67, 0xae, 0x4e, 0xb6, 0xfe, 0xf2, 0x83,
  0x15, 0xe3, 0x87, 0xe8, 0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t DsBind_resp2_dat[] = {
  0x00, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x7f, 0xfb, 0xff, 0x1f, 0x81, 0xa6, 0xff, 0x5d, 0x80, 0x13, 0x94, 0x41,
  0xa3, 0x72, 0xe9, 0xb7, 0x79, 0xd7, 0x02, 0x68, 0xf8, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xd7, 0x26, 0x47,
  0x58, 0xd3, 0xd4, 0x45, 0xaf, 0xa3, 0x85, 0x49, 0x9d, 0x26, 0xb6, 0x11,
  0x00, 0x00, 0x00, 0x00
};

struct torture_suite *ndr_drsuapi_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "drsuapi");

	torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsAddEntry, DsAddEntry_req1_dat, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsAddEntry, DsAddEntry_resp1_dat, NDR_OUT, NULL );

	/*torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsBind, DsBind_req1_dat, NDR_IN, NULL );*/
	torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsBind, DsBind_resp1_dat, NDR_OUT, NULL );

	/* torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsBind, DsBind_req2_dat, NDR_IN, NULL ); */
	torture_suite_add_ndr_pull_fn_test(suite, drsuapi_DsBind, DsBind_resp2_dat, NDR_OUT, NULL );

	return suite;
}

