/* This file is autogenerated by pidl. DO NOT EDIT */
%module unixinfo

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_unixinfo_c.h"
#include "librpc/gen_ndr/unixinfo.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}



%inline {
struct unixinfo { struct dcerpc_pipe *pipe; };
}

%extend unixinfo {
	unixinfo (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct unixinfo *ret = talloc(mem_ctx, struct unixinfo);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_unixinfo, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~unixinfo() {
		talloc_free(self);
	}
	
	/* unixinfo_SidToUid */
	NTSTATUS SidToUid(struct dom_sid sid, uint64_t *uid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct unixinfo_SidToUid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.sid = sid;
		
		status = dcerpc_unixinfo_SidToUid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*uid = *r.out.uid;
		return r.out.result;
	}
	
	/* unixinfo_UidToSid */
	NTSTATUS UidToSid(uint64_t uid, struct dom_sid *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct unixinfo_UidToSid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.uid = uid;
		
		status = dcerpc_unixinfo_UidToSid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sid = *r.out.sid;
		return r.out.result;
	}
	
	/* unixinfo_SidToGid */
	NTSTATUS SidToGid(struct dom_sid sid, uint64_t *gid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct unixinfo_SidToGid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.sid = sid;
		
		status = dcerpc_unixinfo_SidToGid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*gid = *r.out.gid;
		return r.out.result;
	}
	
	/* unixinfo_GidToSid */
	NTSTATUS GidToSid(uint64_t gid, struct dom_sid *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct unixinfo_GidToSid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.gid = gid;
		
		status = dcerpc_unixinfo_GidToSid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sid = *r.out.sid;
		return r.out.result;
	}
	
	/* unixinfo_GetPWUid */
	NTSTATUS GetPWUid(uint32_t *count, uint64_t *uids, struct unixinfo_GetPWUidInfo *infos, TALLOC_CTX *mem_ctx = NULL)
	{
		struct unixinfo_GetPWUid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.count = count;
		r.in.uids = uids;
		
		status = dcerpc_unixinfo_GetPWUid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*count = *r.out.count;
		/* FIXME: infos [out] argument is not a pointer */
		*infos = *r.out.infos;
		return r.out.result;
	}
	
};

/* unixinfo_GetPWUidInfo */

