/* This file is autogenerated by pidl. DO NOT EDIT */
%module samr

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_samr_c.h"
#include "librpc/gen_ndr/samr.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(samr_AcctFlags);
%types(samr_PasswordProperties);
%types(samr_GroupAttrs);
%types(samr_LogonHours);
%types(samr_CryptPassword);
%types(samr_Password);
%types(samr_RidWithAttribute);
%types(samr_RidWithAttributeArray);


%inline {
struct samr { struct dcerpc_pipe *pipe; };
}

%extend samr {
	samr (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct samr *ret = talloc(mem_ctx, struct samr);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_samr, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~samr() {
		talloc_free(self);
	}
	
	/* samr_Connect */
	NTSTATUS Connect(uint16_t *system_name, uint32_t access_mask, struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Connect r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_Connect(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*connect_handle = *r.out.connect_handle;
		return r.out.result;
	}
	
	/* samr_Close */
	NTSTATUS Close(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Close r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_samr_Close(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* samr_SetSecurity */
	NTSTATUS SetSecurity(struct policy_handle *handle, uint32_t sec_info, struct sec_desc_buf *sdbuf, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetSecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sec_info = sec_info;
		r.in.sdbuf = sdbuf;
		
		status = dcerpc_samr_SetSecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_QuerySecurity */
	NTSTATUS QuerySecurity(struct policy_handle *handle, uint32_t sec_info, struct sec_desc_buf *sdbuf, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QuerySecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sec_info = sec_info;
		
		status = dcerpc_samr_QuerySecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sdbuf = *r.out.sdbuf;
		return r.out.result;
	}
	
	/* samr_Shutdown */
	NTSTATUS Shutdown(struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Shutdown r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.connect_handle = connect_handle;
		
		status = dcerpc_samr_Shutdown(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_LookupDomain */
	NTSTATUS LookupDomain(struct policy_handle *connect_handle, struct lsa_String *domain_name, struct dom_sid2 *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_LookupDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.connect_handle = connect_handle;
		r.in.domain_name = domain_name;
		
		status = dcerpc_samr_LookupDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sid = *r.out.sid;
		return r.out.result;
	}
	
	/* samr_EnumDomains */
	NTSTATUS EnumDomains(struct policy_handle *connect_handle, uint32_t *resume_handle, uint32_t buf_size, struct samr_SamArray *sam, uint32_t num_entries, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_EnumDomains r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.connect_handle = connect_handle;
		r.in.resume_handle = resume_handle;
		r.in.buf_size = buf_size;
		
		status = dcerpc_samr_EnumDomains(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*sam = *r.out.sam;
		/* FIXME: num_entries [out] argument is not a pointer */
		*num_entries = *r.out.num_entries;
		return r.out.result;
	}
	
	/* samr_OpenDomain */
	NTSTATUS OpenDomain(struct policy_handle *connect_handle, uint32_t access_mask, struct dom_sid2 *sid, struct policy_handle *domain_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_OpenDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.connect_handle = connect_handle;
		r.in.access_mask = access_mask;
		r.in.sid = sid;
		
		status = dcerpc_samr_OpenDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domain_handle = *r.out.domain_handle;
		return r.out.result;
	}
	
	/* samr_QueryDomainInfo */
	NTSTATUS QueryDomainInfo(struct policy_handle *domain_handle, uint16_t level, union samr_DomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryDomainInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryDomainInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_SetDomainInfo */
	NTSTATUS SetDomainInfo(struct policy_handle *domain_handle, uint16_t level, union samr_DomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetDomainInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_SetDomainInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_CreateDomainGroup */
	NTSTATUS CreateDomainGroup(struct policy_handle *domain_handle, struct lsa_String *name, uint32_t access_mask, struct policy_handle *group_handle, uint32_t *rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_CreateDomainGroup r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.name = name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_CreateDomainGroup(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*group_handle = *r.out.group_handle;
		*rid = *r.out.rid;
		return r.out.result;
	}
	
	/* samr_EnumDomainGroups */
	NTSTATUS EnumDomainGroups(struct policy_handle *domain_handle, uint32_t *resume_handle, uint32_t max_size, struct samr_SamArray *sam, uint32_t num_entries, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_EnumDomainGroups r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.resume_handle = resume_handle;
		r.in.max_size = max_size;
		
		status = dcerpc_samr_EnumDomainGroups(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*sam = *r.out.sam;
		/* FIXME: num_entries [out] argument is not a pointer */
		*num_entries = *r.out.num_entries;
		return r.out.result;
	}
	
	/* samr_CreateUser */
	NTSTATUS CreateUser(struct policy_handle *domain_handle, struct lsa_String *account_name, uint32_t access_mask, struct policy_handle *user_handle, uint32_t *rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_CreateUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.account_name = account_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_CreateUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*user_handle = *r.out.user_handle;
		*rid = *r.out.rid;
		return r.out.result;
	}
	
	/* samr_EnumDomainUsers */
	NTSTATUS EnumDomainUsers(struct policy_handle *domain_handle, uint32_t *resume_handle, uint32_t acct_flags, uint32_t max_size, struct samr_SamArray *sam, uint32_t num_entries, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_EnumDomainUsers r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.resume_handle = resume_handle;
		r.in.acct_flags = acct_flags;
		r.in.max_size = max_size;
		
		status = dcerpc_samr_EnumDomainUsers(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*sam = *r.out.sam;
		/* FIXME: num_entries [out] argument is not a pointer */
		*num_entries = *r.out.num_entries;
		return r.out.result;
	}
	
	/* samr_CreateDomAlias */
	NTSTATUS CreateDomAlias(struct policy_handle *domain_handle, struct lsa_String *alias_name, uint32_t access_mask, struct policy_handle *alias_handle, uint32_t *rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_CreateDomAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.alias_name = alias_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_CreateDomAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*alias_handle = *r.out.alias_handle;
		*rid = *r.out.rid;
		return r.out.result;
	}
	
	/* samr_EnumDomainAliases */
	NTSTATUS EnumDomainAliases(struct policy_handle *domain_handle, uint32_t *resume_handle, uint32_t acct_flags, struct samr_SamArray *sam, uint32_t num_entries, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_EnumDomainAliases r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.resume_handle = resume_handle;
		r.in.acct_flags = acct_flags;
		
		status = dcerpc_samr_EnumDomainAliases(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*sam = *r.out.sam;
		/* FIXME: num_entries [out] argument is not a pointer */
		*num_entries = *r.out.num_entries;
		return r.out.result;
	}
	
	/* samr_GetAliasMembership */
	NTSTATUS GetAliasMembership(struct policy_handle *domain_handle, struct lsa_SidArray *sids, struct samr_Ids *rids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetAliasMembership r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.sids = sids;
		
		status = dcerpc_samr_GetAliasMembership(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*rids = *r.out.rids;
		return r.out.result;
	}
	
	/* samr_LookupNames */
	NTSTATUS LookupNames(struct policy_handle *domain_handle, uint32_t num_names, struct lsa_String *names, struct samr_Ids rids, struct samr_Ids types, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_LookupNames r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.num_names = num_names;
		r.in.names = names;
		
		status = dcerpc_samr_LookupNames(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: rids [out] argument is not a pointer */
		*rids = *r.out.rids;
		/* FIXME: types [out] argument is not a pointer */
		*types = *r.out.types;
		return r.out.result;
	}
	
	/* samr_LookupRids */
	NTSTATUS LookupRids(struct policy_handle *domain_handle, uint32_t num_rids, uint32_t *rids, struct lsa_Strings names, struct samr_Ids types, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_LookupRids r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.num_rids = num_rids;
		r.in.rids = rids;
		
		status = dcerpc_samr_LookupRids(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: names [out] argument is not a pointer */
		*names = *r.out.names;
		/* FIXME: types [out] argument is not a pointer */
		*types = *r.out.types;
		return r.out.result;
	}
	
	/* samr_OpenGroup */
	NTSTATUS OpenGroup(struct policy_handle *domain_handle, uint32_t access_mask, uint32_t rid, struct policy_handle *group_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_OpenGroup r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.access_mask = access_mask;
		r.in.rid = rid;
		
		status = dcerpc_samr_OpenGroup(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*group_handle = *r.out.group_handle;
		return r.out.result;
	}
	
	/* samr_QueryGroupInfo */
	NTSTATUS QueryGroupInfo(struct policy_handle *group_handle, enum samr_GroupInfoEnum level, union samr_GroupInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryGroupInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryGroupInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_SetGroupInfo */
	NTSTATUS SetGroupInfo(struct policy_handle *group_handle, enum samr_GroupInfoEnum level, union samr_GroupInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetGroupInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_SetGroupInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_AddGroupMember */
	NTSTATUS AddGroupMember(struct policy_handle *group_handle, uint32_t rid, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_AddGroupMember r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		r.in.rid = rid;
		r.in.flags = flags;
		
		status = dcerpc_samr_AddGroupMember(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_DeleteDomainGroup */
	NTSTATUS DeleteDomainGroup(struct policy_handle *group_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_DeleteDomainGroup r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		
		status = dcerpc_samr_DeleteDomainGroup(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*group_handle = *r.out.group_handle;
		return r.out.result;
	}
	
	/* samr_DeleteGroupMember */
	NTSTATUS DeleteGroupMember(struct policy_handle *group_handle, uint32_t rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_DeleteGroupMember r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		r.in.rid = rid;
		
		status = dcerpc_samr_DeleteGroupMember(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_QueryGroupMember */
	NTSTATUS QueryGroupMember(struct policy_handle *group_handle, struct samr_RidTypeArray *rids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryGroupMember r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		
		status = dcerpc_samr_QueryGroupMember(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*rids = *r.out.rids;
		return r.out.result;
	}
	
	/* samr_SetMemberAttributesOfGroup */
	NTSTATUS SetMemberAttributesOfGroup(struct policy_handle *group_handle, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetMemberAttributesOfGroup r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.group_handle = group_handle;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_samr_SetMemberAttributesOfGroup(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_OpenAlias */
	NTSTATUS OpenAlias(struct policy_handle *domain_handle, uint32_t access_mask, uint32_t rid, struct policy_handle *alias_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_OpenAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.access_mask = access_mask;
		r.in.rid = rid;
		
		status = dcerpc_samr_OpenAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*alias_handle = *r.out.alias_handle;
		return r.out.result;
	}
	
	/* samr_QueryAliasInfo */
	NTSTATUS QueryAliasInfo(struct policy_handle *alias_handle, enum samr_AliasInfoEnum level, union samr_AliasInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryAliasInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryAliasInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_SetAliasInfo */
	NTSTATUS SetAliasInfo(struct policy_handle *alias_handle, enum samr_AliasInfoEnum level, union samr_AliasInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetAliasInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_SetAliasInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_DeleteDomAlias */
	NTSTATUS DeleteDomAlias(struct policy_handle *alias_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_DeleteDomAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		
		status = dcerpc_samr_DeleteDomAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*alias_handle = *r.out.alias_handle;
		return r.out.result;
	}
	
	/* samr_AddAliasMember */
	NTSTATUS AddAliasMember(struct policy_handle *alias_handle, struct dom_sid2 *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_AddAliasMember r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.sid = sid;
		
		status = dcerpc_samr_AddAliasMember(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_DeleteAliasMember */
	NTSTATUS DeleteAliasMember(struct policy_handle *alias_handle, struct dom_sid2 *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_DeleteAliasMember r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.sid = sid;
		
		status = dcerpc_samr_DeleteAliasMember(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_GetMembersInAlias */
	NTSTATUS GetMembersInAlias(struct policy_handle *alias_handle, struct lsa_SidArray *sids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetMembersInAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		
		status = dcerpc_samr_GetMembersInAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sids = *r.out.sids;
		return r.out.result;
	}
	
	/* samr_OpenUser */
	NTSTATUS OpenUser(struct policy_handle *domain_handle, uint32_t access_mask, uint32_t rid, struct policy_handle *user_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_OpenUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.access_mask = access_mask;
		r.in.rid = rid;
		
		status = dcerpc_samr_OpenUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*user_handle = *r.out.user_handle;
		return r.out.result;
	}
	
	/* samr_DeleteUser */
	NTSTATUS DeleteUser(struct policy_handle *user_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_DeleteUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		
		status = dcerpc_samr_DeleteUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*user_handle = *r.out.user_handle;
		return r.out.result;
	}
	
	/* samr_QueryUserInfo */
	NTSTATUS QueryUserInfo(struct policy_handle *user_handle, uint16_t level, union samr_UserInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryUserInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryUserInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_SetUserInfo */
	NTSTATUS SetUserInfo(struct policy_handle *user_handle, uint16_t level, union samr_UserInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetUserInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_SetUserInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_ChangePasswordUser */
	NTSTATUS ChangePasswordUser(struct policy_handle *user_handle, uint8_t lm_present, struct samr_Password *old_lm_crypted, struct samr_Password *new_lm_crypted, uint8_t nt_present, struct samr_Password *old_nt_crypted, struct samr_Password *new_nt_crypted, uint8_t cross1_present, struct samr_Password *nt_cross, uint8_t cross2_present, struct samr_Password *lm_cross, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_ChangePasswordUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		r.in.lm_present = lm_present;
		r.in.old_lm_crypted = old_lm_crypted;
		r.in.new_lm_crypted = new_lm_crypted;
		r.in.nt_present = nt_present;
		r.in.old_nt_crypted = old_nt_crypted;
		r.in.new_nt_crypted = new_nt_crypted;
		r.in.cross1_present = cross1_present;
		r.in.nt_cross = nt_cross;
		r.in.cross2_present = cross2_present;
		r.in.lm_cross = lm_cross;
		
		status = dcerpc_samr_ChangePasswordUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_GetGroupsForUser */
	NTSTATUS GetGroupsForUser(struct policy_handle *user_handle, struct samr_RidWithAttributeArray *rids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetGroupsForUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		
		status = dcerpc_samr_GetGroupsForUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*rids = *r.out.rids;
		return r.out.result;
	}
	
	/* samr_QueryDisplayInfo */
	NTSTATUS QueryDisplayInfo(struct policy_handle *domain_handle, uint16_t level, uint32_t start_idx, uint32_t max_entries, uint32_t buf_size, uint32_t total_size, uint32_t returned_size, union samr_DispInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryDisplayInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.start_idx = start_idx;
		r.in.max_entries = max_entries;
		r.in.buf_size = buf_size;
		
		status = dcerpc_samr_QueryDisplayInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: total_size [out] argument is not a pointer */
		*total_size = *r.out.total_size;
		/* FIXME: returned_size [out] argument is not a pointer */
		*returned_size = *r.out.returned_size;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_GetDisplayEnumerationIndex */
	NTSTATUS GetDisplayEnumerationIndex(struct policy_handle *domain_handle, uint16_t level, struct lsa_String name, uint32_t idx, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetDisplayEnumerationIndex r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.name = name;
		
		status = dcerpc_samr_GetDisplayEnumerationIndex(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: idx [out] argument is not a pointer */
		*idx = *r.out.idx;
		return r.out.result;
	}
	
	/* samr_TestPrivateFunctionsDomain */
	NTSTATUS TestPrivateFunctionsDomain(struct policy_handle *domain_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_TestPrivateFunctionsDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		
		status = dcerpc_samr_TestPrivateFunctionsDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_TestPrivateFunctionsUser */
	NTSTATUS TestPrivateFunctionsUser(struct policy_handle *user_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_TestPrivateFunctionsUser r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		
		status = dcerpc_samr_TestPrivateFunctionsUser(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_GetUserPwInfo */
	NTSTATUS GetUserPwInfo(struct policy_handle *user_handle, struct samr_PwInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetUserPwInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		
		status = dcerpc_samr_GetUserPwInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_RemoveMemberFromForeignDomain */
	NTSTATUS RemoveMemberFromForeignDomain(struct policy_handle *domain_handle, struct dom_sid2 *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_RemoveMemberFromForeignDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.sid = sid;
		
		status = dcerpc_samr_RemoveMemberFromForeignDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_QueryDomainInfo2 */
	NTSTATUS QueryDomainInfo2(struct policy_handle *domain_handle, uint16_t level, union samr_DomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryDomainInfo2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryDomainInfo2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_QueryUserInfo2 */
	NTSTATUS QueryUserInfo2(struct policy_handle *user_handle, uint16_t level, union samr_UserInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryUserInfo2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		r.in.level = level;
		
		status = dcerpc_samr_QueryUserInfo2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_QueryDisplayInfo2 */
	NTSTATUS QueryDisplayInfo2(struct policy_handle *domain_handle, uint16_t level, uint32_t start_idx, uint32_t max_entries, uint32_t buf_size, uint32_t total_size, uint32_t returned_size, union samr_DispInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryDisplayInfo2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.start_idx = start_idx;
		r.in.max_entries = max_entries;
		r.in.buf_size = buf_size;
		
		status = dcerpc_samr_QueryDisplayInfo2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: total_size [out] argument is not a pointer */
		*total_size = *r.out.total_size;
		/* FIXME: returned_size [out] argument is not a pointer */
		*returned_size = *r.out.returned_size;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_GetDisplayEnumerationIndex2 */
	NTSTATUS GetDisplayEnumerationIndex2(struct policy_handle *domain_handle, uint16_t level, struct lsa_String name, uint32_t idx, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetDisplayEnumerationIndex2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.name = name;
		
		status = dcerpc_samr_GetDisplayEnumerationIndex2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: idx [out] argument is not a pointer */
		*idx = *r.out.idx;
		return r.out.result;
	}
	
	/* samr_CreateUser2 */
	NTSTATUS CreateUser2(struct policy_handle *domain_handle, struct lsa_String *account_name, uint32_t acct_flags, uint32_t access_mask, struct policy_handle *user_handle, uint32_t *access_granted, uint32_t *rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_CreateUser2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.account_name = account_name;
		r.in.acct_flags = acct_flags;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_CreateUser2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*user_handle = *r.out.user_handle;
		*access_granted = *r.out.access_granted;
		*rid = *r.out.rid;
		return r.out.result;
	}
	
	/* samr_QueryDisplayInfo3 */
	NTSTATUS QueryDisplayInfo3(struct policy_handle *domain_handle, uint16_t level, uint32_t start_idx, uint32_t max_entries, uint32_t buf_size, uint32_t total_size, uint32_t returned_size, union samr_DispInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_QueryDisplayInfo3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.level = level;
		r.in.start_idx = start_idx;
		r.in.max_entries = max_entries;
		r.in.buf_size = buf_size;
		
		status = dcerpc_samr_QueryDisplayInfo3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: total_size [out] argument is not a pointer */
		*total_size = *r.out.total_size;
		/* FIXME: returned_size [out] argument is not a pointer */
		*returned_size = *r.out.returned_size;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_AddMultipleMembersToAlias */
	NTSTATUS AddMultipleMembersToAlias(struct policy_handle *alias_handle, struct lsa_SidArray *sids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_AddMultipleMembersToAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.sids = sids;
		
		status = dcerpc_samr_AddMultipleMembersToAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_RemoveMultipleMembersFromAlias */
	NTSTATUS RemoveMultipleMembersFromAlias(struct policy_handle *alias_handle, struct lsa_SidArray *sids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_RemoveMultipleMembersFromAlias r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.alias_handle = alias_handle;
		r.in.sids = sids;
		
		status = dcerpc_samr_RemoveMultipleMembersFromAlias(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_OemChangePasswordUser2 */
	NTSTATUS OemChangePasswordUser2(struct lsa_AsciiString *server, struct lsa_AsciiString *account, struct samr_CryptPassword *password, struct samr_Password *hash, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_OemChangePasswordUser2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.account = account;
		r.in.password = password;
		r.in.hash = hash;
		
		status = dcerpc_samr_OemChangePasswordUser2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_ChangePasswordUser2 */
	NTSTATUS ChangePasswordUser2(struct lsa_String *server, struct lsa_String *account, struct samr_CryptPassword *nt_password, struct samr_Password *nt_verifier, uint8_t lm_change, struct samr_CryptPassword *lm_password, struct samr_Password *lm_verifier, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_ChangePasswordUser2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.account = account;
		r.in.nt_password = nt_password;
		r.in.nt_verifier = nt_verifier;
		r.in.lm_change = lm_change;
		r.in.lm_password = lm_password;
		r.in.lm_verifier = lm_verifier;
		
		status = dcerpc_samr_ChangePasswordUser2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_GetDomPwInfo */
	NTSTATUS GetDomPwInfo(struct lsa_String *domain_name, struct samr_PwInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetDomPwInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_name = domain_name;
		
		status = dcerpc_samr_GetDomPwInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* samr_Connect2 */
	NTSTATUS Connect2(const char *system_name, uint32_t access_mask, struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Connect2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_Connect2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*connect_handle = *r.out.connect_handle;
		return r.out.result;
	}
	
	/* samr_SetUserInfo2 */
	NTSTATUS SetUserInfo2(struct policy_handle *user_handle, uint16_t level, union samr_UserInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetUserInfo2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.user_handle = user_handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_SetUserInfo2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_SetBootKeyInformation */
	NTSTATUS SetBootKeyInformation(struct policy_handle *connect_handle, uint32_t unknown1, uint32_t unknown2, uint32_t unknown3, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetBootKeyInformation r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.connect_handle = connect_handle;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		r.in.unknown3 = unknown3;
		
		status = dcerpc_samr_SetBootKeyInformation(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_GetBootKeyInformation */
	NTSTATUS GetBootKeyInformation(struct policy_handle *domain_handle, uint32_t unknown, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_GetBootKeyInformation r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		
		status = dcerpc_samr_GetBootKeyInformation(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: unknown [out] argument is not a pointer */
		*unknown = *r.out.unknown;
		return r.out.result;
	}
	
	/* samr_Connect3 */
	NTSTATUS Connect3(const char *system_name, uint32_t unknown, uint32_t access_mask, struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Connect3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.unknown = unknown;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_Connect3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*connect_handle = *r.out.connect_handle;
		return r.out.result;
	}
	
	/* samr_Connect4 */
	NTSTATUS Connect4(const char *system_name, uint32_t unknown, uint32_t access_mask, struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Connect4 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.unknown = unknown;
		r.in.access_mask = access_mask;
		
		status = dcerpc_samr_Connect4(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*connect_handle = *r.out.connect_handle;
		return r.out.result;
	}
	
	/* samr_ChangePasswordUser3 */
	NTSTATUS ChangePasswordUser3(struct lsa_String *server, struct lsa_String *account, struct samr_CryptPassword *nt_password, struct samr_Password *nt_verifier, uint8_t lm_change, struct samr_CryptPassword *lm_password, struct samr_Password *lm_verifier, struct samr_CryptPassword *password3, struct samr_DomInfo1 *dominfo, struct samr_ChangeReject *reject, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_ChangePasswordUser3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.account = account;
		r.in.nt_password = nt_password;
		r.in.nt_verifier = nt_verifier;
		r.in.lm_change = lm_change;
		r.in.lm_password = lm_password;
		r.in.lm_verifier = lm_verifier;
		r.in.password3 = password3;
		
		status = dcerpc_samr_ChangePasswordUser3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*dominfo = *r.out.dominfo;
		*reject = *r.out.reject;
		return r.out.result;
	}
	
	/* samr_Connect5 */
	NTSTATUS Connect5(const char *system_name, uint32_t access_mask, uint32_t level, union samr_ConnectInfo *info, struct policy_handle *connect_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_Connect5 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_samr_Connect5(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: level [out] argument is not a pointer */
		*level = *r.out.level;
		*info = *r.out.info;
		*connect_handle = *r.out.connect_handle;
		return r.out.result;
	}
	
	/* samr_RidToSid */
	NTSTATUS RidToSid(struct policy_handle *domain_handle, uint32_t rid, struct dom_sid2 *sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_RidToSid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.domain_handle = domain_handle;
		r.in.rid = rid;
		
		status = dcerpc_samr_RidToSid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sid = *r.out.sid;
		return r.out.result;
	}
	
	/* samr_SetDsrmPassword */
	NTSTATUS SetDsrmPassword(struct lsa_String *name, uint32_t unknown, struct samr_Password *hash, TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_SetDsrmPassword r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.name = name;
		r.in.unknown = unknown;
		r.in.hash = hash;
		
		status = dcerpc_samr_SetDsrmPassword(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* samr_ValidatePassword */
	NTSTATUS ValidatePassword(TALLOC_CTX *mem_ctx = NULL)
	{
		struct samr_ValidatePassword r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_samr_ValidatePassword(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* samr_AcctFlags */
/* samr_SamEntry */
/* samr_SamArray */
/* samr_Role */
/* samr_PasswordProperties */
/* samr_DomInfo1 */
/* samr_DomInfo2 */
/* samr_DomInfo3 */
/* samr_DomInfo4 */
/* samr_DomInfo5 */
/* samr_DomInfo6 */
/* samr_DomInfo7 */
/* samr_DomInfo8 */
/* samr_DomInfo9 */
/* samr_DomInfo11 */
/* samr_DomInfo12 */
/* samr_DomInfo13 */
/* samr_DomainInfo */
/* samr_Ids */
/* samr_GroupAttrs */
/* samr_GroupInfoAll */
/* samr_GroupInfoAttributes */
/* samr_GroupInfoDescription */
/* samr_GroupInfoEnum */
/* samr_GroupInfo */
/* samr_RidTypeArray */
/* samr_AliasInfoAll */
/* samr_AliasInfoEnum */
/* samr_AliasInfo */
/* samr_UserInfo1 */
/* samr_UserInfo2 */
/* samr_LogonHours */
/* samr_UserInfo3 */
/* samr_UserInfo4 */
/* samr_UserInfo5 */
/* samr_UserInfo6 */
/* samr_UserInfo7 */
/* samr_UserInfo8 */
/* samr_UserInfo9 */
/* samr_UserInfo10 */
/* samr_UserInfo11 */
/* samr_UserInfo12 */
/* samr_UserInfo13 */
/* samr_UserInfo14 */
/* samr_UserInfo16 */
/* samr_UserInfo17 */
/* samr_UserInfo20 */
/* samr_FieldsPresent */
/* samr_UserInfo21 */
/* samr_CryptPassword */
/* samr_UserInfo23 */
/* samr_UserInfo24 */
/* samr_CryptPasswordEx */
/* samr_UserInfo25 */
/* samr_UserInfo26 */
/* samr_UserInfo */
/* samr_Password */
/* samr_RidWithAttribute */
/* samr_RidWithAttributeArray */
/* samr_DispEntryGeneral */
/* samr_DispInfoGeneral */
/* samr_DispEntryFull */
/* samr_DispInfoFull */
/* samr_DispEntryFullGroup */
/* samr_DispInfoFullGroups */
/* samr_DispEntryAscii */
/* samr_DispInfoAscii */
/* samr_DispInfo */
/* samr_PwInfo */
/* samr_ChangeReject */
/* samr_ConnectInfo1 */
/* samr_ConnectInfo */

