
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_xattr.h"
#include "librpc/gen_ndr/ndr_xattr_ejs.h"


static NTSTATUS ejs_push_xattr_DosInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "attrib", &r->attrib));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ea_size", &r->ea_size));
	NDR_CHECK(ejs_push_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "create_time", &r->create_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "change_time", &r->change_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_xattr_DosInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attrib", &r->attrib));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ea_size", &r->ea_size));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "create_time", &r->create_time));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "change_time", &r->change_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_xattr_DosInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "attrib", &r->attrib));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ea_size", &r->ea_size));
	NDR_CHECK(ejs_push_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "create_time", &r->create_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "change_time", &r->change_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "write_time", &r->write_time));
	NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_xattr_DosInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attrib", &r->attrib));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ea_size", &r->ea_size));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "create_time", &r->create_time));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "change_time", &r->change_time));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "write_time", &r->write_time));
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_xattr_DosInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union xattr_DosInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_xattr_DosInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_xattr_DosInfo2(ejs, v, "info2", &r->info2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_xattr_DosInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union xattr_DosInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_xattr_DosInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_xattr_DosInfo2(ejs, v, "info2", &r->info2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_xattr_DosAttrib(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosAttrib *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "version", &r->version));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_xattr_DosInfo(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_xattr_DosAttrib(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosAttrib *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "version", &r->version));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_xattr_DosInfo(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_xattr_EA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_EA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "value", &r->value));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_xattr_EA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_EA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "value", &r->value));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_xattr_DosEAs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosEAs *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "num_eas", &r->num_eas));
	if (NULL == r->eas) {
		NDR_CHECK(ejs_push_null(ejs, v, "eas"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_eas;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "eas", i);
				NDR_CHECK(ejs_push_xattr_EA(ejs, v, id, &r->eas[i]));
			}
			ejs_push_uint32(ejs, v, "eas" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_xattr_DosEAs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosEAs *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "num_eas", &r->num_eas));
	if (ejs_pull_null(ejs, v, "eas")) {
		r->eas = NULL;
	} else {
		EJS_ALLOC(ejs, r->eas);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->eas, r->num_eas);
			for (i=0;i<r->num_eas;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "eas", i);
				NDR_CHECK(ejs_pull_xattr_EA(ejs, v, id, &r->eas[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "eas" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_xattr_DosStream(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosStream *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_xattr_DosStream(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosStream *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "alloc_size", &r->alloc_size));
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_xattr_DosStreams(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_DosStreams *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_streams", &r->num_streams));
	if (NULL == r->streams) {
		NDR_CHECK(ejs_push_null(ejs, v, "streams"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_streams;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "streams", i);
				NDR_CHECK(ejs_push_xattr_DosStream(ejs, v, id, &r->streams[i]));
			}
			ejs_push_uint32(ejs, v, "streams" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_xattr_DosStreams(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_DosStreams *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_streams", &r->num_streams));
	if (ejs_pull_null(ejs, v, "streams")) {
		r->streams = NULL;
	} else {
		EJS_ALLOC(ejs, r->streams);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->streams, r->num_streams);
			for (i=0;i<r->num_streams;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "streams", i);
				NDR_CHECK(ejs_pull_xattr_DosStream(ejs, v, id, &r->streams[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "streams" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_xattr_NTACL_Info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union xattr_NTACL_Info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->sd) {
				NDR_CHECK(ejs_push_null(ejs, v, "sd"));
			} else {
				NDR_CHECK(ejs_push_security_descriptor(ejs, v, "sd", r->sd));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_xattr_NTACL_Info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union xattr_NTACL_Info *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "sd")) {
				r->sd = NULL;
			} else {
				EJS_ALLOC(ejs, r->sd);
				NDR_CHECK(ejs_pull_security_descriptor(ejs, v, "sd", r->sd));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_xattr_NTACL(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct xattr_NTACL *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "version", &r->version));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_xattr_NTACL_Info(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_xattr_NTACL(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct xattr_NTACL *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "version", &r->version));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_xattr_NTACL_Info(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static int ejs_xattr_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "xattr", argc, argv);
	mprSetVar(obj, "XATTR_ATTRIB_FLAG_STICKY_WRITE_TIME", mprCreateNumberVar(0x1));
	mprSetVar(obj, "XATTR_STREAM_FLAG_INTERNAL", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "XATTR_NTACL_NAME", mprString("security.NTACL"));
	mprSetVar(obj, "XATTR_DOSEAS_NAME", mprString("user.DosEAs"));
	mprSetVar(obj, "XATTR_MAX_STREAM_SIZE", mprCreateNumberVar(0x4000));
	mprSetVar(obj, "XATTR_DOSSTREAM_PREFIX", mprString("user.DosStream."));
	mprSetVar(obj, "XATTR_DOSSTREAMS_NAME", mprString("user.DosStreams"));
	mprSetVar(obj, "XATTR_DOSATTRIB_ESTIMATED_SIZE", mprCreateNumberVar(64));
	mprSetVar(obj, "XATTR_DOSATTRIB_NAME", mprString("user.DosAttrib"));
	return ejs_rpc_init(obj, "xattr");
}

NTSTATUS ejs_init_xattr(void)
{
	ejsDefineCFunction(-1, "xattr_init", ejs_xattr_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
