
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_winreg.h"
#include "librpc/gen_ndr/ndr_winreg_ejs.h"


static NTSTATUS ejs_pull_winreg_AccessMask(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_winreg_Type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum winreg_Type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_winreg_Type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum winreg_Type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_KeySecurityData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct KeySecurityData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->data, r->len);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "len", &r->len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_KeySecurityData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct KeySecurityData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->size);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->len);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_winreg_SecBuf(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct winreg_SecBuf *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_pull_KeySecurityData(ejs, v, "sd", &r->sd));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "inherit", &r->inherit));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_winreg_CreateAction(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum winreg_CreateAction *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_winreg_CreateAction(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum winreg_CreateAction *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_winreg_StringBuf(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct winreg_StringBuf *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_winreg_StringBuf(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct winreg_StringBuf *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "size", &r->size));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_QueryMultipleValue(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct QueryMultipleValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_winreg_String(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_push_winreg_Type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "offset", &r->offset));
	NDR_CHECK(ejs_push_uint32(ejs, v, "length", &r->length));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_QueryMultipleValue(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct QueryMultipleValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_winreg_String(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_pull_winreg_Type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offset", &r->offset));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_winreg_OpenHKCR(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKCR *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKCR(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKCR *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKCR(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKCR, (ejs_pull_function_t)ejs_pull_winreg_OpenHKCR, (ejs_push_function_t)ejs_push_winreg_OpenHKCR);
}


static NTSTATUS ejs_pull_winreg_OpenHKCU(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKCU *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKCU(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKCU *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKCU(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKCU, (ejs_pull_function_t)ejs_pull_winreg_OpenHKCU, (ejs_push_function_t)ejs_push_winreg_OpenHKCU);
}


static NTSTATUS ejs_pull_winreg_OpenHKLM(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKLM *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKLM(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKLM *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKLM(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKLM, (ejs_pull_function_t)ejs_pull_winreg_OpenHKLM, (ejs_push_function_t)ejs_push_winreg_OpenHKLM);
}


static NTSTATUS ejs_pull_winreg_OpenHKPD(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKPD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKPD(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKPD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKPD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKPD, (ejs_pull_function_t)ejs_pull_winreg_OpenHKPD, (ejs_push_function_t)ejs_push_winreg_OpenHKPD);
}


static NTSTATUS ejs_pull_winreg_OpenHKU(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKU *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKU(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKU *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKU(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKU, (ejs_pull_function_t)ejs_pull_winreg_OpenHKU, (ejs_push_function_t)ejs_push_winreg_OpenHKU);
}


static NTSTATUS ejs_pull_winreg_CloseKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_CloseKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_CloseKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_CloseKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_CloseKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_CLOSEKEY, (ejs_pull_function_t)ejs_pull_winreg_CloseKey, (ejs_push_function_t)ejs_push_winreg_CloseKey);
}


static NTSTATUS ejs_pull_winreg_CreateKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_CreateKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "keyclass", &r->in.keyclass));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "options", &r->in.options));
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	if (ejs_pull_null(ejs, v, "secdesc")) {
		r->in.secdesc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.secdesc);
		NDR_CHECK(ejs_pull_winreg_SecBuf(ejs, v, "secdesc", r->in.secdesc));
	}
	if (ejs_pull_null(ejs, v, "action_taken")) {
		r->in.action_taken = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.action_taken);
		NDR_CHECK(ejs_pull_winreg_CreateAction(ejs, v, "action_taken", r->in.action_taken));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_CreateKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_CreateKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.new_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "new_handle", r->out.new_handle));
	}
	if (NULL == r->out.action_taken) {
		NDR_CHECK(ejs_push_null(ejs, v, "action_taken"));
	} else {
		NDR_CHECK(ejs_push_winreg_CreateAction(ejs, v, "action_taken", r->out.action_taken));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_CreateKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_CREATEKEY, (ejs_pull_function_t)ejs_pull_winreg_CreateKey, (ejs_push_function_t)ejs_push_winreg_CreateKey);
}


static NTSTATUS ejs_pull_winreg_DeleteKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_DeleteKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "key", &r->in.key));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_DeleteKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_DeleteKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_DeleteKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_DELETEKEY, (ejs_pull_function_t)ejs_pull_winreg_DeleteKey, (ejs_push_function_t)ejs_push_winreg_DeleteKey);
}


static NTSTATUS ejs_pull_winreg_DeleteValue(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_DeleteValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "value", &r->in.value));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_DeleteValue(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_DeleteValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_DeleteValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_DELETEVALUE, (ejs_pull_function_t)ejs_pull_winreg_DeleteValue, (ejs_push_function_t)ejs_push_winreg_DeleteValue);
}


static NTSTATUS ejs_pull_winreg_EnumKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_EnumKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enum_index", &r->in.enum_index));
	if (ejs_pull_null(ejs, v, "name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_winreg_StringBuf(ejs, v, "name", r->in.name));
	}
	if (ejs_pull_null(ejs, v, "keyclass")) {
		r->in.keyclass = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.keyclass);
		NDR_CHECK(ejs_pull_winreg_StringBuf(ejs, v, "keyclass", r->in.keyclass));
	}
	if (ejs_pull_null(ejs, v, "last_changed_time")) {
		r->in.last_changed_time = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.last_changed_time);
		NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_changed_time", r->in.last_changed_time));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_EnumKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_EnumKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.name) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_winreg_StringBuf(ejs, v, "name", r->out.name));
	}
	if (NULL == r->out.keyclass) {
		NDR_CHECK(ejs_push_null(ejs, v, "keyclass"));
	} else {
		NDR_CHECK(ejs_push_winreg_StringBuf(ejs, v, "keyclass", r->out.keyclass));
	}
	if (NULL == r->out.last_changed_time) {
		NDR_CHECK(ejs_push_null(ejs, v, "last_changed_time"));
	} else {
		NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_changed_time", r->out.last_changed_time));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_EnumKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_ENUMKEY, (ejs_pull_function_t)ejs_pull_winreg_EnumKey, (ejs_push_function_t)ejs_push_winreg_EnumKey);
}


static NTSTATUS ejs_pull_winreg_EnumValue(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_EnumValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enum_index", &r->in.enum_index));
	if (ejs_pull_null(ejs, v, "name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_winreg_StringBuf(ejs, v, "name", r->in.name));
	}
	if (ejs_pull_null(ejs, v, "type")) {
		r->in.type = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.type);
		NDR_CHECK(ejs_pull_winreg_Type(ejs, v, "type", r->in.type));
	}
	if (ejs_pull_null(ejs, v, "size")) {
		r->in.size = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.size);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "size", r->in.size));
	}
	if (ejs_pull_null(ejs, v, "length")) {
		r->in.length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "length", r->in.length));
	}
	if (ejs_pull_null(ejs, v, "value")) {
		r->in.value = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.value);
		if (r->in.size == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		EJS_ALLOC_N(ejs, r->in.value, *r->in.size);
		if (r->in.length == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_pull_array_uint8(ejs, v, "value", r->in.value, *r->in.length);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_EnumValue(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_EnumValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.name) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_winreg_StringBuf(ejs, v, "name", r->out.name));
	}
	if (NULL == r->out.type) {
		NDR_CHECK(ejs_push_null(ejs, v, "type"));
	} else {
		NDR_CHECK(ejs_push_winreg_Type(ejs, v, "type", r->out.type));
	}
	if (NULL == r->out.value) {
		NDR_CHECK(ejs_push_null(ejs, v, "value"));
	} else {
		if (r->out.length == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_push_array_uint8(ejs, v, "value", r->out.value, *r->out.length);
	}
	if (NULL == r->out.size) {
		NDR_CHECK(ejs_push_null(ejs, v, "size"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "size", r->out.size));
	}
	if (NULL == r->out.length) {
		NDR_CHECK(ejs_push_null(ejs, v, "length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "length", r->out.length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_EnumValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_ENUMVALUE, (ejs_pull_function_t)ejs_pull_winreg_EnumValue, (ejs_push_function_t)ejs_push_winreg_EnumValue);
}


static NTSTATUS ejs_pull_winreg_FlushKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_FlushKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_FlushKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_FlushKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_FlushKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_FLUSHKEY, (ejs_pull_function_t)ejs_pull_winreg_FlushKey, (ejs_push_function_t)ejs_push_winreg_FlushKey);
}


static NTSTATUS ejs_pull_winreg_GetKeySecurity(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_GetKeySecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "sec_info", &r->in.sec_info));
	if (ejs_pull_null(ejs, v, "sd")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sd);
		NDR_CHECK(ejs_pull_KeySecurityData(ejs, v, "sd", r->in.sd));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_GetKeySecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_GetKeySecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sd) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_KeySecurityData(ejs, v, "sd", r->out.sd));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_GetKeySecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_GETKEYSECURITY, (ejs_pull_function_t)ejs_pull_winreg_GetKeySecurity, (ejs_push_function_t)ejs_push_winreg_GetKeySecurity);
}


static NTSTATUS ejs_pull_winreg_LoadKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_LoadKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "keyname")) {
		r->in.keyname = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.keyname);
		NDR_CHECK(ejs_pull_winreg_String(ejs, v, "keyname", r->in.keyname));
	}
	if (ejs_pull_null(ejs, v, "filename")) {
		r->in.filename = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.filename);
		NDR_CHECK(ejs_pull_winreg_String(ejs, v, "filename", r->in.filename));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_LoadKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_LoadKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_LoadKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_LOADKEY, (ejs_pull_function_t)ejs_pull_winreg_LoadKey, (ejs_push_function_t)ejs_push_winreg_LoadKey);
}


static NTSTATUS ejs_pull_winreg_NotifyChangeKeyValue(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_NotifyChangeKeyValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "watch_subtree", &r->in.watch_subtree));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "notify_filter", &r->in.notify_filter));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "string1", &r->in.string1));
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "string2", &r->in.string2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_NotifyChangeKeyValue(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_NotifyChangeKeyValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_NotifyChangeKeyValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_NOTIFYCHANGEKEYVALUE, (ejs_pull_function_t)ejs_pull_winreg_NotifyChangeKeyValue, (ejs_push_function_t)ejs_push_winreg_NotifyChangeKeyValue);
}


static NTSTATUS ejs_pull_winreg_OpenKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "parent_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.parent_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "parent_handle", r->in.parent_handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "keyname", &r->in.keyname));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENKEY, (ejs_pull_function_t)ejs_pull_winreg_OpenKey, (ejs_push_function_t)ejs_push_winreg_OpenKey);
}


static NTSTATUS ejs_pull_winreg_QueryInfoKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_QueryInfoKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "class_in", &r->in.class_in));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_QueryInfoKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_QueryInfoKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.class_out) {
		NDR_CHECK(ejs_push_null(ejs, v, "class_out"));
	} else {
		NDR_CHECK(ejs_push_winreg_String(ejs, v, "class_out", r->out.class_out));
	}
	if (NULL == r->out.num_subkeys) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_subkeys", r->out.num_subkeys));
	}
	if (NULL == r->out.max_subkeylen) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "max_subkeylen", r->out.max_subkeylen));
	}
	if (NULL == r->out.max_subkeysize) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "max_subkeysize", r->out.max_subkeysize));
	}
	if (NULL == r->out.num_values) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_values", r->out.num_values));
	}
	if (NULL == r->out.max_valnamelen) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "max_valnamelen", r->out.max_valnamelen));
	}
	if (NULL == r->out.max_valbufsize) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "max_valbufsize", r->out.max_valbufsize));
	}
	if (NULL == r->out.secdescsize) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "secdescsize", r->out.secdescsize));
	}
	if (NULL == r->out.last_changed_time) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_changed_time", r->out.last_changed_time));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_QueryInfoKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_QUERYINFOKEY, (ejs_pull_function_t)ejs_pull_winreg_QueryInfoKey, (ejs_push_function_t)ejs_push_winreg_QueryInfoKey);
}


static NTSTATUS ejs_pull_winreg_QueryValue(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_QueryValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "value_name", &r->in.value_name));
	if (ejs_pull_null(ejs, v, "type")) {
		r->in.type = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.type);
		NDR_CHECK(ejs_pull_winreg_Type(ejs, v, "type", r->in.type));
	}
	if (ejs_pull_null(ejs, v, "size")) {
		r->in.size = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.size);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "size", r->in.size));
	}
	if (ejs_pull_null(ejs, v, "length")) {
		r->in.length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "length", r->in.length));
	}
	if (ejs_pull_null(ejs, v, "data")) {
		r->in.data = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.data);
		if (r->in.size == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		EJS_ALLOC_N(ejs, r->in.data, *r->in.size);
		if (r->in.length == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_pull_array_uint8(ejs, v, "data", r->in.data, *r->in.length);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_QueryValue(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_QueryValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.type) {
		NDR_CHECK(ejs_push_null(ejs, v, "type"));
	} else {
		NDR_CHECK(ejs_push_winreg_Type(ejs, v, "type", r->out.type));
	}
	if (NULL == r->out.data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		if (r->out.length == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_push_array_uint8(ejs, v, "data", r->out.data, *r->out.length);
	}
	if (NULL == r->out.size) {
		NDR_CHECK(ejs_push_null(ejs, v, "size"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "size", r->out.size));
	}
	if (NULL == r->out.length) {
		NDR_CHECK(ejs_push_null(ejs, v, "length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "length", r->out.length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_QueryValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_QUERYVALUE, (ejs_pull_function_t)ejs_pull_winreg_QueryValue, (ejs_push_function_t)ejs_push_winreg_QueryValue);
}


static NTSTATUS ejs_pull_winreg_ReplaceKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_ReplaceKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_ReplaceKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_ReplaceKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_ReplaceKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_REPLACEKEY, (ejs_pull_function_t)ejs_pull_winreg_ReplaceKey, (ejs_push_function_t)ejs_push_winreg_ReplaceKey);
}


static NTSTATUS ejs_pull_winreg_RestoreKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_RestoreKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_RestoreKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_RestoreKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_RestoreKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_RESTOREKEY, (ejs_pull_function_t)ejs_pull_winreg_RestoreKey, (ejs_push_function_t)ejs_push_winreg_RestoreKey);
}


static NTSTATUS ejs_pull_winreg_SaveKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_SaveKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_SaveKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_SaveKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_SaveKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_SAVEKEY, (ejs_pull_function_t)ejs_pull_winreg_SaveKey, (ejs_push_function_t)ejs_push_winreg_SaveKey);
}


static NTSTATUS ejs_pull_winreg_SetKeySecurity(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_SetKeySecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	if (ejs_pull_null(ejs, v, "sd")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sd);
		NDR_CHECK(ejs_pull_KeySecurityData(ejs, v, "sd", r->in.sd));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_SetKeySecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_SetKeySecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sd) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_KeySecurityData(ejs, v, "sd", r->out.sd));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_SetKeySecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_SETKEYSECURITY, (ejs_pull_function_t)ejs_pull_winreg_SetKeySecurity, (ejs_push_function_t)ejs_push_winreg_SetKeySecurity);
}


static NTSTATUS ejs_pull_winreg_SetValue(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_SetValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_winreg_String(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_winreg_Type(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->in.size));
	if (ejs_pull_null(ejs, v, "data")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.data);
		EJS_ALLOC_N(ejs, r->in.data, r->in.size);
		ejs_pull_array_uint8(ejs, v, "data", r->in.data, r->in.size);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_SetValue(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_SetValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_SetValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_SETVALUE, (ejs_pull_function_t)ejs_pull_winreg_SetValue, (ejs_push_function_t)ejs_push_winreg_SetValue);
}


static NTSTATUS ejs_pull_winreg_UnLoadKey(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_UnLoadKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_UnLoadKey(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_UnLoadKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_UnLoadKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_UNLOADKEY, (ejs_pull_function_t)ejs_pull_winreg_UnLoadKey, (ejs_push_function_t)ejs_push_winreg_UnLoadKey);
}


static NTSTATUS ejs_pull_winreg_InitiateSystemShutdown(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_InitiateSystemShutdown *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "hostname")) {
		r->in.hostname = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.hostname);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "hostname", r->in.hostname));
	}
	if (ejs_pull_null(ejs, v, "message")) {
		r->in.message = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.message);
		NDR_CHECK(ejs_pull_initshutdown_String(ejs, v, "message", r->in.message));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->in.timeout));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "force_apps", &r->in.force_apps));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "reboot", &r->in.reboot));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_InitiateSystemShutdown(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_InitiateSystemShutdown *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_InitiateSystemShutdown(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_INITIATESYSTEMSHUTDOWN, (ejs_pull_function_t)ejs_pull_winreg_InitiateSystemShutdown, (ejs_push_function_t)ejs_push_winreg_InitiateSystemShutdown);
}


static NTSTATUS ejs_pull_winreg_AbortSystemShutdown(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_AbortSystemShutdown *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "server", r->in.server));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_AbortSystemShutdown(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_AbortSystemShutdown *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_AbortSystemShutdown(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_ABORTSYSTEMSHUTDOWN, (ejs_pull_function_t)ejs_pull_winreg_AbortSystemShutdown, (ejs_push_function_t)ejs_push_winreg_AbortSystemShutdown);
}


static NTSTATUS ejs_pull_winreg_GetVersion(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_GetVersion *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_GetVersion(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_GetVersion *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.version) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "version", r->out.version));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_GetVersion(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_GETVERSION, (ejs_pull_function_t)ejs_pull_winreg_GetVersion, (ejs_push_function_t)ejs_push_winreg_GetVersion);
}


static NTSTATUS ejs_pull_winreg_OpenHKCC(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKCC *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKCC(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKCC *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKCC(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKCC, (ejs_pull_function_t)ejs_pull_winreg_OpenHKCC, (ejs_push_function_t)ejs_push_winreg_OpenHKCC);
}


static NTSTATUS ejs_pull_winreg_OpenHKDD(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKDD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKDD(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKDD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKDD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKDD, (ejs_pull_function_t)ejs_pull_winreg_OpenHKDD, (ejs_push_function_t)ejs_push_winreg_OpenHKDD);
}


static NTSTATUS ejs_pull_winreg_QueryMultipleValues(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_QueryMultipleValues *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "key_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.key_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "key_handle", r->in.key_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_values", &r->in.num_values));
	if (ejs_pull_null(ejs, v, "buffer_size")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.buffer_size);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "buffer_size", r->in.buffer_size));
	}
	if (ejs_pull_null(ejs, v, "values")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.values);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->in.values, r->in.num_values);
			for (i=0;i<r->in.num_values;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "values", i);
				NDR_CHECK(ejs_pull_QueryMultipleValue(ejs, v, id, &r->in.values[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "values" ".length", &i);
		}
	}
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		if (r->in.buffer_size == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		EJS_ALLOC_N(ejs, r->in.buffer, *r->in.buffer_size);
		if (r->in.buffer_size == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_pull_array_uint8(ejs, v, "buffer", r->in.buffer, *r->in.buffer_size);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_QueryMultipleValues(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_QueryMultipleValues *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.values) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		{
			uint32_t i;
			for (i=0;i<r->in.num_values;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "values", i);
				NDR_CHECK(ejs_push_QueryMultipleValue(ejs, v, id, &r->out.values[i]));
			}
			ejs_push_uint32(ejs, v, "values" ".length", &i);
		}
	}
	if (NULL == r->out.buffer) {
		NDR_CHECK(ejs_push_null(ejs, v, "buffer"));
	} else {
		if (r->out.buffer_size == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		ejs_push_array_uint8(ejs, v, "buffer", r->out.buffer, *r->out.buffer_size);
	}
	if (NULL == r->out.buffer_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "buffer_size", r->out.buffer_size));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_QueryMultipleValues(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_QUERYMULTIPLEVALUES, (ejs_pull_function_t)ejs_pull_winreg_QueryMultipleValues, (ejs_push_function_t)ejs_push_winreg_QueryMultipleValues);
}


static NTSTATUS ejs_pull_winreg_InitiateSystemShutdownEx(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_InitiateSystemShutdownEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "hostname")) {
		r->in.hostname = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.hostname);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "hostname", r->in.hostname));
	}
	if (ejs_pull_null(ejs, v, "message")) {
		r->in.message = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.message);
		NDR_CHECK(ejs_pull_initshutdown_String(ejs, v, "message", r->in.message));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->in.timeout));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "force_apps", &r->in.force_apps));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "reboot", &r->in.reboot));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reason", &r->in.reason));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_InitiateSystemShutdownEx(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_InitiateSystemShutdownEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_InitiateSystemShutdownEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_INITIATESYSTEMSHUTDOWNEX, (ejs_pull_function_t)ejs_pull_winreg_InitiateSystemShutdownEx, (ejs_push_function_t)ejs_push_winreg_InitiateSystemShutdownEx);
}


static NTSTATUS ejs_pull_winreg_SaveKeyEx(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_SaveKeyEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_SaveKeyEx(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_SaveKeyEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_SaveKeyEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_SAVEKEYEX, (ejs_pull_function_t)ejs_pull_winreg_SaveKeyEx, (ejs_push_function_t)ejs_push_winreg_SaveKeyEx);
}


static NTSTATUS ejs_pull_winreg_OpenHKPT(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKPT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKPT(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKPT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKPT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKPT, (ejs_pull_function_t)ejs_pull_winreg_OpenHKPT, (ejs_push_function_t)ejs_push_winreg_OpenHKPT);
}


static NTSTATUS ejs_pull_winreg_OpenHKPN(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_OpenHKPN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_winreg_AccessMask(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_OpenHKPN(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_OpenHKPN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_OpenHKPN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_OPENHKPN, (ejs_pull_function_t)ejs_pull_winreg_OpenHKPN, (ejs_push_function_t)ejs_push_winreg_OpenHKPN);
}


static NTSTATUS ejs_pull_winreg_QueryMultipleValues2(struct ejs_rpc *ejs, struct MprVar *v, struct winreg_QueryMultipleValues2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winreg_QueryMultipleValues2(struct ejs_rpc *ejs, struct MprVar *v, const struct winreg_QueryMultipleValues2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winreg_QueryMultipleValues2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winreg, DCERPC_WINREG_QUERYMULTIPLEVALUES2, (ejs_pull_function_t)ejs_pull_winreg_QueryMultipleValues2, (ejs_push_function_t)ejs_push_winreg_QueryMultipleValues2);
}

static int ejs_winreg_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "winreg", argc, argv);
	mprSetCFunction(obj, "winreg_OpenHKCR", ejs_winreg_OpenHKCR);
	mprSetCFunction(obj, "winreg_OpenHKCU", ejs_winreg_OpenHKCU);
	mprSetCFunction(obj, "winreg_OpenHKLM", ejs_winreg_OpenHKLM);
	mprSetCFunction(obj, "winreg_OpenHKPD", ejs_winreg_OpenHKPD);
	mprSetCFunction(obj, "winreg_OpenHKU", ejs_winreg_OpenHKU);
	mprSetCFunction(obj, "winreg_CloseKey", ejs_winreg_CloseKey);
	mprSetCFunction(obj, "winreg_CreateKey", ejs_winreg_CreateKey);
	mprSetCFunction(obj, "winreg_DeleteKey", ejs_winreg_DeleteKey);
	mprSetCFunction(obj, "winreg_DeleteValue", ejs_winreg_DeleteValue);
	mprSetCFunction(obj, "winreg_EnumKey", ejs_winreg_EnumKey);
	mprSetCFunction(obj, "winreg_EnumValue", ejs_winreg_EnumValue);
	mprSetCFunction(obj, "winreg_FlushKey", ejs_winreg_FlushKey);
	mprSetCFunction(obj, "winreg_GetKeySecurity", ejs_winreg_GetKeySecurity);
	mprSetCFunction(obj, "winreg_LoadKey", ejs_winreg_LoadKey);
	mprSetCFunction(obj, "winreg_NotifyChangeKeyValue", ejs_winreg_NotifyChangeKeyValue);
	mprSetCFunction(obj, "winreg_OpenKey", ejs_winreg_OpenKey);
	mprSetCFunction(obj, "winreg_QueryInfoKey", ejs_winreg_QueryInfoKey);
	mprSetCFunction(obj, "winreg_QueryValue", ejs_winreg_QueryValue);
	mprSetCFunction(obj, "winreg_ReplaceKey", ejs_winreg_ReplaceKey);
	mprSetCFunction(obj, "winreg_RestoreKey", ejs_winreg_RestoreKey);
	mprSetCFunction(obj, "winreg_SaveKey", ejs_winreg_SaveKey);
	mprSetCFunction(obj, "winreg_SetKeySecurity", ejs_winreg_SetKeySecurity);
	mprSetCFunction(obj, "winreg_SetValue", ejs_winreg_SetValue);
	mprSetCFunction(obj, "winreg_UnLoadKey", ejs_winreg_UnLoadKey);
	mprSetCFunction(obj, "winreg_InitiateSystemShutdown", ejs_winreg_InitiateSystemShutdown);
	mprSetCFunction(obj, "winreg_AbortSystemShutdown", ejs_winreg_AbortSystemShutdown);
	mprSetCFunction(obj, "winreg_GetVersion", ejs_winreg_GetVersion);
	mprSetCFunction(obj, "winreg_OpenHKCC", ejs_winreg_OpenHKCC);
	mprSetCFunction(obj, "winreg_OpenHKDD", ejs_winreg_OpenHKDD);
	mprSetCFunction(obj, "winreg_QueryMultipleValues", ejs_winreg_QueryMultipleValues);
	mprSetCFunction(obj, "winreg_InitiateSystemShutdownEx", ejs_winreg_InitiateSystemShutdownEx);
	mprSetCFunction(obj, "winreg_SaveKeyEx", ejs_winreg_SaveKeyEx);
	mprSetCFunction(obj, "winreg_OpenHKPT", ejs_winreg_OpenHKPT);
	mprSetCFunction(obj, "winreg_OpenHKPN", ejs_winreg_OpenHKPN);
	mprSetCFunction(obj, "winreg_QueryMultipleValues2", ejs_winreg_QueryMultipleValues2);
	mprSetVar(obj, "REG_RESOURCE_REQUIREMENTS_LIST", mprCreateNumberVar(10));
	mprSetVar(obj, "REG_LINK", mprCreateNumberVar(6));
	mprSetVar(obj, "REG_NONE", mprCreateNumberVar(0));
	mprSetVar(obj, "REG_FULL_RESOURCE_DESCRIPTOR", mprCreateNumberVar(9));
	mprSetVar(obj, "REG_DWORD_BIG_ENDIAN", mprCreateNumberVar(5));
	mprSetVar(obj, "REG_BINARY", mprCreateNumberVar(3));
	mprSetVar(obj, "REG_ACTION_NONE", mprCreateNumberVar(0));
	mprSetVar(obj, "REG_SZ", mprCreateNumberVar(1));
	mprSetVar(obj, "REG_MULTI_SZ", mprCreateNumberVar(7));
	mprSetVar(obj, "REG_OPENED_EXISTING_KEY", mprCreateNumberVar(2));
	mprSetVar(obj, "REG_EXPAND_SZ", mprCreateNumberVar(2));
	mprSetVar(obj, "REG_DWORD", mprCreateNumberVar(4));
	mprSetVar(obj, "REG_QWORD", mprCreateNumberVar(11));
	mprSetVar(obj, "REG_CREATED_NEW_KEY", mprCreateNumberVar(1));
	mprSetVar(obj, "REG_RESOURCE_LIST", mprCreateNumberVar(8));
	return ejs_rpc_init(obj, "winreg");
}

NTSTATUS ejs_init_winreg(void)
{
	ejsDefineCFunction(-1, "winreg_init", ejs_winreg_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
