/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_trkwks.h"

/* trkwks - dcerpc server boilerplate generated by pidl */


static NTSTATUS trkwks__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_TRKWKS_BIND
	return DCESRV_INTERFACE_TRKWKS_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void trkwks__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_TRKWKS_UNBIND
	DCESRV_INTERFACE_TRKWKS_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS trkwks__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_trkwks.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_trkwks.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_trkwks.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_trkwks, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS trkwks__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct trkwks_Unknown0 *r2 = (struct trkwks_Unknown0 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(trkwks_Unknown0, NDR_IN, r2);
		}
		r2->out.result = dcesrv_trkwks_Unknown0(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function trkwks_Unknown0 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_trkwks, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS trkwks__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct trkwks_Unknown0 *r2 = (struct trkwks_Unknown0 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function trkwks_Unknown0 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(trkwks_Unknown0, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in trkwks_Unknown0\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_trkwks, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS trkwks__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_trkwks.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_trkwks_interface = {
	.name		= "trkwks",
	.syntax_id  = {{0x300f3532,0x38cc,0x11d0,{0xa3,0xf0},{0x00,0x20,0xaf,0x6b,0x0a,0xdd}},1.2},
	.bind		= trkwks__op_bind,
	.unbind		= trkwks__op_unbind,
	.ndr_pull	= trkwks__op_ndr_pull,
	.dispatch	= trkwks__op_dispatch,
	.reply		= trkwks__op_reply,
	.ndr_push	= trkwks__op_ndr_push
};


static NTSTATUS trkwks__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_trkwks.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_trkwks.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_trkwks_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("trkwks_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL trkwks__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_trkwks_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_trkwks_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_trkwks_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL trkwks__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_trkwks_interface.name, name)==0) {
		memcpy(iface, &dcesrv_trkwks_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_trkwks_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "trkwks";

	/* fill in all the operations */
	ep_server.init_server = trkwks__op_init_server;

	ep_server.interface_by_uuid = trkwks__op_interface_by_uuid;
	ep_server.interface_by_name = trkwks__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'trkwks' endpoint server!\n"));
		return ret;
	}

	return ret;
}

