
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_svcctl.h"
#include "librpc/gen_ndr/ndr_svcctl_ejs.h"


static NTSTATUS ejs_push_SERVICE_LOCK_STATUS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct SERVICE_LOCK_STATUS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_locked", &r->is_locked));
	if (NULL == r->lock_owner) {
		NDR_CHECK(ejs_push_null(ejs, v, "lock_owner"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "lock_owner", r->lock_owner));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "lock_duration", &r->lock_duration));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_SERVICE_STATUS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct SERVICE_STATUS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "controls_accepted", &r->controls_accepted));
	NDR_CHECK(ejs_push_uint32(ejs, v, "win32_exit_code", &r->win32_exit_code));
	NDR_CHECK(ejs_push_uint32(ejs, v, "service_exit_code", &r->service_exit_code));
	NDR_CHECK(ejs_push_uint32(ejs, v, "check_point", &r->check_point));
	NDR_CHECK(ejs_push_uint32(ejs, v, "wait_hint", &r->wait_hint));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_ENUM_SERVICE_STATUS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ENUM_SERVICE_STATUS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->service_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "service_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "service_name", r->service_name));
	}
	if (NULL == r->display_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "display_name", r->display_name));
	}
	NDR_CHECK(ejs_push_SERVICE_STATUS(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_svcctl_ServerType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_svcctl_ServerType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}

static NTSTATUS ejs_pull_svcctl_CloseServiceHandle(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_CloseServiceHandle *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_CloseServiceHandle(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_CloseServiceHandle *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_CloseServiceHandle(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CLOSESERVICEHANDLE, (ejs_pull_function_t)ejs_pull_svcctl_CloseServiceHandle, (ejs_push_function_t)ejs_push_svcctl_CloseServiceHandle);
}


static NTSTATUS ejs_pull_svcctl_ControlService(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_ControlService *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "control", &r->in.control));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_ControlService(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_ControlService *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_SERVICE_STATUS(ejs, v, "status", r->out.status));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_ControlService(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CONTROLSERVICE, (ejs_pull_function_t)ejs_pull_svcctl_ControlService, (ejs_push_function_t)ejs_push_svcctl_ControlService);
}


static NTSTATUS ejs_pull_svcctl_DeleteService(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_DeleteService *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_DeleteService(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_DeleteService *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_DeleteService(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_DELETESERVICE, (ejs_pull_function_t)ejs_pull_svcctl_DeleteService, (ejs_push_function_t)ejs_push_svcctl_DeleteService);
}


static NTSTATUS ejs_pull_svcctl_LockServiceDatabase(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_LockServiceDatabase *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_LockServiceDatabase(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_LockServiceDatabase *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_policy_handle(ejs, v, "lock", &r->out.lock));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_LockServiceDatabase(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_LOCKSERVICEDATABASE, (ejs_pull_function_t)ejs_pull_svcctl_LockServiceDatabase, (ejs_push_function_t)ejs_push_svcctl_LockServiceDatabase);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceObjectSecurity(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceObjectSecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceObjectSecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceObjectSecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceObjectSecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICEOBJECTSECURITY, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceObjectSecurity, (ejs_push_function_t)ejs_push_svcctl_QueryServiceObjectSecurity);
}


static NTSTATUS ejs_pull_svcctl_SetServiceObjectSecurity(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_SetServiceObjectSecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_SetServiceObjectSecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_SetServiceObjectSecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_SetServiceObjectSecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_SETSERVICEOBJECTSECURITY, (ejs_pull_function_t)ejs_pull_svcctl_SetServiceObjectSecurity, (ejs_push_function_t)ejs_push_svcctl_SetServiceObjectSecurity);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceStatus(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceStatus *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceStatus(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceStatus *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_SERVICE_STATUS(ejs, v, "status", r->out.status));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceStatus(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICESTATUS, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceStatus, (ejs_push_function_t)ejs_push_svcctl_QueryServiceStatus);
}


static NTSTATUS ejs_pull_svcctl_SetServiceStatus(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_SetServiceStatus *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_SetServiceStatus(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_SetServiceStatus *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_SetServiceStatus(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_SETSERVICESTATUS, (ejs_pull_function_t)ejs_pull_svcctl_SetServiceStatus, (ejs_push_function_t)ejs_push_svcctl_SetServiceStatus);
}


static NTSTATUS ejs_pull_svcctl_UnlockServiceDatabase(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_UnlockServiceDatabase *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "lock")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.lock);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "lock", r->in.lock));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_UnlockServiceDatabase(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_UnlockServiceDatabase *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.lock) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "lock", r->out.lock));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_UnlockServiceDatabase(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_UNLOCKSERVICEDATABASE, (ejs_pull_function_t)ejs_pull_svcctl_UnlockServiceDatabase, (ejs_push_function_t)ejs_push_svcctl_UnlockServiceDatabase);
}


static NTSTATUS ejs_pull_svcctl_NotifyBootConfigStatus(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_NotifyBootConfigStatus *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_NotifyBootConfigStatus(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_NotifyBootConfigStatus *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_NotifyBootConfigStatus(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_NOTIFYBOOTCONFIGSTATUS, (ejs_pull_function_t)ejs_pull_svcctl_NotifyBootConfigStatus, (ejs_push_function_t)ejs_push_svcctl_NotifyBootConfigStatus);
}


static NTSTATUS ejs_pull_svcctl_SCSetServiceBitsW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_SCSetServiceBitsW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bits", &r->in.bits));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bitson", &r->in.bitson));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "immediate", &r->in.immediate));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_SCSetServiceBitsW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_SCSetServiceBitsW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_SCSetServiceBitsW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_SCSETSERVICEBITSW, (ejs_pull_function_t)ejs_pull_svcctl_SCSetServiceBitsW, (ejs_push_function_t)ejs_push_svcctl_SCSetServiceBitsW);
}


static NTSTATUS ejs_pull_svcctl_ChangeServiceConfigW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_ChangeServiceConfigW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start", &r->in.start));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "error", &r->in.error));
	if (ejs_pull_null(ejs, v, "binary_path")) {
		r->in.binary_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.binary_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "binary_path", &r->in.binary_path));
	}
	if (ejs_pull_null(ejs, v, "load_order_group")) {
		r->in.load_order_group = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.load_order_group);
		NDR_CHECK(ejs_pull_string(ejs, v, "load_order_group", &r->in.load_order_group));
	}
	if (ejs_pull_null(ejs, v, "dependencies")) {
		r->in.dependencies = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.dependencies);
		NDR_CHECK(ejs_pull_string(ejs, v, "dependencies", &r->in.dependencies));
	}
	if (ejs_pull_null(ejs, v, "service_start_name")) {
		r->in.service_start_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_start_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_start_name", &r->in.service_start_name));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->in.password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password);
		NDR_CHECK(ejs_pull_string(ejs, v, "password", &r->in.password));
	}
	if (ejs_pull_null(ejs, v, "display_name")) {
		r->in.display_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "display_name", &r->in.display_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_ChangeServiceConfigW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_ChangeServiceConfigW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tag_id", &r->out.tag_id));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_ChangeServiceConfigW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CHANGESERVICECONFIGW, (ejs_pull_function_t)ejs_pull_svcctl_ChangeServiceConfigW, (ejs_push_function_t)ejs_push_svcctl_ChangeServiceConfigW);
}


static NTSTATUS ejs_pull_svcctl_CreateServiceW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_CreateServiceW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "scmanager_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.scmanager_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "scmanager_handle", r->in.scmanager_handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "ServiceName", &r->in.ServiceName));
	if (ejs_pull_null(ejs, v, "DisplayName")) {
		r->in.DisplayName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.DisplayName);
		NDR_CHECK(ejs_pull_string(ejs, v, "DisplayName", &r->in.DisplayName));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "desired_access", &r->in.desired_access));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start_type", &r->in.start_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "error_control", &r->in.error_control));
	NDR_CHECK(ejs_pull_string(ejs, v, "binary_path", &r->in.binary_path));
	if (ejs_pull_null(ejs, v, "LoadOrderGroupKey")) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.LoadOrderGroupKey);
		NDR_CHECK(ejs_pull_string(ejs, v, "LoadOrderGroupKey", &r->in.LoadOrderGroupKey));
	}
	if (ejs_pull_null(ejs, v, "TagId")) {
		r->in.TagId = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.TagId);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "TagId", r->in.TagId));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dependencies_size", &r->in.dependencies_size));
	if (ejs_pull_null(ejs, v, "service_start_name")) {
		r->in.service_start_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_start_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_start_name", &r->in.service_start_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "password_size", &r->in.password_size));
	if (ejs_pull_null(ejs, v, "dependencies")) {
		r->in.dependencies = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.dependencies);
		EJS_ALLOC_N(ejs, r->in.dependencies, r->in.dependencies_size);
		ejs_pull_array_uint8(ejs, v, "dependencies", r->in.dependencies, r->in.dependencies_size);
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->in.password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password);
		EJS_ALLOC_N(ejs, r->in.password, r->in.password_size);
		ejs_pull_array_uint8(ejs, v, "password", r->in.password, r->in.password_size);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_CreateServiceW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_CreateServiceW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.TagId) {
		NDR_CHECK(ejs_push_null(ejs, v, "TagId"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "TagId", r->out.TagId));
	}
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_CreateServiceW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CREATESERVICEW, (ejs_pull_function_t)ejs_pull_svcctl_CreateServiceW, (ejs_push_function_t)ejs_push_svcctl_CreateServiceW);
}


static NTSTATUS ejs_pull_svcctl_EnumDependentServicesW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_EnumDependentServicesW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "service")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.service);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "service", r->in.service));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_EnumDependentServicesW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_EnumDependentServicesW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		NDR_CHECK(ejs_push_null(ejs, v, "status"));
	} else {
		NDR_CHECK(ejs_push_ENUM_SERVICE_STATUS(ejs, v, "status", r->out.status));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "services_returned", &r->out.services_returned));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_EnumDependentServicesW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_ENUMDEPENDENTSERVICESW, (ejs_pull_function_t)ejs_pull_svcctl_EnumDependentServicesW, (ejs_push_function_t)ejs_push_svcctl_EnumDependentServicesW);
}


static NTSTATUS ejs_pull_svcctl_EnumServicesStatusW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_EnumServicesStatusW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_EnumServicesStatusW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_EnumServicesStatusW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "service", r->out.service, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "services_returned", &r->out.services_returned));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_EnumServicesStatusW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_ENUMSERVICESSTATUSW, (ejs_pull_function_t)ejs_pull_svcctl_EnumServicesStatusW, (ejs_push_function_t)ejs_push_svcctl_EnumServicesStatusW);
}


static NTSTATUS ejs_pull_svcctl_OpenSCManagerW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_OpenSCManagerW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "MachineName")) {
		r->in.MachineName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.MachineName);
		NDR_CHECK(ejs_pull_string(ejs, v, "MachineName", &r->in.MachineName));
	}
	if (ejs_pull_null(ejs, v, "DatabaseName")) {
		r->in.DatabaseName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.DatabaseName);
		NDR_CHECK(ejs_pull_string(ejs, v, "DatabaseName", &r->in.DatabaseName));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_OpenSCManagerW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_OpenSCManagerW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_OpenSCManagerW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_OPENSCMANAGERW, (ejs_pull_function_t)ejs_pull_svcctl_OpenSCManagerW, (ejs_push_function_t)ejs_push_svcctl_OpenSCManagerW);
}


static NTSTATUS ejs_pull_svcctl_OpenServiceW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_OpenServiceW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "scmanager_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.scmanager_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "scmanager_handle", r->in.scmanager_handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "ServiceName", &r->in.ServiceName));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_OpenServiceW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_OpenServiceW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_OpenServiceW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_OPENSERVICEW, (ejs_pull_function_t)ejs_pull_svcctl_OpenServiceW, (ejs_push_function_t)ejs_push_svcctl_OpenServiceW);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceConfigW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceConfigW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceConfigW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceConfigW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "query", r->out.query, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceConfigW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICECONFIGW, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceConfigW, (ejs_push_function_t)ejs_push_svcctl_QueryServiceConfigW);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceLockStatusW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceLockStatusW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceLockStatusW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceLockStatusW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_SERVICE_LOCK_STATUS(ejs, v, "status", r->out.status));
	}
	if (NULL == r->out.required_buf_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "required_buf_size", r->out.required_buf_size));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceLockStatusW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICELOCKSTATUSW, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceLockStatusW, (ejs_push_function_t)ejs_push_svcctl_QueryServiceLockStatusW);
}


static NTSTATUS ejs_pull_svcctl_StartServiceW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_StartServiceW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "NumArgs", &r->in.NumArgs));
	if (ejs_pull_null(ejs, v, "Arguments")) {
		r->in.Arguments = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.Arguments);
		NDR_CHECK(ejs_pull_string(ejs, v, "Arguments", &r->in.Arguments));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_StartServiceW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_StartServiceW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_StartServiceW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_STARTSERVICEW, (ejs_pull_function_t)ejs_pull_svcctl_StartServiceW, (ejs_push_function_t)ejs_push_svcctl_StartServiceW);
}


static NTSTATUS ejs_pull_svcctl_GetServiceDisplayNameW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_GetServiceDisplayNameW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "service_name")) {
		r->in.service_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_name", &r->in.service_name));
	}
	if (ejs_pull_null(ejs, v, "display_name_length")) {
		r->in.display_name_length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name_length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "display_name_length", r->in.display_name_length));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_GetServiceDisplayNameW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_GetServiceDisplayNameW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.display_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "display_name", r->out.display_name));
	}
	if (NULL == r->out.display_name_length) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name_length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "display_name_length", r->out.display_name_length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_GetServiceDisplayNameW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_GETSERVICEDISPLAYNAMEW, (ejs_pull_function_t)ejs_pull_svcctl_GetServiceDisplayNameW, (ejs_push_function_t)ejs_push_svcctl_GetServiceDisplayNameW);
}


static NTSTATUS ejs_pull_svcctl_GetServiceKeyNameW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_GetServiceKeyNameW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "service_name")) {
		r->in.service_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_name", &r->in.service_name));
	}
	if (ejs_pull_null(ejs, v, "display_name_length")) {
		r->in.display_name_length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name_length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "display_name_length", r->in.display_name_length));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_GetServiceKeyNameW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_GetServiceKeyNameW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.key_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "key_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "key_name", r->out.key_name));
	}
	if (NULL == r->out.display_name_length) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name_length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "display_name_length", r->out.display_name_length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_GetServiceKeyNameW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_GETSERVICEKEYNAMEW, (ejs_pull_function_t)ejs_pull_svcctl_GetServiceKeyNameW, (ejs_push_function_t)ejs_push_svcctl_GetServiceKeyNameW);
}


static NTSTATUS ejs_pull_svcctl_SCSetServiceBitsA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_SCSetServiceBitsA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bits", &r->in.bits));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bitson", &r->in.bitson));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "immediate", &r->in.immediate));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_SCSetServiceBitsA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_SCSetServiceBitsA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_SCSetServiceBitsA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_SCSETSERVICEBITSA, (ejs_pull_function_t)ejs_pull_svcctl_SCSetServiceBitsA, (ejs_push_function_t)ejs_push_svcctl_SCSetServiceBitsA);
}


static NTSTATUS ejs_pull_svcctl_ChangeServiceConfigA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_ChangeServiceConfigA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start", &r->in.start));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "error", &r->in.error));
	if (ejs_pull_null(ejs, v, "binary_path")) {
		r->in.binary_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.binary_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "binary_path", &r->in.binary_path));
	}
	if (ejs_pull_null(ejs, v, "load_order_group")) {
		r->in.load_order_group = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.load_order_group);
		NDR_CHECK(ejs_pull_string(ejs, v, "load_order_group", &r->in.load_order_group));
	}
	if (ejs_pull_null(ejs, v, "dependencies")) {
		r->in.dependencies = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.dependencies);
		NDR_CHECK(ejs_pull_string(ejs, v, "dependencies", &r->in.dependencies));
	}
	if (ejs_pull_null(ejs, v, "service_start_name")) {
		r->in.service_start_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_start_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_start_name", &r->in.service_start_name));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->in.password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password);
		NDR_CHECK(ejs_pull_string(ejs, v, "password", &r->in.password));
	}
	if (ejs_pull_null(ejs, v, "display_name")) {
		r->in.display_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "display_name", &r->in.display_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_ChangeServiceConfigA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_ChangeServiceConfigA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tag_id", &r->out.tag_id));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_ChangeServiceConfigA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CHANGESERVICECONFIGA, (ejs_pull_function_t)ejs_pull_svcctl_ChangeServiceConfigA, (ejs_push_function_t)ejs_push_svcctl_ChangeServiceConfigA);
}


static NTSTATUS ejs_pull_svcctl_CreateServiceA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_CreateServiceA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "ServiceName")) {
		r->in.ServiceName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ServiceName);
		NDR_CHECK(ejs_pull_string(ejs, v, "ServiceName", &r->in.ServiceName));
	}
	if (ejs_pull_null(ejs, v, "DisplayName")) {
		r->in.DisplayName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.DisplayName);
		NDR_CHECK(ejs_pull_string(ejs, v, "DisplayName", &r->in.DisplayName));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "desired_access", &r->in.desired_access));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start_type", &r->in.start_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "error_control", &r->in.error_control));
	if (ejs_pull_null(ejs, v, "binary_path")) {
		r->in.binary_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.binary_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "binary_path", &r->in.binary_path));
	}
	if (ejs_pull_null(ejs, v, "LoadOrderGroupKey")) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.LoadOrderGroupKey);
		NDR_CHECK(ejs_pull_string(ejs, v, "LoadOrderGroupKey", &r->in.LoadOrderGroupKey));
	}
	if (ejs_pull_null(ejs, v, "dependencies")) {
		r->in.dependencies = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.dependencies);
		NDR_CHECK(ejs_pull_string(ejs, v, "dependencies", &r->in.dependencies));
	}
	if (ejs_pull_null(ejs, v, "service_start_name")) {
		r->in.service_start_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_start_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_start_name", &r->in.service_start_name));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->in.password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password);
		NDR_CHECK(ejs_pull_string(ejs, v, "password", &r->in.password));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_CreateServiceA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_CreateServiceA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.TagId) {
		NDR_CHECK(ejs_push_null(ejs, v, "TagId"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "TagId", r->out.TagId));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_CreateServiceA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CREATESERVICEA, (ejs_pull_function_t)ejs_pull_svcctl_CreateServiceA, (ejs_push_function_t)ejs_push_svcctl_CreateServiceA);
}


static NTSTATUS ejs_pull_svcctl_EnumDependentServicesA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_EnumDependentServicesA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "service")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.service);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "service", r->in.service));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_EnumDependentServicesA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_EnumDependentServicesA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		NDR_CHECK(ejs_push_null(ejs, v, "status"));
	} else {
		NDR_CHECK(ejs_push_ENUM_SERVICE_STATUS(ejs, v, "status", r->out.status));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "services_returned", &r->out.services_returned));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_EnumDependentServicesA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_ENUMDEPENDENTSERVICESA, (ejs_pull_function_t)ejs_pull_svcctl_EnumDependentServicesA, (ejs_push_function_t)ejs_push_svcctl_EnumDependentServicesA);
}


static NTSTATUS ejs_pull_svcctl_EnumServicesStatusA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_EnumServicesStatusA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_EnumServicesStatusA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_EnumServicesStatusA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "service", r->out.service, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "services_returned", &r->out.services_returned));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_EnumServicesStatusA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_ENUMSERVICESSTATUSA, (ejs_pull_function_t)ejs_pull_svcctl_EnumServicesStatusA, (ejs_push_function_t)ejs_push_svcctl_EnumServicesStatusA);
}


static NTSTATUS ejs_pull_svcctl_OpenSCManagerA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_OpenSCManagerA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "MachineName")) {
		r->in.MachineName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.MachineName);
		NDR_CHECK(ejs_pull_string(ejs, v, "MachineName", &r->in.MachineName));
	}
	if (ejs_pull_null(ejs, v, "DatabaseName")) {
		r->in.DatabaseName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.DatabaseName);
		NDR_CHECK(ejs_pull_string(ejs, v, "DatabaseName", &r->in.DatabaseName));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_OpenSCManagerA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_OpenSCManagerA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_OpenSCManagerA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_OPENSCMANAGERA, (ejs_pull_function_t)ejs_pull_svcctl_OpenSCManagerA, (ejs_push_function_t)ejs_push_svcctl_OpenSCManagerA);
}


static NTSTATUS ejs_pull_svcctl_OpenServiceA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_OpenServiceA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "scmanager_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.scmanager_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "scmanager_handle", r->in.scmanager_handle));
	}
	if (ejs_pull_null(ejs, v, "ServiceName")) {
		r->in.ServiceName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ServiceName);
		NDR_CHECK(ejs_pull_string(ejs, v, "ServiceName", &r->in.ServiceName));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_OpenServiceA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_OpenServiceA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_OpenServiceA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_OPENSERVICEA, (ejs_pull_function_t)ejs_pull_svcctl_OpenServiceA, (ejs_push_function_t)ejs_push_svcctl_OpenServiceA);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceConfigA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceConfigA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceConfigA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceConfigA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "query", r->out.query, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceConfigA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICECONFIGA, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceConfigA, (ejs_push_function_t)ejs_push_svcctl_QueryServiceConfigA);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceLockStatusA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceLockStatusA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceLockStatusA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceLockStatusA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_SERVICE_LOCK_STATUS(ejs, v, "status", r->out.status));
	}
	if (NULL == r->out.required_buf_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "required_buf_size", r->out.required_buf_size));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceLockStatusA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICELOCKSTATUSA, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceLockStatusA, (ejs_push_function_t)ejs_push_svcctl_QueryServiceLockStatusA);
}


static NTSTATUS ejs_pull_svcctl_StartServiceA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_StartServiceA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "NumArgs", &r->in.NumArgs));
	if (ejs_pull_null(ejs, v, "Arguments")) {
		r->in.Arguments = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.Arguments);
		NDR_CHECK(ejs_pull_string(ejs, v, "Arguments", &r->in.Arguments));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_StartServiceA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_StartServiceA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_StartServiceA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_STARTSERVICEA, (ejs_pull_function_t)ejs_pull_svcctl_StartServiceA, (ejs_push_function_t)ejs_push_svcctl_StartServiceA);
}


static NTSTATUS ejs_pull_svcctl_GetServiceDisplayNameA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_GetServiceDisplayNameA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "service_name")) {
		r->in.service_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_name", &r->in.service_name));
	}
	if (ejs_pull_null(ejs, v, "display_name_length")) {
		r->in.display_name_length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name_length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "display_name_length", r->in.display_name_length));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_GetServiceDisplayNameA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_GetServiceDisplayNameA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.display_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "display_name", r->out.display_name));
	}
	if (NULL == r->out.display_name_length) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name_length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "display_name_length", r->out.display_name_length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_GetServiceDisplayNameA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_GETSERVICEDISPLAYNAMEA, (ejs_pull_function_t)ejs_pull_svcctl_GetServiceDisplayNameA, (ejs_push_function_t)ejs_push_svcctl_GetServiceDisplayNameA);
}


static NTSTATUS ejs_pull_svcctl_GetServiceKeyNameA(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_GetServiceKeyNameA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "service_name")) {
		r->in.service_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "service_name", &r->in.service_name));
	}
	if (ejs_pull_null(ejs, v, "display_name_length")) {
		r->in.display_name_length = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.display_name_length);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "display_name_length", r->in.display_name_length));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_GetServiceKeyNameA(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_GetServiceKeyNameA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.key_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "key_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "key_name", r->out.key_name));
	}
	if (NULL == r->out.display_name_length) {
		NDR_CHECK(ejs_push_null(ejs, v, "display_name_length"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "display_name_length", r->out.display_name_length));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_GetServiceKeyNameA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_GETSERVICEKEYNAMEA, (ejs_pull_function_t)ejs_pull_svcctl_GetServiceKeyNameA, (ejs_push_function_t)ejs_push_svcctl_GetServiceKeyNameA);
}


static NTSTATUS ejs_pull_svcctl_GetCurrentGroupeStateW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_GetCurrentGroupeStateW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_GetCurrentGroupeStateW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_GetCurrentGroupeStateW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_GetCurrentGroupeStateW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_GETCURRENTGROUPESTATEW, (ejs_pull_function_t)ejs_pull_svcctl_GetCurrentGroupeStateW, (ejs_push_function_t)ejs_push_svcctl_GetCurrentGroupeStateW);
}


static NTSTATUS ejs_pull_svcctl_EnumServiceGroupW(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_EnumServiceGroupW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_EnumServiceGroupW(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_EnumServiceGroupW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_EnumServiceGroupW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_ENUMSERVICEGROUPW, (ejs_pull_function_t)ejs_pull_svcctl_EnumServiceGroupW, (ejs_push_function_t)ejs_push_svcctl_EnumServiceGroupW);
}


static NTSTATUS ejs_pull_svcctl_ChangeServiceConfig2A(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_ChangeServiceConfig2A *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		NDR_CHECK(ejs_pull_uint8(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_ChangeServiceConfig2A(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_ChangeServiceConfig2A *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_ChangeServiceConfig2A(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CHANGESERVICECONFIG2A, (ejs_pull_function_t)ejs_pull_svcctl_ChangeServiceConfig2A, (ejs_push_function_t)ejs_push_svcctl_ChangeServiceConfig2A);
}


static NTSTATUS ejs_pull_svcctl_ChangeServiceConfig2W(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_ChangeServiceConfig2W *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		NDR_CHECK(ejs_pull_uint8(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_ChangeServiceConfig2W(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_ChangeServiceConfig2W *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_ChangeServiceConfig2W(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_CHANGESERVICECONFIG2W, (ejs_pull_function_t)ejs_pull_svcctl_ChangeServiceConfig2W, (ejs_push_function_t)ejs_push_svcctl_ChangeServiceConfig2W);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceConfig2A(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceConfig2A *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceConfig2A(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceConfig2A *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "buffer", r->out.buffer, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceConfig2A(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICECONFIG2A, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceConfig2A, (ejs_push_function_t)ejs_push_svcctl_QueryServiceConfig2A);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceConfig2W(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceConfig2W *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceConfig2W(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceConfig2W *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "buffer", r->out.buffer, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceConfig2W(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICECONFIG2W, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceConfig2W, (ejs_push_function_t)ejs_push_svcctl_QueryServiceConfig2W);
}


static NTSTATUS ejs_pull_svcctl_QueryServiceStatusEx(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_QueryServiceStatusEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_QueryServiceStatusEx(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_QueryServiceStatusEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "buffer", r->out.buffer, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_QueryServiceStatusEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_QUERYSERVICESTATUSEX, (ejs_pull_function_t)ejs_pull_svcctl_QueryServiceStatusEx, (ejs_push_function_t)ejs_push_svcctl_QueryServiceStatusEx);
}


static NTSTATUS ejs_pull_EnumServicesStatusExA(struct ejs_rpc *ejs, struct MprVar *v, struct EnumServicesStatusExA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "scmanager")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.scmanager);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "scmanager", r->in.scmanager));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EnumServicesStatusExA(struct ejs_rpc *ejs, struct MprVar *v, const struct EnumServicesStatusExA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "services", r->out.services, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "service_returned", &r->out.service_returned));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.group_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "group_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "group_name", r->out.group_name));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EnumServicesStatusExA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_ENUMSERVICESSTATUSEXA, (ejs_pull_function_t)ejs_pull_EnumServicesStatusExA, (ejs_push_function_t)ejs_push_EnumServicesStatusExA);
}


static NTSTATUS ejs_pull_EnumServicesStatusExW(struct ejs_rpc *ejs, struct MprVar *v, struct EnumServicesStatusExW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "scmanager")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.scmanager);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "scmanager", r->in.scmanager));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "info_level", &r->in.info_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "state", &r->in.state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EnumServicesStatusExW(struct ejs_rpc *ejs, struct MprVar *v, const struct EnumServicesStatusExW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "services", r->out.services, r->in.buf_size);
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytes_needed", &r->out.bytes_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "service_returned", &r->out.service_returned));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.group_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "group_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "group_name", r->out.group_name));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EnumServicesStatusExW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_ENUMSERVICESSTATUSEXW, (ejs_pull_function_t)ejs_pull_EnumServicesStatusExW, (ejs_push_function_t)ejs_push_EnumServicesStatusExW);
}


static NTSTATUS ejs_pull_svcctl_SCSendTSMessage(struct ejs_rpc *ejs, struct MprVar *v, struct svcctl_SCSendTSMessage *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_svcctl_SCSendTSMessage(struct ejs_rpc *ejs, struct MprVar *v, const struct svcctl_SCSendTSMessage *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_svcctl_SCSendTSMessage(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_svcctl, DCERPC_SVCCTL_SCSENDTSMESSAGE, (ejs_pull_function_t)ejs_pull_svcctl_SCSendTSMessage, (ejs_push_function_t)ejs_push_svcctl_SCSendTSMessage);
}

static int ejs_svcctl_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "svcctl", argc, argv);
	mprSetCFunction(obj, "svcctl_CloseServiceHandle", ejs_svcctl_CloseServiceHandle);
	mprSetCFunction(obj, "svcctl_ControlService", ejs_svcctl_ControlService);
	mprSetCFunction(obj, "svcctl_DeleteService", ejs_svcctl_DeleteService);
	mprSetCFunction(obj, "svcctl_LockServiceDatabase", ejs_svcctl_LockServiceDatabase);
	mprSetCFunction(obj, "svcctl_QueryServiceObjectSecurity", ejs_svcctl_QueryServiceObjectSecurity);
	mprSetCFunction(obj, "svcctl_SetServiceObjectSecurity", ejs_svcctl_SetServiceObjectSecurity);
	mprSetCFunction(obj, "svcctl_QueryServiceStatus", ejs_svcctl_QueryServiceStatus);
	mprSetCFunction(obj, "svcctl_SetServiceStatus", ejs_svcctl_SetServiceStatus);
	mprSetCFunction(obj, "svcctl_UnlockServiceDatabase", ejs_svcctl_UnlockServiceDatabase);
	mprSetCFunction(obj, "svcctl_NotifyBootConfigStatus", ejs_svcctl_NotifyBootConfigStatus);
	mprSetCFunction(obj, "svcctl_SCSetServiceBitsW", ejs_svcctl_SCSetServiceBitsW);
	mprSetCFunction(obj, "svcctl_ChangeServiceConfigW", ejs_svcctl_ChangeServiceConfigW);
	mprSetCFunction(obj, "svcctl_CreateServiceW", ejs_svcctl_CreateServiceW);
	mprSetCFunction(obj, "svcctl_EnumDependentServicesW", ejs_svcctl_EnumDependentServicesW);
	mprSetCFunction(obj, "svcctl_EnumServicesStatusW", ejs_svcctl_EnumServicesStatusW);
	mprSetCFunction(obj, "svcctl_OpenSCManagerW", ejs_svcctl_OpenSCManagerW);
	mprSetCFunction(obj, "svcctl_OpenServiceW", ejs_svcctl_OpenServiceW);
	mprSetCFunction(obj, "svcctl_QueryServiceConfigW", ejs_svcctl_QueryServiceConfigW);
	mprSetCFunction(obj, "svcctl_QueryServiceLockStatusW", ejs_svcctl_QueryServiceLockStatusW);
	mprSetCFunction(obj, "svcctl_StartServiceW", ejs_svcctl_StartServiceW);
	mprSetCFunction(obj, "svcctl_GetServiceDisplayNameW", ejs_svcctl_GetServiceDisplayNameW);
	mprSetCFunction(obj, "svcctl_GetServiceKeyNameW", ejs_svcctl_GetServiceKeyNameW);
	mprSetCFunction(obj, "svcctl_SCSetServiceBitsA", ejs_svcctl_SCSetServiceBitsA);
	mprSetCFunction(obj, "svcctl_ChangeServiceConfigA", ejs_svcctl_ChangeServiceConfigA);
	mprSetCFunction(obj, "svcctl_CreateServiceA", ejs_svcctl_CreateServiceA);
	mprSetCFunction(obj, "svcctl_EnumDependentServicesA", ejs_svcctl_EnumDependentServicesA);
	mprSetCFunction(obj, "svcctl_EnumServicesStatusA", ejs_svcctl_EnumServicesStatusA);
	mprSetCFunction(obj, "svcctl_OpenSCManagerA", ejs_svcctl_OpenSCManagerA);
	mprSetCFunction(obj, "svcctl_OpenServiceA", ejs_svcctl_OpenServiceA);
	mprSetCFunction(obj, "svcctl_QueryServiceConfigA", ejs_svcctl_QueryServiceConfigA);
	mprSetCFunction(obj, "svcctl_QueryServiceLockStatusA", ejs_svcctl_QueryServiceLockStatusA);
	mprSetCFunction(obj, "svcctl_StartServiceA", ejs_svcctl_StartServiceA);
	mprSetCFunction(obj, "svcctl_GetServiceDisplayNameA", ejs_svcctl_GetServiceDisplayNameA);
	mprSetCFunction(obj, "svcctl_GetServiceKeyNameA", ejs_svcctl_GetServiceKeyNameA);
	mprSetCFunction(obj, "svcctl_GetCurrentGroupeStateW", ejs_svcctl_GetCurrentGroupeStateW);
	mprSetCFunction(obj, "svcctl_EnumServiceGroupW", ejs_svcctl_EnumServiceGroupW);
	mprSetCFunction(obj, "svcctl_ChangeServiceConfig2A", ejs_svcctl_ChangeServiceConfig2A);
	mprSetCFunction(obj, "svcctl_ChangeServiceConfig2W", ejs_svcctl_ChangeServiceConfig2W);
	mprSetCFunction(obj, "svcctl_QueryServiceConfig2A", ejs_svcctl_QueryServiceConfig2A);
	mprSetCFunction(obj, "svcctl_QueryServiceConfig2W", ejs_svcctl_QueryServiceConfig2W);
	mprSetCFunction(obj, "svcctl_QueryServiceStatusEx", ejs_svcctl_QueryServiceStatusEx);
	mprSetCFunction(obj, "EnumServicesStatusExA", ejs_EnumServicesStatusExA);
	mprSetCFunction(obj, "EnumServicesStatusExW", ejs_EnumServicesStatusExW);
	mprSetCFunction(obj, "svcctl_SCSendTSMessage", ejs_svcctl_SCSendTSMessage);
	mprSetVar(obj, "SV_TYPE_SERVER_NT", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "SV_TYPE_AFP", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "SV_TYPE_SERVER_UNIX", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "SV_TYPE_DOMAIN_MASTER", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "SERVICE_TYPE_FS_DRIVER", mprCreateNumberVar(0x02));
	mprSetVar(obj, "SV_TYPE_DIALIN_SERVER", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "SV_TYPE_POTENTIAL_BROWSER", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "SV_TYPE_SQLSERVER", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SV_TYPE_ALL", mprCreateNumberVar(0xFFFFFFFF));
	mprSetVar(obj, "SERVICE_TYPE_RECOGNIZER_DRIVER", mprCreateNumberVar(0x08));
	mprSetVar(obj, "SERVICE_TYPE_WIN32", mprCreateNumberVar(SERVICE_TYPE_WIN32_OWN_PROCESS|SERVICE_TYPE_WIN32_SHARE_PROCESS));
	mprSetVar(obj, "SV_TYPE_WORKSTATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SV_TYPE_SERVER_VMS", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "SV_TYPE_SERVER_MFPN", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "SV_TYPE_ALTERNATE_XPORT", mprCreateNumberVar(( 0x20000000 )));
	mprSetVar(obj, "SV_TYPE_DFS_SERVER", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "SV_TYPE_SERVER_OSF", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "SERVICE_TYPE_WIN32_SHARE_PROCESS", mprCreateNumberVar(0x20));
	mprSetVar(obj, "SV_TYPE_DOMAIN_CTRL", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SERVICE_STATE_ACTIVE", mprCreateNumberVar(0x01));
	mprSetVar(obj, "SV_TYPE_BACKUP_BROWSER", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "SV_TYPE_WFW", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "SERVICE_TYPE_WIN32_OWN_PROCESS", mprCreateNumberVar(0x10));
	mprSetVar(obj, "SV_TYPE_SERVER", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SERVICE_TYPE_DRIVER", mprCreateNumberVar(SERVICE_TYPE_KERNEL_DRIVER|SERVICE_TYPE_FS_DRIVER|SERVICE_TYPE_RECOGNIZER_DRIVER));
	mprSetVar(obj, "SERVICE_TYPE_ADAPTER", mprCreateNumberVar(0x04));
	mprSetVar(obj, "SV_TYPE_DOMAIN_BAKCTRL", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "SV_TYPE_DOMAIN_ENUM", mprCreateNumberVar(( 0x80000000 )));
	mprSetVar(obj, "SV_TYPE_DOMAIN_MEMBER", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "SV_TYPE_PRINTQ_SERVER", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "SV_TYPE_MASTER_BROWSER", mprCreateNumberVar(( 0x00040000 )));
	mprSetVar(obj, "SV_TYPE_LOCAL_LIST_ONLY", mprCreateNumberVar(( 0x40000000 )));
	mprSetVar(obj, "SV_TYPE_NOVELL", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "SV_TYPE_WIN95_PLUS", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "SERVICE_STATE_ALL", mprCreateNumberVar(0x03));
	mprSetVar(obj, "SV_TYPE_NT", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "SERVICE_STATE_INACTIVE", mprCreateNumberVar(0x02));
	mprSetVar(obj, "SV_TYPE_TIME_SOURCE", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "SERVICE_TYPE_KERNEL_DRIVER", mprCreateNumberVar(0x01));
	return ejs_rpc_init(obj, "svcctl");
}

NTSTATUS ejs_init_svcctl(void)
{
	ejsDefineCFunction(-1, "svcctl_init", ejs_svcctl_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
