
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_spoolss.h"
#include "librpc/gen_ndr/ndr_spoolss_ejs.h"


static NTSTATUS ejs_push_spoolss_Time(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_Time *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "year", &r->year));
	NDR_CHECK(ejs_push_uint16(ejs, v, "month", &r->month));
	NDR_CHECK(ejs_push_uint16(ejs, v, "day_of_week", &r->day_of_week));
	NDR_CHECK(ejs_push_uint16(ejs, v, "day", &r->day));
	NDR_CHECK(ejs_push_uint16(ejs, v, "hour", &r->hour));
	NDR_CHECK(ejs_push_uint16(ejs, v, "minute", &r->minute));
	NDR_CHECK(ejs_push_uint16(ejs, v, "second", &r->second));
	NDR_CHECK(ejs_push_uint16(ejs, v, "millisecond", &r->millisecond));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_Time(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_Time *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "year", &r->year));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "month", &r->month));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "day_of_week", &r->day_of_week));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "day", &r->day));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "hour", &r->hour));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "minute", &r->minute));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "second", &r->second));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "millisecond", &r->millisecond));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->printername) {
		NDR_CHECK(ejs_push_null(ejs, v, "printername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printername", r->printername));
	}
	if (NULL == r->servername) {
		NDR_CHECK(ejs_push_null(ejs, v, "servername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "servername", r->servername));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "cjobs", &r->cjobs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_jobs", &r->total_jobs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_bytes", &r->total_bytes));
	NDR_CHECK(ejs_push_spoolss_Time(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "global_counter", &r->global_counter));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_pages", &r->total_pages));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown10", &r->unknown10));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown11", &r->unknown11));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown12", &r->unknown12));
	NDR_CHECK(ejs_push_uint32(ejs, v, "session_counter", &r->session_counter));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown14", &r->unknown14));
	NDR_CHECK(ejs_push_uint32(ejs, v, "printer_errors", &r->printer_errors));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown16", &r->unknown16));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown17", &r->unknown17));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown18", &r->unknown18));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown19", &r->unknown19));
	NDR_CHECK(ejs_push_uint32(ejs, v, "change_id", &r->change_id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown21", &r->unknown21));
	NDR_CHECK(ejs_push_uint32(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown23", &r->unknown23));
	NDR_CHECK(ejs_push_uint32(ejs, v, "c_setprinter", &r->c_setprinter));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown25", &r->unknown25));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown26", &r->unknown26));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown27", &r->unknown27));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown28", &r->unknown28));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown29", &r->unknown29));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "printername")) {
		r->printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->printername));
	}
	if (ejs_pull_null(ejs, v, "servername")) {
		r->servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cjobs", &r->cjobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_jobs", &r->total_jobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_bytes", &r->total_bytes));
	NDR_CHECK(ejs_pull_spoolss_Time(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "global_counter", &r->global_counter));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_pages", &r->total_pages));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown10", &r->unknown10));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown11", &r->unknown11));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown12", &r->unknown12));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "session_counter", &r->session_counter));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown14", &r->unknown14));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "printer_errors", &r->printer_errors));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown16", &r->unknown16));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown17", &r->unknown17));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown18", &r->unknown18));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown19", &r->unknown19));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "change_id", &r->change_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown21", &r->unknown21));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown23", &r->unknown23));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "c_setprinter", &r->c_setprinter));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown25", &r->unknown25));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown26", &r->unknown26));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown27", &r->unknown27));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown28", &r->unknown28));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown29", &r->unknown29));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_DeviceMode(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DeviceMode *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "devicename", r->devicename));
	NDR_CHECK(ejs_push_uint16(ejs, v, "specversion", &r->specversion));
	NDR_CHECK(ejs_push_uint16(ejs, v, "driverversion", &r->driverversion));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint16(ejs, v, "__driverextra_length", &r->__driverextra_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "fields", &r->fields));
	NDR_CHECK(ejs_push_uint16(ejs, v, "orientation", &r->orientation));
	NDR_CHECK(ejs_push_uint16(ejs, v, "papersize", &r->papersize));
	NDR_CHECK(ejs_push_uint16(ejs, v, "paperlength", &r->paperlength));
	NDR_CHECK(ejs_push_uint16(ejs, v, "paperwidth", &r->paperwidth));
	NDR_CHECK(ejs_push_uint16(ejs, v, "scale", &r->scale));
	NDR_CHECK(ejs_push_uint16(ejs, v, "copies", &r->copies));
	NDR_CHECK(ejs_push_uint16(ejs, v, "defaultsource", &r->defaultsource));
	NDR_CHECK(ejs_push_uint16(ejs, v, "printquality", &r->printquality));
	NDR_CHECK(ejs_push_uint16(ejs, v, "color", &r->color));
	NDR_CHECK(ejs_push_uint16(ejs, v, "duplex", &r->duplex));
	NDR_CHECK(ejs_push_uint16(ejs, v, "yresolution", &r->yresolution));
	NDR_CHECK(ejs_push_uint16(ejs, v, "ttoption", &r->ttoption));
	NDR_CHECK(ejs_push_uint16(ejs, v, "collate", &r->collate));
	NDR_CHECK(ejs_push_string(ejs, v, "formname", r->formname));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logpixels", &r->logpixels));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bitsperpel", &r->bitsperpel));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pelswidth", &r->pelswidth));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pelsheight", &r->pelsheight));
	NDR_CHECK(ejs_push_uint32(ejs, v, "displayflags", &r->displayflags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "displayfrequency", &r->displayfrequency));
	NDR_CHECK(ejs_push_uint32(ejs, v, "icmmethod", &r->icmmethod));
	NDR_CHECK(ejs_push_uint32(ejs, v, "icmintent", &r->icmintent));
	NDR_CHECK(ejs_push_uint32(ejs, v, "mediatype", &r->mediatype));
	NDR_CHECK(ejs_push_uint32(ejs, v, "dithertype", &r->dithertype));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved1", &r->reserved1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved2", &r->reserved2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "panningwidth", &r->panningwidth));
	NDR_CHECK(ejs_push_uint32(ejs, v, "panningheight", &r->panningheight));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_spoolss_DeviceMode(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DeviceMode *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "devicename", &r->devicename));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "specversion", &r->specversion));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "driverversion", &r->driverversion));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "fields", &r->fields));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "orientation", &r->orientation));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "papersize", &r->papersize));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "paperlength", &r->paperlength));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "paperwidth", &r->paperwidth));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "scale", &r->scale));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "copies", &r->copies));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "defaultsource", &r->defaultsource));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "printquality", &r->printquality));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "color", &r->color));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "duplex", &r->duplex));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "yresolution", &r->yresolution));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "ttoption", &r->ttoption));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "collate", &r->collate));
	NDR_CHECK(ejs_pull_string(ejs, v, "formname", &r->formname));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logpixels", &r->logpixels));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bitsperpel", &r->bitsperpel));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pelswidth", &r->pelswidth));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pelsheight", &r->pelsheight));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "displayflags", &r->displayflags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "displayfrequency", &r->displayfrequency));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "icmmethod", &r->icmmethod));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "icmintent", &r->icmintent));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "mediatype", &r->mediatype));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dithertype", &r->dithertype));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved1", &r->reserved1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved2", &r->reserved2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "panningwidth", &r->panningwidth));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "panningheight", &r->panningheight));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_EnumPrinterFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_EnumPrinterFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_spoolss_PrinterInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_EnumPrinterFlags(ejs, v, "flags", &r->flags));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->description) {
		NDR_CHECK(ejs_push_null(ejs, v, "description"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "description", r->description));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_EnumPrinterFlags(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "description")) {
		r->description = NULL;
	} else {
		EJS_ALLOC(ejs, r->description);
		NDR_CHECK(ejs_pull_string(ejs, v, "description", &r->description));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterAttributes(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_spoolss_PrinterAttributes(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_spoolss_PrinterStatus(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_spoolss_PrinterStatus(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_spoolss_PrinterInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->servername) {
		NDR_CHECK(ejs_push_null(ejs, v, "servername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "servername", r->servername));
	}
	if (NULL == r->printername) {
		NDR_CHECK(ejs_push_null(ejs, v, "printername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printername", r->printername));
	}
	if (NULL == r->sharename) {
		NDR_CHECK(ejs_push_null(ejs, v, "sharename"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "sharename", r->sharename));
	}
	if (NULL == r->portname) {
		NDR_CHECK(ejs_push_null(ejs, v, "portname"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "portname", r->portname));
	}
	if (NULL == r->drivername) {
		NDR_CHECK(ejs_push_null(ejs, v, "drivername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "drivername", r->drivername));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	if (NULL == r->location) {
		NDR_CHECK(ejs_push_null(ejs, v, "location"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "location", r->location));
	}
	if (NULL == r->devmode) {
		NDR_CHECK(ejs_push_null(ejs, v, "devmode"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	if (NULL == r->sepfile) {
		NDR_CHECK(ejs_push_null(ejs, v, "sepfile"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "sepfile", r->sepfile));
	}
	if (NULL == r->printprocessor) {
		NDR_CHECK(ejs_push_null(ejs, v, "printprocessor"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printprocessor", r->printprocessor));
	}
	if (NULL == r->datatype) {
		NDR_CHECK(ejs_push_null(ejs, v, "datatype"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "datatype", r->datatype));
	}
	if (NULL == r->parameters) {
		NDR_CHECK(ejs_push_null(ejs, v, "parameters"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "parameters", r->parameters));
	}
	if (NULL == r->secdesc) {
		NDR_CHECK(ejs_push_null(ejs, v, "secdesc"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_push_uint32(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_push_uint32(ejs, v, "defaultpriority", &r->defaultpriority));
	NDR_CHECK(ejs_push_uint32(ejs, v, "starttime", &r->starttime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "untiltime", &r->untiltime));
	NDR_CHECK(ejs_push_spoolss_PrinterStatus(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cjobs", &r->cjobs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "averageppm", &r->averageppm));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->servername));
	}
	if (ejs_pull_null(ejs, v, "printername")) {
		r->printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->printername));
	}
	if (ejs_pull_null(ejs, v, "sharename")) {
		r->sharename = NULL;
	} else {
		EJS_ALLOC(ejs, r->sharename);
		NDR_CHECK(ejs_pull_string(ejs, v, "sharename", &r->sharename));
	}
	if (ejs_pull_null(ejs, v, "portname")) {
		r->portname = NULL;
	} else {
		EJS_ALLOC(ejs, r->portname);
		NDR_CHECK(ejs_pull_string(ejs, v, "portname", &r->portname));
	}
	if (ejs_pull_null(ejs, v, "drivername")) {
		r->drivername = NULL;
	} else {
		EJS_ALLOC(ejs, r->drivername);
		NDR_CHECK(ejs_pull_string(ejs, v, "drivername", &r->drivername));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	if (ejs_pull_null(ejs, v, "location")) {
		r->location = NULL;
	} else {
		EJS_ALLOC(ejs, r->location);
		NDR_CHECK(ejs_pull_string(ejs, v, "location", &r->location));
	}
	if (ejs_pull_null(ejs, v, "devmode")) {
		r->devmode = NULL;
	} else {
		EJS_ALLOC(ejs, r->devmode);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	if (ejs_pull_null(ejs, v, "sepfile")) {
		r->sepfile = NULL;
	} else {
		EJS_ALLOC(ejs, r->sepfile);
		NDR_CHECK(ejs_pull_string(ejs, v, "sepfile", &r->sepfile));
	}
	if (ejs_pull_null(ejs, v, "printprocessor")) {
		r->printprocessor = NULL;
	} else {
		EJS_ALLOC(ejs, r->printprocessor);
		NDR_CHECK(ejs_pull_string(ejs, v, "printprocessor", &r->printprocessor));
	}
	if (ejs_pull_null(ejs, v, "datatype")) {
		r->datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "datatype", &r->datatype));
	}
	if (ejs_pull_null(ejs, v, "parameters")) {
		r->parameters = NULL;
	} else {
		EJS_ALLOC(ejs, r->parameters);
		NDR_CHECK(ejs_pull_string(ejs, v, "parameters", &r->parameters));
	}
	if (ejs_pull_null(ejs, v, "secdesc")) {
		r->secdesc = NULL;
	} else {
		EJS_ALLOC(ejs, r->secdesc);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	NDR_CHECK(ejs_pull_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "defaultpriority", &r->defaultpriority));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "starttime", &r->starttime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "untiltime", &r->untiltime));
	NDR_CHECK(ejs_pull_spoolss_PrinterStatus(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cjobs", &r->cjobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "averageppm", &r->averageppm));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->secdesc) {
		NDR_CHECK(ejs_push_null(ejs, v, "secdesc"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "secdesc")) {
		r->secdesc = NULL;
	} else {
		EJS_ALLOC(ejs, r->secdesc);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->printername) {
		NDR_CHECK(ejs_push_null(ejs, v, "printername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printername", r->printername));
	}
	if (NULL == r->servername) {
		NDR_CHECK(ejs_push_null(ejs, v, "servername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "servername", r->servername));
	}
	NDR_CHECK(ejs_push_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "printername")) {
		r->printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->printername));
	}
	if (ejs_pull_null(ejs, v, "servername")) {
		r->servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->servername));
	}
	NDR_CHECK(ejs_pull_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->printername) {
		NDR_CHECK(ejs_push_null(ejs, v, "printername"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printername", r->printername));
	}
	if (NULL == r->portname) {
		NDR_CHECK(ejs_push_null(ejs, v, "portname"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "portname", r->portname));
	}
	NDR_CHECK(ejs_push_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_push_uint32(ejs, v, "device_not_selected_timeout", &r->device_not_selected_timeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "transmission_retry_timeout", &r->transmission_retry_timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "printername")) {
		r->printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->printername));
	}
	if (ejs_pull_null(ejs, v, "portname")) {
		r->portname = NULL;
	} else {
		EJS_ALLOC(ejs, r->portname);
		NDR_CHECK(ejs_pull_string(ejs, v, "portname", &r->portname));
	}
	NDR_CHECK(ejs_pull_spoolss_PrinterAttributes(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "device_not_selected_timeout", &r->device_not_selected_timeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "transmission_retry_timeout", &r->transmission_retry_timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_PrinterStatus(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_PrinterStatus(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DsPrintAction(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_spoolss_DsPrintAction(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_spoolss_PrinterInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrinterInfo7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->guid) {
		NDR_CHECK(ejs_push_null(ejs, v, "guid"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "guid", r->guid));
	}
	NDR_CHECK(ejs_push_spoolss_DsPrintAction(ejs, v, "action", &r->action));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrinterInfo7 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "guid")) {
		r->guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->guid);
		NDR_CHECK(ejs_pull_string(ejs, v, "guid", &r->guid));
	}
	NDR_CHECK(ejs_pull_spoolss_DsPrintAction(ejs, v, "action", &r->action));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DeviceModeInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DeviceModeInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->devmode) {
		NDR_CHECK(ejs_push_null(ejs, v, "devmode"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DeviceModeInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DeviceModeInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "devmode")) {
		r->devmode = NULL;
	} else {
		EJS_ALLOC(ejs, r->devmode);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_PrinterInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_PrinterInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo0(ejs, v, "info0", &r->info0));
			break;
		case 1:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_push_spoolss_PrinterInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_push_spoolss_DeviceModeInfo(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_push_spoolss_DeviceModeInfo(ejs, v, "info9", &r->info9));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_PrinterInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_PrinterInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo0(ejs, v, "info0", &r->info0));
			break;
		case 1:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_pull_spoolss_PrinterInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_pull_spoolss_DeviceModeInfo(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_pull_spoolss_DeviceModeInfo(ejs, v, "info9", &r->info9));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_spoolss_DevmodeContainer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DevmodeContainer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "devmode")) {
		r->devmode = NULL;
	} else {
		EJS_ALLOC(ejs, r->devmode);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_JobInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_JobInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "job_id", &r->job_id));
	if (NULL == r->printer_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "printer_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "printer_name", r->printer_name));
	}
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	if (NULL == r->user_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "user_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	}
	if (NULL == r->document_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "document_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "document_name", r->document_name));
	}
	if (NULL == r->data_type) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_type"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_type", r->data_type));
	}
	if (NULL == r->text_status) {
		NDR_CHECK(ejs_push_null(ejs, v, "text_status"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "text_status", r->text_status));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_push_uint32(ejs, v, "position", &r->position));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_pages", &r->total_pages));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pages_printed", &r->pages_printed));
	NDR_CHECK(ejs_push_spoolss_Time(ejs, v, "time", &r->time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_JobInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_JobInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_id", &r->job_id));
	if (ejs_pull_null(ejs, v, "printer_name")) {
		r->printer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->printer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "printer_name", &r->printer_name));
	}
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	if (ejs_pull_null(ejs, v, "user_name")) {
		r->user_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->user_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	}
	if (ejs_pull_null(ejs, v, "document_name")) {
		r->document_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->document_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "document_name", &r->document_name));
	}
	if (ejs_pull_null(ejs, v, "data_type")) {
		r->data_type = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_type);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_type", &r->data_type));
	}
	if (ejs_pull_null(ejs, v, "text_status")) {
		r->text_status = NULL;
	} else {
		EJS_ALLOC(ejs, r->text_status);
		NDR_CHECK(ejs_pull_string(ejs, v, "text_status", &r->text_status));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "position", &r->position));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_pages", &r->total_pages));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pages_printed", &r->pages_printed));
	NDR_CHECK(ejs_pull_spoolss_Time(ejs, v, "time", &r->time));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_JobInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_JobInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_JobInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			break;
		case 3:
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_JobInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_JobInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_JobInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			break;
		case 3:
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_spoolss_JobInfoContainer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_JobInfoContainer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->level));
	ejs_set_switch(ejs, r->level);
	NDR_CHECK(ejs_pull_spoolss_JobInfo(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_JobControl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum spoolss_JobControl *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterControl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum spoolss_PrinterControl *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_SetPrinterInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_SetPrinterInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "info0")) {
				r->info0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info0);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "info2")) {
				r->info2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info2);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "info3")) {
				r->info3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info3);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo3(ejs, v, "info3", r->info3));
			}
			break;
		case 4:
			if (ejs_pull_null(ejs, v, "info4")) {
				r->info4 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info4);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo4(ejs, v, "info4", r->info4));
			}
			break;
		case 5:
			if (ejs_pull_null(ejs, v, "info5")) {
				r->info5 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info5);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo5(ejs, v, "info5", r->info5));
			}
			break;
		case 6:
			if (ejs_pull_null(ejs, v, "info6")) {
				r->info6 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info6);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo6(ejs, v, "info6", r->info6));
			}
			break;
		case 7:
			if (ejs_pull_null(ejs, v, "info7")) {
				r->info7 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info7);
				NDR_CHECK(ejs_pull_spoolss_PrinterInfo7(ejs, v, "info7", r->info7));
			}
			break;
		case 8:
			if (ejs_pull_null(ejs, v, "info8")) {
				r->info8 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info8);
				NDR_CHECK(ejs_pull_spoolss_DeviceModeInfo(ejs, v, "info8", r->info8));
			}
			break;
		case 9:
			if (ejs_pull_null(ejs, v, "info9")) {
				r->info9 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info9);
				NDR_CHECK(ejs_pull_spoolss_DeviceModeInfo(ejs, v, "info9", r->info9));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_DriverInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverOSVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum spoolss_DriverOSVersion *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverOSVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum spoolss_DriverOSVersion *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	if (NULL == r->architecture) {
		NDR_CHECK(ejs_push_null(ejs, v, "architecture"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "architecture", r->architecture));
	}
	if (NULL == r->driver_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_path", r->driver_path));
	}
	if (NULL == r->data_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_file", r->data_file));
	}
	if (NULL == r->config_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "config_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "config_file", r->config_file));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->architecture));
	}
	if (ejs_pull_null(ejs, v, "driver_path")) {
		r->driver_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_path", &r->driver_path));
	}
	if (ejs_pull_null(ejs, v, "data_file")) {
		r->data_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_file", &r->data_file));
	}
	if (ejs_pull_null(ejs, v, "config_file")) {
		r->config_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->config_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "config_file", &r->config_file));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	if (NULL == r->architecture) {
		NDR_CHECK(ejs_push_null(ejs, v, "architecture"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "architecture", r->architecture));
	}
	if (NULL == r->driver_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_path", r->driver_path));
	}
	if (NULL == r->data_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_file", r->data_file));
	}
	if (NULL == r->config_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "config_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "config_file", r->config_file));
	}
	if (NULL == r->help_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "help_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "help_file", r->help_file));
	}
	if (NULL == r->dependent_files) {
		NDR_CHECK(ejs_push_null(ejs, v, "dependent_files"));
	} else {
		NDR_CHECK(ejs_push_string_array(ejs, v, "dependent_files", r->dependent_files));
	}
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	if (NULL == r->default_datatype) {
		NDR_CHECK(ejs_push_null(ejs, v, "default_datatype"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "default_datatype", r->default_datatype));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->architecture));
	}
	if (ejs_pull_null(ejs, v, "driver_path")) {
		r->driver_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_path", &r->driver_path));
	}
	if (ejs_pull_null(ejs, v, "data_file")) {
		r->data_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_file", &r->data_file));
	}
	if (ejs_pull_null(ejs, v, "config_file")) {
		r->config_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->config_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "config_file", &r->config_file));
	}
	if (ejs_pull_null(ejs, v, "help_file")) {
		r->help_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->help_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "help_file", &r->help_file));
	}
	if (ejs_pull_null(ejs, v, "dependent_files")) {
		r->dependent_files = NULL;
	} else {
		EJS_ALLOC(ejs, r->dependent_files);
		NDR_CHECK(ejs_pull_string_array(ejs, v, "dependent_files", &r->dependent_files));
	}
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	if (ejs_pull_null(ejs, v, "default_datatype")) {
		r->default_datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->default_datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "default_datatype", &r->default_datatype));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	if (NULL == r->architecture) {
		NDR_CHECK(ejs_push_null(ejs, v, "architecture"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "architecture", r->architecture));
	}
	if (NULL == r->driver_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_path", r->driver_path));
	}
	if (NULL == r->data_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_file", r->data_file));
	}
	if (NULL == r->config_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "config_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "config_file", r->config_file));
	}
	if (NULL == r->help_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "help_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "help_file", r->help_file));
	}
	if (NULL == r->dependent_files) {
		NDR_CHECK(ejs_push_null(ejs, v, "dependent_files"));
	} else {
		NDR_CHECK(ejs_push_string_array(ejs, v, "dependent_files", r->dependent_files));
	}
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	if (NULL == r->default_datatype) {
		NDR_CHECK(ejs_push_null(ejs, v, "default_datatype"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "default_datatype", r->default_datatype));
	}
	if (NULL == r->previous_names) {
		NDR_CHECK(ejs_push_null(ejs, v, "previous_names"));
	} else {
		NDR_CHECK(ejs_push_string_array(ejs, v, "previous_names", r->previous_names));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->architecture));
	}
	if (ejs_pull_null(ejs, v, "driver_path")) {
		r->driver_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_path", &r->driver_path));
	}
	if (ejs_pull_null(ejs, v, "data_file")) {
		r->data_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_file", &r->data_file));
	}
	if (ejs_pull_null(ejs, v, "config_file")) {
		r->config_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->config_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "config_file", &r->config_file));
	}
	if (ejs_pull_null(ejs, v, "help_file")) {
		r->help_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->help_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "help_file", &r->help_file));
	}
	if (ejs_pull_null(ejs, v, "dependent_files")) {
		r->dependent_files = NULL;
	} else {
		EJS_ALLOC(ejs, r->dependent_files);
		NDR_CHECK(ejs_pull_string_array(ejs, v, "dependent_files", &r->dependent_files));
	}
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	if (ejs_pull_null(ejs, v, "default_datatype")) {
		r->default_datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->default_datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "default_datatype", &r->default_datatype));
	}
	if (ejs_pull_null(ejs, v, "previous_names")) {
		r->previous_names = NULL;
	} else {
		EJS_ALLOC(ejs, r->previous_names);
		NDR_CHECK(ejs_pull_string_array(ejs, v, "previous_names", &r->previous_names));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	if (NULL == r->architecture) {
		NDR_CHECK(ejs_push_null(ejs, v, "architecture"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "architecture", r->architecture));
	}
	if (NULL == r->driver_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_path", r->driver_path));
	}
	if (NULL == r->data_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_file", r->data_file));
	}
	if (NULL == r->config_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "config_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "config_file", r->config_file));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "driver_attributes", &r->driver_attributes));
	NDR_CHECK(ejs_push_uint32(ejs, v, "config_version", &r->config_version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "driver_version", &r->driver_version));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->architecture));
	}
	if (ejs_pull_null(ejs, v, "driver_path")) {
		r->driver_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_path", &r->driver_path));
	}
	if (ejs_pull_null(ejs, v, "data_file")) {
		r->data_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_file", &r->data_file));
	}
	if (ejs_pull_null(ejs, v, "config_file")) {
		r->config_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->config_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "config_file", &r->config_file));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "driver_attributes", &r->driver_attributes));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "config_version", &r->config_version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "driver_version", &r->driver_version));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_DriverInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverInfo6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (NULL == r->driver_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_name", r->driver_name));
	}
	if (NULL == r->architecture) {
		NDR_CHECK(ejs_push_null(ejs, v, "architecture"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "architecture", r->architecture));
	}
	if (NULL == r->driver_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "driver_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "driver_path", r->driver_path));
	}
	if (NULL == r->data_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "data_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "data_file", r->data_file));
	}
	if (NULL == r->config_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "config_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "config_file", r->config_file));
	}
	if (NULL == r->help_file) {
		NDR_CHECK(ejs_push_null(ejs, v, "help_file"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "help_file", r->help_file));
	}
	if (NULL == r->dependent_files) {
		NDR_CHECK(ejs_push_null(ejs, v, "dependent_files"));
	} else {
		NDR_CHECK(ejs_push_string_array(ejs, v, "dependent_files", r->dependent_files));
	}
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	if (NULL == r->default_datatype) {
		NDR_CHECK(ejs_push_null(ejs, v, "default_datatype"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "default_datatype", r->default_datatype));
	}
	if (NULL == r->previous_names) {
		NDR_CHECK(ejs_push_null(ejs, v, "previous_names"));
	} else {
		NDR_CHECK(ejs_push_string_array(ejs, v, "previous_names", r->previous_names));
	}
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "driver_data", &r->driver_data));
	NDR_CHECK(ejs_push_hyper(ejs, v, "driver_version", &r->driver_version));
	if (NULL == r->manufacturer_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "manufacturer_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "manufacturer_name", r->manufacturer_name));
	}
	if (NULL == r->manufacturer_url) {
		NDR_CHECK(ejs_push_null(ejs, v, "manufacturer_url"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "manufacturer_url", r->manufacturer_url));
	}
	if (NULL == r->hardware_id) {
		NDR_CHECK(ejs_push_null(ejs, v, "hardware_id"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "hardware_id", r->hardware_id));
	}
	if (NULL == r->provider) {
		NDR_CHECK(ejs_push_null(ejs, v, "provider"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "provider", r->provider));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverInfo6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_DriverOSVersion(ejs, v, "version", &r->version));
	if (ejs_pull_null(ejs, v, "driver_name")) {
		r->driver_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_name", &r->driver_name));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->architecture));
	}
	if (ejs_pull_null(ejs, v, "driver_path")) {
		r->driver_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->driver_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "driver_path", &r->driver_path));
	}
	if (ejs_pull_null(ejs, v, "data_file")) {
		r->data_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->data_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "data_file", &r->data_file));
	}
	if (ejs_pull_null(ejs, v, "config_file")) {
		r->config_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->config_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "config_file", &r->config_file));
	}
	if (ejs_pull_null(ejs, v, "help_file")) {
		r->help_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->help_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "help_file", &r->help_file));
	}
	if (ejs_pull_null(ejs, v, "dependent_files")) {
		r->dependent_files = NULL;
	} else {
		EJS_ALLOC(ejs, r->dependent_files);
		NDR_CHECK(ejs_pull_string_array(ejs, v, "dependent_files", &r->dependent_files));
	}
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	if (ejs_pull_null(ejs, v, "default_datatype")) {
		r->default_datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->default_datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "default_datatype", &r->default_datatype));
	}
	if (ejs_pull_null(ejs, v, "previous_names")) {
		r->previous_names = NULL;
	} else {
		EJS_ALLOC(ejs, r->previous_names);
		NDR_CHECK(ejs_pull_string_array(ejs, v, "previous_names", &r->previous_names));
	}
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "driver_data", &r->driver_data));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "driver_version", &r->driver_version));
	if (ejs_pull_null(ejs, v, "manufacturer_name")) {
		r->manufacturer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->manufacturer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "manufacturer_name", &r->manufacturer_name));
	}
	if (ejs_pull_null(ejs, v, "manufacturer_url")) {
		r->manufacturer_url = NULL;
	} else {
		EJS_ALLOC(ejs, r->manufacturer_url);
		NDR_CHECK(ejs_pull_string(ejs, v, "manufacturer_url", &r->manufacturer_url));
	}
	if (ejs_pull_null(ejs, v, "hardware_id")) {
		r->hardware_id = NULL;
	} else {
		EJS_ALLOC(ejs, r->hardware_id);
		NDR_CHECK(ejs_pull_string(ejs, v, "hardware_id", &r->hardware_id));
	}
	if (ejs_pull_null(ejs, v, "provider")) {
		r->provider = NULL;
	} else {
		EJS_ALLOC(ejs, r->provider);
		NDR_CHECK(ejs_pull_string(ejs, v, "provider", &r->provider));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_DriverInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_DriverInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_DriverInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_spoolss_DriverInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_spoolss_DriverInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_spoolss_DriverInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_spoolss_DriverInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_push_spoolss_DriverInfo6(ejs, v, "info6", &r->info6));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_DriverInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_DriverInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_pull_spoolss_DriverInfo6(ejs, v, "info6", &r->info6));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_DriverDirectoryInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_DriverDirectoryInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "directory_name", r->directory_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DriverDirectoryInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DriverDirectoryInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "directory_name", &r->directory_name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_DriverDirectoryInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_DriverDirectoryInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_DriverDirectoryInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			NDR_CHECK(ejs_push_spoolss_DriverDirectoryInfo1(ejs, v, "info1", &r->info1));
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_DriverDirectoryInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_DriverDirectoryInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_DriverDirectoryInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			NDR_CHECK(ejs_pull_spoolss_DriverDirectoryInfo1(ejs, v, "info1", &r->info1));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_PrintProcessorInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PrintProcessorInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->print_processor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "print_processor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "print_processor_name", r->print_processor_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrintProcessorInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PrintProcessorInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "print_processor_name")) {
		r->print_processor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->print_processor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "print_processor_name", &r->print_processor_name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_PrintProcessorInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_PrintProcessorInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_PrintProcessorInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_PrintProcessorInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_PrintProcessorInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_PrintProcessorInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_spoolss_DocumentInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_DocumentInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "document_name")) {
		r->document_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->document_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "document_name", &r->document_name));
	}
	if (ejs_pull_null(ejs, v, "output_file")) {
		r->output_file = NULL;
	} else {
		EJS_ALLOC(ejs, r->output_file);
		NDR_CHECK(ejs_pull_string(ejs, v, "output_file", &r->output_file));
	}
	if (ejs_pull_null(ejs, v, "datatype")) {
		r->datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "datatype", &r->datatype));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_DocumentInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_DocumentInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_spoolss_DocumentInfo1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			break;
		case 3:
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_spoolss_OSVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_OSVersion *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_ndr_size", &r->_ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "major", &r->major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minor", &r->minor));
	NDR_CHECK(ejs_push_uint32(ejs, v, "build", &r->build));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_spoolss_OSVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_OSVersion *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "major", &r->major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minor", &r->minor));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "build", &r->build));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_OSVersionEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_OSVersionEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_ndr_size", &r->_ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "major", &r->major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minor", &r->minor));
	NDR_CHECK(ejs_push_uint32(ejs, v, "build", &r->build));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_spoolss_OSVersionEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_OSVersionEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "major", &r->major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minor", &r->minor));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "build", &r->build));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown3", &r->unknown3));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PrinterDataType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum spoolss_PrinterDataType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PrinterDataType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum spoolss_PrinterDataType *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_PrinterData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_PrinterData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SPOOLSS_PRINTER_DATA_TYPE_NULL:
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_STRING:
			NDR_CHECK(ejs_push_string(ejs, v, "string", r->string));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_BINARY:
			NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "binary", &r->binary));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_UINT32:
			NDR_CHECK(ejs_push_uint32(ejs, v, "value", &r->value));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY:
			NDR_CHECK(ejs_push_string_array(ejs, v, "string_array", r->string_array));
			break;
		default:
			NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "data", &r->data));
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_PrinterData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_PrinterData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SPOOLSS_PRINTER_DATA_TYPE_NULL:
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_STRING:
			NDR_CHECK(ejs_pull_string(ejs, v, "string", &r->string));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_BINARY:
			NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "binary", &r->binary));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_UINT32:
			NDR_CHECK(ejs_pull_uint32(ejs, v, "value", &r->value));
			break;
		case SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY:
			NDR_CHECK(ejs_pull_string_array(ejs, v, "string_array", &r->string_array));
			break;
		default:
			NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "data", &r->data));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_FormFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum spoolss_FormFlags *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_FormFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum spoolss_FormFlags *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_FormSize(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_FormSize *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "width", &r->width));
	NDR_CHECK(ejs_push_uint32(ejs, v, "height", &r->height));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_FormSize(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_FormSize *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "width", &r->width));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "height", &r->height));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_FormArea(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_FormArea *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "left", &r->left));
	NDR_CHECK(ejs_push_uint32(ejs, v, "top", &r->top));
	NDR_CHECK(ejs_push_uint32(ejs, v, "right", &r->right));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bottom", &r->bottom));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_FormArea(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_FormArea *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "left", &r->left));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "top", &r->top));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "right", &r->right));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bottom", &r->bottom));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_FormInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_FormInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_spoolss_FormFlags(ejs, v, "flags", &r->flags));
	if (NULL == r->form_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "form_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "form_name", r->form_name));
	}
	NDR_CHECK(ejs_push_spoolss_FormSize(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_spoolss_FormArea(ejs, v, "area", &r->area));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_FormInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_FormInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_FormFlags(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "form_name")) {
		r->form_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->form_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "form_name", &r->form_name));
	}
	NDR_CHECK(ejs_pull_spoolss_FormSize(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_spoolss_FormArea(ejs, v, "area", &r->area));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_FormInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_FormInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_FormInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_FormInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_FormInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_FormInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_spoolss_AddFormInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_AddFormInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_spoolss_FormFlags(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "form_name")) {
		r->form_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->form_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "form_name", &r->form_name));
	}
	NDR_CHECK(ejs_pull_spoolss_FormSize(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_spoolss_FormArea(ejs, v, "area", &r->area));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_AddFormInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_AddFormInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_spoolss_AddFormInfo1(ejs, v, "info1", r->info1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_PortInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PortInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->port_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "port_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "port_name", r->port_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PortInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PortInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "port_name")) {
		r->port_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->port_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "port_name", &r->port_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_PortType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_spoolss_PortType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_spoolss_PortInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_PortInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->port_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "port_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "port_name", r->port_name));
	}
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	if (NULL == r->description) {
		NDR_CHECK(ejs_push_null(ejs, v, "description"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "description", r->description));
	}
	NDR_CHECK(ejs_push_spoolss_PortType(ejs, v, "port_type", &r->port_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_PortInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_PortInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "port_name")) {
		r->port_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->port_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "port_name", &r->port_name));
	}
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	if (ejs_pull_null(ejs, v, "description")) {
		r->description = NULL;
	} else {
		EJS_ALLOC(ejs, r->description);
		NDR_CHECK(ejs_pull_string(ejs, v, "description", &r->description));
	}
	NDR_CHECK(ejs_pull_spoolss_PortType(ejs, v, "port_type", &r->port_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_PortInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_PortInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_PortInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_spoolss_PortInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_PortInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_PortInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_PortInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_spoolss_PortInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_spoolss_MonitorInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_MonitorInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_MonitorInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_MonitorInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_spoolss_MonitorInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct spoolss_MonitorInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->monitor_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "monitor_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "monitor_name", r->monitor_name));
	}
	if (NULL == r->environment) {
		NDR_CHECK(ejs_push_null(ejs, v, "environment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "environment", r->environment));
	}
	if (NULL == r->dll_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dll_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dll_name", r->dll_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_MonitorInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_MonitorInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "monitor_name")) {
		r->monitor_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->monitor_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->monitor_name));
	}
	if (ejs_pull_null(ejs, v, "environment")) {
		r->environment = NULL;
	} else {
		EJS_ALLOC(ejs, r->environment);
		NDR_CHECK(ejs_pull_string(ejs, v, "environment", &r->environment));
	}
	if (ejs_pull_null(ejs, v, "dll_name")) {
		r->dll_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->dll_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "dll_name", &r->dll_name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_spoolss_MonitorInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union spoolss_MonitorInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_spoolss_MonitorInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_spoolss_MonitorInfo2(ejs, v, "info2", &r->info2));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_spoolss_MonitorInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_MonitorInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_spoolss_MonitorInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_spoolss_MonitorInfo2(ejs, v, "info2", &r->info2));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u3", &r->u3));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u4", &r->u4));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "t2")) {
		r->t2 = NULL;
	} else {
		EJS_ALLOC(ejs, r->t2);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->t2, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "t2", i);
				NDR_CHECK(ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2(ejs, v, id, &r->t2[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "t2" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_UserLevel1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct spoolss_UserLevel1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "build", &r->build));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "major", &r->major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minor", &r->minor));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "processor", &r->processor));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_UserLevel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union spoolss_UserLevel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "level1")) {
				r->level1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->level1);
				NDR_CHECK(ejs_pull_spoolss_UserLevel1(ejs, v, "level1", r->level1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_spoolss_EnumPrinters(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrinters *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_spoolss_EnumPrinterFlags(ejs, v, "flags", &r->in.flags));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrinters(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrinters *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_PrinterInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrinters(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTERS, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrinters, (ejs_push_function_t)ejs_push_spoolss_EnumPrinters);
}


static NTSTATUS ejs_pull_spoolss_OpenPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_OpenPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "printername")) {
		r->in.printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->in.printername));
	}
	if (ejs_pull_null(ejs, v, "datatype")) {
		r->in.datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "datatype", &r->in.datatype));
	}
	NDR_CHECK(ejs_pull_spoolss_DevmodeContainer(ejs, v, "devmode_ctr", &r->in.devmode_ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_OpenPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_OpenPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_OpenPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_OPENPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_OpenPrinter, (ejs_push_function_t)ejs_push_spoolss_OpenPrinter);
}


static NTSTATUS ejs_pull_spoolss_SetJob(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SetJob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_id", &r->in.job_id));
	if (ejs_pull_null(ejs, v, "ctr")) {
		r->in.ctr = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.ctr);
		NDR_CHECK(ejs_pull_spoolss_JobInfoContainer(ejs, v, "ctr", r->in.ctr));
	}
	NDR_CHECK(ejs_pull_spoolss_JobControl(ejs, v, "command", &r->in.command));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SetJob(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SetJob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SetJob(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SETJOB, (ejs_pull_function_t)ejs_pull_spoolss_SetJob, (ejs_push_function_t)ejs_push_spoolss_SetJob);
}


static NTSTATUS ejs_pull_spoolss_GetJob(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetJob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "job_id", &r->in.job_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetJob(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetJob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetJob(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETJOB, (ejs_pull_function_t)ejs_pull_spoolss_GetJob, (ejs_push_function_t)ejs_push_spoolss_GetJob);
}


static NTSTATUS ejs_pull_spoolss_EnumJobs(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumJobs *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "firstjob", &r->in.firstjob));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numjobs", &r->in.numjobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumJobs(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumJobs *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_JobInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumJobs(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMJOBS, (ejs_pull_function_t)ejs_pull_spoolss_EnumJobs, (ejs_push_function_t)ejs_push_spoolss_EnumJobs);
}


static NTSTATUS ejs_pull_spoolss_AddPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_AddPrinter, (ejs_push_function_t)ejs_push_spoolss_AddPrinter);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinter, (ejs_push_function_t)ejs_push_spoolss_DeletePrinter);
}


static NTSTATUS ejs_pull_spoolss_SetPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SetPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_spoolss_SetPrinterInfo(ejs, v, "info", &r->in.info));
	NDR_CHECK(ejs_pull_spoolss_DevmodeContainer(ejs, v, "devmode_ctr", &r->in.devmode_ctr));
	NDR_CHECK(ejs_pull_sec_desc_buf(ejs, v, "secdesc_ctr", &r->in.secdesc_ctr));
	NDR_CHECK(ejs_pull_spoolss_PrinterControl(ejs, v, "command", &r->in.command));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SetPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SetPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SetPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SETPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_SetPrinter, (ejs_push_function_t)ejs_push_spoolss_SetPrinter);
}


static NTSTATUS ejs_pull_spoolss_GetPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinter, (ejs_push_function_t)ejs_push_spoolss_GetPrinter);
}


static NTSTATUS ejs_pull_spoolss_AddPrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrinterDriver *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrinterDriver *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrinterDriver(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTERDRIVER, (ejs_pull_function_t)ejs_pull_spoolss_AddPrinterDriver, (ejs_push_function_t)ejs_push_spoolss_AddPrinterDriver);
}


static NTSTATUS ejs_pull_spoolss_EnumPrinterDrivers(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrinterDrivers *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	if (ejs_pull_null(ejs, v, "environment")) {
		r->in.environment = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.environment);
		NDR_CHECK(ejs_pull_string(ejs, v, "environment", &r->in.environment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrinterDrivers(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrinterDrivers *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_DriverInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrinterDrivers(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTERDRIVERS, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrinterDrivers, (ejs_push_function_t)ejs_push_spoolss_EnumPrinterDrivers);
}


static NTSTATUS ejs_pull_spoolss_GetPrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinterDriver *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinterDriver *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinterDriver(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTERDRIVER, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinterDriver, (ejs_push_function_t)ejs_push_spoolss_GetPrinterDriver);
}


static NTSTATUS ejs_pull_spoolss_GetPrinterDriverDirectory(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinterDriverDirectory *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	if (ejs_pull_null(ejs, v, "environment")) {
		r->in.environment = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.environment);
		NDR_CHECK(ejs_pull_string(ejs, v, "environment", &r->in.environment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinterDriverDirectory(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinterDriverDirectory *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinterDriverDirectory(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTERDRIVERDIRECTORY, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinterDriverDirectory, (ejs_push_function_t)ejs_push_spoolss_GetPrinterDriverDirectory);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterDriver *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->in.architecture));
	NDR_CHECK(ejs_pull_string(ejs, v, "driver", &r->in.driver));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterDriver(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterDriver *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterDriver(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERDRIVER, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterDriver, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterDriver);
}


static NTSTATUS ejs_pull_spoolss_AddPrintProcessor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrintProcessor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrintProcessor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrintProcessor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrintProcessor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTPROCESSOR, (ejs_pull_function_t)ejs_pull_spoolss_AddPrintProcessor, (ejs_push_function_t)ejs_push_spoolss_AddPrintProcessor);
}


static NTSTATUS ejs_pull_spoolss_EnumPrintProcessors(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrintProcessors *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "environment")) {
		r->in.environment = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.environment);
		NDR_CHECK(ejs_pull_string(ejs, v, "environment", &r->in.environment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrintProcessors(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrintProcessors *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_PrintProcessorInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrintProcessors(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTPROCESSORS, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrintProcessors, (ejs_push_function_t)ejs_push_spoolss_EnumPrintProcessors);
}


static NTSTATUS ejs_pull_spoolss_GetPrintProcessorDirectory(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrintProcessorDirectory *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrintProcessorDirectory(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrintProcessorDirectory *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrintProcessorDirectory(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTPROCESSORDIRECTORY, (ejs_pull_function_t)ejs_pull_spoolss_GetPrintProcessorDirectory, (ejs_push_function_t)ejs_push_spoolss_GetPrintProcessorDirectory);
}


static NTSTATUS ejs_pull_spoolss_StartDocPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_StartDocPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_spoolss_DocumentInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_StartDocPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_StartDocPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "job_id", &r->out.job_id));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_StartDocPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_STARTDOCPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_StartDocPrinter, (ejs_push_function_t)ejs_push_spoolss_StartDocPrinter);
}


static NTSTATUS ejs_pull_spoolss_StartPagePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_StartPagePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_StartPagePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_StartPagePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_StartPagePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_STARTPAGEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_StartPagePrinter, (ejs_push_function_t)ejs_push_spoolss_StartPagePrinter);
}


static NTSTATUS ejs_pull_spoolss_WritePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_WritePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "data", &r->in.data));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_WritePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_WritePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_written", &r->out.num_written));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_WritePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_WRITEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_WritePrinter, (ejs_push_function_t)ejs_push_spoolss_WritePrinter);
}


static NTSTATUS ejs_pull_spoolss_EndPagePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EndPagePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EndPagePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EndPagePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EndPagePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENDPAGEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_EndPagePrinter, (ejs_push_function_t)ejs_push_spoolss_EndPagePrinter);
}


static NTSTATUS ejs_pull_spoolss_AbortPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AbortPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AbortPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AbortPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AbortPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ABORTPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_AbortPrinter, (ejs_push_function_t)ejs_push_spoolss_AbortPrinter);
}


static NTSTATUS ejs_pull_spoolss_ReadPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ReadPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "data_size", &r->in.data_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ReadPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ReadPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "data", &r->out.data));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_data_size", &r->out._data_size));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ReadPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_READPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_ReadPrinter, (ejs_push_function_t)ejs_push_spoolss_ReadPrinter);
}


static NTSTATUS ejs_pull_spoolss_EndDocPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EndDocPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EndDocPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EndDocPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EndDocPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENDDOCPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_EndDocPrinter, (ejs_push_function_t)ejs_push_spoolss_EndDocPrinter);
}


static NTSTATUS ejs_pull_spoolss_AddJob(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddJob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddJob(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddJob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddJob(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDJOB, (ejs_pull_function_t)ejs_pull_spoolss_AddJob, (ejs_push_function_t)ejs_push_spoolss_AddJob);
}


static NTSTATUS ejs_pull_spoolss_ScheduleJob(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ScheduleJob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ScheduleJob(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ScheduleJob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ScheduleJob(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SCHEDULEJOB, (ejs_pull_function_t)ejs_pull_spoolss_ScheduleJob, (ejs_push_function_t)ejs_push_spoolss_ScheduleJob);
}


static NTSTATUS ejs_pull_spoolss_GetPrinterData(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinterData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinterData(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinterData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_spoolss_PrinterDataType(ejs, v, "type", &r->out.type));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinterData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTERDATA, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinterData, (ejs_push_function_t)ejs_push_spoolss_GetPrinterData);
}


static NTSTATUS ejs_pull_spoolss_SetPrinterData(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SetPrinterData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	NDR_CHECK(ejs_pull_spoolss_PrinterDataType(ejs, v, "type", &r->in.type));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SetPrinterData(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SetPrinterData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SetPrinterData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SETPRINTERDATA, (ejs_pull_function_t)ejs_pull_spoolss_SetPrinterData, (ejs_push_function_t)ejs_push_spoolss_SetPrinterData);
}


static NTSTATUS ejs_pull_spoolss_WaitForPrinterChange(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_WaitForPrinterChange *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_WaitForPrinterChange(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_WaitForPrinterChange *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_WaitForPrinterChange(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_WAITFORPRINTERCHANGE, (ejs_pull_function_t)ejs_pull_spoolss_WaitForPrinterChange, (ejs_push_function_t)ejs_push_spoolss_WaitForPrinterChange);
}


static NTSTATUS ejs_pull_spoolss_ClosePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ClosePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ClosePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ClosePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ClosePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_CLOSEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_ClosePrinter, (ejs_push_function_t)ejs_push_spoolss_ClosePrinter);
}


static NTSTATUS ejs_pull_spoolss_AddForm(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddForm *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_spoolss_AddFormInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddForm(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddForm *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddForm(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDFORM, (ejs_pull_function_t)ejs_pull_spoolss_AddForm, (ejs_push_function_t)ejs_push_spoolss_AddForm);
}


static NTSTATUS ejs_pull_spoolss_DeleteForm(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeleteForm *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "form_name", &r->in.form_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeleteForm(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeleteForm *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeleteForm(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEFORM, (ejs_pull_function_t)ejs_pull_spoolss_DeleteForm, (ejs_push_function_t)ejs_push_spoolss_DeleteForm);
}


static NTSTATUS ejs_pull_spoolss_GetForm(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetForm *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "form_name", &r->in.form_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetForm(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetForm *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetForm(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETFORM, (ejs_pull_function_t)ejs_pull_spoolss_GetForm, (ejs_push_function_t)ejs_push_spoolss_GetForm);
}


static NTSTATUS ejs_pull_spoolss_SetForm(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SetForm *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "form_name", &r->in.form_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_spoolss_AddFormInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SetForm(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SetForm *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SetForm(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SETFORM, (ejs_pull_function_t)ejs_pull_spoolss_SetForm, (ejs_push_function_t)ejs_push_spoolss_SetForm);
}


static NTSTATUS ejs_pull_spoolss_EnumForms(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumForms *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumForms(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumForms *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_FormInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumForms(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMFORMS, (ejs_pull_function_t)ejs_pull_spoolss_EnumForms, (ejs_push_function_t)ejs_push_spoolss_EnumForms);
}


static NTSTATUS ejs_pull_spoolss_EnumPorts(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPorts *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPorts(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPorts *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_PortInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPorts(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPORTS, (ejs_pull_function_t)ejs_pull_spoolss_EnumPorts, (ejs_push_function_t)ejs_push_spoolss_EnumPorts);
}


static NTSTATUS ejs_pull_spoolss_EnumMonitors(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumMonitors *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumMonitors(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumMonitors *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info", i);
				ejs_set_switch(ejs, r->in.level);
				NDR_CHECK(ejs_push_spoolss_MonitorInfo(ejs, v, id, &r->out.info[i]));
			}
			ejs_push_uint32(ejs, v, "info" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumMonitors(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMMONITORS, (ejs_pull_function_t)ejs_pull_spoolss_EnumMonitors, (ejs_push_function_t)ejs_push_spoolss_EnumMonitors);
}


static NTSTATUS ejs_pull_spoolss_AddPort(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPort *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	NDR_CHECK(ejs_pull_string(ejs, v, "monitor_name", &r->in.monitor_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPort(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPort *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPort(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPORT, (ejs_pull_function_t)ejs_pull_spoolss_AddPort, (ejs_push_function_t)ejs_push_spoolss_AddPort);
}


static NTSTATUS ejs_pull_spoolss_ConfigurePort(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ConfigurePort *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ConfigurePort(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ConfigurePort *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ConfigurePort(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_CONFIGUREPORT, (ejs_pull_function_t)ejs_pull_spoolss_ConfigurePort, (ejs_push_function_t)ejs_push_spoolss_ConfigurePort);
}


static NTSTATUS ejs_pull_spoolss_DeletePort(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePort *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePort(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePort *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePort(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPORT, (ejs_pull_function_t)ejs_pull_spoolss_DeletePort, (ejs_push_function_t)ejs_push_spoolss_DeletePort);
}


static NTSTATUS ejs_pull_spoolss_CreatePrinterIC(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_CreatePrinterIC *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_CreatePrinterIC(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_CreatePrinterIC *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_CreatePrinterIC(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_CREATEPRINTERIC, (ejs_pull_function_t)ejs_pull_spoolss_CreatePrinterIC, (ejs_push_function_t)ejs_push_spoolss_CreatePrinterIC);
}


static NTSTATUS ejs_pull_spoolss_PlayGDIScriptOnPrinterIC(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_PlayGDIScriptOnPrinterIC *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_PlayGDIScriptOnPrinterIC(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_PlayGDIScriptOnPrinterIC *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_PlayGDIScriptOnPrinterIC(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_PLAYGDISCRIPTONPRINTERIC, (ejs_pull_function_t)ejs_pull_spoolss_PlayGDIScriptOnPrinterIC, (ejs_push_function_t)ejs_push_spoolss_PlayGDIScriptOnPrinterIC);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterIC(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterIC *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterIC(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterIC *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterIC(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERIC, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterIC, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterIC);
}


static NTSTATUS ejs_pull_spoolss_AddPrinterConnection(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrinterConnection *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrinterConnection(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrinterConnection *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrinterConnection(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTERCONNECTION, (ejs_pull_function_t)ejs_pull_spoolss_AddPrinterConnection, (ejs_push_function_t)ejs_push_spoolss_AddPrinterConnection);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterConnection(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterConnection *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterConnection(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterConnection *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterConnection(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERCONNECTION, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterConnection, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterConnection);
}


static NTSTATUS ejs_pull_spoolss_PrinterMessageBox(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_PrinterMessageBox *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_PrinterMessageBox(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_PrinterMessageBox *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_PrinterMessageBox(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_PRINTERMESSAGEBOX, (ejs_pull_function_t)ejs_pull_spoolss_PrinterMessageBox, (ejs_push_function_t)ejs_push_spoolss_PrinterMessageBox);
}


static NTSTATUS ejs_pull_spoolss_AddMonitor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddMonitor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddMonitor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddMonitor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddMonitor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDMONITOR, (ejs_pull_function_t)ejs_pull_spoolss_AddMonitor, (ejs_push_function_t)ejs_push_spoolss_AddMonitor);
}


static NTSTATUS ejs_pull_spoolss_DeleteMonitor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeleteMonitor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeleteMonitor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeleteMonitor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeleteMonitor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEMONITOR, (ejs_pull_function_t)ejs_pull_spoolss_DeleteMonitor, (ejs_push_function_t)ejs_push_spoolss_DeleteMonitor);
}


static NTSTATUS ejs_pull_spoolss_DeletePrintProcessor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrintProcessor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrintProcessor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrintProcessor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrintProcessor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTPROCESSOR, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrintProcessor, (ejs_push_function_t)ejs_push_spoolss_DeletePrintProcessor);
}


static NTSTATUS ejs_pull_spoolss_AddPrintProvidor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrintProvidor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrintProvidor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrintProvidor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrintProvidor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTPROVIDOR, (ejs_pull_function_t)ejs_pull_spoolss_AddPrintProvidor, (ejs_push_function_t)ejs_push_spoolss_AddPrintProvidor);
}


static NTSTATUS ejs_pull_spoolss_DeletePrintProvidor(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrintProvidor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrintProvidor(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrintProvidor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrintProvidor(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTPROVIDOR, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrintProvidor, (ejs_push_function_t)ejs_push_spoolss_DeletePrintProvidor);
}


static NTSTATUS ejs_pull_spoolss_EnumPrintProcDataTypes(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrintProcDataTypes *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrintProcDataTypes(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrintProcDataTypes *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrintProcDataTypes(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTPROCDATATYPES, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrintProcDataTypes, (ejs_push_function_t)ejs_push_spoolss_EnumPrintProcDataTypes);
}


static NTSTATUS ejs_pull_spoolss_ResetPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ResetPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ResetPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ResetPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ResetPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_RESETPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_ResetPrinter, (ejs_push_function_t)ejs_push_spoolss_ResetPrinter);
}


static NTSTATUS ejs_pull_spoolss_GetPrinterDriver2(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinterDriver2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "architecture")) {
		r->in.architecture = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.architecture);
		NDR_CHECK(ejs_pull_string(ejs, v, "architecture", &r->in.architecture));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->in.buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.buffer);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", r->in.buffer));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "client_major_version", &r->in.client_major_version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "client_minor_version", &r->in.client_minor_version));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinterDriver2(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinterDriver2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "server_major_version", &r->out.server_major_version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "server_minor_version", &r->out.server_minor_version));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinterDriver2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTERDRIVER2, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinterDriver2, (ejs_push_function_t)ejs_push_spoolss_GetPrinterDriver2);
}


static NTSTATUS ejs_pull_spoolss_FindFirstPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_FindFirstPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_FindFirstPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_FindFirstPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_FindFirstPrinterChangeNotification(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_FINDFIRSTPRINTERCHANGENOTIFICATION, (ejs_pull_function_t)ejs_pull_spoolss_FindFirstPrinterChangeNotification, (ejs_push_function_t)ejs_push_spoolss_FindFirstPrinterChangeNotification);
}


static NTSTATUS ejs_pull_spoolss_FindNextPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_FindNextPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_FindNextPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_FindNextPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_FindNextPrinterChangeNotification(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_FINDNEXTPRINTERCHANGENOTIFICATION, (ejs_pull_function_t)ejs_pull_spoolss_FindNextPrinterChangeNotification, (ejs_push_function_t)ejs_push_spoolss_FindNextPrinterChangeNotification);
}


static NTSTATUS ejs_pull_spoolss_FindClosePrinterNotify(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_FindClosePrinterNotify *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_FindClosePrinterNotify(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_FindClosePrinterNotify *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_FindClosePrinterNotify(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_FINDCLOSEPRINTERNOTIFY, (ejs_pull_function_t)ejs_pull_spoolss_FindClosePrinterNotify, (ejs_push_function_t)ejs_push_spoolss_FindClosePrinterNotify);
}


static NTSTATUS ejs_pull_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RouterFindFirstPrinterChangeNotificationOld(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATIONOLD, (ejs_pull_function_t)ejs_pull_spoolss_RouterFindFirstPrinterChangeNotificationOld, (ejs_push_function_t)ejs_push_spoolss_RouterFindFirstPrinterChangeNotificationOld);
}


static NTSTATUS ejs_pull_spoolss_ReplyOpenPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ReplyOpenPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ReplyOpenPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ReplyOpenPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ReplyOpenPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_REPLYOPENPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_ReplyOpenPrinter, (ejs_push_function_t)ejs_push_spoolss_ReplyOpenPrinter);
}


static NTSTATUS ejs_pull_spoolss_RouterReplyPrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RouterReplyPrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RouterReplyPrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RouterReplyPrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RouterReplyPrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ROUTERREPLYPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_RouterReplyPrinter, (ejs_push_function_t)ejs_push_spoolss_RouterReplyPrinter);
}


static NTSTATUS ejs_pull_spoolss_ReplyClosePrinter(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ReplyClosePrinter *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ReplyClosePrinter(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ReplyClosePrinter *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ReplyClosePrinter(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_REPLYCLOSEPRINTER, (ejs_pull_function_t)ejs_pull_spoolss_ReplyClosePrinter, (ejs_push_function_t)ejs_push_spoolss_ReplyClosePrinter);
}


static NTSTATUS ejs_pull_spoolss_AddPortEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPortEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPortEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPortEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPortEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPORTEX, (ejs_pull_function_t)ejs_pull_spoolss_AddPortEx, (ejs_push_function_t)ejs_push_spoolss_AddPortEx);
}


static NTSTATUS ejs_pull_spoolss_RouterFindFirstPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RouterFindFirstPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RouterFindFirstPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RouterFindFirstPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RouterFindFirstPrinterChangeNotification(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATION, (ejs_pull_function_t)ejs_pull_spoolss_RouterFindFirstPrinterChangeNotification, (ejs_push_function_t)ejs_push_spoolss_RouterFindFirstPrinterChangeNotification);
}


static NTSTATUS ejs_pull_spoolss_SpoolerInit(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SpoolerInit *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SpoolerInit(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SpoolerInit *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SpoolerInit(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SPOOLERINIT, (ejs_pull_function_t)ejs_pull_spoolss_SpoolerInit, (ejs_push_function_t)ejs_push_spoolss_SpoolerInit);
}


static NTSTATUS ejs_pull_spoolss_ResetPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_ResetPrinterEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_ResetPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_ResetPrinterEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_ResetPrinterEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_RESETPRINTEREX, (ejs_pull_function_t)ejs_pull_spoolss_ResetPrinterEx, (ejs_push_function_t)ejs_push_spoolss_ResetPrinterEx);
}


static NTSTATUS ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u1", &r->in.u1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u2", &r->in.u2));
	if (ejs_pull_null(ejs, v, "str")) {
		r->in.str = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.str);
		NDR_CHECK(ejs_pull_string(ejs, v, "str", &r->in.str));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u3", &r->in.u3));
	if (ejs_pull_null(ejs, v, "t1")) {
		r->in.t1 = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.t1);
		NDR_CHECK(ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1(ejs, v, "t1", r->in.t1));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RemoteFindFirstPrinterChangeNotifyEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX, (ejs_pull_function_t)ejs_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx, (ejs_push_function_t)ejs_push_spoolss_RemoteFindFirstPrinterChangeNotifyEx);
}


static NTSTATUS ejs_pull_spoolss_RouterRefreshPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RouterRefreshPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RouterRefreshPrinterChangeNotification(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RouterRefreshPrinterChangeNotification *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RouterRefreshPrinterChangeNotification(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFICATION, (ejs_pull_function_t)ejs_pull_spoolss_RouterRefreshPrinterChangeNotification, (ejs_push_function_t)ejs_push_spoolss_RouterRefreshPrinterChangeNotification);
}


static NTSTATUS ejs_pull_spoolss_RemoteFindNextPrinterChangeNotifyEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_RemoteFindNextPrinterChangeNotifyEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_RemoteFindNextPrinterChangeNotifyEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_RemoteFindNextPrinterChangeNotifyEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_RemoteFindNextPrinterChangeNotifyEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_REMOTEFINDNEXTPRINTERCHANGENOTIFYEX, (ejs_pull_function_t)ejs_pull_spoolss_RemoteFindNextPrinterChangeNotifyEx, (ejs_push_function_t)ejs_push_spoolss_RemoteFindNextPrinterChangeNotifyEx);
}


static NTSTATUS ejs_pull_spoolss_44(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_44 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_44(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_44 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_44(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_44, (ejs_pull_function_t)ejs_pull_spoolss_44, (ejs_push_function_t)ejs_push_spoolss_44);
}


static NTSTATUS ejs_pull_spoolss_OpenPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_OpenPrinterEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "printername")) {
		r->in.printername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.printername);
		NDR_CHECK(ejs_pull_string(ejs, v, "printername", &r->in.printername));
	}
	if (ejs_pull_null(ejs, v, "datatype")) {
		r->in.datatype = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.datatype);
		NDR_CHECK(ejs_pull_string(ejs, v, "datatype", &r->in.datatype));
	}
	NDR_CHECK(ejs_pull_spoolss_DevmodeContainer(ejs, v, "devmode_ctr", &r->in.devmode_ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_spoolss_UserLevel(ejs, v, "userlevel", &r->in.userlevel));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_OpenPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_OpenPrinterEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_OpenPrinterEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_OPENPRINTEREX, (ejs_pull_function_t)ejs_pull_spoolss_OpenPrinterEx, (ejs_push_function_t)ejs_push_spoolss_OpenPrinterEx);
}


static NTSTATUS ejs_pull_spoolss_AddPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrinterEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_spoolss_PrinterInfo(ejs, v, "info", r->in.info));
	}
	NDR_CHECK(ejs_pull_spoolss_DevmodeContainer(ejs, v, "devmode_ctr", &r->in.devmode_ctr));
	if (ejs_pull_null(ejs, v, "secdesc")) {
		r->in.secdesc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.secdesc);
		NDR_CHECK(ejs_pull_security_descriptor(ejs, v, "secdesc", r->in.secdesc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ulevel", &r->in.ulevel));
	ejs_set_switch(ejs, r->in.ulevel);
	NDR_CHECK(ejs_pull_spoolss_UserLevel(ejs, v, "userlevel", &r->in.userlevel));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrinterEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrinterEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrinterEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTEREX, (ejs_pull_function_t)ejs_pull_spoolss_AddPrinterEx, (ejs_push_function_t)ejs_push_spoolss_AddPrinterEx);
}


static NTSTATUS ejs_pull_spoolss_47(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_47 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_47(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_47 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_47(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_47, (ejs_pull_function_t)ejs_pull_spoolss_47, (ejs_push_function_t)ejs_push_spoolss_47);
}


static NTSTATUS ejs_pull_spoolss_EnumPrinterData(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrinterData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enum_index", &r->in.enum_index));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "value_offered", &r->in.value_offered));
	if (ejs_pull_null(ejs, v, "data_size")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.data_size);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "data_size", r->in.data_size));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrinterData(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrinterData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_string(ejs, v, "value_name", r->out.value_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "value_needed", &r->out.value_needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "printerdata_type", &r->out.printerdata_type));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "buffer", &r->out.buffer));
	if (NULL == r->out.data_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "data_size", r->out.data_size));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrinterData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTERDATA, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrinterData, (ejs_push_function_t)ejs_push_spoolss_EnumPrinterData);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterData(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterData(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERDATA, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterData, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterData);
}


static NTSTATUS ejs_pull_spoolss_4a(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_4a *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_4a(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_4a *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_4a(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_4A, (ejs_pull_function_t)ejs_pull_spoolss_4a, (ejs_push_function_t)ejs_push_spoolss_4a);
}


static NTSTATUS ejs_pull_spoolss_4b(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_4b *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_4b(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_4b *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_4b(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_4B, (ejs_pull_function_t)ejs_pull_spoolss_4b, (ejs_push_function_t)ejs_push_spoolss_4b);
}


static NTSTATUS ejs_pull_spoolss_4c(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_4c *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_4c(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_4c *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_4c(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_4C, (ejs_pull_function_t)ejs_pull_spoolss_4c, (ejs_push_function_t)ejs_push_spoolss_4c);
}


static NTSTATUS ejs_pull_spoolss_SetPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_SetPrinterDataEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "key_name", &r->in.key_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->in.type));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "buffer", &r->in.buffer));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_SetPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_SetPrinterDataEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_SetPrinterDataEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_SETPRINTERDATAEX, (ejs_pull_function_t)ejs_pull_spoolss_SetPrinterDataEx, (ejs_push_function_t)ejs_push_spoolss_SetPrinterDataEx);
}


static NTSTATUS ejs_pull_spoolss_GetPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_GetPrinterDataEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "key_name", &r->in.key_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_GetPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_GetPrinterDataEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->out.type));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "buffer", &r->out.buffer));
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_GetPrinterDataEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_GETPRINTERDATAEX, (ejs_pull_function_t)ejs_pull_spoolss_GetPrinterDataEx, (ejs_push_function_t)ejs_push_spoolss_GetPrinterDataEx);
}


static NTSTATUS ejs_pull_spoolss_EnumPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrinterDataEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "key_name", &r->in.key_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrinterDataEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "buffer", &r->out.buffer));
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrinterDataEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTERDATAEX, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrinterDataEx, (ejs_push_function_t)ejs_push_spoolss_EnumPrinterDataEx);
}


static NTSTATUS ejs_pull_spoolss_EnumPrinterKey(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_EnumPrinterKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_EnumPrinterKey(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_EnumPrinterKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_EnumPrinterKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ENUMPRINTERKEY, (ejs_pull_function_t)ejs_pull_spoolss_EnumPrinterKey, (ejs_push_function_t)ejs_push_spoolss_EnumPrinterKey);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterDataEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "key_name", &r->in.key_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "value_name", &r->in.value_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterDataEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterDataEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterDataEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERDATAEX, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterDataEx, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterDataEx);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterKey(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterKey(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERKEY, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterKey, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterKey);
}


static NTSTATUS ejs_pull_spoolss_53(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_53 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_53(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_53 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_53(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_53, (ejs_pull_function_t)ejs_pull_spoolss_53, (ejs_push_function_t)ejs_push_spoolss_53);
}


static NTSTATUS ejs_pull_spoolss_DeletePrinterDriverEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_DeletePrinterDriverEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_DeletePrinterDriverEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_DeletePrinterDriverEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_DeletePrinterDriverEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_DELETEPRINTERDRIVEREX, (ejs_pull_function_t)ejs_pull_spoolss_DeletePrinterDriverEx, (ejs_push_function_t)ejs_push_spoolss_DeletePrinterDriverEx);
}


static NTSTATUS ejs_pull_spoolss_55(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_55 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_55(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_55 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_55(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_55, (ejs_pull_function_t)ejs_pull_spoolss_55, (ejs_push_function_t)ejs_push_spoolss_55);
}


static NTSTATUS ejs_pull_spoolss_56(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_56 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_56(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_56 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_56(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_56, (ejs_pull_function_t)ejs_pull_spoolss_56, (ejs_push_function_t)ejs_push_spoolss_56);
}


static NTSTATUS ejs_pull_spoolss_57(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_57 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_57(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_57 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_57(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_57, (ejs_pull_function_t)ejs_pull_spoolss_57, (ejs_push_function_t)ejs_push_spoolss_57);
}


static NTSTATUS ejs_pull_spoolss_XcvData(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_XcvData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "function_name", &r->in.function_name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "in_data", &r->in.in_data));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offered", &r->in.offered));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_XcvData(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_XcvData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "out_data", &r->out.out_data));
	NDR_CHECK(ejs_push_uint32(ejs, v, "needed", &r->out.needed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->out.unknown2));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_XcvData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_XCVDATA, (ejs_pull_function_t)ejs_pull_spoolss_XcvData, (ejs_push_function_t)ejs_push_spoolss_XcvData);
}


static NTSTATUS ejs_pull_spoolss_AddPrinterDriverEx(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_AddPrinterDriverEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_AddPrinterDriverEx(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_AddPrinterDriverEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_AddPrinterDriverEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_ADDPRINTERDRIVEREX, (ejs_pull_function_t)ejs_pull_spoolss_AddPrinterDriverEx, (ejs_push_function_t)ejs_push_spoolss_AddPrinterDriverEx);
}


static NTSTATUS ejs_pull_spoolss_5a(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5a *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5a(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5a *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5a(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5A, (ejs_pull_function_t)ejs_pull_spoolss_5a, (ejs_push_function_t)ejs_push_spoolss_5a);
}


static NTSTATUS ejs_pull_spoolss_5b(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5b *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5b(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5b *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5b(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5B, (ejs_pull_function_t)ejs_pull_spoolss_5b, (ejs_push_function_t)ejs_push_spoolss_5b);
}


static NTSTATUS ejs_pull_spoolss_5c(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5c *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5c(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5c *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5c(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5C, (ejs_pull_function_t)ejs_pull_spoolss_5c, (ejs_push_function_t)ejs_push_spoolss_5c);
}


static NTSTATUS ejs_pull_spoolss_5d(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5d *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5d(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5d *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5d(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5D, (ejs_pull_function_t)ejs_pull_spoolss_5d, (ejs_push_function_t)ejs_push_spoolss_5d);
}


static NTSTATUS ejs_pull_spoolss_5e(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5e *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5e(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5e *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5e(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5E, (ejs_pull_function_t)ejs_pull_spoolss_5e, (ejs_push_function_t)ejs_push_spoolss_5e);
}


static NTSTATUS ejs_pull_spoolss_5f(struct ejs_rpc *ejs, struct MprVar *v, struct spoolss_5f *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_spoolss_5f(struct ejs_rpc *ejs, struct MprVar *v, const struct spoolss_5f *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_spoolss_5f(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_spoolss, DCERPC_SPOOLSS_5F, (ejs_pull_function_t)ejs_pull_spoolss_5f, (ejs_push_function_t)ejs_push_spoolss_5f);
}

static int ejs_spoolss_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "spoolss", argc, argv);
	mprSetCFunction(obj, "spoolss_EnumPrinters", ejs_spoolss_EnumPrinters);
	mprSetCFunction(obj, "spoolss_OpenPrinter", ejs_spoolss_OpenPrinter);
	mprSetCFunction(obj, "spoolss_SetJob", ejs_spoolss_SetJob);
	mprSetCFunction(obj, "spoolss_GetJob", ejs_spoolss_GetJob);
	mprSetCFunction(obj, "spoolss_EnumJobs", ejs_spoolss_EnumJobs);
	mprSetCFunction(obj, "spoolss_AddPrinter", ejs_spoolss_AddPrinter);
	mprSetCFunction(obj, "spoolss_DeletePrinter", ejs_spoolss_DeletePrinter);
	mprSetCFunction(obj, "spoolss_SetPrinter", ejs_spoolss_SetPrinter);
	mprSetCFunction(obj, "spoolss_GetPrinter", ejs_spoolss_GetPrinter);
	mprSetCFunction(obj, "spoolss_AddPrinterDriver", ejs_spoolss_AddPrinterDriver);
	mprSetCFunction(obj, "spoolss_EnumPrinterDrivers", ejs_spoolss_EnumPrinterDrivers);
	mprSetCFunction(obj, "spoolss_GetPrinterDriver", ejs_spoolss_GetPrinterDriver);
	mprSetCFunction(obj, "spoolss_GetPrinterDriverDirectory", ejs_spoolss_GetPrinterDriverDirectory);
	mprSetCFunction(obj, "spoolss_DeletePrinterDriver", ejs_spoolss_DeletePrinterDriver);
	mprSetCFunction(obj, "spoolss_AddPrintProcessor", ejs_spoolss_AddPrintProcessor);
	mprSetCFunction(obj, "spoolss_EnumPrintProcessors", ejs_spoolss_EnumPrintProcessors);
	mprSetCFunction(obj, "spoolss_GetPrintProcessorDirectory", ejs_spoolss_GetPrintProcessorDirectory);
	mprSetCFunction(obj, "spoolss_StartDocPrinter", ejs_spoolss_StartDocPrinter);
	mprSetCFunction(obj, "spoolss_StartPagePrinter", ejs_spoolss_StartPagePrinter);
	mprSetCFunction(obj, "spoolss_WritePrinter", ejs_spoolss_WritePrinter);
	mprSetCFunction(obj, "spoolss_EndPagePrinter", ejs_spoolss_EndPagePrinter);
	mprSetCFunction(obj, "spoolss_AbortPrinter", ejs_spoolss_AbortPrinter);
	mprSetCFunction(obj, "spoolss_ReadPrinter", ejs_spoolss_ReadPrinter);
	mprSetCFunction(obj, "spoolss_EndDocPrinter", ejs_spoolss_EndDocPrinter);
	mprSetCFunction(obj, "spoolss_AddJob", ejs_spoolss_AddJob);
	mprSetCFunction(obj, "spoolss_ScheduleJob", ejs_spoolss_ScheduleJob);
	mprSetCFunction(obj, "spoolss_GetPrinterData", ejs_spoolss_GetPrinterData);
	mprSetCFunction(obj, "spoolss_SetPrinterData", ejs_spoolss_SetPrinterData);
	mprSetCFunction(obj, "spoolss_WaitForPrinterChange", ejs_spoolss_WaitForPrinterChange);
	mprSetCFunction(obj, "spoolss_ClosePrinter", ejs_spoolss_ClosePrinter);
	mprSetCFunction(obj, "spoolss_AddForm", ejs_spoolss_AddForm);
	mprSetCFunction(obj, "spoolss_DeleteForm", ejs_spoolss_DeleteForm);
	mprSetCFunction(obj, "spoolss_GetForm", ejs_spoolss_GetForm);
	mprSetCFunction(obj, "spoolss_SetForm", ejs_spoolss_SetForm);
	mprSetCFunction(obj, "spoolss_EnumForms", ejs_spoolss_EnumForms);
	mprSetCFunction(obj, "spoolss_EnumPorts", ejs_spoolss_EnumPorts);
	mprSetCFunction(obj, "spoolss_EnumMonitors", ejs_spoolss_EnumMonitors);
	mprSetCFunction(obj, "spoolss_AddPort", ejs_spoolss_AddPort);
	mprSetCFunction(obj, "spoolss_ConfigurePort", ejs_spoolss_ConfigurePort);
	mprSetCFunction(obj, "spoolss_DeletePort", ejs_spoolss_DeletePort);
	mprSetCFunction(obj, "spoolss_CreatePrinterIC", ejs_spoolss_CreatePrinterIC);
	mprSetCFunction(obj, "spoolss_PlayGDIScriptOnPrinterIC", ejs_spoolss_PlayGDIScriptOnPrinterIC);
	mprSetCFunction(obj, "spoolss_DeletePrinterIC", ejs_spoolss_DeletePrinterIC);
	mprSetCFunction(obj, "spoolss_AddPrinterConnection", ejs_spoolss_AddPrinterConnection);
	mprSetCFunction(obj, "spoolss_DeletePrinterConnection", ejs_spoolss_DeletePrinterConnection);
	mprSetCFunction(obj, "spoolss_PrinterMessageBox", ejs_spoolss_PrinterMessageBox);
	mprSetCFunction(obj, "spoolss_AddMonitor", ejs_spoolss_AddMonitor);
	mprSetCFunction(obj, "spoolss_DeleteMonitor", ejs_spoolss_DeleteMonitor);
	mprSetCFunction(obj, "spoolss_DeletePrintProcessor", ejs_spoolss_DeletePrintProcessor);
	mprSetCFunction(obj, "spoolss_AddPrintProvidor", ejs_spoolss_AddPrintProvidor);
	mprSetCFunction(obj, "spoolss_DeletePrintProvidor", ejs_spoolss_DeletePrintProvidor);
	mprSetCFunction(obj, "spoolss_EnumPrintProcDataTypes", ejs_spoolss_EnumPrintProcDataTypes);
	mprSetCFunction(obj, "spoolss_ResetPrinter", ejs_spoolss_ResetPrinter);
	mprSetCFunction(obj, "spoolss_GetPrinterDriver2", ejs_spoolss_GetPrinterDriver2);
	mprSetCFunction(obj, "spoolss_FindFirstPrinterChangeNotification", ejs_spoolss_FindFirstPrinterChangeNotification);
	mprSetCFunction(obj, "spoolss_FindNextPrinterChangeNotification", ejs_spoolss_FindNextPrinterChangeNotification);
	mprSetCFunction(obj, "spoolss_FindClosePrinterNotify", ejs_spoolss_FindClosePrinterNotify);
	mprSetCFunction(obj, "spoolss_RouterFindFirstPrinterChangeNotificationOld", ejs_spoolss_RouterFindFirstPrinterChangeNotificationOld);
	mprSetCFunction(obj, "spoolss_ReplyOpenPrinter", ejs_spoolss_ReplyOpenPrinter);
	mprSetCFunction(obj, "spoolss_RouterReplyPrinter", ejs_spoolss_RouterReplyPrinter);
	mprSetCFunction(obj, "spoolss_ReplyClosePrinter", ejs_spoolss_ReplyClosePrinter);
	mprSetCFunction(obj, "spoolss_AddPortEx", ejs_spoolss_AddPortEx);
	mprSetCFunction(obj, "spoolss_RouterFindFirstPrinterChangeNotification", ejs_spoolss_RouterFindFirstPrinterChangeNotification);
	mprSetCFunction(obj, "spoolss_SpoolerInit", ejs_spoolss_SpoolerInit);
	mprSetCFunction(obj, "spoolss_ResetPrinterEx", ejs_spoolss_ResetPrinterEx);
	mprSetCFunction(obj, "spoolss_RemoteFindFirstPrinterChangeNotifyEx", ejs_spoolss_RemoteFindFirstPrinterChangeNotifyEx);
	mprSetCFunction(obj, "spoolss_RouterRefreshPrinterChangeNotification", ejs_spoolss_RouterRefreshPrinterChangeNotification);
	mprSetCFunction(obj, "spoolss_RemoteFindNextPrinterChangeNotifyEx", ejs_spoolss_RemoteFindNextPrinterChangeNotifyEx);
	mprSetCFunction(obj, "spoolss_44", ejs_spoolss_44);
	mprSetCFunction(obj, "spoolss_OpenPrinterEx", ejs_spoolss_OpenPrinterEx);
	mprSetCFunction(obj, "spoolss_AddPrinterEx", ejs_spoolss_AddPrinterEx);
	mprSetCFunction(obj, "spoolss_47", ejs_spoolss_47);
	mprSetCFunction(obj, "spoolss_EnumPrinterData", ejs_spoolss_EnumPrinterData);
	mprSetCFunction(obj, "spoolss_DeletePrinterData", ejs_spoolss_DeletePrinterData);
	mprSetCFunction(obj, "spoolss_4a", ejs_spoolss_4a);
	mprSetCFunction(obj, "spoolss_4b", ejs_spoolss_4b);
	mprSetCFunction(obj, "spoolss_4c", ejs_spoolss_4c);
	mprSetCFunction(obj, "spoolss_SetPrinterDataEx", ejs_spoolss_SetPrinterDataEx);
	mprSetCFunction(obj, "spoolss_GetPrinterDataEx", ejs_spoolss_GetPrinterDataEx);
	mprSetCFunction(obj, "spoolss_EnumPrinterDataEx", ejs_spoolss_EnumPrinterDataEx);
	mprSetCFunction(obj, "spoolss_EnumPrinterKey", ejs_spoolss_EnumPrinterKey);
	mprSetCFunction(obj, "spoolss_DeletePrinterDataEx", ejs_spoolss_DeletePrinterDataEx);
	mprSetCFunction(obj, "spoolss_DeletePrinterKey", ejs_spoolss_DeletePrinterKey);
	mprSetCFunction(obj, "spoolss_53", ejs_spoolss_53);
	mprSetCFunction(obj, "spoolss_DeletePrinterDriverEx", ejs_spoolss_DeletePrinterDriverEx);
	mprSetCFunction(obj, "spoolss_55", ejs_spoolss_55);
	mprSetCFunction(obj, "spoolss_56", ejs_spoolss_56);
	mprSetCFunction(obj, "spoolss_57", ejs_spoolss_57);
	mprSetCFunction(obj, "spoolss_XcvData", ejs_spoolss_XcvData);
	mprSetCFunction(obj, "spoolss_AddPrinterDriverEx", ejs_spoolss_AddPrinterDriverEx);
	mprSetCFunction(obj, "spoolss_5a", ejs_spoolss_5a);
	mprSetCFunction(obj, "spoolss_5b", ejs_spoolss_5b);
	mprSetCFunction(obj, "spoolss_5c", ejs_spoolss_5c);
	mprSetCFunction(obj, "spoolss_5d", ejs_spoolss_5d);
	mprSetCFunction(obj, "spoolss_5e", ejs_spoolss_5e);
	mprSetCFunction(obj, "spoolss_5f", ejs_spoolss_5f);
	mprSetVar(obj, "PRINTER_STATUS_INITIALIZING", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_CONTROL_UNPAUSE", mprCreateNumberVar(0));
	mprSetVar(obj, "PRINTER_STATUS_NOT_AVAILABLE", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY", mprCreateNumberVar(7));
	mprSetVar(obj, "PRINTER_STATUS_IO_ACTIVE", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "PRINTER_ENUM_DEFAULT", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "PRINTER_ENUM_CONTAINER", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "SPOOLSS_DRIVER_VERSION_NT35", mprCreateNumberVar(1));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_ENABLE_DEVQ", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON7", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "SPOOLSS_ARCHITECTURE_NT_X86", mprString("Windows NT x86"));
	mprSetVar(obj, "PRINTER_STATUS_POWER_SAVE", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "SPOOLSS_PORT_TYPE_WRITE", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "PRINTER_ENUM_FAVORITE", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_TS", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_LAST_PAGE_EJECTED", mprCreateNumberVar(7));
	mprSetVar(obj, "PRINTER_STATUS_TONER_LOW", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON1", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_CONTROL_PAUSE", mprCreateNumberVar(1));
	mprSetVar(obj, "PRINTER_ENUM_ICON2", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "SPOOLSS_FORM_PRINTER", mprCreateNumberVar(2));
	mprSetVar(obj, "PRINTER_ENUM_ICON5", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "SPOOLSS_DRIVER_VERSION_NT4", mprCreateNumberVar(2));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_QUEUED", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "PRINTER_STATUS_PAGE_PUNT", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_FAX", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "DSPRINT_UNPUBLISH", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "PRINTER_STATUS_WARMING_UP", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "SPOOLSS_FORM_BUILTIN", mprCreateNumberVar(1));
	mprSetVar(obj, "DSPRINT_PENDING", mprCreateNumberVar(( 0x80000000 )));
	mprSetVar(obj, "PRINTER_ENUM_CONNECTIONS", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SPOOLSS_PORT_TYPE_NET_ATTACHED", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_DATA_TYPE_UINT32", mprCreateNumberVar(4));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_SEND_TO_PRINTER", mprCreateNumberVar(6));
	mprSetVar(obj, "SPOOLSS_PRINTER_DATA_TYPE_BINARY", mprCreateNumberVar(3));
	mprSetVar(obj, "PRINTER_ENUM_SHARED", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "PRINTER_STATUS_SERVER_UNKNOWN", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_DEFAULT", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_LOCAL", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_DELETE", mprCreateNumberVar(5));
	mprSetVar(obj, "PRINTER_STATUS_MANUAL_FEED", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "PRINTER_STATUS_NO_TONER", mprCreateNumberVar(( 0x00040000 )));
	mprSetVar(obj, "PRINTER_STATUS_OFFLINE", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "DSPRINT_REPUBLISH", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "PRINTER_STATUS_WAITING", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "PRINTER_ENUM_REMOTE", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "PRINTER_STATUS_BUSY", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_CONTROL_PURGE", mprCreateNumberVar(3));
	mprSetVar(obj, "PRINTER_STATUS_PAPER_JAM", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_PAUSE", mprCreateNumberVar(1));
	mprSetVar(obj, "PRINTER_STATUS_ERROR", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_DATA_TYPE_STRING", mprCreateNumberVar(1));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON8", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON6", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "PRINTER_STATUS_PENDING_DELETION", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "PRINTER_STATUS_PROCESSING", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "PRINTER_STATUS_PAUSED", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON3", mprCreateNumberVar(( 0x00040000 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_NETWORK", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "PRINTER_STATUS_PAPER_OUT", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "PRINTER_ENUM_ICON4", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "PRINTER_ENUM_NAME", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "PRINTER_STATUS_PAPER_PROBLEM", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "PRINTER_ENUM_LOCAL", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "PRINTER_STATUS_OUT_OF_MEMORY", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_ENABLE_BIDI", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_WORK_OFFLINE", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "PRINTER_ENUM_EXPAND", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "SPOOLSS_PORT_TYPE_REDIRECTED", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "PRINTER_ENUM_HIDE", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_DATA_TYPE_NULL", mprCreateNumberVar(0));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_HIDDEN", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "PRINTER_STATUS_OUTPUT_BIN_FULL", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "SPOOLSS_FORM_USER", mprCreateNumberVar(0));
	mprSetVar(obj, "PRINTER_STATUS_DOOR_OPEN", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_CANCEL", mprCreateNumberVar(3));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_SHARED", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SPOOLSS_PRINTER_CONTROL_SET_STATUS", mprCreateNumberVar(4));
	mprSetVar(obj, "SPOOLSS_PRINTER_CONTROL_RESUME", mprCreateNumberVar(2));
	mprSetVar(obj, "PRINTER_STATUS_PRINTING", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "SPOOLSS_DRIVER_VERSION_200X", mprCreateNumberVar(3));
	mprSetVar(obj, "SPOOLSS_DRIVER_VERSION_9X", mprCreateNumberVar(0));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_RESTART", mprCreateNumberVar(4));
	mprSetVar(obj, "SPOOLSS_JOB_CONTROL_RESUME", mprCreateNumberVar(2));
	mprSetVar(obj, "PRINTER_ENUM_NETWORK", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "DSPRINT_UPDATE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "PRINTER_STATUS_USER_INTERVENTION", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_DIRECT", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_RAW_ONLY", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "DSPRINT_PUBLISH", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "PRINTER_ATTRIBUTE_PUBLISHED", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "SPOOLSS_PORT_TYPE_READ", mprCreateNumberVar(( 0x00000002 )));
	return ejs_rpc_init(obj, "spoolss");
}

NTSTATUS ejs_init_spoolss(void)
{
	ejsDefineCFunction(-1, "spoolss_init", ejs_spoolss_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
