
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_rot.h"
#include "librpc/gen_ndr/ndr_rot_ejs.h"



static NTSTATUS ejs_pull_rot_add(struct ejs_rpc *ejs, struct MprVar *v, struct rot_add *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	if (ejs_pull_null(ejs, v, "unk")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.unk);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "unk", r->in.unk));
	}
	if (ejs_pull_null(ejs, v, "moniker")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.moniker);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "moniker", r->in.moniker));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_add(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_add *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.rotid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rotid", r->out.rotid));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_add(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_ADD, (ejs_pull_function_t)ejs_pull_rot_add, (ejs_push_function_t)ejs_push_rot_add);
}


static NTSTATUS ejs_pull_rot_remove(struct ejs_rpc *ejs, struct MprVar *v, struct rot_remove *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rotid", &r->in.rotid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_remove(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_remove *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_remove(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_REMOVE, (ejs_pull_function_t)ejs_pull_rot_remove, (ejs_push_function_t)ejs_push_rot_remove);
}


static NTSTATUS ejs_pull_rot_is_listed(struct ejs_rpc *ejs, struct MprVar *v, struct rot_is_listed *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "moniker")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.moniker);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "moniker", r->in.moniker));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_is_listed(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_is_listed *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_is_listed(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_IS_LISTED, (ejs_pull_function_t)ejs_pull_rot_is_listed, (ejs_push_function_t)ejs_push_rot_is_listed);
}


static NTSTATUS ejs_pull_rot_get_interface_pointer(struct ejs_rpc *ejs, struct MprVar *v, struct rot_get_interface_pointer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "moniker")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.moniker);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "moniker", r->in.moniker));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_get_interface_pointer(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_get_interface_pointer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ip) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "ip", r->out.ip));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_get_interface_pointer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_GET_INTERFACE_POINTER, (ejs_pull_function_t)ejs_pull_rot_get_interface_pointer, (ejs_push_function_t)ejs_push_rot_get_interface_pointer);
}


static NTSTATUS ejs_pull_rot_set_modification_time(struct ejs_rpc *ejs, struct MprVar *v, struct rot_set_modification_time *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rotid", &r->in.rotid));
	if (ejs_pull_null(ejs, v, "t")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.t);
		NDR_CHECK(ejs_pull_NTTIME(ejs, v, "t", r->in.t));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_set_modification_time(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_set_modification_time *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_set_modification_time(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_SET_MODIFICATION_TIME, (ejs_pull_function_t)ejs_pull_rot_set_modification_time, (ejs_push_function_t)ejs_push_rot_set_modification_time);
}


static NTSTATUS ejs_pull_rot_get_modification_time(struct ejs_rpc *ejs, struct MprVar *v, struct rot_get_modification_time *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "moniker")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.moniker);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "moniker", r->in.moniker));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_get_modification_time(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_get_modification_time *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.t) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_NTTIME(ejs, v, "t", r->out.t));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_get_modification_time(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_GET_MODIFICATION_TIME, (ejs_pull_function_t)ejs_pull_rot_get_modification_time, (ejs_push_function_t)ejs_push_rot_get_modification_time);
}


static NTSTATUS ejs_pull_rot_enum(struct ejs_rpc *ejs, struct MprVar *v, struct rot_enum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_rot_enum(struct ejs_rpc *ejs, struct MprVar *v, const struct rot_enum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.EnumMoniker) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, "EnumMoniker", r->out.EnumMoniker));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_rot_enum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rot, DCERPC_ROT_ENUM, (ejs_pull_function_t)ejs_pull_rot_enum, (ejs_push_function_t)ejs_push_rot_enum);
}

static int ejs_rot_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "rot", argc, argv);
	mprSetCFunction(obj, "rot_add", ejs_rot_add);
	mprSetCFunction(obj, "rot_remove", ejs_rot_remove);
	mprSetCFunction(obj, "rot_is_listed", ejs_rot_is_listed);
	mprSetCFunction(obj, "rot_get_interface_pointer", ejs_rot_get_interface_pointer);
	mprSetCFunction(obj, "rot_set_modification_time", ejs_rot_set_modification_time);
	mprSetCFunction(obj, "rot_get_modification_time", ejs_rot_get_modification_time);
	mprSetCFunction(obj, "rot_enum", ejs_rot_enum);
	return ejs_rpc_init(obj, "rot");
}

NTSTATUS ejs_init_rot(void)
{
	ejsDefineCFunction(-1, "rot_init", ejs_rot_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
