
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_oxidresolver.h"
#include "librpc/gen_ndr/ndr_oxidresolver_ejs.h"


static NTSTATUS ejs_push_COMINFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct COMINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_COMVERSION(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_ResolveOxid(struct ejs_rpc *ejs, struct MprVar *v, struct ResolveOxid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "pOxid", &r->in.pOxid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cRequestedProtseqs", &r->in.cRequestedProtseqs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.arRequestedProtseqs, r->in.cRequestedProtseqs);
		for (i=0;i<r->in.cRequestedProtseqs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "arRequestedProtseqs", i);
			NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->in.arRequestedProtseqs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "arRequestedProtseqs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ResolveOxid(struct ejs_rpc *ejs, struct MprVar *v, const struct ResolveOxid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.ppdsaOxidBindings) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.ppdsaOxidBindings) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_DUALSTRINGARRAY(ejs, v, "ppdsaOxidBindings", *r->out.ppdsaOxidBindings));
		}
	}
	if (NULL == r->out.pipidRemUnknown) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_GUID(ejs, v, "pipidRemUnknown", r->out.pipidRemUnknown));
	}
	if (NULL == r->out.pAuthnHint) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "pAuthnHint", r->out.pAuthnHint));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ResolveOxid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_RESOLVEOXID, (ejs_pull_function_t)ejs_pull_ResolveOxid, (ejs_push_function_t)ejs_push_ResolveOxid);
}


static NTSTATUS ejs_pull_SimplePing(struct ejs_rpc *ejs, struct MprVar *v, struct SimplePing *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "SetId")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.SetId);
		NDR_CHECK(ejs_pull_hyper(ejs, v, "SetId", r->in.SetId));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_SimplePing(struct ejs_rpc *ejs, struct MprVar *v, const struct SimplePing *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_SimplePing(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_SIMPLEPING, (ejs_pull_function_t)ejs_pull_SimplePing, (ejs_push_function_t)ejs_push_SimplePing);
}


static NTSTATUS ejs_pull_ComplexPing(struct ejs_rpc *ejs, struct MprVar *v, struct ComplexPing *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "SetId")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.SetId);
		NDR_CHECK(ejs_pull_hyper(ejs, v, "SetId", r->in.SetId));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "SequenceNum", &r->in.SequenceNum));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cAddToSet", &r->in.cAddToSet));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cDelFromSet", &r->in.cDelFromSet));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.AddToSet, r->in.cAddToSet);
		for (i=0;i<r->in.cAddToSet;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "AddToSet", i);
			NDR_CHECK(ejs_pull_GUID(ejs, v, id, &r->in.AddToSet[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "AddToSet" ".length", &i);
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.DelFromSet, r->in.cDelFromSet);
		for (i=0;i<r->in.cDelFromSet;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "DelFromSet", i);
			NDR_CHECK(ejs_pull_GUID(ejs, v, id, &r->in.DelFromSet[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "DelFromSet" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ComplexPing(struct ejs_rpc *ejs, struct MprVar *v, const struct ComplexPing *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.SetId) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_hyper(ejs, v, "SetId", r->out.SetId));
	}
	if (NULL == r->out.PingBackoffFactor) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint16(ejs, v, "PingBackoffFactor", r->out.PingBackoffFactor));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ComplexPing(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_COMPLEXPING, (ejs_pull_function_t)ejs_pull_ComplexPing, (ejs_push_function_t)ejs_push_ComplexPing);
}


static NTSTATUS ejs_pull_ServerAlive(struct ejs_rpc *ejs, struct MprVar *v, struct ServerAlive *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ServerAlive(struct ejs_rpc *ejs, struct MprVar *v, const struct ServerAlive *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ServerAlive(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_SERVERALIVE, (ejs_pull_function_t)ejs_pull_ServerAlive, (ejs_push_function_t)ejs_push_ServerAlive);
}


static NTSTATUS ejs_pull_ResolveOxid2(struct ejs_rpc *ejs, struct MprVar *v, struct ResolveOxid2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "pOxid", &r->in.pOxid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "cRequestedProtseqs", &r->in.cRequestedProtseqs));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.arRequestedProtseqs, r->in.cRequestedProtseqs);
		for (i=0;i<r->in.cRequestedProtseqs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "arRequestedProtseqs", i);
			NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->in.arRequestedProtseqs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "arRequestedProtseqs" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ResolveOxid2(struct ejs_rpc *ejs, struct MprVar *v, const struct ResolveOxid2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.pdsaOxidBindings) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.pdsaOxidBindings) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_DUALSTRINGARRAY(ejs, v, "pdsaOxidBindings", *r->out.pdsaOxidBindings));
		}
	}
	if (NULL == r->out.ipidRemUnknown) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_GUID(ejs, v, "ipidRemUnknown", r->out.ipidRemUnknown));
	}
	if (NULL == r->out.AuthnHint) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "AuthnHint", r->out.AuthnHint));
	}
	if (NULL == r->out.ComVersion) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_COMVERSION(ejs, v, "ComVersion", r->out.ComVersion));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ResolveOxid2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_RESOLVEOXID2, (ejs_pull_function_t)ejs_pull_ResolveOxid2, (ejs_push_function_t)ejs_push_ResolveOxid2);
}


static NTSTATUS ejs_pull_ServerAlive2(struct ejs_rpc *ejs, struct MprVar *v, struct ServerAlive2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_ServerAlive2(struct ejs_rpc *ejs, struct MprVar *v, const struct ServerAlive2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_COMINFO(ejs, v, "info", r->out.info));
	}
	if (NULL == r->out.dualstring) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_DUALSTRINGARRAY(ejs, v, "dualstring", r->out.dualstring));
	}
	ejs_push_array_uint8(ejs, v, "unknown2", r->out.unknown2, 3);
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_ServerAlive2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IOXIDResolver, DCERPC_SERVERALIVE2, (ejs_pull_function_t)ejs_pull_ServerAlive2, (ejs_push_function_t)ejs_push_ServerAlive2);
}

static int ejs_IOXIDResolver_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IOXIDResolver", argc, argv);
	mprSetCFunction(obj, "ResolveOxid", ejs_ResolveOxid);
	mprSetCFunction(obj, "SimplePing", ejs_SimplePing);
	mprSetCFunction(obj, "ComplexPing", ejs_ComplexPing);
	mprSetCFunction(obj, "ServerAlive", ejs_ServerAlive);
	mprSetCFunction(obj, "ResolveOxid2", ejs_ResolveOxid2);
	mprSetCFunction(obj, "ServerAlive2", ejs_ServerAlive2);
	return ejs_rpc_init(obj, "IOXIDResolver");
}

NTSTATUS ejs_init_IOXIDResolver(void)
{
	ejsDefineCFunction(-1, "IOXIDResolver_init", ejs_IOXIDResolver_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
