
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_opendb.h"
#include "librpc/gen_ndr/ndr_opendb_ejs.h"


static NTSTATUS ejs_push_opendb_entry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct opendb_entry *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_push_uint32(ejs, v, "stream_id", &r->stream_id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "share_access", &r->share_access));
	NDR_CHECK(ejs_push_uint32(ejs, v, "access_mask", &r->access_mask));
	NDR_CHECK(ejs_push_pointer(ejs, v, "file_handle", &r->file_handle));
	NDR_CHECK(ejs_push_uint8(ejs, v, "delete_on_close", &r->delete_on_close));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplock_level", &r->oplock_level));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_opendb_entry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct opendb_entry *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "stream_id", &r->stream_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "share_access", &r->share_access));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->access_mask));
	NDR_CHECK(ejs_pull_pointer(ejs, v, "file_handle", &r->file_handle));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "delete_on_close", &r->delete_on_close));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplock_level", &r->oplock_level));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_opendb_pending(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct opendb_pending *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_push_pointer(ejs, v, "notify_ptr", &r->notify_ptr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_opendb_pending(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct opendb_pending *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_pull_pointer(ejs, v, "notify_ptr", &r->notify_ptr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_opendb_file(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct opendb_file *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "delete_on_close", &r->delete_on_close));
	NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->num_entries));
	{
		uint32_t i;
		for (i=0;i<r->num_entries;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_push_opendb_entry(ejs, v, id, &r->entries[i]));
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_pending", &r->num_pending));
	{
		uint32_t i;
		for (i=0;i<r->num_pending;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "pending", i);
			NDR_CHECK(ejs_push_opendb_pending(ejs, v, id, &r->pending[i]));
		}
		ejs_push_uint32(ejs, v, "pending" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_opendb_file(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct opendb_file *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "delete_on_close", &r->delete_on_close));
	NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_entries", &r->num_entries));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->entries, r->num_entries);
		for (i=0;i<r->num_entries;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_pull_opendb_entry(ejs, v, id, &r->entries[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_pending", &r->num_pending));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->pending, r->num_pending);
		for (i=0;i<r->num_pending;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "pending", i);
			NDR_CHECK(ejs_pull_opendb_pending(ejs, v, id, &r->pending[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "pending" ".length", &i);
	}
	return NT_STATUS_OK;
}

static int ejs_opendb_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "opendb", argc, argv);
	return ejs_rpc_init(obj, "opendb");
}

NTSTATUS ejs_init_opendb(void)
{
	ejsDefineCFunction(-1, "opendb_init", ejs_opendb_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
